/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2015-08-26 08:11:35 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `eadsk_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_failed_logins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_attempt_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_login_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `logout_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `release_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `eadsk_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2628 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=649 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: eadsk_aiowps_failed_logins */
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1", "0", "magma", "2015-08-21 17:19:16", "201.22.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2", "0", "magma", "2015-08-21 17:55:24", "2.51.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3", "0", "magma", "2015-08-21 18:52:25", "39.44.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4", "0", "magma", "2015-08-21 19:16:14", "94.121.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5", "0", "magma", "2015-08-21 19:38:04", "201.248.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6", "0", "magma", "2015-08-22 00:05:46", "85.74.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7", "0", "magma", "2015-08-22 01:28:54", "37.0.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8", "0", "magma", "2015-08-22 01:47:23", "175.113.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9", "0", "magma", "2015-08-22 03:13:05", "112.203.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10", "0", "magma", "2015-08-22 06:04:07", "86.125.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("11", "0", "magma", "2015-08-22 07:55:37", "37.114.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("12", "0", "magma", "2015-08-22 09:02:46", "121.54.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("13", "0", "magma", "2015-08-22 09:43:11", "104.200.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("14", "0", "magma", "2015-08-22 10:28:36", "109.224.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("15", "0", "magma", "2015-08-22 10:50:39", "104.200.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("16", "0", "magma", "2015-08-22 12:08:23", "82.78.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("17", "0", "magma", "2015-08-22 13:31:13", "39.42.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("18", "0", "magma", "2015-08-22 13:35:00", "39.44.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("19", "0", "magma", "2015-08-22 14:23:21", "139.195.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("20", "0", "magma", "2015-08-22 15:20:07", "185.76.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("21", "0", "magma", "2015-08-22 16:37:14", "103.249.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("22", "0", "magma", "2015-08-22 17:24:11", "41.133.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("23", "0", "magma", "2015-08-22 18:41:19", "87.68.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("24", "0", "magma", "2015-08-22 19:28:01", "109.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("25", "0", "magma", "2015-08-22 19:33:33", "79.180.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("26", "0", "magma", "2015-08-22 19:46:16", "190.167.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("27", "0", "magma", "2015-08-22 22:12:01", "95.187.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("28", "0", "magma", "2015-08-23 00:17:03", "87.68.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("29", "0", "magma", "2015-08-23 02:41:05", "109.245.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("30", "0", "magma", "2015-08-23 03:46:03", "183.91.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("31", "0", "magma", "2015-08-23 03:51:16", "87.16.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("32", "0", "magma", "2015-08-23 04:16:52", "178.221.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("33", "0", "magma", "2015-08-23 05:12:01", "109.245.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("34", "0", "magma", "2015-08-23 05:21:10", "1.1.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("35", "0", "magma", "2015-08-23 05:36:32", "179.105.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("36", "0", "magma", "2015-08-23 07:12:14", "188.26.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("37", "0", "magma", "2015-08-23 16:53:44", "94.176.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("38", "0", "magma", "2015-08-23 17:00:17", "110.139.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("39", "0", "magma", "2015-08-23 17:20:42", "103.224.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("40", "0", "magma", "2015-08-23 17:44:56", "186.123.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("41", "0", "magma", "2015-08-23 18:17:09", "178.221.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("42", "0", "magma", "2015-08-23 19:59:00", "88.245.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("43", "0", "magma", "2015-08-23 21:44:23", "93.87.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("44", "0", "magma", "2015-08-24 00:07:13", "177.229.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("45", "0", "magma", "2015-08-24 01:27:09", "186.137.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("46", "0", "magma", "2015-08-24 03:51:51", "5.12.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("47", "0", "magma", "2015-08-24 03:52:20", "95.245.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("48", "0", "magma", "2015-08-24 07:12:50", "14.141.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("49", "0", "magma", "2015-08-24 07:38:53", "113.20.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("50", "0", "magma", "2015-08-24 08:20:58", "87.68.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("51", "0", "magma", "2015-08-24 11:58:51", "87.10.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("52", "0", "magma", "2015-08-24 12:04:21", "151.247.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("53", "0", "magma", "2015-08-24 16:01:18", "182.185.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("54", "0", "magma", "2015-08-24 17:52:17", "64.237.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("55", "0", "magma", "2015-08-24 19:10:01", "210.195.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("56", "0", "magma", "2015-08-24 20:02:27", "79.101.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("57", "0", "magma", "2015-08-24 21:58:32", "130.204.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("58", "0", "magma", "2015-08-24 23:28:40", "46.40.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("59", "0", "magma", "2015-08-25 04:06:02", "179.24.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("60", "0", "magma", "2015-08-25 04:43:49", "69.47.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("61", "0", "magma", "2015-08-25 08:49:16", "86.125.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("62", "0", "magma", "2015-08-25 10:41:07", "121.54.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("63", "0", "magma", "2015-08-25 12:45:40", "115.66.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("64", "0", "magma", "2015-08-25 17:36:32", "39.50.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("65", "0", "magma", "2015-08-25 19:00:08", "92.97.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("66", "0", "magma", "2015-08-25 19:35:45", "41.133.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("67", "0", "magma", "2015-08-25 20:58:01", "182.178.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("68", "0", "magma", "2015-08-25 23:12:53", "93.86.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("69", "0", "magma", "2015-08-26 02:23:39", "181.120.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("70", "0", "magma", "2015-08-26 03:45:34", "189.26.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("71", "0", "magma", "2015-08-26 05:19:48", "200.158.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("72", "0", "magma", "2015-08-26 05:46:01", "37.27.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("73", "1", "admin8576", "2015-08-26 08:27:20", "138.122.84.*");

/* INSERT TABLE DATA: eadsk_aiowps_login_activity */
INSERT INTO `eadsk_aiowps_login_activity` VALUES("1", "1", "aDmin8576", "2015-08-03 06:03:55", "0000-00-00 00:00:00", "196.210.61.204", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("2", "1", "aDmin8576", "2015-08-03 08:57:47", "0000-00-00 00:00:00", "196.210.61.204", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("3", "1", "aDmin8576", "2015-08-11 14:57:06", "2015-08-11 15:04:15", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("4", "1", "aDmin8576", "2015-08-11 14:59:57", "2015-08-11 15:04:15", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("5", "1", "aDmin8576", "2015-08-11 15:16:59", "0000-00-00 00:00:00", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("6", "1", "aDmin8576", "2015-08-21 15:08:21", "2015-08-21 16:43:54", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("7", "1", "aDmin8576", "2015-08-21 16:42:19", "2015-08-21 16:43:54", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("8", "1", "aDmin8576", "2015-08-21 16:57:24", "0000-00-00 00:00:00", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("9", "1", "aDmin8576", "2015-08-25 15:33:53", "0000-00-00 00:00:00", "196.210.16.42", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("10", "1", "aDmin8576", "2015-08-26 10:11:05", "0000-00-00 00:00:00", "196.210.16.42", "", "");

/* INSERT TABLE DATA: eadsk_aiowps_login_lockdown */
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1", "0", "magma", "2015-08-21 17:19:16", "2015-08-21 18:19:16", "201.22.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2", "0", "magma", "2015-08-21 17:55:24", "2015-08-21 18:55:24", "2.51.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("3", "0", "magma", "2015-08-21 18:52:25", "2015-08-21 19:52:25", "39.44.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("4", "0", "magma", "2015-08-21 19:16:14", "2015-08-21 20:16:14", "94.121.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("5", "0", "magma", "2015-08-21 19:38:04", "2015-08-21 20:38:04", "201.248.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("6", "0", "magma", "2015-08-22 00:05:46", "2015-08-22 01:05:46", "85.74.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("7", "0", "magma", "2015-08-22 01:28:54", "2015-08-22 02:28:54", "37.0.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("8", "0", "magma", "2015-08-22 01:47:23", "2015-08-22 02:47:23", "175.113.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("9", "0", "magma", "2015-08-22 03:13:05", "2015-08-22 04:13:05", "112.203.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("10", "0", "magma", "2015-08-22 06:04:07", "2015-08-22 07:04:07", "86.125.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("11", "0", "magma", "2015-08-22 07:55:37", "2015-08-22 08:55:37", "37.114.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("12", "0", "magma", "2015-08-22 09:02:46", "2015-08-22 10:02:46", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("13", "0", "magma", "2015-08-22 09:43:11", "2015-08-22 10:43:11", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("14", "0", "magma", "2015-08-22 10:28:36", "2015-08-22 11:28:36", "109.224.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("15", "0", "magma", "2015-08-22 10:50:39", "2015-08-22 11:50:39", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("16", "0", "magma", "2015-08-22 12:08:23", "2015-08-22 13:08:23", "82.78.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("17", "0", "magma", "2015-08-22 13:31:13", "2015-08-22 14:31:13", "39.42.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("18", "0", "magma", "2015-08-22 13:35:00", "2015-08-22 14:35:00", "39.44.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("19", "0", "magma", "2015-08-22 14:23:21", "2015-08-22 15:23:21", "139.195.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("20", "0", "magma", "2015-08-22 15:20:07", "2015-08-22 16:20:07", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("21", "0", "magma", "2015-08-22 16:37:14", "2015-08-22 17:37:14", "103.249.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("22", "0", "magma", "2015-08-22 17:24:11", "2015-08-22 18:24:11", "41.133.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("23", "0", "magma", "2015-08-22 18:41:19", "2015-08-22 19:41:19", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("24", "0", "magma", "2015-08-22 19:28:01", "2015-08-22 20:28:01", "109.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("25", "0", "magma", "2015-08-22 19:33:33", "2015-08-22 20:33:33", "79.180.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("26", "0", "magma", "2015-08-22 19:46:16", "2015-08-22 20:46:16", "190.167.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("27", "0", "magma", "2015-08-22 22:12:01", "2015-08-22 23:12:01", "95.187.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("28", "0", "magma", "2015-08-23 00:17:03", "2015-08-23 01:17:03", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("29", "0", "magma", "2015-08-23 02:41:05", "2015-08-23 03:41:05", "109.245.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("30", "0", "magma", "2015-08-23 03:46:03", "2015-08-23 04:46:03", "183.91.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("31", "0", "magma", "2015-08-23 03:51:16", "2015-08-23 04:51:16", "87.16.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("32", "0", "magma", "2015-08-23 04:16:52", "2015-08-23 05:16:52", "178.221.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("33", "0", "magma", "2015-08-23 05:12:02", "2015-08-23 06:12:02", "109.245.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("34", "0", "magma", "2015-08-23 05:21:10", "2015-08-23 06:21:10", "1.1.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("35", "0", "magma", "2015-08-23 05:36:32", "2015-08-23 06:36:32", "179.105.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("36", "0", "magma", "2015-08-23 07:12:14", "2015-08-23 08:12:14", "188.26.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("37", "0", "magma", "2015-08-23 16:53:44", "2015-08-23 17:53:44", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("38", "0", "magma", "2015-08-23 17:00:17", "2015-08-23 18:00:17", "110.139.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("39", "0", "magma", "2015-08-23 17:20:42", "2015-08-23 18:20:42", "103.224.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("40", "0", "magma", "2015-08-23 17:44:56", "2015-08-23 18:44:56", "186.123.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("41", "0", "magma", "2015-08-23 18:17:09", "2015-08-23 19:17:09", "178.221.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("42", "0", "magma", "2015-08-23 19:59:00", "2015-08-23 20:59:00", "88.245.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("43", "0", "magma", "2015-08-23 21:44:23", "2015-08-23 22:44:23", "93.87.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("44", "0", "magma", "2015-08-24 00:07:13", "2015-08-24 01:07:13", "177.229.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("45", "0", "magma", "2015-08-24 01:27:09", "2015-08-24 02:27:09", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("46", "0", "magma", "2015-08-24 03:51:51", "2015-08-24 04:51:51", "5.12.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("47", "0", "magma", "2015-08-24 03:52:20", "2015-08-24 04:52:20", "95.245.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("48", "0", "magma", "2015-08-24 07:12:50", "2015-08-24 08:12:50", "14.141.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("49", "0", "magma", "2015-08-24 07:38:53", "2015-08-24 08:38:53", "113.20.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("50", "0", "magma", "2015-08-24 08:20:58", "2015-08-24 09:20:58", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("51", "0", "magma", "2015-08-24 11:58:51", "2015-08-24 12:58:51", "87.10.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("52", "0", "magma", "2015-08-24 12:04:21", "2015-08-24 13:04:21", "151.247.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("53", "0", "magma", "2015-08-24 16:01:18", "2015-08-24 17:01:18", "182.185.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("54", "0", "magma", "2015-08-24 17:52:17", "2015-08-24 18:52:17", "64.237.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("55", "0", "magma", "2015-08-24 19:10:01", "2015-08-24 20:10:01", "210.195.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("56", "0", "magma", "2015-08-24 20:02:27", "2015-08-24 21:02:27", "79.101.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("57", "0", "magma", "2015-08-24 21:58:32", "2015-08-24 22:58:32", "130.204.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("58", "0", "magma", "2015-08-24 23:28:40", "2015-08-25 00:28:40", "46.40.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("59", "0", "magma", "2015-08-25 04:06:02", "2015-08-25 05:06:02", "179.24.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("60", "0", "magma", "2015-08-25 04:43:49", "2015-08-25 05:43:49", "69.47.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("61", "0", "magma", "2015-08-25 08:49:17", "2015-08-25 09:49:17", "86.125.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("62", "0", "magma", "2015-08-25 10:41:07", "2015-08-25 11:41:07", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("63", "0", "magma", "2015-08-25 12:45:40", "2015-08-25 13:45:40", "115.66.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("64", "0", "magma", "2015-08-25 17:36:32", "2015-08-25 18:36:32", "39.50.206.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("65", "0", "magma", "2015-08-25 19:00:08", "2015-08-25 20:00:08", "92.97.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("66", "0", "magma", "2015-08-25 19:35:45", "2015-08-25 20:35:45", "41.133.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("67", "0", "magma", "2015-08-25 20:58:01", "2015-08-25 21:58:01", "182.178.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("68", "0", "magma", "2015-08-25 23:12:53", "2015-08-26 00:12:53", "93.86.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("69", "0", "magma", "2015-08-26 02:23:39", "2015-08-26 03:23:39", "181.120.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("70", "0", "magma", "2015-08-26 03:45:34", "2015-08-26 04:45:34", "189.26.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("71", "0", "magma", "2015-08-26 05:19:48", "2015-08-26 06:19:48", "200.158.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("72", "0", "magma", "2015-08-26 05:46:01", "2015-08-26 06:46:01", "37.27.55.*", "login_fail", "");

/* INSERT TABLE DATA: eadsk_comments */
INSERT INTO `eadsk_comments` VALUES("1", "1", "Mr WordPress", "", "https://wordpress.org/", "", "2015-04-26 14:37:23", "2015-04-26 14:37:23", "Hi, this is a comment.\nTo delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.", "0", "post-trashed", "", "", "0", "0");

/* INSERT TABLE DATA: eadsk_duplicator_packages */
INSERT INTO `eadsk_duplicator_packages` VALUES("3", "20150826_magmaincattorneys", "55dd74ac7fae67873150826081124", "20", "2015-08-26 08:11:35", "aDmin8576", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:3;s:4:\"Name\";s:26:\"20150826_magmaincattorneys\";s:4:\"Hash\";s:29:\"55dd74ac7fae67873150826081124\";s:8:\"NameHash\";s:56:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124\";s:7:\"Version\";s:6:\"0.5.28\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/usr/www/users/magmaauvky/wp-snapshots/tmp\";s:8:\"StoreURL\";s:35:\"http://magmainc.co.za/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:68:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/usr/www/users/magmaauvky\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:26:\"20150826_magmaincattorneys\";s:4:\"Hash\";s:29:\"55dd74ac7fae67873150826081124\";s:8:\"NameHash\";s:56:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124\";s:7:\"Version\";s:6:\"0.5.28\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/usr/www/users/magmaauvky/wp-snapshots/tmp\";s:8:\"StoreURL\";s:35:\"http://magmainc.co.za/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:70:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:45;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:60;s:8:\"Database\";r:73;}");

/* INSERT TABLE DATA: eadsk_options */
INSERT INTO `eadsk_options` VALUES("1", "siteurl", "http://magmainc.co.za", "yes");
INSERT INTO `eadsk_options` VALUES("2", "home", "http://magmainc.co.za", "yes");
INSERT INTO `eadsk_options` VALUES("3", "blogname", "Magma Inc Attorneys", "yes");
INSERT INTO `eadsk_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `eadsk_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `eadsk_options` VALUES("6", "admin_email", "steve@elementaldesigns.co.z", "yes");
INSERT INTO `eadsk_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `eadsk_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `eadsk_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `eadsk_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `eadsk_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `eadsk_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `eadsk_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `eadsk_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `eadsk_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `eadsk_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `eadsk_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `eadsk_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `eadsk_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `eadsk_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `eadsk_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `eadsk_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `eadsk_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `eadsk_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `eadsk_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `eadsk_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `eadsk_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `eadsk_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `eadsk_options` VALUES("29", "gzipcompression", "0", "yes");
INSERT INTO `eadsk_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `eadsk_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `eadsk_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `eadsk_options` VALUES("33", "active_plugins", "a:7:{i:0;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:49:\"elegant-themes-updater/elegant-themes-updater.php\";i:4;s:19:\"jetpack/jetpack.php\";i:5;s:29:\"wp-db-backup/wp-db-backup.php\";i:6;s:16:\"wp-edit/main.php\";}", "yes");
INSERT INTO `eadsk_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `eadsk_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `eadsk_options` VALUES("36", "advanced_edit", "0", "yes");
INSERT INTO `eadsk_options` VALUES("37", "comment_max_links", "2", "yes");
INSERT INTO `eadsk_options` VALUES("38", "gmt_offset", "2", "yes");
INSERT INTO `eadsk_options` VALUES("39", "default_email_category", "1", "yes");
INSERT INTO `eadsk_options` VALUES("40", "recently_edited", "a:3:{i:0;s:59:\"/usr/www/users/magmaauvky/wp-content/themes/Divi/footer.php\";i:2;s:58:\"/usr/www/users/magmaauvky/wp-content/themes/Divi/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `eadsk_options` VALUES("41", "template", "Divi", "yes");
INSERT INTO `eadsk_options` VALUES("42", "stylesheet", "Divi", "yes");
INSERT INTO `eadsk_options` VALUES("43", "comment_whitelist", "1", "yes");
INSERT INTO `eadsk_options` VALUES("44", "blacklist_keys", "", "no");
INSERT INTO `eadsk_options` VALUES("45", "comment_registration", "0", "yes");
INSERT INTO `eadsk_options` VALUES("46", "html_type", "text/html", "yes");
INSERT INTO `eadsk_options` VALUES("47", "use_trackback", "0", "yes");
INSERT INTO `eadsk_options` VALUES("48", "default_role", "subscriber", "yes");
INSERT INTO `eadsk_options` VALUES("49", "db_version", "31536", "yes");
INSERT INTO `eadsk_options` VALUES("50", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `eadsk_options` VALUES("51", "upload_path", "", "yes");
INSERT INTO `eadsk_options` VALUES("52", "blog_public", "1", "yes");
INSERT INTO `eadsk_options` VALUES("53", "default_link_category", "2", "yes");
INSERT INTO `eadsk_options` VALUES("54", "show_on_front", "page", "yes");
INSERT INTO `eadsk_options` VALUES("55", "tag_base", "", "yes");
INSERT INTO `eadsk_options` VALUES("56", "show_avatars", "1", "yes");
INSERT INTO `eadsk_options` VALUES("57", "avatar_rating", "G", "yes");
INSERT INTO `eadsk_options` VALUES("58", "upload_url_path", "", "yes");
INSERT INTO `eadsk_options` VALUES("59", "thumbnail_size_w", "150", "yes");
INSERT INTO `eadsk_options` VALUES("60", "thumbnail_size_h", "150", "yes");
INSERT INTO `eadsk_options` VALUES("61", "thumbnail_crop", "1", "yes");
INSERT INTO `eadsk_options` VALUES("62", "medium_size_w", "450", "yes");
INSERT INTO `eadsk_options` VALUES("63", "medium_size_h", "600", "yes");
INSERT INTO `eadsk_options` VALUES("64", "avatar_default", "mystery", "yes");
INSERT INTO `eadsk_options` VALUES("65", "large_size_w", "600", "yes");
INSERT INTO `eadsk_options` VALUES("66", "large_size_h", "800", "yes");
INSERT INTO `eadsk_options` VALUES("67", "image_default_link_type", "", "yes");
INSERT INTO `eadsk_options` VALUES("68", "image_default_size", "", "yes");
INSERT INTO `eadsk_options` VALUES("69", "image_default_align", "", "yes");
INSERT INTO `eadsk_options` VALUES("70", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `eadsk_options` VALUES("71", "close_comments_days_old", "14", "yes");
INSERT INTO `eadsk_options` VALUES("72", "thread_comments", "1", "yes");
INSERT INTO `eadsk_options` VALUES("73", "thread_comments_depth", "5", "yes");
INSERT INTO `eadsk_options` VALUES("74", "page_comments", "0", "yes");
INSERT INTO `eadsk_options` VALUES("75", "comments_per_page", "50", "yes");
INSERT INTO `eadsk_options` VALUES("76", "default_comments_page", "newest", "yes");
INSERT INTO `eadsk_options` VALUES("77", "comment_order", "asc", "yes");
INSERT INTO `eadsk_options` VALUES("78", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `eadsk_options` VALUES("79", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("80", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("81", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("82", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `eadsk_options` VALUES("83", "timezone_string", "", "yes");
INSERT INTO `eadsk_options` VALUES("84", "page_for_posts", "0", "yes");
INSERT INTO `eadsk_options` VALUES("85", "page_on_front", "39", "yes");
INSERT INTO `eadsk_options` VALUES("86", "default_post_format", "0", "yes");
INSERT INTO `eadsk_options` VALUES("87", "link_manager_enabled", "0", "yes");
INSERT INTO `eadsk_options` VALUES("88", "initial_db_version", "30133", "yes");
INSERT INTO `eadsk_options` VALUES("89", "eadsk_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `eadsk_options` VALUES("90", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("91", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("92", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("93", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("94", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("95", "sidebars_widgets", "a:7:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:17:\"recent-comments-2\";i:1;s:10:\"archives-2\";i:2;s:6:\"meta-2\";}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:12:\"categories-2\";}s:9:\"sidebar-2\";N;s:9:\"sidebar-3\";N;s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `eadsk_options` VALUES("96", "cron", "a:10:{i:1440577319;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1440579482;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1440583082;a:1:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1440599922;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1440599941;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1440600660;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1440617356;a:1:{s:21:\"et_cron_check_account\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1440618420;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1440658740;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `eadsk_options` VALUES("119", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:27:\"steve@elementaldesigns.co.z\";s:7:\"version\";s:5:\"4.2.4\";s:9:\"timestamp\";i:1439297770;}", "yes");
INSERT INTO `eadsk_options` VALUES("134", "jetpack_file_data", "a:1:{s:5:\"3.6.1\";a:48:{s:32:\"897a2742e7839607c0023b456ed14758\";a:13:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:89:\"Check your spelling, style, and grammar with the After the Deadline proofreading service.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";}s:32:\"c870c79f222cdc3114d210d3a3502a79\";a:13:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:63:\"Transform standard image galleries into full-screen slideshows.\";s:14:\"jumpstart_desc\";s:79:\"brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:9:\"Jumpstart\";}s:32:\"5626c5d4355e483f5d4356630646d742\";a:13:{s:4:\"name\";s:16:\"Jetpack Comments\";s:11:\"description\";s:79:\"Let readers comment with WordPress.com, Twitter, Facebook, or Google+ accounts.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";}s:32:\"24c526e6c78dd2c097eee51c33d627ee\";a:13:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:44:\"Insert a contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:9:\"Jumpstart\";}s:32:\"be64897c0a578ee6cadb1a459021fbbe\";a:13:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:92:\"Organize and display different types of content on your site, separate from posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";}s:32:\"6735e720fe2e3f6f2c48fcaf0fe0a157\";a:13:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:57:\"Customize your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";}s:32:\"3abad4b5ddebf37a03f03331b17c1e1b\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"e30ae0161f5ef7955a2e22021602969b\";a:13:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:74:\"Share your public posts and comments to search engines and other services.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";}s:32:\"e4e461477edd64344126af366b33ae7c\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"1e285572509707836075afa0b7a0d17a\";a:13:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:9:\"Jumpstart\";}s:32:\"2a62f28abd5ac11bea3ce7a8e9c4d893\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"fd2cbe6ae10ff814cc269d51b32baad9\";a:13:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:46:\"Add support for infinite scroll to your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";}s:32:\"931a7a94c663547c5cb6cc430e98dd30\";a:13:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:69:\"Allow applications to securely access your content through the cloud.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:0:\"\";}s:32:\"dd442dc05f950526d584e15e54628bfb\";a:13:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:85:\"Use LaTeX markup language in posts and pages for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";}s:32:\"96f2d1988c22688e9e3d8a8cc5ee1b5b\";a:13:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:70:\"Give visitors an easy way to show their appreciation for your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";}s:32:\"f79ea51a248d9f624e0936ef023cffe1\";a:13:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:76:\"Manage all your sites from a centralized place, https://wordpress.com/sites.\";s:14:\"jumpstart_desc\";s:151:\"helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:22:\"Recommended, Jumpstart\";}s:32:\"46da83c7358c834dcb193789272f7858\";a:13:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";}s:32:\"c189740a3e69c5f42f12a191a15c3dbf\";a:13:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:64:\"Optimize your site with a mobile-friendly theme for smartphones.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:11:\"Recommended\";}s:32:\"0f9fdc374b00a8d5ca816aac44e6d3f6\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"6f1872535dd77713441708214388213c\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"65f2f0936d11bffe8cd447696054f38e\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"a8ff13dae8129c451116dea8803b23da\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"0a38341a9df2d2cb6f90e4faf65b4d64\";a:13:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:88:\"Receive notifications from Jetpack if your site goes offline — and when it it returns.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:11:\"Recommended\";}s:32:\"1c8f61fb80e0f6dd697e6d995431161a\";a:13:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:84:\"Receive notification of site activity via the admin toolbar and your Mobile devices.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";}s:32:\"4ca0a2f31843f3b2a4522fa8b9fb18d3\";a:13:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your Dashboard.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"16\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:0:\"\";}s:32:\"1f1289f469fe089a9ea32024df083f74\";a:13:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:66:\"Accelerate your site by loading images from the WordPress.com CDN.\";s:14:\"jumpstart_desc\";s:141:\"mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:22:\"Recommended, Jumpstart\";}s:32:\"53eb2f9dfe4e9d9b7203d47ab3a0c58e\";a:13:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:58:\"Publish posts by email, using any device and email client.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";}s:32:\"df74d4db35fc795c9bf4b7b2e769116d\";a:13:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:70:\"Adds brute force protection to your login page. Formerly BruteProtect.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:11:\"Recommended\";}s:32:\"e8b7c9d9b0be70888c41e139c34eb448\";a:13:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:55:\"Share new posts on social media networks automatically.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:11:\"Recommended\";}s:32:\"04c7eedf95290d03db05e2fc8682a8da\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"f36c13c725ee67f8fbb85d85b4fa8bdb\";a:13:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:60:\"Display links to your related content under posts and pages.\";s:14:\"jumpstart_desc\";s:113:\"keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:22:\"Recommended, Jumpstart\";}s:32:\"4034d694a22b9864b7d9dbcc291a01f5\";a:13:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:81:\"Allow visitors to share your content on Facebook, Twitter, and more with a click.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:22:\"Recommended, Jumpstart\";}s:32:\"a260ebaa113e875bbbe59b54cd2475b1\";a:13:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:77:\"Embed content from YouTube, Vimeo, SlideShare, and more, no coding necessary.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:0:\"\";}s:32:\"48e6f4cc58711b5d627931f72a4f55a2\";a:13:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:56:\"Enable WP.me-powered shortlinks for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";}s:32:\"0361b51d6b8957ba15a90c8893085e51\";a:13:{s:4:\"name\";s:9:\"Site Icon\";s:11:\"description\";s:29:\"Add a site icon to your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";}s:32:\"03045ecc30a51f072431bd2f6ccffc37\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"2e89d8cf494aa4cc028023de2662b571\";a:13:{s:4:\"name\";s:22:\"Jetpack Single Sign On\";s:11:\"description\";s:62:\"Allow your users to log in using their WordPress.com accounts.\";s:14:\"jumpstart_desc\";s:97:\"lets you login to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:9:\"Jumpstart\";}s:32:\"caf240bf1da3b6f8ec449d7477ac383e\";a:13:{s:4:\"name\";s:19:\"WordPress.com Stats\";s:11:\"description\";s:85:\"Monitor your stats with clear, concise reports and no additional load on your server.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:32:\"WordPress.com Stats, Recommended\";s:7:\"feature\";s:11:\"Recommended\";}s:32:\"b6ef488128505d6cf819d8a6508a081f\";a:13:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:88:\"Allow users to subscribe to your posts and comments and receive notifications via email.\";s:14:\"jumpstart_desc\";s:126:\"give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:9:\"Jumpstart\";}s:32:\"6c0c9cebc91c7aee0de35562fcb8d0b0\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"f354e2a9f6f0823a628e741e7aa88906\";a:13:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:73:\"Display your image galleries in a variety of sleek, graphic arrangements.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";}s:32:\"fb806f9c3f633a466076615f99329d22\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"c6908213746b1364a541c3fde961936f\";a:13:{s:4:\"name\";s:10:\"VaultPress\";s:11:\"description\";s:85:\"Protect your site with automatic backups and security scans. (Subscription required.)\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"df97f3fe6750f6490164e710152d5946\";a:13:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:78:\"Verify your site or domain with Google Webmaster Tools, Pinterest, and others.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}s:32:\"5e000fbc427cecaed6e1b8dbf2732462\";a:13:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:68:\"Upload and embed videos right on your site. (Subscription required.)\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";}s:32:\"86f746acdf5d11f8fe753092aec6f619\";a:13:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:57:\"Specify which widgets appear on which pages of your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";}s:32:\"b91d486b68701c78e5f2776144c546f4\";a:13:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:79:\"Add images, Twitter streams, your site’s RSS links, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:0:\"\";}s:32:\"98a767d5a9377cc7b8d08fda01d960c0\";a:13:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";}}}", "yes");
INSERT INTO `eadsk_options` VALUES("135", "jetpack_available_modules", "a:1:{s:5:\"3.6.1\";a:36:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:6:\"manage\";s:3:\"3.4\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"omnisearch\";s:3:\"2.3\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:9:\"site-icon\";s:3:\"3.2\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";}}", "yes");
INSERT INTO `eadsk_options` VALUES("136", "recently_activated", "a:0:{}", "yes");
INSERT INTO `eadsk_options` VALUES("138", "jetpack_security_report", "a:0:{}", "yes");
INSERT INTO `eadsk_options` VALUES("143", "jetpack_updates", "a:7:{s:7:\"plugins\";i:0;s:6:\"themes\";i:0;s:9:\"wordpress\";i:0;s:12:\"translations\";i:0;s:5:\"total\";i:0;s:10:\"wp_version\";s:5:\"4.2.4\";s:26:\"site_is_version_controlled\";b:0;}", "yes");
INSERT INTO `eadsk_options` VALUES("145", "aioseop_options", "a:87:{s:12:\"aiosp_donate\";N;s:16:\"aiosp_home_title\";N;s:22:\"aiosp_home_description\";s:0:\"\";s:20:\"aiosp_togglekeywords\";i:0;s:19:\"aiosp_home_keywords\";N;s:26:\"aiosp_use_static_home_info\";i:0;s:9:\"aiosp_can\";i:1;s:30:\"aiosp_no_paged_canonical_links\";i:0;s:31:\"aiosp_customize_canonical_links\";i:0;s:22:\"aiosp_can_set_protocol\";s:4:\"auto\";s:20:\"aiosp_rewrite_titles\";i:1;s:20:\"aiosp_force_rewrites\";i:1;s:24:\"aiosp_use_original_title\";i:0;s:16:\"aiosp_cap_titles\";i:1;s:14:\"aiosp_cap_cats\";i:1;s:28:\"aiosp_home_page_title_format\";s:12:\"%page_title%\";s:23:\"aiosp_page_title_format\";s:27:\"%page_title% | %blog_title%\";s:23:\"aiosp_post_title_format\";s:27:\"%post_title% | %blog_title%\";s:27:\"aiosp_category_title_format\";s:31:\"%category_title% | %blog_title%\";s:26:\"aiosp_archive_title_format\";s:30:\"%archive_title% | %blog_title%\";s:23:\"aiosp_date_title_format\";s:21:\"%date% | %blog_title%\";s:25:\"aiosp_author_title_format\";s:23:\"%author% | %blog_title%\";s:22:\"aiosp_tag_title_format\";s:20:\"%tag% | %blog_title%\";s:25:\"aiosp_search_title_format\";s:23:\"%search% | %blog_title%\";s:24:\"aiosp_description_format\";s:13:\"%description%\";s:22:\"aiosp_404_title_format\";s:33:\"Nothing found for %request_words%\";s:18:\"aiosp_paged_format\";s:14:\" - Part %page%\";s:17:\"aiosp_enablecpost\";s:2:\"on\";s:17:\"aiosp_cpostactive\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"aiosp_cpostadvanced\";i:0;s:18:\"aiosp_cpostnoindex\";a:0:{}s:19:\"aiosp_cpostnofollow\";a:0:{}s:16:\"aiosp_cpostnoodp\";a:0:{}s:17:\"aiosp_cpostnoydir\";a:0:{}s:17:\"aiosp_cposttitles\";i:0;s:21:\"aiosp_posttypecolumns\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:15:\"aiosp_admin_bar\";s:2:\"on\";s:23:\"aiosp_custom_menu_order\";s:2:\"on\";s:19:\"aiosp_google_verify\";s:0:\"\";s:17:\"aiosp_bing_verify\";s:0:\"\";s:22:\"aiosp_pinterest_verify\";s:0:\"\";s:22:\"aiosp_google_publisher\";s:0:\"\";s:28:\"aiosp_google_disable_profile\";i:0;s:29:\"aiosp_google_sitelinks_search\";N;s:28:\"aiosp_google_author_advanced\";i:0;s:28:\"aiosp_google_author_location\";a:1:{i:0;s:3:\"all\";}s:29:\"aiosp_google_enable_publisher\";s:2:\"on\";s:30:\"aiosp_google_specify_publisher\";N;s:20:\"aiosp_google_connect\";N;s:25:\"aiosp_google_analytics_id\";N;s:32:\"aiosp_ga_use_universal_analytics\";i:0;s:25:\"aiosp_ga_advanced_options\";s:2:\"on\";s:15:\"aiosp_ga_domain\";N;s:21:\"aiosp_ga_multi_domain\";i:0;s:21:\"aiosp_ga_addl_domains\";N;s:21:\"aiosp_ga_anonymize_ip\";N;s:28:\"aiosp_ga_display_advertising\";N;s:22:\"aiosp_ga_exclude_users\";N;s:29:\"aiosp_ga_track_outbound_links\";i:0;s:25:\"aiosp_ga_link_attribution\";i:0;s:27:\"aiosp_ga_enhanced_ecommerce\";i:0;s:20:\"aiosp_use_categories\";i:0;s:26:\"aiosp_use_tags_as_keywords\";i:1;s:32:\"aiosp_dynamic_postspage_keywords\";i:1;s:22:\"aiosp_category_noindex\";i:1;s:26:\"aiosp_archive_date_noindex\";i:1;s:28:\"aiosp_archive_author_noindex\";i:1;s:18:\"aiosp_tags_noindex\";i:0;s:20:\"aiosp_search_noindex\";i:0;s:17:\"aiosp_404_noindex\";i:0;s:23:\"aiosp_paginated_noindex\";i:0;s:24:\"aiosp_paginated_nofollow\";i:0;s:11:\"aiosp_noodp\";i:0;s:12:\"aiosp_noydir\";i:0;s:18:\"aiosp_skip_excerpt\";i:0;s:27:\"aiosp_generate_descriptions\";i:1;s:20:\"aiosp_run_shortcodes\";i:0;s:33:\"aiosp_hide_paginated_descriptions\";i:0;s:32:\"aiosp_dont_truncate_descriptions\";i:0;s:19:\"aiosp_schema_markup\";i:1;s:20:\"aiosp_unprotect_meta\";i:0;s:14:\"aiosp_ex_pages\";s:0:\"\";s:20:\"aiosp_post_meta_tags\";s:0:\"\";s:20:\"aiosp_page_meta_tags\";s:0:\"\";s:21:\"aiosp_front_meta_tags\";s:0:\"\";s:20:\"aiosp_home_meta_tags\";s:0:\"\";s:12:\"aiosp_do_log\";N;}", "yes");
INSERT INTO `eadsk_options` VALUES("147", "wp_edit_buttons", "a:3:{s:8:\"toolbar1\";s:146:\"bold italic strikethrough bullist numlist blockquote alignleft aligncenter alignright link unlink wp_more hr fontselect fontsizeselect styleselect\";s:8:\"toolbar2\";s:109:\"formatselect underline alignjustify forecolor pastetext removeformat charmap outdent indent undo redo wp_help\";s:14:\"tmce_container\";s:203:\"backcolor media rtl ltr table anchor code emoticons inserttime wp_page preview print searchreplace visualblocks subscript superscript image_orig advlink acheck abbr columnShortcodes nonbreaking eqneditor\";}", "yes");
INSERT INTO `eadsk_options` VALUES("148", "wp_edit_global", "a:3:{s:12:\"jquery_theme\";s:10:\"smoothness\";s:19:\"disable_admin_links\";s:1:\"0\";s:22:\"disable_fancy_tooltips\";s:1:\"0\";}", "yes");
INSERT INTO `eadsk_options` VALUES("149", "wp_edit_general", "a:7:{s:19:\"linebreak_shortcode\";s:1:\"0\";s:21:\"shortcodes_in_widgets\";s:1:\"0\";s:22:\"shortcodes_in_excerpts\";s:1:\"0\";s:19:\"post_excerpt_editor\";s:1:\"0\";s:19:\"page_excerpt_editor\";s:1:\"0\";s:14:\"profile_editor\";s:1:\"0\";s:11:\"php_widgets\";s:1:\"0\";}", "yes");
INSERT INTO `eadsk_options` VALUES("150", "wp_edit_posts", "a:8:{s:16:\"post_title_field\";s:16:\"Enter title here\";s:18:\"max_post_revisions\";s:0:\"\";s:18:\"max_page_revisions\";s:0:\"\";s:16:\"delete_revisions\";s:1:\"0\";s:16:\"hide_admin_posts\";s:0:\"\";s:16:\"hide_admin_pages\";s:0:\"\";s:15:\"disable_wpautop\";s:1:\"0\";s:17:\"column_shortcodes\";s:1:\"0\";}", "yes");
INSERT INTO `eadsk_options` VALUES("151", "wp_edit_editor", "a:3:{s:21:\"editor_add_pre_styles\";s:1:\"0\";s:28:\"default_editor_fontsize_type\";s:2:\"pt\";s:30:\"default_editor_fontsize_values\";s:0:\"\";}", "yes");
INSERT INTO `eadsk_options` VALUES("152", "wp_edit_extras", "a:1:{s:12:\"signoff_text\";s:25:\"Please enter text here...\";}", "yes");
INSERT INTO `eadsk_options` VALUES("154", "wp_edit_install", "2015-04-26", "yes");
INSERT INTO `eadsk_options` VALUES("155", "jetpack_log", "a:3:{i:0;a:4:{s:4:\"time\";i:1430059521;s:7:\"user_id\";i:1;s:7:\"blog_id\";b:0;s:4:\"code\";s:8:\"register\";}i:1;a:4:{s:4:\"time\";i:1430059788;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:90221693;s:4:\"code\";s:9:\"authorize\";}i:2;a:4:{s:4:\"time\";i:1440170529;s:7:\"user_id\";i:1;s:7:\"blog_id\";b:0;s:4:\"code\";s:8:\"register\";}}", "no");
INSERT INTO `eadsk_options` VALUES("156", "jetpack_private_options", "a:2:{s:8:\"register\";s:76:\"BcGQY3c0iKsIdehBgXm3bJ6QLi4LBt8H:eIVfRUUmsOfQk4gnNSbrtvoEQhheIRw3:1440171129\";s:10:\"blog_token\";s:65:\"cN7e6#xnI%lX0UbknJ3V7Q2TJHAPPOQ6.VX9)Jf5x(TV6FpgxCb5sPGuPwFe*m^09\";}", "yes");
INSERT INTO `eadsk_options` VALUES("164", "stats_options", "a:7:{s:9:\"admin_bar\";b:1;s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:11:\"count_roles\";a:0:{}s:7:\"blog_id\";i:90221693;s:12:\"do_not_track\";b:1;s:10:\"hide_smile\";b:1;s:7:\"version\";s:1:\"9\";}", "yes");
INSERT INTO `eadsk_options` VALUES("166", "jetpack_protect_key", "18dba42a3e2179c891858b720347f7d01853611f", "yes");
INSERT INTO `eadsk_options` VALUES("191", "et_account_status", "active", "yes");
INSERT INTO `eadsk_options` VALUES("196", "sharing-options", "a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:4:\"icon\";s:13:\"sharing_label\";s:11:\"Share this:\";s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:0:{}s:6:\"custom\";a:0:{}}}", "yes");
INSERT INTO `eadsk_options` VALUES("204", "db_upgraded", "", "yes");
INSERT INTO `eadsk_options` VALUES("604", "jetpack_protect_blocked_attempts", "110", "yes");
INSERT INTO `eadsk_options` VALUES("618", "stats_cache", "a:2:{s:32:\"73f9d636a0248e9f20cf61fe935d606f\";a:1:{i:1440170349;a:8:{i:0;a:4:{s:7:\"post_id\";s:2:\"39\";s:10:\"post_title\";s:4:\"HOME\";s:14:\"post_permalink\";s:39:\"http://elementalsandbox.co.za/Magmainc/\";s:5:\"views\";s:2:\"38\";}i:1;a:4:{s:7:\"post_id\";s:3:\"205\";s:10:\"post_title\";s:11:\"OUR CLIENTS\";s:14:\"post_permalink\";s:34:\"http://magmainc.co.za/our-clients/\";s:5:\"views\";s:2:\"14\";}i:2;a:4:{s:7:\"post_id\";s:2:\"51\";s:10:\"post_title\";s:10:\"CONTACT US\";s:14:\"post_permalink\";s:50:\"http://elementalsandbox.co.za/Magmainc/contact-us/\";s:5:\"views\";s:2:\"11\";}i:3;a:4:{s:7:\"post_id\";s:2:\"64\";s:10:\"post_title\";s:15:\"NEWS AND EVENTS\";s:14:\"post_permalink\";s:55:\"http://elementalsandbox.co.za/Magmainc/news-and-events/\";s:5:\"views\";s:1:\"7\";}i:4;a:4:{s:7:\"post_id\";s:2:\"58\";s:10:\"post_title\";s:8:\"ABOUT US\";s:14:\"post_permalink\";s:48:\"http://elementalsandbox.co.za/Magmainc/about-us/\";s:5:\"views\";s:1:\"7\";}i:5;a:4:{s:7:\"post_id\";s:2:\"60\";s:10:\"post_title\";s:13:\"PRACTICE AREA\";s:14:\"post_permalink\";s:53:\"http://elementalsandbox.co.za/Magmainc/practice-area/\";s:5:\"views\";s:1:\"6\";}i:6;a:4:{s:7:\"post_id\";s:3:\"213\";s:10:\"post_title\";s:9:\"SUBSCRIBE\";s:14:\"post_permalink\";s:49:\"http://elementalsandbox.co.za/Magmainc/subscribe/\";s:5:\"views\";s:1:\"4\";}i:7;a:4:{s:7:\"post_id\";s:3:\"209\";s:10:\"post_title\";s:11:\"MEMBERSHIPS\";s:14:\"post_permalink\";s:51:\"http://elementalsandbox.co.za/Magmainc/memberships/\";s:5:\"views\";s:1:\"4\";}}}s:32:\"a2fc6b3df881fe0f8580d81619e267ac\";a:1:{i:1440170349;a:0:{}}}", "yes");
INSERT INTO `eadsk_options` VALUES("634", "jetpack_unique_connection", "a:3:{s:9:\"connected\";i:1;s:12:\"disconnected\";i:1;s:7:\"version\";s:5:\"3.6.1\";}", "yes");
INSERT INTO `eadsk_options` VALUES("640", "trusted_ip_header", "REMOTE_ADDR", "yes");
INSERT INTO `eadsk_options` VALUES("645", "can_compress_scripts", "1", "yes");
INSERT INTO `eadsk_options` VALUES("648", "WPLANG", "", "yes");
INSERT INTO `eadsk_options` VALUES("649", "et_automatic_updates_options", "a:2:{s:8:\"username\";s:8:\"bowsprit\";s:7:\"api_key\";s:40:\"e35f6dc3933ac1d81a5881e79d894cba3428fc48\";}", "yes");
INSERT INTO `eadsk_options` VALUES("667", "aiowpsec_db_version", "1.6", "yes");
INSERT INTO `eadsk_options` VALUES("668", "aio_wp_security_configs", "a:67:{s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:1:\"1\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";i:3;s:24:\"aiowps_retry_time_period\";i:5;s:26:\"aiowps_lockout_time_length\";i:60;s:28:\"aiowps_set_generic_login_msg\";s:1:\"1\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:28:\"steve@elementaldesigns.co.za\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:1:\"1\";s:32:\"aiowps_unlock_request_secret_key\";s:20:\"bmc3bco0oxiicqv24p5t\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"yww3x86r996znt8vwpho\";s:42:\"aiowps_enable_manual_registration_approval\";s:1:\"1\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:0:\"\";s:26:\"aiowps_db_backup_frequency\";s:1:\"4\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:26:\"aiowps_backup_files_stored\";s:1:\"2\";s:32:\"aiowps_send_backup_email_address\";s:0:\"\";s:27:\"aiowps_backup_email_address\";s:27:\"steve@elementaldesigns.co.z\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:1:\"1\";s:31:\"aiowps_enable_pingback_firewall\";s:1:\"1\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:0:\"\";s:29:\"aiowps_deny_bad_query_strings\";s:0:\"\";s:34:\"aiowps_advanced_char_string_filter\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:1:\"1\";s:29:\"aiowps_enable_comment_captcha\";s:1:\"1\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:27:\"steve@elementaldesigns.co.z\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";}", "yes");
INSERT INTO `eadsk_options` VALUES("673", "wp_db_backup_excs", "a:2:{s:9:\"revisions\";a:0:{}s:4:\"spam\";a:0:{}}", "yes");
INSERT INTO `eadsk_options` VALUES("1078", "theme_mods_twentyfifteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1438574652;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `eadsk_options` VALUES("1079", "current_theme", "Divi", "yes");
INSERT INTO `eadsk_options` VALUES("1080", "theme_mods_Divi", "a:5:{i:0;b:0;s:21:\"et_pb_layouts_updated\";s:3:\"yes\";s:30:\"et_pb_predefined_layouts_added\";s:2:\"on\";s:36:\"et_pb_predefined_layouts_updated_2_0\";s:2:\"on\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:2;}}", "yes");
INSERT INTO `eadsk_options` VALUES("1081", "theme_switched", "", "yes");
INSERT INTO `eadsk_options` VALUES("1082", "safecss_rev", "1", "yes");
INSERT INTO `eadsk_options` VALUES("1091", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1092", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `eadsk_options` VALUES("1093", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1094", "et_images_temp_folder", "/usr/www/users/magmaauvky/wp-content/uploads/et_temp", "yes");
INSERT INTO `eadsk_options` VALUES("1095", "et_schedule_clean_images_last_time", "1440511252", "yes");
INSERT INTO `eadsk_options` VALUES("1096", "et_divi", "a:101:{s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:15:\"divi_1_3_images\";s:7:\"checked\";s:9:\"divi_logo\";s:58:\"http://magmainc.co.za/wp-content/uploads/2015/08/large.jpg\";s:12:\"divi_favicon\";s:60:\"http://magmainc.co.za/wp-content/uploads/2015/08/favicon.jpg\";s:14:\"divi_fixed_nav\";s:2:\"on\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:5:\"false\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_mailchimp_api_key\";s:0:\"\";s:31:\"divi_regenerate_mailchimp_lists\";s:5:\"false\";s:28:\"divi_regenerate_aweber_lists\";s:5:\"false\";s:23:\"divi_show_facebook_icon\";s:2:\"on\";s:22:\"divi_show_twitter_icon\";s:2:\"on\";s:21:\"divi_show_google_icon\";s:5:\"false\";s:18:\"divi_show_rss_icon\";s:5:\"false\";s:17:\"divi_facebook_url\";s:50:\"https://www.facebook.com/MagmaIncorporated?fref=ts\";s:16:\"divi_twitter_url\";s:28:\"https://twitter.com/MagmaInc\";s:15:\"divi_google_url\";s:1:\"#\";s:12:\"divi_rss_url\";s:0:\"\";s:17:\"divi_catnum_posts\";i:6;s:21:\"divi_archivenum_posts\";i:5;s:20:\"divi_searchnum_posts\";i:5;s:17:\"divi_tagnum_posts\";i:5;s:16:\"divi_date_format\";s:6:\"M j, Y\";s:16:\"divi_use_excerpt\";s:5:\"false\";s:26:\"divi_responsive_shortcodes\";s:2:\"on\";s:33:\"divi_gf_enable_all_character_sets\";s:5:\"false\";s:16:\"divi_back_to_top\";s:5:\"false\";s:18:\"divi_smooth_scroll\";s:5:\"false\";s:15:\"divi_custom_css\";s:128:\"#top-menu li.current-menu-item > a {\ncolor: #ad002e !important;\n}\n\n#logo {\nmax-height: 98%;\n}\n#top-header a {\nfont-size: 16px;\n}\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:2:\"on\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:14:\"divi_postinfo2\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";}s:22:\"divi_show_postcomments\";s:2:\"on\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:3:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:0:\"\";s:21:\"divi_integration_body\";s:0:\"\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:12:\"accent_color\";s:7:\"#ad002e\";s:11:\"menu_height\";s:3:\"109\";s:12:\"header_color\";s:7:\"#ad002e\";s:22:\"fixed_secondary_nav_bg\";s:7:\"#ad002e\";s:22:\"fixed_menu_link_active\";s:7:\"#ad002e\";s:16:\"show_search_icon\";b:1;s:12:\"boxed_layout\";b:1;s:13:\"content_width\";s:4:\"1087\";s:12:\"gutter_width\";s:1:\"2\";s:24:\"primary_nav_font_spacing\";s:1:\"0\";s:21:\"minimized_menu_height\";s:2:\"93\";s:21:\"all_buttons_font_size\";s:2:\"15\";s:24:\"all_buttons_border_width\";s:1:\"1\";s:12:\"header_style\";s:4:\"left\";s:13:\"nav_fullwidth\";b:0;s:16:\"primary_nav_font\";s:10:\"Lato Light\";s:30:\"primary_nav_dropdown_animation\";s:6:\"expand\";s:15:\"section_padding\";s:1:\"0\";s:11:\"row_padding\";s:1:\"2\";}", "yes");
INSERT INTO `eadsk_options` VALUES("1122", "duplicator_version_plugin", "0.5.28", "yes");
INSERT INTO `eadsk_options` VALUES("1203", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `eadsk_options` VALUES("1206", "widget_blog_subscription", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1209", "widget_calendar", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1210", "widget_widget_contact_info", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1211", "widget_nav_menu", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1212", "widget_jetpack_display_posts_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1213", "widget_aboutmewidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1214", "widget_adsensewidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1215", "widget_advwidget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1216", "widget_facebook-likebox", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1217", "widget_wpcom-goodreads", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1218", "widget_grofile", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1219", "widget_image", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1220", "widget_pages", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1222", "widget_rss_links", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1223", "widget_wpcom_social_media_icons_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1224", "widget_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1226", "widget_top-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("1227", "widget_twitter_timeline", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `eadsk_options` VALUES("2153", "category_children", "a:0:{}", "yes");
INSERT INTO `eadsk_options` VALUES("2202", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:2:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.3.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.3-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.3\";s:7:\"version\";s:3:\"4.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":12:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.3.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.3-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.3\";s:7:\"version\";s:3:\"4.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1440575232;s:15:\"version_checked\";s:5:\"4.2.4\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `eadsk_options` VALUES("2209", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1440575234;s:7:\"checked\";a:2:{s:4:\"Divi\";s:7:\"2.4.6.4\";s:13:\"twentyfifteen\";s:3:\"1.3\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `eadsk_options` VALUES("2210", "_site_transient_et_update_themes", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1440575234;}", "yes");
INSERT INTO `eadsk_options` VALUES("2211", "_transient_random_seed", "92e334faa63eb3f9d79f294cfd35d2f8", "yes");
INSERT INTO `eadsk_options` VALUES("2212", "_transient_timeout_jetpack_https_test", "1440254502", "no");
INSERT INTO `eadsk_options` VALUES("2213", "_transient_jetpack_https_test", "1", "no");
INSERT INTO `eadsk_options` VALUES("2214", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"0.5.28\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `eadsk_options` VALUES("2224", "_transient_timeout_jpp_headers_updated_recently", "1440254541", "no");
INSERT INTO `eadsk_options` VALUES("2225", "_transient_jpp_headers_updated_recently", "1", "no");
INSERT INTO `eadsk_options` VALUES("2226", "_site_transient_timeout_browser_edcf8c71bdf406b17c04942f901c1c72", "1440772942", "yes");
INSERT INTO `eadsk_options` VALUES("2227", "_site_transient_browser_edcf8c71bdf406b17c04942f901c1c72", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"40.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `eadsk_options` VALUES("2249", "rewrite_rules", "a:127:{s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:28:\"project/([^/]+)(/[0-9]+)?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:40:\"et_pb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"et_pb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"et_pb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"et_pb_layout/([^/]+)/trackback/?$\";s:54:\"index.php?post_type=et_pb_layout&name=$matches[1]&tb=1\";s:41:\"et_pb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&paged=$matches[2]\";s:48:\"et_pb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&cpage=$matches[2]\";s:33:\"et_pb_layout/([^/]+)(/[0-9]+)?/?$\";s:66:\"index.php?post_type=et_pb_layout&name=$matches[1]&page=$matches[2]\";s:29:\"et_pb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"et_pb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"et_pb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"scope/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?scope=$matches[1]&feed=$matches[2]\";s:41:\"scope/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?scope=$matches[1]&feed=$matches[2]\";s:34:\"scope/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?scope=$matches[1]&paged=$matches[2]\";s:16:\"scope/([^/]+)/?$\";s:27:\"index.php?scope=$matches[1]\";s:52:\"layout_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?layout_type=$matches[1]&feed=$matches[2]\";s:47:\"layout_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?layout_type=$matches[1]&feed=$matches[2]\";s:40:\"layout_type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?layout_type=$matches[1]&paged=$matches[2]\";s:22:\"layout_type/([^/]+)/?$\";s:33:\"index.php?layout_type=$matches[1]\";s:53:\"module_width/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?module_width=$matches[1]&feed=$matches[2]\";s:48:\"module_width/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?module_width=$matches[1]&feed=$matches[2]\";s:41:\"module_width/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?module_width=$matches[1]&paged=$matches[2]\";s:23:\"module_width/([^/]+)/?$\";s:34:\"index.php?module_width=$matches[1]\";s:56:\"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?layout_category=$matches[1]&feed=$matches[2]\";s:51:\"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?layout_category=$matches[1]&feed=$matches[2]\";s:44:\"layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?layout_category=$matches[1]&paged=$matches[2]\";s:26:\"layout_category/([^/]+)/?$\";s:37:\"index.php?layout_category=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=39&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}", "yes");
INSERT INTO `eadsk_options` VALUES("2261", "_site_transient_timeout_browser_509a043accab8cd124d8792d09686be6", "1440773846", "yes");
INSERT INTO `eadsk_options` VALUES("2262", "_site_transient_browser_509a043accab8cd124d8792d09686be6", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"44.0.2403.155\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `eadsk_options` VALUES("2268", "_transient_timeout_jpp_li_3e52a618cbd3344f0dcd1a37a28298ba", "1440171257", "no");
INSERT INTO `eadsk_options` VALUES("2269", "_transient_jpp_li_3e52a618cbd3344f0dcd1a37a28298ba", "a:4:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:43:\"This IP is currently blocked (201.22.48.76)\";s:17:\"seconds_remaining\";i:900;s:6:\"expire\";i:1440171257;}", "no");
INSERT INTO `eadsk_options` VALUES("2270", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1440181164", "yes");
INSERT INTO `eadsk_options` VALUES("2271", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:40:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5223\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3269\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3204\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2734\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2503\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2001\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"1906\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1836\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1787\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1769\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1738\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1728\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1621\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1419\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1357\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1299\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1207\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1165\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1150\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1021\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:3:\"975\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:3:\"942\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:3:\"932\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"896\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"865\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"853\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"806\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"791\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"767\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"743\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"738\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"736\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"695\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"687\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"682\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"669\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"649\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"645\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"640\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"639\";}}", "yes");
INSERT INTO `eadsk_options` VALUES("2272", "_site_transient_et_update_all_plugins", "O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1440188061;}", "yes");
INSERT INTO `eadsk_options` VALUES("2277", "jetpack_options", "a:7:{s:7:\"version\";s:16:\"3.6.1:1440170519\";s:11:\"old_version\";s:16:\"3.6.1:1440170519\";s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:2:\"id\";i:97923097;s:6:\"public\";i:1;s:9:\"jumpstart\";s:14:\"new_connection\";}", "yes");
INSERT INTO `eadsk_options` VALUES("2278", "jetpack_activated", "1", "yes");
INSERT INTO `eadsk_options` VALUES("2517", "_site_transient_timeout_browser_f3af6f445892362a547775849d44f79e", "1441114435", "yes");
INSERT INTO `eadsk_options` VALUES("2518", "_site_transient_browser_f3af6f445892362a547775849d44f79e", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"44.0.2403.157\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `eadsk_options` VALUES("2535", "_transient_timeout_plugin_slugs", "1440596057", "no");
INSERT INTO `eadsk_options` VALUES("2536", "_transient_plugin_slugs", "a:11:{i:0;s:19:\"akismet/akismet.php\";i:1;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:2;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:3;s:15:\"bloom/bloom.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:49:\"elegant-themes-support/elegant-themes-support.php\";i:6;s:49:\"elegant-themes-updater/elegant-themes-updater.php\";i:7;s:9:\"hello.php\";i:8;s:19:\"jetpack/jetpack.php\";i:9;s:29:\"wp-db-backup/wp-db-backup.php\";i:10;s:16:\"wp-edit/main.php\";}", "no");
INSERT INTO `eadsk_options` VALUES("2599", "_transient_timeout_jetpack_site_is_vcs", "1440661621", "no");
INSERT INTO `eadsk_options` VALUES("2600", "_transient_jetpack_site_is_vcs", "0", "no");
INSERT INTO `eadsk_options` VALUES("2601", "_site_transient_timeout_theme_roots", "1440577023", "yes");
INSERT INTO `eadsk_options` VALUES("2602", "_site_transient_theme_roots", "a:2:{s:4:\"Divi\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";}", "yes");
INSERT INTO `eadsk_options` VALUES("2603", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1440575234;s:8:\"response\";a:1:{s:16:\"wp-edit/main.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"48982\";s:4:\"slug\";s:7:\"wp-edit\";s:6:\"plugin\";s:16:\"wp-edit/main.php\";s:11:\"new_version\";s:3:\"3.4\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/wp-edit/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/wp-edit.3.4.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:7:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.1.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.1.3.zip\";}s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"520\";s:4:\"slug\";s:19:\"all-in-one-seo-pack\";s:6:\"plugin\";s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:11:\"new_version\";s:7:\"2.2.7.1\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/all-in-one-seo-pack/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/all-in-one-seo-pack.zip\";}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"41309\";s:4:\"slug\";s:35:\"all-in-one-wp-security-and-firewall\";s:6:\"plugin\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:11:\"new_version\";s:5:\"3.9.9\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.28\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.28.zip\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.6.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.6.1.zip\";}s:29:\"wp-db-backup/wp-db-backup.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"419\";s:4:\"slug\";s:12:\"wp-db-backup\";s:6:\"plugin\";s:29:\"wp-db-backup/wp-db-backup.php\";s:11:\"new_version\";s:5:\"2.3.0\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-db-backup/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-db-backup.2.3.0.zip\";}}}", "yes");
INSERT INTO `eadsk_options` VALUES("2605", "_site_transient_timeout_security_report_performed_recently", "1440577537", "yes");
INSERT INTO `eadsk_options` VALUES("2606", "_site_transient_security_report_performed_recently", "1", "yes");
INSERT INTO `eadsk_options` VALUES("2607", "_transient_timeout_users_online", "1440578465", "no");
INSERT INTO `eadsk_options` VALUES("2608", "_transient_users_online", "a:1:{i:0;a:3:{s:7:\"user_id\";i:1;s:13:\"last_activity\";i:1440583865;s:10:\"ip_address\";s:13:\"196.210.16.42\";}}", "no");
INSERT INTO `eadsk_options` VALUES("2609", "_transient_timeout_feed_831fe7759a8f11bf56457f189e650ca4", "1440619872", "no");
INSERT INTO `eadsk_options` VALUES("2610", "_transient_feed_831fe7759a8f11bf56457f189e650ca4", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:1:\"\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:29:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP Edit Pro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"https://wpeditpro.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Aug 2015 20:58:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://wordpress.org/?v=4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wpeditpro.com/wp-edit-pro-file-manager-version-3-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"WP Edit Pro File Manager Version 3.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://feeds.feedblitz.com/~/107879672/0/wpeditpro~WP-Edit-Pro-File-Manager-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://feeds.feedblitz.com/~/107879672/0/wpeditpro~WP-Edit-Pro-File-Manager-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Aug 2015 20:58:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1729\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1659:\"WP Edit Pro File Manager Version 3.2 A new version of the WP Edit Pro File Manager (Version 3.2) is scheduled to be released today. Not much has changed; with the exception of one major fix. Image Thumbnail Storage &#8211; A &#8220;Recurring&#8221; Issue The WP Edit Pro File Manager was originally coded to store thumbnails [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/107879672/wpeditpro,https%3a%2f%2fwpeditpro.com%2fwp-content%2fuploads%2f2015%2f08%2fwpep_bonus_tab.png\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4023:\"<h2>WP Edit Pro File Manager Version 3.2</h2>\r\n<p>A new version of the WP Edit Pro File Manager (Version 3.2) is scheduled to be released today.  Not much has changed; with the exception of one major fix.</p>\r\n<h3>Image Thumbnail Storage &#8211; A &#8220;Recurring&#8221; Issue</h3>\r\n<p>The WP Edit Pro File Manager was originally coded to store thumbnails of uploaded images in the &#8220;wp-content/uploads&#8221; directory.  This is the ideal place for plugins and themes to store user uploaded items.</p>\r\n<p>However, the core File Manager code suggested NOT to store thumbnails in the same directory where the images themselves were uploaded.  Well&#8230; Oops.  It caused an issue where multiple layers of folders were being created on the server side.  Each time the File Manager was initiated; another layer of folders were added.  This could quickly become very resource intensive.</p>\r\n<h4>The Solution</h4>\r\n<p>The solution was to move the thumbnail folder out of the &#8220;wp-content/uploads&#8221; directory.  The folder now resides at &#8220;wp-content/wp_edit_pro_file_manager_thumbs&#8221;.</p>\r\n<h4>What About My Old Thumbnail Images?</h4>\r\n<p>It is recommended to move the thumbnail images out of their old location; and into the new location.</p>\r\n<p>Navigate to the &#8220;wp-content/uploads&#8221; directory.  Look for a folder named &#8220;thumbs&#8221;.  Copy the images from the &#8220;thumbs&#8221; folder; and paste them into the &#8220;wp-content/wp_edit_pro_file_manager_thumbs&#8221; folder.</p>\r\n<h3>Set Aviary Editing Skin</h3>\r\n<p>A new option has been added to select between a &#8220;light&#8221; and a &#8220;dark&#8221; skin when using the Aviary image editing tools.</p>\r\n<h3>WP Edit Pro Bonus Menu</h3>\r\n<p>The WP Edit Pro &#8220;Bonus&#8221; menu has been altered a bit.  As far as I can tell; there is no code to network deactivate a plugin.  This was interfering when activating/deactivating the File Manager (or other future bonus addons).</p>\r\n<p>The buttons to &#8220;Activate&#8221; and &#8220;Deactivate&#8221; have been removed.  Instead, after installing the File Manager, please visit the admin &#8220;Plugins&#8221; page to activate or deactivate the plugin.</p>\r\n<p><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/08/wpep_bonus_tab.png\"><img src=\"https://wpeditpro.com/wp-content/uploads/2015/08/wpep_bonus_tab.png\" alt=\"wpep_bonus_tab\" width=\"1097\" height=\"113\" class=\"alignnone size-full wp-image-1731\" /></a></p>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/107879672/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/107879672/wpeditpro,https%3a%2f%2fwpeditpro.com%2fwp-content%2fuploads%2f2015%2f08%2fwpep_bonus_tab.png\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/107879672/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://feeds.feedblitz.com/~/107879672/0/wpeditpro~WP-Edit-Pro-File-Manager-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpeditpro.com/wp-edit-pro-version-4-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WP Edit Pro Version 4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://feeds.feedblitz.com/~/107868396/0/wpeditpro~WP-Edit-Pro-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://feeds.feedblitz.com/~/107868396/0/wpeditpro~WP-Edit-Pro-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Aug 2015 19:04:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1708\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1651:\"WP Edit Pro Version 4.0 WP Edit Pro version 4.0 is scheduled to be released later today. In this new version; the code has been completely updated. Converting Options VERY IMPORTANT!! The new WP Edit Pro uses a single options array for storing options in the database. This will help tremendously with page load times. [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/107868396/wpeditpro,https%3a%2f%2fwpeditpro.com%2fwp-content%2fuploads%2f2015%2f08%2fconvert_opts.png\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10252:\"<h2>WP Edit Pro Version 4.0</h2>\r\n<p>WP Edit Pro version 4.0 is scheduled to be released later today.  In this new version; the code has been completely updated.</p>\r\n<h3>Converting Options</h3>\r\n<p><span style=\"color:red;font-weight:bold;\">VERY IMPORTANT!!</span></p>\r\n<p>The new WP Edit Pro uses a single options array for storing options in the database.  This will help tremendously with page load times.  Instead of making multiple calls to the database to grab options; a single call is made when the plugin is loaded.</p>\r\n<p><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/08/convert_opts.png\"><img src=\"https://wpeditpro.com/wp-content/uploads/2015/08/convert_opts.png\" alt=\"convert_opts\" width=\"901\" height=\"140\" class=\"alignnone size-full wp-image-1714\" /></a></p>\r\n<p>When you first visit the WP Edit Pro 4.0 admin page; a notice will appear asking to &#8220;Convert Options&#8221;.  Please convert the options.  If it is a network install; the options will need to be converted for each sub-site.</p>\r\n<h3>Network Administration</h3>\r\n<p>Most of the new features have been added to network activated installations.  Now, when WP Edit Pro is network activated, the plugin will &#8220;adjust&#8221; the settings which are loaded onto the page.  This allows a network admin to administer each sub-site options directly from the WP Edit Pro settings page.</p>\r\n<p>A new tab has been added named &#8220;Network&#8221;.  These options are only available when the plugin is network activated.  A network admin can select the sub-site to administer from the dropdown box under the &#8220;Network&#8221; tab (more below).  Once the options have been configured and saved; simply click the button to cancel editing the sub-site options.</p>\r\n<p>Each of the sub-site options are stored in the corresponding sub-sites &#8220;wp_options&#8221; table.  So, when users visit that site; those corresponding options are loaded.  This allows each sub-site to have independent WP Edit Pro settings.</p>\r\n<p><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/08/network_tab.png\"><img src=\"https://wpeditpro.com/wp-content/uploads/2015/08/network_tab.png\" alt=\"network_tab\" width=\"568\" height=\"448\" class=\"alignnone size-full wp-image-1716\" /></a></p>\r\n<h3>Selecting Sub-Sites</h3>\r\n<p>From the &#8220;Network&#8221; tab, when network activated, the administrator can select the administration mode.  Possible modes are &#8220;Same&#8221; and &#8220;Separate&#8221;.</p>\r\n<p>When set to &#8220;Same&#8221;; all sub-sites will use the options stored in the &#8220;wp_sitemeta&#8221; table.  This means, all sub-sites will use the same options that are appearing on the WP Edit Pro settings page.</p>\r\n<p>When set to &#8220;Separate&#8217;; a dropdown selector will become available which will allow selection between sub-sites.  First, select the sub-site; it&#8217;s corresponding options will be loaded into the WP Edit Pro settings page.  Now, administer the sub-site settings just like normal.  When finished; click the button at the top of the WP Edit Pro settings page, &#8220;Cancel Editing Options&#8221;.  This mode allows each sub-site to use independent plugin settings.</p>\r\n<p>It is important to click the button to &#8220;Cancel Editing Options&#8221; when editing sub-site options.  A jQuery alert has been placed in the code to alert the user if they are trying to navigate away from the WP Edit Pro settings page before canceling the sub-site editing options.</p>\r\n<h3>Creating New Editors</h3>\r\n<p>WP Edit Pro version 4.0 introduces a new method for managing created editors.  The old option of selecting &#8220;custom roles&#8221; or &#8220;WordPress roles&#8221; has been removed.  There is no longer a need to have to select between those modes.</p>\r\n<p>Instead, a new editor can be created directly from the &#8220;Buttons&#8221; tab.  There are four types of editors that can be created:</p>\r\n<ol>\r\n<li>WordPress Role Editors &#8211; These are for WordPress roles.  Each role can have a separate set of buttons.  Custom roles will also appear here.</li>\r\n<li>WordPress Capability Editors &#8211; These are for WordPress capabilities.  Each capability can have a separate set of buttons.  Custom capabilities will also appear here.</li>\r\n<li>WordPress User Editors &#8211; These are for specific WordPress users.  Each user can have a separate set of buttons.</li>\r\n<li>WordPress Visitor Editor &#8211; An additional editor can also be created for site visitors; or non-logged in users.  (Used for front-end editors)</li>\r\n</ol>\r\n<h4>Editor Hierarchy</h4>\r\n<p>There is a hierarchy to how editors are displayed to users.</p>\r\n<p>Say an editor has been created for a user; but an editor has also been created for that users role.  In this case; the users personal editor will &#8220;trump&#8221; the editor created for the users role.</p>\r\n<p>Another instance might be an editor is created for both a users role and the users capability.  In this case; the users capability editor will &#8220;trump&#8221; the users role editor.</p>\r\n<p>Think of it in terms of specificity to the user.  The role editors are the most broad&#8230; so they less user specific.  The user editors are most user specific; and if created for a user, will trump both a capability editor and a role editor.</p>\r\n<h4>Capability Editors Sorting</h4>\r\n<p>When two or more capability editors have been created; they can be sorted in the &#8220;Created Editors&#8221; table (below the button configuration settings).</p>\r\n<p>WordPress users can have multiple capabilities.  If multiple capability editors are created; and a user exists in two or more of the capabilities; the one listed towards the top of the sortable list will be used.</p>\r\n<p><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/08/sorted_caps.png\"><img src=\"https://wpeditpro.com/wp-content/uploads/2015/08/sorted_caps.png\" alt=\"sorted_caps\" width=\"977\" height=\"343\" class=\"alignnone size-full wp-image-1718\" /></a></p>\r\n<h3>Editor Custom Colors</h3>\r\n<p>A new feature has been added (&#8220;Editor&#8221; tab) which allows creation of custom colors to be saved.  These saved colors will appear when clicking the &#8220;Font Color&#8221; button; making it easy to quickly apply a custom color to selected text.</p>\r\n<p><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/08/custom_colors.png\"><img src=\"https://wpeditpro.com/wp-content/uploads/2015/08/custom_colors.png\" alt=\"custom_colors\" width=\"937\" height=\"97\" class=\"alignnone size-full wp-image-1721\" /></a></p>\r\n<h3>Editor Stylesheet</h3>\r\n<p>The editor stylesheet (&#8220;Styles&#8221; tab) is now saved in the WordPress &#8220;wp-content/uploads&#8221; directory.  It has been moved out of the plugin directory.  This is because when located in the plugin directory; the file is being over-written with each plugin update.</p>\r\n<p>If there is custom CSS in this editor; please save the editor stylesheet again, so it will be added to the new location.</p>\r\n<h3>User Options</h3>\r\n<p>Another feature update is the ability to allow different user roles to access the &#8220;User Specific&#8221; options.  After selecting which user roles should have access; a new admin menu item will be added to that users role, allowing them to access and change the user specific options independently.</p>\r\n<p><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/08/user_opts.png\"><img src=\"https://wpeditpro.com/wp-content/uploads/2015/08/user_opts.png\" alt=\"user_opts\" width=\"903\" height=\"248\" class=\"alignnone size-full wp-image-1723\" /></a></p>\r\n<h3>Database Options</h3>\r\n<p>The &#8220;Import Options&#8221; and &#8220;Export Options&#8221; now work with the new single array of options.  Please do not attempt to &#8220;Import&#8221; a file that was exported using the old options configuration.  This may result in unexpected behavior.</p>\r\n<p>Instead, first convert the options (explained above), and then &#8220;Export&#8221; the settings again (so it will use the new configuration).  This can then be imported successfully.</p>\r\n<h3>File Manager New Update</h3>\r\n<p>The Responsive File Manager will also be updated today or tomorrow.  A separate post will be written to explain the changes and adjustments.</p>\r\n<h3>Reporting Bugs</h3>\r\n<p>As always, please use the plugin <a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~forum.wpeditpro.com\" target=\"_blank\">Support Forum</a> to report any bugs.  Your time in this matter is most appreciated; as it will help solidify the plugin code.</p>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/107868396/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/107868396/wpeditpro,https%3a%2f%2fwpeditpro.com%2fwp-content%2fuploads%2f2015%2f08%2fconvert_opts.png\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/107868396/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://feeds.feedblitz.com/~/107868396/0/wpeditpro~WP-Edit-Pro-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wpeditpro.com/wp-edit-pro-version-4-0-pre-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WP Edit Pro Version 4.0 Pre-Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://feeds.feedblitz.com/~/107356986/0/wpeditpro~WP-Edit-Pro-Version-PreRelease/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://feeds.feedblitz.com/~/107356986/0/wpeditpro~WP-Edit-Pro-Version-PreRelease/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Aug 2015 00:21:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1702\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1537:\"WP Edit Pr 4.0 Soon to be Released WP Edit Pro 4.0 is scheduled to be released in the next couple of days. This release takes the old WP Edit Pro; and injects a completely new user experience. The older WP Edit Pro had a few issues with network administration. This has been updated in [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/107356986/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4752:\"<h2>WP Edit Pr 4.0 Soon to be Released</h2>\r\n<div class = \"alert alert-info \">Testers Needed!!  Please scroll down for more information.</div>\r\n<p>WP Edit Pro 4.0 is scheduled to be released in the next couple of days. This release takes the old WP Edit Pro; and injects a completely new user experience.</p>\r\n<p>The older WP Edit Pro had a few issues with network administration. This has been updated in the new WP Edit Pro. When network activated; the super admin can &#8220;switch&#8221; between subsites to administer their settings individually.</p>\r\n<p>Also, most of the functions, hooks and filters have been moved into a single plugin class. This will help tremendously with loading times, and also allow custom filters to be added; changing the functionality of some of the options.</p>\r\n<h3>New Features</h3>\r\n<p>So what to expect from WP Edit Pro 4.0?</p>\r\n<ul>\r\n<li>Updated network administration to allow independent subsite administration (each subsite can have different options).</li>\r\n<li>Code improvements. WP Edit Pro 4.0 uses a Singleton class for most all functions.</li>\r\n<li>Newly updated administration mode.\r\n<ul>\r\n<li>When switching between different subsite options; those options are stored to the corresponding subsite.</li>\r\n<li>When users are on that subsite; they use the independent subsite options.</li>\r\n</ul>\r\n</li>\r\n<li>New mode for administering button arrangements.\r\n<ul>\r\n<li>Create different button arrangements by user role.</li>\r\n<li>Create different button arrangements by user capability.</li>\r\n<li>Create different button arrangements for each user.</li>\r\n</ul>\r\n</li>\r\n<li>This new button administration system gives complete control over which users have access to which buttons.</li>\r\n<li>Options are now stored in a single option entry; which expedites the loading and execution of the plugin.\r\n<ul>\r\n<li>Options will need to be converted to the new option array. Users will be prompted to convert their options.</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<h3>Removed Options</h3>\r\n<p>Two options have been removed from WP Edit Pro 4.0.</p>\r\n<ol>\r\n<ol>\r\n<li>PHP Widgets &#8211; This option introduces a potential security risk whereby a user could insert malicious code into the system.</li>\r\n<li>Disable wpautop &#8211; With the update to WordPress 4.3; the wpautop filter is no longer used. More below&#8230;</li>\r\n</ol>\r\n</ol>\r\n<h3>Disable wpatuop</h3>\r\n<p>The php function used by WordPress to prevent the removal of p and br tags, wpautop, has been deprecated. WordPress now uses a javascript function to process the editor contents during a save or when switching editor views (visual and text).</p>\r\n<p>I will be working diligently to provide an improved solution. The original function to disable the wpautop filter was hackish as best, anyways. A very immediate future update of WP Edit Pro will include an improved system for handling p and br tags.</p>\r\n<h3>Testers Needed!!!</h3>\r\n<p>Do you like what you hear so far? If so, I could definitely use your help!! This update is a major revision to WP Edit Pro. With over 20,000 lines of code, a bug is going to inevitably slip through. Your help in squashing these bugs prior to public release would be most appreciated.</p>\r\n<p>Please contact me using the form on this site; and I will send the beta version along with instructions.</p>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/107356986/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/107356986/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/107356986/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://feeds.feedblitz.com/~/107356986/0/wpeditpro~WP-Edit-Pro-Version-PreRelease/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpeditpro.com/wp-edit-pro-version-3-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WP Edit Pro Version 3.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://feeds.feedblitz.com/~/96265864/0/wpeditpro~WP-Edit-Pro-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://feeds.feedblitz.com/~/96265864/0/wpeditpro~WP-Edit-Pro-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jun 2015 23:43:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1650\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1556:\"WP Edit Pro Version 3.7 WP Edit Pro version 3.7 is being released June 16th, 2015. This update fixes one small bug; enhances a few of the popup dialogs; and brings about two new features. WP Edit Pro Styles &#038; Scripts This update contains the Styles and Scripts features. These features will allow the user [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/96265864/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2776:\"<h2>WP Edit Pro Version 3.7</h2>\r\n<p>WP Edit Pro version 3.7 is being released June 16th, 2015.  This update fixes one small bug; enhances a few of the popup dialogs; and brings about two new features.</p>\r\n<h3>WP Edit Pro Styles &#038; Scripts</h3>\r\n<p>This update contains the Styles and Scripts features.  These features will allow the user to insert global CSS and JS; and/or individual page CSS and JS.  The features are intended to allow an easy method to add custom CSS or JS where needed.</p>\r\n<p>Please read the full article on <a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~learn.wpeditpro.com/styles-scripts/\" target=\"_blank\">WP Edit Pro Styles and Scripts</a> from our Knowledge Base.</p>\r\n<h3>Custom Post Type Excerpts</h3>\r\n<p>Another new feature is the added ability to use the WP Edit Pro buttons configuration on custom post type excerpts.  There has always been the option to add WP Edit Pro to the excerpts of posts and pages; but now custom post types are also supported.</p>\r\n<p>The new option can be found on the &#8220;General&#8221; tab; under &#8220;Excerpts&#8221;.</p>\r\n<h3>Closing</h3>\r\n<p>The rest of the changes are small; and do not affect user experience.  Please read the <a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/changelog/\">changelog</a> for a full list of changes to this version.</p>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/96265864/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/96265864/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/96265864/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://feeds.feedblitz.com/~/96265864/0/wpeditpro~WP-Edit-Pro-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpeditpro.com/wp-edit-pro-version-3-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WP Edit Pro Version 3.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://feeds.feedblitz.com/~/92916716/0/wpeditpro~WP-Edit-Pro-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://feeds.feedblitz.com/~/92916716/0/wpeditpro~WP-Edit-Pro-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 May 2015 02:21:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP Edit Pro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1637\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1584:\"WP Edit Pro Version 3.6 YouTube Update In this release; we say goodbye to the old YouTube button (it served us well)&#8230; and introduce a brand new YouTube button. The developers API was updated by YouTube; and crashed all applications still using the older API (apologies for any inconveniences). The button has been completed updated. [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/92916716/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3058:\"<h2>WP Edit Pro Version 3.6</h2>\r\n<h3>YouTube Update</h3>\r\n<p>In this release; we say goodbye to the old YouTube button (it served us well)&#8230; and introduce a brand new YouTube button.</p>\r\n<p>The developers API was updated by YouTube; and crashed all applications still using the older API (apologies for any inconveniences).</p>\r\n<p>The button has been completed updated. It still resembles the older button in terms of usage, but it also has a couple of new features.  To learn more about the new YouTube button, be sure to read the associated <a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~learn.wpeditpro.com/youtube-button/\" target=\"_blank\">Knowledge Base YouTube Button</a> article.</p>\r\n<h3>DropBox Integration</h3>\r\n<p>Also new in this version is a button which integrates with DropBox. DropBox files can be browsed and inserted directly into the content editor.</p>\r\n<p>Using DropBox requires an App key.  It&#8217;s free; and easy to obtain.  Full instructions (with pictures) can be found on the <a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~learn.wpeditpro.com/dropbox-create-web-application/\" target=\"_blank\">Knowledge Base DropBox App</a> page.</p>\r\n<h3>Coding Enhancements</h3>\r\n<p>The rest of the changes have to do with coding modifications.</p>\r\n<ul>\r\n<li>Optimized code to use the Singleton Class pattern; which is becoming more and more widespread with WordPress developers.</li>\r\n<li>Cleared a loop memory leak; where multiple instances of the plugin were being created (thanks Singleton Pattern!).</li>\r\n<li>Fixed a cookie issue where the user would be logged out of the site repetitively.</li>\r\n</ul>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/92916716/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/92916716/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/92916716/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://feeds.feedblitz.com/~/92916716/0/wpeditpro~WP-Edit-Pro-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpeditpro.com/wp-edit-pro-version-3-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WP Edit Pro Version 3.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://feeds.feedblitz.com/~/87451031/0/wpeditpro~WP-Edit-Pro-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://feeds.feedblitz.com/~/87451031/0/wpeditpro~WP-Edit-Pro-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 22 Mar 2015 02:36:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1612\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1656:\"WP Edit Pro Version 3.5 This update is important; because it includes updated code necessary to run the updated File Manager bonus plugin. File Manager Update The File Manager bonus plugin has been updated to version 3.1. It will be necessary to manually deactivate and delete the old version; and manually install and activate the [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/87451031/wpeditpro,https%3a%2f%2fwpeditpro.com%2fwp-content%2fuploads%2f2015%2f03%2fadd_media3.png\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3925:\"<h2>WP Edit Pro Version 3.5</h2>\r\n<p>This update is important; because it includes updated code necessary to run the updated File Manager bonus plugin.</p>\r\n<h3>File Manager Update</h3>\r\n<p>The File Manager bonus plugin has been updated to version 3.1.  It will be necessary to manually deactivate and delete the old version; and manually install and activate the new version.</p>\r\n<p>This can be done via the &#8220;Bonus&#8221; sub-menu page of WP Edit Pro.</p>\r\n<p>The update to the File Manager Plugin includes:</p>\r\n<ul>\r\n<li>Updated file manager to 9.9.2.</li>\r\n<li>Added option to allow sub-sites access to ONLY their respective WP Content uploads folder.</li>\r\n<li>Fixed &#8220;settings&#8221; link on plugins page when network activated.</li>\r\n<li>Added new menu page for File Manager options.</li>\r\n<li>Finalized language translation strings.</li>\r\n<li>Added tabs for options administration (settings page).</li>\r\n<li>Added multiple options for controlling various parts of the File Manager configuration.</li>\r\n<li>Added options for allowable file types.</li>\r\n<li>Added auto-update code; so future updates can be administered via the WP panel.</li>\r\n</ul>\r\n<h3>Add Media Button Update</h3>\r\n<p>A few new options have also been added to the &#8220;Editor&#8221; tab.</p>\r\n<p>These options apply to the &#8220;Add Media&#8221; button; just above the content editor.</p>\r\n<p>Options can now be set to control the default values used for media alignment, link and type.</p>\r\n<div id=\"attachment_1622\" style=\"width: 618px\" class=\"wp-caption alignnone\"><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/03/add_media3.png\"><img src=\"https://wpeditpro.com/wp-content/uploads/2015/03/add_media3.png\" alt=\"WP Edit Pro Add Media Options\" width=\"608\" height=\"269\" class=\"size-full wp-image-1622\" /></a><p class=\"wp-caption-text\">WP Edit Pro Add Media Options</p></div>\r\n<div style=\"margin-top:20px;\"></div>\r\n<div id=\"attachment_1616\" style=\"width: 302px\" class=\"wp-caption alignnone\"><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/03/add_media2.png\"><img src=\"https://wpeditpro.com/wp-content/uploads/2015/03/add_media2.png\" alt=\"Add Media Attachment Settings\" width=\"292\" height=\"243\" class=\"size-full wp-image-1616\" /></a><p class=\"wp-caption-text\">Add Media Attachment Settings</p></div>\r\n<div style=\"margin-top:20px;\"></div>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/87451031/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/87451031/wpeditpro,https%3a%2f%2fwpeditpro.com%2fwp-content%2fuploads%2f2015%2f03%2fadd_media3.png\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/87451031/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://feeds.feedblitz.com/~/87451031/0/wpeditpro~WP-Edit-Pro-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpeditpro.com/wp-edit-pro-version-3-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WP Edit Pro Version 3.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://feeds.feedblitz.com/~/87450332/0/wpeditpro~WP-Edit-Pro-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://feeds.feedblitz.com/~/87450332/0/wpeditpro~WP-Edit-Pro-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 22 Mar 2015 02:18:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1609\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1587:\"WP Edit Pro Version 3.4 This is a short, sweet update. Just a couple of bug fixes; and one alteration to one of the default values. Fixed an array-merge php notice when custom fonts where enabled; but no custom fonts were defined. Fixed a console notice loading the &#8220;wpeditpro_custom_fonts.css&#8221; file. Added checks to determine if [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/87450332/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2132:\"<h2>WP Edit Pro Version 3.4</h2>\r\n<p>This is a short, sweet update.</p>\r\n<p>Just a couple of bug fixes; and one alteration to one of the default values.</p>\r\n<ul>\r\n<li>Fixed an array-merge php notice when custom fonts where enabled; but no custom fonts were defined.</li>\r\n<li>Fixed a console notice loading the &#8220;wpeditpro_custom_fonts.css&#8221; file.</li>\r\n<li>Added checks to determine if css files exist; before attempting to add them to the admin area and editor.</li>\r\n</ul>\r\n<p>We also changed the default value for the &#8220;button administration&#8221; option when the plugin is activated.  The old value was set to &#8220;User Roles&#8221;.  This has been switched to &#8220;WordPress Roles&#8221;.</p>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/87450332/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/87450332/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/87450332/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://feeds.feedblitz.com/~/87450332/0/wpeditpro~WP-Edit-Pro-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpeditpro.com/wp-edit-pro-version-3-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WP Edit Pro Version 3.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://feeds.feedblitz.com/~/87248287/0/wpeditpro~WP-Edit-Pro-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://feeds.feedblitz.com/~/87248287/0/wpeditpro~WP-Edit-Pro-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Mar 2015 04:11:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1596\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1581:\"WP Edit Pro Version 3.3 WP Edit Pro version 3.3 was released today, March 18th, 2015. Activation and Update Scripts The main focus of this release was to optimize the code used for plugin activations and plugin updates. Prior to this version; the outdated mysql syntax was being used (server-side) to verify plugin license information. [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/87248287/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3106:\"<h2>WP Edit Pro Version 3.3</h2>\r\n<p>WP Edit Pro version 3.3 was released today, March 18th, 2015.</p>\r\n<h3>Activation and Update Scripts</h3>\r\n<p>The main focus of this release was to optimize the code used for plugin activations and plugin updates.</p>\r\n<p>Prior to this version; the outdated mysql syntax was being used (server-side) to verify plugin license information.  Now, we are using the updated <a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~php.net/manual/en/ref.pdo-mysql.php\" title=\"mysql pdo\" target=\"_blank\">mysql pdo</a> syntax; which is more reliable and much faster.</p>\r\n<p>We had numerous reports of the plugin update notices displaying improperly in the last update (3.2).  We believe the outdated syntax being used contributed to the issue.  By updating to mysql pdo; we hope to resolve plugin update issues permanently.</p>\r\n<h3>Plugin License Buttons</h3>\r\n<p>Two new buttons have been added to the &#8220;License&#8221; page.</p>\r\n<p>The &#8220;Manage License&#8221; button is simply a direct link to the WP Edit Pro website; where plugin activations can be managed and removed.</p>\r\n<p>The &#8220;Remove This Activation&#8221; button will remove the site activation from the database; allowing single license and single extended license owners to activate the license on another site.</p>\r\n<h3>Questions</h3>\r\n<p>As always; if any assistance is needed, please <a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~forum.wpeditpro.com\" title=\"WP Edit Pro Forum\" target=\"_blank\">Create a Support Topic</a> or <a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/contact/\" title=\"WP Edit Pro Contact\" target=\"_blank\">Contact Us</a>.</p>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/87248287/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/87248287/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/87248287/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://feeds.feedblitz.com/~/87248287/0/wpeditpro~WP-Edit-Pro-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpeditpro.com/wp-edit-pro-version-3-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WP Edit Pro Version 3.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://feeds.feedblitz.com/~/87014720/0/wpeditpro~WP-Edit-Pro-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://feeds.feedblitz.com/~/87014720/0/wpeditpro~WP-Edit-Pro-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 15 Mar 2015 01:23:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1583\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1568:\"Version 3.2 of WP Edit Pro will be released today, March 15, 2015. WP Pointer A WP Pointer has been added to the post/page editor screen. The notice will inform new users of the Toggle Toolbar button. Simply clicking the button to dismiss the pointer will hide it, permanently. Column Sizes Shortcode The column shortcodes [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/87014720/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3772:\"<p>Version 3.2 of WP Edit Pro will be released today, March 15, 2015.</p>\r\n<h3>WP Pointer</h3>\r\n<p>A WP Pointer has been added to the post/page editor screen.  The notice will inform new users of the Toggle Toolbar button.</p>\r\n<p>Simply clicking the button to dismiss the pointer will hide it, permanently.</p>\r\n<h3>Column Sizes Shortcode</h3>\r\n<p>The column shortcodes button was missing a few column layouts.  These have been added.</p>\r\n<h3>Editor Custom Fonts</h3>\r\n<p>A new section has been added to the &#8220;Fonts&#8221; tab; which allows uploading of custom fonts.  These fonts will then appear in the &#8220;Font Select&#8221; editor dropdown box.</p>\r\n<p>Fonts will also be rendered properly both inside the content editor; and on the front-end of the website.</p>\r\n<p>Fonts should have .otf, .ttf, .woff or .woff2 file extensions.</p>\r\n<h3>Removed Editor Font Size Selection</h3>\r\n<p>Prior to this new release; there was an option under the &#8220;Editor&#8221; tab; which allowed selection between &#8220;pt&#8221; or &#8220;px&#8221; font sizes.</p>\r\n<p>This has been completely removed; and replaced with a radio selection where the user can select between &#8220;pt&#8221;, &#8220;px&#8221;, &#8220;em&#8221; or &#8220;%&#8221;.</p>\r\n<h3>Font Size Input Field</h3>\r\n<p>An input field has also been added where the font size selections can be defined.</p>\r\n<p>For example, if &#8220;px&#8221; is chosen as the desired font size type; the user can also define &#8220;12px,14px,16px&#8221; as available sizes; and only these sizes will be available in the editor.</p>\r\n<h3>Set and Unset wpautop</h3>\r\n<p>Since all posts/pages and custom post types include a checkbox for disabling the wpautop filter; new buttons have been added to check or uncheck all posts/pages and custom post types with a single click.</p>\r\n<h3>License Expiration Notice</h3>\r\n<p>This notice will be shown when plugin updates have expired.  The notice will be suppressed if a license extension is found.</p>\r\n<p>The notice can be clicked to be dismissed permanently.</p>\r\n<h3>Profile Description Editor</h3>\r\n<p>The code for the profile description editor has been updated.</p>\r\n<h3>Updated Mailto Button</h3>\r\n<p>The mailto editor button has been updated to include other options such as &#8220;CC&#8221;, &#8220;BCC&#8221;, &#8220;To&#8221; and &#8220;Subject&#8221;.</p>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/87014720/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/87014720/wpeditpro,\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/87014720/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://feeds.feedblitz.com/~/87014720/0/wpeditpro~WP-Edit-Pro-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n\n		\n		\n		\n		\n		\n				\n		\n		\n				\n			\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpeditpro.com/wp-edit-pro-version-3-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WP Edit Pro Version 3.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"http://feeds.feedblitz.com/~/83385854/0/wpeditpro~WP-Edit-Pro-Version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://feeds.feedblitz.com/~/83385854/0/wpeditpro~WP-Edit-Pro-Version/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jan 2015 17:29:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpeditpro.com/?p=1440\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1642:\"We have some exciting new features in this version of WP Edit Pro: Roles can now be administered using WordPress Roles, or Custom Roles. The rich text editor can now be added to the front-end comment area (works with replies too!). A new button for inserting HTML tags. Image maps are now responsive. File Manager [&#8230;]<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/83385854/wpeditpro,https%3a%2f%2fwpeditpro.com%2fwp-content%2fuploads%2f2015%2f01%2fcomment_editor.png\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Josh Lobe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4452:\"<p>We have some exciting new features in this version of WP Edit Pro:</p>\r\n<ul>\r\n<li>Roles can now be administered using WordPress Roles, or Custom Roles.</li>\r\n<li>The rich text editor can now be added to the front-end comment area (works with replies too!).</li>\r\n<li>A new button for inserting HTML tags.</li>\r\n<li>Image maps are now responsive.</li>\r\n<li>File Manager bonus plugin updated.</li>\r\n</ul>\r\n<h3>User Roles</h3>\r\n<p>The method used for administering buttons can now be selected.\r\n<br>\r\nThe two options include Custom Roles and WordPress roles.</p>\r\n<p>This option can be found on the WP Edit Pro settings page (Global Tab).</p>\r\n<h4>Custom Roles</h4>\r\n<p>This option will allow creation of multiple editors.\r\n<br>\r\nThese editors (roles) can then be assigned to individual users by using a plugin such as User Role Manager.</p>\r\n<h4>WordPress Roles</h4>\r\n<p>This option will enable an editor for each available WordPress role.\r\n<br>\r\nEach users role will use the corresponding editor buttons.</p>\r\n<h3>Comment Editor</h3>\r\n<p>I am proud to announce I now have the rich text editor working in the front-end comment area.\r\n<br>\r\nThe final hurdle was keeping a working editor when a comment reply was canceled.\r\n<br>\r\nFinally, we have a nice user-friendly rich text editor for our commenting guests!</p>\r\n<p><a href=\"http://feeds.feedblitz.com/~/t/0/0/wpeditpro/~https://wpeditpro.com/wp-content/uploads/2015/01/comment_editor.png\"><img class=\"alignnone size-full wp-image-1441\" src=\"https://wpeditpro.com/wp-content/uploads/2015/01/comment_editor.png\" alt=\"comment_editor\" width=\"667\" height=\"733\" /></a></p>\r\n<p>The option to enable the front-end comment editor can be found on the WP Edit Pro settings page (Posts/Pages Tab).</p>\r\n<div class = \"alert alert-info \">It is up to the theme developer to determine how to use the WordPress comment system. Each theme may display differently. Some CSS adjustment may be necessary for the editor to appear properly.</div>\r\n<h3>HTML Tags</h3>\r\n<p>A new button for inserting HTML tags has been added.</p>\r\n<div class = \"alert alert-info \">Remember, &#8220;Saving&#8221; the buttons will automatically check for any new buttons added to WP Edit Pro.</div>\r\n<h3>Responsive Image Maps</h3>\r\n<p>Thanks to one WP Edit Pro user; a new script has been added to the plugin which will allow the image maps to be responsive.</p>\r\n<p>The script is small, clean and does a great job.</p>\r\n<p>There is no need to configure anything.  The script will run automatically on any page that uses an image map in the content.</p>\r\n<h3>File Manager Bonus Plugin</h3>\r\n<p>The File Manager bonus plugin has been updated.</p>\r\n<p>To update the File Manager plugin, visit the WP Edit Pro (Bonus) admin menu page.</p>\r\n<ol>\r\n<li>Deactivate, then uninstall the File Manager plugin.</li>\r\n<li>Install, then activate the File Manager plugin.</li>\r\n<li>Confirm the plugin has been updated to version 3.0.</li>\r\n</ol>\r\n<p>&nbsp;</p>\r\n<Img align=\"left\" border=\"0\" height=\"1\" width=\"1\" alt=\"\" style=\"border:0;float:left;margin:0;padding:0\" hspace=\"0\" src=\"http://feeds.feedblitz.com/~/i/83385854/0/wpeditpro\">\r\n<div style=\"clear:both;padding-top:0.2em;\"><a title=\"Like on Facebook\" href=\"http://feeds.feedblitz.com/_/28/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/fblike20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Share on Google+\" href=\"http://feeds.feedblitz.com/_/30/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/googleplus20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Pin it!\" href=\"http://feeds.feedblitz.com/_/29/83385854/wpeditpro,https%3a%2f%2fwpeditpro.com%2fwp-content%2fuploads%2f2015%2f01%2fcomment_editor.png\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/pinterest20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Tweet This\" href=\"http://feeds.feedblitz.com/_/24/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/twitter20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by email\" href=\"http://feeds.feedblitz.com/_/19/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/email20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;<a title=\"Subscribe by RSS\" href=\"http://feeds.feedblitz.com/_/20/83385854/wpeditpro\"><img height=\"20\" src=\"http://assets.feedblitz.com/i/rss20.png\" style=\"border:0;margin:0;padding:0;\"></a>&#160;</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://feeds.feedblitz.com/~/83385854/0/wpeditpro~WP-Edit-Pro-Version/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:26:\"http://wpeditpro.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:8:{s:13:\"cache-control\";s:12:\"max-age=1800\";s:14:\"content-length\";s:5:\"67474\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:34:\"\"c12b7a3a6fb2033f1602e7e71704f649\"\";s:6:\"server\";s:17:\"Microsoft-IIS/7.5\";s:12:\"x-powered-by\";s:7:\"ASP.NET\";s:4:\"date\";s:29:\"Wed, 26 Aug 2015 08:11:15 GMT\";s:10:\"connection\";s:5:\"close\";}s:5:\"build\";s:14:\"20150821144050\";}", "no");
INSERT INTO `eadsk_options` VALUES("2611", "_transient_timeout_feed_mod_831fe7759a8f11bf56457f189e650ca4", "1440619872", "no");
INSERT INTO `eadsk_options` VALUES("2612", "_transient_feed_mod_831fe7759a8f11bf56457f189e650ca4", "1440576672", "no");
INSERT INTO `eadsk_options` VALUES("2613", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1440619882", "no");
INSERT INTO `eadsk_options` VALUES("2614", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Aug 2015 13:10:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://wordpress.org/?v=4.4-alpha-33729\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 4.3 “Billie”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2015/08/billie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/08/billie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Aug 2015 19:12:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3845\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:352:\"Version 4.3 of WordPress, named &#8220;Billie&#8221; in honor of jazz singer Billie Holiday, is available for download or update in your WordPress dashboard. New features in 4.3 make it even easier to format your content and customize your site. Menus in the Customizer Create your menu, update it, and assign it, all while live-previewing in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:21786:\"<p style=\"margin: 0;height: 0\"><img src=\"https://wordpress.org/news/files/2015/08/WordPress-4-3-billie-1024x574.png\" alt=\"WordPress 4.3 - &quot;Billie&quot;\" width=\"692\" height=\"388\" class=\"alignnone size-large wp-image-3896\" style=\"height:0px;width: 0px;margin: 0\" /></p>\n<p>Version 4.3 of WordPress, named &#8220;Billie&#8221; in honor of jazz singer <a href=\"https://en.wikipedia.org/wiki/Billie_Holiday\">Billie Holiday</a>, is available for <a href=\"https://wordpress.org/download/\">download</a> or update in your WordPress dashboard. New features in 4.3 make it even easier to format your content and customize your site.</p>\n<p><iframe width=\'692\' height=\'389\' src=\'https://videopress.com/embed/T54Iy7Tw?hd=1\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>\n<hr />\n<h2>Menus in the Customizer</h2>\n<div><img src=\"//s.w.org/images/core/4.3/menu-customizer.png\" alt=\"\" /></div>\n<p>Create your menu, update it, and assign it, all while live-previewing in the customizer. The streamlined customizer design provides a mobile-friendly and accessible interface. With every release, it becomes easier and faster to make your site just the way you want it.</p>\n<hr />\n<h2>Formatting Shortcuts</h2>\n<div style=\"margin-bottom: 0\"><div style=\"width: 640px; \" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-3845-1\" width=\"640\" height=\"360\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.3/formatting.mp4?_=1\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.3/formatting.webm?_=1\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.3/formatting.ogv?_=1\" /><a href=\"//s.w.org/images/core/4.3/formatting.mp4\">//s.w.org/images/core/4.3/formatting.mp4</a></video></div></div>\n<p>Your writing flow just got faster with new formatting shortcuts in WordPress 4.3. Use asterisks to create lists and number signs to make a heading. No more breaking your flow; your text looks great with a <code>*</code> and a <code>#</code>.</p>\n<hr />\n<h2>Site Icons</h2>\n<p><img src=\"//s.w.org/images/core/4.3/site-icon-customizer.png\" alt=\"\" /><br />\n&nbsp;<br />\nSite icons represent your site in browser tabs, bookmark menus, and on the home screen of mobile devices. Add your unique site icon in the customizer; it will even stay in place when you switch themes. Make your whole site reflect your brand.</p>\n<hr />\n<h2>Better Passwords</h2>\n<p><img src=\"//s.w.org/images/core/4.3/better-passwords.png\" alt=\"\" /><br />\n&nbsp;<br />\nKeep your site more secure with WordPress’ improved approach to passwords. Instead of receiving passwords via email, you’ll get a password reset link. When you add new users to your site or edit a user profile, WordPress will automatically generate a secure password.</p>\n<hr />\n<h2>Other improvements</h2>\n<ul>\n<li><strong>A smoother admin experience</strong> &#8211; Refinements to the list view across the admin make your WordPress more accessible and easier to work with on any device.</li>\n<li><strong>Comments turned off on pages</strong> &#8211; All new pages that you create will have comments turned off. Keep discussions to your blog, right where they’re supposed to happen.</li>\n<li><strong>Customize your site quickly</strong> &#8211; Wherever you are on the front-end, you can click the customize link in the toolbar to swiftly make changes to your site.</li>\n</ul>\n<hr />\n<h2>The Team</h2>\n<p><a class=\"alignleft\" href=\"https://profiles.wordpress.org/obenland\"><img src=\"https://www.gravatar.com/avatar/2370ea5912750f4cb0f3c51ae1cbca55?d=mm&amp;s=180&amp;r=G\" alt=\"Konstantin Obenland\" width=\"80\" height=\"80\" /></a>This release was led by <a href=\"http://konstantin.obenland.it/\">Konstantin Obenland</a>, with the help of these fine individuals. There are 246 contributors with props in this release. Pull up some Billie Holiday on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/mercime\">@mercime</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamkheckler\">Adam Heckler</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bjorklund</a>, <a href=\"https://profiles.wordpress.org/akirk\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/deconf\">Alin Marcu</a>, <a href=\"https://profiles.wordpress.org/andfinally\">andfinally</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andg\">Andrea Gandino</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/antpb\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/anubisthejackle\">anubisthejackle</a>, <a href=\"https://profiles.wordpress.org/aramzs\">Aram Zucker-Scharff</a>, <a href=\"https://profiles.wordpress.org/arjunskumar\">Arjun S Kumar</a>, <a href=\"https://profiles.wordpress.org/avnarun\">avnarun</a>, <a href=\"https://profiles.wordpress.org/brad2dabone\">Bad Feather</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/binarykitten\">BinaryKitten</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornjohansen\">Bjorn Johansen</a>, <a href=\"https://profiles.wordpress.org/bolo1988\">bolo1988</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradt\">Brad Touesnard</a>, <a href=\"https://profiles.wordpress.org/bramd\">Bram Duvigneau</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/brianlayman\">Brian Layman</a>, <a href=\"https://profiles.wordpress.org/icaleb\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/calevans\">CalEvans</a>, <a href=\"https://profiles.wordpress.org/chasewiseman\">Chase Wiseman</a>, <a href=\"https://profiles.wordpress.org/chipbennett\">Chip Bennett</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/c3mdigital\">Chris Olbekson</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/posykrat\">Clement Biron</a>, <a href=\"https://profiles.wordpress.org/craig-ralston\">Craig Ralston</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Mte90 Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/daniluk4000\">daniluk4000</a>, <a href=\"https://profiles.wordpress.org/dmchale\">Dave McHale</a>, <a href=\"https://profiles.wordpress.org/daveal\">DaveAl</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/daxelrod\">daxelrod</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipesh.kakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/kucrut\">Dzikri Aziz</a>, <a href=\"https://profiles.wordpress.org/eclev91\">eclev91</a>, <a href=\"https://profiles.wordpress.org/eligijus\">eligijus</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/francoeurdavid\">francoeurdavid</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/gabrielperezs\">gabrielperezs</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">Garth Mortensen</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/glennm\">glennm</a>, <a href=\"https://profiles.wordpress.org/gtuk\">gtuk</a>, <a href=\"https://profiles.wordpress.org/hailin\">hailin</a>, <a href=\"https://profiles.wordpress.org/hauvong\">hauvong</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/henrikakselsen\">henrikakselsen</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hrishiv90\">Hrishikesh Vaipurkar</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/isaacchapman\">isaacchapman</a>, <a href=\"https://profiles.wordpress.org/izem\">izem</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jacklenox\">Jack Lenox</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/jamesgol\">jamesgol</a>, <a href=\"https://profiles.wordpress.org/jancbeck\">jancbeck</a>, <a href=\"https://profiles.wordpress.org/jfarthing84\">Jeff Farthing</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jmichaelward\">Jeremy Ward</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">jipmoors</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/jkudish\">Joey Kudish</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/picard102\">John Leschinski</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/jpyper\">Jpyper</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/ungestaltbar\">Kai</a>, <a href=\"https://profiles.wordpress.org/karinchristen\">karinchristen</a>, <a href=\"https://profiles.wordpress.org/karpstrucking\">karpstrucking</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevkoeh\">Kevin Koehler</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leogopal\">Leo Gopal</a>, <a href=\"https://profiles.wordpress.org/loushou\">loushou</a>, <a href=\"https://profiles.wordpress.org/lumaraf\">Lumaraf</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/marsjaninzmarsa\">marsjaninzmarsa</a>, <a href=\"https://profiles.wordpress.org/martinsachse\">martinsachse</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxxsnake\">maxxsnake</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/nikonratm\">Michael</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michaelryanmcneill\">michaelryanmcneill</a>, <a href=\"https://profiles.wordpress.org/mcguive7\">Mickey Kay</a>, <a href=\"https://profiles.wordpress.org/mihai\">mihai</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinic</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mrutz\">mrutz</a>, <a href=\"https://profiles.wordpress.org/nabil_kadimi\">nabil_kadimi</a>, <a href=\"https://profiles.wordpress.org/Nao\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nazmulhossainnihal\">Nazmul Hossain Nihal</a>, <a href=\"https://profiles.wordpress.org/nicholas_io\">nicholas_io</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nickmomrik\">Nick Momrik</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/onnimonni\">Onni Hakala</a>, <a href=\"https://profiles.wordpress.org/ozh\">Ozh</a>, <a href=\"https://profiles.wordpress.org/pareshradadiya-1\">Paresh Radadiya</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/djpaul\">Paul Gibbs</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/gungeekatx\">Pete Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/peterrknight\">PeterRKnight</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/pragunbhutani\">pragunbhutani</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/rarylson\">rarylson</a>, <a href=\"https://profiles.wordpress.org/lamosty\">Rastislav Lamos</a>, <a href=\"https://profiles.wordpress.org/rauchg\">rauchg</a>, <a href=\"https://profiles.wordpress.org/ravinderk\">Ravinder Kumar</a>, <a href=\"https://profiles.wordpress.org/rclations\">RC Lations</a>, <a href=\"https://profiles.wordpress.org/greuben\">Reuben Gunday</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/ritteshpatel\">Ritesh Patel</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rdall\">Robert Dall</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/rhurling\">Rouven Hurling</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/rmarks\">Ryan Marks</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ohryan\">Ryan Neudorf</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sagarjadhav\">Sagar Jadhav</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/santagada\">santagada</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/scruffian\">scruffian</a>, <a href=\"https://profiles.wordpress.org/seanchayes\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/sebastiantiede\">Sebastian</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shooper\">Shawn Hooper</a>, <a href=\"https://profiles.wordpress.org/designsimply\">Sheri Bigelow</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/siobhan\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury (stephdau)</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stuartshields\">stuartshields</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar</a>, <a href=\"https://profiles.wordpress.org/sunnyratilal\">Sunny Ratilal</a>, <a href=\"https://profiles.wordpress.org/taka2\">taka2</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thorbrink\">Thor Brink</a>, <a href=\"https://profiles.wordpress.org/creativeinfusion\">Tim Smith</a>, <a href=\"https://profiles.wordpress.org/tlexcellent\">tlexcellent</a>, <a href=\"https://profiles.wordpress.org/tmatsuur\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tomasm\">Tomas Mackevicius</a>, <a href=\"https://profiles.wordpress.org/tomharrigan\">TomHarrigan</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/toru\">Toru Miki</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy (LilJimmi) Levesque</a>, <a href=\"https://profiles.wordpress.org/tryon\">Tryon Eggleston</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/desaiuditd\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/vivekbhusal\">vivekbhusal</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/willnorris\">Will Norris</a>, <a href=\"https://profiles.wordpress.org/willgladstone\">willgladstone</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/willstedt\">willstedt</a>, <a href=\"https://profiles.wordpress.org/eltobiano\">WPMU DEV Jose</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/ysalame\">Yuri Salame</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/katzwebdesign\">Zack Katz</a>, and <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>.\n<p>&nbsp;</p>\n<p>Special thanks go to <a href=\"http://siobhanmckeown.com/\">Siobhan McKeown</a> for producing the release video, <a href=\"http://hugobaeta.com/\">Hugo Baeta</a> for the design, and <a href=\"http://jacklenox.com/\">Jack Lenox</a> for the voice-over.</p>\n<p>Finally, thanks to all of the contributors who provided subtitles for the release video, which at last count had been translated into 30 languages!</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.4!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/news/2015/08/billie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.4 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 12:10:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3827\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:397:\"WordPress 4.2.4 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by Marc-Alexandre Montpas of Sucuri, Helen Hou-Sandí [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2011:\"<p>WordPress 4.2.4 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by <a href=\"https://sucuri.net/\">Marc-Alexandre Montpas</a> of Sucuri, <a href=\"http://helenhousandi.com/\">Helen Hou-Sandí</a> of the WordPress security team, <a href=\"http://www.checkpoint.com/\">Netanel Rubin</a> of Check Point, and <a href=\"https://hackerone.com/reactors08\">Ivan Grigorov</a>. It also includes a fix for a potential timing side-channel attack, discovered by <a href=\"http://www.scrutinizer-ci.com/\">Johannes Schmitt</a> of Scrutinizer, and prevents an attacker from locking a post from being edited, discovered by <a href=\"https://www.linkedin.com/in/symbiansymoh\">Mohamed A. Baset</a>.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.4 also fixes four bugs. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.4\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=33573&amp;stop_rev=33396\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.4</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.4.</p>\n<p><em>Already testing WordPress 4.3? The second release candidate is now available (<a href=\"https://wordpress.org/wordpress-4.3-RC2.zip\">zip</a>) and it contains these fixes. For more on 4.3, see <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/\">the RC 1 announcement post</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.3 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 23:50:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3817\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"The release candidate for WordPress 4.3 is now available. We&#8217;ve made more than 100 changes since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.3 on Tuesday, August 18, but we [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2256:\"<p>The release candidate for WordPress 4.3 is now available.</p>\n<p>We&#8217;ve made more than <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33512&amp;stop_rev=33372&amp;limit=120\">100 changes</a> since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.3 on <strong>Tuesday, August 18</strong>, but we need your help to get there.</p>\n<p>If you haven’t tested 4.3 yet, now is the time!</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.3 RC1, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.3-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.3 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.3 before next week. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where we&#8217;ll continue to post <a href=\"https://make.wordpress.org/core/tag/dev-notes+4-3/\">notes for developers</a> for 4.3.</p>\n<p><em>Drei Monate Arbeit</em><br />\n<em>Endlich das Ziel vor Augen</em><br />\n<em>Bald hab ich Urlaub!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.3 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 11:21:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3807\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:380:\"WordPress 4.2.3 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was initially reported by Jon Cave and [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2708:\"<p>WordPress 4.2.3 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was initially reported by <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a> and fixed by <a href=\"http://www.miqrogroove.com/\">Robert Chapin</a>, both of the WordPress security team, and later reported by <a href=\"http://klikki.fi/\">Jouko Pynnönen</a>.</p>\n<p>We also fixed an issue where it was possible for a user with Subscriber permissions to create a draft through Quick Draft. Reported by Netanel Rubin from <a href=\"https://www.checkpoint.com/\">Check Point Software Technologies</a>.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.3 also contains fixes for 20 bugs from 4.2. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.3\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=33382&amp;stop_rev=32430\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.3</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.3.</p>\n<p>Thanks to everyone who contributed to 4.2.3:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/gabrielperezs\">Gabriel Pérez</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Mike Adams</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, and <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 21:55:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3796\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2212:\"<p>WordPress 4.3 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\">Beta 3</a> blog posts. Some of the changes in Beta 4 include:</p>\n<ul>\n<li><span class=\"s1\">Fixed several bugs and broken flows in the </span><span class=\"s1\"><strong>publish box </strong></span><span class=\"s1\">in the edit screen.</span></li>\n<li>Addressed a number of edge cases for word count in the <strong>editor</strong>.</li>\n<li><span class=\"s1\"><strong>Site icons</strong> </span><span class=\"s1\">can now be previewed within the customizer. The feature has been removed from general settings.</span></li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33369&amp;stop_rev=33289\">more than 60 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a>.</p>\n<p><em>Few Tickets Remain</em><br />\n<em>Edge Cases Disappearing</em><br />\n<em>You Must Test Today</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jul 2015 21:49:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3787\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2529:\"<p>WordPress 4.3 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a> blog posts. Some of the changes in Beta 3 include:</p>\n<ul>\n<li>Performance improvements for <strong>Menus in the Customizer</strong>, as well as bug fixes and visual enhancements.</li>\n<li>Added <strong>Site Icon</strong> to the Customizer. The feature is now complete and requires lots of testing. Please help us ensure the site icon feature works well in both Settings and the Customizer.</li>\n<li>The improvements to <strong>Passwords</strong> have been added to the installation flow. When installing and setting up WordPress, a strong password will be suggested to site administrators. Please test and let us know if you encounter issues.</li>\n<li>Improved <strong>accessibility of comments and media list tables</strong>. If you use a screen reader, please let us know if you encounter any issues.</li>\n<li>Lots and lots of code documentation improvements.</li>\n<li><strong>Various other bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33286&amp;stop_rev=33141&amp;limit=150\">more than 140 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a>.</p>\n<p><em>Want to test new things?</em><br />\n<em>Wonder how four three shapes up?</em><br />\n<em>Answer: beta three</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jul 2015 22:04:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3769\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2876:\"<p>WordPress 4.3 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta2.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">check out the Beta 1 blog post</a>. Some of the changes in Beta 2 include:</p>\n<ul>\n<li>Fixed an issue in beta 1 where an alert appeared when saving or publishing a new post/page for the first time.</li>\n<li><strong><strong>Customizer</strong></strong> improvements including enhanced accessibility, smoother menu creation and location assignment, and the ability to handle nameless menus. Please help us test menus in the Customizer to fix any remaining edge cases!</li>\n<li>More robust<strong> list tables</strong> with full content support on small screens and a fallback for the primary column for custom list tables. We&#8217;d love to know how these list tables, such as All Posts and Comments, work for you now on small screen devices.</li>\n<li>The <strong>Site Icon</strong> feature has been improved so that cropping is skipped if the image is the exact size (512px square) and the media modal now suggests a minimum icon size. Please let us know how the flow feels and if you encounter any glitches!</li>\n<li>The <strong>toolbar</strong> now has a direct link to the customizer, along with quick access to themes, widgets, and menus in the dashboard.</li>\n<li>We enabled <strong>utf8mb4 for MySQL</strong> extension users, which was previously unintentionally limited to MySQLi users. Please let us know if you run into any issues.</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33138&amp;stop_rev=33046\">almost 100 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.3&amp;group=component&amp;order=priority\">everything we’ve fixed</a>.</p>\n<p><em>Edges polished up</em><br />\n<em>Features meliorated</em><br />\n<em>Beta Two: go test!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordCamps Update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/news/2015/07/wordcamps-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordcamps-update/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jul 2015 16:13:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3758\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:311:\"Last week saw the halfway point for 2015, yay! This seems like a good time to update you on WordCamp happenings in the first half of this year. There have been 39 WordCamps in 2015 so far, with events organized in 17 different countries and on 5 continents. More than 14,000 people have registered for [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9419:\"<p>Last week saw the halfway point for 2015, yay! This seems like a good time to update you on WordCamp happenings in the first half of this year.</p>\n<p>There have been <a href=\"https://central.wordcamp.org/schedule/past-wordcamps/\">39 WordCamps in 2015</a> so far, with events organized in 17 different countries and on 5 continents. More than 14,000 people have registered for WordCamp tickets so far this year, isn&#8217;t that amazing?</p>\n<p><a href=\"https://europe.wordcamp.org/2015/\">WordCamp Europe</a> was held in Seville, Spain just a few weeks ago, with close to 1,000 registered participants and over 500 live stream participants. You can watch  <a href=\"http://wordpress.tv/2015/07/04/matt-mullenweg-keynote-qanda-wordcamp-europe-2015/\">Matt Mullenweg’s keynote Q&amp;A</a> session from WordCamp Europe right now on WordPress.tv.</p>\n<p>WordPress.tv has published 537 videos so far in 2015 from WordCamps around the world. Some of the more popular 2015 WordCamp talks on WordPress.tv include <a href=\"http://wordpress.tv/2015/03/13/tammie-lister-theme-dont-be-my-everything/\">Tammie Lister: Theme, Don’t Be My Everything </a>from WordCamp Maui, <a href=\"http://wordpress.tv/2015/04/17/jenny-munn-seo-for-2015-whats-in-whats-out-and-how-to-be-in-it-to-win-it-for-good/\">Jenny Munn: SEO for 2015 – What’s In, What’s Out and How to Be In It to Win It (For Good)</a> from WordCamp Atlanta, <a href=\"http://wordpress.tv/2015/02/27/fabrice-ducarme-les-constructeurs-de-page-pour-wordpress/\">Fabrice Ducarme: Les Constructeurs de Page pour WordPress</a> from WordCamp Paris, <a href=\"http://wordpress.tv/2015/06/02/ben-furfie-how-to-value-price-websites/\">Ben Furfie: How to Value Price Websites</a> from WordCamp London, and <a href=\"http://wordpress.tv/2015/06/09/morten-rand-hendriksen-building-themes-from-scratch-using-underscores-_s/\">Morten Rand-Hendriksen: Building Themes From Scratch Using Underscores (_S)</a> from WordCamp Seattle. Check them out!</p>\n<h3>Lots of great WordCamps are still to come</h3>\n<p><a href=\"http://ma.tt/2015/06/wordcamp-us-survey/\">WordCamp US</a> is currently in pre-planning, in the process of deciding on a host city. The following cities have proposed themselves as a great place to host the first WordCamp US: Chattanooga, Chicago, Detroit, Orlando, Philadelphia, and Phoenix. It&#8217;s possible the first WordCamp US will be held in 2016 so we can organize the best first WordCamp US imaginable.</p>\n<p>At this time, there are 28 <a href=\"https://central.wordcamp.org/schedule/\">WordCamps</a>, in 9 different countries, that have announced their dates for the rest of 2015. Twelve of these have tickets on sale:</p>\n<ul>\n<li><a href=\"https://columbus.wordcamp.org/2015/\">WordCamp Columbus</a>, Columbus, Ohio: July 17-18</li>\n<li><a href=\"https://scranton.wordcamp.org/2015/\">WordCamp Scranton</a>, Scranton, Pennsylvania: July 18</li>\n<li><a href=\"https://boston.wordcamp.org/2015/\">WordCamp Boston</a>, Boston, Massachussetts: July 18-19</li>\n<li><a href=\"https://milwaukee.wordcamp.org/2015/\">WordCamp Milwaukee</a>, Milwaukee, Wisconsin: July 24-26</li>\n<li><a href=\"https://asheville.wordcamp.org/2015/\">WordCamp Asheville</a>, Asheville, North Carolina: July 24-26</li>\n<li><a href=\"https://kansai.wordcamp.org/2015/\">WordCamp Kansai</a>, Kansai, Japan: July 25-26</li>\n<li><a href=\"https://fayetteville.wordcamp.org/2015/\">WordCamp Fayetteville</a>, Fayetteville, Arkansas: July 31-August 2</li>\n<li><a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton</a>,  Brighton, UK: August 8</li>\n<li><a href=\"https://vancouver.wordcamp.org/2015/\">WordCamp Vancouver, BC,</a> Vancouver, BC, Canada: August 15-16</li>\n<li><a href=\"https://russia.wordcamp.org/2015/\">WordCamp Russia</a>, Moscow, Russia: August 15</li>\n<li><a href=\"https://norrkoping.wordcamp.org/2015/\">WordCamp Norrköping</a>, Norrköping, Sweden: August 28-29</li>\n<li><a href=\"https://croatia.wordcamp.org/2015/\">WordCamp Croatia</a>, Rijeka, Croatia: September 5-6</li>\n<li><a href=\"https://krakow.wordcamp.org/2015/\">WordCamp Krakow,</a>  Krakow, Poland: September 12-13</li>\n<li><a href=\"https://nyc.wordcamp.org/2015/\">WordCamp NYC</a>, New York City, New York: October 30-November 1</li>\n</ul>\n<p>The other 16 events don’t have tickets on sale yet, but they’ve set their dates! Subscribe to the sites to find out when registration opens:</p>\n<ul>\n<li><a href=\"https://pune.wordcamp.org/2015/\">WordCamp Pune</a>, Pune, India: September 6</li>\n<li><a href=\"https://capetown.wordcamp.org/2015/\">WordCamp Cape Town</a>, Cape Town, South Africa: September 10-11</li>\n<li><a href=\"https://baltimore.wordcamp.org/2015/\">WordCamp Baltimore</a>, Baltimore, Maryland: September 12</li>\n<li><a href=\"https://slc.wordcamp.org/2015/\">WordCamp Salt Lake City</a>, Salt Lake City, Utah: September 12</li>\n<li><a href=\"https://lithuania.wordcamp.org/2015/\">WordCamp Lithuania</a>, Vilnius, Lithuania: September 19</li>\n<li><a href=\"https://vegas.wordcamp.org/2015\">WordCamp Vegas</a>, Las Vegas, Nevada: September 19-20</li>\n<li><a href=\"https://switzerland.wordcamp.org/2015/\">WordCamp Switzerland</a>, Zurich, Switzerland: September 19-20</li>\n<li><a href=\"https://tampa.wordcamp.org/2015/\">WordCamp Tampa</a>, Tampa, Florida: September 25-27</li>\n<li><a href=\"https://rhodeisland.wordcamp.org/2015/\">WordCamp Rhode Island</a>,  Providence, Rhode Island: September 25-26</li>\n<li><a href=\"https://la.wordcamp.org/2015/\">WordCamp Los Angeles</a>, Los Angeles, California: September 26-27</li>\n<li><a href=\"https://denmark.wordcamp.org/2015/\">WordCamp Denmark,</a>  Copenhagen, Denmark: October 3-4</li>\n<li><a href=\"https://toronto.wordcamp.org/2015\">WordCamp Toronto</a>, Toronto, Ontario, Canada: October 3-4</li>\n<li><a href=\"https://hamptonroads.wordcamp.org/2015/\">WordCamp Hampton Roads, </a>  Virginia Beach, VA, USA: October 17</li>\n<li><a href=\"https://annarbor.wordcamp.org/2015\">WordCamp Ann Arbor</a>, Ann Arbor, Michigan: October 24</li>\n<li><a href=\"https://portland.wordcamp.org/2015/\">WordCamp Portland</a>,  Portland, OR: October 24-25</li>\n</ul>\n<p>On top of all those exciting community events, there are 26 WordCamps in pre-planning as they look for the right event space.  If you have a great idea for a free or cheap WordCamp venue in any of the below locations, get in touch with the organizers through the WordCamp sites:</p>\n<ul>\n<li><a href=\"https://dfw.wordcamp.org/2015/\">WordCamp DFW</a>:  Dallas/Fort Worth, Texas</li>\n<li><a href=\"https://riodejaneiro.wordcamp.org/2015/\">WordCamp Rio</a>: Rio de Janeiro, Brazil</li>\n<li><a href=\"https://saratoga.wordcamp.org/2015/\">WordCamp Saratoga</a>:  Saratoga Springs, New York</li>\n<li><a href=\"https://sofia.wordcamp.org/2015\">WordCamp Sofia</a>:  Sofia, Bulgaria</li>\n<li><a href=\"https://austin.wordcamp.org/2015/\">WordCamp Austin</a>:  Austin, TX</li>\n<li><a href=\"https://ottawa.wordcamp.org/2015/\">WordCamp Ottawa</a>:  Ottawa, Canada</li>\n<li><a href=\"https://charleston.wordcamp.org/2015/\">WordCamp Charleston</a>:  Charleston, South Carolina</li>\n<li><a href=\"https://chicago.wordcamp.org/2015/\">WordCamp Chicago</a>:  Chicago, Illinois</li>\n<li><a href=\"https://albuquerque.wordcamp.org/2015/\">WordCamp Albuquerque</a>:  Albuquerque, New Mexico</li>\n<li><a href=\"https://prague.wordcamp.org/2015/\">WordCamp Prague</a>:  Prague, Czech Republic</li>\n<li><a href=\"https://seoul.wordcamp.org/2014/\">WordCamp Seoul: </a>Seoul, South Korea</li>\n<li><a href=\"https://louisville.wordcamp.org/2014/\">WordCamp Louisville</a>: Louisville, Kentucky</li>\n<li><a href=\"https://omaha.wordcamp.org/2015/\">WordCamp Omaha</a>:  Omaha, Nebraska</li>\n<li><a href=\"https://grandrapids.wordcamp.org/2015/\">WordCamp Grand Rapids</a>:  Grand Rapids, Michigan</li>\n<li><a href=\"https://easttroy.wordcamp.org/2015/\">WordCamp East Troy</a>:  East Troy, Wisconsin</li>\n<li><a href=\"https://palmademallorca.wordcamp.org/2015\">WordCamp Mallorca</a>: Palma de Mallorca, Spain</li>\n<li><a href=\"https://edinburgh.wordcamp.org/2015/\">WordCamp Edinburgh</a>:  Edinburgh, United Kingdom</li>\n<li><a href=\"https://orlando.wordcamp.org/2015/\">WordCamp Orlando</a>:  Orlando, Florida</li>\n<li><a href=\"https://mexico.wordcamp.org/2015/\">WordCamp Mexico City</a>:  Mexico City, Mexico</li>\n<li><a href=\"https://netherlands.wordcamp.org/2015/\">WordCamp Netherlands</a>:  Utrecht, Netherlands</li>\n<li><a href=\"https://phoenix.wordcamp.org/2016/\">WordCamp Phoenix</a>:  Phoenix, Arizona</li>\n<li><a href=\"https://saopaulo.wordcamp.org/2015/\">WordCamp São Paulo</a>:  São Paulo, Brazil</li>\n<li><a href=\"https://manchester.wordcamp.org/2015/\">WordCamp Manchester</a>:  Manchester, United Kingdom</li>\n<li><a href=\"https://tokyo.wordcamp.org/2015/\">WordCamp Tokyo</a>:  Tokyo, Japan</li>\n<li><a href=\"https://lima.wordcamp.org/2015/\">WordCamp Lima</a>:  Lima, Peru</li>\n<li><a href=\"https://seattle.wordcamp.org/2015-beginner/\">WordCamp Seattle: Beginner</a>: Seattle, WA</li>\n</ul>\n<p>Don’t see your city on the list, but yearning for a local WordCamp? WordCamps are organized by local volunteers from the WordPress community, and we have a whole team of people to support new organizers setting up a first-time WordCamp. If you want to bring WordCamp to town, check out how you can <a href=\"https://central.wordcamp.org/become-an-organizer/\">become a WordCamp organizer</a>!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/news/2015/07/wordcamps-update/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jul 2015 01:30:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3738\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.3 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4352:\"<p>WordPress 4.3 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta1.zip\">download the beta here</a> (zip).</p>\n<p>4.3 is due out next month, but to get there, we need your help testing what we&#8217;ve been working on:</p>\n<ul>\n<li><strong>Menus</strong> can now be managed with the <strong>Customizer</strong>, which allows you to live preview changes you’re making without changing your site for visitors until you’re ready. We&#8217;re especially interested to know if this helps streamline the process of setting up your site (<a href=\"https://core.trac.wordpress.org/ticket/32576\">#32576</a>).</li>\n<li>Take control of another piece of your site with the <strong>Site Icon</strong> feature. You can now manage your site’s favicon and app icon from the admin area (<a href=\"https://core.trac.wordpress.org/ticket/16434\">#16434</a>).</li>\n<li>We put a lot of work into <strong>Better Passwords</strong> throughout WordPress. Now, WordPress will limit the life time of password resets, no longer send passwords via email, and generate and suggest secure passwords for you. Try it out and let us know what you think! (<a href=\"https://core.trac.wordpress.org/ticket/32589\">#32589</a>)</li>\n<li>We’ve also added <strong>Editor Improvements</strong>. Certain text patterns are automatically transformed as you type, including <code>*</code> and <code>-</code> transforming into unordered lists, <code>1.</code> and <code>1)</code> for ordered lists, <code>&gt;</code> for blockquotes and two to six number signs (<code>#</code>) for headings (<a href=\"https://core.trac.wordpress.org/ticket/31441\">#31441</a>).</li>\n<li>We’ve improved the <strong>list view</strong> across the admin dashboard. Now, when you view your posts and pages <strong>on small screen devices</strong>, columns are not truncated and can be toggled into view (<a href=\"https://core.trac.wordpress.org/ticket/32395\">#32395</a>).</li>\n</ul>\n<p><strong>Developers</strong>: There have been a few of changes for you to test as well, including:</p>\n<ul>\n<li><strong>Taxonomy Roadmap:</strong> Terms shared across multiple taxonomies will <a href=\"https://make.wordpress.org/core/2015/06/09/eliminating-shared-taxonomy-terms-in-wordpress-4-3/\">now be split</a> into separate terms on update to 4.3. Please let us know if you hit any snags (<a href=\"https://core.trac.wordpress.org/ticket/30261\">#30261</a>).</li>\n<li>Added <code>singular.php</code> to the template hierarchy as a fallback for <code>single.php</code> and <code>page.php</code>. (<a href=\"https://core.trac.wordpress.org/ticket/22314\">#22314</a>).</li>\n<li>The old Distraction Free Writing code was removed (<a href=\"https://core.trac.wordpress.org/ticket/30949\">#30949</a>).</li>\n<li>List tables now can (and often should) have a primary column defined. We’re working on a fallback for existing custom list tables but right now they likely have some breakage in the aforementioned responsive view (<a href=\"https://core.trac.wordpress.org/ticket/25408\">#25408</a>).</li>\n</ul>\n<p>If you want a more in-depth view of what changes have made it into 4.3, <a href=\"https://make.wordpress.org/core/tag/4-3/\">check out all 4.3-tagged posts</a> on the main development blog.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a> so far.</p>\n<p>Happy testing!</p>\n<p><em>Site icons for all</em><br />\n<em>Live preview menu changes</em><br />\n<em>Four three beta now</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 07 May 2015 02:24:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3718\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"WordPress 4.2.2 is now available. This is a critical security release for all previous versions and we strongly encourage you to update your sites immediately. Version 4.2.2 addresses two security issues: The Genericons icon font package, which is used in a number of popular themes and plugins, contained an HTML file vulnerable to a cross-site [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3213:\"<p>WordPress 4.2.2 is now available. This is a <strong>critical security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>Version 4.2.2 addresses two security issues:</p>\n<ul>\n<li>The Genericons icon font package, which is used in a number of popular themes and plugins, contained an HTML file vulnerable to a cross-site scripting attack. All affected themes and plugins hosted on <a href=\"https://wordpress.org/\">WordPress.org</a> (including the Twenty Fifteen default theme) have been updated today by the WordPress security team to address this issue by removing this nonessential file. To help protect other Genericons usage, WordPress 4.2.2 proactively scans the wp-content directory for this HTML file and removes it. Reported by Robert Abela of <a href=\"http://netsparker.com\">Netsparker</a>.</li>\n<li>WordPress versions 4.2 and earlier are affected by a <a href=\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\">critical cross-site scripting vulnerability</a>, which could enable anonymous users to compromise a site. WordPress 4.2.2 includes a comprehensive fix for this issue. Reported separately by Rice Adu and Tong Shi from Baidu[X-team].</li>\n</ul>\n<p>The release also includes hardening for a potential cross-site scripting vulnerability when using the visual editor. This issue was reported by Mahadev Subedi.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.2 also contains fixes for 13 bugs from 4.2. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.2\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=32418&amp;stop_rev=32324\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.2.</p>\n<p>Thanks to everyone who contributed to 4.2.2:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Mike Adams</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/taka2\">taka2</a>, and <a href=\"https://profiles.wordpress.org/willstedt\">willstedt</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 26 Aug 2015 08:11:21 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:10:\"x-pingback\";s:37:\"https://wordpress.org/news/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Wed, 19 Aug 2015 13:10:24 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20150821144050\";}", "no");
INSERT INTO `eadsk_options` VALUES("2615", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1440619882", "no");
INSERT INTO `eadsk_options` VALUES("2616", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1440576682", "no");
INSERT INTO `eadsk_options` VALUES("2617", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1440619884", "no");
INSERT INTO `eadsk_options` VALUES("2618", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: First Look at the Twenty Sixteen Default WordPress Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://wptavern.com/first-look-at-the-twenty-sixteen-default-wordpress-theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2281:\"<p>WordPress 4.4 is the last scheduled major release of the year and with it will come a new default theme to replace Twenty Fifteen. On the Make WordPress Core site, Tammie Lister <a href=\"https://make.wordpress.org/core/2015/08/25/introducing-twenty-sixteen/\">published an image gallery</a> that shows off the design of Twenty Sixteen.</p>\n<p>According to Lister, the process of determining the new default theme has taken months, &#8220;Lots of themes were considered, eventually settling on the one you see below. It’s a perfect fit,&#8221; she said.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/TwentySixteenConcept.png\"><img class=\"size-large wp-image-47898\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/TwentySixteenConcept.png?resize=433%2C500\" alt=\"Twenty Sixteen\" /></a>Twenty Sixteen\n<p>Twenty Sixteen is designed by <a href=\"https://profiles.wordpress.org/iamtakashi\">Takashi Irie,</a> who also designed the <a href=\"http://takashiirie.com/2013/12/13/twenty-fourteen-wordpress-3-8-parker/\">Twenty Fourteen</a> and <a href=\"http://takashiirie.com/2015/03/19/twenty-fifteen-the-wordpress-default-theme-for-2015/\">Twenty Fifteen</a> default themes. Irie describes Twenty Sixteen as:</p>\n<blockquote><p>A modernized approach of an ever-popular layout — a horizontal masthead and an optional right sidebar that works well with both blogs and websites. It has custom color options that allow you to make your own Twenty Sixteen. The theme was designed on a harmonious fluid grid with a mobile first approach. This means it looks great on any device.</p></blockquote>\n<p>The new theme has hints of Twenty Fourteen but is different enough to stand on its own as a unique design. It doesn&#8217;t look as modern as <a href=\"https://twentyfifteendemo.wordpress.com/\">Twenty Fifteen</a> out-of-the box but the design could change during the 4.4 development cycle.</p>\n<p>If you want to help Twenty Sixteen be the best it can be, please join the weekly meetings held every Monday and Friday at 16:00 UTC in the #core-themes channel on <a href=\"https://make.wordpress.org/chat/\">SlackHQ</a>. The meetings are a half hour-long and start once the theme is initially added to WordPress core.</p>\n<p>What do you think of Twenty Sixteen?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Aug 2015 01:20:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Sessions From BuddyCamp Brighton, UK Now Available to Watch on WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47892\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wptavern.com/sessions-from-buddycamp-brighton-uk-now-available-to-watch-on-wordpress-tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1354:\"<p>Earlier this month, the first <a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton, UK</a> successfully took place. Six speakers presented their sessions from within the venue while four participated remotely. Here&#8217;s a break down of the attendees:</p>\n<ul>\n<li>13 Sponsors.</li>\n<li>8 Sessions.</li>\n<li>7 Volunteers.</li>\n<li>6 Speakers plus another 4 via video message.</li>\n<li>33 Attendees.</li>\n</ul>\n<p>The conference featured sessions on the <a href=\"https://brighton.buddycamp.org/2015/session/the-origin-of-buddypress/\">origin of BuddyPress</a>, a <a href=\"https://brighton.buddycamp.org/2015/session/fireside-with-paul-gibbs/\">fireside chat with Paul Gibbs</a>, and <a href=\"https://brighton.buddycamp.org/2015/session/messages-from-contributors/\">messages from BuddyPress contributors</a>.</p>\n<p>Photographs of the event <a href=\"https://brighton.buddycamp.org/2015/photos/\">are available</a> on the official BuddyCamp Brighton website. In addition to photographs, sessions were recorded and are <a href=\"http://wordpress.tv/event/buddycamp-brighton-2015/\">available to watch for free</a> on WordPress.tv.</p>\n<p>In the following video, Gibbs explains the origins of <a href=\"https://buddypress.org/\">BuddyPress</a>.</p>\n<p></p>\n<p>If you attended BuddyCamp Brighton, UK please share your experience in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Aug 2015 01:11:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: OSTraining Makes Pods Framework Video Training Series Available for Free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47885\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/ostraining-makes-pods-framework-video-training-series-available-for-free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2214:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/03/pods.jpg\"><img class=\"aligncenter size-full wp-image-40653\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/03/pods.jpg?resize=628%2C290\" alt=\"pods\" /></a><a href=\"https://www.ostraining.com/\">OSTraining</a>, a site that offers video training for WordPress, Joomla, Drupal, and other technologies <a href=\"https://www.ostraining.com/blog/wordpress/pods/\">announced</a> their <a href=\"http://pods.io/\">Pods Framework</a> video <a href=\"https://www.ostraining.com/courses/class/wordpress/pods/\">training series</a> is now available for free. Steve Burge, founder of OSTraining.com, says offering the video series for free is the result of a partnership with the Pods Framework project.</p>\n<p>&#8220;This project came about because the OSTraining and Pods teams bumped into each other on a regular basis. I often ran into Jim True and Josh Pollock from Pods. We met at WordCamps and WordPress meetups in Tampa, Orlando, and Miami, FL.</p>\n<p>&#8220;The Pods team explained that they were working on improving their documentation. They started a YouTube series, wrote tutorials, and started the <a href=\"http://wptavern.com/pods-lead-developer-scott-kingsley-clark-launches-friends-of-pods-funding-campaign\">Friends of Pods</a> initiative to support their efforts. Making the videos free is our way of contributing to the Pods project,&#8221; Burge told the Tavern.</p>\n<p>Burge recorded the series after using Pods to create the <a href=\"http://appalachiantrail.com/\">Appalachian Trail</a> website. The series provides an introduction to Pods, templates, creating a custom taxonomy, and more. Those interested can view the series on <a href=\"https://www.ostraining.com/courses/class/wordpress/pods/\">OSTraining.com</a> or <a href=\"https://www.youtube.com/watch?list=PLtaXuX0nEZk9dCVMQRmSptuJ6YdVzMkr5&v=4rm95kNxRXg\">YouTube</a>.</p>\n<p>Here&#8217;s a look at the first video in the series which introduces viewers to the Pods Framework.</p>\n<p><span class=\"embed-youtube\"></span></p>\n<p>Although it was created in 2014, the series contains great insight into the project and provides an educational foundation for learning Pods 3.0.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Aug 2015 21:20:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Alex King: Request: Alex King Rememberances\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://alexking.org/?p=22017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://alexking.org/blog/2015/08/24/rememberances\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1445:\"<p>Dear WordPress community,</p>\n<p>My apologies for the selfish and personal nature of this post. I hope you will forgive me given the circumstances. As most of you know, I was <a href=\"http://alexking.org/blog/thread/cancer\">diagnosed with stage 4 colon cancer in 2013</a>.</p>\n<p>One of the things my wife and I are trying to do is put together some information about my career that will hopefully give my 6 year-old daughter a better sense of who I was as an adult. She knows me as &#8220;dad&#8221;, but when she gets older she&#8217;ll be curious about who I was to my peers and colleagues.</p>\n<p>I&#8217;ve spent more than a decade in the WordPress community and I&#8217;d like to request that you to share a few thoughts or remembrances about me that we can compile and share with her when the time is right.</p>\n<p>If we have crossed paths or if I have managed to do something that you found helpful, I&#8217;d love it if you would take a few minutes to write it down and <a href=\"http://alexking.org/contact\">send it to me</a> or my wife: heatherkingcom@gmail.com. If you&#8217;re willing to have the story shared publicly, please indicate that accordingly. By default, we will keep everything confidential.</p>\n<p class=\"threads-post-notice\">This post is part of the thread: <a href=\"http://alexking.org/blog/thread/cancer\">Cancer</a> &#8211; an ongoing story on this site. View the thread timeline for more context on this post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Aug 2015 21:01:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Alex\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Step Up Your Game: How to Work With Successful WordPress Clients\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47868\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/step-up-your-game-how-to-work-with-successful-wordpress-clients\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:25388:\"<hr />\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/MarioPeshev.jpg\"><img class=\"alignright size-thumbnail wp-image-47869\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/MarioPeshev.jpg?resize=150%2C150\" alt=\"Mario Y. Peshev\" /></a>This post was contributed by <a title=\"Ryan Hellyer\" href=\"http://geek.ryanhellyer.net/\" target=\"_blank\">Mario Peshev</a>. Mario is the founder and WordPress Architect at <a href=\"http://t.co/p9TnMSFMi2\">DevriX</a> building and maintaining large WordPress-driven platforms. With over 10,000 hours of consulting and training, Mario&#8217;s Yin and Yang is his Open Source advocacy and business growth strategy.</p>\n<hr />\n<blockquote><p>Without continual growth and progress, such words as improvement, achievement, and success have no meaning &#8211; Benjamin Franklin</p></blockquote>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/StepUpYourGameFeaturedImage.png\"><img class=\"size-full wp-image-47879\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/StepUpYourGameFeaturedImage.png?resize=682%2C281\" alt=\"Step up your game featured image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/58522126@N00/430932479\">Stairwell</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>I’ve been a learnaholic for as long as I can remember and when I read the aforementioned quote, it resonates strongly with me. My prelude to WordPress years ago was one of the steps toward improvement and success and I’ve developed a special love-hate relationship with WordPress.</p>\n<p>Utmost admiration about its influence over the world in terms of Open Source and opportunities for various people in different niches, and its plague of being diminished and depreciated by professional developers and successful businesses.</p>\n<p>There are ways to solve these issues as long as the inner circle works towards the same goal.</p>\n<p><strong>Note</strong>: If you are happy building lego type websites with random ThemeForest themes and you see that as your future, this post is not for you. If you love doing the same repeatedly for mom and pop shops, this may not resonate with you. This is applicable to people who want to get better at what they do, be more professional, and make some impact by solving complex problems for larger customers.</p>\n<h2>WordPress For a Better Future</h2>\n<p>In May, I presented at a conference focused on kids and teenagers to motivate them, prepare them for the adult life, and nurture their creativity. Kids these days hardly think about their future, between their teenage emotional dramas and boring homework assignments. If you think about it, how can they be passionate about becoming someone if they have no real idea what they need to know and do on a daily basis?</p>\n<p>I used WordPress as an example of a platform that children can use, one that provides them with the opportunity to develop a talent or passion.</p>\n<p>Using WordPress for homework and general notes (or a diary) could indicate interest in several areas:</p>\n<ul>\n<li>Young bloggers can potentially do creative writing or copywriting.</li>\n<li>Constantly switching themes and playing with colors might open the room to design.</li>\n<li>Adding plugins and trying to implement complex combinations is the first step to programming.</li>\n<li>Sharing posts, looking at analytics and comparing different titles or photos is the way to marketing.</li>\n</ul>\n<p>There are other potential areas of course, but as long as kids can associate with an activity, become passionate about it, and start digging into it, they can save years of slacking, not to mention tens of thousands of dollars on college degrees for specialties they couldn’t care less about.</p>\n<p>This is one of the reasons why more and more people join the WordPress industry and switch boring jobs in order to make a living off of WordPress.</p>\n<h2>What Types Of WordPress Services Exist?</h2>\n<p>The amount of opportunities for WordPress work is incredible but the vast pool of WordPress jobs is so vague and blurry, that hiring and educating talent is out of control.</p>\n<p>I keep an eye on dozens of job boards, portals, and freelance networks. Clients look for Virtual Assistants to get their websites built. They look for expert WordPress developers to apply content changes to their site or web designers to develop complex plugins.</p>\n<p>On a weekly basis I see references to WordPress administrators, programmers, developers, designers, marketers, digital artists, webmasters, VAs, and plenty of other job titles used improperly. As a matter of fact, I’m now fascinated when I see a WordPress related job post or an offer looking for the right type of candidate.</p>\n<p>The great news is that you can do anything with WordPress. The caveat here is that WordPress itself is not a skill. You don’t ask for an Internet expert nowadays and you don’t go to the same doctor when you have a headache or you’ve injured your leg.</p>\n<p>The wide industry of innocent clients and amateur service providers have made it nearly impossible to tell a developer from a marketer, or from a general user who has installed WordPress with an auto-installer twice.</p>\n<h2>The Indecent World of WordPress Experts</h2>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/JobTitleFeaturedImage.png\"><img class=\"size-full wp-image-39089\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/02/JobTitleFeaturedImage.png?resize=650%2C200\" alt=\"Job Titles Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/58871905@N03/5565517971\">I love &#8217;84</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>I’ve read a lot about impostor syndrome in several reputable WordPress blogs, and people keep identifying themselves in the comments. In my opinion, this is a problem so insignificant as compared to the ever-growing pool of people claiming to be WordPress Experts.</p>\n<p>In the last several years, I’ve interacted with people all around the world working with WordPress. From freelancers to successful business owners at conferences, and from beginner virtual assistants to full-stack consultants in social media, blogs and job networks.</p>\n<p>The largest group of service providers that I’ve found is the one of <em>WordPress experts</em>. You can easily substitute expert with specialist, guru, master, ninja and rockstar. Just open a new tab and do a few quick searches in Google, job networks, social media and view the large number of results.</p>\n<p>Next on the list are <em>WordPress developers</em>. A WordPress developer is often described as people who install plugins. There are various possible scenarios, but this is rarely the definition of an actual developer proficient in WordPress.</p>\n<p>Some boards or blogs list specific skills that let you filter by programming language or a separate tool. My latest research with 200 contractors with WordPress developer titles led to 170 people who rate themselves with 4 or 5 out of 5 stars in PHP proficiency, and 30 with 3 stars.</p>\n<p>Out of the 170 people in the first group, 150 were college students, Internet marketers, VAs, and people who have substituted strings in WordPress themes thanks to support forums or help from the Codex. Not a single line of code was written from scratch, let alone building anything, and 4 out of 5 or higher self-assessed their level of PHP experience.</p>\n<p>Tom McFarlin <a href=\"http://tommcfarlin.com/wordpress-developers-programmer-implementer/\">published a post</a> on the difference between a developer and implementer and I wrote an overview defining <a href=\"http://wptavern.com/why-wordpress-job-titles-dont-mean-much-anymore\">various technical skills in the WordPress context</a>. Due to the lack of proper training, any official educational resource or meaningful set of skills per role, both finding talent and improving one’s skills is being challenged.</p>\n<p>I challenge you to interview several successful clients around you who looked for skillful WordPress folks. They either happened to know the right people, were recommended someone, ended up with several freelancers who messed up big time, went AWOL and suddenly took the cash and disappeared, couldn’t deliver, or they did and the site is incredibly slow and/or got hacked soon thereafter.</p>\n<p>That’s sending serious businesses away and I won’t touch the topic of under pricing services and products which brings the quality and support way down.</p>\n<p>What motivates people to use a reliable resource in order to grow? The WordPress Foundation, nor any of the big players provide official training curriculum, and a definition for formal roles. There is no WordPress certification program (I won’t get into that to avoid unnecessary discussions), and there are no clear paths for requirements.</p>\n<h2>The WordPress Community is Filled with Amateurs</h2>\n<p>As a result, our community is a large group mostly composed of amateurs who started using WordPress one way or another. These people started earning money and reached a point where they don’t know where they stand, what they’re proficient in, if they’re doing fine, whether they’re experts, impostors, or somewhere in the middle, and what would be helpful to them?</p>\n<p>We still use FTP and work with PHP 5.2-supported hosts. The most popular theme marketplaces provide products with broken and inconsistent code. The WordPress.org plugin repository accepts plenty of plugins with suspicious consistency and compatibility.</p>\n<p>None of these issues are recognized publicly in the WordPress community. Some hosts prohibit SSH and allow solely FTP. PHP 5.2 will be supported by Core for a while, which doesn’t motivate hosts to upgrade. Marketplaces earn millions from their top sellers, so they’re not interested in quickly bringing up quality as long as poorly coded themes sell well. There’s also no formal constantly reviewed plugin repository for high quality plugins and no one is actively backing this idea up.</p>\n<p>If you read the last paragraph as a rant, it’s because it is. It’s meant to be a “wake up call” to clients who don’t know better and service providers who want to become better. While the WordPress Core itself is incredibly stable and flexible, the rest of the infrastructure is mostly poorly coded due to under pricing, lack of skills, and lack of more successful clients interested in backing up WordPress teams and consultants.</p>\n<p>There are different kinds of people and plenty of applications of WordPress. Whatever you do, it’s your professional duty to offer the right type of service instead of misleading your clients, and be aware of the other pertinent verticals. Moreover, it’s the only way forward working with reputable organizations and large profitable corporations.</p>\n<h2>What is a Successful Client?</h2>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/10/SuccessFeaturedImage.png\"><img class=\"size-full wp-image-32204\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/10/SuccessFeaturedImage.png?resize=636%2C278\" alt=\"Success Featured Image\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/seeveeaar/2035597695/\">seeveeaar</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nd/2.0/\">cc</a>\n<p><a href=\"http://prestigeconf.com/\">Prestige Conference</a> happened a few weeks ago, and Shane Pearlman from <a href=\"https://tri.be/\">Modern Tribe</a> shared his experience in a presentation entitled, Land the Big Fish: Strategies Acquiring Larger Clients. It’s a motivational talk that outlines different strategies on negotiating and landing larger customers.</p>\n<p>During the Q&amp;A at the end of the session, Pearlman is asked, “What’s in it for me to go through all of that headache to procure bigger brand names?”</p>\n<p>As I stated at the beginning, working with successful clients is not for everyone. Some people are afraid to leave their comfort zone. Others are too lazy to learn new skills or sometimes doing the same thing repeatedly may be their perfect job. For every other entrepreneur or business player, successful clients are exciting.</p>\n<p>Each small change is magnified when working with successful clients. Usually, they have a lot of employees, a solid budget for marketing and advertising, a lot of traffic, and various complex requirements that help them attract more leads or automate their processes. T</p>\n<p>hey are often respectable and have access to more capital. This allows them to invest more since their return of investment is worth it; while taking a risk due to saving a few bucks could very well ruin their reputation and harm their business. There are several examples of products or companies in the WordPress community that were hacked or where updates caused major issues.</p>\n<p>Working with successful clients is extremely rewarding and exciting, but getting there requires ace skills and solid experience, as well as the right mindset.</p>\n<h2>How to Target Successful Clients</h2>\n<p>Based on my experience with banks, telecoms, automotive, airline brands, large educational institutions and media outlets over the last 12 years as a developer and a technical lead, there are several specific areas where courageous WordPress freelancers and small business owners can focus on if they are aiming for growth and successful clients, but aren’t there yet.</p>\n<p>I have identified some steps for <a href=\"http://www.wpelevation.com/2015/08/8-steps-to-move-from-freelancer-to-successful-company/\">moving from a freelancer to a successful company</a>. Here is what we should focus on in the WordPress context in order to step up our game, understand our industry better, and start acting professionally if we want to be taken seriously.</p>\n<h2>WordPress is a Vague Term</h2>\n<p>Being a WordPress Expert says nothing. You may be a lead developer of WordPress or someone who can memorize the order of all submenus under Settings in the admin dashboard. Both are classified as WordPress experts and that’s what many people don’t realize.</p>\n<p>Specialize in a given niche and polish your skills. Focus on a specific group of projects &#8211; membership websites, eCommerce stores, multisite installs. Become a know-it-all professional for an extensible plugin such as, BuddyPress, Gravity Forms, or Easy Digital Downloads.</p>\n<p>Understand the value you are providing and what it corresponds to. Be respectful to the broad community of professionals in your area, learn from them, ask them to be your mentors. Even the best athletes and CEOs have coaches, business mentors, and boards of directors. Find out what it is that you do whether it’s design, development, marketing, or something else and learn the skill inside and out.</p>\n<h2>WordPress Installments Don’t Matter</h2>\n<p>Plenty of people offer WordPress services as an add-on to their portfolio of other services without realizing the impact it has on the business. While WordPress is used for plenty of purposes, it’s still a technical platform that comes with its own specific set of requirements.</p>\n<p>Imagine what will happen if:</p>\n<ul>\n<li>You set up a vulnerable plugin that is exploited and your client’s password is stolen, along with their private details.</li>\n<li>You forget to protect the media uploader and the client uploads sensitive data. Scanned images of contracts and ID cards end up in the public space.</li>\n<li>Your sitemap plugin indexes protected data since you used a plugin that doesn’t work.</li>\n<li>You set up a site and sell it to a client, and due to the terrible choice of plugins, the site crashes miserably and kills the server during a demonstration in front of their big clients.</li>\n</ul>\n<p>Its a small list of what ifs, but they happen all the time. If you don’t possess the skills or offer the wrong service, this could damage your client’s business. Upping your game and providing solutions instead of websites allows you to take care of the infrastructure, maintenance work, support, development, security, marketing of the project.</p>\n<p>At the very least, be aware of the consequences and partner up with other agencies and consultants. Complete packages are what successful clients look for and inexperienced people often mess up what others have built.</p>\n<h2>WordPress Expert Skills Won’t Cut It</h2>\n<p>Successful clients look for professional skills. They have real problems that can’t be solved with yet another plugin, and they are smart enough to know that.</p>\n<p>If you are in the business of configuring themes and installing a few plugins for clients, that won’t do it for successful customers. You need to specialize in code, design, user experience, marketing, or something else that brings real value to them.</p>\n<p>Large clients are looking for state of the art designs, performant and secure code, brilliant marketing skills, and growth hacking strategy. Large clients are successful because they are outstanding at what they do, the services they offer, and they appreciate high quality.</p>\n<h2>Context-Specific WordPress Solutions</h2>\n<p>Large organizations take their marketing presence and technical stack seriously. They carefully delegate based on multiple factors. Being in a meeting with a large client typically means discussing a use case together with several people such as, a creative director, VP of marketing, network engineer, and project manager.</p>\n<p>In addition to being skillful in your niche and ready to provide value, you have to learn the business processes of your target client. Your idea of a solution may be applicable for small sites, but it may very well be a bad fit based on the company policy or the variety of services used by the team.</p>\n<p>As an example, a creative director may require you to prepare your theme to be ADA Section 508 compliant, which is an accessibility standard required by certain organizations. The VP of marketing may ask for a Hubspot integration with Cvent within your website for proper CRM and meeting request management.</p>\n<p>The network engineer could outline that they need to host the solution on-site, and set up a specific set of web application firewalls and internal web server security rules restricting certain process callbacks. The project manager might share a complicated timeline based on the organization load, holiday schedule, decision maker’s availability, conferences, and various deliverables that need to be presented by different people and other third-parties.</p>\n<p>All of the above are things that we’ve been asked for over the past few months. If you are used to working with a specific host using Apache, prepare for writing documentation and shipping to a restricted server running HHVM. If you use a framework that isn’t accessible, you will need to step back, explore the Section 508 standards, and build something compatible.</p>\n<p>Generic solutions are often not the right fit for large clients. But if you’re determined to learn more and become a better professional, that’s the perfect challenge for you.</p>\n<h2>Solving More Complex Problems</h2>\n<p>In addition to being able to adjust to different environments, working with large clients means solving more complex problems.</p>\n<p>If a mom and pop shop is somewhat broken or down, it’s probably not a big deal if their site receives 100 visits per month. But for a project with tens of millions of views a month and thousands of concurrent users, it is unacceptable.</p>\n<p>Working on larger and heavy platforms often means dealing with a lot of data, complex relationships, and solid traffic. This means that every single line of your code and business decision will inevitably impact the entire system in a way visible to hundreds of thousands of people.</p>\n<p>In order to be able to cope with these, you should study your specialty in detail and understand what the impact is of every single change. These skills increase your value and let you face similar challenges and solve problems that the majority of beginners can’t even imagine.</p>\n<p>You will learn a lot about the entire stack, and get to know hundreds of different rules. At some point you will voluntarily violate those rules, being aware of the fact that some design patterns and best practices don’t solve specific problems. It’s better to denormalize a database or minify a compression algorithm in order to solve a business problem for a large platform.</p>\n<p>It’s just as they say at a music college &#8211; you learn the music theory for three years, and then you throw everything away and start playing jazz. You need to know the entire architecture and strategy first in order to decide how to optimize it in the best possible manner, whether it’s using a best practice or violating one for a specific purpose.</p>\n<h2>Teaming Up</h2>\n<p>If you have worked solo or in a small team, you will eventually need to partner up or grow. Either way, large projects are time consuming and require different expertise, and it’s unthinkable for one to know it all. Therefore, you will work with other professionals from more industries, team up and solve more complex problems together, and learn more about their challenges.</p>\n<p>If you have thought about mastering a single skill, teaming up with the right people will add a few more skills as an extra perk, which will increase the potential of your main skill as well. Working with financial analysts on a project for a bank helped me to understand the entire model of loans and mortgages, as well as the internal banking policy.</p>\n<p>This allowed me to learn how loans and interests work in different cases and get acquainted with standardized security regulations at companies in the financial field.</p>\n<h2>Security Concerns</h2>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/05/HelloSecurityFeaturedImage.png\"><img class=\"size-full wp-image-44224\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/05/HelloSecurityFeaturedImage.png?resize=688%2C368\" alt=\"Hello Security Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/8264582@N06/3383392046\">Two Locks</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>Data privacy and security are important topics that people often misjudge. Working with large clients means more responsibility and higher impact in case of a problem. In the process of building a solution or consulting a reputable organization, you will most likely have to comply with various security policies.</p>\n<p>While some of them may seem unnecessary, there is a reason they exist. The more familiar you are with them, the better it is for you, your clients, and future endeavors. If you’re not using VPNs, SSH keys, two-factor authentication, or voice recognition IDS, this may be a good lesson for you. Why are they needed, what problems do they solve, and how can you apply them to your personal data and existing set of clients?</p>\n<h2>Organization and Accountability</h2>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/BrainyQuote1.jpg\"><img class=\"size-full wp-image-47877\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/BrainyQuote1.jpg?resize=620%2C400\" alt=\"BrainyQuote\" /></a>BrainyQuote\n<p>In order to be helpful to large businesses as a consultant, or an agency, you need to be reliable. This may be a result of a number of testimonials, successful track record at previous companies or a good portfolio. It’s always challenging to start with large customers, so improving your skills and working hard in order to become valuable is important.</p>\n<p>Being organized and process-oriented is essential to most reputable organizations. The majority of them are more conservative and operate slowly, since a minor mistake could cost them millions or more.</p>\n<p>They rely on detailed specifications, scope of work documents, use case diagrams, UX mockups/wireframes, E/R diagrams, and a large list of documents. They include every single detail in their planning &#8211; from holidays for each member of their team, to different dependencies from other service providers and third-party members.</p>\n<p>Successful clients have managed to build a process and scale it in a way that grows their revenue in a predictable way. In order to be able to handle large projects, you need to treat them as a small project that takes longer to complete.</p>\n<p>Learn how to use a project management system and version control properly, define your pricing strategy, make sure to predict all of the delays for both communication and payments. Learn how large organizations operate and do your due diligence upfront in order to avoid surprises.</p>\n<p>Don’t take anything for granted and don’t assume anything. The more confident you are, the higher the possibility of making a major mistake. There are always new automatic deployment strategies or a DevOps service you haven’t heard of, another massive CSS3 grid, or a growth hacking strategy that you haven’t explored.</p>\n<p>The more challenges you face, the more you’ll learn, and be able to solve complex problems.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Aug 2015 18:42:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Alex King: Personal WordPress Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://alexking.org/?p=21662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://alexking.org/blog/2015/08/22/personal-wordpress-theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2188:\"<p>I&#8217;ve forked the FavePersonal theme to release a few changes that I&#8217;ve made to it for my own site.</p>\n<ol>\n<li>An improved Gallery feature, including support for WordPress shortcode galleries. If you&#8217;re uploading photos directly to your gallery post, you can use drag and drop to set the order for them now.</li>\n<li>The Post Formats admin UI is now responsive and works great on mobile devices.</li>\n<li>Remove the Social plugin from the theme (requested by WP.org) &#8211; it can still be installed separately.</li>\n<li>Make tons of misc. code changes to match new coding standards vs. previous coding standards (and pass the theme check).</li>\n</ol>\n<p><img src=\"http://alexking.org/wp-content/uploads/2015/08/maine-gallery-510x469.png\" alt=\"Gallery\" width=\"480\" height=\"441\" class=\"alignnone size-medium-img wp-image-22028\" /></p>\n<p>I was originally hoping to have the modified theme hosted on WordPress.org but after weeks of waiting for review, they responded that features of the theme like <a href=\"https://themes.trac.wordpress.org/ticket/24520#comment:4\">choosing colors and post formats</a> should be done in separate plugins instead. This makes no sense to me as these are core features of the theme, but happily there are great places like <a href=\"https://github.com/alexkingorg/wp-personal\">GitHub</a> that will host the project for us.</p>\n<p>The Personal theme is quite assuredly <a href=\"https://www.google.com/webmasters/tools/mobile-friendly/?url=alexking.org\">mobile-friendly</a>, which makes it a great fit for the importance Google&#8217;s is placing on mobile-friendly sites lately.</p>\n<p>You can download from the <a href=\"https://github.com/alexkingorg/wp-personal/releases\">releases page</a> on GitHub or, for you technically minded, grab the reop with git. Just make sure to also grab the submodules.</p>\n<p><code>git clone git@github.com:alexkingorg/wp-personal.git<br />\ncd wp-personal<br />\ngit submodule update --init --recursive</code></p>\n<p class=\"threads-post-notice\">This post is part of the project: <a href=\"http://alexking.org/project/personal\">Personal Theme</a>. View the project timeline for more context on this post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 22 Aug 2015 19:11:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Alex\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: WordCampus a Conference Devoted to Using WordPress in Higher Education\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47853\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/wordcampus-a-conference-devoted-to-using-wordpress-in-higher-education\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1861:\"<p>Higher education is a subject that <a href=\"http://wordpress.tv/?s=education\">some WordCamps</a> have tackled over the years, but what if there was an event entirely devoted to it? That&#8217;s the idea <a href=\"http://bamadesigner.com\">Rachel Carden</a> is proposing with <a href=\"http://wpcampus.org/\">WordCampus</a>. The idea started off as a tweet but quickly gained momentum with others in the community.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">Ooh. Dream with me: \"<a href=\"https://twitter.com/hashtag/WordCampus?src=hash\">#WordCampus</a>: A WordCamp for folks using <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> in Higher Education.\" I like it. <a href=\"https://twitter.com/hashtag/heweb?src=hash\">#heweb</a> <a href=\"https://t.co/m1zEkpkP4B\">https://t.co/m1zEkpkP4B</a></p>\n<p>&mdash; Rachel Carden (@bamadesigner) <a href=\"https://twitter.com/bamadesigner/status/628324358126235648\">August 3, 2015</a></p></blockquote>\n<p></p>\n<p>WordCampus is an event that would cover topics such as, how to manage a large-scale network of faculty blogs, abiding by FERPA regulations, or how to best implement single sign-on that integrates with Active Directory.</p>\n<p>Carden <a href=\"https://poststatus.com/wordpress-higher-ed-conference-wordcampus/\">outlines her idea in detail</a> on Post Status and says that even though camp is in the event&#8217;s name, it doesn&#8217;t imply that it would be an official WordCamp event. She&#8217;s also open to organizing an event not affiliated with the WordPress Foundation.</p>\n<p>If you&#8217;re interested in speaking, sponsoring, or attending WordCampus, please <a href=\"http://wpcampus.org/\">fill out the survey </a>and help spread the word. The more interest Carden generates, the more likely it is that the WordPress Foundation will back the event.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Aug 2015 19:40:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: What Do You Want to See in WordPress 4.4?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47850\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wptavern.com/what-do-you-want-to-see-in-wordpress-4-4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1220:\"<p>Scott Taylor, who is <a href=\"http://wptavern.com/wordpress-core-team-announces-release-leads-for-wordpress-4-3-and-4-4\">leading the development cycle</a> for WordPress 4.4, <a href=\"https://make.wordpress.org/core/2015/08/19/wordpress-4-4-whats-on-your-wishlist/\">published a post</a> on the Make WordPress Core site asking people what they&#8217;d like to see in WordPress 4.4. The post has generated a number of comments from the community. Some of the most popular suggestions include:</p>\n<ul>\n<li>REST API</li>\n<li>Fields API</li>\n<li>Term Meta</li>\n<li>Shortcake UI</li>\n<li><a href=\"https://core.trac.wordpress.org/ticket/31467\">Ticket 31467</a> Images should default to not linking</li>\n<li>RICG Responsive Images</li>\n<li>Posts 2 Posts</li>\n</ul>\n<p>Most of the items suggested are at various stages of development and there&#8217;s no guarantee any of them will make it into WordPress 4.4. However, the comments provide insight into what a lot of developers want in WordPress.</p>\n<p>If there&#8217;s a ticket, feature, or plugin you&#8217;d like to see in WordPress 4.4, please <a href=\"https://make.wordpress.org/core/2015/08/19/wordpress-4-4-whats-on-your-wishlist/\">leave a comment</a> on the post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Aug 2015 18:16:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: WPWeekly Episode 204 – Overview of WordPress 4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47844\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://wptavern.com/wpweekly-episode-204-overview-of-wordpress-4-3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2272:\"<p>In this week&#8217;s episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I review WordPress 4.3. We discuss the Kim Parsell memorial scholarship and the events that led to its creation. We also discuss Nick Haskins&#8217; rebrand of Lasso. Last but not least, we spread the news that Automattic is hiring.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-3-billie-named-after-jazz-singer-billie-holiday-is-available-for-download\">WordPress 4.3 “Billie” Named After Jazz Singer Billie Holiday Is Available</a><br />\n<a href=\"http://wptavern.com/the-wordpress-foundation-begins-accepting-applications-for-the-kim-parsell-memorial-scholarship\"> The WordPress Foundation Begins Accepting Applications for the Kim Parsell Memorial Scholarship</a><br />\n<a href=\"http://wptavern.com/nick-haskins-rebrands-lasso-to-editus\"> Nick Haskins Rebrands Lasso to Editus</a><br />\n<a href=\"https://automattic.com/work-with-us/\">Automattic is Hiring</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/wp-remote-multisite-post/\">WP Remote Multisite Post</a> allows for advanced remote posting from a WordPress master site to many WordPress client sites using XML-RPC.</p>\n<p><a href=\"https://wordpress.org/plugins/fb-group-feed/\">FB Group Feed</a> is a plugin to display Facebook group posts or a feed on your site in a post or a widget.</p>\n<p><a href=\"https://wordpress.org/plugins/wp-webinarsystem/\">WP Webinar System</a> allows you to run webinars within your WordPress website and customize everything around it.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 26th 4:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #204:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Aug 2015 17:28:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"WPTavern: The WordPress Foundation Begins Accepting Applications for the Kim Parsell Memorial Scholarship\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47835\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://wptavern.com/the-wordpress-foundation-begins-accepting-applications-for-the-kim-parsell-memorial-scholarship\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2885:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsell.png\"><img class=\"size-full wp-image-36619\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/01/KimParsell.png?resize=655%2C418\" alt=\"WordCamp San Francisco 2014 By Sheri Bigelow\" /></a>WordCamp San Francisco 2014 By Sheri Bigelow\n<p>Earlier this year, the WordPress Foundation <a href=\"https://make.wordpress.org/community/2015/01/15/remembering-kim-parsell/\">created a scholarship</a> in memory of <a href=\"http://wptavern.com/kim-parsell-affectionately-known-as-wpmom-passes-away\">Kim Parsell</a> to celebrate her life and contributions to WordPress. With the date and location secured for <a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">WordCamp US</a>, applications for the scholarship are now <a href=\"http://wordcampcentral.polldaddy.com/s/kim-parsell-scholarship-application\">being accepted</a> by the Foundation.</p>\n<p>Details of the scholarship are as follows:</p>\n<ul>\n<li>It is a scholarship for a woman contributor with financial need who has never attended WordCamp San Francisco before.</li>\n<li>It will cover the ticket cost, flight, and lodging.</li>\n<li>It will not cover things like taxis, meals outside the official event, or airport transportation.</li>\n<li>One scholarship is awarded per year.</li>\n<li>It is funded by the WordPress Foundation.</li>\n<li>The application deadline is September 2, 2015.</li>\n<li>A decision will be made by September 16, 2015, and applicants contacted.</li>\n</ul>\n<p>Because of the nature of this scholarship <a href=\"https://make.wordpress.org/community/2015/01/15/remembering-kim-parsell/\">explained here</a>, applicants must fulfill four requirements.</p>\n<ol>\n<li>A woman (this includes trans women)</li>\n<li>An active contributor to the WordPress open source project (through one of the contributor teams or as a local meetup/WordCamp organizer)</li>\n<li>Someone with financial need</li>\n<li>Someone who has never attended WordCamp San Francisco (the precursor to WCUS).</li>\n</ol>\n<p>Kim was an older woman who encouraged others, especially women around the same age group to get involved with WordPress. In light of this, older women are highly encouraged to apply for the scholarship if you meet the other requirements.</p>\n<p>Kim once told me that attending WordCamp San Francisco 2014 was one of the best experiences of her life. It was her first WordCamp San Francisco and although she was unemployed at the time, she was able to attend thanks to financial assistance received from the <a title=\"http://wordpressfoundation.org/\" href=\"http://wordpressfoundation.org/\">WordPress Foundation</a>.</p>\n<p>Thank you to Jen Mylo, the WordPress Foundation, and Matt Mullenweg for not only creating the scholarship, but for providing the opportunity for others to potentially have the same experience.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Aug 2015 20:18:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Hybrid Core 3.0 Experiments With Community-driven Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47825\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/hybrid-core-3-0-experiments-with-community-driven-documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2762:\"<p>Hybrid Core 3.0, developed by Justin Tadlock, is <a href=\"http://themehybrid.com/weblog/hybrid-core-version-3-0-mr-reynolds\">available for download</a>. More than a year in the making, 3.0 has over 269 commits and a slew of new features.</p>\n<p>After the release of Hybrid Core 2.0 last year, Tadlock assumed it would be at least two years before he tackled another major release, &#8220;I’d planned on doing minor and patch releases for a while, all along building themes,&#8221; he said.</p>\n<p>&#8220;However, a lot has changed in the theming world in just the past year. WordPress has added a lot of cool features for theme authors that were previously handled by Hybrid Core,&#8221; Tadlock said.</p>\n<p>Tadlock wants the project to feel fresh and one way to do that is to remove features that are handled natively by WordPress. Features removed from Hybrid Core include:</p>\n<ul>\n<li>Atomic hooks functionality.</li>\n<li>Random Custom Background extension.</li>\n<li>Featured Header extension.</li>\n<li>Cleaner Caption extension (handled in WP).</li>\n<li>Loop title/description (replaced by WP).</li>\n<li>Pagination (replaced by WP).</li>\n</ul>\n<p>It&#8217;s clear that the <a href=\"https://make.wordpress.org/core/2015/06/09/trust-live-preview-and-menus-in-the-customizer/\">customizer in WordPress is here to stay</a> and will be an important part of the project&#8217;s future. Hybrid Core 3.0 adds a variety of enhancements that make the customizer more flexible, these include:</p>\n<ul>\n<li>Color Palette.</li>\n<li>Multiple Checkbox.</li>\n<li>Dropdown Terms.</li>\n<li>Layout.</li>\n<li>Radio Image.</li>\n<li>Select Group.</li>\n<li>Multiple Select.</li>\n</ul>\n<p>There&#8217;s also a few customizer setting classes:</p>\n<ul>\n<li>Array Map.</li>\n<li>Image Data.</li>\n</ul>\n<h2>Tadlock Experiments with Community-driven Documentation</h2>\n<p>One of the largest changes to the Hybrid project is opening up documentation to be community-driven. The <a href=\"https://github.com/justintadlock/hybrid-core/wiki\">Hybrid Core wiki</a> hosted on Github is now open to contributions from the community.</p>\n<p>Tadlock believes that this will drive adoption of the framework by more theme authors, &#8220;The more developers we have using and contributing to the project, the better,&#8221; he said.</p>\n<p>If the community responds well to the experiment, it will allow Tadlock to focus on longer-form tutorials for club members, something he feels he&#8217;s better at doing than reference style documentation.</p>\n<p>Hybrid Core 3.0 includes a number of features, bug fixes, and improvements. If you want to see all of the changes in 3.0, check out the <a href=\"https://github.com/justintadlock/hybrid-core/blob/master/changelog.md\">lengthy changelog</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Aug 2015 19:38:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Matt: 1.6m Downloads in 23 Hours\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45306\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://ma.tt/2015/08/1-6m-downloads-in-23-hours/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:344:\"<p></p>\n<p>23 hours hours ago, WordPress 4.3 was released. <a href=\"https://wordpress.org/download/counter/\">It&#8217;s already had 1.6 million downloads and counting</a>. For a look at what&#8217;s new in this version you can watch the quick video above, or <a href=\"https://wordpress.org/news/2015/08/billie/\">check out the blog post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Aug 2015 18:01:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WPTavern: WordPress 4.3 “Billie” Named After Jazz Singer Billie Holiday Is Available for Download\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47803\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://wptavern.com/wordpress-4-3-billie-named-after-jazz-singer-billie-holiday-is-available-for-download\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10229:\"<p>After four months of development led by <a href=\"http://konstantin.obenland.it/\">Konstantin Obenland</a>, WordPress 4.3 &#8220;Billie&#8221; named after jazz singer <a href=\"http://www.billieholiday.com/\">Billie Holiday</a>, is <a href=\"https://wordpress.org/news/2015/08/billie/\">available for download</a>. This release features menus in the customizer, strong passwords by default, site icons, and variety of other improvements.</p>\n<p></p>\n<p></p>\n<h2>Menus in the Customizer</h2>\n<p>You can now create, add, and edit menus in the customizer while previewing changes to your site in real-time. Unlike other parts of the customizer, previewing menus should be fast as it uses a new hybrid transport layer. Weston Ruter, who contributed to fast previews in the customizer <a href=\"https://make.wordpress.org/core/2015/07/29/fast-previewing-changes-to-menus-in-the-customizer/\">explains the approach</a>.</p>\n<blockquote><p>We also wanted to enable fast previewing of menu changes by default. So we implemented a <code>postMessage</code>/<code>refresh</code> hybrid approach which uses <code>postMessage</code> to sync the menus settings to the preview, and then the preview does an Ajax request to render just the contents of the menu container, and this Ajax response is then inserted into the DOM to replace the previous menu container. The technical name for this approach we have been calling &#8216;partial refresh&#8217;, but you can call it fast preview.</p></blockquote>\n<p>In general, previewing menus in most themes should be a fast experience.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/menu-customizer.png\"><img class=\"size-full wp-image-47806\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/menu-customizer.png?resize=1010%2C568\" alt=\"Menu Customizer\" /></a>Menu Customizer\n<h2>Strong Passwords by Default</h2>\n<p>Mark Jaquith <a href=\"https://make.wordpress.org/core/2015/07/28/passwords-strong-by-default/\">led the effort</a> to improve the way passwords are chosen and changed in WordPress. On the account management page, clicking the Generate Password button generates a strong password by default. The password strength meter is better integrated into the password field which lets users know immediately when their password is weak.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/better-passwords.png\"><img class=\"size-full wp-image-47807\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/better-passwords.png?resize=1010%2C568\" alt=\"Better Passwords in WordPress\" /></a>Better Passwords in WordPress\n<p>The same interface is on the add new user screen, the password reset screen, and the WordPress install screen. While WordPress doesn&#8217;t require users to have a strong password, it does everything it can to encourage users to choose one.</p>\n<p>In addition, WordPress no longer emails passwords and password reset links expire after 24 hours. When your password or e-mail changes, WordPress sends you an email so if someone hijacks your browser session and changes these items, you’ll be notified that it happened, and you can take action. You can disable these e-mails via the <code>send_pass_change_email</code> and <code>send_email_change_email</code> filters by setting them to false.</p>\n<h2>Site Icons</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-3-adds-new-site-icons-feature-and-a-text-editor-to-press-this\">Site Icons</a> are images that represent a website across multiple platforms. You can configure your Site Icon in the Site Identity panel within the customizer where you can upload a 512X512 sized image. This image will be used for browsers, iOS, Android, and Microsoft devices when a visitor bookmarks your site.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/site-icon-customizer.png\"><img class=\"size-full wp-image-47808\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/site-icon-customizer.png?resize=1010%2C568\" alt=\"Site Icons in The Customizer\" /></a>Site Icons in The Customizer\n<h2>Text Patterns, Quick Link Toolbar, and Word Count Changes</h2>\n<p>The editor in WordPress 4.3 has <a href=\"http://wptavern.com/text-patterns-and-the-quick-link-toolbar-in-wordpress-4-3\">undergone more improvements</a> with text shortcuts, a quick link toolbar, and word count changes. Text patterns or text shortcuts allow you to quickly add unordered lists, ordered lists, headers, and blockquotes without having to use a mouse.</p>\n<p>When starting a new paragraph with one of these formatting shortcuts followed by a space, the formatting will be applied automatically. Press Backspace or Escape to undo.</p>\n<p>In the visual editor in WordPress 4.3, typing <code>*</code> or <code>-</code> and hitting the space bar will generate a bulleted list. Typing <code>1. </code> or  <code>1)</code> and hitting space will generate a numbered list. If you don’t want to create these lists or do so in error, clicking the undo button or hitting <code>ctrl/cmd+z</code> or <code>esc</code> will undo the text pattern.</p>\n<p>Starting a paragraph with two to six number signs <code>#</code> will convert the paragraph to a heading. Similarly, the greater-than symbol <code>&gt;</code> will convert the paragraph to a blockquote.</p>\n<ul>\n<li>## = H2</li>\n<li>### = H3</li>\n<li>#### = H4</li>\n<li>##### = H5</li>\n<li>###### = H6</li>\n</ul>\n<h3>Quick Link Preview Toolbar</h3>\n<p>When you click a link in the WordPress 4.3 visual editor, a small inline link toolbar displays the full URL with buttons to edit or remove it. This avoids having to use the Insert/edit link modal window.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/PreviewLinks.png\"><img class=\"size-full wp-image-47792\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/PreviewLinks.png?resize=571%2C102\" alt=\"Preview Links in The Visual Editor WordPress 4.3\" /></a>Preview Links in The Visual Editor WordPress 4.3\n<p>Word and character counts have also changed in WordPress 4.3. Instead of updating counts when pressing enter or return, it will refresh when you stop typing. A lot more characters that shouldn’t be counted as words are excluded. Ella Iseulde Van Dorpe, WordPress core contributor, <a href=\"https://make.wordpress.org/core/2015/07/23/wordcharacter-count-updates-in-4-3/\">lists other notable changes</a>.</p>\n<h2>Changes to the Admin Bar</h2>\n<p>WordPress 4.3 moves the Customize link to the top-level menu of the admin bar. This link opens the customizer, allowing you to manage menus, appearance, and widgets through the customizer interface.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png\"><img class=\"wp-image-46995 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png?resize=429%2C232\" alt=\"WordPress 4.2 Admin Bar\" /></a>WordPress 4.2 Admin Bar\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png\"><img class=\"wp-image-46996 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png?resize=428%2C202\" alt=\"WP43AdminBar\" /></a>WordPress 4.3 Admin Bar\n<p>The Dashboard, Themes, Widgets, and Menus links take users to their corresponding admin pages in the backend of WordPress. This makes it clear which interface users are about to enter. The enhancement is a result of <a href=\"https://core.trac.wordpress.org/ticket/32678\">ticket #32678</a> where Helen Hou-Sandí and other WordPress core contributors discussed ways to improve the context of each link over the course of five weeks.</p>\n<h2>Noteworthy Changes</h2>\n<ul>\n<li><a href=\"http://wptavern.com/wordpress-4-3-improves-user-search-and-turns-comments-off-on-pages-by-default\">Comments are turned off on pages by default</a>.</li>\n<li><a href=\"https://make.wordpress.org/core/2015/07/02/deprecating-php4-style-constructors-in-wordpress-4-3/\">PHP-4 Style constructors have been deprecated</a> to prepare for the release of PHP 7.</li>\n<li>Singular.php was added to the <a href=\"https://make.wordpress.org/core/2015/07/06/singular-php-new-theme-template-in-wordpress-4-3/\">WordPress template hierarchy.</a></li>\n<li>Changes to c<a href=\"https://make.wordpress.org/core/2015/07/27/changes-to-customizer-panels-and-sections-in-4-3/\">ustomizer panels and sections.</a></li>\n<li><a href=\"https://make.wordpress.org/core/2015/07/31/headings-in-admin-screens-change-in-wordpress-4-3/\">Header tags were updated through the admin screens</a>. Plugin, theme, and framework developers, please change the main heading from an <code>&lt;h2&gt;</code> into an <code>&lt;h1&gt;</code>. Also, check the rest of your heading structure to ensure it’s semantic.</li>\n<li><a href=\"https://make.wordpress.org/core/2015/07/24/multisite-focused-changes-in-4-3/\">Multisite focused changes in 4.3</a> specifically, the introduction of get_main_network_id()</li>\n<li><a href=\"https://make.wordpress.org/core/2015/07/30/get_transient-is-now-more-strict-in-4-3/\">get_transient() is now more strict in 4.3</a></li>\n<li>The old <a href=\"https://make.wordpress.org/core/2015/07/29/old-distraction-free-writing-code-removed-in-4-3/\">Distraction Free Writing (DFW) code has been removed</a>.</li>\n<li>The code that powered the <a href=\"https://make.wordpress.org/core/2015/07/30/legacy-theme-preview-removed-in-4-3/\">old theme preview has been removed</a>.</li>\n<li><a href=\"https://make.wordpress.org/core/2015/08/08/list-table-changes-in-4-3/\">List tables have undergone API and UI changes</a>, with the introduction of a primary column concept and easier subclassing.</li>\n</ul>\n<p>WordPress 4.3 is the result of hundreds of paid and non-paid volunteers working tirelessly to improve the software used on more than 24% of the web. If you experience any issues with WordPress 4.3, please <a href=\"https://wordpress.org/support/\">report them on the support forums</a>. Volunteers are watching support threads closely and if warranted, will create a thread listing known issues.</p>\n<p>To enjoy the full upgrade experience, I encourage you to listen to Lady sings The Blues by Billie Holiday as you upgrade your WordPress sites.</p>\n<p><span class=\"embed-youtube\"></span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Aug 2015 19:13:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Automattic is Hiring\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45297\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://ma.tt/2015/08/automattic-is-hiring-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:635:\"<p>Do you know someone who is an amazing developer or designer? Someone who is passionate about helping people? An awesome lounge manager? Or maybe that person is you. <a href=\"https://automattic.com/work-with-us/\">Automattic is hiring for a variety of positions</a>, and for all except two you can live and work wherever you like in the entire planet. There are also a number of other benefits; the main downside it&#8217;s a high performance culture and expectations are extremely high. Automattic hires the best folks regardless of geography, and we are <em>especially</em> looking for people right now outside of US timezones.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Aug 2015 16:05:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Text Patterns and the Quick Link Toolbar in WordPress 4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/text-patterns-and-the-quick-link-toolbar-in-wordpress-4-3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4590:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/QuickLinkToolbarFeaturedImage.png\"><img class=\"size-full wp-image-47794\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/QuickLinkToolbarFeaturedImage.png?resize=675%2C209\" alt=\"Quick Link Toolbar Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/34547181@N00/4309431757\">metal chain</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p>WordPress 4.3 is on schedule to be released <a href=\"https://make.wordpress.org/core/version-4-3-project-schedule/\">August 18th</a> and contains a number of improvements. Among the enhancements to the visual editor are text patterns. Text patterns or text shortcuts allow you to quickly add unordered lists, ordered lists, headers, and blockquotes without having to use a mouse.</p>\n<p>In the visual editor in WordPress 4.3, typing <code>*</code> or <code>-</code> and hitting the space bar will generate a bulleted list. Typing <code>1. </code> or  <code>1)</code> and hitting space will generate a numbered list. If you don&#8217;t want to create these lists or do so in error, clicking the undo button or hitting <code>ctrl/cmd+z</code> or <code>esc</code> will undo the text pattern.</p>\n<p>Starting a paragraph with two to six number signs <code>#</code> will convert the paragraph to a heading. Similarly, the greater-than symbol <code>&gt;</code> will convert the paragraph to a blockquote.</p>\n<ul>\n<li>## = H2</li>\n<li>### = H3</li>\n<li>#### = H4</li>\n<li>##### = H5</li>\n<li>###### = H6</li>\n</ul>\n<p>It took a few tries to figure out but once I got the hang of it, I discovered that I prefer using text patterns versus clicking the appropriate button in the editor.</p>\n<p>For example, the blockquote text pattern places text into a blockquote and automatically closes it while also starting a new paragraph. Traditionally, I highlight text and click on the blockquote button in the editor. Often times, I have to visit the text editor and close the blockquote to start a new paragraph.</p>\n<p>Ryan Boren, WordPress core lead developer, created the <a href=\"https://make.wordpress.org/core/2015/08/01/editor-enhancements-in-4-3-%E2%9C%A8/\">following video</a> which shows the text patterns in action on a mobile device.</p>\n<h2>Quick Previews of Links</h2>\n<p>WordPress 4.2 included a subtle but convenient feature for adding links to text. Pasting the URL to highlighted text automatically turns it into a link. The problem is that there isn&#8217;t an easy way to preview the URL without opening it in a new browser tab.</p>\n<p>When you click a link in the WordPress 4.3 visual editor, a small inline link toolbar displays the full URL with buttons to edit or remove it. This avoids having to use the Insert/edit link modal window.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/PreviewLinks.png\"><img class=\"size-full wp-image-47792\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/PreviewLinks.png?resize=571%2C102\" alt=\"Preview Links in The Visual Editor WordPress 4.3\" /></a>Preview Links in The WordPress 4.3 Visual Editor\n<h2>Changes to Word and Character Counts</h2>\n<p>Word and character counts have also changed in WordPress 4.3. Instead of updating counts when pressing enter or return, it will refresh when you stop typing. A lot more characters that shouldn&#8217;t be counted as words are excluded. Ella Iseulde Van Dorpe, WordPress core contributor, <a href=\"https://make.wordpress.org/core/2015/07/23/wordcharacter-count-updates-in-4-3/\">lists other notable changes</a>.</p>\n<ul>\n<li>For <strong>character</strong> count, we no longer exclude any of these characters. This means that numbers and common western punctuation are no longer excluded compared to 4.2. Emoji and other astral characters are now counted as one character instead of two.</li>\n<li>We added a new type <strong>all</strong>, in addition to words and characters, that will count characters including spaces. This seemed necessary for Japanese and maybe other languages. This is now <code>character_including_spaces</code> and <code>character_excluding_spaces</code>.</li>\n<li>Shortcodes and HTML comments are now excluded.</li>\n</ul>\n<p>To view details and a summary of all the work that went into improving word counts, check out <a href=\"https://core.trac.wordpress.org/ticket/30966\">ticket #30966</a> on trac. As someone who uses the WordPress content editor for a living, I&#8217;m anxiously looking forward to utilizing these enhancements on an everyday basis.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Aug 2015 22:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Post Status: A WordPress conference for higher education: coming to a campus near you?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=14001\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://poststatus.com/wordpress-higher-ed-conference-wordcampus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8684:\"<p><em><strong>Editor&#8217;s Note</strong>: Thus far, there have been numerous niche WordPress conferences aiming toward for-profit initiatives and geared toward businesses, marketers, or eCommerce site owners. But <a href=\"http://bamadesigner.com/\">Rachel Carden</a>&#8216;s concept for a niche, education focused, non-profit event is unique and I&#8217;d love to see it happen.</em></p>\n<p><em>As she notes, universities have unique challenges for managing websites and are also great candidates for utilizing WordPress to its full potential. What follows is her pitch and public brainstorming session on what a <a href=\"http://wordcampus.org/\">higher education focused WordPress conference</a> might look like.</em></p>\n<p>This all started with a tweet.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">Ooh. Dream with me: \"<a href=\"https://twitter.com/hashtag/WordCampus?src=hash\">#WordCampus</a>: A WordCamp for folks using <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> in Higher Education.\" I like it. <a href=\"https://twitter.com/hashtag/heweb?src=hash\">#heweb</a> <a href=\"https://t.co/m1zEkpkP4B\">https://t.co/m1zEkpkP4B</a></p>\n<p>&mdash; Rachel Carden (@bamadesigner) <a href=\"https://twitter.com/bamadesigner/status/628324358126235648\">August 3, 2015</a></p></blockquote>\n<p></p>\n<p>WordCamp U.S. made a big announcement that was all over Twitter, Chris Lema tweeted what we were all thinking, and I couldn’t help but start daydreaming about the possibilities.</p>\n<p>You see, I’m a web designer and developer with a passion for all things WordPress, especially using WordPress to build the world of higher ed web. Having spent the last 8 years working in higher education, I’m always looking for ways to utilize the power of WordPress to fulfill my campus’s needs and to help its communication grow, whether it’s using the powerful CMS to stretch limited resources or using its new API capabilities to share information, and break down silos, across campus departments.</p>\n<p>I love attending WordCamps and other WordPress-related events, but the issues we generally encounter in higher ed are often overlooked.</p>\n<p>Much like online businesses or blogging, higher ed is a world of its own with unique challenges, content, stakeholders, and target audiences. In our world, we don’t worry so much about which eCommerce plugin is best. Instead, we’re more concerned with things like how to manage a large-scale network of faculty blogs, making sure we’re abiding with FERPA regulations, or wondering how to best implement single sign-on that integrates with Active Directory.</p>\n<p>That’s why I’m proposing a new event in the WordPress community: a conference focused on using WordPress in the world of higher education. I call the idea “WordCampus”. (Kind of a perfect name, right? How did nobody think of this before?)</p>\n<p>The name “WordCampus” came to me from a tweet and does not, at this point, imply it would be an official WordCamp event. If needed, I’m open to organizing an event that is not affiliated with the WordPress Foundation. This is a detail that remains to be seen, but honestly, at this point, all details remain to be seen. A WordCamp representative has confirmed that a user group specific WordCamp is possible, but I would need to prove that it could draw a crowd. That’s why I need your help.</p>\n<p>If a WordPress conference for higher ed is something you would be interested in (whether it’s as an attendee, speaker, planner, sponsor, or all of the above), I invite you to read a few of my thoughts, share yours in the comments, and visit <a href=\"http://wordcampus.org/\">wordcampus.org</a> to show your support.</p>\n<h3>Cost and fee consideration</h3>\n<p>Much like your usual WordCamp, the goal for this event is to keep the costs and ticket price as low as possible. The point of this event is professional development and community, not profit. The phrases “big budget” and “higher ed” don’t generally appear in the same sentence anyway.</p>\n<p>A lot of higher ed-oriented web conferences can run upwards of $500 so an inexpensive, but valuable, event would be attractive for most higher education web professionals.</p>\n<h3>Unique sponsorship opportunity</h3>\n<p>Having sponsors to help with costs would be crucial and I am open to all kinds of support, whether it’s monetary or in-kind. Sponsoring an event like WordCampus would be a unique way to get an organization’s name in front of one of the best communities <em>outside</em> of WordPress that <em>uses</em> WordPress all the time.</p>\n<p>In the world of higher education, you often have limited resources, so there are plenty of opportunities for third party products or services like hosting, themes, plugins, custom design, accessibility consulting, and custom development, among others.</p>\n<h3>Location is a factor</h3>\n<p>The location could be a sticking point, as high travel costs might be a deal breaker for many WordCampus attendees. The beauty of local WordCamps is that they are tied to a geographical region and therefore, for most attendees, have limited travel requirements. This could be a problem for an event that is not tied to a specific region.</p>\n<p>Venue wise, universities have beautiful facilities, so I’d love to host the event on an actual college campus and, if the hosting university could donate the space in kind, this would be a huge cost saver. The most preferable universities would also be located near a major airport to help reduce travel time.</p>\n<p>If I’m really dreaming big, it would be great to find numerous universities that would be willing to host and, therefore, we could have regional WordCampus events spread across the country. I don’t think this is outside the realm of possibility, but would depend on interest and attendance. I&#8217;m certainly interested in hearing from anyone that may be interested in hosting WordCampus at their university.</p>\n<h3>A big target audience</h3>\n<p>There are a wide variety of WordPress users in higher ed, from the university-level WordPress developers and administrators, to the users who run WordPress for a college, to the faculty members using WordPress as a learning tool, and any students who’d love to learn a thing or two (they are our future, you know). That’s not even including content strategists, designers, social media managers, and more.</p>\n<p>WordCampus has the potential to attract a variety of users who could inspire a multitude of topics and professional development.</p>\n<h3>A broad variety of topics, even within the education umbrella</h3>\n<p>Speaking of topics, these could also run the gamut from higher ed marketing and content strategy to infrastructure, managing multi-author blogs, and streamlining application processes. Accessibility should also be a featured topic as federally funded institutions are required by law to make their electronic and information technology accessible to people with disabilities.</p>\n<p>Personally, I see the structure of higher ed as tailor-made for the open source mindset and would love to hear someone encourage collaboration and openness by comparing the ideologies of open source with the inner workings of higher education.</p>\n<h3>Event timing</h3>\n<p>As organizing something of this magnitude takes time, I’m looking at a 2016 booking. What time of the year in 2016, however, remains to be seen. There are obviously a lot of variables at play, from venue availability to which time of the year is best for our target attendees. In higher ed, you need time to clear your schedule and request funding, so I’d want to allow for that.</p>\n<p>Usually, the middle of the semester is best for most higher ed professionals, but this can vary depending on their field. And if we’re being honest, the majority of fall might be out of the question because of football season. We’ve included a straw poll <a href=\"http://wordcampus.org\">on the event landing page</a> to help us gauge which time of year might be best for those interested in attending.</p>\n<p>Thank you for taking the time to read through my proposal and hopefully interested parties will have a few additional thoughts for the comments. If you would like be notified of any future developments, or show your support for the project, please visit <a href=\"http://wordcampus.org\">wordcampus.org</a> to share a little bit of information. And don’t forget to tell your friends!</p>\n<p>If you have any questions, or would like to chat, you can also find me on Twitter <a href=\"https://twitter.com/bamadesigner\">@bamadesigner</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Aug 2015 21:33:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Rachel Carden\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Artisanal Water\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45285\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://ma.tt/2015/08/water/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:301:\"<p></p>\n<p>Many of my friends know how obsessed I am with different types of water, from <a href=\"http://www.badoit.com/\">Badoit</a> to <a href=\"https://www.drinkhint.com/\">Hint Water (yum)</a> to <a href=\"http://delaubier.ca/site_en.html\">De L&#8217;aubier</a>. This definitely hit close to home.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Aug 2015 06:38:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: SF Germ Warfare\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45300\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2015/08/sf-germ-warfare/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:258:\"<p>Speaking of San Francisco, did you know <a href=\"http://www.businessinsider.com/the-military-tested-bacterial-weapons-in-san-francisco-2015-7\">for 20 years, the military secretly tested biological/bacterial agents there, delivered through the fog</a>?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 16 Aug 2015 03:04:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Smokestack SF BBQ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/08/smokestack-sf-bbq/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:454:\"<p>I had great BBQ in San Francisco last week at a new place called Smokestack. The brisket was on-point, and competitive with anything I&#8217;ve had in Texas. <a href=\"http://insidescoopsf.sfgate.com/blog/2014/05/08/magnolia-opens-dogpatch-brewery-and-its-restaurant-smokestack/#photo-451076\">This review in the SF Chronicle covers things pretty well</a>, if you&#8217;re hankering for some great Southern food in SF this is the place to check out.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Aug 2015 05:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WP REST API 1.2.3 Patches XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47770\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://wptavern.com/wp-rest-api-1-2-3-patches-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:798:\"<p>WP REST API version 1.2.3 and 2.0 Beta 4 <a href=\"https://make.wordpress.org/core/2015/08/14/rest-api-v1-2-3-and-v2-0-b4/\">address a security issue</a> that affects sites running 1.2 or 2.0 beta. This release fixes a potential XSS vulnerability related to JSONP support in 1.2 and 2.0 of the API. Automatic updates are in progress for 1.2.3 but if your site hasn&#8217;t automatically updated, the team suggests updating manually as soon as possible.</p>\n<p>In addition to the security release, <a href=\"https://wordpress.org/plugins/rest-api/\">2.0 Beta 4</a> includes a number of enhancements, some of which break backwards compatibility. Developers and beta testers should read the <a href=\"https://github.com/WP-API/WP-API/releases/tag/2.0-beta4\">detailed changelog</a> and release notes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 15:22:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Nick Haskins Rebrands Lasso to Editus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47763\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://wptavern.com/nick-haskins-rebrands-lasso-to-editus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1876:\"<p>In mid July, Nick Haskins, founder and lead developer of Lasso, was served a <a href=\"http://wptavern.com/nick-haskins-receives-cease-and-desist-letter-for-violating-lassosoft-trademarks\">cease and desist letter</a> from LassoSoft. LassoSoft argued that Lasso violates its <a href=\"http://www.tmfile.com/mark/?q=861046116\">registered trademarks</a> and causes confusion to its customers.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/EdiusFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-47764\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/EdiusFeaturedImage.png?resize=650%2C182\" alt=\"Edit us Featured Image\" /></a>Instead of fighting litigation, Haskins decided to rebrand the product from Lasso to<a href=\"https://edituswp.com/lasso-is-now-editus/\"> Editus.</a> The name was suggested by <a href=\"http://www.iklektive.com/\">Gavin Aldrich</a>. According to Haskins, the only references to the name is a band in Costa Rica and a directory in Luxemburg.</p>\n<p>In addition to a new domain and cloned website, Lasso 0.9.8 is available for download which includes the renaming of various admin menu items that used the term Lasso.</p>\n<h2>Lasso 0.9.8 Requires a Manual Update</h2>\n<p>Haskins says users will need to update to 0.9.8 manually because of the switch in domain names but automatic updates will return after 0.9.8,  &#8220;Updates after 0.9.8, will continue to be automatic, just as the way they were before,&#8221; Haskins said.</p>\n<p>Aesopinteractive LLC is <a href=\"http://nickhaskins.com/2015/07/on-life-and-family/\">looking for a buyer</a> but after receiving low offers, Haskins has decided to use a broker to facilitate the sale. The broker requested that the rebrand of Lasso be completed before proceeding with the sale process.</p>\n<p>I think Editus has a nice ring to it, what do you think?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 13:39:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Death of Mobile Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45292\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"http://ma.tt/2015/08/death-of-mobile-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:633:\"<blockquote><p>Mobile web and mobile in-app behaviour are not binary. When users are in the facebook app, they spend a tremendous amount of time accessing the mobile web through facebook’s own in-app browser. The same for twitter and others. We enter social apps for discovery and then access the mobile web while still in-app. It is a mistake to conflate time spent on the mobile web with time spent in a traditional browser.</p></blockquote>\n<p>Amen. Tony Haile of Chartbeat: <a href=\"http://www.tonyhaile.com/2015/08/11/a-correction-around-the-death-of-the-mobile-web/\">A correction around the death of the mobile web.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 03:19:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress for iOS: Version 5.4 Adds Statistical Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/wordpress-for-ios-version-5-4-adds-statistical-insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2285:\"<p>WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">available on the app store</a> and includes a couple of new features. To compliment the <a href=\"http://wptavern.com/wordpress-for-ios-5-3-released-with-refreshed-stats-and-a-new-layout-for-posts-and-pages\">improvements to stats in 5.3</a>, 5.4 adds a new stats screen called insights.</p>\n<p>Insights is similar to the Right Now widget in the WordPress dashboard in that it displays a summary of key statistics for a site including, total number of published posts, views, visitors, and the best traffic day. There&#8217;s also a section that displays the current day&#8217;s stats.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png\"><img class=\"size-large wp-image-47744\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png?resize=282%2C500\" alt=\"Stat Insights\" /></a>Stat Insights\n<p>Prior to 5.4, you could only add images to posts that were stored on the device. WordPress for iOS 5.4 adds the ability to insert images from the WordPress media library.</p>\n<p>To add an image from the WordPress media library, select media library from the menu at the top of the screen. If you have a lot of items in the media library, it may take a few minutes to load.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png\"><img class=\"aligncenter size-large wp-image-47746\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png?resize=500%2C399\" alt=\"WP For iOS 5.4 Media Library Selection\" /></a>Other improvements include the ability to search the My Sites list and viewing embedded images in comments. This makes it easier to see the full context of a comment without having to view it in a different part of the app.</p>\n<p>Last but not least, the team fixed a bug that caused the app to not restore its state properly. WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">free and available</a> on the app store. If you encounter any issues, you&#8217;re encouraged to report them on the <a href=\"https://ios.forums.wordpress.org/\">WordPress for iOS support forums</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 20:15:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Short Interview With Nikolay Bachiyski WordPress’ Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2331:\"<p>While on stage at <a href=\"https://europe.wordcamp.org/2015/\">WordCamp Europe</a> answering a question related to WordPress’ security track record, Matt Mullenweg named <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a> as the first Security Czar for the <a href=\"https://wordpress.org/\">WordPress project</a>.</p>\n<p>I interviewed Bachiyski to learn why the role was created and what its purpose is.</p>\n<p><strong>What are the responsibilities of your new role?</strong></p>\n<p>My responsibilities are to coordinate the security efforts of<span class=\"Apple-converted-space\"> </span><a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a><span class=\"Apple-converted-space\">, </span>mostly with incident response and to make sure we respond quickly, have solid fixes, and make sure everyone involved is informed.</p>\n<p><strong>What circumstances led to this role&#8217;s creation?<br />\n</strong></p>\n<p>Nothing too spicy around the creation of the role. As the volume of requests increased, we realized a bit more structure would be helpful so that we are more focused and use our resources wisely.</p>\n<p><strong>Will you only handle security issues for the open source project or will you also help with Automattic’s bounty program as well?</strong></p>\n<p>There are other colleagues at Automattic who are responsible for the bounty program.</p>\n<p><strong>How important are the connections and trust you’ve established over the last 11 years to your role?</strong></p>\n<p>Offline relationships are very important in an online community and I am lucky to know many of the members of the security team in person. This definitely makes working with them easier.</p>\n<h2>Learn More About the WordPress Security Team</h2>\n<p>If you&#8217;d like to learn more about who&#8217;s on the WordPress security team, what they do, and how they handle security releases, listen to my interview with Gary Pendergast.</p>\n<p>Pendergast who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team. In the interview, we discuss what happened behind the scenes before <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">4.2.3 was released</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 18:26:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: WPWeekly Episode 203 – Interview With Kiko Doran Co-organizer of Prestige Conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47721&preview_id=47721\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/wpweekly-episode-203-interview-with-kiko-doran-co-organizer-of-prestige-conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2165:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://kikodoran.com/\">Kiko Doran</a>, co-organizer of <a href=\"http://prestigeconf.com/\">Prestige conference</a>. Doran describes how he discovered WordPress in 2009 and explains the origin of Prestige, a career and business development conference.</p>\n<p>We discuss the <a href=\"http://wptavern.com/the-mantra-of-family-comes-first\">mantra of family first </a>and how Brazilian Jiu Jitsu helps him in his everyday life. Near the end of the interview, we learn Prestige 4 is in the planning stages.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\">WordPress Plugin Directory Surpasses One Billion Total Downloads</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/site-import/\">Site Import</a> allows you to import posts and items from other websites without having to export anything. The content is extracted directly from the site.</p>\n<p><a href=\"https://wordpress.org/plugins/followprice/\">Followprice</a> adds a button to your storefront that when clicked, saves products into a universal wish list. This allows visitors to subscribe and receive price or stock alerts from your store.</p>\n<p><a href=\"https://wordpress.org/plugins/revision-strike/\">Revision Strike</a> is designed to automatically remove unneeded revisions on older, published posts.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 19th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #203:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 16:31:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: Avis GPS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/avis-gps/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2713:\"<p>After an amazing WordCamp Scranton on Saturday I was heading to a friend&#8217;s birthday on Long Island on Sunday, a few people were surprised I had flown from New York and said driving took about the same amount of time when you factor in all the airport hassle.</p>\n<p>I Google Mapped it and it did look like it was only 5-6 hours from Scranton to where I was going. Being a born and raised Texan, I love a good drive, and I probably haven&#8217;t had a proper road trip since my sister&#8217;s birthday a few years ago when we went up Highway 1. I&#8217;ve also never driven on the East Coast, and it seemed like there were some really pretty parks and lakes in between Scranton and Long Island so I ended up going to the airport anyway because that&#8217;s where the rental cars were.</p>\n<p>I like <a href=\"http://www.avis.com/\">Avis</a>. They try harder. <img src=\"http://i2.wp.com/s.ma.tt/blog/wp-includes/images/smilies/simple-smile.png?w=604\" alt=\":)\" class=\"wp-smiley\" /> One thing they do that&#8217;s pretty cool is sell  decent cables, USB wall chargers, and car chargers for a cheap price right at the check-in desk. (I always carry my own car charger, <a href=\"http://www.amazon.com/Incase-Speed-Charger-Lightning-Cable/dp/B00P7Y6M2Y/\">this is my current pick</a>. It&#8217;s super-handy in Ubers as well.) Amazingly though they still try to give you one of those Garmin GPS units that&#8217;s worse than your smartphone in every possible way. I&#8217;m sure it&#8217;s a money maker, otherwise the only reasonable thing to do would be provide <a href=\"http://www.amazon.com/dp/B00O5JARCI\">a smartphone mount</a> (or have one already set up in the car) rather than saddling people with an <a href=\"http://www.amazon.com/gp/bestsellers/electronics/559938/ref=zg_b_bs_559938_1\">archaic, non-networked navigation device</a> that has no idea about construction or traffic.</p>\n<p>I ended up going to a Walmart that was nearby to pick up a car mount (price, $12) that ended up being a life-saver for the trip. <strong>I also believe that every person in tech should visit Walmart at least once a year, and spend time in their technology section.</strong> It&#8217;s good to understand and see how people who don&#8217;t live for technology every day interact with it. It&#8217;s eye-opening, and it&#8217;s handy to know what&#8217;s in stock in case you need 50 feet of ethernet at 4 AM.</p>\n<p>Dropping the car off in Manhattan, it looks like they charged me $20 for a GPS which I don&#8217;t even have, so now going to need to sort out both the fee and the &#8220;missing&#8221; GPS system.</p>\n<p>tl; dr: Smart car rental companies should ditch the GPS, provide smartphone mounts instead.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 02:44:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Filled With Wonder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/08/filled-with-wonder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<blockquote><p>Teach when you are filled with wonder, before you become a boring expert.</p>\n<p>— Mark Pilgrim</p></blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Aug 2015 01:44:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Organizing Team Explains Why Philadelphia Should Host WordCamp US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47699\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/organizing-team-explains-why-philadelphia-should-host-wordcamp-us\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2198:\"<p>When organizing teams in different <a href=\"http://wptavern.com/wordcamp-us-2015-now-accepting-applications-for-host-city\">cities applied to host</a> WordCamp US earlier this year, they provided a substantial amount of information through the application process. While <a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia will host</a> the event in 2015 and 2016, their application is not public information.</p>\n<p>Juliana Reyes, who writes for <a href=\"http://technical.ly/philly\">Technical.ly Philly</a>, acquired and <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">published a few</a> of the responses from the organizing team&#8217;s application, specifically questions four, nine, ten, and eleven.</p>\n<p>Question nine on the application asks, why do you think your city should host WordCamp US 2015? The organizing team responded:</p>\n<blockquote>\n<p dir=\"ltr\">Philadelphia is the birthplace of our nation. The United States started here, and so should WordCamp US.</p>\n<p dir=\"ltr\">We’re ideally situated on the East Coast between New York and Washington DC, and the halfway point between the West Coast and parts of Europe.</p>\n<p dir=\"ltr\">With a population of 1.5 million, it is the 5th largest city in North America, and is a cultural hub for all things food, music, art, and technology. It is well-known for its many excellent medical and educational facilities, including the University of Pennsylvania, Temple University, Drexel University, and the University of the Sciences.</p>\n<p dir=\"ltr\">With over 1,200 daily inbound and outbound flights, Philadelphia is easy to reach from anywhere in the world. The average hotel room and cost of living, is far below any other major East Coast city, and nowhere else has cheesesteaks like we do.</p>\n</blockquote>\n<p dir=\"ltr\">I&#8217;ve yet to visit Philadelphia but one thing I&#8217;ve learned is that residents take their reputation for cheesesteaks seriously. Be sure to read <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">the post</a> to see the team&#8217;s responses to the other three questions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 18:58:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: ThemeConf a Conference for Front-End Developers and Designers September 2nd-4th, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47686\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/themeconf-a-conference-for-front-end-developers-and-designers-september-2nd-4th-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2009:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png\"><img class=\"alignright size-full wp-image-47688\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png?resize=215%2C181\" alt=\"ThemeConf Logo\" /></a><a href=\"http://themeconf.com/\">ThemeConf</a> is a new conference set to take place September 2nd-4th, 2015, in Keswick, England aimed at front-end developers and designers. Confirmed speakers include a handful of Automattic theme wranglers, Noel Tock of Human Made, freelancer Adam Onishi, and Chris Hutchinson of The Times.</p>\n<p>The session schedule is expected to be released later this week however, here are some of the topics that will be covered at the event.</p>\n<ul>\n<li>Craft, workflow and best practices</li>\n<li>Browser performance and developer tools</li>\n<li>Design and photography</li>\n<li>JavaScript and REST APIs</li>\n<li>User experience</li>\n<li>Build tools</li>\n</ul>\n<p>Jack Lenox and Tammie Lister, who are the primary organizers of the event, originally came up with the idea for ThemeConf at the Automattic UK Christmas dinner, &#8220;Lenox wanted to bring a conference to where he lives in the Lake district and I wanted to do one focusing on themes,&#8221; Lister said.</p>\n<p>The two have been planning the event since January of this year. Although most of the confirmed speakers work with WordPress, ThemeConf is not dedicated to it, &#8220;It&#8217;s geared to those making themes in general and working on the front end. We have tried hard not to focus on WordPress,&#8221; Lister said.</p>\n<p><a href=\"https://ti.to/themeconf/2015\">Tickets for ThemeConf</a> are £49 and £99 respectively. The £49 tickets are for speaker sessions only while the £99 tickets include access to a workshop on using the REST API and lunch. Accommodations in the Lake District two hours from Manchester, Glasgow, Edinburgh, Newcastle, Liverpool and Leeds are available through <a href=\"http://www.keswick.org/\">Keswick.org.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 16:37:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: $46M Scam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/46m-scam/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"<p>An incredible story: <a href=\"http://krebsonsecurity.com/2015/08/tech-firm-ubiquiti-suffers-46m-cyberheist/\">Tech Firm Ubiquiti Suffers $46M Cyberheist</a>. Notable for two reasons: I love Ubiquiti&#8217;s products, <a href=\"https://www.ubnt.com/products/#enterprise\">especially their Unifi line</a>, and I&#8217;ve never heard of phishing getting so much from a single victim.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 06:33:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: WordPress Plugin Directory Surpasses One Billion Total Downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1706:\"<p>The WordPress project achieved a milestone earlier today as the official WordPress plugin directory <a href=\"https://wordpress.org/plugins/\">surpassed one billion</a> total downloads.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png\"><img class=\"size-full wp-image-47674\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png?resize=944%2C312\" alt=\"One billion total plugin downloads\" /></a>More than one billion total downloads\n<p>According to Scott Reilly who helps maintain WordPress.org, we&#8217;ll never know which plugin generated the one billionth download. That&#8217;s because WordPress.org doesn&#8217;t log information that matches downloads to plugins.</p>\n<p>&#8220;A download counter exists for each plugin for each day and the total amount is the summation of all those daily download counts,&#8221; Reilly said.</p>\n<p>As WordPress&#8217; <a href=\"http://w3techs.com/technologies/details/cm-wordpress/all/all\">market share</a> continues to grow, so does the amount of downloads from the plugin directory. The following numbers are the total amount of downloads from March 2006 to August 2015. This year, the directory is on pace to serve more than 300 million downloads.</p>\n<ul>\n<li>March 2006  191,567</li>\n<li>2007  2,845,802</li>\n<li>2008  15,130,856</li>\n<li>2009  49,822,116</li>\n<li>2010  72,342,598</li>\n<li>2011  108,501,907</li>\n<li>2012  141,609,682</li>\n<li>2013  182,236,517</li>\n<li>2014  241,142,505</li>\n<li>January 2015 to August 2015  186,243,700</li>\n</ul>\n<p>It took nine years for the plugin directory to reach one billion downloads, when do you think it will reach two billion?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 03:41:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: SkiPress a Week Long Excursion in the French Alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47654\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/skipress-a-week-long-excursion-in-the-french-alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1333:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-47658\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png?resize=852%2C269\" alt=\"SkiPress Featured Image\" /></a>If you enjoy skiing and WordPress, mark your calendars for <a href=\"http://skipressweek.com/\">SkiPress</a>, November 21-28, 2015. SkiPress is a week long excursion to Serre Chevalier, a ski resort in the French Alps. The cottage can hold up to 15 people where attendees can ski, discuss WordPress, develop code, or disconnect from technology.</p>\n<p><a href=\"http://skipressweek.com/\">Bernard-Jacquet</a> who writes for <a href=\"http://wp-spread.com\" target=\"_blank\">WP-spread</a>, and helps organize the local WordPress meetup in Grenoble, France, is organizing the event.</p>\n<p>Rooms at the cottage cost 350 euros. This amount covers the room for a week plus dinner at two restaurants. Prepare to bring some extra cash as the bus, skipass, and ski rental are additional costs.</p>\n<p>There&#8217;s not an official deadline to book a room but the sooner you book the better. If you&#8217;re interested in booking a room, please <a href=\"http://skipressweek.com/\">contact Berard-Jacquet</a> as soon as possible so he can make arrangements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 20:29:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Richard Best Publishes Human Readable Version of the GPLv2 License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/richard-best-publishes-human-readable-version-of-the-gplv2-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2234:\"<p>WordPress is licensed under the <a href=\"https://wordpress.org/about/gpl/\">GPLv2</a> and the four freedoms it allows is considered to be its <a href=\"http://ma.tt/2014/01/four-freedoms/\">Bill of Rights</a>. The four freedoms are:</p>\n<ol start=\"0\">\n<li>The freedom to run the program, for any purpose.</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish.</li>\n<li>The freedom to redistribute copies so you can help your neighbor.</li>\n<li>The freedom to distribute copies of your modified versions, giving the community a chance to benefit from your changes.</li>\n</ol>\n<p>There is a lot more to the GPL than the four freedoms listed above however, the license details can be difficult to read and decipher. Richard Best, a qualified lawyer in New Zealand, England, and Wales, has published a <a href=\"http://wpandlegalstuff.com/a-human-readable-summary-of-the-gpl/\">human readable summary</a> of the GPL license.</p>\n<p>Inspired by how Creative Commons offers a <a href=\"http://creativecommons.org/licenses/by/3.0/\">human readable version</a> of its licenses, the summary explains the core concepts of the GPL and outlines the position in relation to copying, distribution, fees, modifications/derivative works, distributing non-source forms, termination, and downstream licensing.</p>\n<p>It&#8217;s important to note that the document is not endorsed by the Free Software Foundation nor a substitute for the full license text.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png\"><img class=\"size-full wp-image-47647\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png?resize=705%2C554\" alt=\"Sample of the human readable summary of the GPL\" /></a>Sample of the human readable summary of the GPL\n<p>I encourage everyone participating in the WordPress ecosystem to read the <a href=\"https://wordpress.org/about/gpl/\">full license</a> text at least once. However, the summary does a good job explaining the core components of the GPL without having to dig into the license.</p>\n<p>If you have questions concerning the GPL, I suggest seeking legal council with a lawyer familiar with software licensing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 18:31:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WPWeekly Episode 202 – Prestige is Serious Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47628&preview_id=47628\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/wpweekly-episode-202-prestige-is-serious-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2339:\"<p>On this week&#8217;s episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I talk about the news of the week, including the release of WordPress 4.2.4 which patches six security vulnerabilities.</p>\n<p>I shared my experience attending Prestige last weekend while Marcus describes what it was like to watch the livestream. Marcus and I closed out the show with a candid conversation on the difficulty of achieving balance between work and life.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">WordPress 4.2.4 Patches Six Security Vulnerabilities</a><br />\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\"> Recap of Prestige a Conference Geared Towards Growing Businesses</a><br />\n<a href=\"http://nickhaskins.com/2015/07/on-life-and-family/\"> Aesop Interactive LLC For Sale</a><br />\n<a href=\"http://wptavern.com/the-mantra-of-family-comes-first\"> The Mantra of Family Comes First</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/export-plugins-and-templates/\">Export Plugins and Templates</a> exports your plugins and templates to a Zip file directly from the WordPress dashboard.</p>\n<p><a href=\"https://wordpress.org/plugins/expire-posts/\">Expire posts</a> automatically expires posts in WordPress and supports custom post types.</p>\n<p><a href=\"https://wordpress.org/plugins/local-seo-and-business-listings/\">Local SEO and Business Listings</a> allows you to optimize your local business website through a step by step actionable Local SEO Guide and a host of tools proven to increase web rankings.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 12th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #202:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 16:20:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: The WordPress Core Team Receives Praise for Their Efforts to Maintain Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47619\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"http://wptavern.com/the-wordpress-core-team-receives-praise-for-their-efforts-to-maintain-security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1832:\"<p>Netanel Rubin, a vulnerability researcher for <a href=\"http://www.checkpoint.com/\">Check Point Software</a> and <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">credited</a> for properly disclosing a security vulnerability to WordPress, published the <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">first in a trilogy of posts</a> that explains how he discovered it.</p>\n<p>The vulnerability was discovered during a full audit of WordPress&#8217; code base in which Rubin praised the efforts of the WordPress development team.</p>\n<blockquote><p>In contrast to these frequent findings in 3rd party plug-ins’ code, barebones WordPress issues are rare, as WordPress core developers are well-trained to hold high security awareness for all released code.</p>\n<p>We can confirm that during our audit of the source code, we witnessed the developers ‘leaving nothing to chance’, and implementing multiple layers of security protecting most attack vectors we could think of.</p>\n<p>WordPress developers deserve praise for their efforts to maintain such complex software in this level of security, specifically considering the presence of the notoriously trigger-happy foot-gun called PHP.</p></blockquote>\n<p>I recommend <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">reading the post</a> as it&#8217;s a brief look into the mind of a <a href=\"https://en.wikipedia.org/wiki/White_hat\">white hat</a> security researcher.</p>\n<p>Although WordPress has <a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">seen its fair share</a> of security related releases this year, it&#8217;s reassuring to hear a third-party whose job it is to penetrate software security praise WordPress&#8217; codebase.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Aug 2015 00:05:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WPTavern: The Mantra of Family Comes First\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47609\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wptavern.com/the-mantra-of-family-comes-first\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2219:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png\"><img class=\"size-full wp-image-47611\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png?resize=669%2C247\" alt=\"Family First Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/63122283@N06/11867028263\">Mama&#8217;s </a>&#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>At <a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\">Prestige over the weekend</a>, I heard a presenter say that family comes first. This isn&#8217;t the first time I&#8217;ve heard this advice but it&#8217;s becoming more prevalent. I generally hear this advice from those who are living comfortably, have two kids or more, and/or have gone through the startup process more than once.</p>\n<p>I&#8217;m a distributed worker who receives a check every two weeks. I&#8217;m married, have no kids, and write about WordPress for a living. Putting family first should be easy but it&#8217;s not. The last two years as a distributed worker, I&#8217;ve put work before family unless it&#8217;s an emergency.</p>\n<p>Two weeks ago, my wife and I had a serious conversation about the way I work and how it has negatively impacted our marriage. I&#8217;m a late owl and on most nights, my wife sleeps alone. As a distributed worker, I get to make the rules and put myself in the best environment to get the job done.</p>\n<p>The conversation with my wife involved words not fit for reproduction but everything she said was right. I&#8217;m spending too much time on digital devices and not enough with her. Our conversation was the wake up call I didn&#8217;t know I needed.</p>\n<p>It&#8217;s not easy putting family first all the time. Some argue that you need to put yourself before family so that you can provide for them. Others find a critical balance between spending time with family and getting the job done.</p>\n<p>How do you put family first when there are bills that need to be paid, sites to be built, and a constant deluge of work to be done? Please share your thoughts, experiences, and advice in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Aug 2015 01:43:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WordPress 4.2.4 Patches Six Security Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47605\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2004:\"<p>WordPress <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">4.2.4 is available</a> and patches six security vulnerabilities. The vulnerabilities were discovered by outside parties and members of the WordPress core security team. This release also fixes four bugs:</p>\n<ul>\n<ul>\n<li>WPDB: When checking the encoding of strings against the database, make sure we&#8217;re only relying on the return value of strings that were sent to the database. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/32279\">#32279</a></li>\n<li>Don&#8217;t blindly trust the output of <tt>glob()</tt> to be an array. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33093\">#33093</a></li>\n<li>Shortcodes: Handle <tt>do_shortcode(\'&lt;[shortcode]\')</tt> edge cases. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33116\">#33116</a></li>\n<li>Shortcodes: Protect newlines inside of <tt>CDATA</tt>. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33106\">#33106</a></li>\n</ul>\n</ul>\n<p>It&#8217;s been a busy year for the WordPress security team. Since the beginning of the year, there has been five security releases.</p>\n<ul>\n<ul>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-1-2/\">WordPress 4.1.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\">WordPress 4.2.1</a></li>\n<li><a href=\"https://wordpress.org/news/2015/05/wordpress-4-2-2/\">WordPress 4.2.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\">WordPress 4.2.3</a></li>\n<li><a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">WordPress 4.2.4</a></li>\n</ul>\n</ul>\n<p>Users should check their sites to make sure they&#8217;re running 4.2.4. If your site hasn&#8217;t automatically updated yet, you should perform a full backup and manually update. Sites running WordPress RC 2 are safe since it fixes the same issues as 4.2.4.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 23:45:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Recap of Prestige a Conference Geared Towards Growing Businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4245:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png\"><img class=\"size-full wp-image-47595\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png?resize=677%2C268\" alt=\"Tony Perez of Sucuri\" /></a>Tony Perez of Sucuri Presenting on Security at Prestige\n<p>Over the weekend, I attended <a href=\"http://prestigeconf.com/\">Prestige</a>, a conference geared towards freelancers, entrepreneurs, and small agencies looking to grow their businesses. Unlike WordCamps, plugins, themes, and WordPress in general were rarely mentioned. Instead, sessions included high level topics such as, how to land enterprise clients, knowing when to move on to the next big thing, and the benefits of partnerships.</p>\n<p>The venue was perfect with plenty of space and the WiFi worked well. Lunch was an hour-long and provided on both days. The lunchroom can easily seat 300 people or more. Only a third of the space was used when attendees ate lunch providing a great environment to network with people.</p>\n<h2>Nancy Lyons and Technology&#8217;s Dirty Little Secret</h2>\n<p>Since I don&#8217;t deal with clients or own an agency, many of the sessions at Prestige are non-applicable to my day job. However, there is one session in particular that resonated with me. <a href=\"http://www.nancylyons.com/\">Nancy Lyons</a>, founder and CEO of <a href=\"http://www.clockwork.net/\">Clockwork</a>, shared her philosophies on hiring and getting employees engaged. Happy employees do good work but what makes them happy?</p>\n<ul>\n<li>Autonomy:  Control over time, technique, team, or task.</li>\n<li>Mastery: Make progress and get better.</li>\n<li>Purpose: Be part of something bigger.</li>\n</ul>\n<p>A lot of the tips shared by Lyons are geared towards employers but they&#8217;re just as applicable to employees. The biggest danger to agencies and freelancers is the inability to have conversations with clients about what is and isn&#8217;t possible. According to Lyons, you can love someone and still tell them what they need to hear. One of the best tips she shared is to find and have fun at work as there&#8217;s nothing wrong with having fun.</p>\n<h2>Behind the Scenes of the Livestream</h2>\n<p>Prestige is <a href=\"http://prestigeconf.com/free-livestream-minneapolis-2015/\">known for having</a> a high quality livestream where more than 1,000 people can watch the conference live. The livestream is produced by <a href=\"http://pixpromedia.com/\">PixProMedia</a>. The gentleman in charge uses a TriCaster to switch between speakers and slides during sessions. Here are a couple of photographs of his equipment.</p>\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses#gallery-47580-1-slideshow\">Click to view slideshow.</a>\n<p>According to some viewers, watching the livestream was like being at the conference but is not a substitute for face-to-face interactions.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">.<a href=\"https://twitter.com/jeffr0\">@jeffr0</a> The learning is like being there.  I miss the handshakes in the hallway, meeting people face-to-face.&#10;&#10;<a href=\"https://twitter.com/hashtag/prestigeconf?src=hash\">#prestigeconf</a></p>\n<p>&mdash; Cate DeRosia (@mysweetcate) <a href=\"https://twitter.com/mysweetcate/status/627924263799009280\">August 2, 2015</a></p></blockquote>\n<p></p>\n<h2>Westwerk Is a Great Venue for After Parties</h2>\n<p>The after party was held at <a href=\"http://westwerk.com/\">Westwerk</a>, a WordPress development agency and primary sponsor of the event. Their office was perfect for an after party as it includes, a foosball table, Nintendo Wii, shuffleboard, drinks, pool table, and small offices for private conversations. It&#8217;s one of the best after parties for a conference that I&#8217;ve attended.</p>\n<h2>Prestige is Serious Business</h2>\n<p>It may seem like a WordPress conference on the surface but Prestige is geared towards business minded people. It&#8217;s highly focused and filled with information you can apply to companies in and outside of WordPress. If you want to learn how to take your business to the next level, Prestige is an excellent value.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 20:40:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: How to Avoid This Embarrassing Sharing Bug on WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47476\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://wptavern.com/how-to-avoid-embarrassing-sharing-bug-on-wordpress-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1804:\"<p>If you use the sharing feature on WordPress.com, you may have noticed an anomaly between your post title and what&#8217;s shared to social services. Since the post title is the first field to complete when writing a post, it makes sense to fill it in even if it&#8217;s a work in progress.</p>\n<p>The sharing module on WordPress.com has a bug where the initial text in a post title is used when sharing the post to social networks. For the past several months, I&#8217;ve published many articles on WordPress.com where the text within social links does not match the text used in the post title leaving me feeling embarrassed.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png\"><img class=\"size-full wp-image-47477\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png?resize=728%2C482\" alt=\"WordPress.com Bug in Action\" /></a>WordPress.com Bug in Action\n<p>To avoid this embarrassment, you&#8217;ll need to alter the text used in the sharing module before publishing each post. If you&#8217;re using the New Dash interface on WordPress.com, locate the Sharing metabox as seen in the screenshot above. When you&#8217;re ready to hit the publish button, change the text to match your title.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png\"><img class=\"size-full wp-image-47478\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png?resize=571%2C462\" alt=\"Post Title Matches the Sharing Text\" /></a>Post Title Matches the Sharing Text\n<p>I&#8217;ve spoken to several Automattic employees at various WordPress events and they&#8217;re aware of the bug. Until it&#8217;s fixed, you&#8217;ll need to remember to change the sharing text before you publish a post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 21:52:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPWeekly Episode 201 – Interview With Paul Gibbs and John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47469&preview_id=47469\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://wptavern.com/wpweekly-episode-201-interview-with-paul-gibbs-and-john-james-jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2500:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://byotos.com/\">Paul Gibbs</a> and <a href=\"http://jjj.me/\">John James Jacoby</a>. Jacoby shares what he learned and accomplished <a href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">working on bbPress and BuddyPress</a> full-time for six months.</p>\n<p>Gibbs explains his motivation to organize the first ever <a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton, UK</a>, that takes place on August 8th. We also discuss a new working group dedicated to possibly bringing back <a href=\"http://backpress.org/\">BackPress</a>. Last but not least, Gibbs and Jacoby offer their opinions on <a href=\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\">PeepSo</a>, a new social networking plugin for WordPress.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia, PA to Host WordCamp US December 4th–6th</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/gallery-for-instagram/\">Instagram Gallery</a> displays a gallery from one or more Instagram accounts.</p>\n<p><a href=\"https://wordpress.org/plugins/backup-amazon-s3/\">Amazon S3 Backup and Restore</a> enables you to create full backups to Amazon S3 and restore, duplicate, clone, or migrate your site.</p>\n<p><a href=\"https://wordpress.org/plugins/responsivevoice-text-to-speech/\">ResponsiveVoice Text To Speech</a> is a HTML5 based text-to-speech library designed to add voice features to WordPress across all smart phone, tablet, and desktop devices. It supports 51 languages through 168 voices and has no dependencies.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 5th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #201:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 19:45:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Hong Kong Morning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45280\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/07/hong-kong-morning/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"<p><span class=\"embed-youtube\"></span></p>\n<p>The upside of jet lag, like <a href=\"http://om.co/2015/07/10/paris-je-laime/\">Om discovering the streets of Paris</a>, are enjoying parts of the day you might not normally be awake for, like a beautiful sun rise. Here&#8217;s a time lapse I made of the Victoria Harbor in Hong Kong taken from the incredible view I have in my room.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 23:40:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Postmatic Brings 100% Realtime Commenting to WordPress with Epoch Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=44317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/postmatic-brings-100-realtime-commenting-to-wordpress-with-epoch-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7876:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg?resize=919%2C443\" alt=\"epoch\" class=\"aligncenter size-full wp-image-47416\" /></a></p>\n<p>The team behind <a href=\"https://gopostmatic.com/\" target=\"_blank\">Postmatic</a> is aiming to breathe new life into WordPress native comments with the 1.0 release of <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">Epoch</a> today. The plugin was created to provide a Disqus alternative with faster loading and submitting for comments.</p>\n<p>Epoch&#8217;s creators set an ambitious goal for themselves on the plugin&#8217;s description page:</p>\n<blockquote><p>The goal: To provide a realtime commenting/chat experience using fully native comments while being compatible with page caching, CDNs, mobile, other comment plugins, and SEO best practices.</p></blockquote>\n<p>The plugin submits comments via AJAX, which means that comments appear instantly within the conversation without refreshing the page. The experience is designed to be so fast that it blurs the line between commenting and chatting, as comments from other readers also show up automatically with the same speed. The video below shows the plugin in action and a <a href=\"https://gopostmatic.com/epoch/#reply-title\" target=\"_blank\">live demo of Epoch</a> is available on the Postmatic website.</p>\n<p></p>\n<p></p>\n<p>Epoch <a href=\"https://wordpress.org/plugins/epoch/changelog/\" target=\"_blank\">version 1.0</a> boasts compatibility with virtually any WordPress theme. The plugin will attempt to integrate with your theme via one of three ways:</p>\n<ul>\n<li>The first tries to continue using your existing comment template while still offering all the performance gains</li>\n<li>The second overrides your comment template but inherits typography and colors from your theme</li>\n<li>The third totally replaces your comment template à la Disqus or Jetpack Comments</li>\n</ul>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png?resize=1025%2C839\" alt=\"epoch-theme-integration\" class=\"aligncenter size-full wp-image-47442\" /></a></p>\n<p>Unlike Postmatic, which has a <a href=\"https://gopostmatic.com/premium/\" target=\"_blank\">commercial option</a> for additional features, founder Jason Lemieux says Epoch will not be directly monetized.</p>\n<p>&#8220;We do not have any plans to create a commercial version,&#8221; he said. &#8220;Postmatic is our primary product, Epoch exists only to make it easier for people to move back to native commenting, and in turn to use Postmatic. Epoch will be free forever.&#8221;</p>\n<h3>Compatibility with Other Comment Plugins</h3>\n<p>Epoch works seamlessly with Postmatic, i.e. it will pop up an opt-in modal allowing the commenter to subscribe to new post notifications. Using Postmatic in combination with Epoch is not required, because the plugin was created to work well on its own. It&#8217;s also compatible with many other plugins that extend comments.</p>\n<p>&#8220;Other third party native commenting plugins have taken a heavy-handed approach and do not support the comment template hooks built into WordPress,&#8221; Lemieux said. &#8220;This creates a walled garden in which the innovation and hard work present in existing and future comment plugins is left out.</p>\n<p>&#8220;We decided to take a different approach. We built Epoch to be compatible with other comment plugins as much as possible. Not all are, but with little tweaks here and there they work just fine.&#8221;</p>\n<p>Version 1.0 integrates perfectly out of the box with Postmatic, WordPress Zero Spam, Akismet, WP Markdown, and WordPress Social Login.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png?resize=1025%2C583\" alt=\"epoch-plugin-compatibility\" class=\"aligncenter size-full wp-image-47447\" /></a></p>\n<p>&#8220;In our testing most anything that does not use a lot of JavaScript works just fine,&#8221; Lemieux said. &#8220;Things I haven&#8217;t tested but I assume would work would be anything that modifies or adds fields to the comment form (Subscribe to Comments, CommentLuv, various captchas).</p>\n<p>&#8220;Fancier plugins that allow for comment editing or sorting the comment order based on voting would probably not be happy. We will have to make that functionality ourselves.&#8221;</p>\n<h3>Epoch is a Disqus Alternative with an Emphasis on Privacy</h3>\n<p>When Lemieux and his team created Epoch, the strategy was to address problems with native commenting in order to pave the way for more users to get on board with Postmatic.</p>\n<p>&#8220;We didn&#8217;t set out with intentions of competing with Disqus,&#8221; he said. &#8220;However, a few months in it became clear that there are usually two reasons people were not using native comments, and we would need to address both if we wanted widespread adoption of Postmatic.</p>\n<p>&#8220;The first is that the comment templates that come with a huge majority of themes just plain stink. Theme developers hate dealing with them. It&#8217;s usually an afterthought. So the commenting experience suffers. It is slow, ugly, and not at all fun.</p>\n<p>&#8220;The second reason is that native commenting is extremely hard on the server. You can&#8217;t run native comments on a high traffic site. The server would buckle. A CDN won&#8217;t save you because the page content is constantly changing. For larger sites, native commenting is not even an option.</p>\n<p>&#8220;Both of these problems are solved easily with solutions like Livefyre or Disqus, so they get installed. But it&#8217;s just selling your users down the river. Your data is not yours, ads start showing up on your site. Privacy is out the window. And really, the performance gains are minimal when the embedded comments still take 10 second to load because there is so much tracking JavaScript being queued up in the background.&#8221;</p>\n<p>In contrast, Epoch loads faster than third party solutions and is completely private. Your commenters&#8217; data is not farmed out and comments stay on your server.</p>\n<p>&#8220;For the first time someone can say this: running native WordPress commenting will actually increase your site performance,&#8221; Lemieux said.</p>\n<h3>What&#8217;s on the roadmap for the future of Epoch?</h3>\n<p>Lemieux and his team hope to attract a larger community around the project, which is <a href=\"https://github.com/postmatic/epoch\" target=\"_blank\">open to contribution on GitHub</a>.</p>\n<p>&#8220;We plan on aggressively recruiting others to join the project and we hope other developers will be inspired by what we have started,&#8221; he said.</p>\n<p>&#8220;We are going to build out a small API to make it easier for other plugins to hook into some of the advanced functionality.</p>\n<p>&#8220;And there are a few things that feel like they may be necessary: comment voting and a simple little like button which would be handy as a way to say, &#8216;I appreciate what you said, I do not have anything else to add.&#8217; I would love to integrate that with Postmatic. I often will get a comment in my inbox and I want to recognize the thought that went into it, but don&#8217;t feel like I have anything to add. A simple little +1 would do it nicely,&#8221; Lemieux said.</p>\n<p>The 1.0 release of Epoch is exciting news for those who have been dissatisfied with WordPress native comments but are hoping for a reason to return. The plugin is open source and <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">available for free on WordPress.org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 17:45:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Yuuta: A Free Visual Diary Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47303\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/yuuta-a-free-visual-diary-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4045:\"<p>Earlier this month, <a href=\"http://wptavern.com/new-proposal-on-trac-to-remove-post-formats-from-wordpress-core\" target=\"_blank\">a new proposal landed on trac</a>, advocating the removal of <a href=\"http://codex.wordpress.org/Post_Formats\" target=\"_blank\">post formats</a> from core. Many believe that this feature would be better as a plugin, since it has received little improvement over the years and is not used by the majority of WordPress users.</p>\n<p>If the UI can be improved to be less confusing and theme support is standardized, post formats may have a chance at more widespread adoption. The feature is entirely dependent on theme support, as post formats are not enabled by default unless the theme author opts to include them. Many still do, which is why ripping them out of core in favor of a plugin would be a major undertaking.</p>\n<p>One of the most common use cases for post formats is a diary style WordPress theme. <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> is a relatively popular theme on WordPress.org that revolves entirely around post formats. In the past four months, it has been downloaded more than 7,000 times. Yuuta was created to serve as a visual diary and includes support for all nine of WordPress&#8217; post formats.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png?resize=880%2C660\" alt=\"yuuta\" class=\"aligncenter size-full wp-image-47392\" /></a></p>\n<p>The theme was designed by Felix Dorner, owner of <a href=\"http://drnr.co/\" target=\"_blank\">Studio DRNR</a>, a Berlin-based web development company. According to its description page, Yuuta was selected as the the theme&#8217;s name based on its Japanese meaning:</p>\n<blockquote><p>Yuuta is a Japanese name and is made up of 優 (yuu) “gentleness, superiority”, 悠 (yuu) “distant, leisurely” or 勇 (yuu) “brave” combined with 太 (ta) “thick, big”.</p></blockquote>\n<p>Each post format has its own distinguishing icon and unique display. Dorner opted to use Roboto, Roboto Slab, and a sprinkling of Courier as the theme&#8217;s primary fonts. The typography choices were selected for optimal readability on all screen sizes.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg?resize=961%2C526\" alt=\"yuuta-chat-format\" class=\"aligncenter size-full wp-image-47405\" /></a></p>\n<p>Yuuta also includes specific styles for both standard and Jetpack-enabled galleries.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg?resize=652%2C572\" alt=\"yuuta-jetpack-enabled-gallery\" class=\"aligncenter size-full wp-image-47407\" /></a></p>\n<p>The theme&#8217;s design is fairly set, unless you opt to create a child theme. There are zero options in the Customizer. Much of the design customization is done on a post-by-post basis, as the featured image serves as a unique background for the post. Yuuta also includes editor styles to match the editing experience to the theme&#8217;s frontend appearance.</p>\n<p>The primary navigation menu is hidden until toggled into view by the icon in the header, which keeps the reader focused on the content. There are no sidebars to contend with but widgets can be added to the footer.</p>\n<p>If you&#8217;re a fan of post formats, the Yuuta theme really makes them shine. It responds to display beautifully on all devices from desktop to tablet to smartphone. Check out a <a href=\"http://demo.felixdorner.com/yuuta/\" target=\"_blank\">live demo</a> on Dorner&#8217;s website to see each post format in action. You can download <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> for free from WordPress.org or install it via your admin themes browser.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 04:06:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Awesome Geek Podcasts: A Curated List of Tech Podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/awesome-geek-podcasts-a-curated-list-of-tech-podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2834:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg?resize=960%2C482\" alt=\"photo credit: Jan Vašek\" class=\"size-full wp-image-47389\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3YOVALG5DX\">Jan Vašek</a>\n<p>The WordPress community produces a couple dozen high quality podcasts covering diverse topics, such as weekly news, business/entrepreneurship, education, and development. Every year the best WordPress-related podcasts are featured in <a href=\"http://iamdavidgray.com/best-wordpress-podcasts/\" target=\"_blank\">roundup posts</a> highlighting shows that are publishing new episodes regularly.</p>\n<p>One way to venture outside the WordPress world is to expand your horizons when it comes to podcast subscriptions. <a href=\"https://github.com/cv/awesome-geek-podcasts\" target=\"_blank\">Awesome Geek Podcasts</a> is a curated list of tech podcasts that was first published in May of this year on GitHub. Since that time the repository has received 121 commits from 34 contributors.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png?resize=1025%2C551\" alt=\"awesome-geek-podcasts\" class=\"aligncenter size-full wp-image-47382\" /></a></p>\n<p>None of the podcasts listed in the repo are directly related to WordPress, but many cover topics related to the various technologies that work in and with WordPress. The list includes approximately seven PHP-related podcasts in English (and more in other languages), along with shows focused on JavaScript, Sass, Git, and other technologies.</p>\n<p>Other topics included in the Awesome Geek Podcasts list that might be of interest to WordPress developers include:</p>\n<ul>\n<li>Running software companies</li>\n<li>Software design, creation, and delivery</li>\n<li>Front end web design, development, and UX</li>\n<li>Typography, design, prototyping</li>\n<li>Open source software</li>\n<li>Family and life/work balance</li>\n</ul>\n<p>Several of those listed follow a short format of 5 and 10-minute episodes for developers who are short on time. No matter where your interests lie in the various aspects of &#8220;geek life,&#8221; the Awesome Geek Podcast list has something for everyone.</p>\n<p>Currently the list has separate sections for shows in English, Portuguese, Spanish, Russian, Persian, and Swedish, but it is open to contribution. Although it doesn&#8217;t seem to include many podcasts that focus on specific CMS platforms, you can try <a href=\"https://github.com/cv/awesome-geek-podcasts/blob/master/CONTRIBUTING.md\" target=\"_blank\">submitting a pull request</a> for the inclusion of your WordPress-related podcast.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 20:58:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Behind the Scenes of WordPress 4.2.3 With Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47354\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/behind-the-scenes-of-wordpress-4-2-3-with-gary-pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2253:\"<p>When <a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\">WordPress 4.2.3 was released</a> last week, not only did it patch a critical security vulnerability, but also <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">adversely impacted</a> a number of sites. Changes to the Shortcode API which were necessary as part of the patch caused some plugins that rely on the API to break. These changes were not immediately communicated to plugin developers. Nearly eight hours after its release, a <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\">post published</a> on the Make WordPress Core blog explained the changes.</p>\n<p>The release process of WordPress 4.2.3 left <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites#comments\">plugin authors and users</a> scratching their heads. On one hand, point releases are not supposed to break anything. On the other, affected plugin authors were left in the dark for nearly eight hours wondering why a point release broke their plugins.</p>\n<p><a href=\"http://pento.net/\">Gary Pendergast</a> who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team, reached out to me for an interview. In the following conversation, we discuss what happened behind the scenes before 4.2.3 was released.</p>\n<p>He clears up some confusion on when the changes to the Shortcode API were implemented. He also admits the team made some mistakes and has already implemented changes to improve the release process. One of those changes includes publishing a post on the Make WordPress Core blog as soon as the update is pushed out to sites.</p>\n<p>I appreciate and thank Pendergast for reaching out to me to have this conversation. I look forward to similar collaborations with members of the core team in the future. A transcription of this interview is not available but if you have it transcribed and would like to make it available to the public, please <a href=\"http://wptavern.com/contact-me\">contact me</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 19:02:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordPress Theme Review Team Votes to Allow Themes to Use the REST API Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47342\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/wordpress-theme-review-team-votes-to-allow-themes-to-use-the-rest-api-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3363:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg?resize=960%2C470\" alt=\"colored-pencils\" class=\"aligncenter size-full wp-image-42610\" /></a></p>\n<p>During this week&#8217;s WordPress Theme Review Team meeting, members considered the possibility of allowing themes hosted in the directory to make use of the <a href=\"https://wordpress.org/plugins/rest-api/\" target=\"_blank\">WP REST API plugin</a>. Since the API is not yet included in core, any theme or plugin author who wants to use it must have the feature plugin installed.</p>\n<p>Ordinarily, WordPress.org themes are not allowed to require a plugin on installation (although they can suggest one). As per the <a href=\"https://make.wordpress.org/themes/handbook/review/required/#plugins\" target=\"_blank\">Theme Review Handbook on plugins</a>: <em>A theme can recommend plugins but not include those plugins in the theme code.</em></p>\n<p>&#8220;The core team has asked us to consider temporarily allowing the requirement of the REST API for themes that may take advantage of it,&#8221; Tammie Lister said before calling for a vote. She also noted that waiving the rule would be temporary, as the API will soon be going into core.</p>\n<p>&#8220;This does not open up the way for others as an exception because it&#8217;s a core feature,&#8221; she said.</p>\n<p>The team took a quick vote and all present unanimously agreed to allow themes to require the REST API plugin as a temporary measure until it is available in core. Check out the <a href=\"https://make.wordpress.org/themes/2015/07/28/theme-review-team-weekly-meeting-notes-the-logs-7/\" target=\"_blank\">meeting logs</a> for the full discussion.</p>\n<p>The WP REST API is already being used in production in many different ways around the web, as revealed in the comments on project leader Ryan McCue&#8217;s recent <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">post</a> calling for examples. If the Theme Review Team wants to keep pace with where WordPress is headed, it must offer the flexibility to allow for more innovative themes. Temporarily waiving the guideline against plugin requirements is a smart move.</p>\n<p>As WordPress.org accrues more examples of themes that use the REST API in a way that complies with the review team&#8217;s high standards, developers who are just getting started will have strong examples for creating their own. Jack Lenox&#8217;s presentation at WordCamp London this year highlighted a few of the benefits of theming with the REST API:</p>\n<ul>\n<li>Provides a way to retrieve pure data (usually in JSON or XML format) over HTTP</li>\n<li>No loops necessary</li>\n<li>Good for mobile apps and environments where you don’t want a full webpage to render but want content from a blog or site</li>\n</ul>\n<p>With the official directory now welcoming these types of themes, it won&#8217;t be long before the entire landscape of WordPress theme development changes to support more modern ways of presenting content. Check out Jack Lenox&#8217;s presentation on <a href=\"http://wptavern.com/jack-lenox-on-building-themes-with-the-wp-rest-api\" target=\"_blank\">Building themes with the WP REST API</a> for information on how to get started.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 17:30:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Post Status: Don’t make enemies, invest in friendships\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://poststatus.com/invest-in-friendships/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4756:\"<p><em>Editor&#8217;s note: The following is a guest post by <a href=\"http://corymiller.com/about/\">Cory Miller</a>, the CEO of <a href=\"https://ithemes.com\">iThemes</a>. Cory describes his approach to making friends and avoiding making enemies. You should also check out his recent <a href=\"http://corymiller.com/my-talk-on-mental-health-and-entrepreneurship-is-now-online/\">talk on mental health and entrepreneurship</a>, which is terrific.</em></p>\n<p>I’d rather wave a white flag and compromise than make an enemy. Every. Single. Day.</p>\n<p>I’ve purposefully and intentionally, throughout my life (and business), sought to <em>not</em> make enemies, but rather build friendships.</p>\n<ul>\n<li>Enemies are only trouble.</li>\n<li>Enemies are distractions.</li>\n<li>Enemies eat my time and energy and focus.</li>\n<li>Enemies seek your destruction.</li>\n<li>Enemies oppose you.</li>\n<li>Enemies seek to “harm or weaken” you.</li>\n</ul>\n<p>Friends do the opposite.</p>\n<p>My best example of this is my wife, Lindsey. I think of her as my greatest ally and my best friend. She’s the opposite of an enemy.</p>\n<p>The words I use to describe her are “caring,” “supportive,” “loving,” and “wants my best.”</p>\n<p>So why would I spend my time seeking to <em>create</em> enemies, instead of friendships?</p>\n<ul>\n<li>You can have opinions.</li>\n<li>You can take stands.</li>\n<li>You can and should draw boundary lines.</li>\n<li>You can have your principles and <em>never</em> budge on them.</li>\n</ul>\n<p><em>But,</em> you can also, simultaneously, choose to make and focus on friendships.</p>\n<p>Some of my best friendships have come through business, and some of them would be considered “competitors.”</p>\n<p>But I’ve cherished those friendships.</p>\n<p>Additionally, I sleep better at night knowing we only want each other’s best and that there is plenty of room for each other instead of someone actively, purposefully seeking my destruction.</p>\n<p>But instead of seeking to fester anger and hate and competition, I’ve sought the opposite, asking, &#8220;Where can we find ways to help each other do better for each other?&#8221;</p>\n<p>So what if we approached life and business like this:</p>\n<p>Instead of using that anger, bile, jerk-ness, and negative energy in telling the world who you hate and how big of a jerk you can be, and how you don’t want to be an enemy of &#8212; why not seek to build true, lasting, deep friendships?</p>\n<p>The old quote, “Keep your friends close, and your enemies closer,” is pure B.S.</p>\n<p>Why not create a friend instead of nurture an enemy?</p>\n<p>Why not tell the world that you can be the <em>best</em> friend they ever made? And prove it by your actions.</p>\n<p>Friendships do take an investment. They take consistency. They take time. They take compromise sometimes. It means showing up for them when they most need it.</p>\n<p>But those relationships have been some of the richest relationships I’ve ever had. And totally worth the investment (multiple times over and over in fact).</p>\n<p>And yes, I have made enemies in my life. Purposefully and sometimes not. In fact, someone recently asked me jokingly on Twitter who didn’t like me. I responded with:</p>\n<p>“I can think of 1 or 2 a-holes but I don’t like thinking about them. <img src=\"https://poststatus.com/wp-includes/images/smilies/simple-smile.png\" alt=\":)\" class=\"wp-smiley\" /> hahahahaha”</p>\n<p>And although that’s sadly true, I’ve sought to minimize the enemies I’ve made in my life and business.</p>\n<p>My perspective on making necessary enemies is that <em>if</em> you <em>have</em> to make an enemy &#8212; and when I say that, I don’t mean because your personality defaults to that of a jerk and you sadistically like being labeled one), but you <em>have</em> to make an enemy because you have to set a boundary and tell someone no, or take a legal action &#8212; make dang sure it’s either for a <em>very</em> good purpose, value or strategic reason.</p>\n<p>And even then, question yourself about why.</p>\n<p>As my attorney told me recently: “You catch more flies with honey.”</p>\n<p>So don’t be a jerk while making enemies. You’ll make <em>more</em> enemies in the process.</p>\n<p>Simple, lip-biting kindness in the face of anger and hate and bile helps deflate a situation rather than pour lighter fluid on it.</p>\n<p>I tell people often: it doesn’t cost me anything to be nice and kind. (In fact most of the time it makes me happier.) And I seek out different avenues to vent my frustration and relieve my stress.</p>\n<p>So I say: Don’t make enemies. Invest in friendships.</p>\n<p>It should be common sense, but sometimes I (and maybe you) need a reminder.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 05:13:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Cory Miller\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: Adler: A Unique Personal Blogging Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47272\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/adler-a-unique-personal-blogging-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3395:\"<p>If you&#8217;re on the hunt for a new WordPress blogging theme but the designs are all starting to look too similar, you may want to check out <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">Adler</a>. It is one of the more unique themes to land in the WordPress.org directory in recent months with its uncommon typography choices and bright bursts of color.</p>\n<p>Adler was created by Romanian theme designer <a href=\"https://twitter.com/BabBarDeL\" target=\"_blank\">George Olaru</a> of <a href=\"https://pixelgrade.com/\" target=\"_blank\">Pixelgrade</a>. Olaru takes a unique approach to the popular fullscreen splash page style that many themes have adopted for a homepage layout, overlaying it with a serif font title paired with a hand-script style subtitle.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png?resize=880%2C660\" alt=\"adler\" class=\"aligncenter size-full wp-image-47315\" /></a></p>\n<p>Styling for single posts is similar to the home page with the featured image serving as a fullscreen background for the title. Scroll further down and the post content is centered with no distracting sidebar widgets.</p>\n<p>Adler combines two unusual Google font choices in the design: Droid Sans Mono for paragraph text and Permanent Marker for blockquotes and subtitles. Images in posts overhang the text column to create a strong visual impact.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg?resize=810%2C812\" alt=\"adler-images-blockquotes\" class=\"aligncenter size-full wp-image-47318\" /></a></p>\n<p>Adler&#8217;s files include a tiny leaf icon that is tastefully applied on the home and archive templates to separate posts. The effect is minimalist without appearing to be stark. The theme also includes support for Font Awesome icons.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg?resize=656%2C534\" alt=\"font-awesome\" class=\"aligncenter size-full wp-image-47320\" /></a></p>\n<p>The necessity for large featured images can sometimes be a drawback for users when selecting a blogging theme. After testing Adler, I found that the design doesn&#8217;t break if you don&#8217;t have a large featured image assigned to a post. In fact, posts lacking a featured image look just as nice as those that include one, so you&#8217;re not tied down to hunting for one every time you publish.</p>\n<p>Adler supports three menu locations for a primary, footer, and social menu. It includes support for one footer widget area, which spans three columns. There are just two options available in the native customizer that allow you to change the background color or add a background image.</p>\n<p>Adler was created to be a personal blogging theme and the design instantly communicates: &#8220;I have something to say.&#8221; Check out the <a href=\"https://pixelgrade.com/demos/adler/\" target=\"_blank\">live demo</a> on Pixelgrade.com to see it in action. If you like what you see, you can <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">download Adler</a> for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 01:09:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: New WordPress Plugin Automates Slack Team Invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47267\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/new-wordpress-plugin-automates-slack-team-invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4403:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg?resize=700%2C314\" alt=\"slack-logo\" class=\"aligncenter size-full wp-image-33466\" /></a></p>\n<p>Generating Slack team invitations can become rather tedious when you&#8217;re managing a large group of people &#8211; particularly when the team is open to almost anyone. In the case of a company or organization, a Slack admin can use the feature that permits anyone with an email from a specified domain to be accepted on signup. However, this feature isn&#8217;t applicable to teams that are made up of people with diverse email domains and associations.</p>\n<p><a href=\"http://boiteaweb.fr/\" target=\"_blank\">Julio Potier</a>, a French security consultant and prolific <a href=\"https://profiles.wordpress.org/juliobox/\" target=\"_blank\">plugin developer</a>, created a solution for this particular scenario. As an admin on the <a href=\"https://wordpressfr.slack.com/\" target=\"_blank\">WordPressFR.slack.com</a> team, which is open to all French WordPress users, he needed a more convenient way to allow new signups. The team has 27 channels and 250+ members with 200 added in the first week.</p>\n<p>Julio decided to create a plugin to make the invitation process easier in the future. The new <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> plugin automates the sending of Slack team invitations by adding a frontend signup on your WordPress site.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png?resize=404%2C405\" alt=\"join-slack-team\" class=\"aligncenter size-full wp-image-47285\" /></a></p>\n<p>The user simply enters an email address and the invitation is sent. A Slackbot confirmation will appear on the page.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png?resize=365%2C253\" alt=\"slack-team-invite-sent\" class=\"aligncenter size-full wp-image-47286\" /></a></p>\n<p>To configure the plugin for your Slack team all you need to do is enter the group name and the security token for your Slack invitations. As this token is not easy to find, Julio wrote a bookmarklet that will automatically capture it for you. From the plugin&#8217;s settings page you can drag and drop the bookmarklet into your browser toolbar on the invitation page found at: <code>https://YOURGROUP.slack.com/admin/invites</code>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png?resize=782%2C439\" alt=\"lazy-slack-settings\" class=\"aligncenter size-full wp-image-47295\" /></a></p>\n<p>Once the plugin is configured, the invitation signup page will be available at <code>example.com/wp-login.php?action=slack-invitation</code>. If you&#8217;re using either the <a href=\"https://wordpress.org/plugins/wp-recaptcha/\" target=\"_blank\">wp-reCaptcha</a> or <a href=\"https://wordpress.org/plugins/google-captcha/\" target=\"_blank\">google-captcha</a> plugins, Slack Lazy Invitation will automatically add protection to the form.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg?resize=350%2C481\" alt=\"slack-invite-recaptcha\" class=\"aligncenter size-full wp-image-47292\" /></a></p>\n<p>The plugin also includes support for the <a href=\"https://wordpress.org/plugins/sf-move-login/\" target=\"_blank\">SF Move Login</a> plugin, so that the invitation form is available at /slack-invitation instead of the much longer URL. This slug can be changed in the SF Move Login settings panel.</p>\n<p>In the future Julio plans to add support for adding invite pages for multiple groups. I tested <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> and found that it works exactly as advertised. If you have a large Slack team with open invites, this plugin will save you quite a bit of time. Download it for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jul 2015 22:30:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WPTavern: Meet PeepSo: BuddyPress’ Newest Competitor in Open Source Social Networking for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10255:\"<p>When the first <a href=\"https://buddypress.org/2008/12/buddypress-10b1-components/\" target=\"_blank\">BuddyPress beta</a> arrived on the scene in 2008, there was nothing like it for WordPress. Facebook was still relatively new to the public and Twitter was just a couple years old. A plugin that transformed WordPress into a social network was an exciting prospect.</p>\n<p>After seven years of virtually unchallenged dominance among WordPress social networking plugins, BuddyPress has a new competitor. <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a>, trademarked <em>&#8220;Your people. Your community. Your way,&#8221;</em> is the newest contender in WordPress&#8217; open source social networking plugin niche.</p>\n<p>Unlike <a href=\"https://buddypress.org/\" target=\"_blank\">BuddyPress</a>, which for the most part has improved slowly through community contribution, the <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a> project is run more like a startup and is 100% self-funded. It is currently being marketed as an alternative to BuddyPress.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">You\'ve been asking for it. An alternative to BuddyPress. It\'s here! <a href=\"http://t.co/Uxd7AQcnCL\">http://t.co/Uxd7AQcnCL</a> <a href=\"https://twitter.com/hashtag/wordpress?src=hash\">#wordpress</a> <a href=\"https://twitter.com/hashtag/buddypress?src=hash\">#buddypress</a> <a href=\"http://t.co/yYRI5pnXJR\">pic.twitter.com/yYRI5pnXJR</a></p>\n<p>&mdash; peepso (@peepsowp) <a href=\"https://twitter.com/peepsowp/status/623768949943984128\">July 22, 2015</a></p></blockquote>\n<p></p>\n<p>The <a href=\"https://wordpress.org/plugins/peepso-core/\" target=\"_blank\">PeepSo plugin</a>, available on WordPress.org, offers many of the same <a href=\"http://www.peepso.com/pricing/\" target=\"_blank\">core features</a> as BuddyPress but was launched with a collection of commercial add-on plugins for things like photos, videos, moods, tagging, locations, friends, and messages. A groups feature is noticeably absent from Peepso but <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">planned for version 1.4</a>. Current extensions seem to focus primarily on adding multimedia features to the activity stream.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png?resize=1025%2C769\" alt=\"peepso-profile\" class=\"aligncenter size-full wp-image-47235\" /></a></p>\n<h3>Who is Behind PeepSo?</h3>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg?resize=225%2C300\" alt=\"merav-peepso\" class=\"alignright size-medium wp-image-47241\" /></a>PeepSo was founded by <a href=\"https://about.me/meravknafo\" target=\"_blank\">Merav Knafo</a>, owner of <a href=\"http://www.jomsocial.com/\" target=\"_blank\">JomSocial</a>, Joomla&#8217;s most popular social networking solution. Knafo, a veteran in the Joomla community, brings a unique perspective on the differences between the Joomla and WordPress markets for social networking software. As <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">Joomla captures roughly 7% to WordPress&#8217; 60% of the CMS market share</a>, Knafo saw an opportunity to break into a larger market.</p>\n<p>&#8220;As a business owner, it’s my job to pay attention to trends in my industry and unfortunately, Joomla has been on a downward trend since 2009,&#8221; Knafo said.</p>\n<p>&#8220;Many of our JomSocial customers have asked us to &#8216;make JomSocial for WordPress,&#8217; because they wanted to switch to WordPress but there was nothing like JomSocial for WordPress. Finally, I could not ignore the trend nor the requests and decided to get into the WordPress market as well.&#8221;</p>\n<p>Knafo hopes to parlay her experience with JomSocial into her new venture with PeepSo.</p>\n<p>&#8220;We stuck with Joomla for almost 10 years now and took JomSocial to a whole new level when we took over in 2013,&#8221; she said. &#8220;I am very proud of what we’ve accomplished with JomSocial and super excited to implement all this experience and knowledge into PeepSo.&#8221;</p>\n<h3>How PeepSo Got Started</h3>\n<p>The idea for PeepSo was incubating for a few years before Knafo had the opportunity to execute it.</p>\n<p>&#8220;Brad Bihun used to be a customer of ours at <a href=\"http://www.ijoomla.com/\" target=\"_blank\">iJoomla</a>, and then he switched to WordPress,&#8221; she said. &#8220;We happened to live very close to each other in Encinitas, California, so we met up and suggested I’d created &#8216;JomSocial for WordPress.&#8217;</p>\n<p>&#8220;At that time, I didn’t even own JomSocial and I was too busy with all the iJoomla products. Then a couple of years later, I acquired JomSocial and he approached me again, but once again, I was just too busy. A year and a half into JomSocial acquisition, when things got a lot smoother, I finally said yes, he introduced me to the <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a> team, and we got started.&#8221;</p>\n<p>Although the plugin appears to be marketed as a direct competitor to BuddyPress, Knafo said that it wasn&#8217;t created specifically for that purpose but rather to give WordPress users a more robust array of options for building networks.</p>\n<p>&#8220;Obviously we felt there was a need for another product as an alternative to BuddyPress,&#8221; she said. &#8220;Leaving users with just one option is rarely a good idea, people like options.</p>\n<p>&#8220;We don’t necessarily plan to take on BuddyPress, we just want to offer those who want an alternative, a product that is of high quality and that is being continuously developed. Ultimately, people will choose the solution that serves them best. We are just getting started, but we have big plans and an excellent track record doing this successfully with Joomla.&#8221;</p>\n<h3>The Differences Between PeepSo and BuddyPress</h3>\n<p>I asked Knafo what her team perceives to be the most notable differences between PeepSo and its more established competitor, based on what they found to be lacking in BuddyPress.</p>\n<p>&#8220;I’d say the look and feel is a lot more modern in PeepSo right off the bat with no special themes needed,&#8221; she said. &#8220;The features are more up-to-date with the latest and greatest features of big social networks, such as Facebook &#8211; from cover photos to &#8216;likes&#8217; and so on.&#8221;</p>\n<p>BuddyPress core developers have opted to leave the aforementioned features to separate third-party plugins as opposed to packing them into core. With certain features, i.e. photos and videos, PeepSo does the same, except the add-ons are supported by PeepSo core developers.</p>\n<p>&#8220;PeepSo is lightweight and allows you to only add features that you need, to keep it lightweight,&#8221; Knafo said. &#8220;PeepSo’s code is so beautiful it made our developers shed tears of joy when they first saw it &#8211; that said, I never looked at BuddyPress’s code, nor would I be able to tell whether it’s beautiful or not.&#8221;</p>\n<p>In terms of code differences, PeepSo&#8217;s development team cited what they believe to be a few major differences between their <a href=\"https://github.com/wp-plugins/peepso-core\" target=\"_blank\">codebase</a> and BuddyPress:</p>\n<ul>\n<li>All object oriented &#8211; from the PHP to the Javascript</li>\n<li>Built with a templating engine similar to what you see in shopping cart systems. This allows use with virtually any theme.</li>\n<li>The JavaScript uses an extension mechanism, allowing add-ons to extend the abilities of the postbox.</li>\n<li>We made the database queries as optimized as possible to allow for greater scalability.</li>\n</ul>\n<p>&#8220;We have a track record creating and supporting a very large social networking application (JomSocial),&#8221; Knafo told the Tavern. &#8220;We know the ins and out of this business. We may be new to WordPress, but we are veterans when it comes to social networking applications.&#8221;</p>\n<h3>Where is PeepSo Headed?</h3>\n<p>The PeepSo development team, guided by lead architect <a href=\"https://twitter.com/davejesch\" target=\"_blank\">Dave Jesch</a> of <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a>, has an aggressive <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">roadmap</a> for improving the plugin&#8217;s core and adding more features via commercial plugins.</p>\n<p>&#8220;Our main goal is to add more plugins to PeepSo, you can see our road map here. We’ll start with a chat plugin, custom profile fields and then groups, events, pages and so forth,&#8221; Knafo said. The team also hopes to partner with other developers who want to create PeepSo plugins.</p>\n<p>I asked her if the team plans to create a hosted PeepSo platform for community managers. Knafo said it isn&#8217;t totally out of the question but isn&#8217;t high on the priority list at the moment.</p>\n<p>&#8220;We tried to do this with JomSocial but we had a hard time finding the right hosting solution for it,&#8221; she said. &#8220;That said, we are open to the idea, a bit down the road.&#8221;</p>\n<p>PeepSo is just getting started and has not yet attracted many customers. However, Knafo&#8217;s experience of successfully running an open source project for the past 10 years has given her the determination to break into a new and unfamiliar market.</p>\n<p>&#8220;The sales have been as can be expected this early after the initial release, not too shabby to start with but we expect whole lot more sales as the WordPress users become aware of PeepSo, download the free version and give it a try,&#8221; she said.</p>\n<p>&#8220;We’re here for the long haul and we take no shortcuts in doing this right. We know it’s a huge undertaking; there is so much more to do. I am confident that investing in WordPress was the right move, I’ve been very pleased by the feedback and the community. My hope is that WordPress developers will join us and create awesome plugins to take PeepSo to the next level.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 22:50:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 26 Aug 2015 08:11:23 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"193430\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Wed, 26 Aug 2015 07:45:16 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20150821144050\";}", "no");
INSERT INTO `eadsk_options` VALUES("2619", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1440619885", "no");
INSERT INTO `eadsk_options` VALUES("2620", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1440576685", "no");
INSERT INTO `eadsk_options` VALUES("2621", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1440619887", "no");
INSERT INTO `eadsk_options` VALUES("2622", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Aug 2015 07:58:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"8321@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"25254@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29832@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"9542@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"363@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"6743@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2316@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"15@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"5790@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"753@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29860@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2572@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"23862@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"1169@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 13 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2141@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2082@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"132@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"18101@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"12073@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2646@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26907@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"28395@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"21738@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Protect your WordPress site by hiding vital areas of your site, protecting access to important files, preventing brute-force login attempts, detecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"31973@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"49521@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"51888@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"50539@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Google Analytics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/googleanalytics/#post-11199\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Jun 2009 22:09:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"11199@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Enables google analytics on all pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Kevin Sylvestre\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WP-DB-Backup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/wp-db-backup/#post-472\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Mar 2007 04:41:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"472@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"On-demand backup of your WordPress database.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"ringmaster\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26607@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 26 Aug 2015 08:11:27 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:13:\"last-modified\";s:29:\"Thu, 01 Jan 2009 20:34:44 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20150821144050\";}", "no");
INSERT INTO `eadsk_options` VALUES("2623", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1440619887", "no");
INSERT INTO `eadsk_options` VALUES("2624", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1440576687", "no");
INSERT INTO `eadsk_options` VALUES("2625", "_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51", "1440619887", "no");
INSERT INTO `eadsk_options` VALUES("2626", "_transient_dash_4077549d03da2e451c8b5f002294ff51", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2015/08/billie/\'>WordPress 4.3 “Billie”</a> <span class=\"rss-date\">August 18, 2015</span><div class=\"rssSummary\">Version 4.3 of WordPress, named “Billie” in honor of jazz singer Billie Holiday, is available for download or update in your WordPress dashboard. New features in 4.3 make it even easier to format your content and customize your site. Menus in the Customizer Create your menu, update it, and assign it, all while live-previewing in [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wptavern.com/first-look-at-the-twenty-sixteen-default-wordpress-theme\'>WPTavern: First Look at the Twenty Sixteen Default WordPress Theme</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/sessions-from-buddycamp-brighton-uk-now-available-to-watch-on-wordpress-tv\'>WPTavern: Sessions From BuddyCamp Brighton, UK Now Available to Watch on WordPress.tv</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/ostraining-makes-pods-framework-video-training-series-available-for-free\'>WPTavern: OSTraining Makes Pods Framework Video Training Series Available for Free</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/ml-slider/\' class=\'dashboard-news-plugin-link\'>Meta Slider</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=ml-slider&amp;_wpnonce=0d2009b1a7&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Meta Slider\'>Install</a>)</span></li></ul></div>", "no");
INSERT INTO `eadsk_options` VALUES("2627", "duplicator_package_active", "O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:26:\"20150826_magmaincattorneys\";s:4:\"Hash\";s:29:\"55dd74ac7fae67873150826081124\";s:8:\"NameHash\";s:56:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124\";s:7:\"Version\";s:6:\"0.5.28\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/usr/www/users/magmaauvky/wp-snapshots/tmp\";s:8:\"StoreURL\";s:35:\"http://magmainc.co.za/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/usr/www/users/magmaauvky\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:26:\"20150826_magmaincattorneys\";s:4:\"Hash\";s:29:\"55dd74ac7fae67873150826081124\";s:8:\"NameHash\";s:56:\"20150826_magmaincattorneys_55dd74ac7fae67873150826081124\";s:7:\"Version\";s:6:\"0.5.28\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:42:\"/usr/www/users/magmaauvky/wp-snapshots/tmp\";s:8:\"StoreURL\";s:35:\"http://magmainc.co.za/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:45;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:45;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:60;s:8:\"Database\";r:73;}", "yes");

/* INSERT TABLE DATA: eadsk_postmeta */
INSERT INTO `eadsk_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("2", "4", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("3", "4", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("4", "5", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("5", "5", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("6", "6", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("7", "6", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("8", "7", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("9", "7", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("10", "8", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("11", "8", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("12", "9", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("13", "9", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("14", "10", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("15", "10", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("16", "11", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("17", "11", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("18", "12", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("19", "12", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("20", "13", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("21", "13", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("22", "14", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("23", "14", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("24", "15", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("25", "15", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("26", "16", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("27", "16", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("28", "17", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("29", "17", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("30", "18", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("31", "18", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("32", "19", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("33", "19", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("34", "20", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("35", "20", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("36", "21", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("37", "21", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("38", "22", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("39", "22", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("40", "23", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("41", "23", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("42", "24", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("43", "24", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("44", "25", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("45", "25", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("46", "26", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("47", "26", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("48", "27", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("49", "27", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("50", "28", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("51", "28", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("52", "29", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("53", "29", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("54", "30", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("55", "30", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("56", "31", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("57", "31", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("58", "32", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("59", "32", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("60", "33", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("61", "33", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("62", "34", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("63", "34", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("64", "35", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("65", "35", "_et_pb_predefined_layout", "on");
INSERT INTO `eadsk_postmeta` VALUES("68", "37", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("69", "37", "_edit_lock", "1438585210:1");
INSERT INTO `eadsk_postmeta` VALUES("70", "39", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("71", "39", "_edit_lock", "1440011573:1");
INSERT INTO `eadsk_postmeta` VALUES("72", "39", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("73", "39", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("74", "39", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("75", "39", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("76", "39", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("77", "39", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("78", "39", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("79", "43", "_wp_attached_file", "2015/08/education.png");
INSERT INTO `eadsk_postmeta` VALUES("80", "43", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:219;s:6:\"height\";i:91;s:4:\"file\";s:21:\"2015/08/education.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"education-150x91.png\";s:5:\"width\";i:150;s:6:\"height\";i:91;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("81", "44", "_wp_attached_file", "2015/08/finbond.jpg");
INSERT INTO `eadsk_postmeta` VALUES("82", "44", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:217;s:6:\"height\";i:119;s:4:\"file\";s:19:\"2015/08/finbond.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"finbond-150x119.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:119;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("83", "45", "_wp_attached_file", "2015/08/fxi.png");
INSERT INTO `eadsk_postmeta` VALUES("84", "45", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:298;s:6:\"height\";i:200;s:4:\"file\";s:15:\"2015/08/fxi.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"fxi-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("85", "46", "_wp_attached_file", "2015/08/logo.png");
INSERT INTO `eadsk_postmeta` VALUES("86", "46", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:227;s:6:\"height\";i:117;s:4:\"file\";s:16:\"2015/08/logo.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-150x117.png\";s:5:\"width\";i:150;s:6:\"height\";i:117;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("87", "48", "_wp_attached_file", "2015/08/Clients.jpg");
INSERT INTO `eadsk_postmeta` VALUES("88", "48", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:300;s:4:\"file\";s:19:\"2015/08/Clients.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Clients-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"Clients-450x90.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:90;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"Clients-600x120.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:19:\"Clients-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:20:\"Clients-1080x300.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:19:\"Clients-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:20:\"Clients-1080x216.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:216;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("89", "51", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("90", "51", "_edit_lock", "1440156243:1");
INSERT INTO `eadsk_postmeta` VALUES("91", "51", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("92", "51", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("93", "51", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("94", "51", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("95", "51", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("96", "51", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("97", "51", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("98", "53", "_menu_item_type", "post_type");
INSERT INTO `eadsk_postmeta` VALUES("99", "53", "_menu_item_menu_item_parent", "0");
INSERT INTO `eadsk_postmeta` VALUES("100", "53", "_menu_item_object_id", "51");
INSERT INTO `eadsk_postmeta` VALUES("101", "53", "_menu_item_object", "page");
INSERT INTO `eadsk_postmeta` VALUES("102", "53", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("103", "53", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("104", "53", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("105", "53", "_menu_item_url", "");
INSERT INTO `eadsk_postmeta` VALUES("107", "54", "_menu_item_type", "post_type");
INSERT INTO `eadsk_postmeta` VALUES("108", "54", "_menu_item_menu_item_parent", "0");
INSERT INTO `eadsk_postmeta` VALUES("109", "54", "_menu_item_object_id", "39");
INSERT INTO `eadsk_postmeta` VALUES("110", "54", "_menu_item_object", "page");
INSERT INTO `eadsk_postmeta` VALUES("111", "54", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("112", "54", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("113", "54", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("114", "54", "_menu_item_url", "");
INSERT INTO `eadsk_postmeta` VALUES("116", "54", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("117", "53", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("118", "2", "_wp_trash_meta_status", "publish");
INSERT INTO `eadsk_postmeta` VALUES("119", "2", "_wp_trash_meta_time", "1439302203");
INSERT INTO `eadsk_postmeta` VALUES("120", "57", "_wp_attached_file", "2015/08/large.jpg");
INSERT INTO `eadsk_postmeta` VALUES("121", "57", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:350;s:6:\"height\";i:149;s:4:\"file\";s:17:\"2015/08/large.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"large-150x149.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:149;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("122", "58", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("123", "58", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("124", "58", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("125", "58", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("126", "58", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("127", "58", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("128", "58", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("129", "58", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("130", "58", "_edit_lock", "1440009267:1");
INSERT INTO `eadsk_postmeta` VALUES("131", "60", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("132", "60", "_edit_lock", "1440510109:1");
INSERT INTO `eadsk_postmeta` VALUES("133", "60", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("134", "60", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("135", "60", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("136", "60", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("137", "60", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("138", "60", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("139", "60", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("140", "62", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("141", "62", "_edit_lock", "1439302473:1");
INSERT INTO `eadsk_postmeta` VALUES("142", "62", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("143", "62", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("144", "62", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("145", "62", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("146", "62", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("147", "62", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("148", "62", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("149", "64", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("150", "64", "_edit_lock", "1440153059:1");
INSERT INTO `eadsk_postmeta` VALUES("151", "64", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("152", "64", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("153", "64", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("154", "64", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("155", "64", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("156", "64", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("157", "64", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("176", "68", "_menu_item_type", "post_type");
INSERT INTO `eadsk_postmeta` VALUES("177", "68", "_menu_item_menu_item_parent", "0");
INSERT INTO `eadsk_postmeta` VALUES("178", "68", "_menu_item_object_id", "60");
INSERT INTO `eadsk_postmeta` VALUES("179", "68", "_menu_item_object", "page");
INSERT INTO `eadsk_postmeta` VALUES("180", "68", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("181", "68", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("182", "68", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("183", "68", "_menu_item_url", "");
INSERT INTO `eadsk_postmeta` VALUES("185", "69", "_menu_item_type", "post_type");
INSERT INTO `eadsk_postmeta` VALUES("186", "69", "_menu_item_menu_item_parent", "204");
INSERT INTO `eadsk_postmeta` VALUES("187", "69", "_menu_item_object_id", "58");
INSERT INTO `eadsk_postmeta` VALUES("188", "69", "_menu_item_object", "page");
INSERT INTO `eadsk_postmeta` VALUES("189", "69", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("190", "69", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("191", "69", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("192", "69", "_menu_item_url", "");
INSERT INTO `eadsk_postmeta` VALUES("194", "69", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("196", "68", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("198", "96", "_wp_attached_file", "2015/08/back2-1200x300.jpg");
INSERT INTO `eadsk_postmeta` VALUES("199", "96", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:300;s:4:\"file\";s:26:\"2015/08/back2-1200x300.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"back2-1200x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"back2-1200x300-450x113.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:113;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"back2-1200x300-600x150.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:26:\"back2-1200x300-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:27:\"back2-1200x300-1080x300.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:26:\"back2-1200x300-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:27:\"back2-1200x300-1080x270.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("200", "101", "_wp_attached_file", "2015/08/favicon.jpg");
INSERT INTO `eadsk_postmeta` VALUES("201", "101", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:36;s:6:\"height\";i:36;s:4:\"file\";s:19:\"2015/08/favicon.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("202", "107", "_wp_attached_file", "2015/08/plane-1200x300.jpg");
INSERT INTO `eadsk_postmeta` VALUES("203", "107", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:300;s:4:\"file\";s:26:\"2015/08/plane-1200x300.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"plane-1200x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"plane-1200x300-450x113.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:113;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"plane-1200x300-600x150.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:26:\"plane-1200x300-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:27:\"plane-1200x300-1080x300.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:26:\"plane-1200x300-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:27:\"plane-1200x300-1080x270.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("204", "111", "_wp_attached_file", "2015/08/lawyer.jpg");
INSERT INTO `eadsk_postmeta` VALUES("205", "111", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:418;s:4:\"file\";s:18:\"2015/08/lawyer.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"lawyer-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"lawyer-450x157.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:157;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"lawyer-600x209.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:209;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:18:\"lawyer-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:19:\"lawyer-1080x418.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:418;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:18:\"lawyer-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:19:\"lawyer-1080x376.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:376;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:21:\"bernie_moto - Fotolia\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("206", "114", "_wp_attached_file", "2015/08/lawyer1.jpg");
INSERT INTO `eadsk_postmeta` VALUES("207", "114", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:391;s:4:\"file\";s:19:\"2015/08/lawyer1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"lawyer1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"lawyer1-450x147.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"lawyer1-600x196.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:19:\"lawyer1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:20:\"lawyer1-1080x391.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:391;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:19:\"lawyer1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:20:\"lawyer1-1080x352.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:352;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:21:\"bernie_moto - Fotolia\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("208", "116", "_wp_attached_file", "2015/08/fam-1200x300.jpg");
INSERT INTO `eadsk_postmeta` VALUES("209", "116", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:300;s:4:\"file\";s:24:\"2015/08/fam-1200x300.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"fam-1200x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"fam-1200x300-450x113.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:113;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"fam-1200x300-600x150.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"fam-1200x300-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:25:\"fam-1200x300-1080x300.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"fam-1200x300-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:25:\"fam-1200x300-1080x270.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("210", "134", "_wp_attached_file", "2015/08/ASDASDASD1.jpg");
INSERT INTO `eadsk_postmeta` VALUES("211", "134", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:400;s:4:\"file\";s:22:\"2015/08/ASDASDASD1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"ASDASDASD1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"ASDASDASD1-450x150.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"ASDASDASD1-600x200.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"ASDASDASD1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"ASDASDASD1-1080x400.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"ASDASDASD1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"ASDASDASD1-1080x360.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("212", "136", "_wp_attached_file", "2015/08/magale-Copy1.jpg");
INSERT INTO `eadsk_postmeta` VALUES("213", "136", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:176;s:6:\"height\";i:176;s:4:\"file\";s:24:\"2015/08/magale-Copy1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"magale-Copy1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";d:2.3999999999999999;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"iPhone 4S\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1413883818;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.28\";s:3:\"iso\";s:2:\"80\";s:13:\"shutter_speed\";s:4:\"0.05\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("214", "139", "_wp_attached_file", "2015/08/pat-Copy1.jpg");
INSERT INTO `eadsk_postmeta` VALUES("215", "139", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:176;s:6:\"height\";i:176;s:4:\"file\";s:21:\"2015/08/pat-Copy1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"pat-Copy1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";d:2.3999999999999999;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"iPhone 4S\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1413883393;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.28\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:4:\"0.05\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("216", "141", "_wp_attached_file", "2015/08/Picture-Copy.jpg");
INSERT INTO `eadsk_postmeta` VALUES("217", "141", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:174;s:6:\"height\";i:174;s:4:\"file\";s:24:\"2015/08/Picture-Copy.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"Picture-Copy-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";d:2.7999999999999998;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:12:\"Canon EOS 5D\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1317897509;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"155\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("218", "143", "_wp_attached_file", "2015/08/tom.jpg");
INSERT INTO `eadsk_postmeta` VALUES("219", "143", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:176;s:6:\"height\";i:176;s:4:\"file\";s:15:\"2015/08/tom.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"tom-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("220", "37", "_wp_trash_meta_status", "draft");
INSERT INTO `eadsk_postmeta` VALUES("221", "37", "_wp_trash_meta_time", "1439541812");
INSERT INTO `eadsk_postmeta` VALUES("240", "62", "_wp_trash_meta_status", "publish");
INSERT INTO `eadsk_postmeta` VALUES("241", "62", "_wp_trash_meta_time", "1439556997");
INSERT INTO `eadsk_postmeta` VALUES("254", "174", "_wp_attached_file", "2015/08/lawyer2.jpg");
INSERT INTO `eadsk_postmeta` VALUES("255", "174", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:468;s:4:\"file\";s:19:\"2015/08/lawyer2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"lawyer2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"lawyer2-450x176.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"lawyer2-600x234.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:234;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:19:\"lawyer2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:20:\"lawyer2-1080x468.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:19:\"lawyer2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:20:\"lawyer2-1080x421.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:421;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:21:\"bernie_moto - Fotolia\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("265", "176", "_wp_attached_file", "2015/08/contractlaw.jpg");
INSERT INTO `eadsk_postmeta` VALUES("266", "176", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:468;s:4:\"file\";s:23:\"2015/08/contractlaw.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"contractlaw-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"contractlaw-450x176.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"contractlaw-600x234.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:234;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:23:\"contractlaw-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:24:\"contractlaw-1080x468.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:23:\"contractlaw-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:24:\"contractlaw-1080x421.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:421;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:21:\"bernie_moto - Fotolia\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("267", "177", "_wp_attached_file", "2015/08/contractlaw1.jpg");
INSERT INTO `eadsk_postmeta` VALUES("268", "177", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:468;s:4:\"file\";s:24:\"2015/08/contractlaw1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"contractlaw1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"contractlaw1-450x176.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"contractlaw1-600x234.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:234;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"contractlaw1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:25:\"contractlaw1-1080x468.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"contractlaw1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:25:\"contractlaw1-1080x421.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:421;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:21:\"bernie_moto - Fotolia\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("269", "178", "_wp_attached_file", "2015/08/contractlaw2.jpg");
INSERT INTO `eadsk_postmeta` VALUES("270", "178", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:468;s:4:\"file\";s:24:\"2015/08/contractlaw2.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"contractlaw2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"contractlaw2-450x176.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"contractlaw2-600x234.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:234;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"contractlaw2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:25:\"contractlaw2-1080x468.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:468;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"contractlaw2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:25:\"contractlaw2-1080x421.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:421;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:21:\"bernie_moto - Fotolia\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("280", "180", "_wp_attached_file", "2015/08/mine-1200x300.jpg");
INSERT INTO `eadsk_postmeta` VALUES("281", "180", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:300;s:4:\"file\";s:25:\"2015/08/mine-1200x300.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"mine-1200x300-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"mine-1200x300-450x113.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:113;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"mine-1200x300-600x150.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:25:\"mine-1200x300-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:26:\"mine-1200x300-1080x300.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:25:\"mine-1200x300-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:26:\"mine-1200x300-1080x270.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("372", "1", "_wp_trash_meta_status", "publish");
INSERT INTO `eadsk_postmeta` VALUES("373", "1", "_wp_trash_meta_time", "1439803493");
INSERT INTO `eadsk_postmeta` VALUES("374", "1", "_wp_trash_meta_comments_status", "a:1:{i:1;s:1:\"1\";}");
INSERT INTO `eadsk_postmeta` VALUES("408", "58", "_aioseop_keywords", "Magale Masemola, Patrick Motsepe, Dr. Nokuhle Madolo, Tumi Matlakala, Thomas Sibiya, tom sibiya, Tumishang Oupa Phasha, oupa phasha, mining law, corporate law, contract lawyer, family law ");
INSERT INTO `eadsk_postmeta` VALUES("409", "58", "_aioseop_description", "Magale Masemola, Patrick Motsepe, Dr Madolo,  Oupa Phasha and Tom Sibiya are attorneys at Magma Inc in Sandton");
INSERT INTO `eadsk_postmeta` VALUES("410", "58", "_aioseop_title", "ABOUT US");
INSERT INTO `eadsk_postmeta` VALUES("411", "197", "_menu_item_type", "post_type");
INSERT INTO `eadsk_postmeta` VALUES("412", "197", "_menu_item_menu_item_parent", "0");
INSERT INTO `eadsk_postmeta` VALUES("413", "197", "_menu_item_object_id", "64");
INSERT INTO `eadsk_postmeta` VALUES("414", "197", "_menu_item_object", "page");
INSERT INTO `eadsk_postmeta` VALUES("415", "197", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("416", "197", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("417", "197", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("418", "197", "_menu_item_url", "");
INSERT INTO `eadsk_postmeta` VALUES("420", "197", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("421", "199", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("422", "199", "_edit_lock", "1440011520:1");
INSERT INTO `eadsk_postmeta` VALUES("423", "200", "_wp_attached_file", "2015/08/magma-subscribe.jpg");
INSERT INTO `eadsk_postmeta` VALUES("424", "200", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:600;s:4:\"file\";s:27:\"2015/08/magma-subscribe.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"magma-subscribe-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"magma-subscribe-450x338.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:338;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"magma-subscribe-600x450.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:27:\"magma-subscribe-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:27:\"magma-subscribe-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("425", "199", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("428", "199", "_et_post_bg_color", "#ffffff");
INSERT INTO `eadsk_postmeta` VALUES("429", "199", "_et_post_bg_layout", "light");
INSERT INTO `eadsk_postmeta` VALUES("430", "199", "_et_pb_show_title", "on");
INSERT INTO `eadsk_postmeta` VALUES("431", "199", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("432", "199", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("433", "199", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("434", "199", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("435", "199", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("436", "199", "_thumbnail_id", "200");
INSERT INTO `eadsk_postmeta` VALUES("448", "39", "_aioseop_keywords", "lawyers, Magma Inc, Magma Incorporated Attorneys, Magale Masemola Attorneys");
INSERT INTO `eadsk_postmeta` VALUES("449", "39", "_aioseop_description", "Magma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub. (BBB-EE level 3 status)");
INSERT INTO `eadsk_postmeta` VALUES("450", "39", "_aioseop_title", "ATTORNEYS JOHANNESBURG");
INSERT INTO `eadsk_postmeta` VALUES("451", "204", "_menu_item_type", "custom");
INSERT INTO `eadsk_postmeta` VALUES("452", "204", "_menu_item_menu_item_parent", "0");
INSERT INTO `eadsk_postmeta` VALUES("453", "204", "_menu_item_object_id", "204");
INSERT INTO `eadsk_postmeta` VALUES("454", "204", "_menu_item_object", "custom");
INSERT INTO `eadsk_postmeta` VALUES("455", "204", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("456", "204", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("457", "204", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("458", "204", "_menu_item_url", "#");
INSERT INTO `eadsk_postmeta` VALUES("460", "204", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("461", "205", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("462", "205", "_edit_lock", "1440567372:1");
INSERT INTO `eadsk_postmeta` VALUES("463", "205", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("464", "205", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("465", "205", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("466", "205", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("467", "205", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("468", "205", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("469", "205", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("470", "207", "_menu_item_type", "post_type");
INSERT INTO `eadsk_postmeta` VALUES("471", "207", "_menu_item_menu_item_parent", "204");
INSERT INTO `eadsk_postmeta` VALUES("472", "207", "_menu_item_object_id", "205");
INSERT INTO `eadsk_postmeta` VALUES("473", "207", "_menu_item_object", "page");
INSERT INTO `eadsk_postmeta` VALUES("474", "207", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("475", "207", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("476", "207", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("477", "207", "_menu_item_url", "");
INSERT INTO `eadsk_postmeta` VALUES("479", "207", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("480", "209", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("481", "209", "_edit_lock", "1440153651:1");
INSERT INTO `eadsk_postmeta` VALUES("482", "209", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("483", "209", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("484", "209", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("485", "209", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("486", "209", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("487", "209", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("488", "209", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("489", "211", "_menu_item_type", "post_type");
INSERT INTO `eadsk_postmeta` VALUES("490", "211", "_menu_item_menu_item_parent", "204");
INSERT INTO `eadsk_postmeta` VALUES("491", "211", "_menu_item_object_id", "209");
INSERT INTO `eadsk_postmeta` VALUES("492", "211", "_menu_item_object", "page");
INSERT INTO `eadsk_postmeta` VALUES("493", "211", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("494", "211", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("495", "211", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("496", "211", "_menu_item_url", "");
INSERT INTO `eadsk_postmeta` VALUES("498", "211", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("499", "213", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("500", "213", "_edit_lock", "1440153245:1");
INSERT INTO `eadsk_postmeta` VALUES("501", "213", "_wp_page_template", "default");
INSERT INTO `eadsk_postmeta` VALUES("502", "213", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("503", "213", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("504", "213", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("505", "213", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("506", "213", "_et_pb_use_builder", "on");
INSERT INTO `eadsk_postmeta` VALUES("507", "213", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("508", "215", "_menu_item_type", "post_type");
INSERT INTO `eadsk_postmeta` VALUES("509", "215", "_menu_item_menu_item_parent", "0");
INSERT INTO `eadsk_postmeta` VALUES("510", "215", "_menu_item_object_id", "213");
INSERT INTO `eadsk_postmeta` VALUES("511", "215", "_menu_item_object", "page");
INSERT INTO `eadsk_postmeta` VALUES("512", "215", "_menu_item_target", "");
INSERT INTO `eadsk_postmeta` VALUES("513", "215", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `eadsk_postmeta` VALUES("514", "215", "_menu_item_xfn", "");
INSERT INTO `eadsk_postmeta` VALUES("515", "215", "_menu_item_url", "");
INSERT INTO `eadsk_postmeta` VALUES("517", "215", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("518", "218", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("519", "218", "_edit_lock", "1440154483:1");
INSERT INTO `eadsk_postmeta` VALUES("520", "218", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("523", "218", "_et_post_bg_color", "#ffffff");
INSERT INTO `eadsk_postmeta` VALUES("524", "218", "_et_post_bg_layout", "light");
INSERT INTO `eadsk_postmeta` VALUES("525", "218", "_et_pb_show_title", "on");
INSERT INTO `eadsk_postmeta` VALUES("526", "218", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("527", "218", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("528", "218", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("529", "218", "_et_pb_use_builder", "");
INSERT INTO `eadsk_postmeta` VALUES("530", "218", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("531", "220", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("532", "220", "_edit_lock", "1440154081:1");
INSERT INTO `eadsk_postmeta` VALUES("533", "220", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("536", "220", "_et_post_bg_color", "#ffffff");
INSERT INTO `eadsk_postmeta` VALUES("537", "220", "_et_post_bg_layout", "light");
INSERT INTO `eadsk_postmeta` VALUES("538", "220", "_et_pb_show_title", "on");
INSERT INTO `eadsk_postmeta` VALUES("539", "220", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("540", "220", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("541", "220", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("542", "220", "_et_pb_use_builder", "");
INSERT INTO `eadsk_postmeta` VALUES("543", "220", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("544", "222", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("545", "222", "_edit_lock", "1440154253:1");
INSERT INTO `eadsk_postmeta` VALUES("546", "222", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("549", "222", "_et_post_bg_color", "#ffffff");
INSERT INTO `eadsk_postmeta` VALUES("550", "222", "_et_post_bg_layout", "light");
INSERT INTO `eadsk_postmeta` VALUES("551", "222", "_et_pb_show_title", "on");
INSERT INTO `eadsk_postmeta` VALUES("552", "222", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("553", "222", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("554", "222", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("555", "222", "_et_pb_use_builder", "");
INSERT INTO `eadsk_postmeta` VALUES("556", "222", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("559", "225", "_edit_last", "1");
INSERT INTO `eadsk_postmeta` VALUES("560", "225", "_edit_lock", "1440154474:1");
INSERT INTO `eadsk_postmeta` VALUES("561", "225", "_wpas_done_all", "1");
INSERT INTO `eadsk_postmeta` VALUES("564", "225", "_et_post_bg_color", "#ffffff");
INSERT INTO `eadsk_postmeta` VALUES("565", "225", "_et_post_bg_layout", "light");
INSERT INTO `eadsk_postmeta` VALUES("566", "225", "_et_pb_show_title", "on");
INSERT INTO `eadsk_postmeta` VALUES("567", "225", "_et_pb_post_hide_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("568", "225", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `eadsk_postmeta` VALUES("569", "225", "_et_pb_side_nav", "off");
INSERT INTO `eadsk_postmeta` VALUES("570", "225", "_et_pb_use_builder", "");
INSERT INTO `eadsk_postmeta` VALUES("571", "225", "_et_pb_old_content", "");
INSERT INTO `eadsk_postmeta` VALUES("572", "227", "_wp_attached_file", "2015/08/north-west-provincial.jpg");
INSERT INTO `eadsk_postmeta` VALUES("573", "227", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:303;s:4:\"file\";s:33:\"2015/08/north-west-provincial.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"north-west-provincial-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:33:\"north-west-provincial-300x250.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:33:\"north-west-provincial-300x284.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("574", "229", "_wp_attached_file", "2015/08/SAFA.jpg");
INSERT INTO `eadsk_postmeta` VALUES("575", "229", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:462;s:6:\"height\";i:320;s:4:\"file\";s:16:\"2015/08/SAFA.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"SAFA-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"SAFA-450x312.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:312;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:16:\"SAFA-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:16:\"SAFA-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `eadsk_postmeta` VALUES("576", "230", "_wp_attached_file", "2015/08/education1.png");
INSERT INTO `eadsk_postmeta` VALUES("577", "230", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:219;s:6:\"height\";i:91;s:4:\"file\";s:22:\"2015/08/education1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"education1-150x91.png\";s:5:\"width\";i:150;s:6:\"height\";i:91;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("578", "231", "_wp_attached_file", "2015/08/finbond1.jpg");
INSERT INTO `eadsk_postmeta` VALUES("579", "231", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:217;s:6:\"height\";i:119;s:4:\"file\";s:20:\"2015/08/finbond1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"finbond1-150x119.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:119;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("580", "232", "_wp_attached_file", "2015/08/prime.jpg");
INSERT INTO `eadsk_postmeta` VALUES("581", "232", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:225;s:6:\"height\";i:118;s:4:\"file\";s:17:\"2015/08/prime.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"prime-150x118.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("582", "233", "_wp_attached_file", "2015/08/nhc.jpg");
INSERT INTO `eadsk_postmeta` VALUES("583", "233", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:238;s:6:\"height\";i:117;s:4:\"file\";s:15:\"2015/08/nhc.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"nhc-150x117.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:117;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("584", "234", "_wp_attached_file", "2015/08/satawuP.jpg");
INSERT INTO `eadsk_postmeta` VALUES("585", "234", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:225;s:4:\"file\";s:19:\"2015/08/satawuP.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"satawuP-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:19:\"satawuP-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:19:\"satawuP-400x225.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("586", "234", "_wp_attachment_image_alt", "");
INSERT INTO `eadsk_postmeta` VALUES("593", "51", "_aioseop_keywords", "Magma Inc, attorneys in Sandton, johannesburg lawyer");
INSERT INTO `eadsk_postmeta` VALUES("594", "51", "_aioseop_description", "Magma Inc  Attorneys are based in Sandton but have numerous service offices in various provinces.");
INSERT INTO `eadsk_postmeta` VALUES("595", "51", "_aioseop_title", "Contact ATTORNEYS SANDTON");
INSERT INTO `eadsk_postmeta` VALUES("596", "240", "_wp_attached_file", "2015/08/Seda_Logo.gif");
INSERT INTO `eadsk_postmeta` VALUES("597", "240", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:230;s:6:\"height\";i:105;s:4:\"file\";s:21:\"2015/08/Seda_Logo.gif\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Seda_Logo-150x105.gif\";s:5:\"width\";i:150;s:6:\"height\";i:105;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("598", "241", "_wp_attached_file", "2015/08/nhc1.jpg");
INSERT INTO `eadsk_postmeta` VALUES("599", "241", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:238;s:6:\"height\";i:117;s:4:\"file\";s:16:\"2015/08/nhc1.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"nhc1-150x117.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:117;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("600", "242", "_wp_attached_file", "2015/08/fxi1.png");
INSERT INTO `eadsk_postmeta` VALUES("601", "242", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:298;s:6:\"height\";i:200;s:4:\"file\";s:16:\"2015/08/fxi1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"fxi1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("602", "243", "_wp_attached_file", "2015/08/TUT.jpg");
INSERT INTO `eadsk_postmeta` VALUES("603", "243", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:572;s:6:\"height\";i:551;s:4:\"file\";s:15:\"2015/08/TUT.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"TUT-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"TUT-450x433.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:433;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:15:\"TUT-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:15:\"TUT-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("604", "245", "_wp_attached_file", "2015/08/nelson.jpg");
INSERT INTO `eadsk_postmeta` VALUES("605", "245", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:155;s:6:\"height\";i:130;s:4:\"file\";s:18:\"2015/08/nelson.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"nelson-150x130.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:130;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("606", "246", "_wp_attached_file", "2015/08/skynet.jpg");
INSERT INTO `eadsk_postmeta` VALUES("607", "246", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:185;s:6:\"height\";i:135;s:4:\"file\";s:18:\"2015/08/skynet.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"skynet-150x135.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("608", "248", "_wp_attached_file", "2015/08/logo1.png");
INSERT INTO `eadsk_postmeta` VALUES("609", "248", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:227;s:6:\"height\";i:117;s:4:\"file\";s:17:\"2015/08/logo1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"logo1-150x117.png\";s:5:\"width\";i:150;s:6:\"height\";i:117;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("610", "251", "_wp_attached_file", "2015/08/salga.jpg");
INSERT INTO `eadsk_postmeta` VALUES("611", "251", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:223;s:6:\"height\";i:127;s:4:\"file\";s:17:\"2015/08/salga.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"salga-150x127.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `eadsk_postmeta` VALUES("612", "251", "_wp_attachment_image_alt", "SALGA");
INSERT INTO `eadsk_postmeta` VALUES("646", "60", "_aioseop_keywords", "contracts, civil law, aviation law, media law, labour law, Mergers and acquisitions, mining law, family law, Due diligences, insolvencies, debt collection, ");
INSERT INTO `eadsk_postmeta` VALUES("647", "60", "_aioseop_description", "Magma INC attorneys in Sandton have an extensive range of specialitiy legal areas among their team of lawyers.  Mining law and Tax law being two of many.");
INSERT INTO `eadsk_postmeta` VALUES("648", "60", "_aioseop_title", "LEGAL PRACTICE SPECIALITIES");

/* INSERT TABLE DATA: eadsk_posts */
INSERT INTO `eadsk_posts` VALUES("1", "1", "2015-04-26 14:37:23", "2015-04-26 14:37:23", "Welcome to WordPress. This is your first post. Edit or delete it, then start blogging!", "Hello world!", "", "trash", "open", "open", "", "hello-world", "", "", "2015-08-17 11:24:53", "2015-08-17 09:24:53", "", "0", "http://magmainc.co.za/?p=1", "0", "post", "", "1");
INSERT INTO `eadsk_posts` VALUES("2", "1", "2015-04-26 14:37:23", "2015-04-26 14:37:23", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my blog. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://magmainc.co.za/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "Sample Page", "", "trash", "open", "open", "", "sample-page", "", "", "2015-08-11 16:10:03", "2015-08-11 14:10:03", "", "0", "http://magmainc.co.za/?page_id=2", "0", "page", "", "0");
INSERT INTO `eadsk_posts` VALUES("4", "1", "2015-08-03 06:04:14", "2015-08-03 04:04:14", "[et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_slider admin_label=\"Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"Welcome To My Website\" button_text=\"Enter\" button_link=\"#\" background_color=\"#27c9b9\" alignment=\"center\" background_layout=\"dark\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam eros at, laoreet metus.[/et_pb_slide][/et_pb_slider][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"on\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"We Are a Company of Passionate Designers and Developers\" background_layout=\"light\" text_orientation=\"center\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"on\" font_icon=\"h\" icon_color=\"#a8a8a8\" use_circle=\"on\" circle_color=\"#ffffff\" use_circle_border=\"on\" circle_border_color=\"#e0e0e0\" icon_placement=\"top\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"on\" font_icon=\"\" icon_color=\"#a8a8a8\" use_circle=\"on\" circle_color=\"#ffffff\" use_circle_border=\"on\" circle_border_color=\"#e0e0e0\" icon_placement=\"top\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"on\" font_icon=\"v\" icon_color=\"#a8a8a8\" use_circle=\"on\" circle_color=\"#ffffff\" use_circle_border=\"on\" circle_border_color=\"#e0e0e0\" icon_placement=\"top\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"on\" font_icon=\"g\" icon_color=\"#a8a8a8\" use_circle=\"on\" circle_color=\"#ffffff\" use_circle_border=\"on\" circle_border_color=\"#e0e0e0\" icon_placement=\"top\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Drop Me a Line\" button_url=\"#\" button_text=\"Contact\" background_color=\"#2ea3f2\" use_background_color=\"on\" background_layout=\"dark\" text_orientation=\"center\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam eros at, laoreet metus.[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage Basic", "", "publish", "open", "open", "", "homepage-basic", "", "", "2015-08-03 06:04:14", "2015-08-03 04:04:14", "", "0", "http://magmainc.co.za/et_pb_layout/homepage-basic/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("5", "1", "2015-08-03 06:04:14", "2015-08-03 04:04:14", "[et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"Welcome to Our Shop\" button_text=\"Shop Now\" background_color=\"#0194f3\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" alignment=\"center\" background_layout=\"dark\" button_link=\"#\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam eros at, laoreet metus.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h1>Featured Products</h1>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_shop admin_label=\"Shop\" type=\"featured\" posts_number=\"4\" columns=\"4\" orderby=\"menu_order\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"on\" background_color=\"#f7f7f7\" inner_shadow=\"off\" parallax=\"off\"][et_pb_column type=\"3_4\" specialty_columns=\"3\"][et_pb_row_inner][et_pb_column_inner type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h1>Recent Products</h1>[/et_pb_text][et_pb_shop admin_label=\"Shop\" type=\"recent\" posts_number=\"6\" columns=\"3\" orderby=\"date\" /][/et_pb_column_inner][/et_pb_row_inner][et_pb_row_inner][et_pb_column_inner type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" title=\"Holiday Special Sale\" button_text=\"Shop Now\" background_color=\"#108bf5\" use_background_color=\"on\" background_layout=\"dark\" text_orientation=\"center\" button_url=\"#\"]Cras rutrum blandit sem, molestie consequat erat luctus vel. Cras nunc est, laoreet sit amet ligula et, eleifend commodo dui.[/et_pb_cta][/et_pb_column_inner][et_pb_column_inner type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" title=\"Become a Vendor\" button_text=\"Learn More\" background_color=\"#27c9b9\" use_background_color=\"on\" background_layout=\"dark\" text_orientation=\"center\" button_url=\"#\"]Cras rutrum blandit sem, molestie consequat erat luctus vel. Cras nunc est, laoreet sit amet ligula et, eleifend commodo dui.[/et_pb_cta][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_sidebar admin_label=\"Sidebar\" orientation=\"right\" area=\"sidebar-1\" background_layout=\"light\" /][/et_pb_column][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h1>What Our Customers are Saying</h1>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\"]\"Cras rutrum blandit sem, molestie consequat erat luctus vel. Cras nunc est, laoreet sit amet ligula et, eleifend commodo dui. Vivamus id blandit nisi, eu mattis odio.\"[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\"]\"Cras rutrum blandit sem, molestie consequat erat luctus vel. Cras nunc est, laoreet sit amet ligula et, eleifend commodo dui. Vivamus id blandit nisi, eu mattis odio.\"[/et_pb_testimonial][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\"]\"Cras rutrum blandit sem, molestie consequat erat luctus vel. Cras nunc est, laoreet sit amet ligula et, eleifend commodo dui. Vivamus id blandit nisi, eu mattis odio.\"[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\"]\"Cras rutrum blandit sem, molestie consequat erat luctus vel. Cras nunc est, laoreet sit amet ligula et, eleifend commodo dui. Vivamus id blandit nisi, eu mattis odio.\"[/et_pb_testimonial][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#27c9b9\" inner_shadow=\"off\" parallax=\"on\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Browse Our Full Shop\" button_url=\"#\" button_text=\"Enter\" use_background_color=\"off\" background_color=\"#108bf5\" background_layout=\"dark\" text_orientation=\"center\"]Cras rutrum blandit sem, molestie consequat erat luctus vel. Cras nunc est, laoreet sit amet ligula et, eleifend commodo dui.[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage Shop", "", "publish", "open", "open", "", "homepage-shop", "", "", "2015-08-03 06:04:14", "2015-08-03 04:04:14", "", "0", "http://magmainc.co.za/et_pb_layout/homepage-shop/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("6", "1", "2015-08-03 06:04:14", "2015-08-03 04:04:14", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#2e2e2e\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"on\" parallax=\"on\"][et_pb_slide background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" heading=\"Hello! Welcome To My Online Portfolio\" /][et_pb_slide background_color=\"#f84b48\" alignment=\"center\" background_layout=\"dark\" heading=\"Project Title\" button_text=\"View Project\" /][et_pb_slide background_color=\"#23a1f5\" alignment=\"center\" background_layout=\"dark\" heading=\"Project Title\" button_text=\"View Project\" /][et_pb_slide background_color=\"#27c8b8\" alignment=\"center\" background_layout=\"dark\" heading=\"Project Title\" button_text=\"View Project\" /][/et_pb_fullwidth_slider][et_pb_fullwidth_portfolio admin_label=\"Fullwidth Portfolio\" fullwidth=\"on\" show_title=\"on\" show_date=\"on\" background_layout=\"dark\" auto=\"off\" include_categories=\"62,65,72,69,16\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"40\" /][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"on\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam justo et nibh venenatis aliquet.[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"on\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam justo et nibh venenatis aliquet.[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"on\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam justo et nibh venenatis aliquet.[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Coding Languages\" number=\"7\" percent_sign=\"off\" background_layout=\"light\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Loyal Clients\" number=\"65\" percent_sign=\"off\" background_layout=\"light\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"International Awards\" number=\"12\" percent_sign=\"off\" background_layout=\"light\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Years of Experience\" number=\"10\" percent_sign=\"off\" background_layout=\"light\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#27c8b8\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"View My Full Portfolio\" button_url=\"#\" button_text=\"Enter\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"dark\" text_orientation=\"center\"]Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Cras venenatis ac lorema ac tincidunt.[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage Portfolio", "", "publish", "open", "open", "", "homepage-portfolio", "", "", "2015-08-03 06:04:14", "2015-08-03 04:04:14", "", "0", "http://magmainc.co.za/et_pb_layout/homepage-portfolio/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("7", "1", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "[et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"Our Company\" button_text=\"Features\" button_link=\"http://elegantthemes.com/preview/Divi2/features/\" background_color=\"#8d1bf4\" alignment=\"center\" background_layout=\"dark\" image=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/d2-300px.png\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\"]Quisque eleifend orci sit amet est semper, iaculis tempor mi volutpat. Phasellus consectetur justo sed tristique molestie. Cras lectus quam, vehicula eu dictum a, sollicitudin id velit.[/et_pb_slide][et_pb_slide heading=\"Slide Title\" button_text=\"Learn More\" button_link=\"#\" background_color=\"#f84c48\" alignment=\"center\" background_layout=\"dark\"]Quisque eleifend orci sit amet est semper, iaculis tempor mi volutpat. Phasellus consectetur justo sed tristique molestie. Cras lectus quam, vehicula eu dictum a, sollicitudin id velit.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" use_icon=\"off\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Cras semper dictum lectus ac bibendum. Sed id massa vel lorem laoreet molestie. Nullam vulputate lacus at mauris molestie porttitor.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" use_icon=\"off\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Cras semper dictum lectus ac bibendum. Sed id massa vel lorem laoreet molestie. Nullam vulputate lacus at mauris molestie porttitor.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" use_icon=\"off\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Cras semper dictum lectus ac bibendum. Sed id massa vel lorem laoreet molestie. Nullam vulputate lacus at mauris molestie porttitor.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#4b4b4b\" inner_shadow=\"on\" parallax=\"off\"][et_pb_fullwidth_portfolio admin_label=\"Fullwidth Portfolio\" title=\"Recent Work\" fullwidth=\"on\" show_title=\"on\" show_date=\"on\" background_layout=\"dark\" auto=\"off\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#eeeeee\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/et-logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"top\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/et-logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"top\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/et-logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"top\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/et-logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"top\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" company_name=\"Company\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\" job_title=\"Job Role\" url=\"#\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" company_name=\"Company\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\" job_title=\"Job Role\" url=\"#\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_testimonial][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" company_name=\"Company\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\" job_title=\"Job Role\" url=\"#\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" company_name=\"Company\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\" job_title=\"Job Role\" url=\"#\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_testimonial][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_map admin_label=\"Fullwidth Map\" zoom_level=\"8\" address_lat=\"37.43410184255073\" address_lng=\"-122.04768412931253\"][et_pb_map_pin title=\"Elegant Themes\" pin_address=\"San Francisco, CA, USA\" pin_address_lat=\"37.7749295\" pin_address_lng=\"-122.41941550000001\" /][et_pb_map_pin title=\"Lorem Ipsum\" pin_address=\"San Jose, CA, USA\" pin_address_lat=\"37.3393857\" pin_address_lng=\"-121.89495549999998\" /][/et_pb_fullwidth_map][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"off\" title=\"Contact Us\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage Company", "", "publish", "open", "open", "", "homepage-company", "", "", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "", "0", "http://magmainc.co.za/et_pb_layout/homepage-company/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("8", "1", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"Our Company\" button_text=\"Learn More\" button_link=\"#\" background_color=\"#f7f7f7\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" alignment=\"center\" background_layout=\"light\"]Changing the way you build websites. Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc. Etiam adipiscing enim sed condimentum ultrices.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#3a4149\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_circle_counter admin_label=\"Circle Counter\" title=\"Sales & Marketing\" number=\"70\" percent_sign=\"on\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_circle_counter admin_label=\"Circle Counter\" title=\"Brand & Identity\" number=\"90\" percent_sign=\"on\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_circle_counter admin_label=\"Circle Counter\" title=\"Web Design\" number=\"80\" percent_sign=\"on\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_circle_counter admin_label=\"Circle Counter\" title=\"App Development\" number=\"50\" percent_sign=\"on\" background_layout=\"dark\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"2_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h2>What We Offer</h2>[/et_pb_text][et_pb_tabs admin_label=\"Tabs\"][et_pb_tab title=\"Overview\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc. Etiam adipiscing enim sed condimentum ultrices. Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_tab][et_pb_tab title=\"Mission Statement\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc. Etiam adipiscing enim sed condimentum ultrices. Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_tab][et_pb_tab title=\"Culture\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc. Etiam adipiscing enim sed condimentum ultrices. Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_tab][/et_pb_tabs][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"50\" /][et_pb_counters admin_label=\"Bar Counters\" background_layout=\"light\" background_color=\"#f4f4f4\"][et_pb_counter percent=\"80\"]Brand Consulting[/et_pb_counter][et_pb_counter percent=\"45\"]Marketing Campaigns [/et_pb_counter][et_pb_counter percent=\"95\"]Custom Website Design[/et_pb_counter][/et_pb_counters][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#eaeaea\" show_divider=\"on\" height=\"30\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h1>Our Work Flow</h1>[/et_pb_text][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Upsum\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"on\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Upsum\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"on\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Upsum\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"on\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#212a34\" inner_shadow=\"off\" parallax=\"off\" background_image=\"http://www.elegantthemesimages.com/images/premade/d2-placeholder-1920.png\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"20\" /][et_pb_blurb admin_label=\"Blurb\" url_new_window=\"off\" use_icon=\"off\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" image=\"http://elegantthemesimages.com/images/premade/d2-300px.png\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h2>Frequently Asked Questions</h2>\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam justo et nibh venenatis aliquet. Morbi mollis mollis pellentesque. Aenean vitae erat velit. Maecenas urna sapien, dignissim a augue vitae, porttitor luctus urna. Morbi scelerisque semper congue. Donec vitae congue quam. Pellentesque convallis est a eros porta, ut porttitor magna convallis.\r\n\r\nDonec quis felis imperdiet, vestibulum est ut, pulvinar dolor. Mauris laoreet varius sem, tempus congue nibh elementum facilisis. Aliquam ut odio risus. Mauris consectetur mi et ante aliquam, eget posuere urna semper. Vestibulum vestibulum rhoncus enim, id iaculis eros commodo non.[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_accordion admin_label=\"Accordion\"][et_pb_accordion_item title=\"What kind of clients do you work with?\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam justo et nibh venenatis aliquet.[/et_pb_accordion_item][et_pb_accordion_item title=\"What is your turn around time?\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam justo et nibh venenatis aliquet. Morbi mollis mollis pellentesque. Aenean vitae erat velit. Maecenas urna sapien, dignissim a augue vitae, porttitor luctus urna.[/et_pb_accordion_item][et_pb_accordion_item title=\"Do you have an affiliate program?\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam justo et nibh venenatis aliquet. Morbi mollis mollis pellentesque. Aenean vitae erat velit. Maecenas urna sapien, dignissim a augue vitae, porttitor luctus urna.[/et_pb_accordion_item][/et_pb_accordion][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#eaeaea\" show_divider=\"on\" height=\"30\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" url_new_window=\"off\" quote_icon=\"on\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc. Etiam adipiscing enim sed condimentum ultrices. Aenean consectetur ipsum ante, vel egestas enim tincidunt qu[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" url_new_window=\"off\" quote_icon=\"on\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc. Etiam adipiscing enim sed condimentum ultrices. Aenean consectetur ipsum ante, vel egestas enim tincidunt qu[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Lorem Ipsum\" url_new_window=\"off\" quote_icon=\"on\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc. Etiam adipiscing enim sed condimentum ultrices. Aenean consectetur ipsum ante, vel egestas enim tincidunt qu[/et_pb_testimonial][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f74b47\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" button_url=\"#\" button_text=\"Email\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"center\" title=\"Don\'t Be Shy\"]Drop us a line anytime, and one of our customer service reps will respond to you as soon as possible[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage Corporate", "", "publish", "open", "open", "", "homepage-corporate", "", "", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "", "0", "http://magmainc.co.za/et_pb_layout/homepage-corporate/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("9", "1", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "[et_pb_section fullwidth=\"on\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"on\"][et_pb_slide heading=\"Welcome To Our Website\" button_text=\"Learn More\" button_link=\"#\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" video_bg_width=\"1920\" video_bg_height=\"638\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\"]Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Cras venenatis ac lorema ac tincidunt. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue.[/et_pb_slide][et_pb_slide heading=\"Sky\'s The Limit\" background_color=\"#444444\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" alignment=\"center\" background_layout=\"dark\" button_text=\"A Closer Look\" button_link=\"#\"]Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\"][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" animation=\"off\" background_layout=\"light\" text_orientation=\"left\" icon_placement=\"left\" font_icon=\"\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#7c4dd5\" circle_color=\"#7c4dd5\" circle_border_color=\"#2caaca\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" animation=\"off\" background_layout=\"light\" text_orientation=\"left\" icon_placement=\"left\" font_icon=\"\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#7c4dd5\" circle_color=\"#7c4dd5\" circle_border_color=\"#2caaca\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" animation=\"off\" background_layout=\"light\" text_orientation=\"left\" icon_placement=\"left\" font_icon=\"\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#7c4dd5\" circle_color=\"#7c4dd5\" circle_border_color=\"#2caaca\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" animation=\"off\" background_layout=\"light\" text_orientation=\"left\" icon_placement=\"left\" font_icon=\"\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#7c4dd5\" circle_color=\"#7c4dd5\" circle_border_color=\"#2caaca\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" animation=\"off\" background_layout=\"light\" text_orientation=\"left\" icon_placement=\"left\" font_icon=\"\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#7c4dd5\" circle_color=\"#7c4dd5\" circle_border_color=\"#2caaca\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" animation=\"off\" background_layout=\"light\" text_orientation=\"left\" icon_placement=\"left\" font_icon=\"\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#7c4dd5\" circle_color=\"#7c4dd5\" circle_border_color=\"#2caaca\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" background_color=\"#27c9b8\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" button_url=\"#\" button_text=\"Get Started\" background_color=\"#7ebec5\" use_background_color=\"off\" background_layout=\"dark\" text_orientation=\"center\"]</p><h1>Building a website has never been so fun.</h1><p>[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" background_color=\"#27323a\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]</p><h1>Lorem Ipsum Dolor.</h1><p>Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus dolor ipsum amet sit. Nec  eleifend tincidunt nisi.Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.</p><p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1080px.jpg\" url_new_window=\"off\" animation=\"right\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"left\"]</p><h3>Lorem Ipsum</h3><p><span style=\"color: #bbbbbb;\">Vestibulum lobortis. Donec at euismod nibh, eu ibendum quam. Nullam non gravida puruipsum amet sdum it. Nec ele bulum lobortis. Donec at euismod nibh, eu biben</span></p><p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"left\"]</p><h3>Lorem Ipsum</h3><p><span style=\"color: #bbbbbb;\">Vestibulum lobortis. Donec at euismod nibh, eu ibendum quam. Nullam non gravida puruipsum amet sdum it. Nec ele bulum lobortis. Donec at euismod nibh, eu biben</span></p><p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"left\"]</p><h3>Lorem Ipsum</h3><p><span style=\"color: #bbbbbb;\">Vestibulum lobortis. Donec at euismod nibh, eu ibendum quam. Nullam non gravida puruipsum amet sdum it. Nec ele bulum lobortis. Donec at euismod nibh, eu biben</span></p><p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" background_color=\"#22262e\" inner_shadow=\"off\" parallax=\"on\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Lorem Ipsum\" number=\"2700\" percent_sign=\"off\" counter_color=\"#815ab4\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Lorem Ipsum\" number=\"30\" percent_sign=\"off\" counter_color=\"#2caaca\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Lorem Ipsum\" number=\"87\" percent_sign=\"off\" counter_color=\"#35bbaa\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Lorem Ipsum\" number=\"999\" percent_sign=\"off\" counter_color=\"#ef6462\" background_layout=\"dark\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\"][et_pb_fullwidth_portfolio admin_label=\"Fullwidth Portfolio\" fullwidth=\"on\" include_categories=\"15\" show_title=\"on\" show_date=\"on\" background_layout=\"dark\" auto=\"on\" /][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"Slide Title Here\" button_text=\"Shop Now\" button_link=\"http://elegantthemes.com/preview/Divi2/shop-extended/\" background_color=\"#1a86cf\" alignment=\"center\" background_layout=\"dark\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam eros at, laoreet metus.[/et_pb_slide][et_pb_slide heading=\"Slide Title Here\" alignment=\"center\" background_layout=\"dark\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam er\r\nos at, laoreet metus.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"center\"]</p><h1>Core Features</h1><p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-builder.jpg\" animation=\"bottom\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#2caaca\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\"]Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi. Fusce at purus in massa laoreet[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-layouts.jpg\" animation=\"bottom\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#2caaca\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\" url=\"http://elegantthemes.com/preview/Divi2/features/#predefined\"]Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi. Fusce at purus in massa laoreet[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-export.jpg\" animation=\"bottom\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#2caaca\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\" url=\"http://elegantthemes.com/preview/Divi2/features/#layouts\"]Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi. Fusce at purus in massa laoreet[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-modules.jpg\" animation=\"bottom\" background_layout=\"light\" text_orientation=\"center\" icon_placement=\"top\" use_icon=\"off\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#2caaca\" circle_color=\"#2caaca\" circle_border_color=\"#2caaca\"]Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi. Fusce at purus in massa laoreet[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-mobile.jpg\" animation=\"bottom\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#2caaca\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\" url=\"http://elegantthemes.com/preview/Divi2/features/#mobile\"]Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi. Fusce at purus in massa laoreet[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-commerce.jpg\" animation=\"bottom\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#2caaca\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\"]Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi. Fusce at purus in massa laoreet[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"on\"][et_pb_slide heading=\"Slide Title Here\" button_text=\"Our Work\" button_link=\"#\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi.Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" background_color=\"#283139\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]</p><h1>Versatile Layout Options</h1><p>Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus dolor ipsum amet sit.</p><p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" icon_placement=\"left\" font_icon=\"R\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#ec6d5f\" circle_color=\"#2caaca\" circle_border_color=\"#2caaca\" animation=\"bottom\" background_layout=\"dark\" text_orientation=\"center\"]<span style=\"color: #bbbbbb;\">Donec at euismod nibh, eu bibendum.[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" icon_placement=\"left\" font_icon=\"R\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#1fa0e3\" circle_color=\"#2caaca\" circle_border_color=\"#2caaca\" animation=\"right\" background_layout=\"dark\" text_orientation=\"center\"]<span style=\"color: #bbbbbb;\">Donec at euismod nibh, eu bibendum.[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" icon_placement=\"left\" font_icon=\"R\" use_icon=\"on\" use_circle=\"off\" use_circle_border=\"off\" icon_color=\"#47bfa4\" circle_color=\"#2caaca\" circle_border_color=\"#2caaca\" animation=\"top\" background_layout=\"dark\" text_orientation=\"center\"]<span style=\"color: #bbbbbb;\">Donec at euismod nibh, eu bibendum.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" url_new_window=\"off\" animation=\"bottom\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" url_new_window=\"off\" animation=\"bottom\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" background_color=\"#ec6d5f\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" background_color=\"#7ebec5\" use_background_color=\"off\" background_layout=\"dark\" text_orientation=\"center\" button_url=\"#\" button_text=\"Join Now\"]</p><h1>Look No Further. Get Started Today</h1><p>[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Homepage Extended", "", "publish", "open", "open", "", "homepage-extended", "", "", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "", "0", "http://magmainc.co.za/et_pb_layout/homepage-extended/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("10", "1", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "[et_pb_section fullwidth=\"on\" specialty=\"off\" inner_shadow=\"off\" parallax=\"off\" background_color=\"#2ea3f2\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"Page Title\" subhead=\"Here is a basic page layout with no sidebar\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\"]\r\n<h2>Just A Standard Page</h2>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\nSed sit amet blandit ipsum, et consectetur libero. Integer convallis at metus quis molestie. Morbi vitae odio ut ante molestie scelerisque. Aliquam erat volutpat. Vivamus dignissim fringilla semper. Aliquam imperdiet dui a purus pellentesque, non ornare ipsum blandit. Sed imperdiet elit in quam egestas lacinia nec sit amet dui. Cras malesuada tincidunt ante, in luctus tellus hendrerit at. Duis massa mauris, bibendum a mollis a, laoreet quis elit. Nulla pulvinar vestibulum est, in viverra nisi malesuada vel. Nam ut ipsum quis est faucibus mattis eu ut turpis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas nunc felis, venenatis in fringilla vel, tempus in turpis. Mauris aliquam dictum dolor at varius. Fusce sed vestibulum metus. Vestibulum dictum ultrices nulla sit amet fermentum.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h3>Lorem Ipsum Dolor</h3>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h3>Lorem Ipsum Dolor</h3>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Page Fullwidth", "", "publish", "open", "open", "", "page-fullwidth", "", "", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "", "0", "http://magmainc.co.za/et_pb_layout/page-fullwidth/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("11", "1", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"on\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"Page Title\" subhead=\"Here is a basic page layout with a right sidebar\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"on\"][et_pb_column type=\"3_4\" specialty_columns=\"3\"][et_pb_row_inner][et_pb_column_inner type=\"4_4\"][et_pb_text admin_label=\"Text\"]\r\n<h2>Just A Standard Page</h2>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\nSed sit amet blandit ipsum, et consectetur libero. Integer convallis at metus quis molestie. Morbi vitae odio ut ante molestie scelerisque. Aliquam erat volutpat. Vivamus dignissim fringilla semper. Aliquam imperdiet dui a purus pellentesque, non ornare ipsum blandit. Sed imperdiet elit in quam egestas lacinia nec sit amet dui. Cras malesuada tincidunt ante, in luctus tellus hendrerit at. Duis massa mauris, bibendum a mollis a, laoreet quis elit. Nulla pulvinar vestibulum est, in viverra nisi malesuada vel. Nam ut ipsum quis est faucibus mattis eu ut turpis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas nunc felis, venenatis in fringilla vel, tempus in turpis. Mauris aliquam dictum dolor at varius. Fusce sed vestibulum metus. Vestibulum dictum ultrices nulla sit amet fermentum.\r\n\r\n[/et_pb_text][/et_pb_column_inner][/et_pb_row_inner][et_pb_row_inner][et_pb_column_inner type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h3>Lorem Ipsum Dolor</h3>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][et_pb_column_inner type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h3>Lorem Ipsum Dolor</h3>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][/et_pb_row_inner][et_pb_row_inner][et_pb_column_inner type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][et_pb_column_inner type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][et_pb_column_inner type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_sidebar admin_label=\"Sidebar\" orientation=\"right\" area=\"sidebar-1\" background_layout=\"light\" /][/et_pb_column][/et_pb_section]", "Page Right Sidebar", "", "publish", "open", "open", "", "page-right-sidebar", "", "", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "", "0", "http://magmainc.co.za/et_pb_layout/page-right-sidebar/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("12", "1", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"Page With Left Sidebar\" subhead=\"Here is a basic page layout with a left sidebar\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"on\"][et_pb_column type=\"1_4\"][et_pb_sidebar admin_label=\"Sidebar\" orientation=\"left\" area=\"sidebar-1\" background_layout=\"light\" /][/et_pb_column][et_pb_column type=\"3_4\" specialty_columns=\"3\"][et_pb_row_inner][et_pb_column_inner type=\"4_4\"][et_pb_text admin_label=\"Text\"]\r\n<h2>Just A Standard Page</h2>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\nSed sit amet blandit ipsum, et consectetur libero. Integer convallis at metus quis molestie. Morbi vitae odio ut ante molestie scelerisque. Aliquam erat volutpat. Vivamus dignissim fringilla semper. Aliquam imperdiet dui a purus pellentesque, non ornare ipsum blandit. Sed imperdiet elit in quam egestas lacinia nec sit amet dui. Cras malesuada tincidunt ante, in luctus tellus hendrerit at. Duis massa mauris, bibendum a mollis a, laoreet quis elit. Nulla pulvinar vestibulum est, in viverra nisi malesuada vel. Nam ut ipsum quis est faucibus mattis eu ut turpis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas nunc felis, venenatis in fringilla vel, tempus in turpis. Mauris aliquam dictum dolor at varius. Fusce sed vestibulum metus. Vestibulum dictum ultrices nulla sit amet fermentum.\r\n\r\n[/et_pb_text][/et_pb_column_inner][/et_pb_row_inner][et_pb_row_inner][et_pb_column_inner type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h3>Lorem Ipsum Dolor</h3>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][et_pb_column_inner type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h3>Lorem Ipsum Dolor</h3>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][/et_pb_row_inner][et_pb_row_inner][et_pb_column_inner type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][et_pb_column_inner type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][et_pb_column_inner type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h4>Lorem Ipsum Dolor</h4>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][/et_pb_section]", "Page Left Sidebar", "", "publish", "open", "open", "", "page-left-sidebar", "", "", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "", "0", "http://magmainc.co.za/et_pb_layout/page-left-sidebar/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("13", "1", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"Page With Dual Sidebars\" subhead=\"Here is a basic page layout with dual sidebars\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"on\"][et_pb_column type=\"1_4\"][et_pb_sidebar admin_label=\"Sidebar\" orientation=\"left\" area=\"sidebar-1\" background_layout=\"light\" /][/et_pb_column][et_pb_column type=\"1_2\" specialty_columns=\"2\"][et_pb_row_inner][et_pb_column_inner type=\"4_4\"][et_pb_text admin_label=\"Text\"]\r\n<h2>Just A Standard Page</h2>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\nSed sit amet blandit ipsum, et consectetur libero. Integer convallis at metus quis molestie. Morbi vitae odio ut ante molestie scelerisque. Aliquam erat volutpat. Vivamus dignissim fringilla semper. Aliquam imperdiet dui a purus pellentesque, non ornare ipsum blandit. Sed imperdiet elit in quam egestas lacinia nec sit amet dui. Cras malesuada tincidunt ante, in luctus tellus hendrerit at. Duis massa mauris, bibendum a mollis a, laoreet quis elit. Nulla pulvinar vestibulum est, in viverra nisi malesuada vel. Nam ut ipsum quis est faucibus mattis eu ut turpis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas nunc felis, venenatis in fringilla vel, tempus in turpis. Mauris aliquam dictum dolor at varius. Fusce sed vestibulum metus. Vestibulum dictum ultrices nulla sit amet fermentum.\r\n\r\n[/et_pb_text][/et_pb_column_inner][/et_pb_row_inner][et_pb_row_inner][et_pb_column_inner type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h3>Lorem Ipsum Dolor</h3>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][et_pb_column_inner type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]\r\n<h3>Lorem Ipsum Dolor</h3>\r\nNunc et vestibulum velit. Suspendisse euismod eros vel urna bibendum gravida. Phasellus et metus nec dui ornare molestie. In consequat urna sed tincidunt euismod. Praesent non pharetra arcu, at tincidunt sapien. Nullam lobortis ultricies bibendum. Duis elit leo, porta vel nisl in, ullamcorper scelerisque velit. Fusce volutpat purus dolor, vel pulvinar dui porttitor sed. Phasellus ac odio eu quam varius elementum sit amet euismod justo.\r\n\r\n[/et_pb_text][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_sidebar admin_label=\"Sidebar\" orientation=\"right\" area=\"sidebar-1\" background_layout=\"light\" /][/et_pb_column][/et_pb_section]", "Page Dual Sidebars", "", "publish", "open", "open", "", "page-dual-sidebars", "", "", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "", "0", "http://magmainc.co.za/et_pb_layout/page-dual-sidebars/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("14", "1", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"My Work\" subhead=\"Your Subtitle Goes Here\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_filterable_portfolio admin_label=\"Filterable Portfolio\" fullwidth=\"off\" posts_number=\"12\" show_title=\"on\" show_categories=\"on\" show_pagination=\"off\" background_layout=\"light\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Like What You See?\" button_url=\"#\" button_text=\"Contact Me\" use_background_color=\"off\" background_color=\"#108bf5\" background_layout=\"light\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Portfolio Grid", "", "publish", "open", "open", "", "portfolio-grid", "", "", "2015-08-03 06:04:15", "2015-08-03 04:04:15", "", "0", "http://magmainc.co.za/et_pb_layout/portfolio-grid/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("15", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"on\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"My Work\" subhead=\"Your Subtitle Goes Here\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_portfolio admin_label=\"Portfolio\" fullwidth=\"on\" posts_number=\"4\" show_title=\"on\" show_categories=\"on\" show_pagination=\"on\" background_layout=\"light\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"I Love Working With Creative Minds\" button_url=\"#\" button_text=\"Contact Me\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"dark\" text_orientation=\"center\"]If you are interested in working together, send me an inquiry and I will get back to you as soon as I can![/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Portfolio 1 Column", "", "publish", "open", "open", "", "portfolio-1-column", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/portfolio-1-column/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("16", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"on\" parallax=\"off\"][et_pb_slide background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" /][et_pb_slide background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" /][et_pb_slide background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" /][/et_pb_fullwidth_slider][et_pb_fullwidth_portfolio admin_label=\"Fullwidth Portfolio\" fullwidth=\"on\" show_title=\"on\" show_date=\"on\" background_layout=\"light\" auto=\"off\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Let\'s Build Something Together\" button_url=\"#\" button_text=\"Contact Me\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Portfolio Fullwidth Carousel", "", "publish", "open", "open", "", "portfolio-fullwidth-carousel", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/portfolio-fullwidth-carousel/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("17", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_portfolio admin_label=\"Fullwidth Portfolio\" fullwidth=\"off\" show_title=\"on\" show_date=\"on\" background_layout=\"dark\" auto=\"off\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Interested In Working On A Project?\" button_url=\"#\" button_text=\"Contact Me\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Portfolio Fullwidth Grid", "", "publish", "open", "open", "", "portfolio-fullwidth-grid", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/portfolio-fullwidth-grid/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("18", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section background_color=\"#3a3a3a\" inner_shadow=\"off\" parallax=\"on\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_blurb admin_label=\"Blurb\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"bottom\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#45c4ec\" use_circle=\"off\" circle_color=\"#45c4ec\" use_circle_border=\"off\" circle_border_color=\"#45c4ec\" icon_placement=\"top\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]<h1 style=\"font-size: 72px; font-weight: 300;\">Your Project Name</h1>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h2>The Challenge</h2>\r\nVivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl.[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h2>The Solution</h2>\r\nVivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl.[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"on\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"on\"][et_pb_slide heading=\"Complete Corporate Identity\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" /][et_pb_slide heading=\"We Rethought Everything\" background_color=\"#2ea3f2\" alignment=\"center\" background_layout=\"dark\" /][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#353535\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Corporate Rebranding\" number=\"70\" percent_sign=\"on\" background_layout=\"dark\" counter_color=\"#2ea3f2\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Website Redesign\" number=\"30\" percent_sign=\"on\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Day Turnaround\" number=\"60\" percent_sign=\"off\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Amazing Result\" number=\"1\" percent_sign=\"off\" background_layout=\"dark\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"90\" /][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"left\"]<h1>Mobile Site Boosted Sales By 50%</h1>[/et_pb_text][et_pb_blurb admin_label=\"Blurb\" title=\"Mobile Refresh\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"left\" animation=\"right\" background_layout=\"dark\" text_orientation=\"left\"]The Challenge Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Rebuilt From the Inside Out\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"left\" animation=\"right\" background_layout=\"dark\" text_orientation=\"left\"]The Challenge Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Extensive Demographic Studies\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"left\" animation=\"right\" background_layout=\"dark\" text_orientation=\"left\"]The Challenge Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/mobile-lockup.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#353535\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_counters admin_label=\"Bar Counters\" background_layout=\"light\" background_color=\"#2e2e2e\"][et_pb_counter percent=\"80\"]Mobile Sales[/et_pb_counter][et_pb_counter percent=\"50\"]Website Traffic[/et_pb_counter][et_pb_counter percent=\"75\"]Conversion Rate[/et_pb_counter][et_pb_counter percent=\"60\"]Email Subscribers[/et_pb_counter][/et_pb_counters][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" title=\"The Results Were Amazing\" button_url=\"#\" button_text=\"Live Project\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"left\"]Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl.[/et_pb_cta][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"on\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"on\"][et_pb_slide heading=\"We Rethought Everything\" background_color=\"#2ea3f2\" alignment=\"center\" background_layout=\"dark\" /][et_pb_slide heading=\"Complete Corporate Identity\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" /][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Interested In Working With Us?\" button_url=\"#\" button_text=\"Get In Touch\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"light\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Project Extended", "", "publish", "open", "open", "", "project-extended", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/project-extended/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("19", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h1>Your Project Name</h1>[/et_pb_text][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" url_new_window=\"off\" animation=\"fade_in\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"3_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h4>Project Description</h4>\r\nVivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue at nisl. Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien.[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h4>Project Details</h4>\r\n<strong>Client </strong>Client Name\r\n<strong>Date </strong>Date of Completion\r\n<strong>Skills </strong>Branding, Web Design\r\n<strong>View </strong>elegantthemes.com[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][et_pb_cta admin_label=\"Call To Action\" title=\"Project Feature\" button_url=\"#\" button_text=\"Live Project\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"light\" text_orientation=\"left\"]Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl quis nibh non, molestie tempus sapien.[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_3\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"100\" /][et_pb_cta admin_label=\"Call To Action\" title=\"Project Feature\" button_url=\"#\" button_text=\"See More\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"light\" text_orientation=\"right\"]Vivamus ipsum velit, ullamcorper quis nibh, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl.[/et_pb_cta][/et_pb_column][et_pb_column type=\"2_3\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-700px.jpg\" url_new_window=\"off\" animation=\"right\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"on\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Like What You See?\" button_url=\"#\" button_text=\"Contact Us\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"dark\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Project Extended 2", "", "publish", "open", "open", "", "project-extended-2", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/project-extended-2/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("20", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"on\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"Welcome to My Blog\" subhead=\"Here is a masonry blog layout with no sidebar\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_blog admin_label=\"Blog\" fullwidth=\"off\" posts_number=\"18\" meta_date=\"M j, Y\" show_thumbnail=\"on\" show_content=\"off\" show_author=\"on\" show_date=\"on\" show_categories=\"on\" show_pagination=\"on\" background_layout=\"light\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Blog Masonry", "", "publish", "open", "open", "", "blog-masonry", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/blog-masonry/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("21", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"on\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"Welcome to My Blog\" subhead=\"Here is a basic blog layout with a right sidebar\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"on\"][et_pb_column type=\"3_4\" specialty_columns=\"3\"][et_pb_row_inner][et_pb_column_inner type=\"4_4\"][et_pb_blog admin_label=\"Blog\" fullwidth=\"on\" posts_number=\"6\" meta_date=\"M j, Y\" show_thumbnail=\"on\" show_content=\"off\" show_author=\"on\" show_date=\"on\" show_categories=\"on\" show_pagination=\"on\" background_layout=\"light\" /][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_sidebar admin_label=\"Sidebar\" orientation=\"right\" area=\"sidebar-1\" background_layout=\"light\" /][/et_pb_column][/et_pb_section]", "Blog Standard", "", "publish", "open", "open", "", "blog-standard", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/blog-standard/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("22", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#f84b48\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"Welcome to Our Shop\" subhead=\"Divi gives you the power to run a full-fledged online storefront.\" background_layout=\"dark\" text_orientation=\"left\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_shop admin_label=\"Shop\" type=\"recent\" posts_number=\"12\" columns=\"4\" orderby=\"menu_order\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"News & Events\" button_url=\"#\" button_text=\"Follow\" use_background_color=\"on\" background_color=\"#57ccc4\" background_layout=\"dark\" text_orientation=\"center\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada.[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Shop Basic", "", "publish", "open", "open", "", "shop-basic", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/shop-basic/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("23", "1", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#b2ede0\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"Our Shop\" button_text=\"Shop Now\" button_link=\"#\" background_color=\"#81dfde\" alignment=\"center\" background_layout=\"dark\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\"]Divi gives you the power to easily run a full-fledged online storefront. With the Divi Builder, you can create gorgeous shop pages, such as this one.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"on\"][et_pb_column type=\"3_4\" specialty_columns=\"3\"][et_pb_row_inner][et_pb_column_inner type=\"4_4\"][et_pb_shop admin_label=\"Shop\" type=\"recent\" posts_number=\"6\" columns=\"3\" orderby=\"menu_order\" /][/et_pb_column_inner][/et_pb_row_inner][et_pb_row_inner][et_pb_column_inner type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" title=\"Summer Sale!\" button_url=\"#\" button_text=\"Shop Now\" background_color=\"#ed5362\" use_background_color=\"on\" background_layout=\"dark\" text_orientation=\"center\"]For a limited time only, all of our vintage products are 50% off! Don\'t miss your chance to save big on these wonderful items.[/et_pb_cta][/et_pb_column_inner][et_pb_column_inner type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" title=\"Buy 2 Get 1 Free\" button_url=\"#\" button_text=\"Coupon Code\" background_color=\"#57ccc4\" use_background_color=\"on\" background_layout=\"dark\" text_orientation=\"center\"]For a limited time only, if you buy two of any item, you get the 3rd for free! Click below to redeem the coupon code to use at checkout.[/et_pb_cta][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_sidebar admin_label=\"Sidebar\" orientation=\"right\" area=\"sidebar-1\" background_layout=\"light\" /][/et_pb_column][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h1>Our Most Popular Items</h1>[/et_pb_text][et_pb_shop admin_label=\"Shop\" type=\"best_selling\" posts_number=\"4\" columns=\"4\" orderby=\"menu_order\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#57ccc4\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"View All of Our On-Sale Items\" button_url=\"#\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"dark\" text_orientation=\"center\" button_text=\"Shop Now\"]For a limited time only, all of our vintage products are 50% off! Don’t miss your chance to save big on these wonderful items.[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Shop Extended", "", "publish", "open", "open", "", "shop-extended", "", "", "2015-08-03 06:04:16", "2015-08-03 04:04:16", "", "0", "http://magmainc.co.za/et_pb_layout/shop-extended/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("24", "1", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "[et_pb_section background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"150\" /][et_pb_blurb admin_label=\"Blurb\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/d2-300px.png\" animation=\"bottom\" background_layout=\"dark\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#108bf5\" use_circle=\"off\" circle_color=\"#108bf5\" use_circle_border=\"off\" circle_border_color=\"#108bf5\" icon_placement=\"top\"]<h1></h1>[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]<h4><strong>Lorem Ipsum Dolor</strong></h4>\r\nAenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]<h4><strong>Lorem Ipsum Dolor</strong></h4>\r\nAenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]<h4><strong>Lorem Ipsum Dolor</strong></h4>\r\nAenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante.[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" button_text=\"Enter\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"dark\" text_orientation=\"center\" button_url=\"#\" /][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"400\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Splash Page", "", "publish", "open", "open", "", "splash-page", "", "", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "", "0", "http://magmainc.co.za/et_pb_layout/splash-page/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("25", "1", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "[et_pb_section background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][et_pb_blurb admin_label=\"Blurb\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-builder.jpg\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"top\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"center\"]<h1>We will Be back Soon</h1>\r\nThis is an example of a blank page with no header or footer.[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Undergoing Maintenance\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#63cde3\" use_circle=\"on\" circle_color=\"#f7f7f7\" use_circle_border=\"on\" circle_border_color=\"#2ea3f2\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Divi is here to stay, and you can rest easy knowing that our team will be updating and improving it for years to come.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Feature Updates\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#63cde3\" use_circle=\"on\" circle_color=\"#f7f7f7\" use_circle_border=\"on\" circle_border_color=\"#2ea3f2\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Divi is here to stay, and you can rest easy knowing that our team will be updating and improving it for years to come.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Bug Fixes\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#63cde3\" use_circle=\"on\" circle_color=\"#f7f7f7\" use_circle_border=\"on\" circle_border_color=\"#2ea3f2\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Divi is here to stay, and you can rest easy knowing that our team will be updating and improving it for years to come.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" button_url=\"#\" button_text=\"Contact Us\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"light\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Maintenance Mode", "", "publish", "open", "open", "", "maintenance-mode", "", "", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "", "0", "http://magmainc.co.za/et_pb_layout/maintenance-mode/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("26", "1", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "[et_pb_section inner_shadow=\"off\" parallax=\"off\" background_color=\"#8d1bf4\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"70\" /][et_pb_countdown_timer admin_label=\"Countdown Timer\" date_time=\"05/31/2014 05:15\" background_layout=\"dark\" background_color=\"#e03e3e\" use_background_color=\"off\" title=\"This Site Is Coming Soon\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_signup admin_label=\"Subscribe\" title=\"Sign Up to Receive Updates\" button_text=\"Submit\" background_color=\"#6e15c2\" use_background_color=\"on\" mailchimp_list=\"none\" background_layout=\"dark\" text_orientation=\"left\" provider=\"mailchimp\" aweber_list=\"none\"]Integer accumsan leo non nisi sollicitudin, sit amet eleifend dolor mollis. Donec sagittis posuere commodo. Aenean sed convallis lectus. Vivamus et nisi posuere erat aliquet adipiscing in non libero. Integer ornare dui at molestie dictum. Vivamus id aliquam urna. Duis quis fermentum lacus. Sed viverra dui leo, non auctor nisi porttitor a. Nunc a tristique lectus.[/et_pb_signup][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" button_url=\"#\" button_text=\"Contact Us\" background_color=\"#2caaca\" use_background_color=\"off\" background_layout=\"dark\" text_orientation=\"center\" /][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"600\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Coming Soon", "", "publish", "open", "open", "", "coming-soon", "", "", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "", "0", "http://magmainc.co.za/et_pb_layout/coming-soon/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("27", "1", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "[et_pb_section background_color=\"#27323a\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]<h1 style=\"font-size: 72px;\">My Website</h1>\r\n<h2><em>My Tagline</em></h2>[/et_pb_text][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1080px.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"fade_in\" /][et_pb_cta admin_label=\"Call To Action\" title=\"Lorem ipsum dolor sit amet consectetur.\" button_url=\"#\" button_text=\"Learn More\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section background_color=\"#313f55\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" use_icon=\"off\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" icon_placement=\"top\" animation=\"top\" background_layout=\"dark\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" use_icon=\"off\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" icon_placement=\"top\" animation=\"top\" background_layout=\"dark\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum Dolor\" url_new_window=\"off\" use_icon=\"off\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" icon_placement=\"top\" animation=\"top\" background_layout=\"dark\" text_orientation=\"center\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section background_color=\"#27323a\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1080px.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"right\" /][et_pb_cta admin_label=\"Call To Action\" button_url=\"#\" button_text=\"Get Started\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"light\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "Landing Page", "", "publish", "open", "open", "", "landing-page", "", "", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "", "0", "http://magmainc.co.za/et_pb_layout/landing-page/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("28", "1", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "[et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"on\"][et_pb_slide heading=\"My Name\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\"]Subheading[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h1>This is My Story</h1>\r\nCurabitur quis dui volutpat, cursus eros ut, commodo elit. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Ut id est euismod, rhoncus nunc quis, lobortis turpis. Tam sociis natoque. Curabitur quis dui volutpat, cursus eros ut, commodo elit. Cum sociis natoque penatibus et magnis dis parturient montes.[/et_pb_text][/et_pb_column][et_pb_column type=\"2_3\"][et_pb_counters admin_label=\"Bar Counters\" background_layout=\"light\" background_color=\"#dddddd\" bar_bg_color=\"#2ea3f2\"][et_pb_counter percent=\"80\"]Brand Strategy[/et_pb_counter][et_pb_counter percent=\"60\"]Internet Marketing[/et_pb_counter][et_pb_counter percent=\"50\"]App Development[/et_pb_counter][et_pb_counter percent=\"90\"]Customer Happiness[/et_pb_counter][/et_pb_counters][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#108bf5\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_header admin_label=\"Fullwidth Header\" title=\"My Recent Work\" background_layout=\"dark\" text_orientation=\"center\" /][et_pb_fullwidth_portfolio admin_label=\"Fullwidth Portfolio\" fullwidth=\"on\" show_title=\"on\" show_date=\"on\" background_layout=\"light\" auto=\"on\" /][/et_pb_section]", "About Me", "", "publish", "open", "open", "", "about-me", "", "", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "", "0", "http://magmainc.co.za/et_pb_layout/about-me/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("29", "1", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "[et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"on\"][et_pb_slide heading=\"Our Company\" button_text=\"Learn More\" button_link=\"#\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\"]Our Company Tagline lorem ipsum dolor sit amet.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"A Digital Agency\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#7c8d9b\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Curabitur quis dui volutpat, cursus eros elut commodo elit cum sociis natoque penatibus[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Forward Thinking\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#7c8d9b\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Curabitur quis dui volutpat, cursus eros elut commodo elit cum sociis natoque penatibus[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Problem Solvers\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#7c8d9b\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Curabitur quis dui volutpat, cursus eros elut commodo elit cum sociis natoque penatibus[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Customer Support\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#7c8d9b\" use_circle=\"off\" circle_color=\"#2ea3f2\" use_circle_border=\"off\" circle_border_color=\"#2ea3f2\" icon_placement=\"top\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Curabitur quis dui volutpat, cursus eros elut commodo elit cum sociis natoque penatibus[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h1>Our Story</h1>\r\nCurabitur quis dui volutpat, cursus eros ut, commodo elit. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Ut id est euismod, rhoncus nunc quis, lobortis turpis. Tam sociis natoque. Curabitur quis dui volutpat, cursus eros ut, commodo elit. Cum sociis natoque penatibus et magnis dis parturient montes.[/et_pb_text][/et_pb_column][et_pb_column type=\"2_3\"][et_pb_counters admin_label=\"Bar Counters\" background_layout=\"light\" background_color=\"#dddddd\" bar_bg_color=\"#2ea3f2\"][et_pb_counter percent=\"80\"]Brand Strategy[/et_pb_counter][et_pb_counter percent=\"60\"]Internet Marketing[/et_pb_counter][et_pb_counter percent=\"50\"]App Development[/et_pb_counter][et_pb_counter percent=\"90\"]Customer Happiness[/et_pb_counter][/et_pb_counters][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"1_3\"][et_pb_team_member admin_label=\"Team Member\" name=\"Team Member 1\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"light\" facebook_url=\"#\" twitter_url=\"#\" google_url=\"#\" linkedin_url=\"#\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc.[/et_pb_team_member][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_team_member admin_label=\"Team Member\" name=\"Team Member 1\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"light\" facebook_url=\"#\" twitter_url=\"#\" google_url=\"#\" linkedin_url=\"#\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc.[/et_pb_team_member][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_team_member admin_label=\"Team Member\" name=\"Team Member 1\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"light\" facebook_url=\"#\" twitter_url=\"#\" google_url=\"#\" linkedin_url=\"#\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc.[/et_pb_team_member][/et_pb_column][/et_pb_row][/et_pb_section]", "About Us", "", "publish", "open", "open", "", "about-us", "", "", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "", "0", "http://magmainc.co.za/et_pb_layout/about-us/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("30", "1", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "[et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_map admin_label=\"Fullwidth Map\" zoom_level=\"9\" address_lat=\"37.77492949999972\" address_lng=\"-122.41941550000001\"][et_pb_map_pin title=\"Headquarters\" pin_address=\"San Francisco, CA, USA\" pin_address_lat=\"37.7749295\" pin_address_lng=\"-122.41941550000001\" /][/et_pb_fullwidth_map][/et_pb_section][et_pb_section fullwidth=\"off\"][et_pb_row][et_pb_column type=\"2_3\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"off\" title=\"Get In Touch\" /][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h3>More Info</h3>\r\n<p>sit amet, consectetur adipiscing elit. Integer placerat metus id orci facilisis, in luctus eros laoreet. Mauris interdum augue varius, faucibus massa id, imperdiet tortor. Donec vel tortor molestie, hendrerit sem a, hendrerit arcu. Aliquam erat volutpat. Proin varius eros eros, non condimentum nis.</p>\r\n\r\n<strong>Address:</strong> 890 Lorem Ipsum Street #12\r\nSan Francisco, California 65432\r\n\r\n<strong>Phone:</strong> 123.4567.890\r\n\r\n<strong>Business Hours:</strong> 8a-6:30p M-F, 9a-2p S-S[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Contact Us", "", "publish", "open", "open", "", "contact-us", "", "", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "", "0", "http://magmainc.co.za/et_pb_layout/contact-us/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("31", "1", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "[et_pb_section background_color=\"#6aceb6\" inner_shadow=\"on\" fullwidth=\"on\"]\r\n[et_pb_fullwidth_header title=\"About Our Team\" subhead=\"Your subtitle goes right here.\" background_layout=\"dark\"][/et_pb_fullwidth_header]\r\n[/et_pb_section]\r\n\r\n[et_pb_section]\r\n[et_pb_row]\r\n[et_pb_column type=\"1_3\"]\r\n[et_pb_image src=\"http://www.elegantthemesimages.com/images/premade_image_800x600.png\" animation=\"left\"][/et_pb_image]\r\n[et_pb_text]\r\n<h2>Nick Roach</h2>\r\n<em>President, CEO, Theme UI/UX Designer</em>\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis nec nisi non luctus. Donec aliquam non nisi ut rutrum. In sit amet vestibulum felis, id aliquet ipsum. Vestibulum feugiat lacinia aliquet.\r\n[/et_pb_text]\r\n[et_pb_counters]\r\n[et_pb_counter percent=\"50\"]Design & UX[/et_pb_counter]\r\n[et_pb_counter percent=\"80\"]Web Programming[/et_pb_counter]\r\n[et_pb_counter percent=\"10\"]Internet Marketing[/et_pb_counter]\r\n[/et_pb_counters]\r\n[/et_pb_column]\r\n\r\n[et_pb_column type=\"1_3\"]\r\n[et_pb_image src=\"http://www.elegantthemesimages.com/images/premade_image_800x600.png\" animation=\"top\"][/et_pb_image]\r\n[et_pb_text]\r\n<h2>Kenny Sing</h2>\r\n<em>Lead Graphic Designers</em>\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis nec nisi non luctus. Donec aliquam non nisi ut rutrum. In sit amet vestibulum felis, id aliquet ipsum. Vestibulum feugiat lacinia aliquet.\r\n[/et_pb_text]\r\n[et_pb_counters]\r\n[et_pb_counter percent=\"85\"]Photoshop[/et_pb_counter]\r\n[et_pb_counter percent=\"70\"]After Effects[/et_pb_counter]\r\n[et_pb_counter percent=\"50\"]Illustrator[/et_pb_counter]\r\n[/et_pb_counters]\r\n[/et_pb_column]\r\n\r\n[et_pb_column type=\"1_3\"]\r\n[et_pb_image src=\"http://www.elegantthemesimages.com/images/premade_image_800x600.png\" animation=\"right\"][/et_pb_image]\r\n[et_pb_text]\r\n<h2>Mitch Skolnik</h2>\r\n<em>Community Manager</em>\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis nec nisi non luctus. Donec aliquam non nisi ut rutrum. In sit amet vestibulum felis, id aliquet ipsum. Vestibulum feugiat lacinia aliquet.\r\n[/et_pb_text]\r\n[et_pb_counters]\r\n[et_pb_counter percent=\"80\"]Customer Happiness[/et_pb_counter]\r\n[et_pb_counter percent=\"30\"]Tech Support[/et_pb_counter]\r\n[et_pb_counter percent=\"50\"]Community Management[/et_pb_counter]\r\n[/et_pb_counters]\r\n[/et_pb_column]\r\n[/et_pb_row]\r\n[/et_pb_section]\r\n\r\n[et_pb_section background_color=\"#2d3743\" inner_shadow=\"on\"]\r\n[et_pb_row]\r\n[et_pb_column type=\"1_4\"]\r\n[et_pb_blurb background_layout=\"dark\" image=\"http://www.elegantthemesimages.com/images/premade_blurb_5.png\"  title=\"Timely Support\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec eleifend tincidunt nisi. Fusce at purus in massa laoreet.[/et_pb_blurb]\r\n[/et_pb_column]\r\n[et_pb_column type=\"1_4\"]\r\n[et_pb_blurb background_layout=\"dark\" image=\"http://www.elegantthemesimages.com/images/premade_blurb_6.png\"  title=\"Innovative Ideas\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec eleifend tincidunt nisi. Fusce at purus in massa laoreet.[/et_pb_blurb]\r\n[/et_pb_column]\r\n[et_pb_column type=\"1_4\"]\r\n[et_pb_blurb background_layout=\"dark\" image=\"http://www.elegantthemesimages.com/images/premade_blurb_7.png\"  title=\"Advanced Technology\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec eleifend tincidunt nisi. Fusce at purus in massa laoreet.[/et_pb_blurb]\r\n[/et_pb_column]\r\n[et_pb_column type=\"1_4\"]\r\n[et_pb_blurb background_layout=\"dark\" image=\"http://www.elegantthemesimages.com/images/premade_blurb_8.png\"  title=\"Clear Communication\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec eleifend tincidunt nisi. Fusce at purus in massa laoreet.[/et_pb_blurb]\r\n[/et_pb_column]\r\n[/et_pb_row]\r\n[/et_pb_section]\r\n\r\n[et_pb_section background_color=\"#f5f5f5\" inner_shadow=\"on\"]\r\n[et_pb_row]\r\n[et_pb_column type=\"4_4\"]\r\n[et_pb_text text_orientation=\"center\"]<h2>Recent Blog Posts</h2>\r\nLearn from the top thought leaders in the industry.\r\n[/et_pb_text]\r\n[/et_pb_column]\r\n[/et_pb_row]\r\n[et_pb_row]\r\n[et_pb_column type=\"4_4\"]\r\n[et_pb_blog fullwidth=\"off\" show_pagination=\"off\" posts_number=\"3\" meta_date=\"M j, Y\" show_thumbnail=\"on\" show_content=\"off\" show_author=\"on\" show_date=\"on\" show_categories=\"on\"][/et_pb_blog]\r\n[/et_pb_column]\r\n[/et_pb_row]\r\n[/et_pb_section]\r\n\r\n[et_pb_section]\r\n[et_pb_row]\r\n[et_pb_column type=\"4_4\"]\r\n[et_pb_text text_orientation=\"center\"]<h2>Recent Projects</h2>\r\nLearn from the top thought leaders in the industry.\r\n[/et_pb_text]\r\n[/et_pb_column]\r\n[/et_pb_row]\r\n[et_pb_row]\r\n[et_pb_column type=\"4_4\"]\r\n[et_pb_portfolio categories=\"Portfolio\" fullwidth=\"off\"][/et_pb_portfolio]\r\n[/et_pb_column]\r\n[/et_pb_row]\r\n[/et_pb_section]\r\n\r\n[et_pb_section background_color=\"#7EBEC5\"]\r\n[et_pb_row]\r\n[et_pb_column type=\"4_4\"]\r\n[et_pb_cta title=\"Don\'t Be Shy. Get In Touch.\" button_url=\"#\" button_text=\"Contact Us\" background_layout=\"dark\" background_color=\"none\"]\r\nIf you are interested in working together, send us an inquiry and we will get back to you as soon as we can!\r\n[/et_pb_cta]\r\n[/et_pb_column]\r\n[/et_pb_row]\r\n[/et_pb_section]", "Our Team", "", "publish", "open", "open", "", "our-team", "", "", "2015-08-03 06:04:17", "2015-08-03 04:04:17", "", "0", "http://magmainc.co.za/et_pb_layout/our-team/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("32", "1", "2015-08-03 06:04:18", "2015-08-03 04:04:18", "[et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"WE ARE A CREATIVE AGENCY\" button_text=\"Our Work\" button_link=\"http://elegantthemes.com/preview/Divi2/fullwidth-grid/\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" /][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-mobile.jpg\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#108bf5\" use_circle=\"off\" circle_color=\"#108bf5\" use_circle_border=\"off\" circle_border_color=\"#108bf5\" icon_placement=\"top\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-export.jpg\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#108bf5\" use_circle=\"off\" circle_color=\"#108bf5\" use_circle_border=\"off\" circle_border_color=\"#108bf5\" icon_placement=\"top\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-layouts.jpg\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#108bf5\" use_circle=\"off\" circle_color=\"#108bf5\" use_circle_border=\"off\" circle_border_color=\"#108bf5\" icon_placement=\"top\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Lorem Ipsum\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/builder-blurbs-commerce.jpg\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#108bf5\" use_circle=\"off\" circle_color=\"#108bf5\" use_circle_border=\"off\" circle_border_color=\"#108bf5\" icon_placement=\"top\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f7f7f7\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"center\"]<h1>OUR LATEST WORK</h1>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_portfolio admin_label=\"Portfolio\" fullwidth=\"off\" posts_number=\"8\" show_title=\"on\" show_categories=\"off\" show_pagination=\"off\" background_layout=\"light\" /][et_pb_cta admin_label=\"Call To Action\" button_url=\"#\" button_text=\"Full Portfolio\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"light\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#222b34\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]<h1>MEET THE CREW</h1>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_team_member admin_label=\"Team Member\" name=\"Lorem Ipsum\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"dark\" /][et_pb_team_member admin_label=\"Team Member\" name=\"Lorem Ipsum\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_team_member admin_label=\"Team Member\" name=\"Lorem Ipsum\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"dark\" /][et_pb_team_member admin_label=\"Team Member\" name=\"Lorem Ipsum\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_team_member admin_label=\"Team Member\" name=\"Lorem Ipsum\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"dark\" /][et_pb_team_member admin_label=\"Team Member\" name=\"Lorem Ipsum\" position=\"Company Role\" image_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-320px.jpg\" animation=\"fade_in\" background_layout=\"dark\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" button_url=\"#\" button_text=\"Full Profiles\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"center\"]<h1>OUR CLIENTS</h1>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/et-logo.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/et-logo.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/et-logo.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/et-logo.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/et-logo.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/et-logo.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/et-logo.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/05/et-logo.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" button_url=\"#\" button_text=\"Full List\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"light\" text_orientation=\"center\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" inner_shadow=\"off\" parallax=\"off\" background_color=\"#2ea3f2\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_signup admin_label=\"Subscribe\" provider=\"mailchimp\" mailc\r\nhimp_list=\"none\" aweber_list=\"3423452\" button_text=\"Sign Me Up\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"left\" title=\"Connect With Us\"]Aenean consectetur ipsum ante, vel egestas enim tincidunt quis. Pellentesque vitae congue neque, vel mattis ante. In vitae tempus nunc. Etiam adipiscing enim sed condimentum ultrices. Cras rutrum blandit sem, molestie consequat erat luctus vel. Cras nunc est, laoreet sit amet ligula et, eleifend commodo dui. Vivamus id blandit nisi, eu mattis odio. Nulla facilisi. Aenean in mi odio. Etiam adipiscing enim sed condimentum ultrices.[/et_pb_signup][/et_pb_column][/et_pb_row][/et_pb_section]", "Creative Agency", "", "publish", "open", "open", "", "creative-agency", "", "", "2015-08-03 06:04:18", "2015-08-03 04:04:18", "", "0", "http://magmainc.co.za/et_pb_layout/creative-agency/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("33", "1", "2015-08-03 06:04:18", "2015-08-03 04:04:18", "[et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"A Brand New Product\" background_color=\"#efefef\" image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" alignment=\"center\" background_layout=\"light\" button_text=\"Buy Now\"]The Divi Builder allows you to create beautiful and unique layouts visually, without touching a single line of code.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Gorgeous Design\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#108bf5\" use_circle_border=\"off\" circle_border_color=\"#108bf5\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Drag & Drop Builder\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"1\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#108bf5\" use_circle_border=\"off\" circle_border_color=\"#108bf5\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_blurb admin_label=\"Blurb\" title=\"Fully Responsive\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#2ea3f2\" use_circle=\"off\" circle_color=\"#108bf5\" use_circle_border=\"off\" circle_border_color=\"#108bf5\" icon_placement=\"left\" animation=\"top\" background_layout=\"light\" text_orientation=\"center\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f3f3f3\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"center\"]<h1>Plans and Pricing</h1>\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam eros at, laoreet metus. Proin ac eros eros. Suspendisse auctor, eros ac sollicitudin vulputate.[/et_pb_text][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][et_pb_pricing_tables admin_label=\"Pricing Table\"][et_pb_pricing_table featured=\"off\" title=\"Basic\" currency=\"$\" per=\"yr\" sum=\"39\" button_url=\"http://elegantthemes.com/\" button_text=\"Sign Up\"]+Access to <a href=\"http://elegantthemes.com/preview/Divi/module-pricing-tables/#\">All Themes</a>\r\n+Perpetual Theme Updates\r\n-Premium Technical Support\r\n-Access to <a href=\"http://elegantthemes.com/preview/Divi/module-pricing-tables/#\">All Plugins</a>\r\n-Layered Photoshop Files\r\n-No Yearly Fees[/et_pb_pricing_table][et_pb_pricing_table featured=\"off\" title=\"Personal\" currency=\"$\" per=\"yr\" sum=\"69\" button_url=\"http://elegantthemes.com/\" button_text=\"Sign Up\"]+Access to <a href=\"http://elegantthemes.com/preview/Divi/module-pricing-tables/#\">All Themes</a>\r\n+Perpetual Theme Updates\r\n+Premium Technical Support\r\n-Access to <a href=\"http://elegantthemes.com/preview/Divi/module-pricing-tables/#\">All Plugins</a>\r\n-Layered Photoshop Files\r\n-No Yearly Fees[/et_pb_pricing_table][et_pb_pricing_table featured=\"on\" title=\"Developer\" subtitle=\"Best Value\" currency=\"$\" per=\"yr\" sum=\"89\" button_url=\"http://elegantthemes.com/\" button_text=\"Sign Up\"]+Access to <a href=\"http://elegantthemes.com/preview/Divi/module-pricing-tables/#\">All Themes</a>\r\n+Perpetual Theme Updates\r\n+Premium Technical Support\r\n+Access to <a href=\"http://elegantthemes.com/preview/Divi/module-pricing-tables/#\">All Plugins</a>\r\n+Layered Photoshop Files\r\n-No Yearly Fees[/et_pb_pricing_table][et_pb_pricing_table featured=\"off\" title=\"Lifetime\" currency=\"$\" sum=\"249\" button_url=\"http://elegantthemes.com/\" button_text=\"Sign Up\"]+Access to <a href=\"http://elegantthemes.com/preview/Divi/module-pricing-tables/#\">All Themes</a>\r\n+Perpetual Theme Updates\r\n+Premium Technical Support\r\n+Access to <a href=\"http://elegantthemes.com/preview/Divi/module-pricing-tables/#\">All Plugins</a>\r\n+Layered Photoshop Files\r\n+No Yearly Fees[/et_pb_pricing_table][/et_pb_pricing_tables][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"center\"]<h1>What Our Customers Are Saying</h1>\r\nDon\'t just take it from us, let our customers do the talking![/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Luke Chapman\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\"]\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam eros at, laoreet metus. Proin ac eros eros. Suspendisse auctor, eros ac sollicitudin vulputate, urna arcu sodales quam, eget faucibus eros ante nec enim.\r\n\r\nEtiam quis eros in enim molestie tempus a non urna. Suspendisse nibh massa, tristique sit amet interdum non, fermentum in quam. \"[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Luke Chapman\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\"]\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam eros at, laoreet metus. Proin ac eros eros. Suspendisse auctor, eros ac sollicitudin vulputate, urna arcu sodales quam, eget faucibus eros ante nec enim.\r\n\r\nEtiam quis eros in enim molestie tempus a non urna. Suspendisse nibh massa, tristique sit amet interdum non, fermentum in quam. \"[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_testimonial admin_label=\"Testimonial\" author=\"Luke Chapman\" url_new_window=\"off\" portrait_url=\"http://elegantthemesimages.com/images/premade/d2-placeholder-225px.png\" quote_icon=\"off\" use_background_color=\"on\" background_color=\"#f5f5f5\" background_layout=\"light\" text_orientation=\"left\"]\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In in risus eget lectus suscipit malesuada. Maecenas ut urna mollis, aliquam eros at, laoreet metus. Proin ac eros eros. Suspendisse auctor, eros ac sollicitudin vulputate, urna arcu sodales quam, eget faucibus eros ante nec enim.\r\n\r\nEtiam quis eros in enim molestie tempus a non urna. Suspendisse nibh massa, tristique sit amet interdum non, fermentum in quam. \"[/et_pb_testimonial][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#eeeeee\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/et-logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"bottom\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/et-logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"bottom\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/et-logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"bottom\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/et-logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"bottom\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"center\"]<h1>Frequently Asked Questions</h1>[/et_pb_text][et_pb_toggle admin_label=\"Toggle\" title=\"Can I use the themes on multiple sites?\" open=\"off\"]Yes, you are free to use our themes on as many websites as you like. We do not place any restrictions on how many times you can download or use a theme, nor do we limit the number of domains that you can install our themes to.[/et_pb_toggle][et_pb_toggle admin_label=\"Toggle\" title=\"What is your refund policy?\" open=\"on\"]We offer no-questions-asked refunds to all customers within 30 days of your purchase. If you are not satisfied with our product, then simply send us an email and we will refund your purchase right away. Our goal has always been to create a happy, thriving community. If you are not thrilled with the product or are not enjoying the experience, then we have no interest in forcing you to stay an unhappy member.[/et_pb_toggle][et_pb_toggle admin_label=\"Toggle\" title=\"What are Photoshop Files?\" open=\"off\"]Elegant Themes offers two different packages: Personal and Developer. The Personal Subscription is ideal for the average user while the Developers License is meant for experienced designers who wish to customize their themes using the original Photoshop files. Photoshop files are the original design files that were used to create the theme. They can be opened using Adobe Photoshop and edited, and prove very useful for customers wishing to change their theme\'s design in some way.[/et_pb_toggle][et_pb_toggle admin_label=\"Toggle\" title=\"Can I upgrade after signing up?\" open=\"off\"]Yes, you can upgrade at any time after signing up. When you log in as a \"personal\" subscriber, you will see a notice regarding your current package and instructions on how to upgrade.[/et_pb_toggle][et_pb_toggle admin_label=\"Toggle\" title=\"Can I use your themes with WP.com?\" open=\"off\"]Unfortunately WordPress.com does not allow the use of custom themes. If you would like to use a custom theme of any kind, you will need to purchase your own hosting account and install the free software from WordPress.org. If you are looking for great WordPress hosting, we recommend giving HostGator a try.[/et_pb_toggle][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" inner_shadow=\"on\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Don\'t Be Shy\" button_url=\"#\" button_text=\"Get In Touch\" use_background_color=\"off\" background_color=\"#108bf5\" background_layout=\"dark\" text_orientation=\"center\"]If we didn\'t answer all of your questions, feel free to drop us a line anytime.[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Sales Page", "", "publish", "open", "open", "", "sales-page", "", "", "2015-08-03 06:04:18", "2015-08-03 04:04:18", "", "0", "http://magmainc.co.za/et_pb_layout/sales-page/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("34", "1", "2015-08-03 06:04:18", "2015-08-03 04:04:18", "[et_pb_section background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"on\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_blurb admin_label=\"Blurb\" url_new_window=\"off\" image=\"http://elegantthemesimages.com/images/premade/d2-300px.png\" animation=\"bottom\" background_layout=\"light\" text_orientation=\"center\" use_icon=\"off\" icon_color=\"#45c4ec\" use_circle=\"off\" circle_color=\"#45c4ec\" use_circle_border=\"off\" circle_border_color=\"#45c4ec\" icon_placement=\"top\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]<h1 style=\"font-size: 72px; font-weight: 300;\">Divi Case Study</h1>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h2>The Challenge</h2>\r\nVivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl.[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\"]<h2>The Solution</h2>\r\nVivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl.[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"on\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"on\"][et_pb_slide heading=\"Complete Corporate Identity\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" /][et_pb_slide heading=\"We Rethought Everything\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" /][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#353535\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Corporate Rebranding\" number=\"70\" percent_sign=\"on\" background_layout=\"dark\" counter_color=\"#2ea3f2\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Website Redesign\" number=\"30\" percent_sign=\"on\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Day Turnaround\" number=\"60\" percent_sign=\"off\" background_layout=\"dark\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_number_counter admin_label=\"Number Counter\" title=\"Amazing Result\" number=\"1\" percent_sign=\"off\" background_layout=\"dark\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#2ea3f2\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"90\" /][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"left\"]<h1>Mobile Site Boosted Sales By 50%</h1>[/et_pb_text][et_pb_blurb admin_label=\"Blurb\" title=\"Mobile Refresh\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"left\" animation=\"right\" background_layout=\"dark\" text_orientation=\"left\"]The Challenge Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Rebuilt From the Inside Out\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"left\" animation=\"right\" background_layout=\"dark\" text_orientation=\"left\"]The Challenge Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor[/et_pb_blurb][et_pb_blurb admin_label=\"Blurb\" title=\"Extensive Demographic Studies\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"\" icon_color=\"#ffffff\" use_circle=\"off\" circle_color=\"#2caaca\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"left\" animation=\"right\" background_layout=\"dark\" text_orientation=\"left\"]The Challenge Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/mobile-lockup.png\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#353535\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_counters admin_label=\"Bar Counters\" background_layout=\"light\" background_color=\"#2e2e2e\"][et_pb_counter percent=\"80\"]Mobile Sales[/et_pb_counter][et_pb_counter percent=\"50\"]Website Traffic[/et_pb_counter][et_pb_counter percent=\"75\"]Conversion Rate[/et_pb_counter][et_pb_counter percent=\"60\"]Email Subscribers[/et_pb_counter][/et_pb_counters][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" title=\"The Results Were Amazing\" button_url=\"#\" button_text=\"Live Project\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"left\"]Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl. Vivamus ipsum velit, ullamcorper quis nibh non, molestie tempus sapien. Mauris ultrices, felis ut eleifend auctor, leo felis vehicula quam, ut accumsan augue nunc at nisl.[/et_pb_cta][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" inner_shadow=\"off\" parallax=\"off\" background_color=\"#2e2e2e\"][et_pb_fullwidth_portfolio admin_label=\"Fullwidth Portfolio\" fullwidth=\"on\" show_title=\"on\" show_date=\"off\" background_layout=\"dark\" auto=\"off\" title=\"Related Case Studies\" /][/et_pb_section]", "Case Study", "", "publish", "open", "open", "", "case-study", "", "", "2015-08-03 06:04:18", "2015-08-03 04:04:18", "", "0", "http://magmainc.co.za/et_pb_layout/case-study/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("35", "1", "2015-08-03 06:04:18", "2015-08-03 04:04:18", "[et_pb_section background_color=\"#132c47\" inner_shadow=\"off\" parallax=\"on\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"60\" /][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]<h1 style=\"font-size: 52px;\">Product Features</h1>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\" url_new_window=\"off\" animation=\"bottom\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Advanced Page Builder\" url_new_window=\"off\" animation=\"top\" background_layout=\"dark\" text_orientation=\"center\" use_icon=\"on\" use_circle=\"on\" circle_color=\"#0d2035\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\" font_icon=\"\" icon_color=\"#2ea3f2\"]Divi will change the way you build websites forever. The advanced page builder makes it possible to build truly dynamic pages without learning code.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Key Elements\" url_new_window=\"off\" animation=\"top\" background_layout=\"dark\" text_orientation=\"center\" use_icon=\"on\" use_circle=\"on\" circle_color=\"#0d2035\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\" font_icon=\"\" icon_color=\"#2ad4e0\"]The builder comes packed with tons of great modules, and more are on the way! Combine and arrange them in any order. The possibilities are countless.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Target Audience\" url_new_window=\"off\" animation=\"top\" background_layout=\"dark\" text_orientation=\"center\" use_icon=\"on\" icon_color=\"#9633e8\" use_circle=\"on\" circle_color=\"#0d2035\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\" font_icon=\"\"]Divi’s layout has been designed with mobile devices in mind. No matter how you use it, and no matter how you view it, your website is going to look great.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb admin_label=\"Blurb\" title=\"Strategy\" url_new_window=\"off\" image=\"http://elegantthemes.com/preview/Divi2/wp-content/uploads/2014/04/blurb-icon-updates.png\" animation=\"top\" background_layout=\"dark\" text_orientation=\"center\" use_icon=\"on\" icon_color=\"#d85fd6\" use_circle=\"on\" circle_color=\"#0d2035\" use_circle_border=\"off\" circle_border_color=\"#2caaca\" icon_placement=\"top\" font_icon=\"\"]Divi is here to stay, and you can rest easy knowing that our team will be updating and improving it for years to come. Build on top of a powerful foundation.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\" module_id=\"builder\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"center\"]<h1>Advanced Drag & Drop Builder</h1>\r\nThe Divi Builder was made with user experience at the forefront of its priorities. The way it is broken up into sections, rows, columns and widgets, really allows you to understand and edit the structure of your page. Your editing controls are pulled out of the main content area so that you get a clear and concise representation of how your modules fit into your page layout.[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1080px.jpg\" url_new_window=\"off\" animation=\"right\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"on\" module_id=\"backgrounds\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" parallax=\"off\"][et_pb_slide heading=\"All The Right Things\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" background_image=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1920.jpg\"]Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi.Vestibulum lobortis. Donec at euismod nibh, eu bibendum quam. Nullam non gravida purus, nec  eleifend tincidunt nisi.[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#283139\" inner_shadow=\"off\" parallax=\"off\" module_id=\"mobile\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"dark\" text_orientation=\"center\"]\r\n<h1>Fully Responsive Layouts</h1>\r\nWe know that your website needs to be accessible and readable on all devices. We made Divi fully responsive so that your designs look great no matter what. With the builder, you design your desktop website, and we make sure that Divi does the heavy lifting for you.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-1080px.jpg\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#ffffff\" inner_shadow=\"off\" parallax=\"off\" module_id=\"layouts\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" url_new_window=\"off\" animation=\"right\" show_in_lightbox=\"off\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"70\" /][et_pb_cta admin_label=\"Call To Action\" title=\"Product Feature\" button_url=\"#\" button_text=\"Learn More\" use_background_color=\"off\" background_color=\"#2caaca\" background_layout=\"light\" text_orientation=\"left\"]Divi Ships with a tone of great premade layouts to get you started with a homepage, a portfolio, an eCommerce Storefront, and much more! Check out the theme demo to preview a few of these premade layouts. We\'ve even realeased layout packs along the way for portfolios and business focused websites.[/et_pb_cta][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"40\" /][et_pb_cta admin_label=\"Call To Action\" title=\"Product Feature\" button_url=\"#\" button_text=\"Learn More\" use_background_color=\"off\" background_color=\"#2caaca\" background_layout=\"light\" text_orientation=\"right\"]Divi Ships with a tone of great premade layouts to get you started with a homepage, a portfolio, an eCommerce Storefront, and much more! Check out the theme demo to preview a few of these premade layouts. We\'ve even realeased layout packs along the way for portfolios and business focused websites.[/et_pb_cta][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_image admin_label=\"Image\" src=\"http://elegantthemesimages.com/images/premade/d2-placeholder-510px.jpg\" url_new_window=\"off\" animation=\"left\" show_in_lightbox=\"off\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" background_color=\"#f74b47\" inner_shadow=\"off\" parallax=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" title=\"Signup Today For Instant Access\" button_url=\"#\" button_text=\"Join Today\" use_background_color=\"off\" background_color=\"#2ea3f2\" background_layout=\"dark\" text_orientation=\"center\"]Join today and get access to Divi, as well as our other countless themes and plugins.[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "Product Features", "", "publish", "open", "open", "", "product-features", "", "", "2015-08-03 06:04:18", "2015-08-03 04:04:18", "", "0", "http://magmainc.co.za/et_pb_layout/product-features/", "0", "et_pb_layout", "", "0");
INSERT INTO `eadsk_posts` VALUES("37", "1", "2015-08-03 09:00:10", "2015-08-03 07:00:10", "[et_pb_section][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\nFatigue is a condition characterised by low energy levels, chronic tiredness and lethargy, exhaustion, and so on. Often people believe that these factors lead to an unhealthy lifestyle, but the truth is that they are the result of one.\n\nWhile these factors can be debilitating to a person’s personal and professional life, they are completely controllable. This control comes in the form of Fatigue Management.\n\nHowever, before we explore the specifics of fatigue management, let us take a closer look at fatigue itself.\n\n&nbsp;\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"2_3\"][/et_pb_column][et_pb_column type=\"1_3\"][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "trash", "open", "open", "", "37", "", "", "2015-08-14 10:43:32", "2015-08-14 08:43:32", "", "0", "http://magmainc.co.za/?page_id=37", "0", "page", "", "0");
INSERT INTO `eadsk_posts` VALUES("39", "1", "2015-08-11 15:44:18", "2015-08-11 13:44:18", "[et_pb_section fullwidth=\"on\" specialty=\"off\" transparent_background=\"off\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" custom_padding=\"20|20\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"on\" auto_ignore_hover=\"off\" parallax=\"off\" parallax_method=\"off\" remove_inner_shadow=\"off\" background_position=\"default\" background_size=\"default\" hide_content_on_mobile=\"off\" hide_cta_on_mobile=\"off\" show_image_video_mobile=\"off\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\" auto_speed=\"5000\" top_padding=\"150\" bottom_padding=\"150\"] [et_pb_slide background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/lawyer2.jpg\" background_position=\"bottom_center\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" header_font=\"|on|||\" header_font_size=\"4\"] [/et_pb_slide][et_pb_slide background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/fam-1200x300.jpg\" background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" heading=\"Family Law\"] [/et_pb_slide][et_pb_slide background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/plane-1200x300.jpg\" background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" heading=\"Aviation Law\"] [/et_pb_slide][et_pb_slide heading=\"Mergers and acquisitions | Contracts | Tax law\" background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/contractlaw2.jpg\" background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\"] [/et_pb_slide][et_pb_slide heading=\"Mining law | Labour Law\" background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/mine-1200x300.jpg\" background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\"] [/et_pb_slide] [/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"2_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Magma Incorporated Attorneys</h1>\r\n&nbsp;\r\n\r\n<span style=\"font-size: 14pt;\">Magma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub.</span>\r\n\r\n&nbsp;\r\n\r\nThe firm is a 100% Black owned and run with a certified BBB-EE level 1 status. Although <a href=\"http://magmainc.co.za/about-us/\">Magma Inc. Attorneys</a> has recently been incorporated, it traces its roots and 15 years’ history back to June 2000 when it was formed, then as Magale Masemola Attorneys.\r\n\r\nThe firm has a rich and solid history of providing its diverse portfolio of clients with value for money, <a href=\"http://magmainc.co.za/practice-area/\">diversified legal services</a> and we do so in a manner that meets our clients’ expectations and often exceeding them.\r\n\r\nOur diverse range of legal, finance and other expertise pave a way for formidable partnerships we forge with our clients across the whole spectrum of their <a href=\"http://magmainc.co.za/practice-area/\">legal needs</a> and requirements.\r\n\r\nWe benchmark ourselves against the very results that our clients expect from us.\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Why use us</h2>\r\n<ul>\r\n	<li>Competitive fees.</li>\r\n	<li>Well resourced in terms of staff compliment, books and law reports and statutes that ensure we are able to render a good quality service within a short space of time without compromising quality,</li>\r\n	<li>Our ability to research a subject matter forms the basis for our success as we know exactly where to find information within a short space of time thus narrowing the time spend on collecting information, saving our clients fees.</li>\r\n</ul>\r\n[/et_pb_text][et_pb_cta admin_label=\"Call To Action\" url_new_window=\"off\" button_text=\"CONTACT US\" use_background_color=\"off\" background_color=\"#ad002e\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\" button_url=\"http://magmainc.co.za/contact-us/\"]\r\n\r\n<strong>We look forward to being of service to you.</strong>\r\n\r\n[/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section transparent_background=\"off\" background_color=\"#ede9d5\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nMagma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma. When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment.\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<div>Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way. Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Some of our distinguished clients</h3>\r\n[/et_pb_text][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/Clients.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section]", "HOME", "", "publish", "open", "open", "", "39-2", "", "", "2015-08-19 21:12:52", "2015-08-19 19:12:52", "", "0", "http://magmainc.co.za/?page_id=39", "0", "page", "", "0");
INSERT INTO `eadsk_posts` VALUES("40", "1", "2015-08-11 15:44:18", "2015-08-11 13:44:18", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Magma Incorporated Attorneys</h1>\r\n<div></div>\r\n<div>Magma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma.</div>\r\n<div></div>\r\n<div>When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment. Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way.</div>\r\n<div></div>\r\n<div>Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "inherit", "open", "open", "", "39-revision-v1", "", "", "2015-08-11 15:44:18", "2015-08-11 13:44:18", "", "39", "http://magmainc.co.za/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("41", "1", "2015-08-11 15:45:58", "2015-08-11 13:45:58", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nMagma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub.\r\n\r\nThe firm is a 100% Black owned and run with a certified BBB-EE level 3 status. Although Magma Inc. Attorneys has recently been incorporated, it traces its roots and 15 years’ history back to June 2000 when it was formed, then as Magale Masemola Attorneys.\r\n\r\nThe firm has a rich and solid history of providing its diverse portfolio of clients with value for money\r\ndiversified legal services and we do so in a manner that meets our clients’ expectations and often exceeding them.\r\n\r\nOur diverse range of legal, finance and other expertise pave a way for formidable partnerships we forge with our clients across the whole spectrum of their legal needs and requirements.\r\n\r\nWe benchmark ourselves against the very results that our clients expect from us\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Magma Incorporated Attorneys</h1>\r\n<div></div>\r\n<div>Magma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma.</div>\r\n<div></div>\r\n<div>When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment. Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way.</div>\r\n<div></div>\r\n<div>Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "inherit", "open", "open", "", "39-revision-v1", "", "", "2015-08-11 15:45:58", "2015-08-11 13:45:58", "", "39", "http://magmainc.co.za/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("42", "1", "2015-08-14 16:06:31", "2015-08-14 14:06:31", "<p>[et_pb_section fullwidth=\"on\" specialty=\"off\" transparent_background=\"off\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" custom_padding=\"20|20\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"on\" auto_ignore_hover=\"off\" parallax=\"off\" parallax_method=\"off\" remove_inner_shadow=\"off\" background_position=\"default\" background_size=\"default\" hide_content_on_mobile=\"off\" hide_cta_on_mobile=\"off\" show_image_video_mobile=\"off\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\" auto_speed=\"5000\" top_padding=\"150\" bottom_padding=\"150\"] [et_pb_slide background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/lawyer2.jpg\" background_position=\"bottom_center\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" header_font=\"|on|||\" header_font_size=\"4\"] [/et_pb_slide][et_pb_slide background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/fam-1200x300.jpg\" background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" heading=\"Family Law\"] [/et_pb_slide][et_pb_slide background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/plane-1200x300.jpg\" background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" heading=\"Aviation Law\"] [/et_pb_slide][et_pb_slide heading=\"Mergers and Aquisitions | Contracts\" background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/contractlaw2.jpg\" background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\"] [/et_pb_slide] [/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"2_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]</p>\n<h1>Magma Incorporated Attorneys</h1>\n<p>&nbsp;</p>\n<p><span style=\"font-size: 14pt;\">Magma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub.</span></p>\n<p>&nbsp;</p>\n<p>The firm is a 100% Black owned and run with a certified BBB-EE level 3 status. Although Magma Inc. Attorneys has recently been incorporated, it traces its roots and 15 years’ history back to June 2000 when it was formed, then as Magale Masemola Attorneys.</p>\n<p>The firm has a rich and solid history of providing its diverse portfolio of clients with value for money, diversified legal services and we do so in a manner that meets our clients’ expectations and often exceeding them.</p>\n<p>Our diverse range of legal, finance and other expertise pave a way for formidable partnerships we forge with our clients across the whole spectrum of their legal needs and requirements.</p>\n<p>We benchmark ourselves against the very results that our clients expect from us.</p>\n<p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]</p>\n<h2>Why use us</h2>\n<ul>\n<li>Competitive in terms of fees.</li>\n<li>Our firm is well resourced in terms of staff compliment as well as books and law reports and statutes that ensure we are able to render a good quality service within a short space of time without compromising quality,</li>\n<li>Our ability to research on the subject matter forms the basis for our success as we know exactly where to find information within a short space of time and thus narrowing the time spend on collecting information and this consequently once again save our clients fees, we look forward to being of service to you.</li>\n</ul>\n<p>We look forward to being of service to you.</p>\n<p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section transparent_background=\"off\" background_color=\"#ede9d5\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]</p>\n<p>Magma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma. When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment.</p>\n<p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]</p>\n<div>Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way. Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\n<p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]</p>\n<h3>Some of our distinguished clients</h3>\n<p>[/et_pb_text][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/Clients.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section]</p>\n", "HOME", "", "inherit", "open", "open", "", "39-autosave-v1", "", "", "2015-08-14 16:06:31", "2015-08-14 14:06:31", "", "39", "http://magmainc.co.za/39-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("43", "1", "2015-08-11 15:49:18", "2015-08-11 13:49:18", "", "education", "", "inherit", "open", "open", "", "education", "", "", "2015-08-11 15:49:18", "2015-08-11 13:49:18", "", "39", "http://magmainc.co.za/wp-content/uploads/2015/08/education.png", "0", "attachment", "image/png", "0");
INSERT INTO `eadsk_posts` VALUES("44", "1", "2015-08-11 15:49:35", "2015-08-11 13:49:35", "", "finbond", "", "inherit", "open", "open", "", "finbond", "", "", "2015-08-11 15:49:35", "2015-08-11 13:49:35", "", "39", "http://magmainc.co.za/wp-content/uploads/2015/08/finbond.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `eadsk_posts` VALUES("45", "1", "2015-08-11 15:49:57", "2015-08-11 13:49:57", "", "fxi", "", "inherit", "open", "open", "", "fxi", "", "", "2015-08-11 15:49:57", "2015-08-11 13:49:57", "", "39", "http://magmainc.co.za/wp-content/uploads/2015/08/fxi.png", "0", "attachment", "image/png", "0");
INSERT INTO `eadsk_posts` VALUES("46", "1", "2015-08-11 15:50:11", "2015-08-11 13:50:11", "", "logo", "", "inherit", "open", "open", "", "logo", "", "", "2015-08-11 15:50:11", "2015-08-11 13:50:11", "", "39", "http://magmainc.co.za/wp-content/uploads/2015/08/logo.png", "0", "attachment", "image/png", "0");
INSERT INTO `eadsk_posts` VALUES("47", "1", "2015-08-11 15:50:16", "2015-08-11 13:50:16", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nMagma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub.\r\n\r\nThe firm is a 100% Black owned and run with a certified BBB-EE level 3 status. Although Magma Inc. Attorneys has recently been incorporated, it traces its roots and 15 years’ history back to June 2000 when it was formed, then as Magale Masemola Attorneys.\r\n\r\nThe firm has a rich and solid history of providing its diverse portfolio of clients with value for money\r\ndiversified legal services and we do so in a manner that meets our clients’ expectations and often exceeding them.\r\n\r\nOur diverse range of legal, finance and other expertise pave a way for formidable partnerships we forge with our clients across the whole spectrum of their legal needs and requirements.\r\n\r\nWe benchmark ourselves against the very results that our clients expect from us\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Magma Incorporated Attorneys</h1>\r\n<div></div>\r\n<div>Magma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma.</div>\r\n<div></div>\r\n<div>When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment. Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way.</div>\r\n<div></div>\r\n<div>Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/education.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/finbond.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/fxi.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/logo.png\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "inherit", "open", "open", "", "39-revision-v1", "", "", "2015-08-11 15:50:16", "2015-08-11 13:50:16", "", "39", "http://magmainc.co.za/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("48", "1", "2015-08-11 16:04:02", "2015-08-11 14:04:02", "", "Clients", "", "inherit", "open", "open", "", "clients", "", "", "2015-08-11 16:04:02", "2015-08-11 14:04:02", "", "39", "http://magmainc.co.za/wp-content/uploads/2015/08/Clients.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `eadsk_posts` VALUES("49", "1", "2015-08-11 16:04:10", "2015-08-11 14:04:10", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nMagma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub.\r\n\r\nThe firm is a 100% Black owned and run with a certified BBB-EE level 3 status. Although Magma Inc. Attorneys has recently been incorporated, it traces its roots and 15 years’ history back to June 2000 when it was formed, then as Magale Masemola Attorneys.\r\n\r\nThe firm has a rich and solid history of providing its diverse portfolio of clients with value for money\r\ndiversified legal services and we do so in a manner that meets our clients’ expectations and often exceeding them.\r\n\r\nOur diverse range of legal, finance and other expertise pave a way for formidable partnerships we forge with our clients across the whole spectrum of their legal needs and requirements.\r\n\r\nWe benchmark ourselves against the very results that our clients expect from us\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Magma Incorporated Attorneys</h1>\r\n<div></div>\r\n<div>Magma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma.</div>\r\n<div></div>\r\n<div>When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment. Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way.</div>\r\n<div></div>\r\n<div>Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/Clients.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "", "", "inherit", "open", "open", "", "39-revision-v1", "", "", "2015-08-11 16:04:10", "2015-08-11 14:04:10", "", "39", "http://magmainc.co.za/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("50", "1", "2015-08-11 16:06:03", "2015-08-11 14:06:03", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nMagma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub.\r\n\r\nThe firm is a 100% Black owned and run with a certified BBB-EE level 3 status. Although Magma Inc. Attorneys has recently been incorporated, it traces its roots and 15 years’ history back to June 2000 when it was formed, then as Magale Masemola Attorneys.\r\n\r\nThe firm has a rich and solid history of providing its diverse portfolio of clients with value for money\r\ndiversified legal services and we do so in a manner that meets our clients’ expectations and often exceeding them.\r\n\r\nOur diverse range of legal, finance and other expertise pave a way for formidable partnerships we forge with our clients across the whole spectrum of their legal needs and requirements.\r\n\r\nWe benchmark ourselves against the very results that our clients expect from us\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Magma Incorporated Attorneys</h1>\r\n<div></div>\r\n<div>Magma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma.</div>\r\n<div></div>\r\n<div>When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment. Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way.</div>\r\n<div></div>\r\n<div>Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/Clients.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "HOME", "", "inherit", "open", "open", "", "39-revision-v1", "", "", "2015-08-11 16:06:03", "2015-08-11 14:06:03", "", "39", "http://magmainc.co.za/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("51", "1", "2015-08-11 16:06:24", "2015-08-11 14:06:24", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Contact Magma Inc</h1>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Physical Address\r\n</strong><span style=\"line-height: 1.5;\">Block A, Wedgefield Office Park\r\n</span><span style=\"line-height: 1.5;\">17 Muswell Road South,\r\nBryanston, Sandton\r\n</span><span style=\"line-height: 1.5;\">2021</span>\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][et_pb_social_media_follow admin_label=\"Social Media Follow\" link_shape=\"rounded_rectangle\" background_layout=\"light\" url_new_window=\"off\" follow_button=\"on\"] [et_pb_social_media_follow_network social_network=\"facebook\" url=\"https://www.facebook.com/MagmaIncorporated?fref=ts\" bg_color=\"#3b5998\"] facebook [/et_pb_social_media_follow_network][et_pb_social_media_follow_network social_network=\"twitter\" url=\"https://twitter.com/MagmaInc\" bg_color=\"#00aced\"] Twitter [/et_pb_social_media_follow_network] [/et_pb_social_media_follow][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" transparent_background=\"off\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"on\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" auto_ignore_hover=\"off\" parallax=\"off\" parallax_method=\"off\" remove_inner_shadow=\"off\" background_position=\"default\" background_size=\"default\" hide_content_on_mobile=\"off\" hide_cta_on_mobile=\"off\" show_image_video_mobile=\"off\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [et_pb_slide background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/ASDASDASD1.jpg\"] [/et_pb_slide] [/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#f2edde\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"2_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "publish", "open", "open", "", "contact-us", "", "", "2015-08-21 13:24:03", "2015-08-21 11:24:03", "", "0", "http://magmainc.co.za/?page_id=51", "0", "page", "", "0");
INSERT INTO `eadsk_posts` VALUES("52", "1", "2015-08-11 16:06:24", "2015-08-11 14:06:24", "[et_pb_section][et_pb_row][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 16:06:24", "2015-08-11 14:06:24", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("53", "1", "2015-08-11 16:06:55", "2015-08-11 14:06:55", " ", "", "", "publish", "open", "open", "", "53", "", "", "2015-08-25 16:09:33", "2015-08-25 14:09:33", "", "0", "http://magmainc.co.za/?p=53", "9", "nav_menu_item", "", "0");
INSERT INTO `eadsk_posts` VALUES("54", "1", "2015-08-11 16:06:55", "2015-08-11 14:06:55", " ", "", "", "publish", "open", "open", "", "54", "", "", "2015-08-25 16:09:32", "2015-08-25 14:09:32", "", "0", "http://magmainc.co.za/?p=54", "1", "nav_menu_item", "", "0");
INSERT INTO `eadsk_posts` VALUES("55", "1", "2015-08-11 16:10:03", "2015-08-11 14:10:03", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my blog. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://magmainc.co.za/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "Sample Page", "", "inherit", "open", "open", "", "2-revision-v1", "", "", "2015-08-11 16:10:03", "2015-08-11 14:10:03", "", "2", "http://magmainc.co.za/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("56", "1", "2015-08-11 16:11:01", "2015-08-11 14:11:01", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nMagma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub.\r\n\r\nThe firm is a 100% Black owned and run with a certified BBB-EE level 3 status. Although Magma Inc. Attorneys has recently been incorporated, it traces its roots and 15 years’ history back to June 2000 when it was formed, then as Magale Masemola Attorneys.\r\n\r\nThe firm has a rich and solid history of providing its diverse portfolio of clients with value for money\r\ndiversified legal services and we do so in a manner that meets our clients’ expectations and often exceeding them.\r\n\r\nOur diverse range of legal, finance and other expertise pave a way for formidable partnerships we forge with our clients across the whole spectrum of their legal needs and requirements.\r\n\r\nWe benchmark ourselves against the very results that our clients expect from us\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Magma Incorporated Attorneys</h1>\r\n<div></div>\r\n<div>Magma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma.</div>\r\n<div></div>\r\n<div>When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment. Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way.</div>\r\n<div></div>\r\n<div>Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Some of our distinguished clients</h3>\r\n[/et_pb_text][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/Clients.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section]", "HOME", "", "inherit", "open", "open", "", "39-revision-v1", "", "", "2015-08-11 16:11:01", "2015-08-11 14:11:01", "", "39", "http://magmainc.co.za/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("57", "1", "2015-08-11 16:11:26", "2015-08-11 14:11:26", "", "large", "", "inherit", "open", "open", "", "large", "", "", "2015-08-11 16:11:26", "2015-08-11 14:11:26", "", "0", "http://magmainc.co.za/wp-content/uploads/2015/08/large.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `eadsk_posts` VALUES("58", "1", "2015-08-11 16:15:44", "2015-08-11 14:15:44", "[et_pb_section][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Magale Masemola\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1><a href=\"http://magmainc.co.za/wp-content/uploads/2015/08/magale-Copy1.jpg\"><img class=\"alignright wp-image-136 size-full\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/magale-Copy1.jpg\" alt=\"Magale Masemola\" width=\"176\" height=\"176\" /></a>Magale Masemola</h1>\r\n<ul>\r\n	<li>B.Proc Degree</li>\r\n	<li>LLB Degree</li>\r\n	<li>Certificate in Advanced Military Law</li>\r\n</ul>\r\nMagale obtained his B.Proc degree in 1997 from University of Natal (Durban), now known as University of Kwa-Zulu Natal. He further holds an LLB Degree from the same university in 1998 which was funded by Deneys Reitz attorneys, now known as or merged with Norton Rose Fulbright.\r\n\r\nHe attended school for legal practice in 1998, night school offered by the law society of South Africa, which reduced his period of articles from two years to one. He was admitted as an attorney in May of the year 2000 and obtained his certificate of right of appearance in the High courts in July 2000.\r\n\r\nHe has a certificate in advanced military law from Tshwane Military College, which he received at Thaba Tshwane in the year 2002 and thereafter served as a Defense counsel for the South African National Defence Force, while still maintaining his private practice.\r\n\r\nMagale Masemola has acted for and on behalf of various high profile clients both in the private and public sectors, among them are:\r\n<ul>\r\n	<li>The North West Provincial Government\r\nIn respect of a workshop on sixteen days of activism against women and child abuse, which he co-hosted with Professor L.P Direko, a Professor at North West University, Mafikeng campus,</li>\r\n	<li>Centre for Higher Education Transformation and National Department of Education on the possible launch of student Federation,</li>\r\n	<li>Freedom of Expression Institute (FXI), a legal opinion and advice on a matter against Iscor, now Arcelor Mittal) regarding water and air pollution in van der Bijlpark,</li>\r\n	<li>South African Transport &amp; Allied Workers Union (SATAWU) Limpopo, legal advice,</li>\r\n	<li>Drivers Operators &amp; Allied Workers Union for the review and Redrafting of the union’s constitution,</li>\r\n	<li>The Global Brands, restructuring and Financing and contracts review</li>\r\n	<li><span style=\"line-height: 1.5;\">National Heritage Council, the review and redrafting of their inter-Governmental agreement between National Heritage Council and the National Department of Arts &amp; Culture,</span></li>\r\n	<li><span style=\"line-height: 1.5;\">Tshwane University of Technology, a legal advice to Council of the Tshwane University of Technology,</span></li>\r\n	<li><span style=\"line-height: 1.5;\">Chair of the commission of enquiry into the doctoral qualification of Professor Johnny Molefe, </span><span style=\"line-height: 1.5;\">then acting Vice chancellor and Principal of the University,</span></li>\r\n</ul>\r\nThere are a plethora of other matters that Mr Masemola has handled over and above the ones listed above.\r\nMagale Masemola has just been appointed by SAFA’s 24th Annual Congress to serve on the National Disciplinary Committee.\r\n\r\n<strong>Masemola also serves on the following professional bodies</strong>\r\n<div>\r\n<div class=\"gmail_extra\">\r\n<div class=\"gmail_quote\">\r\n<div dir=\"auto\">\r\n<ul>\r\n	<li>Commercial panel of the arbitration foundation of Southern Africa (AFSA)</li>\r\n	<li>National disciplinary committee of South African Football association (SAFA)</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n[/et_pb_text][et_pb_social_media_follow admin_label=\"Social Media Follow\" link_shape=\"rounded_rectangle\" background_layout=\"light\" url_new_window=\"off\" follow_button=\"off\"] [et_pb_social_media_follow_network social_network=\"linkedin\" url=\"http://www.linkedin.com/profile/view?id=268391058&amp;authType=NAME_SEARCH&amp;authToken=3Aq7&amp;locale=en_US&amp;srchid=359911101440009182956&amp;srchindex=3&amp;srchtotal=3&amp;trk=vsrp_people_res_name&amp;trkInfo=VSRPsearchId%3A359911101440009182956%2CVSRPtargetId%3A268391058%2CVSRPcmpt%3Aprimary%2CVSRPnm%3Atrue%2CauthType%3ANAME_SEARCH\" bg_color=\"#007bb6\"] LinkedIn [/et_pb_social_media_follow_network] [/et_pb_social_media_follow][et_pb_divider admin_label=\"Divider\" color=\"#dd0000\" show_divider=\"off\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\" height=\"10\"]\r\n[/et_pb_divider][et_pb_divider admin_label=\"Divider\" color=\"#dd0000\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\" height=\"10\"]\r\n[/et_pb_divider][et_pb_text admin_label=\"Dr. Nokuhle Madolo\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1></h1>\r\n<h1><a href=\"http://magmainc.co.za/wp-content/uploads/2015/08/Picture-Copy.jpg\"><img class=\"alignright wp-image-141 size-full\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/Picture-Copy.jpg\" alt=\"Dr. Nokuhle Madolo\" width=\"174\" height=\"174\" /></a>Dr. Nokuhle Madolo</h1>\r\n<strong>Head of Department of Mining and Corporate Law.</strong>\r\n<ul>\r\n	<li>PhD in Minerals Investment &amp; Policy from University of the Witwatersrand</li>\r\n	<li>Masters of Law in resources Law and Policy from University of Dundee,</li>\r\n	<li>B. A. Law from University of Swaziland.</li>\r\n</ul>\r\nDr. Madolo has been a senior Lecturer at the University of the Witwatersrand School of Law from 2009 to 2013. She has worked for several multinational mining companies and has been involved in the drafting of various charters and policies in the mining sector, she was also involved with the following projects, Drafting of the Namibian Mineral Policy, identifying suitable BEE partners for major mining companies.\r\n\r\nDr. Madolo was a legal adviser to the Minister of Natural Resources &amp; Energy, Swaziland and is indeed an authority of the issues of mining and minerals.\r\n\r\nShe has other countless achievements under her belt and extensive knowledge and expertise in the following areas, some of which she has lectured on, namely:\r\n<ul>\r\n	<li>Commercial and Mercantile Law</li>\r\n	<li>Drafting of Minerals and Petroleum Agreements</li>\r\n	<li>Commercial Agreements</li>\r\n	<li>Negotiating Mining Exploration Quarry Leases</li>\r\n	<li>Special Exclusive Licenses and Agreements</li>\r\n	<li>Drafting of FIDIC, Agreements that govern Engineering contracts</li>\r\n	<li>Shareholders Agreements,</li>\r\n	<li>Joint Venture,</li>\r\n	<li>Comprehensive knowledge on the field of International Economic Law.</li>\r\n</ul>\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Tumishang Oupa Phasha\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Tumishang Oupa Phasha</h1>\r\n<strong>Head of Labour Law, disciplinary hearings, Contracts and general litigation</strong>\r\n<ul>\r\n	<li>LLB Degree from University of Limpopo</li>\r\n	<li>Masters of Law in Labour Law from University of Limpopo</li>\r\n</ul>\r\nTumishang or \"Oupa\", as he is popularly known was admitted as an attorney in 2011 and has a right of Appearance in the High Courts of South Africa. His area of practice in the field of Labour law, which includes disciplinary hearings, legal opinions to various organisations on issues relating to labour Matters, review of contracts as well as general litigation.\r\n\r\n[/et_pb_text][et_pb_divider admin_label=\"Divider\" color=\"#dd0000\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"]\r\n[/et_pb_divider][et_pb_divider admin_label=\"Divider\" color=\"#dd0000\" show_divider=\"off\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\" height=\"10\"]\r\n[/et_pb_divider][et_pb_text admin_label=\"Thomas Sibiya\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1><a href=\"http://magmainc.co.za/wp-content/uploads/2015/08/tom.jpg\"><img class=\"alignright wp-image-143 size-full\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/tom.jpg\" alt=\"Thomas Sibiya\" width=\"176\" height=\"176\" /></a>Thomas Sibiya</h1>\r\n<strong>Head of Tax, Corporate Finance, and Mergers &amp; Acquisition</strong>\r\n<ul>\r\n	<li>National Diploma in Accounting</li>\r\n	<li>post-graduation Diploma in Taxation</li>\r\n	<li>Degree in Taxation</li>\r\n</ul>\r\nThomas served his articles at Deloitte and Touché, after which he worked as a corporate tax manager for the same firm. In addition, he served as a corporate tax manager for KPMG.\r\n\r\n<strong>He specialises in the following:</strong>\r\n<ul>\r\n	<li>Financial Management Systems,</li>\r\n	<li>Business Process Re-engineering,</li>\r\n	<li>Auditing and Corporate Tax,</li>\r\n	<li>VAT Reviews,</li>\r\n	<li>Income Tax.</li>\r\n</ul>\r\nMr Sibiya undertook various high profile advisory tasks, among them providing consulting services for various government departments such as the Gauteng Department of Education in the Free State. In the Department of Education, he was involved with forensic audit of public and special schools, and for the Department of Sports and Department of Arts and Culture in the North West province as well. He undertook same tasks for various municipalities, assisting them with the debt reviews.\r\n\r\nThomas, or Tom as he is often called,  is an associate of the Institute of Chartered Accountants of Southern. Africa under South African institute of Chartered Accountants (SAICA). He has also worked for South African Revenue services (SARS), De Beers Consolidated Mines, ABSA Bank and Ford Motor Corporation.\r\n\r\n[/et_pb_text][et_pb_divider admin_label=\"Divider\" color=\"#dd0000\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"]\r\n[/et_pb_divider][et_pb_divider admin_label=\"Divider\" color=\"#dd0000\" show_divider=\"off\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\" height=\"10\"]\r\n[/et_pb_divider][et_pb_text admin_label=\"Tumi Matlakala\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Tumi Matlakala</h2>\r\n<ul>\r\n	<li>LLB Degree</li>\r\n</ul>\r\nMr. Matlakala obtained his LLB degree in 2009 from University of Limpopo. He previously worked for a well-known law firm where he obtained various practical skills, experience and expertise on various aspects of law. He also acted for and on behalf of the Road Accident Fund as its attorney of record on R.A.F’s panels of attorneys. Through this process he developed a vast knowledge on medical law.\r\n\r\nHis other interests are:\r\n<ul>\r\n	<li>Civil Litigation.</li>\r\n	<li>Family Law\r\n- Divorce, Maintenance, Custody, Protection orders.</li>\r\n	<li>Administration of deceased’s estates.</li>\r\n	<li>Contracts.</li>\r\n</ul>\r\nTumi also has a right of appearance in the High Courts of South Africa.\r\n\r\n[/et_pb_text][et_pb_divider admin_label=\"Divider\" color=\"#dd0000\" show_divider=\"off\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\" height=\"10\"]\r\n[/et_pb_divider][et_pb_divider admin_label=\"Divider\" color=\"#dd0000\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\" height=\"10\"]\r\n[/et_pb_divider][et_pb_text admin_label=\"Patrick Motsepe\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Patrick Motsepe<a href=\"http://magmainc.co.za/wp-content/uploads/2015/08/pat-Copy1.jpg\"><img class=\"alignright wp-image-139 size-full\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/pat-Copy1.jpg\" alt=\"Patrick Motsepe\" width=\"176\" height=\"176\" /></a></h2>\r\n<ul>\r\n	<li>LLB from UNISA,</li>\r\n	<li>B. Iuris from University of North West</li>\r\n	<li>Diploma in Business Management from IMM</li>\r\n	<li>National Certificate in Arbitration and Sport from National Association of Arbitrators</li>\r\n	<li>\r\n<div data-canvas-width=\"355.524\">Diploma in Insolvency Law &amp; Practice from UPE</div></li>\r\n	<li>Diploma in Auctioning</li>\r\n</ul>\r\n<div data-canvas-width=\"92.22\">Patrick Motsepe has over 16 years’ experience working on various Capacities in the legal field and for various law firms in Gauteng.</div>\r\n<div data-canvas-width=\"357.56850000000003\"></div>\r\n<div data-canvas-width=\"357.56850000000003\">Patrick\'s practical experience includes, having worked and researched for well-known Senior legal persons such as the late David Soggott SC who defended among others the late Steve Biko and Rivonia trialists.</div>\r\n<div data-canvas-width=\"357.56850000000003\"></div>\r\n<div data-canvas-width=\"357.56850000000003\">Patrick Motsepe worked closely in high court matters including research and heads of arguments with Advocate Phillip Coppin, now a High Court Judge in the South Gauteng High Court. He also dealt with SABC and was hosted by various talk show hosts of the SABC radio stations.</div>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Some of our distinguished clients</h3>\r\n[/et_pb_text][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/Clients.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\" background_color=\"#f2edde\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" url_new_window=\"off\" button_text=\"CONTACT US TO MAKE AN APPOINTMENT\" use_background_color=\"off\" background_color=\"#ad002e\" background_layout=\"light\" text_orientation=\"center\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\" button_url=\"http://magmainc.co.za/contact-us/\"] [/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "ABOUT US", "", "publish", "open", "open", "", "about-us", "", "", "2015-08-19 20:34:23", "2015-08-19 18:34:23", "", "0", "http://magmainc.co.za/?page_id=58", "0", "page", "", "0");
INSERT INTO `eadsk_posts` VALUES("59", "1", "2015-08-11 16:15:44", "2015-08-11 14:15:44", "[et_pb_section][et_pb_row][/et_pb_row][/et_pb_section]", "ABOUT US", "", "inherit", "open", "open", "", "58-revision-v1", "", "", "2015-08-11 16:15:44", "2015-08-11 14:15:44", "", "58", "http://magmainc.co.za/58-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("60", "1", "2015-08-11 16:16:17", "2015-08-11 14:16:17", "[et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_image admin_label=\"Fullwidth Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/back2-1200x300.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_fullwidth_image][/et_pb_section][et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Our areas of legal Practice</h1>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<ul>\r\n	<li>Arbitrations and disciplinary hearings</li>\r\n	<li>Aviation law</li>\r\n	<li>Business rescue proceedings</li>\r\n	<li>Civil litigation</li>\r\n	<li>Commercial transactions</li>\r\n	<li>Commissions of Enquiries</li>\r\n	<li>Contracts drafting and reviewing</li>\r\n	<li>Debt collection</li>\r\n</ul>\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<ul>\r\n	<li>Disciplinary hearings</li>\r\n	<li>Due diligences</li>\r\n	<li>Family law</li>\r\n	<li>General commercial litigation</li>\r\n	<li>Insolvency and liquidations</li>\r\n	<li>Labour law</li>\r\n	<li>Legal opinions</li>\r\n	<li>Local Government law</li>\r\n</ul>\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<ul>\r\n	<li>Media law</li>\r\n	<li>Mergers &amp; acquisitions</li>\r\n	<li>Mining law</li>\r\n	<li>Municipal by laws</li>\r\n	<li>Policy and legislation</li>\r\n	<li>Public service law</li>\r\n	<li>Tax and finance law</li>\r\n	<li>Workshops for companies of various laws</li>\r\n</ul>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#ede9d5\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_cta admin_label=\"Call To Action\" url_new_window=\"off\" button_text=\"READ MORE ABOUT OUR LEGAL TEAM\" use_background_color=\"off\" background_color=\"#ad002e\" background_layout=\"light\" text_orientation=\"center\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\" button_url=\"http://magmainc.co.za/about-us/\"] [/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "PRACTICE AREA", "", "publish", "open", "open", "", "practice-area", "", "", "2015-08-25 15:42:28", "2015-08-25 13:42:28", "", "0", "http://magmainc.co.za/?page_id=60", "0", "page", "", "0");
INSERT INTO `eadsk_posts` VALUES("61", "1", "2015-08-11 16:16:17", "2015-08-11 14:16:17", "[et_pb_section][et_pb_row][/et_pb_row][/et_pb_section]", "PRACTICE AREA", "", "inherit", "open", "open", "", "60-revision-v1", "", "", "2015-08-11 16:16:17", "2015-08-11 14:16:17", "", "60", "http://magmainc.co.za/60-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("62", "1", "2015-08-11 16:16:41", "2015-08-11 14:16:41", "[et_pb_section][et_pb_row][/et_pb_row][/et_pb_section]", "OFFICES", "", "trash", "open", "open", "", "offices", "", "", "2015-08-14 14:56:38", "2015-08-14 12:56:38", "", "0", "http://magmainc.co.za/?page_id=62", "0", "page", "", "0");
INSERT INTO `eadsk_posts` VALUES("63", "1", "2015-08-11 16:16:41", "2015-08-11 14:16:41", "[et_pb_section][et_pb_row][/et_pb_row][/et_pb_section]", "OFFICES", "", "inherit", "open", "open", "", "62-revision-v1", "", "", "2015-08-11 16:16:41", "2015-08-11 14:16:41", "", "62", "http://magmainc.co.za/62-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("64", "1", "2015-08-11 16:17:12", "2015-08-11 14:17:12", "[et_pb_section][et_pb_row][et_pb_column type=\"2_3\"][et_pb_blog admin_label=\"Blog\" fullwidth=\"on\" show_thumbnail=\"on\" show_content=\"off\" show_more=\"off\" show_author=\"on\" show_date=\"on\" show_categories=\"on\" show_pagination=\"on\" offset_number=\"0\" background_layout=\"light\" use_dropshadow=\"off\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_blog][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_sidebar admin_label=\"Sidebar\" orientation=\"right\" area=\"sidebar-1\" background_layout=\"light\" remove_border=\"off\"] [/et_pb_sidebar][/et_pb_column][/et_pb_row][/et_pb_section]", "NEWS AND EVENTS", "", "publish", "open", "open", "", "news-and-events", "", "", "2015-08-21 12:30:56", "2015-08-21 10:30:56", "", "0", "http://magmainc.co.za/?page_id=64", "0", "page", "", "0");
INSERT INTO `eadsk_posts` VALUES("65", "1", "2015-08-11 16:17:12", "2015-08-11 14:17:12", "[et_pb_section][et_pb_row][/et_pb_row][/et_pb_section]", "NEWS AND EVENTS", "", "inherit", "open", "open", "", "64-revision-v1", "", "", "2015-08-11 16:17:12", "2015-08-11 14:17:12", "", "64", "http://magmainc.co.za/64-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("68", "1", "2015-08-11 16:17:51", "2015-08-11 14:17:51", "", "AREAS OF PRACTICE", "", "publish", "open", "open", "", "68", "", "", "2015-08-25 16:09:32", "2015-08-25 14:09:32", "", "0", "http://magmainc.co.za/?p=68", "6", "nav_menu_item", "", "0");
INSERT INTO `eadsk_posts` VALUES("69", "1", "2015-08-11 16:17:51", "2015-08-11 14:17:51", "", "OUR LEGAL TEAM", "", "publish", "open", "open", "", "69", "", "", "2015-08-25 16:09:32", "2015-08-25 14:09:32", "", "0", "http://magmainc.co.za/?p=69", "3", "nav_menu_item", "", "0");
INSERT INTO `eadsk_posts` VALUES("70", "1", "2015-08-11 17:16:41", "2015-08-11 15:16:41", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nMagma Incorporated Attorneys is a prestigious, talented and versatile law firm situated at the heart of Sandton, Africa’s economic hub.\r\n\r\nThe firm is a 100% Black owned and run with a certified BBB-EE level 3 status. Although Magma Inc. Attorneys has recently been incorporated, it traces its roots and 15 years’ history back to June 2000 when it was formed, then as Magale Masemola Attorneys.\r\n\r\nThe firm has a rich and solid history of providing its diverse portfolio of clients with value for money\r\ndiversified legal services and we do so in a manner that meets our clients’ expectations and often exceeding them.\r\n\r\nOur diverse range of legal, finance and other expertise pave a way for formidable partnerships we forge with our clients across the whole spectrum of their legal needs and requirements.\r\n\r\nWe benchmark ourselves against the very results that our clients expect from us\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h1>Magma Incorporated Attorneys</h1>\r\n<div></div>\r\n<div>Magma is a high and complex volatile temperature beneath the surface of the earth’s crust, which erupts onto the earth’s surface, forming a volcano. Magma Incorporated Attorneys on the other hand is a combination of the first three letters and the first two letters of the firm’s founder and Chairman Magale Masemola’s name and surname respectively to form the name Magma.</div>\r\n<div></div>\r\n<div>When volcanoes erupt, they create a chaotic environment on the surface of the earth, destroying everything in their paths and dominate the environment. Magma Incorporated Attorneys too, erupts into action and legally destroy everything and anything that stands in our clients’ way.</div>\r\n<div></div>\r\n<div>Consequently our name says it all. That is what we stand for, a carefully orchestrated legal path that ensures our clients fully optimize value out of a superior service we offer. We develop a reputation of being one of Gauteng’s trusted and reliable law firms with a goal of expanding our operations outside of South Africa.</div>\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Why use us</h2>\r\nWe are…\r\n<ul>\r\n	<li>Competitive in terms of fees.</li>\r\n	<li>Our firm is well resourced in terms of staff compliment as well as books and law reports and statutes that ensure we are able to render a good quality service within a short space of time without compromising quality,</li>\r\n	<li>Our ability to research on the subject matter forms the basis for our success as we know exactly where to find information within a short space of time and thus narrowing the time spend on collecting information and this consequently once again save our clients fees, we look forward to being of service to you.</li>\r\n</ul>\r\nWe look forward to being of service to you.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Some of our distinguished clients</h3>\r\n[/et_pb_text][et_pb_image admin_label=\"Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/Clients.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" sticky=\"off\" align=\"left\" force_fullwidth=\"off\" always_center_on_mobile=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section]", "HOME", "", "inherit", "open", "open", "", "39-revision-v1", "", "", "2015-08-11 17:16:41", "2015-08-11 15:16:41", "", "39", "http://magmainc.co.za/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("71", "1", "2015-08-11 17:17:50", "2015-08-11 15:17:50", "[et_pb_section][et_pb_row][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\nPhysical Address\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\nPostal Address\r\nP.O.Box 785 871,\r\nSandton City,\r\n2146\r\nDocex 85,\r\nSandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:17:50", "2015-08-11 15:17:50", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("72", "1", "2015-08-11 17:18:51", "2015-08-11 15:18:51", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\nPhysical Address\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\nPostal Address\r\nP.O.Box 785 871,\r\nSandton City,\r\n2146\r\nDocex 85,\r\nSandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" url_new_window=\"off\" use_background_color=\"on\" background_color=\"#ad002e\" background_layout=\"dark\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:18:51", "2015-08-11 15:18:51", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("73", "1", "2015-08-11 17:19:52", "2015-08-11 15:19:52", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:19:52", "2015-08-11 15:19:52", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("74", "1", "2015-08-11 17:20:12", "2015-08-11 15:20:12", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:20:12", "2015-08-11 15:20:12", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("75", "1", "2015-08-11 17:26:53", "2015-08-11 15:26:53", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" url_new_window=\"off\" use_background_color=\"on\" background_color=\"#ad002e\" background_layout=\"dark\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:26:53", "2015-08-11 15:26:53", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("76", "1", "2015-08-11 17:27:46", "2015-08-11 15:27:46", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_cta admin_label=\"Call To Action\" url_new_window=\"off\" use_background_color=\"off\" background_color=\"#ad002e\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_cta][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:27:46", "2015-08-11 15:27:46", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("77", "1", "2015-08-11 17:28:45", "2015-08-11 15:28:45", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\" /][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:28:45", "2015-08-11 15:28:45", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("78", "1", "2015-08-14 09:44:12", "2015-08-14 07:44:12", "[et_pb_section][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"] [/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n<h2>Contact information</h2>\n<strong>Physical Address</strong>\nBlock A, Wedgefield Office Park\n17 Muswell Road South, Bryanston, Sandton\n2021\n\n<strong>Postal Address</strong>\nP.O.Box 785 871,\nSandton City, 2146\nDocex 85, Sandton Square\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"3\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>Phone:</strong> +27(0)11 317 3680\n<strong>Fax:</strong> +27(0)11 317 3601\n<strong>Direct Fax:</strong> +27(0)86 695 4251\n<strong>Email:</strong> magma@magmainc.co.za\n\n&nbsp;\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\" transparent_background=\"off\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"on\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\" background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/back2-1200x300.jpg\"][et_pb_fullwidth_slider admin_label=\"Fullwidth Slider\" show_arrows=\"on\" show_pagination=\"on\" auto=\"off\" auto_ignore_hover=\"off\" parallax=\"off\" parallax_method=\"off\" remove_inner_shadow=\"off\" background_position=\"default\" background_size=\"default\" hide_content_on_mobile=\"off\" hide_cta_on_mobile=\"off\" show_image_video_mobile=\"off\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [et_pb_slide background_position=\"default\" background_size=\"default\" background_color=\"#ffffff\" alignment=\"center\" background_layout=\"dark\" allow_player_pause=\"off\" header_font_select=\"default\" body_font_select=\"default\" custom_button=\"off\" button_font_select=\"default\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" background_image=\"http://magmainc.co.za/wp-content/uploads/2015/08/ASDASDASD1.jpg\"] [/et_pb_slide] [/et_pb_fullwidth_slider][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"2_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n<h3>Our Offices</h3>\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\n\nThe following are our service addresses, our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\n\n&nbsp;\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>Johannesburg:</strong>\nBlock A, Wedgefield Office Park\n17 Muswell Road South, Bryanston, Sandton\n2021\n\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>East London:</strong>\nOffice 1, Malconess Park\nCnr Gately Street &amp;\nSt Georges Road,\nEast London, 5201\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>Pretoria:</strong>\nCnr 271 Vermeaulen Street &amp;\nChurch Square,\nDx 459\n\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>Port Elizabeth:</strong>\nNo 9 Nile Road,\nPerridgevale,\nPE 6001\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>Cape Town:</strong>\n4th Floor, Constitution House\n124 Adderley Street,\nCape Town, 8000\n\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>Pietermaritzburg:</strong>\n11 Assurance Street,\nPietermaritzburg,\n3201\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>Durban:</strong>\nShop 1 Salmon Grove Chambers\n407 Anton Lembede Street,\nDurban 4000\n\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\n\n<strong>Bloemfontein:</strong>\nDx 600\nPost Office Building,\nBloemfontein, 9301\n\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-autosave-v1", "", "", "2015-08-14 09:44:12", "2015-08-14 07:44:12", "", "51", "http://magmainc.co.za/51-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("79", "1", "2015-08-11 17:32:57", "2015-08-11 15:32:57", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][/et_pb_column][et_pb_column type=\"1_4\"][/et_pb_column][et_pb_column type=\"1_4\"][/et_pb_column][et_pb_column type=\"1_4\"][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:32:57", "2015-08-11 15:32:57", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("80", "1", "2015-08-11 17:36:13", "2015-08-11 15:36:13", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:36:13", "2015-08-11 15:36:13", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("81", "1", "2015-08-11 17:37:46", "2015-08-11 15:37:46", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:37:46", "2015-08-11 15:37:46", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("82", "1", "2015-08-11 17:38:24", "2015-08-11 15:38:24", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:38:24", "2015-08-11 15:38:24", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("83", "1", "2015-08-11 17:38:38", "2015-08-11 15:38:38", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nOUR OFFICES\r\n\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:38:38", "2015-08-11 15:38:38", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("84", "1", "2015-08-11 17:42:56", "2015-08-11 15:42:56", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:42:56", "2015-08-11 15:42:56", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("85", "1", "2015-08-11 17:44:01", "2015-08-11 15:44:01", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:44:01", "2015-08-11 15:44:01", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("86", "1", "2015-08-11 17:44:41", "2015-08-11 15:44:41", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:44:41", "2015-08-11 15:44:41", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("87", "1", "2015-08-11 17:45:59", "2015-08-11 15:45:59", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\nCONTACT INFO\r\n\r\nPhone: +27(0)11 317 3680\r\nFax: +27(0)11 317 3601\r\nDirect Fax: +27(0)86 695 4251\r\nEmail: magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:45:59", "2015-08-11 15:45:59", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("88", "1", "2015-08-11 17:51:48", "2015-08-11 15:51:48", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"25\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\" /][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:51:48", "2015-08-11 15:51:48", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("89", "1", "2015-08-11 17:52:08", "2015-08-11 15:52:08", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"15\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:52:08", "2015-08-11 15:52:08", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("90", "1", "2015-08-11 17:52:30", "2015-08-11 15:52:30", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"5\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:52:30", "2015-08-11 15:52:30", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("91", "1", "2015-08-11 17:53:09", "2015-08-11 15:53:09", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"4\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:53:09", "2015-08-11 15:53:09", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("92", "1", "2015-08-11 17:53:38", "2015-08-11 15:53:38", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"3\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, where our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:53:38", "2015-08-11 15:53:38", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("93", "1", "2015-08-11 17:54:50", "2015-08-11 15:54:50", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"3\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, whereour clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:54:50", "2015-08-11 15:54:50", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("94", "1", "2015-08-11 17:56:40", "2015-08-11 15:56:40", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"3\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:56:40", "2015-08-11 15:56:40", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("95", "1", "2015-08-11 17:59:28", "2015-08-11 15:59:28", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"3\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"2_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 17:59:28", "2015-08-11 15:59:28", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("96", "1", "2015-08-11 18:03:51", "2015-08-11 16:03:51", "", "back2-1200x300", "", "inherit", "open", "open", "", "back2-1200x300", "", "", "2015-08-11 18:03:51", "2015-08-11 16:03:51", "", "51", "http://magmainc.co.za/wp-content/uploads/2015/08/back2-1200x300.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `eadsk_posts` VALUES("97", "1", "2015-08-11 18:04:00", "2015-08-11 16:04:00", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact information</h2>\r\n<strong>Physical Address</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n<strong>Postal Address</strong>\r\nP.O.Box 785 871,\r\nSandton City, 2146\r\nDocex 85, Sandton Square\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_divider admin_label=\"Divider\" color=\"#ffffff\" show_divider=\"off\" height=\"3\" divider_style=\"solid\" divider_position=\"top\" hide_on_mobile=\"on\"] [/et_pb_divider][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Phone:</strong> +27(0)11 317 3680\r\n<strong>Fax:</strong> +27(0)11 317 3601\r\n<strong>Direct Fax:</strong> +27(0)86 695 4251\r\n<strong>Email:</strong> magma@magmainc.co.za\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_contact_form admin_label=\"Contact Form\" captcha=\"on\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" custom_button=\"off\" button_letter_spacing=\"0\" button_use_icon=\"default\" button_icon_placement=\"right\" button_on_hover=\"on\" button_letter_spacing_hover=\"0\"] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"on\" specialty=\"off\"][et_pb_fullwidth_image admin_label=\"Fullwidth Image\" src=\"http://magmainc.co.za/wp-content/uploads/2015/08/back2-1200x300.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" animation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\" /][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" transparent_background=\"off\" background_color=\"#eaeaea\" allow_player_pause=\"off\" inner_shadow=\"off\" parallax=\"off\" parallax_method=\"off\" padding_mobile=\"off\" make_fullwidth=\"off\" use_custom_width=\"off\" width_unit=\"on\" make_equal=\"off\" use_custom_gutter=\"off\"][et_pb_row][et_pb_column type=\"2_3\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h3>Our Offices</h3>\r\nWe have a numerous selected service offices in various provinces to ensure that we save our clients money of correspondence fees.\r\n\r\nThe following are our service addresses, our clients across the country can deliver documents, collect and sign documents to ensure overnight receipt of important documents to and from our clients.\r\n\r\n&nbsp;\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\"][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Johannesburg:</strong>\r\nBlock A, Wedgefield Office Park\r\n17 Muswell Road South, Bryanston, Sandton\r\n2021\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>East London:</strong>\r\nOffice 1, Malconess Park\r\nCnr Gately Street &amp;\r\nSt Georges Road,\r\nEast London, 5201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pretoria:</strong>\r\nCnr 271 Vermeaulen Street &amp;\r\nChurch Square,\r\nDx 459\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Port Elizabeth:</strong>\r\nNo 9 Nile Road,\r\nPerridgevale,\r\nPE 6001\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Cape Town:</strong>\r\n4th Floor, Constitution House\r\n124 Adderley Street,\r\nCape Town, 8000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Pietermaritzburg:</strong>\r\n11 Assurance Street,\r\nPietermaritzburg,\r\n3201\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Durban:</strong>\r\nShop 1 Salmon Grove Chambers\r\n407 Anton Lembede Street,\r\nDurban 4000\r\n\r\n[/et_pb_text][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n\r\n<strong>Bloemfontein:</strong>\r\nDx 600\r\nPost Office Building,\r\nBloemfontein, 9301\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "CONTACT US", "", "inherit", "open", "open", "", "51-revision-v1", "", "", "2015-08-11 18:04:00", "2015-08-11 16:04:00", "", "51", "http://magmainc.co.za/51-revision-v1/", "0", "revision", "", "0");
INSERT INTO `eadsk_posts` VALUES("98", "1", "2015-08-11 18:16:14", "2015-08-11 16:16:14", "[et_pb_section][et_pb_row][et_pb_column type=\"1_4\"][et_pb_text admin_label=\"Text\" background_layout=\"light\" text_orientation=\"left\" use_border_color=\"off\" border_color=\"#ffffff\" border_style=\"solid\"]\r\n<h2>Contact