/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2017-11-20 09:27:07 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `eadsk_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_ci,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_failed_logins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_attempt_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10066 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_login_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `logout_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `release_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4049 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

CREATE TABLE `eadsk_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=91761 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1855 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=581 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: eadsk_aiowps_failed_logins */
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5058", "1", "admin8576", "2015-11-08 00:54:29", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5059", "1", "admin8576", "2015-11-08 02:13:33", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5060", "1", "admin8576", "2015-11-08 03:32:37", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5061", "1", "admin8576", "2015-11-08 04:51:15", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5062", "0", "admin", "2015-11-08 05:55:55", "77.109.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5063", "1", "admin8576", "2015-11-08 07:28:45", "96.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5064", "1", "admin8576", "2015-11-08 08:47:11", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5065", "1", "admin8576", "2015-11-08 10:05:38", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5066", "1", "admin8576", "2015-11-08 11:24:19", "77.109.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5067", "1", "admin8576", "2015-11-08 12:43:03", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5068", "1", "admin8576", "2015-11-08 15:20:51", "188.235.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5069", "0", "admin", "2015-11-08 15:54:44", "31.14.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5070", "1", "admin8576", "2015-11-08 16:46:15", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5071", "1", "admin8576", "2015-11-08 18:12:48", "37.48.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5072", "1", "admin8576", "2015-11-08 19:43:17", "192.99.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5073", "1", "admin8576", "2015-11-08 22:37:02", "204.11.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5074", "1", "admin8576", "2015-11-09 00:04:16", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5075", "0", "admin", "2015-11-09 01:28:52", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5076", "1", "admin8576", "2015-11-09 01:32:52", "185.10.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5077", "1", "admin8576", "2015-11-09 03:00:29", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5078", "1", "admin8576", "2015-11-09 04:29:18", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5079", "1", "admin8576", "2015-11-09 05:56:47", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5080", "1", "admin8576", "2015-11-09 07:24:27", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5081", "1", "admin8576", "2015-11-09 08:51:33", "95.130.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5082", "0", "admin", "2015-11-09 10:15:06", "5.196.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5083", "1", "admin8576", "2015-11-09 10:19:11", "96.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5084", "1", "admin8576", "2015-11-09 11:45:38", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5085", "1", "admin8576", "2015-11-09 13:12:08", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5086", "1", "admin8576", "2015-11-09 14:39:01", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5087", "1", "admin8576", "2015-11-09 16:05:32", "178.20.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5088", "1", "admin8576", "2015-11-09 17:31:48", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5089", "1", "admin8576", "2015-11-09 18:58:10", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5090", "1", "admin8576", "2015-11-09 20:25:03", "85.24.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5091", "0", "admin", "2015-11-09 20:35:56", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5092", "1", "admin8576", "2015-11-09 21:51:23", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5093", "1", "admin8576", "2015-11-09 23:17:59", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5094", "1", "admin8576", "2015-11-10 00:43:54", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5095", "1", "admin8576", "2015-11-10 02:10:46", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5096", "1", "admin8576", "2015-11-10 03:38:40", "192.99.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5097", "1", "admin8576", "2015-11-10 05:06:42", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5098", "1", "admin8576", "2015-11-10 06:34:31", "94.26.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5099", "0", "admin", "2015-11-10 06:47:02", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5100", "1", "admin8576", "2015-11-10 08:01:15", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5101", "1", "admin8576", "2015-11-10 09:28:47", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5102", "1", "admin8576", "2015-11-10 10:56:26", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5103", "1", "admin8576", "2015-11-10 12:24:07", "178.20.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5104", "0", "magma", "2015-11-10 13:32:20", "223.197.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5105", "0", "magma", "2015-11-10 13:40:40", "151.224.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5106", "0", "magma", "2015-11-10 13:49:40", "172.194.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5107", "0", "magma", "2015-11-10 13:49:45", "103.41.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5108", "1", "admin8576", "2015-11-10 13:51:19", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5109", "0", "magma", "2015-11-10 14:22:55", "41.141.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5110", "0", "magma", "2015-11-10 14:30:25", "115.184.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5111", "0", "magma", "2015-11-10 14:43:52", "5.186.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5112", "0", "magma", "2015-11-10 15:02:54", "123.136.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5113", "0", "magma", "2015-11-10 15:03:08", "37.26.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5114", "1", "admin8576", "2015-11-10 15:18:14", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5115", "0", "magma", "2015-11-10 15:20:13", "37.78.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5116", "0", "magma", "2015-11-10 15:41:38", "62.121.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5117", "0", "magma", "2015-11-10 16:21:25", "5.41.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5118", "0", "magma", "2015-11-10 16:36:28", "49.144.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5119", "1", "admin8576", "2015-11-10 18:12:56", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5120", "1", "admin8576", "2015-11-10 19:40:19", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5121", "1", "admin8576", "2015-11-10 21:07:06", "46.105.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5122", "1", "admin8576", "2015-11-10 22:33:58", "176.10.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5123", "1", "admin8576", "2015-11-11 00:00:24", "93.184.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5124", "1", "admin8576", "2015-11-11 01:27:09", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5125", "1", "admin8576", "2015-11-11 02:53:38", "94.242.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5126", "0", "admin", "2015-11-11 03:42:41", "64.113.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5127", "1", "admin8576", "2015-11-11 04:20:44", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5128", "1", "admin8576", "2015-11-11 05:47:41", "85.245.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5129", "1", "admin8576", "2015-11-11 07:14:45", "198.96.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5130", "1", "admin8576", "2015-11-11 08:41:43", "178.17.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5131", "1", "admin8576", "2015-11-11 10:10:30", "77.109.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5132", "1", "admin8576", "2015-11-11 11:39:11", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5133", "1", "admin8576", "2015-11-11 13:05:38", "83.233.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5134", "0", "admin", "2015-11-11 13:32:03", "85.93.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5135", "1", "admin8576", "2015-11-11 14:32:58", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5136", "0", "magma", "2015-11-11 14:44:22", "199.192.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5137", "0", "magma", "2015-11-11 15:31:46", "39.32.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5138", "0", "magma", "2015-11-11 15:53:15", "196.1.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5139", "1", "admin8576", "2015-11-11 16:00:51", "176.31.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5140", "0", "magma", "2015-11-11 16:06:47", "188.120.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5141", "0", "magma", "2015-11-11 16:12:57", "115.188.111.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5142", "0", "magma", "2015-11-11 16:14:03", "41.250.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5143", "0", "magma", "2015-11-11 16:28:55", "188.219.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5144", "0", "magma", "2015-11-11 17:12:57", "61.92.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5145", "0", "magma", "2015-11-11 17:12:58", "176.221.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5146", "0", "magma", "2015-11-11 17:23:07", "182.178.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5147", "0", "magma", "2015-11-11 17:47:26", "95.86.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5148", "0", "magma", "2015-11-11 17:48:50", "112.207.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5149", "0", "magma", "2015-11-11 18:19:17", "109.225.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5150", "0", "magma", "2015-11-11 18:22:50", "5.246.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5151", "0", "magma", "2015-11-11 18:23:28", "179.180.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5152", "0", "magma", "2015-11-11 18:33:09", "5.102.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5153", "0", "magma", "2015-11-11 18:39:36", "37.157.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5154", "0", "magma", "2015-11-11 18:50:47", "191.178.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5155", "0", "magma", "2015-11-11 18:54:04", "179.222.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5156", "1", "admin8576", "2015-11-11 18:54:34", "178.20.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5157", "0", "magma", "2015-11-11 19:25:43", "213.119.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5158", "0", "magma", "2015-11-11 20:00:40", "110.159.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5159", "0", "magma", "2015-11-11 20:06:39", "77.105.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5160", "1", "admin8576", "2015-11-11 20:21:05", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5161", "0", "magma", "2015-11-11 20:29:02", "218.110.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5162", "0", "magma", "2015-11-11 20:39:38", "185.23.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5163", "0", "magma", "2015-11-11 20:56:30", "5.102.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5164", "0", "magma", "2015-11-11 21:31:32", "191.185.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5165", "1", "admin8576", "2015-11-11 21:47:20", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5166", "0", "magma", "2015-11-11 22:05:31", "188.141.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5167", "0", "magma", "2015-11-11 22:12:58", "189.26.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5168", "0", "magma", "2015-11-11 22:21:49", "94.189.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5169", "0", "admin", "2015-11-11 23:06:45", "185.10.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5170", "1", "admin8576", "2015-11-11 23:13:51", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5171", "0", "magma", "2015-11-11 23:34:57", "178.222.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5172", "0", "magma", "2015-11-11 23:59:46", "46.240.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5173", "0", "magma", "2015-11-12 00:40:41", "78.163.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5174", "0", "magma", "2015-11-12 01:26:20", "187.171.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5175", "1", "admin8576", "2015-11-12 03:35:00", "176.58.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5176", "0", "magma", "2015-11-12 03:37:27", "116.90.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5177", "0", "magma", "2015-11-12 04:42:09", "200.192.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5178", "1", "admin8576", "2015-11-12 05:01:46", "158.69.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5179", "1", "admin8576", "2015-11-12 06:29:28", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5180", "0", "magma", "2015-11-12 06:44:41", "80.227.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5181", "0", "magma", "2015-11-12 07:08:12", "49.204.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5182", "0", "admin", "2015-11-12 07:56:29", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5183", "1", "admin8576", "2015-11-12 07:57:16", "46.182.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5184", "1", "admin8576", "2015-11-12 09:24:10", "193.171.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5185", "0", "magma", "2015-11-12 09:26:35", "182.186.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5186", "0", "magma", "2015-11-12 10:09:12", "197.117.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5187", "1", "admin8576", "2015-11-12 10:49:50", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5188", "0", "magma", "2015-11-12 11:42:04", "178.149.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5189", "1", "admin8576", "2015-11-12 12:16:16", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5190", "0", "magma", "2015-11-12 12:33:49", "163.47.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5191", "0", "magma", "2015-11-12 12:44:56", "43.227.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5192", "1", "admin8576", "2015-11-12 13:42:52", "65.183.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5193", "1", "admin8576", "2015-11-12 15:09:47", "185.100.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5194", "1", "admin8576", "2015-11-12 16:36:30", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5195", "0", "admin", "2015-11-12 17:44:47", "80.82.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5196", "1", "admin8576", "2015-11-12 18:03:17", "207.201.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5197", "1", "admin8576", "2015-11-12 19:29:48", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5198", "1", "admin8576", "2015-11-12 20:56:26", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5199", "1", "admin8576", "2015-11-12 22:23:17", "129.123.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5200", "1", "admin8576", "2015-11-12 23:50:19", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5201", "1", "admin8576", "2015-11-13 01:17:07", "173.254.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5202", "1", "admin8576", "2015-11-13 02:44:00", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5203", "0", "admin", "2015-11-13 04:30:35", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5204", "1", "admin8576", "2015-11-13 05:39:19", "95.130.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5205", "1", "admin8576", "2015-11-13 07:06:46", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5206", "1", "admin8576", "2015-11-13 08:34:19", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5207", "1", "admin8576", "2015-11-13 10:01:47", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5208", "1", "admin8576", "2015-11-13 11:29:10", "209.222.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5209", "1", "admin8576", "2015-11-13 12:56:15", "94.242.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5210", "1", "admin8576", "2015-11-13 14:23:57", "37.59.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5211", "0", "admin", "2015-11-13 14:56:57", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5212", "1", "admin8576", "2015-11-13 15:51:21", "89.187.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5213", "1", "admin8576", "2015-11-13 17:19:36", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5214", "1", "admin8576", "2015-11-13 18:46:55", "81.7.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5215", "1", "admin8576", "2015-11-13 20:14:04", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5216", "1", "admin8576", "2015-11-13 21:42:50", "104.238.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5217", "1", "admin8576", "2015-11-13 23:09:49", "185.14.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5218", "1", "admin8576", "2015-11-14 00:37:07", "5.199.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5219", "0", "admin", "2015-11-14 01:48:50", "195.154.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5220", "1", "admin8576", "2015-11-14 02:04:01", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5221", "1", "admin8576", "2015-11-14 03:32:17", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5222", "1", "admin8576", "2015-11-14 04:59:57", "162.218.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5223", "1", "admin8576", "2015-11-14 06:28:13", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5224", "1", "admin8576", "2015-11-14 07:54:03", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5225", "1", "admin8576", "2015-11-14 09:21:54", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5226", "1", "admin8576", "2015-11-14 10:49:27", "212.83.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5227", "1", "admin8576", "2015-11-14 12:16:52", "185.17.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5228", "1", "admin8576", "2015-11-14 13:44:09", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5229", "1", "admin8576", "2015-11-14 15:10:49", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5230", "1", "admin8576", "2015-11-14 16:37:55", "85.16.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5231", "1", "admin8576", "2015-11-14 18:05:06", "217.12.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5232", "1", "admin8576", "2015-11-14 19:32:35", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5233", "1", "admin8576", "2015-11-14 21:01:20", "107.181.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5234", "1", "admin8576", "2015-11-14 22:29:14", "158.69.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5235", "0", "admin", "2015-11-14 23:00:38", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5236", "1", "admin8576", "2015-11-14 23:57:14", "81.17.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5237", "1", "admin8576", "2015-11-15 01:24:34", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5238", "1", "admin8576", "2015-11-15 02:51:11", "185.100.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5239", "1", "admin8576", "2015-11-15 04:23:23", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5240", "1", "admin8576", "2015-11-15 05:53:40", "158.69.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5241", "1", "admin8576", "2015-11-15 07:25:01", "65.183.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5242", "0", "admin", "2015-11-15 08:50:57", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5243", "1", "admin8576", "2015-11-15 08:52:22", "79.172.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5244", "1", "admin8576", "2015-11-15 10:19:57", "192.3.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5245", "1", "admin8576", "2015-11-15 11:47:26", "80.169.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5246", "1", "admin8576", "2015-11-15 13:15:42", "212.47.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5247", "1", "admin8576", "2015-11-15 14:44:30", "5.135.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5248", "1", "admin8576", "2015-11-15 16:12:50", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5249", "1", "admin8576", "2015-11-15 17:42:45", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5250", "0", "admin", "2015-11-15 18:47:17", "5.9.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5251", "1", "admin8576", "2015-11-15 19:11:41", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5252", "1", "admin8576", "2015-11-15 22:11:48", "84.19.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5253", "1", "admin8576", "2015-11-15 23:41:54", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5254", "1", "admin8576", "2015-11-16 01:10:55", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5255", "1", "admin8576", "2015-11-16 02:40:51", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5256", "1", "admin8576", "2015-11-16 04:10:03", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5257", "1", "admin8576", "2015-11-16 05:40:25", "217.115.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5258", "1", "admin8576", "2015-11-16 07:08:06", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5259", "1", "admin8576", "2015-11-16 08:37:18", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5260", "1", "admin8576", "2015-11-16 10:04:40", "207.244.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5261", "1", "admin8576", "2015-11-16 11:32:27", "77.244.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5262", "1", "admin8576", "2015-11-16 13:00:18", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5263", "1", "admin8576", "2015-11-16 14:28:41", "173.255.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5264", "1", "admin8576", "2015-11-16 15:53:13", "92.222.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5265", "1", "admin8576", "2015-11-16 17:16:39", "31.220.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5266", "1", "admin8576", "2015-11-16 18:40:17", "209.222.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5267", "1", "admin8576", "2015-11-16 20:04:08", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5268", "1", "admin8576", "2015-11-16 21:28:10", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5269", "1", "admin8576", "2015-11-16 22:52:10", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5270", "1", "admin8576", "2015-11-17 00:16:08", "79.98.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5271", "1", "admin8576", "2015-11-17 01:39:53", "77.244.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5272", "1", "admin8576", "2015-11-17 03:03:18", "85.93.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5273", "1", "admin8576", "2015-11-17 04:26:44", "142.4.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5274", "1", "admin8576", "2015-11-17 05:49:47", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5275", "0", "admin", "2015-11-17 06:42:42", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5276", "1", "admin8576", "2015-11-17 07:15:02", "85.16.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5277", "1", "admin8576", "2015-11-17 08:38:01", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5278", "0", "admin", "2015-11-17 09:11:04", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5279", "1", "admin8576", "2015-11-17 10:00:42", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5280", "1", "admin8576", "2015-11-17 11:23:12", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5281", "0", "admin", "2015-11-17 11:23:54", "81.89.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5282", "0", "admin", "2015-11-17 11:43:12", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5283", "1", "admin8576", "2015-11-17 12:46:06", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5284", "1", "admin8576", "2015-11-17 14:13:47", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5285", "1", "admin8576", "2015-11-17 16:03:30", "54.183.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5286", "1", "admin8576", "2015-11-17 17:13:32", "54.183.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5287", "1", "admin8576", "2015-11-17 17:14:16", "142.4.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5288", "1", "admin8576", "2015-11-17 17:58:49", "54.183.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5289", "1", "admin8576", "2015-11-17 18:43:26", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5290", "1", "admin8576", "2015-11-17 20:12:53", "173.254.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5291", "0", "admin", "2015-11-17 21:25:53", "158.69.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5292", "1", "admin8576", "2015-11-17 21:39:48", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5293", "1", "admin8576", "2015-11-17 23:02:32", "185.100.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5294", "0", "admin", "2015-11-17 23:50:48", "91.109.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5295", "0", "admin", "2015-11-17 23:55:44", "173.255.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5296", "1", "admin8576", "2015-11-18 00:25:29", "85.93.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5297", "1", "admin8576", "2015-11-18 01:49:08", "198.50.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5298", "1", "admin8576", "2015-11-18 03:13:51", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5299", "1", "admin8576", "2015-11-18 04:36:28", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5300", "1", "admin8576", "2015-11-18 05:59:06", "89.248.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5301", "0", "admin", "2015-11-18 06:39:04", "64.27.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5302", "1", "admin8576", "2015-11-18 07:21:50", "104.232.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5303", "1", "admin8576", "2015-11-18 08:44:00", "89.248.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5304", "0", "admin", "2015-11-18 08:59:59", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5305", "1", "admin8576", "2015-11-18 10:06:44", "81.7.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5306", "0", "admin", "2015-11-18 10:59:34", "31.220.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5307", "0", "admin", "2015-11-18 10:59:35", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5308", "1", "admin8576", "2015-11-18 11:29:14", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5309", "1", "admin8576", "2015-11-18 11:52:44", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5310", "1", "admin8576", "2015-11-18 12:26:18", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5311", "1", "admin8576", "2015-11-18 12:52:19", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5312", "1", "admin8576", "2015-11-18 12:58:26", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5313", "1", "admin8576", "2015-11-18 13:29:18", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5314", "1", "admin8576", "2015-11-18 14:03:23", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5315", "1", "admin8576", "2015-11-18 14:18:56", "84.19.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5316", "1", "admin8576", "2015-11-18 14:36:33", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5317", "1", "admin8576", "2015-11-18 15:15:03", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5318", "1", "admin8576", "2015-11-18 15:51:52", "85.16.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5319", "1", "admin8576", "2015-11-18 15:55:37", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5320", "1", "admin8576", "2015-11-18 16:39:40", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5321", "1", "admin8576", "2015-11-18 17:23:19", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5322", "1", "admin8576", "2015-11-18 17:26:11", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5323", "1", "admin8576", "2015-11-18 18:10:04", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5324", "1", "admin8576", "2015-11-18 18:51:41", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5325", "1", "admin8576", "2015-11-18 19:05:21", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5326", "1", "admin8576", "2015-11-18 19:27:48", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5327", "1", "admin8576", "2015-11-18 19:59:56", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5328", "1", "admin8576", "2015-11-18 20:33:11", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5329", "0", "admin", "2015-11-18 20:46:29", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5330", "1", "admin8576", "2015-11-18 21:05:34", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5331", "0", "admin", "2015-11-18 22:54:40", "94.102.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5332", "0", "admin", "2015-11-18 22:54:41", "178.32.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5333", "0", "admin", "2015-11-19 06:21:53", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5334", "1", "admin8576", "2015-11-19 07:11:07", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5335", "1", "admin8576", "2015-11-19 07:38:09", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5336", "1", "admin8576", "2015-11-19 08:05:22", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5337", "1", "admin8576", "2015-11-19 08:32:41", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5338", "0", "admin", "2015-11-19 08:42:58", "176.10.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5339", "1", "admin8576", "2015-11-19 08:59:42", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5340", "1", "admin8576", "2015-11-19 09:27:12", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5341", "1", "admin8576", "2015-11-19 09:54:31", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5342", "1", "admin8576", "2015-11-19 10:29:48", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5343", "0", "admin", "2015-11-19 10:40:08", "178.17.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5344", "0", "admin", "2015-11-19 10:40:09", "200.63.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5345", "1", "admin8576", "2015-11-19 11:01:17", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5346", "1", "admin8576", "2015-11-19 11:31:53", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5347", "1", "admin8576", "2015-11-19 12:06:00", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5348", "1", "admin8576", "2015-11-19 12:39:03", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5349", "1", "admin8576", "2015-11-19 13:10:53", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5350", "1", "admin8576", "2015-11-19 13:43:47", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5351", "1", "admin8576", "2015-11-19 14:19:54", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5352", "1", "admin8576", "2015-11-19 15:02:38", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5353", "1", "admin8576", "2015-11-19 15:44:04", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5354", "1", "admin8576", "2015-11-19 16:20:26", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5355", "1", "admin8576", "2015-11-19 16:51:25", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5356", "1", "admin8576", "2015-11-19 17:31:45", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5357", "1", "admin8576", "2015-11-19 18:13:31", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5358", "0", "admin", "2015-11-19 18:24:22", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5359", "1", "admin8576", "2015-11-19 18:55:18", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5360", "1", "admin8576", "2015-11-19 19:28:31", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5361", "0", "admin", "2015-11-19 23:01:45", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5362", "0", "admin", "2015-11-19 23:01:45", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5363", "0", "admin", "2015-11-20 07:08:29", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5364", "0", "admin", "2015-11-20 09:44:22", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5365", "0", "admin", "2015-11-20 11:29:58", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5366", "0", "admin", "2015-11-20 11:30:16", "72.52.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5367", "0", "admin", "2015-11-20 20:14:33", "204.124.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5368", "0", "admin", "2015-11-21 00:05:47", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5369", "0", "admin", "2015-11-21 00:05:47", "176.10.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5370", "0", "admin", "2015-11-21 08:00:09", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5371", "0", "admin", "2015-11-21 19:12:41", "46.148.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5372", "0", "admin", "2015-11-22 05:20:06", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5373", "0", "admin", "2015-11-22 15:36:06", "46.165.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5374", "0", "admin", "2015-11-23 02:24:40", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5375", "0", "admin", "2015-11-23 11:04:34", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5376", "1", "admin8576", "2015-11-24 16:12:40", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5377", "1", "admin8576", "2015-11-24 16:45:52", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5378", "1", "admin8576", "2015-11-24 17:35:15", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5379", "1", "admin8576", "2015-11-24 18:22:54", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5380", "1", "admin8576", "2015-11-24 18:47:44", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5381", "1", "admin8576", "2015-11-24 19:13:39", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5382", "1", "admin8576", "2015-11-24 19:41:09", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5383", "1", "admin8576", "2015-11-24 20:09:41", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5384", "1", "admin8576", "2015-11-24 20:37:11", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5385", "1", "admin8576", "2015-11-24 21:04:38", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5386", "0", "admin", "2015-11-24 21:19:28", "178.175.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5387", "1", "admin8576", "2015-11-24 21:32:20", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5388", "1", "admin8576", "2015-11-24 21:56:09", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5389", "1", "admin8576", "2015-11-24 22:20:32", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5390", "1", "admin8576", "2015-11-24 22:46:48", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5391", "1", "admin8576", "2015-11-24 23:21:09", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5392", "1", "admin8576", "2015-11-24 23:56:34", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5393", "1", "admin8576", "2015-11-25 00:32:37", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5394", "1", "admin8576", "2015-11-25 01:08:25", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5395", "1", "admin8576", "2015-11-25 01:43:10", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5396", "0", "admin", "2015-11-25 07:25:33", "176.31.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5397", "1", "admin8576", "2015-11-25 09:52:36", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5398", "1", "admin8576", "2015-11-25 10:15:08", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5399", "1", "admin8576", "2015-11-25 10:43:03", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5400", "1", "admin8576", "2015-11-25 11:11:09", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5401", "1", "admin8576", "2015-11-25 11:39:52", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5402", "1", "admin8576", "2015-11-25 12:09:01", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5403", "1", "admin8576", "2015-11-25 12:37:04", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5404", "1", "admin8576", "2015-11-25 13:01:02", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5405", "1", "admin8576", "2015-11-25 13:25:40", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5406", "1", "admin8576", "2015-11-25 13:54:55", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5407", "1", "admin8576", "2015-11-25 14:27:10", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5408", "1", "admin8576", "2015-11-25 14:58:40", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5409", "1", "admin8576", "2015-11-25 15:28:42", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5410", "1", "admin8576", "2015-11-25 15:54:56", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5411", "0", "admin", "2015-11-25 17:40:58", "81.89.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5412", "0", "admin", "2015-11-26 04:10:36", "37.59.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5413", "1", "admin8576", "2015-11-27 09:47:38", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5414", "1", "admin8576", "2015-11-27 09:47:39", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5415", "2", "admin5748", "2015-11-27 09:47:39", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5416", "1", "admin8576", "2015-11-29 12:30:25", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5417", "1", "admin8576", "2015-11-29 12:30:26", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5418", "2", "admin5748", "2015-11-29 12:30:27", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5419", "0", "admin", "2015-11-29 18:53:38", "151.80.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5420", "1", "admin8576", "2015-12-01 17:55:19", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5421", "1", "admin8576", "2015-12-01 17:55:20", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5422", "2", "admin5748", "2015-12-01 17:55:20", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5423", "1", "admin8576", "2015-12-02 19:33:55", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5424", "1", "admin8576", "2015-12-02 20:27:55", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5425", "1", "admin8576", "2015-12-02 21:02:20", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5426", "1", "admin8576", "2015-12-02 21:31:49", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5427", "1", "admin8576", "2015-12-02 21:53:52", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5428", "1", "admin8576", "2015-12-02 22:20:44", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5429", "1", "admin8576", "2015-12-02 22:47:30", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5430", "1", "admin8576", "2015-12-02 23:15:35", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5431", "1", "admin8576", "2015-12-02 23:43:03", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5432", "1", "admin8576", "2015-12-03 00:11:15", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5433", "1", "admin8576", "2015-12-03 00:38:58", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5434", "1", "admin8576", "2015-12-03 01:07:28", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5435", "1", "admin8576", "2015-12-03 01:35:30", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5436", "1", "admin8576", "2015-12-03 02:01:47", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5437", "1", "admin8576", "2015-12-03 02:24:05", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5438", "1", "admin8576", "2015-12-03 02:46:07", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5439", "1", "admin8576", "2015-12-03 03:12:28", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5440", "1", "admin8576", "2015-12-03 03:40:00", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5441", "1", "admin8576", "2015-12-03 04:07:03", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5442", "1", "admin8576", "2015-12-13 13:38:09", "188.143.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5443", "1", "admin8576", "2015-12-13 13:38:10", "188.143.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5444", "1", "admin8576", "2015-12-13 13:38:12", "188.143.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5445", "0", "Admin", "2015-12-14 10:31:50", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5446", "0", "aDmin5478", "2015-12-14 14:55:00", "41.13.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5447", "2", "admin5748", "2015-12-15 13:54:18", "41.13.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5448", "2", "aDmin5748", "2015-12-15 13:55:14", "41.13.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5449", "1", "aDmin8576", "2015-12-15 13:55:55", "41.13.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5450", "1", "admin8576", "2015-12-15 14:09:39", "52.35.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5451", "1", "admin8576", "2015-12-15 14:50:22", "52.35.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5452", "1", "admin8576", "2015-12-15 15:46:55", "52.35.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5453", "1", "admin8576", "2015-12-15 16:45:39", "52.11.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5454", "1", "admin8576", "2015-12-15 17:11:07", "52.11.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5455", "1", "admin8576", "2015-12-15 17:37:44", "52.11.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5456", "1", "admin8576", "2015-12-15 18:04:15", "52.11.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5457", "1", "admin8576", "2015-12-16 21:16:21", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5458", "1", "admin8576", "2015-12-16 21:45:57", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5459", "1", "admin8576", "2015-12-16 22:16:32", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5460", "1", "admin8576", "2015-12-16 22:44:03", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5461", "1", "admin8576", "2015-12-16 23:10:36", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5462", "1", "admin8576", "2015-12-16 23:37:35", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5463", "1", "admin8576", "2015-12-17 00:04:39", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5464", "1", "admin8576", "2015-12-17 00:34:46", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5465", "1", "admin8576", "2015-12-17 01:07:55", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5466", "1", "admin8576", "2015-12-17 01:39:33", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5467", "1", "admin8576", "2015-12-17 02:12:56", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5468", "1", "admin8576", "2015-12-17 02:46:19", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5469", "1", "admin8576", "2015-12-17 03:19:54", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5470", "1", "admin8576", "2015-12-17 03:54:06", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5471", "1", "admin8576", "2015-12-17 04:27:57", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5472", "1", "admin8576", "2015-12-17 04:59:36", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5473", "0", "Admin", "2015-12-17 08:56:10", "195.154.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5474", "1", "admin8576", "2015-12-17 11:18:43", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5475", "1", "admin8576", "2015-12-17 11:25:36", "54.183.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5476", "1", "admin8576", "2015-12-17 11:45:27", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5477", "1", "admin8576", "2015-12-17 12:12:41", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5478", "1", "admin8576", "2015-12-17 12:40:09", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5479", "1", "admin8576", "2015-12-17 13:07:41", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5480", "1", "admin8576", "2015-12-17 13:42:18", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5481", "1", "admin8576", "2015-12-17 14:17:20", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5482", "1", "admin8576", "2015-12-17 14:52:13", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5483", "1", "admin8576", "2015-12-17 15:27:36", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5484", "1", "admin8576", "2015-12-17 16:02:29", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5485", "1", "admin8576", "2015-12-17 16:37:28", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5486", "1", "admin8576", "2015-12-17 17:11:52", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5487", "1", "admin8576", "2015-12-17 17:39:52", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5488", "1", "admin8576", "2015-12-17 18:12:39", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5489", "1", "admin8576", "2015-12-17 18:46:30", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5490", "1", "admin8576", "2015-12-17 21:05:49", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5491", "1", "admin8576", "2015-12-17 21:05:50", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5492", "2", "admin5748", "2015-12-17 21:05:51", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5493", "1", "admin8576", "2015-12-19 16:46:53", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5494", "1", "admin8576", "2015-12-19 16:46:54", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5495", "2", "admin5748", "2015-12-19 16:46:54", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5496", "0", "Admin", "2015-12-20 22:47:13", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5497", "0", "Admin", "2015-12-25 02:00:56", "195.154.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5498", "1", "admin8576", "2015-12-30 19:35:27", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5499", "1", "admin8576", "2015-12-30 19:35:28", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5500", "2", "admin5748", "2015-12-30 19:35:29", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5501", "0", "Admin", "2016-01-05 04:33:41", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5502", "1", "admin8576", "2016-01-05 19:54:53", "216.17.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5503", "1", "admin8576", "2016-01-06 03:56:12", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5504", "1", "admin8576", "2016-01-06 11:50:46", "5.39.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5505", "1", "admin8576", "2016-01-06 12:12:08", "27.255.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5506", "1", "admin8576", "2016-01-06 12:12:09", "27.255.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5507", "1", "admin8576", "2016-01-06 12:12:10", "27.255.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5508", "1", "admin8576", "2016-01-06 20:07:57", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5509", "1", "admin8576", "2016-01-07 04:19:48", "198.50.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5510", "1", "admin8576", "2016-01-07 12:04:43", "91.219.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5511", "1", "admin8576", "2016-01-07 20:08:53", "188.120.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5512", "1", "admin8576", "2016-01-08 03:56:28", "212.83.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5513", "1", "admin8576", "2016-01-08 11:19:55", "81.7.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5514", "1", "admin8576", "2016-01-08 18:55:02", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5515", "1", "admin8576", "2016-01-10 17:11:36", "193.33.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5516", "1", "admin8576", "2016-01-11 00:47:05", "217.147.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5517", "1", "admin8576", "2016-01-11 16:35:02", "185.104.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5518", "1", "admin8576", "2016-01-12 01:02:20", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5519", "1", "admin8576", "2016-01-12 09:02:54", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5520", "1", "admin8576", "2016-01-13 02:01:08", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5521", "1", "admin8576", "2016-01-13 10:18:37", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5522", "1", "admin8576", "2016-01-13 16:54:19", "37.203.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5523", "1", "admin8576", "2016-01-13 16:54:19", "37.203.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5524", "1", "admin8576", "2016-01-13 16:54:20", "37.203.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5525", "1", "admin8576", "2016-01-13 16:54:20", "37.203.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5526", "1", "admin8576", "2016-01-13 18:59:38", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5527", "1", "admin8576", "2016-01-14 04:18:05", "185.100.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5528", "1", "admin8576", "2016-01-14 13:04:11", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5529", "1", "admin8576", "2016-01-14 21:54:27", "195.22.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5530", "1", "admin8576", "2016-01-15 06:28:04", "94.242.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5531", "1", "admin8576", "2016-01-15 15:08:46", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5532", "1", "admin8576", "2016-01-15 23:52:44", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5533", "1", "admin8576", "2016-01-16 08:18:14", "85.17.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5534", "1", "admin8576", "2016-01-16 16:52:12", "66.230.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5535", "1", "admin8576", "2016-01-17 01:34:35", "217.115.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5536", "1", "admin8576", "2016-01-17 09:38:07", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5537", "1", "admin8576", "2016-01-17 17:44:49", "176.123.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5538", "1", "admin8576", "2016-01-18 01:57:44", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5539", "1", "admin8576", "2016-01-18 09:45:59", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5540", "1", "admin8576", "2016-01-18 17:45:53", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5541", "1", "admin8576", "2016-01-19 02:00:30", "162.221.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5542", "1", "admin8576", "2016-01-19 06:25:00", "62.210.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5543", "1", "admin8576", "2016-01-19 06:25:01", "62.210.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5544", "2", "admin5748", "2016-01-19 06:25:02", "62.210.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5545", "1", "admin8576", "2016-01-19 09:51:54", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5546", "1", "admin8576", "2016-01-19 18:26:21", "69.162.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5547", "0", "Admin", "2016-01-19 23:31:42", "195.154.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5548", "1", "admin8576", "2016-01-20 10:37:49", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5549", "0", "Admin", "2016-01-20 12:26:41", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5550", "1", "admin8576", "2016-01-20 19:15:20", "85.93.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5551", "1", "admin8576", "2016-01-21 03:43:49", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5552", "1", "admin8576", "2016-01-21 11:55:38", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5553", "1", "admin8576", "2016-01-21 20:26:33", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5554", "1", "admin8576", "2016-01-22 04:45:11", "5.199.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5555", "1", "admin8576", "2016-01-22 12:51:05", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5556", "1", "admin8576", "2016-01-22 16:58:48", "62.210.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5557", "1", "admin8576", "2016-01-22 16:58:49", "62.210.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5558", "2", "admin5748", "2016-01-22 16:58:50", "62.210.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5559", "1", "admin8576", "2016-01-22 21:19:46", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5560", "1", "admin8576", "2016-01-23 05:29:29", "193.171.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5561", "1", "admin8576", "2016-01-23 13:16:17", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5562", "0", "Admin", "2016-01-23 15:26:53", "195.154.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5563", "1", "admin8576", "2016-01-23 21:28:42", "37.48.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5564", "1", "admin8576", "2016-01-24 05:42:00", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5565", "1", "admin8576", "2016-01-24 13:33:50", "85.25.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5566", "1", "admin8576", "2016-01-24 21:43:18", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5567", "1", "admin8576", "2016-01-25 13:37:40", "91.219.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5568", "1", "admin8576", "2016-01-25 22:20:09", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5569", "1", "admin8576", "2016-01-26 06:46:26", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5570", "0", "admin", "2016-01-26 15:05:18", "175.44.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5571", "1", "admin8576", "2016-01-26 15:06:31", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5572", "0", "admin", "2016-01-26 16:43:45", "112.111.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5573", "1", "admin8576", "2016-01-27 00:09:09", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5574", "1", "admin8576", "2016-01-27 08:51:33", "193.171.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5575", "1", "admin8576", "2016-01-27 17:45:58", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5576", "1", "admin8576", "2016-01-28 02:51:43", "193.90.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5577", "1", "admin8576", "2016-01-28 10:56:13", "204.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5578", "1", "admin8576", "2016-01-28 19:54:52", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5579", "1", "admin8576", "2016-01-29 04:59:25", "185.104.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5580", "1", "admin8576", "2016-01-29 13:05:55", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5581", "1", "admin8576", "2016-01-29 21:44:53", "185.104.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5582", "1", "admin8576", "2016-01-30 23:28:08", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5583", "1", "admin8576", "2016-01-31 08:07:54", "185.17.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5584", "0", "admin", "2016-02-02 03:11:18", "118.193.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5585", "0", "Admin", "2016-02-04 10:49:11", "195.154.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5586", "0", "Admin", "2016-02-18 22:58:12", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5587", "0", "Admin", "2016-02-21 21:15:13", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5588", "1", "admin8576", "2016-02-23 17:35:23", "46.119.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5589", "1", "admin8576", "2016-02-23 17:35:27", "46.119.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5590", "1", "admin8576", "2016-02-23 17:35:31", "46.119.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5591", "0", "Admin", "2016-03-04 21:15:52", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5592", "1", "admin8576", "2016-03-08 03:31:29", "195.154.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5593", "1", "admin8576", "2016-03-08 03:31:31", "195.154.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5594", "1", "admin8576", "2016-03-08 03:31:35", "195.154.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5595", "1", "admin8576", "2016-03-10 12:27:06", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5596", "1", "admin8576", "2016-03-10 13:17:53", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5597", "1", "admin8576", "2016-03-10 14:10:27", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5598", "1", "admin8576", "2016-03-10 15:04:48", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5599", "1", "admin8576", "2016-03-10 15:58:42", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5600", "1", "admin8576", "2016-03-10 16:53:35", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5601", "1", "admin8576", "2016-03-10 17:48:23", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5602", "1", "admin8576", "2016-03-10 18:43:01", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5603", "1", "admin8576", "2016-03-10 19:38:18", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5604", "1", "admin8576", "2016-03-10 20:33:22", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5605", "1", "admin8576", "2016-03-10 21:26:32", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5606", "0", "Admin", "2016-03-10 21:40:33", "195.154.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5607", "1", "admin8576", "2016-03-10 22:18:17", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5608", "1", "admin8576", "2016-03-10 23:11:51", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5609", "1", "admin8576", "2016-03-11 00:06:11", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5610", "1", "admin8576", "2016-03-11 01:00:48", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5611", "1", "admin8576", "2016-03-11 01:58:20", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5612", "1", "admin8576", "2016-03-11 03:02:46", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5613", "1", "admin8576", "2016-03-11 04:06:52", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5614", "1", "admin8576", "2016-03-11 05:10:23", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5615", "1", "admin8576", "2016-03-11 06:13:56", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5616", "1", "admin8576", "2016-03-11 07:16:47", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5617", "0", "Admin", "2016-03-13 00:03:51", "195.154.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5618", "1", "admin8576", "2016-03-14 23:10:02", "134.249.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5619", "1", "admin8576", "2016-03-14 23:10:29", "134.249.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5620", "1", "admin8576", "2016-03-14 23:10:57", "134.249.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5621", "0", "Admin", "2016-03-18 07:12:25", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5622", "0", "admin", "2016-03-18 18:46:04", "62.210.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5623", "0", "Admin", "2016-03-22 07:06:39", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5624", "0", "admin", "2016-03-29 17:47:29", "13.92.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5625", "0", "admin", "2016-03-30 19:27:08", "13.92.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5626", "1", "admin8576", "2016-04-01 17:37:50", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5627", "1", "admin8576", "2016-04-01 18:16:48", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5628", "1", "admin8576", "2016-04-01 18:56:00", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5629", "1", "admin8576", "2016-04-01 19:35:02", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5630", "1", "admin8576", "2016-04-01 20:16:05", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5631", "1", "admin8576", "2016-04-01 20:58:50", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5632", "1", "admin8576", "2016-04-01 21:41:56", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5633", "1", "admin8576", "2016-04-01 22:24:12", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5634", "1", "admin8576", "2016-04-01 23:07:38", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5635", "1", "admin8576", "2016-04-01 23:49:44", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5636", "1", "admin8576", "2016-04-02 00:30:57", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5637", "1", "admin8576", "2016-04-02 01:13:00", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5638", "1", "admin8576", "2016-04-02 01:57:03", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5639", "1", "admin8576", "2016-04-02 02:39:56", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5640", "1", "admin8576", "2016-04-02 03:23:45", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5641", "1", "admin8576", "2016-04-02 04:08:38", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5642", "1", "admin8576", "2016-04-02 04:54:01", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5643", "1", "admin8576", "2016-04-02 05:40:17", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5644", "1", "admin8576", "2016-04-02 06:26:10", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5645", "1", "admin8576", "2016-04-02 07:11:36", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5646", "1", "admin8576", "2016-04-02 07:57:39", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5647", "1", "admin8576", "2016-04-02 08:43:20", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5648", "1", "admin8576", "2016-04-02 09:27:24", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5649", "1", "admin8576", "2016-04-02 10:12:35", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5650", "1", "admin8576", "2016-04-02 11:03:30", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5651", "1", "admin8576", "2016-04-02 11:49:24", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5652", "1", "admin8576", "2016-04-02 12:35:38", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5653", "1", "admin8576", "2016-04-02 13:22:23", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5654", "1", "admin8576", "2016-04-02 14:08:57", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5655", "1", "admin8576", "2016-04-02 14:54:15", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5656", "1", "admin8576", "2016-04-02 15:38:54", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5657", "1", "admin8576", "2016-04-02 16:33:30", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5658", "1", "admin8576", "2016-04-02 17:20:12", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5659", "1", "admin8576", "2016-04-02 18:06:27", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5660", "1", "admin8576", "2016-04-02 18:52:32", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5661", "1", "admin8576", "2016-04-02 19:37:58", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5662", "1", "admin8576", "2016-04-02 20:22:49", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5663", "1", "admin8576", "2016-04-02 21:08:09", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5664", "1", "admin8576", "2016-04-02 21:54:37", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5665", "1", "admin8576", "2016-04-02 22:41:16", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5666", "1", "admin8576", "2016-04-02 23:26:46", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5667", "1", "admin8576", "2016-04-03 00:13:02", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5668", "1", "admin8576", "2016-04-03 00:58:52", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5669", "1", "admin8576", "2016-04-03 01:38:52", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5670", "1", "admin8576", "2016-04-03 02:20:13", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5671", "1", "admin8576", "2016-04-03 03:02:32", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5672", "1", "admin8576", "2016-04-03 03:44:42", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5673", "1", "admin8576", "2016-04-03 04:25:32", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5674", "1", "admin8576", "2016-04-03 05:07:09", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5675", "1", "admin8576", "2016-04-03 05:48:38", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5676", "1", "admin8576", "2016-04-03 06:28:16", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5677", "1", "admin8576", "2016-04-03 07:06:58", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5678", "1", "admin8576", "2016-04-03 07:45:17", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5679", "1", "admin8576", "2016-04-03 08:25:43", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5680", "1", "admin8576", "2016-04-03 09:04:36", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5681", "1", "admin8576", "2016-04-03 09:42:20", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5682", "1", "admin8576", "2016-04-03 10:21:03", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5683", "1", "admin8576", "2016-04-03 11:02:34", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5684", "1", "admin8576", "2016-04-03 11:42:56", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5685", "1", "admin8576", "2016-04-03 12:21:42", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5686", "1", "admin8576", "2016-04-03 13:00:58", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5687", "1", "admin8576", "2016-04-03 13:41:05", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5688", "1", "admin8576", "2016-04-03 14:21:50", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5689", "1", "admin8576", "2016-04-03 15:02:41", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5690", "1", "admin8576", "2016-04-03 15:43:56", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5691", "1", "admin8576", "2016-04-03 16:27:05", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5692", "1", "admin8576", "2016-04-03 17:10:41", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5693", "1", "admin8576", "2016-04-03 17:52:54", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5694", "1", "admin8576", "2016-04-03 18:32:52", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5695", "1", "admin8576", "2016-04-08 15:26:22", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5696", "1", "admin8576", "2016-04-08 15:26:23", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5697", "1", "admin8576", "2016-04-08 15:26:24", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5698", "1", "admin8576", "2016-04-12 06:12:49", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5699", "1", "admin8576", "2016-04-12 12:17:48", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5700", "1", "admin8576", "2016-04-12 19:40:35", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5701", "1", "admin8576", "2016-04-13 03:11:14", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5702", "1", "admin8576", "2016-04-13 10:49:27", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5703", "1", "admin8576", "2016-04-13 18:05:51", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5704", "1", "admin8576", "2016-04-14 01:29:25", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5705", "1", "admin8576", "2016-04-14 09:09:05", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5706", "1", "admin8576", "2016-04-14 16:47:49", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5707", "1", "admin8576", "2016-04-15 00:26:33", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5708", "1", "admin8576", "2016-04-15 08:03:25", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5709", "1", "admin8576", "2016-04-15 14:30:09", "178.137.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5710", "1", "admin8576", "2016-04-15 20:33:24", "178.137.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5711", "1", "admin8576", "2016-04-16 02:41:32", "178.137.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5712", "1", "admin8576", "2016-04-16 07:17:41", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5713", "1", "admin8576", "2016-04-16 13:33:15", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5714", "1", "admin8576", "2016-04-16 19:51:03", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5715", "1", "admin8576", "2016-04-17 02:14:02", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5716", "1", "admin8576", "2016-04-17 08:36:09", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5717", "1", "admin8576", "2016-04-17 14:56:38", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5718", "1", "admin8576", "2016-04-17 18:42:54", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5719", "1", "admin8576", "2016-04-18 00:54:51", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5720", "1", "admin8576", "2016-04-18 07:04:13", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5721", "1", "admin8576", "2016-04-18 13:08:20", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5722", "1", "admin8576", "2016-04-18 19:25:39", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5723", "1", "admin8576", "2016-04-19 01:48:26", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5724", "1", "admin8576", "2016-04-19 08:21:08", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5725", "1", "admin8576", "2016-04-19 14:52:29", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5726", "1", "admin8576", "2016-04-19 21:26:52", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5727", "1", "admin8576", "2016-04-20 03:33:19", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5728", "1", "admin8576", "2016-04-20 08:05:37", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5729", "1", "admin8576", "2016-04-20 13:05:57", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5730", "1", "admin8576", "2016-04-20 17:41:40", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5731", "1", "admin8576", "2016-04-21 00:12:13", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5732", "1", "admin8576", "2016-04-21 06:50:15", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5733", "1", "admin8576", "2016-04-21 13:23:06", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5734", "1", "admin8576", "2016-04-21 20:01:44", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5735", "0", "Admin", "2016-04-21 22:15:10", "195.154.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5736", "1", "admin8576", "2016-04-22 02:41:44", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5737", "1", "admin8576", "2016-04-22 09:22:53", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5738", "1", "admin8576", "2016-04-22 16:06:39", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5739", "1", "admin8576", "2016-04-22 22:45:34", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5740", "1", "admin8576", "2016-04-23 05:22:21", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5741", "1", "admin8576", "2016-04-23 11:53:51", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5742", "1", "admin8576", "2016-04-23 18:25:02", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5743", "1", "admin8576", "2016-04-24 00:56:28", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5744", "1", "admin8576", "2016-04-24 06:33:50", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5745", "1", "admin8576", "2016-04-24 12:34:06", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5746", "1", "admin8576", "2016-04-24 18:47:10", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5747", "1", "admin8576", "2016-04-25 01:19:53", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5748", "1", "admin8576", "2016-04-25 07:52:10", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5749", "1", "admin8576", "2016-04-25 14:19:08", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5750", "1", "admin8576", "2016-04-25 20:41:43", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5751", "1", "admin8576", "2016-04-26 03:08:14", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5752", "1", "admin8576", "2016-04-26 06:59:14", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5753", "1", "admin8576", "2016-04-26 12:09:56", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5754", "1", "admin8576", "2016-04-26 18:32:32", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5755", "1", "admin8576", "2016-04-27 06:24:52", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5756", "1", "admin8576", "2016-04-27 12:37:57", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5757", "1", "admin8576", "2016-04-27 18:53:21", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5758", "1", "admin8576", "2016-04-28 01:02:44", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5759", "1", "admin8576", "2016-04-28 06:12:47", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5760", "2", "admin5748", "2016-04-28 10:13:39", "82.207.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5761", "1", "admin8576", "2016-04-28 10:24:06", "94.29.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5762", "2", "admin5748", "2016-04-28 10:39:42", "42.112.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5763", "2", "admin5748", "2016-04-28 10:44:40", "83.139.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5764", "1", "admin8576", "2016-04-28 10:53:09", "185.17.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5765", "1", "admin8576", "2016-04-28 10:56:52", "113.161.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5766", "1", "admin8576", "2016-04-28 11:04:35", "117.3.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5767", "2", "admin5748", "2016-04-28 11:19:25", "113.166.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5768", "1", "admin8576", "2016-04-28 11:33:10", "62.133.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5769", "2", "admin5748", "2016-04-28 11:42:23", "115.77.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5770", "1", "admin8576", "2016-04-28 11:42:48", "2.62.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5771", "2", "admin5748", "2016-04-28 12:05:11", "46.180.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5772", "1", "admin8576", "2016-04-28 14:09:49", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5773", "1", "admin8576", "2016-04-28 18:03:48", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5774", "1", "admin8576", "2016-04-29 00:20:14", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5775", "1", "admin8576", "2016-04-29 06:40:18", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5776", "1", "admin8576", "2016-04-29 12:55:16", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5777", "1", "admin8576", "2016-04-29 19:00:24", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5778", "1", "admin8576", "2016-04-30 01:14:45", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5779", "1", "admin8576", "2016-04-30 07:33:54", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5780", "1", "admin8576", "2016-04-30 12:44:38", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5781", "1", "admin8576", "2016-04-30 18:17:10", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5782", "1", "admin8576", "2016-05-01 00:15:23", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5783", "1", "admin8576", "2016-05-01 06:43:27", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5784", "1", "admin8576", "2016-05-01 12:43:07", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5785", "1", "admin8576", "2016-05-01 19:05:53", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5786", "1", "admin8576", "2016-05-02 01:13:30", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5787", "1", "admin8576", "2016-05-02 07:12:35", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5788", "1", "admin8576", "2016-05-02 13:09:29", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5789", "1", "admin8576", "2016-05-02 19:01:58", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5790", "1", "admin8576", "2016-05-03 01:10:41", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5791", "1", "admin8576", "2016-05-03 06:26:16", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5792", "1", "admin8576", "2016-05-03 12:16:55", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5793", "1", "admin8576", "2016-05-03 18:40:20", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5794", "1", "admin8576", "2016-05-04 01:00:43", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5795", "1", "admin8576", "2016-05-04 05:38:00", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5796", "1", "admin8576", "2016-05-04 10:47:40", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5797", "1", "admin8576", "2016-05-04 16:02:23", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5798", "1", "admin8576", "2016-05-04 21:10:37", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5799", "1", "admin8576", "2016-05-05 02:22:02", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5800", "0", "Admin", "2016-05-05 03:11:20", "195.154.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5801", "1", "admin8576", "2016-05-05 08:05:14", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5802", "1", "admin8576", "2016-05-05 13:30:52", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5803", "1", "admin8576", "2016-05-05 18:48:18", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5804", "1", "admin8576", "2016-05-06 00:05:29", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5805", "1", "admin8576", "2016-05-06 05:20:28", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5806", "1", "admin8576", "2016-05-06 10:37:13", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5807", "1", "admin8576", "2016-05-06 15:40:00", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5808", "1", "admin8576", "2016-05-06 20:50:30", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5809", "1", "admin8576", "2016-05-07 02:53:55", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5810", "1", "admin8576", "2016-05-07 08:36:14", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5811", "1", "admin8576", "2016-05-07 13:51:30", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5812", "1", "admin8576", "2016-05-07 19:28:07", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5813", "1", "admin8576", "2016-05-08 01:00:35", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5814", "1", "admin8576", "2016-05-08 06:57:44", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5815", "1", "admin8576", "2016-05-08 12:37:16", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5816", "1", "admin8576", "2016-05-08 18:06:33", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5817", "1", "admin8576", "2016-05-08 23:29:51", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5818", "1", "admin8576", "2016-05-09 04:06:49", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5819", "1", "admin8576", "2016-05-09 09:49:46", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5820", "1", "admin8576", "2016-05-09 16:16:48", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5821", "1", "admin8576", "2016-05-09 22:35:47", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5822", "1", "admin8576", "2016-05-10 05:11:27", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5823", "1", "admin8576", "2016-05-10 10:59:24", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5824", "0", "admin8568", "2016-05-11 13:04:56", "196.210.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5825", "0", "author", "2016-05-16 12:49:35", "90.150.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5826", "0", "editor", "2016-05-16 13:04:16", "113.188.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5827", "1", "admin8576", "2016-05-19 00:01:13", "89.163.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5828", "1", "admin8576", "2016-05-19 00:01:14", "89.163.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5829", "1", "admin8576", "2016-05-19 00:01:14", "89.163.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5830", "0", "Admin", "2016-05-23 16:23:01", "195.154.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5831", "2", "admin5748", "2016-05-25 14:39:41", "115.74.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5832", "1", "admin8576", "2016-05-25 14:42:02", "88.249.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5833", "2", "admin5748", "2016-05-25 14:49:44", "115.76.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5834", "1", "admin8576", "2016-05-25 14:53:42", "83.240.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5835", "1", "admin8576", "2016-05-25 15:09:03", "93.185.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5836", "2", "admin5748", "2016-05-25 15:09:55", "41.107.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5837", "2", "admin5748", "2016-05-25 15:27:15", "14.186.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5838", "1", "admin8576", "2016-05-25 15:34:47", "123.26.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5839", "1", "admin8576", "2016-05-25 16:36:32", "14.207.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5840", "2", "admin5748", "2016-05-25 16:48:32", "58.186.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5841", "1", "admin8576", "2016-05-25 17:36:18", "14.181.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5842", "2", "admin5748", "2016-05-25 17:38:37", "37.79.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5843", "1", "admin8576", "2016-05-25 17:42:58", "186.60.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5844", "2", "admin5748", "2016-05-25 18:25:29", "14.160.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5845", "2", "admin5748", "2016-05-25 18:42:31", "46.0.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5846", "1", "admin8576", "2016-05-25 19:00:50", "109.169.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5847", "1", "admin8576", "2016-05-25 19:07:47", "89.232.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5848", "2", "admin5748", "2016-05-25 19:12:38", "91.237.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5849", "1", "admin8576", "2016-05-28 07:36:12", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5850", "1", "admin8576", "2016-05-28 08:04:10", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5851", "1", "admin8576", "2016-05-28 08:32:42", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5852", "1", "admin8576", "2016-05-28 09:01:18", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5853", "1", "admin8576", "2016-05-28 09:30:22", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5854", "1", "admin8576", "2016-05-28 09:59:24", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5855", "1", "admin8576", "2016-06-01 10:31:36", "195.208.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5856", "1", "admin8576", "2016-06-01 10:31:37", "195.208.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5857", "1", "admin8576", "2016-06-01 10:31:37", "195.208.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5858", "1", "admin8576", "2016-06-06 19:17:58", "103.249.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5859", "1", "admin8576", "2016-06-06 19:17:59", "103.249.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5860", "1", "admin8576", "2016-06-06 19:18:00", "103.249.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5861", "0", "Admin", "2016-06-12 05:21:01", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5862", "1", "admin8576", "2016-06-12 10:22:46", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5863", "1", "admin8576", "2016-06-12 10:22:47", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5864", "1", "admin8576", "2016-06-14 04:10:29", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5865", "1", "admin8576", "2016-06-14 04:10:30", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5866", "1", "admin8576", "2016-06-15 23:51:54", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5867", "1", "admin8576", "2016-06-15 23:51:55", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5868", "1", "admin8576", "2016-06-17 19:43:55", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5869", "1", "admin8576", "2016-06-17 19:43:56", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5870", "1", "admin8576", "2016-06-19 15:14:44", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5871", "1", "admin8576", "2016-06-19 15:14:45", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5872", "1", "admin8576", "2016-06-21 11:01:37", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5873", "1", "admin8576", "2016-06-21 11:01:38", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5874", "0", "admin", "2016-06-21 20:02:01", "216.45.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5875", "0", "admin", "2016-06-21 20:02:02", "216.45.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5876", "0", "admin", "2016-06-21 20:02:03", "216.45.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5877", "0", "Admin", "2016-06-25 06:54:57", "195.154.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5878", "1", "admin8576", "2016-06-29 22:43:26", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5879", "1", "admin8576", "2016-06-29 22:43:27", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5880", "1", "admin8576", "2016-07-02 05:53:59", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5881", "1", "admin8576", "2016-07-02 05:54:00", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5882", "0", "magmainc", "2016-07-05 05:48:39", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5883", "0", "admin", "2016-07-05 12:00:33", "197.96.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5884", "0", "magmainc", "2016-07-11 02:52:48", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5885", "1", "admin8576", "2016-07-11 09:40:02", "107.152.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5886", "1", "admin8576", "2016-07-11 09:43:38", "107.152.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5887", "1", "admin8576", "2016-07-11 09:46:49", "107.152.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5888", "0", "magmainc", "2016-07-14 16:33:51", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5889", "0", "wpupdatestream", "2016-07-16 01:17:39", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5890", "1", "admin8576", "2016-07-17 01:35:11", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5891", "1", "admin8576", "2016-07-17 01:35:18", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5892", "1", "admin8576", "2016-07-17 03:28:10", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5893", "1", "admin8576", "2016-07-17 03:28:11", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5894", "1", "admin8576", "2016-07-17 05:20:52", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5895", "1", "admin8576", "2016-07-17 05:20:54", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5896", "0", "magmainc", "2016-07-17 07:38:50", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5897", "0", "magmainc", "2016-07-18 09:05:35", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5898", "1", "admin8576", "2016-07-23 10:31:14", "142.54.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5899", "1", "admin8576", "2016-07-23 10:31:15", "142.54.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5900", "2", "admin5748", "2016-07-23 10:31:16", "142.54.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5901", "1", "admin8576", "2016-07-25 23:49:35", "109.228.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5902", "1", "admin8576", "2016-07-25 23:49:36", "109.228.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5903", "1", "admin8576", "2016-07-25 23:49:37", "109.228.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5904", "1", "admin8576", "2016-07-29 05:40:28", "122.28.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5905", "1", "admin8576", "2016-07-29 05:40:29", "122.28.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5906", "1", "admin8576", "2016-07-29 05:40:30", "122.28.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5907", "1", "admin8576", "2016-08-03 22:47:40", "212.83.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5908", "1", "admin8576", "2016-08-03 22:47:41", "212.83.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5909", "1", "admin8576", "2016-08-03 22:47:42", "212.83.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5910", "0", "Admin", "2016-08-04 14:07:26", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5911", "1", "admin8576", "2016-08-11 17:35:15", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5912", "1", "admin8576", "2016-08-11 17:35:15", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5913", "2", "admin5748", "2016-08-11 17:35:16", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5914", "1", "admin8576", "2016-08-12 00:48:10", "67.243.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5915", "1", "admin8576", "2016-08-12 01:00:27", "68.57.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5916", "1", "admin8576", "2016-08-12 01:19:55", "213.168.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5917", "1", "admin8576", "2016-08-12 01:21:06", "88.246.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5918", "1", "admin8576", "2016-08-12 01:21:39", "71.87.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5919", "1", "admin8576", "2016-08-12 01:45:08", "106.216.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5920", "1", "admin8576", "2016-08-12 01:46:06", "49.175.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5921", "1", "admin8576", "2016-08-12 01:49:56", "177.91.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5922", "1", "admin8576", "2016-08-12 01:50:17", "180.248.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5923", "1", "admin8576", "2016-08-12 01:56:28", "101.100.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5924", "1", "admin8576", "2016-08-12 02:02:20", "109.255.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5925", "1", "admin8576", "2016-08-12 02:02:27", "82.123.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5926", "1", "admin8576", "2016-08-12 02:02:50", "47.55.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5927", "1", "admin8576", "2016-08-12 02:04:04", "122.178.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5928", "1", "admin8576", "2016-08-12 02:11:49", "112.208.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5929", "1", "admin8576", "2016-08-12 02:12:19", "154.126.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5930", "1", "admin8576", "2016-08-12 02:13:10", "103.233.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5931", "1", "admin8576", "2016-08-12 02:13:30", "182.227.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5932", "1", "admin8576", "2016-08-12 02:17:58", "73.238.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5933", "1", "admin8576", "2016-08-12 02:19:45", "84.109.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5934", "1", "admin8576", "2016-08-12 02:20:35", "112.198.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5935", "1", "admin8576", "2016-08-12 02:22:48", "98.165.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5936", "1", "admin8576", "2016-08-12 02:26:18", "80.87.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5937", "1", "admin8576", "2016-08-12 02:36:35", "109.66.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5938", "1", "admin8576", "2016-08-12 03:08:02", "101.180.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5939", "1", "admin8576", "2016-08-12 03:11:00", "219.248.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5940", "1", "admin8576", "2016-08-12 03:11:08", "5.36.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5941", "1", "admin8576", "2016-08-12 03:12:07", "27.131.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5942", "1", "admin8576", "2016-08-12 03:14:29", "72.184.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5943", "1", "admin8576", "2016-08-12 03:34:20", "5.31.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5944", "1", "admin8576", "2016-08-12 03:34:48", "195.174.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5945", "1", "admin8576", "2016-08-12 03:36:51", "86.97.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5946", "1", "admin8576", "2016-08-12 03:45:41", "108.161.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5947", "1", "admin8576", "2016-08-12 03:50:34", "41.105.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5948", "1", "admin8576", "2016-08-12 03:51:54", "49.148.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5949", "1", "admin8576", "2016-08-12 03:52:40", "190.161.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5950", "1", "admin8576", "2016-08-12 03:56:20", "121.54.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5951", "1", "admin8576", "2016-08-12 04:02:27", "114.108.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5952", "1", "admin8576", "2016-08-12 04:08:22", "154.97.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5953", "1", "admin8576", "2016-08-12 04:14:01", "123.217.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5954", "1", "admin8576", "2016-08-12 04:16:26", "94.126.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5955", "1", "admin8576", "2016-08-12 04:17:50", "188.25.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5956", "1", "admin8576", "2016-08-12 04:18:12", "176.92.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5957", "1", "admin8576", "2016-08-12 04:22:45", "186.93.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5958", "1", "admin8576", "2016-08-12 04:28:02", "112.205.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5959", "1", "admin8576", "2016-08-12 04:33:54", "108.191.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5960", "1", "admin8576", "2016-08-12 04:35:42", "186.179.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5961", "1", "admin8576", "2016-08-12 04:36:06", "49.175.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5962", "1", "admin8576", "2016-08-12 04:36:29", "103.242.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5963", "1", "admin8576", "2016-08-12 04:40:03", "5.60.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5964", "1", "admin8576", "2016-08-12 04:41:19", "138.36.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5965", "1", "admin8576", "2016-08-12 04:46:55", "123.248.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5966", "1", "admin8576", "2016-08-12 04:57:18", "152.231.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5967", "1", "admin8576", "2016-08-12 05:03:45", "105.101.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5968", "1", "admin8576", "2016-08-12 05:03:45", "91.12.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5969", "1", "admin8576", "2016-08-12 05:03:55", "190.136.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5970", "1", "admin8576", "2016-08-12 05:06:25", "200.120.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5971", "1", "admin8576", "2016-08-12 05:12:34", "173.169.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5972", "1", "admin8576", "2016-08-12 05:15:22", "54.171.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5973", "1", "admin8576", "2016-08-12 05:22:36", "216.66.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5974", "1", "admin8576", "2016-08-12 05:23:48", "85.55.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5975", "1", "admin8576", "2016-08-12 05:29:29", "185.37.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5976", "1", "admin8576", "2016-08-12 05:30:25", "112.203.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5977", "1", "admin8576", "2016-08-12 05:33:49", "181.213.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5978", "1", "admin8576", "2016-08-12 05:34:48", "49.148.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5979", "1", "admin8576", "2016-08-12 05:35:03", "49.148.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5980", "1", "admin8576", "2016-08-12 05:39:58", "89.181.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5981", "1", "admin8576", "2016-08-12 05:44:34", "36.39.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5982", "1", "admin8576", "2016-08-12 05:46:46", "223.205.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5983", "1", "admin8576", "2016-08-12 05:46:51", "5.36.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5984", "1", "admin8576", "2016-08-12 05:53:30", "197.89.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5985", "1", "admin8576", "2016-08-12 06:00:12", "186.138.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5986", "1", "admin8576", "2016-08-12 06:01:44", "220.126.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5987", "1", "admin8576", "2016-08-12 06:04:46", "41.202.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5988", "1", "admin8576", "2016-08-12 06:07:04", "115.66.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5989", "1", "admin8576", "2016-08-12 06:09:07", "112.204.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5990", "1", "admin8576", "2016-08-12 06:09:18", "168.1.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5991", "1", "admin8576", "2016-08-12 06:14:22", "41.87.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5992", "1", "admin8576", "2016-08-12 06:17:24", "190.56.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5993", "1", "admin8576", "2016-08-12 06:18:37", "117.214.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5994", "1", "admin8576", "2016-08-12 06:26:47", "59.177.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5995", "1", "admin8576", "2016-08-12 06:30:09", "81.44.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5996", "1", "admin8576", "2016-08-12 06:30:52", "201.170.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5997", "1", "admin8576", "2016-08-12 06:48:41", "95.21.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5998", "1", "admin8576", "2016-08-12 06:51:58", "150.242.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5999", "1", "admin8576", "2016-08-12 06:53:59", "41.218.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6000", "1", "admin8576", "2016-08-12 06:54:23", "180.191.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6001", "1", "admin8576", "2016-08-12 06:55:51", "190.207.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6002", "1", "admin8576", "2016-08-12 06:57:09", "124.106.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6003", "1", "admin8576", "2016-08-12 06:58:42", "84.186.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6004", "1", "admin8576", "2016-08-12 07:10:35", "139.218.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6005", "1", "admin8576", "2016-08-12 07:11:15", "187.151.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6006", "1", "admin8576", "2016-08-12 07:11:43", "113.130.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6007", "1", "admin8576", "2016-08-12 07:16:05", "175.205.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6008", "1", "admin8576", "2016-08-12 07:17:35", "93.84.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6009", "1", "admin8576", "2016-08-12 07:22:19", "211.129.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6010", "1", "admin8576", "2016-08-12 07:28:18", "112.198.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6011", "1", "admin8576", "2016-08-12 07:29:21", "27.34.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6012", "1", "admin8576", "2016-08-12 07:49:45", "45.115.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6013", "1", "admin8576", "2016-08-12 07:53:23", "180.244.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6014", "1", "admin8576", "2016-08-12 07:53:51", "5.156.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6015", "1", "admin8576", "2016-08-12 07:55:15", "105.98.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6016", "1", "admin8576", "2016-08-12 07:57:10", "49.32.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6017", "1", "admin8576", "2016-08-12 07:57:26", "89.216.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6018", "1", "admin8576", "2016-08-12 07:58:36", "122.15.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6019", "1", "admin8576", "2016-08-12 08:07:51", "5.29.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6020", "1", "admin8576", "2016-08-12 08:12:10", "45.248.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6021", "1", "admin8576", "2016-08-12 08:12:15", "79.101.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6022", "1", "admin8576", "2016-08-12 08:12:54", "5.22.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6023", "1", "admin8576", "2016-08-12 08:13:28", "115.161.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6024", "1", "admin8576", "2016-08-12 08:16:04", "70.112.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6025", "1", "admin8576", "2016-08-12 08:27:42", "124.104.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6026", "1", "admin8576", "2016-08-12 08:37:02", "24.1.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6027", "1", "admin8576", "2016-08-12 08:38:10", "110.139.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6028", "1", "admin8576", "2016-08-12 08:38:45", "114.143.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6029", "1", "admin8576", "2016-08-12 08:47:10", "101.255.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6030", "1", "admin8576", "2016-08-12 08:48:16", "39.37.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6031", "1", "admin8576", "2016-08-12 08:51:53", "109.93.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6032", "1", "admin8576", "2016-08-12 08:57:14", "121.97.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6033", "1", "admin8576", "2016-08-12 08:58:46", "93.171.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6034", "1", "admin8576", "2016-08-12 09:01:20", "49.32.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6035", "1", "admin8576", "2016-08-12 09:02:03", "84.252.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6036", "1", "admin8576", "2016-08-12 09:02:39", "112.201.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6037", "1", "admin8576", "2016-08-12 09:03:34", "182.58.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6038", "1", "admin8576", "2016-08-12 09:12:37", "43.229.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6039", "1", "admin8576", "2016-08-12 09:13:38", "125.17.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6040", "1", "admin8576", "2016-08-12 09:14:51", "59.180.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6041", "1", "admin8576", "2016-08-12 09:20:01", "2.51.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6042", "1", "admin8576", "2016-08-12 09:24:17", "209.140.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6043", "1", "admin8576", "2016-08-12 09:24:33", "124.105.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6044", "1", "admin8576", "2016-08-12 09:27:10", "79.106.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6045", "1", "admin8576", "2016-08-12 09:30:23", "110.21.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6046", "1", "admin8576", "2016-08-12 09:30:49", "179.105.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6047", "1", "admin8576", "2016-08-12 09:34:10", "5.206.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6048", "1", "admin8576", "2016-08-12 09:34:51", "108.251.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6049", "1", "admin8576", "2016-08-12 09:37:07", "121.176.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6050", "1", "admin8576", "2016-08-12 09:37:24", "112.204.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6051", "1", "admin8576", "2016-08-12 09:39:47", "103.12.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6052", "1", "admin8576", "2016-08-12 09:44:20", "112.209.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6053", "1", "admin8576", "2016-08-12 09:45:20", "82.10.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6054", "1", "admin8576", "2016-08-12 09:46:07", "73.153.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6055", "1", "admin8576", "2016-08-12 09:49:01", "49.206.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6056", "1", "admin8576", "2016-08-12 09:52:03", "93.140.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6057", "1", "admin8576", "2016-08-12 09:52:38", "122.254.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6058", "1", "admin8576", "2016-08-12 09:55:44", "175.100.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6059", "1", "admin8576", "2016-08-12 09:57:27", "105.225.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6060", "1", "admin8576", "2016-08-12 09:58:35", "92.209.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6061", "1", "admin8576", "2016-08-12 09:58:44", "222.235.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6062", "1", "admin8576", "2016-08-12 10:02:47", "24.112.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6063", "1", "admin8576", "2016-08-12 10:05:19", "178.152.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6064", "1", "admin8576", "2016-08-12 10:05:36", "31.168.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6065", "1", "admin8576", "2016-08-12 10:07:44", "116.68.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6066", "1", "admin8576", "2016-08-12 10:09:22", "75.166.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6067", "1", "admin8576", "2016-08-12 10:11:02", "14.52.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6068", "1", "admin8576", "2016-08-12 10:12:45", "125.22.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6069", "1", "admin8576", "2016-08-12 10:15:58", "139.190.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6070", "1", "admin8576", "2016-08-12 10:18:57", "90.0.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6071", "1", "admin8576", "2016-08-12 10:18:59", "94.118.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6072", "1", "admin8576", "2016-08-12 10:19:04", "188.135.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6073", "1", "admin8576", "2016-08-12 10:20:17", "217.11.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6074", "1", "admin8576", "2016-08-12 10:20:51", "89.210.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6075", "1", "admin8576", "2016-08-12 10:21:39", "103.232.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6076", "1", "admin8576", "2016-08-12 10:22:36", "187.207.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6077", "1", "admin8576", "2016-08-12 10:25:17", "83.101.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6078", "1", "admin8576", "2016-08-12 10:27:38", "1.223.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6079", "1", "admin8576", "2016-08-12 10:34:27", "39.40.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6080", "1", "admin8576", "2016-08-12 10:36:36", "120.63.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6081", "1", "admin8576", "2016-08-12 10:37:21", "115.124.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6082", "1", "admin8576", "2016-08-12 10:37:36", "23.114.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6083", "1", "admin8576", "2016-08-12 10:39:26", "88.246.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6084", "1", "admin8576", "2016-08-12 10:42:30", "86.137.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6085", "1", "admin8576", "2016-08-12 10:42:37", "62.245.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6086", "1", "admin8576", "2016-08-12 10:43:06", "79.106.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6087", "1", "admin8576", "2016-08-12 10:43:28", "201.196.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6088", "1", "admin8576", "2016-08-12 10:43:29", "85.154.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6089", "1", "admin8576", "2016-08-12 10:45:00", "39.46.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6090", "1", "admin8576", "2016-08-12 10:45:24", "103.55.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6091", "1", "admin8576", "2016-08-12 10:45:49", "2.86.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6092", "1", "admin8576", "2016-08-12 10:47:53", "71.191.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6093", "1", "admin8576", "2016-08-12 10:48:46", "119.2.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6094", "1", "admin8576", "2016-08-12 10:53:38", "180.149.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6095", "1", "admin8576", "2016-08-12 10:55:40", "203.215.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6096", "1", "admin8576", "2016-08-12 10:57:52", "93.117.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6097", "1", "admin8576", "2016-08-12 11:00:16", "39.63.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6098", "1", "admin8576", "2016-08-12 11:02:16", "27.89.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6099", "1", "admin8576", "2016-08-12 11:09:56", "91.206.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6100", "1", "admin8576", "2016-08-12 11:13:57", "88.128.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6101", "1", "admin8576", "2016-08-12 11:17:31", "115.134.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6102", "1", "admin8576", "2016-08-12 11:19:59", "202.131.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6103", "1", "admin8576", "2016-08-12 11:23:34", "105.186.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6104", "1", "admin8576", "2016-08-12 11:25:20", "91.240.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6105", "1", "admin8576", "2016-08-12 11:27:51", "117.248.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6106", "1", "admin8576", "2016-08-12 11:33:14", "81.82.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6107", "1", "admin8576", "2016-08-12 11:34:34", "49.38.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6108", "1", "admin8576", "2016-08-12 11:35:43", "183.83.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6109", "1", "admin8576", "2016-08-12 11:36:15", "31.216.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6110", "1", "admin8576", "2016-08-12 11:39:10", "43.247.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6111", "1", "admin8576", "2016-08-12 11:45:48", "196.201.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6112", "1", "admin8576", "2016-08-12 11:49:10", "112.133.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6113", "1", "admin8576", "2016-08-12 11:49:21", "83.79.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6114", "1", "admin8576", "2016-08-12 11:52:28", "203.30.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6115", "1", "admin8576", "2016-08-12 11:55:37", "124.125.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6116", "1", "admin8576", "2016-08-12 11:55:52", "103.39.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6117", "1", "admin8576", "2016-08-12 11:58:43", "178.222.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6118", "1", "admin8576", "2016-08-12 12:00:00", "5.22.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6119", "1", "admin8576", "2016-08-12 12:00:46", "51.6.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6120", "1", "admin8576", "2016-08-12 12:02:24", "123.252.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6121", "1", "admin8576", "2016-08-12 12:03:21", "80.100.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6122", "1", "admin8576", "2016-08-12 12:05:15", "178.253.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6123", "1", "admin8576", "2016-08-12 12:08:30", "188.211.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6124", "1", "admin8576", "2016-08-12 12:09:14", "41.250.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6125", "1", "admin8576", "2016-08-12 12:11:45", "114.143.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6126", "1", "admin8576", "2016-08-12 12:12:27", "185.66.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6127", "1", "admin8576", "2016-08-12 12:15:41", "87.6.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6128", "1", "admin8576", "2016-08-12 12:18:38", "41.222.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6129", "1", "admin8576", "2016-08-12 12:19:50", "183.83.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6130", "1", "admin8576", "2016-08-12 12:21:57", "197.149.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6131", "1", "admin8576", "2016-08-12 12:23:12", "213.122.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6132", "1", "admin8576", "2016-08-12 12:24:15", "59.100.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6133", "1", "admin8576", "2016-08-12 12:24:54", "111.119.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6134", "1", "admin8576", "2016-08-12 12:28:20", "210.89.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6135", "1", "admin8576", "2016-08-12 12:29:28", "41.100.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6136", "1", "admin8576", "2016-08-12 12:32:46", "78.173.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6137", "1", "admin8576", "2016-08-12 12:36:18", "188.27.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6138", "1", "admin8576", "2016-08-12 12:37:55", "84.194.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6139", "1", "admin8576", "2016-08-12 12:41:23", "36.79.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6140", "1", "admin8576", "2016-08-12 12:41:38", "186.109.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6141", "1", "admin8576", "2016-08-12 12:44:41", "109.199.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6142", "1", "admin8576", "2016-08-12 12:52:49", "76.73.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6143", "1", "admin8576", "2016-08-12 12:54:32", "108.61.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6144", "1", "admin8576", "2016-08-12 12:56:32", "188.252.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6145", "1", "admin8576", "2016-08-12 12:58:59", "95.18.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6146", "1", "admin8576", "2016-08-12 13:00:32", "91.191.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6147", "1", "admin8576", "2016-08-12 13:10:44", "89.181.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6148", "1", "admin8576", "2016-08-12 13:12:42", "99.239.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6149", "1", "admin8576", "2016-08-12 13:13:59", "78.172.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6150", "1", "admin8576", "2016-08-12 13:14:15", "101.191.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6151", "1", "admin8576", "2016-08-12 13:15:08", "59.180.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6152", "1", "admin8576", "2016-08-12 13:15:33", "78.57.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6153", "1", "admin8576", "2016-08-12 13:19:38", "171.4.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6154", "1", "admin8576", "2016-08-12 13:20:51", "179.53.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6155", "1", "admin8576", "2016-08-12 13:21:46", "76.173.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6156", "1", "admin8576", "2016-08-12 13:25:50", "1.22.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6157", "1", "admin8576", "2016-08-12 13:26:50", "213.57.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6158", "1", "admin8576", "2016-08-12 13:30:47", "182.48.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6159", "1", "admin8576", "2016-08-12 13:31:21", "59.177.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6160", "1", "admin8576", "2016-08-12 13:34:29", "93.115.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6161", "1", "admin8576", "2016-08-12 13:34:59", "183.88.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6162", "1", "admin8576", "2016-08-12 13:35:03", "195.154.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6163", "1", "admin8576", "2016-08-12 13:36:18", "94.174.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6164", "1", "admin8576", "2016-08-12 13:37:40", "172.196.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6165", "1", "admin8576", "2016-08-12 13:42:00", "121.223.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6166", "1", "admin8576", "2016-08-12 13:42:58", "175.143.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6167", "1", "admin8576", "2016-08-12 13:44:10", "110.44.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6168", "1", "admin8576", "2016-08-12 13:49:11", "183.87.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6169", "1", "admin8576", "2016-08-12 13:53:13", "213.253.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6170", "1", "admin8576", "2016-08-12 13:56:17", "130.225.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6171", "1", "admin8576", "2016-08-12 13:58:39", "103.255.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6172", "1", "admin8576", "2016-08-12 13:59:17", "183.97.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6173", "1", "admin8576", "2016-08-12 14:02:54", "192.168.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6174", "1", "admin8576", "2016-08-12 14:04:50", "90.194.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6175", "1", "admin8576", "2016-08-12 14:04:51", "124.40.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6176", "1", "admin8576", "2016-08-12 14:07:08", "117.242.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6177", "1", "admin8576", "2016-08-12 14:08:38", "89.115.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6178", "1", "admin8576", "2016-08-12 14:12:40", "85.245.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6179", "1", "admin8576", "2016-08-12 14:16:24", "89.231.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6180", "1", "admin8576", "2016-08-12 14:21:01", "80.237.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6181", "1", "admin8576", "2016-08-12 14:25:53", "79.7.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6182", "1", "admin8576", "2016-08-12 14:29:49", "151.73.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6183", "1", "admin8576", "2016-08-12 14:31:17", "1.22.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6184", "1", "admin8576", "2016-08-12 14:33:24", "110.174.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6185", "1", "admin8576", "2016-08-12 14:35:03", "46.129.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6186", "1", "admin8576", "2016-08-12 14:37:10", "117.201.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6187", "1", "admin8576", "2016-08-12 14:37:18", "130.105.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6188", "1", "admin8576", "2016-08-12 14:37:57", "67.193.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6189", "1", "admin8576", "2016-08-12 14:38:39", "176.184.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6190", "1", "admin8576", "2016-08-12 14:41:38", "84.212.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6191", "1", "admin8576", "2016-08-12 14:42:38", "49.32.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6192", "1", "admin8576", "2016-08-12 14:44:55", "101.160.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6193", "1", "admin8576", "2016-08-12 14:46:23", "103.54.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6194", "1", "admin8576", "2016-08-12 14:47:23", "135.23.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6195", "1", "admin8576", "2016-08-12 14:48:37", "154.126.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6196", "1", "admin8576", "2016-08-12 14:51:39", "80.8.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6197", "1", "admin8576", "2016-08-12 14:53:02", "2.249.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6198", "1", "admin8576", "2016-08-12 14:53:33", "85.121.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6199", "1", "admin8576", "2016-08-12 14:53:48", "203.184.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6200", "1", "admin8576", "2016-08-12 14:57:01", "190.202.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6201", "1", "admin8576", "2016-08-12 15:04:34", "162.238.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6202", "1", "admin8576", "2016-08-12 15:06:54", "213.177.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6203", "1", "admin8576", "2016-08-12 15:10:13", "119.153.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6204", "1", "admin8576", "2016-08-12 15:10:47", "178.148.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6205", "1", "admin8576", "2016-08-12 15:13:18", "181.49.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6206", "1", "admin8576", "2016-08-12 15:20:05", "39.38.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6207", "1", "admin8576", "2016-08-12 15:21:20", "78.0.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6208", "1", "admin8576", "2016-08-12 15:24:22", "73.196.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6209", "1", "admin8576", "2016-08-12 15:25:04", "82.244.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6210", "1", "admin8576", "2016-08-12 15:25:49", "110.168.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6211", "1", "admin8576", "2016-08-12 15:27:02", "79.101.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6212", "1", "admin8576", "2016-08-12 15:30:15", "109.92.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6213", "1", "admin8576", "2016-08-12 15:30:44", "180.190.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6214", "1", "admin8576", "2016-08-12 15:31:47", "49.32.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6215", "1", "admin8576", "2016-08-12 15:32:02", "77.54.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6216", "1", "admin8576", "2016-08-12 15:33:02", "31.46.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6217", "1", "admin8576", "2016-08-12 15:34:43", "180.246.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6218", "1", "admin8576", "2016-08-12 15:35:29", "78.150.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6219", "1", "admin8576", "2016-08-12 15:35:56", "103.48.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6220", "1", "admin8576", "2016-08-12 15:36:37", "123.2.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6221", "1", "admin8576", "2016-08-12 15:38:24", "177.98.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6222", "1", "admin8576", "2016-08-12 15:38:44", "197.226.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6223", "1", "admin8576", "2016-08-12 15:38:56", "139.218.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6224", "1", "admin8576", "2016-08-12 15:39:31", "213.122.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6225", "1", "admin8576", "2016-08-12 15:41:07", "186.228.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6226", "1", "admin8576", "2016-08-12 15:44:39", "105.158.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6227", "1", "admin8576", "2016-08-12 15:44:40", "178.0.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6228", "1", "admin8576", "2016-08-12 15:46:18", "190.216.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6229", "1", "admin8576", "2016-08-12 15:47:48", "103.225.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6230", "1", "admin8576", "2016-08-12 15:48:20", "217.120.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6231", "1", "admin8576", "2016-08-12 15:48:55", "103.225.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6232", "1", "admin8576", "2016-08-12 15:50:05", "65.184.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6233", "1", "admin8576", "2016-08-12 15:50:55", "49.145.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6234", "1", "admin8576", "2016-08-12 15:51:37", "82.74.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6235", "1", "admin8576", "2016-08-12 15:52:00", "49.177.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6236", "1", "admin8576", "2016-08-12 15:54:42", "213.22.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6237", "1", "admin8576", "2016-08-12 15:56:08", "174.107.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6238", "1", "admin8576", "2016-08-12 15:58:50", "112.173.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6239", "1", "admin8576", "2016-08-12 15:58:57", "203.173.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6240", "1", "admin8576", "2016-08-12 15:59:33", "37.228.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6241", "1", "admin8576", "2016-08-12 16:00:28", "1.186.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6242", "1", "admin8576", "2016-08-12 16:01:11", "185.66.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6243", "1", "admin8576", "2016-08-12 16:03:00", "202.156.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6244", "1", "admin8576", "2016-08-12 16:04:57", "72.137.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6245", "1", "admin8576", "2016-08-12 16:05:22", "201.241.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6246", "1", "admin8576", "2016-08-12 16:06:22", "77.46.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6247", "1", "admin8576", "2016-08-12 16:08:10", "122.177.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6248", "1", "admin8576", "2016-08-12 16:12:53", "76.110.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6249", "1", "admin8576", "2016-08-12 16:16:14", "194.228.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6250", "1", "admin8576", "2016-08-12 16:16:39", "79.186.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6251", "1", "admin8576", "2016-08-12 16:17:07", "90.179.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6252", "1", "admin8576", "2016-08-12 16:17:19", "191.55.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6253", "1", "admin8576", "2016-08-12 16:17:41", "103.24.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6254", "1", "admin8576", "2016-08-12 16:19:42", "109.93.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6255", "1", "admin8576", "2016-08-12 16:22:26", "188.51.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6256", "1", "admin8576", "2016-08-12 16:30:15", "176.114.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6257", "1", "admin8576", "2016-08-12 16:34:41", "213.204.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6258", "1", "admin8576", "2016-08-12 16:34:44", "39.42.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6259", "1", "admin8576", "2016-08-12 16:35:37", "77.28.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6260", "1", "admin8576", "2016-08-12 16:41:20", "201.240.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6261", "1", "admin8576", "2016-08-12 16:41:33", "112.211.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6262", "1", "admin8576", "2016-08-12 16:43:12", "123.231.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6263", "1", "admin8576", "2016-08-12 16:50:14", "109.166.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6264", "1", "admin8576", "2016-08-12 16:54:26", "84.197.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6265", "1", "admin8576", "2016-08-12 16:54:35", "178.255.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6266", "1", "admin8576", "2016-08-12 16:58:12", "201.163.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6267", "1", "admin8576", "2016-08-12 16:58:31", "72.27.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6268", "1", "admin8576", "2016-08-12 17:00:52", "113.159.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6269", "1", "admin8576", "2016-08-12 17:01:25", "185.149.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6270", "1", "admin8576", "2016-08-12 17:06:07", "109.103.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6271", "1", "admin8576", "2016-08-12 17:06:25", "78.1.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6272", "1", "admin8576", "2016-08-12 17:06:54", "112.149.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6273", "1", "admin8576", "2016-08-12 17:10:16", "173.56.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6274", "1", "admin8576", "2016-08-12 17:10:45", "109.78.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6275", "1", "admin8576", "2016-08-12 17:11:06", "91.178.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6276", "1", "admin8576", "2016-08-12 17:13:05", "202.56.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6277", "1", "admin8576", "2016-08-12 17:15:19", "124.83.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6278", "1", "admin8576", "2016-08-12 17:16:12", "103.56.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6279", "1", "admin8576", "2016-08-12 17:16:23", "180.9.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6280", "1", "admin8576", "2016-08-12 17:16:28", "211.110.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6281", "1", "admin8576", "2016-08-12 17:16:42", "51.36.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6282", "1", "admin8576", "2016-08-12 17:16:59", "180.191.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6283", "1", "admin8576", "2016-08-12 17:17:13", "117.217.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6284", "1", "admin8576", "2016-08-12 17:21:18", "93.37.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6285", "1", "admin8576", "2016-08-12 17:22:39", "87.115.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6286", "1", "admin8576", "2016-08-12 17:24:15", "76.91.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6287", "1", "admin8576", "2016-08-12 17:24:26", "119.40.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6288", "1", "admin8576", "2016-08-12 17:25:33", "2.25.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6289", "1", "admin8576", "2016-08-12 17:27:01", "79.53.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6290", "1", "admin8576", "2016-08-12 17:27:22", "62.57.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6291", "1", "admin8576", "2016-08-12 17:28:34", "2.50.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6292", "1", "admin8576", "2016-08-12 17:28:40", "81.225.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6293", "1", "admin8576", "2016-08-12 17:32:48", "103.252.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6294", "1", "admin8576", "2016-08-12 17:32:53", "190.115.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6295", "1", "admin8576", "2016-08-12 17:34:16", "173.18.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6296", "1", "admin8576", "2016-08-12 17:35:19", "89.2.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6297", "1", "admin8576", "2016-08-12 17:36:14", "5.197.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6298", "1", "admin8576", "2016-08-12 17:37:11", "124.106.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6299", "1", "admin8576", "2016-08-12 17:39:11", "81.248.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6300", "1", "admin8576", "2016-08-12 17:39:47", "91.137.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6301", "1", "admin8576", "2016-08-12 17:41:49", "78.159.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6302", "1", "admin8576", "2016-08-12 17:42:09", "79.112.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6303", "1", "admin8576", "2016-08-12 17:43:28", "122.15.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6304", "1", "admin8576", "2016-08-12 17:47:00", "197.39.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6305", "1", "admin8576", "2016-08-12 17:47:44", "95.14.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6306", "1", "admin8576", "2016-08-12 17:48:34", "200.93.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6307", "1", "admin8576", "2016-08-12 17:50:06", "110.78.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6308", "1", "admin8576", "2016-08-12 17:50:15", "178.222.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6309", "1", "admin8576", "2016-08-12 17:54:16", "46.109.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6310", "1", "admin8576", "2016-08-12 17:58:15", "192.168.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6311", "1", "admin8576", "2016-08-12 17:59:52", "191.81.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6312", "1", "admin8576", "2016-08-12 18:00:07", "176.63.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6313", "1", "admin8576", "2016-08-12 18:02:20", "125.63.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6314", "1", "admin8576", "2016-08-12 18:02:46", "83.47.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6315", "1", "admin8576", "2016-08-12 18:03:47", "193.77.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6316", "1", "admin8576", "2016-08-12 18:04:33", "112.201.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6317", "1", "admin8576", "2016-08-12 18:09:13", "119.153.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6318", "1", "admin8576", "2016-08-12 18:09:14", "171.49.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6319", "1", "admin8576", "2016-08-12 18:09:20", "41.210.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6320", "1", "admin8576", "2016-08-12 18:09:21", "72.53.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6321", "1", "admin8576", "2016-08-12 18:10:09", "14.37.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6322", "1", "admin8576", "2016-08-12 18:14:15", "91.195.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6323", "1", "admin8576", "2016-08-12 18:14:31", "88.212.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6324", "1", "admin8576", "2016-08-12 18:15:19", "182.64.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6325", "1", "admin8576", "2016-08-12 18:15:48", "105.157.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6326", "1", "admin8576", "2016-08-12 18:15:57", "58.179.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6327", "1", "admin8576", "2016-08-12 18:18:48", "173.44.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6328", "1", "admin8576", "2016-08-12 18:19:43", "203.88.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6329", "1", "admin8576", "2016-08-12 18:24:40", "103.255.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6330", "1", "admin8576", "2016-08-12 18:29:36", "182.183.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6331", "1", "admin8576", "2016-08-12 18:30:28", "92.80.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6332", "1", "admin8576", "2016-08-12 18:31:37", "99.111.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6333", "1", "admin8576", "2016-08-12 18:34:46", "99.115.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6334", "1", "admin8576", "2016-08-12 18:35:32", "89.176.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6335", "1", "admin8576", "2016-08-12 18:38:00", "82.53.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6336", "1", "admin8576", "2016-08-12 18:38:00", "31.216.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6337", "1", "admin8576", "2016-08-12 18:39:02", "125.25.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6338", "1", "admin8576", "2016-08-12 18:39:37", "60.50.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6339", "1", "admin8576", "2016-08-12 18:41:55", "188.223.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6340", "1", "admin8576", "2016-08-12 18:42:30", "82.118.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6341", "1", "admin8576", "2016-08-12 18:46:11", "185.19.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6342", "1", "admin8576", "2016-08-12 18:47:25", "27.7.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6343", "1", "admin8576", "2016-08-12 18:49:22", "198.91.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6344", "1", "admin8576", "2016-08-12 18:49:27", "181.90.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6345", "1", "admin8576", "2016-08-12 18:56:32", "63.148.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6346", "1", "admin8576", "2016-08-12 19:00:25", "5.22.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6347", "1", "admin8576", "2016-08-12 19:04:16", "213.89.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6348", "1", "admin8576", "2016-08-12 19:05:36", "212.178.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6349", "1", "admin8576", "2016-08-12 19:06:24", "179.192.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6350", "1", "admin8576", "2016-08-12 19:06:57", "24.122.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6351", "1", "admin8576", "2016-08-12 19:08:31", "41.251.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6352", "1", "admin8576", "2016-08-12 19:09:35", "2.50.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6353", "1", "admin8576", "2016-08-12 19:10:52", "124.44.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6354", "1", "admin8576", "2016-08-12 19:14:00", "41.141.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6355", "1", "admin8576", "2016-08-12 19:22:14", "112.133.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6356", "1", "admin8576", "2016-08-12 19:23:16", "99.90.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6357", "1", "admin8576", "2016-08-12 19:24:31", "78.175.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6358", "1", "admin8576", "2016-08-12 19:27:09", "117.199.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6359", "1", "admin8576", "2016-08-12 19:28:14", "130.105.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6360", "1", "admin8576", "2016-08-12 19:30:28", "119.17.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6361", "1", "admin8576", "2016-08-12 19:30:58", "156.211.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6362", "1", "admin8576", "2016-08-12 19:31:25", "58.178.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6363", "1", "admin8576", "2016-08-12 19:31:56", "115.96.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6364", "1", "admin8576", "2016-08-12 19:32:15", "219.92.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6365", "1", "admin8576", "2016-08-12 19:36:57", "73.253.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6366", "1", "admin8576", "2016-08-12 19:37:34", "192.116.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6367", "1", "admin8576", "2016-08-12 19:38:11", "27.114.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6368", "1", "admin8576", "2016-08-12 19:38:43", "111.94.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6369", "1", "admin8576", "2016-08-12 19:41:58", "212.199.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6370", "1", "admin8576", "2016-08-12 19:43:28", "94.96.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6371", "1", "admin8576", "2016-08-12 19:43:48", "128.79.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6372", "1", "admin8576", "2016-08-12 19:43:52", "103.212.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6373", "1", "admin8576", "2016-08-12 19:43:55", "74.58.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6374", "1", "admin8576", "2016-08-12 19:44:52", "112.207.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6375", "1", "admin8576", "2016-08-12 19:47:18", "169.1.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6376", "1", "admin8576", "2016-08-12 19:51:22", "90.28.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6377", "1", "admin8576", "2016-08-12 19:52:26", "103.19.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6378", "1", "admin8576", "2016-08-12 19:52:38", "77.139.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6379", "1", "admin8576", "2016-08-12 19:54:19", "179.98.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6380", "1", "admin8576", "2016-08-12 19:55:23", "24.114.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6381", "1", "admin8576", "2016-08-12 19:55:46", "103.215.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6382", "1", "admin8576", "2016-08-12 19:59:30", "85.245.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6383", "1", "admin8576", "2016-08-12 19:59:40", "101.162.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6384", "1", "admin8576", "2016-08-12 20:00:02", "178.148.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6385", "1", "admin8576", "2016-08-12 20:00:38", "188.187.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6386", "1", "admin8576", "2016-08-12 20:08:47", "121.157.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6387", "1", "admin8576", "2016-08-12 20:11:06", "188.50.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6388", "1", "admin8576", "2016-08-12 20:11:36", "179.4.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6389", "1", "admin8576", "2016-08-12 20:11:41", "93.143.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6390", "1", "admin8576", "2016-08-12 20:11:47", "202.136.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6391", "1", "admin8576", "2016-08-12 20:14:26", "103.25.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6392", "1", "admin8576", "2016-08-12 20:15:59", "212.26.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6393", "1", "admin8576", "2016-08-12 20:16:23", "104.157.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6394", "1", "admin8576", "2016-08-12 20:20:56", "45.56.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6395", "1", "admin8576", "2016-08-12 20:22:14", "173.239.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6396", "1", "admin8576", "2016-08-12 20:32:38", "49.207.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6397", "1", "admin8576", "2016-08-12 20:33:51", "151.68.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6398", "1", "admin8576", "2016-08-12 20:37:34", "108.88.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6399", "1", "admin8576", "2016-08-12 20:39:05", "90.65.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6400", "1", "admin8576", "2016-08-12 20:40:14", "95.244.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6401", "1", "admin8576", "2016-08-12 20:40:48", "89.176.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6402", "1", "admin8576", "2016-08-12 20:41:12", "161.111.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6403", "1", "admin8576", "2016-08-12 20:45:57", "64.237.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6404", "1", "admin8576", "2016-08-12 21:04:51", "185.63.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6405", "1", "admin8576", "2016-08-12 21:04:56", "24.135.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6406", "1", "admin8576", "2016-08-12 21:05:32", "83.203.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6407", "1", "admin8576", "2016-08-12 21:14:39", "185.113.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6408", "1", "admin8576", "2016-08-12 21:14:42", "125.18.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6409", "1", "admin8576", "2016-08-12 21:15:19", "46.99.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6410", "1", "admin8576", "2016-08-12 21:15:24", "191.183.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6411", "1", "admin8576", "2016-08-12 21:17:30", "180.9.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6412", "1", "admin8576", "2016-08-12 21:17:46", "121.122.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6413", "1", "admin8576", "2016-08-12 21:18:01", "94.193.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6414", "1", "admin8576", "2016-08-12 21:18:55", "139.255.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6415", "1", "admin8576", "2016-08-12 21:19:43", "95.102.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6416", "1", "admin8576", "2016-08-12 21:25:24", "193.179.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6417", "1", "admin8576", "2016-08-12 21:30:29", "1.186.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6418", "1", "admin8576", "2016-08-12 21:33:15", "45.123.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6419", "1", "admin8576", "2016-08-12 21:39:35", "88.247.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6420", "1", "admin8576", "2016-08-12 21:44:17", "85.197.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6421", "1", "admin8576", "2016-08-12 21:45:27", "93.142.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6422", "1", "admin8576", "2016-08-12 21:46:05", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6423", "1", "admin8576", "2016-08-12 21:46:40", "43.230.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6424", "1", "admin8576", "2016-08-12 21:47:56", "91.234.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6425", "1", "admin8576", "2016-08-12 21:54:16", "31.223.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6426", "1", "admin8576", "2016-08-12 21:58:26", "2.31.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6427", "1", "admin8576", "2016-08-12 21:59:46", "50.202.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6428", "1", "admin8576", "2016-08-12 22:00:16", "37.228.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6429", "1", "admin8576", "2016-08-12 22:03:44", "197.0.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6430", "1", "admin8576", "2016-08-12 22:06:19", "41.226.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6431", "1", "admin8576", "2016-08-12 22:06:20", "169.1.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6432", "1", "admin8576", "2016-08-12 22:08:12", "24.77.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6433", "1", "admin8576", "2016-08-12 22:08:38", "84.10.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6434", "1", "admin8576", "2016-08-12 22:08:42", "86.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6435", "1", "admin8576", "2016-08-12 22:15:45", "80.60.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6436", "1", "admin8576", "2016-08-12 22:16:11", "71.89.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6437", "1", "admin8576", "2016-08-12 22:16:23", "2.30.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6438", "1", "admin8576", "2016-08-12 22:16:32", "212.127.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6439", "1", "admin8576", "2016-08-12 22:18:13", "154.127.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6440", "1", "admin8576", "2016-08-12 22:19:49", "89.138.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6441", "1", "admin8576", "2016-08-12 22:19:50", "176.43.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6442", "1", "admin8576", "2016-08-12 22:29:04", "46.10.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6443", "1", "admin8576", "2016-08-12 22:30:10", "80.87.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6444", "1", "admin8576", "2016-08-12 22:31:22", "89.248.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6445", "1", "admin8576", "2016-08-12 22:36:06", "62.194.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6446", "1", "admin8576", "2016-08-12 22:36:12", "174.1.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6447", "1", "admin8576", "2016-08-12 22:39:42", "31.27.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6448", "1", "admin8576", "2016-08-12 22:39:49", "79.33.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6449", "1", "admin8576", "2016-08-12 22:41:06", "46.152.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6450", "1", "admin8576", "2016-08-12 22:43:25", "79.179.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6451", "1", "admin8576", "2016-08-12 22:43:35", "50.170.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6452", "1", "admin8576", "2016-08-12 22:43:48", "92.108.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6453", "1", "admin8576", "2016-08-12 22:44:45", "173.166.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6454", "1", "admin8576", "2016-08-12 22:44:46", "198.84.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6455", "1", "admin8576", "2016-08-12 22:46:29", "24.147.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6456", "1", "admin8576", "2016-08-12 22:46:33", "10.5.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6457", "1", "admin8576", "2016-08-12 22:47:29", "173.76.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6458", "1", "admin8576", "2016-08-12 22:47:35", "98.202.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6459", "1", "admin8576", "2016-08-12 22:49:19", "82.221.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6460", "1", "admin8576", "2016-08-12 22:49:35", "186.69.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6461", "1", "admin8576", "2016-08-12 22:51:54", "71.47.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6462", "1", "admin8576", "2016-08-12 22:52:43", "90.224.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6463", "1", "admin8576", "2016-08-12 22:52:52", "77.250.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6464", "1", "admin8576", "2016-08-12 22:53:05", "89.176.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6465", "1", "admin8576", "2016-08-12 22:53:36", "62.90.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6466", "1", "admin8576", "2016-08-12 22:54:24", "200.89.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6467", "1", "admin8576", "2016-08-12 22:56:43", "94.174.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6468", "1", "admin8576", "2016-08-12 22:58:33", "201.217.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6469", "1", "admin8576", "2016-08-12 22:59:45", "50.198.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6470", "1", "admin8576", "2016-08-12 23:01:03", "58.93.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6471", "1", "admin8576", "2016-08-12 23:02:40", "168.187.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6472", "1", "admin8576", "2016-08-12 23:04:06", "217.79.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6473", "1", "admin8576", "2016-08-12 23:05:04", "151.227.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6474", "1", "admin8576", "2016-08-12 23:07:22", "73.21.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6475", "1", "admin8576", "2016-08-12 23:07:40", "92.9.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6476", "1", "admin8576", "2016-08-12 23:09:38", "197.53.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6477", "1", "admin8576", "2016-08-12 23:10:08", "105.229.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6478", "1", "admin8576", "2016-08-12 23:11:32", "109.93.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6479", "1", "admin8576", "2016-08-12 23:11:37", "179.32.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6480", "1", "admin8576", "2016-08-12 23:11:46", "68.65.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6481", "1", "admin8576", "2016-08-12 23:12:10", "49.149.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6482", "1", "admin8576", "2016-08-12 23:12:20", "31.176.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6483", "1", "admin8576", "2016-08-12 23:13:03", "109.67.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6484", "1", "admin8576", "2016-08-12 23:13:22", "45.64.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6485", "1", "admin8576", "2016-08-12 23:14:20", "212.117.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6486", "1", "admin8576", "2016-08-12 23:15:49", "99.90.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6487", "1", "admin8576", "2016-08-12 23:17:19", "41.150.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6488", "1", "admin8576", "2016-08-12 23:17:30", "109.81.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6489", "1", "admin8576", "2016-08-12 23:18:30", "79.154.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6490", "1", "admin8576", "2016-08-12 23:18:31", "78.180.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6491", "1", "admin8576", "2016-08-12 23:19:49", "177.17.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6492", "1", "admin8576", "2016-08-12 23:19:56", "49.150.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6493", "1", "admin8576", "2016-08-12 23:21:08", "115.66.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6494", "1", "admin8576", "2016-08-12 23:21:28", "41.96.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6495", "1", "admin8576", "2016-08-12 23:22:29", "197.48.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6496", "1", "admin8576", "2016-08-12 23:24:37", "176.249.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6497", "1", "admin8576", "2016-08-12 23:26:06", "41.66.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6498", "1", "admin8576", "2016-08-12 23:27:53", "103.212.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6499", "1", "admin8576", "2016-08-12 23:30:42", "49.32.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6500", "1", "admin8576", "2016-08-12 23:32:19", "178.37.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6501", "1", "admin8576", "2016-08-12 23:33:15", "130.105.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6502", "1", "admin8576", "2016-08-12 23:33:51", "201.4.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6503", "1", "admin8576", "2016-08-12 23:35:17", "105.227.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6504", "1", "admin8576", "2016-08-12 23:36:15", "135.23.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6505", "1", "admin8576", "2016-08-12 23:40:05", "178.23.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6506", "1", "admin8576", "2016-08-12 23:41:56", "95.107.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6507", "1", "admin8576", "2016-08-12 23:43:12", "41.45.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6508", "1", "admin8576", "2016-08-12 23:45:19", "89.173.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6509", "1", "admin8576", "2016-08-12 23:45:47", "178.222.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6510", "1", "admin8576", "2016-08-12 23:46:11", "90.74.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6511", "1", "admin8576", "2016-08-12 23:47:48", "79.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6512", "1", "admin8576", "2016-08-12 23:49:02", "37.142.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6513", "1", "admin8576", "2016-08-12 23:51:36", "111.88.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6514", "1", "admin8576", "2016-08-12 23:54:13", "41.141.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6515", "1", "admin8576", "2016-08-12 23:54:50", "68.70.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6516", "1", "admin8576", "2016-08-12 23:55:04", "213.125.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6517", "1", "admin8576", "2016-08-12 23:55:17", "24.142.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6518", "1", "admin8576", "2016-08-12 23:56:31", "77.125.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6519", "1", "admin8576", "2016-08-12 23:57:41", "192.168.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6520", "1", "admin8576", "2016-08-13 00:00:33", "93.136.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6521", "1", "admin8576", "2016-08-13 00:01:49", "186.179.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6522", "1", "admin8576", "2016-08-13 00:01:55", "86.183.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6523", "1", "admin8576", "2016-08-13 00:03:03", "113.162.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6524", "1", "admin8576", "2016-08-13 00:03:42", "72.223.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6525", "1", "admin8576", "2016-08-13 00:04:33", "110.175.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6526", "1", "admin8576", "2016-08-13 00:04:41", "85.228.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6527", "1", "admin8576", "2016-08-13 00:05:57", "5.146.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6528", "1", "admin8576", "2016-08-13 00:06:05", "194.1.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6529", "1", "admin8576", "2016-08-13 00:06:07", "89.211.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6530", "1", "admin8576", "2016-08-13 00:06:58", "79.114.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6531", "1", "admin8576", "2016-08-13 00:07:35", "219.91.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6532", "1", "admin8576", "2016-08-13 00:08:31", "73.196.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6533", "1", "admin8576", "2016-08-13 00:10:47", "93.168.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6534", "1", "admin8576", "2016-08-13 00:10:52", "111.69.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6535", "1", "admin8576", "2016-08-13 00:10:57", "86.82.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6536", "1", "admin8576", "2016-08-13 00:10:59", "37.105.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6537", "1", "admin8576", "2016-08-13 00:12:14", "41.33.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6538", "1", "admin8576", "2016-08-13 00:12:49", "41.250.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6539", "1", "admin8576", "2016-08-13 00:13:05", "173.75.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6540", "1", "admin8576", "2016-08-13 00:13:28", "41.230.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6541", "1", "admin8576", "2016-08-13 00:13:33", "184.89.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6542", "1", "admin8576", "2016-08-13 00:24:28", "89.100.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6543", "1", "admin8576", "2016-08-13 00:28:16", "78.200.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6544", "1", "admin8576", "2016-08-13 00:28:26", "69.4.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6545", "1", "admin8576", "2016-08-13 00:29:24", "179.208.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6546", "1", "admin8576", "2016-08-13 00:29:36", "37.186.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6547", "1", "admin8576", "2016-08-13 00:30:09", "77.134.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6548", "1", "admin8576", "2016-08-13 00:31:12", "201.227.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6549", "1", "admin8576", "2016-08-13 00:38:58", "189.63.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6550", "1", "admin8576", "2016-08-13 00:43:14", "176.42.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6551", "1", "admin8576", "2016-08-13 00:45:49", "190.191.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6552", "1", "admin8576", "2016-08-13 00:49:12", "37.228.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6553", "1", "admin8576", "2016-08-13 00:50:29", "138.94.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6554", "1", "admin8576", "2016-08-13 00:52:04", "189.236.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6555", "1", "admin8576", "2016-08-13 01:01:33", "209.126.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6556", "1", "admin8576", "2016-08-13 01:01:47", "93.99.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6557", "1", "admin8576", "2016-08-13 01:03:59", "186.77.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6558", "1", "admin8576", "2016-08-13 01:05:27", "50.202.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6559", "1", "admin8576", "2016-08-13 01:06:10", "14.201.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6560", "1", "admin8576", "2016-08-13 01:09:08", "105.189.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6561", "1", "admin8576", "2016-08-13 01:10:02", "103.21.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6562", "1", "admin8576", "2016-08-13 01:11:07", "81.100.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6563", "1", "admin8576", "2016-08-13 01:12:17", "77.148.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6564", "1", "admin8576", "2016-08-13 01:15:05", "51.36.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6565", "1", "admin8576", "2016-08-13 01:16:59", "51.179.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6566", "1", "admin8576", "2016-08-13 01:22:33", "197.251.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6567", "1", "admin8576", "2016-08-13 01:25:43", "88.231.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6568", "1", "admin8576", "2016-08-13 01:26:14", "93.137.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6569", "1", "admin8576", "2016-08-13 01:27:26", "213.162.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6570", "1", "admin8576", "2016-08-13 01:28:21", "190.255.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6571", "1", "admin8576", "2016-08-13 01:28:46", "74.131.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6572", "1", "admin8576", "2016-08-13 01:29:02", "173.32.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6573", "1", "admin8576", "2016-08-13 01:35:25", "186.212.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6574", "1", "admin8576", "2016-08-13 01:40:14", "178.17.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6575", "1", "admin8576", "2016-08-13 01:40:20", "138.255.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6576", "1", "admin8576", "2016-08-13 01:41:41", "70.112.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6577", "1", "admin8576", "2016-08-13 01:43:57", "46.152.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6578", "1", "admin8576", "2016-08-13 01:50:38", "203.217.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6579", "1", "admin8576", "2016-08-13 01:51:05", "86.19.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6580", "1", "admin8576", "2016-08-13 01:53:12", "222.113.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6581", "1", "admin8576", "2016-08-13 01:57:02", "109.64.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6582", "1", "admin8576", "2016-08-13 01:57:09", "79.179.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6583", "1", "admin8576", "2016-08-13 02:02:08", "187.161.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6584", "1", "admin8576", "2016-08-13 02:03:01", "112.206.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6585", "1", "admin8576", "2016-08-13 02:03:54", "103.12.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6586", "1", "admin8576", "2016-08-13 02:05:21", "60.246.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6587", "1", "admin8576", "2016-08-13 02:11:32", "213.136.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6588", "1", "admin8576", "2016-08-13 02:11:36", "89.205.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6589", "1", "admin8576", "2016-08-13 02:15:44", "50.121.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6590", "1", "admin8576", "2016-08-13 02:16:25", "61.2.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6591", "1", "admin8576", "2016-08-13 02:17:37", "49.32.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6592", "1", "admin8576", "2016-08-13 02:18:21", "151.16.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6593", "1", "admin8576", "2016-08-13 02:18:43", "122.59.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6594", "1", "admin8576", "2016-08-13 02:19:03", "24.122.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6595", "1", "admin8576", "2016-08-13 02:24:14", "99.90.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6596", "1", "admin8576", "2016-08-13 02:25:13", "177.228.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6597", "1", "admin8576", "2016-08-13 02:25:26", "45.243.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6598", "1", "admin8576", "2016-08-13 02:26:34", "82.31.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6599", "1", "admin8576", "2016-08-13 02:27:09", "180.178.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6600", "1", "admin8576", "2016-08-13 02:28:46", "37.216.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6601", "1", "admin8576", "2016-08-13 02:29:54", "190.20.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6602", "1", "admin8576", "2016-08-13 02:31:21", "103.252.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6603", "1", "admin8576", "2016-08-13 02:34:34", "24.235.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6604", "1", "admin8576", "2016-08-13 02:37:16", "77.100.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6605", "1", "admin8576", "2016-08-13 02:39:00", "120.56.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6606", "1", "admin8576", "2016-08-13 02:39:28", "95.235.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6607", "1", "admin8576", "2016-08-13 02:39:57", "100.1.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6608", "1", "admin8576", "2016-08-13 02:42:39", "126.87.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6609", "1", "admin8576", "2016-08-13 02:43:23", "174.103.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6610", "1", "admin8576", "2016-08-13 02:43:48", "118.97.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6611", "1", "admin8576", "2016-08-13 02:51:21", "80.251.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6612", "1", "admin8576", "2016-08-13 02:51:42", "188.117.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6613", "1", "admin8576", "2016-08-13 02:52:38", "101.186.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6614", "1", "admin8576", "2016-08-13 02:53:16", "121.184.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6615", "1", "admin8576", "2016-08-13 02:53:57", "119.93.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6616", "1", "admin8576", "2016-08-13 02:54:27", "49.175.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6617", "1", "admin8576", "2016-08-13 02:55:03", "178.41.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6618", "1", "admin8576", "2016-08-13 02:55:19", "78.244.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6619", "1", "admin8576", "2016-08-13 02:59:51", "94.176.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6620", "1", "admin8576", "2016-08-13 03:03:44", "174.0.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6621", "1", "admin8576", "2016-08-13 03:07:21", "90.180.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6622", "1", "admin8576", "2016-08-13 03:08:34", "46.10.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6623", "1", "admin8576", "2016-08-13 03:09:05", "119.95.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6624", "1", "admin8576", "2016-08-13 03:09:13", "189.149.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6625", "1", "admin8576", "2016-08-13 03:10:26", "169.255.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6626", "1", "admin8576", "2016-08-13 03:14:03", "41.230.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6627", "1", "admin8576", "2016-08-13 03:16:22", "188.135.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6628", "1", "admin8576", "2016-08-13 03:19:01", "67.247.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6629", "1", "admin8576", "2016-08-13 03:19:06", "189.169.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6630", "1", "admin8576", "2016-08-13 03:19:44", "49.144.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6631", "1", "admin8576", "2016-08-13 03:20:36", "187.62.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6632", "1", "admin8576", "2016-08-13 03:20:50", "80.61.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6633", "1", "admin8576", "2016-08-13 03:21:48", "188.50.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6634", "1", "admin8576", "2016-08-13 03:22:16", "210.84.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6635", "1", "admin8576", "2016-08-13 03:23:25", "46.116.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6636", "1", "admin8576", "2016-08-13 03:26:28", "154.73.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6637", "1", "admin8576", "2016-08-13 03:27:21", "38.124.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6638", "1", "admin8576", "2016-08-13 03:28:10", "49.145.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6639", "1", "admin8576", "2016-08-13 03:28:18", "95.68.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6640", "1", "admin8576", "2016-08-13 03:28:51", "89.99.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6641", "1", "admin8576", "2016-08-13 03:29:51", "150.129.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6642", "1", "admin8576", "2016-08-13 03:37:00", "178.164.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6643", "1", "admin8576", "2016-08-13 03:37:42", "101.183.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6644", "1", "admin8576", "2016-08-13 03:39:18", "190.220.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6645", "1", "admin8576", "2016-08-13 03:40:56", "41.97.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6646", "1", "admin8576", "2016-08-13 03:41:04", "186.87.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6647", "1", "admin8576", "2016-08-13 03:43:45", "216.239.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6648", "1", "admin8576", "2016-08-13 03:44:19", "122.54.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6649", "1", "admin8576", "2016-08-13 03:46:56", "85.254.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6650", "1", "admin8576", "2016-08-13 03:47:20", "58.10.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6651", "1", "admin8576", "2016-08-13 03:49:56", "94.204.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6652", "1", "admin8576", "2016-08-13 03:50:14", "94.101.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6653", "1", "admin8576", "2016-08-13 03:51:30", "89.181.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6654", "1", "admin8576", "2016-08-13 03:54:40", "99.247.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6655", "1", "admin8576", "2016-08-13 03:56:17", "41.66.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6656", "1", "admin8576", "2016-08-13 03:57:05", "1.220.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6657", "1", "admin8576", "2016-08-13 03:58:01", "101.100.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6658", "1", "admin8576", "2016-08-13 03:59:16", "88.105.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6659", "1", "admin8576", "2016-08-13 04:05:07", "121.45.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6660", "1", "admin8576", "2016-08-13 04:06:24", "187.151.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6661", "1", "admin8576", "2016-08-13 04:08:53", "183.88.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6662", "1", "admin8576", "2016-08-13 04:10:16", "178.17.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6663", "1", "admin8576", "2016-08-13 04:10:28", "70.31.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6664", "1", "admin8576", "2016-08-13 04:10:48", "189.21.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6665", "1", "admin8576", "2016-08-13 04:10:58", "62.44.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6666", "1", "admin8576", "2016-08-13 04:11:48", "49.146.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6667", "1", "admin8576", "2016-08-13 04:14:39", "211.198.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6668", "1", "admin8576", "2016-08-13 04:15:38", "124.159.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6669", "1", "admin8576", "2016-08-13 04:15:58", "112.198.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6670", "1", "admin8576", "2016-08-13 04:16:59", "49.149.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6671", "1", "admin8576", "2016-08-13 04:18:21", "190.57.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6672", "1", "admin8576", "2016-08-13 04:21:10", "99.251.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6673", "1", "admin8576", "2016-08-13 04:21:52", "109.64.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6674", "1", "admin8576", "2016-08-13 04:22:10", "103.1.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6675", "1", "admin8576", "2016-08-13 04:26:35", "212.158.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6676", "1", "admin8576", "2016-08-13 04:27:30", "186.247.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6677", "1", "admin8576", "2016-08-13 04:29:47", "27.123.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6678", "1", "admin8576", "2016-08-13 04:30:24", "82.173.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6679", "1", "admin8576", "2016-08-13 04:31:58", "69.157.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6680", "1", "admin8576", "2016-08-13 04:32:22", "120.61.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6681", "1", "admin8576", "2016-08-13 04:37:29", "154.242.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6682", "1", "admin8576", "2016-08-13 04:39:09", "63.140.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6683", "1", "admin8576", "2016-08-13 04:42:13", "49.145.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6684", "1", "admin8576", "2016-08-13 04:43:18", "81.173.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6685", "1", "admin8576", "2016-08-13 04:44:45", "122.54.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6686", "1", "admin8576", "2016-08-13 04:47:20", "219.88.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6687", "1", "admin8576", "2016-08-13 04:48:30", "42.115.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6688", "1", "admin8576", "2016-08-13 04:54:13", "120.28.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6689", "1", "admin8576", "2016-08-13 04:54:57", "49.144.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6690", "1", "admin8576", "2016-08-13 04:56:10", "75.131.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6691", "1", "admin8576", "2016-08-13 04:58:31", "91.140.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6692", "1", "admin8576", "2016-08-13 04:59:36", "213.172.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6693", "1", "admin8576", "2016-08-13 05:00:41", "172.111.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6694", "1", "admin8576", "2016-08-13 05:01:05", "122.53.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6695", "1", "admin8576", "2016-08-13 05:03:38", "180.9.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6696", "1", "admin8576", "2016-08-13 05:04:20", "198.71.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6697", "1", "admin8576", "2016-08-13 05:04:46", "179.53.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6698", "1", "admin8576", "2016-08-13 05:06:18", "82.147.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6699", "1", "admin8576", "2016-08-13 05:10:47", "60.52.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6700", "1", "admin8576", "2016-08-13 05:11:23", "116.88.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6701", "1", "admin8576", "2016-08-13 05:15:12", "150.107.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6702", "1", "admin8576", "2016-08-13 05:15:53", "122.3.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6703", "1", "admin8576", "2016-08-13 05:16:24", "79.179.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6704", "1", "admin8576", "2016-08-13 05:17:41", "39.53.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6705", "1", "admin8576", "2016-08-13 05:18:48", "108.59.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6706", "1", "admin8576", "2016-08-13 05:24:55", "98.207.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6707", "1", "admin8576", "2016-08-13 05:26:18", "210.14.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6708", "1", "admin8576", "2016-08-13 05:26:37", "49.205.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6709", "1", "admin8576", "2016-08-13 05:27:51", "78.234.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6710", "1", "admin8576", "2016-08-13 05:28:14", "189.217.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6711", "1", "admin8576", "2016-08-13 05:30:26", "173.44.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6712", "1", "admin8576", "2016-08-13 05:31:22", "115.161.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6713", "1", "admin8576", "2016-08-13 05:35:14", "112.204.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6714", "1", "admin8576", "2016-08-13 05:37:14", "81.44.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6715", "1", "admin8576", "2016-08-13 05:39:36", "46.23.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6716", "1", "admin8576", "2016-08-13 05:46:04", "41.147.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6717", "1", "admin8576", "2016-08-13 05:48:25", "103.54.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6718", "1", "admin8576", "2016-08-13 05:48:26", "179.4.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6719", "1", "admin8576", "2016-08-13 05:50:33", "144.139.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6720", "1", "admin8576", "2016-08-13 05:52:01", "67.221.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6721", "1", "admin8576", "2016-08-13 05:53:47", "78.240.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6722", "1", "admin8576", "2016-08-13 05:58:25", "98.109.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6723", "1", "admin8576", "2016-08-13 05:59:38", "27.34.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6724", "1", "admin8576", "2016-08-13 06:00:31", "108.184.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6725", "1", "admin8576", "2016-08-13 06:06:40", "72.51.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6726", "1", "admin8576", "2016-08-13 06:08:06", "139.195.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6727", "1", "admin8576", "2016-08-13 06:09:14", "109.97.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6728", "1", "admin8576", "2016-08-13 06:09:50", "91.51.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6729", "1", "admin8576", "2016-08-13 06:11:01", "61.72.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6730", "1", "admin8576", "2016-08-13 06:12:58", "74.134.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6731", "1", "admin8576", "2016-08-13 06:14:52", "24.157.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6732", "1", "admin8576", "2016-08-13 06:18:14", "49.32.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6733", "1", "admin8576", "2016-08-13 06:21:21", "93.139.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6734", "1", "admin8576", "2016-08-13 06:23:14", "189.27.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6735", "1", "admin8576", "2016-08-13 06:25:09", "78.250.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6736", "1", "admin8576", "2016-08-13 06:27:03", "162.226.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6737", "1", "admin8576", "2016-08-13 06:28:43", "219.91.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6738", "1", "admin8576", "2016-08-13 06:32:17", "112.209.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6739", "1", "admin8576", "2016-08-13 06:34:23", "119.237.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6740", "1", "admin8576", "2016-08-13 06:34:52", "119.93.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6741", "1", "admin8576", "2016-08-13 06:36:40", "49.32.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6742", "1", "admin8576", "2016-08-13 06:36:49", "211.43.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6743", "1", "admin8576", "2016-08-13 06:37:14", "217.197.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6744", "1", "admin8576", "2016-08-13 06:50:03", "49.144.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6745", "1", "admin8576", "2016-08-13 06:50:42", "189.217.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6746", "1", "admin8576", "2016-08-13 06:53:00", "177.67.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6747", "1", "admin8576", "2016-08-13 06:54:59", "112.204.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6748", "1", "admin8576", "2016-08-13 06:57:20", "49.149.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6749", "1", "admin8576", "2016-08-13 06:59:18", "197.36.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6750", "1", "admin8576", "2016-08-13 07:00:00", "103.246.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6751", "1", "admin8576", "2016-08-13 07:05:47", "77.28.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6752", "1", "admin8576", "2016-08-13 07:07:53", "165.255.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6753", "1", "admin8576", "2016-08-13 07:08:59", "201.73.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6754", "1", "admin8576", "2016-08-13 07:09:23", "222.167.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6755", "1", "admin8576", "2016-08-13 07:10:32", "89.216.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6756", "1", "admin8576", "2016-08-13 07:11:16", "27.106.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6757", "1", "admin8576", "2016-08-13 07:11:52", "124.104.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6758", "1", "admin8576", "2016-08-13 07:12:31", "24.112.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6759", "1", "admin8576", "2016-08-13 07:15:12", "189.13.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6760", "1", "admin8576", "2016-08-13 07:15:13", "118.70.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6761", "1", "admin8576", "2016-08-13 07:16:10", "183.83.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6762", "1", "admin8576", "2016-08-13 07:16:12", "109.101.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6763", "1", "admin8576", "2016-08-13 07:18:19", "186.213.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6764", "1", "admin8576", "2016-08-13 07:20:09", "1.186.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6765", "1", "admin8576", "2016-08-13 07:21:56", "112.134.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6766", "1", "admin8576", "2016-08-13 07:22:23", "49.142.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6767", "1", "admin8576", "2016-08-13 07:24:20", "145.132.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6768", "1", "admin8576", "2016-08-13 07:27:48", "202.166.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6769", "1", "admin8576", "2016-08-13 07:29:06", "92.97.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6770", "1", "admin8576", "2016-08-13 07:29:39", "139.192.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6771", "1", "admin8576", "2016-08-13 07:29:47", "39.32.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6772", "1", "admin8576", "2016-08-13 07:30:27", "154.126.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6773", "1", "admin8576", "2016-08-13 07:30:43", "65.29.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6774", "1", "admin8576", "2016-08-13 07:31:08", "42.60.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6775", "1", "admin8576", "2016-08-13 07:34:42", "197.225.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6776", "1", "admin8576", "2016-08-13 07:36:57", "85.53.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6777", "1", "admin8576", "2016-08-13 07:37:21", "181.135.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6778", "1", "admin8576", "2016-08-13 07:37:44", "107.194.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6779", "1", "admin8576", "2016-08-13 07:39:19", "108.90.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6780", "1", "admin8576", "2016-08-13 07:41:30", "101.179.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6781", "1", "admin8576", "2016-08-13 07:42:01", "36.84.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6782", "1", "admin8576", "2016-08-13 07:42:09", "103.230.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6783", "1", "admin8576", "2016-08-13 07:44:01", "36.72.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6784", "1", "admin8576", "2016-08-13 07:44:04", "172.196.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6785", "1", "admin8576", "2016-08-13 07:46:06", "185.120.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6786", "1", "admin8576", "2016-08-13 07:46:38", "186.251.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6787", "1", "admin8576", "2016-08-13 07:47:38", "1.2.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6788", "1", "admin8576", "2016-08-13 07:49:51", "71.219.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6789", "1", "admin8576", "2016-08-13 07:52:05", "103.48.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6790", "1", "admin8576", "2016-08-13 07:52:53", "46.40.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6791", "1", "admin8576", "2016-08-13 07:54:12", "105.224.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6792", "1", "admin8576", "2016-08-13 07:59:21", "36.73.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6793", "1", "admin8576", "2016-08-13 08:02:22", "103.198.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6794", "1", "admin8576", "2016-08-13 08:02:57", "152.226.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6795", "1", "admin8576", "2016-08-13 08:04:42", "59.89.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6796", "1", "admin8576", "2016-08-13 08:05:59", "101.190.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6797", "1", "admin8576", "2016-08-13 08:06:56", "122.171.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6798", "1", "admin8576", "2016-08-13 08:07:07", "123.200.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6799", "1", "admin8576", "2016-08-13 08:07:36", "85.108.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6800", "1", "admin8576", "2016-08-13 08:07:46", "185.113.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6801", "1", "admin8576", "2016-08-13 08:08:27", "31.215.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6802", "1", "admin8576", "2016-08-13 08:10:40", "2.233.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6803", "1", "admin8576", "2016-08-13 08:13:05", "117.201.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6804", "1", "admin8576", "2016-08-13 08:16:31", "126.219.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6805", "1", "admin8576", "2016-08-13 08:20:57", "176.222.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6806", "1", "admin8576", "2016-08-13 08:21:59", "118.179.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6807", "1", "admin8576", "2016-08-13 08:25:13", "197.40.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6808", "1", "admin8576", "2016-08-13 08:33:09", "150.129.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6809", "1", "admin8576", "2016-08-13 08:37:13", "43.225.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6810", "1", "admin8576", "2016-08-13 08:38:47", "72.35.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6811", "1", "admin8576", "2016-08-13 08:39:57", "113.193.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6812", "1", "admin8576", "2016-08-13 08:46:07", "27.114.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6813", "1", "admin8576", "2016-08-13 08:55:31", "103.236.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6814", "1", "admin8576", "2016-08-13 09:14:42", "117.195.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6815", "1", "admin8576", "2016-08-13 09:15:02", "213.233.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6816", "1", "admin8576", "2016-08-13 09:45:58", "27.4.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6817", "1", "admin8576", "2016-08-13 10:10:10", "58.97.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6818", "1", "admin8576", "2016-08-13 10:16:47", "82.159.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6819", "1", "admin8576", "2016-08-13 10:17:59", "41.207.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6820", "1", "admin8576", "2016-08-13 10:18:02", "117.203.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6821", "1", "admin8576", "2016-08-13 11:34:24", "79.180.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6822", "1", "admin8576", "2016-08-13 11:50:47", "109.64.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6823", "1", "admin8576", "2016-08-13 12:14:13", "92.8.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6824", "1", "admin8576", "2016-08-13 12:47:33", "37.142.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6825", "1", "admin8576", "2016-08-13 13:13:45", "101.183.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6826", "1", "admin8576", "2016-08-13 13:58:33", "27.32.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6827", "1", "admin8576", "2016-08-13 14:06:16", "168.167.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6828", "1", "admin8576", "2016-08-13 14:26:27", "39.55.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6829", "1", "admin8576", "2016-08-13 15:19:49", "41.141.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6830", "1", "admin8576", "2016-08-13 15:25:14", "98.235.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6831", "1", "admin8576", "2016-08-13 15:43:45", "178.61.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6832", "1", "admin8576", "2016-08-13 16:19:13", "182.185.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6833", "1", "admin8576", "2016-08-13 18:36:17", "62.15.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6834", "1", "admin8576", "2016-08-13 21:30:30", "31.10.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6835", "1", "admin8576", "2016-08-13 22:40:11", "95.103.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6836", "1", "admin8576", "2016-08-13 22:42:26", "184.57.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6837", "1", "admin8576", "2016-08-14 16:40:10", "82.42.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6838", "1", "admin8576", "2016-08-14 21:16:52", "190.213.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6839", "1", "admin8576", "2016-08-15 09:36:56", "123.201.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6840", "1", "admin8576", "2016-08-15 11:58:59", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6841", "1", "admin8576", "2016-08-15 11:59:00", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6842", "2", "admin5748", "2016-08-15 11:59:01", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6843", "1", "admin8576", "2016-08-16 00:28:44", "24.87.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6844", "1", "admin8576", "2016-08-16 07:02:54", "175.144.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6845", "1", "admin8576", "2016-08-17 05:46:51", "37.229.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6846", "1", "admin8576", "2016-08-17 12:47:09", "80.182.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6847", "1", "admin8576", "2016-08-17 20:39:54", "106.51.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6848", "1", "admin8576", "2016-08-20 06:35:31", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6849", "1", "admin8576", "2016-08-20 06:35:32", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6850", "2", "admin5748", "2016-08-20 06:35:32", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6851", "0", "Admin", "2016-08-21 16:19:57", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6852", "1", "admin8576", "2016-08-22 23:21:40", "69.30.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6853", "1", "admin8576", "2016-08-22 23:21:41", "69.30.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6854", "1", "admin8576", "2016-08-22 23:21:42", "69.30.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6855", "0", "Admin", "2016-08-29 13:51:42", "195.154.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6856", "1", "admin8576", "2016-09-03 05:14:22", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6857", "1", "admin8576", "2016-09-03 05:14:24", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6858", "1", "admin8576", "2016-09-03 05:14:26", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6859", "1", "admin8576", "2016-09-04 13:53:45", "185.24.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6860", "1", "admin8576", "2016-09-04 13:53:46", "185.24.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6861", "1", "admin8576", "2016-09-04 13:53:47", "185.24.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6862", "1", "admin8576", "2016-09-19 23:23:47", "180.150.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6863", "1", "admin8576", "2016-09-19 23:23:50", "180.150.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6864", "1", "admin8576", "2016-09-19 23:23:53", "180.150.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6865", "1", "admin8576", "2016-09-23 16:57:36", "5.44.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6866", "1", "admin8576", "2016-09-23 20:19:11", "46.170.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6867", "1", "admin8576", "2016-09-23 22:14:33", "5.44.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6868", "1", "admin8576", "2016-09-23 23:24:41", "80.92.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6869", "1", "admin8576", "2016-09-24 03:46:40", "185.71.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6870", "1", "admin8576", "2016-09-24 05:35:34", "185.71.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6871", "1", "admin8576", "2016-09-24 07:07:12", "185.59.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6872", "1", "admin8576", "2016-09-24 08:28:59", "91.193.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6873", "1", "admin8576", "2016-09-24 12:21:13", "117.253.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6874", "1", "admin8576", "2016-09-24 18:42:24", "37.132.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6875", "1", "admin8576", "2016-09-24 20:29:28", "46.170.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6876", "1", "admin8576", "2016-09-24 21:36:42", "2.118.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6877", "1", "admin8576", "2016-09-24 23:55:53", "78.10.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6878", "1", "admin8576", "2016-09-25 02:02:08", "2.118.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6879", "1", "admin8576", "2016-09-25 07:25:05", "117.253.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6880", "1", "admin8576", "2016-09-25 09:45:04", "5.44.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6881", "1", "admin8576", "2016-09-25 11:58:44", "195.64.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6882", "1", "admin8576", "2016-09-25 14:09:51", "93.43.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6883", "1", "admin8576", "2016-09-25 16:58:39", "5.44.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6884", "1", "admin8576", "2016-09-25 19:51:15", "80.87.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6885", "1", "admin8576", "2016-09-25 20:37:44", "46.170.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6886", "1", "admin8576", "2016-09-25 22:17:15", "185.71.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6887", "1", "admin8576", "2016-09-26 00:34:26", "193.165.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6888", "1", "admin8576", "2016-09-26 03:02:58", "117.253.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6889", "1", "admin8576", "2016-09-26 05:22:45", "5.44.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6890", "1", "admin8576", "2016-09-26 07:12:35", "5.44.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6891", "1", "admin8576", "2016-09-26 08:58:54", "80.23.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6892", "1", "admin8576", "2016-09-26 10:42:26", "5.44.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6893", "1", "admin8576", "2016-09-26 13:56:42", "206.214.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6894", "1", "admin8576", "2016-09-26 16:30:10", "195.57.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6895", "1", "admin8576", "2016-09-26 19:28:34", "5.44.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6896", "1", "admin8576", "2016-09-26 22:07:37", "151.237.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6897", "1", "admin8576", "2016-09-27 02:21:21", "82.207.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6898", "1", "admin8576", "2016-09-27 04:35:48", "117.255.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6899", "1", "admin8576", "2016-09-27 08:42:14", "201.47.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6900", "0", "admin", "2016-09-27 11:39:38", "172.246.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6901", "1", "admin8576", "2016-09-27 12:44:05", "46.246.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6902", "1", "admin8576", "2016-09-27 15:13:49", "78.23.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6903", "1", "admin8576", "2016-09-27 18:25:23", "193.59.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6904", "1", "admin8576", "2016-09-27 21:11:42", "117.253.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6905", "1", "admin8576", "2016-09-27 23:43:55", "187.103.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6906", "1", "admin8576", "2016-09-28 02:23:36", "82.98.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6907", "1", "admin8576", "2016-09-28 04:58:35", "213.145.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6908", "1", "admin8576", "2016-09-28 07:07:54", "5.44.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6909", "1", "admin8576", "2016-09-28 09:14:42", "93.170.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6910", "1", "admin8576", "2016-09-28 11:20:07", "2.40.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6911", "0", "admin", "2016-09-28 13:12:02", "172.246.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6912", "1", "admin8576", "2016-09-28 13:31:00", "92.223.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6913", "1", "admin8576", "2016-09-28 15:47:05", "93.43.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6914", "1", "admin8576", "2016-09-28 17:45:20", "5.44.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6915", "1", "admin8576", "2016-09-28 19:42:46", "89.29.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6916", "1", "admin8576", "2016-09-28 19:42:46", "194.184.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6917", "1", "admin8576", "2016-09-28 21:37:30", "112.163.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6918", "1", "admin8576", "2016-09-29 01:35:13", "80.48.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6919", "1", "admin8576", "2016-09-29 06:56:40", "93.99.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6920", "1", "admin8576", "2016-09-29 08:13:25", "185.71.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6921", "1", "admin8576", "2016-09-29 09:41:39", "5.44.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6922", "1", "admin8576", "2016-09-29 11:32:18", "206.214.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6923", "1", "admin8576", "2016-09-29 12:48:20", "31.148.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6924", "1", "admin8576", "2016-09-29 13:34:59", "31.196.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6925", "0", "admin", "2016-09-29 14:02:04", "142.91.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6926", "1", "admin8576", "2016-09-29 14:49:45", "195.235.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6927", "1", "admin8576", "2016-09-29 19:05:16", "95.254.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6928", "1", "admin8576", "2016-09-29 23:06:08", "69.57.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6929", "1", "admin8576", "2016-09-30 00:39:55", "45.63.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6930", "1", "admin8576", "2016-09-30 05:45:46", "218.217.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6931", "0", "admin", "2016-09-30 15:49:59", "198.98.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6932", "1", "admin8576", "2016-10-01 02:49:43", "117.253.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6933", "0", "admin", "2016-10-01 18:04:41", "23.89.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6934", "0", "admin", "2016-10-02 19:50:17", "172.246.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6935", "0", "admin", "2016-10-03 20:34:33", "192.157.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6936", "0", "admin", "2016-10-04 22:19:49", "23.88.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6937", "0", "admin", "2016-10-20 16:25:16", "95.10.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6938", "1", "admin8576", "2016-10-28 06:12:53", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6939", "1", "admin8576", "2016-10-28 06:12:54", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6940", "1", "admin8576", "2016-10-28 06:12:55", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6941", "0", "admin8576@admin8576", "2016-11-19 17:32:58", "52.90.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6942", "1", "admin8576", "2016-11-20 21:16:34", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6943", "1", "admin8576", "2016-11-20 22:27:54", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6944", "1", "admin8576", "2016-11-20 23:15:22", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6945", "1", "admin8576", "2016-11-21 00:03:15", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6946", "1", "admin8576", "2016-11-21 00:51:02", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6947", "1", "admin8576", "2016-11-21 01:39:03", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6948", "1", "admin8576", "2016-11-21 02:27:14", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6949", "1", "admin8576", "2016-11-21 03:15:27", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6950", "1", "admin8576", "2016-11-21 04:03:55", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6951", "1", "admin8576", "2016-11-21 04:52:43", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6952", "1", "admin8576", "2016-11-21 05:43:21", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6953", "1", "admin8576", "2016-11-21 06:32:07", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6954", "1", "admin8576", "2016-11-21 07:25:31", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6955", "1", "admin8576", "2016-11-21 08:26:25", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6956", "1", "admin8576", "2016-11-21 09:28:33", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6957", "1", "admin8576", "2016-11-21 10:30:12", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6958", "1", "admin8576", "2016-11-21 11:33:00", "54.206.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6959", "1", "admin8576", "2016-12-09 20:55:41", "37.115.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6960", "1", "admin8576", "2016-12-11 09:37:49", "86.102.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6961", "0", "admin", "2016-12-11 13:36:38", "136.243.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6962", "1", "admin8576", "2016-12-11 21:58:37", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6963", "1", "admin8576", "2016-12-11 21:58:38", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6964", "1", "admin8576", "2016-12-11 21:58:42", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6965", "1", "admin8576", "2016-12-14 15:29:43", "110.36.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6966", "1", "admin8576", "2016-12-18 04:21:21", "111.9.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6967", "1", "admin8576", "2016-12-21 19:23:38", "117.253.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6968", "0", "admin", "2016-12-24 20:35:02", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6969", "1", "admin8576", "2016-12-25 17:56:38", "202.136.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6970", "1", "admin8576", "2016-12-26 09:54:13", "205.217.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6971", "1", "admin8576", "2016-12-29 10:56:10", "125.19.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6972", "0", "chaotic", "2016-12-29 20:31:59", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6973", "1", "admin8576", "2016-12-30 04:26:14", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6974", "1", "admin8576", "2016-12-30 04:26:15", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6975", "1", "admin8576", "2016-12-30 04:26:16", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6976", "0", "expect", "2017-01-03 06:26:01", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6977", "1", "admin8576", "2017-01-03 06:53:59", "37.252.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6978", "0", "expect", "2017-01-04 04:29:22", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6979", "0", "expect", "2017-01-05 22:55:13", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6980", "1", "admin8576", "2017-01-06 06:46:05", "5.250.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6981", "0", "ability", "2017-01-07 07:16:32", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6982", "0", "based", "2017-01-07 21:16:23", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6983", "0", "very", "2017-01-08 02:52:16", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6984", "0", "admin", "2017-01-08 17:51:09", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6985", "0", "render", "2017-01-09 06:08:32", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6986", "1", "admin8576", "2017-01-09 09:17:32", "37.114.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6987", "0", "based", "2017-01-09 18:22:08", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6988", "0", "based", "2017-01-09 20:09:56", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6989", "0", "admin8576@admin8576", "2017-01-09 21:49:02", "54.194.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6990", "0", "very", "2017-01-10 01:06:27", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6991", "1", "admin8576", "2017-01-11 01:35:30", "131.255.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6992", "0", "volatile", "2017-01-11 02:05:40", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6993", "0", "admin", "2017-01-11 02:44:33", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6994", "0", "hand", "2017-01-11 12:41:56", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6995", "0", "black", "2017-01-12 05:01:05", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6996", "0", "gmai", "2017-01-12 12:23:11", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6997", "1", "admin8576", "2017-01-12 13:26:35", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6998", "1", "admin8576", "2017-01-12 17:42:56", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6999", "1", "admin8576", "2017-01-12 18:26:03", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7000", "1", "admin8576", "2017-01-12 19:11:31", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7001", "1", "admin8576", "2017-01-12 19:59:45", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7002", "1", "admin8576", "2017-01-12 20:47:25", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7003", "1", "admin8576", "2017-01-12 21:25:08", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7004", "1", "admin8576", "2017-01-12 22:02:25", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7005", "1", "admin8576", "2017-01-12 22:40:00", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7006", "1", "admin8576", "2017-01-12 23:17:06", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7007", "1", "admin8576", "2017-01-12 23:54:49", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7008", "1", "admin8576", "2017-01-13 00:31:58", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7009", "1", "admin8576", "2017-01-13 01:09:36", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7010", "1", "admin8576", "2017-01-13 01:47:44", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7011", "1", "admin8576", "2017-01-13 02:26:26", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7012", "0", "admin", "2017-01-13 02:28:50", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7013", "1", "admin8576", "2017-01-13 03:04:58", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7014", "1", "admin8576", "2017-01-13 03:43:49", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7015", "1", "admin8576", "2017-01-13 04:22:36", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7016", "1", "admin8576", "2017-01-13 05:01:44", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7017", "1", "admin8576", "2017-01-13 05:40:50", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7018", "1", "admin8576", "2017-01-13 06:20:00", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7019", "1", "admin8576", "2017-01-13 06:58:50", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7020", "0", "paths", "2017-01-13 07:04:58", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7021", "1", "admin8576", "2017-01-13 07:37:48", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7022", "1", "admin8576", "2017-01-13 08:16:50", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7023", "0", "admin", "2017-01-13 08:54:13", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7024", "1", "admin8576", "2017-01-13 08:56:12", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7025", "1", "admin8576", "2017-01-13 09:35:58", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7026", "1", "admin8576", "2017-01-13 10:15:33", "54.203.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7027", "0", "space", "2017-01-14 16:48:16", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7028", "0", "admin", "2017-01-14 22:11:40", "95.173.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7029", "1", "admin8576", "2017-01-15 06:55:26", "138.118.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7030", "0", "against", "2017-01-15 17:20:46", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7031", "0", "forming", "2017-01-16 08:37:44", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7032", "0", "admin", "2017-01-17 15:25:52", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7033", "0", "admin", "2017-01-17 22:19:26", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7034", "0", "johannesburg", "2017-01-18 07:34:26", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7035", "0", "admin", "2017-01-18 09:55:00", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7036", "0", "first", "2017-01-18 17:43:33", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7037", "1", "admin8576", "2017-01-19 05:25:24", "177.38.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7038", "0", "offices", "2017-01-20 02:47:56", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7039", "0", "offices", "2017-01-20 11:45:10", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7040", "0", "admin", "2017-01-20 16:46:13", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7041", "0", "admin", "2017-01-20 18:43:43", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7042", "0", "admin", "2017-01-21 01:17:14", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7043", "0", "admin", "2017-01-21 06:06:03", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7044", "0", "admin", "2017-01-21 06:15:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7045", "0", "admin", "2017-01-21 16:32:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7046", "0", "admin", "2017-01-21 22:05:50", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7047", "0", "volcano", "2017-01-22 04:16:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7048", "0", "admin", "2017-01-22 07:45:25", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7049", "0", "2146", "2017-01-22 12:48:56", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7050", "0", "admin", "2017-01-22 20:25:51", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7051", "0", "admin", "2017-01-23 01:23:51", "5.39.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7052", "0", "admin", "2017-01-23 07:20:05", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7053", "0", "admin", "2017-01-23 12:05:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7054", "0", "admin", "2017-01-23 17:16:35", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7055", "0", "chambers", "2017-01-23 17:29:03", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7056", "0", "admin", "2017-01-23 18:58:23", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7057", "0", "admin", "2017-01-24 16:48:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7058", "0", "admin", "2017-01-24 17:09:45", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7059", "0", "admin", "2017-01-24 18:23:28", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7060", "0", "admin", "2017-01-25 05:36:23", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7061", "0", "paths", "2017-01-25 14:34:08", "5.39.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7062", "0", "can", "2017-01-25 23:01:07", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7063", "0", "solid", "2017-01-26 03:02:11", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7064", "0", "magale", "2017-01-26 04:25:26", "5.39.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7065", "0", "certified", "2017-01-26 08:51:12", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7066", "0", "admin", "2017-01-26 10:03:54", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7067", "1", "admin8576", "2017-01-26 17:04:09", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7068", "1", "admin8576", "2017-01-26 19:15:57", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7069", "1", "admin8576", "2017-01-26 19:47:52", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7070", "1", "admin8576", "2017-01-26 20:14:08", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7071", "1", "admin8576", "2017-01-26 20:40:41", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7072", "1", "admin8576", "2017-01-26 21:07:29", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7073", "1", "admin8576", "2017-01-26 21:34:03", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7074", "1", "admin8576", "2017-01-26 22:00:51", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7075", "1", "admin8576", "2017-01-26 22:27:55", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7076", "1", "admin8576", "2017-01-26 22:54:08", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7077", "1", "admin8576", "2017-01-26 23:20:17", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7078", "1", "admin8576", "2017-01-26 23:46:40", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7079", "1", "admin8576", "2017-01-27 00:13:02", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7080", "1", "admin8576", "2017-01-27 00:39:05", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7081", "1", "admin8576", "2017-01-27 01:05:10", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7082", "1", "admin8576", "2017-01-27 01:31:36", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7083", "0", "this", "2017-01-27 01:33:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7084", "0", "admin", "2017-01-27 01:34:11", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7085", "1", "admin8576", "2017-01-27 01:57:58", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7086", "1", "admin8576", "2017-01-27 02:23:57", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7087", "1", "admin8576", "2017-01-27 02:49:39", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7088", "1", "admin8576", "2017-01-27 03:15:54", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7089", "1", "admin8576", "2017-01-27 03:42:17", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7090", "1", "admin8576", "2017-01-27 04:08:44", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7091", "1", "admin8576", "2017-01-27 04:34:54", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7092", "0", "georges", "2017-01-27 04:40:47", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7093", "1", "admin8576", "2017-01-27 05:01:09", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7094", "1", "admin8576", "2017-01-27 05:27:26", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7095", "1", "admin8576", "2017-01-27 05:53:40", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7096", "1", "admin8576", "2017-01-27 06:19:56", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7097", "1", "admin8576", "2017-01-27 06:45:53", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7098", "1", "admin8576", "2017-01-27 07:12:03", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7099", "1", "admin8576", "2017-01-27 07:38:06", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7100", "1", "admin8576", "2017-01-27 08:04:16", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7101", "1", "admin8576", "2017-01-27 08:30:39", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7102", "1", "admin8576", "2017-01-27 08:57:01", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7103", "1", "admin8576", "2017-01-27 09:23:52", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7104", "1", "admin8576", "2017-01-27 09:50:20", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7105", "1", "admin8576", "2017-01-27 10:17:02", "35.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7106", "0", "form", "2017-01-27 17:20:52", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7107", "0", "builder", "2017-01-27 18:16:10", "5.39.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7108", "0", "online", "2017-01-27 18:27:05", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7109", "0", "admin", "2017-01-28 16:21:30", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7110", "0", "admin", "2017-01-29 07:30:36", "5.39.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7111", "0", "admin", "2017-01-29 12:29:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7112", "0", "complex", "2017-01-29 15:38:41", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7113", "2", "admin5748", "2017-01-29 21:13:34", "202.5.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7114", "2", "admin5748", "2017-01-29 21:50:11", "41.33.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7115", "0", "admin", "2017-01-30 02:16:58", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7116", "0", "admin", "2017-01-30 06:36:55", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7117", "0", "admin", "2017-01-30 07:23:00", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7118", "2", "admin5748", "2017-01-30 13:33:08", "116.193.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7119", "0", "awards", "2017-01-30 16:34:46", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7120", "0", "aviation", "2017-01-30 19:34:01", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7121", "0", "admin", "2017-01-30 22:58:35", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7122", "2", "admin5748", "2017-01-31 02:54:31", "220.227.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7123", "0", "services", "2017-01-31 02:59:59", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7124", "2", "admin5748", "2017-01-31 03:04:19", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7125", "0", "partnerships", "2017-01-31 09:43:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7126", "2", "admin5748", "2017-01-31 14:53:13", "197.255.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7127", "2", "admin5748", "2017-01-31 18:01:42", "81.28.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7128", "0", "beneath", "2017-01-31 19:45:27", "5.39.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7129", "0", "know", "2017-02-01 04:06:10", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7130", "0", "follow", "2017-02-01 06:56:37", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7131", "0", "admin", "2017-02-01 14:12:29", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7132", "0", "admin", "2017-02-01 15:47:13", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7133", "0", "documents", "2017-02-01 16:05:11", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7134", "2", "admin5748", "2017-02-01 16:16:10", "94.227.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7135", "1", "admin8576", "2017-02-02 01:07:17", "82.209.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7136", "2", "admin5748", "2017-02-02 07:27:40", "84.15.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7137", "2", "admin5748", "2017-02-02 07:28:37", "83.240.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7138", "2", "admin5748", "2017-02-03 01:53:59", "190.120.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7139", "2", "admin5748", "2017-02-03 02:33:50", "175.106.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7140", "0", "top", "2017-02-03 05:39:23", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7141", "0", "admin", "2017-02-03 07:55:30", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7142", "0", "admin", "2017-02-03 10:58:01", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7143", "1", "admin8576", "2017-02-03 10:59:55", "211.236.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7144", "0", "volatile", "2017-02-03 13:18:51", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7145", "2", "admin5748", "2017-02-03 17:13:44", "92.103.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7146", "2", "admin5748", "2017-02-03 18:41:13", "82.194.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7147", "0", "admin", "2017-02-03 21:36:41", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7148", "0", "home", "2017-02-03 22:30:43", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7149", "0", "admin", "2017-02-04 00:24:00", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7150", "0", "partnerships", "2017-02-04 05:13:01", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7151", "2", "admin5748", "2017-02-04 15:44:58", "36.78.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7152", "2", "admin5748", "2017-02-04 16:28:03", "103.36.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7153", "0", "admin", "2017-02-04 18:46:33", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7154", "0", "attorneys", "2017-02-04 21:26:09", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7155", "0", "admin", "2017-02-04 23:00:25", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7156", "2", "admin5748", "2017-02-05 06:24:59", "88.200.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7157", "0", "basis", "2017-02-05 06:45:52", "5.39.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7158", "0", "your", "2017-02-06 15:43:13", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7159", "0", "4000", "2017-02-06 17:57:57", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7160", "1", "admin8576", "2017-02-07 06:09:40", "187.16.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7161", "0", "admin", "2017-02-07 07:42:48", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7162", "0", "admin", "2017-02-08 09:58:39", "5.39.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7163", "0", "earth", "2017-02-08 11:20:54", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7164", "1", "admin8576", "2017-02-08 14:25:22", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7165", "1", "admin8576", "2017-02-08 14:25:24", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7166", "1", "admin8576", "2017-02-08 14:25:25", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7167", "0", "admin", "2017-02-08 15:35:55", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7168", "0", "admin", "2017-02-09 03:42:40", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7169", "0", "level", "2017-02-09 05:07:14", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7170", "1", "admin8576", "2017-02-09 05:52:51", "205.217.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7171", "0", "admin", "2017-02-09 10:30:05", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7172", "0", "admin", "2017-02-09 14:44:12", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7173", "0", "admin", "2017-02-09 17:03:17", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7174", "0", "admin", "2017-02-09 20:42:02", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7175", "0", "admin", "2017-02-10 01:10:48", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7176", "0", "6001", "2017-02-10 01:19:59", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7177", "0", "admin", "2017-02-10 06:54:24", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7178", "0", "admin", "2017-02-10 18:37:53", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7179", "0", "admin", "2017-02-11 14:22:44", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7180", "0", "admin", "2017-02-11 15:35:20", "87.255.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7181", "0", "magmainc.co", "2017-02-11 16:48:13", "89.239.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7182", "0", "admin", "2017-02-11 16:59:03", "81.1.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7183", "0", "magmainc.co", "2017-02-11 17:02:56", "81.195.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7184", "0", "admin", "2017-02-11 17:21:26", "176.197.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7185", "0", "magmainc.co", "2017-02-11 17:50:27", "95.72.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7186", "0", "admin", "2017-02-11 17:53:22", "188.68.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7187", "0", "magmainc.co", "2017-02-11 18:13:13", "81.195.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7188", "0", "admin", "2017-02-11 18:25:07", "95.143.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7189", "0", "admin", "2017-02-11 18:36:53", "31.173.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7190", "0", "magmainc.co", "2017-02-11 18:41:14", "95.189.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7191", "0", "admin", "2017-02-11 18:46:37", "5.129.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7192", "0", "magmainc.co", "2017-02-11 19:02:50", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7193", "0", "admin", "2017-02-11 19:15:21", "77.106.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7194", "0", "magmainc.co", "2017-02-11 19:24:22", "128.68.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7195", "0", "admin", "2017-02-11 19:28:43", "109.252.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7196", "0", "magmainc.co", "2017-02-11 19:36:25", "188.32.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7197", "0", "magmainc.co", "2017-02-11 19:54:54", "92.255.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7198", "0", "admin", "2017-02-11 19:55:24", "109.252.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7199", "0", "magmainc.co", "2017-02-11 20:01:54", "176.97.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7200", "0", "admin", "2017-02-11 20:08:15", "185.13.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7201", "0", "magmainc.co", "2017-02-11 20:24:21", "109.252.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7202", "0", "admin", "2017-02-11 20:28:54", "213.182.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7203", "0", "magmainc.co", "2017-02-11 20:34:49", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7204", "0", "admin", "2017-02-11 20:45:50", "178.167.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7205", "0", "magmainc.co", "2017-02-11 20:46:59", "93.100.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7206", "0", "admin", "2017-02-11 21:00:25", "31.130.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7207", "0", "magmainc.co", "2017-02-11 21:20:38", "46.158.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7208", "0", "admin", "2017-02-11 21:26:48", "93.185.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7209", "0", "magmainc.co", "2017-02-11 21:58:41", "93.157.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7210", "0", "admin", "2017-02-11 21:58:55", "91.107.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7211", "0", "admin", "2017-02-11 22:20:16", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7212", "0", "admin", "2017-02-11 23:07:13", "31.173.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7213", "0", "admin", "2017-02-11 23:40:24", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7214", "0", "magmainc.co", "2017-02-11 23:56:39", "213.24.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7215", "0", "admin", "2017-02-12 00:41:58", "31.173.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7216", "0", "admin", "2017-02-12 01:05:47", "188.68.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7217", "0", "magmainc.co", "2017-02-12 01:19:48", "213.57.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7218", "0", "admin", "2017-02-12 01:27:09", "46.158.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7219", "0", "magmainc.co", "2017-02-12 01:28:22", "94.190.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7220", "0", "admin", "2017-02-12 02:45:01", "176.197.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7221", "0", "magmainc.co", "2017-02-12 02:57:00", "193.233.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7222", "0", "admin", "2017-02-12 04:22:15", "188.32.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7223", "0", "magmainc.co", "2017-02-12 04:48:25", "109.111.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7224", "0", "admin", "2017-02-12 05:05:15", "37.110.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7225", "0", "magmainc.co", "2017-02-12 05:13:27", "109.252.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7226", "0", "magmainc.co", "2017-02-12 05:14:53", "46.158.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7227", "0", "admin", "2017-02-12 05:14:58", "109.111.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7228", "1", "admin8576", "2017-02-12 05:22:35", "190.90.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7229", "0", "admin", "2017-02-12 05:28:50", "95.189.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7230", "0", "admin", "2017-02-12 06:28:49", "93.185.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7231", "0", "admin", "2017-02-12 06:32:56", "37.110.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7232", "0", "magmainc.co", "2017-02-12 06:49:34", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7233", "0", "admin", "2017-02-12 07:05:56", "92.55.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7234", "0", "magmainc.co", "2017-02-12 07:12:03", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7235", "0", "admin", "2017-02-12 07:33:43", "213.24.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7236", "0", "magmainc.co", "2017-02-12 07:41:36", "89.251.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7237", "0", "admin", "2017-02-12 07:44:31", "93.85.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7238", "0", "admin", "2017-02-12 08:08:02", "79.21.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7239", "0", "admin", "2017-02-12 08:29:11", "188.17.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7240", "0", "magmainc.co", "2017-02-12 08:30:48", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7241", "0", "admin", "2017-02-12 08:47:28", "95.31.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7242", "0", "magmainc.co", "2017-02-12 08:56:01", "37.78.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7243", "0", "admin", "2017-02-12 09:06:53", "213.57.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7244", "0", "magmainc.co", "2017-02-12 09:23:20", "31.130.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7245", "0", "admin", "2017-02-12 09:34:31", "95.29.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7246", "0", "magmainc.co", "2017-02-12 09:41:09", "109.252.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7247", "0", "admin", "2017-02-12 10:05:39", "81.195.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7248", "0", "admin", "2017-02-12 10:16:55", "46.44.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7249", "0", "magmainc.co", "2017-02-12 10:30:01", "5.18.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7250", "0", "admin", "2017-02-12 10:42:39", "37.78.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7251", "0", "magmainc.co", "2017-02-12 10:47:16", "89.239.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7252", "0", "magmainc.co", "2017-02-12 10:54:34", "95.31.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7253", "0", "admin", "2017-02-12 11:01:15", "37.78.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7254", "0", "magmainc.co", "2017-02-12 11:02:05", "212.46.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7255", "0", "magmainc.co", "2017-02-12 11:12:29", "213.57.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7256", "0", "admin", "2017-02-12 11:14:47", "87.243.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7257", "0", "magmainc.co", "2017-02-12 11:15:53", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7258", "0", "admin", "2017-02-12 11:21:24", "193.34.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7259", "0", "magmainc.co", "2017-02-12 11:28:30", "95.143.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7260", "0", "admin", "2017-02-12 11:34:51", "80.92.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7261", "0", "magmainc.co", "2017-02-12 11:37:20", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7262", "0", "magmainc.co", "2017-02-12 11:54:17", "5.141.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7263", "0", "magmainc.co", "2017-02-12 12:30:27", "77.37.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7264", "0", "admin", "2017-02-12 12:34:43", "46.158.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7265", "0", "magmainc.co", "2017-02-12 13:10:35", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7266", "0", "admin", "2017-02-12 13:13:55", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7267", "0", "magmainc.co", "2017-02-12 13:14:23", "193.233.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7268", "0", "admin", "2017-02-12 13:23:16", "31.130.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7269", "0", "magmainc.co", "2017-02-12 13:39:53", "93.85.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7270", "0", "magmainc.co", "2017-02-12 13:47:39", "185.57.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7271", "0", "magmainc.co", "2017-02-12 14:14:34", "109.172.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7272", "0", "admin", "2017-02-12 14:17:27", "86.62.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7273", "0", "admin", "2017-02-12 14:21:01", "213.57.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7274", "0", "magmainc.co", "2017-02-12 14:30:51", "81.5.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7275", "0", "magmainc.co", "2017-02-12 14:44:24", "5.141.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7276", "0", "magmainc.co", "2017-02-12 15:23:58", "94.188.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7277", "0", "admin", "2017-02-12 15:24:23", "109.174.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7278", "0", "magmainc.co", "2017-02-12 15:29:17", "188.232.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7279", "0", "admin", "2017-02-12 15:31:09", "37.78.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7280", "0", "magmainc.co", "2017-02-12 15:36:49", "37.23.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7281", "0", "admin", "2017-02-12 15:39:12", "178.34.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7282", "0", "magmainc.co", "2017-02-12 15:55:19", "109.174.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7283", "0", "admin", "2017-02-12 16:15:30", "109.174.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7284", "0", "magmainc.co", "2017-02-12 16:19:37", "87.243.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7285", "0", "correspondence", "2017-02-12 16:20:26", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7286", "0", "admin", "2017-02-12 16:42:19", "37.21.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7287", "0", "magmainc.co", "2017-02-12 16:53:05", "94.24.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7288", "0", "admin", "2017-02-12 17:03:24", "89.251.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7289", "0", "magmainc.co", "2017-02-12 17:03:41", "217.118.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7290", "0", "magmainc.co", "2017-02-12 17:25:15", "93.85.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7291", "0", "admin", "2017-02-12 17:51:50", "31.162.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7292", "0", "magmainc.co", "2017-02-12 17:57:49", "37.78.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7293", "0", "magmainc.co", "2017-02-12 18:16:36", "188.17.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7294", "0", "magmainc.co", "2017-02-12 18:18:18", "178.57.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7295", "0", "admin", "2017-02-12 18:18:29", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7296", "0", "admin", "2017-02-12 18:19:37", "87.117.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7297", "0", "magmainc.co", "2017-02-12 18:25:20", "93.157.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7298", "0", "magmainc.co", "2017-02-12 18:38:03", "213.57.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7299", "0", "admin", "2017-02-12 18:38:29", "217.118.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7300", "0", "admin", "2017-02-12 18:40:51", "31.162.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7301", "0", "magmainc.co", "2017-02-12 18:52:17", "94.188.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7302", "0", "admin", "2017-02-12 19:04:04", "95.143.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7303", "0", "magmain", "2017-02-12 19:14:05", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7304", "0", "magmainc.co", "2017-02-12 19:25:17", "81.177.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7305", "0", "admin", "2017-02-12 19:29:19", "93.32.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7306", "0", "magmainc.co", "2017-02-12 19:34:32", "67.161.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7307", "0", "terms", "2017-02-12 19:42:38", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7308", "0", "admin", "2017-02-12 20:00:15", "87.117.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7309", "0", "magmainc.co", "2017-02-12 20:11:58", "109.172.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7310", "0", "magmainc.co", "2017-02-12 20:15:21", "185.54.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7311", "0", "admin", "2017-02-12 20:18:19", "37.78.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7312", "0", "magmainc.co", "2017-02-12 20:19:28", "188.168.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7313", "0", "admin", "2017-02-12 20:43:31", "89.251.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7314", "0", "magmainc.co", "2017-02-12 20:52:00", "94.24.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7315", "0", "magmainc.co", "2017-02-12 20:53:58", "94.190.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7316", "0", "admin", "2017-02-12 20:53:58", "77.37.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7317", "0", "admin", "2017-02-12 20:55:22", "95.143.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7318", "0", "admin", "2017-02-12 21:16:32", "109.252.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7319", "0", "magmainc.co", "2017-02-12 21:17:07", "78.36.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7320", "0", "magmainc.co", "2017-02-12 21:34:10", "185.13.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7321", "0", "magmainc.co", "2017-02-12 21:57:26", "91.214.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7322", "0", "magmainc.co", "2017-02-12 22:55:54", "87.255.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7323", "0", "admin", "2017-02-12 22:58:17", "185.13.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7324", "0", "magmainc.co", "2017-02-12 23:00:18", "37.145.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7325", "0", "admin", "2017-02-12 23:13:48", "31.162.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7326", "0", "admin", "2017-02-12 23:25:43", "77.37.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7327", "0", "magmainc.co", "2017-02-13 00:11:46", "94.24.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7328", "0", "admin", "2017-02-13 00:25:57", "77.37.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7329", "0", "admin", "2017-02-13 01:08:42", "31.162.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7330", "0", "magmainc.co", "2017-02-13 01:36:49", "95.71.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7331", "0", "admin", "2017-02-13 01:58:23", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7332", "0", "magmainc.co", "2017-02-13 01:59:43", "77.35.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7333", "0", "admin", "2017-02-13 02:39:14", "195.93.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7334", "0", "magmainc.co", "2017-02-13 02:54:41", "89.251.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7335", "0", "admin", "2017-02-13 03:56:55", "193.233.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7336", "0", "magmainc.co", "2017-02-13 04:23:36", "37.110.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7337", "0", "admin", "2017-02-13 05:03:34", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7338", "0", "admin", "2017-02-13 05:26:30", "94.24.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7339", "0", "admin", "2017-02-13 05:36:24", "85.173.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7340", "0", "magmainc.co", "2017-02-13 05:44:37", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7341", "0", "magmainc.co", "2017-02-13 06:11:38", "90.152.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7342", "0", "admin", "2017-02-13 06:17:54", "77.35.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7343", "0", "magmainc.co", "2017-02-13 06:29:56", "195.68.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7344", "0", "admin", "2017-02-13 06:48:57", "37.110.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7345", "0", "magmainc.co", "2017-02-13 07:04:53", "95.189.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7346", "0", "admin", "2017-02-13 07:06:54", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7347", "0", "magmainc.co", "2017-02-13 07:12:37", "212.21.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7348", "0", "admin", "2017-02-13 07:18:27", "84.237.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7349", "0", "magmainc.co", "2017-02-13 07:20:06", "92.242.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7350", "0", "magmainc.co", "2017-02-13 07:27:22", "193.34.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7351", "0", "admin", "2017-02-13 07:38:42", "213.110.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7352", "0", "magmainc.co", "2017-02-13 07:45:13", "95.71.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7353", "0", "admin", "2017-02-13 07:49:09", "195.93.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7354", "0", "admin", "2017-02-13 08:07:00", "134.255.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7355", "0", "magmainc.co", "2017-02-13 08:10:28", "78.29.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7356", "0", "admin", "2017-02-13 08:13:53", "195.93.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7357", "0", "magmainc.co", "2017-02-13 08:17:34", "5.143.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7358", "0", "admin", "2017-02-13 08:19:39", "73.185.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7359", "0", "magmainc.co", "2017-02-13 08:28:21", "217.172.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7360", "0", "admin", "2017-02-13 08:30:36", "46.39.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7361", "0", "magmainc.co", "2017-02-13 08:43:39", "90.152.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7362", "0", "admin", "2017-02-13 08:45:54", "193.233.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7363", "0", "magmainc.co", "2017-02-13 08:48:49", "31.163.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7364", "0", "admin", "2017-02-13 08:49:38", "37.110.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7365", "0", "magmainc.co", "2017-02-13 08:50:21", "145.255.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7366", "0", "admin", "2017-02-13 08:52:51", "89.251.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7367", "0", "admin", "2017-02-13 09:05:44", "188.232.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7368", "0", "magmainc.co", "2017-02-13 09:10:06", "195.62.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7369", "0", "admin", "2017-02-13 09:17:30", "185.57.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7370", "0", "magmainc.co", "2017-02-13 09:24:11", "185.52.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7371", "0", "admin", "2017-02-13 09:24:54", "78.29.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7372", "0", "magmainc.co", "2017-02-13 09:25:41", "213.110.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7373", "0", "magmainc.co", "2017-02-13 09:39:15", "91.220.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7374", "0", "admin", "2017-02-13 09:48:54", "109.252.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7375", "0", "magmainc.co", "2017-02-13 09:49:07", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7376", "0", "admin", "2017-02-13 09:53:18", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7377", "0", "magmainc.co", "2017-02-13 09:56:11", "77.240.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7378", "0", "admin", "2017-02-13 09:59:00", "134.255.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7379", "0", "magmainc.co", "2017-02-13 10:15:07", "178.140.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7380", "0", "admin", "2017-02-13 10:28:04", "79.8.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7381", "0", "magmainc.co", "2017-02-13 10:35:47", "91.205.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7382", "0", "admin", "2017-02-13 10:38:17", "31.181.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7383", "0", "admin", "2017-02-13 10:43:07", "192.168.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7384", "0", "magmainc.co", "2017-02-13 10:51:46", "31.210.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7385", "0", "admin", "2017-02-13 11:09:35", "83.242.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7386", "0", "magmainc.co", "2017-02-13 11:10:34", "95.179.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7387", "0", "admin", "2017-02-13 11:29:12", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7388", "0", "magmainc.co", "2017-02-13 11:35:56", "217.194.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7389", "0", "admin", "2017-02-13 11:41:19", "94.24.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7390", "0", "admin", "2017-02-13 11:45:40", "87.255.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7391", "0", "magmainc.co", "2017-02-13 11:50:05", "5.102.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7392", "0", "magmainc.co", "2017-02-13 11:51:47", "89.107.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7393", "0", "admin", "2017-02-13 12:06:54", "151.77.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7394", "0", "magmainc.co", "2017-02-13 12:08:35", "194.150.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7395", "0", "admin", "2017-02-13 12:13:57", "195.96.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7396", "0", "magmainc.co", "2017-02-13 12:14:05", "193.111.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7397", "0", "admin", "2017-02-13 12:21:34", "37.23.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7398", "0", "magmainc.co", "2017-02-13 12:21:35", "77.240.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7399", "0", "admin", "2017-02-13 12:22:40", "46.44.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7400", "0", "magmainc.co", "2017-02-13 12:23:18", "195.218.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7401", "0", "admin", "2017-02-13 12:30:48", "85.143.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7402", "0", "magmainc.co", "2017-02-13 12:44:27", "37.18.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7403", "0", "admin", "2017-02-13 12:47:50", "145.255.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7404", "0", "magmainc.co", "2017-02-13 12:48:52", "78.29.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7405", "0", "admin", "2017-02-13 12:56:41", "89.106.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7406", "0", "magmainc.co", "2017-02-13 12:59:42", "91.247.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7407", "0", "admin", "2017-02-13 13:00:05", "178.234.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7408", "0", "admin", "2017-02-13 13:06:00", "89.107.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7409", "0", "magmainc.co", "2017-02-13 13:17:14", "195.91.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7410", "0", "admin", "2017-02-13 13:25:13", "77.37.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7411", "0", "magmainc.co", "2017-02-13 13:27:47", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7412", "0", "admin", "2017-02-13 13:29:50", "89.107.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7413", "0", "magmainc.co", "2017-02-13 13:41:18", "94.25.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7414", "0", "admin", "2017-02-13 13:47:48", "31.173.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7415", "0", "magmainc.co", "2017-02-13 13:51:41", "37.29.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7416", "0", "admin", "2017-02-13 13:55:09", "145.255.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7417", "0", "admin", "2017-02-13 14:01:10", "213.182.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7418", "0", "magmainc.co", "2017-02-13 14:05:09", "195.91.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7419", "0", "admin", "2017-02-13 14:05:49", "5.102.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7420", "0", "magmainc.co", "2017-02-13 14:28:41", "46.188.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7421", "0", "admin", "2017-02-13 14:31:26", "193.34.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7422", "0", "magmainc.co", "2017-02-13 14:34:13", "188.18.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7423", "0", "admin", "2017-02-13 14:57:04", "195.62.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7424", "0", "magmainc.co", "2017-02-13 15:00:32", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7425", "0", "magmainc.co", "2017-02-13 15:08:29", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7426", "0", "admin", "2017-02-13 15:10:02", "5.158.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7427", "0", "magmainc.co", "2017-02-13 15:25:55", "176.197.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7428", "0", "admin", "2017-02-13 15:27:39", "185.26.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7429", "0", "magmainc.co", "2017-02-13 15:30:52", "94.25.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7430", "0", "admin", "2017-02-13 15:34:48", "195.96.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7431", "0", "magmainc.co", "2017-02-13 15:37:37", "212.11.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7432", "0", "admin", "2017-02-13 15:44:52", "188.232.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7433", "0", "magmainc.co", "2017-02-13 15:47:34", "31.173.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7434", "0", "admin", "2017-02-13 15:50:55", "37.145.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7435", "0", "magmainc.co", "2017-02-13 15:54:41", "89.175.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7436", "0", "admin", "2017-02-13 15:55:35", "188.68.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7437", "0", "magmainc.co", "2017-02-13 16:03:15", "62.133.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7438", "0", "admin", "2017-02-13 16:04:36", "176.52.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7439", "0", "magmainc.co", "2017-02-13 16:11:05", "37.145.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7440", "0", "admin", "2017-02-13 16:12:51", "83.219.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7441", "0", "magmainc.co", "2017-02-13 16:16:21", "213.160.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7442", "0", "admin", "2017-02-13 16:18:43", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7443", "0", "admin", "2017-02-13 16:26:49", "188.65.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7444", "0", "magmainc.co", "2017-02-13 16:26:58", "192.168.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7445", "0", "admin", "2017-02-13 16:36:09", "37.44.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7446", "0", "magmainc.co", "2017-02-13 16:36:39", "37.190.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7447", "0", "admin", "2017-02-13 16:42:59", "89.106.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7448", "0", "magmainc.co", "2017-02-13 16:54:40", "31.148.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7449", "0", "admin", "2017-02-13 16:58:18", "188.18.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7450", "0", "magmainc.co", "2017-02-13 17:02:13", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7451", "0", "admin", "2017-02-13 17:02:52", "188.162.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7452", "0", "admin", "2017-02-13 17:21:23", "178.34.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7453", "0", "magmainc.co", "2017-02-13 17:30:51", "109.94.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7454", "0", "admin", "2017-02-13 17:31:46", "151.26.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7455", "0", "magmainc.co", "2017-02-13 17:32:04", "91.107.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7456", "0", "magmainc.co", "2017-02-13 17:45:40", "188.18.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7457", "0", "admin", "2017-02-13 17:50:31", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7458", "0", "admin", "2017-02-13 17:51:48", "37.110.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7459", "0", "magmainc.co", "2017-02-13 17:53:16", "46.44.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7460", "0", "admin", "2017-02-13 18:08:44", "89.175.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7461", "0", "magmainc.co", "2017-02-13 18:21:25", "95.72.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7462", "0", "admin", "2017-02-13 18:23:14", "81.5.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7463", "0", "magmainc.co", "2017-02-13 18:37:16", "31.148.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7464", "0", "admin", "2017-02-13 18:39:36", "85.173.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7465", "0", "magmainc.co", "2017-02-13 18:48:49", "95.71.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7466", "0", "admin", "2017-02-13 19:00:39", "94.188.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7467", "0", "admin", "2017-02-13 19:02:34", "79.8.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7468", "0", "magmainc.co", "2017-02-13 19:05:08", "176.197.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7469", "0", "magmainc.co", "2017-02-13 19:06:55", "81.195.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7470", "0", "admin", "2017-02-13 19:10:13", "176.52.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7471", "0", "admin", "2017-02-13 19:22:59", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7472", "0", "magmainc.co", "2017-02-13 19:33:36", "213.155.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7473", "0", "bloemfontein", "2017-02-13 19:44:25", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7474", "0", "magmainc.co", "2017-02-13 19:47:43", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7475", "0", "admin", "2017-02-13 19:51:34", "81.5.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7476", "0", "admin", "2017-02-13 19:57:42", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7477", "0", "magmainc.co", "2017-02-13 19:59:39", "91.214.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7478", "0", "magmainc.co", "2017-02-13 20:12:47", "178.34.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7479", "0", "admin", "2017-02-13 20:22:44", "188.18.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7480", "0", "magmainc.co", "2017-02-13 20:30:32", "176.52.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7481", "0", "admin", "2017-02-13 20:32:39", "80.240.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7482", "0", "magmainc.co", "2017-02-13 20:46:40", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7483", "0", "admin", "2017-02-13 20:57:18", "31.148.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7484", "0", "magmainc.co", "2017-02-13 20:57:46", "89.189.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7485", "0", "magmainc.co", "2017-02-13 20:58:34", "5.44.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7486", "0", "admin", "2017-02-13 21:00:49", "77.73.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7487", "0", "magmainc.co", "2017-02-13 21:02:09", "176.210.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7488", "0", "admin", "2017-02-13 21:04:50", "109.252.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7489", "0", "magmainc.co", "2017-02-13 21:22:27", "95.245.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7490", "0", "admin", "2017-02-13 21:24:46", "89.175.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7491", "0", "magmainc.co", "2017-02-13 21:45:14", "185.13.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7492", "0", "admin", "2017-02-13 21:45:26", "80.240.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7493", "0", "admin", "2017-02-13 21:49:00", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7494", "0", "magmainc.co", "2017-02-13 21:49:08", "194.8.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7495", "0", "admin", "2017-02-13 22:07:34", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7496", "0", "magmainc.co", "2017-02-13 22:07:49", "89.175.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7497", "0", "admin", "2017-02-13 22:28:10", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7498", "0", "magmainc.co", "2017-02-13 22:52:37", "176.195.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7499", "0", "admin", "2017-02-13 23:11:30", "109.252.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7500", "0", "admin", "2017-02-13 23:43:12", "87.251.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7501", "0", "magmainc.co", "2017-02-13 23:52:08", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7502", "0", "admin", "2017-02-13 23:55:33", "195.114.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7503", "0", "magmainc.co", "2017-02-14 00:03:24", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7504", "0", "admin", "2017-02-14 00:12:41", "37.78.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7505", "0", "magmainc.co", "2017-02-14 00:21:09", "188.68.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7506", "0", "admin", "2017-02-14 00:35:35", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7507", "0", "magmainc.co", "2017-02-14 00:58:57", "90.152.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7508", "0", "admin", "2017-02-14 01:43:42", "83.149.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7509", "0", "admin", "2017-02-14 02:32:28", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7510", "0", "magmainc.co", "2017-02-14 03:42:00", "188.68.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7511", "0", "admin", "2017-02-14 03:59:40", "84.237.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7512", "0", "magmainc.co", "2017-02-14 04:18:32", "176.52.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7513", "0", "admin", "2017-02-14 04:28:49", "195.91.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7514", "0", "magmainc.co", "2017-02-14 04:31:41", "84.237.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7515", "0", "admin", "2017-02-14 04:40:06", "176.52.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7516", "0", "magmainc.co", "2017-02-14 04:59:54", "31.211.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7517", "0", "admin", "2017-02-14 05:05:03", "46.173.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7518", "0", "magmainc.co", "2017-02-14 05:50:40", "80.240.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7519", "0", "admin", "2017-02-14 05:58:47", "195.62.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7520", "0", "magmainc.co", "2017-02-14 05:59:37", "185.57.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7521", "0", "admin", "2017-02-14 06:05:55", "99.226.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7522", "0", "magmainc.co", "2017-02-14 06:06:04", "77.37.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7523", "0", "admin", "2017-02-14 06:09:52", "185.184.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7524", "0", "magmainc.co", "2017-02-14 06:15:06", "89.175.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7525", "0", "admin", "2017-02-14 06:18:03", "5.44.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7526", "0", "magmainc.co", "2017-02-14 06:22:45", "195.218.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7527", "0", "admin", "2017-02-14 06:49:55", "94.28.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7528", "0", "magmainc.co", "2017-02-14 06:50:41", "176.197.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7529", "0", "admin", "2017-02-14 06:53:05", "89.175.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7530", "0", "magmainc.co", "2017-02-14 06:57:50", "5.44.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7531", "0", "admin", "2017-02-14 07:05:20", "80.240.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7532", "1", "admin8576", "2017-02-14 07:12:58", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7533", "1", "admin8576", "2017-02-14 07:12:59", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7534", "1", "admin8576", "2017-02-14 07:13:00", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7535", "0", "magmainc.co", "2017-02-14 07:13:17", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7536", "0", "admin", "2017-02-14 07:16:26", "109.252.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7537", "0", "magmainc.co", "2017-02-14 07:20:09", "5.158.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7538", "0", "admin", "2017-02-14 07:21:50", "195.93.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7539", "0", "magmainc.co", "2017-02-14 07:31:33", "188.43.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7540", "0", "magmainc.co", "2017-02-14 07:47:07", "176.195.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7541", "0", "admin", "2017-02-14 07:51:55", "188.232.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7542", "0", "magmainc.co", "2017-02-14 07:52:54", "213.155.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7543", "0", "admin", "2017-02-14 07:58:43", "217.118.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7544", "0", "magmainc.co", "2017-02-14 08:01:39", "212.220.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7545", "0", "admin", "2017-02-14 08:05:51", "145.255.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7546", "0", "magmainc.co", "2017-02-14 08:06:56", "91.210.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7547", "0", "admin", "2017-02-14 08:10:37", "81.17.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7548", "0", "magmainc.co", "2017-02-14 08:19:55", "46.151.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7549", "0", "magmainc.co", "2017-02-14 08:23:57", "31.173.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7550", "0", "admin", "2017-02-14 08:24:33", "109.169.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7551", "0", "admin", "2017-02-14 08:36:28", "195.114.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7552", "0", "magmainc.co", "2017-02-14 08:49:44", "95.79.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7553", "0", "admin", "2017-02-14 09:02:23", "83.151.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7554", "0", "admin", "2017-02-14 09:18:56", "178.140.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7555", "0", "admin", "2017-02-14 09:36:22", "82.112.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7556", "0", "magmainc.co", "2017-02-14 09:39:20", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7557", "0", "admin", "2017-02-14 09:42:35", "86.102.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7558", "0", "admin", "2017-02-14 09:54:28", "109.174.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7559", "0", "magmainc.co", "2017-02-14 10:03:19", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7560", "0", "admin", "2017-02-14 10:12:33", "188.43.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7561", "0", "magmainc.co", "2017-02-14 10:13:52", "80.91.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7562", "0", "admin", "2017-02-14 10:15:47", "46.147.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7563", "0", "admin", "2017-02-14 10:15:49", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7564", "0", "magmainc.co", "2017-02-14 10:17:23", "62.117.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7565", "0", "admin", "2017-02-14 10:26:53", "91.221.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7566", "0", "magmainc.co", "2017-02-14 10:36:53", "95.79.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7567", "0", "admin", "2017-02-14 10:51:44", "83.151.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7568", "0", "magmainc.co", "2017-02-14 10:57:26", "188.18.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7569", "0", "admin", "2017-02-14 11:01:11", "85.26.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7570", "0", "magmainc.co", "2017-02-14 11:03:50", "91.221.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7571", "0", "admin", "2017-02-14 11:09:01", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7572", "0", "admin", "2017-02-14 11:16:12", "94.25.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7573", "0", "magmainc.co", "2017-02-14 11:17:37", "176.114.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7574", "0", "admin", "2017-02-14 11:20:31", "46.147.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7575", "0", "admin", "2017-02-14 11:28:45", "86.102.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7576", "0", "magmainc.co", "2017-02-14 11:53:56", "178.236.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7577", "0", "admin", "2017-02-14 13:00:58", "176.125.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7578", "0", "magmainc.co", "2017-02-14 13:16:17", "91.205.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7579", "0", "magmainc.co", "2017-02-14 13:26:24", "217.114.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7580", "0", "admin", "2017-02-14 13:32:37", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7581", "0", "magmainc.co", "2017-02-14 13:38:08", "37.44.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7582", "0", "admin", "2017-02-14 13:43:07", "109.206.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7583", "0", "magmainc.co", "2017-02-14 13:44:29", "83.149.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7584", "0", "admin", "2017-02-14 13:47:39", "81.30.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7585", "0", "magmainc.co", "2017-02-14 13:54:10", "46.151.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7586", "0", "magmainc.co", "2017-02-14 13:57:33", "109.195.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7587", "0", "admin", "2017-02-14 15:35:49", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7588", "0", "magmainc.co", "2017-02-14 15:53:51", "95.79.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7589", "0", "admin", "2017-02-14 15:56:21", "212.100.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7590", "0", "magmainc.co", "2017-02-14 16:00:40", "176.106.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7591", "0", "admin", "2017-02-14 16:09:18", "94.232.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7592", "0", "admin", "2017-02-14 16:13:41", "5.44.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7593", "0", "magmainc.co", "2017-02-14 16:14:38", "192.166.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7594", "0", "admin", "2017-02-14 16:17:47", "145.255.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7595", "0", "magmainc.co", "2017-02-14 16:25:53", "94.25.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7596", "0", "admin", "2017-02-14 16:27:59", "77.37.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7597", "0", "magmainc.co", "2017-02-14 16:31:32", "176.107.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7598", "0", "admin", "2017-02-14 16:40:58", "178.216.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7599", "0", "magmainc.co", "2017-02-14 16:48:33", "217.58.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7600", "0", "admin", "2017-02-14 16:54:29", "185.184.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7601", "0", "magmainc.co", "2017-02-14 17:03:57", "151.26.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7602", "0", "admin", "2017-02-14 17:04:48", "188.18.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7603", "0", "admin", "2017-02-14 17:11:30", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7604", "0", "magmainc.co", "2017-02-14 17:25:05", "95.30.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7605", "0", "admin", "2017-02-14 17:27:48", "188.13.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7606", "0", "magmainc.co", "2017-02-14 17:31:14", "88.206.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7607", "0", "admin", "2017-02-14 17:37:06", "217.172.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7608", "0", "magmainc.co", "2017-02-14 17:42:22", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7609", "0", "admin", "2017-02-14 17:44:50", "87.255.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7610", "0", "magmainc.co", "2017-02-14 17:50:22", "188.125.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7611", "0", "admin", "2017-02-14 17:56:32", "213.242.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7612", "0", "admin", "2017-02-14 17:59:00", "93.61.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7613", "0", "magmainc.co", "2017-02-14 18:02:33", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7614", "0", "admin", "2017-02-14 18:04:34", "185.54.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7615", "0", "magmainc.co", "2017-02-14 18:05:00", "91.148.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7616", "0", "admin", "2017-02-14 18:11:42", "178.204.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7617", "0", "magmainc.co", "2017-02-14 18:14:20", "94.24.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7618", "0", "admin", "2017-02-14 18:16:49", "178.167.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7619", "0", "magmainc.co", "2017-02-14 18:20:44", "109.252.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7620", "0", "bloemfontein", "2017-02-14 18:21:15", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7621", "0", "admin", "2017-02-14 18:24:07", "5.141.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7622", "0", "admin", "2017-02-14 18:25:40", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7623", "0", "magmainc.co", "2017-02-14 18:26:29", "83.149.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7624", "0", "magmainc.co", "2017-02-14 18:47:55", "181.14.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7625", "0", "admin", "2017-02-14 18:50:13", "79.1.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7626", "0", "magmainc.co", "2017-02-14 18:50:20", "185.3.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7627", "0", "admin", "2017-02-14 18:55:33", "85.173.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7628", "0", "magmainc.co", "2017-02-14 18:57:18", "213.33.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7629", "0", "admin", "2017-02-14 19:02:17", "213.242.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7630", "0", "magmainc.co", "2017-02-14 19:15:22", "109.196.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7631", "1", "admin8576", "2017-02-14 19:42:37", "177.159.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7632", "0", "magmainc.co", "2017-02-14 19:50:22", "2.226.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7633", "0", "admin", "2017-02-14 19:56:57", "185.3.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7634", "0", "magmainc.co", "2017-02-14 19:56:59", "10.8.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7635", "0", "admin", "2017-02-14 19:58:21", "91.193.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7636", "0", "admin", "2017-02-14 20:05:32", "80.19.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7637", "0", "admin", "2017-02-14 20:10:36", "95.72.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7638", "0", "magmainc.co", "2017-02-14 20:18:34", "95.221.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7639", "0", "admin", "2017-02-14 20:30:55", "83.235.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7640", "0", "magmainc.co", "2017-02-14 20:32:00", "83.102.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7641", "0", "admin", "2017-02-14 20:32:01", "188.18.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7642", "0", "magmainc.co", "2017-02-14 20:42:39", "188.18.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7643", "0", "admin", "2017-02-14 20:56:44", "93.100.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7644", "0", "magmainc.co", "2017-02-14 21:05:10", "92.242.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7645", "0", "admin", "2017-02-14 21:09:28", "5.3.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7646", "0", "admin", "2017-02-14 21:13:17", "93.61.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7647", "0", "magmainc.co", "2017-02-14 21:15:09", "79.17.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7648", "0", "sandton", "2017-02-14 21:25:17", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7649", "0", "admin", "2017-02-14 21:32:40", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7650", "0", "advisors", "2017-02-14 21:34:20", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7651", "0", "magmainc.co", "2017-02-14 22:11:05", "93.170.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7652", "0", "admin", "2017-02-14 22:20:45", "46.158.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7653", "0", "magmainc.co", "2017-02-14 22:21:23", "195.91.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7654", "0", "magmainc.co", "2017-02-14 22:33:04", "85.192.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7655", "0", "admin", "2017-02-14 22:39:40", "151.43.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7656", "0", "magmainc.co", "2017-02-14 22:44:48", "46.39.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7657", "0", "magmainc.co", "2017-02-14 22:51:56", "217.107.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7658", "0", "admin", "2017-02-14 22:54:33", "193.233.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7659", "0", "admin", "2017-02-14 22:59:50", "87.229.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7660", "0", "magmainc.co", "2017-02-14 23:01:44", "31.130.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7661", "0", "magmainc.co", "2017-02-14 23:05:31", "85.173.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7662", "0", "admin", "2017-02-14 23:07:28", "195.91.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7663", "0", "admin", "2017-02-14 23:12:14", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7664", "0", "magmainc.co", "2017-02-14 23:21:18", "85.236.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7665", "0", "admin", "2017-02-14 23:26:02", "92.252.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7666", "0", "magmainc.co", "2017-02-14 23:29:34", "87.255.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7667", "0", "magmainc.co", "2017-02-14 23:34:34", "79.120.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7668", "0", "magmainc.co", "2017-02-14 23:43:54", "62.183.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7669", "0", "magmainc.co", "2017-02-14 23:46:41", "195.91.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7670", "0", "magmainc.co", "2017-02-15 00:01:57", "185.57.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7671", "0", "magmainc.co", "2017-02-15 00:33:27", "81.1.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7672", "0", "magmainc.co", "2017-02-15 02:10:28", "178.44.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7673", "0", "admin", "2017-02-15 02:11:22", "195.6.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7674", "0", "admin", "2017-02-15 02:25:54", "88.200.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7675", "0", "magmainc.co", "2017-02-15 02:31:14", "46.158.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7676", "0", "admin", "2017-02-15 02:32:10", "91.232.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7677", "0", "magmainc.co", "2017-02-15 03:01:54", "81.30.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7678", "0", "admin", "2017-02-15 03:07:52", "185.13.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7679", "0", "magmainc.co", "2017-02-15 03:08:37", "195.218.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7680", "0", "admin", "2017-02-15 03:14:53", "5.8.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7681", "0", "magmainc.co", "2017-02-15 03:23:41", "37.112.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7682", "0", "magmainc.co", "2017-02-15 03:46:41", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7683", "0", "admin", "2017-02-15 04:32:26", "31.173.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7684", "0", "admin", "2017-02-15 04:33:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7685", "0", "magmainc.co", "2017-02-15 04:39:20", "95.169.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7686", "0", "admin", "2017-02-15 04:42:44", "79.50.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7687", "0", "magmainc.co", "2017-02-15 04:52:16", "85.236.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7688", "0", "admin", "2017-02-15 04:57:11", "109.233.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7689", "0", "magmainc.co", "2017-02-15 05:11:33", "95.189.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7690", "0", "admin", "2017-02-15 05:13:44", "195.6.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7691", "0", "magmainc.co", "2017-02-15 05:21:42", "92.252.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7692", "0", "admin", "2017-02-15 05:24:24", "195.6.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7693", "0", "magmainc.co", "2017-02-15 05:33:17", "185.184.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7694", "0", "admin", "2017-02-15 05:34:44", "188.191.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7695", "0", "magmainc.co", "2017-02-15 05:39:26", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7696", "0", "magmainc.co", "2017-02-15 05:43:44", "188.18.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7697", "0", "admin", "2017-02-15 05:44:42", "188.68.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7698", "0", "magmainc.co", "2017-02-15 05:55:44", "90.152.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7699", "0", "admin", "2017-02-15 06:16:08", "94.230.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7700", "0", "magmainc.co", "2017-02-15 06:24:21", "80.18.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7701", "0", "admin", "2017-02-15 06:33:00", "91.227.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7702", "0", "magmainc.co", "2017-02-15 06:36:14", "109.195.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7703", "0", "magmainc.co", "2017-02-15 06:39:50", "212.57.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7704", "0", "admin", "2017-02-15 06:51:47", "178.167.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7705", "0", "magmainc.co", "2017-02-15 07:08:37", "82.112.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7706", "0", "magmainc.co", "2017-02-15 07:14:55", "31.173.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7707", "0", "admin", "2017-02-15 07:14:57", "87.103.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7708", "0", "admin", "2017-02-15 07:19:21", "5.139.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7709", "0", "magmainc.co", "2017-02-15 07:20:46", "89.175.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7710", "0", "admin", "2017-02-15 07:21:38", "176.125.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7711", "0", "magmainc.co", "2017-02-15 07:22:33", "145.255.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7712", "0", "magmainc.co", "2017-02-15 07:24:05", "94.230.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7713", "0", "admin", "2017-02-15 07:24:06", "62.117.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7714", "0", "admin", "2017-02-15 07:25:17", "5.140.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7715", "0", "magmainc.co", "2017-02-15 07:25:47", "109.233.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7716", "0", "admin", "2017-02-15 07:27:27", "195.68.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7717", "0", "magmainc.co", "2017-02-15 07:32:49", "82.112.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7718", "0", "admin", "2017-02-15 07:38:24", "178.34.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7719", "0", "magmainc.co", "2017-02-15 07:43:34", "46.0.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7720", "0", "admin", "2017-02-15 07:44:23", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7721", "0", "magmainc.co", "2017-02-15 07:53:01", "37.230.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7722", "0", "admin", "2017-02-15 07:54:20", "195.68.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7723", "0", "magmainc.co", "2017-02-15 07:57:07", "217.117.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7724", "0", "admin", "2017-02-15 08:00:06", "185.108.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7725", "0", "magmainc.co", "2017-02-15 08:01:02", "62.133.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7726", "0", "admin", "2017-02-15 08:03:18", "176.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7727", "0", "magmainc.co", "2017-02-15 08:04:59", "176.195.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7728", "0", "admin", "2017-02-15 08:12:00", "62.117.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7729", "0", "magmainc.co", "2017-02-15 08:25:40", "176.195.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7730", "0", "admin", "2017-02-15 08:25:42", "81.1.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7731", "0", "magmainc.co", "2017-02-15 08:28:03", "188.162.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7732", "0", "admin", "2017-02-15 08:31:14", "79.13.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7733", "0", "admin", "2017-02-15 08:59:13", "109.233.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7734", "0", "magmainc.co", "2017-02-15 09:07:50", "88.215.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7735", "0", "admin", "2017-02-15 09:08:32", "46.0.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7736", "0", "magmainc.co", "2017-02-15 09:10:51", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7737", "0", "admin", "2017-02-15 09:12:38", "90.152.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7738", "0", "magmainc.co", "2017-02-15 09:21:34", "91.107.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7739", "0", "admin", "2017-02-15 09:22:39", "109.226.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7740", "0", "magmainc.co", "2017-02-15 09:26:03", "195.6.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7741", "0", "admin", "2017-02-15 09:28:12", "213.129.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7742", "0", "magmainc.co", "2017-02-15 09:29:09", "176.213.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7743", "0", "admin", "2017-02-15 09:35:28", "89.249.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7744", "0", "magmainc.co", "2017-02-15 09:50:17", "83.171.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7745", "0", "admin", "2017-02-15 10:00:59", "188.191.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7746", "0", "magmainc.co", "2017-02-15 10:02:03", "95.179.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7747", "0", "magmainc.co", "2017-02-15 10:26:54", "80.240.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7748", "0", "admin", "2017-02-15 10:29:57", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7749", "0", "magmainc.co", "2017-02-15 10:32:56", "5.167.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7750", "0", "admin", "2017-02-15 10:34:24", "195.68.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7751", "0", "magmainc.co", "2017-02-15 10:36:41", "83.219.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7752", "0", "admin", "2017-02-15 10:40:26", "176.117.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7753", "0", "admin", "2017-02-15 10:49:11", "176.195.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7754", "0", "admin", "2017-02-15 11:09:42", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7755", "0", "magmainc.co", "2017-02-15 11:12:24", "94.255.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7756", "0", "admin", "2017-02-15 11:19:53", "176.114.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7757", "0", "magmainc.co", "2017-02-15 11:33:03", "95.179.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7758", "0", "admin", "2017-02-15 11:53:22", "178.34.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7759", "0", "admin", "2017-02-15 11:55:12", "185.13.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7760", "0", "magmainc.co", "2017-02-15 11:55:24", "92.242.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7761", "0", "magmainc.co", "2017-02-15 12:15:45", "89.250.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7762", "0", "magmainc.co", "2017-02-15 12:30:11", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7763", "0", "admin", "2017-02-15 12:59:15", "88.215.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7764", "0", "magmainc.co", "2017-02-15 13:01:49", "95.106.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7765", "0", "admin", "2017-02-15 13:08:02", "37.44.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7766", "0", "magmainc.co", "2017-02-15 13:09:38", "188.18.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7767", "0", "admin", "2017-02-15 13:27:10", "176.114.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7768", "0", "magmainc.co", "2017-02-15 13:36:35", "188.35.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7769", "0", "admin", "2017-02-15 13:38:12", "91.227.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7770", "0", "admin", "2017-02-15 13:40:16", "91.210.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7771", "0", "magmainc.co", "2017-02-15 13:40:23", "109.111.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7772", "0", "admin", "2017-02-15 13:52:00", "46.158.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7773", "0", "magmainc.co", "2017-02-15 13:54:35", "178.34.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7774", "0", "magmainc.co", "2017-02-15 14:12:05", "88.215.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7775", "0", "admin", "2017-02-15 14:14:02", "92.255.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7776", "0", "admin", "2017-02-15 14:21:07", "188.68.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7777", "0", "magmainc.co", "2017-02-15 14:31:04", "212.100.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7778", "0", "admin", "2017-02-15 14:58:21", "212.100.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7779", "0", "magmainc.co", "2017-02-15 14:59:26", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7780", "0", "admin", "2017-02-15 15:17:08", "80.240.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7781", "0", "magmainc.co", "2017-02-15 15:20:44", "89.107.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7782", "0", "admin", "2017-02-15 15:25:51", "79.120.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7783", "0", "magmainc.co", "2017-02-15 15:40:53", "5.167.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7784", "0", "admin", "2017-02-15 15:47:08", "85.236.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7785", "0", "admin", "2017-02-15 15:47:13", "77.35.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7786", "0", "magmainc.co", "2017-02-15 15:47:35", "37.18.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7787", "0", "magmainc.co", "2017-02-15 16:16:02", "94.255.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7788", "0", "attending", "2017-02-15 16:16:17", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7789", "0", "admin", "2017-02-15 16:28:31", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7790", "0", "magmainc.co", "2017-02-15 16:46:12", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7791", "0", "admin", "2017-02-15 17:12:09", "176.114.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7792", "0", "admin", "2017-02-15 17:34:50", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7793", "0", "magmainc.co", "2017-02-15 17:35:24", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7794", "0", "admin", "2017-02-15 18:35:16", "81.1.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7795", "0", "magmainc.co", "2017-02-15 18:41:57", "77.37.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7796", "0", "magmainc.co", "2017-02-15 19:32:27", "80.18.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7797", "0", "admin", "2017-02-15 19:33:18", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7798", "0", "magmainc.co", "2017-02-15 19:47:57", "37.44.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7799", "0", "admin", "2017-02-15 19:52:06", "91.210.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7800", "0", "magmainc.co", "2017-02-15 19:56:46", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7801", "0", "admin", "2017-02-15 20:22:41", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7802", "0", "magmainc.co", "2017-02-15 20:28:11", "81.1.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7803", "0", "admin", "2017-02-15 21:00:46", "37.44.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7804", "0", "admin", "2017-02-15 21:09:19", "37.78.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7805", "0", "admin", "2017-02-15 21:49:38", "176.114.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7806", "0", "magmainc.co", "2017-02-15 22:17:20", "77.37.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7807", "0", "admin", "2017-02-15 22:20:45", "178.204.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7808", "0", "about", "2017-02-15 22:26:45", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7809", "0", "magmainc.co", "2017-02-15 22:27:15", "178.140.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7810", "0", "admin", "2017-02-15 22:30:32", "93.170.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7811", "0", "magmainc.co", "2017-02-15 22:36:56", "195.91.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7812", "0", "admin", "2017-02-15 22:41:18", "46.39.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7813", "0", "magmainc.co", "2017-02-15 22:47:37", "188.15.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7814", "0", "admin", "2017-02-15 22:58:28", "128.75.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7815", "0", "magmainc.co", "2017-02-15 23:01:46", "213.156.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7816", "0", "admin", "2017-02-15 23:09:30", "87.255.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7817", "0", "admin", "2017-02-15 23:17:34", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7818", "0", "magmainc.co", "2017-02-15 23:17:51", "188.162.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7819", "0", "magmainc.co", "2017-02-15 23:27:03", "212.11.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7820", "0", "magmainc.co", "2017-02-15 23:36:09", "190.198.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7821", "0", "admin", "2017-02-15 23:42:14", "85.173.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7822", "0", "magmainc.co", "2017-02-15 23:50:23", "195.62.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7823", "0", "admin", "2017-02-15 23:56:49", "178.204.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7824", "0", "magmainc.co", "2017-02-15 23:58:29", "185.54.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7825", "0", "admin", "2017-02-16 00:01:06", "190.198.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7826", "0", "magmainc.co", "2017-02-16 00:02:23", "85.26.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7827", "0", "admin", "2017-02-16 00:23:29", "185.13.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7828", "0", "magmainc.co", "2017-02-16 00:31:50", "37.18.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7829", "0", "admin", "2017-02-16 00:45:39", "188.15.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7830", "0", "magmainc.co", "2017-02-16 00:53:33", "178.161.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7831", "0", "admin", "2017-02-16 01:04:41", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7832", "0", "admin", "2017-02-16 01:39:00", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7833", "0", "magmainc.co", "2017-02-16 01:57:08", "83.219.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7834", "0", "admin", "2017-02-16 02:07:55", "91.227.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7835", "0", "magmainc.co", "2017-02-16 02:22:06", "86.62.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7836", "0", "admin", "2017-02-16 02:46:38", "5.44.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7837", "0", "magmainc.co", "2017-02-16 03:20:16", "90.151.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7838", "0", "admin", "2017-02-16 03:21:58", "212.11.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7839", "0", "magmainc.co", "2017-02-16 03:33:06", "93.177.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7840", "0", "admin", "2017-02-16 04:00:37", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7841", "0", "magmainc.co", "2017-02-16 04:00:48", "195.62.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7842", "0", "magmainc.co", "2017-02-16 04:25:27", "62.117.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7843", "0", "black", "2017-02-16 04:30:29", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7844", "0", "admin", "2017-02-16 04:33:19", "95.238.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7845", "0", "magmainc.co", "2017-02-16 04:39:12", "62.117.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7846", "0", "admin", "2017-02-16 05:14:13", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7847", "0", "magmainc.co", "2017-02-16 05:27:23", "87.251.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7848", "0", "magmainc.co", "2017-02-16 05:54:38", "31.173.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7849", "0", "admin", "2017-02-16 05:58:01", "190.198.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7850", "0", "magmainc.co", "2017-02-16 06:05:06", "37.113.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7851", "0", "admin", "2017-02-16 06:07:03", "93.170.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7852", "0", "magmainc.co", "2017-02-16 06:13:57", "185.124.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7853", "0", "883", "2017-02-16 06:15:40", "5.39.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7854", "0", "admin", "2017-02-16 06:25:26", "80.18.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7855", "0", "magmainc.co", "2017-02-16 06:26:28", "212.122.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7856", "0", "admin", "2017-02-16 06:28:19", "37.113.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7857", "0", "magmainc.co", "2017-02-16 06:42:11", "128.75.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7858", "0", "admin", "2017-02-16 06:44:23", "212.220.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7859", "0", "magmainc.co", "2017-02-16 06:45:20", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7860", "0", "distinguished", "2017-02-16 06:56:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7861", "0", "admin", "2017-02-16 06:56:46", "77.35.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7862", "0", "magmainc.co", "2017-02-16 07:00:52", "5.199.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7863", "0", "notaries", "2017-02-16 07:06:32", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7864", "0", "admin", "2017-02-16 07:07:28", "178.167.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7865", "0", "magmainc.co", "2017-02-16 07:20:33", "87.251.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7866", "0", "admin", "2017-02-16 07:23:32", "212.122.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7867", "0", "magmainc.co", "2017-02-16 07:33:51", "37.230.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7868", "0", "admin", "2017-02-16 07:34:33", "195.62.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7869", "0", "magmainc.co", "2017-02-16 07:47:33", "188.168.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7870", "0", "magmainc.co", "2017-02-16 07:57:57", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7871", "0", "admin", "2017-02-16 08:08:52", "62.133.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7872", "0", "magmainc.co", "2017-02-16 08:10:11", "188.191.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7873", "0", "admin", "2017-02-16 08:11:25", "95.106.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7874", "0", "magmainc.co", "2017-02-16 08:16:03", "193.233.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7875", "0", "admin", "2017-02-16 08:19:26", "62.117.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7876", "0", "magmainc.co", "2017-02-16 08:22:45", "93.40.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7877", "0", "admin", "2017-02-16 08:24:41", "62.183.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7878", "0", "magmainc.co", "2017-02-16 08:42:47", "188.15.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7879", "0", "admin", "2017-02-16 08:52:01", "91.227.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7880", "0", "magmainc.co", "2017-02-16 08:56:08", "81.1.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7881", "0", "admin", "2017-02-16 08:56:47", "93.85.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7882", "0", "magmainc.co", "2017-02-16 09:01:08", "46.50.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7883", "0", "admin", "2017-02-16 09:05:12", "145.255.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7884", "0", "magmainc.co", "2017-02-16 09:18:52", "195.218.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7885", "0", "admin", "2017-02-16 09:20:44", "95.106.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7886", "0", "magmainc.co", "2017-02-16 09:34:00", "91.210.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7887", "0", "admin", "2017-02-16 09:34:32", "46.151.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7888", "0", "magmainc.co", "2017-02-16 09:49:27", "73.185.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7889", "0", "admin", "2017-02-16 09:52:05", "94.25.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7890", "0", "magmainc.co", "2017-02-16 10:00:50", "212.11.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7891", "0", "admin", "2017-02-16 10:05:31", "62.183.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7892", "0", "magmainc.co", "2017-02-16 10:10:30", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7893", "0", "admin", "2017-02-16 10:11:42", "188.18.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7894", "0", "magmainc.co", "2017-02-16 10:16:49", "77.243.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7895", "0", "magmainc.co", "2017-02-16 10:24:08", "195.62.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7896", "0", "admin", "2017-02-16 10:31:10", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7897", "0", "magmainc.co", "2017-02-16 10:36:48", "46.44.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7898", "0", "admin", "2017-02-16 10:43:00", "92.242.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7899", "0", "magmainc.co", "2017-02-16 10:46:58", "84.237.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7900", "0", "admin", "2017-02-16 10:55:20", "158.46.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7901", "0", "magmainc.co", "2017-02-16 11:02:43", "77.232.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7902", "0", "admin", "2017-02-16 11:03:01", "91.225.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7903", "0", "magmainc.co", "2017-02-16 11:05:12", "5.199.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7904", "0", "sandton", "2017-02-16 11:06:27", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7905", "0", "admin", "2017-02-16 11:09:53", "79.47.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7906", "0", "admin", "2017-02-16 11:15:54", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7907", "0", "magmainc.co", "2017-02-16 11:24:22", "46.191.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7908", "0", "admin", "2017-02-16 11:26:47", "109.169.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7909", "0", "admin", "2017-02-16 11:29:26", "46.148.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7910", "0", "magmainc.co", "2017-02-16 11:29:29", "212.100.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7911", "0", "magmainc.co", "2017-02-16 11:35:02", "79.47.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7912", "0", "admin", "2017-02-16 11:35:48", "46.242.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7913", "0", "magmainc.co", "2017-02-16 11:42:42", "94.255.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7914", "0", "magmainc.co", "2017-02-16 11:46:36", "94.41.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7915", "0", "admin", "2017-02-16 11:46:36", "109.169.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7916", "0", "admin", "2017-02-16 11:47:45", "46.191.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7917", "0", "magmainc.co", "2017-02-16 11:52:33", "91.204.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7918", "0", "magmainc.co", "2017-02-16 11:54:29", "31.173.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7919", "0", "admin", "2017-02-16 11:58:26", "217.114.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7920", "0", "admin", "2017-02-16 12:06:56", "87.255.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7921", "0", "magmainc.co", "2017-02-16 12:09:20", "93.88.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7922", "0", "admin", "2017-02-16 12:13:46", "188.186.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7923", "0", "magmainc.co", "2017-02-16 12:21:57", "176.124.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7924", "0", "admin", "2017-02-16 12:27:25", "91.225.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7925", "0", "magmainc.co", "2017-02-16 12:32:39", "95.73.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7926", "0", "admin", "2017-02-16 12:37:30", "188.162.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7927", "0", "magmainc.co", "2017-02-16 12:37:32", "83.220.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7928", "0", "admin", "2017-02-16 12:41:58", "109.111.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7929", "0", "magmainc.co", "2017-02-16 12:45:25", "88.149.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7930", "0", "admin", "2017-02-16 12:47:34", "188.234.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7931", "0", "magmainc.co", "2017-02-16 12:54:49", "2.226.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7932", "0", "admin", "2017-02-16 13:06:32", "94.255.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7933", "0", "magmainc.co", "2017-02-16 13:12:54", "82.112.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7934", "0", "admin", "2017-02-16 13:14:20", "93.85.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7935", "0", "magmainc.co", "2017-02-16 13:15:33", "78.138.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7936", "0", "admin", "2017-02-16 13:20:06", "95.73.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7937", "0", "magmainc.co", "2017-02-16 13:21:35", "5.140.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7938", "0", "magmainc.co", "2017-02-16 13:26:15", "188.18.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7939", "0", "admin", "2017-02-16 13:28:19", "192.168.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7940", "0", "admin", "2017-02-16 13:31:58", "195.19.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7941", "0", "magmainc.co", "2017-02-16 13:36:40", "158.46.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7942", "0", "admin", "2017-02-16 13:38:23", "178.234.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7943", "0", "magmainc.co", "2017-02-16 13:42:15", "94.25.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7944", "0", "admin", "2017-02-16 13:43:01", "193.233.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7945", "0", "magmainc.co", "2017-02-16 13:54:56", "41.230.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7946", "0", "admin", "2017-02-16 13:59:00", "77.243.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7947", "0", "magmainc.co", "2017-02-16 14:03:02", "81.20.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7948", "0", "admin", "2017-02-16 14:12:51", "91.232.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7949", "0", "admin", "2017-02-16 14:22:03", "91.107.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7950", "0", "magmainc.co", "2017-02-16 14:28:18", "217.114.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7951", "0", "admin", "2017-02-16 14:28:39", "94.25.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7952", "0", "magmainc.co", "2017-02-16 14:28:53", "85.26.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7953", "0", "admin", "2017-02-16 14:34:29", "212.109.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7954", "0", "magmainc.co", "2017-02-16 14:39:38", "212.23.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7955", "0", "admin", "2017-02-16 14:40:27", "94.188.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7956", "0", "magmainc.co", "2017-02-16 14:42:48", "46.29.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7957", "0", "admin", "2017-02-16 14:43:40", "81.4.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7958", "0", "magmainc.co", "2017-02-16 14:44:42", "77.35.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7959", "0", "admin", "2017-02-16 14:49:41", "81.20.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7960", "0", "magmainc.co", "2017-02-16 15:03:21", "109.195.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7961", "0", "magmainc.co", "2017-02-16 15:07:34", "94.25.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7962", "0", "admin", "2017-02-16 15:16:37", "91.107.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7963", "0", "magmainc.co", "2017-02-16 15:19:27", "5.143.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7964", "0", "admin", "2017-02-16 15:22:48", "178.140.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7965", "0", "admin", "2017-02-16 15:34:32", "78.138.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7966", "0", "magmainc.co", "2017-02-16 15:40:17", "91.247.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7967", "0", "admin", "2017-02-16 15:48:02", "79.122.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7968", "0", "magmainc.co", "2017-02-16 15:53:03", "195.96.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7969", "0", "admin", "2017-02-16 15:54:59", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7970", "0", "magmainc.co", "2017-02-16 16:00:34", "94.188.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7971", "0", "admin", "2017-02-16 16:04:45", "176.213.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7972", "1", "admin8576", "2017-02-16 16:07:36", "206.214.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7973", "0", "admin", "2017-02-16 16:08:47", "188.191.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7974", "0", "magmainc.co", "2017-02-16 16:10:25", "5.44.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7975", "0", "admin", "2017-02-16 16:14:18", "5.167.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7976", "0", "magmainc.co", "2017-02-16 16:25:49", "194.186.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7977", "0", "admin", "2017-02-16 16:31:25", "80.18.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7978", "0", "magmainc.co", "2017-02-16 16:33:40", "94.25.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7979", "0", "admin", "2017-02-16 16:40:57", "83.220.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7980", "0", "magmainc.co", "2017-02-16 16:46:28", "81.1.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7981", "0", "admin", "2017-02-16 16:50:18", "176.215.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7982", "0", "magmainc.co", "2017-02-16 16:51:59", "93.85.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7983", "0", "admin", "2017-02-16 16:52:40", "62.182.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7984", "0", "magmainc.co", "2017-02-16 16:56:48", "109.195.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7985", "0", "admin", "2017-02-16 16:58:41", "89.106.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7986", "1", "admin8576", "2017-02-16 17:00:33", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7987", "0", "magmainc.co", "2017-02-16 17:22:39", "81.30.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7988", "1", "admin8576", "2017-02-16 17:24:57", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7989", "0", "admin", "2017-02-16 17:40:09", "89.109.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7990", "0", "magmainc.co", "2017-02-16 17:44:46", "195.234.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7991", "1", "admin8576", "2017-02-16 18:04:07", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7992", "0", "magmainc.co", "2017-02-16 18:07:09", "93.40.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7993", "1", "admin8576", "2017-02-16 18:23:15", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7994", "0", "admin", "2017-02-16 18:26:10", "195.234.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7995", "0", "magmainc.co", "2017-02-16 18:36:20", "95.26.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7996", "0", "admin", "2017-02-16 18:38:27", "89.105.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7997", "0", "magmainc.co", "2017-02-16 18:38:54", "46.235.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7998", "1", "admin8576", "2017-02-16 18:40:50", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("7999", "0", "admin", "2017-02-16 18:46:14", "91.79.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8000", "1", "admin8576", "2017-02-16 18:58:33", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8001", "0", "magmainc.co", "2017-02-16 19:05:33", "81.195.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8002", "0", "admin", "2017-02-16 19:09:22", "89.105.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8003", "1", "admin8576", "2017-02-16 19:16:16", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8004", "0", "magmainc.co", "2017-02-16 19:18:17", "2.92.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8005", "0", "admin", "2017-02-16 19:19:15", "5.39.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8006", "0", "magmainc.co", "2017-02-16 19:25:32", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8007", "0", "admin", "2017-02-16 19:29:07", "109.94.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8008", "0", "magmainc.co", "2017-02-16 19:31:20", "94.25.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8009", "0", "admin", "2017-02-16 19:33:09", "91.79.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8010", "1", "admin8576", "2017-02-16 19:34:03", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8011", "0", "magmainc.co", "2017-02-16 19:34:15", "188.32.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8012", "0", "admin", "2017-02-16 19:34:22", "46.39.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8013", "0", "magmainc.co", "2017-02-16 19:42:30", "95.251.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8014", "1", "admin8576", "2017-02-16 19:51:51", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8015", "0", "admin", "2017-02-16 19:52:38", "91.107.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8016", "0", "magmainc.co", "2017-02-16 19:56:31", "5.141.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8017", "0", "magmainc.co", "2017-02-16 20:00:12", "79.122.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8018", "0", "admin", "2017-02-16 20:00:54", "91.144.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8019", "0", "admin", "2017-02-16 20:02:29", "93.85.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8020", "0", "magmainc.co", "2017-02-16 20:03:14", "195.64.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8021", "0", "admin", "2017-02-16 20:06:25", "109.252.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8022", "0", "magmainc.co", "2017-02-16 20:08:44", "89.17.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8023", "1", "admin8576", "2017-02-16 20:09:33", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8024", "0", "magmainc.co", "2017-02-16 20:18:23", "95.244.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8025", "0", "admin", "2017-02-16 20:20:34", "188.186.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8026", "1", "admin8576", "2017-02-16 20:27:02", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8027", "0", "magmainc.co", "2017-02-16 20:27:25", "46.0.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8028", "0", "admin", "2017-02-16 20:32:23", "5.44.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8029", "0", "magmainc.co", "2017-02-16 20:34:55", "85.140.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8030", "1", "admin8576", "2017-02-16 20:44:31", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8031", "0", "magmainc.co", "2017-02-16 20:56:38", "188.168.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8032", "0", "magmainc.co", "2017-02-16 20:59:00", "5.141.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8033", "0", "admin", "2017-02-16 20:59:05", "37.79.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8034", "1", "admin8576", "2017-02-16 21:02:33", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8035", "0", "magmainc.co", "2017-02-16 21:12:57", "92.55.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8036", "0", "admin", "2017-02-16 21:18:00", "46.0.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8037", "0", "magmainc.co", "2017-02-16 21:18:16", "178.204.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8038", "1", "admin8576", "2017-02-16 21:21:39", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8039", "0", "admin", "2017-02-16 21:24:44", "81.177.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8040", "0", "magmainc.co", "2017-02-16 21:26:14", "5.141.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8041", "1", "admin8576", "2017-02-16 21:40:48", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8042", "0", "magmainc.co", "2017-02-16 21:51:12", "85.140.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8043", "1", "admin8576", "2017-02-16 22:00:01", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8044", "1", "admin8576", "2017-02-16 22:19:16", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8045", "1", "admin8576", "2017-02-16 22:38:23", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8046", "0", "matter", "2017-02-16 22:57:20", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8047", "1", "admin8576", "2017-02-16 22:57:31", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8048", "1", "admin8576", "2017-02-16 23:16:37", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8049", "1", "admin8576", "2017-02-16 23:35:34", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8050", "1", "admin8576", "2017-02-16 23:54:28", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8051", "1", "admin8576", "2017-02-17 00:13:23", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8052", "1", "admin8576", "2017-02-17 00:32:11", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8053", "1", "admin8576", "2017-02-17 00:50:57", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8054", "1", "admin8576", "2017-02-17 01:09:45", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8055", "1", "admin8576", "2017-02-17 01:28:39", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8056", "1", "admin8576", "2017-02-17 01:47:34", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8057", "0", "situated", "2017-02-17 02:04:31", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8058", "1", "admin8576", "2017-02-17 02:06:34", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8059", "1", "admin8576", "2017-02-17 02:25:39", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8060", "1", "admin8576", "2017-02-17 02:44:41", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8061", "1", "admin8576", "2017-02-17 03:03:41", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8062", "1", "admin8576", "2017-02-17 03:22:45", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8063", "1", "admin8576", "2017-02-17 03:41:41", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8064", "1", "admin8576", "2017-02-17 04:00:34", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8065", "1", "admin8576", "2017-02-17 04:19:37", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8066", "0", "shop", "2017-02-17 04:35:39", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8067", "1", "admin8576", "2017-02-17 04:38:37", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8068", "1", "admin8576", "2017-02-17 04:57:32", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8069", "1", "admin8576", "2017-02-17 05:16:33", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8070", "1", "admin8576", "2017-02-17 05:35:34", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8071", "1", "admin8576", "2017-02-17 05:54:22", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8072", "1", "admin8576", "2017-02-17 06:13:12", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8073", "1", "admin8576", "2017-02-17 06:32:02", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8074", "1", "admin8576", "2017-02-17 06:50:48", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8075", "1", "admin8576", "2017-02-17 07:09:34", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8076", "1", "admin8576", "2017-02-17 07:28:23", "54.145.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8077", "0", "compromising", "2017-02-17 07:40:48", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8078", "0", "admin", "2017-02-17 08:24:02", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8079", "0", "720", "2017-02-17 20:36:17", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8080", "0", "compromising", "2017-02-17 20:44:01", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8081", "0", "admin", "2017-02-17 23:12:51", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8082", "0", "forward", "2017-02-17 23:29:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8083", "0", "tax", "2017-02-18 04:43:13", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8084", "0", "formed", "2017-02-18 05:07:26", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8085", "1", "admin8576", "2017-02-18 05:33:58", "201.197.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8086", "0", "render", "2017-02-18 10:18:23", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8087", "0", "admin", "2017-02-18 16:39:15", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8088", "0", "admin", "2017-02-18 19:12:29", "5.39.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8089", "0", "admin", "2017-02-19 04:47:39", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8090", "0", "admin", "2017-02-19 07:57:00", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8091", "0", "admin", "2017-02-19 12:32:02", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8092", "0", "admin", "2017-02-19 18:32:56", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8093", "0", "5201", "2017-02-19 19:26:27", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8094", "0", "compromising", "2017-02-20 01:57:48", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8095", "0", "memberships", "2017-02-20 08:24:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8096", "0", "admin", "2017-02-20 09:26:39", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8097", "0", "compromising", "2017-02-20 16:27:26", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8098", "0", "admin", "2017-02-20 20:50:44", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8099", "2", "aDmin5748", "2017-02-20 21:01:36", "196.210.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8100", "0", "admin", "2017-02-21 02:58:49", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8101", "0", "admin", "2017-02-21 12:10:57", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8102", "0", "collecting", "2017-02-21 18:01:29", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8103", "0", "admin", "2017-02-21 18:54:43", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8104", "1", "admin8576", "2017-02-21 22:40:09", "149.56.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8105", "0", "admin", "2017-02-22 03:21:39", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8106", "0", "subscribe", "2017-02-22 04:39:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8107", "0", "agmainc", "2017-02-22 09:14:37", "5.39.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8108", "0", "nile", "2017-02-22 15:19:58", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8109", "0", "masemola", "2017-02-23 11:38:35", "185.130.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8110", "0", "admin", "2017-02-23 14:23:04", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8111", "1", "admin8576", "2017-02-23 15:46:08", "186.216.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8112", "0", "within", "2017-02-23 19:27:25", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8113", "0", "admin", "2017-02-24 07:46:19", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8114", "0", "admin", "2017-02-25 01:21:06", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8115", "0", "admin", "2017-02-25 09:32:42", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8116", "0", "admin", "2017-02-25 16:54:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8117", "0", "admin", "2017-02-25 20:10:34", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8118", "0", "admin", "2017-02-25 20:57:04", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8119", "0", "admin", "2017-02-25 20:57:44", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8120", "0", "pretoria", "2017-02-25 23:35:10", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8121", "0", "where", "2017-02-26 03:08:22", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8122", "1", "admin8576", "2017-02-26 05:49:22", "118.179.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8123", "1", "admin8576", "2017-02-26 06:18:26", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8124", "1", "admin8576", "2017-02-26 06:18:27", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8125", "1", "admin8576", "2017-02-26 06:18:28", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8126", "0", "admin", "2017-02-26 12:06:11", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8127", "2", "admin5748", "2017-02-27 05:19:35", "5.178.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8128", "0", "saving", "2017-02-27 13:38:27", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8129", "0", "admin", "2017-02-27 13:54:30", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8130", "2", "admin5748", "2017-02-28 01:44:34", "37.252.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8131", "2", "admin5748", "2017-02-28 01:44:35", "37.252.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8132", "0", "admin", "2017-02-28 06:08:53", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8133", "0", "admin", "2017-02-28 08:48:51", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8134", "0", "this", "2017-02-28 12:02:08", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8135", "0", "admin", "2017-02-28 19:38:07", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8136", "2", "admin5748", "2017-02-28 20:34:45", "37.252.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8137", "0", "has", "2017-03-01 02:41:12", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8138", "0", "admin", "2017-03-01 03:27:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8139", "0", "admin", "2017-03-01 11:32:41", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8140", "0", "871", "2017-03-01 15:58:17", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8141", "2", "admin5748", "2017-03-01 16:32:23", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8142", "0", "admin", "2017-03-01 18:34:58", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8143", "0", "everything", "2017-03-01 21:23:29", "5.39.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8144", "0", "admin", "2017-03-02 11:57:13", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8145", "0", "distinguished", "2017-03-03 03:37:01", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8146", "0", "html", "2017-03-03 11:39:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8147", "1", "admin8576", "2017-03-03 19:12:30", "74.208.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8148", "1", "admin8576", "2017-03-03 19:12:31", "74.208.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8149", "1", "admin8576", "2017-03-03 19:12:32", "74.208.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8150", "0", "admin", "2017-03-04 10:40:01", "5.39.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8151", "0", "admin", "2017-03-04 13:24:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8152", "0", "collect", "2017-03-04 13:40:59", "5.39.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8153", "0", "your", "2017-03-04 18:34:22", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8154", "2", "admin5748", "2017-03-05 00:43:30", "5.254.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8155", "0", "thus", "2017-03-05 02:57:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8156", "0", "admin", "2017-03-05 07:00:30", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8157", "0", "towers", "2017-03-05 07:25:31", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8158", "0", "subscribe", "2017-03-05 19:43:27", "5.39.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8159", "0", "fax", "2017-03-05 19:46:16", "146.0.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8160", "2", "admin5748", "2017-03-06 03:43:50", "81.82.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8161", "0", "admin", "2017-03-07 03:28:39", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8162", "2", "admin5748", "2017-03-07 04:39:09", "118.91.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8163", "0", "admin", "2017-03-07 06:25:12", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8164", "0", "read", "2017-03-07 17:17:32", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8165", "0", "some", "2017-03-07 20:39:33", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8166", "0", "admin", "2017-03-07 23:13:24", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8167", "0", "admin", "2017-03-08 01:19:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8168", "0", "respectively", "2017-03-08 06:05:51", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8169", "0", "admin", "2017-03-08 16:55:08", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8170", "1", "admin8576", "2017-03-09 03:35:11", "84.255.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8171", "0", "admin", "2017-03-09 05:26:24", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8172", "0", "883", "2017-03-09 22:38:23", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8173", "0", "drive", "2017-03-10 13:57:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8174", "0", "admin", "2017-03-10 17:16:48", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8175", "0", "admin", "2017-03-11 11:26:49", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8176", "0", "admin", "2017-03-11 16:43:48", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8177", "1", "admin8576", "2017-03-11 22:53:26", "197.50.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8178", "0", "admin", "2017-03-13 14:00:24", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8179", "0", "admin", "2017-03-14 07:45:35", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8180", "0", "3367", "2017-03-14 08:43:16", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8181", "0", "admin", "2017-03-14 10:19:00", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8182", "0", "port", "2017-03-14 11:10:18", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8183", "0", "subject", "2017-03-14 13:01:33", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8184", "0", "admin", "2017-03-14 16:17:10", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8185", "0", "admin", "2017-03-14 17:29:32", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8186", "0", "main", "2017-03-14 23:58:05", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8187", "0", "admin", "2017-03-15 10:57:46", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8188", "0", "admin", "2017-03-15 15:30:17", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8189", "0", "admin", "2017-03-16 03:12:59", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8190", "0", "exactly", "2017-03-16 12:29:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8191", "0", "versatile", "2017-03-17 02:08:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8192", "0", "admin", "2017-03-17 12:54:09", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8193", "0", "admin", "2017-03-18 00:38:49", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8194", "0", "admin", "2017-03-18 06:43:24", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8195", "0", "admin", "2017-03-18 07:40:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8196", "0", "admin", "2017-03-19 13:13:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8197", "0", "admin", "2017-03-20 20:46:58", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8198", "0", "admin", "2017-03-20 21:11:59", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8199", "0", "admin", "2017-03-21 05:14:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8200", "0", "admin", "2017-03-21 09:27:15", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8201", "0", "and", "2017-03-21 15:12:10", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8202", "0", "they", "2017-03-21 22:59:40", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8203", "0", "admin", "2017-03-22 04:06:31", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8204", "0", "admin", "2017-03-22 20:31:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8205", "0", "admin", "2017-03-23 13:05:16", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8206", "0", "admin", "2017-03-23 17:31:58", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8207", "0", "durban", "2017-03-24 00:40:19", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8208", "0", "with", "2017-03-24 12:05:32", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8209", "0", "admin", "2017-03-24 12:57:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8210", "0", "east", "2017-03-24 16:19:58", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8211", "0", "admin", "2017-03-24 17:15:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8212", "0", "admin", "2017-03-24 20:31:47", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8213", "0", "high", "2017-03-25 01:39:45", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8214", "0", "admin", "2017-03-25 02:46:17", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8215", "0", "4th", "2017-03-25 08:42:20", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8216", "0", "other", "2017-03-27 02:51:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8217", "0", "compromising", "2017-03-27 06:13:11", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8218", "0", "owned", "2017-03-27 06:48:56", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8219", "0", "recently", "2017-03-28 16:49:38", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8220", "0", "admin", "2017-03-28 20:05:59", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8221", "0", "admin", "2017-03-29 07:06:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8222", "0", "good", "2017-03-29 10:43:37", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8223", "0", "agmai", "2017-03-29 14:00:52", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8224", "0", "prestigious", "2017-03-29 22:57:37", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8225", "0", "tax", "2017-03-30 03:20:25", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8226", "0", "volcanoes", "2017-03-30 17:04:26", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8227", "0", "johannesburg", "2017-03-30 19:24:00", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8228", "0", "admin", "2017-03-31 09:40:39", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8229", "0", "fees", "2017-04-01 23:37:34", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8230", "0", "spectrum", "2017-04-02 03:29:29", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8231", "0", "admin", "2017-04-04 02:42:14", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8232", "0", "admin", "2017-04-04 03:50:44", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8233", "0", "admin", "2017-04-04 04:23:12", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8234", "0", "admin", "2017-04-04 14:49:50", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8235", "0", "3367", "2017-04-04 18:00:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8236", "0", "results", "2017-04-05 01:28:34", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8237", "0", "expectations", "2017-04-05 07:15:05", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8238", "0", "respectively", "2017-04-05 07:46:09", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8239", "0", "admin", "2017-04-05 11:09:48", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8240", "0", "post", "2017-04-05 18:07:51", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8241", "0", "erupt", "2017-04-05 18:39:18", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8242", "0", "admin", "2017-04-06 20:23:13", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8243", "0", "admin", "2017-04-06 20:36:06", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8244", "0", "admin", "2017-04-06 20:57:29", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8245", "1", "admin8576", "2017-04-07 06:03:31", "103.62.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8246", "1", "admin8576", "2017-04-07 07:18:17", "193.254.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8247", "1", "admin8576", "2017-04-07 08:34:48", "103.62.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8248", "1", "admin8576", "2017-04-07 09:48:56", "62.69.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8249", "1", "admin8576", "2017-04-07 12:16:34", "109.1.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8250", "1", "admin8576", "2017-04-07 13:35:23", "194.184.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8251", "1", "admin8576", "2017-04-07 14:47:36", "194.184.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8252", "1", "admin8576", "2017-04-07 17:05:51", "91.126.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8253", "1", "admin8576", "2017-04-07 20:56:02", "193.254.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8254", "0", "admin", "2017-04-07 20:58:24", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8255", "1", "admin8576", "2017-04-07 22:15:48", "194.184.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8256", "0", "admin", "2017-04-08 00:12:37", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8257", "1", "admin8576", "2017-04-08 02:33:15", "91.126.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8258", "0", "admin", "2017-04-08 02:59:27", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8259", "1", "admin8576", "2017-04-08 06:39:00", "62.69.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8260", "1", "admin8576", "2017-04-08 08:01:00", "62.69.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8261", "0", "unnecessary", "2017-04-08 09:48:30", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8262", "0", "expect", "2017-04-08 13:40:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8263", "1", "admin8576", "2017-04-08 14:45:29", "89.218.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8264", "1", "admin8576", "2017-04-08 16:06:32", "194.184.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8265", "0", "subject", "2017-04-08 16:22:45", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8266", "1", "admin8576", "2017-04-08 21:27:17", "103.252.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8267", "1", "admin8576", "2017-04-08 22:57:22", "178.253.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8268", "1", "admin8576", "2017-04-09 00:31:28", "178.253.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8269", "1", "admin8576", "2017-04-09 01:52:46", "222.104.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8270", "1", "admin8576", "2017-04-09 02:15:25", "200.43.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8271", "1", "admin8576", "2017-04-09 03:39:06", "119.164.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8272", "1", "admin8576", "2017-04-09 04:00:16", "119.164.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8273", "1", "admin8576", "2017-04-09 04:35:13", "194.184.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8274", "1", "admin8576", "2017-04-09 07:26:11", "89.218.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8275", "1", "admin8576", "2017-04-09 09:37:32", "222.104.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8276", "1", "admin8576", "2017-04-09 12:15:23", "185.49.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8277", "0", "admin", "2017-04-09 12:20:53", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8278", "1", "admin8576", "2017-04-09 16:37:53", "187.237.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8279", "1", "admin8576", "2017-04-09 18:03:03", "182.74.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8280", "1", "admin8576", "2017-04-09 23:30:40", "80.23.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8281", "0", "2196", "2017-04-10 00:46:16", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8282", "1", "admin8576", "2017-04-10 02:52:54", "89.97.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8283", "1", "admin8576", "2017-04-10 04:33:21", "89.97.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8284", "0", "2016", "2017-04-10 06:00:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8285", "1", "admin8576", "2017-04-10 10:55:01", "89.97.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8286", "1", "admin8576", "2017-04-10 14:00:02", "89.97.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8287", "1", "admin8576", "2017-04-10 17:11:24", "80.23.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8288", "1", "admin8576", "2017-04-10 18:39:55", "43.226.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8289", "1", "admin8576", "2017-04-10 20:15:36", "27.251.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8290", "1", "admin8576", "2017-04-10 21:35:16", "62.86.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8291", "1", "admin8576", "2017-04-11 00:38:23", "5.133.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8292", "1", "admin8576", "2017-04-11 02:20:34", "62.86.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8293", "0", "admin", "2017-04-11 02:30:03", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8294", "1", "admin8576", "2017-04-11 04:05:22", "185.49.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8295", "1", "admin8576", "2017-04-11 05:46:16", "43.226.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8296", "0", "admin", "2017-04-11 06:36:10", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8297", "1", "admin8576", "2017-04-11 07:21:26", "103.62.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8298", "0", "two", "2017-04-11 08:06:23", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8299", "0", "admin", "2017-04-11 10:12:03", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8300", "1", "admin8576", "2017-04-11 10:36:29", "27.250.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8301", "1", "admin8576", "2017-04-11 12:13:44", "103.62.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8302", "1", "admin8576", "2017-04-11 13:48:58", "5.133.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8303", "0", "admin", "2017-04-11 18:55:02", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8304", "0", "onto", "2017-04-12 20:16:27", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8305", "0", "5201", "2017-04-12 23:15:14", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8306", "0", "notaries", "2017-04-13 03:24:41", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8307", "0", "phone", "2017-04-13 03:45:49", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8308", "0", "admin", "2017-04-13 08:21:41", "31.171.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8309", "0", "407", "2017-04-13 10:46:31", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8310", "0", "admin", "2017-04-13 18:07:43", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8311", "0", "postal", "2017-04-13 18:39:25", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8312", "0", "admin", "2017-04-13 19:09:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8313", "0", "admin", "2017-04-13 22:26:19", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8314", "0", "admin", "2017-04-14 00:08:40", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8315", "0", "why", "2017-04-14 04:27:03", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8316", "0", "competitive", "2017-04-14 13:53:03", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8317", "0", "admin", "2017-04-14 23:57:51", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8318", "0", "admin", "2017-04-15 00:06:40", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8319", "0", "admin", "2017-04-15 08:47:25", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8320", "0", "follow", "2017-04-15 18:19:45", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8321", "0", "compromising", "2017-04-15 18:56:18", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8322", "0", "designed", "2017-04-15 22:06:15", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8323", "0", "requirements", "2017-04-16 00:22:43", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8324", "0", "been", "2017-04-16 01:03:49", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8325", "0", "admin", "2017-04-16 06:21:50", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8326", "0", "admin", "2017-04-16 06:45:50", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8327", "0", "advisors", "2017-04-16 20:25:54", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8328", "0", "status", "2017-04-16 22:58:56", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8329", "0", "admin", "2017-04-16 23:57:40", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8330", "0", "admin", "2017-04-17 01:35:23", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8331", "0", "twitter", "2017-04-17 16:14:42", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8332", "1", "admin8576", "2017-04-17 20:40:14", "119.146.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8333", "0", "admin", "2017-04-18 03:53:24", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8334", "0", "admin", "2017-04-18 07:04:33", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8335", "0", "admin", "2017-04-18 16:27:12", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8336", "0", "admin", "2017-04-19 00:20:28", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8337", "0", "well", "2017-04-19 02:50:03", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8338", "0", "receipt", "2017-04-19 03:18:06", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8339", "0", "admin", "2017-04-19 07:43:50", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8340", "0", "admin", "2017-04-19 09:18:46", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8341", "0", "admin", "2017-04-19 14:08:46", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8342", "0", "admin", "2017-04-20 05:44:36", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8343", "1", "admin8576", "2017-04-20 12:42:21", "190.195.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8344", "1", "admin8576", "2017-04-20 12:51:13", "196.219.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8345", "0", "compliment", "2017-04-20 13:18:12", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8346", "0", "admin", "2017-04-20 15:27:25", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8347", "0", "chaotic", "2017-04-20 21:47:34", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8348", "0", "admin", "2017-04-21 03:16:20", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8349", "0", "admin", "2017-04-21 03:22:56", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8350", "0", "admin", "2017-04-21 03:24:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8351", "0", "admin", "2017-04-21 07:36:50", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8352", "0", "admin", "2017-04-21 08:49:54", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8353", "0", "have", "2017-04-21 12:28:31", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8354", "1", "admin8576", "2017-04-21 12:52:53", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8355", "1", "admin8576", "2017-04-21 13:21:54", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8356", "1", "admin8576", "2017-04-21 13:42:46", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8357", "0", "admin", "2017-04-21 15:21:14", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8358", "1", "admin8576", "2017-04-21 16:04:49", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8359", "1", "admin8576", "2017-04-21 16:22:42", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8360", "1", "admin8576", "2017-04-21 16:41:15", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8361", "1", "admin8576", "2017-04-21 16:59:23", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8362", "1", "admin8576", "2017-04-21 17:16:58", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8363", "1", "admin8576", "2017-04-21 17:35:07", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8364", "1", "admin8576", "2017-04-21 17:53:02", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8365", "1", "admin8576", "2017-04-21 18:10:54", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8366", "1", "admin8576", "2017-04-21 18:28:20", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8367", "1", "admin8576", "2017-04-21 18:47:06", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8368", "1", "admin8576", "2017-04-21 19:05:49", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8369", "1", "admin8576", "2017-04-21 19:24:53", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8370", "1", "admin8576", "2017-04-21 19:43:12", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8371", "1", "admin8576", "2017-04-21 20:02:00", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8372", "1", "admin8576", "2017-04-21 20:20:25", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8373", "1", "admin8576", "2017-04-21 20:38:46", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8374", "1", "admin8576", "2017-04-21 20:56:57", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8375", "1", "admin8576", "2017-04-21 21:15:48", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8376", "1", "admin8576", "2017-04-21 21:34:38", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8377", "1", "admin8576", "2017-04-21 21:53:22", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8378", "1", "admin8576", "2017-04-21 22:11:45", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8379", "1", "admin8576", "2017-04-21 22:30:17", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8380", "1", "admin8576", "2017-04-21 22:49:09", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8381", "1", "admin8576", "2017-04-21 23:08:01", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8382", "0", "admin", "2017-04-21 23:14:42", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8383", "1", "admin8576", "2017-04-21 23:26:15", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8384", "1", "admin8576", "2017-04-21 23:44:47", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8385", "1", "admin8576", "2017-04-22 00:03:29", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8386", "1", "admin8576", "2017-04-22 00:22:20", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8387", "1", "admin8576", "2017-04-22 00:40:39", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8388", "1", "admin8576", "2017-04-22 00:59:18", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8389", "1", "admin8576", "2017-04-22 01:18:10", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8390", "1", "admin8576", "2017-04-22 01:36:51", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8391", "1", "admin8576", "2017-04-22 01:55:00", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8392", "1", "admin8576", "2017-04-22 02:06:31", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8393", "1", "admin8576", "2017-04-22 02:06:32", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8394", "1", "admin8576", "2017-04-22 02:06:34", "199.15.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8395", "1", "admin8576", "2017-04-22 02:13:55", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8396", "1", "admin8576", "2017-04-22 02:32:51", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8397", "1", "admin8576", "2017-04-22 02:51:32", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8398", "1", "admin8576", "2017-04-22 03:10:06", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8399", "1", "admin8576", "2017-04-22 03:29:05", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8400", "1", "admin8576", "2017-04-22 03:48:00", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8401", "1", "admin8576", "2017-04-22 04:06:49", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8402", "1", "admin8576", "2017-04-22 04:25:14", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8403", "1", "admin8576", "2017-04-22 04:44:02", "52.201.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8404", "0", "3201", "2017-04-22 17:17:20", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8405", "1", "admin8576", "2017-04-22 21:11:34", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8406", "1", "admin8576", "2017-04-22 21:11:35", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8407", "1", "admin8576", "2017-04-22 21:11:36", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8408", "0", "admin", "2017-04-22 21:12:54", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8409", "0", "first", "2017-04-24 02:20:48", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8410", "0", "admin", "2017-04-24 09:03:08", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8411", "0", "admin", "2017-04-24 10:58:36", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8412", "0", "their", "2017-04-24 13:37:29", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8413", "0", "inc", "2017-04-24 23:47:05", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8414", "0", "use", "2017-04-25 01:22:28", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8415", "0", "whole", "2017-04-25 03:28:23", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8416", "0", "admin", "2017-04-25 11:41:12", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8417", "0", "gmai", "2017-04-25 23:07:40", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8418", "0", "adderley", "2017-04-26 02:20:40", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8419", "1", "admin8576", "2017-04-26 10:14:06", "61.183.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8420", "1", "admin8576", "2017-04-26 14:32:32", "27.189.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8421", "0", "based", "2017-04-26 15:20:08", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8422", "0", "720", "2017-04-26 18:56:00", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8423", "0", "crust", "2017-04-26 22:33:40", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8424", "0", "admin", "2017-04-27 01:06:51", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8425", "0", "admin", "2017-04-27 05:36:40", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8426", "0", "admin", "2017-04-27 13:34:33", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8427", "0", "good", "2017-04-27 18:16:57", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8428", "0", "admin", "2017-04-28 00:00:27", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8429", "0", "chairman", "2017-04-28 01:34:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8430", "0", "basis", "2017-04-28 04:29:35", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8431", "0", "admin", "2017-04-28 10:15:58", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8432", "0", "admin", "2017-04-28 19:14:56", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8433", "0", "admin", "2017-04-29 00:01:20", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8434", "0", "admin", "2017-04-29 12:23:07", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8435", "1", "admin8576", "2017-04-29 21:25:11", "186.251.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8436", "1", "admin8576", "2017-04-29 21:25:12", "181.143.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8437", "0", "rich", "2017-04-30 02:05:40", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8438", "0", "contracts", "2017-04-30 04:31:01", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8439", "0", "owned", "2017-04-30 08:08:30", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8440", "0", "admin", "2017-04-30 22:12:38", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8441", "0", "commercial", "2017-04-30 22:48:59", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8442", "0", "email", "2017-04-30 23:01:43", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8443", "0", "admin", "2017-04-30 23:20:35", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8444", "0", "practice", "2017-04-30 23:39:48", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8445", "0", "hub", "2017-05-01 04:47:24", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8446", "0", "office", "2017-05-01 06:55:19", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8447", "1", "admin8576", "2017-05-01 14:28:31", "109.237.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8448", "1", "admin8576", "2017-05-01 15:09:32", "188.163.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8449", "1", "admin8576", "2017-05-01 16:25:18", "46.42.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8450", "1", "admin8576", "2017-05-01 17:35:39", "109.88.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8451", "1", "admin8576", "2017-05-01 19:12:38", "196.1.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8452", "0", "lawyer", "2017-05-01 20:13:09", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8453", "1", "admin8576", "2017-05-01 22:08:17", "190.81.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8454", "1", "admin8576", "2017-05-01 23:28:00", "92.53.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8455", "0", "admin", "2017-05-01 23:30:19", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8456", "1", "admin8576", "2017-05-02 00:19:40", "87.243.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8457", "0", "admin", "2017-05-02 15:30:55", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8458", "1", "admin8576", "2017-05-02 19:57:51", "2.84.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8459", "0", "admin", "2017-05-03 02:25:31", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8460", "1", "admin8576", "2017-05-03 05:16:09", "193.201.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8461", "0", "2016", "2017-05-03 12:31:09", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8462", "0", "client", "2017-05-03 12:46:37", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8463", "0", "4th", "2017-05-03 17:15:20", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8464", "0", "admin", "2017-05-03 19:06:04", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8465", "0", "church", "2017-05-04 01:58:45", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8466", "0", "sign", "2017-05-04 04:03:28", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8467", "1", "admin8576", "2017-05-04 04:43:56", "185.147.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8468", "1", "admin8576", "2017-05-04 05:39:37", "111.68.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8469", "0", "admin", "2017-05-04 05:59:51", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8470", "0", "admin", "2017-05-04 06:24:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8471", "1", "admin8576", "2017-05-04 07:11:28", "178.186.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8472", "0", "other", "2017-05-04 10:36:55", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8473", "1", "admin8576", "2017-05-04 11:33:09", "46.47.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8474", "0", "admin", "2017-05-04 14:38:04", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8475", "0", "admin", "2017-05-04 16:17:54", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8476", "1", "admin8576", "2017-05-04 17:45:16", "188.27.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8477", "1", "admin8576", "2017-05-04 21:47:46", "46.116.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8478", "1", "admin8576", "2017-05-04 22:41:55", "212.40.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8479", "0", "constitution", "2017-05-05 00:54:45", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8480", "1", "admin8576", "2017-05-05 01:14:27", "212.90.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8481", "0", "reports", "2017-05-05 09:10:18", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8482", "0", "admin", "2017-05-05 17:35:39", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8483", "0", "erupt", "2017-05-05 23:33:38", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8484", "0", "which", "2017-05-05 23:50:58", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8485", "0", "admin", "2017-05-06 03:44:15", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8486", "0", "admin", "2017-05-06 08:00:49", "195.175.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8487", "0", "admin", "2017-05-06 08:45:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8488", "0", "admin", "2017-05-06 10:16:35", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8489", "0", "admin", "2017-05-06 15:36:09", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8490", "0", "admin", "2017-05-06 17:56:28", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8491", "0", "diverse", "2017-05-06 20:27:34", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8492", "1", "admin8576", "2017-05-07 00:22:24", "202.119.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8493", "1", "admin8576", "2017-05-07 00:23:39", "27.189.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8494", "0", "house", "2017-05-07 01:56:52", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8495", "0", "admin", "2017-05-07 18:47:42", "195.175.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8496", "0", "admin", "2017-05-07 19:53:05", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8497", "0", "collect", "2017-05-08 00:16:00", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8498", "0", "100", "2017-05-08 01:23:08", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8499", "0", "admin", "2017-05-08 01:29:43", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8500", "0", "portfolio", "2017-05-08 06:31:18", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8501", "0", "admin", "2017-05-08 09:10:39", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8502", "0", "destroying", "2017-05-08 17:19:10", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8503", "0", "admin", "2017-05-08 17:42:26", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8504", "0", "admin", "2017-05-09 01:31:27", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8505", "0", "chambers", "2017-05-09 02:20:19", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8506", "0", "admin", "2017-05-09 05:43:10", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8507", "0", "admin", "2017-05-09 06:18:17", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8508", "0", "admin", "2017-05-09 07:16:34", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8509", "0", "admin", "2017-05-09 11:05:17", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8510", "0", "news", "2017-05-09 12:01:37", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8511", "0", "admin", "2017-05-09 14:44:51", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8512", "0", "able", "2017-05-09 16:44:43", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8513", "0", "international", "2017-05-09 20:46:27", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8514", "0", "use", "2017-05-09 21:45:25", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8515", "0", "admin", "2017-05-10 00:08:30", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8516", "1", "admin8576", "2017-05-10 02:25:50", "120.203.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8517", "1", "admin8576", "2017-05-10 02:26:59", "206.214.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8518", "0", "admin", "2017-05-10 04:31:13", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8519", "0", "admin", "2017-05-10 18:36:01", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8520", "1", "admin8576", "2017-05-10 18:40:44", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8521", "1", "admin8576", "2017-05-10 19:30:39", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8522", "1", "admin8576", "2017-05-10 20:06:46", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8523", "1", "admin8576", "2017-05-10 20:42:39", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8524", "1", "admin8576", "2017-05-10 21:19:03", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8525", "1", "admin8576", "2017-05-10 21:55:28", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8526", "1", "admin8576", "2017-05-10 22:31:35", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8527", "0", "admin", "2017-05-10 22:51:21", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8528", "1", "admin8576", "2017-05-10 23:07:32", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8529", "1", "admin8576", "2017-05-10 23:44:50", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8530", "1", "admin8576", "2017-05-11 00:21:47", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8531", "1", "admin8576", "2017-05-11 00:59:22", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8532", "1", "admin8576", "2017-05-11 01:36:56", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8533", "1", "admin8576", "2017-05-11 02:14:45", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8534", "1", "admin8576", "2017-05-11 02:52:11", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8535", "1", "admin8576", "2017-05-11 03:30:11", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8536", "1", "admin8576", "2017-05-11 04:08:01", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8537", "1", "admin8576", "2017-05-11 04:46:01", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8538", "1", "admin8576", "2017-05-11 05:23:43", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8539", "1", "admin8576", "2017-05-11 06:01:22", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8540", "1", "admin8576", "2017-05-11 06:38:43", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8541", "1", "admin8576", "2017-05-11 07:16:20", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8542", "1", "admin8576", "2017-05-11 07:53:59", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8543", "1", "admin8576", "2017-05-11 08:32:41", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8544", "1", "admin8576", "2017-05-11 09:10:28", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8545", "1", "admin8576", "2017-05-11 09:48:54", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8546", "1", "admin8576", "2017-05-11 10:27:05", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8547", "1", "admin8576", "2017-05-11 11:05:28", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8548", "1", "admin8576", "2017-05-11 11:43:50", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8549", "0", "admin", "2017-05-11 11:54:57", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8550", "1", "admin8576", "2017-05-11 12:22:00", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8551", "1", "admin8576", "2017-05-11 13:00:39", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8552", "1", "admin8576", "2017-05-11 13:38:42", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8553", "1", "admin8576", "2017-05-11 14:16:56", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8554", "1", "admin8576", "2017-05-11 14:55:06", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8555", "1", "admin8576", "2017-05-11 15:33:25", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8556", "1", "admin8576", "2017-05-11 16:12:17", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8557", "1", "admin8576", "2017-05-11 16:50:46", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8558", "1", "admin8576", "2017-05-11 17:29:13", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8559", "1", "admin8576", "2017-05-11 18:07:41", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8560", "0", "admin", "2017-05-11 18:17:11", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8561", "1", "admin8576", "2017-05-11 18:45:40", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8562", "1", "admin8576", "2017-05-11 19:23:49", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8563", "1", "admin8576", "2017-05-11 20:01:32", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8564", "1", "admin8576", "2017-05-11 20:39:32", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8565", "1", "admin8576", "2017-05-11 21:17:56", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8566", "1", "admin8576", "2017-05-11 21:56:38", "34.203.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8567", "0", "elizabeth", "2017-05-12 01:12:18", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8568", "0", "admin", "2017-05-12 11:53:38", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8569", "0", "785", "2017-05-12 22:06:16", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8570", "0", "admin", "2017-05-13 01:36:49", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8571", "0", "towers", "2017-05-13 02:42:22", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8572", "0", "admin", "2017-05-13 04:12:38", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8573", "0", "admin", "2017-05-13 05:04:38", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8574", "0", "status", "2017-05-13 08:28:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8575", "0", "admin", "2017-05-13 10:17:59", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8576", "0", "perridgevale", "2017-05-13 12:41:56", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8577", "0", "name", "2017-05-13 15:39:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8578", "0", "1132", "2017-05-13 16:24:14", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8579", "0", "admin", "2017-05-13 22:57:19", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8580", "0", "pietermaritzburg", "2017-05-14 03:23:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8581", "0", "271", "2017-05-14 10:33:07", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8582", "0", "admin", "2017-05-14 11:40:26", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8583", "0", "complex", "2017-05-14 14:02:13", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8584", "0", "family", "2017-05-15 01:51:20", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8585", "0", "admin", "2017-05-15 05:24:39", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8586", "0", "admin", "2017-05-15 21:57:56", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8587", "1", "admin8576", "2017-05-15 23:22:48", "121.10.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8588", "1", "admin8576", "2017-05-15 23:22:54", "117.159.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8589", "0", "admin", "2017-05-16 00:03:19", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8590", "1", "admin8576", "2017-05-16 00:06:35", "194.224.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8591", "0", "two", "2017-05-16 00:55:03", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8592", "0", "admin", "2017-05-16 11:20:11", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8593", "0", "across", "2017-05-16 18:31:19", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8594", "0", "award", "2017-05-16 21:48:07", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8595", "0", "admin", "2017-05-16 22:52:08", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8596", "0", "awarded", "2017-05-17 09:46:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8597", "0", "admin", "2017-05-17 12:41:38", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8598", "0", "find", "2017-05-17 13:19:02", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8599", "0", "history", "2017-05-17 14:36:05", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8600", "0", "admin", "2017-05-17 17:27:29", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8601", "0", "magma", "2017-05-17 17:35:41", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8602", "0", "provinces", "2017-05-18 00:15:20", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8603", "0", "admin", "2017-05-18 02:00:59", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8604", "0", "people", "2017-05-18 06:44:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8605", "0", "destroying", "2017-05-18 15:20:55", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8606", "0", "admin", "2017-05-18 16:13:08", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8607", "1", "admin8576", "2017-05-18 19:48:32", "60.174.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8608", "1", "admin8576", "2017-05-18 19:48:55", "41.189.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8609", "1", "admin8576", "2017-05-18 23:08:30", "91.126.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8610", "0", "admin", "2017-05-19 19:33:20", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8611", "0", "manner", "2017-05-20 02:12:37", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8612", "0", "admin", "2017-05-20 03:18:38", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8613", "0", "roots", "2017-05-20 03:59:05", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8614", "0", "mainc", "2017-05-20 07:41:40", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8615", "0", "admin", "2017-05-20 08:04:47", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8616", "0", "admin", "2017-05-20 10:33:46", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8617", "0", "admin", "2017-05-20 15:38:57", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8618", "0", "time", "2017-05-20 18:55:28", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8619", "0", "admin", "2017-05-21 03:26:19", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8620", "1", "admin8576", "2017-05-21 03:26:53", "59.19.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8621", "1", "admin8576", "2017-05-21 04:00:57", "128.134.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8622", "0", "that", "2017-05-21 04:09:19", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8623", "1", "admin8576", "2017-05-21 04:37:37", "109.99.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8624", "1", "admin8576", "2017-05-21 05:15:00", "222.103.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8625", "1", "admin8576", "2017-05-21 05:51:18", "89.29.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8626", "1", "admin8576", "2017-05-21 06:26:09", "206.214.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8627", "1", "admin8576", "2017-05-21 06:59:21", "46.151.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8628", "1", "admin8576", "2017-05-21 07:33:29", "31.148.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8629", "0", "surface", "2017-05-21 07:45:02", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8630", "1", "admin8576", "2017-05-21 08:42:26", "117.253.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8631", "1", "admin8576", "2017-05-21 09:48:03", "31.148.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8632", "0", "gmain", "2017-05-21 10:17:53", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8633", "0", "admin", "2017-05-21 10:40:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8634", "1", "admin8576", "2017-05-21 11:28:07", "176.150.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8635", "1", "admin8576", "2017-05-21 12:33:13", "109.1.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8636", "1", "admin8576", "2017-05-21 13:07:59", "31.148.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8637", "1", "admin8576", "2017-05-21 14:19:16", "222.103.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8638", "1", "admin8576", "2017-05-21 14:54:35", "89.121.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8639", "1", "admin8576", "2017-05-21 15:27:18", "2.233.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8640", "1", "admin8576", "2017-05-21 15:59:27", "109.1.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8641", "1", "admin8576", "2017-05-21 17:30:11", "31.148.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8642", "1", "admin8576", "2017-05-21 18:01:59", "86.246.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8643", "1", "admin8576", "2017-05-21 18:33:16", "134.255.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8644", "1", "admin8576", "2017-05-21 19:05:36", "117.253.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8645", "1", "admin8576", "2017-05-21 20:09:25", "93.51.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8646", "1", "admin8576", "2017-05-21 20:42:59", "93.51.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8647", "1", "admin8576", "2017-05-21 21:15:19", "59.19.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8648", "1", "admin8576", "2017-05-21 23:22:52", "185.49.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8649", "1", "admin8576", "2017-05-21 23:55:16", "37.151.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8650", "1", "admin8576", "2017-05-22 00:27:39", "109.99.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8651", "1", "admin8576", "2017-05-22 00:58:18", "222.165.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8652", "1", "admin8576", "2017-05-22 01:24:46", "201.184.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8653", "1", "admin8576", "2017-05-22 01:24:49", "218.201.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8654", "1", "admin8576", "2017-05-22 02:01:46", "109.99.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8655", "1", "admin8576", "2017-05-22 02:30:45", "120.194.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8656", "1", "admin8576", "2017-05-22 03:07:47", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8657", "1", "admin8576", "2017-05-22 03:39:47", "202.129.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8658", "1", "admin8576", "2017-05-22 04:12:05", "79.124.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8659", "1", "admin8576", "2017-05-22 04:44:05", "128.134.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8660", "1", "admin8576", "2017-05-22 06:12:55", "31.148.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8661", "1", "admin8576", "2017-05-22 06:41:37", "188.248.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8662", "1", "admin8576", "2017-05-22 08:23:18", "46.184.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8663", "1", "admin8576", "2017-05-22 08:56:48", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8664", "1", "admin8576", "2017-05-22 09:30:20", "92.81.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8665", "1", "admin8576", "2017-05-22 10:35:09", "89.121.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8666", "1", "admin8576", "2017-05-22 11:06:12", "31.148.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8667", "1", "admin8576", "2017-05-22 11:36:39", "89.29.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8668", "1", "admin8576", "2017-05-22 13:09:13", "203.142.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8669", "1", "admin8576", "2017-05-22 13:41:05", "79.124.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8670", "1", "admin8576", "2017-05-22 14:12:29", "109.99.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8671", "0", "vermeaulen", "2017-05-22 14:14:48", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8672", "1", "admin8576", "2017-05-22 14:43:11", "203.142.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8673", "0", "temperature", "2017-05-22 14:56:25", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8674", "1", "admin8576", "2017-05-22 17:09:05", "220.241.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8675", "1", "admin8576", "2017-05-22 17:36:03", "109.99.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8676", "1", "admin8576", "2017-05-22 18:03:23", "109.81.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8677", "1", "admin8576", "2017-05-22 19:30:14", "206.214.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8678", "1", "admin8576", "2017-05-22 20:02:12", "93.72.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8679", "1", "admin8576", "2017-05-22 20:31:29", "202.129.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8680", "1", "admin8576", "2017-05-22 21:02:51", "128.134.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8681", "0", "aviation", "2017-05-22 21:17:53", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8682", "1", "admin8576", "2017-05-22 21:34:00", "185.49.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8683", "1", "admin8576", "2017-05-22 22:05:06", "91.126.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8684", "1", "admin8576", "2017-05-22 22:38:21", "46.184.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8685", "1", "admin8576", "2017-05-22 23:11:18", "202.129.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8686", "1", "admin8576", "2017-05-23 00:15:54", "115.186.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8687", "1", "admin8576", "2017-05-23 01:18:18", "31.148.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8688", "1", "admin8576", "2017-05-23 02:22:56", "89.29.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8689", "0", "admin", "2017-05-23 02:36:27", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8690", "1", "admin8576", "2017-05-23 02:53:41", "1.9.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8691", "1", "admin8576", "2017-05-23 03:26:11", "109.1.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8692", "1", "admin8576", "2017-05-23 04:29:55", "31.196.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8693", "1", "admin8576", "2017-05-23 05:02:09", "79.124.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8694", "1", "admin8576", "2017-05-23 05:34:10", "128.134.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8695", "1", "admin8576", "2017-05-23 06:05:20", "109.1.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8696", "1", "admin8576", "2017-05-23 06:36:23", "189.254.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8697", "1", "admin8576", "2017-05-23 07:38:43", "79.124.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8698", "1", "admin8576", "2017-05-23 08:10:26", "46.151.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8699", "0", "admin", "2017-05-23 08:55:01", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8700", "1", "admin8576", "2017-05-23 09:46:56", "58.65.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8701", "1", "admin8576", "2017-05-23 10:18:31", "128.134.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8702", "1", "admin8576", "2017-05-23 10:51:33", "62.28.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8703", "1", "admin8576", "2017-05-23 11:23:46", "46.184.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8704", "0", "admin", "2017-05-23 14:19:57", "81.213.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8705", "0", "exceeds", "2017-05-23 16:05:19", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8706", "0", "malconess", "2017-05-24 05:40:51", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8707", "0", "admin", "2017-05-24 21:05:32", "212.175.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8708", "0", "admin", "2017-05-24 21:15:13", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8709", "0", "admin", "2017-05-24 22:15:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8710", "0", "although", "2017-05-25 01:40:24", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8711", "0", "being", "2017-05-25 02:52:44", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8712", "0", "information", "2017-05-25 05:16:57", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8713", "0", "admin", "2017-05-25 07:46:32", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8714", "0", "admin", "2017-05-25 20:22:16", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8715", "1", "admin8576", "2017-05-25 23:06:56", "222.217.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8716", "1", "admin8576", "2017-05-25 23:21:01", "88.201.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8717", "1", "admin8576", "2017-05-26 02:19:27", "59.44.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8718", "0", "admin", "2017-05-26 02:36:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8719", "0", "admin", "2017-05-26 05:46:28", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8720", "0", "success", "2017-05-26 06:20:02", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8721", "0", "admin", "2017-05-26 07:21:13", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8722", "0", "most", "2017-05-26 09:10:24", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8723", "0", "agmain", "2017-05-27 00:51:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8724", "0", "admin", "2017-05-27 04:03:17", "195.175.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8725", "0", "way", "2017-05-27 07:05:36", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8726", "0", "admin", "2017-05-27 13:35:18", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8727", "0", "admin", "2017-05-28 00:19:14", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8728", "0", "admin", "2017-05-28 10:46:32", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8729", "0", "from", "2017-05-28 17:34:11", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8730", "0", "admin", "2017-05-29 09:26:24", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8731", "1", "admin8576", "2017-05-29 11:50:47", "122.114.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8732", "1", "admin8576", "2017-05-29 11:51:06", "130.0.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8733", "1", "admin8576", "2017-05-29 11:59:08", "218.84.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8734", "1", "admin8576", "2017-05-29 12:14:01", "111.160.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8735", "0", "admin", "2017-05-29 15:35:26", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8736", "0", "admin", "2017-05-29 15:50:02", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8737", "0", "admin", "2017-05-29 16:57:40", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8738", "0", "admin", "2017-05-29 18:10:13", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8739", "0", "admin", "2017-05-29 20:07:30", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8740", "0", "for", "2017-05-29 22:16:24", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8741", "0", "admin", "2017-05-30 09:12:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8742", "0", "you", "2017-05-30 13:56:09", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8743", "0", "firms", "2017-05-30 15:41:12", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8744", "0", "anton", "2017-05-30 15:42:12", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8745", "0", "admin", "2017-05-30 17:02:15", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8746", "0", "traces", "2017-05-30 18:57:28", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8747", "0", "459", "2017-05-31 00:44:21", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8748", "0", "earth", "2017-05-31 05:40:09", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8749", "0", "admin", "2017-05-31 10:14:00", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8750", "0", "news", "2017-05-31 11:31:22", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8751", "0", "assurance", "2017-06-01 01:02:18", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8752", "0", "admin", "2017-06-01 02:22:59", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8753", "1", "admin8576", "2017-06-01 08:33:33", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8754", "1", "admin8576", "2017-06-01 08:33:35", "61.54.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8755", "1", "admin8576", "2017-06-01 08:33:36", "168.63.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8756", "1", "admin8576", "2017-06-01 08:36:29", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8757", "0", "our", "2017-06-01 10:47:20", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8758", "1", "admin8576", "2017-06-01 14:25:23", "192.187.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8759", "1", "admin8576", "2017-06-01 14:25:24", "192.187.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8760", "1", "admin8576", "2017-06-01 14:25:24", "192.187.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8761", "0", "magma@magmainc.co.za", "2017-06-01 15:42:51", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8762", "0", "admin", "2017-06-01 18:33:30", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8763", "0", "124", "2017-06-02 01:52:52", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8764", "0", "admin", "2017-06-02 07:48:23", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8765", "0", "have", "2017-06-02 16:32:44", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8766", "0", "page", "2017-06-02 16:51:26", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8767", "0", "value", "2017-06-03 12:19:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8768", "0", "6001", "2017-06-03 18:08:51", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8769", "0", "admin", "2017-06-03 22:25:45", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8770", "0", "quality", "2017-06-03 23:18:46", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8771", "0", "admin", "2017-06-04 04:49:33", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8772", "0", "shop", "2017-06-04 05:07:06", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8773", "1", "admin8576", "2017-06-04 10:03:31", "220.164.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8774", "1", "admin8576", "2017-06-04 11:01:03", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8775", "0", "admin", "2017-06-04 12:39:30", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8776", "0", "incorporated", "2017-06-04 22:27:59", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8777", "0", "admin", "2017-06-05 09:16:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8778", "0", "admin", "2017-06-05 15:00:27", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8779", "0", "admin", "2017-06-05 16:25:50", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8780", "1", "admin8576", "2017-06-06 01:16:20", "199.59.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8781", "1", "admin8576", "2017-06-06 01:16:21", "199.59.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8782", "1", "admin8576", "2017-06-06 01:16:22", "199.59.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8783", "0", "admin", "2017-06-06 01:22:17", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8784", "0", "firm", "2017-06-06 02:22:30", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8785", "1", "admin8576", "2017-06-06 11:36:52", "142.54.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8786", "1", "admin8576", "2017-06-06 11:37:50", "142.54.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8787", "1", "admin8576", "2017-06-06 11:37:54", "142.54.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8788", "0", "admin", "2017-06-06 17:46:23", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8789", "1", "admin8576", "2017-06-07 03:44:52", "136.144.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8790", "1", "admin8576", "2017-06-07 03:44:58", "136.144.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8791", "1", "admin8576", "2017-06-07 03:44:59", "136.144.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8792", "0", "1132", "2017-06-07 05:52:43", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8793", "1", "admin8576", "2017-06-07 07:14:50", "58.17.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8794", "1", "admin8576", "2017-06-07 08:37:13", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8795", "1", "admin8576", "2017-06-07 08:37:13", "181.112.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8796", "1", "admin8576", "2017-06-07 08:41:48", "221.231.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8797", "0", "admin", "2017-06-07 09:23:34", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8798", "0", "building", "2017-06-07 17:01:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8799", "0", "admin", "2017-06-07 19:12:00", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8800", "0", "contact", "2017-06-08 03:14:44", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8801", "0", "anton", "2017-06-08 10:12:46", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8802", "0", "admin", "2017-06-08 21:58:04", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8803", "0", "admin", "2017-06-09 01:27:44", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8804", "0", "admin", "2017-06-09 15:55:05", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8805", "0", "admin", "2017-06-09 18:44:15", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8806", "0", "admin", "2017-06-09 22:49:12", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8807", "0", "why", "2017-06-10 00:04:00", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8808", "0", "admin", "2017-06-10 06:54:57", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8809", "0", "pretoria", "2017-06-10 08:08:39", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8810", "0", "admin", "2017-06-10 09:14:15", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8811", "0", "admin", "2017-06-10 10:18:55", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8812", "0", "admin", "2017-06-10 10:35:56", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8813", "1", "admin8576", "2017-06-10 11:35:09", "111.38.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8814", "1", "admin8576", "2017-06-10 11:35:13", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8815", "0", "prestigious", "2017-06-10 16:02:17", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8816", "0", "admin", "2017-06-10 17:18:43", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8817", "0", "admin", "2017-06-10 22:58:17", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8818", "0", "ourselves", "2017-06-11 02:26:37", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8819", "0", "admin", "2017-06-11 05:24:32", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8820", "0", "beneath", "2017-06-11 09:38:30", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8821", "0", "which", "2017-06-12 00:39:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8822", "0", "admin", "2017-06-12 02:02:52", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8823", "0", "admin", "2017-06-12 08:28:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8824", "0", "that", "2017-06-12 16:38:13", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8825", "0", "admin", "2017-06-13 00:07:38", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8826", "0", "africa", "2017-06-13 03:47:38", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8827", "0", "admin", "2017-06-13 05:57:22", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8828", "1", "admin8576", "2017-06-13 15:05:23", "107.150.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8829", "1", "admin8576", "2017-06-13 15:05:26", "107.150.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8830", "1", "admin8576", "2017-06-13 15:05:30", "107.150.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8831", "1", "admin8576", "2017-06-13 20:40:03", "185.100.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8832", "1", "admin8576", "2017-06-13 20:40:09", "222.223.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8833", "0", "time", "2017-06-13 22:41:25", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8834", "0", "admin", "2017-06-14 05:45:36", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8835", "0", "admin", "2017-06-14 09:20:21", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8836", "0", "admin", "2017-06-14 10:19:59", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8837", "0", "important", "2017-06-14 10:28:28", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8838", "0", "admin", "2017-06-14 17:49:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8839", "0", "volcano", "2017-06-15 02:13:39", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8840", "1", "admin8576", "2017-06-15 03:31:24", "117.253.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8841", "1", "admin8576", "2017-06-15 04:13:01", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8842", "0", "admin", "2017-06-15 04:48:51", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8843", "1", "admin8576", "2017-06-15 04:52:10", "220.241.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8844", "1", "admin8576", "2017-06-15 05:27:58", "159.20.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8845", "1", "admin8576", "2017-06-15 06:01:53", "85.35.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8846", "1", "admin8576", "2017-06-15 06:34:56", "93.188.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8847", "1", "admin8576", "2017-06-15 07:07:07", "59.127.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8848", "1", "admin8576", "2017-06-15 08:08:33", "43.226.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8849", "1", "admin8576", "2017-06-15 09:10:24", "182.73.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8850", "1", "admin8576", "2017-06-15 09:40:55", "89.121.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8851", "1", "admin8576", "2017-06-15 10:46:03", "115.186.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8852", "1", "admin8576", "2017-06-15 11:19:12", "62.103.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8853", "0", "admin", "2017-06-15 11:45:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8854", "1", "admin8576", "2017-06-15 11:47:53", "189.85.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8855", "1", "admin8576", "2017-06-15 12:15:58", "59.29.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8856", "1", "admin8576", "2017-06-15 12:45:31", "14.141.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8857", "1", "admin8576", "2017-06-15 13:49:35", "94.45.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8858", "1", "admin8576", "2017-06-15 14:19:24", "80.13.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8859", "1", "admin8576", "2017-06-15 14:50:32", "117.211.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8860", "1", "admin8576", "2017-06-15 15:18:54", "31.148.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8861", "1", "admin8576", "2017-06-15 15:49:11", "186.216.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8862", "1", "admin8576", "2017-06-15 16:50:38", "85.35.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8863", "1", "admin8576", "2017-06-15 17:20:20", "188.248.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8864", "1", "admin8576", "2017-06-15 18:16:22", "150.214.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8865", "1", "admin8576", "2017-06-15 18:42:59", "31.148.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8866", "0", "vermeaulen", "2017-06-15 20:20:17", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8867", "0", "admin", "2017-06-15 20:37:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8868", "0", "south", "2017-06-15 20:39:11", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8869", "1", "admin8576", "2017-06-15 21:54:09", "203.153.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8870", "0", "team", "2017-06-15 22:03:16", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8871", "1", "admin8576", "2017-06-15 22:23:56", "59.29.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8872", "1", "admin8576", "2017-06-15 22:54:03", "61.82.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8873", "0", "871", "2017-06-15 23:16:18", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8874", "1", "admin8576", "2017-06-15 23:24:44", "203.134.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8875", "1", "admin8576", "2017-06-16 01:45:08", "59.29.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8876", "1", "admin8576", "2017-06-16 03:40:07", "84.211.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8877", "1", "admin8576", "2017-06-16 04:37:53", "202.129.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8878", "1", "admin8576", "2017-06-16 05:10:06", "59.29.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8879", "1", "admin8576", "2017-06-16 05:39:39", "45.118.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8880", "1", "admin8576", "2017-06-16 06:08:46", "89.121.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8881", "1", "admin8576", "2017-06-16 07:04:00", "84.211.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8882", "1", "admin8576", "2017-06-16 08:35:10", "220.191.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8883", "0", "brands", "2017-06-16 09:23:20", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8884", "1", "admin8576", "2017-06-16 09:33:24", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8885", "1", "admin8576", "2017-06-16 10:31:59", "202.136.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8886", "0", "acquisitions", "2017-06-16 10:47:54", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8887", "1", "admin8576", "2017-06-16 12:00:00", "82.104.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8888", "1", "admin8576", "2017-06-16 12:27:39", "45.118.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8889", "1", "admin8576", "2017-06-16 15:01:24", "202.129.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8890", "1", "admin8576", "2017-06-16 15:31:41", "201.238.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8891", "1", "admin8576", "2017-06-16 16:01:40", "61.82.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8892", "1", "admin8576", "2017-06-16 17:02:07", "78.4.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8893", "1", "admin8576", "2017-06-16 18:01:14", "117.253.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8894", "1", "admin8576", "2017-06-16 18:57:07", "59.29.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8895", "1", "admin8576", "2017-06-16 20:20:47", "94.45.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8896", "1", "admin8576", "2017-06-16 20:49:33", "62.69.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8897", "1", "admin8576", "2017-06-16 21:17:57", "62.103.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8898", "1", "admin8576", "2017-06-16 21:46:38", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8899", "1", "admin8576", "2017-06-16 22:14:01", "186.216.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8900", "1", "admin8576", "2017-06-16 22:44:31", "59.127.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8901", "1", "admin8576", "2017-06-16 23:13:23", "203.134.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8902", "1", "admin8576", "2017-06-17 00:08:36", "115.186.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8903", "1", "admin8576", "2017-06-17 01:05:03", "84.238.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8904", "1", "admin8576", "2017-06-17 02:56:45", "62.28.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8905", "1", "admin8576", "2017-06-17 04:21:47", "43.226.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8906", "1", "admin8576", "2017-06-17 04:51:34", "218.25.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8907", "1", "admin8576", "2017-06-17 05:49:42", "117.253.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8908", "1", "admin8576", "2017-06-17 06:26:10", "190.254.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8909", "1", "admin8576", "2017-06-17 06:48:19", "59.127.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8910", "1", "admin8576", "2017-06-17 07:17:35", "117.211.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8911", "1", "admin8576", "2017-06-17 07:45:36", "202.129.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8912", "1", "admin8576", "2017-06-17 08:13:10", "78.5.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8913", "0", "admin", "2017-06-17 23:21:31", "197.83.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8914", "0", "admin", "2017-06-18 16:53:24", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8915", "0", "road", "2017-06-18 19:44:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8916", "0", "admin", "2017-06-19 05:52:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8917", "1", "admin8576", "2017-06-19 09:51:54", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8918", "1", "admin8576", "2017-06-19 09:51:56", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8919", "1", "admin8576", "2017-06-19 09:51:58", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8920", "0", "admin", "2017-06-19 14:46:58", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8921", "1", "admin8576", "2017-06-20 03:39:29", "185.172.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8922", "1", "admin8576", "2017-06-20 03:40:46", "197.149.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8923", "1", "admin8576", "2017-06-20 03:42:25", "82.194.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8924", "1", "admin8576", "2017-06-21 16:56:12", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8925", "1", "admin8576", "2017-06-21 16:56:16", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8926", "1", "admin8576", "2017-06-21 16:56:18", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8927", "2", "admin5748", "2017-06-23 01:12:09", "94.29.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8928", "1", "admin8576", "2017-06-23 01:12:10", "5.178.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8929", "0", "short", "2017-06-23 10:20:32", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8930", "0", "more", "2017-06-23 10:21:52", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8931", "0", "recently", "2017-06-23 14:29:01", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8932", "0", "admin", "2017-06-23 16:27:18", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8933", "0", "was", "2017-06-24 04:55:04", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8934", "0", "admin", "2017-06-24 10:30:18", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8935", "0", "admin", "2017-06-24 11:00:25", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8936", "0", "admin", "2017-06-25 05:21:48", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8937", "0", "create", "2017-06-25 10:30:55", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8938", "0", "formidable", "2017-06-25 12:53:14", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8939", "0", "admin", "2017-06-25 21:52:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8940", "0", "admin", "2017-06-26 03:19:45", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8941", "0", "admin", "2017-06-26 15:35:05", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8942", "0", "admin", "2017-06-26 23:21:14", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8943", "0", "admin", "2017-06-27 03:41:38", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8944", "0", "awarded", "2017-06-27 05:25:39", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8945", "0", "admin", "2017-06-27 11:21:29", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8946", "1", "admin8576", "2017-06-27 18:19:16", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8947", "1", "admin8576", "2017-06-27 18:19:17", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8948", "1", "admin8576", "2017-06-27 18:19:17", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8949", "0", "admin", "2017-06-27 21:54:29", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8950", "0", "admin", "2017-06-28 01:09:52", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8951", "0", "office", "2017-06-28 04:30:35", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8952", "0", "admin", "2017-06-28 09:48:05", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8953", "0", "admin", "2017-06-28 15:02:22", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8954", "0", "admin", "2017-06-28 15:43:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8955", "1", "admin8576", "2017-06-28 22:02:45", "95.137.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8956", "1", "admin8576", "2017-06-28 22:04:50", "178.124.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8957", "1", "admin8576", "2017-06-28 22:06:22", "89.148.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8958", "1", "admin8576", "2017-06-28 22:14:27", "168.63.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8959", "0", "providing", "2017-06-28 23:33:41", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8960", "0", "100", "2017-06-30 15:18:13", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8961", "0", "admin", "2017-06-30 16:24:16", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8962", "0", "run", "2017-07-01 08:59:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8963", "0", "versatile", "2017-07-01 11:10:23", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8964", "1", "admin8576", "2017-07-01 16:48:55", "203.202.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8965", "1", "admin8576", "2017-07-01 16:49:01", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8966", "1", "admin8576", "2017-07-01 22:07:44", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8967", "1", "admin8576", "2017-07-01 22:07:46", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8968", "1", "admin8576", "2017-07-01 22:07:47", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8969", "0", "admin", "2017-07-02 09:09:15", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8970", "0", "admin", "2017-07-02 09:34:42", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8971", "0", "june", "2017-07-02 18:54:56", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8972", "0", "economic", "2017-07-02 19:28:28", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8973", "0", "admin", "2017-07-02 22:51:00", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8974", "0", "main", "2017-07-03 02:27:55", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8975", "0", "surface", "2017-07-03 17:37:12", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8976", "0", "space", "2017-07-04 00:48:19", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8977", "1", "admin8576", "2017-07-04 09:03:58", "5.178.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8978", "2", "admin5748", "2017-07-04 09:04:06", "31.171.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8979", "0", "admin", "2017-07-04 09:17:22", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8980", "0", "admin", "2017-07-04 11:06:39", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8981", "0", "admin", "2017-07-04 13:10:19", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8982", "0", "african", "2017-07-04 16:38:22", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8983", "0", "spend", "2017-07-04 21:23:18", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8984", "0", "admin", "2017-07-05 05:53:49", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8985", "1", "admin8576", "2017-07-05 08:41:28", "5.83.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8986", "1", "admin8576", "2017-07-05 08:41:31", "27.189.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8987", "0", "admin", "2017-07-05 11:43:07", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8988", "0", "admin", "2017-07-05 20:10:39", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8989", "0", "admin", "2017-07-05 22:46:08", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8990", "0", "corporate", "2017-07-05 23:42:53", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8991", "0", "admin", "2017-07-06 22:19:38", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8992", "0", "admin", "2017-07-07 08:33:24", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8993", "0", "narrowing", "2017-07-07 19:55:22", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8994", "0", "2000", "2017-07-07 23:44:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8995", "1", "admin8576", "2017-07-08 02:34:58", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8996", "2", "admin5748", "2017-07-08 02:34:59", "88.201.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8997", "0", "solid", "2017-07-08 07:13:03", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8998", "0", "look", "2017-07-08 13:11:17", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("8999", "0", "competitive", "2017-07-08 15:24:16", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9000", "0", "admin", "2017-07-08 20:13:25", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9001", "0", "overnight", "2017-07-08 23:26:16", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9002", "0", "admin", "2017-07-09 01:35:46", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9003", "0", "magmai", "2017-07-09 07:06:32", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9004", "0", "admin", "2017-07-09 08:40:55", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9005", "0", "271", "2017-07-09 15:40:43", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9006", "1", "admin8576", "2017-07-09 20:52:18", "152.66.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9007", "1", "admin8576", "2017-07-09 20:52:21", "181.112.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9008", "1", "admin8576", "2017-07-09 21:05:35", "36.81.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9009", "1", "admin8576", "2017-07-09 21:36:39", "95.104.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9010", "0", "events", "2017-07-10 05:58:55", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9011", "0", "london", "2017-07-10 13:21:08", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9012", "0", "admin", "2017-07-10 15:07:54", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9013", "0", "admin", "2017-07-10 23:56:24", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9014", "0", "important", "2017-07-11 05:22:00", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9015", "0", "admin", "2017-07-11 08:38:03", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9016", "0", "where", "2017-07-11 10:49:50", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9017", "0", "lawyer", "2017-07-11 11:39:22", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9018", "0", "commercial", "2017-07-11 15:24:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9019", "0", "magm", "2017-07-11 16:08:23", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9020", "0", "run", "2017-07-12 04:52:35", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9021", "0", "everything", "2017-07-12 06:02:28", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9022", "0", "with", "2017-07-12 07:18:44", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9023", "0", "admin", "2017-07-12 11:16:49", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9024", "0", "admin", "2017-07-12 11:55:45", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9025", "0", "admin", "2017-07-13 00:43:36", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9026", "1", "admin8576", "2017-07-13 01:24:16", "95.104.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9027", "1", "admin8576", "2017-07-13 01:24:17", "195.228.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9028", "1", "admin8576", "2017-07-13 01:24:17", "195.228.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9029", "1", "admin8576", "2017-07-13 01:24:20", "95.104.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9030", "0", "admin", "2017-07-13 20:06:53", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9031", "0", "admin", "2017-07-13 23:42:50", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9032", "0", "admin", "2017-07-15 03:34:32", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9033", "0", "admin", "2017-07-15 04:54:06", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9034", "0", "people", "2017-07-15 08:40:04", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9035", "0", "admin", "2017-07-15 18:00:39", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9036", "0", "docex", "2017-07-15 20:21:54", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9037", "0", "admin", "2017-07-16 00:37:51", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9038", "0", "conveyancers", "2017-07-16 02:59:33", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9039", "0", "admin", "2017-07-16 03:12:18", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9040", "2", "admin5748", "2017-07-16 12:03:23", "190.220.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9041", "0", "research", "2017-07-16 17:05:10", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9042", "1", "admin8576", "2017-07-17 09:28:34", "173.208.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9043", "1", "admin8576", "2017-07-17 09:28:34", "173.208.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9044", "1", "admin8576", "2017-07-17 09:28:36", "173.208.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9045", "0", "assurance", "2017-07-17 13:58:57", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9046", "0", "600", "2017-07-18 07:31:39", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9047", "0", "pietermaritzburg", "2017-07-18 08:24:56", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9048", "1", "admin8576", "2017-07-18 15:01:18", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9049", "1", "admin8576", "2017-07-18 15:01:19", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9050", "1", "admin8576", "2017-07-18 16:03:19", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9051", "1", "admin8576", "2017-07-18 16:03:20", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9052", "1", "admin8576", "2017-07-18 16:36:35", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9053", "1", "admin8576", "2017-07-18 16:36:36", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9054", "1", "admin8576", "2017-07-18 19:22:04", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9055", "1", "admin8576", "2017-07-18 19:22:05", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9056", "1", "admin8576", "2017-07-18 19:51:35", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9057", "1", "admin8576", "2017-07-18 19:51:35", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9058", "1", "admin8576", "2017-07-18 20:23:15", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9059", "1", "admin8576", "2017-07-18 20:23:16", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9060", "1", "admin8576", "2017-07-18 20:53:56", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9061", "1", "admin8576", "2017-07-18 20:53:56", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9062", "1", "admin8576", "2017-07-18 21:25:04", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9063", "1", "admin8576", "2017-07-18 21:25:05", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9064", "1", "admin8576", "2017-07-18 21:55:21", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9065", "1", "admin8576", "2017-07-18 21:55:21", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9066", "1", "admin8576", "2017-07-18 22:27:01", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9067", "1", "admin8576", "2017-07-18 22:27:02", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9068", "1", "admin8576", "2017-07-18 22:57:38", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9069", "1", "admin8576", "2017-07-18 22:57:38", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9070", "1", "admin8576", "2017-07-18 23:29:18", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9071", "1", "admin8576", "2017-07-18 23:29:19", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9072", "1", "admin8576", "2017-07-19 00:00:02", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9073", "1", "admin8576", "2017-07-19 00:00:02", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9074", "1", "admin8576", "2017-07-19 00:32:03", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9075", "1", "admin8576", "2017-07-19 00:32:04", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9076", "1", "admin8576", "2017-07-19 01:03:59", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9077", "1", "admin8576", "2017-07-19 01:03:59", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9078", "1", "admin8576", "2017-07-19 01:37:10", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9079", "1", "admin8576", "2017-07-19 01:37:11", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9080", "1", "admin8576", "2017-07-19 02:09:21", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9081", "1", "admin8576", "2017-07-19 02:09:22", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9082", "1", "admin8576", "2017-07-19 02:42:52", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9083", "1", "admin8576", "2017-07-19 02:42:52", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9084", "1", "admin8576", "2017-07-19 03:15:14", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9085", "1", "admin8576", "2017-07-19 03:15:16", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9086", "1", "admin8576", "2017-07-19 03:47:55", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9087", "1", "admin8576", "2017-07-19 03:47:55", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9088", "0", "cape", "2017-07-19 03:50:11", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9089", "1", "admin8576", "2017-07-19 04:19:51", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9090", "1", "admin8576", "2017-07-19 04:19:52", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9091", "1", "admin8576", "2017-07-19 04:53:04", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9092", "1", "admin8576", "2017-07-19 04:53:04", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9093", "1", "admin8576", "2017-07-19 05:24:57", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9094", "1", "admin8576", "2017-07-19 05:24:57", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9095", "0", "admin", "2017-07-19 05:53:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9096", "1", "admin8576", "2017-07-19 05:57:58", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9097", "1", "admin8576", "2017-07-19 05:57:59", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9098", "1", "admin8576", "2017-07-19 06:30:05", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9099", "1", "admin8576", "2017-07-19 06:30:05", "54.208.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9100", "0", "admin", "2017-07-19 07:28:32", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9101", "0", "collecting", "2017-07-19 08:30:58", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9102", "0", "admin", "2017-07-19 17:58:44", "222.223.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9103", "0", "admin", "2017-07-19 17:58:54", "206.214.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9104", "0", "admin", "2017-07-19 18:51:14", "82.165.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9105", "0", "without", "2017-07-21 02:26:43", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9106", "0", "admin", "2017-07-21 17:34:49", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9107", "0", "admin", "2017-07-21 17:57:32", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9108", "0", "services", "2017-07-21 18:43:09", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9109", "0", "twitter", "2017-07-21 20:32:52", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9110", "0", "admin", "2017-07-21 21:16:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9111", "0", "the", "2017-07-22 00:09:46", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9112", "0", "letters", "2017-07-22 01:48:10", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9113", "0", "admin", "2017-07-22 05:02:57", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9114", "0", "level", "2017-07-22 15:22:30", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9115", "0", "admin", "2017-07-22 20:39:20", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9116", "0", "admin", "2017-07-23 00:19:41", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9117", "0", "agencies", "2017-07-23 03:51:27", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9118", "0", "admin", "2017-07-23 16:16:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9119", "0", "diversified", "2017-07-23 23:52:29", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9120", "0", "admin", "2017-07-24 06:46:38", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9121", "0", "docex", "2017-07-24 17:55:53", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9122", "0", "admin", "2017-07-25 00:49:17", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9123", "0", "nile", "2017-07-25 06:13:01", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9124", "0", "admin", "2017-07-25 14:33:40", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9125", "0", "various", "2017-07-25 15:14:12", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9126", "0", "admin", "2017-07-25 17:13:45", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9127", "0", "address", "2017-07-25 20:29:15", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9128", "0", "june", "2017-07-25 23:53:53", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9129", "0", "admin", "2017-07-26 09:37:14", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9130", "0", "admin", "2017-07-26 11:09:23", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9131", "0", "admin", "2017-07-26 11:25:30", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9132", "0", "inc", "2017-07-26 21:36:54", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9133", "0", "admin", "2017-07-26 21:43:42", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9134", "0", "admin", "2017-07-27 03:12:34", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9135", "0", "admin", "2017-07-27 04:00:48", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9136", "0", "sandown", "2017-07-27 04:13:05", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9137", "0", "port", "2017-07-27 17:51:44", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9138", "0", "admin", "2017-07-27 18:21:07", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9139", "0", "south", "2017-07-27 20:25:54", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9140", "0", "acquisition", "2017-07-28 01:23:03", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9141", "0", "needs", "2017-07-28 03:29:40", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9142", "0", "city", "2017-07-28 04:19:06", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9143", "0", "admin", "2017-07-28 05:02:08", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9144", "0", "admin", "2017-07-28 08:30:07", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9145", "0", "africa", "2017-07-28 21:35:19", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9146", "0", "admin", "2017-07-29 07:40:04", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9147", "0", "our", "2017-07-29 11:49:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9148", "1", "admin8576", "2017-07-29 16:13:27", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9149", "1", "admin8576", "2017-07-29 16:13:29", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9150", "1", "admin8576", "2017-07-29 16:13:30", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9151", "1", "admin8576", "2017-07-30 15:29:45", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9152", "1", "admin8576", "2017-07-30 15:29:50", "103.24.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9153", "1", "admin8576", "2017-07-30 15:46:35", "113.240.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9154", "1", "admin8576", "2017-07-30 18:03:40", "41.76.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9155", "0", "magma", "2017-07-30 21:12:03", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9156", "0", "award", "2017-07-30 22:01:21", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9157", "0", "builder", "2017-07-31 01:03:52", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9158", "0", "admin", "2017-07-31 01:56:04", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9159", "0", "admin", "2017-07-31 10:18:18", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9160", "1", "admin8576", "2017-07-31 12:39:25", "37.187.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9161", "0", "admin", "2017-07-31 16:33:25", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9162", "0", "admin", "2017-08-01 06:27:47", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9163", "0", "within", "2017-08-01 09:14:36", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9164", "0", "admin", "2017-08-01 13:26:00", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9165", "0", "admin", "2017-08-01 19:46:06", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9166", "0", "admin", "2017-08-01 20:25:12", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9167", "0", "unnecessary", "2017-08-01 23:36:32", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9168", "0", "admin", "2017-08-02 02:01:43", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9169", "0", "chairman", "2017-08-02 07:06:01", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9170", "0", "admin", "2017-08-02 08:05:09", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9171", "0", "admin", "2017-08-02 09:58:18", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9172", "0", "admin", "2017-08-02 09:58:26", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9173", "0", "one", "2017-08-02 14:25:23", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9174", "0", "admin", "2017-08-02 15:15:51", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9175", "0", "ainc", "2017-08-02 15:37:02", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9176", "0", "admin", "2017-08-02 17:56:01", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9177", "1", "admin8576", "2017-08-02 23:08:22", "197.231.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9178", "0", "admin", "2017-08-03 04:55:31", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9179", "3", "Editorial5", "2017-08-03 16:05:28", "105.212.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9180", "3", "Editorial5", "2017-08-03 16:07:25", "105.212.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9181", "3", "editorial5", "2017-08-03 16:07:50", "105.212.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9182", "0", "regard", "2017-08-03 16:43:42", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9183", "1", "admin8576", "2017-08-03 17:51:35", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9184", "1", "admin8576", "2017-08-03 17:51:37", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9185", "1", "admin8576", "2017-08-03 17:51:38", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9186", "1", "admin8576", "2017-08-04 04:47:14", "112.120.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9187", "1", "admin8576", "2017-08-04 04:48:33", "37.187.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9188", "1", "admin8576", "2017-08-04 05:09:30", "61.148.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9189", "2", "admin5748", "2017-08-05 07:16:40", "185.140.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9190", "2", "admin5748", "2017-08-05 07:16:42", "185.140.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9191", "2", "admin5748", "2017-08-05 07:16:42", "185.140.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9192", "1", "admin8576", "2017-08-05 14:29:34", "104.130.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9193", "1", "admin8576", "2017-08-05 14:29:35", "104.130.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9194", "1", "admin8576", "2017-08-05 14:29:36", "104.130.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9195", "1", "admin8576", "2017-08-05 16:38:06", "61.178.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9196", "1", "admin8576", "2017-08-05 16:38:13", "43.254.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9197", "1", "admin8576", "2017-08-05 16:38:21", "114.7.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9198", "1", "admin8576", "2017-08-05 16:38:51", "27.111.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9199", "1", "admin8576", "2017-08-05 18:22:46", "188.169.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9200", "2", "admin5748", "2017-08-06 09:44:26", "62.48.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9201", "2", "admin5748", "2017-08-06 09:44:31", "62.48.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9202", "2", "admin5748", "2017-08-06 09:44:36", "62.48.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9203", "1", "admin8576", "2017-08-06 15:33:51", "104.250.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9204", "1", "admin8576", "2017-08-06 15:33:52", "104.250.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9205", "1", "admin8576", "2017-08-06 15:33:53", "104.250.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9206", "2", "admin5748", "2017-08-06 20:25:33", "104.219.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9207", "2", "admin5748", "2017-08-06 20:25:36", "104.219.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9208", "2", "admin5748", "2017-08-06 20:25:37", "104.219.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9209", "1", "admin8576", "2017-08-06 22:14:35", "46.105.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9210", "1", "admin8576", "2017-08-06 22:14:36", "46.105.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9211", "1", "admin8576", "2017-08-06 22:14:36", "46.105.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9212", "0", "temperature", "2017-08-07 13:33:31", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9213", "0", "admin", "2017-08-07 18:46:22", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9214", "1", "admin8576", "2017-08-08 04:26:40", "200.113.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9215", "1", "admin8576", "2017-08-08 04:37:00", "218.107.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9216", "1", "admin8576", "2017-08-08 05:28:20", "86.57.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9217", "0", "gmain", "2017-08-09 12:09:38", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9218", "0", "admin", "2017-08-09 21:04:38", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9219", "0", "magm", "2017-08-10 05:50:55", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9220", "0", "certified", "2017-08-10 11:46:35", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9221", "0", "admin", "2017-08-10 14:45:47", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9222", "1", "admin8576", "2017-08-10 21:19:46", "60.215.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9223", "1", "admin8576", "2017-08-10 21:35:16", "91.135.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9224", "1", "admin8576", "2017-08-10 21:35:45", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9225", "1", "admin8576", "2017-08-11 02:21:01", "120.196.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9226", "0", "talented", "2017-08-11 06:22:16", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9227", "0", "incorporated", "2017-08-11 09:28:01", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9228", "0", "admin", "2017-08-11 13:12:39", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9229", "0", "admin", "2017-08-11 14:12:23", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9230", "0", "admin", "2017-08-12 10:45:59", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9231", "0", "adderley", "2017-08-12 14:24:55", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9232", "0", "street", "2017-08-12 20:12:33", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9233", "1", "admin8576", "2017-08-13 16:11:48", "80.14.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9234", "1", "admin8576", "2017-08-13 16:11:59", "123.138.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9235", "1", "admin8576", "2017-08-13 16:33:07", "186.215.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9236", "1", "admin8576", "2017-08-14 01:00:49", "36.66.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9237", "1", "admin8576", "2017-08-14 01:09:34", "221.226.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9238", "1", "admin8576", "2017-08-16 13:38:34", "222.176.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9239", "1", "admin8576", "2017-08-16 13:38:50", "61.37.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9240", "1", "admin8576", "2017-08-16 13:40:11", "210.74.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9241", "1", "admin8576", "2017-08-16 14:13:57", "120.87.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9242", "1", "admin8576", "2017-08-16 19:00:19", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9243", "1", "admin8576", "2017-08-16 20:03:56", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9244", "1", "admin8576", "2017-08-16 20:33:59", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9245", "1", "admin8576", "2017-08-16 21:04:04", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9246", "1", "admin8576", "2017-08-16 21:33:13", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9247", "1", "admin8576", "2017-08-16 22:04:19", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9248", "1", "admin8576", "2017-08-16 22:36:16", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9249", "1", "admin8576", "2017-08-16 23:08:56", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9250", "1", "admin8576", "2017-08-16 23:40:45", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9251", "1", "admin8576", "2017-08-17 00:13:17", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9252", "1", "admin8576", "2017-08-17 00:44:57", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9253", "1", "admin8576", "2017-08-17 01:09:56", "198.204.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9254", "1", "admin8576", "2017-08-17 01:09:57", "198.204.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9255", "1", "admin8576", "2017-08-17 01:09:58", "198.204.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9256", "1", "admin8576", "2017-08-17 01:18:14", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9257", "1", "admin8576", "2017-08-17 01:50:13", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9258", "1", "admin8576", "2017-08-17 02:23:19", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9259", "1", "admin8576", "2017-08-17 02:55:17", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9260", "1", "admin8576", "2017-08-17 03:29:26", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9261", "1", "admin8576", "2017-08-17 04:02:25", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9262", "1", "admin8576", "2017-08-17 04:36:32", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9263", "1", "admin8576", "2017-08-17 05:09:35", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9264", "1", "admin8576", "2017-08-17 05:43:44", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9265", "1", "admin8576", "2017-08-17 06:16:59", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9266", "1", "admin8576", "2017-08-17 06:51:33", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9267", "1", "admin8576", "2017-08-17 07:25:17", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9268", "1", "admin8576", "2017-08-17 07:58:57", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9269", "1", "admin8576", "2017-08-17 08:32:49", "54.186.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9270", "1", "admin8576", "2017-08-19 03:01:07", "60.5.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9271", "1", "admin8576", "2017-08-19 03:24:44", "220.164.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9272", "1", "admin8576", "2017-08-19 03:42:30", "119.146.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9273", "1", "admin8576", "2017-08-19 03:44:21", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9274", "1", "admin8576", "2017-08-19 13:46:31", "74.91.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9275", "1", "admin8576", "2017-08-19 13:46:32", "74.91.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9276", "1", "admin8576", "2017-08-19 13:46:33", "74.91.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9277", "0", "bbb", "2017-08-21 19:45:10", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9278", "0", "numerous", "2017-08-21 20:53:43", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9279", "1", "admin8576", "2017-08-21 22:14:21", "5.178.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9280", "1", "admin8576", "2017-08-21 22:14:27", "62.86.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9281", "1", "admin8576", "2017-08-21 22:14:28", "62.86.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9282", "1", "admin8576", "2017-08-21 22:22:21", "101.66.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9283", "0", "admin", "2017-08-22 08:21:44", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9284", "0", "innovative", "2017-08-22 11:34:33", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9285", "0", "admin", "2017-08-23 09:29:49", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9286", "1", "admin8576", "2017-08-23 19:46:32", "58.57.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9287", "0", "admin", "2017-08-23 19:46:46", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9288", "0", "history", "2017-08-23 23:03:43", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9289", "0", "formed", "2017-08-23 23:49:42", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9290", "1", "admin8576", "2017-08-24 12:22:10", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9291", "1", "admin8576", "2017-08-24 12:24:31", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9292", "1", "admin8576", "2017-08-24 12:44:46", "186.182.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9293", "0", "admin", "2017-08-24 18:51:52", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9294", "0", "admin", "2017-08-25 02:15:35", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9295", "0", "admin", "2017-08-25 06:53:41", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9296", "0", "9301", "2017-08-25 09:58:50", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9297", "0", "admin", "2017-08-26 02:03:46", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9298", "0", "admin", "2017-08-26 21:47:06", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9299", "0", "admin", "2017-08-26 22:34:28", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9300", "2", "admin5748", "2017-08-27 00:01:10", "193.84.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9301", "2", "admin5748", "2017-08-27 00:01:10", "193.84.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9302", "2", "admin5748", "2017-08-27 00:01:11", "193.84.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9303", "0", "dominate", "2017-08-27 00:26:55", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9304", "0", "erupts", "2017-08-27 01:56:16", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9305", "0", "regard", "2017-08-27 02:59:26", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9306", "0", "admin", "2017-08-27 04:19:25", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9307", "1", "admin8576", "2017-08-27 04:23:39", "212.198.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9308", "1", "admin8576", "2017-08-27 04:23:41", "31.148.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9309", "1", "admin8576", "2017-08-27 04:24:20", "103.36.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9310", "1", "admin8576", "2017-08-27 04:27:04", "113.95.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9311", "1", "admin8576", "2017-08-27 07:03:26", "114.135.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9312", "1", "admin8576", "2017-08-27 08:51:02", "192.169.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9313", "1", "admin8576", "2017-08-27 08:51:03", "192.169.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9314", "1", "admin8576", "2017-08-27 08:51:04", "192.169.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9315", "0", "admin", "2017-08-29 21:01:07", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9316", "1", "admin8576", "2017-08-29 22:18:56", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9317", "1", "admin8576", "2017-08-29 22:19:04", "88.32.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9318", "1", "admin8576", "2017-08-29 22:19:53", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9319", "1", "admin8576", "2017-08-29 22:20:17", "190.5.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9320", "0", "admin", "2017-08-30 10:29:11", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9321", "0", "admin", "2017-08-30 11:55:59", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9322", "0", "admin", "2017-08-30 13:58:27", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9323", "0", "admin", "2017-08-31 06:25:42", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9324", "0", "admin", "2017-08-31 12:26:49", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9325", "0", "diverse", "2017-08-31 16:14:23", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9326", "0", "admin", "2017-09-01 04:35:37", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9327", "1", "admin8576", "2017-09-01 05:58:13", "200.7.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9328", "1", "admin8576", "2017-09-01 06:30:32", "218.104.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9329", "0", "admin", "2017-09-01 09:02:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9330", "0", "subscription", "2017-09-01 09:21:49", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9331", "1", "admin8576", "2017-09-01 11:57:54", "27.111.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9332", "1", "admin8576", "2017-09-01 12:49:21", "142.54.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9333", "1", "admin8576", "2017-09-01 12:49:22", "142.54.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9334", "1", "admin8576", "2017-09-01 12:49:23", "142.54.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9335", "0", "admin", "2017-09-01 15:08:42", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9336", "0", "admin", "2017-09-02 11:07:28", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9337", "0", "salmon", "2017-09-02 11:45:17", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9338", "0", "admin", "2017-09-02 12:29:27", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9339", "0", "ability", "2017-09-02 23:02:54", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9340", "0", "onto", "2017-09-03 00:16:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9341", "0", "combination", "2017-09-03 07:08:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9342", "0", "designed", "2017-09-03 08:42:53", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9343", "1", "admin8576", "2017-09-04 16:00:03", "5.83.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9344", "1", "admin8576", "2017-09-04 16:25:04", "95.104.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9345", "1", "admin8576", "2017-09-04 16:42:45", "181.113.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9346", "0", "admin", "2017-09-04 20:40:21", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9347", "0", "admin", "2017-09-05 14:41:54", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9348", "0", "when", "2017-09-05 16:56:34", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9349", "1", "admin8576", "2017-09-07 01:24:38", "58.57.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9350", "1", "admin8576", "2017-09-07 01:27:57", "78.36.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9351", "1", "admin8576", "2017-09-07 02:17:04", "115.238.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9352", "1", "admin8576", "2017-09-07 03:38:44", "31.148.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9353", "0", "admin", "2017-09-07 08:57:10", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9354", "0", "admin", "2017-09-07 14:42:58", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9355", "0", "admin", "2017-09-08 01:33:12", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9356", "0", "meets", "2017-09-08 10:21:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9357", "0", "admin", "2017-09-08 13:28:15", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9358", "0", "785", "2017-09-09 00:15:24", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9359", "0", "admin", "2017-09-09 02:04:14", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9360", "1", "admin8576", "2017-09-09 10:27:41", "197.45.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9361", "1", "admin8576", "2017-09-09 10:27:47", "222.221.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9362", "1", "admin8576", "2017-09-09 10:33:28", "130.0.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9363", "1", "admin8576", "2017-09-09 10:36:00", "77.242.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9364", "0", "law", "2017-09-09 12:58:10", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9365", "1", "admin8576", "2017-09-09 17:58:42", "190.167.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9366", "0", "admin", "2017-09-09 18:03:59", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9367", "0", "admin", "2017-09-10 01:21:45", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9368", "0", "admin", "2017-09-10 02:37:26", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9369", "0", "mergers", "2017-09-10 06:17:01", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9370", "0", "admin", "2017-09-10 10:31:05", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9371", "0", "attending", "2017-09-10 18:20:43", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9372", "0", "admin", "2017-09-11 04:15:29", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9373", "1", "admin8576", "2017-09-11 09:25:38", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9374", "1", "admin8576", "2017-09-11 09:25:39", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9375", "1", "admin8576", "2017-09-11 09:25:42", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9376", "0", "admin", "2017-09-11 14:27:48", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9377", "0", "resourced", "2017-09-11 22:54:05", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9378", "0", "admin", "2017-09-12 00:14:50", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9379", "0", "city", "2017-09-12 01:26:20", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9380", "0", "labour", "2017-09-12 07:43:09", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9381", "0", "most", "2017-09-12 14:22:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9382", "1", "admin8576", "2017-09-12 16:49:24", "81.164.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9383", "0", "admin", "2017-09-12 16:49:59", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9384", "1", "admin8576", "2017-09-12 16:58:09", "219.138.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9385", "0", "admin", "2017-09-12 19:03:06", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9386", "1", "admin8576", "2017-09-12 20:25:46", "190.167.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9387", "0", "admin", "2017-09-12 23:26:58", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9388", "0", "offices", "2017-09-13 02:04:11", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9389", "0", "dominate", "2017-09-13 06:56:38", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9390", "0", "magmainc", "2017-09-13 08:59:36", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9391", "0", "physical", "2017-09-13 11:03:17", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9392", "0", "service", "2017-09-14 08:02:45", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9393", "0", "admin", "2017-09-14 09:02:27", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9394", "0", "admin", "2017-09-14 09:59:46", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9395", "0", "admin", "2017-09-14 12:44:16", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9396", "0", "roots", "2017-09-14 22:20:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9397", "0", "for", "2017-09-15 00:04:32", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9398", "0", "admin", "2017-09-15 02:44:48", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9399", "1", "admin8576", "2017-09-15 02:47:36", "45.125.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9400", "1", "admin8576", "2017-09-15 03:17:34", "218.61.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9401", "1", "admin8576", "2017-09-15 04:09:36", "5.178.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9402", "0", "admin", "2017-09-15 11:08:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9403", "0", "600", "2017-09-15 13:06:27", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9404", "0", "admin", "2017-09-15 16:15:04", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9405", "0", "admin", "2017-09-15 16:49:59", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9406", "0", "awards", "2017-09-15 23:26:33", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9407", "2", "admin5748", "2017-09-16 02:26:04", "142.4.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9408", "2", "admin5748", "2017-09-16 02:26:05", "142.4.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9409", "2", "admin5748", "2017-09-16 02:26:06", "142.4.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9410", "1", "admin8576", "2017-09-16 03:57:16", "216.245.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9411", "1", "admin8576", "2017-09-16 03:57:17", "216.245.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9412", "1", "admin8576", "2017-09-16 03:57:18", "216.245.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9413", "0", "admin", "2017-09-16 08:01:21", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9414", "0", "addresses", "2017-09-16 21:22:43", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9415", "0", "magma@magmainc.co.za", "2017-09-16 22:53:35", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9416", "0", "floor", "2017-09-17 00:33:41", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9417", "0", "admin", "2017-09-17 03:45:40", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9418", "1", "admin8576", "2017-09-17 11:44:43", "95.104.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9419", "1", "admin8576", "2017-09-17 11:45:00", "36.66.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9420", "1", "admin8576", "2017-09-17 12:25:12", "95.104.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9421", "1", "admin8576", "2017-09-17 13:13:28", "124.129.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9422", "0", "staff", "2017-09-17 14:13:27", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9423", "0", "admin", "2017-09-17 17:50:05", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9424", "1", "admin8576", "2017-09-17 18:26:41", "190.210.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9425", "0", "look", "2017-09-18 01:37:32", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9426", "0", "against", "2017-09-18 06:55:40", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9427", "0", "years", "2017-09-18 08:25:04", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9428", "0", "admin", "2017-09-18 10:21:35", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9429", "0", "admin", "2017-09-18 14:24:11", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9430", "1", "admin8576", "2017-09-18 15:43:48", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9431", "0", "cape", "2017-09-18 18:57:21", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9432", "0", "admin", "2017-09-19 16:00:27", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9433", "0", "name", "2017-09-19 16:18:11", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9434", "0", "exceeds", "2017-09-19 20:21:20", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9435", "1", "admin8576", "2017-09-20 02:31:30", "113.240.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9436", "1", "admin8576", "2017-09-20 02:59:08", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9437", "1", "admin8576", "2017-09-20 06:29:00", "88.201.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9438", "0", "admin", "2017-09-20 10:39:09", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9439", "0", "statutes", "2017-09-20 18:19:09", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9440", "0", "documents", "2017-09-20 20:39:17", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9441", "0", "attorneys", "2017-09-20 22:51:21", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9442", "0", "form", "2017-09-21 13:41:47", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9443", "0", "admin", "2017-09-21 21:42:38", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9444", "0", "firm", "2017-09-22 12:53:32", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9445", "1", "admin8576", "2017-09-22 18:59:05", "80.152.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9446", "0", "top", "2017-09-22 22:21:30", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9447", "0", "admin", "2017-09-23 10:45:27", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9448", "0", "pave", "2017-09-23 11:13:53", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9449", "0", "admin", "2017-09-23 13:53:19", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9450", "0", "admin", "2017-09-23 14:42:24", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9451", "1", "admin8576", "2017-09-23 17:29:57", "82.98.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9452", "0", "admin", "2017-09-23 17:35:49", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9453", "0", "4000", "2017-09-23 19:35:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9454", "0", "exactly", "2017-09-23 23:15:26", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9455", "0", "admin", "2017-09-24 07:52:53", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9456", "0", "admin", "2017-09-24 17:20:38", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9457", "0", "admin", "2017-09-25 02:46:31", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9458", "1", "admin8576", "2017-09-25 12:06:00", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9459", "0", "admin", "2017-09-25 12:21:58", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9460", "0", "admin", "2017-09-25 13:42:28", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9461", "0", "admin", "2017-09-25 14:03:07", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9462", "0", "admin", "2017-09-25 22:19:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9463", "0", "admin", "2017-09-26 01:19:46", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9464", "1", "admin8576", "2017-09-26 01:36:40", "131.72.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9465", "0", "admin", "2017-09-26 04:14:27", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9466", "0", "years", "2017-09-26 12:12:04", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9467", "0", "admin", "2017-09-27 05:07:48", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9468", "0", "3358", "2017-09-27 05:34:50", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9469", "1", "admin8576", "2017-09-27 09:17:07", "69.195.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9470", "2", "admin5748", "2017-09-27 09:17:08", "58.65.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9471", "0", "magmain", "2017-09-27 17:05:37", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9472", "1", "admin8576", "2017-09-27 19:18:01", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9473", "1", "admin8576", "2017-09-27 19:18:03", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9474", "1", "admin8576", "2017-09-27 19:18:04", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9475", "0", "ensure", "2017-09-27 20:34:25", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9476", "0", "admin", "2017-09-28 02:37:50", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9477", "0", "admin", "2017-09-28 03:08:28", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9478", "0", "admin", "2017-09-28 04:27:03", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9479", "0", "cnr", "2017-09-28 14:12:31", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9480", "0", "admin", "2017-09-28 17:39:38", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9481", "0", "admin", "2017-09-29 00:17:14", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9482", "0", "heart", "2017-09-29 04:21:01", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9483", "1", "admin8576", "2017-09-29 04:59:09", "217.155.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9484", "1", "admin8576", "2017-09-29 05:20:55", "110.185.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9485", "1", "admin8576", "2017-09-29 05:48:52", "118.98.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9486", "0", "admin", "2017-09-29 18:27:11", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9487", "0", "admin", "2017-09-29 22:34:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9488", "0", "information", "2017-09-29 22:35:25", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9489", "0", "page", "2017-09-29 23:13:30", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9490", "0", "admin", "2017-09-30 00:29:32", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9491", "1", "admin8576", "2017-09-30 01:12:40", "177.135.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9492", "0", "admin", "2017-09-30 13:45:42", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9493", "1", "admin8576", "2017-09-30 14:53:52", "94.87.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9494", "0", "admin", "2017-09-30 15:13:54", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9495", "1", "admin8576", "2017-09-30 15:30:43", "120.209.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9496", "1", "admin8576", "2017-09-30 16:09:34", "187.216.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9497", "1", "admin8576", "2017-09-30 16:52:46", "80.19.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9498", "1", "admin8576", "2017-09-30 17:33:46", "90.178.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9499", "1", "admin8576", "2017-09-30 18:14:50", "62.209.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9500", "1", "admin8576", "2017-09-30 18:57:07", "188.169.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9501", "1", "admin8576", "2017-09-30 19:39:46", "109.81.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9502", "1", "admin8576", "2017-09-30 20:22:04", "5.150.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9503", "1", "admin8576", "2017-09-30 21:03:54", "217.125.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9504", "1", "admin8576", "2017-09-30 21:44:45", "78.11.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9505", "0", "0759", "2017-09-30 22:12:34", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9506", "1", "admin8576", "2017-09-30 22:26:41", "60.13.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9507", "1", "admin8576", "2017-10-01 00:31:28", "200.43.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9508", "1", "admin8576", "2017-10-01 01:14:30", "109.81.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9509", "0", "admin", "2017-10-01 01:41:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9510", "1", "admin8576", "2017-10-01 01:58:04", "81.164.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9511", "1", "admin8576", "2017-10-01 02:41:06", "90.176.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9512", "1", "admin8576", "2017-10-01 04:04:46", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9513", "1", "admin8576", "2017-10-01 04:42:18", "115.186.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9514", "1", "admin8576", "2017-10-01 06:02:00", "177.230.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9515", "1", "admin8576", "2017-10-01 07:20:45", "59.19.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9516", "1", "admin8576", "2017-10-01 08:41:19", "90.177.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9517", "1", "admin8576", "2017-10-01 09:23:36", "91.151.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9518", "1", "admin8576", "2017-10-01 10:05:58", "88.53.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9519", "0", "client", "2017-10-01 10:43:28", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9520", "1", "admin8576", "2017-10-01 12:11:00", "5.150.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9521", "1", "admin8576", "2017-10-01 13:35:16", "88.100.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9522", "1", "admin8576", "2017-10-01 14:16:56", "88.53.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9523", "0", "government", "2017-10-01 14:43:02", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9524", "1", "admin8576", "2017-10-01 15:00:22", "212.142.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9525", "1", "admin8576", "2017-10-01 15:43:18", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9526", "1", "admin8576", "2017-10-01 16:25:26", "66.98.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9527", "1", "admin8576", "2017-10-01 17:05:14", "90.177.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9528", "1", "admin8576", "2017-10-01 17:44:49", "109.99.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9529", "1", "admin8576", "2017-10-01 18:36:31", "194.243.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9530", "1", "admin8576", "2017-10-01 18:44:22", "185.73.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9531", "1", "admin8576", "2017-10-01 18:44:23", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9532", "1", "admin8576", "2017-10-01 18:44:24", "219.149.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9533", "1", "admin8576", "2017-10-01 19:48:05", "59.19.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9534", "1", "admin8576", "2017-10-01 20:30:24", "77.95.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9535", "0", "magale", "2017-10-01 21:46:49", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9536", "1", "admin8576", "2017-10-01 21:52:26", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9537", "1", "admin8576", "2017-10-01 22:09:13", "84.238.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9538", "1", "admin8576", "2017-10-01 22:33:45", "88.53.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9539", "0", "admin", "2017-10-01 23:06:02", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9540", "1", "admin8576", "2017-10-01 23:13:33", "90.177.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9541", "1", "admin8576", "2017-10-01 23:55:00", "90.178.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9542", "0", "admin", "2017-10-02 00:01:48", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9543", "1", "admin8576", "2017-10-02 00:33:53", "85.172.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9544", "1", "admin8576", "2017-10-02 01:14:48", "109.80.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9545", "0", "ainc", "2017-10-02 01:41:08", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9546", "1", "admin8576", "2017-10-02 01:54:04", "109.81.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9547", "1", "admin8576", "2017-10-02 02:33:22", "189.254.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9548", "1", "admin8576", "2017-10-02 03:12:31", "201.38.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9549", "1", "admin8576", "2017-10-02 03:53:10", "109.80.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9550", "0", "benchmark", "2017-10-02 04:13:43", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9551", "0", "admin", "2017-10-02 04:40:42", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9552", "1", "admin8576", "2017-10-02 05:16:59", "90.176.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9553", "1", "admin8576", "2017-10-02 05:58:27", "187.188.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9554", "1", "admin8576", "2017-10-02 06:37:55", "185.93.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9555", "1", "admin8576", "2017-10-02 07:58:03", "109.80.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9556", "1", "admin8576", "2017-10-02 08:38:18", "189.254.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9557", "1", "admin8576", "2017-10-02 10:01:09", "109.81.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9558", "1", "admin8576", "2017-10-02 10:41:44", "90.178.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9559", "0", "2146", "2017-10-02 11:25:45", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9560", "1", "admin8576", "2017-10-02 12:02:22", "83.208.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9561", "1", "admin8576", "2017-10-02 12:40:26", "109.80.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9562", "1", "admin8576", "2017-10-02 13:18:52", "78.4.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9563", "1", "admin8576", "2017-10-02 14:00:21", "193.188.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9564", "1", "admin8576", "2017-10-02 14:41:14", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9565", "1", "admin8576", "2017-10-02 15:20:38", "187.237.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9566", "1", "admin8576", "2017-10-02 16:02:08", "90.177.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9567", "1", "admin8576", "2017-10-02 16:42:23", "90.177.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9568", "1", "admin8576", "2017-10-02 17:23:45", "5.150.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9569", "1", "admin8576", "2017-10-02 19:24:21", "2.230.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9570", "1", "admin8576", "2017-10-02 20:06:32", "85.70.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9571", "1", "admin8576", "2017-10-02 21:27:46", "91.122.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9572", "1", "admin8576", "2017-10-02 22:06:35", "89.218.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9573", "1", "admin8576", "2017-10-02 22:45:39", "81.208.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9574", "1", "admin8576", "2017-10-02 23:25:18", "79.139.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9575", "1", "admin8576", "2017-10-03 00:03:02", "203.242.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9576", "1", "admin8576", "2017-10-03 00:40:47", "81.208.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9577", "1", "admin8576", "2017-10-03 01:16:17", "92.101.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9578", "1", "admin8576", "2017-10-03 01:50:52", "189.114.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9579", "1", "admin8576", "2017-10-03 02:26:10", "201.18.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9580", "1", "admin8576", "2017-10-03 03:37:00", "202.98.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9581", "1", "admin8576", "2017-10-03 04:11:50", "90.177.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9582", "0", "admin", "2017-10-03 04:19:46", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9583", "0", "admin", "2017-10-03 04:41:40", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9584", "1", "admin8576", "2017-10-03 05:23:21", "93.63.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9585", "1", "admin8576", "2017-10-03 06:00:09", "90.178.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9586", "1", "admin8576", "2017-10-03 07:10:31", "185.49.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9587", "1", "admin8576", "2017-10-03 07:44:42", "58.65.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9588", "1", "admin8576", "2017-10-03 08:17:22", "220.191.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9589", "1", "admin8576", "2017-10-03 08:48:59", "62.112.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9590", "1", "admin8576", "2017-10-03 09:22:39", "109.81.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9591", "1", "admin8576", "2017-10-03 09:56:20", "62.148.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9592", "1", "admin8576", "2017-10-03 11:35:12", "85.14.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9593", "1", "admin8576", "2017-10-03 12:42:28", "91.76.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9594", "1", "admin8576", "2017-10-03 13:16:58", "109.99.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9595", "0", "resourced", "2017-10-03 20:37:42", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9596", "0", "admin", "2017-10-03 21:15:01", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9597", "0", "the", "2017-10-04 05:54:35", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9598", "0", "read", "2017-10-04 11:05:17", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9599", "0", "money", "2017-10-04 12:38:14", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9600", "0", "3342", "2017-10-04 14:02:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9601", "0", "receipt", "2017-10-04 22:31:29", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9602", "1", "admin8576", "2017-10-04 23:35:54", "221.2.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9603", "1", "admin8576", "2017-10-04 23:36:07", "5.178.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9604", "1", "admin8576", "2017-10-04 23:41:57", "103.28.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9605", "1", "admin8576", "2017-10-05 06:30:06", "189.114.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9606", "0", "admin", "2017-10-05 11:22:20", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9607", "0", "admin", "2017-10-05 16:45:08", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9608", "0", "elemental", "2017-10-06 02:55:37", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9609", "0", "admin", "2017-10-06 03:16:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9610", "0", "admin", "2017-10-06 08:06:25", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9611", "0", "admin", "2017-10-06 15:26:52", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9612", "0", "forward", "2017-10-06 15:55:35", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9613", "0", "admin", "2017-10-06 17:32:59", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9614", "0", "admin", "2017-10-06 17:41:34", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9615", "0", "malconess", "2017-10-06 17:51:32", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9616", "0", "portfolio", "2017-10-06 20:31:40", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9617", "0", "admin", "2017-10-06 23:11:06", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9618", "0", "admin", "2017-10-07 00:35:18", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9619", "0", "admin", "2017-10-07 01:07:42", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9620", "0", "its", "2017-10-07 05:47:06", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9621", "0", "admin", "2017-10-07 06:38:49", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9622", "0", "admin", "2017-10-07 07:20:38", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9623", "0", "admin", "2017-10-07 08:03:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9624", "0", "reports", "2017-10-07 11:01:32", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9625", "0", "way", "2017-10-07 11:06:23", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9626", "0", "sandown", "2017-10-07 11:22:41", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9627", "0", "admin", "2017-10-07 11:50:10", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9628", "0", "town", "2017-10-07 12:34:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9629", "1", "admin8576", "2017-10-07 15:08:08", "84.232.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9630", "1", "admin8576", "2017-10-07 15:08:23", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9631", "1", "admin8576", "2017-10-07 15:53:34", "77.95.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9632", "1", "admin8576", "2017-10-07 16:03:03", "122.224.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9633", "0", "admin", "2017-10-07 17:57:16", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9634", "0", "house", "2017-10-09 17:57:36", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9635", "0", "london", "2017-10-09 23:05:03", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9636", "0", "admin", "2017-10-10 02:19:44", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9637", "0", "mining", "2017-10-10 02:38:15", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9638", "0", "admin", "2017-10-10 14:24:36", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9639", "0", "0759", "2017-10-10 20:27:06", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9640", "0", "admin", "2017-10-10 20:44:38", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9641", "1", "admin8576", "2017-10-10 23:19:48", "84.232.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9642", "1", "admin8576", "2017-10-10 23:39:29", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9643", "1", "admin8576", "2017-10-10 23:40:57", "187.188.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9644", "1", "admin8576", "2017-10-10 23:43:38", "120.194.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9645", "0", "spend", "2017-10-11 10:37:24", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9646", "0", "admin", "2017-10-11 14:09:40", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9647", "0", "they", "2017-10-11 15:36:30", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9648", "0", "admin", "2017-10-11 17:30:53", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9649", "0", "environment", "2017-10-12 01:35:30", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9650", "0", "box", "2017-10-12 05:13:22", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9651", "0", "admin", "2017-10-12 08:52:27", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9652", "0", "gmainc", "2017-10-13 12:04:23", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9653", "0", "georges", "2017-10-13 12:09:58", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9654", "0", "admin", "2017-10-13 12:48:17", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9655", "1", "admin8576", "2017-10-13 20:28:52", "180.250.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9656", "1", "admin8576", "2017-10-13 20:29:32", "202.79.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9657", "0", "admin", "2017-10-13 22:08:41", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9658", "0", "grove", "2017-10-14 00:54:05", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9659", "0", "admin", "2017-10-14 07:35:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9660", "0", "hub", "2017-10-14 16:37:42", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9661", "0", "memberships", "2017-10-14 17:07:55", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9662", "0", "admin", "2017-10-14 18:58:03", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9663", "0", "admin", "2017-10-14 23:07:14", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9664", "0", "admin", "2017-10-15 07:47:16", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9665", "0", "admin", "2017-10-15 13:57:51", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9666", "0", "admin", "2017-10-15 14:11:03", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9667", "0", "admin", "2017-10-15 17:56:31", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9668", "1", "admin8576", "2017-10-15 21:29:37", "103.212.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9669", "1", "admin8576", "2017-10-15 21:29:40", "103.212.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9670", "1", "admin8576", "2017-10-15 21:29:43", "103.212.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9671", "0", "8000", "2017-10-16 10:10:49", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9672", "0", "crust", "2017-10-16 16:34:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9673", "1", "admin8576", "2017-10-16 16:47:04", "31.146.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9674", "1", "admin8576", "2017-10-16 16:51:07", "206.214.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9675", "1", "admin8576", "2017-10-16 16:53:37", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9676", "0", "money", "2017-10-16 18:14:44", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9677", "1", "admin8576", "2017-10-16 18:25:23", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9678", "1", "admin8576", "2017-10-16 19:06:03", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9679", "1", "admin8576", "2017-10-16 19:36:32", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9680", "1", "admin8576", "2017-10-16 20:07:26", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9681", "1", "admin8576", "2017-10-16 20:37:52", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9682", "1", "admin8576", "2017-10-16 21:08:44", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9683", "1", "admin8576", "2017-10-16 21:39:28", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9684", "0", "admin", "2017-10-16 22:00:30", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9685", "1", "admin8576", "2017-10-16 22:11:05", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9686", "1", "admin8576", "2017-10-16 22:42:29", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9687", "1", "admin8576", "2017-10-16 23:14:12", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9688", "0", "admin", "2017-10-16 23:25:08", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9689", "1", "admin8576", "2017-10-16 23:45:05", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9690", "1", "admin8576", "2017-10-17 00:16:18", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9691", "1", "admin8576", "2017-10-17 00:47:25", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9692", "1", "admin8576", "2017-10-17 01:20:52", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9693", "1", "admin8576", "2017-10-17 01:59:28", "34.228.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9694", "0", "fees", "2017-10-17 07:27:31", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9695", "0", "pave", "2017-10-17 08:32:35", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9696", "0", "admin", "2017-10-17 09:40:41", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9697", "0", "admin", "2017-10-17 13:24:17", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9698", "1", "admin8576", "2017-10-17 16:09:07", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9699", "1", "admin8576", "2017-10-17 17:17:33", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9700", "1", "admin8576", "2017-10-18 02:38:02", "180.183.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9701", "1", "admin8576", "2017-10-18 13:06:15", "202.182.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9702", "0", "admin", "2017-10-18 18:04:11", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9703", "0", "admin", "2017-10-18 21:10:09", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9704", "1", "admin8576", "2017-10-18 23:05:14", "193.254.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9705", "0", "admin", "2017-10-19 01:33:14", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9706", "0", "hand", "2017-10-19 03:46:04", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9707", "0", "been", "2017-10-19 06:05:58", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9708", "0", "admin", "2017-10-19 08:16:20", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9709", "1", "admin8576", "2017-10-19 09:07:02", "110.39.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9710", "0", "admin", "2017-10-19 10:22:51", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9711", "1", "admin8576", "2017-10-19 13:06:47", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9712", "1", "admin8576", "2017-10-19 13:07:08", "220.164.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9713", "1", "admin8576", "2017-10-19 14:29:06", "95.104.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9714", "0", "admin", "2017-10-19 18:06:12", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9715", "1", "admin8576", "2017-10-19 18:28:33", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9716", "1", "admin8576", "2017-10-19 19:11:53", "45.123.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9717", "1", "admin8576", "2017-10-19 20:50:17", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9718", "1", "admin8576", "2017-10-19 21:21:56", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9719", "1", "admin8576", "2017-10-19 21:53:58", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9720", "1", "admin8576", "2017-10-19 22:26:04", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9721", "1", "admin8576", "2017-10-19 22:57:43", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9722", "0", "-", "2017-10-19 23:17:58", "128.199.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9723", "1", "admin8576", "2017-10-19 23:29:44", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9724", "1", "admin8576", "2017-10-20 00:01:55", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9725", "1", "admin8576", "2017-10-20 00:34:18", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9726", "1", "admin8576", "2017-10-20 01:06:41", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9727", "1", "admin8576", "2017-10-20 01:39:11", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9728", "1", "admin8576", "2017-10-20 02:11:53", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9729", "1", "admin8576", "2017-10-20 02:44:34", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9730", "1", "admin8576", "2017-10-20 03:17:21", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9731", "1", "admin8576", "2017-10-20 03:50:42", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9732", "1", "admin8576", "2017-10-20 04:24:14", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9733", "1", "admin8576", "2017-10-20 04:57:21", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9734", "1", "admin8576", "2017-10-20 05:29:58", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9735", "1", "admin8576", "2017-10-20 06:02:40", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9736", "1", "admin8576", "2017-10-20 06:35:33", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9737", "1", "admin8576", "2017-10-20 07:08:31", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9738", "1", "admin8576", "2017-10-20 07:41:33", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9739", "1", "admin8576", "2017-10-20 08:14:45", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9740", "1", "admin8576", "2017-10-20 08:47:31", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9741", "0", "-", "2017-10-20 10:09:11", "166.63.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9742", "1", "admin8576", "2017-10-20 10:13:06", "34.215.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9743", "0", "durban", "2017-10-20 10:26:03", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9744", "0", "talented", "2017-10-20 10:52:21", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9745", "0", "admin", "2017-10-20 17:27:10", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9746", "1", "admin8576", "2017-10-20 21:54:46", "192.151.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9747", "1", "admin8576", "2017-10-20 21:54:47", "192.151.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9748", "1", "admin8576", "2017-10-20 21:54:48", "192.151.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9749", "0", "admin", "2017-10-20 22:51:15", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9750", "0", "clients", "2017-10-21 21:22:33", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9751", "0", "admin", "2017-10-21 21:26:32", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9752", "0", "admin", "2017-10-21 22:18:42", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9753", "0", "admin", "2017-10-22 00:27:30", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9754", "1", "admin8576", "2017-10-22 05:46:28", "58.215.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9755", "1", "admin8576", "2017-10-22 05:50:22", "95.104.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9756", "1", "admin8576", "2017-10-23 03:05:44", "180.183.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9757", "0", "admin", "2017-10-23 10:46:43", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9758", "1", "admin8576", "2017-10-23 13:29:30", "181.198.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9759", "0", "african", "2017-10-23 18:49:35", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9760", "0", "conveyancers", "2017-10-23 19:20:42", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9761", "0", "admin", "2017-10-23 20:01:20", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9762", "1", "admin8576", "2017-10-23 23:41:28", "115.186.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9763", "0", "admin", "2017-10-24 09:22:40", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9764", "1", "admin8576", "2017-10-24 09:57:38", "110.39.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9765", "0", "from", "2017-10-24 19:47:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9766", "0", "forming", "2017-10-24 19:51:29", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9767", "1", "admin8576", "2017-10-24 20:22:30", "179.184.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9768", "0", "meets", "2017-10-24 21:48:12", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9769", "1", "admin8576", "2017-10-25 02:40:16", "222.176.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9770", "1", "admin8576", "2017-10-25 06:23:25", "181.198.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9771", "0", "gmainc", "2017-10-25 11:52:04", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9772", "0", "contact", "2017-10-25 15:22:21", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9773", "0", "provinces", "2017-10-25 16:14:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9774", "1", "admin8576", "2017-10-25 17:16:18", "125.209.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9775", "0", "letters", "2017-10-25 20:04:09", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9776", "0", "html", "2017-10-26 02:43:41", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9777", "1", "admin8576", "2017-10-26 02:50:03", "177.11.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9778", "0", "magmai", "2017-10-26 08:50:14", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9779", "1", "admin8576", "2017-10-26 11:58:30", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9780", "1", "admin8576", "2017-10-26 19:56:01", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9781", "1", "admin8576", "2017-10-26 19:56:21", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9782", "1", "admin8576", "2017-10-26 19:56:45", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9783", "0", "correspondence", "2017-10-26 22:45:12", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9784", "1", "admin8576", "2017-10-27 06:26:32", "36.67.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9785", "0", "create", "2017-10-27 06:55:40", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9786", "0", "building", "2017-10-27 13:48:57", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9787", "1", "admin8576", "2017-10-27 14:53:19", "82.194.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9788", "1", "admin8576", "2017-10-27 15:12:46", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9789", "1", "admin8576", "2017-10-27 15:39:38", "181.198.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9790", "1", "admin8576", "2017-10-27 15:57:31", "122.227.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9791", "0", "admin", "2017-10-27 19:47:20", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9792", "0", "admin", "2017-10-28 01:57:12", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9793", "1", "admin8576", "2017-10-28 09:13:36", "203.76.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9794", "1", "admin8576", "2017-10-28 18:14:26", "43.231.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9795", "0", "mergers", "2017-10-28 21:37:23", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9796", "0", "agmainc", "2017-10-29 03:48:23", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9797", "0", "admin", "2017-10-29 10:59:21", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9798", "1", "admin8576", "2017-10-29 12:10:42", "45.115.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9799", "0", "admin", "2017-10-29 14:20:37", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9800", "0", "admin", "2017-10-29 15:32:05", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9801", "0", "books", "2017-10-29 16:08:45", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9802", "0", "459", "2017-10-29 17:14:07", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9803", "0", "floor", "2017-10-29 18:18:08", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9804", "0", "legal", "2017-10-30 00:02:24", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9805", "1", "admin8576", "2017-10-30 05:23:21", "186.101.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9806", "0", "whole", "2017-10-30 09:17:16", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9807", "1", "admin8576", "2017-10-30 14:14:28", "181.198.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9808", "0", "formidable", "2017-10-30 21:48:33", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9809", "0", "admin", "2017-10-31 00:25:12", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9810", "0", "more", "2017-10-31 07:44:05", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9811", "1", "admin8576", "2017-10-31 07:54:01", "36.66.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9812", "0", "value", "2017-10-31 14:12:48", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9813", "0", "government", "2017-10-31 16:36:09", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9814", "1", "admin8576", "2017-10-31 16:56:54", "190.63.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9815", "1", "admin8576", "2017-10-31 17:12:01", "220.164.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9816", "1", "admin8576", "2017-10-31 22:16:27", "77.69.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9817", "0", "can", "2017-11-01 01:49:10", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9818", "0", "admin", "2017-11-01 02:10:23", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9819", "0", "although", "2017-11-01 06:35:32", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9820", "1", "admin8576", "2017-11-01 10:52:06", "36.67.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9821", "0", "2196", "2017-11-01 14:31:14", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9822", "0", "can", "2017-11-01 16:12:57", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9823", "1", "admin8576", "2017-11-01 19:56:55", "124.109.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9824", "0", "agma", "2017-11-01 22:15:17", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9825", "0", "admin", "2017-11-02 01:35:24", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9826", "0", "admin", "2017-11-02 01:38:04", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9827", "0", "three", "2017-11-02 02:26:42", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9828", "0", "admin", "2017-11-02 03:54:52", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9829", "1", "admin8576", "2017-11-02 04:39:47", "181.198.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9830", "1", "admin8576", "2017-11-02 22:18:55", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9831", "1", "admin8576", "2017-11-03 02:47:15", "201.47.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9832", "0", "admin", "2017-11-03 07:16:33", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9833", "1", "admin8576", "2017-11-03 07:30:41", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9834", "0", "ensure", "2017-11-03 08:24:22", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9835", "0", "2000", "2017-11-03 11:31:49", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9836", "0", "admin", "2017-11-03 11:38:53", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9837", "0", "east", "2017-11-03 11:52:08", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9838", "0", "some", "2017-11-03 16:05:35", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9839", "0", "admin", "2017-11-03 17:02:09", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9840", "1", "admin8576", "2017-11-03 17:12:48", "180.250.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9841", "0", "expectations", "2017-11-03 22:39:58", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9842", "1", "admin8576", "2017-11-04 02:39:04", "173.208.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9843", "1", "admin8576", "2017-11-04 02:39:05", "173.208.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9844", "1", "admin8576", "2017-11-04 02:39:06", "173.208.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9845", "1", "admin8576", "2017-11-04 02:50:35", "115.186.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9846", "0", "manner", "2017-11-04 06:19:24", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9847", "0", "admin", "2017-11-04 06:48:56", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9848", "0", "success", "2017-11-04 11:41:45", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9849", "1", "admin8576", "2017-11-04 12:00:42", "186.101.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9850", "0", "admin", "2017-11-04 14:59:44", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9851", "0", "admin", "2017-11-04 19:32:43", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9852", "1", "admin8576", "2017-11-04 21:13:24", "103.58.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9853", "0", "admin", "2017-11-05 04:27:18", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9854", "1", "admin8576", "2017-11-05 06:37:11", "103.192.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9855", "0", "combination", "2017-11-05 06:54:33", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9856", "1", "admin8576", "2017-11-05 15:53:51", "80.11.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9857", "0", "admin", "2017-11-05 16:40:53", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9858", "0", "road", "2017-11-06 00:23:42", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9859", "1", "admin8576", "2017-11-06 01:05:32", "36.67.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9860", "0", "407", "2017-11-06 05:51:29", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9861", "0", "admin", "2017-11-06 09:29:55", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9862", "0", "rich", "2017-11-06 09:46:49", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9863", "1", "admin8576", "2017-11-06 11:29:24", "107.150.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9864", "1", "admin8576", "2017-11-06 11:29:25", "107.150.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9865", "1", "admin8576", "2017-11-06 11:29:26", "107.150.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9866", "0", "park", "2017-11-06 11:33:26", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9867", "1", "admin8576", "2017-11-06 19:51:35", "181.198.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9868", "0", "admin", "2017-11-06 22:15:51", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9869", "0", "heart", "2017-11-07 09:17:05", "185.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9870", "1", "admin8576", "2017-11-07 10:18:15", "36.66.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9871", "0", "diversified", "2017-11-07 13:24:31", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9872", "0", "admin", "2017-11-07 14:07:56", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9873", "1", "admin8576", "2017-11-07 14:19:47", "183.88.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9874", "0", "gately", "2017-11-07 17:59:04", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9875", "1", "admin8576", "2017-11-07 18:39:36", "180.250.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9876", "1", "admin8576", "2017-11-07 18:43:20", "134.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9877", "1", "admin8576", "2017-11-07 18:45:53", "186.96.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9878", "0", "town", "2017-11-07 19:24:45", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9879", "1", "admin8576", "2017-11-07 19:25:17", "91.187.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9880", "1", "admin8576", "2017-11-07 21:57:18", "107.150.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9881", "1", "admin8576", "2017-11-07 21:57:19", "107.150.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9882", "1", "admin8576", "2017-11-07 21:57:20", "107.150.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9883", "1", "admin8576", "2017-11-07 23:25:46", "181.198.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9884", "0", "founder", "2017-11-08 16:51:16", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9885", "1", "admin8576", "2017-11-08 20:30:30", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9886", "1", "admin8576", "2017-11-08 20:30:33", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9887", "1", "admin8576", "2017-11-08 20:30:37", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9888", "0", "admin", "2017-11-09 03:20:09", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9889", "0", "admin", "2017-11-09 03:36:23", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9890", "0", "admin", "2017-11-09 15:15:23", "185.85.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9891", "0", "sign", "2017-11-09 16:01:36", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9892", "0", "contracts", "2017-11-10 03:42:28", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9893", "0", "street", "2017-11-10 04:09:03", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9894", "1", "admin8576", "2017-11-10 06:40:10", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9895", "1", "admin8576", "2017-11-10 07:00:51", "45.64.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9896", "1", "admin8576", "2017-11-10 07:21:14", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9897", "1", "admin8576", "2017-11-10 07:41:25", "124.109.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9898", "1", "admin8576", "2017-11-10 08:01:45", "178.253.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9899", "1", "admin8576", "2017-11-10 08:22:16", "45.64.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9900", "1", "admin8576", "2017-11-10 08:42:59", "103.51.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9901", "1", "admin8576", "2017-11-10 09:03:45", "177.182.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9902", "1", "admin8576", "2017-11-10 09:24:12", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9903", "1", "admin8576", "2017-11-10 10:03:12", "137.59.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9904", "1", "admin8576", "2017-11-10 10:22:37", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9905", "1", "admin8576", "2017-11-10 10:41:39", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9906", "1", "admin8576", "2017-11-10 11:01:30", "110.39.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9907", "1", "admin8576", "2017-11-10 11:37:23", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9908", "1", "admin8576", "2017-11-10 11:56:03", "202.166.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9909", "1", "admin8576", "2017-11-10 12:15:10", "45.64.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9910", "1", "admin8576", "2017-11-10 12:51:58", "43.231.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9911", "1", "admin8576", "2017-11-10 13:10:34", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9912", "1", "admin8576", "2017-11-10 13:28:55", "82.209.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9913", "1", "admin8576", "2017-11-10 13:47:19", "45.123.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9914", "1", "admin8576", "2017-11-10 14:05:29", "189.203.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9915", "1", "admin8576", "2017-11-10 14:23:46", "183.88.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9916", "0", "6th", "2017-11-10 14:32:57", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9917", "1", "admin8576", "2017-11-10 14:42:16", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9918", "1", "admin8576", "2017-11-10 14:43:58", "188.129.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9919", "1", "admin8576", "2017-11-10 14:47:45", "109.107.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9920", "1", "admin8576", "2017-11-10 15:01:03", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9921", "1", "admin8576", "2017-11-10 15:20:05", "43.231.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9922", "1", "admin8576", "2017-11-10 15:38:57", "187.190.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9923", "1", "admin8576", "2017-11-10 15:57:45", "45.123.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9924", "1", "admin8576", "2017-11-10 16:00:07", "221.193.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9925", "1", "admin8576", "2017-11-10 16:16:32", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9926", "1", "admin8576", "2017-11-10 16:54:38", "43.231.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9927", "1", "admin8576", "2017-11-10 17:13:49", "45.123.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9928", "1", "admin8576", "2017-11-10 17:32:45", "45.123.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9929", "1", "admin8576", "2017-11-10 17:51:11", "43.231.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9930", "1", "admin8576", "2017-11-10 18:27:43", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9931", "1", "admin8576", "2017-11-10 18:46:12", "43.231.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9932", "1", "admin8576", "2017-11-10 19:21:07", "178.253.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9933", "1", "admin8576", "2017-11-10 19:38:02", "45.123.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9934", "1", "admin8576", "2017-11-10 19:55:03", "43.231.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9935", "1", "admin8576", "2017-11-10 20:11:37", "43.231.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9936", "1", "admin8576", "2017-11-10 20:44:57", "189.204.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9937", "1", "admin8576", "2017-11-10 21:18:16", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9938", "1", "admin8576", "2017-11-10 21:34:57", "45.64.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9939", "1", "admin8576", "2017-11-10 21:51:19", "124.29.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9940", "1", "admin8576", "2017-11-10 22:07:21", "177.23.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9941", "1", "admin8576", "2017-11-10 22:23:38", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9942", "1", "admin8576", "2017-11-10 22:39:24", "177.159.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9943", "1", "admin8576", "2017-11-10 22:55:27", "45.123.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9944", "1", "admin8576", "2017-11-10 23:11:34", "93.186.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9945", "0", "admin", "2017-11-10 23:30:33", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9946", "1", "admin8576", "2017-11-11 00:14:32", "112.91.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9947", "1", "admin8576", "2017-11-11 00:16:31", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9948", "1", "admin8576", "2017-11-11 00:33:18", "185.49.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9949", "1", "admin8576", "2017-11-11 00:46:20", "183.88.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9950", "1", "admin8576", "2017-11-11 01:02:28", "178.253.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9951", "1", "admin8576", "2017-11-11 01:34:34", "110.39.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9952", "1", "admin8576", "2017-11-11 01:50:17", "45.123.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9953", "1", "admin8576", "2017-11-11 02:05:54", "89.121.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9954", "1", "admin8576", "2017-11-11 02:21:50", "45.64.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9955", "1", "admin8576", "2017-11-11 02:38:19", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9956", "1", "admin8576", "2017-11-11 02:54:35", "115.186.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9957", "1", "admin8576", "2017-11-11 03:11:02", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9958", "1", "admin8576", "2017-11-11 03:27:37", "45.64.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9959", "1", "admin8576", "2017-11-11 03:43:59", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9960", "1", "admin8576", "2017-11-11 04:01:43", "89.148.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9961", "1", "admin8576", "2017-11-11 04:19:31", "202.165.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9962", "1", "admin8576", "2017-11-11 04:37:09", "186.182.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9963", "1", "admin8576", "2017-11-11 05:12:39", "43.231.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9964", "1", "admin8576", "2017-11-11 05:30:06", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9965", "1", "admin8576", "2017-11-11 05:47:22", "187.190.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9966", "1", "admin8576", "2017-11-11 06:04:52", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9967", "1", "admin8576", "2017-11-11 06:39:31", "45.123.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9968", "1", "admin8576", "2017-11-11 06:56:57", "187.188.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9969", "1", "admin8576", "2017-11-11 07:13:20", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9970", "1", "admin8576", "2017-11-11 07:28:53", "168.90.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9971", "1", "admin8576", "2017-11-11 08:16:11", "45.123.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9972", "1", "admin8576", "2017-11-11 08:31:39", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9973", "1", "admin8576", "2017-11-11 09:04:01", "109.99.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9974", "1", "admin8576", "2017-11-11 09:20:27", "45.64.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9975", "1", "admin8576", "2017-11-11 09:36:50", "89.96.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9976", "1", "admin8576", "2017-11-11 09:52:57", "45.123.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9977", "1", "admin8576", "2017-11-11 10:09:20", "193.254.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9978", "1", "admin8576", "2017-11-11 10:25:37", "178.253.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9979", "1", "admin8576", "2017-11-11 10:42:06", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9980", "1", "admin8576", "2017-11-11 11:14:48", "186.215.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9981", "1", "admin8576", "2017-11-11 11:46:50", "58.65.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9982", "1", "admin8576", "2017-11-11 12:03:32", "43.231.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9983", "1", "admin8576", "2017-11-11 12:36:14", "187.189.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9984", "1", "admin8576", "2017-11-11 13:08:25", "43.231.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9985", "1", "admin8576", "2017-11-11 13:24:47", "202.79.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9986", "1", "admin8576", "2017-11-11 13:40:56", "196.202.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9987", "1", "admin8576", "2017-11-11 14:12:54", "45.123.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9988", "1", "admin8576", "2017-11-11 14:28:52", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9989", "1", "admin8576", "2017-11-11 14:44:57", "115.186.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9990", "1", "admin8576", "2017-11-11 15:00:48", "180.183.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9991", "1", "admin8576", "2017-11-11 15:00:54", "180.183.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9992", "1", "admin8576", "2017-11-11 15:17:43", "180.183.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9993", "1", "admin8576", "2017-11-11 15:51:15", "58.65.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9994", "1", "admin8576", "2017-11-11 16:08:16", "187.190.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9995", "1", "admin8576", "2017-11-11 16:25:04", "103.1.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9996", "1", "admin8576", "2017-11-11 16:41:46", "45.123.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9997", "1", "admin8576", "2017-11-11 16:58:25", "43.231.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9998", "1", "admin8576", "2017-11-11 17:14:48", "62.210.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("9999", "1", "admin8576", "2017-11-11 17:32:00", "88.187.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10000", "1", "admin8576", "2017-11-11 18:06:16", "180.183.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10001", "1", "admin8576", "2017-11-11 18:22:18", "187.188.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10002", "1", "admin8576", "2017-11-11 18:39:03", "197.50.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10003", "1", "admin8576", "2017-11-11 18:55:36", "45.123.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10004", "1", "admin8576", "2017-11-11 19:12:17", "190.210.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10005", "1", "admin8576", "2017-11-11 19:28:49", "203.82.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10006", "1", "admin8576", "2017-11-11 19:45:21", "125.209.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10007", "1", "admin8576", "2017-11-11 20:01:54", "124.109.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10008", "1", "admin8576", "2017-11-11 20:18:05", "43.231.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10009", "1", "admin8576", "2017-11-11 20:50:23", "178.253.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10010", "1", "admin8576", "2017-11-11 21:06:45", "187.189.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10011", "1", "admin8576", "2017-11-12 03:33:06", "107.150.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10012", "1", "admin8576", "2017-11-12 03:33:07", "107.150.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10013", "1", "admin8576", "2017-11-12 03:33:08", "107.150.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10014", "0", "admin", "2017-11-12 12:55:40", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10015", "0", "statutes", "2017-11-12 13:41:48", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10016", "0", "admin", "2017-11-13 00:08:54", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10017", "0", "admin", "2017-11-13 08:35:00", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10018", "1", "admin8576", "2017-11-13 22:03:18", "142.54.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10019", "1", "admin8576", "2017-11-13 22:03:19", "142.54.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10020", "1", "admin8576", "2017-11-13 22:03:20", "142.54.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10021", "0", "narrowing", "2017-11-14 04:57:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10022", "1", "admin8576", "2017-11-14 06:48:04", "77.39.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10023", "1", "admin8576", "2017-11-14 06:48:10", "27.189.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10024", "0", "admin", "2017-11-14 14:16:03", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10025", "0", "save", "2017-11-14 23:34:11", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10026", "0", "admin", "2017-11-15 13:28:11", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10027", "0", "three", "2017-11-15 18:44:09", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10028", "0", "admin", "2017-11-16 00:32:52", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10029", "0", "admin", "2017-11-16 01:37:44", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10030", "0", "admin", "2017-11-16 04:57:23", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10031", "0", "forms", "2017-11-16 04:58:07", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10032", "0", "save", "2017-11-16 07:42:49", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10033", "0", "email", "2017-11-16 11:02:52", "185.85.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10034", "0", "select", "2017-11-16 11:28:21", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10035", "0", "situated", "2017-11-16 12:36:15", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10036", "0", "are", "2017-11-16 17:11:34", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10037", "0", "admin", "2017-11-16 22:50:29", "185.86.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10038", "1", "admin8576", "2017-11-16 23:53:26", "220.164.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10039", "0", "6th", "2017-11-17 00:38:01", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10040", "0", "traces", "2017-11-17 03:07:53", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10041", "1", "admin8576", "2017-11-17 05:39:52", "91.122.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10042", "1", "admin8576", "2017-11-17 05:39:53", "36.67.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10043", "1", "admin8576", "2017-11-17 06:00:42", "41.38.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10044", "1", "admin8576", "2017-11-17 07:02:40", "221.193.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10045", "0", "admin", "2017-11-17 08:51:21", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10046", "0", "8000", "2017-11-17 11:30:24", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10047", "0", "admin", "2017-11-17 11:31:18", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10048", "2", "admin5748", "2017-11-17 22:58:13", "200.160.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10049", "2", "admin5748", "2017-11-17 22:58:15", "200.160.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10050", "2", "admin5748", "2017-11-17 22:58:17", "200.160.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10051", "0", "masemola", "2017-11-18 06:06:05", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10052", "0", "admin", "2017-11-18 06:45:32", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10053", "0", "fredman", "2017-11-18 07:06:39", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10054", "0", "ourselves", "2017-11-18 08:04:34", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10055", "0", "admin", "2017-11-18 10:35:41", "185.86.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10056", "0", "but", "2017-11-18 10:55:55", "185.119.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10057", "0", "are", "2017-11-18 14:43:38", "185.85.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10058", "0", "admin", "2017-11-19 12:10:21", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10059", "1", "admin8576", "2017-11-19 12:12:37", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10060", "1", "admin8576", "2017-11-19 12:12:48", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10061", "1", "admin8576", "2017-11-19 12:12:52", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10062", "0", "admin", "2017-11-19 19:12:16", "185.86.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10063", "1", "admin8576", "2017-11-20 08:00:41", "186.215.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10064", "1", "admin8576", "2017-11-20 08:02:44", "36.66.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("10065", "1", "admin8576", "2017-11-20 08:09:34", "58.57.21.*");

/* INSERT TABLE DATA: eadsk_aiowps_login_activity */
INSERT INTO `eadsk_aiowps_login_activity` VALUES("1", "1", "aDmin8576", "2015-08-03 06:03:55", "0000-00-00 00:00:00", "196.210.61.204", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("2", "1", "aDmin8576", "2015-08-03 08:57:47", "0000-00-00 00:00:00", "196.210.61.204", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("3", "1", "aDmin8576", "2015-08-11 14:57:06", "2015-08-11 15:04:15", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("4", "1", "aDmin8576", "2015-08-11 14:59:57", "2015-08-11 15:04:15", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("5", "1", "aDmin8576", "2015-08-11 15:16:59", "0000-00-00 00:00:00", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("6", "1", "aDmin8576", "2015-08-21 15:08:21", "2015-08-21 16:43:54", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("7", "1", "aDmin8576", "2015-08-21 16:42:19", "2015-08-21 16:43:54", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("8", "1", "aDmin8576", "2015-08-21 16:57:24", "0000-00-00 00:00:00", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("9", "1", "aDmin8576", "2015-08-25 15:33:53", "2015-08-26 10:13:38", "196.210.16.42", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("10", "1", "aDmin8576", "2015-08-26 10:11:05", "2015-08-26 10:13:38", "196.210.16.42", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("11", "1", "aDmin8576", "2015-08-28 13:25:13", "0000-00-00 00:00:00", "196.210.16.42", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("12", "1", "aDmin8576", "2015-09-17 11:14:22", "0000-00-00 00:00:00", "196.210.61.194", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("13", "1", "aDmin8576", "2015-09-19 11:17:27", "0000-00-00 00:00:00", "41.13.12.197", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("14", "1", "aDmin8576", "2015-10-01 21:40:37", "0000-00-00 00:00:00", "196.210.61.159", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("15", "1", "aDmin8576", "2015-10-16 11:38:17", "0000-00-00 00:00:00", "196.210.45.106", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("16", "1", "aDmin8576", "2015-10-21 11:40:56", "0000-00-00 00:00:00", "196.210.45.245", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("17", "1", "aDmin8576", "2015-10-27 16:49:52", "0000-00-00 00:00:00", "196.215.84.33", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("18", "1", "aDmin8576", "2015-11-03 13:49:38", "2015-11-03 14:37:19", "196.215.0.112", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("19", "1", "aDmin8576", "2015-11-09 17:15:30", "2015-11-12 13:10:00", "196.215.0.112", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("20", "1", "aDmin8576", "2015-11-12 12:57:18", "2015-11-12 13:10:00", "196.215.0.112", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("21", "2", "aDmin5748", "2015-11-12 13:10:24", "2015-11-12 15:18:55", "196.215.0.112", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("22", "2", "aDmin5748", "2015-11-13 14:17:03", "2015-11-13 15:36:13", "196.210.173.234", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("23", "2", "aDmin5748", "2015-12-15 20:26:51", "0000-00-00 00:00:00", "41.13.220.23", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("24", "2", "aDmin5748", "2015-12-15 21:46:06", "2015-12-15 21:47:14", "41.13.224.178", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("25", "2", "aDmin5748", "2015-12-17 14:58:05", "0000-00-00 00:00:00", "41.13.192.171", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("26", "2", "aDmin5748", "2016-02-01 11:17:03", "0000-00-00 00:00:00", "196.210.45.124", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("27", "2", "aDmin5748", "2016-02-12 22:10:14", "0000-00-00 00:00:00", "196.215.84.55", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("28", "2", "aDmin5748", "2016-02-16 11:37:01", "0000-00-00 00:00:00", "196.215.84.106", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("29", "2", "aDmin5748", "2016-02-24 08:19:46", "0000-00-00 00:00:00", "196.210.62.32", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("30", "2", "aDmin5748", "2016-03-04 10:54:28", "0000-00-00 00:00:00", "196.210.61.137", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("31", "2", "aDmin5748", "2016-03-21 07:22:23", "0000-00-00 00:00:00", "197.228.248.59", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("32", "2", "aDmin5748", "2016-04-21 04:01:37", "0000-00-00 00:00:00", "196.215.34.63", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("33", "2", "aDmin5748", "2016-04-21 17:23:32", "0000-00-00 00:00:00", "196.215.34.63", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("34", "2", "aDmin5748", "2016-05-12 08:20:51", "0000-00-00 00:00:00", "196.210.229.220", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("35", "2", "aDmin5748", "2016-06-02 11:13:23", "0000-00-00 00:00:00", "196.215.98.97", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("36", "2", "aDmin5748", "2016-06-14 11:11:39", "0000-00-00 00:00:00", "196.215.98.117", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("37", "2", "aDmin5748", "2016-06-29 15:12:43", "0000-00-00 00:00:00", "196.215.84.21", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("38", "2", "aDmin5748", "2016-06-30 13:23:06", "0000-00-00 00:00:00", "196.215.84.21", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("39", "2", "aDmin5748", "2016-07-05 00:18:26", "0000-00-00 00:00:00", "196.210.173.248", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("40", "2", "aDmin5748", "2016-07-19 15:40:53", "0000-00-00 00:00:00", "196.215.53.7", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("41", "2", "aDmin5748", "2016-08-30 15:24:39", "0000-00-00 00:00:00", "196.210.61.171", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("42", "2", "aDmin5748", "2016-09-01 09:14:57", "2016-09-01 09:29:48", "196.210.45.38", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("43", "2", "aDmin5748", "2016-09-07 13:47:47", "0000-00-00 00:00:00", "196.215.100.118", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("44", "2", "aDmin5748", "2016-11-10 12:04:40", "0000-00-00 00:00:00", "41.13.8.14", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("45", "2", "aDmin5748", "2017-02-02 10:02:28", "0000-00-00 00:00:00", "196.215.53.27", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("46", "2", "aDmin5748", "2017-02-20 21:08:24", "0000-00-00 00:00:00", "196.210.45.251", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("47", "2", "aDmin5748", "2017-05-16 11:46:03", "0000-00-00 00:00:00", "196.210.173.148", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("48", "2", "aDmin5748", "2017-05-25 20:15:48", "0000-00-00 00:00:00", "196.215.53.20", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("49", "2", "aDmin5748", "2017-06-28 18:33:14", "0000-00-00 00:00:00", "196.210.210.69", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("50", "2", "aDmin5748", "2017-08-03 11:03:00", "0000-00-00 00:00:00", "165.165.86.16", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("51", "2", "aDmin5748", "2017-08-03 12:12:10", "0000-00-00 00:00:00", "165.165.86.16", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("52", "3", "Editorial5", "2017-08-03 12:19:52", "2017-08-03 12:20:02", "102.249.49.6", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("53", "2", "aDmin5748", "2017-10-25 21:47:12", "0000-00-00 00:00:00", "41.150.71.105", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("54", "2", "aDmin5748", "2017-11-01 14:08:01", "0000-00-00 00:00:00", "154.69.29.167", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("55", "2", "aDmin5748", "2017-11-20 11:18:23", "0000-00-00 00:00:00", "41.151.31.184", "", "");

/* INSERT TABLE DATA: eadsk_aiowps_login_lockdown */
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1", "0", "magma", "2015-08-21 17:19:16", "2015-08-21 18:19:16", "201.22.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2", "0", "magma", "2015-08-21 17:55:24", "2015-08-21 18:55:24", "2.51.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("3", "0", "magma", "2015-08-21 18:52:25", "2015-08-21 19:52:25", "39.44.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("4", "0", "magma", "2015-08-21 19:16:14", "2015-08-21 20:16:14", "94.121.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("5", "0", "magma", "2015-08-21 19:38:04", "2015-08-21 20:38:04", "201.248.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("6", "0", "magma", "2015-08-22 00:05:46", "2015-08-22 01:05:46", "85.74.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("7", "0", "magma", "2015-08-22 01:28:54", "2015-08-22 02:28:54", "37.0.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("8", "0", "magma", "2015-08-22 01:47:23", "2015-08-22 02:47:23", "175.113.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("9", "0", "magma", "2015-08-22 03:13:05", "2015-08-22 04:13:05", "112.203.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("10", "0", "magma", "2015-08-22 06:04:07", "2015-08-22 07:04:07", "86.125.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("11", "0", "magma", "2015-08-22 07:55:37", "2015-08-22 08:55:37", "37.114.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("12", "0", "magma", "2015-08-22 09:02:46", "2015-08-22 10:02:46", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("13", "0", "magma", "2015-08-22 09:43:11", "2015-08-22 10:43:11", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("14", "0", "magma", "2015-08-22 10:28:36", "2015-08-22 11:28:36", "109.224.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("15", "0", "magma", "2015-08-22 10:50:39", "2015-08-22 11:50:39", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("16", "0", "magma", "2015-08-22 12:08:23", "2015-08-22 13:08:23", "82.78.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("17", "0", "magma", "2015-08-22 13:31:13", "2015-08-22 14:31:13", "39.42.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("18", "0", "magma", "2015-08-22 13:35:00", "2015-08-22 14:35:00", "39.44.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("19", "0", "magma", "2015-08-22 14:23:21", "2015-08-22 15:23:21", "139.195.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("20", "0", "magma", "2015-08-22 15:20:07", "2015-08-22 16:20:07", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("21", "0", "magma", "2015-08-22 16:37:14", "2015-08-22 17:37:14", "103.249.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("22", "0", "magma", "2015-08-22 17:24:11", "2015-08-22 18:24:11", "41.133.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("23", "0", "magma", "2015-08-22 18:41:19", "2015-08-22 19:41:19", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("24", "0", "magma", "2015-08-22 19:28:01", "2015-08-22 20:28:01", "109.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("25", "0", "magma", "2015-08-22 19:33:33", "2015-08-22 20:33:33", "79.180.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("26", "0", "magma", "2015-08-22 19:46:16", "2015-08-22 20:46:16", "190.167.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("27", "0", "magma", "2015-08-22 22:12:01", "2015-08-22 23:12:01", "95.187.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("28", "0", "magma", "2015-08-23 00:17:03", "2015-08-23 01:17:03", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("29", "0", "magma", "2015-08-23 02:41:05", "2015-08-23 03:41:05", "109.245.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("30", "0", "magma", "2015-08-23 03:46:03", "2015-08-23 04:46:03", "183.91.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("31", "0", "magma", "2015-08-23 03:51:16", "2015-08-23 04:51:16", "87.16.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("32", "0", "magma", "2015-08-23 04:16:52", "2015-08-23 05:16:52", "178.221.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("33", "0", "magma", "2015-08-23 05:12:02", "2015-08-23 06:12:02", "109.245.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("34", "0", "magma", "2015-08-23 05:21:10", "2015-08-23 06:21:10", "1.1.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("35", "0", "magma", "2015-08-23 05:36:32", "2015-08-23 06:36:32", "179.105.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("36", "0", "magma", "2015-08-23 07:12:14", "2015-08-23 08:12:14", "188.26.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("37", "0", "magma", "2015-08-23 16:53:44", "2015-08-23 17:53:44", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("38", "0", "magma", "2015-08-23 17:00:17", "2015-08-23 18:00:17", "110.139.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("39", "0", "magma", "2015-08-23 17:20:42", "2015-08-23 18:20:42", "103.224.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("40", "0", "magma", "2015-08-23 17:44:56", "2015-08-23 18:44:56", "186.123.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("41", "0", "magma", "2015-08-23 18:17:09", "2015-08-23 19:17:09", "178.221.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("42", "0", "magma", "2015-08-23 19:59:00", "2015-08-23 20:59:00", "88.245.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("43", "0", "magma", "2015-08-23 21:44:23", "2015-08-23 22:44:23", "93.87.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("44", "0", "magma", "2015-08-24 00:07:13", "2015-08-24 01:07:13", "177.229.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("45", "0", "magma", "2015-08-24 01:27:09", "2015-08-24 02:27:09", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("46", "0", "magma", "2015-08-24 03:51:51", "2015-08-24 04:51:51", "5.12.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("47", "0", "magma", "2015-08-24 03:52:20", "2015-08-24 04:52:20", "95.245.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("48", "0", "magma", "2015-08-24 07:12:50", "2015-08-24 08:12:50", "14.141.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("49", "0", "magma", "2015-08-24 07:38:53", "2015-08-24 08:38:53", "113.20.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("50", "0", "magma", "2015-08-24 08:20:58", "2015-08-24 09:20:58", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("51", "0", "magma", "2015-08-24 11:58:51", "2015-08-24 12:58:51", "87.10.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("52", "0", "magma", "2015-08-24 12:04:21", "2015-08-24 13:04:21", "151.247.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("53", "0", "magma", "2015-08-24 16:01:18", "2015-08-24 17:01:18", "182.185.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("54", "0", "magma", "2015-08-24 17:52:17", "2015-08-24 18:52:17", "64.237.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("55", "0", "magma", "2015-08-24 19:10:01", "2015-08-24 20:10:01", "210.195.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("56", "0", "magma", "2015-08-24 20:02:27", "2015-08-24 21:02:27", "79.101.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("57", "0", "magma", "2015-08-24 21:58:32", "2015-08-24 22:58:32", "130.204.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("58", "0", "magma", "2015-08-24 23:28:40", "2015-08-25 00:28:40", "46.40.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("59", "0", "magma", "2015-08-25 04:06:02", "2015-08-25 05:06:02", "179.24.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("60", "0", "magma", "2015-08-25 04:43:49", "2015-08-25 05:43:49", "69.47.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("61", "0", "magma", "2015-08-25 08:49:17", "2015-08-25 09:49:17", "86.125.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("62", "0", "magma", "2015-08-25 10:41:07", "2015-08-25 11:41:07", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("63", "0", "magma", "2015-08-25 12:45:40", "2015-08-25 13:45:40", "115.66.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("64", "0", "magma", "2015-08-25 17:36:32", "2015-08-25 18:36:32", "39.50.206.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("65", "0", "magma", "2015-08-25 19:00:08", "2015-08-25 20:00:08", "92.97.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("66", "0", "magma", "2015-08-25 19:35:45", "2015-08-25 20:35:45", "41.133.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("67", "0", "magma", "2015-08-25 20:58:01", "2015-08-25 21:58:01", "182.178.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("68", "0", "magma", "2015-08-25 23:12:53", "2015-08-26 00:12:53", "93.86.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("69", "0", "magma", "2015-08-26 02:23:39", "2015-08-26 03:23:39", "181.120.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("70", "0", "magma", "2015-08-26 03:45:34", "2015-08-26 04:45:34", "189.26.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("71", "0", "magma", "2015-08-26 05:19:48", "2015-08-26 06:19:48", "200.158.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("72", "0", "magma", "2015-08-26 05:46:01", "2015-08-26 06:46:01", "37.27.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("73", "0", "magma", "2015-08-26 11:46:49", "2015-08-26 12:46:49", "92.80.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("74", "0", "magma", "2015-08-26 13:25:13", "2015-08-26 14:25:13", "82.166.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("75", "0", "magma", "2015-08-26 13:59:35", "2015-08-26 14:59:35", "39.42.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("76", "0", "magma", "2015-08-26 14:00:36", "2015-08-26 15:00:36", "39.42.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("77", "0", "magma", "2015-08-26 15:32:42", "2015-08-26 16:32:42", "81.10.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("78", "0", "magma", "2015-08-26 15:38:31", "2015-08-26 16:38:31", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("79", "0", "magma", "2015-08-26 15:53:52", "2015-08-26 16:53:52", "60.51.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("80", "0", "magma", "2015-08-26 17:25:30", "2015-08-26 18:25:30", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("81", "0", "magma", "2015-08-26 18:39:57", "2015-08-26 19:39:57", "201.220.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("82", "0", "magma", "2015-08-26 18:56:34", "2015-08-26 19:56:34", "202.159.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("83", "0", "magma", "2015-08-26 19:02:58", "2015-08-26 20:02:58", "81.10.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("84", "0", "magma", "2015-08-26 20:37:29", "2015-08-26 21:37:29", "202.81.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("85", "0", "magma", "2015-08-26 20:50:16", "2015-08-26 21:50:16", "78.168.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("86", "0", "magma", "2015-08-26 21:17:12", "2015-08-26 22:17:12", "2.50.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("87", "0", "magma", "2015-08-26 21:35:06", "2015-08-26 22:35:06", "69.47.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("88", "0", "magma", "2015-08-27 00:30:09", "2015-08-27 01:30:09", "78.130.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("89", "0", "magma", "2015-08-27 04:11:07", "2015-08-27 05:11:07", "81.183.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("90", "0", "magma", "2015-08-27 04:21:24", "2015-08-27 05:21:24", "95.180.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("91", "1", "admin8576", "2015-08-27 04:58:18", "2015-08-27 05:58:18", "62.14.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("92", "0", "magma", "2015-08-27 07:57:21", "2015-08-27 08:57:21", "101.50.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("93", "0", "magma", "2015-08-27 10:25:29", "2015-08-27 11:25:29", "109.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("94", "0", "magma", "2015-08-27 10:39:49", "2015-08-27 11:39:49", "182.185.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("95", "0", "magma", "2015-08-27 12:08:53", "2015-08-27 13:08:53", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("96", "0", "magma", "2015-08-27 12:33:37", "2015-08-27 13:33:37", "115.133.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("97", "0", "magma", "2015-08-27 14:28:02", "2015-08-27 15:28:02", "42.113.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("98", "0", "magma", "2015-08-27 15:53:57", "2015-08-27 16:53:57", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("99", "0", "magma", "2015-08-27 17:06:34", "2015-08-27 18:06:34", "42.61.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("100", "0", "magma", "2015-08-27 20:24:15", "2015-08-27 21:24:15", "94.126.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("101", "0", "magma", "2015-08-27 21:54:14", "2015-08-27 22:54:14", "78.56.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("102", "0", "magma", "2015-08-28 00:06:22", "2015-08-28 01:06:22", "190.198.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("103", "0", "magma", "2015-08-28 00:11:34", "2015-08-28 01:11:34", "78.168.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("104", "0", "magma", "2015-08-28 01:11:50", "2015-08-28 02:11:50", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("105", "0", "magma", "2015-08-28 06:48:19", "2015-08-28 07:48:19", "79.134.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("106", "0", "magma", "2015-08-28 07:23:45", "2015-08-28 08:23:45", "190.198.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("107", "0", "magma", "2015-08-28 07:41:34", "2015-08-28 08:41:34", "94.189.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("108", "0", "magma", "2015-08-28 08:24:10", "2015-08-28 09:24:10", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("109", "0", "magma", "2015-08-28 10:06:02", "2015-08-28 11:06:02", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("110", "0", "magma", "2015-08-28 10:37:14", "2015-08-28 11:37:14", "178.126.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("111", "0", "magma", "2015-08-28 13:11:50", "2015-08-28 14:11:50", "89.41.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("112", "0", "magma", "2015-08-28 14:16:06", "2015-08-28 15:16:06", "197.88.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("113", "0", "magma", "2015-08-28 14:39:06", "2015-08-28 15:39:06", "139.193.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("114", "0", "magma", "2015-08-28 19:01:21", "2015-08-28 20:01:21", "84.228.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("115", "0", "magma", "2015-08-28 20:29:41", "2015-08-28 21:29:41", "86.126.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("116", "0", "magma", "2015-08-28 20:38:29", "2015-08-28 21:38:29", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("117", "0", "magma", "2015-08-29 09:36:50", "2015-08-29 10:36:50", "1.1.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("118", "0", "magma", "2015-08-29 10:57:00", "2015-08-29 11:57:00", "39.42.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("119", "0", "magma", "2015-08-29 11:11:58", "2015-08-29 12:11:58", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("120", "0", "magma", "2015-08-29 14:23:17", "2015-08-29 15:23:17", "217.119.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("121", "0", "magma", "2015-08-29 15:30:15", "2015-08-29 16:30:15", "87.120.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("122", "0", "magma", "2015-08-29 16:05:32", "2015-08-29 17:05:32", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("123", "0", "magma", "2015-08-29 16:34:53", "2015-08-29 17:34:53", "39.32.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("124", "0", "magma", "2015-08-29 20:52:51", "2015-08-29 21:52:51", "86.38.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("125", "0", "magma", "2015-08-30 02:52:50", "2015-08-30 03:52:50", "180.234.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("126", "0", "magma", "2015-08-30 04:32:09", "2015-08-30 05:32:09", "109.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("127", "0", "magma", "2015-08-30 05:38:59", "2015-08-30 06:38:59", "180.234.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("128", "0", "magma", "2015-08-30 05:52:23", "2015-08-30 06:52:23", "79.115.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("129", "0", "magma", "2015-08-30 06:44:05", "2015-08-30 07:44:05", "121.98.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("130", "0", "magma", "2015-08-30 11:57:13", "2015-08-30 12:57:13", "202.81.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("131", "0", "magma", "2015-08-30 17:37:04", "2015-08-30 18:37:04", "79.182.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("132", "0", "magma", "2015-08-30 17:57:09", "2015-08-30 18:57:09", "84.228.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("133", "0", "magma", "2015-08-30 18:41:14", "2015-08-30 19:41:14", "95.180.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("134", "0", "magma", "2015-08-30 20:04:46", "2015-08-30 21:04:46", "45.118.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("135", "0", "magma", "2015-08-30 20:14:40", "2015-08-30 21:14:40", "37.252.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("136", "0", "magma", "2015-08-30 20:16:11", "2015-08-30 21:16:11", "41.133.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("137", "0", "magma", "2015-08-30 20:43:59", "2015-08-30 21:43:59", "109.57.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("138", "0", "magma", "2015-08-30 20:49:30", "2015-08-30 21:49:30", "89.41.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("139", "0", "magma", "2015-08-30 20:51:51", "2015-08-30 21:51:51", "105.158.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("140", "0", "magma", "2015-08-30 22:05:17", "2015-08-30 23:05:17", "103.19.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("141", "0", "magma", "2015-08-31 02:29:25", "2015-08-31 03:29:25", "122.3.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("142", "0", "magma", "2015-08-31 08:32:10", "2015-08-31 09:32:10", "103.249.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("143", "0", "magma", "2015-08-31 10:40:05", "2015-08-31 11:40:05", "112.198.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("144", "0", "magma", "2015-08-31 11:15:23", "2015-08-31 12:15:23", "182.185.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("145", "0", "magma", "2015-08-31 11:26:07", "2015-08-31 12:26:07", "217.119.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("146", "0", "magma", "2015-08-31 11:32:39", "2015-08-31 12:32:39", "39.44.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("147", "0", "magma", "2015-08-31 12:15:35", "2015-08-31 13:15:35", "1.1.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("148", "0", "magma", "2015-08-31 17:58:56", "2015-08-31 18:58:56", "64.237.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("149", "0", "magma", "2015-08-31 22:14:41", "2015-08-31 23:14:41", "41.41.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("150", "0", "magma", "2015-08-31 23:35:13", "2015-09-01 00:35:13", "109.76.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("151", "0", "magma", "2015-09-01 01:52:21", "2015-09-01 02:52:21", "5.45.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("152", "0", "magma", "2015-09-01 02:00:29", "2015-09-01 03:00:29", "41.99.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("153", "0", "magma", "2015-09-01 02:38:09", "2015-09-01 03:38:09", "37.27.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("154", "0", "magma", "2015-09-01 04:54:09", "2015-09-01 05:54:09", "190.167.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("155", "0", "magma", "2015-09-01 05:26:30", "2015-09-01 06:26:30", "37.27.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("156", "0", "magma", "2015-09-01 08:04:03", "2015-09-01 09:04:03", "115.134.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("157", "0", "magma", "2015-09-01 08:26:01", "2015-09-01 09:26:01", "10.0.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("158", "0", "magma", "2015-09-01 09:24:03", "2015-09-01 10:24:03", "81.182.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("159", "0", "magma", "2015-09-01 09:47:12", "2015-09-01 10:47:12", "14.141.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("160", "0", "admin", "2015-09-01 13:02:49", "2015-09-01 14:02:49", "109.161.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("161", "0", "magma", "2015-09-01 13:47:45", "2015-09-01 14:47:45", "182.178.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("162", "0", "magma", "2015-09-01 15:47:30", "2015-09-01 16:47:30", "112.207.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("163", "0", "magma", "2015-09-01 18:19:59", "2015-09-01 19:19:59", "49.229.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("164", "0", "admin", "2015-09-01 20:02:14", "2015-09-01 21:02:14", "134.255.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("165", "0", "magma", "2015-09-01 23:28:17", "2015-09-02 00:28:17", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("166", "0", "magma", "2015-09-02 03:06:49", "2015-09-02 04:06:49", "188.159.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("167", "0", "magma", "2015-09-02 03:46:39", "2015-09-02 04:46:39", "81.183.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("168", "0", "magma", "2015-09-02 09:23:27", "2015-09-02 10:23:27", "200.90.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("169", "0", "magma", "2015-09-02 09:40:47", "2015-09-02 10:40:47", "175.136.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("170", "1", "admin8576", "2015-09-02 13:28:05", "2015-09-02 14:28:05", "52.27.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("171", "0", "magma", "2015-09-02 16:24:33", "2015-09-02 17:24:33", "180.191.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("172", "0", "magma", "2015-09-02 18:07:52", "2015-09-02 19:07:52", "5.0.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("173", "0", "magma", "2015-09-02 18:43:24", "2015-09-02 19:43:24", "78.130.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("174", "0", "magma", "2015-09-02 18:57:50", "2015-09-02 19:57:50", "2.50.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("175", "0", "magma", "2015-09-02 21:41:09", "2015-09-02 22:41:09", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("176", "0", "magma", "2015-09-03 00:34:59", "2015-09-03 01:34:59", "45.118.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("177", "0", "magma", "2015-09-03 05:40:18", "2015-09-03 06:40:18", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("178", "0", "admin", "2015-09-03 08:14:12", "2015-09-03 09:14:12", "185.24.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("179", "0", "admin", "2015-09-03 08:14:13", "2015-09-03 09:14:13", "207.201.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("180", "0", "admin", "2015-09-03 08:18:34", "2015-09-03 09:18:34", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("181", "0", "admin", "2015-09-03 09:26:10", "2015-09-03 10:26:10", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("182", "0", "magma", "2015-09-03 12:33:28", "2015-09-03 13:33:28", "188.79.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("183", "0", "admin", "2015-09-03 13:26:41", "2015-09-03 14:26:41", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("184", "0", "admin", "2015-09-03 13:26:41", "2015-09-03 14:26:41", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("185", "0", "admin", "2015-09-03 13:26:41", "2015-09-03 14:26:41", "5.189.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("186", "0", "admin", "2015-09-03 13:26:45", "2015-09-03 14:26:45", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("187", "0", "admin", "2015-09-03 13:26:47", "2015-09-03 14:26:47", "185.77.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("188", "0", "magma", "2015-09-03 15:16:43", "2015-09-03 16:16:43", "182.185.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("189", "0", "magma", "2015-09-03 17:59:44", "2015-09-03 18:59:44", "84.109.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("190", "0", "magma", "2015-09-03 19:26:46", "2015-09-03 20:26:46", "182.185.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("191", "0", "magma", "2015-09-03 20:37:53", "2015-09-03 21:37:53", "182.185.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("192", "1", "admin8576", "2015-09-03 20:46:35", "2015-09-03 21:46:35", "52.27.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("193", "0", "magma", "2015-09-03 23:11:25", "2015-09-04 00:11:25", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("194", "0", "admin", "2015-09-03 23:37:09", "2015-09-04 00:37:09", "128.68.255.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("195", "0", "admin", "2015-09-03 23:37:09", "2015-09-04 00:37:09", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("196", "0", "admin", "2015-09-03 23:37:11", "2015-09-04 00:37:11", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("197", "0", "admin", "2015-09-03 23:37:11", "2015-09-04 00:37:11", "195.228.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("198", "0", "admin", "2015-09-03 23:37:22", "2015-09-04 00:37:22", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("199", "0", "magma", "2015-09-04 01:28:00", "2015-09-04 02:28:00", "79.114.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("200", "0", "magma", "2015-09-04 02:33:38", "2015-09-04 03:33:38", "79.114.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("201", "0", "admin", "2015-09-04 08:25:25", "2015-09-04 09:25:25", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("202", "0", "admin", "2015-09-04 08:25:25", "2015-09-04 09:25:25", "5.135.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("203", "0", "admin", "2015-09-04 08:25:25", "2015-09-04 09:25:25", "96.44.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("204", "0", "admin", "2015-09-04 08:25:26", "2015-09-04 09:25:26", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("205", "0", "admin", "2015-09-04 08:25:26", "2015-09-04 09:25:26", "185.62.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("206", "0", "magma", "2015-09-04 12:09:03", "2015-09-04 13:09:03", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("207", "0", "magma", "2015-09-04 13:06:39", "2015-09-04 14:06:39", "31.46.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("208", "0", "magma", "2015-09-04 14:45:52", "2015-09-04 15:45:52", "31.46.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("209", "0", "magma", "2015-09-04 17:21:20", "2015-09-04 18:21:20", "178.164.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("210", "0", "magma", "2015-09-04 17:25:29", "2015-09-04 18:25:29", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("211", "0", "magma", "2015-09-04 17:37:13", "2015-09-04 18:37:13", "94.203.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("212", "0", "admin", "2015-09-04 17:54:48", "2015-09-04 18:54:48", "78.108.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("213", "0", "admin", "2015-09-04 17:54:49", "2015-09-04 18:54:49", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("214", "0", "admin", "2015-09-04 17:54:50", "2015-09-04 18:54:50", "178.16.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("215", "0", "admin", "2015-09-04 17:54:51", "2015-09-04 18:54:51", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("216", "0", "admin", "2015-09-04 17:54:52", "2015-09-04 18:54:52", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("217", "0", "admin", "2015-09-05 03:24:17", "2015-09-05 04:24:17", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("218", "0", "admin", "2015-09-05 03:24:18", "2015-09-05 04:24:18", "173.254.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("219", "0", "admin", "2015-09-05 03:24:18", "2015-09-05 04:24:18", "5.135.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("220", "0", "magma", "2015-09-05 04:07:15", "2015-09-05 05:07:15", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("221", "0", "magma", "2015-09-05 04:10:57", "2015-09-05 05:10:57", "190.46.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("222", "0", "magma", "2015-09-05 04:39:31", "2015-09-05 05:39:31", "151.25.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("223", "0", "magma", "2015-09-05 06:33:43", "2015-09-05 07:33:43", "103.58.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("224", "0", "magma", "2015-09-05 09:31:49", "2015-09-05 10:31:49", "103.19.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("225", "0", "magma", "2015-09-05 13:02:54", "2015-09-05 14:02:54", "5.154.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("226", "0", "magma", "2015-09-05 14:14:35", "2015-09-05 15:14:35", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("227", "0", "magma", "2015-09-05 15:09:11", "2015-09-05 16:09:11", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("228", "0", "magma", "2015-09-05 15:37:39", "2015-09-05 16:37:39", "37.27.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("229", "0", "magma", "2015-09-05 15:57:13", "2015-09-05 16:57:13", "115.76.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("230", "0", "magma", "2015-09-05 16:23:11", "2015-09-05 17:23:11", "116.88.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("231", "0", "magma", "2015-09-05 19:27:03", "2015-09-05 20:27:03", "94.177.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("232", "0", "magma", "2015-09-05 20:29:37", "2015-09-05 21:29:37", "103.224.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("233", "0", "magma", "2015-09-06 04:48:54", "2015-09-06 05:48:54", "178.238.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("234", "0", "magma", "2015-09-06 06:28:00", "2015-09-06 07:28:00", "2.50.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("235", "0", "magma", "2015-09-06 12:05:39", "2015-09-06 13:05:39", "112.209.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("236", "0", "magma", "2015-09-06 12:33:20", "2015-09-06 13:33:20", "94.227.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("237", "0", "magma", "2015-09-06 13:12:30", "2015-09-06 14:12:30", "182.185.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("238", "0", "magma", "2015-09-06 14:43:01", "2015-09-06 15:43:01", "89.39.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("239", "0", "magma", "2015-09-06 14:53:41", "2015-09-06 15:53:41", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("240", "0", "magma", "2015-09-06 16:39:03", "2015-09-06 17:39:03", "210.195.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("241", "0", "magma", "2015-09-06 18:20:33", "2015-09-06 19:20:33", "79.185.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("242", "0", "magma", "2015-09-06 19:23:07", "2015-09-06 20:23:07", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("243", "0", "magma", "2015-09-06 22:34:39", "2015-09-06 23:34:39", "190.204.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("244", "0", "magma", "2015-09-07 03:26:49", "2015-09-07 04:26:49", "187.194.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("245", "0", "magma", "2015-09-07 04:50:46", "2015-09-07 05:50:46", "78.92.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("246", "0", "magma", "2015-09-07 12:39:33", "2015-09-07 13:39:33", "1.1.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("247", "0", "magma", "2015-09-07 14:46:44", "2015-09-07 15:46:44", "212.90.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("248", "0", "magma", "2015-09-07 14:50:41", "2015-09-07 15:50:41", "208.168.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("249", "0", "magma", "2015-09-07 14:53:53", "2015-09-07 15:53:53", "180.191.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("250", "0", "magma", "2015-09-07 14:58:43", "2015-09-07 15:58:43", "41.69.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("251", "0", "magma", "2015-09-07 15:09:02", "2015-09-07 16:09:02", "217.75.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("252", "0", "magma", "2015-09-07 15:18:37", "2015-09-07 16:18:37", "109.229.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("253", "0", "magma", "2015-09-07 15:38:06", "2015-09-07 16:38:06", "79.47.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("254", "0", "magma", "2015-09-07 15:38:59", "2015-09-07 16:38:59", "59.93.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("255", "0", "magma", "2015-09-07 15:43:01", "2015-09-07 16:43:01", "86.14.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("256", "0", "magma", "2015-09-07 15:43:13", "2015-09-07 16:43:13", "81.217.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("257", "0", "magma", "2015-09-07 15:47:22", "2015-09-07 16:47:22", "203.210.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("258", "0", "magma", "2015-09-07 15:49:06", "2015-09-07 16:49:06", "200.120.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("259", "0", "magma", "2015-09-07 15:55:07", "2015-09-07 16:55:07", "194.143.147.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("260", "0", "magma", "2015-09-07 16:05:49", "2015-09-07 17:05:49", "145.132.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("261", "0", "magma", "2015-09-07 16:07:18", "2015-09-07 17:07:18", "212.109.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("262", "0", "magma", "2015-09-07 16:07:49", "2015-09-07 17:07:49", "220.240.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("263", "0", "magma", "2015-09-07 16:12:25", "2015-09-07 17:12:25", "112.208.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("264", "0", "magma", "2015-09-07 16:31:00", "2015-09-07 17:31:00", "41.76.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("265", "0", "magma", "2015-09-07 16:31:49", "2015-09-07 17:31:49", "5.102.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("266", "0", "magma", "2015-09-07 16:32:21", "2015-09-07 17:32:21", "42.119.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("267", "0", "magma", "2015-09-07 16:41:11", "2015-09-07 17:41:11", "78.186.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("268", "0", "magma", "2015-09-07 16:43:34", "2015-09-07 17:43:34", "31.154.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("269", "0", "magma", "2015-09-07 16:45:05", "2015-09-07 17:45:05", "81.89.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("270", "0", "magma", "2015-09-07 16:50:14", "2015-09-07 17:50:14", "86.14.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("271", "0", "magma", "2015-09-07 16:52:35", "2015-09-07 17:52:35", "85.138.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("272", "0", "magma", "2015-09-07 16:53:32", "2015-09-07 17:53:32", "81.149.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("273", "0", "magma", "2015-09-07 17:01:06", "2015-09-07 18:01:06", "89.153.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("274", "0", "magma", "2015-09-07 17:10:12", "2015-09-07 18:10:12", "81.82.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("275", "0", "magma", "2015-09-07 17:14:13", "2015-09-07 18:14:13", "83.58.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("276", "0", "magma", "2015-09-07 17:17:06", "2015-09-07 18:17:06", "163.152.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("277", "0", "magma", "2015-09-07 17:28:21", "2015-09-07 18:28:21", "76.76.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("278", "0", "magma", "2015-09-07 17:37:34", "2015-09-07 18:37:34", "118.136.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("279", "0", "magma", "2015-09-07 17:38:17", "2015-09-07 18:38:17", "160.80.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("280", "0", "magma", "2015-09-07 17:42:43", "2015-09-07 18:42:43", "62.195.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("281", "0", "magma", "2015-09-07 17:45:01", "2015-09-07 18:45:01", "2.39.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("282", "0", "magma", "2015-09-07 17:48:53", "2015-09-07 18:48:53", "1.32.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("283", "0", "magma", "2015-09-07 17:50:24", "2015-09-07 18:50:24", "5.44.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("284", "0", "magma", "2015-09-07 17:54:13", "2015-09-07 18:54:13", "210.223.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("285", "0", "magma", "2015-09-07 17:57:27", "2015-09-07 18:57:27", "79.170.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("286", "0", "magma", "2015-09-07 18:00:24", "2015-09-07 19:00:24", "180.191.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("287", "0", "magma", "2015-09-07 18:05:59", "2015-09-07 19:05:59", "122.167.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("288", "0", "magma", "2015-09-07 18:14:36", "2015-09-07 19:14:36", "90.190.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("289", "0", "magma", "2015-09-07 18:18:13", "2015-09-07 19:18:13", "2.51.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("290", "0", "magma", "2015-09-07 18:18:18", "2015-09-07 19:18:18", "175.156.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("291", "0", "magma", "2015-09-07 18:22:37", "2015-09-07 19:22:37", "93.86.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("292", "0", "magma", "2015-09-07 18:27:26", "2015-09-07 19:27:26", "83.172.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("293", "0", "magma", "2015-09-07 18:28:33", "2015-09-07 19:28:33", "83.240.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("294", "0", "magma", "2015-09-07 18:28:53", "2015-09-07 19:28:53", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("295", "0", "magma", "2015-09-07 18:30:55", "2015-09-07 19:30:55", "88.192.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("296", "0", "magma", "2015-09-07 18:37:43", "2015-09-07 19:37:43", "94.228.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("297", "0", "magma", "2015-09-07 18:40:56", "2015-09-07 19:40:56", "122.57.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("298", "0", "magma", "2015-09-07 18:41:14", "2015-09-07 19:41:14", "41.215.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("299", "0", "magma", "2015-09-07 19:02:31", "2015-09-07 20:02:31", "122.177.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("300", "0", "magma", "2015-09-07 19:06:19", "2015-09-07 20:06:19", "211.223.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("301", "0", "magma", "2015-09-07 19:11:41", "2015-09-07 20:11:41", "46.121.245.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("302", "0", "magma", "2015-09-07 19:13:58", "2015-09-07 20:13:58", "183.87.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("303", "0", "magma", "2015-09-07 19:14:13", "2015-09-07 20:14:13", "109.229.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("304", "0", "magma", "2015-09-07 19:15:28", "2015-09-07 20:15:28", "109.197.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("305", "0", "magma", "2015-09-07 19:16:58", "2015-09-07 20:16:58", "181.171.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("306", "0", "magma", "2015-09-07 19:21:28", "2015-09-07 20:21:28", "109.219.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("307", "0", "magma", "2015-09-07 19:28:10", "2015-09-07 20:28:10", "47.17.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("308", "0", "magma", "2015-09-07 19:29:50", "2015-09-07 20:29:50", "79.16.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("309", "0", "magma", "2015-09-07 19:32:44", "2015-09-07 20:32:44", "220.253.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("310", "0", "magma", "2015-09-07 19:32:53", "2015-09-07 20:32:53", "37.229.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("311", "0", "magma", "2015-09-07 19:32:55", "2015-09-07 20:32:55", "121.54.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("312", "0", "magma", "2015-09-07 19:35:41", "2015-09-07 20:35:41", "24.209.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("313", "0", "magma", "2015-09-07 19:37:15", "2015-09-07 20:37:15", "61.6.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("314", "0", "magma", "2015-09-07 19:38:54", "2015-09-07 20:38:54", "151.29.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("315", "0", "magma", "2015-09-07 19:41:20", "2015-09-07 20:41:20", "109.66.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("316", "0", "magma", "2015-09-07 19:49:03", "2015-09-07 20:49:03", "79.116.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("317", "0", "magma", "2015-09-07 19:49:24", "2015-09-07 20:49:24", "98.165.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("318", "0", "magma", "2015-09-07 19:51:48", "2015-09-07 20:51:48", "89.152.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("319", "0", "magma", "2015-09-07 19:55:54", "2015-09-07 20:55:54", "188.141.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("320", "0", "magma", "2015-09-07 20:01:29", "2015-09-07 21:01:29", "37.105.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("321", "0", "magma", "2015-09-07 20:04:25", "2015-09-07 21:04:25", "177.154.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("322", "0", "magma", "2015-09-07 20:05:24", "2015-09-07 21:05:24", "203.186.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("323", "0", "magma", "2015-09-07 20:05:55", "2015-09-07 21:05:55", "68.107.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("324", "0", "magma", "2015-09-07 20:09:24", "2015-09-07 21:09:24", "39.53.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("325", "0", "magma", "2015-09-07 20:10:09", "2015-09-07 21:10:09", "124.30.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("326", "0", "magma", "2015-09-07 20:12:18", "2015-09-07 21:12:18", "14.192.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("327", "0", "magma", "2015-09-07 20:12:24", "2015-09-07 21:12:24", "81.89.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("328", "0", "magma", "2015-09-07 20:19:35", "2015-09-07 21:19:35", "109.101.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("329", "0", "magma", "2015-09-07 20:24:48", "2015-09-07 21:24:48", "77.173.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("330", "0", "magma", "2015-09-07 20:29:32", "2015-09-07 21:29:32", "200.1.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("331", "0", "magma", "2015-09-07 20:30:54", "2015-09-07 21:30:54", "67.176.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("332", "0", "magma", "2015-09-07 20:32:24", "2015-09-07 21:32:24", "210.195.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("333", "0", "magma", "2015-09-07 20:34:30", "2015-09-07 21:34:30", "24.139.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("334", "0", "magma", "2015-09-07 20:44:47", "2015-09-07 21:44:47", "93.47.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("335", "0", "magma", "2015-09-07 20:51:54", "2015-09-07 21:51:54", "94.175.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("336", "0", "magma", "2015-09-07 20:52:39", "2015-09-07 21:52:39", "186.193.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("337", "0", "magma", "2015-09-07 20:54:34", "2015-09-07 21:54:34", "176.45.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("338", "0", "magma", "2015-09-07 20:55:51", "2015-09-07 21:55:51", "222.155.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("339", "0", "magma", "2015-09-07 21:03:46", "2015-09-07 22:03:46", "103.51.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("340", "0", "magma", "2015-09-07 21:04:33", "2015-09-07 22:04:33", "41.224.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("341", "0", "magma", "2015-09-07 21:05:40", "2015-09-07 22:05:40", "217.136.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("342", "0", "magma", "2015-09-07 21:11:24", "2015-09-07 22:11:24", "95.14.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("343", "0", "magma", "2015-09-07 21:12:27", "2015-09-07 22:12:27", "176.41.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("344", "0", "magma", "2015-09-07 21:18:22", "2015-09-07 22:18:22", "85.70.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("345", "0", "magma", "2015-09-07 21:19:04", "2015-09-07 22:19:04", "76.240.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("346", "0", "magma", "2015-09-07 21:19:45", "2015-09-07 22:19:45", "85.202.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("347", "0", "magma", "2015-09-07 21:31:22", "2015-09-07 22:31:22", "78.0.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("348", "0", "magma", "2015-09-07 21:31:37", "2015-09-07 22:31:37", "46.99.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("349", "0", "magma", "2015-09-07 21:47:26", "2015-09-07 22:47:26", "158.181.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("350", "0", "magma", "2015-09-07 21:47:51", "2015-09-07 22:47:51", "189.32.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("351", "0", "magma", "2015-09-07 21:48:51", "2015-09-07 22:48:51", "80.56.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("352", "0", "magma", "2015-09-07 21:51:50", "2015-09-07 22:51:50", "197.89.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("353", "0", "magma", "2015-09-07 21:53:04", "2015-09-07 22:53:04", "84.236.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("354", "0", "magma", "2015-09-07 21:53:15", "2015-09-07 22:53:15", "2.4.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("355", "0", "magma", "2015-09-07 21:55:11", "2015-09-07 22:55:11", "200.73.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("356", "0", "magma", "2015-09-07 21:57:26", "2015-09-07 22:57:26", "188.82.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("357", "0", "magma", "2015-09-07 21:58:22", "2015-09-07 22:58:22", "95.76.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("358", "0", "magma", "2015-09-07 21:59:41", "2015-09-07 22:59:41", "87.14.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("359", "0", "magma", "2015-09-07 22:06:51", "2015-09-07 23:06:51", "31.15.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("360", "0", "magma", "2015-09-07 22:12:13", "2015-09-07 23:12:13", "31.41.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("361", "0", "magma", "2015-09-07 22:16:08", "2015-09-07 23:16:08", "190.31.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("362", "0", "magma", "2015-09-07 22:16:38", "2015-09-07 23:16:38", "149.88.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("363", "0", "magma", "2015-09-07 22:17:04", "2015-09-07 23:17:04", "176.179.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("364", "0", "magma", "2015-09-07 22:18:17", "2015-09-07 23:18:17", "94.236.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("365", "0", "magma", "2015-09-07 22:21:59", "2015-09-07 23:21:59", "217.39.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("366", "0", "magma", "2015-09-07 22:34:02", "2015-09-07 23:34:02", "79.112.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("367", "0", "magma", "2015-09-07 22:37:02", "2015-09-07 23:37:02", "37.159.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("368", "0", "magma", "2015-09-07 22:37:25", "2015-09-07 23:37:25", "5.189.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("369", "0", "magma", "2015-09-07 22:38:19", "2015-09-07 23:38:19", "5.197.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("370", "0", "magma", "2015-09-07 22:38:38", "2015-09-07 23:38:38", "149.88.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("371", "0", "magma", "2015-09-07 22:40:20", "2015-09-07 23:40:20", "181.48.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("372", "0", "magma", "2015-09-07 22:41:26", "2015-09-07 23:41:26", "79.31.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("373", "0", "admin", "2015-09-07 22:42:59", "2015-09-07 23:42:59", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("374", "0", "admin", "2015-09-07 22:42:59", "2015-09-07 23:42:59", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("375", "0", "admin", "2015-09-07 22:43:00", "2015-09-07 23:43:00", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("376", "0", "admin", "2015-09-07 22:43:00", "2015-09-07 23:43:00", "64.113.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("377", "0", "admin", "2015-09-07 22:43:00", "2015-09-07 23:43:00", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("378", "0", "magma", "2015-09-07 22:47:00", "2015-09-07 23:47:00", "77.78.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("379", "0", "magma", "2015-09-07 22:48:45", "2015-09-07 23:48:45", "94.19.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("380", "0", "magma", "2015-09-07 22:51:10", "2015-09-07 23:51:10", "186.78.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("381", "0", "magma", "2015-09-07 22:53:11", "2015-09-07 23:53:11", "24.209.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("382", "0", "magma", "2015-09-07 22:53:37", "2015-09-07 23:53:37", "89.70.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("383", "0", "magma", "2015-09-07 22:58:39", "2015-09-07 23:58:39", "71.71.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("384", "0", "magma", "2015-09-07 22:59:28", "2015-09-07 23:59:28", "202.128.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("385", "0", "magma", "2015-09-07 23:03:15", "2015-09-08 00:03:15", "79.130.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("386", "0", "magma", "2015-09-07 23:03:29", "2015-09-08 00:03:29", "66.188.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("387", "0", "magma", "2015-09-07 23:09:40", "2015-09-08 00:09:40", "5.12.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("388", "0", "magma", "2015-09-07 23:13:55", "2015-09-08 00:13:55", "188.37.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("389", "0", "magma", "2015-09-07 23:17:25", "2015-09-08 00:17:25", "59.115.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("390", "0", "magma", "2015-09-07 23:26:59", "2015-09-08 00:26:59", "79.117.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("391", "0", "magma", "2015-09-07 23:31:05", "2015-09-08 00:31:05", "112.186.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("392", "0", "magma", "2015-09-07 23:34:18", "2015-09-08 00:34:18", "83.61.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("393", "0", "magma", "2015-09-07 23:43:08", "2015-09-08 00:43:08", "197.89.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("394", "0", "magma", "2015-09-07 23:58:05", "2015-09-08 00:58:05", "109.101.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("395", "0", "magma", "2015-09-07 23:58:10", "2015-09-08 00:58:10", "68.107.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("396", "0", "magma", "2015-09-08 00:01:25", "2015-09-08 01:01:25", "78.60.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("397", "0", "magma", "2015-09-08 00:03:22", "2015-09-08 01:03:22", "177.137.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("398", "0", "magma", "2015-09-08 00:04:21", "2015-09-08 01:04:21", "178.79.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("399", "0", "magma", "2015-09-08 00:30:25", "2015-09-08 01:30:25", "181.188.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("400", "0", "magma", "2015-09-08 00:41:44", "2015-09-08 01:41:44", "128.6.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("401", "0", "magma", "2015-09-08 00:45:52", "2015-09-08 01:45:52", "89.116.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("402", "0", "magma", "2015-09-08 01:14:58", "2015-09-08 02:14:58", "76.28.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("403", "0", "magma", "2015-09-08 01:44:36", "2015-09-08 02:44:36", "178.220.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("404", "0", "magma", "2015-09-08 01:48:31", "2015-09-08 02:48:31", "109.76.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("405", "0", "magma", "2015-09-08 01:51:50", "2015-09-08 02:51:50", "87.255.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("406", "0", "magma", "2015-09-08 01:56:13", "2015-09-08 02:56:13", "86.88.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("407", "0", "magma", "2015-09-08 02:03:06", "2015-09-08 03:03:06", "88.188.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("408", "0", "magma", "2015-09-08 02:04:06", "2015-09-08 03:04:06", "192.168.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("409", "0", "magma", "2015-09-08 02:06:23", "2015-09-08 03:06:23", "31.192.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("410", "0", "magma", "2015-09-08 02:12:01", "2015-09-08 03:12:01", "189.87.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("411", "0", "magma", "2015-09-08 02:26:23", "2015-09-08 03:26:23", "95.180.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("412", "0", "magma", "2015-09-08 02:26:37", "2015-09-08 03:26:37", "89.115.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("413", "0", "magma", "2015-09-08 02:42:53", "2015-09-08 03:42:53", "89.154.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("414", "0", "magma", "2015-09-08 02:46:44", "2015-09-08 03:46:44", "174.61.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("415", "0", "magma", "2015-09-08 02:56:23", "2015-09-08 03:56:23", "79.118.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("416", "0", "magma", "2015-09-08 03:36:01", "2015-09-08 04:36:01", "107.146.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("417", "0", "magma", "2015-09-08 03:36:37", "2015-09-08 04:36:37", "46.13.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("418", "0", "magma", "2015-09-08 04:01:58", "2015-09-08 05:01:58", "77.235.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("419", "0", "magma", "2015-09-08 04:02:33", "2015-09-08 05:02:33", "105.228.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("420", "0", "magma", "2015-09-08 04:02:40", "2015-09-08 05:02:40", "85.113.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("421", "0", "magma", "2015-09-08 04:08:43", "2015-09-08 05:08:43", "85.254.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("422", "0", "magma", "2015-09-08 04:14:32", "2015-09-08 05:14:32", "210.7.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("423", "0", "magma", "2015-09-08 04:47:09", "2015-09-08 05:47:09", "124.107.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("424", "0", "magma", "2015-09-08 04:54:01", "2015-09-08 05:54:01", "113.161.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("425", "0", "magma", "2015-09-08 06:06:11", "2015-09-08 07:06:11", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("426", "0", "magma", "2015-09-08 06:08:43", "2015-09-08 07:08:43", "82.3.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("427", "0", "magma", "2015-09-08 06:24:21", "2015-09-08 07:24:21", "46.186.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("428", "0", "magma", "2015-09-08 06:28:33", "2015-09-08 07:28:33", "175.141.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("429", "0", "magma", "2015-09-08 06:45:07", "2015-09-08 07:45:07", "211.33.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("430", "0", "magma", "2015-09-08 07:00:19", "2015-09-08 08:00:19", "80.220.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("431", "0", "magma", "2015-09-08 07:10:06", "2015-09-08 08:10:06", "50.27.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("432", "0", "magma", "2015-09-08 07:10:20", "2015-09-08 08:10:20", "121.107.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("433", "0", "magma", "2015-09-08 07:13:44", "2015-09-08 08:13:44", "85.250.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("434", "0", "magma", "2015-09-08 07:34:17", "2015-09-08 08:34:17", "203.76.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("435", "0", "magma", "2015-09-08 07:38:01", "2015-09-08 08:38:01", "182.71.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("436", "0", "magma", "2015-09-08 07:42:16", "2015-09-08 08:42:16", "88.196.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("437", "0", "magma", "2015-09-08 07:57:31", "2015-09-08 08:57:31", "92.242.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("438", "0", "admin", "2015-09-08 08:05:43", "2015-09-08 09:05:43", "81.7.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("439", "0", "admin", "2015-09-08 08:05:43", "2015-09-08 09:05:43", "89.105.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("440", "0", "admin", "2015-09-08 08:05:43", "2015-09-08 09:05:43", "176.9.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("441", "0", "admin", "2015-09-08 08:05:44", "2015-09-08 09:05:44", "199.127.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("442", "0", "admin", "2015-09-08 08:05:53", "2015-09-08 09:05:53", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("443", "0", "magma", "2015-09-08 08:06:43", "2015-09-08 09:06:43", "85.254.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("444", "0", "magma", "2015-09-08 08:17:23", "2015-09-08 09:17:23", "112.211.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("445", "0", "magma", "2015-09-08 08:22:30", "2015-09-08 09:22:30", "80.77.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("446", "0", "magma", "2015-09-08 08:36:04", "2015-09-08 09:36:04", "120.63.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("447", "0", "magma", "2015-09-08 08:42:03", "2015-09-08 09:42:03", "79.42.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("448", "0", "magma", "2015-09-08 08:49:14", "2015-09-08 09:49:14", "124.107.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("449", "0", "magma", "2015-09-08 08:59:38", "2015-09-08 09:59:38", "191.185.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("450", "0", "magma", "2015-09-08 09:04:19", "2015-09-08 10:04:19", "89.41.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("451", "0", "magma", "2015-09-08 09:10:56", "2015-09-08 10:10:56", "85.113.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("452", "0", "magma", "2015-09-08 09:23:00", "2015-09-08 10:23:00", "103.10.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("453", "0", "magma", "2015-09-08 09:27:02", "2015-09-08 10:27:02", "111.240.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("454", "0", "magma", "2015-09-08 09:34:27", "2015-09-08 10:34:27", "177.134.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("455", "0", "magma", "2015-09-08 09:34:40", "2015-09-08 10:34:40", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("456", "0", "magma", "2015-09-08 09:36:24", "2015-09-08 10:36:24", "5.15.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("457", "0", "magma", "2015-09-08 09:38:51", "2015-09-08 10:38:51", "123.201.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("458", "0", "magma", "2015-09-08 09:43:59", "2015-09-08 10:43:59", "120.63.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("459", "0", "magma", "2015-09-08 09:45:17", "2015-09-08 10:45:17", "89.39.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("460", "0", "magma", "2015-09-08 09:52:57", "2015-09-08 10:52:57", "195.68.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("461", "0", "magma", "2015-09-08 09:56:35", "2015-09-08 10:56:35", "92.70.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("462", "0", "magma", "2015-09-08 09:58:01", "2015-09-08 10:58:01", "220.244.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("463", "0", "magma", "2015-09-08 10:23:09", "2015-09-08 11:23:09", "46.121.245.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("464", "0", "magma", "2015-09-08 10:36:11", "2015-09-08 11:36:11", "178.161.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("465", "0", "magma", "2015-09-08 10:38:22", "2015-09-08 11:38:22", "125.60.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("466", "0", "magma", "2015-09-08 10:47:01", "2015-09-08 11:47:01", "5.44.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("467", "0", "magma", "2015-09-08 11:09:28", "2015-09-08 12:09:28", "83.51.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("468", "0", "magma", "2015-09-08 11:15:11", "2015-09-08 12:15:11", "160.80.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("469", "0", "magma", "2015-09-08 11:15:21", "2015-09-08 12:15:21", "92.242.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("470", "0", "magma", "2015-09-08 11:24:16", "2015-09-08 12:24:16", "83.35.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("471", "0", "magma", "2015-09-08 11:30:26", "2015-09-08 12:30:26", "180.183.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("472", "0", "magma", "2015-09-08 11:36:45", "2015-09-08 12:36:45", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("473", "0", "magma", "2015-09-08 11:57:04", "2015-09-08 12:57:04", "89.155.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("474", "0", "magma", "2015-09-08 11:57:47", "2015-09-08 12:57:47", "83.132.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("475", "0", "magma", "2015-09-08 12:07:04", "2015-09-08 13:07:04", "95.180.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("476", "0", "magma", "2015-09-08 12:09:20", "2015-09-08 13:09:20", "175.136.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("477", "0", "magma", "2015-09-08 12:09:42", "2015-09-08 13:09:42", "182.237.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("478", "0", "magma", "2015-09-08 12:10:03", "2015-09-08 13:10:03", "94.178.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("479", "0", "magma", "2015-09-08 12:10:42", "2015-09-08 13:10:42", "1.126.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("480", "0", "magma", "2015-09-08 12:11:28", "2015-09-08 13:11:28", "217.75.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("481", "0", "magma", "2015-09-08 12:20:03", "2015-09-08 13:20:03", "79.114.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("482", "0", "magma", "2015-09-08 12:22:16", "2015-09-08 13:22:16", "60.241.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("483", "0", "magma", "2015-09-08 12:23:06", "2015-09-08 13:23:06", "31.154.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("484", "0", "magma", "2015-09-08 12:38:23", "2015-09-08 13:38:23", "89.66.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("485", "0", "magma", "2015-09-08 12:39:16", "2015-09-08 13:39:16", "85.204.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("486", "0", "magma", "2015-09-08 12:40:19", "2015-09-08 13:40:19", "14.201.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("487", "0", "magma", "2015-09-08 12:54:29", "2015-09-08 13:54:29", "31.154.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("488", "0", "magma", "2015-09-08 13:01:54", "2015-09-08 14:01:54", "105.186.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("489", "0", "magma", "2015-09-08 13:02:53", "2015-09-08 14:02:53", "212.107.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("490", "0", "magma", "2015-09-08 13:26:00", "2015-09-08 14:26:00", "173.172.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("491", "0", "magma", "2015-09-08 13:27:46", "2015-09-08 14:27:46", "175.141.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("492", "0", "magma", "2015-09-08 13:37:47", "2015-09-08 14:37:47", "188.225.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("493", "0", "magma", "2015-09-08 13:53:17", "2015-09-08 14:53:17", "86.35.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("494", "0", "magma", "2015-09-08 13:57:59", "2015-09-08 14:57:59", "62.197.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("495", "0", "magma", "2015-09-08 14:02:19", "2015-09-08 15:02:19", "197.210.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("496", "0", "magma", "2015-09-08 14:10:53", "2015-09-08 15:10:53", "95.86.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("497", "0", "magma", "2015-09-08 14:14:01", "2015-09-08 15:14:01", "85.99.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("498", "0", "magma", "2015-09-08 14:29:17", "2015-09-08 15:29:17", "202.128.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("499", "0", "magma", "2015-09-08 14:31:09", "2015-09-08 15:31:09", "73.18.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("500", "0", "magma", "2015-09-08 14:42:24", "2015-09-08 15:42:24", "88.243.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("501", "0", "magma", "2015-09-08 14:47:02", "2015-09-08 15:47:02", "37.210.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("502", "0", "magma", "2015-09-08 14:50:19", "2015-09-08 15:50:19", "212.79.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("503", "0", "magma", "2015-09-08 14:56:15", "2015-09-08 15:56:15", "194.1.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("504", "0", "magma", "2015-09-08 15:00:34", "2015-09-08 16:00:34", "24.184.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("505", "0", "magma", "2015-09-08 15:07:26", "2015-09-08 16:07:26", "125.179.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("506", "0", "magma", "2015-09-08 15:08:58", "2015-09-08 16:08:58", "83.9.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("507", "0", "magma", "2015-09-08 15:09:19", "2015-09-08 16:09:19", "78.157.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("508", "0", "magma", "2015-09-08 15:12:46", "2015-09-08 16:12:46", "186.121.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("509", "0", "magma", "2015-09-08 15:20:20", "2015-09-08 16:20:20", "41.201.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("510", "0", "magma", "2015-09-08 15:22:16", "2015-09-08 16:22:16", "85.138.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("511", "0", "magma", "2015-09-08 15:28:32", "2015-09-08 16:28:32", "84.1.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("512", "0", "magma", "2015-09-08 16:02:43", "2015-09-08 17:02:43", "93.103.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("513", "0", "magma", "2015-09-08 16:05:19", "2015-09-08 17:05:19", "5.44.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("514", "0", "magma", "2015-09-08 16:07:22", "2015-09-08 17:07:22", "60.53.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("515", "0", "magma", "2015-09-08 16:20:20", "2015-09-08 17:20:20", "150.129.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("516", "0", "magma", "2015-09-08 16:22:36", "2015-09-08 17:22:36", "84.228.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("517", "0", "magma", "2015-09-08 16:24:15", "2015-09-08 17:24:15", "180.190.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("518", "0", "magma", "2015-09-08 16:35:11", "2015-09-08 17:35:11", "143.176.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("519", "0", "magma", "2015-09-08 16:35:33", "2015-09-08 17:35:33", "181.188.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("520", "0", "magma", "2015-09-08 16:50:34", "2015-09-08 17:50:34", "79.183.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("521", "0", "magma", "2015-09-08 16:52:55", "2015-09-08 17:52:55", "188.24.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("522", "0", "magma", "2015-09-08 16:54:37", "2015-09-08 17:54:37", "178.255.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("523", "0", "magma", "2015-09-08 16:59:52", "2015-09-08 17:59:52", "201.210.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("524", "0", "magma", "2015-09-08 17:00:44", "2015-09-08 18:00:44", "78.23.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("525", "0", "magma", "2015-09-08 17:01:50", "2015-09-08 18:01:50", "193.92.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("526", "0", "magma", "2015-09-08 17:07:34", "2015-09-08 18:07:34", "217.84.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("527", "0", "magma", "2015-09-08 17:15:19", "2015-09-08 18:15:19", "31.41.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("528", "0", "magma", "2015-09-08 17:25:09", "2015-09-08 18:25:09", "68.58.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("529", "0", "magma", "2015-09-08 17:25:52", "2015-09-08 18:25:52", "79.134.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("530", "0", "magma", "2015-09-08 17:27:19", "2015-09-08 18:27:19", "72.252.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("531", "0", "magma", "2015-09-08 17:44:04", "2015-09-08 18:44:04", "178.220.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("532", "0", "admin", "2015-09-08 18:01:55", "2015-09-08 19:01:55", "89.73.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("533", "0", "admin", "2015-09-08 18:01:56", "2015-09-08 19:01:56", "193.37.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("534", "0", "admin", "2015-09-08 18:01:56", "2015-09-08 19:01:56", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("535", "0", "admin", "2015-09-08 18:01:56", "2015-09-08 19:01:56", "62.212.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("536", "0", "admin", "2015-09-08 18:01:57", "2015-09-08 19:01:57", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("537", "0", "magma", "2015-09-08 18:17:33", "2015-09-08 19:17:33", "86.86.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("538", "0", "magma", "2015-09-08 18:27:06", "2015-09-08 19:27:06", "189.87.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("539", "0", "magma", "2015-09-08 18:28:26", "2015-09-08 19:28:26", "116.14.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("540", "0", "magma", "2015-09-08 18:38:11", "2015-09-08 19:38:11", "43.254.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("541", "0", "magma", "2015-09-08 18:40:43", "2015-09-08 19:40:43", "91.206.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("542", "0", "magma", "2015-09-08 18:54:36", "2015-09-08 19:54:36", "84.85.161.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("543", "0", "magma", "2015-09-08 19:14:42", "2015-09-08 20:14:42", "109.101.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("544", "0", "magma", "2015-09-08 19:18:16", "2015-09-08 20:18:16", "87.95.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("545", "0", "magma", "2015-09-08 19:29:55", "2015-09-08 20:29:55", "46.121.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("546", "0", "magma", "2015-09-08 19:39:04", "2015-09-08 20:39:04", "81.219.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("547", "0", "magma", "2015-09-08 20:05:33", "2015-09-08 21:05:33", "78.82.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("548", "0", "magma", "2015-09-08 20:07:37", "2015-09-08 21:07:37", "181.198.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("549", "0", "magma", "2015-09-08 20:09:31", "2015-09-08 21:09:31", "41.202.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("550", "0", "magma", "2015-09-08 20:10:19", "2015-09-08 21:10:19", "83.183.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("551", "0", "magma", "2015-09-08 20:22:13", "2015-09-08 21:22:13", "81.108.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("552", "0", "magma", "2015-09-08 20:28:12", "2015-09-08 21:28:12", "174.64.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("553", "0", "magma", "2015-09-08 20:32:14", "2015-09-08 21:32:14", "80.192.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("554", "0", "magma", "2015-09-08 20:35:52", "2015-09-08 21:35:52", "95.76.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("555", "0", "magma", "2015-09-08 20:38:08", "2015-09-08 21:38:08", "85.24.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("556", "0", "magma", "2015-09-08 20:44:07", "2015-09-08 21:44:07", "83.117.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("557", "0", "magma", "2015-09-08 20:48:02", "2015-09-08 21:48:02", "92.126.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("558", "0", "magma", "2015-09-08 21:03:20", "2015-09-08 22:03:20", "49.158.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("559", "0", "magma", "2015-09-08 21:09:44", "2015-09-08 22:09:44", "89.169.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("560", "0", "magma", "2015-09-08 21:10:05", "2015-09-08 22:10:05", "2.49.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("561", "0", "magma", "2015-09-08 21:38:25", "2015-09-08 22:38:25", "46.13.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("562", "0", "magma", "2015-09-08 21:39:52", "2015-09-08 22:39:52", "66.183.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("563", "0", "magma", "2015-09-08 21:41:17", "2015-09-08 22:41:17", "86.121.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("564", "0", "magma", "2015-09-08 21:41:36", "2015-09-08 22:41:36", "190.98.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("565", "0", "magma", "2015-09-08 21:41:50", "2015-09-08 22:41:50", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("566", "0", "magma", "2015-09-08 21:42:20", "2015-09-08 22:42:20", "42.201.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("567", "0", "magma", "2015-09-08 22:01:11", "2015-09-08 23:01:11", "177.72.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("568", "0", "magma", "2015-09-08 22:01:42", "2015-09-08 23:01:42", "111.68.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("569", "0", "magma", "2015-09-08 22:12:55", "2015-09-08 23:12:55", "86.71.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("570", "0", "magma", "2015-09-08 22:21:08", "2015-09-08 23:21:08", "94.175.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("571", "0", "magma", "2015-09-08 22:32:40", "2015-09-08 23:32:40", "178.220.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("572", "0", "magma", "2015-09-08 22:38:33", "2015-09-08 23:38:33", "151.70.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("573", "0", "magma", "2015-09-08 23:00:39", "2015-09-09 00:00:39", "95.76.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("574", "0", "magma", "2015-09-08 23:35:23", "2015-09-09 00:35:23", "173.52.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("575", "0", "magma", "2015-09-08 23:40:04", "2015-09-09 00:40:04", "197.89.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("576", "0", "magma", "2015-09-08 23:49:52", "2015-09-09 00:49:52", "188.79.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("577", "0", "magma", "2015-09-09 00:19:43", "2015-09-09 01:19:43", "112.207.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("578", "0", "magma", "2015-09-09 00:38:06", "2015-09-09 01:38:06", "79.145.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("579", "0", "magma", "2015-09-09 00:47:37", "2015-09-09 01:47:37", "219.92.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("580", "0", "magma", "2015-09-09 01:35:29", "2015-09-09 02:35:29", "175.136.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("581", "0", "magma", "2015-09-09 02:42:55", "2015-09-09 03:42:55", "208.179.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("582", "0", "magma", "2015-09-09 03:34:28", "2015-09-09 04:34:28", "190.232.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("583", "0", "admin", "2015-09-09 03:55:44", "2015-09-09 04:55:44", "37.221.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("584", "0", "admin", "2015-09-09 03:55:44", "2015-09-09 04:55:44", "87.118.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("585", "0", "admin", "2015-09-09 03:55:44", "2015-09-09 04:55:44", "54.94.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("586", "0", "admin", "2015-09-09 03:55:45", "2015-09-09 04:55:45", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("587", "0", "admin", "2015-09-09 03:55:45", "2015-09-09 04:55:45", "5.45.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("588", "0", "magma", "2015-09-09 03:57:03", "2015-09-09 04:57:03", "174.1.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("589", "0", "magma", "2015-09-09 04:55:42", "2015-09-09 05:55:42", "2.51.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("590", "0", "magma", "2015-09-09 05:02:43", "2015-09-09 06:02:43", "87.1.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("591", "0", "magma", "2015-09-09 05:10:23", "2015-09-09 06:10:23", "212.233.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("592", "0", "magma", "2015-09-09 05:17:36", "2015-09-09 06:17:36", "211.72.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("593", "0", "magma", "2015-09-09 06:14:27", "2015-09-09 07:14:27", "190.147.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("594", "0", "magma", "2015-09-09 06:17:15", "2015-09-09 07:17:15", "76.72.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("595", "0", "magma", "2015-09-09 07:33:21", "2015-09-09 08:33:21", "78.92.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("596", "0", "magma", "2015-09-09 07:35:08", "2015-09-09 08:35:08", "31.41.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("597", "0", "magma", "2015-09-09 07:53:14", "2015-09-09 08:53:14", "79.118.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("598", "0", "magma", "2015-09-09 08:38:38", "2015-09-09 09:38:38", "86.47.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("599", "0", "magma", "2015-09-09 09:02:54", "2015-09-09 10:02:54", "103.229.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("600", "0", "magma", "2015-09-09 09:07:29", "2015-09-09 10:07:29", "109.64.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("601", "0", "magma", "2015-09-09 09:12:02", "2015-09-09 10:12:02", "108.38.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("602", "0", "magma", "2015-09-09 09:26:08", "2015-09-09 10:26:08", "183.87.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("603", "0", "magma", "2015-09-09 10:39:31", "2015-09-09 11:39:31", "112.168.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("604", "0", "magma", "2015-09-09 10:39:56", "2015-09-09 11:39:56", "188.64.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("605", "0", "magma", "2015-09-09 11:12:46", "2015-09-09 12:12:46", "179.178.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("606", "0", "magma", "2015-09-09 11:14:17", "2015-09-09 12:14:17", "77.127.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("607", "0", "magma", "2015-09-09 11:52:50", "2015-09-09 12:52:50", "112.209.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("608", "0", "magma", "2015-09-09 12:02:52", "2015-09-09 13:02:52", "31.192.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("609", "1", "admin8576", "2015-09-09 12:31:46", "2015-09-09 13:31:46", "89.233.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("610", "0", "magma", "2015-09-09 12:33:29", "2015-09-09 13:33:29", "188.135.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("611", "0", "magma", "2015-09-09 12:59:27", "2015-09-09 13:59:27", "79.101.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("612", "0", "magma", "2015-09-09 13:09:24", "2015-09-09 14:09:24", "210.242.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("613", "0", "magma", "2015-09-09 13:35:28", "2015-09-09 14:35:28", "79.130.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("614", "0", "admin", "2015-09-09 13:43:51", "2015-09-09 14:43:51", "185.104.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("615", "0", "admin", "2015-09-09 13:43:51", "2015-09-09 14:43:51", "85.10.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("616", "0", "admin", "2015-09-09 13:43:52", "2015-09-09 14:43:52", "51.254.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("617", "0", "admin", "2015-09-09 13:43:52", "2015-09-09 14:43:52", "204.8.156.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("618", "0", "admin", "2015-09-09 13:43:53", "2015-09-09 14:43:53", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("619", "0", "magma", "2015-09-09 13:58:56", "2015-09-09 14:58:56", "84.236.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("620", "0", "magma", "2015-09-09 14:15:35", "2015-09-09 15:15:35", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("621", "0", "magma", "2015-09-09 14:16:44", "2015-09-09 15:16:44", "149.129.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("622", "0", "magma", "2015-09-09 14:28:46", "2015-09-09 15:28:46", "197.200.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("623", "0", "magma", "2015-09-09 14:29:21", "2015-09-09 15:29:21", "182.57.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("624", "1", "admin8576", "2015-09-09 14:30:10", "2015-09-09 15:30:10", "89.233.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("625", "0", "magma", "2015-09-09 14:30:48", "2015-09-09 15:30:48", "112.198.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("626", "0", "magma", "2015-09-09 14:47:12", "2015-09-09 15:47:12", "105.98.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("627", "0", "magma", "2015-09-09 14:50:04", "2015-09-09 15:50:04", "188.4.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("628", "0", "magma", "2015-09-09 14:59:15", "2015-09-09 15:59:15", "31.11.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("629", "0", "magma", "2015-09-09 15:02:12", "2015-09-09 16:02:12", "46.121.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("630", "0", "magma", "2015-09-09 15:12:10", "2015-09-09 16:12:10", "149.3.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("631", "0", "magma", "2015-09-09 15:16:08", "2015-09-09 16:16:08", "143.160.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("632", "0", "magma", "2015-09-09 15:33:43", "2015-09-09 16:33:43", "41.250.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("633", "0", "magma", "2015-09-09 15:37:34", "2015-09-09 16:37:34", "1.22.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("634", "0", "magma", "2015-09-09 15:53:51", "2015-09-09 16:53:51", "86.81.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("635", "0", "magma", "2015-09-09 16:00:58", "2015-09-09 17:00:58", "180.234.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("636", "0", "magma", "2015-09-09 16:05:02", "2015-09-09 17:05:02", "113.203.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("637", "0", "magma", "2015-09-09 16:17:43", "2015-09-09 17:17:43", "109.92.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("638", "0", "magma", "2015-09-09 16:28:43", "2015-09-09 17:28:43", "89.35.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("639", "0", "magma", "2015-09-09 16:29:37", "2015-09-09 17:29:37", "122.163.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("640", "0", "magma", "2015-09-09 16:34:09", "2015-09-09 17:34:09", "180.149.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("641", "0", "magma", "2015-09-09 16:36:01", "2015-09-09 17:36:01", "87.244.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("642", "0", "magma", "2015-09-09 16:41:16", "2015-09-09 17:41:16", "190.7.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("643", "0", "magma", "2015-09-09 16:43:53", "2015-09-09 17:43:53", "188.2.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("644", "0", "magma", "2015-09-09 16:47:07", "2015-09-09 17:47:07", "92.249.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("645", "0", "magma", "2015-09-09 16:50:34", "2015-09-09 17:50:34", "197.210.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("646", "0", "magma", "2015-09-09 17:10:06", "2015-09-09 18:10:06", "46.116.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("647", "0", "magma", "2015-09-09 17:10:44", "2015-09-09 18:10:44", "175.137.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("648", "0", "magma", "2015-09-09 17:31:22", "2015-09-09 18:31:22", "5.14.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("649", "0", "magma", "2015-09-09 17:46:08", "2015-09-09 18:46:08", "79.117.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("650", "0", "magma", "2015-09-09 18:32:51", "2015-09-09 19:32:51", "189.81.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("651", "0", "magma", "2015-09-09 18:34:10", "2015-09-09 19:34:10", "79.113.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("652", "0", "magma", "2015-09-09 18:39:54", "2015-09-09 19:39:54", "93.145.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("653", "0", "magma", "2015-09-09 18:42:14", "2015-09-09 19:42:14", "5.12.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("654", "0", "magma", "2015-09-09 18:46:12", "2015-09-09 19:46:12", "81.244.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("655", "0", "magma", "2015-09-09 19:09:16", "2015-09-09 20:09:16", "78.134.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("656", "0", "magma", "2015-09-09 19:09:18", "2015-09-09 20:09:18", "182.72.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("657", "0", "magma", "2015-09-09 19:11:13", "2015-09-09 20:11:13", "61.245.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("658", "0", "magma", "2015-09-09 19:25:46", "2015-09-09 20:25:46", "108.38.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("659", "0", "magma", "2015-09-09 19:30:55", "2015-09-09 20:30:55", "78.71.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("660", "0", "magma", "2015-09-09 19:54:48", "2015-09-09 20:54:48", "118.101.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("661", "0", "magma", "2015-09-09 19:55:42", "2015-09-09 20:55:42", "197.87.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("662", "0", "magma", "2015-09-09 19:55:52", "2015-09-09 20:55:52", "83.177.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("663", "0", "magma", "2015-09-09 20:34:57", "2015-09-09 21:34:57", "62.197.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("664", "0", "magma", "2015-09-09 20:54:02", "2015-09-09 21:54:02", "90.194.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("665", "0", "magma", "2015-09-09 21:15:22", "2015-09-09 22:15:22", "77.12.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("666", "0", "magma", "2015-09-09 21:21:49", "2015-09-09 22:21:49", "213.241.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("667", "0", "magma", "2015-09-09 21:41:44", "2015-09-09 22:41:44", "188.159.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("668", "0", "magma", "2015-09-09 22:04:27", "2015-09-09 23:04:27", "197.200.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("669", "0", "magma", "2015-09-09 22:44:12", "2015-09-09 23:44:12", "188.4.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("670", "0", "magma", "2015-09-09 23:16:44", "2015-09-10 00:16:44", "78.36.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("671", "0", "magma", "2015-09-09 23:30:42", "2015-09-10 00:30:42", "69.79.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("672", "0", "magma", "2015-09-09 23:55:14", "2015-09-10 00:55:14", "105.106.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("673", "0", "magma", "2015-09-10 00:14:48", "2015-09-10 01:14:48", "41.216.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("674", "0", "magma", "2015-09-10 00:18:50", "2015-09-10 01:18:50", "186.121.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("675", "0", "admin", "2015-09-10 00:33:05", "2015-09-10 01:33:05", "185.62.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("676", "0", "admin", "2015-09-10 00:33:07", "2015-09-10 01:33:07", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("677", "0", "admin", "2015-09-10 00:33:17", "2015-09-10 01:33:17", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("678", "0", "admin", "2015-09-10 00:33:23", "2015-09-10 01:33:23", "204.85.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("679", "0", "admin", "2015-09-10 00:33:26", "2015-09-10 01:33:26", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("680", "0", "admin", "2015-09-10 00:33:33", "2015-09-10 01:33:33", "185.17.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("681", "0", "magma", "2015-09-10 00:41:31", "2015-09-10 01:41:31", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("682", "0", "magma", "2015-09-10 00:59:28", "2015-09-10 01:59:28", "24.112.176.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("683", "0", "magma", "2015-09-10 02:05:29", "2015-09-10 03:05:29", "41.250.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("684", "0", "magma", "2015-09-10 02:07:32", "2015-09-10 03:07:32", "183.89.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("685", "0", "magma", "2015-09-10 02:32:29", "2015-09-10 03:32:29", "24.209.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("686", "0", "magma", "2015-09-10 03:25:16", "2015-09-10 04:25:16", "180.69.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("687", "0", "magma", "2015-09-10 03:32:31", "2015-09-10 04:32:31", "178.222.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("688", "0", "magma", "2015-09-10 03:59:21", "2015-09-10 04:59:21", "184.188.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("689", "0", "magma", "2015-09-10 04:30:49", "2015-09-10 05:30:49", "41.250.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("690", "0", "magma", "2015-09-10 05:33:12", "2015-09-10 06:33:12", "69.79.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("691", "0", "magma", "2015-09-10 05:42:13", "2015-09-10 06:42:13", "197.224.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("692", "0", "magma", "2015-09-10 06:02:10", "2015-09-10 07:02:10", "46.99.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("693", "0", "magma", "2015-09-10 06:28:38", "2015-09-10 07:28:38", "187.54.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("694", "0", "magma", "2015-09-10 06:39:25", "2015-09-10 07:39:25", "83.233.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("695", "0", "magma", "2015-09-10 06:43:05", "2015-09-10 07:43:05", "190.72.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("696", "0", "magma", "2015-09-10 07:26:35", "2015-09-10 08:26:35", "181.120.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("697", "0", "magma", "2015-09-10 07:57:24", "2015-09-10 08:57:24", "85.229.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("698", "0", "magma", "2015-09-10 08:15:40", "2015-09-10 09:15:40", "182.186.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("699", "0", "magma", "2015-09-10 08:31:44", "2015-09-10 09:31:44", "105.186.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("700", "0", "magma", "2015-09-10 08:33:08", "2015-09-10 09:33:08", "58.186.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("701", "0", "magma", "2015-09-10 08:37:36", "2015-09-10 09:37:36", "94.240.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("702", "0", "magma", "2015-09-10 08:55:10", "2015-09-10 09:55:10", "185.82.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("703", "0", "magma", "2015-09-10 08:57:12", "2015-09-10 09:57:12", "46.248.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("704", "0", "magma", "2015-09-10 09:01:47", "2015-09-10 10:01:47", "84.236.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("705", "0", "magma", "2015-09-10 09:11:10", "2015-09-10 10:11:10", "112.133.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("706", "0", "magma", "2015-09-10 09:18:39", "2015-09-10 10:18:39", "112.210.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("707", "0", "magma", "2015-09-10 09:25:39", "2015-09-10 10:25:39", "117.194.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("708", "0", "magma", "2015-09-10 09:38:52", "2015-09-10 10:38:52", "105.98.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("709", "0", "magma", "2015-09-10 10:02:48", "2015-09-10 11:02:48", "69.204.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("710", "0", "admin", "2015-09-10 10:09:16", "2015-09-10 11:09:16", "213.252.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("711", "0", "admin", "2015-09-10 10:09:17", "2015-09-10 11:09:17", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("712", "0", "admin", "2015-09-10 10:09:17", "2015-09-10 11:09:17", "217.115.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("713", "0", "admin", "2015-09-10 10:09:17", "2015-09-10 11:09:17", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("714", "0", "admin", "2015-09-10 10:09:18", "2015-09-10 11:09:18", "69.42.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("715", "0", "magma", "2015-09-10 10:15:04", "2015-09-10 11:15:04", "202.62.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("716", "0", "magma", "2015-09-10 10:37:34", "2015-09-10 11:37:34", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("717", "0", "magma", "2015-09-10 10:42:25", "2015-09-10 11:42:25", "77.240.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("718", "0", "magma", "2015-09-10 10:55:23", "2015-09-10 11:55:23", "118.36.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("719", "0", "magma", "2015-09-10 11:00:34", "2015-09-10 12:00:34", "223.223.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("720", "0", "magma", "2015-09-10 11:49:14", "2015-09-10 12:49:14", "217.75.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("721", "0", "magma", "2015-09-10 12:22:00", "2015-09-10 13:22:00", "122.167.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("722", "0", "magma", "2015-09-10 12:48:42", "2015-09-10 13:48:42", "178.220.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("723", "0", "magma", "2015-09-10 12:55:00", "2015-09-10 13:55:00", "197.224.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("724", "0", "magma", "2015-09-10 13:23:28", "2015-09-10 14:23:28", "41.74.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("725", "0", "magma", "2015-09-10 13:34:19", "2015-09-10 14:34:19", "86.121.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("726", "0", "magma", "2015-09-10 14:03:43", "2015-09-10 15:03:43", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("727", "0", "magma", "2015-09-10 14:17:32", "2015-09-10 15:17:32", "84.0.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("728", "0", "magma", "2015-09-10 15:13:54", "2015-09-10 16:13:54", "39.36.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("729", "0", "magma", "2015-09-10 15:17:32", "2015-09-10 16:17:32", "210.242.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("730", "0", "magma", "2015-09-10 15:19:06", "2015-09-10 16:19:06", "41.230.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("731", "0", "magma", "2015-09-10 15:22:15", "2015-09-10 16:22:15", "92.84.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("732", "0", "magma", "2015-09-10 15:46:16", "2015-09-10 16:46:16", "79.114.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("733", "0", "magma", "2015-09-10 16:16:07", "2015-09-10 17:16:07", "95.76.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("734", "0", "magma", "2015-09-10 16:20:12", "2015-09-10 17:20:12", "86.123.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("735", "0", "magma", "2015-09-10 16:29:46", "2015-09-10 17:29:46", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("736", "0", "magma", "2015-09-10 16:47:11", "2015-09-10 17:47:11", "49.159.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("737", "0", "magma", "2015-09-10 17:11:53", "2015-09-10 18:11:53", "212.54.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("738", "0", "magma", "2015-09-10 17:32:07", "2015-09-10 18:32:07", "94.122.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("739", "0", "magma", "2015-09-10 17:44:16", "2015-09-10 18:44:16", "217.71.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("740", "0", "magma", "2015-09-10 18:09:08", "2015-09-10 19:09:08", "88.184.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("741", "0", "magma", "2015-09-10 18:26:40", "2015-09-10 19:26:40", "178.150.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("742", "0", "magma", "2015-09-10 18:27:57", "2015-09-10 19:27:57", "1.126.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("743", "0", "magma", "2015-09-10 18:28:00", "2015-09-10 19:28:00", "92.80.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("744", "0", "magma", "2015-09-10 18:37:15", "2015-09-10 19:37:15", "182.186.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("745", "0", "magma", "2015-09-10 19:21:10", "2015-09-10 20:21:10", "200.82.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("746", "0", "magma", "2015-09-10 19:50:10", "2015-09-10 20:50:10", "78.207.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("747", "0", "magma", "2015-09-10 19:59:23", "2015-09-10 20:59:23", "5.15.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("748", "0", "magma", "2015-09-10 20:08:11", "2015-09-10 21:08:11", "78.71.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("749", "0", "magma", "2015-09-10 20:16:03", "2015-09-10 21:16:03", "37.210.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("750", "0", "magma", "2015-09-10 20:19:50", "2015-09-10 21:19:50", "178.220.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("751", "0", "magma", "2015-09-10 20:22:56", "2015-09-10 21:22:56", "99.226.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("752", "0", "magma", "2015-09-10 20:35:49", "2015-09-10 21:35:49", "82.237.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("753", "0", "magma", "2015-09-10 20:41:08", "2015-09-10 21:41:08", "60.50.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("754", "0", "admin", "2015-09-10 20:58:30", "2015-09-10 21:58:30", "176.31.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("755", "0", "admin", "2015-09-10 20:58:31", "2015-09-10 21:58:31", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("756", "0", "admin", "2015-09-10 20:58:31", "2015-09-10 21:58:31", "134.17.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("757", "0", "admin", "2015-09-10 20:58:31", "2015-09-10 21:58:31", "178.217.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("758", "0", "admin", "2015-09-10 20:58:50", "2015-09-10 21:58:50", "185.14.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("759", "0", "admin", "2015-09-10 20:58:56", "2015-09-10 21:58:56", "87.98.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("760", "0", "magma", "2015-09-10 21:04:38", "2015-09-10 22:04:38", "81.108.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("761", "0", "magma", "2015-09-10 21:35:25", "2015-09-10 22:35:25", "39.42.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("762", "0", "magma", "2015-09-10 22:18:38", "2015-09-10 23:18:38", "27.124.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("763", "0", "magma", "2015-09-10 22:31:14", "2015-09-10 23:31:14", "41.100.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("764", "0", "magma", "2015-09-10 22:44:38", "2015-09-10 23:44:38", "197.88.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("765", "0", "magma", "2015-09-10 22:55:17", "2015-09-10 23:55:17", "89.42.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("766", "0", "magma", "2015-09-10 22:57:33", "2015-09-10 23:57:33", "84.123.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("767", "0", "magma", "2015-09-10 22:59:57", "2015-09-10 23:59:57", "92.80.222.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("768", "0", "magma", "2015-09-10 23:35:28", "2015-09-11 00:35:28", "178.148.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("769", "0", "magma", "2015-09-10 23:56:49", "2015-09-11 00:56:49", "112.208.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("770", "0", "magma", "2015-09-11 00:29:59", "2015-09-11 01:29:59", "5.228.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("771", "0", "magma", "2015-09-11 01:00:32", "2015-09-11 02:00:32", "178.67.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("772", "0", "magma", "2015-09-11 01:18:38", "2015-09-11 02:18:38", "210.242.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("773", "0", "magma", "2015-09-11 02:03:11", "2015-09-11 03:03:11", "78.127.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("774", "0", "magma", "2015-09-11 03:21:15", "2015-09-11 04:21:15", "190.88.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("775", "0", "magma", "2015-09-11 04:29:07", "2015-09-11 05:29:07", "95.23.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("776", "0", "magma", "2015-09-11 04:40:47", "2015-09-11 05:40:47", "113.203.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("777", "0", "magma", "2015-09-11 04:56:53", "2015-09-11 05:56:53", "58.186.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("778", "0", "magma", "2015-09-11 06:34:55", "2015-09-11 07:34:55", "45.114.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("779", "0", "magma", "2015-09-11 06:47:31", "2015-09-11 07:47:31", "197.88.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("780", "0", "magma", "2015-09-11 07:00:17", "2015-09-11 08:00:17", "105.98.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("781", "0", "magma", "2015-09-11 07:19:54", "2015-09-11 08:19:54", "49.145.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("782", "0", "magma", "2015-09-11 07:28:28", "2015-09-11 08:28:28", "124.82.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("783", "0", "admin", "2015-09-11 07:31:09", "2015-09-11 08:31:09", "85.25.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("784", "0", "admin", "2015-09-11 07:31:10", "2015-09-11 08:31:10", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("785", "0", "admin", "2015-09-11 07:31:10", "2015-09-11 08:31:10", "193.42.156.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("786", "0", "admin", "2015-09-11 07:31:10", "2015-09-11 08:31:10", "62.141.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("787", "0", "admin", "2015-09-11 07:31:13", "2015-09-11 08:31:13", "185.62.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("788", "0", "magma", "2015-09-11 07:45:22", "2015-09-11 08:45:22", "82.76.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("789", "0", "magma", "2015-09-11 08:35:19", "2015-09-11 09:35:19", "103.230.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("790", "0", "magma", "2015-09-11 08:39:19", "2015-09-11 09:39:19", "109.93.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("791", "0", "magma", "2015-09-11 09:09:40", "2015-09-11 10:09:40", "150.129.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("792", "0", "magma", "2015-09-11 09:26:07", "2015-09-11 10:26:07", "1.186.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("793", "0", "magma", "2015-09-11 09:33:35", "2015-09-11 10:33:35", "178.220.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("794", "0", "magma", "2015-09-11 09:54:18", "2015-09-11 10:54:18", "62.209.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("795", "0", "magma", "2015-09-11 10:19:46", "2015-09-11 11:19:46", "110.93.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("796", "0", "magma", "2015-09-11 10:21:06", "2015-09-11 11:21:06", "178.137.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("797", "0", "magma", "2015-09-11 10:35:38", "2015-09-11 11:35:38", "87.250.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("798", "0", "magma", "2015-09-11 10:55:27", "2015-09-11 11:55:27", "176.73.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("799", "1", "admin8576", "2015-09-11 11:34:22", "2015-09-11 12:34:22", "89.233.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("800", "0", "magma", "2015-09-11 12:04:25", "2015-09-11 13:04:25", "46.20.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("801", "0", "magma", "2015-09-11 12:08:10", "2015-09-11 13:08:10", "86.21.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("802", "0", "magma", "2015-09-11 12:16:36", "2015-09-11 13:16:36", "176.73.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("803", "0", "magma", "2015-09-11 13:27:55", "2015-09-11 14:27:55", "89.152.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("804", "0", "magma", "2015-09-11 13:56:14", "2015-09-11 14:56:14", "115.254.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("805", "0", "magma", "2015-09-11 13:56:19", "2015-09-11 14:56:19", "212.233.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("806", "0", "magma", "2015-09-11 14:26:40", "2015-09-11 15:26:40", "46.59.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("807", "0", "magma", "2015-09-11 14:43:29", "2015-09-11 15:43:29", "95.61.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("808", "0", "magma", "2015-09-11 14:56:24", "2015-09-11 15:56:24", "41.230.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("809", "0", "magma", "2015-09-11 15:25:55", "2015-09-11 16:25:55", "81.108.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("810", "0", "magma", "2015-09-11 15:49:28", "2015-09-11 16:49:28", "178.223.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("811", "0", "magma", "2015-09-11 15:49:29", "2015-09-11 16:49:29", "185.82.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("812", "0", "magma", "2015-09-11 16:14:17", "2015-09-11 17:14:17", "188.36.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("813", "0", "magma", "2015-09-11 17:00:33", "2015-09-11 18:00:33", "84.0.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("814", "0", "magma", "2015-09-11 17:10:58", "2015-09-11 18:10:58", "93.103.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("815", "0", "magma", "2015-09-11 17:22:01", "2015-09-11 18:22:01", "49.159.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("816", "0", "magma", "2015-09-11 17:34:27", "2015-09-11 18:34:27", "112.207.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("817", "0", "admin", "2015-09-11 17:35:46", "2015-09-11 18:35:46", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("818", "0", "admin", "2015-09-11 17:35:46", "2015-09-11 18:35:46", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("819", "0", "admin", "2015-09-11 17:35:46", "2015-09-11 18:35:46", "188.138.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("820", "0", "admin", "2015-09-11 17:35:47", "2015-09-11 18:35:47", "92.222.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("821", "0", "magma", "2015-09-11 17:49:38", "2015-09-11 18:49:38", "178.93.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("822", "0", "magma", "2015-09-11 18:11:00", "2015-09-11 19:11:00", "84.1.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("823", "0", "magma", "2015-09-11 19:09:46", "2015-09-11 20:09:46", "36.80.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("824", "0", "magma", "2015-09-11 19:18:32", "2015-09-11 20:18:32", "1.186.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("825", "0", "magma", "2015-09-11 19:41:24", "2015-09-11 20:41:24", "31.41.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("826", "0", "magma", "2015-09-11 19:43:53", "2015-09-11 20:43:53", "89.35.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("827", "0", "magma", "2015-09-11 20:13:17", "2015-09-11 21:13:17", "46.20.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("828", "0", "magma", "2015-09-11 20:16:11", "2015-09-11 21:16:11", "90.224.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("829", "0", "magma", "2015-09-11 20:19:34", "2015-09-11 21:19:34", "84.221.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("830", "0", "magma", "2015-09-11 21:02:12", "2015-09-11 22:02:12", "186.153.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("831", "0", "magma", "2015-09-11 21:06:34", "2015-09-11 22:06:34", "46.164.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("832", "0", "magma", "2015-09-11 21:42:47", "2015-09-11 22:42:47", "92.56.161.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("833", "0", "magma", "2015-09-11 21:46:39", "2015-09-11 22:46:39", "109.80.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("834", "0", "magma", "2015-09-11 21:48:12", "2015-09-11 22:48:12", "120.28.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("835", "0", "magma", "2015-09-11 22:19:33", "2015-09-11 23:19:33", "85.250.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("836", "0", "magma", "2015-09-11 22:35:56", "2015-09-11 23:35:56", "93.103.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("837", "0", "magma", "2015-09-11 22:44:46", "2015-09-11 23:44:46", "27.124.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("838", "0", "magma", "2015-09-11 23:08:59", "2015-09-12 00:08:59", "176.73.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("839", "0", "magma", "2015-09-11 23:26:53", "2015-09-12 00:26:53", "85.250.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("840", "0", "magma", "2015-09-11 23:26:57", "2015-09-12 00:26:57", "176.221.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("841", "0", "magma", "2015-09-11 23:38:23", "2015-09-12 00:38:23", "196.36.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("842", "0", "magma", "2015-09-12 01:50:12", "2015-09-12 02:50:12", "79.178.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("843", "0", "magma", "2015-09-12 01:55:34", "2015-09-12 02:55:34", "174.1.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("844", "0", "magma", "2015-09-12 03:14:08", "2015-09-12 04:14:08", "46.107.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("845", "0", "magma", "2015-09-12 03:24:21", "2015-09-12 04:24:21", "84.108.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("846", "0", "magma", "2015-09-12 03:42:06", "2015-09-12 04:42:06", "114.134.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("847", "0", "magma", "2015-09-12 03:48:30", "2015-09-12 04:48:30", "78.182.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("848", "0", "admin", "2015-09-12 04:01:41", "2015-09-12 05:01:41", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("849", "0", "admin", "2015-09-12 04:01:42", "2015-09-12 05:01:42", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("850", "0", "admin", "2015-09-12 04:01:42", "2015-09-12 05:01:42", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("851", "0", "admin", "2015-09-12 04:01:46", "2015-09-12 05:01:46", "188.209.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("852", "0", "admin", "2015-09-12 04:01:51", "2015-09-12 05:01:51", "176.9.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("853", "0", "magma", "2015-09-12 04:13:10", "2015-09-12 05:13:10", "175.142.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("854", "0", "magma", "2015-09-12 04:36:06", "2015-09-12 05:36:06", "151.25.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("855", "0", "magma", "2015-09-12 05:01:27", "2015-09-12 06:01:27", "92.82.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("856", "0", "magma", "2015-09-12 05:44:03", "2015-09-12 06:44:03", "180.232.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("857", "0", "magma", "2015-09-12 05:56:24", "2015-09-12 06:56:24", "81.217.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("858", "0", "magma", "2015-09-12 06:22:46", "2015-09-12 07:22:46", "197.251.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("859", "0", "magma", "2015-09-12 08:19:13", "2015-09-12 09:19:13", "188.212.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("860", "0", "magma", "2015-09-12 08:37:01", "2015-09-12 09:37:01", "27.147.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("861", "0", "magma", "2015-09-12 09:22:18", "2015-09-12 10:22:18", "42.115.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("862", "0", "magma", "2015-09-12 09:40:25", "2015-09-12 10:40:25", "89.103.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("863", "0", "magma", "2015-09-12 10:05:26", "2015-09-12 11:05:26", "79.117.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("864", "0", "magma", "2015-09-12 10:42:26", "2015-09-12 11:42:26", "109.65.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("865", "0", "magma", "2015-09-12 10:59:21", "2015-09-12 11:59:21", "213.226.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("866", "0", "magma", "2015-09-12 11:39:53", "2015-09-12 12:39:53", "1.52.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("867", "0", "magma", "2015-09-12 12:14:59", "2015-09-12 13:14:59", "62.197.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("868", "0", "magma", "2015-09-12 12:41:53", "2015-09-12 13:41:53", "94.52.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("869", "0", "magma", "2015-09-12 13:15:43", "2015-09-12 14:15:43", "5.178.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("870", "0", "magma", "2015-09-12 13:47:01", "2015-09-12 14:47:01", "195.240.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("871", "0", "admin", "2015-09-12 13:56:18", "2015-09-12 14:56:18", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("872", "0", "admin", "2015-09-12 13:56:19", "2015-09-12 14:56:19", "185.36.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("873", "0", "admin", "2015-09-12 13:56:19", "2015-09-12 14:56:19", "5.9.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("874", "0", "admin", "2015-09-12 13:56:21", "2015-09-12 14:56:21", "185.75.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("875", "0", "admin", "2015-09-12 13:56:27", "2015-09-12 14:56:27", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("876", "0", "magma", "2015-09-12 14:05:50", "2015-09-12 15:05:50", "103.26.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("877", "0", "magma", "2015-09-12 14:09:28", "2015-09-12 15:09:28", "90.191.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("878", "0", "magma", "2015-09-12 14:34:13", "2015-09-12 15:34:13", "143.176.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("879", "0", "magma", "2015-09-12 14:36:15", "2015-09-12 15:36:15", "5.178.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("880", "0", "magma", "2015-09-12 14:46:00", "2015-09-12 15:46:00", "139.194.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("881", "0", "magma", "2015-09-12 15:55:17", "2015-09-12 16:55:17", "105.159.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("882", "0", "magma", "2015-09-12 16:01:21", "2015-09-12 17:01:21", "109.92.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("883", "0", "magma", "2015-09-12 16:10:36", "2015-09-12 17:10:36", "80.222.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("884", "0", "magma", "2015-09-12 16:17:49", "2015-09-12 17:17:49", "178.161.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("885", "0", "magma", "2015-09-12 16:21:10", "2015-09-12 17:21:10", "217.145.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("886", "0", "magma", "2015-09-12 16:47:21", "2015-09-12 17:47:21", "89.114.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("887", "0", "magma", "2015-09-12 16:58:32", "2015-09-12 17:58:32", "188.4.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("888", "0", "magma", "2015-09-12 17:25:16", "2015-09-12 18:25:16", "195.240.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("889", "0", "magma", "2015-09-12 17:25:19", "2015-09-12 18:25:19", "180.232.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("890", "0", "magma", "2015-09-12 17:27:02", "2015-09-12 18:27:02", "185.38.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("891", "0", "magma", "2015-09-12 17:39:14", "2015-09-12 18:39:14", "217.119.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("892", "0", "magma", "2015-09-12 18:05:35", "2015-09-12 19:05:35", "46.20.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("893", "0", "magma", "2015-09-12 18:16:25", "2015-09-12 19:16:25", "109.92.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("894", "0", "magma", "2015-09-12 18:19:18", "2015-09-12 19:19:18", "86.101.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("895", "0", "magma", "2015-09-12 18:28:26", "2015-09-12 19:28:26", "79.176.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("896", "0", "magma", "2015-09-12 18:32:15", "2015-09-12 19:32:15", "83.44.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("897", "0", "magma", "2015-09-12 19:29:26", "2015-09-12 20:29:26", "175.157.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("898", "0", "magma", "2015-09-12 21:36:37", "2015-09-12 22:36:37", "103.230.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("899", "0", "magma", "2015-09-12 21:48:35", "2015-09-12 22:48:35", "210.210.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("900", "0", "magma", "2015-09-12 21:53:57", "2015-09-12 22:53:57", "175.195.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("901", "0", "magma", "2015-09-12 21:58:54", "2015-09-12 22:58:54", "37.27.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("902", "0", "magma", "2015-09-12 22:03:40", "2015-09-12 23:03:40", "86.21.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("903", "0", "magma", "2015-09-12 22:32:23", "2015-09-12 23:32:23", "46.99.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("904", "1", "admin8576", "2015-09-12 22:50:47", "2015-09-12 23:50:47", "173.208.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("905", "1", "admin8576", "2015-09-12 22:50:47", "2015-09-12 23:50:47", "173.208.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("906", "0", "magma", "2015-09-13 00:01:17", "2015-09-13 01:01:17", "194.219.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("907", "0", "magma", "2015-09-13 00:08:27", "2015-09-13 01:08:27", "85.74.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("908", "0", "admin", "2015-09-13 00:32:46", "2015-09-13 01:32:46", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("909", "0", "admin", "2015-09-13 00:32:46", "2015-09-13 01:32:46", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("910", "0", "admin", "2015-09-13 00:32:47", "2015-09-13 01:32:47", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("911", "0", "admin", "2015-09-13 00:32:48", "2015-09-13 01:32:48", "94.242.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("912", "0", "magma", "2015-09-13 01:34:23", "2015-09-13 02:34:23", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("913", "0", "magma", "2015-09-13 03:06:26", "2015-09-13 04:06:26", "108.183.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("914", "0", "magma", "2015-09-13 04:06:59", "2015-09-13 05:06:59", "50.191.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("915", "0", "magma", "2015-09-13 04:23:06", "2015-09-13 05:23:06", "41.254.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("916", "0", "magma", "2015-09-13 05:00:48", "2015-09-13 06:00:48", "181.59.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("917", "0", "magma", "2015-09-13 05:08:03", "2015-09-13 06:08:03", "62.209.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("918", "0", "magma", "2015-09-13 05:50:11", "2015-09-13 06:50:11", "121.99.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("919", "0", "magma", "2015-09-13 06:23:06", "2015-09-13 07:23:06", "119.93.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("920", "0", "magma", "2015-09-13 06:56:32", "2015-09-13 07:56:32", "186.45.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("921", "0", "magma", "2015-09-13 07:53:51", "2015-09-13 08:53:51", "180.234.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("922", "0", "magma", "2015-09-13 08:12:12", "2015-09-13 09:12:12", "175.140.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("923", "0", "magma", "2015-09-13 08:41:49", "2015-09-13 09:41:49", "210.195.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("924", "0", "magma", "2015-09-13 08:45:43", "2015-09-13 09:45:43", "178.42.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("925", "0", "magma", "2015-09-13 09:13:13", "2015-09-13 10:13:13", "50.118.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("926", "0", "magma", "2015-09-13 09:54:42", "2015-09-13 10:54:42", "79.140.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("927", "0", "magma", "2015-09-13 10:13:16", "2015-09-13 11:13:16", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("928", "0", "magma", "2015-09-13 10:33:43", "2015-09-13 11:33:43", "79.101.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("929", "0", "admin", "2015-09-13 10:36:33", "2015-09-13 11:36:33", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("930", "0", "admin", "2015-09-13 10:36:33", "2015-09-13 11:36:33", "62.141.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("931", "0", "admin", "2015-09-13 10:36:33", "2015-09-13 11:36:33", "62.210.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("932", "0", "magma", "2015-09-13 11:27:40", "2015-09-13 12:27:40", "112.168.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("933", "0", "magma", "2015-09-13 11:42:16", "2015-09-13 12:42:16", "41.142.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("934", "0", "magma", "2015-09-13 12:01:44", "2015-09-13 13:01:44", "92.87.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("935", "0", "magma", "2015-09-13 12:08:28", "2015-09-13 13:08:28", "91.186.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("936", "0", "magma", "2015-09-13 12:26:07", "2015-09-13 13:26:07", "95.86.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("937", "0", "magma", "2015-09-13 12:33:14", "2015-09-13 13:33:14", "5.83.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("938", "0", "magma", "2015-09-13 12:36:49", "2015-09-13 13:36:49", "117.195.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("939", "0", "magma", "2015-09-13 13:17:06", "2015-09-13 14:17:06", "203.87.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("940", "0", "magma", "2015-09-13 13:22:22", "2015-09-13 14:22:22", "89.42.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("941", "0", "magma", "2015-09-13 13:24:40", "2015-09-13 14:24:40", "178.150.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("942", "0", "magma", "2015-09-13 13:31:27", "2015-09-13 14:31:27", "186.123.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("943", "0", "magma", "2015-09-13 13:46:37", "2015-09-13 14:46:37", "151.30.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("944", "0", "magma", "2015-09-13 14:08:56", "2015-09-13 15:08:56", "89.139.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("945", "0", "magma", "2015-09-13 14:14:34", "2015-09-13 15:14:34", "78.61.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("946", "0", "magma", "2015-09-13 14:46:01", "2015-09-13 15:46:01", "109.101.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("947", "0", "magma", "2015-09-13 15:31:23", "2015-09-13 16:31:23", "111.68.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("948", "0", "magma", "2015-09-13 15:40:43", "2015-09-13 16:40:43", "1.52.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("949", "0", "magma", "2015-09-13 16:03:30", "2015-09-13 17:03:30", "91.186.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("950", "0", "magma", "2015-09-13 16:16:06", "2015-09-13 17:16:06", "41.46.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("951", "0", "magma", "2015-09-13 16:18:01", "2015-09-13 17:18:01", "90.244.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("952", "0", "magma", "2015-09-13 16:34:52", "2015-09-13 17:34:52", "117.195.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("953", "0", "magma", "2015-09-13 16:35:42", "2015-09-13 17:35:42", "180.234.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("954", "0", "magma", "2015-09-13 16:56:36", "2015-09-13 17:56:36", "85.122.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("955", "0", "magma", "2015-09-13 17:07:59", "2015-09-13 18:07:59", "178.222.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("956", "0", "magma", "2015-09-13 17:17:18", "2015-09-13 18:17:18", "197.200.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("957", "0", "magma", "2015-09-13 18:58:07", "2015-09-13 19:58:07", "39.59.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("958", "0", "magma", "2015-09-13 19:01:56", "2015-09-13 20:01:56", "79.134.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("959", "0", "magma", "2015-09-13 19:03:29", "2015-09-13 20:03:29", "197.0.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("960", "0", "magma", "2015-09-13 19:05:32", "2015-09-13 20:05:32", "213.226.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("961", "0", "magma", "2015-09-13 19:11:32", "2015-09-13 20:11:32", "85.238.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("962", "0", "magma", "2015-09-13 19:47:45", "2015-09-13 20:47:45", "108.183.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("963", "0", "magma", "2015-09-13 20:06:23", "2015-09-13 21:06:23", "176.109.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("964", "0", "magma", "2015-09-13 20:30:19", "2015-09-13 21:30:19", "86.124.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("965", "0", "magma", "2015-09-13 21:04:35", "2015-09-13 22:04:35", "178.93.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("966", "0", "magma", "2015-09-13 21:10:07", "2015-09-13 22:10:07", "92.82.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("967", "0", "magma", "2015-09-13 21:20:03", "2015-09-13 22:20:03", "46.99.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("968", "0", "admin", "2015-09-13 21:43:19", "2015-09-13 22:43:19", "178.17.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("969", "0", "admin", "2015-09-13 21:43:20", "2015-09-13 22:43:20", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("970", "0", "admin", "2015-09-13 21:43:20", "2015-09-13 22:43:20", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("971", "0", "admin", "2015-09-13 21:43:23", "2015-09-13 22:43:23", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("972", "0", "admin", "2015-09-13 21:43:25", "2015-09-13 22:43:25", "50.7.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("973", "0", "magma", "2015-09-13 22:47:19", "2015-09-13 23:47:19", "41.249.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("974", "0", "magma", "2015-09-13 22:53:45", "2015-09-13 23:53:45", "201.1.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("975", "0", "magma", "2015-09-13 22:54:25", "2015-09-13 23:54:25", "87.9.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("976", "0", "magma", "2015-09-14 02:40:21", "2015-09-14 03:40:21", "188.36.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("977", "0", "magma", "2015-09-14 04:09:21", "2015-09-14 05:09:21", "41.182.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("978", "0", "magma", "2015-09-14 05:45:03", "2015-09-14 06:45:03", "109.102.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("979", "0", "magma", "2015-09-14 07:19:13", "2015-09-14 08:19:13", "2.49.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("980", "0", "magma", "2015-09-14 07:34:07", "2015-09-14 08:34:07", "117.216.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("981", "0", "magma", "2015-09-14 07:51:11", "2015-09-14 08:51:11", "41.182.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("982", "0", "magma", "2015-09-14 08:04:35", "2015-09-14 09:04:35", "210.242.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("983", "0", "admin", "2015-09-14 08:17:07", "2015-09-14 09:17:07", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("984", "0", "admin", "2015-09-14 08:17:07", "2015-09-14 09:17:07", "37.157.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("985", "0", "admin", "2015-09-14 08:17:08", "2015-09-14 09:17:08", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("986", "0", "admin", "2015-09-14 08:17:09", "2015-09-14 09:17:09", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("987", "0", "admin", "2015-09-14 08:17:16", "2015-09-14 09:17:16", "85.93.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("988", "0", "magma", "2015-09-14 09:27:08", "2015-09-14 10:27:08", "95.254.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("989", "0", "magma", "2015-09-14 09:30:58", "2015-09-14 10:30:58", "217.75.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("990", "0", "magma", "2015-09-14 09:36:08", "2015-09-14 10:36:08", "158.181.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("991", "0", "magma", "2015-09-14 10:27:32", "2015-09-14 11:27:32", "188.69.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("992", "0", "magma", "2015-09-14 11:25:57", "2015-09-14 12:25:57", "31.154.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("993", "0", "magma", "2015-09-14 11:28:59", "2015-09-14 12:28:59", "146.255.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("994", "0", "magma", "2015-09-14 12:40:01", "2015-09-14 13:40:01", "41.67.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("995", "0", "magma", "2015-09-14 13:03:36", "2015-09-14 14:03:36", "79.116.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("996", "0", "magma", "2015-09-14 13:25:28", "2015-09-14 14:25:28", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("997", "0", "magma", "2015-09-14 13:32:48", "2015-09-14 14:32:48", "39.32.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("998", "0", "magma", "2015-09-14 14:12:11", "2015-09-14 15:12:11", "86.120.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("999", "0", "magma", "2015-09-14 14:12:58", "2015-09-14 15:12:58", "117.197.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1000", "0", "magma", "2015-09-14 14:42:47", "2015-09-14 15:42:47", "78.88.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1001", "0", "magma", "2015-09-14 15:17:05", "2015-09-14 16:17:05", "151.250.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1002", "0", "magma", "2015-09-14 15:43:33", "2015-09-14 16:43:33", "87.252.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1003", "0", "magma", "2015-09-14 15:55:36", "2015-09-14 16:55:36", "114.108.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1004", "0", "magma", "2015-09-14 16:10:27", "2015-09-14 17:10:27", "151.30.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1005", "0", "magma", "2015-09-14 16:28:58", "2015-09-14 17:28:58", "31.217.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1006", "0", "magma", "2015-09-14 16:33:18", "2015-09-14 17:33:18", "86.121.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1007", "0", "magma", "2015-09-14 16:37:09", "2015-09-14 17:37:09", "78.88.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1008", "0", "magma", "2015-09-14 16:44:08", "2015-09-14 17:44:08", "89.165.176.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1009", "0", "magma", "2015-09-14 17:07:32", "2015-09-14 18:07:32", "124.41.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1010", "0", "admin", "2015-09-14 20:01:20", "2015-09-14 21:01:20", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1011", "0", "admin", "2015-09-14 20:01:21", "2015-09-14 21:01:21", "85.10.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1012", "0", "admin", "2015-09-14 20:01:22", "2015-09-14 21:01:22", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1013", "0", "admin", "2015-09-14 20:01:23", "2015-09-14 21:01:23", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1014", "0", "admin", "2015-09-14 20:01:23", "2015-09-14 21:01:23", "37.48.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1015", "0", "magma", "2015-09-14 20:15:13", "2015-09-14 21:15:13", "178.221.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1016", "0", "magma", "2015-09-14 20:18:00", "2015-09-14 21:18:00", "180.234.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1017", "0", "magma", "2015-09-14 20:44:23", "2015-09-14 21:44:23", "92.97.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1018", "0", "magma", "2015-09-14 20:47:13", "2015-09-14 21:47:13", "95.49.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1019", "0", "magma", "2015-09-14 20:52:11", "2015-09-14 21:52:11", "89.138.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1020", "0", "magma", "2015-09-14 21:43:16", "2015-09-14 22:43:16", "182.181.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1021", "0", "magma", "2015-09-14 21:54:47", "2015-09-14 22:54:47", "46.107.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1022", "0", "magma", "2015-09-14 22:26:03", "2015-09-14 23:26:03", "177.200.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1023", "0", "Admin", "2015-09-14 23:39:55", "2015-09-15 00:39:55", "195.154.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1024", "0", "magma", "2015-09-14 23:52:04", "2015-09-15 00:52:04", "31.223.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1025", "0", "magma", "2015-09-15 00:07:51", "2015-09-15 01:07:51", "183.87.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1026", "0", "magma", "2015-09-15 00:20:45", "2015-09-15 01:20:45", "209.174.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1027", "0", "magma", "2015-09-15 00:48:39", "2015-09-15 01:48:39", "193.226.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1028", "0", "magma", "2015-09-15 01:02:57", "2015-09-15 02:02:57", "111.93.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1029", "0", "magma", "2015-09-15 01:48:59", "2015-09-15 02:48:59", "77.235.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1030", "0", "magma", "2015-09-15 02:12:47", "2015-09-15 03:12:47", "200.82.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1031", "0", "magma", "2015-09-15 02:37:40", "2015-09-15 03:37:40", "41.216.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1032", "0", "magma", "2015-09-15 03:34:42", "2015-09-15 04:34:42", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1033", "0", "magma", "2015-09-15 03:55:18", "2015-09-15 04:55:18", "189.49.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1034", "0", "magma", "2015-09-15 04:24:41", "2015-09-15 05:24:41", "190.78.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1035", "0", "magma", "2015-09-15 06:12:04", "2015-09-15 07:12:04", "41.216.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1036", "0", "magma", "2015-09-15 07:02:25", "2015-09-15 08:02:25", "177.18.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1037", "0", "admin", "2015-09-15 07:13:11", "2015-09-15 08:13:11", "87.118.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1038", "0", "admin", "2015-09-15 07:13:12", "2015-09-15 08:13:12", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1039", "0", "admin", "2015-09-15 07:13:12", "2015-09-15 08:13:12", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1040", "0", "admin", "2015-09-15 07:13:13", "2015-09-15 08:13:13", "194.150.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1041", "0", "magma", "2015-09-15 07:50:32", "2015-09-15 08:50:32", "49.145.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1042", "0", "magma", "2015-09-15 08:06:37", "2015-09-15 09:06:37", "95.68.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1043", "0", "magma", "2015-09-15 08:09:43", "2015-09-15 09:09:43", "103.55.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1044", "0", "magma", "2015-09-15 09:07:20", "2015-09-15 10:07:20", "2.50.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1045", "0", "magma", "2015-09-15 09:44:55", "2015-09-15 10:44:55", "2.49.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1046", "0", "magma", "2015-09-15 10:30:23", "2015-09-15 11:30:23", "213.55.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1047", "0", "magma", "2015-09-15 11:57:13", "2015-09-15 12:57:13", "178.220.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1048", "0", "magma", "2015-09-15 12:29:57", "2015-09-15 13:29:57", "60.54.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1049", "0", "magma", "2015-09-15 12:50:25", "2015-09-15 13:50:25", "46.117.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1050", "0", "magma", "2015-09-15 13:14:41", "2015-09-15 14:14:41", "80.8.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1051", "0", "magma", "2015-09-15 13:59:34", "2015-09-15 14:59:34", "94.21.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1052", "0", "magma", "2015-09-15 14:04:52", "2015-09-15 15:04:52", "92.87.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1053", "0", "magma", "2015-09-15 14:07:29", "2015-09-15 15:07:29", "42.115.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1054", "0", "magma", "2015-09-15 15:12:25", "2015-09-15 16:12:25", "85.238.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1055", "0", "magma", "2015-09-15 15:17:05", "2015-09-15 16:17:05", "120.28.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1056", "0", "magma", "2015-09-15 16:00:14", "2015-09-15 17:00:14", "188.135.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1057", "0", "magma", "2015-09-15 16:12:59", "2015-09-15 17:12:59", "89.138.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1058", "0", "magma", "2015-09-15 16:45:38", "2015-09-15 17:45:38", "117.222.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1059", "0", "magma", "2015-09-15 16:48:53", "2015-09-15 17:48:53", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1060", "0", "magma", "2015-09-15 16:55:16", "2015-09-15 17:55:16", "103.48.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1061", "0", "magma", "2015-09-15 17:15:18", "2015-09-15 18:15:18", "185.22.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1062", "0", "magma", "2015-09-15 18:06:49", "2015-09-15 19:06:49", "113.203.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1063", "0", "admin", "2015-09-15 18:21:59", "2015-09-15 19:21:59", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1064", "0", "admin", "2015-09-15 18:22:00", "2015-09-15 19:22:00", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1065", "0", "admin", "2015-09-15 18:22:00", "2015-09-15 19:22:00", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1066", "0", "admin", "2015-09-15 18:22:00", "2015-09-15 19:22:00", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1067", "0", "admin", "2015-09-15 18:22:10", "2015-09-15 19:22:10", "198.50.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1068", "0", "magma", "2015-09-15 19:16:55", "2015-09-15 20:16:55", "24.92.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1069", "0", "magma", "2015-09-15 19:37:32", "2015-09-15 20:37:32", "197.200.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1070", "0", "magma", "2015-09-15 20:31:24", "2015-09-15 21:31:24", "39.44.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1071", "0", "magma", "2015-09-15 21:04:28", "2015-09-15 22:04:28", "82.166.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1072", "0", "magma", "2015-09-15 22:42:10", "2015-09-15 23:42:10", "103.224.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1073", "0", "magma", "2015-09-16 00:07:03", "2015-09-16 01:07:03", "5.71.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1074", "0", "magma", "2015-09-16 01:27:19", "2015-09-16 02:27:19", "112.198.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1075", "0", "magma", "2015-09-16 02:21:50", "2015-09-16 03:21:50", "178.222.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1076", "0", "magma", "2015-09-16 03:30:57", "2015-09-16 04:30:57", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1077", "0", "magma", "2015-09-16 04:38:03", "2015-09-16 05:38:03", "196.207.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1078", "0", "admin", "2015-09-16 04:44:48", "2015-09-16 05:44:48", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1079", "0", "admin", "2015-09-16 04:44:48", "2015-09-16 05:44:48", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1080", "0", "admin", "2015-09-16 04:44:48", "2015-09-16 05:44:48", "46.182.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1081", "0", "admin", "2015-09-16 04:44:49", "2015-09-16 05:44:49", "96.47.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1082", "0", "admin", "2015-09-16 04:45:04", "2015-09-16 05:45:04", "87.98.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1083", "0", "magma", "2015-09-16 04:50:11", "2015-09-16 05:50:11", "188.173.255.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1084", "0", "magma", "2015-09-16 05:08:01", "2015-09-16 06:08:01", "46.40.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1085", "0", "magma", "2015-09-16 06:26:39", "2015-09-16 07:26:39", "1.52.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1086", "0", "magma", "2015-09-16 08:21:27", "2015-09-16 09:21:27", "197.221.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1087", "0", "magma", "2015-09-16 08:54:28", "2015-09-16 09:54:28", "46.107.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1088", "0", "magma", "2015-09-16 10:02:11", "2015-09-16 11:02:11", "118.136.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1089", "0", "magma", "2015-09-16 11:23:58", "2015-09-16 12:23:58", "5.55.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1090", "0", "magma", "2015-09-16 12:46:37", "2015-09-16 13:46:37", "14.192.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1091", "0", "magma", "2015-09-16 13:03:12", "2015-09-16 14:03:12", "178.220.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1092", "0", "magma", "2015-09-16 13:19:14", "2015-09-16 14:19:14", "94.21.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1093", "0", "magma", "2015-09-16 13:31:17", "2015-09-16 14:31:17", "5.178.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1094", "0", "magma", "2015-09-16 13:45:52", "2015-09-16 14:45:52", "91.206.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1095", "0", "magma", "2015-09-16 14:12:52", "2015-09-16 15:12:52", "89.42.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1096", "0", "magma", "2015-09-16 15:02:09", "2015-09-16 16:02:09", "92.82.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1097", "0", "admin", "2015-09-16 15:10:26", "2015-09-16 16:10:26", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1098", "0", "admin", "2015-09-16 15:10:27", "2015-09-16 16:10:27", "209.222.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1099", "0", "admin", "2015-09-16 15:10:28", "2015-09-16 16:10:28", "69.172.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1100", "0", "admin", "2015-09-16 15:10:29", "2015-09-16 16:10:29", "142.4.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1101", "0", "admin", "2015-09-16 15:10:29", "2015-09-16 16:10:29", "46.165.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1102", "0", "magma", "2015-09-16 17:59:27", "2015-09-16 18:59:27", "195.12.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1103", "0", "magma", "2015-09-16 18:30:29", "2015-09-16 19:30:29", "190.98.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1104", "0", "magma", "2015-09-16 19:00:30", "2015-09-16 20:00:30", "77.221.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1105", "0", "magma", "2015-09-16 19:13:22", "2015-09-16 20:13:22", "197.162.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1106", "0", "magma", "2015-09-16 20:24:50", "2015-09-16 21:24:50", "78.141.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1107", "0", "magma", "2015-09-16 21:20:53", "2015-09-16 22:20:53", "41.140.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1108", "0", "magma", "2015-09-16 21:56:51", "2015-09-16 22:56:51", "178.150.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1109", "0", "magma", "2015-09-16 22:12:25", "2015-09-16 23:12:25", "39.42.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1110", "0", "admin", "2015-09-17 02:19:31", "2015-09-17 03:19:31", "199.127.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1111", "0", "admin", "2015-09-17 02:19:31", "2015-09-17 03:19:31", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1112", "0", "admin", "2015-09-17 02:19:32", "2015-09-17 03:19:32", "93.115.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1113", "0", "admin", "2015-09-17 02:19:32", "2015-09-17 03:19:32", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1114", "0", "admin", "2015-09-17 02:19:35", "2015-09-17 03:19:35", "46.165.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1115", "0", "magma", "2015-09-17 06:19:43", "2015-09-17 07:19:43", "49.204.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1116", "0", "magma", "2015-09-17 07:44:45", "2015-09-17 08:44:45", "197.88.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1117", "0", "magma", "2015-09-17 08:29:00", "2015-09-17 09:29:00", "210.4.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1118", "0", "magma", "2015-09-17 08:58:05", "2015-09-17 09:58:05", "193.188.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1119", "0", "magma", "2015-09-17 09:45:15", "2015-09-17 10:45:15", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1120", "0", "magma", "2015-09-17 10:02:43", "2015-09-17 11:02:43", "59.161.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1121", "0", "magma", "2015-09-17 10:12:06", "2015-09-17 11:12:06", "31.154.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1122", "0", "magma", "2015-09-17 10:20:10", "2015-09-17 11:20:10", "83.50.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1123", "0", "magma", "2015-09-17 11:46:14", "2015-09-17 12:46:14", "185.82.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1124", "0", "magma", "2015-09-17 12:06:46", "2015-09-17 13:06:46", "89.215.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1125", "0", "admin", "2015-09-17 12:23:39", "2015-09-17 13:23:39", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1126", "0", "magma", "2015-09-17 13:48:14", "2015-09-17 14:48:14", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1127", "0", "magma", "2015-09-17 14:12:34", "2015-09-17 15:12:34", "60.54.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1128", "0", "magma", "2015-09-17 14:47:31", "2015-09-17 15:47:31", "200.153.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1129", "0", "magma", "2015-09-17 15:20:34", "2015-09-17 16:20:34", "152.118.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1130", "0", "magma", "2015-09-17 15:24:36", "2015-09-17 16:24:36", "109.101.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1131", "0", "magma", "2015-09-17 16:04:41", "2015-09-17 17:04:41", "117.200.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1132", "0", "magma", "2015-09-17 17:03:57", "2015-09-17 18:03:57", "81.196.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1133", "0", "magma", "2015-09-17 18:07:47", "2015-09-17 19:07:47", "5.97.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1134", "0", "magma", "2015-09-17 18:35:13", "2015-09-17 19:35:13", "41.67.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1135", "0", "magma", "2015-09-17 18:39:51", "2015-09-17 19:39:51", "31.215.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1136", "0", "magma", "2015-09-17 19:22:47", "2015-09-17 20:22:47", "94.21.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1137", "0", "magma", "2015-09-17 19:33:42", "2015-09-17 20:33:42", "39.59.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1138", "0", "magma", "2015-09-17 19:58:53", "2015-09-17 20:58:53", "223.223.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1139", "0", "magma", "2015-09-17 21:36:19", "2015-09-17 22:36:19", "2.50.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1140", "0", "admin", "2015-09-17 21:36:20", "2015-09-17 22:36:20", "94.142.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1141", "0", "admin", "2015-09-17 21:36:21", "2015-09-17 22:36:21", "109.163.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1142", "0", "magma", "2015-09-17 23:16:43", "2015-09-18 00:16:43", "94.132.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1143", "0", "magma", "2015-09-18 00:28:59", "2015-09-18 01:28:59", "41.223.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1144", "0", "magma", "2015-09-18 00:50:09", "2015-09-18 01:50:09", "188.2.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1145", "0", "magma", "2015-09-18 02:22:56", "2015-09-18 03:22:56", "178.67.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1146", "0", "magma", "2015-09-18 04:38:09", "2015-09-18 05:38:09", "37.237.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1147", "0", "magma", "2015-09-18 05:12:25", "2015-09-18 06:12:25", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1148", "0", "magma", "2015-09-18 05:37:19", "2015-09-18 06:37:19", "31.215.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1149", "0", "admin", "2015-09-18 06:19:41", "2015-09-18 07:19:41", "62.212.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1150", "0", "admin", "2015-09-18 06:19:41", "2015-09-18 07:19:41", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1151", "0", "magma", "2015-09-18 08:22:53", "2015-09-18 09:22:53", "78.167.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1152", "0", "magma", "2015-09-18 10:11:59", "2015-09-18 11:11:59", "119.74.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1153", "0", "magma", "2015-09-18 12:14:20", "2015-09-18 13:14:20", "5.107.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1154", "0", "magma", "2015-09-18 12:41:39", "2015-09-18 13:41:39", "78.182.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1155", "0", "magma", "2015-09-18 13:27:04", "2015-09-18 14:27:04", "89.39.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1156", "0", "magma", "2015-09-18 14:23:49", "2015-09-18 15:23:49", "95.61.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1157", "0", "magma", "2015-09-18 15:07:31", "2015-09-18 16:07:31", "93.145.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1158", "0", "magma", "2015-09-18 15:07:54", "2015-09-18 16:07:54", "118.136.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1159", "0", "magma", "2015-09-18 16:51:27", "2015-09-18 17:51:27", "39.58.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1160", "0", "magma", "2015-09-18 17:55:25", "2015-09-18 18:55:25", "223.223.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1161", "0", "magma", "2015-09-18 18:42:45", "2015-09-18 19:42:45", "178.164.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1162", "0", "magma", "2015-09-18 18:53:44", "2015-09-18 19:53:44", "113.203.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1163", "0", "magma", "2015-09-18 19:39:08", "2015-09-18 20:39:08", "177.18.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1164", "0", "magma", "2015-09-18 19:54:37", "2015-09-18 20:54:37", "182.185.26.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1165", "0", "magma", "2015-09-18 21:22:37", "2015-09-18 22:22:37", "197.200.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1166", "0", "admin8568", "2015-09-18 21:28:13", "2015-09-18 22:28:13", "196.210.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1167", "0", "magma", "2015-09-18 21:52:14", "2015-09-18 22:52:14", "92.83.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1168", "0", "magma", "2015-09-18 22:27:36", "2015-09-18 23:27:36", "79.119.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1169", "0", "magma", "2015-09-18 22:30:04", "2015-09-18 23:30:04", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1170", "0", "magma", "2015-09-18 22:52:50", "2015-09-18 23:52:50", "95.76.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1171", "0", "magma", "2015-09-18 23:06:56", "2015-09-19 00:06:56", "27.147.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1172", "0", "magma", "2015-09-19 00:14:13", "2015-09-19 01:14:13", "31.215.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1173", "0", "magma", "2015-09-19 00:41:13", "2015-09-19 01:41:13", "181.59.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1174", "0", "magma", "2015-09-19 00:47:40", "2015-09-19 01:47:40", "188.25.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1175", "0", "magma", "2015-09-19 01:03:11", "2015-09-19 02:03:11", "189.5.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1176", "0", "magma", "2015-09-19 01:07:26", "2015-09-19 02:07:26", "188.36.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1177", "0", "magma", "2015-09-19 02:04:27", "2015-09-19 03:04:27", "5.228.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1178", "0", "magma", "2015-09-19 03:18:43", "2015-09-19 04:18:43", "178.220.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1179", "0", "magma", "2015-09-19 05:11:01", "2015-09-19 06:11:01", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1180", "0", "magma", "2015-09-19 06:29:48", "2015-09-19 07:29:48", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1181", "0", "magma", "2015-09-19 06:55:59", "2015-09-19 07:55:59", "203.112.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1182", "0", "magma", "2015-09-19 07:52:57", "2015-09-19 08:52:57", "122.3.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1183", "0", "magma", "2015-09-19 10:11:59", "2015-09-19 11:11:59", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1184", "0", "magma", "2015-09-19 10:59:16", "2015-09-19 11:59:16", "117.248.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1185", "0", "magma", "2015-09-19 11:40:54", "2015-09-19 12:40:54", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1186", "0", "magma", "2015-09-19 11:46:19", "2015-09-19 12:46:19", "115.76.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1187", "0", "magma", "2015-09-19 12:00:39", "2015-09-19 13:00:39", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1188", "0", "magma", "2015-09-19 12:21:55", "2015-09-19 13:21:55", "31.14.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1189", "0", "magma", "2015-09-19 12:57:28", "2015-09-19 13:57:28", "114.77.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1190", "0", "magma", "2015-09-19 13:09:33", "2015-09-19 14:09:33", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1191", "0", "magma", "2015-09-19 13:18:25", "2015-09-19 14:18:25", "178.234.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1192", "0", "magma", "2015-09-19 13:22:16", "2015-09-19 14:22:16", "133.209.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1193", "0", "magma", "2015-09-19 13:41:32", "2015-09-19 14:41:32", "41.228.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1194", "0", "magma", "2015-09-19 13:57:25", "2015-09-19 14:57:25", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1195", "0", "magma", "2015-09-19 15:08:41", "2015-09-19 16:08:41", "87.68.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1196", "0", "magma", "2015-09-19 16:43:06", "2015-09-19 17:43:06", "89.42.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1197", "0", "magma", "2015-09-19 16:53:21", "2015-09-19 17:53:21", "86.99.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1198", "0", "magma", "2015-09-19 17:04:51", "2015-09-19 18:04:51", "1.1.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1199", "0", "magma", "2015-09-19 17:13:01", "2015-09-19 18:13:01", "178.67.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1200", "0", "magma", "2015-09-19 17:36:10", "2015-09-19 18:36:10", "176.73.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1201", "0", "magma", "2015-09-19 18:30:50", "2015-09-19 19:30:50", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1202", "0", "magma", "2015-09-19 18:47:14", "2015-09-19 19:47:14", "5.14.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1203", "0", "magma", "2015-09-19 20:07:22", "2015-09-19 21:07:22", "180.191.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1204", "0", "magma", "2015-09-19 22:09:59", "2015-09-19 23:09:59", "181.59.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1205", "0", "magma", "2015-09-19 22:12:06", "2015-09-19 23:12:06", "103.252.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1206", "0", "magma", "2015-09-19 22:29:34", "2015-09-19 23:29:34", "46.121.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1207", "0", "magma", "2015-09-19 23:11:39", "2015-09-20 00:11:39", "78.29.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1208", "0", "magma", "2015-09-19 23:15:51", "2015-09-20 00:15:51", "77.36.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1209", "0", "magma", "2015-09-19 23:35:14", "2015-09-20 00:35:14", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1210", "0", "magma", "2015-09-20 01:14:34", "2015-09-20 02:14:34", "178.220.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1211", "0", "magma", "2015-09-20 01:17:09", "2015-09-20 02:17:09", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1212", "0", "magma", "2015-09-20 01:46:07", "2015-09-20 02:46:07", "112.134.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1213", "0", "magma", "2015-09-20 06:17:26", "2015-09-20 07:17:26", "41.67.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1214", "0", "magma", "2015-09-20 10:52:45", "2015-09-20 11:52:45", "178.164.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1215", "0", "magma", "2015-09-20 10:57:09", "2015-09-20 11:57:09", "176.109.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1216", "0", "magma", "2015-09-20 13:15:09", "2015-09-20 14:15:09", "89.35.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1217", "0", "magma", "2015-09-20 14:09:14", "2015-09-20 15:09:14", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1218", "0", "magma", "2015-09-20 14:26:33", "2015-09-20 15:26:33", "89.42.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1219", "0", "magma", "2015-09-20 15:02:00", "2015-09-20 16:02:00", "31.154.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1220", "0", "magma", "2015-09-20 17:45:48", "2015-09-20 18:45:48", "176.106.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1221", "0", "magma", "2015-09-20 17:57:39", "2015-09-20 18:57:39", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1222", "0", "magma", "2015-09-20 18:03:16", "2015-09-20 19:03:16", "41.100.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1223", "0", "magma", "2015-09-20 18:33:58", "2015-09-20 19:33:58", "42.201.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1224", "0", "magma", "2015-09-20 19:36:48", "2015-09-20 20:36:48", "82.166.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1225", "0", "magma", "2015-09-20 19:59:59", "2015-09-20 20:59:59", "41.226.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1226", "0", "magma", "2015-09-20 20:08:55", "2015-09-20 21:08:55", "146.255.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1227", "0", "magma", "2015-09-20 21:11:05", "2015-09-20 22:11:05", "31.11.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1228", "0", "magma", "2015-09-20 21:20:06", "2015-09-20 22:20:06", "77.239.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1229", "0", "magma", "2015-09-20 22:05:44", "2015-09-20 23:05:44", "178.220.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1230", "0", "magma", "2015-09-20 22:08:56", "2015-09-20 23:08:56", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1231", "0", "magma", "2015-09-20 22:40:39", "2015-09-20 23:40:39", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1232", "0", "magma", "2015-09-20 22:45:22", "2015-09-20 23:45:22", "31.185.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1233", "0", "magma", "2015-09-20 23:08:01", "2015-09-21 00:08:01", "176.106.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1234", "0", "magma", "2015-09-21 00:22:46", "2015-09-21 01:22:46", "190.75.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1235", "0", "magma", "2015-09-21 03:22:36", "2015-09-21 04:22:36", "186.121.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1236", "0", "magma", "2015-09-21 05:52:20", "2015-09-21 06:52:20", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1237", "0", "magma", "2015-09-21 07:44:02", "2015-09-21 08:44:02", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1238", "0", "magma", "2015-09-21 08:40:43", "2015-09-21 09:40:43", "117.222.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1239", "0", "magma", "2015-09-21 09:10:46", "2015-09-21 10:10:46", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1240", "0", "magma", "2015-09-21 11:47:26", "2015-09-21 12:47:26", "197.157.255.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1241", "0", "magma", "2015-09-21 12:07:29", "2015-09-21 13:07:29", "39.50.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1242", "0", "magma", "2015-09-21 12:28:32", "2015-09-21 13:28:32", "190.45.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1243", "1", "admin8576", "2015-09-21 12:36:09", "2015-09-21 13:36:09", "52.24.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1244", "0", "magma", "2015-09-21 13:18:16", "2015-09-21 14:18:16", "182.185.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1245", "0", "magma", "2015-09-21 14:16:53", "2015-09-21 15:16:53", "121.99.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1246", "0", "magma", "2015-09-21 14:41:17", "2015-09-21 15:41:17", "46.197.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1247", "0", "magma", "2015-09-21 15:14:47", "2015-09-21 16:14:47", "2.49.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1248", "0", "magma", "2015-09-21 15:49:52", "2015-09-21 16:49:52", "110.227.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1249", "0", "magma", "2015-09-21 15:56:14", "2015-09-21 16:56:14", "89.121.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1250", "0", "magma", "2015-09-21 16:04:55", "2015-09-21 17:04:55", "49.145.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1251", "0", "magma", "2015-09-21 16:36:03", "2015-09-21 17:36:03", "78.182.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1252", "0", "magma", "2015-09-21 17:14:06", "2015-09-21 18:14:06", "114.134.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1253", "0", "magma", "2015-09-21 17:47:17", "2015-09-21 18:47:17", "188.36.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1254", "0", "magma", "2015-09-21 18:52:57", "2015-09-21 19:52:57", "88.247.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1255", "0", "magma", "2015-09-21 19:01:10", "2015-09-21 20:01:10", "37.27.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1256", "0", "magma", "2015-09-21 19:17:10", "2015-09-21 20:17:10", "175.142.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1257", "0", "magma", "2015-09-21 19:58:07", "2015-09-21 20:58:07", "79.126.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1258", "0", "magma", "2015-09-21 20:24:04", "2015-09-21 21:24:04", "146.255.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1259", "0", "magma", "2015-09-21 20:51:20", "2015-09-21 21:51:20", "79.112.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1260", "0", "magma", "2015-09-21 21:21:03", "2015-09-21 22:21:03", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1261", "0", "magma", "2015-09-21 21:31:01", "2015-09-21 22:31:01", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1262", "0", "magma", "2015-09-21 22:05:08", "2015-09-21 23:05:08", "114.134.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1263", "0", "magma", "2015-09-21 22:11:44", "2015-09-21 23:11:44", "81.244.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1264", "0", "magma", "2015-09-21 23:33:04", "2015-09-22 00:33:04", "1.52.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1265", "0", "magma", "2015-09-22 00:04:46", "2015-09-22 01:04:46", "176.41.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1266", "0", "magma", "2015-09-22 04:06:53", "2015-09-22 05:06:53", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1267", "0", "magma", "2015-09-22 04:07:46", "2015-09-22 05:07:46", "31.154.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1268", "0", "magma", "2015-09-22 07:41:44", "2015-09-22 08:41:44", "178.222.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1269", "0", "magma", "2015-09-22 10:08:42", "2015-09-22 11:08:42", "188.143.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1270", "0", "magma", "2015-09-22 11:07:17", "2015-09-22 12:07:17", "95.180.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1271", "0", "magma", "2015-09-22 12:36:37", "2015-09-22 13:36:37", "109.94.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1272", "0", "admin", "2015-09-22 14:40:35", "2015-09-22 15:40:35", "178.16.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1273", "0", "magma", "2015-09-22 14:56:03", "2015-09-22 15:56:03", "139.195.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1274", "0", "magma", "2015-09-22 15:17:23", "2015-09-22 16:17:23", "188.6.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1275", "0", "magma", "2015-09-22 15:29:02", "2015-09-22 16:29:02", "1.1.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1276", "0", "magma", "2015-09-22 16:26:02", "2015-09-22 17:26:02", "79.178.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1277", "0", "magma", "2015-09-22 16:31:03", "2015-09-22 17:31:03", "195.146.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1278", "0", "magma", "2015-09-22 17:09:04", "2015-09-22 18:09:04", "190.98.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1279", "0", "magma", "2015-09-22 17:10:27", "2015-09-22 18:10:27", "39.50.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1280", "0", "magma", "2015-09-22 17:17:22", "2015-09-22 18:17:22", "79.191.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1281", "0", "admin", "2015-09-22 18:00:31", "2015-09-22 19:00:31", "5.9.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1282", "0", "admin", "2015-09-22 18:00:32", "2015-09-22 19:00:32", "96.44.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1283", "0", "magma", "2015-09-22 18:47:19", "2015-09-22 19:47:19", "94.132.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1284", "0", "magma", "2015-09-22 18:53:54", "2015-09-22 19:53:54", "88.247.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1285", "0", "magma", "2015-09-22 19:06:02", "2015-09-22 20:06:02", "5.228.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1286", "0", "magma", "2015-09-22 19:27:34", "2015-09-22 20:27:34", "79.112.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1287", "0", "magma", "2015-09-22 20:26:14", "2015-09-22 21:26:14", "78.56.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1288", "0", "magma", "2015-09-22 20:50:05", "2015-09-22 21:50:05", "46.197.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1289", "0", "magma", "2015-09-22 21:13:50", "2015-09-22 22:13:50", "89.41.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1290", "0", "admin", "2015-09-22 21:20:06", "2015-09-22 22:20:06", "185.17.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1291", "0", "admin", "2015-09-22 21:20:15", "2015-09-22 22:20:15", "37.157.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1292", "0", "magma", "2015-09-23 00:58:37", "2015-09-23 01:58:37", "177.39.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1293", "0", "magma", "2015-09-23 01:44:18", "2015-09-23 02:44:18", "197.200.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1294", "0", "admin", "2015-09-23 02:30:04", "2015-09-23 03:30:04", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1295", "0", "magma", "2015-09-23 03:21:07", "2015-09-23 04:21:07", "192.0.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1296", "0", "magma", "2015-09-23 04:05:05", "2015-09-23 05:05:05", "179.192.155.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1297", "0", "magma", "2015-09-23 04:54:35", "2015-09-23 05:54:35", "114.77.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1298", "0", "admin", "2015-09-23 05:35:01", "2015-09-23 06:35:01", "188.138.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1299", "0", "admin", "2015-09-23 05:35:01", "2015-09-23 06:35:01", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1300", "1", "admin8576", "2015-09-23 06:08:55", "2015-09-23 07:08:55", "173.254.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1301", "0", "magma", "2015-09-23 06:19:17", "2015-09-23 07:19:17", "117.214.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1302", "0", "admin", "2015-09-23 09:02:48", "2015-09-23 10:02:48", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1303", "0", "admin", "2015-09-23 09:02:48", "2015-09-23 10:02:48", "5.255.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1304", "0", "magma", "2015-09-23 09:43:17", "2015-09-23 10:43:17", "119.94.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1305", "0", "magma", "2015-09-23 10:57:39", "2015-09-23 11:57:39", "176.106.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1306", "0", "magma", "2015-09-23 11:25:10", "2015-09-23 12:25:10", "37.0.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1307", "0", "magma", "2015-09-23 11:48:45", "2015-09-23 12:48:45", "81.196.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1308", "0", "magma", "2015-09-23 12:23:40", "2015-09-23 13:23:40", "190.147.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1309", "0", "magma", "2015-09-23 13:00:27", "2015-09-23 14:00:27", "78.169.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1310", "0", "magma", "2015-09-23 13:12:05", "2015-09-23 14:12:05", "213.197.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1311", "0", "admin", "2015-09-23 15:07:13", "2015-09-23 16:07:13", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1312", "0", "magma", "2015-09-23 15:13:22", "2015-09-23 16:13:22", "117.248.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1313", "0", "magma", "2015-09-23 15:17:32", "2015-09-23 16:17:32", "109.92.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1314", "0", "magma", "2015-09-23 15:30:48", "2015-09-23 16:30:48", "83.168.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1315", "0", "magma", "2015-09-23 15:40:08", "2015-09-23 16:40:08", "49.144.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1316", "0", "magma", "2015-09-23 16:01:27", "2015-09-23 17:01:27", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1317", "0", "magma", "2015-09-23 16:06:02", "2015-09-23 17:06:02", "88.201.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1318", "0", "magma", "2015-09-23 16:40:53", "2015-09-23 17:40:53", "188.25.250.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1319", "0", "magma", "2015-09-23 17:34:20", "2015-09-23 18:34:20", "186.16.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1320", "0", "magma", "2015-09-23 18:06:48", "2015-09-23 19:06:48", "176.40.169.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1321", "0", "admin", "2015-09-23 18:49:46", "2015-09-23 19:49:46", "79.98.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1322", "0", "admin", "2015-09-23 18:49:46", "2015-09-23 19:49:46", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1323", "0", "magma", "2015-09-23 19:16:33", "2015-09-23 20:16:33", "178.79.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1324", "0", "magma", "2015-09-23 21:04:36", "2015-09-23 22:04:36", "95.92.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1325", "0", "magma", "2015-09-23 21:27:07", "2015-09-23 22:27:07", "62.209.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1326", "0", "magma", "2015-09-23 21:30:17", "2015-09-23 22:30:17", "146.255.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1327", "0", "admin", "2015-09-23 22:31:00", "2015-09-23 23:31:00", "5.9.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1328", "0", "admin", "2015-09-23 22:31:01", "2015-09-23 23:31:01", "185.11.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1329", "0", "magma", "2015-09-23 22:50:15", "2015-09-23 23:50:15", "141.85.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1330", "0", "magma", "2015-09-23 23:22:37", "2015-09-24 00:22:37", "82.146.26.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1331", "0", "magma", "2015-09-23 23:24:15", "2015-09-24 00:24:15", "189.5.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1332", "0", "magma", "2015-09-24 00:11:48", "2015-09-24 01:11:48", "77.235.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1333", "0", "magma", "2015-09-24 01:14:43", "2015-09-24 02:14:43", "83.168.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1334", "0", "admin", "2015-09-24 04:44:40", "2015-09-24 05:44:40", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1335", "0", "admin", "2015-09-24 08:08:51", "2015-09-24 09:08:51", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1336", "0", "admin", "2015-09-24 08:08:57", "2015-09-24 09:08:57", "50.7.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1337", "0", "magma", "2015-09-24 09:24:50", "2015-09-24 10:24:50", "212.235.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1338", "0", "magma", "2015-09-24 09:38:28", "2015-09-24 10:38:28", "60.49.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1339", "0", "magma", "2015-09-24 11:42:09", "2015-09-24 12:42:09", "81.182.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1340", "0", "admin", "2015-09-24 12:07:05", "2015-09-24 13:07:05", "5.79.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1341", "0", "admin", "2015-09-24 12:07:05", "2015-09-24 13:07:05", "199.87.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1342", "0", "magma", "2015-09-24 13:44:19", "2015-09-24 14:44:19", "83.50.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1343", "0", "magma", "2015-09-24 14:56:42", "2015-09-24 15:56:42", "120.28.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1344", "0", "magma", "2015-09-24 15:36:08", "2015-09-24 16:36:08", "95.92.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1345", "0", "magma", "2015-09-24 17:11:19", "2015-09-24 18:11:19", "41.182.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1346", "0", "magma", "2015-09-24 17:54:34", "2015-09-24 18:54:34", "197.38.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1347", "0", "admin", "2015-09-24 18:59:14", "2015-09-24 19:59:14", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1348", "0", "magma", "2015-09-24 19:00:34", "2015-09-24 20:00:34", "197.200.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1349", "0", "magma", "2015-09-24 20:06:03", "2015-09-24 21:06:03", "84.0.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1350", "0", "magma", "2015-09-24 20:58:05", "2015-09-24 21:58:05", "109.98.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1351", "0", "magma", "2015-09-24 22:32:31", "2015-09-24 23:32:31", "46.11.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1352", "0", "magma", "2015-09-24 22:45:06", "2015-09-24 23:45:06", "128.243.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1353", "0", "magma", "2015-09-24 22:50:04", "2015-09-24 23:50:04", "62.219.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1354", "0", "admin", "2015-09-24 22:53:36", "2015-09-24 23:53:36", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1355", "0", "admin", "2015-09-24 22:53:36", "2015-09-24 23:53:36", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1356", "0", "magma", "2015-09-24 23:29:00", "2015-09-25 00:29:00", "85.120.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1357", "0", "magma", "2015-09-24 23:45:57", "2015-09-25 00:45:57", "49.150.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1358", "0", "magma", "2015-09-25 00:12:23", "2015-09-25 01:12:23", "5.238.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1359", "0", "magma", "2015-09-25 01:06:33", "2015-09-25 02:06:33", "46.217.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1360", "0", "magma", "2015-09-25 01:12:24", "2015-09-25 02:12:24", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1361", "0", "magma", "2015-09-25 01:28:52", "2015-09-25 02:28:52", "187.114.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1362", "0", "magma", "2015-09-25 02:27:19", "2015-09-25 03:27:19", "217.129.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1363", "0", "magma", "2015-09-25 02:33:45", "2015-09-25 03:33:45", "179.42.176.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1364", "0", "magma", "2015-09-25 02:39:41", "2015-09-25 03:39:41", "107.133.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1365", "0", "admin", "2015-09-25 02:57:32", "2015-09-25 03:57:32", "50.7.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1366", "0", "admin", "2015-09-25 02:57:39", "2015-09-25 03:57:39", "185.24.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1367", "0", "magma", "2015-09-25 03:30:50", "2015-09-25 04:30:50", "85.250.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1368", "0", "magma", "2015-09-25 04:28:09", "2015-09-25 05:28:09", "5.55.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1369", "0", "magma", "2015-09-25 05:09:56", "2015-09-25 06:09:56", "200.82.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1370", "0", "magma", "2015-09-25 08:08:36", "2015-09-25 09:08:36", "114.165.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1371", "0", "magma", "2015-09-25 09:11:33", "2015-09-25 10:11:33", "93.86.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1372", "0", "magma", "2015-09-25 09:35:40", "2015-09-25 10:35:40", "81.196.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1373", "0", "admin", "2015-09-25 09:41:22", "2015-09-25 10:41:22", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1374", "0", "magma", "2015-09-25 10:52:34", "2015-09-25 11:52:34", "61.0.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1375", "0", "magma", "2015-09-25 10:55:06", "2015-09-25 11:55:06", "121.98.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1376", "0", "magma", "2015-09-25 12:00:56", "2015-09-25 13:00:56", "88.201.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1377", "0", "magma", "2015-09-25 12:33:56", "2015-09-25 13:33:56", "125.212.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1378", "0", "magma", "2015-09-25 12:34:32", "2015-09-25 13:34:32", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1379", "0", "magma", "2015-09-25 12:56:20", "2015-09-25 13:56:20", "46.107.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1380", "0", "admin", "2015-09-25 13:22:03", "2015-09-25 14:22:03", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1381", "0", "admin", "2015-09-25 13:22:12", "2015-09-25 14:22:12", "5.79.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1382", "0", "magma", "2015-09-25 13:27:57", "2015-09-25 14:27:57", "178.42.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1383", "0", "magma", "2015-09-25 13:35:39", "2015-09-25 14:35:39", "109.92.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1384", "0", "magma", "2015-09-25 13:50:41", "2015-09-25 14:50:41", "125.18.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1385", "0", "magma", "2015-09-25 14:56:50", "2015-09-25 15:56:50", "84.0.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1386", "0", "magma", "2015-09-25 15:17:44", "2015-09-25 16:17:44", "82.31.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1387", "0", "magma", "2015-09-25 16:13:14", "2015-09-25 17:13:14", "178.67.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1388", "0", "magma", "2015-09-25 16:14:05", "2015-09-25 17:14:05", "178.222.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1389", "0", "magma", "2015-09-25 16:26:44", "2015-09-25 17:26:44", "77.38.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1390", "0", "magma", "2015-09-25 16:51:37", "2015-09-25 17:51:37", "92.87.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1391", "0", "magma", "2015-09-25 17:16:36", "2015-09-25 18:16:36", "178.220.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1392", "0", "magma", "2015-09-25 17:23:47", "2015-09-25 18:23:47", "49.148.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1393", "0", "magma", "2015-09-25 17:25:45", "2015-09-25 18:25:45", "176.12.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1394", "0", "admin", "2015-09-25 17:47:00", "2015-09-25 18:47:00", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1395", "0", "admin", "2015-09-25 17:47:03", "2015-09-25 18:47:03", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1396", "0", "magma", "2015-09-25 18:09:57", "2015-09-25 19:09:57", "77.36.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1397", "0", "magma", "2015-09-25 18:26:46", "2015-09-25 19:26:46", "197.89.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1398", "0", "magma", "2015-09-25 18:50:54", "2015-09-25 19:50:54", "200.82.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1399", "0", "magma", "2015-09-25 18:52:53", "2015-09-25 19:52:53", "178.222.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1400", "0", "magma", "2015-09-25 19:01:39", "2015-09-25 20:01:39", "37.78.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1401", "0", "magma", "2015-09-25 19:03:50", "2015-09-25 20:03:50", "109.102.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1402", "0", "magma", "2015-09-25 20:14:22", "2015-09-25 21:14:22", "82.79.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1403", "0", "magma", "2015-09-25 20:28:43", "2015-09-25 21:28:43", "92.81.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1404", "0", "magma", "2015-09-25 22:03:17", "2015-09-25 23:03:17", "86.7.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1405", "0", "magma", "2015-09-25 22:07:29", "2015-09-25 23:07:29", "200.90.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1406", "0", "magma", "2015-09-25 23:43:57", "2015-09-26 00:43:57", "201.68.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1407", "0", "magma", "2015-09-26 00:49:25", "2015-09-26 01:49:25", "105.103.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1408", "0", "admin", "2015-09-26 01:08:00", "2015-09-26 02:08:00", "198.96.155.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1409", "0", "magma", "2015-09-26 01:16:10", "2015-09-26 02:16:10", "41.182.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1410", "0", "magma", "2015-09-26 03:02:41", "2015-09-26 04:02:41", "76.123.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1411", "0", "magma", "2015-09-26 04:29:42", "2015-09-26 05:29:42", "190.73.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1412", "0", "admin", "2015-09-26 04:35:04", "2015-09-26 05:35:04", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1413", "0", "admin", "2015-09-26 04:35:05", "2015-09-26 05:35:05", "82.221.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1414", "0", "magma", "2015-09-26 05:13:19", "2015-09-26 06:13:19", "153.175.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1415", "0", "magma", "2015-09-26 05:16:32", "2015-09-26 06:16:32", "86.25.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1416", "0", "magma", "2015-09-26 05:21:00", "2015-09-26 06:21:00", "200.54.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1417", "0", "magma", "2015-09-26 07:11:34", "2015-09-26 08:11:34", "200.90.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1418", "0", "magma", "2015-09-26 08:46:38", "2015-09-26 09:46:38", "31.11.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1419", "0", "admin", "2015-09-26 08:59:12", "2015-09-26 09:59:12", "193.111.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1420", "0", "admin", "2015-09-26 08:59:13", "2015-09-26 09:59:13", "198.23.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1421", "0", "magma", "2015-09-26 09:20:23", "2015-09-26 10:20:23", "109.77.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1422", "0", "magma", "2015-09-26 09:22:48", "2015-09-26 10:22:48", "183.91.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1423", "0", "magma", "2015-09-26 10:23:31", "2015-09-26 11:23:31", "95.21.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1424", "0", "magma", "2015-09-26 10:24:53", "2015-09-26 11:24:53", "115.99.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1425", "0", "magma", "2015-09-26 10:39:59", "2015-09-26 11:39:59", "176.106.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1426", "0", "magma", "2015-09-26 12:25:51", "2015-09-26 13:25:51", "86.38.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1427", "0", "magma", "2015-09-26 12:36:20", "2015-09-26 13:36:20", "77.238.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1428", "0", "magma", "2015-09-26 13:44:11", "2015-09-26 14:44:11", "46.252.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1429", "0", "magma", "2015-09-26 14:03:01", "2015-09-26 15:03:01", "80.242.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1430", "0", "magma", "2015-09-26 14:09:14", "2015-09-26 15:09:14", "27.106.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1431", "0", "magma", "2015-09-26 14:10:22", "2015-09-26 15:10:22", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1432", "0", "magma", "2015-09-26 14:28:10", "2015-09-26 15:28:10", "112.211.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1433", "0", "magma", "2015-09-26 15:23:51", "2015-09-26 16:23:51", "174.97.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1434", "0", "magma", "2015-09-26 16:09:25", "2015-09-26 17:09:25", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1435", "0", "magma", "2015-09-26 16:24:22", "2015-09-26 17:24:22", "121.7.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1436", "0", "magma", "2015-09-26 16:49:27", "2015-09-26 17:49:27", "189.5.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1437", "0", "admin", "2015-09-26 17:02:47", "2015-09-26 18:02:47", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1438", "0", "magma", "2015-09-26 17:49:04", "2015-09-26 18:49:04", "109.93.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1439", "0", "magma", "2015-09-26 18:28:04", "2015-09-26 19:28:04", "89.39.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1440", "0", "magma", "2015-09-26 18:52:17", "2015-09-26 19:52:17", "82.166.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1441", "0", "magma", "2015-09-26 19:43:16", "2015-09-26 20:43:16", "178.220.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1442", "0", "magma", "2015-09-26 20:16:26", "2015-09-26 21:16:26", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1443", "0", "magma", "2015-09-26 20:46:06", "2015-09-26 21:46:06", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1444", "0", "magma", "2015-09-26 20:51:55", "2015-09-26 21:51:55", "122.3.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1445", "0", "magma", "2015-09-26 22:21:07", "2015-09-26 23:21:07", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1446", "0", "magma", "2015-09-26 22:28:50", "2015-09-26 23:28:50", "88.201.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1447", "0", "admin", "2015-09-27 00:50:55", "2015-09-27 01:50:55", "195.154.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1448", "0", "admin", "2015-09-27 00:50:55", "2015-09-27 01:50:55", "77.109.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1449", "0", "magma", "2015-09-27 02:46:29", "2015-09-27 03:46:29", "85.253.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1450", "0", "magma", "2015-09-27 03:33:17", "2015-09-27 04:33:17", "77.29.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1451", "0", "magma", "2015-09-27 05:25:47", "2015-09-27 06:25:47", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1452", "0", "magma", "2015-09-27 06:58:29", "2015-09-27 07:58:29", "98.177.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1453", "0", "magma", "2015-09-27 08:31:55", "2015-09-27 09:31:55", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1454", "0", "magma", "2015-09-27 12:20:05", "2015-09-27 13:20:05", "46.116.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1455", "0", "magma", "2015-09-27 13:25:01", "2015-09-27 14:25:01", "124.104.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1456", "0", "magma", "2015-09-27 13:58:39", "2015-09-27 14:58:39", "176.109.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1457", "0", "magma", "2015-09-27 15:12:47", "2015-09-27 16:12:47", "46.176.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1458", "0", "magma", "2015-09-27 16:48:56", "2015-09-27 17:48:56", "112.210.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1459", "0", "magma", "2015-09-27 17:02:22", "2015-09-27 18:02:22", "46.176.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1460", "0", "magma", "2015-09-27 17:06:03", "2015-09-27 18:06:03", "109.92.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1461", "0", "magma", "2015-09-27 17:23:09", "2015-09-27 18:23:09", "77.249.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1462", "0", "magma", "2015-09-27 17:24:11", "2015-09-27 18:24:11", "109.98.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1463", "0", "magma", "2015-09-27 17:53:23", "2015-09-27 18:53:23", "118.100.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1464", "0", "magma", "2015-09-27 19:02:19", "2015-09-27 20:02:19", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1465", "0", "magma", "2015-09-27 19:11:08", "2015-09-27 20:11:08", "89.164.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1466", "0", "magma", "2015-09-27 19:37:17", "2015-09-27 20:37:17", "95.86.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1467", "0", "magma", "2015-09-27 19:41:05", "2015-09-27 20:41:05", "93.103.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1468", "0", "magma", "2015-09-27 21:08:33", "2015-09-27 22:08:33", "5.228.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1469", "0", "magma", "2015-09-27 21:14:54", "2015-09-27 22:14:54", "189.176.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1470", "0", "magma", "2015-09-27 21:54:09", "2015-09-27 22:54:09", "95.76.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1471", "0", "magma", "2015-09-27 21:58:21", "2015-09-27 22:58:21", "83.83.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1472", "0", "magma", "2015-09-27 22:21:52", "2015-09-27 23:21:52", "188.2.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1473", "0", "magma", "2015-09-28 03:35:13", "2015-09-28 04:35:13", "109.92.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1474", "0", "magma", "2015-09-28 07:55:18", "2015-09-28 08:55:18", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1475", "0", "magma", "2015-09-28 09:38:58", "2015-09-28 10:38:58", "83.168.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1476", "0", "magma", "2015-09-28 10:54:45", "2015-09-28 11:54:45", "193.248.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1477", "0", "magma", "2015-09-28 13:04:43", "2015-09-28 14:04:43", "79.106.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1478", "0", "magma", "2015-09-28 15:01:29", "2015-09-28 16:01:29", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1479", "0", "magma", "2015-09-28 15:22:10", "2015-09-28 16:22:10", "109.245.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1480", "0", "magma", "2015-09-28 15:50:09", "2015-09-28 16:50:09", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1481", "0", "magma", "2015-09-28 16:04:40", "2015-09-28 17:04:40", "190.147.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1482", "0", "magma", "2015-09-28 16:47:01", "2015-09-28 17:47:01", "46.70.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1483", "0", "magma", "2015-09-28 17:01:45", "2015-09-28 18:01:45", "93.168.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1484", "0", "magma", "2015-09-28 17:50:24", "2015-09-28 18:50:24", "108.181.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1485", "0", "magma", "2015-09-28 18:11:06", "2015-09-28 19:11:06", "188.2.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1486", "0", "magma", "2015-09-28 18:31:38", "2015-09-28 19:31:38", "197.89.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1487", "0", "magma", "2015-09-28 19:18:22", "2015-09-28 20:18:22", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1488", "0", "magma", "2015-09-28 19:23:24", "2015-09-28 20:23:24", "42.60.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1489", "0", "magma", "2015-09-28 19:32:29", "2015-09-28 20:32:29", "24.92.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1490", "0", "magma", "2015-09-28 21:18:57", "2015-09-28 22:18:57", "95.170.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1491", "0", "magma", "2015-09-28 22:21:39", "2015-09-28 23:21:39", "95.76.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1492", "0", "magma", "2015-09-29 00:26:32", "2015-09-29 01:26:32", "115.135.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1493", "0", "magma", "2015-09-29 03:23:41", "2015-09-29 04:23:41", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1494", "0", "magma", "2015-09-29 03:38:37", "2015-09-29 04:38:37", "37.27.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1495", "0", "magma", "2015-09-29 03:42:56", "2015-09-29 04:42:56", "81.183.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1496", "0", "magma", "2015-09-29 04:58:41", "2015-09-29 05:58:41", "174.97.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1497", "0", "magma", "2015-09-29 06:25:30", "2015-09-29 07:25:30", "1.52.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1498", "0", "magma", "2015-09-29 06:26:29", "2015-09-29 07:26:29", "112.209.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1499", "0", "magma", "2015-09-29 07:37:20", "2015-09-29 08:37:20", "186.121.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1500", "0", "magma", "2015-09-29 10:21:09", "2015-09-29 11:21:09", "176.40.169.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1501", "0", "magma", "2015-09-29 10:50:05", "2015-09-29 11:50:05", "93.103.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1502", "0", "magma", "2015-09-29 11:01:44", "2015-09-29 12:01:44", "182.185.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1503", "0", "magma", "2015-09-29 11:37:11", "2015-09-29 12:37:11", "79.129.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1504", "0", "magma", "2015-09-29 12:10:51", "2015-09-29 13:10:51", "79.112.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1505", "0", "magma", "2015-09-29 12:55:25", "2015-09-29 13:55:25", "180.250.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1506", "0", "admin", "2015-09-29 13:03:43", "2015-09-29 14:03:43", "92.222.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1507", "0", "admin", "2015-09-29 14:48:00", "2015-09-29 15:48:00", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1508", "0", "magma", "2015-09-29 14:54:10", "2015-09-29 15:54:10", "89.121.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1509", "0", "magma", "2015-09-29 15:36:49", "2015-09-29 16:36:49", "1.32.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1510", "0", "admin", "2015-09-29 15:47:20", "2015-09-29 16:47:20", "5.9.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1511", "0", "magma", "2015-09-29 16:10:39", "2015-09-29 17:10:39", "118.101.26.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1512", "0", "magma", "2015-09-29 16:22:06", "2015-09-29 17:22:06", "82.231.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1513", "0", "magma", "2015-09-29 16:50:38", "2015-09-29 17:50:38", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1514", "0", "magma", "2015-09-29 16:52:47", "2015-09-29 17:52:47", "89.44.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1515", "0", "admin", "2015-09-29 17:00:59", "2015-09-29 18:00:59", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1516", "0", "magma", "2015-09-29 17:38:22", "2015-09-29 18:38:22", "5.197.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1517", "0", "admin", "2015-09-29 17:55:30", "2015-09-29 18:55:30", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1518", "0", "magma", "2015-09-29 18:04:34", "2015-09-29 19:04:34", "121.99.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1519", "0", "magma", "2015-09-29 18:25:29", "2015-09-29 19:25:29", "112.207.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1520", "0", "magma", "2015-09-29 18:39:22", "2015-09-29 19:39:22", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1521", "0", "magma", "2015-09-29 20:07:14", "2015-09-29 21:07:14", "109.92.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1522", "0", "magma", "2015-09-29 22:24:55", "2015-09-29 23:24:55", "196.205.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1523", "0", "magma", "2015-09-29 23:14:13", "2015-09-30 00:14:13", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1524", "0", "magma", "2015-09-30 00:20:31", "2015-09-30 01:20:31", "178.221.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1525", "0", "magma", "2015-09-30 00:22:24", "2015-09-30 01:22:24", "109.98.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1526", "0", "magma", "2015-09-30 01:52:26", "2015-09-30 02:52:26", "115.99.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1527", "0", "admin", "2015-09-30 04:03:03", "2015-09-30 05:03:03", "178.63.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1528", "0", "magma", "2015-09-30 04:19:52", "2015-09-30 05:19:52", "176.40.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1529", "0", "magma", "2015-09-30 05:25:33", "2015-09-30 06:25:33", "92.80.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1530", "0", "magma", "2015-09-30 05:48:40", "2015-09-30 06:48:40", "1.52.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1531", "0", "admin", "2015-09-30 05:56:48", "2015-09-30 06:56:48", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1532", "0", "magma", "2015-09-30 05:59:03", "2015-09-30 06:59:03", "109.76.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1533", "0", "magma", "2015-09-30 06:03:40", "2015-09-30 07:03:40", "49.146.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1534", "0", "magma", "2015-09-30 06:48:18", "2015-09-30 07:48:18", "178.221.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1535", "0", "admin", "2015-09-30 06:57:04", "2015-09-30 07:57:04", "85.24.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1536", "0", "magma", "2015-09-30 06:59:11", "2015-09-30 07:59:11", "1.52.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1537", "0", "admin", "2015-09-30 08:15:28", "2015-09-30 09:15:28", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1538", "0", "magma", "2015-09-30 09:03:56", "2015-09-30 10:03:56", "203.124.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1539", "0", "magma", "2015-09-30 09:04:27", "2015-09-30 10:04:27", "210.7.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1540", "0", "admin", "2015-09-30 09:09:18", "2015-09-30 10:09:18", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1541", "0", "magma", "2015-09-30 10:18:32", "2015-09-30 11:18:32", "151.250.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1542", "0", "magma", "2015-09-30 15:39:39", "2015-09-30 16:39:39", "188.2.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1543", "0", "magma", "2015-09-30 15:44:36", "2015-09-30 16:44:36", "187.107.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1544", "0", "magma", "2015-09-30 17:51:32", "2015-09-30 18:51:32", "197.255.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1545", "0", "magma", "2015-09-30 19:22:30", "2015-09-30 20:22:30", "89.44.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1546", "0", "admin", "2015-09-30 19:27:14", "2015-09-30 20:27:14", "5.79.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1547", "0", "magma", "2015-09-30 19:35:43", "2015-09-30 20:35:43", "81.64.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1548", "0", "magma", "2015-09-30 19:51:24", "2015-09-30 20:51:24", "2.85.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1549", "0", "magma", "2015-09-30 19:57:39", "2015-09-30 20:57:39", "188.36.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1550", "0", "admin", "2015-09-30 21:13:09", "2015-09-30 22:13:09", "185.29.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1551", "0", "magma", "2015-09-30 21:13:15", "2015-09-30 22:13:15", "149.78.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1552", "0", "admin", "2015-09-30 22:07:13", "2015-09-30 23:07:13", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1553", "0", "magma", "2015-09-30 22:34:42", "2015-09-30 23:34:42", "95.187.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1554", "0", "magma", "2015-09-30 23:08:32", "2015-10-01 00:08:32", "189.70.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1555", "0", "admin", "2015-09-30 23:20:35", "2015-10-01 00:20:35", "212.21.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1556", "0", "magma", "2015-09-30 23:48:45", "2015-10-01 00:48:45", "31.11.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1557", "0", "admin", "2015-10-01 00:05:55", "2015-10-01 01:05:55", "64.113.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1558", "0", "magma", "2015-10-01 00:44:09", "2015-10-01 01:44:09", "186.210.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1559", "0", "magma", "2015-10-01 01:59:31", "2015-10-01 02:59:31", "46.121.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1560", "0", "magma", "2015-10-01 07:17:41", "2015-10-01 08:17:41", "49.207.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1561", "0", "magma", "2015-10-01 08:41:32", "2015-10-01 09:41:32", "107.77.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1562", "0", "magma", "2015-10-01 08:44:59", "2015-10-01 09:44:59", "183.91.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1563", "0", "magma", "2015-10-01 09:19:40", "2015-10-01 10:19:40", "37.127.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1564", "0", "admin", "2015-10-01 09:22:22", "2015-10-01 10:22:22", "92.222.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1565", "0", "magma", "2015-10-01 09:28:04", "2015-10-01 10:28:04", "197.221.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1566", "0", "admin", "2015-10-01 10:56:40", "2015-10-01 11:56:40", "204.85.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1567", "0", "admin", "2015-10-01 11:41:13", "2015-10-01 12:41:13", "5.196.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1568", "0", "magma", "2015-10-01 11:42:00", "2015-10-01 12:42:00", "41.134.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1569", "0", "magma", "2015-10-01 12:32:30", "2015-10-01 13:32:30", "41.109.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1570", "0", "admin", "2015-10-01 12:53:45", "2015-10-01 13:53:45", "162.244.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1571", "0", "admin", "2015-10-01 13:33:56", "2015-10-01 14:33:56", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1572", "0", "magma", "2015-10-01 13:43:18", "2015-10-01 14:43:18", "212.93.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1573", "0", "magma", "2015-10-01 13:51:05", "2015-10-01 14:51:05", "59.92.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1574", "0", "magma", "2015-10-01 15:17:35", "2015-10-01 16:17:35", "217.71.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1575", "0", "magma", "2015-10-01 16:01:46", "2015-10-01 17:01:46", "92.87.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1576", "0", "magma", "2015-10-01 17:54:58", "2015-10-01 18:54:58", "79.116.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1577", "0", "magma", "2015-10-01 17:56:27", "2015-10-01 18:56:27", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1578", "0", "magma", "2015-10-01 18:17:01", "2015-10-01 19:17:01", "201.33.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1579", "0", "magma", "2015-10-01 18:17:14", "2015-10-01 19:17:14", "77.253.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1580", "0", "magma", "2015-10-01 18:20:25", "2015-10-01 19:20:25", "39.35.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1581", "0", "magma", "2015-10-01 18:32:19", "2015-10-01 19:32:19", "2.177.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1582", "0", "magma", "2015-10-01 18:49:19", "2015-10-01 19:49:19", "79.177.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1583", "0", "magma", "2015-10-01 19:48:29", "2015-10-01 20:48:29", "37.217.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1584", "0", "magma", "2015-10-01 20:38:29", "2015-10-01 21:38:29", "79.36.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1585", "0", "magma", "2015-10-01 20:39:48", "2015-10-01 21:39:48", "5.197.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1586", "0", "magma", "2015-10-01 21:11:23", "2015-10-01 22:11:23", "95.95.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1587", "0", "magma", "2015-10-01 21:15:09", "2015-10-01 22:15:09", "41.59.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1588", "0", "magma", "2015-10-01 21:23:02", "2015-10-01 22:23:02", "81.244.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1589", "0", "magma", "2015-10-01 21:27:54", "2015-10-01 22:27:54", "58.65.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1590", "0", "magma", "2015-10-01 21:42:06", "2015-10-01 22:42:06", "100.96.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1591", "0", "magma", "2015-10-01 22:40:21", "2015-10-01 23:40:21", "217.254.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1592", "0", "magma", "2015-10-01 23:04:10", "2015-10-02 00:04:10", "78.61.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1593", "0", "admin", "2015-10-01 23:39:10", "2015-10-02 00:39:10", "198.100.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1594", "0", "magma", "2015-10-01 23:51:01", "2015-10-02 00:51:01", "210.212.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1595", "0", "magma", "2015-10-02 00:56:23", "2015-10-02 01:56:23", "188.2.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1596", "0", "admin", "2015-10-02 01:14:17", "2015-10-02 02:14:17", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1597", "0", "magma", "2015-10-02 01:27:05", "2015-10-02 02:27:05", "93.41.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1598", "0", "admin", "2015-10-02 01:54:45", "2015-10-02 02:54:45", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1599", "0", "magma", "2015-10-02 02:20:24", "2015-10-02 03:20:24", "200.90.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1600", "0", "magma", "2015-10-02 02:48:21", "2015-10-02 03:48:21", "172.7.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1601", "0", "admin", "2015-10-02 03:05:28", "2015-10-02 04:05:28", "94.242.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1602", "0", "magma", "2015-10-02 03:08:44", "2015-10-02 04:08:44", "37.27.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1603", "0", "admin", "2015-10-02 03:39:52", "2015-10-02 04:39:52", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1604", "0", "magma", "2015-10-02 06:42:52", "2015-10-02 07:42:52", "121.75.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1605", "0", "magma", "2015-10-02 07:39:53", "2015-10-02 08:39:53", "61.18.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1606", "0", "magma", "2015-10-02 08:35:04", "2015-10-02 09:35:04", "109.186.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1607", "0", "magma", "2015-10-02 09:07:27", "2015-10-02 10:07:27", "37.27.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1608", "0", "magma", "2015-10-02 09:15:30", "2015-10-02 10:15:30", "94.176.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1609", "0", "magma", "2015-10-02 10:17:04", "2015-10-02 11:17:04", "79.118.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1610", "0", "magma", "2015-10-02 11:01:17", "2015-10-02 12:01:17", "84.2.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1611", "0", "magma", "2015-10-02 11:16:12", "2015-10-02 12:16:12", "91.206.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1612", "0", "magma", "2015-10-02 11:20:31", "2015-10-02 12:20:31", "125.18.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1613", "0", "magma", "2015-10-02 12:14:08", "2015-10-02 13:14:08", "117.195.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1614", "0", "magma", "2015-10-02 12:16:06", "2015-10-02 13:16:06", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1615", "0", "magma", "2015-10-02 12:51:19", "2015-10-02 13:51:19", "41.139.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1616", "0", "magma", "2015-10-02 13:05:32", "2015-10-02 14:05:32", "194.79.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1617", "0", "admin", "2015-10-02 14:23:45", "2015-10-02 15:23:45", "94.26.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1618", "0", "magma", "2015-10-02 14:58:07", "2015-10-02 15:58:07", "160.177.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1619", "0", "admin", "2015-10-02 15:02:17", "2015-10-02 16:02:17", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1620", "0", "admin", "2015-10-02 15:02:17", "2015-10-02 16:02:17", "188.138.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1621", "0", "magma", "2015-10-02 15:38:05", "2015-10-02 16:38:05", "197.156.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1622", "0", "magma", "2015-10-02 16:14:40", "2015-10-02 17:14:40", "46.116.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1623", "0", "admin", "2015-10-02 16:23:30", "2015-10-02 17:23:30", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1624", "0", "admin", "2015-10-02 16:56:32", "2015-10-02 17:56:32", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1625", "0", "magma", "2015-10-02 17:00:23", "2015-10-02 18:00:23", "89.121.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1626", "0", "magma", "2015-10-02 17:02:55", "2015-10-02 18:02:55", "27.130.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1627", "0", "magma", "2015-10-02 17:14:20", "2015-10-02 18:14:20", "43.224.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1628", "0", "magma", "2015-10-02 18:10:29", "2015-10-02 19:10:29", "109.98.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1629", "0", "magma", "2015-10-02 18:34:02", "2015-10-02 19:34:02", "117.0.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1630", "0", "magma", "2015-10-02 18:49:34", "2015-10-02 19:49:34", "176.12.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1631", "0", "magma", "2015-10-02 19:43:34", "2015-10-02 20:43:34", "77.81.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1632", "0", "magma", "2015-10-02 20:56:48", "2015-10-02 21:56:48", "46.103.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1633", "0", "magma", "2015-10-02 21:25:05", "2015-10-02 22:25:05", "126.64.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1634", "0", "magma", "2015-10-02 21:48:25", "2015-10-02 22:48:25", "5.197.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1635", "0", "magma", "2015-10-02 21:52:42", "2015-10-02 22:52:42", "77.46.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1636", "0", "magma", "2015-10-02 21:56:18", "2015-10-02 22:56:18", "93.57.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1637", "0", "magma", "2015-10-02 22:11:29", "2015-10-02 23:11:29", "188.2.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1638", "0", "magma", "2015-10-02 22:47:52", "2015-10-02 23:47:52", "46.214.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1639", "0", "magma", "2015-10-02 23:09:12", "2015-10-03 00:09:12", "95.246.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1640", "0", "magma", "2015-10-02 23:39:58", "2015-10-03 00:39:58", "60.53.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1641", "0", "magma", "2015-10-03 00:16:45", "2015-10-03 01:16:45", "197.32.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1642", "0", "magma", "2015-10-03 00:21:42", "2015-10-03 01:21:42", "112.204.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1643", "0", "magma", "2015-10-03 00:29:31", "2015-10-03 01:29:31", "190.60.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1644", "0", "magma", "2015-10-03 01:13:18", "2015-10-03 02:13:18", "49.150.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1645", "0", "magma", "2015-10-03 01:25:12", "2015-10-03 02:25:12", "191.183.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1646", "0", "magma", "2015-10-03 01:42:37", "2015-10-03 02:42:37", "178.220.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1647", "0", "magma", "2015-10-03 02:23:05", "2015-10-03 03:23:05", "81.182.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1648", "0", "magma", "2015-10-03 02:44:49", "2015-10-03 03:44:49", "200.88.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1649", "0", "admin", "2015-10-03 04:17:22", "2015-10-03 05:17:22", "176.31.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1650", "0", "magma", "2015-10-03 04:33:19", "2015-10-03 05:33:19", "116.237.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1651", "0", "admin", "2015-10-03 04:44:23", "2015-10-03 05:44:23", "5.135.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1652", "0", "admin", "2015-10-03 06:04:07", "2015-10-03 07:04:07", "212.232.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1653", "0", "admin", "2015-10-03 06:28:40", "2015-10-03 07:28:40", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1654", "0", "admin", "2015-10-03 06:39:25", "2015-10-03 07:39:25", "158.69.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1655", "0", "magma", "2015-10-03 08:10:08", "2015-10-03 09:10:08", "122.57.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1656", "0", "magma", "2015-10-03 08:26:08", "2015-10-03 09:26:08", "27.109.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1657", "0", "magma", "2015-10-03 10:03:17", "2015-10-03 11:03:17", "119.92.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1658", "0", "magma", "2015-10-03 10:23:29", "2015-10-03 11:23:29", "77.29.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1659", "0", "magma", "2015-10-03 10:24:58", "2015-10-03 11:24:58", "112.204.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1660", "0", "magma", "2015-10-03 10:52:45", "2015-10-03 11:52:45", "78.61.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1661", "0", "magma", "2015-10-03 11:08:54", "2015-10-03 12:08:54", "176.41.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1662", "0", "magma", "2015-10-03 11:28:29", "2015-10-03 12:28:29", "211.18.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1663", "0", "magma", "2015-10-03 14:22:37", "2015-10-03 15:22:37", "112.207.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1664", "0", "magma", "2015-10-03 15:29:32", "2015-10-03 16:29:32", "77.36.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1665", "0", "magma", "2015-10-03 15:30:57", "2015-10-03 16:30:57", "2.133.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1666", "0", "admin", "2015-10-03 16:40:23", "2015-10-03 17:40:23", "62.210.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1667", "0", "magma", "2015-10-03 17:23:42", "2015-10-03 18:23:42", "149.78.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1668", "0", "magma", "2015-10-03 17:38:33", "2015-10-03 18:38:33", "109.92.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1669", "0", "magma", "2015-10-03 17:47:22", "2015-10-03 18:47:22", "84.94.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1670", "0", "magma", "2015-10-03 18:02:26", "2015-10-03 19:02:26", "59.178.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1671", "0", "magma", "2015-10-03 18:40:55", "2015-10-03 19:40:55", "192.0.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1672", "0", "magma", "2015-10-03 18:58:07", "2015-10-03 19:58:07", "46.167.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1673", "0", "magma", "2015-10-03 19:02:17", "2015-10-03 20:02:17", "88.159.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1674", "0", "magma", "2015-10-03 19:02:41", "2015-10-03 20:02:41", "86.19.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1675", "0", "magma", "2015-10-03 19:06:21", "2015-10-03 20:06:21", "103.51.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1676", "0", "magma", "2015-10-03 19:12:55", "2015-10-03 20:12:55", "71.198.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1677", "0", "magma", "2015-10-03 19:13:25", "2015-10-03 20:13:25", "141.237.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1678", "0", "magma", "2015-10-03 19:16:06", "2015-10-03 20:16:06", "118.70.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1679", "0", "magma", "2015-10-03 19:25:53", "2015-10-03 20:25:53", "46.219.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1680", "0", "magma", "2015-10-03 19:28:22", "2015-10-03 20:28:22", "142.51.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1681", "0", "magma", "2015-10-03 19:31:06", "2015-10-03 20:31:06", "151.33.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1682", "0", "magma", "2015-10-03 19:44:47", "2015-10-03 20:44:47", "177.188.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1683", "0", "magma", "2015-10-03 19:46:29", "2015-10-03 20:46:29", "200.35.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1684", "0", "magma", "2015-10-03 19:57:34", "2015-10-03 20:57:34", "172.16.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1685", "0", "magma", "2015-10-03 19:59:31", "2015-10-03 20:59:31", "105.154.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1686", "0", "magma", "2015-10-03 20:01:11", "2015-10-03 21:01:11", "93.11.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1687", "0", "magma", "2015-10-03 20:02:52", "2015-10-03 21:02:52", "182.186.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1688", "0", "magma", "2015-10-03 20:03:01", "2015-10-03 21:03:01", "49.145.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1689", "0", "magma", "2015-10-03 20:04:02", "2015-10-03 21:04:02", "103.231.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1690", "0", "magma", "2015-10-03 20:04:04", "2015-10-03 21:04:04", "78.58.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1691", "0", "magma", "2015-10-03 20:05:34", "2015-10-03 21:05:34", "109.60.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1692", "0", "magma", "2015-10-03 20:22:17", "2015-10-03 21:22:17", "75.158.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1693", "0", "magma", "2015-10-03 20:45:15", "2015-10-03 21:45:15", "196.2.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1694", "0", "magma", "2015-10-03 20:49:45", "2015-10-03 21:49:45", "39.33.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1695", "0", "magma", "2015-10-03 21:00:21", "2015-10-03 22:00:21", "95.103.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1696", "0", "magma", "2015-10-03 21:05:16", "2015-10-03 22:05:16", "84.29.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1697", "0", "magma", "2015-10-03 21:19:20", "2015-10-03 22:19:20", "109.205.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1698", "0", "magma", "2015-10-03 21:33:00", "2015-10-03 22:33:00", "77.222.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1699", "0", "magma", "2015-10-03 21:41:12", "2015-10-03 22:41:12", "213.49.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1700", "0", "magma", "2015-10-03 22:08:40", "2015-10-03 23:08:40", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1701", "0", "magma", "2015-10-03 22:20:48", "2015-10-03 23:20:48", "85.244.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1702", "0", "magma", "2015-10-03 22:31:03", "2015-10-03 23:31:03", "185.18.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1703", "0", "magma", "2015-10-03 22:41:34", "2015-10-03 23:41:34", "94.76.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1704", "0", "magma", "2015-10-03 22:56:38", "2015-10-03 23:56:38", "27.34.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1705", "0", "magma", "2015-10-04 00:33:19", "2015-10-04 01:33:19", "178.243.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1706", "0", "admin", "2015-10-04 00:50:33", "2015-10-04 01:50:33", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1707", "0", "magma", "2015-10-04 00:50:39", "2015-10-04 01:50:39", "82.49.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1708", "0", "magma", "2015-10-04 01:28:38", "2015-10-04 02:28:38", "98.160.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1709", "0", "magmainc", "2015-10-04 02:24:51", "2015-10-04 03:24:51", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1710", "0", "magma", "2015-10-04 02:51:14", "2015-10-04 03:51:14", "93.86.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1711", "0", "magma", "2015-10-04 03:01:39", "2015-10-04 04:01:39", "210.195.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1712", "0", "magmainc", "2015-10-04 04:02:28", "2015-10-04 05:02:28", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1713", "0", "magma", "2015-10-04 04:12:11", "2015-10-04 05:12:11", "42.115.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1714", "0", "magma", "2015-10-04 05:10:09", "2015-10-04 06:10:09", "112.208.206.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1715", "0", "magma", "2015-10-04 05:30:09", "2015-10-04 06:30:09", "82.65.147.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1716", "0", "magmainc.co.za", "2015-10-04 05:45:03", "2015-10-04 06:45:03", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1717", "0", "magma", "2015-10-04 06:11:53", "2015-10-04 07:11:53", "218.185.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1718", "0", "magma", "2015-10-04 06:50:17", "2015-10-04 07:50:17", "94.242.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1719", "0", "magma", "2015-10-04 06:50:39", "2015-10-04 07:50:39", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1720", "0", "magmainc.co.za", "2015-10-04 07:25:23", "2015-10-04 08:25:23", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1721", "0", "magma", "2015-10-04 07:58:08", "2015-10-04 08:58:08", "46.167.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1722", "0", "magma", "2015-10-04 08:29:16", "2015-10-04 09:29:16", "178.41.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1723", "0", "admin", "2015-10-04 08:39:58", "2015-10-04 09:39:58", "92.222.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1724", "0", "magma", "2015-10-04 08:45:45", "2015-10-04 09:45:45", "121.181.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1725", "0", "magma", "2015-10-04 08:50:38", "2015-10-04 09:50:38", "150.129.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1726", "0", "magma", "2015-10-04 09:07:27", "2015-10-04 10:07:27", "118.96.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1727", "0", "magmainc.co.za", "2015-10-04 09:08:06", "2015-10-04 10:08:06", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1728", "0", "magma", "2015-10-04 09:21:01", "2015-10-04 10:21:01", "109.102.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1729", "0", "magma", "2015-10-04 09:40:23", "2015-10-04 10:40:23", "77.85.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1730", "0", "magma", "2015-10-04 10:03:20", "2015-10-04 11:03:20", "78.248.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1731", "0", "magma", "2015-10-04 10:04:35", "2015-10-04 11:04:35", "182.178.147.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1732", "0", "magma", "2015-10-04 10:25:46", "2015-10-04 11:25:46", "41.79.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1733", "0", "magma", "2015-10-04 10:41:40", "2015-10-04 11:41:40", "203.87.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1734", "0", "magma", "2015-10-04 10:46:14", "2015-10-04 11:46:14", "112.198.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1735", "0", "magmainc.co.za", "2015-10-04 10:52:06", "2015-10-04 11:52:06", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1736", "0", "magma", "2015-10-04 11:07:48", "2015-10-04 12:07:48", "27.34.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1737", "0", "magma", "2015-10-04 11:36:40", "2015-10-04 12:36:40", "188.241.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1738", "0", "magma", "2015-10-04 11:50:48", "2015-10-04 12:50:48", "83.6.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1739", "0", "magma", "2015-10-04 11:59:59", "2015-10-04 12:59:59", "103.255.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1740", "0", "magma", "2015-10-04 12:39:25", "2015-10-04 13:39:25", "113.203.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1741", "0", "magma", "2015-10-04 13:16:17", "2015-10-04 14:16:17", "122.54.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1742", "0", "magma", "2015-10-04 13:27:44", "2015-10-04 14:27:44", "188.205.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1743", "0", "magma", "2015-10-04 13:31:53", "2015-10-04 14:31:53", "121.54.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1744", "0", "magma", "2015-10-04 13:35:53", "2015-10-04 14:35:53", "2.100.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1745", "0", "magma", "2015-10-04 13:38:39", "2015-10-04 14:38:39", "197.202.155.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1746", "0", "magma", "2015-10-04 13:41:29", "2015-10-04 14:41:29", "62.198.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1747", "0", "magma", "2015-10-04 13:42:41", "2015-10-04 14:42:41", "81.233.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1748", "0", "magma", "2015-10-04 13:47:12", "2015-10-04 14:47:12", "188.25.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1749", "0", "magma", "2015-10-04 14:05:25", "2015-10-04 15:05:25", "185.19.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1750", "0", "magma", "2015-10-04 14:52:42", "2015-10-04 15:52:42", "117.201.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1751", "0", "magma", "2015-10-04 15:45:02", "2015-10-04 16:45:02", "114.108.222.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1752", "0", "magma", "2015-10-04 16:46:35", "2015-10-04 17:46:35", "36.84.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1753", "0", "magma", "2015-10-04 16:51:49", "2015-10-04 17:51:49", "180.190.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1754", "0", "magma", "2015-10-04 16:59:46", "2015-10-04 17:59:46", "86.126.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1755", "0", "magma", "2015-10-04 17:12:50", "2015-10-04 18:12:50", "39.53.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1756", "0", "magma", "2015-10-04 17:14:15", "2015-10-04 18:14:15", "160.242.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1757", "0", "magma", "2015-10-04 17:28:39", "2015-10-04 18:28:39", "93.92.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1758", "0", "magma", "2015-10-04 17:28:40", "2015-10-04 18:28:40", "39.41.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1759", "0", "magma", "2015-10-04 17:42:01", "2015-10-04 18:42:01", "78.60.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1760", "0", "magma", "2015-10-04 17:54:14", "2015-10-04 18:54:14", "68.193.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1761", "0", "magma", "2015-10-04 18:11:46", "2015-10-04 19:11:46", "58.26.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1762", "0", "magma", "2015-10-04 18:28:55", "2015-10-04 19:28:55", "1.186.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1763", "0", "magma", "2015-10-04 18:58:45", "2015-10-04 19:58:45", "62.169.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1764", "0", "magma", "2015-10-04 20:29:35", "2015-10-04 21:29:35", "95.180.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1765", "0", "magma", "2015-10-04 20:39:39", "2015-10-04 21:39:39", "85.99.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1766", "0", "magma", "2015-10-04 21:37:10", "2015-10-04 22:37:10", "173.217.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1767", "0", "magma", "2015-10-04 22:04:42", "2015-10-04 23:04:42", "37.6.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1768", "0", "magma", "2015-10-04 22:46:48", "2015-10-04 23:46:48", "24.205.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1769", "0", "magma", "2015-10-04 23:27:57", "2015-10-05 00:27:57", "134.176.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1770", "0", "magma", "2015-10-04 23:56:57", "2015-10-05 00:56:57", "31.2.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1771", "0", "magma", "2015-10-05 00:22:45", "2015-10-05 01:22:45", "187.38.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1772", "0", "magma", "2015-10-05 02:22:02", "2015-10-05 03:22:02", "191.240.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1773", "0", "admin", "2015-10-05 02:59:00", "2015-10-05 03:59:00", "5.196.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1774", "0", "magma", "2015-10-05 04:54:03", "2015-10-05 05:54:03", "92.158.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1775", "0", "magma", "2015-10-05 05:14:56", "2015-10-05 06:14:56", "117.197.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1776", "0", "magma", "2015-10-05 05:31:28", "2015-10-05 06:31:28", "99.248.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1777", "0", "magma", "2015-10-05 06:00:15", "2015-10-05 07:00:15", "171.96.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1778", "0", "magma", "2015-10-05 09:18:34", "2015-10-05 10:18:34", "85.127.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1779", "0", "magma", "2015-10-05 09:22:23", "2015-10-05 10:22:23", "188.37.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1780", "0", "magma", "2015-10-05 09:56:37", "2015-10-05 10:56:37", "121.99.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1781", "0", "admin", "2015-10-05 11:01:31", "2015-10-05 12:01:31", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1782", "0", "admin", "2015-10-05 11:28:38", "2015-10-05 12:28:38", "185.101.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1783", "0", "magma", "2015-10-05 11:48:29", "2015-10-05 12:48:29", "202.67.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1784", "0", "magma", "2015-10-05 11:49:57", "2015-10-05 12:49:57", "180.191.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1785", "0", "admin", "2015-10-05 12:01:40", "2015-10-05 13:01:40", "5.9.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1786", "0", "magma", "2015-10-05 13:11:38", "2015-10-05 14:11:38", "89.68.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1787", "0", "magma", "2015-10-05 13:46:44", "2015-10-05 14:46:44", "222.118.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1788", "0", "magma", "2015-10-05 13:49:10", "2015-10-05 14:49:10", "88.201.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1789", "0", "admin", "2015-10-05 14:58:38", "2015-10-05 15:58:38", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1790", "0", "magma", "2015-10-05 14:59:43", "2015-10-05 15:59:43", "79.177.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1791", "0", "magma", "2015-10-05 15:53:38", "2015-10-05 16:53:38", "121.99.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1792", "0", "magma", "2015-10-05 16:02:13", "2015-10-05 17:02:13", "86.107.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1793", "0", "magma", "2015-10-05 16:20:19", "2015-10-05 17:20:19", "5.2.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1794", "0", "magma", "2015-10-05 17:01:30", "2015-10-05 18:01:30", "92.252.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1795", "0", "magma", "2015-10-05 17:23:49", "2015-10-05 18:23:49", "1.23.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1796", "0", "magma", "2015-10-05 17:40:45", "2015-10-05 18:40:45", "92.51.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1797", "0", "magma", "2015-10-05 17:51:25", "2015-10-05 18:51:25", "46.211.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1798", "0", "magma", "2015-10-05 19:07:00", "2015-10-05 20:07:00", "203.215.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1799", "0", "magma", "2015-10-05 20:07:57", "2015-10-05 21:07:57", "182.65.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1800", "0", "magma", "2015-10-05 20:20:20", "2015-10-05 21:20:20", "14.47.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1801", "0", "magma", "2015-10-05 20:24:58", "2015-10-05 21:24:58", "93.109.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1802", "0", "admin", "2015-10-05 21:51:57", "2015-10-05 22:51:57", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1803", "0", "magma", "2015-10-05 21:52:46", "2015-10-05 22:52:46", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1804", "0", "admin", "2015-10-05 22:06:07", "2015-10-05 23:06:07", "212.16.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1805", "0", "magma", "2015-10-05 22:43:55", "2015-10-05 23:43:55", "77.77.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1806", "0", "admin", "2015-10-05 22:55:06", "2015-10-05 23:55:06", "185.34.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1807", "0", "magma", "2015-10-05 23:20:49", "2015-10-06 00:20:49", "5.28.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1808", "0", "magma", "2015-10-05 23:35:28", "2015-10-06 00:35:28", "80.242.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1809", "0", "magma", "2015-10-06 01:42:32", "2015-10-06 02:42:32", "73.46.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1810", "0", "admin", "2015-10-06 01:57:04", "2015-10-06 02:57:04", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1811", "0", "magma", "2015-10-06 02:31:56", "2015-10-06 03:31:56", "2.33.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1812", "0", "magma", "2015-10-06 03:22:04", "2015-10-06 04:22:04", "114.77.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1813", "0", "magma", "2015-10-06 06:44:50", "2015-10-06 07:44:50", "95.76.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1814", "0", "magma", "2015-10-06 07:05:11", "2015-10-06 08:05:11", "79.115.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1815", "0", "admin", "2015-10-06 07:23:29", "2015-10-06 08:23:29", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1816", "0", "admin", "2015-10-06 07:34:40", "2015-10-06 08:34:40", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1817", "0", "admin", "2015-10-06 08:06:03", "2015-10-06 09:06:03", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1818", "0", "magma", "2015-10-06 08:11:56", "2015-10-06 09:11:56", "114.69.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1819", "0", "magma", "2015-10-06 08:13:08", "2015-10-06 09:13:08", "203.111.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1820", "0", "magma", "2015-10-06 08:32:12", "2015-10-06 09:32:12", "197.6.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1821", "0", "magma", "2015-10-06 09:32:18", "2015-10-06 10:32:18", "42.83.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1822", "0", "magma", "2015-10-06 11:05:18", "2015-10-06 12:05:18", "180.227.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1823", "0", "magma", "2015-10-06 14:46:50", "2015-10-06 15:46:50", "197.203.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1824", "0", "magma", "2015-10-06 14:51:30", "2015-10-06 15:51:30", "46.121.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1825", "0", "magma", "2015-10-06 14:55:46", "2015-10-06 15:55:46", "62.81.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1826", "0", "magma", "2015-10-06 15:28:56", "2015-10-06 16:28:56", "119.94.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1827", "0", "magma", "2015-10-06 15:53:27", "2015-10-06 16:53:27", "94.76.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1828", "0", "magma", "2015-10-06 17:03:03", "2015-10-06 18:03:03", "175.145.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1829", "0", "admin", "2015-10-06 17:05:00", "2015-10-06 18:05:00", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1830", "0", "admin", "2015-10-06 17:23:20", "2015-10-06 18:23:20", "149.202.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1831", "0", "magma", "2015-10-06 17:41:28", "2015-10-06 18:41:28", "114.108.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1832", "0", "magma", "2015-10-06 17:50:23", "2015-10-06 18:50:23", "178.220.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1833", "0", "admin", "2015-10-06 17:50:33", "2015-10-06 18:50:33", "94.242.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1834", "0", "magma", "2015-10-06 18:25:33", "2015-10-06 19:25:33", "90.190.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1835", "0", "magma", "2015-10-06 18:36:32", "2015-10-06 19:36:32", "179.104.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1836", "0", "magma", "2015-10-06 20:29:18", "2015-10-06 21:29:18", "87.2.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1837", "0", "admin", "2015-10-06 22:01:35", "2015-10-06 23:01:35", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1838", "0", "magma", "2015-10-06 23:50:45", "2015-10-07 00:50:45", "178.220.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1839", "0", "magma", "2015-10-06 23:54:52", "2015-10-07 00:54:52", "81.245.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1840", "0", "magma", "2015-10-07 00:13:34", "2015-10-07 01:13:34", "197.89.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1841", "0", "magma", "2015-10-07 00:20:59", "2015-10-07 01:20:59", "185.36.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1842", "0", "admin", "2015-10-07 03:05:12", "2015-10-07 04:05:12", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1843", "0", "admin", "2015-10-07 03:27:21", "2015-10-07 04:27:21", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1844", "0", "magma", "2015-10-07 07:39:28", "2015-10-07 08:39:28", "14.98.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1845", "0", "admin", "2015-10-07 07:43:53", "2015-10-07 08:43:53", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1846", "0", "magma", "2015-10-07 08:11:55", "2015-10-07 09:11:55", "197.221.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1847", "0", "magma", "2015-10-07 11:00:48", "2015-10-07 12:00:48", "79.185.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1848", "0", "magma", "2015-10-07 11:03:51", "2015-10-07 12:03:51", "178.222.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1849", "0", "magma", "2015-10-07 12:01:33", "2015-10-07 13:01:33", "178.223.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1850", "0", "admin", "2015-10-07 12:07:05", "2015-10-07 13:07:05", "96.47.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1851", "0", "admin", "2015-10-07 12:35:06", "2015-10-07 13:35:06", "212.21.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1852", "0", "admin", "2015-10-07 12:35:29", "2015-10-07 13:35:29", "77.244.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1853", "0", "magma", "2015-10-07 16:39:12", "2015-10-07 17:39:12", "106.51.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1854", "0", "magma", "2015-10-07 17:18:03", "2015-10-07 18:18:03", "31.215.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1855", "0", "magma", "2015-10-07 17:29:12", "2015-10-07 18:29:12", "79.116.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1856", "0", "admin", "2015-10-07 17:36:14", "2015-10-07 18:36:14", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1857", "0", "magma", "2015-10-07 18:06:20", "2015-10-07 19:06:20", "112.207.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1858", "0", "magma", "2015-10-07 18:18:26", "2015-10-07 19:18:26", "93.87.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1859", "0", "magma", "2015-10-07 18:44:22", "2015-10-07 19:44:22", "41.133.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1860", "0", "magma", "2015-10-07 21:50:16", "2015-10-07 22:50:16", "24.132.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1861", "0", "admin", "2015-10-07 22:05:19", "2015-10-07 23:05:19", "195.154.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1862", "0", "admin", "2015-10-07 22:32:02", "2015-10-07 23:32:02", "37.157.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1863", "0", "admin", "2015-10-07 22:32:10", "2015-10-07 23:32:10", "92.222.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1864", "0", "magma", "2015-10-07 22:33:40", "2015-10-07 23:33:40", "134.176.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1865", "0", "magma", "2015-10-08 01:02:09", "2015-10-08 02:02:09", "89.205.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1866", "0", "magma", "2015-10-08 01:09:22", "2015-10-08 02:09:22", "95.92.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1867", "0", "magma", "2015-10-08 01:40:04", "2015-10-08 02:40:04", "41.196.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1868", "0", "magma", "2015-10-08 01:45:28", "2015-10-08 02:45:28", "177.80.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1869", "0", "magma", "2015-10-08 02:01:18", "2015-10-08 03:01:18", "5.83.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1870", "0", "magma", "2015-10-08 02:57:30", "2015-10-08 03:57:30", "112.201.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1871", "0", "magma", "2015-10-08 03:25:31", "2015-10-08 04:25:31", "185.36.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1872", "0", "admin", "2015-10-08 03:41:36", "2015-10-08 04:41:36", "31.172.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1873", "0", "magma", "2015-10-08 05:17:03", "2015-10-08 06:17:03", "106.51.26.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1874", "0", "magma", "2015-10-08 05:22:55", "2015-10-08 06:22:55", "88.161.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1875", "0", "magma", "2015-10-08 05:52:09", "2015-10-08 06:52:09", "186.30.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1876", "0", "admin", "2015-10-08 06:47:48", "2015-10-08 07:47:48", "158.69.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1877", "0", "magma", "2015-10-08 07:08:55", "2015-10-08 08:08:55", "79.169.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1878", "0", "admin", "2015-10-08 07:36:45", "2015-10-08 08:36:45", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1879", "0", "magma", "2015-10-08 08:00:24", "2015-10-08 09:00:24", "5.107.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1880", "0", "magma", "2015-10-08 09:58:26", "2015-10-08 10:58:26", "149.3.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1881", "0", "magma", "2015-10-08 12:22:27", "2015-10-08 13:22:27", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1882", "0", "admin", "2015-10-08 12:58:01", "2015-10-08 13:58:01", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1883", "0", "magma", "2015-10-08 13:16:41", "2015-10-08 14:16:41", "200.90.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1884", "0", "magma", "2015-10-08 13:48:05", "2015-10-08 14:48:05", "79.115.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1885", "0", "magma", "2015-10-08 13:57:17", "2015-10-08 14:57:17", "197.27.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1886", "0", "magma", "2015-10-08 14:04:00", "2015-10-08 15:04:00", "80.227.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1887", "0", "admin", "2015-10-08 15:29:47", "2015-10-08 16:29:47", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1888", "0", "magma", "2015-10-08 15:35:53", "2015-10-08 16:35:53", "89.121.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1889", "0", "magma", "2015-10-08 15:46:05", "2015-10-08 16:46:05", "178.220.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1890", "0", "admin", "2015-10-08 16:01:42", "2015-10-08 17:01:42", "87.118.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1891", "0", "magma", "2015-10-08 16:44:02", "2015-10-08 17:44:02", "121.54.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1892", "0", "admin", "2015-10-08 16:45:23", "2015-10-08 17:45:23", "185.11.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1893", "0", "magma", "2015-10-08 18:51:49", "2015-10-08 19:51:49", "112.203.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1894", "0", "magma", "2015-10-08 19:32:04", "2015-10-08 20:32:04", "89.35.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1895", "0", "magma", "2015-10-08 20:48:36", "2015-10-08 21:48:36", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1896", "0", "magma", "2015-10-08 21:18:54", "2015-10-08 22:18:54", "27.109.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1897", "0", "admin", "2015-10-08 22:38:47", "2015-10-08 23:38:47", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1898", "0", "magma", "2015-10-09 00:33:31", "2015-10-09 01:33:31", "81.244.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1899", "0", "admin", "2015-10-09 00:38:22", "2015-10-09 01:38:22", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1900", "0", "admin", "2015-10-09 01:08:51", "2015-10-09 02:08:51", "185.11.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1901", "0", "magma", "2015-10-09 01:21:49", "2015-10-09 02:21:49", "84.2.156.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1902", "0", "admin", "2015-10-09 02:09:51", "2015-10-09 03:09:51", "195.154.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1903", "0", "magma", "2015-10-09 07:20:21", "2015-10-09 08:20:21", "171.6.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1904", "0", "admin", "2015-10-09 07:57:56", "2015-10-09 08:57:56", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1905", "0", "admin", "2015-10-09 08:51:54", "2015-10-09 09:51:54", "5.9.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1906", "0", "admin", "2015-10-09 09:31:08", "2015-10-09 10:31:08", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1907", "0", "magma", "2015-10-09 09:37:01", "2015-10-09 10:37:01", "210.186.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1908", "0", "magma", "2015-10-09 10:56:06", "2015-10-09 11:56:06", "151.228.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1909", "0", "admin", "2015-10-09 11:03:54", "2015-10-09 12:03:54", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1910", "0", "magma", "2015-10-09 11:04:33", "2015-10-09 12:04:33", "37.211.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1911", "0", "magma", "2015-10-09 11:35:07", "2015-10-09 12:35:07", "174.97.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1912", "0", "magma", "2015-10-09 11:53:51", "2015-10-09 12:53:51", "92.99.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1913", "0", "magma", "2015-10-09 12:37:03", "2015-10-09 13:37:03", "174.113.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1914", "0", "magma", "2015-10-09 12:54:10", "2015-10-09 13:54:10", "175.143.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1915", "0", "magma", "2015-10-09 13:12:00", "2015-10-09 14:12:00", "89.134.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1916", "0", "magma", "2015-10-09 13:20:50", "2015-10-09 14:20:50", "176.43.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1917", "0", "magma", "2015-10-09 13:30:47", "2015-10-09 14:30:47", "81.246.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1918", "0", "magma", "2015-10-09 13:32:54", "2015-10-09 14:32:54", "62.28.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1919", "0", "magma", "2015-10-09 13:39:00", "2015-10-09 14:39:00", "85.186.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1920", "0", "magma", "2015-10-09 13:49:15", "2015-10-09 14:49:15", "197.160.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1921", "0", "magma", "2015-10-09 13:49:43", "2015-10-09 14:49:43", "81.108.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1922", "0", "magma", "2015-10-09 13:54:43", "2015-10-09 14:54:43", "92.87.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1923", "0", "magma", "2015-10-09 13:56:33", "2015-10-09 14:56:33", "187.183.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1924", "0", "magma", "2015-10-09 14:03:06", "2015-10-09 15:03:06", "130.204.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1925", "0", "magma", "2015-10-09 14:11:05", "2015-10-09 15:11:05", "46.217.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1926", "0", "magma", "2015-10-09 14:15:47", "2015-10-09 15:15:47", "193.191.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1927", "0", "magma", "2015-10-09 14:26:14", "2015-10-09 15:26:14", "138.118.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1928", "0", "magma", "2015-10-09 14:42:42", "2015-10-09 15:42:42", "190.46.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1929", "0", "magma", "2015-10-09 14:43:55", "2015-10-09 15:43:55", "14.141.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1930", "0", "magma", "2015-10-09 14:46:07", "2015-10-09 15:46:07", "94.67.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1931", "0", "magma", "2015-10-09 14:47:21", "2015-10-09 15:47:21", "95.146.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1932", "0", "magma", "2015-10-09 14:58:00", "2015-10-09 15:58:00", "90.221.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1933", "0", "magma", "2015-10-09 15:05:42", "2015-10-09 16:05:42", "98.228.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1934", "0", "magma", "2015-10-09 15:07:53", "2015-10-09 16:07:53", "24.63.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1935", "0", "magma", "2015-10-09 15:09:05", "2015-10-09 16:09:05", "46.109.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1936", "0", "magma", "2015-10-09 15:23:39", "2015-10-09 16:23:39", "201.252.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1937", "0", "magma", "2015-10-09 15:29:39", "2015-10-09 16:29:39", "178.149.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1938", "0", "magma", "2015-10-09 15:32:17", "2015-10-09 16:32:17", "58.97.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1939", "0", "magma", "2015-10-09 15:33:31", "2015-10-09 16:33:31", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1940", "0", "magma", "2015-10-09 15:36:32", "2015-10-09 16:36:32", "79.113.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1941", "0", "magma", "2015-10-09 16:09:51", "2015-10-09 17:09:51", "110.164.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1942", "0", "magma", "2015-10-09 16:12:49", "2015-10-09 17:12:49", "94.203.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1943", "0", "magma", "2015-10-09 16:34:12", "2015-10-09 17:34:12", "94.225.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1944", "0", "magma", "2015-10-09 16:51:31", "2015-10-09 17:51:31", "79.173.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1945", "0", "magma", "2015-10-09 17:02:11", "2015-10-09 18:02:11", "87.17.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1946", "0", "magma", "2015-10-09 17:06:50", "2015-10-09 18:06:50", "89.65.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1947", "0", "magma", "2015-10-09 17:07:46", "2015-10-09 18:07:46", "178.143.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1948", "0", "magma", "2015-10-09 17:16:22", "2015-10-09 18:16:22", "181.64.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1949", "0", "magma", "2015-10-09 17:20:19", "2015-10-09 18:20:19", "93.34.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1950", "0", "magma", "2015-10-09 17:23:58", "2015-10-09 18:23:58", "103.57.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1951", "0", "admin", "2015-10-09 17:25:14", "2015-10-09 18:25:14", "193.34.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1952", "0", "magma", "2015-10-09 17:27:33", "2015-10-09 18:27:33", "97.118.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1953", "0", "magma", "2015-10-09 17:34:27", "2015-10-09 18:34:27", "59.95.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1954", "0", "magma", "2015-10-09 17:40:31", "2015-10-09 18:40:31", "181.160.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1955", "0", "admin", "2015-10-09 17:41:06", "2015-10-09 18:41:06", "109.163.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1956", "0", "magma", "2015-10-09 17:42:50", "2015-10-09 18:42:50", "5.13.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1957", "0", "magma", "2015-10-09 17:44:46", "2015-10-09 18:44:46", "187.67.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1958", "0", "magma", "2015-10-09 17:55:05", "2015-10-09 18:55:05", "154.126.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1959", "0", "magma", "2015-10-09 17:58:03", "2015-10-09 18:58:03", "67.170.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1960", "0", "magma", "2015-10-09 17:59:49", "2015-10-09 18:59:49", "106.168.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1961", "0", "magma", "2015-10-09 18:01:55", "2015-10-09 19:01:55", "105.226.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1962", "0", "magma", "2015-10-09 18:01:55", "2015-10-09 19:01:55", "79.117.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1963", "0", "magma", "2015-10-09 18:08:44", "2015-10-09 19:08:44", "85.96.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1964", "0", "magma", "2015-10-09 18:18:10", "2015-10-09 19:18:10", "178.152.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1965", "0", "magma", "2015-10-09 18:40:11", "2015-10-09 19:40:11", "94.61.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1966", "0", "magma", "2015-10-09 18:43:45", "2015-10-09 19:43:45", "86.124.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1967", "0", "magma", "2015-10-09 18:45:11", "2015-10-09 19:45:11", "43.231.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1968", "0", "magma", "2015-10-09 18:47:57", "2015-10-09 19:47:57", "79.183.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1969", "0", "magma", "2015-10-09 19:34:34", "2015-10-09 20:34:34", "41.236.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1970", "0", "magma", "2015-10-09 19:42:07", "2015-10-09 20:42:07", "213.67.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1971", "0", "magma", "2015-10-09 19:47:11", "2015-10-09 20:47:11", "37.11.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1972", "0", "magma", "2015-10-09 19:52:28", "2015-10-09 20:52:28", "141.8.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1973", "0", "magma", "2015-10-09 19:56:10", "2015-10-09 20:56:10", "151.72.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1974", "0", "magma", "2015-10-09 20:04:21", "2015-10-09 21:04:21", "105.224.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1975", "0", "magma", "2015-10-09 20:11:19", "2015-10-09 21:11:19", "86.124.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1976", "0", "magma", "2015-10-09 20:21:53", "2015-10-09 21:21:53", "182.57.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1977", "0", "admin", "2015-10-09 20:22:27", "2015-10-09 21:22:27", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1978", "0", "magma", "2015-10-09 20:32:19", "2015-10-09 21:32:19", "201.149.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1979", "0", "magma", "2015-10-09 20:49:36", "2015-10-09 21:49:36", "107.179.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1980", "0", "magma", "2015-10-09 20:54:16", "2015-10-09 21:54:16", "41.101.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1981", "0", "magma", "2015-10-09 21:04:58", "2015-10-09 22:04:58", "203.111.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1982", "0", "magma", "2015-10-09 21:09:13", "2015-10-09 22:09:13", "46.99.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1983", "0", "magma", "2015-10-09 21:09:14", "2015-10-09 22:09:14", "110.5.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1984", "0", "magma", "2015-10-09 21:10:22", "2015-10-09 22:10:22", "89.164.156.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1985", "0", "magma", "2015-10-09 21:18:25", "2015-10-09 22:18:25", "219.240.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1986", "0", "magma", "2015-10-09 21:23:43", "2015-10-09 22:23:43", "202.171.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1987", "0", "magma", "2015-10-09 21:24:03", "2015-10-09 22:24:03", "84.77.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1988", "0", "magma", "2015-10-09 21:28:47", "2015-10-09 22:28:47", "89.142.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1989", "0", "magma", "2015-10-09 21:32:39", "2015-10-09 22:32:39", "89.153.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1990", "0", "magma", "2015-10-09 21:43:33", "2015-10-09 22:43:33", "181.168.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1991", "0", "magma", "2015-10-09 21:44:35", "2015-10-09 22:44:35", "154.68.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1992", "0", "magma", "2015-10-09 21:51:25", "2015-10-09 22:51:25", "217.46.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1993", "0", "magma", "2015-10-09 21:55:17", "2015-10-09 22:55:17", "83.110.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1994", "0", "magma", "2015-10-09 22:08:16", "2015-10-09 23:08:16", "178.223.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1995", "0", "magma", "2015-10-09 22:15:07", "2015-10-09 23:15:07", "46.152.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1996", "0", "magma", "2015-10-09 22:20:40", "2015-10-09 23:20:40", "95.156.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1997", "0", "magma", "2015-10-09 22:30:08", "2015-10-09 23:30:08", "31.215.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1998", "0", "magma", "2015-10-09 22:40:45", "2015-10-09 23:40:45", "185.33.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1999", "0", "magma", "2015-10-09 22:43:05", "2015-10-09 23:43:05", "87.241.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2000", "0", "magma", "2015-10-09 22:55:12", "2015-10-09 23:55:12", "90.192.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2001", "0", "magma", "2015-10-09 22:57:17", "2015-10-09 23:57:17", "212.93.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2002", "0", "magma", "2015-10-09 23:28:15", "2015-10-10 00:28:15", "89.36.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2003", "0", "magma", "2015-10-09 23:28:16", "2015-10-10 00:28:16", "37.190.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2004", "0", "magma", "2015-10-09 23:28:39", "2015-10-10 00:28:39", "213.67.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2005", "0", "magma", "2015-10-10 00:57:21", "2015-10-10 01:57:21", "109.201.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2006", "0", "admin", "2015-10-10 02:40:42", "2015-10-10 03:40:42", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2007", "0", "admin", "2015-10-10 02:57:00", "2015-10-10 03:57:00", "96.44.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2008", "0", "magma", "2015-10-10 10:50:32", "2015-10-10 11:50:32", "213.185.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2009", "0", "admin", "2015-10-10 10:57:25", "2015-10-10 11:57:25", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2010", "0", "admin", "2015-10-10 12:16:27", "2015-10-10 13:16:27", "46.28.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2011", "0", "magma", "2015-10-10 13:18:34", "2015-10-10 14:18:34", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2012", "0", "admin", "2015-10-10 14:32:39", "2015-10-10 15:32:39", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2013", "0", "admin", "2015-10-10 19:44:42", "2015-10-10 20:44:42", "85.10.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2014", "0", "admin", "2015-10-10 20:56:28", "2015-10-10 21:56:28", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2015", "0", "admin", "2015-10-10 23:54:05", "2015-10-11 00:54:05", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2016", "0", "admin", "2015-10-11 05:47:58", "2015-10-11 06:47:58", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2017", "0", "admin", "2015-10-11 14:22:55", "2015-10-11 15:22:55", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2018", "0", "admin", "2015-10-11 17:28:44", "2015-10-11 18:28:44", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2019", "0", "admin", "2015-10-11 22:11:33", "2015-10-11 23:11:33", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2020", "0", "admin", "2015-10-11 23:31:29", "2015-10-12 00:31:29", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2021", "0", "admin", "2015-10-12 00:52:05", "2015-10-12 01:52:05", "77.109.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2022", "0", "admin", "2015-10-12 02:36:09", "2015-10-12 03:36:09", "185.36.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2023", "0", "admin", "2015-10-12 06:45:54", "2015-10-12 07:45:54", "91.219.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2024", "0", "admin", "2015-10-12 08:04:27", "2015-10-12 09:04:27", "158.130.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2025", "0", "admin", "2015-10-12 09:36:44", "2015-10-12 10:36:44", "195.154.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2026", "0", "admin", "2015-10-12 11:16:44", "2015-10-12 12:16:44", "204.85.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2027", "0", "admin", "2015-10-12 15:44:58", "2015-10-12 16:44:58", "94.23.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2028", "0", "admin", "2015-10-12 17:24:22", "2015-10-12 18:24:22", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2029", "0", "admin", "2015-10-12 19:21:30", "2015-10-12 20:21:30", "188.165.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2030", "0", "admin", "2015-10-12 21:19:03", "2015-10-12 22:19:03", "85.10.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2031", "0", "admin", "2015-10-13 01:56:35", "2015-10-13 02:56:35", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2032", "0", "admin", "2015-10-13 05:17:12", "2015-10-13 06:17:12", "185.101.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2033", "0", "admin", "2015-10-13 06:49:09", "2015-10-13 07:49:09", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2034", "0", "admin", "2015-10-13 10:50:36", "2015-10-13 11:50:36", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2035", "0", "admin", "2015-10-13 12:35:16", "2015-10-13 13:35:16", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2036", "0", "admin", "2015-10-13 14:41:06", "2015-10-13 15:41:06", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2037", "0", "admin", "2015-10-13 22:17:53", "2015-10-13 23:17:53", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2038", "0", "admin", "2015-10-14 00:41:51", "2015-10-14 01:41:51", "212.47.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2039", "0", "admin", "2015-10-14 02:03:34", "2015-10-14 03:03:34", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2040", "0", "admin", "2015-10-14 05:37:47", "2015-10-14 06:37:47", "194.150.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2041", "0", "admin", "2015-10-14 07:25:22", "2015-10-14 08:25:22", "94.26.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2042", "0", "admin", "2015-10-14 10:12:22", "2015-10-14 11:12:22", "5.9.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2043", "0", "admin", "2015-10-14 11:32:29", "2015-10-14 12:32:29", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2044", "0", "admin", "2015-10-14 15:35:52", "2015-10-14 16:35:52", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2045", "0", "admin", "2015-10-14 17:19:18", "2015-10-14 18:19:18", "69.162.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2046", "0", "admin", "2015-10-14 21:23:23", "2015-10-14 22:23:23", "85.25.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2047", "0", "admin", "2015-10-15 01:04:39", "2015-10-15 02:04:39", "194.150.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2048", "0", "admin", "2015-10-15 02:46:19", "2015-10-15 03:46:19", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2049", "0", "admin", "2015-10-15 06:35:22", "2015-10-15 07:35:22", "62.210.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2050", "0", "admin", "2015-10-15 09:40:45", "2015-10-15 10:40:45", "62.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2051", "0", "admin", "2015-10-15 11:29:43", "2015-10-15 12:29:43", "80.82.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2052", "0", "admin", "2015-10-15 14:45:33", "2015-10-15 15:45:33", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2053", "0", "admin", "2015-10-15 15:38:07", "2015-10-15 16:38:07", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2054", "0", "admin", "2015-10-15 18:40:47", "2015-10-15 19:40:47", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2055", "0", "admin", "2015-10-15 20:45:31", "2015-10-15 21:45:31", "85.10.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2056", "0", "admin", "2015-10-16 00:26:48", "2015-10-16 01:26:48", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2057", "0", "admin", "2015-10-16 01:15:07", "2015-10-16 02:15:07", "162.221.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2058", "0", "admin", "2015-10-16 04:03:47", "2015-10-16 05:03:47", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2059", "0", "admin", "2015-10-16 09:43:59", "2015-10-16 10:43:59", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2060", "0", "admin", "2015-10-16 14:47:54", "2015-10-16 15:47:54", "95.130.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2061", "0", "admin", "2015-10-16 19:00:17", "2015-10-16 20:00:17", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2062", "0", "admin", "2015-10-16 19:24:24", "2015-10-16 20:24:24", "62.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2063", "0", "admin", "2015-10-16 22:02:50", "2015-10-16 23:02:50", "192.151.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2064", "0", "admin", "2015-10-17 00:09:28", "2015-10-17 01:09:28", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2065", "0", "admin", "2015-10-17 04:39:51", "2015-10-17 05:39:51", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2066", "0", "admin", "2015-10-17 09:02:30", "2015-10-17 10:02:30", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2067", "0", "admin", "2015-10-17 13:40:29", "2015-10-17 14:40:29", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2068", "0", "admin", "2015-10-17 13:40:43", "2015-10-17 14:40:43", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2069", "0", "magma", "2015-10-17 15:44:17", "2015-10-17 16:44:17", "182.231.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2070", "0", "magma", "2015-10-17 15:47:42", "2015-10-17 16:47:42", "31.11.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2071", "0", "magma", "2015-10-17 16:06:34", "2015-10-17 17:06:34", "86.87.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2072", "0", "magma", "2015-10-17 16:08:40", "2015-10-17 17:08:40", "101.186.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2073", "0", "magma", "2015-10-17 16:10:17", "2015-10-17 17:10:17", "112.210.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2074", "0", "magma", "2015-10-17 16:11:19", "2015-10-17 17:11:19", "91.240.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2075", "0", "magma", "2015-10-17 16:13:00", "2015-10-17 17:13:00", "89.46.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2076", "0", "magma", "2015-10-17 16:20:46", "2015-10-17 17:20:46", "81.230.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2077", "0", "magma", "2015-10-17 16:21:52", "2015-10-17 17:21:52", "177.177.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2078", "0", "magma", "2015-10-17 16:35:09", "2015-10-17 17:35:09", "62.234.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2079", "0", "magma", "2015-10-17 16:47:20", "2015-10-17 17:47:20", "176.40.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2080", "0", "magma", "2015-10-17 16:52:04", "2015-10-17 17:52:04", "105.237.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2081", "0", "magma", "2015-10-17 17:05:42", "2015-10-17 18:05:42", "100.4.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2082", "0", "magma", "2015-10-17 17:06:41", "2015-10-17 18:06:41", "197.36.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2083", "0", "magma", "2015-10-17 17:23:17", "2015-10-17 18:23:17", "105.226.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2084", "0", "magma", "2015-10-17 17:28:27", "2015-10-17 18:28:27", "105.226.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2085", "0", "magma", "2015-10-17 17:37:23", "2015-10-17 18:37:23", "92.80.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2086", "0", "magma", "2015-10-17 17:38:09", "2015-10-17 18:38:09", "109.96.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2087", "0", "magma", "2015-10-17 17:39:03", "2015-10-17 18:39:03", "93.180.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2088", "0", "magma", "2015-10-17 17:39:12", "2015-10-17 18:39:12", "95.186.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2089", "0", "magma", "2015-10-17 17:52:18", "2015-10-17 18:52:18", "79.176.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2090", "0", "magma", "2015-10-17 17:53:41", "2015-10-17 18:53:41", "178.222.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2091", "0", "magma", "2015-10-17 17:59:04", "2015-10-17 18:59:04", "93.86.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2092", "0", "magma", "2015-10-17 18:00:11", "2015-10-17 19:00:11", "79.108.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2093", "0", "magma", "2015-10-17 18:01:29", "2015-10-17 19:01:29", "81.235.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2094", "0", "admin", "2015-10-17 18:04:33", "2015-10-17 19:04:33", "149.202.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2095", "0", "magma", "2015-10-17 18:08:56", "2015-10-17 19:08:56", "203.218.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2096", "0", "magma", "2015-10-17 18:11:13", "2015-10-17 19:11:13", "82.51.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2097", "0", "magma", "2015-10-17 18:14:43", "2015-10-17 19:14:43", "46.211.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2098", "0", "magma", "2015-10-17 18:16:54", "2015-10-17 19:16:54", "83.53.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2099", "0", "magma", "2015-10-17 18:20:05", "2015-10-17 19:20:05", "88.8.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2100", "0", "magma", "2015-10-17 18:23:23", "2015-10-17 19:23:23", "92.80.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2101", "0", "magma", "2015-10-17 18:37:26", "2015-10-17 19:37:26", "83.59.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2102", "0", "magma", "2015-10-17 18:55:12", "2015-10-17 19:55:12", "78.60.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2103", "0", "magma", "2015-10-17 18:55:16", "2015-10-17 19:55:16", "24.51.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2104", "0", "magma", "2015-10-17 19:05:07", "2015-10-17 20:05:07", "182.178.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2105", "0", "magma", "2015-10-17 19:13:45", "2015-10-17 20:13:45", "109.194.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2106", "0", "magma", "2015-10-17 19:14:12", "2015-10-17 20:14:12", "213.22.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2107", "0", "magma", "2015-10-17 19:17:50", "2015-10-17 20:17:50", "82.10.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2108", "0", "magma", "2015-10-17 19:21:18", "2015-10-17 20:21:18", "188.221.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2109", "0", "magma", "2015-10-17 19:26:34", "2015-10-17 20:26:34", "2.49.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2110", "0", "magma", "2015-10-17 19:26:54", "2015-10-17 20:26:54", "46.19.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2111", "0", "magma", "2015-10-17 19:27:10", "2015-10-17 20:27:10", "123.201.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2112", "0", "magma", "2015-10-17 19:28:09", "2015-10-17 20:28:09", "188.127.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2113", "0", "magma", "2015-10-17 19:29:02", "2015-10-17 20:29:02", "91.178.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2114", "0", "magma", "2015-10-17 19:38:37", "2015-10-17 20:38:37", "46.189.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2115", "0", "magma", "2015-10-17 19:42:57", "2015-10-17 20:42:57", "82.67.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2116", "0", "magma", "2015-10-17 19:49:17", "2015-10-17 20:49:17", "91.185.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2117", "0", "magma", "2015-10-17 19:52:02", "2015-10-17 20:52:02", "24.157.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2118", "0", "magma", "2015-10-17 19:56:27", "2015-10-17 20:56:27", "190.152.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2119", "0", "magma", "2015-10-17 19:59:28", "2015-10-17 20:59:28", "116.87.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2120", "0", "magma", "2015-10-17 20:15:02", "2015-10-17 21:15:02", "78.21.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2121", "0", "magma", "2015-10-17 20:30:38", "2015-10-17 21:30:38", "5.15.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2122", "0", "magma", "2015-10-17 20:31:04", "2015-10-17 21:31:04", "31.2.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2123", "0", "magma", "2015-10-17 20:37:11", "2015-10-17 21:37:11", "213.156.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2124", "0", "magma", "2015-10-17 20:37:23", "2015-10-17 21:37:23", "39.57.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2125", "0", "magma", "2015-10-17 20:39:08", "2015-10-17 21:39:08", "78.13.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2126", "0", "magma", "2015-10-17 20:39:42", "2015-10-17 21:39:42", "2.225.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2127", "0", "magma", "2015-10-17 20:49:32", "2015-10-17 21:49:32", "111.88.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2128", "0", "magma", "2015-10-17 20:51:06", "2015-10-17 21:51:06", "37.157.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2129", "0", "magma", "2015-10-17 20:51:31", "2015-10-17 21:51:31", "37.211.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2130", "0", "magma", "2015-10-17 20:57:19", "2015-10-17 21:57:19", "82.30.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2131", "0", "magma", "2015-10-17 21:00:31", "2015-10-17 22:00:31", "46.117.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2132", "0", "magma", "2015-10-17 21:01:18", "2015-10-17 22:01:18", "81.165.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2133", "0", "magma", "2015-10-17 21:13:32", "2015-10-17 22:13:32", "41.136.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2134", "0", "magma", "2015-10-17 21:14:36", "2015-10-17 22:14:36", "121.87.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2135", "0", "magma", "2015-10-17 21:22:51", "2015-10-17 22:22:51", "118.96.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2136", "0", "magma", "2015-10-17 21:33:06", "2015-10-17 22:33:06", "70.171.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2137", "0", "magma", "2015-10-17 21:38:00", "2015-10-17 22:38:00", "68.195.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2138", "0", "magma", "2015-10-17 21:39:11", "2015-10-17 22:39:11", "80.174.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2139", "0", "magma", "2015-10-17 21:43:10", "2015-10-17 22:43:10", "186.45.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2140", "0", "magma", "2015-10-17 21:47:37", "2015-10-17 22:47:37", "122.175.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2141", "0", "magma", "2015-10-17 21:47:56", "2015-10-17 22:47:56", "148.101.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2142", "0", "magma", "2015-10-17 21:52:59", "2015-10-17 22:52:59", "31.134.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2143", "0", "magma", "2015-10-17 22:03:00", "2015-10-17 23:03:00", "174.21.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2144", "0", "magma", "2015-10-17 22:10:30", "2015-10-17 23:10:30", "178.220.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2145", "0", "magma", "2015-10-17 22:12:45", "2015-10-17 23:12:45", "88.231.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2146", "0", "magma", "2015-10-17 22:13:38", "2015-10-17 23:13:38", "129.7.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2147", "0", "magma", "2015-10-17 22:21:46", "2015-10-17 23:21:46", "78.58.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2148", "0", "admin", "2015-10-17 22:48:08", "2015-10-17 23:48:08", "62.212.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2149", "0", "admin", "2015-10-17 22:49:16", "2015-10-17 23:49:16", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2150", "0", "magma", "2015-10-17 23:08:07", "2015-10-18 00:08:07", "210.195.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2151", "0", "magma", "2015-10-17 23:10:50", "2015-10-18 00:10:50", "86.98.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2152", "0", "magma", "2015-10-17 23:13:56", "2015-10-18 00:13:56", "137.207.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2153", "0", "magma", "2015-10-17 23:14:57", "2015-10-18 00:14:57", "82.27.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2154", "0", "magma", "2015-10-17 23:16:15", "2015-10-18 00:16:15", "79.118.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2155", "0", "magma", "2015-10-17 23:17:03", "2015-10-18 00:17:03", "1.243.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2156", "0", "magma", "2015-10-17 23:21:30", "2015-10-18 00:21:30", "202.142.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2157", "0", "magma", "2015-10-17 23:34:32", "2015-10-18 00:34:32", "78.98.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2158", "0", "magma", "2015-10-17 23:48:51", "2015-10-18 00:48:51", "2.30.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2159", "0", "magma", "2015-10-18 00:02:37", "2015-10-18 01:02:37", "178.213.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2160", "0", "magma", "2015-10-18 00:13:22", "2015-10-18 01:13:22", "111.237.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2161", "0", "magma", "2015-10-18 00:13:50", "2015-10-18 01:13:50", "67.189.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2162", "0", "magma", "2015-10-18 00:15:41", "2015-10-18 01:15:41", "39.55.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2163", "0", "magma", "2015-10-18 00:17:40", "2015-10-18 01:17:40", "197.86.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2164", "0", "magma", "2015-10-18 00:17:55", "2015-10-18 01:17:55", "213.238.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2165", "0", "magma", "2015-10-18 00:20:55", "2015-10-18 01:20:55", "87.69.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2166", "0", "magma", "2015-10-18 00:24:27", "2015-10-18 01:24:27", "109.67.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2167", "0", "magma", "2015-10-18 00:25:20", "2015-10-18 01:25:20", "188.141.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2168", "0", "magma", "2015-10-18 00:27:22", "2015-10-18 01:27:22", "47.18.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2169", "0", "magma", "2015-10-18 00:36:06", "2015-10-18 01:36:06", "77.222.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2170", "0", "admin", "2015-10-18 00:37:38", "2015-10-18 01:37:38", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2171", "0", "magma", "2015-10-18 00:43:13", "2015-10-18 01:43:13", "151.0.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2172", "0", "magma", "2015-10-18 00:46:20", "2015-10-18 01:46:20", "177.10.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2173", "0", "magma", "2015-10-18 01:12:20", "2015-10-18 02:12:20", "181.73.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2174", "0", "magma", "2015-10-18 01:28:43", "2015-10-18 02:28:43", "178.153.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2175", "0", "magma", "2015-10-18 01:35:10", "2015-10-18 02:35:10", "41.207.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2176", "0", "magma", "2015-10-18 01:37:38", "2015-10-18 02:37:38", "82.19.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2177", "0", "magma", "2015-10-18 01:39:43", "2015-10-18 02:39:43", "197.86.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2178", "0", "magma", "2015-10-18 01:40:52", "2015-10-18 02:40:52", "95.95.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2179", "0", "magma", "2015-10-18 01:41:57", "2015-10-18 02:41:57", "104.235.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2180", "0", "magma", "2015-10-18 01:46:20", "2015-10-18 02:46:20", "75.40.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2181", "0", "magma", "2015-10-18 01:50:57", "2015-10-18 02:50:57", "96.55.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2182", "0", "magma", "2015-10-18 02:02:44", "2015-10-18 03:02:44", "77.97.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2183", "0", "magma", "2015-10-18 02:05:20", "2015-10-18 03:05:20", "95.185.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2184", "0", "magma", "2015-10-18 02:38:23", "2015-10-18 03:38:23", "31.11.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2185", "0", "magma", "2015-10-18 02:45:21", "2015-10-18 03:45:21", "221.202.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2186", "0", "admin", "2015-10-18 02:52:43", "2015-10-18 03:52:43", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2187", "0", "magma", "2015-10-18 02:59:14", "2015-10-18 03:59:14", "147.194.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2188", "0", "magma", "2015-10-18 03:00:39", "2015-10-18 04:00:39", "200.192.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2189", "0", "magma", "2015-10-18 03:10:56", "2015-10-18 04:10:56", "46.116.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2190", "0", "magma", "2015-10-18 03:14:20", "2015-10-18 04:14:20", "35.32.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2191", "0", "magma", "2015-10-18 03:52:04", "2015-10-18 04:52:04", "182.178.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2192", "0", "magma", "2015-10-18 03:58:19", "2015-10-18 04:58:19", "89.205.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2193", "0", "magma", "2015-10-18 04:20:05", "2015-10-18 05:20:05", "92.149.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2194", "0", "magma", "2015-10-18 04:24:41", "2015-10-18 05:24:41", "191.177.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2195", "0", "magma", "2015-10-18 04:25:56", "2015-10-18 05:25:56", "79.117.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2196", "0", "magma", "2015-10-18 04:27:08", "2015-10-18 05:27:08", "92.53.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2197", "0", "magma", "2015-10-18 04:38:30", "2015-10-18 05:38:30", "113.210.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2198", "0", "magma", "2015-10-18 04:49:03", "2015-10-18 05:49:03", "112.198.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2199", "0", "magma", "2015-10-18 05:00:08", "2015-10-18 06:00:08", "104.162.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2200", "0", "magma", "2015-10-18 05:06:24", "2015-10-18 06:06:24", "58.104.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2201", "0", "magma", "2015-10-18 05:11:18", "2015-10-18 06:11:18", "173.172.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2202", "0", "magma", "2015-10-18 05:15:01", "2015-10-18 06:15:01", "181.55.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2203", "0", "magma", "2015-10-18 05:26:57", "2015-10-18 06:26:57", "46.116.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2204", "0", "magma", "2015-10-18 05:39:27", "2015-10-18 06:39:27", "135.23.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2205", "0", "magma", "2015-10-18 05:42:28", "2015-10-18 06:42:28", "68.81.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2206", "0", "magma", "2015-10-18 06:00:40", "2015-10-18 07:00:40", "70.49.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2207", "0", "magma", "2015-10-18 06:16:32", "2015-10-18 07:16:32", "220.124.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2208", "0", "magma", "2015-10-18 06:23:05", "2015-10-18 07:23:05", "109.65.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2209", "0", "magma", "2015-10-18 06:26:29", "2015-10-18 07:26:29", "118.101.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2210", "0", "magma", "2015-10-18 06:53:27", "2015-10-18 07:53:27", "105.226.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2211", "0", "magma", "2015-10-18 06:54:08", "2015-10-18 07:54:08", "103.231.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2212", "0", "magma", "2015-10-18 07:13:12", "2015-10-18 08:13:12", "117.204.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2213", "0", "magma", "2015-10-18 07:16:37", "2015-10-18 08:16:37", "78.95.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2214", "0", "magma", "2015-10-18 07:24:31", "2015-10-18 08:24:31", "72.241.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2215", "0", "magma", "2015-10-18 07:35:24", "2015-10-18 08:35:24", "74.57.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2216", "0", "magma", "2015-10-18 07:35:44", "2015-10-18 08:35:44", "108.180.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2217", "0", "admin", "2015-10-18 07:43:10", "2015-10-18 08:43:10", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2218", "0", "admin", "2015-10-18 07:52:46", "2015-10-18 08:52:46", "94.156.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2219", "0", "magma", "2015-10-18 07:54:02", "2015-10-18 08:54:02", "49.248.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2220", "0", "magma", "2015-10-18 07:55:29", "2015-10-18 08:55:29", "73.206.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2221", "0", "magma", "2015-10-18 07:56:58", "2015-10-18 08:56:58", "82.84.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2222", "0", "magma", "2015-10-18 07:58:28", "2015-10-18 08:58:28", "119.93.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2223", "0", "magma", "2015-10-18 08:01:45", "2015-10-18 09:01:45", "210.186.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2224", "0", "magma", "2015-10-18 08:10:46", "2015-10-18 09:10:46", "124.104.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2225", "0", "magma", "2015-10-18 08:28:52", "2015-10-18 09:28:52", "93.130.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2226", "0", "magma", "2015-10-18 08:34:51", "2015-10-18 09:34:51", "59.95.176.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2227", "0", "magma", "2015-10-18 08:52:27", "2015-10-18 09:52:27", "126.7.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2228", "0", "magma", "2015-10-18 08:54:03", "2015-10-18 09:54:03", "118.97.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2229", "0", "magma", "2015-10-18 08:59:42", "2015-10-18 09:59:42", "39.49.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2230", "0", "magma", "2015-10-18 09:10:01", "2015-10-18 10:10:01", "1.52.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2231", "0", "magma", "2015-10-18 09:31:41", "2015-10-18 10:31:41", "120.56.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2232", "0", "magma", "2015-10-18 09:41:29", "2015-10-18 10:41:29", "79.193.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2233", "0", "magma", "2015-10-18 09:48:19", "2015-10-18 10:48:19", "61.255.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2234", "0", "magma", "2015-10-18 09:57:36", "2015-10-18 10:57:36", "105.184.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2235", "0", "magma", "2015-10-18 10:03:49", "2015-10-18 11:03:49", "95.165.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2236", "0", "magma", "2015-10-18 10:14:46", "2015-10-18 11:14:46", "178.221.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2237", "0", "magma", "2015-10-18 10:28:26", "2015-10-18 11:28:26", "211.212.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2238", "0", "magma", "2015-10-18 10:45:53", "2015-10-18 11:45:53", "109.96.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2239", "0", "magma", "2015-10-18 10:47:24", "2015-10-18 11:47:24", "82.124.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2240", "0", "magma", "2015-10-18 10:48:52", "2015-10-18 11:48:52", "212.107.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2241", "0", "magma", "2015-10-18 10:53:32", "2015-10-18 11:53:32", "79.108.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2242", "0", "magma", "2015-10-18 10:55:19", "2015-10-18 11:55:19", "109.57.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2243", "0", "magma", "2015-10-18 10:56:42", "2015-10-18 11:56:42", "82.56.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2244", "0", "magma", "2015-10-18 10:57:42", "2015-10-18 11:57:42", "101.57.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2245", "0", "magma", "2015-10-18 11:01:27", "2015-10-18 12:01:27", "202.21.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2246", "0", "magma", "2015-10-18 11:05:31", "2015-10-18 12:05:31", "5.13.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2247", "0", "magma", "2015-10-18 11:08:54", "2015-10-18 12:08:54", "58.160.147.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2248", "0", "magma", "2015-10-18 11:16:27", "2015-10-18 12:16:27", "83.250.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2249", "0", "magma", "2015-10-18 11:23:52", "2015-10-18 12:23:52", "83.56.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2250", "0", "admin", "2015-10-18 11:24:26", "2015-10-18 12:24:26", "46.28.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2251", "0", "magma", "2015-10-18 11:26:39", "2015-10-18 12:26:39", "202.160.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2252", "0", "magma", "2015-10-18 11:35:22", "2015-10-18 12:35:22", "213.143.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2253", "0", "magma", "2015-10-18 11:38:20", "2015-10-18 12:38:20", "203.210.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2254", "0", "magma", "2015-10-18 12:10:17", "2015-10-18 13:10:17", "139.192.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2255", "0", "magma", "2015-10-18 12:26:38", "2015-10-18 13:26:38", "86.86.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2256", "0", "magma", "2015-10-18 12:29:28", "2015-10-18 13:29:28", "2.85.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2257", "0", "magma", "2015-10-18 12:35:19", "2015-10-18 13:35:19", "109.96.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2258", "0", "magma", "2015-10-18 12:37:31", "2015-10-18 13:37:31", "84.109.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2259", "0", "magma", "2015-10-18 12:51:42", "2015-10-18 13:51:42", "95.135.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2260", "0", "magma", "2015-10-18 12:55:07", "2015-10-18 13:55:07", "117.201.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2261", "0", "magma", "2015-10-18 13:12:54", "2015-10-18 14:12:54", "80.242.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2262", "0", "magma", "2015-10-18 13:24:15", "2015-10-18 14:24:15", "178.221.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2263", "0", "magma", "2015-10-18 13:27:41", "2015-10-18 14:27:41", "84.109.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2264", "0", "magma", "2015-10-18 13:30:31", "2015-10-18 14:30:31", "151.33.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2265", "0", "magma", "2015-10-18 13:35:18", "2015-10-18 14:35:18", "105.102.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2266", "0", "magma", "2015-10-18 13:44:01", "2015-10-18 14:44:01", "182.178.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2267", "0", "magma", "2015-10-18 13:49:28", "2015-10-18 14:49:28", "197.255.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2268", "0", "magma", "2015-10-18 14:06:30", "2015-10-18 15:06:30", "197.160.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2269", "0", "magma", "2015-10-18 14:09:01", "2015-10-18 15:09:01", "112.204.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2270", "0", "magma", "2015-10-18 14:18:10", "2015-10-18 15:18:10", "179.105.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2271", "0", "magma", "2015-10-18 14:42:20", "2015-10-18 15:42:20", "109.173.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2272", "0", "magma", "2015-10-18 14:43:08", "2015-10-18 15:43:08", "43.230.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2273", "0", "magma", "2015-10-18 14:50:49", "2015-10-18 15:50:49", "104.237.155.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2274", "0", "magma", "2015-10-18 14:51:16", "2015-10-18 15:51:16", "85.254.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2275", "0", "magma", "2015-10-18 14:53:48", "2015-10-18 15:53:48", "178.220.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2276", "0", "magma", "2015-10-18 14:57:51", "2015-10-18 15:57:51", "116.48.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2277", "0", "magma", "2015-10-18 15:00:49", "2015-10-18 16:00:49", "146.199.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2278", "0", "magma", "2015-10-18 15:02:54", "2015-10-18 16:02:54", "149.3.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2279", "0", "magma", "2015-10-18 15:06:47", "2015-10-18 16:06:47", "31.11.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2280", "0", "magma", "2015-10-18 15:12:51", "2015-10-18 16:12:51", "39.48.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2281", "0", "magma", "2015-10-18 15:13:21", "2015-10-18 16:13:21", "105.99.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2282", "0", "magma", "2015-10-18 15:39:06", "2015-10-18 16:39:06", "176.92.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2283", "0", "magma", "2015-10-18 15:43:12", "2015-10-18 16:43:12", "89.47.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2284", "0", "magma", "2015-10-18 15:51:08", "2015-10-18 16:51:08", "178.221.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2285", "0", "magma", "2015-10-18 15:55:38", "2015-10-18 16:55:38", "78.62.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2286", "0", "magma", "2015-10-18 16:19:52", "2015-10-18 17:19:52", "126.64.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2287", "0", "admin", "2015-10-18 16:46:06", "2015-10-18 17:46:06", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2288", "0", "magma", "2015-10-18 16:51:14", "2015-10-18 17:51:14", "118.97.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2289", "0", "magma", "2015-10-18 17:07:24", "2015-10-18 18:07:24", "78.92.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2290", "0", "magma", "2015-10-18 17:19:15", "2015-10-18 18:19:15", "66.172.250.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2291", "0", "magma", "2015-10-18 17:34:00", "2015-10-18 18:34:00", "49.207.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2292", "0", "magma", "2015-10-18 17:54:02", "2015-10-18 18:54:02", "83.4.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2293", "0", "magma", "2015-10-18 17:55:02", "2015-10-18 18:55:02", "93.130.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2294", "0", "admin", "2015-10-18 17:58:15", "2015-10-18 18:58:15", "142.4.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2295", "0", "magma", "2015-10-18 17:59:09", "2015-10-18 18:59:09", "78.60.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2296", "0", "magma", "2015-10-18 18:13:29", "2015-10-18 19:13:29", "79.115.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2297", "0", "magma", "2015-10-18 18:14:00", "2015-10-18 19:14:00", "46.236.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2298", "0", "magma", "2015-10-18 18:14:31", "2015-10-18 19:14:31", "106.68.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2299", "0", "magma", "2015-10-18 18:15:02", "2015-10-18 19:15:02", "31.214.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2300", "0", "magma", "2015-10-18 18:18:53", "2015-10-18 19:18:53", "81.104.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2301", "0", "magma", "2015-10-18 18:33:18", "2015-10-18 19:33:18", "2.51.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2302", "0", "magma", "2015-10-18 18:57:33", "2015-10-18 19:57:33", "93.76.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2303", "0", "magma", "2015-10-18 19:00:58", "2015-10-18 20:00:58", "93.103.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2304", "0", "magma", "2015-10-18 19:02:40", "2015-10-18 20:02:40", "202.142.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2305", "0", "magma", "2015-10-18 19:02:48", "2015-10-18 20:02:48", "94.67.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2306", "0", "magma", "2015-10-18 19:07:19", "2015-10-18 20:07:19", "41.251.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2307", "0", "magma", "2015-10-18 19:09:59", "2015-10-18 20:09:59", "37.201.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2308", "0", "magma", "2015-10-18 19:13:51", "2015-10-18 20:13:51", "88.227.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2309", "0", "magma", "2015-10-18 19:18:42", "2015-10-18 20:18:42", "93.58.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2310", "0", "magma", "2015-10-18 19:23:30", "2015-10-18 20:23:30", "94.177.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2311", "0", "magma", "2015-10-18 19:28:20", "2015-10-18 20:28:20", "189.48.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2312", "0", "magma", "2015-10-18 19:32:37", "2015-10-18 20:32:37", "62.98.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2313", "0", "magma", "2015-10-18 19:36:43", "2015-10-18 20:36:43", "87.126.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2314", "0", "magma", "2015-10-18 19:37:16", "2015-10-18 20:37:16", "177.205.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2315", "0", "magma", "2015-10-18 19:46:30", "2015-10-18 20:46:30", "72.178.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2316", "0", "magma", "2015-10-18 19:48:04", "2015-10-18 20:48:04", "89.103.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2317", "0", "magma", "2015-10-18 19:54:39", "2015-10-18 20:54:39", "178.143.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2318", "0", "magma", "2015-10-18 20:09:24", "2015-10-18 21:09:24", "159.20.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2319", "0", "magma", "2015-10-18 20:10:23", "2015-10-18 21:10:23", "188.25.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2320", "0", "magma", "2015-10-18 20:12:35", "2015-10-18 21:12:35", "93.103.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2321", "0", "magma", "2015-10-18 20:20:04", "2015-10-18 21:20:04", "176.73.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2322", "0", "magma", "2015-10-18 20:23:30", "2015-10-18 21:23:30", "178.233.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2323", "0", "magma", "2015-10-18 20:23:40", "2015-10-18 21:23:40", "46.149.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2324", "0", "magma", "2015-10-18 20:31:03", "2015-10-18 21:31:03", "5.246.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2325", "0", "magma", "2015-10-18 20:35:34", "2015-10-18 21:35:34", "177.80.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2326", "0", "magma", "2015-10-18 20:45:33", "2015-10-18 21:45:33", "103.26.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2327", "0", "magma", "2015-10-18 20:47:29", "2015-10-18 21:47:29", "182.185.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2328", "0", "magma", "2015-10-18 20:48:49", "2015-10-18 21:48:49", "131.161.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2329", "0", "magma", "2015-10-18 21:04:39", "2015-10-18 22:04:39", "79.157.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2330", "0", "magma", "2015-10-18 21:07:02", "2015-10-18 22:07:02", "95.95.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2331", "0", "magma", "2015-10-18 21:27:50", "2015-10-18 22:27:50", "41.102.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2332", "0", "magma", "2015-10-18 21:28:40", "2015-10-18 22:28:40", "83.117.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2333", "0", "magma", "2015-10-18 21:36:38", "2015-10-18 22:36:38", "178.128.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2334", "0", "magma", "2015-10-18 21:41:04", "2015-10-18 22:41:04", "78.60.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2335", "0", "magma", "2015-10-18 21:43:10", "2015-10-18 22:43:10", "86.98.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2336", "0", "magma", "2015-10-18 21:48:03", "2015-10-18 22:48:03", "10.1.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2337", "0", "magma", "2015-10-18 21:58:39", "2015-10-18 22:58:39", "94.132.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2338", "0", "magma", "2015-10-18 22:10:22", "2015-10-18 23:10:22", "5.64.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2339", "0", "magma", "2015-10-18 22:21:02", "2015-10-18 23:21:02", "45.74.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2340", "0", "magma", "2015-10-18 22:21:59", "2015-10-18 23:21:59", "134.226.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2341", "0", "magma", "2015-10-18 22:36:35", "2015-10-18 23:36:35", "190.160.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2342", "0", "magma", "2015-10-18 22:52:11", "2015-10-18 23:52:11", "79.169.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2343", "0", "magma", "2015-10-18 23:08:50", "2015-10-19 00:08:50", "93.43.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2344", "0", "magma", "2015-10-18 23:45:22", "2015-10-19 00:45:22", "200.73.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2345", "0", "magma", "2015-10-18 23:58:16", "2015-10-19 00:58:16", "78.147.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2346", "0", "magma", "2015-10-19 00:09:58", "2015-10-19 01:09:58", "77.89.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2347", "0", "magma", "2015-10-19 00:13:55", "2015-10-19 01:13:55", "193.59.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2348", "0", "magma", "2015-10-19 00:19:47", "2015-10-19 01:19:47", "88.167.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2349", "0", "magma", "2015-10-19 00:42:27", "2015-10-19 01:42:27", "78.92.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2350", "0", "magma", "2015-10-19 00:42:47", "2015-10-19 01:42:47", "177.179.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2351", "0", "magma", "2015-10-19 00:56:58", "2015-10-19 01:56:58", "119.93.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2352", "0", "magma", "2015-10-19 01:20:15", "2015-10-19 02:20:15", "24.90.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2353", "0", "magma", "2015-10-19 01:34:05", "2015-10-19 02:34:05", "68.172.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2354", "0", "magma", "2015-10-19 02:19:05", "2015-10-19 03:19:05", "2.50.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2355", "0", "magma", "2015-10-19 02:19:16", "2015-10-19 03:19:16", "177.143.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2356", "0", "magma", "2015-10-19 02:26:36", "2015-10-19 03:26:36", "82.213.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2357", "0", "admin", "2015-10-19 02:35:11", "2015-10-19 03:35:11", "178.219.245.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2358", "0", "magma", "2015-10-19 02:43:00", "2015-10-19 03:43:00", "119.73.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2359", "0", "magma", "2015-10-19 02:48:34", "2015-10-19 03:48:34", "93.139.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2360", "0", "admin", "2015-10-19 02:52:36", "2015-10-19 03:52:36", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2361", "0", "magma", "2015-10-19 03:34:21", "2015-10-19 04:34:21", "83.153.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2362", "0", "magma", "2015-10-19 03:53:06", "2015-10-19 04:53:06", "220.255.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2363", "0", "magma", "2015-10-19 04:03:24", "2015-10-19 05:03:24", "180.255.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2364", "0", "magma", "2015-10-19 04:04:11", "2015-10-19 05:04:11", "31.185.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2365", "0", "magma", "2015-10-19 04:23:05", "2015-10-19 05:23:05", "82.10.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2366", "0", "magma", "2015-10-19 04:31:10", "2015-10-19 05:31:10", "92.85.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2367", "0", "magma", "2015-10-19 05:03:52", "2015-10-19 06:03:52", "124.83.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2368", "0", "admin", "2015-10-19 06:06:03", "2015-10-19 07:06:03", "104.167.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2369", "0", "magma", "2015-10-19 06:13:23", "2015-10-19 07:13:23", "85.127.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2370", "0", "magma", "2015-10-19 06:21:07", "2015-10-19 07:21:07", "186.45.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2371", "0", "magma", "2015-10-19 07:03:51", "2015-10-19 08:03:51", "133.21.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2372", "0", "magma", "2015-10-19 07:14:55", "2015-10-19 08:14:55", "76.183.161.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2373", "0", "magma", "2015-10-19 07:41:02", "2015-10-19 08:41:02", "182.185.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2374", "0", "magma", "2015-10-19 08:26:40", "2015-10-19 09:26:40", "49.205.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2375", "0", "magma", "2015-10-19 08:49:28", "2015-10-19 09:49:28", "86.5.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2376", "0", "magma", "2015-10-19 08:57:00", "2015-10-19 09:57:00", "104.32.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2377", "0", "magma", "2015-10-19 09:21:46", "2015-10-19 10:21:46", "49.151.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2378", "0", "magma", "2015-10-19 09:31:52", "2015-10-19 10:31:52", "49.146.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2379", "0", "magma", "2015-10-19 09:59:30", "2015-10-19 10:59:30", "5.140.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2380", "0", "magma", "2015-10-19 10:03:31", "2015-10-19 11:03:31", "79.46.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2381", "0", "magma", "2015-10-19 10:13:40", "2015-10-19 11:13:40", "49.145.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2382", "0", "magma", "2015-10-19 10:15:09", "2015-10-19 11:15:09", "198.8.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2383", "0", "magma", "2015-10-19 10:19:15", "2015-10-19 11:19:15", "123.63.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2384", "0", "magma", "2015-10-19 10:23:46", "2015-10-19 11:23:46", "12.26.161.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2385", "0", "magma", "2015-10-19 10:29:23", "2015-10-19 11:29:23", "122.61.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2386", "0", "magma", "2015-10-19 10:43:40", "2015-10-19 11:43:40", "79.126.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2387", "0", "magma", "2015-10-19 10:59:28", "2015-10-19 11:59:28", "173.168.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2388", "0", "magma", "2015-10-19 11:42:00", "2015-10-19 12:42:00", "165.50.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2389", "0", "magma", "2015-10-19 11:44:08", "2015-10-19 12:44:08", "65.183.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2390", "0", "magma", "2015-10-19 11:54:19", "2015-10-19 12:54:19", "194.103.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2391", "0", "admin", "2015-10-19 12:21:18", "2015-10-19 13:21:18", "176.9.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2392", "0", "admin", "2015-10-19 12:39:46", "2015-10-19 13:39:46", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2393", "0", "magma", "2015-10-19 13:01:58", "2015-10-19 14:01:58", "81.165.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2394", "0", "magma", "2015-10-19 13:25:04", "2015-10-19 14:25:04", "123.2.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2395", "0", "magma", "2015-10-19 13:42:29", "2015-10-19 14:42:29", "109.121.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2396", "0", "magma", "2015-10-19 13:45:17", "2015-10-19 14:45:17", "123.254.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2397", "0", "magma", "2015-10-19 14:10:44", "2015-10-19 15:10:44", "79.53.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2398", "0", "magma", "2015-10-19 14:16:43", "2015-10-19 15:16:43", "95.180.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2399", "0", "magma", "2015-10-19 14:50:36", "2015-10-19 15:50:36", "188.126.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2400", "0", "magma", "2015-10-19 14:55:20", "2015-10-19 15:55:20", "87.8.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2401", "0", "magma", "2015-10-19 15:17:07", "2015-10-19 16:17:07", "73.213.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2402", "0", "magma", "2015-10-19 15:20:42", "2015-10-19 16:20:42", "189.29.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2403", "0", "magma", "2015-10-19 15:24:45", "2015-10-19 16:24:45", "37.221.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2404", "0", "magma", "2015-10-19 15:25:46", "2015-10-19 16:25:46", "104.193.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2405", "0", "admin", "2015-10-19 15:39:15", "2015-10-19 16:39:15", "94.242.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2406", "0", "magma", "2015-10-19 15:54:41", "2015-10-19 16:54:41", "149.78.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2407", "0", "magma", "2015-10-19 16:14:15", "2015-10-19 17:14:15", "101.100.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2408", "0", "magma", "2015-10-19 16:47:01", "2015-10-19 17:47:01", "123.237.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2409", "0", "magma", "2015-10-19 17:02:32", "2015-10-19 18:02:32", "85.154.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2410", "0", "magma", "2015-10-19 17:12:42", "2015-10-19 18:12:42", "188.123.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2411", "0", "magma", "2015-10-19 17:15:43", "2015-10-19 18:15:43", "89.211.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2412", "0", "magma", "2015-10-19 17:31:55", "2015-10-19 18:31:55", "93.172.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2413", "0", "magma", "2015-10-19 17:34:23", "2015-10-19 18:34:23", "41.213.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2414", "0", "magma", "2015-10-19 17:40:25", "2015-10-19 18:40:25", "86.123.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2415", "0", "magma", "2015-10-19 17:44:00", "2015-10-19 18:44:00", "95.158.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2416", "0", "magma", "2015-10-19 18:40:00", "2015-10-19 19:40:00", "31.215.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2417", "0", "magma", "2015-10-19 18:57:18", "2015-10-19 19:57:18", "177.43.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2418", "0", "magma", "2015-10-19 19:10:30", "2015-10-19 20:10:30", "202.21.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2419", "0", "magma", "2015-10-19 19:17:24", "2015-10-19 20:17:24", "5.29.222.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2420", "0", "magma", "2015-10-19 19:32:10", "2015-10-19 20:32:10", "46.218.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2421", "0", "magma", "2015-10-19 19:37:15", "2015-10-19 20:37:15", "91.90.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2422", "0", "magma", "2015-10-19 19:42:03", "2015-10-19 20:42:03", "123.237.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2423", "0", "magma", "2015-10-19 19:52:28", "2015-10-19 20:52:28", "87.68.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2424", "0", "magma", "2015-10-19 20:06:44", "2015-10-19 21:06:44", "85.96.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2425", "0", "magma", "2015-10-19 20:24:07", "2015-10-19 21:24:07", "14.201.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2426", "0", "magma", "2015-10-19 20:25:44", "2015-10-19 21:25:44", "128.234.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2427", "0", "magma", "2015-10-19 20:30:42", "2015-10-19 21:30:42", "41.236.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2428", "0", "magma", "2015-10-19 20:31:59", "2015-10-19 21:31:59", "5.246.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2429", "0", "magma", "2015-10-19 20:38:13", "2015-10-19 21:38:13", "41.133.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2430", "0", "magma", "2015-10-19 20:45:55", "2015-10-19 21:45:55", "37.203.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2431", "0", "magma", "2015-10-19 21:21:02", "2015-10-19 22:21:02", "173.168.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2432", "0", "magma", "2015-10-19 21:26:54", "2015-10-19 22:26:54", "86.5.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2433", "0", "magma", "2015-10-19 21:31:44", "2015-10-19 22:31:44", "113.161.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2434", "0", "magma", "2015-10-19 21:40:35", "2015-10-19 22:40:35", "149.78.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2435", "0", "magma", "2015-10-19 21:52:58", "2015-10-19 22:52:58", "89.216.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2436", "0", "magma", "2015-10-19 22:04:54", "2015-10-19 23:04:54", "24.135.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2437", "0", "magma", "2015-10-19 22:22:39", "2015-10-19 23:22:39", "83.99.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2438", "0", "admin", "2015-10-19 22:22:50", "2015-10-19 23:22:50", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2439", "0", "magma", "2015-10-19 22:28:12", "2015-10-19 23:28:12", "128.179.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2440", "0", "magma", "2015-10-19 22:39:05", "2015-10-19 23:39:05", "77.77.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2441", "0", "magma", "2015-10-19 22:41:27", "2015-10-19 23:41:27", "79.176.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2442", "0", "magma", "2015-10-19 22:42:49", "2015-10-19 23:42:49", "5.66.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2443", "0", "admin", "2015-10-19 22:43:49", "2015-10-19 23:43:49", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2444", "0", "admin", "2015-10-19 22:47:32", "2015-10-19 23:47:32", "178.17.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2445", "0", "magma", "2015-10-19 22:59:13", "2015-10-19 23:59:13", "151.26.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2446", "0", "magma", "2015-10-19 23:10:55", "2015-10-20 00:10:55", "119.26.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2447", "0", "magma", "2015-10-19 23:20:51", "2015-10-20 00:20:51", "73.213.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2448", "0", "magma", "2015-10-19 23:23:53", "2015-10-20 00:23:53", "73.141.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2449", "0", "magma", "2015-10-19 23:24:57", "2015-10-20 00:24:57", "79.116.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2450", "0", "magma", "2015-10-19 23:43:08", "2015-10-20 00:43:08", "77.125.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2451", "0", "magma", "2015-10-19 23:49:45", "2015-10-20 00:49:45", "177.83.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2452", "0", "magma", "2015-10-20 00:29:14", "2015-10-20 01:29:14", "82.19.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2453", "0", "magma", "2015-10-20 00:32:30", "2015-10-20 01:32:30", "218.49.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2454", "0", "magma", "2015-10-20 01:06:13", "2015-10-20 02:06:13", "167.59.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2455", "0", "magma", "2015-10-20 01:10:58", "2015-10-20 02:10:58", "190.92.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2456", "0", "magma", "2015-10-20 01:33:37", "2015-10-20 02:33:37", "112.198.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2457", "0", "magma", "2015-10-20 01:39:07", "2015-10-20 02:39:07", "86.40.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2458", "0", "magma", "2015-10-20 01:47:20", "2015-10-20 02:47:20", "101.186.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2459", "0", "magma", "2015-10-20 02:10:58", "2015-10-20 03:10:58", "109.252.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2460", "0", "magma", "2015-10-20 02:23:11", "2015-10-20 03:23:11", "45.74.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2461", "0", "magma", "2015-10-20 02:56:40", "2015-10-20 03:56:40", "95.185.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2462", "0", "magma", "2015-10-20 03:09:46", "2015-10-20 04:09:46", "167.59.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2463", "0", "magma", "2015-10-20 03:34:10", "2015-10-20 04:34:10", "71.95.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2464", "0", "magma", "2015-10-20 03:52:46", "2015-10-20 04:52:46", "82.213.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2465", "0", "magma", "2015-10-20 03:58:05", "2015-10-20 04:58:05", "191.243.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2466", "0", "magma", "2015-10-20 04:41:44", "2015-10-20 05:41:44", "177.223.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2467", "0", "magma", "2015-10-20 04:41:55", "2015-10-20 05:41:55", "31.215.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2468", "0", "magma", "2015-10-20 05:20:38", "2015-10-20 06:20:38", "178.124.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2469", "0", "magma", "2015-10-20 05:55:40", "2015-10-20 06:55:40", "182.185.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2470", "0", "magma", "2015-10-20 06:10:18", "2015-10-20 07:10:18", "46.62.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2471", "0", "magma", "2015-10-20 06:49:11", "2015-10-20 07:49:11", "82.213.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2472", "0", "magma", "2015-10-20 07:28:19", "2015-10-20 08:28:19", "112.198.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2473", "0", "magma", "2015-10-20 07:55:59", "2015-10-20 08:55:59", "92.99.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2474", "0", "admin", "2015-10-20 07:57:32", "2015-10-20 08:57:32", "5.135.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2475", "0", "magma", "2015-10-20 08:07:40", "2015-10-20 09:07:40", "2.50.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2476", "0", "magma", "2015-10-20 08:52:04", "2015-10-20 09:52:04", "178.220.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2477", "0", "magma", "2015-10-20 09:03:17", "2015-10-20 10:03:17", "194.28.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2478", "0", "magma", "2015-10-20 09:14:54", "2015-10-20 10:14:54", "178.59.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2479", "0", "magma", "2015-10-20 09:45:30", "2015-10-20 10:45:30", "95.56.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2480", "0", "magma", "2015-10-20 09:48:51", "2015-10-20 10:48:51", "78.0.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2481", "0", "magma", "2015-10-20 09:50:38", "2015-10-20 10:50:38", "82.172.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2482", "0", "magma", "2015-10-20 10:05:49", "2015-10-20 11:05:49", "94.177.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2483", "0", "magma", "2015-10-20 10:14:44", "2015-10-20 11:14:44", "217.165.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2484", "0", "admin", "2015-10-20 10:47:58", "2015-10-20 11:47:58", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2485", "0", "magma", "2015-10-20 11:00:16", "2015-10-20 12:00:16", "88.119.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2486", "0", "magma", "2015-10-20 11:33:32", "2015-10-20 12:33:32", "36.231.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2487", "0", "magma", "2015-10-20 11:42:27", "2015-10-20 12:42:27", "86.98.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2488", "0", "magma", "2015-10-20 12:27:29", "2015-10-20 13:27:29", "126.64.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2489", "0", "magma", "2015-10-20 12:29:03", "2015-10-20 13:29:03", "79.127.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2490", "0", "magma", "2015-10-20 12:35:34", "2015-10-20 13:35:34", "111.93.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2491", "0", "magma", "2015-10-20 12:44:59", "2015-10-20 13:44:59", "95.103.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2492", "0", "magma", "2015-10-20 12:51:33", "2015-10-20 13:51:33", "182.178.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2493", "0", "magma", "2015-10-20 12:59:01", "2015-10-20 13:59:01", "62.219.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2494", "0", "magma", "2015-10-20 13:11:48", "2015-10-20 14:11:48", "154.70.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2495", "0", "magma", "2015-10-20 13:15:00", "2015-10-20 14:15:00", "94.190.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2496", "0", "magma", "2015-10-20 14:00:18", "2015-10-20 15:00:18", "176.73.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2497", "0", "magma", "2015-10-20 14:11:40", "2015-10-20 15:11:40", "202.142.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2498", "0", "magma", "2015-10-20 14:28:14", "2015-10-20 15:28:14", "109.78.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2499", "0", "magma", "2015-10-20 14:38:43", "2015-10-20 15:38:43", "103.225.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2500", "0", "magma", "2015-10-20 14:40:30", "2015-10-20 15:40:30", "105.226.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2501", "0", "magma", "2015-10-20 15:09:22", "2015-10-20 16:09:22", "45.74.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2502", "0", "magma", "2015-10-20 15:37:20", "2015-10-20 16:37:20", "85.244.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2503", "0", "magma", "2015-10-20 15:39:47", "2015-10-20 16:39:47", "77.40.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2504", "0", "magma", "2015-10-20 15:56:36", "2015-10-20 16:56:36", "60.243.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2505", "0", "magma", "2015-10-20 16:44:54", "2015-10-20 17:44:54", "61.6.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2506", "0", "admin", "2015-10-20 16:50:16", "2015-10-20 17:50:16", "158.130.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2507", "0", "magma", "2015-10-20 17:37:20", "2015-10-20 18:37:20", "5.245.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2508", "0", "magma", "2015-10-20 18:09:57", "2015-10-20 19:09:57", "78.174.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2509", "0", "magma", "2015-10-20 18:13:07", "2015-10-20 19:13:07", "188.17.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2510", "0", "magma", "2015-10-20 18:44:48", "2015-10-20 19:44:48", "39.32.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2511", "0", "magma", "2015-10-20 19:06:49", "2015-10-20 20:06:49", "151.52.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2512", "0", "magma", "2015-10-20 19:18:11", "2015-10-20 20:18:11", "41.213.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2513", "0", "magma", "2015-10-20 19:30:15", "2015-10-20 20:30:15", "46.193.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2514", "0", "magma", "2015-10-20 19:36:20", "2015-10-20 20:36:20", "221.149.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2515", "0", "magma", "2015-10-20 19:45:29", "2015-10-20 20:45:29", "123.254.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2516", "0", "magma", "2015-10-20 19:53:15", "2015-10-20 20:53:15", "86.98.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2517", "0", "magma", "2015-10-20 19:55:46", "2015-10-20 20:55:46", "2.51.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2518", "0", "admin", "2015-10-20 20:38:22", "2015-10-20 21:38:22", "178.20.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2519", "0", "magma", "2015-10-20 20:38:33", "2015-10-20 21:38:33", "86.134.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2520", "0", "magma", "2015-10-20 20:51:53", "2015-10-20 21:51:53", "64.185.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2521", "0", "magma", "2015-10-20 21:37:18", "2015-10-20 22:37:18", "190.150.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2522", "0", "magma", "2015-10-20 21:44:14", "2015-10-20 22:44:14", "81.61.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2523", "0", "magma", "2015-10-20 21:45:23", "2015-10-20 22:45:23", "79.177.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2524", "0", "magma", "2015-10-20 22:02:04", "2015-10-20 23:02:04", "103.232.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2525", "0", "magma", "2015-10-20 22:09:45", "2015-10-20 23:09:45", "195.26.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2526", "0", "magma", "2015-10-20 22:31:18", "2015-10-20 23:31:18", "86.98.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2527", "0", "magma", "2015-10-20 22:38:54", "2015-10-20 23:38:54", "71.95.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2528", "0", "magma", "2015-10-20 23:04:04", "2015-10-21 00:04:04", "81.237.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2529", "0", "magma", "2015-10-20 23:42:35", "2015-10-21 00:42:35", "41.143.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2530", "0", "magma", "2015-10-21 00:02:59", "2015-10-21 01:02:59", "121.6.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2531", "0", "magma", "2015-10-21 00:05:03", "2015-10-21 01:05:03", "188.26.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2532", "0", "magma", "2015-10-21 00:23:51", "2015-10-21 01:23:51", "191.7.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2533", "0", "magma", "2015-10-21 00:48:11", "2015-10-21 01:48:11", "93.163.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2534", "0", "magma", "2015-10-21 00:51:03", "2015-10-21 01:51:03", "86.10.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2535", "0", "magma", "2015-10-21 01:13:16", "2015-10-21 02:13:16", "177.223.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2536", "0", "magma", "2015-10-21 01:19:18", "2015-10-21 02:19:18", "92.53.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2537", "0", "magma", "2015-10-21 01:25:37", "2015-10-21 02:25:37", "27.38.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2538", "0", "magma", "2015-10-21 01:32:40", "2015-10-21 02:32:40", "91.206.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2539", "0", "magma", "2015-10-21 01:54:44", "2015-10-21 02:54:44", "191.7.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2540", "0", "magma", "2015-10-21 02:05:34", "2015-10-21 03:05:34", "93.173.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2541", "0", "magma", "2015-10-21 02:19:49", "2015-10-21 03:19:49", "197.38.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2542", "0", "magma", "2015-10-21 02:22:32", "2015-10-21 03:22:32", "94.197.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2543", "0", "admin", "2015-10-21 02:55:10", "2015-10-21 03:55:10", "94.242.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2544", "0", "magma", "2015-10-21 02:58:33", "2015-10-21 03:58:33", "149.78.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2545", "0", "magma", "2015-10-21 03:15:50", "2015-10-21 04:15:50", "85.130.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2546", "0", "magma", "2015-10-21 03:16:06", "2015-10-21 04:16:06", "92.53.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2547", "0", "admin", "2015-10-21 03:38:23", "2015-10-21 04:38:23", "51.254.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2548", "0", "magma", "2015-10-21 04:08:13", "2015-10-21 05:08:13", "181.55.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2549", "0", "magma", "2015-10-21 04:13:45", "2015-10-21 05:13:45", "115.134.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2550", "0", "magma", "2015-10-21 04:29:01", "2015-10-21 05:29:01", "41.59.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2551", "0", "magma", "2015-10-21 04:32:16", "2015-10-21 05:32:16", "174.52.250.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2552", "0", "magma", "2015-10-21 05:06:34", "2015-10-21 06:06:34", "189.51.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2553", "0", "magma", "2015-10-21 05:36:25", "2015-10-21 06:36:25", "103.232.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2554", "0", "magma", "2015-10-21 05:56:42", "2015-10-21 06:56:42", "117.202.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2555", "0", "magma", "2015-10-21 06:04:28", "2015-10-21 07:04:28", "80.174.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2556", "0", "admin", "2015-10-21 06:19:38", "2015-10-21 07:19:38", "5.196.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2557", "0", "magma", "2015-10-21 06:21:56", "2015-10-21 07:21:56", "94.60.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2558", "0", "magma", "2015-10-21 06:24:10", "2015-10-21 07:24:10", "46.162.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2559", "0", "magma", "2015-10-21 06:33:58", "2015-10-21 07:33:58", "41.207.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2560", "0", "magma", "2015-10-21 06:34:19", "2015-10-21 07:34:19", "87.237.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2561", "0", "magma", "2015-10-21 06:50:57", "2015-10-21 07:50:57", "186.11.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2562", "0", "magma", "2015-10-21 07:18:18", "2015-10-21 08:18:18", "14.97.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2563", "0", "magma", "2015-10-21 08:14:48", "2015-10-21 09:14:48", "175.140.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2564", "0", "magma", "2015-10-21 08:21:45", "2015-10-21 09:21:45", "212.107.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2565", "0", "magma", "2015-10-21 09:07:18", "2015-10-21 10:07:18", "112.211.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2566", "0", "magma", "2015-10-21 09:21:27", "2015-10-21 10:21:27", "93.184.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2567", "0", "magma", "2015-10-21 09:23:22", "2015-10-21 10:23:22", "39.42.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2568", "0", "magma", "2015-10-21 09:48:08", "2015-10-21 10:48:08", "85.254.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2569", "0", "magma", "2015-10-21 09:59:30", "2015-10-21 10:59:30", "78.63.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2570", "0", "magma", "2015-10-21 10:04:02", "2015-10-21 11:04:02", "85.102.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2571", "0", "magma", "2015-10-21 10:28:00", "2015-10-21 11:28:00", "154.66.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2572", "0", "magma", "2015-10-21 11:11:53", "2015-10-21 12:11:53", "125.19.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2573", "0", "magma", "2015-10-21 11:20:56", "2015-10-21 12:20:56", "95.94.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2574", "0", "magma", "2015-10-21 11:28:31", "2015-10-21 12:28:31", "78.11.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2575", "0", "magma", "2015-10-21 11:54:07", "2015-10-21 12:54:07", "93.103.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2576", "0", "magma", "2015-10-21 11:58:21", "2015-10-21 12:58:21", "198.200.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2577", "0", "admin", "2015-10-21 12:19:07", "2015-10-21 13:19:07", "79.120.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2578", "0", "admin", "2015-10-21 12:20:59", "2015-10-21 13:20:59", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2579", "0", "magma", "2015-10-21 12:29:58", "2015-10-21 13:29:58", "203.147.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2580", "0", "magma", "2015-10-21 12:30:37", "2015-10-21 13:30:37", "82.61.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2581", "0", "magma", "2015-10-21 12:42:09", "2015-10-21 13:42:09", "95.235.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2582", "0", "magma", "2015-10-21 13:24:45", "2015-10-21 14:24:45", "196.217.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2583", "0", "magma", "2015-10-21 13:39:47", "2015-10-21 14:39:47", "86.1.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2584", "0", "magma", "2015-10-21 13:58:47", "2015-10-21 14:58:47", "89.169.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2585", "0", "magma", "2015-10-21 14:01:24", "2015-10-21 15:01:24", "176.93.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2586", "0", "magma", "2015-10-21 14:07:14", "2015-10-21 15:07:14", "111.91.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2587", "0", "magma", "2015-10-21 14:16:47", "2015-10-21 15:16:47", "178.221.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2588", "0", "magma", "2015-10-21 14:23:26", "2015-10-21 15:23:26", "90.157.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2589", "0", "magma", "2015-10-21 14:40:31", "2015-10-21 15:40:31", "184.3.250.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2590", "0", "magma", "2015-10-21 15:09:07", "2015-10-21 16:09:07", "162.234.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2591", "0", "magma", "2015-10-21 15:17:19", "2015-10-21 16:17:19", "178.143.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2592", "0", "magma", "2015-10-21 15:19:09", "2015-10-21 16:19:09", "58.97.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2593", "0", "magma", "2015-10-21 15:38:24", "2015-10-21 16:38:24", "178.223.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2594", "0", "magma", "2015-10-21 15:44:26", "2015-10-21 16:44:26", "213.22.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2595", "0", "magma", "2015-10-21 16:02:00", "2015-10-21 17:02:00", "61.255.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2596", "0", "magma", "2015-10-21 16:27:49", "2015-10-21 17:27:49", "82.144.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2597", "0", "magma", "2015-10-21 16:38:01", "2015-10-21 17:38:01", "82.213.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2598", "0", "magma", "2015-10-21 16:45:54", "2015-10-21 17:45:54", "176.92.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2599", "0", "magma", "2015-10-21 16:56:52", "2015-10-21 17:56:52", "78.96.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2600", "0", "magma", "2015-10-21 17:18:37", "2015-10-21 18:18:37", "14.37.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2601", "0", "magma", "2015-10-21 17:39:06", "2015-10-21 18:39:06", "95.93.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2602", "0", "magma", "2015-10-21 18:20:40", "2015-10-21 19:20:40", "86.129.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2603", "0", "magma", "2015-10-21 18:25:41", "2015-10-21 19:25:41", "178.221.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2604", "0", "magma", "2015-10-21 18:30:09", "2015-10-21 19:30:09", "85.50.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2605", "0", "magma", "2015-10-21 19:01:02", "2015-10-21 20:01:02", "87.248.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2606", "0", "magma", "2015-10-21 19:29:15", "2015-10-21 20:29:15", "77.127.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2607", "0", "magma", "2015-10-21 19:44:05", "2015-10-21 20:44:05", "202.166.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2608", "0", "magma", "2015-10-21 19:45:08", "2015-10-21 20:45:08", "109.121.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2609", "0", "magma", "2015-10-21 22:13:36", "2015-10-21 23:13:36", "77.98.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2610", "0", "magma", "2015-10-21 22:27:37", "2015-10-21 23:27:37", "24.235.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2611", "0", "admin", "2015-10-21 22:40:18", "2015-10-21 23:40:18", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2612", "0", "admin", "2015-10-21 22:40:59", "2015-10-21 23:40:59", "89.187.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2613", "0", "magma", "2015-10-21 22:42:21", "2015-10-21 23:42:21", "41.72.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2614", "0", "magma", "2015-10-21 22:57:38", "2015-10-21 23:57:38", "104.137.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2615", "0", "magma", "2015-10-21 23:00:19", "2015-10-22 00:00:19", "86.217.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2616", "0", "magma", "2015-10-21 23:00:44", "2015-10-22 00:00:44", "79.181.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2617", "0", "magma", "2015-10-21 23:01:25", "2015-10-22 00:01:25", "41.103.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2618", "0", "magma", "2015-10-21 23:45:14", "2015-10-22 00:45:14", "186.194.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2619", "0", "admin", "2015-10-21 23:48:18", "2015-10-22 00:48:18", "213.142.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2620", "0", "magma", "2015-10-22 00:16:18", "2015-10-22 01:16:18", "73.233.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2621", "0", "magma", "2015-10-22 00:30:12", "2015-10-22 01:30:12", "182.55.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2622", "0", "magma", "2015-10-22 01:17:15", "2015-10-22 02:17:15", "5.66.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2623", "0", "magma", "2015-10-22 01:17:46", "2015-10-22 02:17:46", "5.54.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2624", "0", "magma", "2015-10-22 01:22:10", "2015-10-22 02:22:10", "141.237.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2625", "0", "magma", "2015-10-22 01:33:21", "2015-10-22 02:33:21", "77.127.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2626", "0", "magma", "2015-10-22 01:40:27", "2015-10-22 02:40:27", "79.18.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2627", "0", "magma", "2015-10-22 01:43:44", "2015-10-22 02:43:44", "199.192.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2628", "0", "magma", "2015-10-22 01:58:29", "2015-10-22 02:58:29", "92.12.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2629", "0", "magma", "2015-10-22 02:12:13", "2015-10-22 03:12:13", "23.116.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2630", "0", "magma", "2015-10-22 02:14:22", "2015-10-22 03:14:22", "31.16.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2631", "0", "magma", "2015-10-22 02:19:39", "2015-10-22 03:19:39", "94.231.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2632", "0", "magma", "2015-10-22 03:04:11", "2015-10-22 04:04:11", "5.66.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2633", "0", "magma", "2015-10-22 03:07:40", "2015-10-22 04:07:40", "81.237.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2634", "0", "magma", "2015-10-22 03:16:41", "2015-10-22 04:16:41", "98.94.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2635", "0", "magma", "2015-10-22 03:22:42", "2015-10-22 04:22:42", "2.49.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2636", "0", "magma", "2015-10-22 03:25:16", "2015-10-22 04:25:16", "116.74.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2637", "0", "magma", "2015-10-22 05:26:15", "2015-10-22 06:26:15", "103.248.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2638", "0", "magma", "2015-10-22 05:26:22", "2015-10-22 06:26:22", "104.35.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2639", "0", "magma", "2015-10-22 05:47:48", "2015-10-22 06:47:48", "94.60.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2640", "0", "magma", "2015-10-22 07:08:54", "2015-10-22 08:08:54", "1.22.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2641", "0", "admin", "2015-10-22 07:28:38", "2015-10-22 08:28:38", "199.127.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2642", "0", "admin", "2015-10-22 07:38:53", "2015-10-22 08:38:53", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2643", "0", "magma", "2015-10-22 08:00:56", "2015-10-22 09:00:56", "37.107.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2644", "0", "magma", "2015-10-22 09:15:15", "2015-10-22 10:15:15", "88.231.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2645", "0", "magma", "2015-10-22 09:33:44", "2015-10-22 10:33:44", "75.133.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2646", "0", "magma", "2015-10-22 09:52:28", "2015-10-22 10:52:28", "193.232.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2647", "0", "magma", "2015-10-22 10:16:01", "2015-10-22 11:16:01", "169.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2648", "0", "magma", "2015-10-22 10:17:57", "2015-10-22 11:17:57", "5.64.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2649", "0", "magma", "2015-10-22 11:06:23", "2015-10-22 12:06:23", "139.194.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2650", "0", "magma", "2015-10-22 11:11:50", "2015-10-22 12:11:50", "84.241.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2651", "0", "magma", "2015-10-22 11:33:01", "2015-10-22 12:33:01", "49.145.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2652", "0", "magma", "2015-10-22 11:59:34", "2015-10-22 12:59:34", "46.208.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2653", "0", "magma", "2015-10-22 12:29:42", "2015-10-22 13:29:42", "92.46.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2654", "0", "magma", "2015-10-22 12:50:19", "2015-10-22 13:50:19", "61.247.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2655", "0", "magma", "2015-10-22 12:57:35", "2015-10-22 13:57:35", "41.223.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2656", "0", "magma", "2015-10-22 13:23:28", "2015-10-22 14:23:28", "111.68.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2657", "0", "magma", "2015-10-22 14:22:27", "2015-10-22 15:22:27", "178.175.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2658", "0", "magma", "2015-10-22 14:23:37", "2015-10-22 15:23:37", "86.1.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2659", "0", "magma", "2015-10-22 14:32:47", "2015-10-22 15:32:47", "176.60.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2660", "0", "magma", "2015-10-22 15:16:39", "2015-10-22 16:16:39", "178.17.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2661", "0", "magma", "2015-10-22 15:18:02", "2015-10-22 16:18:02", "177.208.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2662", "0", "magma", "2015-10-22 15:27:49", "2015-10-22 16:27:49", "210.195.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2663", "0", "magma", "2015-10-22 15:45:48", "2015-10-22 16:45:48", "112.211.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2664", "0", "magma", "2015-10-22 15:52:02", "2015-10-22 16:52:02", "42.60.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2665", "0", "magma", "2015-10-22 15:58:09", "2015-10-22 16:58:09", "149.78.255.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2666", "0", "magma", "2015-10-22 16:04:05", "2015-10-22 17:04:05", "177.202.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2667", "0", "magma", "2015-10-22 16:04:17", "2015-10-22 17:04:17", "128.0.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2668", "0", "magma", "2015-10-22 16:08:23", "2015-10-22 17:08:23", "94.98.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2669", "0", "magma", "2015-10-22 16:13:51", "2015-10-22 17:13:51", "117.206.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2670", "0", "magma", "2015-10-22 16:27:52", "2015-10-22 17:27:52", "81.108.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2671", "0", "magma", "2015-10-22 16:27:56", "2015-10-22 17:27:56", "82.168.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2672", "0", "admin", "2015-10-22 16:31:23", "2015-10-22 17:31:23", "85.25.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2673", "0", "magma", "2015-10-22 16:43:42", "2015-10-22 17:43:42", "83.110.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2674", "0", "magma", "2015-10-22 16:48:56", "2015-10-22 17:48:56", "178.221.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2675", "0", "magma", "2015-10-22 16:54:33", "2015-10-22 17:54:33", "46.55.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2676", "0", "admin", "2015-10-22 16:55:56", "2015-10-22 17:55:56", "79.136.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2677", "0", "magma", "2015-10-22 16:58:56", "2015-10-22 17:58:56", "197.220.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2678", "0", "magma", "2015-10-22 17:25:23", "2015-10-22 18:25:23", "5.81.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2679", "0", "magma", "2015-10-22 17:44:32", "2015-10-22 18:44:32", "31.154.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2680", "0", "magma", "2015-10-22 17:48:56", "2015-10-22 18:48:56", "109.121.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2681", "0", "magma", "2015-10-22 17:52:25", "2015-10-22 18:52:25", "188.169.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2682", "0", "magma", "2015-10-22 18:14:38", "2015-10-22 19:14:38", "87.248.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2683", "0", "magma", "2015-10-22 18:20:19", "2015-10-22 19:20:19", "180.190.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2684", "0", "magma", "2015-10-22 18:27:54", "2015-10-22 19:27:54", "73.233.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2685", "0", "admin", "2015-10-22 18:29:14", "2015-10-22 19:29:14", "173.254.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2686", "0", "magma", "2015-10-22 18:34:17", "2015-10-22 19:34:17", "83.60.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2687", "0", "magma", "2015-10-22 19:04:22", "2015-10-22 20:04:22", "91.185.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2688", "0", "magma", "2015-10-22 19:18:11", "2015-10-22 20:18:11", "200.1.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2689", "0", "magma", "2015-10-22 19:31:31", "2015-10-22 20:31:31", "41.216.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2690", "0", "Admin", "2015-10-22 19:49:28", "2015-10-22 20:49:28", "195.154.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2691", "0", "magma", "2015-10-22 19:59:11", "2015-10-22 20:59:11", "154.123.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2692", "0", "magma", "2015-10-22 20:09:49", "2015-10-22 21:09:49", "173.168.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2693", "0", "magma", "2015-10-22 20:18:50", "2015-10-22 21:18:50", "86.104.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2694", "0", "magma", "2015-10-22 20:28:02", "2015-10-22 21:28:02", "119.94.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2695", "0", "magma", "2015-10-22 20:36:13", "2015-10-22 21:36:13", "89.137.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2696", "0", "magma", "2015-10-22 20:43:20", "2015-10-22 21:43:20", "177.16.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2697", "0", "magma", "2015-10-22 20:46:04", "2015-10-22 21:46:04", "5.55.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2698", "0", "magma", "2015-10-22 21:06:44", "2015-10-22 22:06:44", "78.145.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2699", "0", "magma", "2015-10-22 21:36:03", "2015-10-22 22:36:03", "92.0.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2700", "0", "magma", "2015-10-22 21:56:18", "2015-10-22 22:56:18", "93.43.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2701", "0", "magma", "2015-10-22 22:07:11", "2015-10-22 23:07:11", "202.69.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2702", "0", "magma", "2015-10-22 22:13:31", "2015-10-22 23:13:31", "119.235.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2703", "0", "magma", "2015-10-22 22:39:34", "2015-10-22 23:39:34", "89.69.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2704", "0", "magma", "2015-10-22 23:14:05", "2015-10-23 00:14:05", "189.51.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2705", "0", "magma", "2015-10-22 23:17:58", "2015-10-23 00:17:58", "177.125.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2706", "0", "magma", "2015-10-23 00:24:56", "2015-10-23 01:24:56", "41.68.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2707", "0", "magma", "2015-10-23 00:38:29", "2015-10-23 01:38:29", "79.177.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2708", "0", "admin", "2015-10-23 01:45:27", "2015-10-23 02:45:27", "62.141.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2709", "0", "magma", "2015-10-23 01:48:24", "2015-10-23 02:48:24", "93.163.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2710", "0", "magma", "2015-10-23 02:02:21", "2015-10-23 03:02:21", "93.108.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2711", "0", "admin", "2015-10-23 02:16:18", "2015-10-23 03:16:18", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2712", "0", "magma", "2015-10-23 02:30:54", "2015-10-23 03:30:54", "209.131.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2713", "0", "magma", "2015-10-23 03:38:10", "2015-10-23 04:38:10", "110.77.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2714", "0", "admin", "2015-10-23 03:52:37", "2015-10-23 04:52:37", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2715", "0", "magma", "2015-10-23 05:35:55", "2015-10-23 06:35:55", "58.104.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2716", "0", "magma", "2015-10-23 06:11:23", "2015-10-23 07:11:23", "89.137.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2717", "0", "magma", "2015-10-23 07:03:16", "2015-10-23 08:03:16", "24.96.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2718", "0", "magma", "2015-10-23 07:06:34", "2015-10-23 08:06:34", "36.37.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2719", "0", "magma", "2015-10-23 07:12:37", "2015-10-23 08:12:37", "93.177.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2720", "0", "magma", "2015-10-23 07:54:44", "2015-10-23 08:54:44", "103.248.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2721", "0", "magma", "2015-10-23 07:55:42", "2015-10-23 08:55:42", "222.124.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2722", "0", "magma", "2015-10-23 09:29:12", "2015-10-23 10:29:12", "86.104.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2723", "0", "magma", "2015-10-23 09:47:01", "2015-10-23 10:47:01", "222.238.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2724", "0", "magma", "2015-10-23 11:32:42", "2015-10-23 12:32:42", "79.177.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2725", "0", "magma", "2015-10-23 12:16:41", "2015-10-23 13:16:41", "179.211.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2726", "0", "magma", "2015-10-23 12:18:52", "2015-10-23 13:18:52", "2.126.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2727", "0", "magma", "2015-10-23 13:18:51", "2015-10-23 14:18:51", "178.197.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2728", "0", "magma", "2015-10-23 14:08:37", "2015-10-23 15:08:37", "27.77.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2729", "0", "magma", "2015-10-23 14:09:26", "2015-10-23 15:09:26", "110.93.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2730", "0", "magma", "2015-10-23 14:34:37", "2015-10-23 15:34:37", "188.77.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2731", "0", "magma", "2015-10-23 15:13:33", "2015-10-23 16:13:33", "62.42.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2732", "0", "magma", "2015-10-23 15:43:05", "2015-10-23 16:43:05", "197.156.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2733", "0", "magma", "2015-10-23 16:44:02", "2015-10-23 17:44:02", "79.108.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2734", "0", "magma", "2015-10-23 17:20:22", "2015-10-23 18:20:22", "117.200.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2735", "0", "magma", "2015-10-23 17:55:47", "2015-10-23 18:55:47", "39.32.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2736", "0", "magma", "2015-10-23 18:01:19", "2015-10-23 19:01:19", "95.42.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2737", "0", "admin", "2015-10-23 18:31:17", "2015-10-23 19:31:17", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2738", "0", "magma", "2015-10-23 18:50:56", "2015-10-23 19:50:56", "115.124.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2739", "0", "magma", "2015-10-23 19:03:30", "2015-10-23 20:03:30", "188.126.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2740", "0", "magma", "2015-10-23 19:17:33", "2015-10-23 20:17:33", "154.67.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2741", "0", "magma", "2015-10-23 20:04:42", "2015-10-23 21:04:42", "180.191.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2742", "0", "magma", "2015-10-23 21:31:49", "2015-10-23 22:31:49", "183.90.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2743", "0", "magma", "2015-10-23 21:38:59", "2015-10-23 22:38:59", "68.123.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2744", "0", "magma", "2015-10-23 21:59:31", "2015-10-23 22:59:31", "18