/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2016-09-01 07:15:25 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `eadsk_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_ci,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_failed_logins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_attempt_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6856 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_login_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `logout_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `release_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3981 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `eadsk_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=14410 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1511 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=490 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eadsk_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: eadsk_aiowps_failed_logins */
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1856", "1", "admin8576", "2015-09-27 05:32:33", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1857", "1", "admin8576", "2015-09-27 06:08:50", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1858", "1", "admin8576", "2015-09-27 06:42:10", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1859", "0", "magma", "2015-09-27 06:58:29", "98.177.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1860", "1", "admin8576", "2015-09-27 07:14:01", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1861", "1", "admin8576", "2015-09-27 07:42:50", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1862", "1", "admin8576", "2015-09-27 08:11:51", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1863", "0", "magma", "2015-09-27 08:31:55", "87.68.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1864", "1", "admin8576", "2015-09-27 08:41:10", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1865", "1", "admin8576", "2015-09-27 09:10:13", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1866", "1", "admin8576", "2015-09-27 09:39:45", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1867", "1", "admin8576", "2015-09-27 10:09:14", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1868", "1", "admin8576", "2015-09-27 10:38:07", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1869", "1", "admin8576", "2015-09-27 11:06:59", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1870", "1", "admin8576", "2015-09-27 11:36:00", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1871", "1", "admin8576", "2015-09-27 12:05:14", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1872", "0", "magma", "2015-09-27 12:20:05", "46.116.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1873", "1", "admin8576", "2015-09-27 12:36:33", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1874", "1", "admin8576", "2015-09-27 13:05:32", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1875", "0", "magma", "2015-09-27 13:25:01", "124.104.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1876", "1", "admin8576", "2015-09-27 13:34:38", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1877", "0", "magma", "2015-09-27 13:58:39", "176.109.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1878", "1", "admin8576", "2015-09-27 14:03:52", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1879", "1", "admin8576", "2015-09-27 14:33:07", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1880", "1", "admin8576", "2015-09-27 15:02:32", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1881", "0", "magma", "2015-09-27 15:12:46", "46.176.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1882", "1", "admin8576", "2015-09-27 15:31:53", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1883", "1", "admin8576", "2015-09-27 16:01:09", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1884", "1", "admin8576", "2015-09-27 16:30:30", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1885", "0", "magma", "2015-09-27 16:48:56", "112.210.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1886", "1", "admin8576", "2015-09-27 17:00:09", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1887", "0", "magma", "2015-09-27 17:02:22", "46.176.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1888", "0", "magma", "2015-09-27 17:06:03", "109.92.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1889", "0", "magma", "2015-09-27 17:23:09", "77.249.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1890", "0", "magma", "2015-09-27 17:24:11", "109.98.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1891", "1", "admin8576", "2015-09-27 17:30:17", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1892", "0", "magma", "2015-09-27 17:53:23", "118.100.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1893", "1", "admin8576", "2015-09-27 18:00:25", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1894", "1", "admin8576", "2015-09-27 18:30:14", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1895", "1", "admin8576", "2015-09-27 18:59:57", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1896", "0", "magma", "2015-09-27 19:02:19", "186.137.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1897", "0", "magma", "2015-09-27 19:11:08", "89.164.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1898", "1", "admin8576", "2015-09-27 19:30:05", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1899", "0", "magma", "2015-09-27 19:37:17", "95.86.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1900", "0", "magma", "2015-09-27 19:41:05", "93.103.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1901", "1", "admin8576", "2015-09-27 19:59:22", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1902", "1", "admin8576", "2015-09-27 20:29:18", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1903", "1", "admin8576", "2015-09-27 20:59:10", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1904", "0", "magma", "2015-09-27 21:08:33", "5.228.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1905", "0", "magma", "2015-09-27 21:14:54", "189.176.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1906", "1", "admin8576", "2015-09-27 21:29:20", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1907", "0", "magma", "2015-09-27 21:54:09", "95.76.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1908", "0", "magma", "2015-09-27 21:58:21", "83.83.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1909", "1", "admin8576", "2015-09-27 21:59:12", "199.195.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1910", "0", "magma", "2015-09-27 22:21:52", "188.2.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1911", "0", "magma", "2015-09-28 03:35:13", "109.92.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1912", "1", "admin8576", "2015-09-28 05:25:05", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1913", "1", "admin8576", "2015-09-28 06:00:41", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1914", "1", "admin8576", "2015-09-28 06:36:50", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1915", "1", "admin8576", "2015-09-28 07:13:13", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1916", "1", "admin8576", "2015-09-28 07:50:02", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1917", "0", "magma", "2015-09-28 07:55:18", "186.137.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1918", "1", "admin8576", "2015-09-28 08:26:54", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1919", "1", "admin8576", "2015-09-28 09:03:25", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1920", "0", "magma", "2015-09-28 09:38:58", "83.168.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1921", "1", "admin8576", "2015-09-28 09:40:35", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1922", "1", "admin8576", "2015-09-28 10:17:59", "5.254.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1923", "0", "magma", "2015-09-28 10:54:45", "193.248.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1924", "1", "admin8576", "2015-09-28 10:55:36", "188.227.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1925", "1", "admin8576", "2015-09-28 11:32:10", "188.227.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1926", "1", "admin8576", "2015-09-28 12:08:52", "188.227.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1927", "1", "admin8576", "2015-09-28 12:45:48", "188.227.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1928", "0", "magma", "2015-09-28 13:04:43", "79.106.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1929", "0", "magma", "2015-09-28 15:01:29", "31.41.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1930", "0", "magma", "2015-09-28 15:22:10", "109.245.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1931", "0", "magma", "2015-09-28 15:50:09", "123.231.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1932", "0", "magma", "2015-09-28 16:04:40", "190.147.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1933", "0", "magma", "2015-09-28 16:47:01", "46.70.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1934", "0", "magma", "2015-09-28 17:01:45", "93.168.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1935", "0", "magma", "2015-09-28 17:50:24", "108.181.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1936", "0", "magma", "2015-09-28 18:11:06", "188.2.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1937", "0", "magma", "2015-09-28 18:31:38", "197.89.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1938", "0", "magma", "2015-09-28 19:18:22", "123.231.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1939", "0", "magma", "2015-09-28 19:23:24", "42.60.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1940", "0", "magma", "2015-09-28 19:32:29", "24.92.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1941", "0", "magma", "2015-09-28 21:18:57", "95.170.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1942", "0", "magma", "2015-09-28 22:21:39", "95.76.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1943", "0", "magma", "2015-09-29 00:26:32", "115.135.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1944", "0", "magma", "2015-09-29 03:23:41", "78.158.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1945", "0", "magma", "2015-09-29 03:38:36", "37.27.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1946", "0", "magma", "2015-09-29 03:42:56", "81.183.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1947", "0", "magma", "2015-09-29 04:58:41", "174.97.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1948", "0", "magma", "2015-09-29 06:25:30", "1.52.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1949", "0", "magma", "2015-09-29 06:26:29", "112.209.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1950", "0", "magma", "2015-09-29 07:37:20", "186.121.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1951", "0", "magma", "2015-09-29 10:21:09", "176.40.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1952", "0", "magma", "2015-09-29 10:50:05", "93.103.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1953", "0", "magma", "2015-09-29 11:01:44", "182.185.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1954", "0", "magma", "2015-09-29 11:37:11", "79.129.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1955", "0", "magma", "2015-09-29 12:10:50", "79.112.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1956", "0", "magma", "2015-09-29 12:55:25", "180.250.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1957", "0", "admin", "2015-09-29 13:03:43", "92.222.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1958", "0", "admin", "2015-09-29 14:48:00", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1959", "0", "magma", "2015-09-29 14:54:10", "89.121.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1960", "0", "magma", "2015-09-29 15:36:49", "1.32.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1961", "0", "admin", "2015-09-29 15:47:20", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1962", "0", "magma", "2015-09-29 16:10:39", "118.101.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1963", "0", "magma", "2015-09-29 16:22:06", "82.231.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1964", "0", "magma", "2015-09-29 16:50:38", "104.200.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1965", "0", "magma", "2015-09-29 16:52:47", "89.44.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1966", "0", "admin", "2015-09-29 17:00:59", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1967", "0", "magma", "2015-09-29 17:38:22", "5.197.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1968", "0", "admin", "2015-09-29 17:55:30", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1969", "0", "magma", "2015-09-29 18:04:34", "121.99.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1970", "0", "magma", "2015-09-29 18:25:29", "112.207.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1971", "0", "magma", "2015-09-29 18:39:22", "104.200.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1972", "0", "magma", "2015-09-29 20:07:14", "109.92.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1973", "0", "magma", "2015-09-29 22:24:54", "196.205.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1974", "0", "magma", "2015-09-29 23:14:12", "176.32.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1975", "0", "magma", "2015-09-30 00:20:31", "178.221.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1976", "0", "magma", "2015-09-30 00:22:24", "109.98.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1977", "0", "magma", "2015-09-30 01:52:26", "115.99.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1978", "0", "admin", "2015-09-30 04:03:03", "178.63.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1979", "0", "magma", "2015-09-30 04:19:52", "176.40.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1980", "0", "magma", "2015-09-30 05:25:33", "92.80.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1981", "0", "magma", "2015-09-30 05:48:39", "1.52.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1982", "0", "admin", "2015-09-30 05:56:48", "91.109.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1983", "0", "magma", "2015-09-30 05:59:03", "109.76.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1984", "0", "magma", "2015-09-30 06:03:40", "49.146.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1985", "0", "magma", "2015-09-30 06:48:18", "178.221.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1986", "0", "admin", "2015-09-30 06:57:04", "85.24.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1987", "0", "magma", "2015-09-30 06:59:11", "1.52.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1988", "0", "admin", "2015-09-30 08:15:28", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1989", "0", "magma", "2015-09-30 09:03:56", "203.124.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1990", "0", "magma", "2015-09-30 09:04:27", "210.7.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1991", "0", "admin", "2015-09-30 09:09:18", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1992", "0", "magma", "2015-09-30 10:18:32", "151.250.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1993", "1", "admin8576", "2015-09-30 14:00:12", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1994", "1", "admin8576", "2015-09-30 14:27:30", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1995", "1", "admin8576", "2015-09-30 14:54:29", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1996", "1", "admin8576", "2015-09-30 15:22:24", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1997", "0", "magma", "2015-09-30 15:39:39", "188.2.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1998", "0", "magma", "2015-09-30 15:44:36", "187.107.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("1999", "1", "admin8576", "2015-09-30 15:51:18", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2000", "1", "admin8576", "2015-09-30 16:19:39", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2001", "1", "admin8576", "2015-09-30 16:47:58", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2002", "1", "admin8576", "2015-09-30 17:16:49", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2003", "1", "admin8576", "2015-09-30 17:44:44", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2004", "0", "magma", "2015-09-30 17:51:32", "197.255.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2005", "1", "admin8576", "2015-09-30 18:09:37", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2006", "1", "admin8576", "2015-09-30 18:39:31", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2007", "1", "admin8576", "2015-09-30 19:07:59", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2008", "0", "magma", "2015-09-30 19:22:30", "89.44.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2009", "0", "admin", "2015-09-30 19:27:14", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2010", "0", "magma", "2015-09-30 19:35:43", "81.64.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2011", "1", "admin8576", "2015-09-30 19:35:52", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2012", "0", "magma", "2015-09-30 19:51:24", "2.85.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2013", "0", "magma", "2015-09-30 19:57:39", "188.36.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2014", "1", "admin8576", "2015-09-30 20:05:59", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2015", "1", "admin8576", "2015-09-30 20:36:26", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2016", "1", "admin8576", "2015-09-30 21:07:15", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2017", "0", "admin", "2015-09-30 21:13:09", "185.29.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2018", "0", "magma", "2015-09-30 21:13:15", "149.78.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2019", "1", "admin8576", "2015-09-30 21:37:43", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2020", "0", "admin", "2015-09-30 22:07:13", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2021", "1", "admin8576", "2015-09-30 22:08:25", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2022", "0", "magma", "2015-09-30 22:34:42", "95.187.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2023", "1", "admin8576", "2015-09-30 22:38:35", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2024", "0", "magma", "2015-09-30 23:08:32", "189.70.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2025", "1", "admin8576", "2015-09-30 23:08:51", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2026", "0", "admin", "2015-09-30 23:20:35", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2027", "1", "admin8576", "2015-09-30 23:38:47", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2028", "0", "magma", "2015-09-30 23:48:45", "31.11.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2029", "0", "admin", "2015-10-01 00:05:55", "64.113.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2030", "1", "admin8576", "2015-10-01 00:08:59", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2031", "1", "admin8576", "2015-10-01 00:38:32", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2032", "0", "magma", "2015-10-01 00:44:09", "186.210.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2033", "1", "admin8576", "2015-10-01 01:08:35", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2034", "1", "admin8576", "2015-10-01 01:38:55", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2035", "0", "magma", "2015-10-01 01:59:31", "46.121.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2036", "1", "admin8576", "2015-10-01 02:10:25", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2037", "1", "admin8576", "2015-10-01 02:42:12", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2038", "1", "admin8576", "2015-10-01 03:13:24", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2039", "1", "admin8576", "2015-10-01 03:45:26", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2040", "1", "admin8576", "2015-10-01 04:16:59", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2041", "1", "admin8576", "2015-10-01 04:48:24", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2042", "1", "admin8576", "2015-10-01 05:19:37", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2043", "1", "admin8576", "2015-10-01 05:52:11", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2044", "1", "admin8576", "2015-10-01 06:23:31", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2045", "1", "admin8576", "2015-10-01 06:54:24", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2046", "0", "magma", "2015-10-01 07:17:41", "49.207.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2047", "1", "admin8576", "2015-10-01 07:24:50", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2048", "1", "admin8576", "2015-10-01 07:56:19", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2049", "1", "admin8576", "2015-10-01 08:27:59", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2050", "0", "magma", "2015-10-01 08:41:32", "107.77.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2051", "0", "magma", "2015-10-01 08:44:59", "183.91.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2052", "1", "admin8576", "2015-10-01 08:58:57", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2053", "0", "magma", "2015-10-01 09:19:40", "37.127.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2054", "0", "admin", "2015-10-01 09:22:22", "92.222.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2055", "0", "magma", "2015-10-01 09:28:03", "197.221.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2056", "1", "admin8576", "2015-10-01 09:30:21", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2057", "1", "admin8576", "2015-10-01 10:00:02", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2058", "1", "admin8576", "2015-10-01 10:29:35", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2059", "0", "admin", "2015-10-01 10:56:40", "204.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2060", "1", "admin8576", "2015-10-01 10:58:58", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2061", "1", "admin8576", "2015-10-01 11:28:21", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2062", "0", "admin", "2015-10-01 11:41:13", "5.196.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2063", "0", "magma", "2015-10-01 11:42:00", "41.134.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2064", "1", "admin8576", "2015-10-01 11:57:41", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2065", "1", "admin8576", "2015-10-01 12:27:03", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2066", "0", "magma", "2015-10-01 12:32:30", "41.109.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2067", "0", "admin", "2015-10-01 12:53:45", "162.244.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2068", "1", "admin8576", "2015-10-01 12:56:28", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2069", "1", "admin8576", "2015-10-01 13:26:29", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2070", "0", "admin", "2015-10-01 13:33:56", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2071", "0", "magma", "2015-10-01 13:43:18", "212.93.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2072", "0", "magma", "2015-10-01 13:51:05", "59.92.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2073", "1", "admin8576", "2015-10-01 13:56:15", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2074", "1", "admin8576", "2015-10-01 14:25:58", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2075", "1", "admin8576", "2015-10-01 14:55:38", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2076", "0", "magma", "2015-10-01 15:17:35", "217.71.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2077", "1", "admin8576", "2015-10-01 15:25:44", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2078", "1", "admin8576", "2015-10-01 15:56:05", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2079", "0", "magma", "2015-10-01 16:01:46", "92.87.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2080", "1", "admin8576", "2015-10-01 16:26:37", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2081", "1", "admin8576", "2015-10-01 16:56:11", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2082", "1", "admin8576", "2015-10-01 17:25:34", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2083", "0", "magma", "2015-10-01 17:54:58", "79.116.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2084", "1", "admin8576", "2015-10-01 17:55:25", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2085", "0", "magma", "2015-10-01 17:56:27", "87.68.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2086", "0", "magma", "2015-10-01 18:17:01", "201.33.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2087", "0", "magma", "2015-10-01 18:17:13", "77.253.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2088", "0", "magma", "2015-10-01 18:20:25", "39.35.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2089", "1", "admin8576", "2015-10-01 18:26:16", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2090", "0", "magma", "2015-10-01 18:32:19", "2.177.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2091", "0", "magma", "2015-10-01 18:49:19", "79.177.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2092", "1", "admin8576", "2015-10-01 19:02:35", "93.190.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2093", "0", "magma", "2015-10-01 19:48:29", "37.217.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2094", "0", "magma", "2015-10-01 20:38:29", "79.36.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2095", "0", "magma", "2015-10-01 20:39:48", "5.197.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2096", "0", "magma", "2015-10-01 21:11:23", "95.95.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2097", "0", "magma", "2015-10-01 21:15:09", "41.59.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2098", "0", "magma", "2015-10-01 21:23:02", "81.244.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2099", "0", "magma", "2015-10-01 21:27:54", "58.65.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2100", "0", "magma", "2015-10-01 21:42:06", "100.96.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2101", "0", "magma", "2015-10-01 22:40:21", "217.254.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2102", "0", "magma", "2015-10-01 23:04:10", "78.61.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2103", "0", "admin", "2015-10-01 23:39:10", "198.100.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2104", "0", "magma", "2015-10-01 23:51:01", "210.212.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2105", "0", "magma", "2015-10-02 00:56:23", "188.2.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2106", "1", "admin8576", "2015-10-02 01:07:35", "95.211.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2107", "0", "admin", "2015-10-02 01:14:17", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2108", "0", "magma", "2015-10-02 01:27:05", "93.41.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2109", "1", "admin8576", "2015-10-02 01:43:11", "95.211.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2110", "0", "admin", "2015-10-02 01:54:45", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2111", "0", "magma", "2015-10-02 02:20:23", "200.90.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2112", "0", "magma", "2015-10-02 02:48:21", "172.7.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2113", "0", "admin", "2015-10-02 03:05:28", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2114", "0", "magma", "2015-10-02 03:08:43", "37.27.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2115", "0", "admin", "2015-10-02 03:39:52", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2116", "0", "magma", "2015-10-02 06:42:52", "121.75.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2117", "0", "magma", "2015-10-02 07:39:53", "61.18.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2118", "0", "magma", "2015-10-02 08:35:04", "109.186.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2119", "1", "admin8576", "2015-10-02 08:37:28", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2120", "0", "magma", "2015-10-02 09:07:27", "37.27.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2121", "1", "admin8576", "2015-10-02 09:13:24", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2122", "0", "magma", "2015-10-02 09:15:30", "94.176.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2123", "1", "admin8576", "2015-10-02 09:47:52", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2124", "0", "magma", "2015-10-02 10:17:04", "79.118.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2125", "1", "admin8576", "2015-10-02 10:21:34", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2126", "1", "admin8576", "2015-10-02 10:53:50", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2127", "0", "magma", "2015-10-02 11:01:17", "84.2.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2128", "0", "magma", "2015-10-02 11:16:12", "91.206.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2129", "0", "magma", "2015-10-02 11:20:31", "125.18.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2130", "1", "admin8576", "2015-10-02 11:24:29", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2131", "1", "admin8576", "2015-10-02 11:55:46", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2132", "0", "magma", "2015-10-02 12:14:08", "117.195.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2133", "0", "magma", "2015-10-02 12:16:06", "84.1.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2134", "1", "admin8576", "2015-10-02 12:20:48", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2135", "1", "admin8576", "2015-10-02 12:27:13", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2136", "0", "magma", "2015-10-02 12:51:19", "41.139.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2137", "1", "admin8576", "2015-10-02 12:58:27", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2138", "0", "magma", "2015-10-02 13:05:32", "194.79.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2139", "1", "admin8576", "2015-10-02 13:30:12", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2140", "1", "admin8576", "2015-10-02 14:01:10", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2141", "1", "admin8576", "2015-10-02 14:16:16", "176.123.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2142", "0", "admin", "2015-10-02 14:23:45", "94.26.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2143", "1", "admin8576", "2015-10-02 14:31:42", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2144", "0", "magma", "2015-10-02 14:58:07", "160.177.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2145", "0", "admin", "2015-10-02 15:02:17", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2146", "0", "admin", "2015-10-02 15:02:17", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2147", "1", "admin8576", "2015-10-02 15:03:17", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2148", "1", "admin8576", "2015-10-02 15:37:08", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2149", "0", "magma", "2015-10-02 15:38:05", "197.156.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2150", "1", "admin8576", "2015-10-02 16:11:29", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2151", "0", "magma", "2015-10-02 16:14:40", "46.116.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2152", "0", "admin", "2015-10-02 16:23:30", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2153", "1", "admin8576", "2015-10-02 16:32:31", "176.123.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2154", "1", "admin8576", "2015-10-02 16:43:43", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2155", "0", "admin", "2015-10-02 16:56:32", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2156", "0", "magma", "2015-10-02 17:00:23", "89.121.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2157", "0", "magma", "2015-10-02 17:02:55", "27.130.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2158", "0", "magma", "2015-10-02 17:14:20", "43.224.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2159", "1", "admin8576", "2015-10-02 17:23:24", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2160", "1", "admin8576", "2015-10-02 17:56:13", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2161", "0", "magma", "2015-10-02 18:10:29", "109.98.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2162", "1", "admin8576", "2015-10-02 18:24:47", "176.123.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2163", "1", "admin8576", "2015-10-02 18:26:46", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2164", "0", "magma", "2015-10-02 18:34:02", "117.0.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2165", "0", "magma", "2015-10-02 18:49:34", "176.12.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2166", "1", "admin8576", "2015-10-02 18:57:10", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2167", "1", "admin8576", "2015-10-02 19:28:07", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2168", "0", "magma", "2015-10-02 19:43:34", "77.81.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2169", "1", "admin8576", "2015-10-02 19:59:30", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2170", "1", "admin8576", "2015-10-02 20:31:45", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2171", "0", "magma", "2015-10-02 20:56:48", "46.103.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2172", "1", "admin8576", "2015-10-02 21:04:49", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2173", "0", "magma", "2015-10-02 21:25:05", "126.64.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2174", "1", "admin8576", "2015-10-02 21:37:51", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2175", "0", "magma", "2015-10-02 21:48:25", "5.197.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2176", "0", "magma", "2015-10-02 21:52:42", "77.46.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2177", "0", "magma", "2015-10-02 21:56:18", "93.57.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2178", "1", "admin8576", "2015-10-02 22:07:49", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2179", "0", "magma", "2015-10-02 22:11:29", "188.2.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2180", "1", "admin8576", "2015-10-02 22:38:56", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2181", "0", "magma", "2015-10-02 22:47:52", "46.214.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2182", "0", "magma", "2015-10-02 23:09:12", "95.246.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2183", "1", "admin8576", "2015-10-02 23:10:05", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2184", "0", "magma", "2015-10-02 23:39:58", "60.53.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2185", "1", "admin8576", "2015-10-02 23:41:04", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2186", "1", "admin8576", "2015-10-03 00:11:33", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2187", "0", "magma", "2015-10-03 00:16:45", "197.32.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2188", "0", "magma", "2015-10-03 00:21:42", "112.204.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2189", "0", "magma", "2015-10-03 00:29:31", "190.60.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2190", "1", "admin8576", "2015-10-03 00:41:58", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2191", "1", "admin8576", "2015-10-03 01:12:45", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2192", "0", "magma", "2015-10-03 01:13:18", "49.150.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2193", "0", "magma", "2015-10-03 01:25:12", "191.183.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2194", "0", "magma", "2015-10-03 01:42:37", "178.220.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2195", "1", "admin8576", "2015-10-03 01:43:33", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2196", "1", "admin8576", "2015-10-03 02:14:21", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2197", "0", "magma", "2015-10-03 02:23:04", "81.182.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2198", "0", "magma", "2015-10-03 02:44:49", "200.88.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2199", "1", "admin8576", "2015-10-03 02:46:21", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2200", "1", "admin8576", "2015-10-03 03:17:32", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2201", "1", "admin8576", "2015-10-03 03:47:21", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2202", "1", "admin8576", "2015-10-03 04:16:32", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2203", "0", "admin", "2015-10-03 04:17:22", "176.31.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2204", "0", "magma", "2015-10-03 04:33:19", "116.237.111.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2205", "0", "admin", "2015-10-03 04:44:23", "5.135.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2206", "1", "admin8576", "2015-10-03 04:45:57", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2207", "1", "admin8576", "2015-10-03 05:15:54", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2208", "1", "admin8576", "2015-10-03 05:46:35", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2209", "0", "admin", "2015-10-03 06:04:07", "212.232.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2210", "1", "admin8576", "2015-10-03 06:17:02", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2211", "0", "admin", "2015-10-03 06:28:40", "176.31.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2212", "0", "admin", "2015-10-03 06:39:25", "158.69.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2213", "1", "admin8576", "2015-10-03 06:46:14", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2214", "1", "admin8576", "2015-10-03 07:14:35", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2215", "1", "admin8576", "2015-10-03 07:43:00", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2216", "0", "magma", "2015-10-03 08:10:08", "122.57.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2217", "1", "admin8576", "2015-10-03 08:11:53", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2218", "0", "magma", "2015-10-03 08:26:08", "27.109.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2219", "1", "admin8576", "2015-10-03 08:39:53", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2220", "1", "admin8576", "2015-10-03 09:09:14", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2221", "1", "admin8576", "2015-10-03 09:38:08", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2222", "0", "magma", "2015-10-03 10:03:17", "119.92.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2223", "1", "admin8576", "2015-10-03 10:06:34", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2224", "0", "magma", "2015-10-03 10:23:29", "77.29.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2225", "0", "magma", "2015-10-03 10:24:58", "112.204.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2226", "1", "admin8576", "2015-10-03 10:35:44", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2227", "0", "magma", "2015-10-03 10:52:45", "78.61.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2228", "1", "admin8576", "2015-10-03 11:04:48", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2229", "0", "magma", "2015-10-03 11:08:54", "176.41.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2230", "0", "magma", "2015-10-03 11:28:29", "211.18.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2231", "1", "admin8576", "2015-10-03 11:35:45", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2232", "1", "admin8576", "2015-10-03 11:48:52", "176.123.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2233", "1", "admin8576", "2015-10-03 12:05:55", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2234", "1", "admin8576", "2015-10-03 12:34:56", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2235", "1", "admin8576", "2015-10-03 13:03:44", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2236", "1", "admin8576", "2015-10-03 13:33:06", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2237", "1", "admin8576", "2015-10-03 14:01:44", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2238", "0", "magma", "2015-10-03 14:22:37", "112.207.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2239", "1", "admin8576", "2015-10-03 14:31:38", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2240", "1", "admin8576", "2015-10-03 14:56:13", "176.123.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2241", "1", "admin8576", "2015-10-03 15:03:26", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2242", "0", "magma", "2015-10-03 15:29:32", "77.36.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2243", "0", "magma", "2015-10-03 15:30:57", "2.133.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2244", "1", "admin8576", "2015-10-03 15:34:00", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2245", "1", "admin8576", "2015-10-03 16:04:03", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2246", "1", "admin8576", "2015-10-03 16:34:18", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2247", "0", "admin", "2015-10-03 16:40:22", "62.210.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2248", "1", "admin8576", "2015-10-03 16:49:29", "176.123.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2249", "1", "admin8576", "2015-10-03 17:05:48", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2250", "0", "magma", "2015-10-03 17:23:42", "149.78.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2251", "1", "admin8576", "2015-10-03 17:34:43", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2252", "0", "magma", "2015-10-03 17:38:33", "109.92.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2253", "0", "magma", "2015-10-03 17:47:22", "84.94.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2254", "0", "magma", "2015-10-03 18:02:26", "59.178.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2255", "1", "admin8576", "2015-10-03 18:04:26", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2256", "1", "admin8576", "2015-10-03 18:33:50", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2257", "0", "magma", "2015-10-03 18:40:55", "192.0.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2258", "0", "magma", "2015-10-03 18:58:07", "46.167.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2259", "0", "magma", "2015-10-03 19:02:17", "88.159.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2260", "0", "magma", "2015-10-03 19:02:41", "86.19.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2261", "1", "admin8576", "2015-10-03 19:04:47", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2262", "0", "magma", "2015-10-03 19:06:21", "103.51.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2263", "0", "magma", "2015-10-03 19:12:54", "71.198.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2264", "0", "magma", "2015-10-03 19:13:25", "141.237.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2265", "0", "magma", "2015-10-03 19:16:06", "118.70.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2266", "0", "magma", "2015-10-03 19:25:52", "46.219.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2267", "0", "magma", "2015-10-03 19:28:22", "142.51.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2268", "0", "magma", "2015-10-03 19:31:06", "151.33.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2269", "1", "admin8576", "2015-10-03 19:33:05", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2270", "0", "magma", "2015-10-03 19:44:47", "177.188.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2271", "0", "magma", "2015-10-03 19:46:29", "200.35.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2272", "0", "magma", "2015-10-03 19:57:34", "172.16.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2273", "0", "magma", "2015-10-03 19:59:31", "105.154.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2274", "0", "magma", "2015-10-03 20:01:11", "93.11.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2275", "1", "admin8576", "2015-10-03 20:02:04", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2276", "0", "magma", "2015-10-03 20:02:52", "182.186.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2277", "0", "magma", "2015-10-03 20:03:01", "49.145.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2278", "0", "magma", "2015-10-03 20:04:02", "103.231.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2279", "0", "magma", "2015-10-03 20:04:03", "78.58.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2280", "0", "magma", "2015-10-03 20:05:34", "109.60.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2281", "0", "magma", "2015-10-03 20:22:17", "75.158.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2282", "1", "admin8576", "2015-10-03 20:31:27", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2283", "0", "magma", "2015-10-03 20:45:15", "196.2.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2284", "0", "magma", "2015-10-03 20:49:45", "39.33.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2285", "1", "admin8576", "2015-10-03 20:57:11", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2286", "0", "magma", "2015-10-03 21:00:21", "95.103.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2287", "0", "magma", "2015-10-03 21:05:16", "84.29.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2288", "0", "magma", "2015-10-03 21:19:20", "109.205.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2289", "1", "admin8576", "2015-10-03 21:21:27", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2290", "0", "magma", "2015-10-03 21:33:00", "77.222.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2291", "0", "magma", "2015-10-03 21:41:12", "213.49.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2292", "1", "admin8576", "2015-10-03 21:45:43", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2293", "0", "magma", "2015-10-03 22:08:40", "108.23.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2294", "1", "admin8576", "2015-10-03 22:09:56", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2295", "0", "magma", "2015-10-03 22:20:48", "85.244.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2296", "0", "magma", "2015-10-03 22:31:03", "185.18.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2297", "1", "admin8576", "2015-10-03 22:34:00", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2298", "0", "magma", "2015-10-03 22:41:33", "94.76.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2299", "0", "magma", "2015-10-03 22:56:37", "27.34.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2300", "1", "admin8576", "2015-10-03 22:58:12", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2301", "1", "admin8576", "2015-10-03 23:22:22", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2302", "1", "admin8576", "2015-10-03 23:46:34", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2303", "1", "admin8576", "2015-10-04 00:11:08", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2304", "0", "magma", "2015-10-04 00:33:19", "178.243.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2305", "1", "admin8576", "2015-10-04 00:35:49", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2306", "0", "admin", "2015-10-04 00:50:32", "176.31.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2307", "0", "magma", "2015-10-04 00:50:38", "82.49.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2308", "1", "admin8576", "2015-10-04 01:00:29", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2309", "1", "admin8576", "2015-10-04 01:24:56", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2310", "0", "magma", "2015-10-04 01:28:37", "98.160.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2311", "1", "admin8576", "2015-10-04 01:49:17", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2312", "1", "admin8576", "2015-10-04 02:13:27", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2313", "0", "magmainc", "2015-10-04 02:24:51", "146.185.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2314", "1", "admin8576", "2015-10-04 02:37:36", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2315", "0", "magma", "2015-10-04 02:51:14", "93.86.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2316", "0", "magma", "2015-10-04 03:01:39", "210.195.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2317", "1", "admin8576", "2015-10-04 03:01:57", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2318", "1", "admin8576", "2015-10-04 03:26:11", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2319", "1", "admin8576", "2015-10-04 03:55:08", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2320", "0", "magmainc", "2015-10-04 04:02:28", "146.185.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2321", "0", "magma", "2015-10-04 04:12:11", "42.115.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2322", "1", "admin8576", "2015-10-04 04:24:09", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2323", "1", "admin8576", "2015-10-04 04:52:30", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2324", "0", "magma", "2015-10-04 05:10:09", "112.208.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2325", "1", "admin8576", "2015-10-04 05:21:04", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2326", "0", "magma", "2015-10-04 05:30:09", "82.65.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2327", "0", "magmainc.co.za", "2015-10-04 05:45:03", "146.185.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2328", "1", "admin8576", "2015-10-04 05:49:41", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2329", "0", "magma", "2015-10-04 06:11:52", "218.185.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2330", "1", "admin8576", "2015-10-04 06:18:18", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2331", "1", "admin8576", "2015-10-04 06:46:58", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2332", "0", "magma", "2015-10-04 06:50:17", "94.242.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2333", "0", "magma", "2015-10-04 06:50:38", "108.23.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2334", "1", "admin8576", "2015-10-04 07:15:03", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2335", "0", "magmainc.co.za", "2015-10-04 07:25:23", "146.185.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2336", "1", "admin8576", "2015-10-04 07:45:46", "217.23.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2337", "0", "magma", "2015-10-04 07:58:08", "46.167.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2338", "0", "magma", "2015-10-04 08:29:16", "178.41.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2339", "0", "admin", "2015-10-04 08:39:58", "92.222.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2340", "0", "magma", "2015-10-04 08:45:45", "121.181.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2341", "0", "magma", "2015-10-04 08:50:38", "150.129.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2342", "0", "magma", "2015-10-04 09:07:27", "118.96.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2343", "0", "magmainc.co.za", "2015-10-04 09:08:06", "146.185.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2344", "0", "magma", "2015-10-04 09:21:01", "109.102.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2345", "0", "magma", "2015-10-04 09:40:23", "77.85.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2346", "1", "admin8576", "2015-10-04 09:42:19", "176.123.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2347", "0", "magma", "2015-10-04 10:03:20", "78.248.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2348", "0", "magma", "2015-10-04 10:04:35", "182.178.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2349", "0", "magma", "2015-10-04 10:25:46", "41.79.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2350", "0", "magma", "2015-10-04 10:41:39", "203.87.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2351", "0", "magma", "2015-10-04 10:46:14", "112.198.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2352", "0", "magmainc.co.za", "2015-10-04 10:52:06", "146.185.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2353", "0", "magma", "2015-10-04 11:07:48", "27.34.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2354", "0", "magma", "2015-10-04 11:36:40", "188.241.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2355", "1", "admin8576", "2015-10-04 11:38:23", "176.123.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2356", "0", "magma", "2015-10-04 11:50:48", "83.6.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2357", "0", "magma", "2015-10-04 11:59:59", "103.255.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2358", "0", "magma", "2015-10-04 12:39:25", "113.203.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2359", "0", "magma", "2015-10-04 13:16:17", "122.54.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2360", "0", "magma", "2015-10-04 13:27:44", "188.205.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2361", "0", "magma", "2015-10-04 13:31:53", "121.54.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2362", "0", "magma", "2015-10-04 13:35:53", "2.100.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2363", "0", "magma", "2015-10-04 13:38:39", "197.202.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2364", "0", "magma", "2015-10-04 13:41:29", "62.198.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2365", "0", "magma", "2015-10-04 13:42:41", "81.233.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2366", "0", "magma", "2015-10-04 13:47:12", "188.25.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2367", "0", "magma", "2015-10-04 14:05:24", "185.19.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2368", "0", "magma", "2015-10-04 14:52:42", "117.201.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2369", "0", "magma", "2015-10-04 15:45:02", "114.108.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2370", "1", "admin8576", "2015-10-04 16:10:52", "176.123.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2371", "0", "magma", "2015-10-04 16:46:35", "36.84.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2372", "0", "magma", "2015-10-04 16:51:49", "180.190.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2373", "0", "magma", "2015-10-04 16:59:46", "86.126.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2374", "0", "magma", "2015-10-04 17:12:49", "39.53.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2375", "0", "magma", "2015-10-04 17:14:15", "160.242.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2376", "0", "magma", "2015-10-04 17:28:39", "93.92.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2377", "0", "magma", "2015-10-04 17:28:40", "39.41.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2378", "0", "magma", "2015-10-04 17:42:01", "78.60.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2379", "0", "magma", "2015-10-04 17:54:14", "68.193.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2380", "1", "admin8576", "2015-10-04 18:06:12", "176.123.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2381", "0", "magma", "2015-10-04 18:11:46", "58.26.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2382", "0", "magma", "2015-10-04 18:28:55", "1.186.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2383", "0", "magma", "2015-10-04 18:58:45", "62.169.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2384", "1", "admin8576", "2015-10-04 19:58:39", "176.123.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2385", "0", "magma", "2015-10-04 20:29:35", "95.180.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2386", "0", "magma", "2015-10-04 20:39:39", "85.99.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2387", "0", "magma", "2015-10-04 21:37:10", "173.217.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2388", "1", "admin8576", "2015-10-04 21:51:24", "176.123.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2389", "0", "magma", "2015-10-04 22:04:42", "37.6.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2390", "0", "magma", "2015-10-04 22:46:48", "24.205.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2391", "0", "magma", "2015-10-04 23:27:57", "134.176.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2392", "1", "admin8576", "2015-10-04 23:46:50", "176.123.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2393", "0", "magma", "2015-10-04 23:56:57", "31.2.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2394", "0", "magma", "2015-10-05 00:22:45", "187.38.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2395", "1", "admin8576", "2015-10-05 01:39:30", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2396", "0", "magma", "2015-10-05 02:22:02", "191.240.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2397", "0", "admin", "2015-10-05 02:59:00", "5.196.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2398", "1", "admin8576", "2015-10-05 03:32:10", "176.123.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2399", "0", "magma", "2015-10-05 04:54:03", "92.158.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2400", "0", "magma", "2015-10-05 05:14:56", "117.197.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2401", "1", "admin8576", "2015-10-05 05:27:41", "176.123.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2402", "0", "magma", "2015-10-05 05:31:28", "99.248.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2403", "0", "magma", "2015-10-05 06:00:15", "171.96.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2404", "0", "magma", "2015-10-05 09:18:34", "85.127.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2405", "0", "magma", "2015-10-05 09:22:22", "188.37.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2406", "0", "magma", "2015-10-05 09:56:37", "121.99.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2407", "0", "admin", "2015-10-05 11:01:31", "91.109.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2408", "0", "admin", "2015-10-05 11:28:38", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2409", "0", "magma", "2015-10-05 11:48:29", "202.67.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2410", "0", "magma", "2015-10-05 11:49:57", "180.191.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2411", "0", "admin", "2015-10-05 12:01:40", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2412", "0", "magma", "2015-10-05 13:11:38", "89.68.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2413", "0", "magma", "2015-10-05 13:46:44", "222.118.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2414", "0", "magma", "2015-10-05 13:49:10", "88.201.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2415", "0", "admin", "2015-10-05 14:58:38", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2416", "0", "magma", "2015-10-05 14:59:43", "79.177.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2417", "0", "magma", "2015-10-05 15:53:38", "121.99.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2418", "0", "magma", "2015-10-05 16:02:13", "86.107.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2419", "0", "magma", "2015-10-05 16:20:19", "5.2.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2420", "0", "magma", "2015-10-05 17:01:30", "92.252.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2421", "0", "magma", "2015-10-05 17:23:49", "1.23.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2422", "0", "magma", "2015-10-05 17:40:45", "92.51.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2423", "0", "magma", "2015-10-05 17:51:25", "46.211.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2424", "0", "magma", "2015-10-05 19:07:00", "203.215.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2425", "0", "magma", "2015-10-05 20:07:57", "182.65.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2426", "0", "magma", "2015-10-05 20:20:19", "14.47.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2427", "0", "magma", "2015-10-05 20:24:58", "93.109.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2428", "0", "admin", "2015-10-05 21:51:57", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2429", "0", "magma", "2015-10-05 21:52:46", "78.158.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2430", "0", "admin", "2015-10-05 22:06:07", "212.16.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2431", "0", "magma", "2015-10-05 22:43:55", "77.77.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2432", "0", "admin", "2015-10-05 22:55:05", "185.34.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2433", "0", "magma", "2015-10-05 23:20:49", "5.28.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2434", "0", "magma", "2015-10-05 23:35:28", "80.242.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2435", "0", "magma", "2015-10-06 01:42:32", "73.46.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2436", "0", "admin", "2015-10-06 01:57:04", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2437", "0", "magma", "2015-10-06 02:31:56", "2.33.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2438", "0", "magma", "2015-10-06 03:22:03", "114.77.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2439", "0", "magma", "2015-10-06 06:44:50", "95.76.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2440", "0", "magma", "2015-10-06 07:05:11", "79.115.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2441", "0", "admin", "2015-10-06 07:23:29", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2442", "0", "admin", "2015-10-06 07:34:40", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2443", "0", "admin", "2015-10-06 08:06:02", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2444", "0", "magma", "2015-10-06 08:11:55", "114.69.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2445", "0", "magma", "2015-10-06 08:13:08", "203.111.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2446", "0", "magma", "2015-10-06 08:32:12", "197.6.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2447", "0", "magma", "2015-10-06 09:32:18", "42.83.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2448", "0", "magma", "2015-10-06 11:05:18", "180.227.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2449", "0", "magma", "2015-10-06 14:46:50", "197.203.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2450", "0", "magma", "2015-10-06 14:51:30", "46.121.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2451", "0", "magma", "2015-10-06 14:55:46", "62.81.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2452", "0", "magma", "2015-10-06 15:28:56", "119.94.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2453", "0", "magma", "2015-10-06 15:53:27", "94.76.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2454", "0", "magma", "2015-10-06 17:03:03", "175.145.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2455", "0", "admin", "2015-10-06 17:05:00", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2456", "0", "admin", "2015-10-06 17:23:20", "149.202.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2457", "0", "magma", "2015-10-06 17:41:28", "114.108.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2458", "0", "magma", "2015-10-06 17:50:23", "178.220.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2459", "0", "admin", "2015-10-06 17:50:33", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2460", "0", "magma", "2015-10-06 18:25:33", "90.190.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2461", "0", "magma", "2015-10-06 18:36:32", "179.104.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2462", "0", "magma", "2015-10-06 20:29:18", "87.2.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2463", "0", "admin", "2015-10-06 22:01:35", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2464", "0", "magma", "2015-10-06 23:50:45", "178.220.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2465", "0", "magma", "2015-10-06 23:54:52", "81.245.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2466", "0", "magma", "2015-10-07 00:13:34", "197.89.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2467", "0", "magma", "2015-10-07 00:20:59", "185.36.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2468", "0", "admin", "2015-10-07 03:05:12", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2469", "0", "admin", "2015-10-07 03:27:21", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2470", "0", "magma", "2015-10-07 07:39:28", "14.98.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2471", "0", "admin", "2015-10-07 07:43:53", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2472", "0", "magma", "2015-10-07 08:11:55", "197.221.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2473", "0", "magma", "2015-10-07 11:00:48", "79.185.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2474", "0", "magma", "2015-10-07 11:03:50", "178.222.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2475", "0", "magma", "2015-10-07 12:01:33", "178.223.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2476", "0", "admin", "2015-10-07 12:07:05", "96.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2477", "0", "admin", "2015-10-07 12:35:06", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2478", "0", "admin", "2015-10-07 12:35:29", "77.244.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2479", "1", "admin8576", "2015-10-07 14:36:19", "198.144.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2480", "0", "magma", "2015-10-07 16:39:12", "106.51.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2481", "1", "admin8576", "2015-10-07 16:47:38", "198.144.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2482", "0", "magma", "2015-10-07 17:18:03", "31.215.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2483", "0", "magma", "2015-10-07 17:29:12", "79.116.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2484", "0", "admin", "2015-10-07 17:36:13", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2485", "1", "admin8576", "2015-10-07 17:54:02", "198.144.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2486", "0", "magma", "2015-10-07 18:06:20", "112.207.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2487", "0", "magma", "2015-10-07 18:18:26", "93.87.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2488", "0", "magma", "2015-10-07 18:44:22", "41.133.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2489", "1", "admin8576", "2015-10-07 18:59:04", "198.144.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2490", "1", "admin8576", "2015-10-07 20:05:29", "198.144.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2491", "1", "admin8576", "2015-10-07 21:11:58", "198.144.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2492", "0", "magma", "2015-10-07 21:50:16", "24.132.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2493", "0", "admin", "2015-10-07 22:05:19", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2494", "0", "admin", "2015-10-07 22:32:02", "37.157.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2495", "0", "admin", "2015-10-07 22:32:09", "92.222.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2496", "0", "magma", "2015-10-07 22:33:40", "134.176.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2497", "0", "magma", "2015-10-08 01:02:09", "89.205.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2498", "0", "magma", "2015-10-08 01:09:22", "95.92.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2499", "0", "magma", "2015-10-08 01:40:03", "41.196.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2500", "0", "magma", "2015-10-08 01:45:28", "177.80.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2501", "0", "magma", "2015-10-08 02:01:18", "5.83.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2502", "0", "magma", "2015-10-08 02:57:30", "112.201.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2503", "0", "magma", "2015-10-08 03:25:31", "185.36.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2504", "0", "admin", "2015-10-08 03:41:36", "31.172.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2505", "0", "magma", "2015-10-08 05:17:03", "106.51.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2506", "0", "magma", "2015-10-08 05:22:55", "88.161.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2507", "0", "magma", "2015-10-08 05:52:09", "186.30.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2508", "0", "admin", "2015-10-08 06:47:48", "158.69.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2509", "0", "magma", "2015-10-08 07:08:55", "79.169.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2510", "0", "admin", "2015-10-08 07:36:45", "176.10.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2511", "0", "magma", "2015-10-08 08:00:24", "5.107.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2512", "0", "magma", "2015-10-08 09:58:26", "149.3.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2513", "0", "magma", "2015-10-08 12:22:27", "176.32.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2514", "0", "admin", "2015-10-08 12:58:01", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2515", "0", "magma", "2015-10-08 13:16:41", "200.90.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2516", "0", "magma", "2015-10-08 13:48:05", "79.115.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2517", "0", "magma", "2015-10-08 13:57:17", "197.27.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2518", "0", "magma", "2015-10-08 14:04:00", "80.227.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2519", "0", "admin", "2015-10-08 15:29:47", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2520", "0", "magma", "2015-10-08 15:35:53", "89.121.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2521", "0", "magma", "2015-10-08 15:46:05", "178.220.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2522", "0", "admin", "2015-10-08 16:01:42", "87.118.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2523", "0", "magma", "2015-10-08 16:44:02", "121.54.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2524", "0", "admin", "2015-10-08 16:45:23", "185.11.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2525", "0", "magma", "2015-10-08 18:51:49", "112.203.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2526", "0", "magma", "2015-10-08 19:32:04", "89.35.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2527", "0", "magma", "2015-10-08 20:48:36", "86.100.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2528", "0", "magma", "2015-10-08 21:18:54", "27.109.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2529", "0", "admin", "2015-10-08 22:38:47", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2530", "0", "magma", "2015-10-09 00:33:31", "81.244.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2531", "0", "admin", "2015-10-09 00:38:22", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2532", "0", "admin", "2015-10-09 01:08:50", "185.11.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2533", "0", "magma", "2015-10-09 01:21:49", "84.2.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2534", "0", "admin", "2015-10-09 02:09:50", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2535", "0", "magma", "2015-10-09 07:20:21", "171.6.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2536", "0", "admin", "2015-10-09 07:57:56", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2537", "0", "admin", "2015-10-09 08:51:54", "5.9.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2538", "0", "admin", "2015-10-09 09:31:08", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2539", "0", "magma", "2015-10-09 09:37:01", "210.186.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2540", "0", "magma", "2015-10-09 10:56:06", "151.228.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2541", "0", "admin", "2015-10-09 11:03:54", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2542", "0", "magma", "2015-10-09 11:04:33", "37.211.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2543", "0", "magma", "2015-10-09 11:35:07", "174.97.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2544", "0", "magma", "2015-10-09 11:53:51", "92.99.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2545", "0", "magma", "2015-10-09 12:37:03", "174.113.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2546", "0", "magma", "2015-10-09 12:54:10", "175.143.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2547", "0", "magma", "2015-10-09 13:12:00", "89.134.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2548", "0", "magma", "2015-10-09 13:20:50", "176.43.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2549", "0", "magma", "2015-10-09 13:30:47", "81.246.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2550", "0", "magma", "2015-10-09 13:32:54", "62.28.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2551", "0", "magma", "2015-10-09 13:39:00", "85.186.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2552", "0", "magma", "2015-10-09 13:49:15", "197.160.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2553", "0", "magma", "2015-10-09 13:49:43", "81.108.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2554", "0", "magma", "2015-10-09 13:54:43", "92.87.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2555", "0", "magma", "2015-10-09 13:56:33", "187.183.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2556", "0", "magma", "2015-10-09 14:03:06", "130.204.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2557", "0", "magma", "2015-10-09 14:11:05", "46.217.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2558", "0", "magma", "2015-10-09 14:15:47", "193.191.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2559", "0", "magma", "2015-10-09 14:26:14", "138.118.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2560", "0", "magma", "2015-10-09 14:42:42", "190.46.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2561", "0", "magma", "2015-10-09 14:43:55", "14.141.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2562", "0", "magma", "2015-10-09 14:46:07", "94.67.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2563", "0", "magma", "2015-10-09 14:47:20", "95.146.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2564", "0", "magma", "2015-10-09 14:58:00", "90.221.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2565", "0", "magma", "2015-10-09 15:05:42", "98.228.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2566", "0", "magma", "2015-10-09 15:07:53", "24.63.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2567", "0", "magma", "2015-10-09 15:09:05", "46.109.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2568", "0", "magma", "2015-10-09 15:23:39", "201.252.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2569", "0", "magma", "2015-10-09 15:29:39", "178.149.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2570", "0", "magma", "2015-10-09 15:32:17", "58.97.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2571", "0", "magma", "2015-10-09 15:33:31", "100.8.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2572", "0", "magma", "2015-10-09 15:36:32", "79.113.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2573", "0", "magma", "2015-10-09 16:09:51", "110.164.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2574", "0", "magma", "2015-10-09 16:12:49", "94.203.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2575", "0", "magma", "2015-10-09 16:34:12", "94.225.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2576", "0", "magma", "2015-10-09 16:51:31", "79.173.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2577", "0", "magma", "2015-10-09 17:02:11", "87.17.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2578", "0", "magma", "2015-10-09 17:06:50", "89.65.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2579", "0", "magma", "2015-10-09 17:07:46", "178.143.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2580", "0", "magma", "2015-10-09 17:16:22", "181.64.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2581", "0", "magma", "2015-10-09 17:20:19", "93.34.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2582", "0", "magma", "2015-10-09 17:23:58", "103.57.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2583", "0", "admin", "2015-10-09 17:25:14", "193.34.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2584", "0", "magma", "2015-10-09 17:27:33", "97.118.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2585", "0", "magma", "2015-10-09 17:34:27", "59.95.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2586", "0", "magma", "2015-10-09 17:40:31", "181.160.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2587", "0", "admin", "2015-10-09 17:41:06", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2588", "0", "magma", "2015-10-09 17:42:50", "5.13.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2589", "0", "magma", "2015-10-09 17:44:46", "187.67.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2590", "0", "magma", "2015-10-09 17:55:05", "154.126.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2591", "0", "magma", "2015-10-09 17:58:03", "67.170.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2592", "0", "magma", "2015-10-09 17:59:49", "106.168.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2593", "0", "magma", "2015-10-09 18:01:55", "105.226.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2594", "0", "magma", "2015-10-09 18:01:55", "79.117.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2595", "0", "magma", "2015-10-09 18:08:44", "85.96.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2596", "0", "magma", "2015-10-09 18:18:10", "178.152.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2597", "0", "magma", "2015-10-09 18:40:11", "94.61.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2598", "0", "magma", "2015-10-09 18:43:45", "86.124.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2599", "0", "magma", "2015-10-09 18:45:11", "43.231.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2600", "0", "magma", "2015-10-09 18:47:57", "79.183.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2601", "0", "magma", "2015-10-09 19:34:34", "41.236.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2602", "0", "magma", "2015-10-09 19:42:06", "213.67.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2603", "0", "magma", "2015-10-09 19:47:11", "37.11.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2604", "0", "magma", "2015-10-09 19:52:28", "141.8.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2605", "0", "magma", "2015-10-09 19:56:10", "151.72.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2606", "0", "magma", "2015-10-09 20:04:21", "105.224.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2607", "0", "magma", "2015-10-09 20:11:19", "86.124.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2608", "0", "magma", "2015-10-09 20:21:52", "182.57.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2609", "0", "admin", "2015-10-09 20:22:27", "95.130.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2610", "0", "magma", "2015-10-09 20:32:19", "201.149.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2611", "0", "magma", "2015-10-09 20:49:36", "107.179.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2612", "0", "magma", "2015-10-09 20:54:15", "41.101.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2613", "0", "magma", "2015-10-09 21:04:58", "203.111.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2614", "0", "magma", "2015-10-09 21:09:12", "46.99.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2615", "0", "magma", "2015-10-09 21:09:14", "110.5.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2616", "0", "magma", "2015-10-09 21:10:22", "89.164.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2617", "0", "magma", "2015-10-09 21:18:25", "219.240.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2618", "0", "magma", "2015-10-09 21:23:43", "202.171.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2619", "0", "magma", "2015-10-09 21:24:03", "84.77.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2620", "0", "magma", "2015-10-09 21:28:47", "89.142.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2621", "0", "magma", "2015-10-09 21:32:39", "89.153.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2622", "0", "magma", "2015-10-09 21:43:33", "181.168.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2623", "0", "magma", "2015-10-09 21:44:35", "154.68.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2624", "0", "magma", "2015-10-09 21:51:25", "217.46.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2625", "0", "magma", "2015-10-09 21:55:17", "83.110.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2626", "0", "magma", "2015-10-09 22:08:15", "178.223.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2627", "0", "magma", "2015-10-09 22:15:07", "46.152.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2628", "0", "magma", "2015-10-09 22:20:39", "95.156.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2629", "0", "magma", "2015-10-09 22:30:08", "31.215.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2630", "0", "magma", "2015-10-09 22:40:45", "185.33.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2631", "0", "magma", "2015-10-09 22:43:04", "87.241.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2632", "0", "magma", "2015-10-09 22:55:11", "90.192.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2633", "0", "magma", "2015-10-09 22:57:17", "212.93.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2634", "0", "magma", "2015-10-09 23:28:15", "89.36.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2635", "0", "magma", "2015-10-09 23:28:16", "37.190.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2636", "0", "magma", "2015-10-09 23:28:39", "213.67.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2637", "0", "magma", "2015-10-10 00:57:21", "109.201.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2638", "0", "admin", "2015-10-10 02:40:42", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2639", "0", "admin", "2015-10-10 02:57:00", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2640", "0", "magma", "2015-10-10 10:50:32", "213.185.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2641", "0", "admin", "2015-10-10 10:57:25", "95.130.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2642", "0", "admin", "2015-10-10 12:16:27", "46.28.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2643", "0", "magma", "2015-10-10 13:18:34", "94.176.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2644", "0", "admin", "2015-10-10 14:32:39", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2645", "0", "admin", "2015-10-10 19:44:42", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2646", "0", "admin", "2015-10-10 20:56:28", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2647", "0", "admin", "2015-10-10 23:54:05", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2648", "0", "admin", "2015-10-11 05:47:58", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2649", "1", "admin8576", "2015-10-11 13:19:08", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2650", "0", "admin", "2015-10-11 14:22:55", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2651", "1", "admin8576", "2015-10-11 14:24:31", "5.175.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2652", "1", "admin8576", "2015-10-11 15:20:58", "176.123.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2653", "1", "admin8576", "2015-10-11 15:43:06", "81.7.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2654", "1", "admin8576", "2015-10-11 17:02:13", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2655", "1", "admin8576", "2015-10-11 17:23:06", "176.123.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2656", "0", "admin", "2015-10-11 17:28:44", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2657", "1", "admin8576", "2015-10-11 18:21:12", "79.172.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2658", "1", "admin8576", "2015-10-11 19:24:40", "176.123.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2659", "1", "admin8576", "2015-10-11 19:41:14", "176.123.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2660", "1", "admin8576", "2015-10-11 21:02:21", "198.23.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2661", "1", "admin8576", "2015-10-11 21:26:26", "176.123.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2662", "0", "admin", "2015-10-11 22:11:33", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2663", "1", "admin8576", "2015-10-11 22:24:07", "212.47.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2664", "1", "admin8576", "2015-10-11 23:27:57", "176.123.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2665", "0", "admin", "2015-10-11 23:31:29", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2666", "1", "admin8576", "2015-10-11 23:42:10", "79.172.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2667", "0", "admin", "2015-10-12 00:52:05", "77.109.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2668", "1", "admin8576", "2015-10-12 00:57:49", "176.31.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2669", "1", "admin8576", "2015-10-12 01:46:20", "176.123.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2670", "1", "admin8576", "2015-10-12 02:12:49", "46.226.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2671", "0", "admin", "2015-10-12 02:36:09", "185.36.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2672", "1", "admin8576", "2015-10-12 03:26:00", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2673", "1", "admin8576", "2015-10-12 05:48:42", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2674", "0", "admin", "2015-10-12 06:45:54", "91.219.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2675", "1", "admin8576", "2015-10-12 07:01:31", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2676", "0", "admin", "2015-10-12 08:04:27", "158.130.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2677", "1", "admin8576", "2015-10-12 09:31:51", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2678", "0", "admin", "2015-10-12 09:36:44", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2679", "1", "admin8576", "2015-10-12 10:51:59", "95.128.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2680", "1", "admin8576", "2015-10-12 11:01:42", "176.123.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2681", "0", "admin", "2015-10-12 11:16:44", "204.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2682", "1", "admin8576", "2015-10-12 12:13:52", "153.92.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2683", "1", "admin8576", "2015-10-12 13:35:28", "212.47.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2684", "1", "admin8576", "2015-10-12 14:56:29", "46.235.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2685", "0", "admin", "2015-10-12 15:44:58", "94.23.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2686", "0", "admin", "2015-10-12 17:24:22", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2687", "1", "admin8576", "2015-10-12 17:41:49", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2688", "1", "admin8576", "2015-10-12 18:12:49", "176.123.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2689", "1", "admin8576", "2015-10-12 19:01:07", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2690", "0", "admin", "2015-10-12 19:21:30", "188.165.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2691", "0", "admin", "2015-10-12 21:19:03", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2692", "1", "admin8576", "2015-10-12 21:56:38", "193.34.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2693", "1", "admin8576", "2015-10-13 00:43:49", "78.108.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2694", "0", "admin", "2015-10-13 01:56:35", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2695", "1", "admin8576", "2015-10-13 02:00:45", "207.244.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2696", "1", "admin8576", "2015-10-13 03:16:42", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2697", "1", "admin8576", "2015-10-13 04:32:38", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2698", "0", "admin", "2015-10-13 05:17:12", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2699", "1", "admin8576", "2015-10-13 05:47:06", "166.70.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2700", "0", "admin", "2015-10-13 06:49:09", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2701", "1", "admin8576", "2015-10-13 07:00:36", "46.165.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2702", "1", "admin8576", "2015-10-13 09:15:45", "176.123.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2703", "1", "admin8576", "2015-10-13 09:33:32", "91.213.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2704", "0", "admin", "2015-10-13 10:50:36", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2705", "1", "admin8576", "2015-10-13 10:52:02", "212.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2706", "1", "admin8576", "2015-10-13 10:52:23", "176.123.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2707", "1", "admin8576", "2015-10-13 12:14:03", "185.62.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2708", "1", "admin8576", "2015-10-13 12:28:33", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2709", "0", "admin", "2015-10-13 12:35:16", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2710", "1", "admin8576", "2015-10-13 13:40:59", "176.123.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2711", "0", "admin", "2015-10-13 14:41:06", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2712", "1", "admin8576", "2015-10-13 14:47:30", "91.219.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2713", "1", "admin8576", "2015-10-13 15:33:16", "176.123.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2714", "1", "admin8576", "2015-10-13 16:08:26", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2715", "1", "admin8576", "2015-10-13 17:19:17", "176.123.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2716", "1", "admin8576", "2015-10-13 17:55:16", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2717", "1", "admin8576", "2015-10-13 18:20:03", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2718", "1", "admin8576", "2015-10-13 18:44:36", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2719", "1", "admin8576", "2015-10-13 18:53:54", "78.108.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2720", "1", "admin8576", "2015-10-13 19:09:14", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2721", "1", "admin8576", "2015-10-13 19:23:42", "176.123.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2722", "1", "admin8576", "2015-10-13 19:35:36", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2723", "1", "admin8576", "2015-10-13 20:00:12", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2724", "1", "admin8576", "2015-10-13 20:18:30", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2725", "1", "admin8576", "2015-10-13 20:24:58", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2726", "1", "admin8576", "2015-10-13 20:49:35", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2727", "1", "admin8576", "2015-10-13 21:14:40", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2728", "1", "admin8576", "2015-10-13 21:20:43", "176.123.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2729", "1", "admin8576", "2015-10-13 21:43:27", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2730", "1", "admin8576", "2015-10-13 21:46:15", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2731", "1", "admin8576", "2015-10-13 22:12:32", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2732", "0", "admin", "2015-10-13 22:17:53", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2733", "1", "admin8576", "2015-10-13 22:37:40", "83.143.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2734", "1", "admin8576", "2015-10-13 23:01:30", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2735", "1", "admin8576", "2015-10-13 23:06:22", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2736", "1", "admin8576", "2015-10-13 23:07:31", "62.212.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2737", "1", "admin8576", "2015-10-13 23:39:25", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2738", "1", "admin8576", "2015-10-14 00:12:03", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2739", "1", "admin8576", "2015-10-14 00:27:35", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2740", "0", "admin", "2015-10-14 00:41:51", "212.47.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2741", "1", "admin8576", "2015-10-14 00:44:41", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2742", "1", "admin8576", "2015-10-14 00:45:40", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2743", "1", "admin8576", "2015-10-14 01:17:06", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2744", "1", "admin8576", "2015-10-14 01:42:28", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2745", "1", "admin8576", "2015-10-14 01:49:41", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2746", "1", "admin8576", "2015-10-14 02:03:15", "172.4.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2747", "0", "admin", "2015-10-14 02:03:34", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2748", "1", "admin8576", "2015-10-14 02:19:43", "216.36.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2749", "1", "admin8576", "2015-10-14 02:22:10", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2750", "1", "admin8576", "2015-10-14 02:28:43", "176.123.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2751", "1", "admin8576", "2015-10-14 02:34:24", "199.59.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2752", "1", "admin8576", "2015-10-14 02:48:29", "76.97.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2753", "1", "admin8576", "2015-10-14 02:54:43", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2754", "1", "admin8576", "2015-10-14 03:27:14", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2755", "1", "admin8576", "2015-10-14 03:34:50", "107.170.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2756", "1", "admin8576", "2015-10-14 03:59:44", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2757", "1", "admin8576", "2015-10-14 04:07:48", "79.98.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2758", "1", "admin8576", "2015-10-14 04:21:47", "76.8.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2759", "1", "admin8576", "2015-10-14 04:32:06", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2760", "1", "admin8576", "2015-10-14 05:04:30", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2761", "1", "admin8576", "2015-10-14 05:07:56", "71.85.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2762", "1", "admin8576", "2015-10-14 05:18:53", "50.62.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2763", "1", "admin8576", "2015-10-14 05:31:29", "173.198.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2764", "1", "admin8576", "2015-10-14 05:36:41", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2765", "0", "admin", "2015-10-14 05:37:47", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2766", "1", "admin8576", "2015-10-14 05:55:16", "108.61.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2767", "1", "admin8576", "2015-10-14 06:08:22", "98.103.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2768", "1", "admin8576", "2015-10-14 06:09:08", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2769", "1", "admin8576", "2015-10-14 06:20:30", "50.251.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2770", "1", "admin8576", "2015-10-14 06:32:42", "64.9.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2771", "1", "admin8576", "2015-10-14 06:41:27", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2772", "1", "admin8576", "2015-10-14 07:13:39", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2773", "0", "admin", "2015-10-14 07:25:22", "94.26.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2774", "1", "admin8576", "2015-10-14 07:26:09", "174.143.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2775", "1", "admin8576", "2015-10-14 07:38:45", "71.30.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2776", "1", "admin8576", "2015-10-14 07:38:45", "71.30.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2777", "1", "admin8576", "2015-10-14 07:46:04", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2778", "1", "admin8576", "2015-10-14 07:50:18", "65.51.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2779", "1", "admin8576", "2015-10-14 08:02:15", "50.62.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2780", "1", "admin8576", "2015-10-14 08:18:38", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2781", "1", "admin8576", "2015-10-14 08:25:43", "216.159.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2782", "1", "admin8576", "2015-10-14 08:48:39", "12.5.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2783", "1", "admin8576", "2015-10-14 08:50:55", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2784", "1", "admin8576", "2015-10-14 08:59:06", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2785", "1", "admin8576", "2015-10-14 09:22:12", "96.31.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2786", "1", "admin8576", "2015-10-14 09:23:24", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2787", "1", "admin8576", "2015-10-14 09:34:19", "64.203.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2788", "1", "admin8576", "2015-10-14 09:55:53", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2789", "0", "admin", "2015-10-14 10:12:22", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2790", "1", "admin8576", "2015-10-14 10:13:36", "216.151.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2791", "1", "admin8576", "2015-10-14 10:13:51", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2792", "1", "admin8576", "2015-10-14 10:28:34", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2793", "1", "admin8576", "2015-10-14 10:41:22", "209.118.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2794", "1", "admin8576", "2015-10-14 10:56:07", "192.149.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2795", "1", "admin8576", "2015-10-14 11:01:00", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2796", "1", "admin8576", "2015-10-14 11:25:56", "137.119.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2797", "1", "admin8576", "2015-10-14 11:28:51", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2798", "0", "admin", "2015-10-14 11:32:29", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2799", "1", "admin8576", "2015-10-14 11:33:37", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2800", "1", "admin8576", "2015-10-14 11:40:40", "208.69.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2801", "1", "admin8576", "2015-10-14 11:56:26", "66.186.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2802", "1", "admin8576", "2015-10-14 12:02:11", "176.123.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2803", "1", "admin8576", "2015-10-14 12:06:09", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2804", "1", "admin8576", "2015-10-14 12:25:24", "209.168.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2805", "1", "admin8576", "2015-10-14 12:38:28", "75.145.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2806", "1", "admin8576", "2015-10-14 12:38:50", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2807", "1", "admin8576", "2015-10-14 12:44:36", "188.165.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2808", "1", "admin8576", "2015-10-14 12:51:36", "50.242.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2809", "1", "admin8576", "2015-10-14 13:04:53", "216.171.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2810", "1", "admin8576", "2015-10-14 13:11:26", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2811", "1", "admin8576", "2015-10-14 13:44:01", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2812", "1", "admin8576", "2015-10-14 13:46:05", "207.231.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2813", "1", "admin8576", "2015-10-14 13:59:14", "96.31.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2814", "1", "admin8576", "2015-10-14 14:12:13", "24.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2815", "1", "admin8576", "2015-10-14 14:16:33", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2816", "1", "admin8576", "2015-10-14 14:25:51", "64.203.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2817", "1", "admin8576", "2015-10-14 14:40:24", "198.20.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2818", "1", "admin8576", "2015-10-14 14:49:06", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2819", "1", "admin8576", "2015-10-14 15:01:01", "176.123.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2820", "1", "admin8576", "2015-10-14 15:19:05", "212.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2821", "1", "admin8576", "2015-10-14 15:21:40", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2822", "0", "admin", "2015-10-14 15:35:52", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2823", "1", "admin8576", "2015-10-14 15:36:36", "209.76.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2824", "1", "admin8576", "2015-10-14 15:52:00", "74.7.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2825", "1", "admin8576", "2015-10-14 15:54:19", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2826", "1", "admin8576", "2015-10-14 16:04:57", "12.165.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2827", "1", "admin8576", "2015-10-14 16:17:29", "67.51.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2828", "1", "admin8576", "2015-10-14 16:26:50", "188.227.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2829", "1", "admin8576", "2015-10-14 16:31:08", "73.203.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2830", "1", "admin8576", "2015-10-14 16:39:15", "176.9.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2831", "1", "admin8576", "2015-10-14 16:45:07", "176.123.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2832", "1", "admin8576", "2015-10-14 16:45:48", "107.217.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2833", "1", "admin8576", "2015-10-14 17:00:34", "64.149.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2834", "0", "admin", "2015-10-14 17:19:18", "69.162.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2835", "1", "admin8576", "2015-10-14 17:27:56", "64.207.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2836", "1", "admin8576", "2015-10-14 17:41:19", "99.75.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2837", "1", "admin8576", "2015-10-14 17:59:30", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2838", "1", "admin8576", "2015-10-14 18:09:16", "64.19.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2839", "1", "admin8576", "2015-10-14 18:23:30", "97.77.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2840", "1", "admin8576", "2015-10-14 18:38:04", "75.127.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2841", "1", "admin8576", "2015-10-14 18:53:40", "176.123.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2842", "1", "admin8576", "2015-10-14 19:05:28", "96.57.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2843", "1", "admin8576", "2015-10-14 19:17:33", "185.10.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2844", "1", "admin8576", "2015-10-14 19:19:11", "192.149.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2845", "1", "admin8576", "2015-10-14 19:33:51", "209.76.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2846", "1", "admin8576", "2015-10-14 19:47:15", "107.14.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2847", "1", "admin8576", "2015-10-14 20:02:01", "66.186.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2848", "1", "admin8576", "2015-10-14 20:15:40", "50.62.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2849", "1", "admin8576", "2015-10-14 20:30:29", "67.208.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2850", "1", "admin8576", "2015-10-14 20:44:15", "173.196.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2851", "1", "admin8576", "2015-10-14 20:58:16", "69.9.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2852", "1", "admin8576", "2015-10-14 21:21:15", "176.123.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2853", "0", "admin", "2015-10-14 21:23:23", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2854", "1", "admin8576", "2015-10-14 21:26:19", "50.86.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2855", "1", "admin8576", "2015-10-14 21:41:18", "66.90.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2856", "1", "admin8576", "2015-10-14 21:55:58", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2857", "1", "admin8576", "2015-10-14 21:56:01", "173.219.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2858", "1", "admin8576", "2015-10-14 22:10:05", "96.228.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2859", "1", "admin8576", "2015-10-14 22:52:11", "64.9.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2860", "1", "admin8576", "2015-10-14 23:16:39", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2861", "1", "admin8576", "2015-10-14 23:17:23", "176.123.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2862", "1", "admin8576", "2015-10-14 23:19:30", "24.221.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2863", "1", "admin8576", "2015-10-14 23:35:01", "199.59.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2864", "1", "admin8576", "2015-10-14 23:48:28", "67.51.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2865", "1", "admin8576", "2015-10-15 00:02:59", "24.106.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2866", "1", "admin8576", "2015-10-15 00:30:50", "216.162.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2867", "1", "admin8576", "2015-10-15 00:34:52", "176.9.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2868", "1", "admin8576", "2015-10-15 00:44:51", "174.139.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2869", "1", "admin8576", "2015-10-15 00:58:59", "12.5.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2870", "0", "admin", "2015-10-15 01:04:39", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2871", "1", "admin8576", "2015-10-15 01:05:13", "176.123.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2872", "1", "admin8576", "2015-10-15 01:12:42", "207.231.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2873", "1", "admin8576", "2015-10-15 01:25:10", "64.203.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2874", "1", "admin8576", "2015-10-15 01:51:53", "50.62.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2875", "1", "admin8576", "2015-10-15 01:51:57", "193.111.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2876", "1", "admin8576", "2015-10-15 02:04:38", "98.103.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2877", "1", "admin8576", "2015-10-15 02:34:14", "24.53.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2878", "1", "admin8576", "2015-10-15 02:44:04", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2879", "0", "admin", "2015-10-15 02:46:19", "176.10.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2880", "1", "admin8576", "2015-10-15 03:18:26", "216.60.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2881", "1", "admin8576", "2015-10-15 03:32:18", "66.55.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2882", "1", "admin8576", "2015-10-15 03:47:02", "107.170.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2883", "1", "admin8576", "2015-10-15 04:20:50", "176.123.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2884", "1", "admin8576", "2015-10-15 04:21:07", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2885", "1", "admin8576", "2015-10-15 04:45:30", "50.86.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2886", "1", "admin8576", "2015-10-15 04:59:02", "204.195.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2887", "1", "admin8576", "2015-10-15 05:13:37", "64.1.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2888", "1", "admin8576", "2015-10-15 05:27:59", "107.190.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2889", "1", "admin8576", "2015-10-15 05:36:18", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2890", "1", "admin8576", "2015-10-15 05:42:48", "173.219.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2891", "1", "admin8576", "2015-10-15 05:57:44", "172.9.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2892", "1", "admin8576", "2015-10-15 05:58:14", "176.123.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2893", "1", "admin8576", "2015-10-15 06:11:47", "96.57.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2894", "1", "admin8576", "2015-10-15 06:26:19", "192.149.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2895", "0", "admin", "2015-10-15 06:35:22", "62.210.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2896", "1", "admin8576", "2015-10-15 06:39:34", "209.76.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2897", "1", "admin8576", "2015-10-15 06:53:03", "97.80.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2898", "1", "admin8576", "2015-10-15 06:54:55", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2899", "1", "admin8576", "2015-10-15 07:06:41", "71.164.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2900", "1", "admin8576", "2015-10-15 07:33:02", "8.29.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2901", "1", "admin8576", "2015-10-15 07:36:01", "176.123.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2902", "1", "admin8576", "2015-10-15 07:46:56", "159.100.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2903", "1", "admin8576", "2015-10-15 08:00:49", "69.9.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2904", "1", "admin8576", "2015-10-15 08:11:46", "178.17.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2905", "1", "admin8576", "2015-10-15 08:27:45", "99.75.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2906", "1", "admin8576", "2015-10-15 08:40:41", "204.195.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2907", "1", "admin8576", "2015-10-15 09:10:34", "75.149.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2908", "1", "admin8576", "2015-10-15 09:22:48", "176.123.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2909", "1", "admin8576", "2015-10-15 09:29:55", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2910", "1", "admin8576", "2015-10-15 09:38:52", "72.35.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2911", "0", "admin", "2015-10-15 09:40:45", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2912", "1", "admin8576", "2015-10-15 11:19:18", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2913", "0", "admin", "2015-10-15 11:29:43", "80.82.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2914", "1", "admin8576", "2015-10-15 12:02:50", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2915", "1", "admin8576", "2015-10-15 12:56:23", "176.123.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2916", "1", "admin8576", "2015-10-15 13:21:12", "193.34.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2917", "1", "admin8576", "2015-10-15 14:36:38", "176.123.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2918", "1", "admin8576", "2015-10-15 14:41:42", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2919", "0", "admin", "2015-10-15 14:45:33", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2920", "0", "admin", "2015-10-15 15:38:07", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2921", "1", "admin8576", "2015-10-15 16:02:52", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2922", "1", "admin8576", "2015-10-15 16:18:25", "176.123.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2923", "1", "admin8576", "2015-10-15 17:56:36", "176.123.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2924", "0", "admin", "2015-10-15 18:40:47", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2925", "1", "admin8576", "2015-10-15 18:47:05", "93.184.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2926", "1", "admin8576", "2015-10-15 19:34:16", "176.123.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2927", "1", "admin8576", "2015-10-15 20:07:41", "5.165.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2928", "0", "admin", "2015-10-15 20:45:31", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2929", "1", "admin8576", "2015-10-15 21:11:09", "176.123.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2930", "1", "admin8576", "2015-10-15 22:47:17", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2931", "1", "admin8576", "2015-10-15 22:48:58", "74.208.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2932", "1", "admin8576", "2015-10-16 00:04:43", "185.16.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2933", "1", "admin8576", "2015-10-16 00:23:48", "176.123.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2934", "0", "admin", "2015-10-16 00:26:48", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2935", "0", "admin", "2015-10-16 01:15:07", "162.221.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2936", "1", "admin8576", "2015-10-16 01:25:21", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2937", "1", "admin8576", "2015-10-16 01:59:55", "176.123.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2938", "1", "admin8576", "2015-10-16 02:37:05", "94.242.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2939", "1", "admin8576", "2015-10-16 03:47:57", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2940", "0", "admin", "2015-10-16 04:03:47", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2941", "1", "admin8576", "2015-10-16 05:00:10", "79.98.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2942", "1", "admin8576", "2015-10-16 07:24:38", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2943", "1", "admin8576", "2015-10-16 08:38:12", "178.162.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2944", "0", "admin", "2015-10-16 09:43:58", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2945", "1", "admin8576", "2015-10-16 09:51:04", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2946", "1", "admin8576", "2015-10-16 12:18:44", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2947", "0", "admin", "2015-10-16 14:47:54", "95.130.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2948", "1", "admin8576", "2015-10-16 14:49:20", "178.32.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2949", "1", "admin8576", "2015-10-16 16:05:55", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2950", "1", "admin8576", "2015-10-16 17:21:53", "62.149.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2951", "1", "admin8576", "2015-10-16 18:40:17", "209.222.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2952", "0", "admin", "2015-10-16 19:00:17", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2953", "0", "admin", "2015-10-16 19:24:24", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2954", "0", "admin", "2015-10-16 22:02:50", "192.151.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2955", "1", "admin8576", "2015-10-16 22:41:49", "178.32.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2956", "1", "admin8576", "2015-10-17 00:05:13", "95.142.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2957", "0", "admin", "2015-10-17 00:09:28", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2958", "1", "admin8576", "2015-10-17 01:27:31", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2959", "1", "admin8576", "2015-10-17 02:44:11", "85.24.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2960", "1", "admin8576", "2015-10-17 04:01:33", "5.9.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2961", "0", "admin", "2015-10-17 04:39:51", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2962", "1", "admin8576", "2015-10-17 05:18:32", "31.192.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2963", "1", "admin8576", "2015-10-17 06:35:39", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2964", "1", "admin8576", "2015-10-17 07:51:46", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2965", "0", "admin", "2015-10-17 09:02:30", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2966", "1", "admin8576", "2015-10-17 09:10:37", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2967", "1", "admin8576", "2015-10-17 10:30:55", "91.219.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2968", "1", "admin8576", "2015-10-17 11:50:32", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2969", "1", "admin8576", "2015-10-17 13:10:39", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2970", "0", "admin", "2015-10-17 13:40:29", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2971", "0", "admin", "2015-10-17 13:40:43", "176.10.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2972", "1", "admin8576", "2015-10-17 14:31:13", "158.69.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2973", "0", "magma", "2015-10-17 15:44:17", "182.231.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2974", "0", "magma", "2015-10-17 15:47:42", "31.11.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2975", "1", "admin8576", "2015-10-17 15:52:59", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2976", "0", "magma", "2015-10-17 16:06:34", "86.87.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2977", "0", "magma", "2015-10-17 16:08:40", "101.186.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2978", "0", "magma", "2015-10-17 16:10:17", "112.210.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2979", "0", "magma", "2015-10-17 16:11:19", "91.240.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2980", "0", "magma", "2015-10-17 16:13:00", "89.46.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2981", "0", "magma", "2015-10-17 16:20:46", "81.230.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2982", "0", "magma", "2015-10-17 16:21:52", "177.177.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2983", "0", "magma", "2015-10-17 16:35:09", "62.234.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2984", "0", "magma", "2015-10-17 16:47:20", "176.40.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2985", "0", "magma", "2015-10-17 16:52:04", "105.237.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2986", "0", "magma", "2015-10-17 17:05:42", "100.4.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2987", "0", "magma", "2015-10-17 17:06:41", "197.36.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2988", "1", "admin8576", "2015-10-17 17:16:00", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2989", "0", "magma", "2015-10-17 17:23:17", "105.226.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2990", "0", "magma", "2015-10-17 17:28:27", "105.226.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2991", "0", "magma", "2015-10-17 17:37:22", "92.80.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2992", "0", "magma", "2015-10-17 17:38:09", "109.96.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2993", "0", "magma", "2015-10-17 17:39:03", "93.180.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2994", "0", "magma", "2015-10-17 17:39:12", "95.186.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2995", "0", "magma", "2015-10-17 17:52:17", "79.176.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2996", "0", "magma", "2015-10-17 17:53:41", "178.222.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2997", "0", "magma", "2015-10-17 17:59:04", "93.86.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2998", "0", "magma", "2015-10-17 18:00:11", "79.108.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("2999", "0", "magma", "2015-10-17 18:01:29", "81.235.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3000", "0", "admin", "2015-10-17 18:04:33", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3001", "0", "magma", "2015-10-17 18:08:55", "203.218.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3002", "0", "magma", "2015-10-17 18:11:13", "82.51.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3003", "0", "magma", "2015-10-17 18:14:43", "46.211.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3004", "0", "magma", "2015-10-17 18:16:54", "83.53.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3005", "0", "magma", "2015-10-17 18:20:05", "88.8.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3006", "0", "magma", "2015-10-17 18:23:23", "92.80.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3007", "0", "magma", "2015-10-17 18:37:26", "83.59.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3008", "1", "admin8576", "2015-10-17 18:37:41", "89.187.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3009", "0", "magma", "2015-10-17 18:55:12", "78.60.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3010", "0", "magma", "2015-10-17 18:55:16", "24.51.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3011", "0", "magma", "2015-10-17 19:05:07", "182.178.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3012", "0", "magma", "2015-10-17 19:13:45", "109.194.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3013", "0", "magma", "2015-10-17 19:14:12", "213.22.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3014", "0", "magma", "2015-10-17 19:17:50", "82.10.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3015", "0", "magma", "2015-10-17 19:21:18", "188.221.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3016", "0", "magma", "2015-10-17 19:26:34", "2.49.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3017", "0", "magma", "2015-10-17 19:26:54", "46.19.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3018", "0", "magma", "2015-10-17 19:27:09", "123.201.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3019", "0", "magma", "2015-10-17 19:28:09", "188.127.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3020", "0", "magma", "2015-10-17 19:29:02", "91.178.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3021", "0", "magma", "2015-10-17 19:38:37", "46.189.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3022", "0", "magma", "2015-10-17 19:42:57", "82.67.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3023", "0", "magma", "2015-10-17 19:49:17", "91.185.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3024", "0", "magma", "2015-10-17 19:52:02", "24.157.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3025", "0", "magma", "2015-10-17 19:56:27", "190.152.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3026", "1", "admin8576", "2015-10-17 19:59:16", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3027", "0", "magma", "2015-10-17 19:59:28", "116.87.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3028", "0", "magma", "2015-10-17 20:15:01", "78.21.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3029", "0", "magma", "2015-10-17 20:30:38", "5.15.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3030", "0", "magma", "2015-10-17 20:31:04", "31.2.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3031", "0", "magma", "2015-10-17 20:37:11", "213.156.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3032", "0", "magma", "2015-10-17 20:37:22", "39.57.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3033", "0", "magma", "2015-10-17 20:39:08", "78.13.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3034", "0", "magma", "2015-10-17 20:39:42", "2.225.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3035", "0", "magma", "2015-10-17 20:49:32", "111.88.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3036", "0", "magma", "2015-10-17 20:51:06", "37.157.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3037", "0", "magma", "2015-10-17 20:51:31", "37.211.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3038", "0", "magma", "2015-10-17 20:57:19", "82.30.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3039", "0", "magma", "2015-10-17 21:00:31", "46.117.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3040", "0", "magma", "2015-10-17 21:01:18", "81.165.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3041", "0", "magma", "2015-10-17 21:13:32", "41.136.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3042", "0", "magma", "2015-10-17 21:14:36", "121.87.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3043", "0", "magma", "2015-10-17 21:22:51", "118.96.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3044", "0", "magma", "2015-10-17 21:33:06", "70.171.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3045", "0", "magma", "2015-10-17 21:38:00", "68.195.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3046", "0", "magma", "2015-10-17 21:39:11", "80.174.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3047", "0", "magma", "2015-10-17 21:43:09", "186.45.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3048", "0", "magma", "2015-10-17 21:47:37", "122.175.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3049", "0", "magma", "2015-10-17 21:47:56", "148.101.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3050", "0", "magma", "2015-10-17 21:52:59", "31.134.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3051", "0", "magma", "2015-10-17 22:03:00", "174.21.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3052", "0", "magma", "2015-10-17 22:10:30", "178.220.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3053", "0", "magma", "2015-10-17 22:12:45", "88.231.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3054", "0", "magma", "2015-10-17 22:13:37", "129.7.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3055", "0", "magma", "2015-10-17 22:21:46", "78.58.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3056", "0", "admin", "2015-10-17 22:48:08", "62.212.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3057", "0", "admin", "2015-10-17 22:49:16", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3058", "0", "magma", "2015-10-17 23:08:07", "210.195.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3059", "0", "magma", "2015-10-17 23:10:50", "86.98.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3060", "0", "magma", "2015-10-17 23:13:56", "137.207.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3061", "0", "magma", "2015-10-17 23:14:57", "82.27.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3062", "0", "magma", "2015-10-17 23:16:15", "79.118.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3063", "0", "magma", "2015-10-17 23:17:03", "1.243.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3064", "0", "magma", "2015-10-17 23:21:30", "202.142.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3065", "0", "magma", "2015-10-17 23:34:32", "78.98.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3066", "0", "magma", "2015-10-17 23:48:51", "2.30.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3067", "0", "magma", "2015-10-18 00:02:37", "178.213.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3068", "1", "admin8576", "2015-10-18 00:06:35", "23.91.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3069", "0", "magma", "2015-10-18 00:13:22", "111.237.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3070", "0", "magma", "2015-10-18 00:13:50", "67.189.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3071", "0", "magma", "2015-10-18 00:15:41", "39.55.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3072", "0", "magma", "2015-10-18 00:17:40", "197.86.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3073", "0", "magma", "2015-10-18 00:17:55", "213.238.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3074", "0", "magma", "2015-10-18 00:20:55", "87.69.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3075", "0", "magma", "2015-10-18 00:24:27", "109.67.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3076", "0", "magma", "2015-10-18 00:25:20", "188.141.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3077", "0", "magma", "2015-10-18 00:27:22", "47.18.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3078", "0", "magma", "2015-10-18 00:36:06", "77.222.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3079", "0", "admin", "2015-10-18 00:37:38", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3080", "0", "magma", "2015-10-18 00:43:13", "151.0.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3081", "0", "magma", "2015-10-18 00:46:20", "177.10.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3082", "0", "magma", "2015-10-18 01:12:20", "181.73.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3083", "1", "admin8576", "2015-10-18 01:28:05", "81.7.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3084", "0", "magma", "2015-10-18 01:28:43", "178.153.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3085", "0", "magma", "2015-10-18 01:35:10", "41.207.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3086", "0", "magma", "2015-10-18 01:37:38", "82.19.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3087", "0", "magma", "2015-10-18 01:39:43", "197.86.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3088", "0", "magma", "2015-10-18 01:40:52", "95.95.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3089", "0", "magma", "2015-10-18 01:41:57", "104.235.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3090", "0", "magma", "2015-10-18 01:46:20", "75.40.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3091", "0", "magma", "2015-10-18 01:50:57", "96.55.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3092", "0", "magma", "2015-10-18 02:02:44", "77.97.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3093", "0", "magma", "2015-10-18 02:05:20", "95.185.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3094", "0", "magma", "2015-10-18 02:38:23", "31.11.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3095", "0", "magma", "2015-10-18 02:45:21", "221.202.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3096", "1", "admin8576", "2015-10-18 02:46:15", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3097", "0", "admin", "2015-10-18 02:52:43", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3098", "0", "magma", "2015-10-18 02:59:13", "147.194.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3099", "0", "magma", "2015-10-18 03:00:39", "200.192.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3100", "0", "magma", "2015-10-18 03:10:56", "46.116.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3101", "0", "magma", "2015-10-18 03:14:20", "35.32.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3102", "0", "magma", "2015-10-18 03:52:03", "182.178.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3103", "0", "magma", "2015-10-18 03:58:19", "89.205.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3104", "1", "admin8576", "2015-10-18 04:04:05", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3105", "0", "magma", "2015-10-18 04:20:05", "92.149.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3106", "0", "magma", "2015-10-18 04:24:41", "191.177.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3107", "0", "magma", "2015-10-18 04:25:56", "79.117.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3108", "0", "magma", "2015-10-18 04:27:08", "92.53.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3109", "0", "magma", "2015-10-18 04:38:30", "113.210.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3110", "0", "magma", "2015-10-18 04:49:03", "112.198.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3111", "0", "magma", "2015-10-18 05:00:08", "104.162.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3112", "0", "magma", "2015-10-18 05:06:23", "58.104.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3113", "0", "magma", "2015-10-18 05:11:18", "173.172.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3114", "0", "magma", "2015-10-18 05:15:01", "181.55.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3115", "1", "admin8576", "2015-10-18 05:22:06", "192.99.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3116", "0", "magma", "2015-10-18 05:26:57", "46.116.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3117", "0", "magma", "2015-10-18 05:39:27", "135.23.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3118", "0", "magma", "2015-10-18 05:42:28", "68.81.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3119", "0", "magma", "2015-10-18 06:00:40", "70.49.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3120", "0", "magma", "2015-10-18 06:16:32", "220.124.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3121", "0", "magma", "2015-10-18 06:23:05", "109.65.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3122", "0", "magma", "2015-10-18 06:26:29", "118.101.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3123", "1", "admin8576", "2015-10-18 06:39:28", "94.23.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3124", "0", "magma", "2015-10-18 06:53:27", "105.226.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3125", "0", "magma", "2015-10-18 06:54:08", "103.231.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3126", "0", "magma", "2015-10-18 07:13:12", "117.204.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3127", "0", "magma", "2015-10-18 07:16:37", "78.95.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3128", "0", "magma", "2015-10-18 07:24:31", "72.241.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3129", "0", "magma", "2015-10-18 07:35:24", "74.57.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3130", "0", "magma", "2015-10-18 07:35:44", "108.180.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3131", "0", "admin", "2015-10-18 07:43:10", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3132", "0", "admin", "2015-10-18 07:52:46", "94.156.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3133", "0", "magma", "2015-10-18 07:54:01", "49.248.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3134", "0", "magma", "2015-10-18 07:55:29", "73.206.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3135", "1", "admin8576", "2015-10-18 07:55:53", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3136", "0", "magma", "2015-10-18 07:56:58", "82.84.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3137", "0", "magma", "2015-10-18 07:58:27", "119.93.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3138", "0", "magma", "2015-10-18 08:01:45", "210.186.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3139", "0", "magma", "2015-10-18 08:10:46", "124.104.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3140", "0", "magma", "2015-10-18 08:28:52", "93.130.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3141", "0", "magma", "2015-10-18 08:34:51", "59.95.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3142", "0", "magma", "2015-10-18 08:52:27", "126.7.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3143", "0", "magma", "2015-10-18 08:54:03", "118.97.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3144", "0", "magma", "2015-10-18 08:59:42", "39.49.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3145", "0", "magma", "2015-10-18 09:10:01", "1.52.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3146", "1", "admin8576", "2015-10-18 09:14:14", "207.244.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3147", "0", "magma", "2015-10-18 09:31:41", "120.56.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3148", "0", "magma", "2015-10-18 09:41:29", "79.193.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3149", "0", "magma", "2015-10-18 09:48:19", "61.255.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3150", "0", "magma", "2015-10-18 09:57:36", "105.184.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3151", "0", "magma", "2015-10-18 10:03:49", "95.165.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3152", "0", "magma", "2015-10-18 10:14:46", "178.221.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3153", "0", "magma", "2015-10-18 10:28:26", "211.212.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3154", "1", "admin8576", "2015-10-18 10:34:37", "192.99.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3155", "0", "magma", "2015-10-18 10:45:53", "109.96.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3156", "0", "magma", "2015-10-18 10:47:24", "82.124.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3157", "0", "magma", "2015-10-18 10:48:52", "212.107.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3158", "0", "magma", "2015-10-18 10:53:32", "79.108.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3159", "0", "magma", "2015-10-18 10:55:18", "109.57.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3160", "0", "magma", "2015-10-18 10:56:42", "82.56.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3161", "0", "magma", "2015-10-18 10:57:42", "101.57.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3162", "0", "magma", "2015-10-18 11:01:27", "202.21.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3163", "0", "magma", "2015-10-18 11:05:31", "5.13.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3164", "0", "magma", "2015-10-18 11:08:54", "58.160.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3165", "0", "magma", "2015-10-18 11:16:27", "83.250.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3166", "0", "magma", "2015-10-18 11:23:52", "83.56.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3167", "0", "admin", "2015-10-18 11:24:26", "46.28.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3168", "0", "magma", "2015-10-18 11:26:39", "202.160.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3169", "0", "magma", "2015-10-18 11:35:22", "213.143.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3170", "0", "magma", "2015-10-18 11:38:20", "203.210.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3171", "1", "admin8576", "2015-10-18 11:55:42", "178.162.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3172", "0", "magma", "2015-10-18 12:10:17", "139.192.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3173", "0", "magma", "2015-10-18 12:26:38", "86.86.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3174", "0", "magma", "2015-10-18 12:29:28", "2.85.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3175", "0", "magma", "2015-10-18 12:35:19", "109.96.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3176", "0", "magma", "2015-10-18 12:37:31", "84.109.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3177", "0", "magma", "2015-10-18 12:51:42", "95.135.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3178", "0", "magma", "2015-10-18 12:55:07", "117.201.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3179", "0", "magma", "2015-10-18 13:12:54", "80.242.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3180", "1", "admin8576", "2015-10-18 13:18:55", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3181", "0", "magma", "2015-10-18 13:24:15", "178.221.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3182", "0", "magma", "2015-10-18 13:27:41", "84.109.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3183", "0", "magma", "2015-10-18 13:30:30", "151.33.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3184", "0", "magma", "2015-10-18 13:35:18", "105.102.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3185", "0", "magma", "2015-10-18 13:44:01", "182.178.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3186", "0", "magma", "2015-10-18 13:49:28", "197.255.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3187", "0", "magma", "2015-10-18 14:06:30", "197.160.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3188", "0", "magma", "2015-10-18 14:09:01", "112.204.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3189", "0", "magma", "2015-10-18 14:18:10", "179.105.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3190", "0", "magma", "2015-10-18 14:42:20", "109.173.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3191", "0", "magma", "2015-10-18 14:43:08", "43.230.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3192", "1", "admin8576", "2015-10-18 14:43:37", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3193", "0", "magma", "2015-10-18 14:50:49", "104.237.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3194", "0", "magma", "2015-10-18 14:51:16", "85.254.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3195", "0", "magma", "2015-10-18 14:53:48", "178.220.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3196", "0", "magma", "2015-10-18 14:57:51", "116.48.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3197", "0", "magma", "2015-10-18 15:00:49", "146.199.111.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3198", "0", "magma", "2015-10-18 15:02:54", "149.3.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3199", "0", "magma", "2015-10-18 15:06:47", "31.11.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3200", "0", "magma", "2015-10-18 15:12:51", "39.48.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3201", "0", "magma", "2015-10-18 15:13:21", "105.99.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3202", "0", "magma", "2015-10-18 15:39:06", "176.92.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3203", "0", "magma", "2015-10-18 15:43:12", "89.47.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3204", "0", "magma", "2015-10-18 15:51:08", "178.221.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3205", "0", "magma", "2015-10-18 15:55:38", "78.62.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3206", "1", "admin8576", "2015-10-18 16:08:41", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3207", "0", "magma", "2015-10-18 16:19:51", "126.64.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3208", "0", "admin", "2015-10-18 16:46:06", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3209", "0", "magma", "2015-10-18 16:51:14", "118.97.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3210", "0", "magma", "2015-10-18 17:07:24", "78.92.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3211", "0", "magma", "2015-10-18 17:19:15", "66.172.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3212", "1", "admin8576", "2015-10-18 17:33:54", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3213", "0", "magma", "2015-10-18 17:34:00", "49.207.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3214", "0", "magma", "2015-10-18 17:54:02", "83.4.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3215", "0", "magma", "2015-10-18 17:55:02", "93.130.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3216", "0", "admin", "2015-10-18 17:58:15", "142.4.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3217", "0", "magma", "2015-10-18 17:59:09", "78.60.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3218", "0", "magma", "2015-10-18 18:13:29", "79.115.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3219", "0", "magma", "2015-10-18 18:14:00", "46.236.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3220", "0", "magma", "2015-10-18 18:14:31", "106.68.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3221", "0", "magma", "2015-10-18 18:15:02", "31.214.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3222", "0", "magma", "2015-10-18 18:18:53", "81.104.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3223", "0", "magma", "2015-10-18 18:33:18", "2.51.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3224", "0", "magma", "2015-10-18 18:57:33", "93.76.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3225", "1", "admin8576", "2015-10-18 18:59:49", "207.244.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3226", "0", "magma", "2015-10-18 19:00:57", "93.103.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3227", "0", "magma", "2015-10-18 19:02:40", "202.142.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3228", "0", "magma", "2015-10-18 19:02:48", "94.67.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3229", "0", "magma", "2015-10-18 19:07:19", "41.251.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3230", "0", "magma", "2015-10-18 19:09:59", "37.201.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3231", "0", "magma", "2015-10-18 19:13:50", "88.227.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3232", "0", "magma", "2015-10-18 19:18:42", "93.58.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3233", "0", "magma", "2015-10-18 19:23:30", "94.177.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3234", "0", "magma", "2015-10-18 19:28:20", "189.48.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3235", "0", "magma", "2015-10-18 19:32:37", "62.98.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3236", "0", "magma", "2015-10-18 19:36:43", "87.126.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3237", "0", "magma", "2015-10-18 19:37:16", "177.205.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3238", "0", "magma", "2015-10-18 19:46:30", "72.178.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3239", "0", "magma", "2015-10-18 19:48:04", "89.103.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3240", "0", "magma", "2015-10-18 19:54:39", "178.143.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3241", "0", "magma", "2015-10-18 20:09:24", "159.20.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3242", "0", "magma", "2015-10-18 20:10:23", "188.25.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3243", "0", "magma", "2015-10-18 20:12:35", "93.103.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3244", "0", "magma", "2015-10-18 20:20:04", "176.73.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3245", "1", "admin8576", "2015-10-18 20:23:29", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3246", "0", "magma", "2015-10-18 20:23:29", "178.233.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3247", "0", "magma", "2015-10-18 20:23:40", "46.149.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3248", "0", "magma", "2015-10-18 20:31:03", "5.246.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3249", "0", "magma", "2015-10-18 20:35:34", "177.80.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3250", "0", "magma", "2015-10-18 20:45:33", "103.26.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3251", "0", "magma", "2015-10-18 20:47:29", "182.185.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3252", "0", "magma", "2015-10-18 20:48:49", "131.161.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3253", "0", "magma", "2015-10-18 21:04:39", "79.157.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3254", "0", "magma", "2015-10-18 21:07:02", "95.95.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3255", "0", "magma", "2015-10-18 21:27:50", "41.102.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3256", "0", "magma", "2015-10-18 21:28:40", "83.117.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3257", "0", "magma", "2015-10-18 21:36:38", "178.128.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3258", "0", "magma", "2015-10-18 21:41:04", "78.60.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3259", "0", "magma", "2015-10-18 21:43:10", "86.98.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3260", "1", "admin8576", "2015-10-18 21:47:30", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3261", "0", "magma", "2015-10-18 21:48:03", "10.1.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3262", "0", "magma", "2015-10-18 21:58:39", "94.132.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3263", "0", "magma", "2015-10-18 22:10:21", "5.64.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3264", "0", "magma", "2015-10-18 22:21:02", "45.74.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3265", "0", "magma", "2015-10-18 22:21:59", "134.226.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3266", "0", "magma", "2015-10-18 22:36:35", "190.160.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3267", "0", "magma", "2015-10-18 22:52:11", "79.169.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3268", "0", "magma", "2015-10-18 23:08:50", "93.43.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3269", "1", "admin8576", "2015-10-18 23:11:12", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3270", "0", "magma", "2015-10-18 23:45:22", "200.73.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3271", "0", "magma", "2015-10-18 23:58:16", "78.147.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3272", "0", "magma", "2015-10-19 00:09:58", "77.89.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3273", "0", "magma", "2015-10-19 00:13:55", "193.59.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3274", "0", "magma", "2015-10-19 00:19:46", "88.167.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3275", "0", "magma", "2015-10-19 00:42:27", "78.92.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3276", "0", "magma", "2015-10-19 00:42:47", "177.179.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3277", "0", "magma", "2015-10-19 00:56:57", "119.93.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3278", "0", "magma", "2015-10-19 01:20:15", "24.90.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3279", "0", "magma", "2015-10-19 01:34:05", "68.172.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3280", "0", "magma", "2015-10-19 02:19:05", "2.50.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3281", "0", "magma", "2015-10-19 02:19:16", "177.143.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3282", "0", "magma", "2015-10-19 02:26:36", "82.213.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3283", "0", "admin", "2015-10-19 02:35:11", "178.219.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3284", "0", "magma", "2015-10-19 02:43:00", "119.73.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3285", "0", "magma", "2015-10-19 02:48:34", "93.139.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3286", "0", "admin", "2015-10-19 02:52:36", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3287", "1", "admin8576", "2015-10-19 03:06:08", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3288", "0", "magma", "2015-10-19 03:34:21", "83.153.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3289", "0", "magma", "2015-10-19 03:53:06", "220.255.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3290", "0", "magma", "2015-10-19 04:03:24", "180.255.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3291", "0", "magma", "2015-10-19 04:04:11", "31.185.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3292", "0", "magma", "2015-10-19 04:23:05", "82.10.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3293", "0", "magma", "2015-10-19 04:31:10", "92.85.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3294", "0", "magma", "2015-10-19 05:03:52", "124.83.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3295", "0", "admin", "2015-10-19 06:06:03", "104.167.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3296", "0", "magma", "2015-10-19 06:13:23", "85.127.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3297", "0", "magma", "2015-10-19 06:21:07", "186.45.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3298", "1", "admin8576", "2015-10-19 07:00:06", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3299", "0", "magma", "2015-10-19 07:03:50", "133.21.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3300", "0", "magma", "2015-10-19 07:14:55", "76.183.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3301", "0", "magma", "2015-10-19 07:41:02", "182.185.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3302", "1", "admin8576", "2015-10-19 08:16:51", "120.29.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3303", "0", "magma", "2015-10-19 08:26:40", "49.205.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3304", "0", "magma", "2015-10-19 08:49:28", "86.5.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3305", "0", "magma", "2015-10-19 08:57:00", "104.32.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3306", "0", "magma", "2015-10-19 09:21:46", "49.151.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3307", "0", "magma", "2015-10-19 09:31:52", "49.146.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3308", "1", "admin8576", "2015-10-19 09:33:35", "77.244.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3309", "0", "magma", "2015-10-19 09:59:30", "5.140.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3310", "0", "magma", "2015-10-19 10:03:31", "79.46.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3311", "0", "magma", "2015-10-19 10:13:40", "49.145.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3312", "0", "magma", "2015-10-19 10:15:09", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3313", "0", "magma", "2015-10-19 10:19:15", "123.63.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3314", "0", "magma", "2015-10-19 10:23:46", "12.26.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3315", "0", "magma", "2015-10-19 10:29:23", "122.61.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3316", "0", "magma", "2015-10-19 10:43:40", "79.126.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3317", "1", "admin8576", "2015-10-19 10:52:09", "94.26.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3318", "0", "magma", "2015-10-19 10:59:28", "173.168.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3319", "0", "magma", "2015-10-19 11:42:00", "165.50.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3320", "0", "magma", "2015-10-19 11:44:08", "65.183.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3321", "0", "magma", "2015-10-19 11:54:19", "194.103.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3322", "1", "admin8576", "2015-10-19 12:12:08", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3323", "0", "admin", "2015-10-19 12:21:18", "176.9.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3324", "0", "admin", "2015-10-19 12:39:46", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3325", "0", "magma", "2015-10-19 13:01:58", "81.165.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3326", "0", "magma", "2015-10-19 13:25:04", "123.2.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3327", "1", "admin8576", "2015-10-19 13:31:16", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3328", "0", "magma", "2015-10-19 13:42:29", "109.121.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3329", "0", "magma", "2015-10-19 13:45:17", "123.254.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3330", "0", "magma", "2015-10-19 14:10:43", "79.53.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3331", "0", "magma", "2015-10-19 14:16:43", "95.180.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3332", "0", "magma", "2015-10-19 14:50:36", "188.126.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3333", "0", "magma", "2015-10-19 14:55:20", "87.8.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3334", "0", "magma", "2015-10-19 15:17:07", "73.213.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3335", "0", "magma", "2015-10-19 15:20:41", "189.29.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3336", "0", "magma", "2015-10-19 15:24:45", "37.221.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3337", "0", "magma", "2015-10-19 15:25:45", "104.193.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3338", "0", "admin", "2015-10-19 15:39:15", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3339", "0", "magma", "2015-10-19 15:54:41", "149.78.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3340", "0", "magma", "2015-10-19 16:14:15", "101.100.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3341", "1", "admin8576", "2015-10-19 16:14:24", "108.166.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3342", "0", "magma", "2015-10-19 16:47:00", "123.237.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3343", "0", "magma", "2015-10-19 17:02:32", "85.154.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3344", "0", "magma", "2015-10-19 17:12:42", "188.123.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3345", "0", "magma", "2015-10-19 17:15:43", "89.211.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3346", "0", "magma", "2015-10-19 17:31:55", "93.172.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3347", "1", "admin8576", "2015-10-19 17:33:59", "37.187.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3348", "0", "magma", "2015-10-19 17:34:23", "41.213.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3349", "0", "magma", "2015-10-19 17:40:25", "86.123.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3350", "0", "magma", "2015-10-19 17:44:00", "95.158.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3351", "0", "magma", "2015-10-19 18:40:00", "31.215.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3352", "1", "admin8576", "2015-10-19 18:54:34", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3353", "0", "magma", "2015-10-19 18:57:18", "177.43.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3354", "0", "magma", "2015-10-19 19:10:30", "202.21.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3355", "0", "magma", "2015-10-19 19:17:24", "5.29.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3356", "0", "magma", "2015-10-19 19:32:09", "46.218.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3357", "0", "magma", "2015-10-19 19:37:15", "91.90.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3358", "0", "magma", "2015-10-19 19:42:03", "123.237.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3359", "0", "magma", "2015-10-19 19:52:28", "87.68.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3360", "0", "magma", "2015-10-19 20:06:44", "85.96.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3361", "1", "admin8576", "2015-10-19 20:16:47", "62.212.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3362", "0", "magma", "2015-10-19 20:24:07", "14.201.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3363", "0", "magma", "2015-10-19 20:25:44", "128.234.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3364", "0", "magma", "2015-10-19 20:30:42", "41.236.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3365", "0", "magma", "2015-10-19 20:31:59", "5.246.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3366", "0", "magma", "2015-10-19 20:38:13", "41.133.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3367", "0", "magma", "2015-10-19 20:45:55", "37.203.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3368", "0", "magma", "2015-10-19 21:21:02", "173.168.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3369", "0", "magma", "2015-10-19 21:26:54", "86.5.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3370", "0", "magma", "2015-10-19 21:31:44", "113.161.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3371", "0", "magma", "2015-10-19 21:40:35", "149.78.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3372", "1", "admin8576", "2015-10-19 21:41:49", "162.247.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3373", "0", "magma", "2015-10-19 21:52:58", "89.216.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3374", "0", "magma", "2015-10-19 22:04:54", "24.135.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3375", "0", "magma", "2015-10-19 22:22:39", "83.99.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3376", "0", "admin", "2015-10-19 22:22:50", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3377", "0", "magma", "2015-10-19 22:28:12", "128.179.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3378", "0", "magma", "2015-10-19 22:39:05", "77.77.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3379", "0", "magma", "2015-10-19 22:41:27", "79.176.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3380", "0", "magma", "2015-10-19 22:42:49", "5.66.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3381", "0", "admin", "2015-10-19 22:43:49", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3382", "0", "admin", "2015-10-19 22:47:32", "178.17.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3383", "0", "magma", "2015-10-19 22:59:13", "151.26.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3384", "0", "magma", "2015-10-19 23:10:55", "119.26.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3385", "0", "magma", "2015-10-19 23:20:51", "73.213.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3386", "0", "magma", "2015-10-19 23:23:53", "73.141.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3387", "0", "magma", "2015-10-19 23:24:57", "79.116.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3388", "0", "magma", "2015-10-19 23:43:08", "77.125.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3389", "0", "magma", "2015-10-19 23:49:45", "177.83.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3390", "1", "admin8576", "2015-10-20 00:27:46", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3391", "0", "magma", "2015-10-20 00:29:13", "82.19.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3392", "0", "magma", "2015-10-20 00:32:30", "218.49.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3393", "0", "magma", "2015-10-20 01:06:13", "167.59.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3394", "0", "magma", "2015-10-20 01:10:58", "190.92.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3395", "0", "magma", "2015-10-20 01:33:37", "112.198.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3396", "0", "magma", "2015-10-20 01:39:07", "86.40.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3397", "1", "admin8576", "2015-10-20 01:44:05", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3398", "0", "magma", "2015-10-20 01:47:20", "101.186.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3399", "0", "magma", "2015-10-20 02:10:58", "109.252.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3400", "0", "magma", "2015-10-20 02:23:11", "45.74.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3401", "0", "magma", "2015-10-20 02:56:40", "95.185.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3402", "1", "admin8576", "2015-10-20 02:59:35", "212.47.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3403", "0", "magma", "2015-10-20 03:09:46", "167.59.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3404", "0", "magma", "2015-10-20 03:34:10", "71.95.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3405", "0", "magma", "2015-10-20 03:52:46", "82.213.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3406", "0", "magma", "2015-10-20 03:58:05", "191.243.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3407", "1", "admin8576", "2015-10-20 04:16:47", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3408", "0", "magma", "2015-10-20 04:41:44", "177.223.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3409", "0", "magma", "2015-10-20 04:41:55", "31.215.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3410", "0", "magma", "2015-10-20 05:20:38", "178.124.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3411", "0", "magma", "2015-10-20 05:55:40", "182.185.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3412", "0", "magma", "2015-10-20 06:10:18", "46.62.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3413", "0", "magma", "2015-10-20 06:49:11", "82.213.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3414", "0", "magma", "2015-10-20 07:28:19", "112.198.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3415", "0", "magma", "2015-10-20 07:55:59", "92.99.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3416", "0", "admin", "2015-10-20 07:57:32", "5.135.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3417", "0", "magma", "2015-10-20 08:07:40", "2.50.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3418", "0", "magma", "2015-10-20 08:52:04", "178.220.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3419", "0", "magma", "2015-10-20 09:03:17", "194.28.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3420", "0", "magma", "2015-10-20 09:14:54", "178.59.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3421", "0", "magma", "2015-10-20 09:45:30", "95.56.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3422", "0", "magma", "2015-10-20 09:48:51", "78.0.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3423", "0", "magma", "2015-10-20 09:50:38", "82.172.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3424", "0", "magma", "2015-10-20 10:05:49", "94.177.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3425", "0", "magma", "2015-10-20 10:14:44", "217.165.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3426", "0", "admin", "2015-10-20 10:47:58", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3427", "1", "admin8576", "2015-10-20 10:53:37", "62.212.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3428", "0", "magma", "2015-10-20 11:00:16", "88.119.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3429", "0", "magma", "2015-10-20 11:33:32", "36.231.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3430", "0", "magma", "2015-10-20 11:42:27", "86.98.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3431", "0", "magma", "2015-10-20 12:27:28", "126.64.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3432", "0", "magma", "2015-10-20 12:29:02", "79.127.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3433", "0", "magma", "2015-10-20 12:35:34", "111.93.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3434", "0", "magma", "2015-10-20 12:44:59", "95.103.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3435", "0", "magma", "2015-10-20 12:51:33", "182.178.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3436", "0", "magma", "2015-10-20 12:59:01", "62.219.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3437", "0", "magma", "2015-10-20 13:11:48", "154.70.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3438", "0", "magma", "2015-10-20 13:15:00", "94.190.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3439", "1", "admin8576", "2015-10-20 13:38:37", "5.135.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3440", "0", "magma", "2015-10-20 14:00:18", "176.73.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3441", "0", "magma", "2015-10-20 14:11:40", "202.142.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3442", "0", "magma", "2015-10-20 14:28:14", "109.78.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3443", "0", "magma", "2015-10-20 14:38:43", "103.225.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3444", "0", "magma", "2015-10-20 14:40:30", "105.226.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3445", "1", "admin8576", "2015-10-20 14:58:08", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3446", "0", "magma", "2015-10-20 15:09:22", "45.74.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3447", "0", "magma", "2015-10-20 15:37:20", "85.244.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3448", "0", "magma", "2015-10-20 15:39:47", "77.40.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3449", "0", "magma", "2015-10-20 15:56:36", "60.243.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3450", "1", "admin8576", "2015-10-20 16:25:15", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3451", "0", "magma", "2015-10-20 16:44:54", "61.6.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3452", "0", "admin", "2015-10-20 16:50:16", "158.130.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3453", "0", "magma", "2015-10-20 17:37:20", "5.245.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3454", "0", "magma", "2015-10-20 18:09:57", "78.174.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3455", "0", "magma", "2015-10-20 18:13:07", "188.17.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3456", "0", "magma", "2015-10-20 18:44:48", "39.32.111.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3457", "0", "magma", "2015-10-20 19:06:49", "151.52.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3458", "0", "magma", "2015-10-20 19:18:11", "41.213.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3459", "1", "admin8576", "2015-10-20 19:22:51", "77.244.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3460", "0", "magma", "2015-10-20 19:30:15", "46.193.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3461", "0", "magma", "2015-10-20 19:36:20", "221.149.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3462", "0", "magma", "2015-10-20 19:45:29", "123.254.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3463", "0", "magma", "2015-10-20 19:53:15", "86.98.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3464", "0", "magma", "2015-10-20 19:55:46", "2.51.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3465", "0", "admin", "2015-10-20 20:38:22", "178.20.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3466", "0", "magma", "2015-10-20 20:38:33", "86.134.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3467", "0", "magma", "2015-10-20 20:51:53", "64.185.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3468", "1", "admin8576", "2015-10-20 20:52:03", "158.69.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3469", "0", "magma", "2015-10-20 21:37:17", "190.150.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3470", "0", "magma", "2015-10-20 21:44:14", "81.61.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3471", "0", "magma", "2015-10-20 21:45:23", "79.177.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3472", "0", "magma", "2015-10-20 22:02:04", "103.232.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3473", "0", "magma", "2015-10-20 22:09:45", "195.26.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3474", "1", "admin8576", "2015-10-20 22:20:16", "151.80.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3475", "0", "magma", "2015-10-20 22:31:18", "86.98.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3476", "0", "magma", "2015-10-20 22:38:54", "71.95.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3477", "0", "magma", "2015-10-20 23:04:04", "81.237.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3478", "0", "magma", "2015-10-20 23:42:35", "41.143.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3479", "1", "admin8576", "2015-10-20 23:42:52", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3480", "0", "magma", "2015-10-21 00:02:59", "121.6.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3481", "0", "magma", "2015-10-21 00:05:03", "188.26.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3482", "0", "magma", "2015-10-21 00:23:51", "191.7.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3483", "0", "magma", "2015-10-21 00:48:11", "93.163.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3484", "0", "magma", "2015-10-21 00:51:03", "86.10.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3485", "1", "admin8576", "2015-10-21 01:03:37", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3486", "0", "magma", "2015-10-21 01:13:16", "177.223.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3487", "0", "magma", "2015-10-21 01:19:18", "92.53.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3488", "0", "magma", "2015-10-21 01:25:37", "27.38.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3489", "0", "magma", "2015-10-21 01:32:40", "91.206.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3490", "0", "magma", "2015-10-21 01:54:44", "191.7.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3491", "0", "magma", "2015-10-21 02:05:34", "93.173.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3492", "0", "magma", "2015-10-21 02:19:49", "197.38.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3493", "0", "magma", "2015-10-21 02:22:32", "94.197.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3494", "1", "admin8576", "2015-10-21 02:22:42", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3495", "0", "admin", "2015-10-21 02:55:10", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3496", "0", "magma", "2015-10-21 02:58:33", "149.78.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3497", "0", "magma", "2015-10-21 03:15:50", "85.130.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3498", "0", "magma", "2015-10-21 03:16:05", "92.53.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3499", "0", "admin", "2015-10-21 03:38:23", "51.254.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3500", "1", "admin8576", "2015-10-21 03:47:58", "178.17.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3501", "0", "magma", "2015-10-21 04:08:12", "181.55.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3502", "0", "magma", "2015-10-21 04:13:45", "115.134.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3503", "0", "magma", "2015-10-21 04:29:01", "41.59.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3504", "0", "magma", "2015-10-21 04:32:16", "174.52.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3505", "0", "magma", "2015-10-21 05:06:33", "189.51.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3506", "1", "admin8576", "2015-10-21 05:25:02", "46.165.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3507", "0", "magma", "2015-10-21 05:36:25", "103.232.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3508", "0", "magma", "2015-10-21 05:56:41", "117.202.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3509", "0", "magma", "2015-10-21 06:04:28", "80.174.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3510", "0", "admin", "2015-10-21 06:19:38", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3511", "0", "magma", "2015-10-21 06:21:56", "94.60.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3512", "0", "magma", "2015-10-21 06:24:10", "46.162.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3513", "0", "magma", "2015-10-21 06:33:58", "41.207.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3514", "0", "magma", "2015-10-21 06:34:19", "87.237.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3515", "0", "magma", "2015-10-21 06:50:57", "186.11.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3516", "0", "magma", "2015-10-21 07:18:18", "14.97.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3517", "1", "admin8576", "2015-10-21 07:22:52", "31.220.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3518", "0", "magma", "2015-10-21 08:14:47", "175.140.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3519", "0", "magma", "2015-10-21 08:21:45", "212.107.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3520", "0", "magma", "2015-10-21 09:07:18", "112.211.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3521", "1", "admin8576", "2015-10-21 09:07:32", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3522", "0", "magma", "2015-10-21 09:21:27", "93.184.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3523", "0", "magma", "2015-10-21 09:23:22", "39.42.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3524", "0", "magma", "2015-10-21 09:48:08", "85.254.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3525", "0", "magma", "2015-10-21 09:59:30", "78.63.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3526", "0", "magma", "2015-10-21 10:04:02", "85.102.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3527", "1", "admin8576", "2015-10-21 10:25:27", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3528", "0", "magma", "2015-10-21 10:28:00", "154.66.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3529", "0", "magma", "2015-10-21 11:11:53", "125.19.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3530", "0", "magma", "2015-10-21 11:20:56", "95.94.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3531", "0", "magma", "2015-10-21 11:28:31", "78.11.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3532", "1", "admin8576", "2015-10-21 11:44:49", "86.180.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3533", "0", "magma", "2015-10-21 11:54:07", "93.103.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3534", "0", "magma", "2015-10-21 11:58:21", "198.200.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3535", "0", "admin", "2015-10-21 12:19:06", "79.120.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3536", "0", "admin", "2015-10-21 12:20:59", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3537", "0", "magma", "2015-10-21 12:29:57", "203.147.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3538", "0", "magma", "2015-10-21 12:30:37", "82.61.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3539", "0", "magma", "2015-10-21 12:42:09", "95.235.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3540", "1", "admin8576", "2015-10-21 13:04:05", "74.208.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3541", "0", "magma", "2015-10-21 13:24:45", "196.217.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3542", "0", "magma", "2015-10-21 13:39:47", "86.1.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3543", "0", "magma", "2015-10-21 13:58:47", "89.169.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3544", "0", "magma", "2015-10-21 14:01:24", "176.93.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3545", "0", "magma", "2015-10-21 14:07:14", "111.91.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3546", "0", "magma", "2015-10-21 14:16:47", "178.221.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3547", "0", "magma", "2015-10-21 14:23:26", "90.157.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3548", "1", "admin8576", "2015-10-21 14:25:02", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3549", "0", "magma", "2015-10-21 14:40:31", "184.3.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3550", "0", "magma", "2015-10-21 15:09:07", "162.234.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3551", "0", "magma", "2015-10-21 15:17:19", "178.143.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3552", "0", "magma", "2015-10-21 15:19:09", "58.97.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3553", "0", "magma", "2015-10-21 15:38:24", "178.223.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3554", "0", "magma", "2015-10-21 15:44:26", "213.22.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3555", "1", "admin8576", "2015-10-21 15:46:35", "62.212.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3556", "0", "magma", "2015-10-21 16:02:00", "61.255.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3557", "0", "magma", "2015-10-21 16:27:49", "82.144.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3558", "0", "magma", "2015-10-21 16:38:01", "82.213.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3559", "0", "magma", "2015-10-21 16:45:54", "176.92.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3560", "0", "magma", "2015-10-21 16:56:52", "78.96.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3561", "1", "admin8576", "2015-10-21 17:09:16", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3562", "0", "magma", "2015-10-21 17:18:37", "14.37.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3563", "0", "magma", "2015-10-21 17:39:06", "95.93.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3564", "0", "magma", "2015-10-21 18:20:40", "86.129.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3565", "0", "magma", "2015-10-21 18:25:41", "178.221.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3566", "1", "admin8576", "2015-10-21 18:30:00", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3567", "0", "magma", "2015-10-21 18:30:09", "85.50.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3568", "0", "magma", "2015-10-21 19:01:02", "87.248.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3569", "0", "magma", "2015-10-21 19:29:15", "77.127.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3570", "0", "magma", "2015-10-21 19:44:05", "202.166.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3571", "0", "magma", "2015-10-21 19:45:08", "109.121.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3572", "1", "admin8576", "2015-10-21 19:49:53", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3573", "1", "admin8576", "2015-10-21 21:11:09", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3574", "0", "magma", "2015-10-21 22:13:36", "77.98.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3575", "0", "magma", "2015-10-21 22:27:37", "24.235.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3576", "1", "admin8576", "2015-10-21 22:32:09", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3577", "0", "admin", "2015-10-21 22:40:18", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3578", "0", "admin", "2015-10-21 22:40:58", "89.187.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3579", "0", "magma", "2015-10-21 22:42:21", "41.72.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3580", "0", "magma", "2015-10-21 22:57:38", "104.137.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3581", "0", "magma", "2015-10-21 23:00:19", "86.217.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3582", "0", "magma", "2015-10-21 23:00:43", "79.181.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3583", "0", "magma", "2015-10-21 23:01:25", "41.103.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3584", "0", "magma", "2015-10-21 23:45:14", "186.194.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3585", "0", "admin", "2015-10-21 23:48:18", "213.142.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3586", "0", "magma", "2015-10-22 00:16:18", "73.233.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3587", "0", "magma", "2015-10-22 00:30:12", "182.55.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3588", "0", "magma", "2015-10-22 01:17:15", "5.66.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3589", "0", "magma", "2015-10-22 01:17:46", "5.54.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3590", "0", "magma", "2015-10-22 01:22:10", "141.237.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3591", "0", "magma", "2015-10-22 01:33:21", "77.127.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3592", "0", "magma", "2015-10-22 01:40:27", "79.18.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3593", "0", "magma", "2015-10-22 01:43:44", "199.192.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3594", "0", "magma", "2015-10-22 01:58:29", "92.12.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3595", "0", "magma", "2015-10-22 02:12:13", "23.116.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3596", "0", "magma", "2015-10-22 02:14:22", "31.16.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3597", "0", "magma", "2015-10-22 02:19:39", "94.231.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3598", "1", "admin8576", "2015-10-22 02:21:17", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3599", "0", "magma", "2015-10-22 03:04:11", "5.66.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3600", "0", "magma", "2015-10-22 03:07:40", "81.237.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3601", "0", "magma", "2015-10-22 03:16:41", "98.94.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3602", "0", "magma", "2015-10-22 03:22:42", "2.49.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3603", "0", "magma", "2015-10-22 03:25:15", "116.74.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3604", "1", "admin8576", "2015-10-22 04:48:35", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3605", "0", "magma", "2015-10-22 05:26:15", "103.248.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3606", "0", "magma", "2015-10-22 05:26:22", "104.35.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3607", "0", "magma", "2015-10-22 05:47:48", "94.60.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3608", "0", "magma", "2015-10-22 07:08:54", "1.22.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3609", "1", "admin8576", "2015-10-22 07:13:26", "81.89.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3610", "0", "admin", "2015-10-22 07:28:38", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3611", "0", "admin", "2015-10-22 07:38:53", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3612", "0", "magma", "2015-10-22 08:00:55", "37.107.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3613", "1", "admin8576", "2015-10-22 08:28:11", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3614", "0", "magma", "2015-10-22 09:15:15", "88.231.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3615", "0", "magma", "2015-10-22 09:33:44", "75.133.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3616", "1", "admin8576", "2015-10-22 09:42:44", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3617", "0", "magma", "2015-10-22 09:52:28", "193.232.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3618", "0", "magma", "2015-10-22 10:16:01", "169.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3619", "0", "magma", "2015-10-22 10:17:57", "5.64.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3620", "1", "admin8576", "2015-10-22 10:57:29", "178.17.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3621", "0", "magma", "2015-10-22 11:06:23", "139.194.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3622", "0", "magma", "2015-10-22 11:11:50", "84.241.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3623", "0", "magma", "2015-10-22 11:33:01", "49.145.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3624", "0", "magma", "2015-10-22 11:59:34", "46.208.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3625", "0", "magma", "2015-10-22 12:29:42", "92.46.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3626", "0", "magma", "2015-10-22 12:50:19", "61.247.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3627", "0", "magma", "2015-10-22 12:57:35", "41.223.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3628", "0", "magma", "2015-10-22 13:23:28", "111.68.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3629", "0", "magma", "2015-10-22 14:22:27", "178.175.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3630", "0", "magma", "2015-10-22 14:23:37", "86.1.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3631", "0", "magma", "2015-10-22 14:32:47", "176.60.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3632", "1", "admin8576", "2015-10-22 14:47:06", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3633", "0", "magma", "2015-10-22 15:16:39", "178.17.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3634", "0", "magma", "2015-10-22 15:18:02", "177.208.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3635", "0", "magma", "2015-10-22 15:27:49", "210.195.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3636", "1", "admin8576", "2015-10-22 15:43:15", "91.229.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3637", "0", "magma", "2015-10-22 15:45:48", "112.211.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3638", "0", "magma", "2015-10-22 15:52:02", "42.60.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3639", "0", "magma", "2015-10-22 15:58:09", "149.78.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3640", "0", "magma", "2015-10-22 16:04:04", "177.202.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3641", "0", "magma", "2015-10-22 16:04:17", "128.0.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3642", "0", "magma", "2015-10-22 16:08:22", "94.98.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3643", "0", "magma", "2015-10-22 16:13:51", "117.206.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3644", "0", "magma", "2015-10-22 16:27:52", "81.108.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3645", "0", "magma", "2015-10-22 16:27:56", "82.168.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3646", "0", "admin", "2015-10-22 16:31:23", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3647", "0", "magma", "2015-10-22 16:43:42", "83.110.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3648", "0", "magma", "2015-10-22 16:48:56", "178.221.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3649", "0", "magma", "2015-10-22 16:54:33", "46.55.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3650", "0", "admin", "2015-10-22 16:55:56", "79.136.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3651", "0", "magma", "2015-10-22 16:58:56", "197.220.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3652", "1", "admin8576", "2015-10-22 16:59:10", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3653", "0", "magma", "2015-10-22 17:25:23", "5.81.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3654", "0", "magma", "2015-10-22 17:44:32", "31.154.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3655", "0", "magma", "2015-10-22 17:48:56", "109.121.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3656", "0", "magma", "2015-10-22 17:52:25", "188.169.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3657", "0", "magma", "2015-10-22 18:14:38", "87.248.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3658", "0", "magma", "2015-10-22 18:20:18", "180.190.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3659", "0", "magma", "2015-10-22 18:27:54", "73.233.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3660", "0", "admin", "2015-10-22 18:29:14", "173.254.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3661", "0", "magma", "2015-10-22 18:34:17", "83.60.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3662", "0", "magma", "2015-10-22 19:04:22", "91.185.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3663", "0", "magma", "2015-10-22 19:18:11", "200.1.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3664", "0", "magma", "2015-10-22 19:31:31", "41.216.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3665", "1", "admin8576", "2015-10-22 19:31:39", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3666", "0", "Admin", "2015-10-22 19:49:28", "195.154.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3667", "0", "magma", "2015-10-22 19:59:11", "154.123.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3668", "0", "magma", "2015-10-22 20:09:49", "173.168.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3669", "0", "magma", "2015-10-22 20:18:50", "86.104.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3670", "0", "magma", "2015-10-22 20:28:02", "119.94.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3671", "0", "magma", "2015-10-22 20:36:12", "89.137.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3672", "0", "magma", "2015-10-22 20:43:20", "177.16.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3673", "0", "magma", "2015-10-22 20:46:04", "5.55.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3674", "1", "admin8576", "2015-10-22 20:48:13", "149.202.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3675", "0", "magma", "2015-10-22 21:06:44", "78.145.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3676", "0", "magma", "2015-10-22 21:36:03", "92.0.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3677", "0", "magma", "2015-10-22 21:56:18", "93.43.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3678", "1", "admin8576", "2015-10-22 22:04:30", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3679", "0", "magma", "2015-10-22 22:07:11", "202.69.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3680", "0", "magma", "2015-10-22 22:13:31", "119.235.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3681", "0", "magma", "2015-10-22 22:39:34", "89.69.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3682", "0", "magma", "2015-10-22 23:14:05", "189.51.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3683", "0", "magma", "2015-10-22 23:17:58", "177.125.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3684", "0", "magma", "2015-10-23 00:24:56", "41.68.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3685", "1", "admin8576", "2015-10-23 00:37:41", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3686", "0", "magma", "2015-10-23 00:38:28", "79.177.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3687", "0", "admin", "2015-10-23 01:45:27", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3688", "0", "magma", "2015-10-23 01:48:24", "93.163.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3689", "0", "magma", "2015-10-23 02:02:21", "93.108.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3690", "0", "admin", "2015-10-23 02:16:18", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3691", "0", "magma", "2015-10-23 02:30:54", "209.131.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3692", "1", "admin8576", "2015-10-23 03:10:20", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3693", "0", "magma", "2015-10-23 03:38:10", "110.77.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3694", "0", "admin", "2015-10-23 03:52:36", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3695", "0", "magma", "2015-10-23 05:35:55", "58.104.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3696", "1", "admin8576", "2015-10-23 05:42:38", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3697", "0", "magma", "2015-10-23 06:11:23", "89.137.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3698", "1", "admin8576", "2015-10-23 06:59:00", "204.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3699", "0", "magma", "2015-10-23 07:03:16", "24.96.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3700", "0", "magma", "2015-10-23 07:06:34", "36.37.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3701", "0", "magma", "2015-10-23 07:12:37", "93.177.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3702", "0", "magma", "2015-10-23 07:54:44", "103.248.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3703", "0", "magma", "2015-10-23 07:55:42", "222.124.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3704", "1", "admin8576", "2015-10-23 08:14:57", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3705", "0", "magma", "2015-10-23 09:29:11", "86.104.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3706", "1", "admin8576", "2015-10-23 09:31:06", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3707", "0", "magma", "2015-10-23 09:47:01", "222.238.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3708", "1", "admin8576", "2015-10-23 10:47:10", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3709", "0", "magma", "2015-10-23 11:32:42", "79.177.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3710", "1", "admin8576", "2015-10-23 12:03:16", "198.23.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3711", "0", "magma", "2015-10-23 12:16:41", "179.211.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3712", "0", "magma", "2015-10-23 12:18:52", "2.126.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3713", "0", "magma", "2015-10-23 13:18:51", "178.197.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3714", "1", "admin8576", "2015-10-23 13:19:18", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3715", "0", "magma", "2015-10-23 14:08:37", "27.77.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3716", "0", "magma", "2015-10-23 14:09:26", "110.93.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3717", "0", "magma", "2015-10-23 14:34:37", "188.77.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3718", "1", "admin8576", "2015-10-23 14:36:06", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3719", "0", "magma", "2015-10-23 15:13:33", "62.42.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3720", "0", "magma", "2015-10-23 15:43:05", "197.156.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3721", "1", "admin8576", "2015-10-23 15:52:20", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3722", "0", "magma", "2015-10-23 16:44:02", "79.108.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3723", "1", "admin8576", "2015-10-23 17:08:44", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3724", "0", "magma", "2015-10-23 17:20:22", "117.200.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3725", "0", "magma", "2015-10-23 17:55:47", "39.32.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3726", "0", "magma", "2015-10-23 18:01:19", "95.42.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3727", "1", "admin8576", "2015-10-23 18:25:23", "108.166.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3728", "0", "admin", "2015-10-23 18:31:17", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3729", "0", "magma", "2015-10-23 18:50:56", "115.124.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3730", "0", "magma", "2015-10-23 19:03:30", "188.126.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3731", "0", "magma", "2015-10-23 19:17:33", "154.67.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3732", "0", "magma", "2015-10-23 20:04:41", "180.191.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3733", "1", "admin8576", "2015-10-23 20:58:54", "91.109.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3734", "0", "magma", "2015-10-23 21:31:49", "183.90.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3735", "0", "magma", "2015-10-23 21:38:59", "68.123.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3736", "0", "magma", "2015-10-23 21:59:31", "185.34.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3737", "0", "magma", "2015-10-23 22:08:53", "87.252.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3738", "0", "magma", "2015-10-23 22:13:42", "181.55.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3739", "1", "admin8576", "2015-10-23 22:15:23", "95.130.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3740", "0", "magma", "2015-10-23 22:26:42", "182.187.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3741", "1", "admin8576", "2015-10-23 23:32:20", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3742", "1", "admin8576", "2015-10-24 00:48:57", "81.7.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3743", "0", "magma", "2015-10-24 02:23:46", "93.184.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3744", "0", "magma", "2015-10-24 02:53:16", "197.88.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3745", "1", "admin8576", "2015-10-24 03:21:36", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3746", "0", "magma", "2015-10-24 03:23:05", "198.72.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3747", "1", "admin8576", "2015-10-24 04:37:49", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3748", "0", "magma", "2015-10-24 04:52:18", "118.59.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3749", "0", "magma", "2015-10-24 05:01:41", "24.179.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3750", "0", "magma", "2015-10-24 05:16:13", "197.88.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3751", "0", "magma", "2015-10-24 07:01:32", "190.163.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3752", "0", "magma", "2015-10-24 07:54:28", "188.2.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3753", "0", "magma", "2015-10-24 07:59:04", "109.92.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3754", "1", "admin8576", "2015-10-24 08:26:48", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3755", "0", "magma", "2015-10-24 08:44:15", "210.195.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3756", "1", "admin8576", "2015-10-24 09:42:59", "62.212.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3757", "0", "magma", "2015-10-24 09:49:58", "210.103.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3758", "0", "admin", "2015-10-24 09:59:45", "93.179.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3759", "0", "magma", "2015-10-24 10:31:18", "115.136.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3760", "0", "admin", "2015-10-24 10:31:28", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3761", "1", "admin8576", "2015-10-24 10:59:08", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3762", "0", "magma", "2015-10-24 11:33:55", "121.170.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3763", "1", "admin8576", "2015-10-24 13:30:57", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3764", "0", "magma", "2015-10-24 14:05:10", "79.101.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3765", "0", "magma", "2015-10-24 14:21:20", "41.69.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3766", "0", "magma", "2015-10-24 14:43:44", "176.26.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3767", "0", "magma", "2015-10-24 15:31:46", "197.88.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3768", "0", "magma", "2015-10-24 15:55:11", "5.237.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3769", "0", "magma", "2015-10-24 15:59:02", "81.206.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3770", "0", "magma", "2015-10-24 16:47:56", "85.96.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3771", "1", "admin8576", "2015-10-24 17:19:54", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3772", "0", "magma", "2015-10-24 17:25:45", "79.127.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3773", "0", "magma", "2015-10-24 17:29:45", "49.147.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3774", "1", "admin8576", "2015-10-24 18:36:29", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3775", "0", "admin", "2015-10-24 19:08:59", "79.98.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3776", "0", "magma", "2015-10-24 19:19:33", "41.213.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3777", "0", "magma", "2015-10-24 19:20:14", "86.35.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3778", "0", "magma", "2015-10-24 19:20:42", "213.46.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3779", "0", "magma", "2015-10-24 19:26:47", "111.216.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3780", "0", "magma", "2015-10-24 19:32:06", "41.101.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3781", "0", "magma", "2015-10-24 19:34:15", "86.59.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3782", "0", "magma", "2015-10-24 21:41:00", "190.150.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3783", "1", "admin8576", "2015-10-24 22:26:43", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3784", "0", "magma", "2015-10-25 00:16:39", "86.7.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3785", "1", "admin8576", "2015-10-25 01:00:16", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3786", "1", "admin8576", "2015-10-25 02:16:44", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3787", "1", "admin8576", "2015-10-25 04:49:23", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3788", "0", "magma", "2015-10-25 06:30:24", "189.202.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3789", "0", "magma", "2015-10-25 06:30:33", "78.95.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3790", "0", "magma", "2015-10-25 07:16:45", "125.19.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3791", "1", "admin8576", "2015-10-25 07:22:21", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3792", "1", "admin8576", "2015-10-25 08:38:41", "5.12.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3793", "0", "magma", "2015-10-25 08:51:49", "219.240.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3794", "1", "admin8576", "2015-10-25 09:55:22", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3795", "0", "magma", "2015-10-25 10:37:01", "89.69.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3796", "0", "magma", "2015-10-25 10:50:30", "188.2.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3797", "0", "magma", "2015-10-25 11:10:25", "121.54.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3798", "1", "admin8576", "2015-10-25 11:11:30", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3799", "0", "admin", "2015-10-25 11:22:33", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3800", "0", "magma", "2015-10-25 11:43:23", "95.5.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3801", "1", "admin8576", "2015-10-25 12:27:45", "207.244.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3802", "0", "magma", "2015-10-25 13:32:25", "85.207.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3803", "0", "magma", "2015-10-25 14:21:30", "2.248.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3804", "0", "magma", "2015-10-25 14:58:12", "92.80.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3805", "1", "admin8576", "2015-10-25 15:00:08", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3806", "0", "magma", "2015-10-25 15:54:45", "124.83.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3807", "0", "magma", "2015-10-25 16:15:48", "94.253.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3808", "1", "admin8576", "2015-10-25 16:17:02", "173.254.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3809", "0", "magma", "2015-10-25 16:37:54", "93.155.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3810", "1", "admin8576", "2015-10-25 17:33:50", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3811", "0", "magma", "2015-10-25 19:16:17", "178.221.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3812", "0", "magma", "2015-10-25 19:16:45", "37.208.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3813", "0", "admin", "2015-10-25 19:39:57", "107.181.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3814", "0", "magma", "2015-10-25 20:02:06", "190.198.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3815", "1", "admin8576", "2015-10-25 20:07:46", "5.196.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3816", "0", "magma", "2015-10-25 20:12:00", "46.120.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3817", "0", "magma", "2015-10-25 20:26:51", "212.110.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3818", "0", "magma", "2015-10-25 21:21:51", "152.237.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3819", "1", "admin8576", "2015-10-25 21:24:39", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3820", "0", "magma", "2015-10-25 22:19:42", "79.180.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3821", "1", "admin8576", "2015-10-25 22:41:36", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3822", "1", "admin8576", "2015-10-25 23:58:25", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3823", "0", "magma", "2015-10-26 00:20:58", "87.69.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3824", "0", "magma", "2015-10-26 01:09:38", "109.96.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3825", "1", "admin8576", "2015-10-26 01:15:05", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3826", "1", "admin8576", "2015-10-26 02:31:30", "31.14.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3827", "0", "magma", "2015-10-26 03:17:27", "93.108.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3828", "0", "magma", "2015-10-26 03:37:05", "152.237.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3829", "0", "magma", "2015-10-26 03:48:35", "14.203.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3830", "0", "admin", "2015-10-26 03:50:26", "94.242.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3831", "0", "magma", "2015-10-26 05:32:19", "89.137.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3832", "0", "magma", "2015-10-26 06:07:14", "79.177.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3833", "1", "admin8576", "2015-10-26 06:21:43", "178.18.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3834", "1", "admin8576", "2015-10-26 07:38:12", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3835", "0", "magma", "2015-10-26 08:11:40", "219.241.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3836", "1", "admin8576", "2015-10-26 08:54:41", "158.69.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3837", "0", "magma", "2015-10-26 09:20:33", "78.97.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3838", "0", "admin", "2015-10-26 09:37:37", "93.179.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3839", "1", "admin8576", "2015-10-26 10:11:25", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3840", "0", "magma", "2015-10-26 11:37:05", "219.240.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3841", "0", "magma", "2015-10-26 11:50:41", "109.96.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3842", "1", "admin8576", "2015-10-26 12:44:04", "89.18.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3843", "0", "magma", "2015-10-26 12:49:16", "203.219.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3844", "1", "admin8576", "2015-10-26 15:17:19", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3845", "0", "magma", "2015-10-26 16:41:52", "95.86.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3846", "0", "magma", "2015-10-26 18:12:49", "83.28.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3847", "0", "magma", "2015-10-26 18:35:45", "197.228.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3848", "0", "magma", "2015-10-26 18:36:09", "92.83.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3849", "1", "admin8576", "2015-10-26 19:07:20", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3850", "0", "magma", "2015-10-26 19:37:30", "149.129.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3851", "1", "admin8576", "2015-10-26 20:24:21", "178.18.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3852", "0", "magma", "2015-10-26 21:17:52", "211.189.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3853", "1", "admin8576", "2015-10-26 21:41:10", "92.222.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3854", "0", "admin", "2015-10-26 22:28:09", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3855", "0", "magma", "2015-10-26 22:50:47", "187.240.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3856", "0", "magma", "2015-10-26 22:52:19", "190.228.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3857", "0", "magma", "2015-10-26 22:52:59", "219.92.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3858", "1", "admin8576", "2015-10-26 22:58:04", "50.247.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3859", "0", "magma", "2015-10-26 23:04:47", "115.132.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3860", "0", "magma", "2015-10-26 23:06:28", "145.255.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3861", "0", "magma", "2015-10-26 23:06:52", "2.50.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3862", "0", "magma", "2015-10-26 23:37:38", "31.61.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3863", "0", "magma", "2015-10-26 23:47:24", "80.98.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3864", "0", "magma", "2015-10-27 00:06:11", "81.84.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3865", "0", "magma", "2015-10-27 00:06:23", "97.121.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3866", "0", "magma", "2015-10-27 00:11:05", "178.236.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3867", "0", "magma", "2015-10-27 00:11:24", "187.189.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3868", "0", "magma", "2015-10-27 00:15:19", "176.189.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3869", "0", "magma", "2015-10-27 00:21:44", "82.157.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3870", "0", "magma", "2015-10-27 00:26:47", "49.150.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3871", "0", "magma", "2015-10-27 00:48:55", "178.222.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3872", "0", "magma", "2015-10-27 00:52:25", "119.157.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3873", "0", "magma", "2015-10-27 00:56:53", "115.135.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3874", "0", "magma", "2015-10-27 01:14:52", "2.29.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3875", "0", "magma", "2015-10-27 01:21:12", "187.64.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3876", "1", "admin8576", "2015-10-27 01:32:48", "82.221.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3877", "0", "magma", "2015-10-27 01:32:51", "85.203.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3878", "0", "magma", "2015-10-27 01:42:01", "155.158.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3879", "0", "magma", "2015-10-27 01:47:20", "80.48.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3880", "0", "magma", "2015-10-27 01:51:54", "8.29.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3881", "0", "magma", "2015-10-27 02:03:34", "179.219.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3882", "0", "magma", "2015-10-27 02:14:44", "138.117.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3883", "0", "magma", "2015-10-27 02:24:10", "188.254.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3884", "1", "admin8576", "2015-10-27 02:49:38", "91.213.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3885", "0", "magma", "2015-10-27 03:06:48", "94.231.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3886", "0", "magma", "2015-10-27 03:09:34", "87.210.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3887", "0", "magma", "2015-10-27 03:15:09", "93.126.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3888", "0", "magma", "2015-10-27 03:17:54", "37.210.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3889", "0", "magma", "2015-10-27 03:29:42", "174.20.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3890", "0", "magma", "2015-10-27 03:37:08", "103.225.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3891", "0", "magma", "2015-10-27 03:45:21", "60.49.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3892", "0", "magma", "2015-10-27 04:02:03", "190.240.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3893", "1", "admin8576", "2015-10-27 04:06:36", "96.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3894", "0", "magma", "2015-10-27 04:27:04", "103.21.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3895", "0", "magma", "2015-10-27 05:05:25", "190.100.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3896", "0", "magma", "2015-10-27 05:11:56", "210.186.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3897", "1", "admin8576", "2015-10-27 05:22:58", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3898", "0", "magma", "2015-10-27 05:36:03", "121.54.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3899", "0", "magma", "2015-10-27 05:48:30", "152.237.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3900", "0", "magma", "2015-10-27 05:53:30", "188.2.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3901", "0", "magma", "2015-10-27 05:54:58", "112.133.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3902", "0", "magma", "2015-10-27 05:54:59", "77.79.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3903", "0", "magma", "2015-10-27 06:19:30", "78.50.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3904", "0", "magma", "2015-10-27 06:39:16", "41.232.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3905", "1", "admin8576", "2015-10-27 06:39:59", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3906", "0", "magma", "2015-10-27 06:57:27", "122.162.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3907", "0", "magma", "2015-10-27 07:11:49", "190.18.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3908", "0", "admin", "2015-10-27 07:18:15", "45.79.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3909", "0", "magma", "2015-10-27 07:32:12", "24.4.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3910", "0", "magma", "2015-10-27 07:33:09", "49.146.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3911", "0", "magma", "2015-10-27 07:40:41", "2.96.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3912", "1", "admin8576", "2015-10-27 07:55:51", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3913", "0", "magma", "2015-10-27 08:03:35", "49.147.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3914", "0", "magma", "2015-10-27 08:16:50", "41.207.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3915", "0", "magma", "2015-10-27 08:27:18", "49.228.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3916", "0", "magma", "2015-10-27 08:29:06", "112.153.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3917", "0", "magma", "2015-10-27 08:31:08", "116.73.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3918", "0", "magma", "2015-10-27 08:31:23", "186.212.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3919", "0", "magma", "2015-10-27 08:35:42", "89.210.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3920", "0", "magma", "2015-10-27 08:56:32", "68.189.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3921", "0", "magma", "2015-10-27 09:00:10", "14.139.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3922", "1", "admin8576", "2015-10-27 09:12:06", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3923", "0", "magma", "2015-10-27 09:17:19", "141.136.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3924", "0", "magma", "2015-10-27 09:17:38", "118.163.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3925", "0", "magma", "2015-10-27 09:19:09", "197.35.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3926", "0", "magma", "2015-10-27 09:19:21", "120.155.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3927", "0", "magma", "2015-10-27 09:25:41", "78.0.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3928", "0", "magma", "2015-10-27 09:25:41", "58.65.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3929", "0", "magma", "2015-10-27 09:33:48", "69.158.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3930", "0", "magma", "2015-10-27 09:57:47", "68.189.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3931", "0", "magma", "2015-10-27 10:00:48", "187.240.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3932", "0", "magma", "2015-10-27 10:20:13", "46.162.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3933", "0", "magma", "2015-10-27 10:20:29", "117.241.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3934", "0", "magma", "2015-10-27 10:23:43", "79.114.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3935", "0", "magma", "2015-10-27 10:27:55", "58.97.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3936", "0", "magma", "2015-10-27 10:32:08", "176.241.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3937", "0", "magma", "2015-10-27 10:32:53", "77.72.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3938", "0", "magma", "2015-10-27 10:33:18", "201.37.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3939", "0", "magma", "2015-10-27 10:47:19", "184.7.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3940", "0", "magma", "2015-10-27 10:48:08", "78.211.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3941", "0", "magma", "2015-10-27 10:51:58", "41.220.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3942", "0", "magma", "2015-10-27 11:06:40", "188.241.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3943", "0", "magma", "2015-10-27 11:08:34", "141.8.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3944", "0", "magma", "2015-10-27 11:25:04", "31.52.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3945", "0", "magma", "2015-10-27 11:39:03", "106.206.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3946", "1", "admin8576", "2015-10-27 11:44:54", "91.213.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3947", "0", "magma", "2015-10-27 12:00:28", "118.136.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3948", "0", "magma", "2015-10-27 12:01:16", "188.17.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3949", "0", "magma", "2015-10-27 12:12:41", "148.0.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3950", "0", "magma", "2015-10-27 12:14:53", "95.252.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3951", "0", "magma", "2015-10-27 12:30:54", "77.98.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3952", "0", "magma", "2015-10-27 12:36:13", "122.53.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3953", "0", "magma", "2015-10-27 12:41:25", "78.144.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3954", "0", "magma", "2015-10-27 12:43:03", "116.48.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3955", "0", "magma", "2015-10-27 12:46:33", "79.113.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3956", "0", "magma", "2015-10-27 12:55:04", "213.46.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3957", "1", "admin8576", "2015-10-27 13:01:50", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3958", "0", "magma", "2015-10-27 13:13:40", "110.34.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3959", "0", "magma", "2015-10-27 13:14:32", "90.133.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3960", "0", "magma", "2015-10-27 13:16:28", "177.158.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3961", "0", "magma", "2015-10-27 13:17:37", "91.140.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3962", "0", "magma", "2015-10-27 13:31:33", "36.38.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3963", "0", "magma", "2015-10-27 13:33:40", "117.201.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3964", "0", "magma", "2015-10-27 13:34:56", "151.241.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3965", "0", "magma", "2015-10-27 13:41:16", "88.238.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3966", "0", "magma", "2015-10-27 13:49:16", "89.94.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3967", "0", "magma", "2015-10-27 14:00:10", "190.85.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3968", "0", "magma", "2015-10-27 14:03:28", "80.80.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3969", "0", "magma", "2015-10-27 14:09:01", "77.46.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3970", "1", "admin8576", "2015-10-27 14:19:08", "96.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3971", "0", "magma", "2015-10-27 14:21:19", "77.30.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3972", "0", "magma", "2015-10-27 14:34:29", "116.89.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3973", "0", "magma", "2015-10-27 14:58:40", "196.22.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3974", "0", "magma", "2015-10-27 15:02:00", "179.177.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3975", "0", "magma", "2015-10-27 15:04:20", "186.235.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3976", "0", "magma", "2015-10-27 15:11:58", "218.51.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3977", "0", "magma", "2015-10-27 15:17:31", "89.212.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3978", "0", "magma", "2015-10-27 15:22:17", "103.21.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3979", "0", "magma", "2015-10-27 15:29:14", "59.16.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3980", "0", "magma", "2015-10-27 15:32:05", "31.154.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3981", "1", "admin8576", "2015-10-27 15:36:56", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3982", "0", "magma", "2015-10-27 15:36:59", "92.109.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3983", "0", "magma", "2015-10-27 15:50:24", "1.23.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3984", "0", "magma", "2015-10-27 15:55:33", "178.222.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3985", "0", "magma", "2015-10-27 16:13:38", "101.98.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3986", "0", "magma", "2015-10-27 16:32:37", "46.176.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3987", "0", "magma", "2015-10-27 16:38:48", "182.70.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3988", "0", "magma", "2015-10-27 16:47:31", "94.190.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3989", "0", "magma", "2015-10-27 16:49:02", "167.62.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3990", "1", "admin8576", "2015-10-27 16:54:47", "61.230.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3991", "0", "magma", "2015-10-27 16:58:39", "112.207.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3992", "0", "magma", "2015-10-27 16:59:11", "186.45.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3993", "0", "magma", "2015-10-27 17:00:57", "94.0.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3994", "0", "magma", "2015-10-27 17:06:39", "82.77.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3995", "0", "magma", "2015-10-27 17:07:45", "194.28.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3996", "0", "magma", "2015-10-27 17:09:08", "212.225.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3997", "0", "admin", "2015-10-27 17:27:31", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3998", "0", "magma", "2015-10-27 17:29:14", "106.168.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("3999", "0", "magma", "2015-10-27 17:33:12", "98.195.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4000", "0", "magma", "2015-10-27 17:33:56", "116.74.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4001", "0", "magma", "2015-10-27 17:36:38", "78.150.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4002", "0", "magma", "2015-10-27 17:47:09", "200.84.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4003", "0", "magma", "2015-10-27 17:55:10", "39.53.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4004", "0", "magma", "2015-10-27 17:55:31", "49.205.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4005", "0", "magma", "2015-10-27 17:56:47", "151.15.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4006", "0", "magma", "2015-10-27 17:59:50", "176.84.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4007", "0", "magma", "2015-10-27 18:03:32", "84.235.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4008", "0", "magma", "2015-10-27 18:05:59", "185.67.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4009", "1", "admin8576", "2015-10-27 18:12:41", "91.109.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4010", "0", "magma", "2015-10-27 18:23:48", "123.201.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4011", "0", "magma", "2015-10-27 18:30:34", "86.42.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4012", "0", "magma", "2015-10-27 18:35:10", "123.200.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4013", "0", "magma", "2015-10-27 18:35:49", "186.23.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4014", "0", "magma", "2015-10-27 18:36:51", "76.76.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4015", "0", "magma", "2015-10-27 18:58:19", "151.62.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4016", "0", "magma", "2015-10-27 19:08:28", "178.223.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4017", "0", "magma", "2015-10-27 19:10:59", "88.224.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4018", "0", "magma", "2015-10-27 19:12:28", "89.94.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4019", "0", "magma", "2015-10-27 19:24:44", "80.43.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4020", "0", "magma", "2015-10-27 19:29:52", "67.184.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4021", "0", "magma", "2015-10-27 19:36:25", "92.98.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4022", "0", "magma", "2015-10-27 19:42:00", "79.119.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4023", "0", "magma", "2015-10-27 19:50:08", "94.99.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4024", "0", "magma", "2015-10-27 19:57:14", "213.164.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4025", "0", "magma", "2015-10-27 20:07:03", "81.161.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4026", "0", "magma", "2015-10-27 20:13:32", "31.176.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4027", "0", "magma", "2015-10-27 20:20:22", "85.102.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4028", "0", "magma", "2015-10-27 20:27:45", "75.133.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4029", "0", "magma", "2015-10-27 20:50:30", "79.20.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4030", "0", "magma", "2015-10-27 20:51:04", "103.49.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4031", "0", "magma", "2015-10-27 20:52:07", "85.254.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4032", "0", "magma", "2015-10-27 20:55:38", "90.219.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4033", "0", "magma", "2015-10-27 21:11:00", "79.177.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4034", "0", "magma", "2015-10-27 21:33:02", "195.214.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4035", "0", "magma", "2015-10-27 22:04:43", "188.247.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4036", "0", "magma", "2015-10-27 22:05:54", "186.241.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4037", "1", "admin8576", "2015-10-27 22:06:34", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4038", "0", "magma", "2015-10-27 22:08:45", "81.198.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4039", "0", "magma", "2015-10-27 22:22:19", "123.49.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4040", "0", "magma", "2015-10-27 22:24:59", "2.81.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4041", "0", "magma", "2015-10-27 22:25:36", "76.101.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4042", "0", "magma", "2015-10-27 22:31:32", "41.105.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4043", "0", "magma", "2015-10-27 22:32:52", "73.24.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4044", "0", "magma", "2015-10-27 22:36:13", "84.85.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4045", "0", "magma", "2015-10-27 22:46:14", "90.204.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4046", "0", "magma", "2015-10-27 22:47:57", "39.55.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4047", "0", "magma", "2015-10-27 22:50:53", "89.137.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4048", "0", "magma", "2015-10-27 22:53:39", "151.30.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4049", "1", "admin8576", "2015-10-27 22:55:38", "192.210.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4050", "1", "admin8576", "2015-10-27 22:55:38", "192.210.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4051", "1", "admin8576", "2015-10-27 22:55:38", "192.210.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4052", "0", "magma", "2015-10-27 23:01:26", "83.58.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4053", "0", "magma", "2015-10-27 23:06:02", "89.205.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4054", "0", "magma", "2015-10-27 23:07:47", "83.24.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4055", "0", "magma", "2015-10-27 23:22:50", "37.142.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4056", "1", "admin8576", "2015-10-27 23:24:41", "192.151.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4057", "0", "magma", "2015-10-27 23:26:28", "186.1.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4058", "0", "magma", "2015-10-27 23:35:13", "84.46.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4059", "0", "magma", "2015-10-27 23:43:59", "41.39.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4060", "0", "magma", "2015-10-27 23:44:03", "79.177.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4061", "0", "magma", "2015-10-28 00:13:54", "104.175.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4062", "0", "magma", "2015-10-28 00:24:35", "89.164.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4063", "0", "magma", "2015-10-28 00:26:18", "112.169.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4064", "1", "admin8576", "2015-10-28 00:42:43", "176.9.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4065", "0", "magma", "2015-10-28 01:03:25", "179.192.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4066", "0", "magma", "2015-10-28 01:04:29", "62.201.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4067", "0", "magma", "2015-10-28 01:28:34", "51.174.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4068", "0", "magma", "2015-10-28 01:32:06", "89.152.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4069", "0", "magma", "2015-10-28 01:32:22", "77.46.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4070", "0", "magma", "2015-10-28 01:34:35", "78.149.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4071", "1", "admin8576", "2015-10-28 02:00:21", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4072", "0", "magma", "2015-10-28 02:04:26", "86.122.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4073", "0", "magma", "2015-10-28 02:10:01", "89.146.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4074", "0", "magma", "2015-10-28 02:11:48", "189.33.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4075", "0", "magma", "2015-10-28 02:26:45", "217.25.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4076", "0", "magma", "2015-10-28 02:28:02", "5.29.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4077", "0", "magma", "2015-10-28 02:36:37", "79.181.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4078", "0", "magma", "2015-10-28 02:38:42", "121.54.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4079", "0", "magma", "2015-10-28 02:44:43", "202.21.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4080", "0", "magma", "2015-10-28 03:01:19", "163.152.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4081", "0", "magma", "2015-10-28 03:06:41", "137.147.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4082", "1", "admin8576", "2015-10-28 03:18:03", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4083", "0", "magma", "2015-10-28 03:19:54", "62.8.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4084", "0", "magma", "2015-10-28 03:21:58", "149.147.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4085", "0", "admin", "2015-10-28 03:23:06", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4086", "0", "magma", "2015-10-28 03:24:01", "190.101.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4087", "0", "magma", "2015-10-28 03:28:37", "123.252.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4088", "0", "magma", "2015-10-28 03:29:20", "99.60.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4089", "0", "magma", "2015-10-28 03:31:50", "95.122.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4090", "0", "magma", "2015-10-28 03:52:22", "190.219.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4091", "0", "magma", "2015-10-28 04:01:08", "201.172.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4092", "0", "magma", "2015-10-28 04:03:52", "191.54.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4093", "0", "magma", "2015-10-28 04:20:52", "216.240.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4094", "0", "magma", "2015-10-28 04:24:57", "109.76.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4095", "1", "admin8576", "2015-10-28 04:36:26", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4096", "0", "magma", "2015-10-28 04:57:53", "220.247.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4097", "0", "magma", "2015-10-28 04:59:37", "118.189.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4098", "0", "magma", "2015-10-28 05:01:09", "186.204.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4099", "0", "magma", "2015-10-28 05:29:06", "31.168.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4100", "0", "magma", "2015-10-28 05:37:35", "115.186.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4101", "0", "magma", "2015-10-28 05:54:07", "216.240.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4102", "1", "admin8576", "2015-10-28 05:54:52", "62.210.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4103", "0", "magma", "2015-10-28 05:59:43", "112.169.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4104", "0", "magma", "2015-10-28 06:11:28", "190.4.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4105", "0", "magma", "2015-10-28 06:21:56", "105.229.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4106", "0", "magma", "2015-10-28 06:33:20", "103.224.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4107", "0", "magma", "2015-10-28 06:37:00", "219.248.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4108", "0", "magma", "2015-10-28 06:41:28", "163.47.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4109", "0", "magma", "2015-10-28 06:52:48", "175.143.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4110", "0", "magma", "2015-10-28 06:55:41", "197.32.16.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4111", "0", "magma", "2015-10-28 06:57:05", "112.187.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4112", "0", "magma", "2015-10-28 07:02:17", "173.245.217.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4113", "1", "admin8576", "2015-10-28 07:13:15", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4114", "0", "magma", "2015-10-28 07:13:22", "119.192.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4115", "1", "admin8576", "2015-10-28 07:23:00", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4116", "0", "magma", "2015-10-28 07:25:00", "211.178.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4117", "0", "magma", "2015-10-28 07:29:47", "103.231.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4118", "0", "magma", "2015-10-28 07:49:08", "119.154.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4119", "1", "admin8576", "2015-10-28 07:54:00", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4120", "0", "magma", "2015-10-28 07:54:07", "49.149.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4121", "0", "magma", "2015-10-28 07:56:45", "189.63.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4122", "0", "magma", "2015-10-28 08:06:04", "61.17.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4123", "1", "admin8576", "2015-10-28 08:23:35", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4124", "0", "magma", "2015-10-28 08:24:36", "82.120.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4125", "1", "admin8576", "2015-10-28 08:31:21", "158.69.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4126", "0", "magma", "2015-10-28 08:43:42", "186.125.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4127", "0", "magma", "2015-10-28 08:49:58", "101.98.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4128", "1", "admin8576", "2015-10-28 08:53:11", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4129", "0", "magma", "2015-10-28 09:21:32", "61.17.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4130", "1", "admin8576", "2015-10-28 09:23:54", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4131", "0", "magma", "2015-10-28 09:31:01", "119.192.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4132", "0", "magma", "2015-10-28 09:43:07", "197.220.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4133", "0", "magma", "2015-10-28 09:46:02", "217.16.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4134", "0", "magma", "2015-10-28 09:47:38", "70.171.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4135", "1", "admin8576", "2015-10-28 09:49:26", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4136", "1", "admin8576", "2015-10-28 09:54:50", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4137", "1", "admin8576", "2015-10-28 10:25:08", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4138", "0", "magma", "2015-10-28 10:54:37", "178.223.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4139", "1", "admin8576", "2015-10-28 10:54:43", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4140", "0", "magma", "2015-10-28 10:56:33", "49.205.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4141", "0", "magma", "2015-10-28 11:00:33", "77.46.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4142", "1", "admin8576", "2015-10-28 11:07:25", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4143", "0", "magma", "2015-10-28 11:07:36", "84.244.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4144", "1", "admin8576", "2015-10-28 11:24:50", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4145", "0", "magma", "2015-10-28 11:26:49", "93.142.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4146", "0", "magma", "2015-10-28 11:32:38", "154.73.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4147", "0", "magma", "2015-10-28 11:45:05", "95.218.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4148", "1", "admin8576", "2015-10-28 11:54:41", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4149", "0", "magma", "2015-10-28 12:10:12", "85.139.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4150", "0", "magma", "2015-10-28 12:18:36", "78.131.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4151", "1", "admin8576", "2015-10-28 12:24:30", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4152", "1", "admin8576", "2015-10-28 12:25:37", "85.245.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4153", "0", "magma", "2015-10-28 12:47:02", "202.74.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4154", "1", "admin8576", "2015-10-28 12:54:27", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4155", "0", "magma", "2015-10-28 13:19:50", "2.26.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4156", "0", "admin", "2015-10-28 13:21:29", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4157", "1", "admin8576", "2015-10-28 13:24:32", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4158", "0", "magma", "2015-10-28 13:27:59", "121.54.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4159", "0", "magma", "2015-10-28 13:30:18", "84.109.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4160", "1", "admin8576", "2015-10-28 13:44:10", "85.16.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4161", "1", "admin8576", "2015-10-28 13:54:32", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4162", "0", "magma", "2015-10-28 14:11:30", "178.206.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4163", "1", "admin8576", "2015-10-28 14:24:18", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4164", "0", "admin", "2015-10-28 14:40:43", "93.179.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4165", "0", "magma", "2015-10-28 14:46:46", "93.137.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4166", "0", "magma", "2015-10-28 14:48:37", "39.33.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4167", "1", "admin8576", "2015-10-28 14:55:34", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4168", "1", "admin8576", "2015-10-28 15:02:29", "207.244.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4169", "0", "magma", "2015-10-28 15:11:08", "220.132.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4170", "0", "magma", "2015-10-28 15:25:14", "117.253.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4171", "1", "admin8576", "2015-10-28 15:27:16", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4172", "0", "magma", "2015-10-28 15:31:25", "46.217.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4173", "0", "magma", "2015-10-28 15:36:19", "175.157.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4174", "0", "magma", "2015-10-28 15:37:02", "92.124.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4175", "0", "magma", "2015-10-28 15:39:11", "41.108.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4176", "0", "magma", "2015-10-28 15:39:56", "37.193.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4177", "0", "magma", "2015-10-28 15:52:31", "115.66.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4178", "0", "magma", "2015-10-28 15:52:47", "103.41.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4179", "1", "admin8576", "2015-10-28 15:57:52", "188.227.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4180", "0", "magma", "2015-10-28 15:59:24", "31.146.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4181", "1", "admin8576", "2015-10-28 16:21:00", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4182", "0", "magma", "2015-10-28 16:35:12", "82.211.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4183", "0", "magma", "2015-10-28 16:54:11", "93.137.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4184", "0", "magma", "2015-10-28 17:10:38", "37.26.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4185", "0", "magma", "2015-10-28 17:14:35", "217.164.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4186", "0", "magma", "2015-10-28 17:19:29", "77.46.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4187", "1", "admin8576", "2015-10-28 17:39:55", "185.17.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4188", "0", "magma", "2015-10-28 17:53:05", "139.194.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4189", "0", "magma", "2015-10-28 17:53:47", "212.73.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4190", "0", "magma", "2015-10-28 17:55:07", "202.177.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4191", "0", "magma", "2015-10-28 18:04:02", "197.15.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4192", "0", "magma", "2015-10-28 18:11:23", "199.192.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4193", "0", "magma", "2015-10-28 18:14:16", "124.82.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4194", "0", "magma", "2015-10-28 18:35:35", "197.251.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4195", "0", "magma", "2015-10-28 18:55:11", "115.186.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4196", "1", "admin8576", "2015-10-28 18:58:36", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4197", "0", "magma", "2015-10-28 19:01:53", "188.24.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4198", "0", "magma", "2015-10-28 19:03:21", "79.178.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4199", "0", "magma", "2015-10-28 19:31:08", "200.108.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4200", "0", "magma", "2015-10-28 19:57:58", "178.222.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4201", "0", "magma", "2015-10-28 20:13:35", "119.94.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4202", "1", "admin8576", "2015-10-28 20:18:07", "45.63.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4203", "0", "magma", "2015-10-28 20:44:45", "185.37.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4204", "0", "magma", "2015-10-28 20:49:02", "103.243.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4205", "0", "magma", "2015-10-28 21:13:26", "141.138.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4206", "0", "magma", "2015-10-28 21:33:48", "197.38.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4207", "1", "admin8576", "2015-10-28 21:36:59", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4208", "0", "magma", "2015-10-28 21:41:13", "101.188.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4209", "0", "magma", "2015-10-28 21:49:44", "77.46.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4210", "0", "magma", "2015-10-28 21:54:19", "177.103.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4211", "0", "magma", "2015-10-28 22:09:14", "89.201.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4212", "0", "magma", "2015-10-28 22:39:18", "88.11.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4213", "0", "magma", "2015-10-28 22:39:58", "85.203.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4214", "0", "magma", "2015-10-28 22:45:16", "50.65.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4215", "0", "magma", "2015-10-28 22:48:32", "85.207.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4216", "1", "admin8576", "2015-10-28 22:55:59", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4217", "0", "magma", "2015-10-28 22:59:13", "46.53.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4218", "0", "magma", "2015-10-28 23:09:16", "121.170.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4219", "0", "admin", "2015-10-28 23:15:57", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4220", "0", "magma", "2015-10-28 23:22:29", "93.113.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4221", "0", "magma", "2015-10-28 23:44:04", "37.231.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4222", "1", "admin8576", "2015-10-29 00:15:15", "82.221.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4223", "0", "magma", "2015-10-29 00:33:18", "212.252.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4224", "0", "magma", "2015-10-29 00:40:14", "93.142.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4225", "0", "magma", "2015-10-29 00:54:23", "79.177.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4226", "0", "magma", "2015-10-29 00:58:05", "79.178.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4227", "0", "magma", "2015-10-29 01:08:11", "79.115.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4228", "0", "magma", "2015-10-29 01:15:09", "79.115.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4229", "1", "admin8576", "2015-10-29 01:34:14", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4230", "0", "magma", "2015-10-29 01:35:33", "4.28.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4231", "0", "magma", "2015-10-29 02:06:37", "112.210.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4232", "0", "magma", "2015-10-29 02:31:21", "187.181.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4233", "0", "magma", "2015-10-29 02:39:17", "36.80.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4234", "0", "magma", "2015-10-29 02:42:20", "94.190.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4235", "0", "magma", "2015-10-29 02:43:41", "217.55.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4236", "0", "magma", "2015-10-29 02:45:32", "90.170.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4237", "1", "admin8576", "2015-10-29 02:53:56", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4238", "0", "magma", "2015-10-29 03:04:52", "218.110.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4239", "0", "magma", "2015-10-29 03:24:32", "49.205.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4240", "0", "magma", "2015-10-29 03:35:46", "195.202.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4241", "0", "magma", "2015-10-29 03:41:01", "95.219.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4242", "1", "admin8576", "2015-10-29 04:12:39", "5.79.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4243", "0", "magma", "2015-10-29 04:31:04", "94.76.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4244", "0", "magma", "2015-10-29 04:41:59", "77.58.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4245", "0", "magma", "2015-10-29 05:15:32", "78.131.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4246", "1", "admin8576", "2015-10-29 05:31:29", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4247", "0", "magma", "2015-10-29 05:58:03", "24.202.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4248", "1", "admin8576", "2015-10-29 06:50:26", "149.91.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4249", "0", "magma", "2015-10-29 07:00:55", "73.3.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4250", "0", "magma", "2015-10-29 07:03:25", "196.0.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4251", "0", "magma", "2015-10-29 07:11:37", "190.153.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4252", "0", "magma", "2015-10-29 07:21:38", "86.166.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4253", "0", "magma", "2015-10-29 07:34:08", "95.180.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4254", "0", "magma", "2015-10-29 07:55:11", "123.252.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4255", "1", "admin8576", "2015-10-29 08:08:52", "179.43.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4256", "0", "admin", "2015-10-29 08:30:23", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4257", "0", "magma", "2015-10-29 08:41:28", "104.59.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4258", "0", "magma", "2015-10-29 08:43:32", "49.147.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4259", "0", "magma", "2015-10-29 08:46:14", "175.119.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4260", "0", "magma", "2015-10-29 09:24:47", "46.108.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4261", "1", "admin8576", "2015-10-29 09:27:25", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4262", "0", "magma", "2015-10-29 10:05:16", "86.98.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4263", "0", "magma", "2015-10-29 10:26:15", "180.67.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4264", "0", "magma", "2015-10-29 10:28:32", "84.241.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4265", "0", "magma", "2015-10-29 10:33:52", "121.33.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4266", "1", "admin8576", "2015-10-29 10:45:30", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4267", "0", "magma", "2015-10-29 10:47:07", "117.194.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4268", "0", "magma", "2015-10-29 11:08:30", "42.115.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4269", "0", "magma", "2015-10-29 11:12:50", "103.224.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4270", "0", "magma", "2015-10-29 11:47:31", "176.42.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4271", "1", "admin8576", "2015-10-29 12:03:53", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4272", "1", "admin8576", "2015-10-29 13:22:19", "185.34.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4273", "0", "magma", "2015-10-29 13:39:08", "122.176.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4274", "0", "magma", "2015-10-29 13:50:23", "92.53.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4275", "0", "magma", "2015-10-29 13:50:42", "108.209.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4276", "0", "magma", "2015-10-29 14:07:08", "197.14.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4277", "1", "admin8576", "2015-10-29 14:41:58", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4278", "0", "magma", "2015-10-29 14:46:13", "41.189.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4279", "0", "magma", "2015-10-29 14:54:09", "213.199.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4280", "0", "magma", "2015-10-29 14:59:14", "49.144.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4281", "0", "magma", "2015-10-29 15:10:23", "176.73.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4282", "0", "magma", "2015-10-29 15:17:04", "201.76.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4283", "0", "magma", "2015-10-29 16:01:49", "197.14.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4284", "1", "admin8576", "2015-10-29 16:02:34", "65.183.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4285", "0", "magma", "2015-10-29 16:08:55", "79.180.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4286", "0", "magma", "2015-10-29 16:09:56", "163.47.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4287", "0", "magma", "2015-10-29 16:29:04", "5.12.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4288", "0", "magma", "2015-10-29 16:55:51", "121.179.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4289", "1", "admin8576", "2015-10-29 17:21:57", "204.124.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4290", "0", "magma", "2015-10-29 17:32:05", "191.34.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4291", "0", "magma", "2015-10-29 17:33:52", "122.168.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4292", "0", "magma", "2015-10-29 17:55:38", "210.89.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4293", "0", "admin", "2015-10-29 18:10:28", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4294", "0", "magma", "2015-10-29 18:26:14", "223.30.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4295", "1", "admin8576", "2015-10-29 18:41:37", "46.165.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4296", "0", "magma", "2015-10-29 18:47:17", "128.0.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4297", "0", "magma", "2015-10-29 18:53:46", "105.107.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4298", "1", "admin8576", "2015-10-29 20:01:09", "217.115.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4299", "0", "magma", "2015-10-29 20:04:43", "92.232.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4300", "0", "magma", "2015-10-29 20:21:38", "86.50.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4301", "0", "magma", "2015-10-29 20:42:59", "103.44.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4302", "1", "admin8576", "2015-10-29 21:20:41", "5.135.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4303", "0", "magma", "2015-10-29 21:33:10", "41.79.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4304", "1", "admin8576", "2015-10-29 22:40:30", "179.43.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4305", "0", "magma", "2015-10-29 23:47:26", "213.119.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4306", "0", "magma", "2015-10-30 00:24:29", "5.14.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4307", "0", "magma", "2015-10-30 00:27:21", "37.193.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4308", "1", "admin8576", "2015-10-30 01:20:30", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4309", "0", "magma", "2015-10-30 01:24:30", "178.175.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4310", "0", "magma", "2015-10-30 02:36:11", "82.178.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4311", "1", "admin8576", "2015-10-30 02:40:55", "212.47.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4312", "0", "magma", "2015-10-30 02:42:50", "157.157.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4313", "0", "magma", "2015-10-30 02:45:11", "50.65.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4314", "0", "magma", "2015-10-30 02:52:56", "70.26.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4315", "0", "magma", "2015-10-30 03:20:30", "59.133.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4316", "0", "admin", "2015-10-30 03:46:13", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4317", "0", "magma", "2015-10-30 04:05:22", "189.176.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4318", "0", "magma", "2015-10-30 04:12:13", "143.176.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4319", "0", "magma", "2015-10-30 04:45:25", "94.98.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4320", "1", "admin8576", "2015-10-30 05:20:04", "79.172.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4321", "0", "magma", "2015-10-30 05:24:34", "109.175.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4322", "0", "magma", "2015-10-30 05:48:01", "220.80.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4323", "0", "magma", "2015-10-30 05:55:07", "86.6.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4324", "0", "magma", "2015-10-30 05:58:53", "94.98.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4325", "0", "magma", "2015-10-30 06:23:41", "211.220.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4326", "1", "admin8576", "2015-10-30 06:39:15", "5.199.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4327", "1", "admin8576", "2015-10-30 07:57:32", "65.183.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4328", "0", "magma", "2015-10-30 08:01:15", "188.120.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4329", "1", "admin8576", "2015-10-30 09:16:09", "5.79.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4330", "0", "magma", "2015-10-30 09:30:55", "103.21.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4331", "0", "magma", "2015-10-30 09:31:41", "37.208.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4332", "0", "magma", "2015-10-30 09:35:24", "10.174.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4333", "0", "magma", "2015-10-30 09:48:16", "77.31.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4334", "0", "magma", "2015-10-30 10:09:08", "217.165.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4335", "0", "magma", "2015-10-30 10:26:40", "176.63.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4336", "1", "admin8576", "2015-10-30 10:34:31", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4337", "1", "admin8576", "2015-10-30 11:52:56", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4338", "0", "magma", "2015-10-30 12:09:50", "91.185.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4339", "0", "magma", "2015-10-30 12:10:13", "188.254.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4340", "0", "magma", "2015-10-30 12:31:08", "49.204.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4341", "0", "admin", "2015-10-30 12:58:18", "198.27.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4342", "1", "admin8576", "2015-10-30 13:11:21", "79.172.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4343", "0", "magma", "2015-10-30 13:49:14", "79.115.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4344", "0", "magma", "2015-10-30 14:14:13", "188.254.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4345", "0", "magma", "2015-10-30 14:15:03", "61.254.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4346", "1", "admin8576", "2015-10-30 14:29:39", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4347", "0", "magma", "2015-10-30 14:57:07", "178.220.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4348", "0", "magma", "2015-10-30 15:02:10", "212.233.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4349", "0", "magma", "2015-10-30 15:14:17", "89.165.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4350", "1", "admin8576", "2015-10-30 15:48:07", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4351", "1", "admin8576", "2015-10-30 17:07:03", "31.220.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4352", "0", "magma", "2015-10-30 17:15:16", "116.74.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4353", "0", "magma", "2015-10-30 17:26:11", "217.103.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4354", "0", "magma", "2015-10-30 17:50:23", "86.100.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4355", "0", "magma", "2015-10-30 17:58:04", "178.223.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4356", "1", "admin8576", "2015-10-30 18:26:18", "65.183.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4357", "0", "magma", "2015-10-30 18:55:59", "202.142.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4358", "0", "magma", "2015-10-30 19:09:19", "190.7.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4359", "1", "admin8576", "2015-10-30 19:45:33", "50.7.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4360", "0", "magma", "2015-10-30 19:59:32", "182.190.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4361", "1", "admin8576", "2015-10-30 21:04:52", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4362", "0", "magma", "2015-10-30 21:14:17", "78.141.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4363", "0", "magma", "2015-10-30 21:35:42", "5.107.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4364", "0", "magma", "2015-10-30 21:47:17", "79.100.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4365", "0", "magma", "2015-10-30 22:08:58", "77.68.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4366", "0", "admin", "2015-10-30 22:12:40", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4367", "0", "magma", "2015-10-30 22:19:26", "93.87.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4368", "1", "admin8576", "2015-10-30 22:24:19", "51.175.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4369", "0", "magma", "2015-10-30 22:37:27", "181.31.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4370", "0", "magma", "2015-10-30 22:48:39", "179.189.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4371", "0", "magma", "2015-10-30 23:41:59", "93.87.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4372", "1", "admin8576", "2015-10-30 23:44:01", "95.211.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4373", "0", "magma", "2015-10-30 23:55:05", "91.185.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4374", "0", "magma", "2015-10-31 00:01:39", "78.181.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4375", "0", "magma", "2015-10-31 00:03:00", "95.102.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4376", "1", "admin8576", "2015-10-31 01:03:43", "62.210.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4377", "0", "magma", "2015-10-31 01:13:16", "93.169.111.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4378", "0", "magma", "2015-10-31 01:56:16", "92.96.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4379", "1", "admin8576", "2015-10-31 02:23:23", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4380", "0", "magma", "2015-10-31 02:53:20", "112.198.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4381", "0", "magma", "2015-10-31 03:01:11", "114.108.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4382", "0", "magma", "2015-10-31 03:17:43", "175.156.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4383", "1", "admin8576", "2015-10-31 03:42:49", "83.69.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4384", "0", "magma", "2015-10-31 03:53:41", "187.20.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4385", "0", "magma", "2015-10-31 03:58:00", "79.177.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4386", "0", "magma", "2015-10-31 04:03:24", "93.105.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4387", "0", "magma", "2015-10-31 05:27:19", "178.152.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4388", "1", "admin8576", "2015-10-31 06:22:21", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4389", "0", "magma", "2015-10-31 06:41:26", "122.54.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4390", "0", "admin", "2015-10-31 07:14:32", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4391", "0", "magma", "2015-10-31 07:27:24", "14.192.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4392", "1", "admin8576", "2015-10-31 07:41:35", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4393", "0", "magma", "2015-10-31 08:01:07", "103.8.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4394", "1", "admin8576", "2015-10-31 09:00:18", "81.169.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4395", "1", "admin8576", "2015-10-31 10:19:09", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4396", "0", "magma", "2015-10-31 10:55:07", "24.50.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4397", "1", "admin8576", "2015-10-31 11:38:04", "204.17.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4398", "0", "magma", "2015-10-31 12:00:27", "203.218.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4399", "0", "magma", "2015-10-31 12:44:11", "185.97.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4400", "1", "admin8576", "2015-10-31 12:56:57", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4401", "0", "magma", "2015-10-31 13:50:08", "122.167.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4402", "0", "magma", "2015-10-31 14:11:51", "41.39.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4403", "1", "admin8576", "2015-10-31 14:15:52", "217.12.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4404", "1", "admin8576", "2015-10-31 15:34:53", "185.104.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4405", "0", "magma", "2015-10-31 15:42:15", "188.26.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4406", "0", "magma", "2015-10-31 15:42:56", "79.101.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4407", "0", "magma", "2015-10-31 15:47:45", "178.223.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4408", "0", "magma", "2015-10-31 16:03:32", "41.143.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4409", "0", "admin", "2015-10-31 16:25:27", "176.10.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4410", "0", "magma", "2015-10-31 16:46:16", "5.15.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4411", "1", "admin8576", "2015-10-31 16:54:10", "85.226.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4412", "0", "magma", "2015-10-31 17:27:10", "49.150.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4413", "1", "admin8576", "2015-10-31 18:13:42", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4414", "0", "magma", "2015-10-31 18:18:15", "37.104.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4415", "0", "magma", "2015-10-31 18:51:12", "93.142.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4416", "0", "magma", "2015-10-31 18:52:35", "71.248.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4417", "1", "admin8576", "2015-10-31 19:33:15", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4418", "0", "magma", "2015-10-31 19:41:12", "197.245.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4419", "0", "magma", "2015-10-31 20:08:15", "201.176.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4420", "0", "magma", "2015-10-31 20:10:14", "38.114.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4421", "0", "magma", "2015-10-31 20:15:15", "191.115.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4422", "0", "magma", "2015-10-31 20:27:28", "182.48.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4423", "1", "admin8576", "2015-10-31 20:52:48", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4424", "0", "magma", "2015-10-31 20:55:29", "209.131.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4425", "0", "magma", "2015-10-31 21:50:38", "178.149.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4426", "0", "magma", "2015-10-31 22:03:31", "85.243.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4427", "1", "admin8576", "2015-10-31 22:12:23", "94.242.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4428", "0", "magma", "2015-10-31 23:27:28", "84.108.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4429", "1", "admin8576", "2015-10-31 23:31:45", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4430", "0", "magma", "2015-10-31 23:52:14", "178.223.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4431", "1", "admin8576", "2015-11-01 00:51:41", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4432", "0", "magma", "2015-11-01 01:09:42", "81.206.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4433", "0", "admin", "2015-11-01 01:27:36", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4434", "0", "magma", "2015-11-01 02:09:18", "95.180.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4435", "1", "admin8576", "2015-11-01 02:11:21", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4436", "0", "magma", "2015-11-01 02:51:15", "189.114.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4437", "0", "magma", "2015-11-01 02:51:53", "182.224.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4438", "0", "magma", "2015-11-01 02:54:58", "41.96.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4439", "0", "magma", "2015-11-01 02:58:21", "200.85.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4440", "0", "magma", "2015-11-01 03:11:03", "176.219.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4441", "1", "admin8576", "2015-11-01 03:30:47", "94.242.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4442", "0", "magma", "2015-11-01 04:38:31", "209.131.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4443", "0", "magma", "2015-11-01 04:44:05", "105.155.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4444", "1", "admin8576", "2015-11-01 04:50:18", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4445", "0", "magma", "2015-11-01 05:18:30", "197.254.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4446", "0", "magma", "2015-11-01 05:40:38", "167.62.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4447", "0", "magma", "2015-11-01 06:26:30", "112.134.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4448", "0", "magma", "2015-11-01 06:29:59", "49.149.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4449", "1", "admin8576", "2015-11-01 07:29:03", "81.7.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4450", "0", "magma", "2015-11-01 08:07:57", "178.220.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4451", "0", "magma", "2015-11-01 08:21:06", "39.48.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4452", "1", "admin8576", "2015-11-01 08:48:43", "52.0.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4453", "0", "magma", "2015-11-01 09:53:08", "168.167.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4454", "0", "admin", "2015-11-01 10:03:39", "142.4.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4455", "1", "admin8576", "2015-11-01 10:08:47", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4456", "0", "magma", "2015-11-01 11:26:20", "78.61.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4457", "1", "admin8576", "2015-11-01 11:27:55", "5.196.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4458", "0", "magma", "2015-11-01 11:29:01", "5.197.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4459", "1", "admin8576", "2015-11-01 12:47:05", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4460", "0", "magma", "2015-11-01 13:13:42", "109.93.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4461", "0", "magma", "2015-11-01 13:16:36", "81.84.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4462", "0", "magma", "2015-11-01 13:18:26", "31.11.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4463", "0", "magma", "2015-11-01 13:23:05", "189.169.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4464", "0", "magma", "2015-11-01 13:33:54", "41.227.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4465", "0", "magma", "2015-11-01 13:39:49", "188.187.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4466", "0", "magma", "2015-11-01 13:43:44", "5.14.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4467", "0", "magma", "2015-11-01 13:57:58", "125.212.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4468", "0", "magma", "2015-11-01 14:00:26", "49.144.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4469", "0", "magma", "2015-11-01 14:00:35", "82.100.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4470", "0", "magma", "2015-11-01 14:03:52", "213.149.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4471", "1", "admin8576", "2015-11-01 14:06:15", "213.167.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4472", "0", "magma", "2015-11-01 14:07:51", "113.203.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4473", "0", "magma", "2015-11-01 14:11:52", "222.109.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4474", "0", "magma", "2015-11-01 14:48:36", "179.219.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4475", "0", "magma", "2015-11-01 14:48:52", "60.49.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4476", "0", "magma", "2015-11-01 14:55:15", "87.117.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4477", "0", "magma", "2015-11-01 14:58:25", "24.10.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4478", "0", "magma", "2015-11-01 14:59:48", "201.239.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4479", "0", "magma", "2015-11-01 15:04:28", "79.113.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4480", "0", "magma", "2015-11-01 15:19:31", "72.252.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4481", "0", "magma", "2015-11-01 15:20:54", "59.94.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4482", "1", "admin8576", "2015-11-01 15:25:34", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4483", "0", "magma", "2015-11-01 15:25:46", "110.159.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4484", "0", "magma", "2015-11-01 15:43:34", "94.21.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4485", "0", "magma", "2015-11-01 15:50:38", "176.193.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4486", "0", "magma", "2015-11-01 16:07:30", "46.109.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4487", "0", "magma", "2015-11-01 16:11:40", "110.55.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4488", "0", "magma", "2015-11-01 16:12:45", "103.49.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4489", "0", "magma", "2015-11-01 16:17:07", "181.226.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4490", "0", "magma", "2015-11-01 16:30:29", "78.60.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4491", "0", "magma", "2015-11-01 16:32:03", "212.200.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4492", "0", "magma", "2015-11-01 16:37:20", "45.115.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4493", "0", "magma", "2015-11-01 16:37:54", "93.32.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4494", "1", "admin8576", "2015-11-01 16:45:19", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4495", "0", "magma", "2015-11-01 16:47:53", "41.96.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4496", "0", "magma", "2015-11-01 16:48:49", "188.186.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4497", "0", "magma", "2015-11-01 16:49:15", "108.23.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4498", "0", "magma", "2015-11-01 16:50:47", "80.50.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4499", "0", "magma", "2015-11-01 16:50:54", "103.243.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4500", "0", "magma", "2015-11-01 16:51:16", "180.93.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4501", "0", "magma", "2015-11-01 16:56:04", "109.128.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4502", "0", "magma", "2015-11-01 16:59:38", "94.21.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4503", "0", "magma", "2015-11-01 17:09:50", "86.104.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4504", "0", "magma", "2015-11-01 17:13:17", "103.21.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4505", "0", "magma", "2015-11-01 17:29:35", "112.119.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4506", "0", "magma", "2015-11-01 17:32:38", "59.152.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4507", "0", "magma", "2015-11-01 17:33:47", "37.157.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4508", "0", "magma", "2015-11-01 17:42:40", "103.23.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4509", "1", "admin8576", "2015-11-01 18:05:10", "198.27.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4510", "0", "magma", "2015-11-01 18:11:17", "109.163.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4511", "0", "magma", "2015-11-01 18:15:14", "92.29.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4512", "0", "magma", "2015-11-01 18:19:52", "93.184.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4513", "0", "magma", "2015-11-01 18:29:07", "122.54.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4514", "0", "magma", "2015-11-01 18:47:31", "1.0.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4515", "0", "magma", "2015-11-01 18:49:02", "86.124.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4516", "0", "magma", "2015-11-01 18:54:01", "49.207.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4517", "0", "admin", "2015-11-01 18:55:19", "81.7.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4518", "0", "magma", "2015-11-01 19:46:03", "189.219.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4519", "0", "magma", "2015-11-01 19:48:35", "179.53.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4520", "0", "magma", "2015-11-01 19:52:08", "78.10.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4521", "0", "magma", "2015-11-01 19:54:06", "80.72.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4522", "0", "magma", "2015-11-01 20:05:10", "111.68.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4523", "0", "magma", "2015-11-01 20:05:32", "178.221.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4524", "0", "magma", "2015-11-01 20:12:51", "188.71.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4525", "0", "magma", "2015-11-01 20:13:22", "81.190.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4526", "0", "magma", "2015-11-01 20:27:14", "31.11.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4527", "0", "magma", "2015-11-01 20:34:08", "182.178.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4528", "0", "magma", "2015-11-01 20:42:11", "190.92.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4529", "1", "admin8576", "2015-11-01 20:44:49", "94.23.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4530", "0", "magma", "2015-11-01 20:45:49", "1.22.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4531", "0", "magma", "2015-11-01 20:46:42", "131.191.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4532", "0", "magma", "2015-11-01 20:50:47", "181.93.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4533", "0", "magma", "2015-11-01 20:53:24", "197.163.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4534", "0", "magma", "2015-11-01 20:56:19", "196.206.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4535", "0", "magma", "2015-11-01 20:57:35", "191.248.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4536", "0", "magma", "2015-11-01 20:59:10", "186.218.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4537", "0", "magma", "2015-11-01 21:15:18", "89.78.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4538", "0", "magma", "2015-11-01 21:19:43", "81.206.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4539", "0", "magma", "2015-11-01 21:38:34", "188.2.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4540", "0", "magma", "2015-11-01 21:44:33", "37.182.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4541", "0", "magma", "2015-11-01 21:47:51", "143.176.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4542", "1", "admin8576", "2015-11-01 22:04:37", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4543", "0", "magma", "2015-11-01 22:09:09", "87.0.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4544", "0", "magma", "2015-11-01 22:11:10", "108.39.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4545", "0", "magma", "2015-11-01 22:12:21", "77.147.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4546", "0", "magma", "2015-11-01 22:13:10", "203.87.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4547", "0", "magma", "2015-11-01 22:23:51", "77.46.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4548", "0", "magma", "2015-11-01 22:37:00", "157.157.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4549", "0", "magma", "2015-11-01 22:58:24", "92.80.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4550", "0", "magma", "2015-11-01 23:00:18", "178.223.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4551", "0", "magma", "2015-11-01 23:05:17", "70.66.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4552", "0", "magma", "2015-11-01 23:06:16", "37.11.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4553", "0", "magma", "2015-11-01 23:15:23", "89.211.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4554", "0", "magma", "2015-11-01 23:17:24", "46.99.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4555", "1", "admin8576", "2015-11-01 23:24:13", "85.16.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4556", "0", "magma", "2015-11-01 23:24:41", "89.211.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4557", "0", "magma", "2015-11-01 23:34:48", "37.182.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4558", "0", "magma", "2015-11-01 23:40:14", "179.189.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4559", "0", "magma", "2015-11-01 23:43:21", "84.27.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4560", "0", "magma", "2015-11-01 23:49:23", "14.136.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4561", "0", "magma", "2015-11-01 23:59:23", "43.224.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4562", "0", "magma", "2015-11-02 00:02:42", "109.66.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4563", "0", "magma", "2015-11-02 00:06:45", "188.2.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4564", "0", "magma", "2015-11-02 00:16:14", "46.236.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4565", "0", "magma", "2015-11-02 00:19:25", "109.67.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4566", "0", "magma", "2015-11-02 00:28:54", "89.172.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4567", "0", "magma", "2015-11-02 00:30:07", "218.214.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4568", "0", "magma", "2015-11-02 00:33:23", "41.182.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4569", "0", "magma", "2015-11-02 00:40:42", "39.45.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4570", "1", "admin8576", "2015-11-02 00:43:50", "198.100.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4571", "0", "magma", "2015-11-02 01:03:42", "186.45.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4572", "0", "magma", "2015-11-02 01:29:42", "117.244.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4573", "0", "magma", "2015-11-02 01:38:16", "89.115.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4574", "1", "admin8576", "2015-11-02 02:03:28", "37.48.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4575", "0", "magma", "2015-11-02 02:24:42", "97.92.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4576", "0", "magma", "2015-11-02 02:31:11", "181.198.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4577", "0", "magma", "2015-11-02 02:33:22", "91.105.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4578", "0", "magma", "2015-11-02 02:40:54", "143.176.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4579", "0", "magma", "2015-11-02 02:54:59", "95.168.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4580", "0", "magma", "2015-11-02 03:10:18", "118.158.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4581", "0", "magma", "2015-11-02 03:11:19", "209.89.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4582", "0", "magma", "2015-11-02 03:11:40", "187.14.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4583", "1", "admin8576", "2015-11-02 03:23:40", "89.223.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4584", "0", "magma", "2015-11-02 03:28:51", "86.149.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4585", "0", "magma", "2015-11-02 03:30:54", "118.137.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4586", "0", "magma", "2015-11-02 03:35:36", "67.184.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4587", "0", "admin", "2015-11-02 03:42:20", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4588", "0", "magma", "2015-11-02 03:42:31", "80.227.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4589", "0", "magma", "2015-11-02 03:45:20", "79.125.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4590", "0", "magma", "2015-11-02 03:45:56", "197.8.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4591", "0", "magma", "2015-11-02 03:46:41", "49.149.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4592", "0", "magma", "2015-11-02 04:30:08", "197.15.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4593", "1", "admin8576", "2015-11-02 04:43:14", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4594", "0", "magma", "2015-11-02 04:55:33", "118.200.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4595", "0", "magma", "2015-11-02 05:03:50", "41.141.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4596", "0", "magma", "2015-11-02 05:17:38", "79.113.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4597", "0", "magma", "2015-11-02 05:51:37", "169.1.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4598", "1", "admin8576", "2015-11-02 06:02:31", "198.50.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4599", "0", "magma", "2015-11-02 06:06:33", "105.100.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4600", "0", "magma", "2015-11-02 06:06:45", "94.43.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4601", "0", "magma", "2015-11-02 06:10:04", "179.180.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4602", "0", "magma", "2015-11-02 06:42:58", "179.108.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4603", "0", "magma", "2015-11-02 07:10:42", "221.147.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4604", "0", "magma", "2015-11-02 07:16:54", "175.136.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4605", "1", "admin8576", "2015-11-02 07:21:59", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4606", "0", "magma", "2015-11-02 07:24:16", "162.104.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4607", "0", "magma", "2015-11-02 07:45:00", "37.6.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4608", "0", "magma", "2015-11-02 08:02:52", "182.56.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4609", "0", "magma", "2015-11-02 08:08:20", "77.40.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4610", "0", "magma", "2015-11-02 08:20:23", "180.190.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4611", "0", "magma", "2015-11-02 08:21:13", "94.97.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4612", "0", "magma", "2015-11-02 08:37:34", "78.189.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4613", "0", "magma", "2015-11-02 08:39:17", "104.175.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4614", "1", "admin8576", "2015-11-02 08:41:10", "37.187.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4615", "0", "magma", "2015-11-02 08:42:45", "202.169.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4616", "0", "magma", "2015-11-02 08:45:54", "14.192.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4617", "0", "magma", "2015-11-02 08:57:52", "111.90.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4618", "0", "magma", "2015-11-02 09:29:14", "91.46.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4619", "0", "magma", "2015-11-02 09:30:14", "192.101.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4620", "0", "magma", "2015-11-02 09:35:48", "103.251.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4621", "0", "magma", "2015-11-02 09:44:05", "105.107.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4622", "1", "admin8576", "2015-11-02 10:00:38", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4623", "0", "magma", "2015-11-02 10:31:14", "115.167.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4624", "0", "magma", "2015-11-02 10:36:27", "85.64.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4625", "0", "magma", "2015-11-02 10:45:03", "189.169.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4626", "0", "magma", "2015-11-02 10:46:50", "85.250.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4627", "0", "magma", "2015-11-02 11:01:31", "114.111.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4628", "0", "magma", "2015-11-02 11:19:11", "39.41.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4629", "1", "admin8576", "2015-11-02 11:19:57", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4630", "0", "magma", "2015-11-02 11:31:31", "124.82.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4631", "0", "magma", "2015-11-02 11:31:55", "86.122.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4632", "0", "magma", "2015-11-02 11:45:23", "90.209.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4633", "0", "magma", "2015-11-02 12:00:27", "42.60.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4634", "0", "magma", "2015-11-02 12:04:03", "69.253.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4635", "0", "admin", "2015-11-02 12:11:26", "176.9.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4636", "0", "magma", "2015-11-02 12:15:01", "5.78.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4637", "0", "magma", "2015-11-02 12:22:55", "112.135.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4638", "0", "magma", "2015-11-02 12:37:15", "41.222.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4639", "1", "admin8576", "2015-11-02 12:39:06", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4640", "0", "magma", "2015-11-02 12:46:18", "117.199.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4641", "0", "magma", "2015-11-02 12:55:48", "41.65.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4642", "0", "magma", "2015-11-02 13:03:55", "121.54.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4643", "0", "magma", "2015-11-02 13:07:11", "41.105.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4644", "0", "magma", "2015-11-02 13:47:59", "89.212.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4645", "1", "admin8576", "2015-11-02 13:58:34", "95.142.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4646", "0", "magma", "2015-11-02 14:28:09", "169.0.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4647", "0", "magma", "2015-11-02 14:37:21", "103.252.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4648", "0", "magma", "2015-11-02 14:53:28", "31.192.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4649", "0", "magma", "2015-11-02 15:02:34", "5.14.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4650", "0", "magma", "2015-11-02 15:15:19", "179.157.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4651", "1", "admin8576", "2015-11-02 15:18:06", "46.233.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4652", "0", "magma", "2015-11-02 16:10:29", "150.107.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4653", "0", "magma", "2015-11-02 16:14:51", "93.102.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4654", "1", "admin8576", "2015-11-02 16:37:43", "64.113.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4655", "0", "magma", "2015-11-02 16:43:53", "176.158.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4656", "0", "magma", "2015-11-02 16:49:28", "109.175.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4657", "0", "magma", "2015-11-02 16:57:08", "79.181.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4658", "0", "magma", "2015-11-02 17:08:36", "172.194.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4659", "0", "magma", "2015-11-02 17:32:53", "94.189.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4660", "0", "magma", "2015-11-02 17:35:10", "78.56.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4661", "0", "magma", "2015-11-02 17:40:43", "2.177.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4662", "0", "magma", "2015-11-02 17:55:34", "109.103.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4663", "1", "admin8576", "2015-11-02 17:57:52", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4664", "0", "magma", "2015-11-02 18:20:54", "61.0.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4665", "0", "magma", "2015-11-02 18:31:59", "87.211.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4666", "0", "magma", "2015-11-02 18:34:06", "175.193.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4667", "0", "magma", "2015-11-02 18:47:53", "83.102.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4668", "0", "magma", "2015-11-02 19:16:51", "78.60.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4669", "0", "magma", "2015-11-02 19:18:29", "1.52.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4670", "0", "magma", "2015-11-02 19:37:29", "177.16.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4671", "0", "magma", "2015-11-02 19:39:45", "90.209.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4672", "0", "magma", "2015-11-02 19:43:15", "110.235.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4673", "1", "admin8576", "2015-11-02 19:46:58", "46.246.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4674", "0", "magma", "2015-11-02 20:06:39", "39.59.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4675", "0", "magma", "2015-11-02 20:08:32", "51.39.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4676", "0", "magma", "2015-11-02 20:21:51", "117.192.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4677", "0", "magma", "2015-11-02 20:28:13", "84.40.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4678", "0", "magma", "2015-11-02 20:39:43", "197.89.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4679", "0", "magma", "2015-11-02 20:40:49", "86.218.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4680", "0", "magma", "2015-11-02 20:45:26", "217.171.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4681", "0", "magma", "2015-11-02 20:51:24", "80.220.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4682", "0", "magma", "2015-11-02 20:56:41", "94.176.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4683", "0", "magma", "2015-11-02 21:09:28", "196.206.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4684", "0", "magma", "2015-11-02 21:38:08", "31.223.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4685", "0", "magma", "2015-11-02 21:44:54", "178.222.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4686", "0", "magma", "2015-11-02 21:58:17", "37.221.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4687", "0", "magma", "2015-11-02 21:58:49", "89.40.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4688", "0", "magma", "2015-11-02 22:04:35", "31.11.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4689", "0", "magma", "2015-11-02 22:19:03", "79.183.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4690", "0", "admin", "2015-11-02 22:25:36", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4691", "0", "magma", "2015-11-02 22:27:11", "95.120.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4692", "1", "admin8576", "2015-11-02 22:35:33", "77.244.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4693", "0", "magma", "2015-11-02 22:39:02", "197.255.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4694", "0", "magma", "2015-11-02 23:07:46", "87.127.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4695", "0", "magma", "2015-11-02 23:18:16", "58.97.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4696", "0", "magma", "2015-11-02 23:36:00", "73.165.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4697", "0", "magma", "2015-11-02 23:41:57", "83.87.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4698", "0", "magma", "2015-11-02 23:48:28", "201.2.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4699", "0", "magma", "2015-11-03 00:07:03", "107.200.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4700", "0", "magma", "2015-11-03 00:22:43", "122.176.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4701", "1", "admin8576", "2015-11-03 00:36:15", "50.7.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4702", "0", "magma", "2015-11-03 00:58:43", "151.226.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4703", "0", "magma", "2015-11-03 00:59:53", "175.136.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4704", "0", "magma", "2015-11-03 01:08:17", "94.43.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4705", "0", "magma", "2015-11-03 01:19:03", "194.83.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4706", "0", "magma", "2015-11-03 01:24:58", "41.108.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4707", "0", "magma", "2015-11-03 01:57:06", "177.56.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4708", "1", "admin8576", "2015-11-03 01:57:14", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4709", "0", "magma", "2015-11-03 01:57:53", "91.185.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4710", "0", "magma", "2015-11-03 02:59:35", "149.78.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4711", "0", "magma", "2015-11-03 03:15:13", "76.181.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4712", "1", "admin8576", "2015-11-03 03:16:21", "80.82.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4713", "0", "magma", "2015-11-03 03:44:26", "149.88.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4714", "0", "magma", "2015-11-03 03:45:56", "178.124.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4715", "1", "admin8576", "2015-11-03 04:35:26", "79.172.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4716", "0", "magma", "2015-11-03 05:10:35", "176.21.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4717", "0", "magma", "2015-11-03 05:15:19", "85.64.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4718", "0", "magma", "2015-11-03 05:26:31", "112.134.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4719", "0", "magma", "2015-11-03 05:30:42", "187.41.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4720", "0", "magma", "2015-11-03 05:35:08", "92.109.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4721", "0", "magma", "2015-11-03 05:42:26", "60.243.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4722", "1", "admin8576", "2015-11-03 05:54:17", "212.83.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4723", "0", "magma", "2015-11-03 06:21:09", "41.169.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4724", "0", "magma", "2015-11-03 06:24:25", "85.135.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4725", "0", "magma", "2015-11-03 06:59:23", "49.149.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4726", "1", "admin8576", "2015-11-03 07:13:30", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4727", "0", "magma", "2015-11-03 07:17:46", "42.115.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4728", "0", "magma", "2015-11-03 08:07:59", "188.247.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4729", "0", "magma", "2015-11-03 08:23:46", "60.243.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4730", "1", "admin8576", "2015-11-03 08:32:16", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4731", "0", "admin", "2015-11-03 09:01:05", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4732", "0", "magma", "2015-11-03 09:18:45", "109.149.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4733", "0", "magma", "2015-11-03 09:44:15", "109.67.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4734", "1", "admin8576", "2015-11-03 09:51:13", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4735", "0", "magma", "2015-11-03 10:08:29", "122.54.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4736", "0", "magma", "2015-11-03 10:09:21", "194.28.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4737", "0", "magma", "2015-11-03 10:24:16", "89.212.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4738", "0", "magma", "2015-11-03 10:25:39", "5.2.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4739", "0", "magma", "2015-11-03 10:46:44", "41.141.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4740", "0", "magma", "2015-11-03 10:59:03", "201.229.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4741", "0", "magma", "2015-11-03 11:00:40", "185.33.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4742", "1", "admin8576", "2015-11-03 11:09:52", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4743", "0", "magma", "2015-11-03 11:25:05", "93.87.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4744", "0", "magma", "2015-11-03 11:25:58", "68.35.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4745", "0", "magma", "2015-11-03 11:33:26", "5.141.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4746", "0", "magma", "2015-11-03 12:03:29", "64.180.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4747", "0", "magma", "2015-11-03 12:27:03", "79.179.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4748", "1", "admin8576", "2015-11-03 12:28:23", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4749", "0", "magma", "2015-11-03 12:45:41", "5.36.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4750", "0", "magma", "2015-11-03 12:46:17", "41.186.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4751", "0", "magma", "2015-11-03 12:51:01", "81.196.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4752", "0", "magma", "2015-11-03 13:03:20", "50.170.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4753", "0", "magma", "2015-11-03 13:12:16", "147.229.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4754", "0", "magma", "2015-11-03 13:23:44", "112.207.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4755", "0", "magma", "2015-11-03 13:45:39", "94.97.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4756", "0", "magma", "2015-11-03 13:46:40", "176.60.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4757", "1", "admin8576", "2015-11-03 13:47:01", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4758", "0", "magma", "2015-11-03 13:55:52", "139.194.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4759", "0", "magma", "2015-11-03 13:58:34", "188.161.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4760", "0", "magma", "2015-11-03 14:30:44", "105.105.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4761", "0", "magma", "2015-11-03 14:32:00", "37.35.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4762", "0", "magma", "2015-11-03 14:33:51", "182.182.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4763", "0", "magma", "2015-11-03 14:43:36", "196.207.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4764", "0", "magma", "2015-11-03 14:48:01", "87.7.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4765", "1", "admin8576", "2015-11-03 15:06:01", "82.223.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4766", "0", "magma", "2015-11-03 15:08:03", "79.51.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4767", "0", "magma", "2015-11-03 15:11:18", "79.176.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4768", "0", "magma", "2015-11-03 15:17:00", "94.97.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4769", "0", "magma", "2015-11-03 15:31:25", "43.231.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4770", "0", "magma", "2015-11-03 15:40:15", "59.152.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4771", "0", "magma", "2015-11-03 15:46:12", "116.118.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4772", "0", "magma", "2015-11-03 16:15:18", "188.187.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4773", "0", "magma", "2015-11-03 16:18:50", "103.16.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4774", "1", "admin8576", "2015-11-03 16:25:00", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4775", "0", "magma", "2015-11-03 16:40:00", "78.163.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4776", "0", "magma", "2015-11-03 16:43:41", "41.207.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4777", "0", "magma", "2015-11-03 17:06:38", "201.239.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4778", "1", "admin8576", "2015-11-03 17:44:08", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4779", "0", "magma", "2015-11-03 18:00:49", "88.229.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4780", "0", "magma", "2015-11-03 18:06:56", "175.193.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4781", "0", "magma", "2015-11-03 18:24:26", "112.153.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4782", "0", "magma", "2015-11-03 18:29:50", "79.114.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4783", "0", "magma", "2015-11-03 18:38:26", "79.176.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4784", "0", "magma", "2015-11-03 18:42:05", "81.164.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4785", "1", "admin8576", "2015-11-03 19:03:36", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4786", "0", "admin", "2015-11-03 19:25:12", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4787", "0", "magma", "2015-11-03 19:28:20", "112.198.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4788", "0", "magma", "2015-11-03 20:02:19", "91.140.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4789", "0", "magma", "2015-11-03 20:08:36", "217.71.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4790", "0", "magma", "2015-11-03 20:13:19", "78.60.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4791", "0", "magma", "2015-11-03 20:16:25", "178.149.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4792", "1", "admin8576", "2015-11-03 20:22:56", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4793", "0", "magma", "2015-11-03 20:34:54", "191.250.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4794", "0", "magma", "2015-11-03 20:42:19", "121.170.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4795", "0", "magma", "2015-11-03 21:11:00", "103.49.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4796", "0", "magma", "2015-11-03 21:12:01", "86.104.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4797", "0", "magma", "2015-11-03 21:25:51", "90.164.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4798", "1", "admin8576", "2015-11-03 21:42:32", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4799", "0", "magma", "2015-11-03 21:50:09", "109.230.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4800", "0", "magma", "2015-11-03 21:53:39", "191.254.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4801", "0", "magma", "2015-11-03 21:54:11", "95.172.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4802", "0", "magma", "2015-11-03 21:59:42", "92.97.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4803", "0", "magma", "2015-11-03 22:14:43", "124.106.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4804", "0", "magma", "2015-11-03 22:42:03", "176.63.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4805", "0", "magma", "2015-11-03 22:42:06", "212.252.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4806", "0", "magma", "2015-11-03 22:46:58", "111.88.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4807", "1", "admin8576", "2015-11-03 23:02:05", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4808", "0", "magma", "2015-11-03 23:09:12", "94.96.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4809", "0", "magma", "2015-11-03 23:26:07", "181.228.33.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4810", "0", "magma", "2015-11-03 23:27:16", "109.98.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4811", "0", "magma", "2015-11-03 23:30:48", "95.102.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4812", "0", "magma", "2015-11-03 23:32:01", "43.227.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4813", "0", "magma", "2015-11-03 23:52:30", "85.139.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4814", "1", "admin8576", "2015-11-04 00:21:52", "95.69.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4815", "0", "magma", "2015-11-04 00:36:38", "111.88.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4816", "0", "magma", "2015-11-04 00:50:37", "27.34.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4817", "0", "magma", "2015-11-04 00:52:01", "5.155.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4818", "0", "magma", "2015-11-04 01:00:58", "177.40.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4819", "0", "magma", "2015-11-04 01:31:02", "41.82.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4820", "1", "admin8576", "2015-11-04 01:42:04", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4821", "0", "magma", "2015-11-04 01:55:47", "90.45.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4822", "0", "magma", "2015-11-04 02:33:47", "41.231.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4823", "0", "magma", "2015-11-04 02:46:33", "71.89.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4824", "1", "admin8576", "2015-11-04 03:02:17", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4825", "0", "magma", "2015-11-04 03:07:48", "84.235.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4826", "0", "magma", "2015-11-04 03:09:11", "206.45.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4827", "0", "magma", "2015-11-04 03:29:08", "101.186.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4828", "0", "magma", "2015-11-04 03:47:06", "197.83.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4829", "1", "admin8576", "2015-11-04 04:21:41", "81.89.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4830", "0", "magma", "2015-11-04 05:29:11", "78.84.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4831", "1", "admin8576", "2015-11-04 05:41:10", "37.59.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4832", "0", "admin", "2015-11-04 05:56:04", "104.232.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4833", "0", "magma", "2015-11-04 06:19:05", "95.165.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4834", "0", "magma", "2015-11-04 06:27:33", "199.18.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4835", "0", "magma", "2015-11-04 06:35:50", "208.168.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4836", "1", "admin8576", "2015-11-04 07:00:43", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4837", "0", "magma", "2015-11-04 07:13:36", "76.185.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4838", "0", "magma", "2015-11-04 07:17:37", "203.219.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4839", "0", "magma", "2015-11-04 07:41:53", "217.46.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4840", "0", "magma", "2015-11-04 07:53:39", "5.141.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4841", "1", "admin8576", "2015-11-04 08:19:57", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4842", "0", "magma", "2015-11-04 09:00:41", "106.51.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4843", "0", "magma", "2015-11-04 09:15:47", "118.33.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4844", "0", "magma", "2015-11-04 09:22:37", "89.115.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4845", "0", "magma", "2015-11-04 09:31:44", "31.215.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4846", "1", "admin8576", "2015-11-04 09:38:52", "81.89.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4847", "0", "magma", "2015-11-04 09:41:46", "109.214.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4848", "0", "magma", "2015-11-04 09:42:24", "112.153.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4849", "0", "magma", "2015-11-04 10:31:17", "112.135.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4850", "0", "magma", "2015-11-04 10:37:53", "179.53.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4851", "0", "magma", "2015-11-04 10:47:28", "190.193.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4852", "0", "magma", "2015-11-04 10:50:57", "90.69.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4853", "0", "magma", "2015-11-04 10:51:25", "175.119.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4854", "1", "admin8576", "2015-11-04 10:57:14", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4855", "0", "magma", "2015-11-04 11:08:50", "83.134.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4856", "1", "admin8576", "2015-11-04 11:22:02", "104.223.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4857", "1", "admin8576", "2015-11-04 11:22:02", "104.223.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4858", "1", "admin8576", "2015-11-04 11:22:02", "104.223.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4859", "0", "magma", "2015-11-04 11:24:50", "41.220.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4860", "0", "magma", "2015-11-04 11:42:28", "109.76.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4861", "0", "magma", "2015-11-04 12:05:48", "155.143.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4862", "0", "magma", "2015-11-04 12:06:34", "82.112.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4863", "1", "admin8576", "2015-11-04 12:15:54", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4864", "0", "magma", "2015-11-04 12:16:56", "190.148.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4865", "0", "magma", "2015-11-04 12:46:08", "49.206.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4866", "0", "magma", "2015-11-04 12:47:51", "212.109.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4867", "0", "magma", "2015-11-04 12:49:13", "194.249.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4868", "0", "magma", "2015-11-04 12:54:35", "71.89.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4869", "0", "magma", "2015-11-04 12:57:30", "89.34.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4870", "1", "admin8576", "2015-11-04 13:34:43", "45.63.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4871", "0", "magma", "2015-11-04 14:12:35", "188.123.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4872", "0", "magma", "2015-11-04 14:46:01", "39.59.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4873", "0", "magma", "2015-11-04 14:47:44", "84.25.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4874", "0", "magma", "2015-11-04 14:50:58", "222.112.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4875", "1", "admin8576", "2015-11-04 14:53:49", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4876", "0", "magma", "2015-11-04 14:59:26", "109.121.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4877", "0", "magma", "2015-11-04 15:10:03", "5.10.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4878", "0", "magma", "2015-11-04 15:38:12", "24.135.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4879", "0", "magma", "2015-11-04 16:06:30", "41.38.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4880", "1", "admin8576", "2015-11-04 16:13:32", "173.254.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4881", "0", "magma", "2015-11-04 16:22:15", "187.181.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4882", "0", "magma", "2015-11-04 16:34:19", "78.159.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4883", "0", "magma", "2015-11-04 16:36:24", "42.115.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4884", "0", "magma", "2015-11-04 17:07:51", "103.245.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4885", "0", "magma", "2015-11-04 17:08:34", "92.85.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4886", "0", "admin", "2015-11-04 17:15:06", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4887", "1", "admin8576", "2015-11-04 17:32:53", "77.247.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4888", "0", "magma", "2015-11-04 17:39:04", "178.140.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4889", "0", "magma", "2015-11-04 18:13:00", "82.67.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4890", "0", "magma", "2015-11-04 18:17:32", "165.120.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4891", "0", "magma", "2015-11-04 18:18:30", "81.60.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4892", "0", "magma", "2015-11-04 18:22:28", "176.221.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4893", "0", "magma", "2015-11-04 18:28:21", "103.199.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4894", "0", "magma", "2015-11-04 18:42:54", "217.209.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4895", "0", "magma", "2015-11-04 18:52:00", "90.221.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4896", "1", "admin8576", "2015-11-04 18:52:32", "217.115.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4897", "0", "magma", "2015-11-04 19:14:55", "113.199.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4898", "0", "magma", "2015-11-04 19:38:59", "208.168.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4899", "0", "magma", "2015-11-04 20:08:07", "182.181.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4900", "1", "admin8576", "2015-11-04 20:12:52", "142.4.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4901", "0", "magma", "2015-11-04 20:13:00", "95.168.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4902", "0", "magma", "2015-11-04 20:55:19", "89.67.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4903", "0", "magma", "2015-11-04 20:56:06", "201.22.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4904", "0", "magma", "2015-11-04 21:06:58", "201.209.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4905", "0", "magma", "2015-11-04 21:09:57", "5.15.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4906", "0", "magma", "2015-11-04 21:20:27", "112.211.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4907", "0", "magma", "2015-11-04 21:29:07", "119.94.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4908", "0", "magma", "2015-11-04 21:29:22", "128.234.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4909", "0", "magma", "2015-11-04 21:30:30", "188.26.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4910", "1", "admin8576", "2015-11-04 21:32:40", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4911", "0", "magma", "2015-11-04 21:36:06", "186.33.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4912", "0", "magma", "2015-11-04 21:52:23", "182.186.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4913", "0", "magma", "2015-11-04 22:00:30", "111.91.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4914", "0", "magma", "2015-11-04 22:08:41", "1.32.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4915", "1", "admin8576", "2015-11-04 22:52:22", "176.123.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4916", "0", "magma", "2015-11-04 23:00:09", "89.87.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4917", "0", "magma", "2015-11-04 23:01:47", "89.216.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4918", "0", "magma", "2015-11-04 23:23:01", "71.89.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4919", "0", "magma", "2015-11-04 23:24:52", "177.40.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4920", "0", "magma", "2015-11-04 23:29:39", "111.91.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4921", "0", "magma", "2015-11-04 23:46:58", "76.103.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4922", "0", "magma", "2015-11-04 23:54:13", "151.224.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4923", "0", "magma", "2015-11-05 00:10:25", "191.251.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4924", "0", "magma", "2015-11-05 00:11:55", "5.146.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4925", "1", "admin8576", "2015-11-05 00:12:01", "79.134.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4926", "0", "magma", "2015-11-05 00:20:57", "5.144.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4927", "0", "magma", "2015-11-05 00:21:12", "80.212.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4928", "0", "magma", "2015-11-05 00:23:01", "131.117.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4929", "0", "magma", "2015-11-05 00:23:31", "86.149.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4930", "0", "magma", "2015-11-05 00:27:55", "109.92.111.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4931", "0", "magma", "2015-11-05 00:35:30", "151.229.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4932", "0", "magma", "2015-11-05 01:01:18", "31.215.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4933", "1", "admin8576", "2015-11-05 01:31:27", "86.195.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4934", "0", "magma", "2015-11-05 02:01:39", "213.143.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4935", "1", "admin8576", "2015-11-05 02:51:02", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4936", "0", "magma", "2015-11-05 03:04:04", "176.21.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4937", "0", "magma", "2015-11-05 04:02:55", "112.210.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4938", "1", "admin8576", "2015-11-05 04:11:45", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4939", "0", "magma", "2015-11-05 04:20:05", "181.90.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4940", "0", "magma", "2015-11-05 04:39:19", "109.101.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4941", "0", "magma", "2015-11-05 04:46:00", "2.220.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4942", "0", "magma", "2015-11-05 04:52:25", "190.136.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4943", "0", "admin", "2015-11-05 04:53:20", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4944", "1", "admin8576", "2015-11-05 05:31:10", "89.46.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4945", "0", "magma", "2015-11-05 06:12:44", "191.33.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4946", "0", "magma", "2015-11-05 06:15:06", "148.0.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4947", "0", "magma", "2015-11-05 06:17:40", "112.198.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4948", "0", "magma", "2015-11-05 06:26:47", "112.210.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4949", "1", "admin8576", "2015-11-05 06:50:33", "158.69.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4950", "0", "magma", "2015-11-05 07:11:47", "111.119.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4951", "0", "magma", "2015-11-05 07:22:33", "64.237.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4952", "1", "admin8576", "2015-11-05 08:09:47", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4953", "0", "magma", "2015-11-05 09:26:19", "5.12.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4954", "0", "magma", "2015-11-05 10:01:39", "31.11.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4955", "0", "magma", "2015-11-05 10:04:54", "95.180.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4956", "0", "magma", "2015-11-05 10:15:43", "71.81.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4957", "0", "magma", "2015-11-05 10:21:10", "43.245.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4958", "0", "magma", "2015-11-05 10:46:31", "84.244.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4959", "0", "magma", "2015-11-05 11:15:38", "82.114.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4960", "0", "magma", "2015-11-05 11:17:50", "5.237.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4961", "0", "magma", "2015-11-05 11:28:20", "49.148.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4962", "0", "magma", "2015-11-05 11:46:46", "182.50.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4963", "0", "magma", "2015-11-05 11:48:06", "78.187.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4964", "0", "magma", "2015-11-05 11:51:24", "211.189.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4965", "0", "magma", "2015-11-05 11:55:29", "111.119.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4966", "0", "magma", "2015-11-05 12:02:23", "109.92.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4967", "1", "admin8576", "2015-11-05 12:05:50", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4968", "0", "magma", "2015-11-05 12:12:25", "188.123.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4969", "0", "magma", "2015-11-05 13:00:51", "182.185.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4970", "0", "magma", "2015-11-05 13:03:42", "80.72.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4971", "0", "magma", "2015-11-05 13:09:05", "176.21.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4972", "1", "admin8576", "2015-11-05 13:24:50", "50.7.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4973", "0", "magma", "2015-11-05 13:36:06", "188.27.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4974", "0", "magma", "2015-11-05 13:52:44", "115.42.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4975", "0", "magma", "2015-11-05 14:15:54", "89.169.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4976", "0", "magma", "2015-11-05 14:23:58", "94.189.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4977", "1", "admin8576", "2015-11-05 14:44:04", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4978", "0", "magma", "2015-11-05 14:45:10", "109.64.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4979", "0", "magma", "2015-11-05 14:46:29", "120.155.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4980", "0", "magma", "2015-11-05 15:10:47", "85.250.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4981", "0", "magma", "2015-11-05 15:18:05", "109.66.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4982", "0", "magma", "2015-11-05 15:18:22", "39.59.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4983", "0", "magma", "2015-11-05 15:36:33", "105.227.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4984", "0", "admin", "2015-11-05 15:46:32", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4985", "1", "admin8576", "2015-11-05 16:03:41", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4986", "0", "magma", "2015-11-05 16:14:31", "82.114.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4987", "0", "magma", "2015-11-05 16:25:30", "111.94.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4988", "0", "magma", "2015-11-05 16:28:41", "115.167.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4989", "0", "magma", "2015-11-05 16:33:43", "174.100.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4990", "0", "magma", "2015-11-05 16:41:17", "41.207.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4991", "0", "magma", "2015-11-05 16:48:32", "46.240.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4992", "0", "magma", "2015-11-05 17:15:38", "104.230.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4993", "1", "admin8576", "2015-11-05 17:23:17", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4994", "0", "magma", "2015-11-05 17:47:30", "89.205.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4995", "0", "magma", "2015-11-05 18:22:54", "219.75.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4996", "0", "magma", "2015-11-05 18:25:50", "179.216.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4997", "0", "magma", "2015-11-05 18:39:13", "92.53.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4998", "0", "magma", "2015-11-05 18:40:09", "82.78.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("4999", "1", "admin8576", "2015-11-05 18:43:12", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5000", "0", "magma", "2015-11-05 18:56:38", "128.234.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5001", "0", "magma", "2015-11-05 19:04:35", "37.221.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5002", "0", "magma", "2015-11-05 19:10:14", "197.116.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5003", "0", "magma", "2015-11-05 19:14:10", "95.5.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5004", "0", "magma", "2015-11-05 19:51:14", "179.219.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5005", "0", "magma", "2015-11-05 19:52:57", "105.158.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5006", "1", "admin8576", "2015-11-05 20:03:22", "209.159.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5007", "0", "magma", "2015-11-05 20:06:00", "87.14.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5008", "0", "magma", "2015-11-05 20:08:58", "121.54.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5009", "0", "magma", "2015-11-05 20:13:27", "190.193.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5010", "0", "magma", "2015-11-05 21:01:47", "90.176.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5011", "0", "magma", "2015-11-05 21:05:33", "79.179.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5012", "0", "magma", "2015-11-05 21:13:29", "79.115.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5013", "1", "admin8576", "2015-11-05 21:23:02", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5014", "1", "admin8576", "2015-11-05 22:42:49", "209.159.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5015", "0", "magma", "2015-11-05 22:55:22", "105.102.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5016", "1", "admin8576", "2015-11-06 00:02:47", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5017", "1", "admin8576", "2015-11-06 01:22:18", "151.80.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5018", "0", "admin", "2015-11-06 02:19:27", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5019", "1", "admin8576", "2015-11-06 02:41:57", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5020", "1", "admin8576", "2015-11-06 04:01:38", "82.76.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5021", "1", "admin8576", "2015-11-06 05:21:07", "158.69.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5022", "1", "admin8576", "2015-11-06 06:40:10", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5023", "1", "admin8576", "2015-11-06 07:59:19", "185.17.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5024", "1", "admin8576", "2015-11-06 09:18:11", "46.165.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5025", "1", "admin8576", "2015-11-06 10:37:05", "204.11.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5026", "1", "admin8576", "2015-11-06 11:55:45", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5027", "0", "admin", "2015-11-06 12:59:33", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5028", "1", "admin8576", "2015-11-06 13:14:31", "109.74.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5029", "1", "admin8576", "2015-11-06 14:33:20", "212.47.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5030", "1", "admin8576", "2015-11-06 15:52:07", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5031", "1", "admin8576", "2015-11-06 17:11:20", "192.3.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5032", "1", "admin8576", "2015-11-06 18:30:42", "178.20.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5033", "1", "admin8576", "2015-11-06 19:50:01", "46.165.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5034", "1", "admin8576", "2015-11-06 21:09:52", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5035", "1", "admin8576", "2015-11-06 22:29:40", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5036", "0", "admin", "2015-11-06 23:24:53", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5037", "1", "admin8576", "2015-11-06 23:49:54", "198.96.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5038", "1", "admin8576", "2015-11-07 01:09:24", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5039", "1", "admin8576", "2015-11-07 02:28:34", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5040", "1", "admin8576", "2015-11-07 03:47:40", "78.193.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5041", "1", "admin8576", "2015-11-07 05:07:19", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5042", "1", "admin8576", "2015-11-07 06:26:34", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5043", "1", "admin8576", "2015-11-07 07:46:08", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5044", "1", "admin8576", "2015-11-07 09:05:16", "92.222.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5045", "0", "admin", "2015-11-07 09:35:23", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5046", "1", "admin8576", "2015-11-07 10:24:03", "94.242.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5047", "1", "admin8576", "2015-11-07 11:42:40", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5048", "1", "admin8576", "2015-11-07 13:01:18", "192.81.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5049", "1", "admin8576", "2015-11-07 14:19:59", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5050", "1", "admin8576", "2015-11-07 15:39:06", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5051", "1", "admin8576", "2015-11-07 16:58:03", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5052", "1", "admin8576", "2015-11-07 18:17:18", "179.43.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5053", "1", "admin8576", "2015-11-07 19:36:41", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5054", "0", "admin", "2015-11-07 19:52:14", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5055", "1", "admin8576", "2015-11-07 20:56:06", "65.181.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5056", "1", "admin8576", "2015-11-07 22:15:36", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5057", "1", "admin8576", "2015-11-07 23:35:22", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5058", "1", "admin8576", "2015-11-08 00:54:29", "96.44.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5059", "1", "admin8576", "2015-11-08 02:13:33", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5060", "1", "admin8576", "2015-11-08 03:32:37", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5061", "1", "admin8576", "2015-11-08 04:51:15", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5062", "0", "admin", "2015-11-08 05:55:55", "77.109.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5063", "1", "admin8576", "2015-11-08 07:28:45", "96.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5064", "1", "admin8576", "2015-11-08 08:47:11", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5065", "1", "admin8576", "2015-11-08 10:05:38", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5066", "1", "admin8576", "2015-11-08 11:24:19", "77.109.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5067", "1", "admin8576", "2015-11-08 12:43:03", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5068", "1", "admin8576", "2015-11-08 15:20:51", "188.235.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5069", "0", "admin", "2015-11-08 15:54:44", "31.14.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5070", "1", "admin8576", "2015-11-08 16:46:15", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5071", "1", "admin8576", "2015-11-08 18:12:48", "37.48.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5072", "1", "admin8576", "2015-11-08 19:43:17", "192.99.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5073", "1", "admin8576", "2015-11-08 22:37:02", "204.11.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5074", "1", "admin8576", "2015-11-09 00:04:16", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5075", "0", "admin", "2015-11-09 01:28:52", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5076", "1", "admin8576", "2015-11-09 01:32:52", "185.10.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5077", "1", "admin8576", "2015-11-09 03:00:29", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5078", "1", "admin8576", "2015-11-09 04:29:18", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5079", "1", "admin8576", "2015-11-09 05:56:47", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5080", "1", "admin8576", "2015-11-09 07:24:27", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5081", "1", "admin8576", "2015-11-09 08:51:33", "95.130.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5082", "0", "admin", "2015-11-09 10:15:06", "5.196.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5083", "1", "admin8576", "2015-11-09 10:19:11", "96.47.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5084", "1", "admin8576", "2015-11-09 11:45:38", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5085", "1", "admin8576", "2015-11-09 13:12:08", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5086", "1", "admin8576", "2015-11-09 14:39:01", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5087", "1", "admin8576", "2015-11-09 16:05:32", "178.20.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5088", "1", "admin8576", "2015-11-09 17:31:48", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5089", "1", "admin8576", "2015-11-09 18:58:10", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5090", "1", "admin8576", "2015-11-09 20:25:03", "85.24.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5091", "0", "admin", "2015-11-09 20:35:56", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5092", "1", "admin8576", "2015-11-09 21:51:23", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5093", "1", "admin8576", "2015-11-09 23:17:59", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5094", "1", "admin8576", "2015-11-10 00:43:54", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5095", "1", "admin8576", "2015-11-10 02:10:46", "5.9.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5096", "1", "admin8576", "2015-11-10 03:38:40", "192.99.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5097", "1", "admin8576", "2015-11-10 05:06:42", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5098", "1", "admin8576", "2015-11-10 06:34:31", "94.26.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5099", "0", "admin", "2015-11-10 06:47:02", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5100", "1", "admin8576", "2015-11-10 08:01:15", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5101", "1", "admin8576", "2015-11-10 09:28:47", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5102", "1", "admin8576", "2015-11-10 10:56:26", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5103", "1", "admin8576", "2015-11-10 12:24:07", "178.20.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5104", "0", "magma", "2015-11-10 13:32:20", "223.197.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5105", "0", "magma", "2015-11-10 13:40:40", "151.224.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5106", "0", "magma", "2015-11-10 13:49:40", "172.194.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5107", "0", "magma", "2015-11-10 13:49:45", "103.41.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5108", "1", "admin8576", "2015-11-10 13:51:19", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5109", "0", "magma", "2015-11-10 14:22:55", "41.141.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5110", "0", "magma", "2015-11-10 14:30:25", "115.184.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5111", "0", "magma", "2015-11-10 14:43:52", "5.186.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5112", "0", "magma", "2015-11-10 15:02:54", "123.136.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5113", "0", "magma", "2015-11-10 15:03:08", "37.26.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5114", "1", "admin8576", "2015-11-10 15:18:14", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5115", "0", "magma", "2015-11-10 15:20:13", "37.78.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5116", "0", "magma", "2015-11-10 15:41:38", "62.121.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5117", "0", "magma", "2015-11-10 16:21:25", "5.41.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5118", "0", "magma", "2015-11-10 16:36:28", "49.144.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5119", "1", "admin8576", "2015-11-10 18:12:56", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5120", "1", "admin8576", "2015-11-10 19:40:19", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5121", "1", "admin8576", "2015-11-10 21:07:06", "46.105.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5122", "1", "admin8576", "2015-11-10 22:33:58", "176.10.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5123", "1", "admin8576", "2015-11-11 00:00:24", "93.184.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5124", "1", "admin8576", "2015-11-11 01:27:09", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5125", "1", "admin8576", "2015-11-11 02:53:38", "94.242.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5126", "0", "admin", "2015-11-11 03:42:41", "64.113.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5127", "1", "admin8576", "2015-11-11 04:20:44", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5128", "1", "admin8576", "2015-11-11 05:47:41", "85.245.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5129", "1", "admin8576", "2015-11-11 07:14:45", "198.96.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5130", "1", "admin8576", "2015-11-11 08:41:43", "178.17.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5131", "1", "admin8576", "2015-11-11 10:10:30", "77.109.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5132", "1", "admin8576", "2015-11-11 11:39:11", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5133", "1", "admin8576", "2015-11-11 13:05:38", "83.233.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5134", "0", "admin", "2015-11-11 13:32:03", "85.93.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5135", "1", "admin8576", "2015-11-11 14:32:58", "185.101.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5136", "0", "magma", "2015-11-11 14:44:22", "199.192.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5137", "0", "magma", "2015-11-11 15:31:46", "39.32.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5138", "0", "magma", "2015-11-11 15:53:15", "196.1.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5139", "1", "admin8576", "2015-11-11 16:00:51", "176.31.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5140", "0", "magma", "2015-11-11 16:06:47", "188.120.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5141", "0", "magma", "2015-11-11 16:12:57", "115.188.111.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5142", "0", "magma", "2015-11-11 16:14:03", "41.250.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5143", "0", "magma", "2015-11-11 16:28:55", "188.219.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5144", "0", "magma", "2015-11-11 17:12:57", "61.92.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5145", "0", "magma", "2015-11-11 17:12:58", "176.221.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5146", "0", "magma", "2015-11-11 17:23:07", "182.178.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5147", "0", "magma", "2015-11-11 17:47:26", "95.86.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5148", "0", "magma", "2015-11-11 17:48:50", "112.207.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5149", "0", "magma", "2015-11-11 18:19:17", "109.225.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5150", "0", "magma", "2015-11-11 18:22:50", "5.246.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5151", "0", "magma", "2015-11-11 18:23:28", "179.180.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5152", "0", "magma", "2015-11-11 18:33:09", "5.102.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5153", "0", "magma", "2015-11-11 18:39:36", "37.157.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5154", "0", "magma", "2015-11-11 18:50:47", "191.178.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5155", "0", "magma", "2015-11-11 18:54:04", "179.222.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5156", "1", "admin8576", "2015-11-11 18:54:34", "178.20.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5157", "0", "magma", "2015-11-11 19:25:43", "213.119.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5158", "0", "magma", "2015-11-11 20:00:40", "110.159.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5159", "0", "magma", "2015-11-11 20:06:39", "77.105.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5160", "1", "admin8576", "2015-11-11 20:21:05", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5161", "0", "magma", "2015-11-11 20:29:02", "218.110.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5162", "0", "magma", "2015-11-11 20:39:38", "185.23.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5163", "0", "magma", "2015-11-11 20:56:30", "5.102.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5164", "0", "magma", "2015-11-11 21:31:32", "191.185.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5165", "1", "admin8576", "2015-11-11 21:47:20", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5166", "0", "magma", "2015-11-11 22:05:31", "188.141.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5167", "0", "magma", "2015-11-11 22:12:58", "189.26.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5168", "0", "magma", "2015-11-11 22:21:49", "94.189.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5169", "0", "admin", "2015-11-11 23:06:45", "185.10.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5170", "1", "admin8576", "2015-11-11 23:13:51", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5171", "0", "magma", "2015-11-11 23:34:57", "178.222.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5172", "0", "magma", "2015-11-11 23:59:46", "46.240.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5173", "0", "magma", "2015-11-12 00:40:41", "78.163.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5174", "0", "magma", "2015-11-12 01:26:20", "187.171.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5175", "1", "admin8576", "2015-11-12 03:35:00", "176.58.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5176", "0", "magma", "2015-11-12 03:37:27", "116.90.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5177", "0", "magma", "2015-11-12 04:42:09", "200.192.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5178", "1", "admin8576", "2015-11-12 05:01:46", "158.69.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5179", "1", "admin8576", "2015-11-12 06:29:28", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5180", "0", "magma", "2015-11-12 06:44:41", "80.227.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5181", "0", "magma", "2015-11-12 07:08:12", "49.204.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5182", "0", "admin", "2015-11-12 07:56:29", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5183", "1", "admin8576", "2015-11-12 07:57:16", "46.182.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5184", "1", "admin8576", "2015-11-12 09:24:10", "193.171.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5185", "0", "magma", "2015-11-12 09:26:35", "182.186.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5186", "0", "magma", "2015-11-12 10:09:12", "197.117.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5187", "1", "admin8576", "2015-11-12 10:49:50", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5188", "0", "magma", "2015-11-12 11:42:04", "178.149.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5189", "1", "admin8576", "2015-11-12 12:16:16", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5190", "0", "magma", "2015-11-12 12:33:49", "163.47.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5191", "0", "magma", "2015-11-12 12:44:56", "43.227.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5192", "1", "admin8576", "2015-11-12 13:42:52", "65.183.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5193", "1", "admin8576", "2015-11-12 15:09:47", "185.100.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5194", "1", "admin8576", "2015-11-12 16:36:30", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5195", "0", "admin", "2015-11-12 17:44:47", "80.82.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5196", "1", "admin8576", "2015-11-12 18:03:17", "207.201.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5197", "1", "admin8576", "2015-11-12 19:29:48", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5198", "1", "admin8576", "2015-11-12 20:56:26", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5199", "1", "admin8576", "2015-11-12 22:23:17", "129.123.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5200", "1", "admin8576", "2015-11-12 23:50:19", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5201", "1", "admin8576", "2015-11-13 01:17:07", "173.254.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5202", "1", "admin8576", "2015-11-13 02:44:00", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5203", "0", "admin", "2015-11-13 04:30:35", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5204", "1", "admin8576", "2015-11-13 05:39:19", "95.130.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5205", "1", "admin8576", "2015-11-13 07:06:46", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5206", "1", "admin8576", "2015-11-13 08:34:19", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5207", "1", "admin8576", "2015-11-13 10:01:47", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5208", "1", "admin8576", "2015-11-13 11:29:10", "209.222.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5209", "1", "admin8576", "2015-11-13 12:56:15", "94.242.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5210", "1", "admin8576", "2015-11-13 14:23:57", "37.59.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5211", "0", "admin", "2015-11-13 14:56:57", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5212", "1", "admin8576", "2015-11-13 15:51:21", "89.187.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5213", "1", "admin8576", "2015-11-13 17:19:36", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5214", "1", "admin8576", "2015-11-13 18:46:55", "81.7.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5215", "1", "admin8576", "2015-11-13 20:14:04", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5216", "1", "admin8576", "2015-11-13 21:42:50", "104.238.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5217", "1", "admin8576", "2015-11-13 23:09:49", "185.14.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5218", "1", "admin8576", "2015-11-14 00:37:07", "5.199.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5219", "0", "admin", "2015-11-14 01:48:50", "195.154.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5220", "1", "admin8576", "2015-11-14 02:04:01", "188.138.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5221", "1", "admin8576", "2015-11-14 03:32:17", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5222", "1", "admin8576", "2015-11-14 04:59:57", "162.218.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5223", "1", "admin8576", "2015-11-14 06:28:13", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5224", "1", "admin8576", "2015-11-14 07:54:03", "149.202.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5225", "1", "admin8576", "2015-11-14 09:21:54", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5226", "1", "admin8576", "2015-11-14 10:49:27", "212.83.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5227", "1", "admin8576", "2015-11-14 12:16:52", "185.17.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5228", "1", "admin8576", "2015-11-14 13:44:09", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5229", "1", "admin8576", "2015-11-14 15:10:49", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5230", "1", "admin8576", "2015-11-14 16:37:55", "85.16.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5231", "1", "admin8576", "2015-11-14 18:05:06", "217.12.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5232", "1", "admin8576", "2015-11-14 19:32:35", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5233", "1", "admin8576", "2015-11-14 21:01:20", "107.181.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5234", "1", "admin8576", "2015-11-14 22:29:14", "158.69.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5235", "0", "admin", "2015-11-14 23:00:38", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5236", "1", "admin8576", "2015-11-14 23:57:14", "81.17.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5237", "1", "admin8576", "2015-11-15 01:24:34", "62.141.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5238", "1", "admin8576", "2015-11-15 02:51:11", "185.100.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5239", "1", "admin8576", "2015-11-15 04:23:23", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5240", "1", "admin8576", "2015-11-15 05:53:40", "158.69.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5241", "1", "admin8576", "2015-11-15 07:25:01", "65.183.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5242", "0", "admin", "2015-11-15 08:50:57", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5243", "1", "admin8576", "2015-11-15 08:52:22", "79.172.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5244", "1", "admin8576", "2015-11-15 10:19:57", "192.3.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5245", "1", "admin8576", "2015-11-15 11:47:26", "80.169.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5246", "1", "admin8576", "2015-11-15 13:15:42", "212.47.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5247", "1", "admin8576", "2015-11-15 14:44:30", "5.135.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5248", "1", "admin8576", "2015-11-15 16:12:50", "5.196.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5249", "1", "admin8576", "2015-11-15 17:42:45", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5250", "0", "admin", "2015-11-15 18:47:17", "5.9.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5251", "1", "admin8576", "2015-11-15 19:11:41", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5252", "1", "admin8576", "2015-11-15 22:11:48", "84.19.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5253", "1", "admin8576", "2015-11-15 23:41:54", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5254", "1", "admin8576", "2015-11-16 01:10:55", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5255", "1", "admin8576", "2015-11-16 02:40:51", "37.130.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5256", "1", "admin8576", "2015-11-16 04:10:03", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5257", "1", "admin8576", "2015-11-16 05:40:25", "217.115.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5258", "1", "admin8576", "2015-11-16 07:08:06", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5259", "1", "admin8576", "2015-11-16 08:37:18", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5260", "1", "admin8576", "2015-11-16 10:04:40", "207.244.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5261", "1", "admin8576", "2015-11-16 11:32:27", "77.244.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5262", "1", "admin8576", "2015-11-16 13:00:18", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5263", "1", "admin8576", "2015-11-16 14:28:41", "173.255.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5264", "1", "admin8576", "2015-11-16 15:53:13", "92.222.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5265", "1", "admin8576", "2015-11-16 17:16:39", "31.220.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5266", "1", "admin8576", "2015-11-16 18:40:17", "209.222.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5267", "1", "admin8576", "2015-11-16 20:04:08", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5268", "1", "admin8576", "2015-11-16 21:28:10", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5269", "1", "admin8576", "2015-11-16 22:52:10", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5270", "1", "admin8576", "2015-11-17 00:16:08", "79.98.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5271", "1", "admin8576", "2015-11-17 01:39:53", "77.244.254.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5272", "1", "admin8576", "2015-11-17 03:03:18", "85.93.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5273", "1", "admin8576", "2015-11-17 04:26:44", "142.4.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5274", "1", "admin8576", "2015-11-17 05:49:47", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5275", "0", "admin", "2015-11-17 06:42:42", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5276", "1", "admin8576", "2015-11-17 07:15:02", "85.16.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5277", "1", "admin8576", "2015-11-17 08:38:01", "194.150.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5278", "0", "admin", "2015-11-17 09:11:04", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5279", "1", "admin8576", "2015-11-17 10:00:42", "94.242.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5280", "1", "admin8576", "2015-11-17 11:23:12", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5281", "0", "admin", "2015-11-17 11:23:54", "81.89.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5282", "0", "admin", "2015-11-17 11:43:12", "192.42.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5283", "1", "admin8576", "2015-11-17 12:46:06", "85.10.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5284", "1", "admin8576", "2015-11-17 14:13:47", "149.202.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5285", "1", "admin8576", "2015-11-17 16:03:30", "54.183.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5286", "1", "admin8576", "2015-11-17 17:13:32", "54.183.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5287", "1", "admin8576", "2015-11-17 17:14:16", "142.4.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5288", "1", "admin8576", "2015-11-17 17:58:49", "54.183.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5289", "1", "admin8576", "2015-11-17 18:43:26", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5290", "1", "admin8576", "2015-11-17 20:12:53", "173.254.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5291", "0", "admin", "2015-11-17 21:25:53", "158.69.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5292", "1", "admin8576", "2015-11-17 21:39:48", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5293", "1", "admin8576", "2015-11-17 23:02:32", "185.100.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5294", "0", "admin", "2015-11-17 23:50:48", "91.109.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5295", "0", "admin", "2015-11-17 23:55:44", "173.255.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5296", "1", "admin8576", "2015-11-18 00:25:29", "85.93.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5297", "1", "admin8576", "2015-11-18 01:49:08", "198.50.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5298", "1", "admin8576", "2015-11-18 03:13:51", "199.87.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5299", "1", "admin8576", "2015-11-18 04:36:28", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5300", "1", "admin8576", "2015-11-18 05:59:06", "89.248.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5301", "0", "admin", "2015-11-18 06:39:04", "64.27.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5302", "1", "admin8576", "2015-11-18 07:21:50", "104.232.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5303", "1", "admin8576", "2015-11-18 08:44:00", "89.248.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5304", "0", "admin", "2015-11-18 08:59:59", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5305", "1", "admin8576", "2015-11-18 10:06:44", "81.7.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5306", "0", "admin", "2015-11-18 10:59:34", "31.220.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5307", "0", "admin", "2015-11-18 10:59:35", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5308", "1", "admin8576", "2015-11-18 11:29:14", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5309", "1", "admin8576", "2015-11-18 11:52:44", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5310", "1", "admin8576", "2015-11-18 12:26:18", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5311", "1", "admin8576", "2015-11-18 12:52:19", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5312", "1", "admin8576", "2015-11-18 12:58:26", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5313", "1", "admin8576", "2015-11-18 13:29:18", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5314", "1", "admin8576", "2015-11-18 14:03:23", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5315", "1", "admin8576", "2015-11-18 14:18:56", "84.19.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5316", "1", "admin8576", "2015-11-18 14:36:33", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5317", "1", "admin8576", "2015-11-18 15:15:03", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5318", "1", "admin8576", "2015-11-18 15:51:52", "85.16.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5319", "1", "admin8576", "2015-11-18 15:55:37", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5320", "1", "admin8576", "2015-11-18 16:39:40", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5321", "1", "admin8576", "2015-11-18 17:23:19", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5322", "1", "admin8576", "2015-11-18 17:26:11", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5323", "1", "admin8576", "2015-11-18 18:10:04", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5324", "1", "admin8576", "2015-11-18 18:51:41", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5325", "1", "admin8576", "2015-11-18 19:05:21", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5326", "1", "admin8576", "2015-11-18 19:27:48", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5327", "1", "admin8576", "2015-11-18 19:59:56", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5328", "1", "admin8576", "2015-11-18 20:33:11", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5329", "0", "admin", "2015-11-18 20:46:29", "37.187.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5330", "1", "admin8576", "2015-11-18 21:05:34", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5331", "0", "admin", "2015-11-18 22:54:40", "94.102.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5332", "0", "admin", "2015-11-18 22:54:41", "178.32.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5333", "0", "admin", "2015-11-19 06:21:53", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5334", "1", "admin8576", "2015-11-19 07:11:07", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5335", "1", "admin8576", "2015-11-19 07:38:09", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5336", "1", "admin8576", "2015-11-19 08:05:22", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5337", "1", "admin8576", "2015-11-19 08:32:41", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5338", "0", "admin", "2015-11-19 08:42:58", "176.10.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5339", "1", "admin8576", "2015-11-19 08:59:42", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5340", "1", "admin8576", "2015-11-19 09:27:12", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5341", "1", "admin8576", "2015-11-19 09:54:31", "188.227.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5342", "1", "admin8576", "2015-11-19 10:29:48", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5343", "0", "admin", "2015-11-19 10:40:08", "178.17.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5344", "0", "admin", "2015-11-19 10:40:09", "200.63.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5345", "1", "admin8576", "2015-11-19 11:01:17", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5346", "1", "admin8576", "2015-11-19 11:31:53", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5347", "1", "admin8576", "2015-11-19 12:06:00", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5348", "1", "admin8576", "2015-11-19 12:39:03", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5349", "1", "admin8576", "2015-11-19 13:10:53", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5350", "1", "admin8576", "2015-11-19 13:43:47", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5351", "1", "admin8576", "2015-11-19 14:19:54", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5352", "1", "admin8576", "2015-11-19 15:02:38", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5353", "1", "admin8576", "2015-11-19 15:44:04", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5354", "1", "admin8576", "2015-11-19 16:20:26", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5355", "1", "admin8576", "2015-11-19 16:51:25", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5356", "1", "admin8576", "2015-11-19 17:31:45", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5357", "1", "admin8576", "2015-11-19 18:13:31", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5358", "0", "admin", "2015-11-19 18:24:22", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5359", "1", "admin8576", "2015-11-19 18:55:18", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5360", "1", "admin8576", "2015-11-19 19:28:31", "52.31.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5361", "0", "admin", "2015-11-19 23:01:45", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5362", "0", "admin", "2015-11-19 23:01:45", "46.166.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5363", "0", "admin", "2015-11-20 07:08:29", "94.242.246.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5364", "0", "admin", "2015-11-20 09:44:22", "89.31.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5365", "0", "admin", "2015-11-20 11:29:58", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5366", "0", "admin", "2015-11-20 11:30:16", "72.52.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5367", "0", "admin", "2015-11-20 20:14:33", "204.124.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5368", "0", "admin", "2015-11-21 00:05:47", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5369", "0", "admin", "2015-11-21 00:05:47", "176.10.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5370", "0", "admin", "2015-11-21 08:00:09", "85.25.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5371", "0", "admin", "2015-11-21 19:12:41", "46.148.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5372", "0", "admin", "2015-11-22 05:20:06", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5373", "0", "admin", "2015-11-22 15:36:06", "46.165.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5374", "0", "admin", "2015-11-23 02:24:40", "5.79.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5375", "0", "admin", "2015-11-23 11:04:34", "176.126.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5376", "1", "admin8576", "2015-11-24 16:12:40", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5377", "1", "admin8576", "2015-11-24 16:45:52", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5378", "1", "admin8576", "2015-11-24 17:35:15", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5379", "1", "admin8576", "2015-11-24 18:22:54", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5380", "1", "admin8576", "2015-11-24 18:47:44", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5381", "1", "admin8576", "2015-11-24 19:13:39", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5382", "1", "admin8576", "2015-11-24 19:41:09", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5383", "1", "admin8576", "2015-11-24 20:09:41", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5384", "1", "admin8576", "2015-11-24 20:37:11", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5385", "1", "admin8576", "2015-11-24 21:04:38", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5386", "0", "admin", "2015-11-24 21:19:28", "178.175.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5387", "1", "admin8576", "2015-11-24 21:32:20", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5388", "1", "admin8576", "2015-11-24 21:56:09", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5389", "1", "admin8576", "2015-11-24 22:20:32", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5390", "1", "admin8576", "2015-11-24 22:46:48", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5391", "1", "admin8576", "2015-11-24 23:21:09", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5392", "1", "admin8576", "2015-11-24 23:56:34", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5393", "1", "admin8576", "2015-11-25 00:32:37", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5394", "1", "admin8576", "2015-11-25 01:08:25", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5395", "1", "admin8576", "2015-11-25 01:43:10", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5396", "0", "admin", "2015-11-25 07:25:33", "176.31.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5397", "1", "admin8576", "2015-11-25 09:52:36", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5398", "1", "admin8576", "2015-11-25 10:15:08", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5399", "1", "admin8576", "2015-11-25 10:43:03", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5400", "1", "admin8576", "2015-11-25 11:11:09", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5401", "1", "admin8576", "2015-11-25 11:39:52", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5402", "1", "admin8576", "2015-11-25 12:09:01", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5403", "1", "admin8576", "2015-11-25 12:37:04", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5404", "1", "admin8576", "2015-11-25 13:01:02", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5405", "1", "admin8576", "2015-11-25 13:25:40", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5406", "1", "admin8576", "2015-11-25 13:54:55", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5407", "1", "admin8576", "2015-11-25 14:27:10", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5408", "1", "admin8576", "2015-11-25 14:58:40", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5409", "1", "admin8576", "2015-11-25 15:28:42", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5410", "1", "admin8576", "2015-11-25 15:54:56", "54.183.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5411", "0", "admin", "2015-11-25 17:40:58", "81.89.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5412", "0", "admin", "2015-11-26 04:10:36", "37.59.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5413", "1", "admin8576", "2015-11-27 09:47:38", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5414", "1", "admin8576", "2015-11-27 09:47:39", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5415", "2", "admin5748", "2015-11-27 09:47:39", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5416", "1", "admin8576", "2015-11-29 12:30:25", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5417", "1", "admin8576", "2015-11-29 12:30:26", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5418", "2", "admin5748", "2015-11-29 12:30:27", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5419", "0", "admin", "2015-11-29 18:53:38", "151.80.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5420", "1", "admin8576", "2015-12-01 17:55:19", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5421", "1", "admin8576", "2015-12-01 17:55:20", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5422", "2", "admin5748", "2015-12-01 17:55:20", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5423", "1", "admin8576", "2015-12-02 19:33:55", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5424", "1", "admin8576", "2015-12-02 20:27:55", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5425", "1", "admin8576", "2015-12-02 21:02:20", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5426", "1", "admin8576", "2015-12-02 21:31:49", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5427", "1", "admin8576", "2015-12-02 21:53:52", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5428", "1", "admin8576", "2015-12-02 22:20:44", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5429", "1", "admin8576", "2015-12-02 22:47:30", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5430", "1", "admin8576", "2015-12-02 23:15:35", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5431", "1", "admin8576", "2015-12-02 23:43:03", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5432", "1", "admin8576", "2015-12-03 00:11:15", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5433", "1", "admin8576", "2015-12-03 00:38:58", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5434", "1", "admin8576", "2015-12-03 01:07:28", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5435", "1", "admin8576", "2015-12-03 01:35:30", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5436", "1", "admin8576", "2015-12-03 02:01:47", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5437", "1", "admin8576", "2015-12-03 02:24:05", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5438", "1", "admin8576", "2015-12-03 02:46:07", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5439", "1", "admin8576", "2015-12-03 03:12:28", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5440", "1", "admin8576", "2015-12-03 03:40:00", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5441", "1", "admin8576", "2015-12-03 04:07:03", "54.164.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5442", "1", "admin8576", "2015-12-13 13:38:09", "188.143.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5443", "1", "admin8576", "2015-12-13 13:38:10", "188.143.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5444", "1", "admin8576", "2015-12-13 13:38:12", "188.143.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5445", "0", "Admin", "2015-12-14 10:31:50", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5446", "0", "aDmin5478", "2015-12-14 14:55:00", "41.13.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5447", "2", "admin5748", "2015-12-15 13:54:18", "41.13.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5448", "2", "aDmin5748", "2015-12-15 13:55:14", "41.13.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5449", "1", "aDmin8576", "2015-12-15 13:55:55", "41.13.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5450", "1", "admin8576", "2015-12-15 14:09:39", "52.35.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5451", "1", "admin8576", "2015-12-15 14:50:22", "52.35.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5452", "1", "admin8576", "2015-12-15 15:46:55", "52.35.74.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5453", "1", "admin8576", "2015-12-15 16:45:39", "52.11.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5454", "1", "admin8576", "2015-12-15 17:11:07", "52.11.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5455", "1", "admin8576", "2015-12-15 17:37:44", "52.11.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5456", "1", "admin8576", "2015-12-15 18:04:15", "52.11.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5457", "1", "admin8576", "2015-12-16 21:16:21", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5458", "1", "admin8576", "2015-12-16 21:45:57", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5459", "1", "admin8576", "2015-12-16 22:16:32", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5460", "1", "admin8576", "2015-12-16 22:44:03", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5461", "1", "admin8576", "2015-12-16 23:10:36", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5462", "1", "admin8576", "2015-12-16 23:37:35", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5463", "1", "admin8576", "2015-12-17 00:04:39", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5464", "1", "admin8576", "2015-12-17 00:34:46", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5465", "1", "admin8576", "2015-12-17 01:07:55", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5466", "1", "admin8576", "2015-12-17 01:39:33", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5467", "1", "admin8576", "2015-12-17 02:12:56", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5468", "1", "admin8576", "2015-12-17 02:46:19", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5469", "1", "admin8576", "2015-12-17 03:19:54", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5470", "1", "admin8576", "2015-12-17 03:54:06", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5471", "1", "admin8576", "2015-12-17 04:27:57", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5472", "1", "admin8576", "2015-12-17 04:59:36", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5473", "0", "Admin", "2015-12-17 08:56:10", "195.154.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5474", "1", "admin8576", "2015-12-17 11:18:43", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5475", "1", "admin8576", "2015-12-17 11:25:36", "54.183.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5476", "1", "admin8576", "2015-12-17 11:45:27", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5477", "1", "admin8576", "2015-12-17 12:12:41", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5478", "1", "admin8576", "2015-12-17 12:40:09", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5479", "1", "admin8576", "2015-12-17 13:07:41", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5480", "1", "admin8576", "2015-12-17 13:42:18", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5481", "1", "admin8576", "2015-12-17 14:17:20", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5482", "1", "admin8576", "2015-12-17 14:52:13", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5483", "1", "admin8576", "2015-12-17 15:27:36", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5484", "1", "admin8576", "2015-12-17 16:02:29", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5485", "1", "admin8576", "2015-12-17 16:37:28", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5486", "1", "admin8576", "2015-12-17 17:11:52", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5487", "1", "admin8576", "2015-12-17 17:39:52", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5488", "1", "admin8576", "2015-12-17 18:12:39", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5489", "1", "admin8576", "2015-12-17 18:46:30", "52.34.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5490", "1", "admin8576", "2015-12-17 21:05:49", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5491", "1", "admin8576", "2015-12-17 21:05:50", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5492", "2", "admin5748", "2015-12-17 21:05:51", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5493", "1", "admin8576", "2015-12-19 16:46:53", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5494", "1", "admin8576", "2015-12-19 16:46:54", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5495", "2", "admin5748", "2015-12-19 16:46:54", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5496", "0", "Admin", "2015-12-20 22:47:13", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5497", "0", "Admin", "2015-12-25 02:00:56", "195.154.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5498", "1", "admin8576", "2015-12-30 19:35:27", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5499", "1", "admin8576", "2015-12-30 19:35:28", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5500", "2", "admin5748", "2015-12-30 19:35:29", "195.154.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5501", "0", "Admin", "2016-01-05 04:33:41", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5502", "1", "admin8576", "2016-01-05 19:54:53", "216.17.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5503", "1", "admin8576", "2016-01-06 03:56:12", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5504", "1", "admin8576", "2016-01-06 11:50:46", "5.39.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5505", "1", "admin8576", "2016-01-06 12:12:08", "27.255.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5506", "1", "admin8576", "2016-01-06 12:12:09", "27.255.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5507", "1", "admin8576", "2016-01-06 12:12:10", "27.255.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5508", "1", "admin8576", "2016-01-06 20:07:57", "162.247.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5509", "1", "admin8576", "2016-01-07 04:19:48", "198.50.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5510", "1", "admin8576", "2016-01-07 12:04:43", "91.219.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5511", "1", "admin8576", "2016-01-07 20:08:53", "188.120.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5512", "1", "admin8576", "2016-01-08 03:56:28", "212.83.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5513", "1", "admin8576", "2016-01-08 11:19:55", "81.7.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5514", "1", "admin8576", "2016-01-08 18:55:02", "37.187.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5515", "1", "admin8576", "2016-01-10 17:11:36", "193.33.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5516", "1", "admin8576", "2016-01-11 00:47:05", "217.147.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5517", "1", "admin8576", "2016-01-11 16:35:02", "185.104.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5518", "1", "admin8576", "2016-01-12 01:02:20", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5519", "1", "admin8576", "2016-01-12 09:02:54", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5520", "1", "admin8576", "2016-01-13 02:01:08", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5521", "1", "admin8576", "2016-01-13 10:18:37", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5522", "1", "admin8576", "2016-01-13 16:54:19", "37.203.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5523", "1", "admin8576", "2016-01-13 16:54:19", "37.203.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5524", "1", "admin8576", "2016-01-13 16:54:20", "37.203.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5525", "1", "admin8576", "2016-01-13 16:54:20", "37.203.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5526", "1", "admin8576", "2016-01-13 18:59:38", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5527", "1", "admin8576", "2016-01-14 04:18:05", "185.100.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5528", "1", "admin8576", "2016-01-14 13:04:11", "212.117.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5529", "1", "admin8576", "2016-01-14 21:54:27", "195.22.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5530", "1", "admin8576", "2016-01-15 06:28:04", "94.242.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5531", "1", "admin8576", "2016-01-15 15:08:46", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5532", "1", "admin8576", "2016-01-15 23:52:44", "89.234.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5533", "1", "admin8576", "2016-01-16 08:18:14", "85.17.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5534", "1", "admin8576", "2016-01-16 16:52:12", "66.230.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5535", "1", "admin8576", "2016-01-17 01:34:35", "217.115.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5536", "1", "admin8576", "2016-01-17 09:38:07", "93.174.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5537", "1", "admin8576", "2016-01-17 17:44:49", "176.123.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5538", "1", "admin8576", "2016-01-18 01:57:44", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5539", "1", "admin8576", "2016-01-18 09:45:59", "176.10.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5540", "1", "admin8576", "2016-01-18 17:45:53", "62.102.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5541", "1", "admin8576", "2016-01-19 02:00:30", "162.221.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5542", "1", "admin8576", "2016-01-19 06:25:00", "62.210.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5543", "1", "admin8576", "2016-01-19 06:25:01", "62.210.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5544", "2", "admin5748", "2016-01-19 06:25:02", "62.210.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5545", "1", "admin8576", "2016-01-19 09:51:54", "93.115.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5546", "1", "admin8576", "2016-01-19 18:26:21", "69.162.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5547", "0", "Admin", "2016-01-19 23:31:42", "195.154.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5548", "1", "admin8576", "2016-01-20 10:37:49", "35.0.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5549", "0", "Admin", "2016-01-20 12:26:41", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5550", "1", "admin8576", "2016-01-20 19:15:20", "85.93.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5551", "1", "admin8576", "2016-01-21 03:43:49", "62.210.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5552", "1", "admin8576", "2016-01-21 11:55:38", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5553", "1", "admin8576", "2016-01-21 20:26:33", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5554", "1", "admin8576", "2016-01-22 04:45:11", "5.199.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5555", "1", "admin8576", "2016-01-22 12:51:05", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5556", "1", "admin8576", "2016-01-22 16:58:48", "62.210.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5557", "1", "admin8576", "2016-01-22 16:58:49", "62.210.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5558", "2", "admin5748", "2016-01-22 16:58:50", "62.210.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5559", "1", "admin8576", "2016-01-22 21:19:46", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5560", "1", "admin8576", "2016-01-23 05:29:29", "193.171.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5561", "1", "admin8576", "2016-01-23 13:16:17", "212.21.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5562", "0", "Admin", "2016-01-23 15:26:53", "195.154.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5563", "1", "admin8576", "2016-01-23 21:28:42", "37.48.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5564", "1", "admin8576", "2016-01-24 05:42:00", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5565", "1", "admin8576", "2016-01-24 13:33:50", "85.25.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5566", "1", "admin8576", "2016-01-24 21:43:18", "185.65.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5567", "1", "admin8576", "2016-01-25 13:37:40", "91.219.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5568", "1", "admin8576", "2016-01-25 22:20:09", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5569", "1", "admin8576", "2016-01-26 06:46:26", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5570", "0", "admin", "2016-01-26 15:05:18", "175.44.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5571", "1", "admin8576", "2016-01-26 15:06:31", "109.163.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5572", "0", "admin", "2016-01-26 16:43:45", "112.111.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5573", "1", "admin8576", "2016-01-27 00:09:09", "178.217.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5574", "1", "admin8576", "2016-01-27 08:51:33", "193.171.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5575", "1", "admin8576", "2016-01-27 17:45:58", "171.25.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5576", "1", "admin8576", "2016-01-28 02:51:43", "193.90.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5577", "1", "admin8576", "2016-01-28 10:56:13", "204.85.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5578", "1", "admin8576", "2016-01-28 19:54:52", "195.154.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5579", "1", "admin8576", "2016-01-29 04:59:25", "185.104.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5580", "1", "admin8576", "2016-01-29 13:05:55", "199.127.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5581", "1", "admin8576", "2016-01-29 21:44:53", "185.104.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5582", "1", "admin8576", "2016-01-30 23:28:08", "77.247.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5583", "1", "admin8576", "2016-01-31 08:07:54", "185.17.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5584", "0", "admin", "2016-02-02 03:11:18", "118.193.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5585", "0", "Admin", "2016-02-04 10:49:11", "195.154.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5586", "0", "Admin", "2016-02-18 22:58:12", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5587", "0", "Admin", "2016-02-21 21:15:13", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5588", "1", "admin8576", "2016-02-23 17:35:23", "46.119.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5589", "1", "admin8576", "2016-02-23 17:35:27", "46.119.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5590", "1", "admin8576", "2016-02-23 17:35:31", "46.119.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5591", "0", "Admin", "2016-03-04 21:15:52", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5592", "1", "admin8576", "2016-03-08 03:31:29", "195.154.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5593", "1", "admin8576", "2016-03-08 03:31:31", "195.154.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5594", "1", "admin8576", "2016-03-08 03:31:35", "195.154.216.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5595", "1", "admin8576", "2016-03-10 12:27:06", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5596", "1", "admin8576", "2016-03-10 13:17:53", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5597", "1", "admin8576", "2016-03-10 14:10:27", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5598", "1", "admin8576", "2016-03-10 15:04:48", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5599", "1", "admin8576", "2016-03-10 15:58:42", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5600", "1", "admin8576", "2016-03-10 16:53:35", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5601", "1", "admin8576", "2016-03-10 17:48:23", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5602", "1", "admin8576", "2016-03-10 18:43:01", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5603", "1", "admin8576", "2016-03-10 19:38:18", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5604", "1", "admin8576", "2016-03-10 20:33:22", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5605", "1", "admin8576", "2016-03-10 21:26:32", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5606", "0", "Admin", "2016-03-10 21:40:33", "195.154.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5607", "1", "admin8576", "2016-03-10 22:18:17", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5608", "1", "admin8576", "2016-03-10 23:11:51", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5609", "1", "admin8576", "2016-03-11 00:06:11", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5610", "1", "admin8576", "2016-03-11 01:00:48", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5611", "1", "admin8576", "2016-03-11 01:58:20", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5612", "1", "admin8576", "2016-03-11 03:02:46", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5613", "1", "admin8576", "2016-03-11 04:06:52", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5614", "1", "admin8576", "2016-03-11 05:10:23", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5615", "1", "admin8576", "2016-03-11 06:13:56", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5616", "1", "admin8576", "2016-03-11 07:16:47", "54.172.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5617", "0", "Admin", "2016-03-13 00:03:51", "195.154.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5618", "1", "admin8576", "2016-03-14 23:10:02", "134.249.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5619", "1", "admin8576", "2016-03-14 23:10:29", "134.249.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5620", "1", "admin8576", "2016-03-14 23:10:57", "134.249.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5621", "0", "Admin", "2016-03-18 07:12:25", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5622", "0", "admin", "2016-03-18 18:46:04", "62.210.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5623", "0", "Admin", "2016-03-22 07:06:39", "195.154.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5624", "0", "admin", "2016-03-29 17:47:29", "13.92.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5625", "0", "admin", "2016-03-30 19:27:08", "13.92.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5626", "1", "admin8576", "2016-04-01 17:37:50", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5627", "1", "admin8576", "2016-04-01 18:16:48", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5628", "1", "admin8576", "2016-04-01 18:56:00", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5629", "1", "admin8576", "2016-04-01 19:35:02", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5630", "1", "admin8576", "2016-04-01 20:16:05", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5631", "1", "admin8576", "2016-04-01 20:58:50", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5632", "1", "admin8576", "2016-04-01 21:41:56", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5633", "1", "admin8576", "2016-04-01 22:24:12", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5634", "1", "admin8576", "2016-04-01 23:07:38", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5635", "1", "admin8576", "2016-04-01 23:49:44", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5636", "1", "admin8576", "2016-04-02 00:30:57", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5637", "1", "admin8576", "2016-04-02 01:13:00", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5638", "1", "admin8576", "2016-04-02 01:57:03", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5639", "1", "admin8576", "2016-04-02 02:39:56", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5640", "1", "admin8576", "2016-04-02 03:23:45", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5641", "1", "admin8576", "2016-04-02 04:08:38", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5642", "1", "admin8576", "2016-04-02 04:54:01", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5643", "1", "admin8576", "2016-04-02 05:40:17", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5644", "1", "admin8576", "2016-04-02 06:26:10", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5645", "1", "admin8576", "2016-04-02 07:11:36", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5646", "1", "admin8576", "2016-04-02 07:57:39", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5647", "1", "admin8576", "2016-04-02 08:43:20", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5648", "1", "admin8576", "2016-04-02 09:27:24", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5649", "1", "admin8576", "2016-04-02 10:12:35", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5650", "1", "admin8576", "2016-04-02 11:03:30", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5651", "1", "admin8576", "2016-04-02 11:49:24", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5652", "1", "admin8576", "2016-04-02 12:35:38", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5653", "1", "admin8576", "2016-04-02 13:22:23", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5654", "1", "admin8576", "2016-04-02 14:08:57", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5655", "1", "admin8576", "2016-04-02 14:54:15", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5656", "1", "admin8576", "2016-04-02 15:38:54", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5657", "1", "admin8576", "2016-04-02 16:33:30", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5658", "1", "admin8576", "2016-04-02 17:20:12", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5659", "1", "admin8576", "2016-04-02 18:06:27", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5660", "1", "admin8576", "2016-04-02 18:52:32", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5661", "1", "admin8576", "2016-04-02 19:37:58", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5662", "1", "admin8576", "2016-04-02 20:22:49", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5663", "1", "admin8576", "2016-04-02 21:08:09", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5664", "1", "admin8576", "2016-04-02 21:54:37", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5665", "1", "admin8576", "2016-04-02 22:41:16", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5666", "1", "admin8576", "2016-04-02 23:26:46", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5667", "1", "admin8576", "2016-04-03 00:13:02", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5668", "1", "admin8576", "2016-04-03 00:58:52", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5669", "1", "admin8576", "2016-04-03 01:38:52", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5670", "1", "admin8576", "2016-04-03 02:20:13", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5671", "1", "admin8576", "2016-04-03 03:02:32", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5672", "1", "admin8576", "2016-04-03 03:44:42", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5673", "1", "admin8576", "2016-04-03 04:25:32", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5674", "1", "admin8576", "2016-04-03 05:07:09", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5675", "1", "admin8576", "2016-04-03 05:48:38", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5676", "1", "admin8576", "2016-04-03 06:28:16", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5677", "1", "admin8576", "2016-04-03 07:06:58", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5678", "1", "admin8576", "2016-04-03 07:45:17", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5679", "1", "admin8576", "2016-04-03 08:25:43", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5680", "1", "admin8576", "2016-04-03 09:04:36", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5681", "1", "admin8576", "2016-04-03 09:42:20", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5682", "1", "admin8576", "2016-04-03 10:21:03", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5683", "1", "admin8576", "2016-04-03 11:02:34", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5684", "1", "admin8576", "2016-04-03 11:42:56", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5685", "1", "admin8576", "2016-04-03 12:21:42", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5686", "1", "admin8576", "2016-04-03 13:00:58", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5687", "1", "admin8576", "2016-04-03 13:41:05", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5688", "1", "admin8576", "2016-04-03 14:21:50", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5689", "1", "admin8576", "2016-04-03 15:02:41", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5690", "1", "admin8576", "2016-04-03 15:43:56", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5691", "1", "admin8576", "2016-04-03 16:27:05", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5692", "1", "admin8576", "2016-04-03 17:10:41", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5693", "1", "admin8576", "2016-04-03 17:52:54", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5694", "1", "admin8576", "2016-04-03 18:32:52", "52.62.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5695", "1", "admin8576", "2016-04-08 15:26:22", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5696", "1", "admin8576", "2016-04-08 15:26:23", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5697", "1", "admin8576", "2016-04-08 15:26:24", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5698", "1", "admin8576", "2016-04-12 06:12:49", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5699", "1", "admin8576", "2016-04-12 12:17:48", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5700", "1", "admin8576", "2016-04-12 19:40:35", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5701", "1", "admin8576", "2016-04-13 03:11:14", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5702", "1", "admin8576", "2016-04-13 10:49:27", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5703", "1", "admin8576", "2016-04-13 18:05:51", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5704", "1", "admin8576", "2016-04-14 01:29:25", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5705", "1", "admin8576", "2016-04-14 09:09:05", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5706", "1", "admin8576", "2016-04-14 16:47:49", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5707", "1", "admin8576", "2016-04-15 00:26:33", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5708", "1", "admin8576", "2016-04-15 08:03:25", "134.249.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5709", "1", "admin8576", "2016-04-15 14:30:09", "178.137.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5710", "1", "admin8576", "2016-04-15 20:33:24", "178.137.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5711", "1", "admin8576", "2016-04-16 02:41:32", "178.137.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5712", "1", "admin8576", "2016-04-16 07:17:41", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5713", "1", "admin8576", "2016-04-16 13:33:15", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5714", "1", "admin8576", "2016-04-16 19:51:03", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5715", "1", "admin8576", "2016-04-17 02:14:02", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5716", "1", "admin8576", "2016-04-17 08:36:09", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5717", "1", "admin8576", "2016-04-17 14:56:38", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5718", "1", "admin8576", "2016-04-17 18:42:54", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5719", "1", "admin8576", "2016-04-18 00:54:51", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5720", "1", "admin8576", "2016-04-18 07:04:13", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5721", "1", "admin8576", "2016-04-18 13:08:20", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5722", "1", "admin8576", "2016-04-18 19:25:39", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5723", "1", "admin8576", "2016-04-19 01:48:26", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5724", "1", "admin8576", "2016-04-19 08:21:08", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5725", "1", "admin8576", "2016-04-19 14:52:29", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5726", "1", "admin8576", "2016-04-19 21:26:52", "178.137.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5727", "1", "admin8576", "2016-04-20 03:33:19", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5728", "1", "admin8576", "2016-04-20 08:05:37", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5729", "1", "admin8576", "2016-04-20 13:05:57", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5730", "1", "admin8576", "2016-04-20 17:41:40", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5731", "1", "admin8576", "2016-04-21 00:12:13", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5732", "1", "admin8576", "2016-04-21 06:50:15", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5733", "1", "admin8576", "2016-04-21 13:23:06", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5734", "1", "admin8576", "2016-04-21 20:01:44", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5735", "0", "Admin", "2016-04-21 22:15:10", "195.154.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5736", "1", "admin8576", "2016-04-22 02:41:44", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5737", "1", "admin8576", "2016-04-22 09:22:53", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5738", "1", "admin8576", "2016-04-22 16:06:39", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5739", "1", "admin8576", "2016-04-22 22:45:34", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5740", "1", "admin8576", "2016-04-23 05:22:21", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5741", "1", "admin8576", "2016-04-23 11:53:51", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5742", "1", "admin8576", "2016-04-23 18:25:02", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5743", "1", "admin8576", "2016-04-24 00:56:28", "178.137.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5744", "1", "admin8576", "2016-04-24 06:33:50", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5745", "1", "admin8576", "2016-04-24 12:34:06", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5746", "1", "admin8576", "2016-04-24 18:47:10", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5747", "1", "admin8576", "2016-04-25 01:19:53", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5748", "1", "admin8576", "2016-04-25 07:52:10", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5749", "1", "admin8576", "2016-04-25 14:19:08", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5750", "1", "admin8576", "2016-04-25 20:41:43", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5751", "1", "admin8576", "2016-04-26 03:08:14", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5752", "1", "admin8576", "2016-04-26 06:59:14", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5753", "1", "admin8576", "2016-04-26 12:09:56", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5754", "1", "admin8576", "2016-04-26 18:32:32", "178.137.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5755", "1", "admin8576", "2016-04-27 06:24:52", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5756", "1", "admin8576", "2016-04-27 12:37:57", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5757", "1", "admin8576", "2016-04-27 18:53:21", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5758", "1", "admin8576", "2016-04-28 01:02:44", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5759", "1", "admin8576", "2016-04-28 06:12:47", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5760", "2", "admin5748", "2016-04-28 10:13:39", "82.207.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5761", "1", "admin8576", "2016-04-28 10:24:06", "94.29.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5762", "2", "admin5748", "2016-04-28 10:39:42", "42.112.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5763", "2", "admin5748", "2016-04-28 10:44:40", "83.139.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5764", "1", "admin8576", "2016-04-28 10:53:09", "185.17.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5765", "1", "admin8576", "2016-04-28 10:56:52", "113.161.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5766", "1", "admin8576", "2016-04-28 11:04:35", "117.3.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5767", "2", "admin5748", "2016-04-28 11:19:25", "113.166.185.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5768", "1", "admin8576", "2016-04-28 11:33:10", "62.133.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5769", "2", "admin5748", "2016-04-28 11:42:23", "115.77.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5770", "1", "admin8576", "2016-04-28 11:42:48", "2.62.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5771", "2", "admin5748", "2016-04-28 12:05:11", "46.180.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5772", "1", "admin8576", "2016-04-28 14:09:49", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5773", "1", "admin8576", "2016-04-28 18:03:48", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5774", "1", "admin8576", "2016-04-29 00:20:14", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5775", "1", "admin8576", "2016-04-29 06:40:18", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5776", "1", "admin8576", "2016-04-29 12:55:16", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5777", "1", "admin8576", "2016-04-29 19:00:24", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5778", "1", "admin8576", "2016-04-30 01:14:45", "46.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5779", "1", "admin8576", "2016-04-30 07:33:54", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5780", "1", "admin8576", "2016-04-30 12:44:38", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5781", "1", "admin8576", "2016-04-30 18:17:10", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5782", "1", "admin8576", "2016-05-01 00:15:23", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5783", "1", "admin8576", "2016-05-01 06:43:27", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5784", "1", "admin8576", "2016-05-01 12:43:07", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5785", "1", "admin8576", "2016-05-01 19:05:53", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5786", "1", "admin8576", "2016-05-02 01:13:30", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5787", "1", "admin8576", "2016-05-02 07:12:35", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5788", "1", "admin8576", "2016-05-02 13:09:29", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5789", "1", "admin8576", "2016-05-02 19:01:58", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5790", "1", "admin8576", "2016-05-03 01:10:41", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5791", "1", "admin8576", "2016-05-03 06:26:16", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5792", "1", "admin8576", "2016-05-03 12:16:55", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5793", "1", "admin8576", "2016-05-03 18:40:20", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5794", "1", "admin8576", "2016-05-04 01:00:43", "46.118.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5795", "1", "admin8576", "2016-05-04 05:38:00", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5796", "1", "admin8576", "2016-05-04 10:47:40", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5797", "1", "admin8576", "2016-05-04 16:02:23", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5798", "1", "admin8576", "2016-05-04 21:10:37", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5799", "1", "admin8576", "2016-05-05 02:22:02", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5800", "0", "Admin", "2016-05-05 03:11:20", "195.154.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5801", "1", "admin8576", "2016-05-05 08:05:14", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5802", "1", "admin8576", "2016-05-05 13:30:52", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5803", "1", "admin8576", "2016-05-05 18:48:18", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5804", "1", "admin8576", "2016-05-06 00:05:29", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5805", "1", "admin8576", "2016-05-06 05:20:28", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5806", "1", "admin8576", "2016-05-06 10:37:13", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5807", "1", "admin8576", "2016-05-06 15:40:00", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5808", "1", "admin8576", "2016-05-06 20:50:30", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5809", "1", "admin8576", "2016-05-07 02:53:55", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5810", "1", "admin8576", "2016-05-07 08:36:14", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5811", "1", "admin8576", "2016-05-07 13:51:30", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5812", "1", "admin8576", "2016-05-07 19:28:07", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5813", "1", "admin8576", "2016-05-08 01:00:35", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5814", "1", "admin8576", "2016-05-08 06:57:44", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5815", "1", "admin8576", "2016-05-08 12:37:16", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5816", "1", "admin8576", "2016-05-08 18:06:33", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5817", "1", "admin8576", "2016-05-08 23:29:51", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5818", "1", "admin8576", "2016-05-09 04:06:49", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5819", "1", "admin8576", "2016-05-09 09:49:46", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5820", "1", "admin8576", "2016-05-09 16:16:48", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5821", "1", "admin8576", "2016-05-09 22:35:47", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5822", "1", "admin8576", "2016-05-10 05:11:27", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5823", "1", "admin8576", "2016-05-10 10:59:24", "178.137.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5824", "0", "admin8568", "2016-05-11 13:04:56", "196.210.62.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5825", "0", "author", "2016-05-16 12:49:35", "90.150.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5826", "0", "editor", "2016-05-16 13:04:16", "113.188.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5827", "1", "admin8576", "2016-05-19 00:01:13", "89.163.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5828", "1", "admin8576", "2016-05-19 00:01:14", "89.163.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5829", "1", "admin8576", "2016-05-19 00:01:14", "89.163.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5830", "0", "Admin", "2016-05-23 16:23:01", "195.154.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5831", "2", "admin5748", "2016-05-25 14:39:41", "115.74.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5832", "1", "admin8576", "2016-05-25 14:42:02", "88.249.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5833", "2", "admin5748", "2016-05-25 14:49:44", "115.76.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5834", "1", "admin8576", "2016-05-25 14:53:42", "83.240.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5835", "1", "admin8576", "2016-05-25 15:09:03", "93.185.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5836", "2", "admin5748", "2016-05-25 15:09:55", "41.107.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5837", "2", "admin5748", "2016-05-25 15:27:15", "14.186.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5838", "1", "admin8576", "2016-05-25 15:34:47", "123.26.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5839", "1", "admin8576", "2016-05-25 16:36:32", "14.207.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5840", "2", "admin5748", "2016-05-25 16:48:32", "58.186.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5841", "1", "admin8576", "2016-05-25 17:36:18", "14.181.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5842", "2", "admin5748", "2016-05-25 17:38:37", "37.79.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5843", "1", "admin8576", "2016-05-25 17:42:58", "186.60.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5844", "2", "admin5748", "2016-05-25 18:25:29", "14.160.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5845", "2", "admin5748", "2016-05-25 18:42:31", "46.0.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5846", "1", "admin8576", "2016-05-25 19:00:50", "109.169.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5847", "1", "admin8576", "2016-05-25 19:07:47", "89.232.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5848", "2", "admin5748", "2016-05-25 19:12:38", "91.237.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5849", "1", "admin8576", "2016-05-28 07:36:12", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5850", "1", "admin8576", "2016-05-28 08:04:10", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5851", "1", "admin8576", "2016-05-28 08:32:42", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5852", "1", "admin8576", "2016-05-28 09:01:18", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5853", "1", "admin8576", "2016-05-28 09:30:22", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5854", "1", "admin8576", "2016-05-28 09:59:24", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5855", "1", "admin8576", "2016-06-01 10:31:36", "195.208.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5856", "1", "admin8576", "2016-06-01 10:31:37", "195.208.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5857", "1", "admin8576", "2016-06-01 10:31:37", "195.208.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5858", "1", "admin8576", "2016-06-06 19:17:58", "103.249.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5859", "1", "admin8576", "2016-06-06 19:17:59", "103.249.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5860", "1", "admin8576", "2016-06-06 19:18:00", "103.249.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5861", "0", "Admin", "2016-06-12 05:21:01", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5862", "1", "admin8576", "2016-06-12 10:22:46", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5863", "1", "admin8576", "2016-06-12 10:22:47", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5864", "1", "admin8576", "2016-06-14 04:10:29", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5865", "1", "admin8576", "2016-06-14 04:10:30", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5866", "1", "admin8576", "2016-06-15 23:51:54", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5867", "1", "admin8576", "2016-06-15 23:51:55", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5868", "1", "admin8576", "2016-06-17 19:43:55", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5869", "1", "admin8576", "2016-06-17 19:43:56", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5870", "1", "admin8576", "2016-06-19 15:14:44", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5871", "1", "admin8576", "2016-06-19 15:14:45", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5872", "1", "admin8576", "2016-06-21 11:01:37", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5873", "1", "admin8576", "2016-06-21 11:01:38", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5874", "0", "admin", "2016-06-21 20:02:01", "216.45.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5875", "0", "admin", "2016-06-21 20:02:02", "216.45.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5876", "0", "admin", "2016-06-21 20:02:03", "216.45.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5877", "0", "Admin", "2016-06-25 06:54:57", "195.154.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5878", "1", "admin8576", "2016-06-29 22:43:26", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5879", "1", "admin8576", "2016-06-29 22:43:27", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5880", "1", "admin8576", "2016-07-02 05:53:59", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5881", "1", "admin8576", "2016-07-02 05:54:00", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5882", "0", "magmainc", "2016-07-05 05:48:39", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5883", "0", "admin", "2016-07-05 12:00:33", "197.96.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5884", "0", "magmainc", "2016-07-11 02:52:48", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5885", "1", "admin8576", "2016-07-11 09:40:02", "107.152.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5886", "1", "admin8576", "2016-07-11 09:43:38", "107.152.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5887", "1", "admin8576", "2016-07-11 09:46:49", "107.152.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5888", "0", "magmainc", "2016-07-14 16:33:51", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5889", "0", "wpupdatestream", "2016-07-16 01:17:39", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5890", "1", "admin8576", "2016-07-17 01:35:11", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5891", "1", "admin8576", "2016-07-17 01:35:18", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5892", "1", "admin8576", "2016-07-17 03:28:10", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5893", "1", "admin8576", "2016-07-17 03:28:11", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5894", "1", "admin8576", "2016-07-17 05:20:52", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5895", "1", "admin8576", "2016-07-17 05:20:54", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5896", "0", "magmainc", "2016-07-17 07:38:50", "91.200.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5897", "0", "magmainc", "2016-07-18 09:05:35", "193.201.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5898", "1", "admin8576", "2016-07-23 10:31:14", "142.54.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5899", "1", "admin8576", "2016-07-23 10:31:15", "142.54.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5900", "2", "admin5748", "2016-07-23 10:31:16", "142.54.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5901", "1", "admin8576", "2016-07-25 23:49:35", "109.228.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5902", "1", "admin8576", "2016-07-25 23:49:36", "109.228.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5903", "1", "admin8576", "2016-07-25 23:49:37", "109.228.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5904", "1", "admin8576", "2016-07-29 05:40:28", "122.28.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5905", "1", "admin8576", "2016-07-29 05:40:29", "122.28.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5906", "1", "admin8576", "2016-07-29 05:40:30", "122.28.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5907", "1", "admin8576", "2016-08-03 22:47:40", "212.83.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5908", "1", "admin8576", "2016-08-03 22:47:41", "212.83.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5909", "1", "admin8576", "2016-08-03 22:47:42", "212.83.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5910", "0", "Admin", "2016-08-04 14:07:26", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5911", "1", "admin8576", "2016-08-11 17:35:15", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5912", "1", "admin8576", "2016-08-11 17:35:15", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5913", "2", "admin5748", "2016-08-11 17:35:16", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5914", "1", "admin8576", "2016-08-12 00:48:10", "67.243.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5915", "1", "admin8576", "2016-08-12 01:00:27", "68.57.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5916", "1", "admin8576", "2016-08-12 01:19:55", "213.168.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5917", "1", "admin8576", "2016-08-12 01:21:06", "88.246.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5918", "1", "admin8576", "2016-08-12 01:21:39", "71.87.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5919", "1", "admin8576", "2016-08-12 01:45:08", "106.216.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5920", "1", "admin8576", "2016-08-12 01:46:06", "49.175.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5921", "1", "admin8576", "2016-08-12 01:49:56", "177.91.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5922", "1", "admin8576", "2016-08-12 01:50:17", "180.248.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5923", "1", "admin8576", "2016-08-12 01:56:28", "101.100.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5924", "1", "admin8576", "2016-08-12 02:02:20", "109.255.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5925", "1", "admin8576", "2016-08-12 02:02:27", "82.123.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5926", "1", "admin8576", "2016-08-12 02:02:50", "47.55.190.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5927", "1", "admin8576", "2016-08-12 02:04:04", "122.178.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5928", "1", "admin8576", "2016-08-12 02:11:49", "112.208.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5929", "1", "admin8576", "2016-08-12 02:12:19", "154.126.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5930", "1", "admin8576", "2016-08-12 02:13:10", "103.233.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5931", "1", "admin8576", "2016-08-12 02:13:30", "182.227.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5932", "1", "admin8576", "2016-08-12 02:17:58", "73.238.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5933", "1", "admin8576", "2016-08-12 02:19:45", "84.109.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5934", "1", "admin8576", "2016-08-12 02:20:35", "112.198.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5935", "1", "admin8576", "2016-08-12 02:22:48", "98.165.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5936", "1", "admin8576", "2016-08-12 02:26:18", "80.87.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5937", "1", "admin8576", "2016-08-12 02:36:35", "109.66.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5938", "1", "admin8576", "2016-08-12 03:08:02", "101.180.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5939", "1", "admin8576", "2016-08-12 03:11:00", "219.248.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5940", "1", "admin8576", "2016-08-12 03:11:08", "5.36.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5941", "1", "admin8576", "2016-08-12 03:12:07", "27.131.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5942", "1", "admin8576", "2016-08-12 03:14:29", "72.184.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5943", "1", "admin8576", "2016-08-12 03:34:20", "5.31.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5944", "1", "admin8576", "2016-08-12 03:34:48", "195.174.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5945", "1", "admin8576", "2016-08-12 03:36:51", "86.97.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5946", "1", "admin8576", "2016-08-12 03:45:41", "108.161.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5947", "1", "admin8576", "2016-08-12 03:50:34", "41.105.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5948", "1", "admin8576", "2016-08-12 03:51:54", "49.148.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5949", "1", "admin8576", "2016-08-12 03:52:40", "190.161.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5950", "1", "admin8576", "2016-08-12 03:56:20", "121.54.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5951", "1", "admin8576", "2016-08-12 04:02:27", "114.108.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5952", "1", "admin8576", "2016-08-12 04:08:22", "154.97.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5953", "1", "admin8576", "2016-08-12 04:14:01", "123.217.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5954", "1", "admin8576", "2016-08-12 04:16:26", "94.126.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5955", "1", "admin8576", "2016-08-12 04:17:50", "188.25.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5956", "1", "admin8576", "2016-08-12 04:18:12", "176.92.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5957", "1", "admin8576", "2016-08-12 04:22:45", "186.93.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5958", "1", "admin8576", "2016-08-12 04:28:02", "112.205.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5959", "1", "admin8576", "2016-08-12 04:33:54", "108.191.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5960", "1", "admin8576", "2016-08-12 04:35:42", "186.179.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5961", "1", "admin8576", "2016-08-12 04:36:06", "49.175.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5962", "1", "admin8576", "2016-08-12 04:36:29", "103.242.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5963", "1", "admin8576", "2016-08-12 04:40:03", "5.60.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5964", "1", "admin8576", "2016-08-12 04:41:19", "138.36.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5965", "1", "admin8576", "2016-08-12 04:46:55", "123.248.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5966", "1", "admin8576", "2016-08-12 04:57:18", "152.231.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5967", "1", "admin8576", "2016-08-12 05:03:45", "105.101.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5968", "1", "admin8576", "2016-08-12 05:03:45", "91.12.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5969", "1", "admin8576", "2016-08-12 05:03:55", "190.136.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5970", "1", "admin8576", "2016-08-12 05:06:25", "200.120.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5971", "1", "admin8576", "2016-08-12 05:12:34", "173.169.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5972", "1", "admin8576", "2016-08-12 05:15:22", "54.171.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5973", "1", "admin8576", "2016-08-12 05:22:36", "216.66.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5974", "1", "admin8576", "2016-08-12 05:23:48", "85.55.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5975", "1", "admin8576", "2016-08-12 05:29:29", "185.37.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5976", "1", "admin8576", "2016-08-12 05:30:25", "112.203.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5977", "1", "admin8576", "2016-08-12 05:33:49", "181.213.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5978", "1", "admin8576", "2016-08-12 05:34:48", "49.148.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5979", "1", "admin8576", "2016-08-12 05:35:03", "49.148.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5980", "1", "admin8576", "2016-08-12 05:39:58", "89.181.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5981", "1", "admin8576", "2016-08-12 05:44:34", "36.39.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5982", "1", "admin8576", "2016-08-12 05:46:46", "223.205.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5983", "1", "admin8576", "2016-08-12 05:46:51", "5.36.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5984", "1", "admin8576", "2016-08-12 05:53:30", "197.89.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5985", "1", "admin8576", "2016-08-12 06:00:12", "186.138.167.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5986", "1", "admin8576", "2016-08-12 06:01:44", "220.126.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5987", "1", "admin8576", "2016-08-12 06:04:46", "41.202.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5988", "1", "admin8576", "2016-08-12 06:07:04", "115.66.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5989", "1", "admin8576", "2016-08-12 06:09:07", "112.204.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5990", "1", "admin8576", "2016-08-12 06:09:18", "168.1.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5991", "1", "admin8576", "2016-08-12 06:14:22", "41.87.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5992", "1", "admin8576", "2016-08-12 06:17:24", "190.56.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5993", "1", "admin8576", "2016-08-12 06:18:37", "117.214.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5994", "1", "admin8576", "2016-08-12 06:26:47", "59.177.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5995", "1", "admin8576", "2016-08-12 06:30:09", "81.44.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5996", "1", "admin8576", "2016-08-12 06:30:52", "201.170.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5997", "1", "admin8576", "2016-08-12 06:48:41", "95.21.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5998", "1", "admin8576", "2016-08-12 06:51:58", "150.242.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("5999", "1", "admin8576", "2016-08-12 06:53:59", "41.218.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6000", "1", "admin8576", "2016-08-12 06:54:23", "180.191.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6001", "1", "admin8576", "2016-08-12 06:55:51", "190.207.15.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6002", "1", "admin8576", "2016-08-12 06:57:09", "124.106.143.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6003", "1", "admin8576", "2016-08-12 06:58:42", "84.186.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6004", "1", "admin8576", "2016-08-12 07:10:35", "139.218.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6005", "1", "admin8576", "2016-08-12 07:11:15", "187.151.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6006", "1", "admin8576", "2016-08-12 07:11:43", "113.130.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6007", "1", "admin8576", "2016-08-12 07:16:05", "175.205.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6008", "1", "admin8576", "2016-08-12 07:17:35", "93.84.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6009", "1", "admin8576", "2016-08-12 07:22:19", "211.129.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6010", "1", "admin8576", "2016-08-12 07:28:18", "112.198.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6011", "1", "admin8576", "2016-08-12 07:29:21", "27.34.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6012", "1", "admin8576", "2016-08-12 07:49:45", "45.115.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6013", "1", "admin8576", "2016-08-12 07:53:23", "180.244.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6014", "1", "admin8576", "2016-08-12 07:53:51", "5.156.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6015", "1", "admin8576", "2016-08-12 07:55:15", "105.98.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6016", "1", "admin8576", "2016-08-12 07:57:10", "49.32.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6017", "1", "admin8576", "2016-08-12 07:57:26", "89.216.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6018", "1", "admin8576", "2016-08-12 07:58:36", "122.15.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6019", "1", "admin8576", "2016-08-12 08:07:51", "5.29.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6020", "1", "admin8576", "2016-08-12 08:12:10", "45.248.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6021", "1", "admin8576", "2016-08-12 08:12:15", "79.101.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6022", "1", "admin8576", "2016-08-12 08:12:54", "5.22.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6023", "1", "admin8576", "2016-08-12 08:13:28", "115.161.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6024", "1", "admin8576", "2016-08-12 08:16:04", "70.112.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6025", "1", "admin8576", "2016-08-12 08:27:42", "124.104.230.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6026", "1", "admin8576", "2016-08-12 08:37:02", "24.1.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6027", "1", "admin8576", "2016-08-12 08:38:10", "110.139.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6028", "1", "admin8576", "2016-08-12 08:38:45", "114.143.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6029", "1", "admin8576", "2016-08-12 08:47:10", "101.255.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6030", "1", "admin8576", "2016-08-12 08:48:16", "39.37.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6031", "1", "admin8576", "2016-08-12 08:51:53", "109.93.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6032", "1", "admin8576", "2016-08-12 08:57:14", "121.97.112.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6033", "1", "admin8576", "2016-08-12 08:58:46", "93.171.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6034", "1", "admin8576", "2016-08-12 09:01:20", "49.32.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6035", "1", "admin8576", "2016-08-12 09:02:03", "84.252.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6036", "1", "admin8576", "2016-08-12 09:02:39", "112.201.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6037", "1", "admin8576", "2016-08-12 09:03:34", "182.58.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6038", "1", "admin8576", "2016-08-12 09:12:37", "43.229.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6039", "1", "admin8576", "2016-08-12 09:13:38", "125.17.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6040", "1", "admin8576", "2016-08-12 09:14:51", "59.180.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6041", "1", "admin8576", "2016-08-12 09:20:01", "2.51.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6042", "1", "admin8576", "2016-08-12 09:24:17", "209.140.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6043", "1", "admin8576", "2016-08-12 09:24:33", "124.105.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6044", "1", "admin8576", "2016-08-12 09:27:10", "79.106.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6045", "1", "admin8576", "2016-08-12 09:30:23", "110.21.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6046", "1", "admin8576", "2016-08-12 09:30:49", "179.105.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6047", "1", "admin8576", "2016-08-12 09:34:10", "5.206.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6048", "1", "admin8576", "2016-08-12 09:34:51", "108.251.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6049", "1", "admin8576", "2016-08-12 09:37:07", "121.176.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6050", "1", "admin8576", "2016-08-12 09:37:24", "112.204.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6051", "1", "admin8576", "2016-08-12 09:39:47", "103.12.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6052", "1", "admin8576", "2016-08-12 09:44:20", "112.209.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6053", "1", "admin8576", "2016-08-12 09:45:20", "82.10.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6054", "1", "admin8576", "2016-08-12 09:46:07", "73.153.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6055", "1", "admin8576", "2016-08-12 09:49:01", "49.206.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6056", "1", "admin8576", "2016-08-12 09:52:03", "93.140.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6057", "1", "admin8576", "2016-08-12 09:52:38", "122.254.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6058", "1", "admin8576", "2016-08-12 09:55:44", "175.100.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6059", "1", "admin8576", "2016-08-12 09:57:27", "105.225.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6060", "1", "admin8576", "2016-08-12 09:58:35", "92.209.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6061", "1", "admin8576", "2016-08-12 09:58:44", "222.235.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6062", "1", "admin8576", "2016-08-12 10:02:47", "24.112.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6063", "1", "admin8576", "2016-08-12 10:05:19", "178.152.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6064", "1", "admin8576", "2016-08-12 10:05:36", "31.168.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6065", "1", "admin8576", "2016-08-12 10:07:44", "116.68.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6066", "1", "admin8576", "2016-08-12 10:09:22", "75.166.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6067", "1", "admin8576", "2016-08-12 10:11:02", "14.52.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6068", "1", "admin8576", "2016-08-12 10:12:45", "125.22.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6069", "1", "admin8576", "2016-08-12 10:15:58", "139.190.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6070", "1", "admin8576", "2016-08-12 10:18:57", "90.0.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6071", "1", "admin8576", "2016-08-12 10:18:59", "94.118.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6072", "1", "admin8576", "2016-08-12 10:19:04", "188.135.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6073", "1", "admin8576", "2016-08-12 10:20:17", "217.11.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6074", "1", "admin8576", "2016-08-12 10:20:51", "89.210.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6075", "1", "admin8576", "2016-08-12 10:21:39", "103.232.25.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6076", "1", "admin8576", "2016-08-12 10:22:36", "187.207.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6077", "1", "admin8576", "2016-08-12 10:25:17", "83.101.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6078", "1", "admin8576", "2016-08-12 10:27:38", "1.223.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6079", "1", "admin8576", "2016-08-12 10:34:27", "39.40.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6080", "1", "admin8576", "2016-08-12 10:36:36", "120.63.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6081", "1", "admin8576", "2016-08-12 10:37:21", "115.124.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6082", "1", "admin8576", "2016-08-12 10:37:36", "23.114.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6083", "1", "admin8576", "2016-08-12 10:39:26", "88.246.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6084", "1", "admin8576", "2016-08-12 10:42:30", "86.137.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6085", "1", "admin8576", "2016-08-12 10:42:37", "62.245.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6086", "1", "admin8576", "2016-08-12 10:43:06", "79.106.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6087", "1", "admin8576", "2016-08-12 10:43:28", "201.196.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6088", "1", "admin8576", "2016-08-12 10:43:29", "85.154.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6089", "1", "admin8576", "2016-08-12 10:45:00", "39.46.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6090", "1", "admin8576", "2016-08-12 10:45:24", "103.55.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6091", "1", "admin8576", "2016-08-12 10:45:49", "2.86.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6092", "1", "admin8576", "2016-08-12 10:47:53", "71.191.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6093", "1", "admin8576", "2016-08-12 10:48:46", "119.2.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6094", "1", "admin8576", "2016-08-12 10:53:38", "180.149.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6095", "1", "admin8576", "2016-08-12 10:55:40", "203.215.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6096", "1", "admin8576", "2016-08-12 10:57:52", "93.117.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6097", "1", "admin8576", "2016-08-12 11:00:16", "39.63.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6098", "1", "admin8576", "2016-08-12 11:02:16", "27.89.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6099", "1", "admin8576", "2016-08-12 11:09:56", "91.206.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6100", "1", "admin8576", "2016-08-12 11:13:57", "88.128.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6101", "1", "admin8576", "2016-08-12 11:17:31", "115.134.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6102", "1", "admin8576", "2016-08-12 11:19:59", "202.131.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6103", "1", "admin8576", "2016-08-12 11:23:34", "105.186.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6104", "1", "admin8576", "2016-08-12 11:25:20", "91.240.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6105", "1", "admin8576", "2016-08-12 11:27:51", "117.248.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6106", "1", "admin8576", "2016-08-12 11:33:14", "81.82.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6107", "1", "admin8576", "2016-08-12 11:34:34", "49.38.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6108", "1", "admin8576", "2016-08-12 11:35:43", "183.83.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6109", "1", "admin8576", "2016-08-12 11:36:15", "31.216.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6110", "1", "admin8576", "2016-08-12 11:39:10", "43.247.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6111", "1", "admin8576", "2016-08-12 11:45:48", "196.201.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6112", "1", "admin8576", "2016-08-12 11:49:10", "112.133.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6113", "1", "admin8576", "2016-08-12 11:49:21", "83.79.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6114", "1", "admin8576", "2016-08-12 11:52:28", "203.30.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6115", "1", "admin8576", "2016-08-12 11:55:37", "124.125.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6116", "1", "admin8576", "2016-08-12 11:55:52", "103.39.29.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6117", "1", "admin8576", "2016-08-12 11:58:43", "178.222.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6118", "1", "admin8576", "2016-08-12 12:00:00", "5.22.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6119", "1", "admin8576", "2016-08-12 12:00:46", "51.6.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6120", "1", "admin8576", "2016-08-12 12:02:24", "123.252.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6121", "1", "admin8576", "2016-08-12 12:03:21", "80.100.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6122", "1", "admin8576", "2016-08-12 12:05:15", "178.253.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6123", "1", "admin8576", "2016-08-12 12:08:30", "188.211.22.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6124", "1", "admin8576", "2016-08-12 12:09:14", "41.250.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6125", "1", "admin8576", "2016-08-12 12:11:45", "114.143.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6126", "1", "admin8576", "2016-08-12 12:12:27", "185.66.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6127", "1", "admin8576", "2016-08-12 12:15:41", "87.6.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6128", "1", "admin8576", "2016-08-12 12:18:38", "41.222.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6129", "1", "admin8576", "2016-08-12 12:19:50", "183.83.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6130", "1", "admin8576", "2016-08-12 12:21:57", "197.149.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6131", "1", "admin8576", "2016-08-12 12:23:12", "213.122.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6132", "1", "admin8576", "2016-08-12 12:24:15", "59.100.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6133", "1", "admin8576", "2016-08-12 12:24:54", "111.119.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6134", "1", "admin8576", "2016-08-12 12:28:20", "210.89.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6135", "1", "admin8576", "2016-08-12 12:29:28", "41.100.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6136", "1", "admin8576", "2016-08-12 12:32:46", "78.173.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6137", "1", "admin8576", "2016-08-12 12:36:18", "188.27.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6138", "1", "admin8576", "2016-08-12 12:37:55", "84.194.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6139", "1", "admin8576", "2016-08-12 12:41:23", "36.79.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6140", "1", "admin8576", "2016-08-12 12:41:38", "186.109.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6141", "1", "admin8576", "2016-08-12 12:44:41", "109.199.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6142", "1", "admin8576", "2016-08-12 12:52:49", "76.73.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6143", "1", "admin8576", "2016-08-12 12:54:32", "108.61.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6144", "1", "admin8576", "2016-08-12 12:56:32", "188.252.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6145", "1", "admin8576", "2016-08-12 12:58:59", "95.18.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6146", "1", "admin8576", "2016-08-12 13:00:32", "91.191.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6147", "1", "admin8576", "2016-08-12 13:10:44", "89.181.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6148", "1", "admin8576", "2016-08-12 13:12:42", "99.239.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6149", "1", "admin8576", "2016-08-12 13:13:59", "78.172.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6150", "1", "admin8576", "2016-08-12 13:14:15", "101.191.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6151", "1", "admin8576", "2016-08-12 13:15:08", "59.180.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6152", "1", "admin8576", "2016-08-12 13:15:33", "78.57.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6153", "1", "admin8576", "2016-08-12 13:19:38", "171.4.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6154", "1", "admin8576", "2016-08-12 13:20:51", "179.53.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6155", "1", "admin8576", "2016-08-12 13:21:46", "76.173.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6156", "1", "admin8576", "2016-08-12 13:25:50", "1.22.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6157", "1", "admin8576", "2016-08-12 13:26:50", "213.57.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6158", "1", "admin8576", "2016-08-12 13:30:47", "182.48.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6159", "1", "admin8576", "2016-08-12 13:31:21", "59.177.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6160", "1", "admin8576", "2016-08-12 13:34:29", "93.115.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6161", "1", "admin8576", "2016-08-12 13:34:59", "183.88.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6162", "1", "admin8576", "2016-08-12 13:35:03", "195.154.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6163", "1", "admin8576", "2016-08-12 13:36:18", "94.174.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6164", "1", "admin8576", "2016-08-12 13:37:40", "172.196.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6165", "1", "admin8576", "2016-08-12 13:42:00", "121.223.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6166", "1", "admin8576", "2016-08-12 13:42:58", "175.143.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6167", "1", "admin8576", "2016-08-12 13:44:10", "110.44.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6168", "1", "admin8576", "2016-08-12 13:49:11", "183.87.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6169", "1", "admin8576", "2016-08-12 13:53:13", "213.253.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6170", "1", "admin8576", "2016-08-12 13:56:17", "130.225.244.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6171", "1", "admin8576", "2016-08-12 13:58:39", "103.255.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6172", "1", "admin8576", "2016-08-12 13:59:17", "183.97.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6173", "1", "admin8576", "2016-08-12 14:02:54", "192.168.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6174", "1", "admin8576", "2016-08-12 14:04:50", "90.194.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6175", "1", "admin8576", "2016-08-12 14:04:51", "124.40.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6176", "1", "admin8576", "2016-08-12 14:07:08", "117.242.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6177", "1", "admin8576", "2016-08-12 14:08:38", "89.115.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6178", "1", "admin8576", "2016-08-12 14:12:40", "85.245.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6179", "1", "admin8576", "2016-08-12 14:16:24", "89.231.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6180", "1", "admin8576", "2016-08-12 14:21:01", "80.237.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6181", "1", "admin8576", "2016-08-12 14:25:53", "79.7.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6182", "1", "admin8576", "2016-08-12 14:29:49", "151.73.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6183", "1", "admin8576", "2016-08-12 14:31:17", "1.22.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6184", "1", "admin8576", "2016-08-12 14:33:24", "110.174.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6185", "1", "admin8576", "2016-08-12 14:35:03", "46.129.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6186", "1", "admin8576", "2016-08-12 14:37:10", "117.201.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6187", "1", "admin8576", "2016-08-12 14:37:18", "130.105.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6188", "1", "admin8576", "2016-08-12 14:37:57", "67.193.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6189", "1", "admin8576", "2016-08-12 14:38:39", "176.184.89.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6190", "1", "admin8576", "2016-08-12 14:41:38", "84.212.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6191", "1", "admin8576", "2016-08-12 14:42:38", "49.32.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6192", "1", "admin8576", "2016-08-12 14:44:55", "101.160.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6193", "1", "admin8576", "2016-08-12 14:46:23", "103.54.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6194", "1", "admin8576", "2016-08-12 14:47:23", "135.23.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6195", "1", "admin8576", "2016-08-12 14:48:37", "154.126.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6196", "1", "admin8576", "2016-08-12 14:51:39", "80.8.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6197", "1", "admin8576", "2016-08-12 14:53:02", "2.249.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6198", "1", "admin8576", "2016-08-12 14:53:33", "85.121.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6199", "1", "admin8576", "2016-08-12 14:53:48", "203.184.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6200", "1", "admin8576", "2016-08-12 14:57:01", "190.202.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6201", "1", "admin8576", "2016-08-12 15:04:34", "162.238.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6202", "1", "admin8576", "2016-08-12 15:06:54", "213.177.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6203", "1", "admin8576", "2016-08-12 15:10:13", "119.153.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6204", "1", "admin8576", "2016-08-12 15:10:47", "178.148.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6205", "1", "admin8576", "2016-08-12 15:13:18", "181.49.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6206", "1", "admin8576", "2016-08-12 15:20:05", "39.38.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6207", "1", "admin8576", "2016-08-12 15:21:20", "78.0.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6208", "1", "admin8576", "2016-08-12 15:24:22", "73.196.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6209", "1", "admin8576", "2016-08-12 15:25:04", "82.244.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6210", "1", "admin8576", "2016-08-12 15:25:49", "110.168.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6211", "1", "admin8576", "2016-08-12 15:27:02", "79.101.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6212", "1", "admin8576", "2016-08-12 15:30:15", "109.92.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6213", "1", "admin8576", "2016-08-12 15:30:44", "180.190.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6214", "1", "admin8576", "2016-08-12 15:31:47", "49.32.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6215", "1", "admin8576", "2016-08-12 15:32:02", "77.54.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6216", "1", "admin8576", "2016-08-12 15:33:02", "31.46.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6217", "1", "admin8576", "2016-08-12 15:34:43", "180.246.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6218", "1", "admin8576", "2016-08-12 15:35:29", "78.150.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6219", "1", "admin8576", "2016-08-12 15:35:56", "103.48.59.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6220", "1", "admin8576", "2016-08-12 15:36:37", "123.2.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6221", "1", "admin8576", "2016-08-12 15:38:24", "177.98.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6222", "1", "admin8576", "2016-08-12 15:38:44", "197.226.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6223", "1", "admin8576", "2016-08-12 15:38:56", "139.218.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6224", "1", "admin8576", "2016-08-12 15:39:31", "213.122.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6225", "1", "admin8576", "2016-08-12 15:41:07", "186.228.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6226", "1", "admin8576", "2016-08-12 15:44:39", "105.158.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6227", "1", "admin8576", "2016-08-12 15:44:40", "178.0.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6228", "1", "admin8576", "2016-08-12 15:46:18", "190.216.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6229", "1", "admin8576", "2016-08-12 15:47:48", "103.225.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6230", "1", "admin8576", "2016-08-12 15:48:20", "217.120.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6231", "1", "admin8576", "2016-08-12 15:48:55", "103.225.231.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6232", "1", "admin8576", "2016-08-12 15:50:05", "65.184.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6233", "1", "admin8576", "2016-08-12 15:50:55", "49.145.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6234", "1", "admin8576", "2016-08-12 15:51:37", "82.74.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6235", "1", "admin8576", "2016-08-12 15:52:00", "49.177.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6236", "1", "admin8576", "2016-08-12 15:54:42", "213.22.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6237", "1", "admin8576", "2016-08-12 15:56:08", "174.107.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6238", "1", "admin8576", "2016-08-12 15:58:50", "112.173.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6239", "1", "admin8576", "2016-08-12 15:58:57", "203.173.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6240", "1", "admin8576", "2016-08-12 15:59:33", "37.228.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6241", "1", "admin8576", "2016-08-12 16:00:28", "1.186.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6242", "1", "admin8576", "2016-08-12 16:01:11", "185.66.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6243", "1", "admin8576", "2016-08-12 16:03:00", "202.156.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6244", "1", "admin8576", "2016-08-12 16:04:57", "72.137.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6245", "1", "admin8576", "2016-08-12 16:05:22", "201.241.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6246", "1", "admin8576", "2016-08-12 16:06:22", "77.46.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6247", "1", "admin8576", "2016-08-12 16:08:10", "122.177.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6248", "1", "admin8576", "2016-08-12 16:12:53", "76.110.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6249", "1", "admin8576", "2016-08-12 16:16:14", "194.228.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6250", "1", "admin8576", "2016-08-12 16:16:39", "79.186.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6251", "1", "admin8576", "2016-08-12 16:17:07", "90.179.187.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6252", "1", "admin8576", "2016-08-12 16:17:19", "191.55.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6253", "1", "admin8576", "2016-08-12 16:17:41", "103.24.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6254", "1", "admin8576", "2016-08-12 16:19:42", "109.93.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6255", "1", "admin8576", "2016-08-12 16:22:26", "188.51.182.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6256", "1", "admin8576", "2016-08-12 16:30:15", "176.114.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6257", "1", "admin8576", "2016-08-12 16:34:41", "213.204.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6258", "1", "admin8576", "2016-08-12 16:34:44", "39.42.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6259", "1", "admin8576", "2016-08-12 16:35:37", "77.28.151.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6260", "1", "admin8576", "2016-08-12 16:41:20", "201.240.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6261", "1", "admin8576", "2016-08-12 16:41:33", "112.211.86.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6262", "1", "admin8576", "2016-08-12 16:43:12", "123.231.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6263", "1", "admin8576", "2016-08-12 16:50:14", "109.166.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6264", "1", "admin8576", "2016-08-12 16:54:26", "84.197.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6265", "1", "admin8576", "2016-08-12 16:54:35", "178.255.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6266", "1", "admin8576", "2016-08-12 16:58:12", "201.163.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6267", "1", "admin8576", "2016-08-12 16:58:31", "72.27.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6268", "1", "admin8576", "2016-08-12 17:00:52", "113.159.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6269", "1", "admin8576", "2016-08-12 17:01:25", "185.149.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6270", "1", "admin8576", "2016-08-12 17:06:07", "109.103.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6271", "1", "admin8576", "2016-08-12 17:06:25", "78.1.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6272", "1", "admin8576", "2016-08-12 17:06:54", "112.149.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6273", "1", "admin8576", "2016-08-12 17:10:16", "173.56.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6274", "1", "admin8576", "2016-08-12 17:10:45", "109.78.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6275", "1", "admin8576", "2016-08-12 17:11:06", "91.178.154.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6276", "1", "admin8576", "2016-08-12 17:13:05", "202.56.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6277", "1", "admin8576", "2016-08-12 17:15:19", "124.83.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6278", "1", "admin8576", "2016-08-12 17:16:12", "103.56.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6279", "1", "admin8576", "2016-08-12 17:16:23", "180.9.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6280", "1", "admin8576", "2016-08-12 17:16:28", "211.110.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6281", "1", "admin8576", "2016-08-12 17:16:42", "51.36.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6282", "1", "admin8576", "2016-08-12 17:16:59", "180.191.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6283", "1", "admin8576", "2016-08-12 17:17:13", "117.217.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6284", "1", "admin8576", "2016-08-12 17:21:18", "93.37.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6285", "1", "admin8576", "2016-08-12 17:22:39", "87.115.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6286", "1", "admin8576", "2016-08-12 17:24:15", "76.91.194.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6287", "1", "admin8576", "2016-08-12 17:24:26", "119.40.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6288", "1", "admin8576", "2016-08-12 17:25:33", "2.25.141.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6289", "1", "admin8576", "2016-08-12 17:27:01", "79.53.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6290", "1", "admin8576", "2016-08-12 17:27:22", "62.57.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6291", "1", "admin8576", "2016-08-12 17:28:34", "2.50.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6292", "1", "admin8576", "2016-08-12 17:28:40", "81.225.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6293", "1", "admin8576", "2016-08-12 17:32:48", "103.252.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6294", "1", "admin8576", "2016-08-12 17:32:53", "190.115.161.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6295", "1", "admin8576", "2016-08-12 17:34:16", "173.18.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6296", "1", "admin8576", "2016-08-12 17:35:19", "89.2.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6297", "1", "admin8576", "2016-08-12 17:36:14", "5.197.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6298", "1", "admin8576", "2016-08-12 17:37:11", "124.106.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6299", "1", "admin8576", "2016-08-12 17:39:11", "81.248.252.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6300", "1", "admin8576", "2016-08-12 17:39:47", "91.137.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6301", "1", "admin8576", "2016-08-12 17:41:49", "78.159.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6302", "1", "admin8576", "2016-08-12 17:42:09", "79.112.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6303", "1", "admin8576", "2016-08-12 17:43:28", "122.15.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6304", "1", "admin8576", "2016-08-12 17:47:00", "197.39.91.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6305", "1", "admin8576", "2016-08-12 17:47:44", "95.14.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6306", "1", "admin8576", "2016-08-12 17:48:34", "200.93.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6307", "1", "admin8576", "2016-08-12 17:50:06", "110.78.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6308", "1", "admin8576", "2016-08-12 17:50:15", "178.222.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6309", "1", "admin8576", "2016-08-12 17:54:16", "46.109.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6310", "1", "admin8576", "2016-08-12 17:58:15", "192.168.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6311", "1", "admin8576", "2016-08-12 17:59:52", "191.81.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6312", "1", "admin8576", "2016-08-12 18:00:07", "176.63.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6313", "1", "admin8576", "2016-08-12 18:02:20", "125.63.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6314", "1", "admin8576", "2016-08-12 18:02:46", "83.47.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6315", "1", "admin8576", "2016-08-12 18:03:47", "193.77.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6316", "1", "admin8576", "2016-08-12 18:04:33", "112.201.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6317", "1", "admin8576", "2016-08-12 18:09:13", "119.153.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6318", "1", "admin8576", "2016-08-12 18:09:14", "171.49.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6319", "1", "admin8576", "2016-08-12 18:09:20", "41.210.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6320", "1", "admin8576", "2016-08-12 18:09:21", "72.53.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6321", "1", "admin8576", "2016-08-12 18:10:09", "14.37.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6322", "1", "admin8576", "2016-08-12 18:14:15", "91.195.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6323", "1", "admin8576", "2016-08-12 18:14:31", "88.212.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6324", "1", "admin8576", "2016-08-12 18:15:19", "182.64.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6325", "1", "admin8576", "2016-08-12 18:15:48", "105.157.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6326", "1", "admin8576", "2016-08-12 18:15:57", "58.179.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6327", "1", "admin8576", "2016-08-12 18:18:48", "173.44.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6328", "1", "admin8576", "2016-08-12 18:19:43", "203.88.92.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6329", "1", "admin8576", "2016-08-12 18:24:40", "103.255.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6330", "1", "admin8576", "2016-08-12 18:29:36", "182.183.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6331", "1", "admin8576", "2016-08-12 18:30:28", "92.80.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6332", "1", "admin8576", "2016-08-12 18:31:37", "99.111.119.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6333", "1", "admin8576", "2016-08-12 18:34:46", "99.115.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6334", "1", "admin8576", "2016-08-12 18:35:32", "89.176.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6335", "1", "admin8576", "2016-08-12 18:38:00", "82.53.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6336", "1", "admin8576", "2016-08-12 18:38:00", "31.216.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6337", "1", "admin8576", "2016-08-12 18:39:02", "125.25.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6338", "1", "admin8576", "2016-08-12 18:39:37", "60.50.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6339", "1", "admin8576", "2016-08-12 18:41:55", "188.223.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6340", "1", "admin8576", "2016-08-12 18:42:30", "82.118.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6341", "1", "admin8576", "2016-08-12 18:46:11", "185.19.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6342", "1", "admin8576", "2016-08-12 18:47:25", "27.7.17.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6343", "1", "admin8576", "2016-08-12 18:49:22", "198.91.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6344", "1", "admin8576", "2016-08-12 18:49:27", "181.90.150.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6345", "1", "admin8576", "2016-08-12 18:56:32", "63.148.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6346", "1", "admin8576", "2016-08-12 19:00:25", "5.22.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6347", "1", "admin8576", "2016-08-12 19:04:16", "213.89.10.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6348", "1", "admin8576", "2016-08-12 19:05:36", "212.178.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6349", "1", "admin8576", "2016-08-12 19:06:24", "179.192.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6350", "1", "admin8576", "2016-08-12 19:06:57", "24.122.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6351", "1", "admin8576", "2016-08-12 19:08:31", "41.251.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6352", "1", "admin8576", "2016-08-12 19:09:35", "2.50.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6353", "1", "admin8576", "2016-08-12 19:10:52", "124.44.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6354", "1", "admin8576", "2016-08-12 19:14:00", "41.141.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6355", "1", "admin8576", "2016-08-12 19:22:14", "112.133.232.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6356", "1", "admin8576", "2016-08-12 19:23:16", "99.90.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6357", "1", "admin8576", "2016-08-12 19:24:31", "78.175.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6358", "1", "admin8576", "2016-08-12 19:27:09", "117.199.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6359", "1", "admin8576", "2016-08-12 19:28:14", "130.105.196.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6360", "1", "admin8576", "2016-08-12 19:30:28", "119.17.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6361", "1", "admin8576", "2016-08-12 19:30:58", "156.211.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6362", "1", "admin8576", "2016-08-12 19:31:25", "58.178.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6363", "1", "admin8576", "2016-08-12 19:31:56", "115.96.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6364", "1", "admin8576", "2016-08-12 19:32:15", "219.92.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6365", "1", "admin8576", "2016-08-12 19:36:57", "73.253.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6366", "1", "admin8576", "2016-08-12 19:37:34", "192.116.2.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6367", "1", "admin8576", "2016-08-12 19:38:11", "27.114.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6368", "1", "admin8576", "2016-08-12 19:38:43", "111.94.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6369", "1", "admin8576", "2016-08-12 19:41:58", "212.199.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6370", "1", "admin8576", "2016-08-12 19:43:28", "94.96.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6371", "1", "admin8576", "2016-08-12 19:43:48", "128.79.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6372", "1", "admin8576", "2016-08-12 19:43:52", "103.212.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6373", "1", "admin8576", "2016-08-12 19:43:55", "74.58.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6374", "1", "admin8576", "2016-08-12 19:44:52", "112.207.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6375", "1", "admin8576", "2016-08-12 19:47:18", "169.1.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6376", "1", "admin8576", "2016-08-12 19:51:22", "90.28.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6377", "1", "admin8576", "2016-08-12 19:52:26", "103.19.255.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6378", "1", "admin8576", "2016-08-12 19:52:38", "77.139.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6379", "1", "admin8576", "2016-08-12 19:54:19", "179.98.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6380", "1", "admin8576", "2016-08-12 19:55:23", "24.114.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6381", "1", "admin8576", "2016-08-12 19:55:46", "103.215.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6382", "1", "admin8576", "2016-08-12 19:59:30", "85.245.227.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6383", "1", "admin8576", "2016-08-12 19:59:40", "101.162.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6384", "1", "admin8576", "2016-08-12 20:00:02", "178.148.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6385", "1", "admin8576", "2016-08-12 20:00:38", "188.187.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6386", "1", "admin8576", "2016-08-12 20:08:47", "121.157.197.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6387", "1", "admin8576", "2016-08-12 20:11:06", "188.50.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6388", "1", "admin8576", "2016-08-12 20:11:36", "179.4.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6389", "1", "admin8576", "2016-08-12 20:11:41", "93.143.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6390", "1", "admin8576", "2016-08-12 20:11:47", "202.136.72.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6391", "1", "admin8576", "2016-08-12 20:14:26", "103.25.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6392", "1", "admin8576", "2016-08-12 20:15:59", "212.26.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6393", "1", "admin8576", "2016-08-12 20:16:23", "104.157.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6394", "1", "admin8576", "2016-08-12 20:20:56", "45.56.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6395", "1", "admin8576", "2016-08-12 20:22:14", "173.239.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6396", "1", "admin8576", "2016-08-12 20:32:38", "49.207.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6397", "1", "admin8576", "2016-08-12 20:33:51", "151.68.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6398", "1", "admin8576", "2016-08-12 20:37:34", "108.88.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6399", "1", "admin8576", "2016-08-12 20:39:05", "90.65.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6400", "1", "admin8576", "2016-08-12 20:40:14", "95.244.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6401", "1", "admin8576", "2016-08-12 20:40:48", "89.176.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6402", "1", "admin8576", "2016-08-12 20:41:12", "161.111.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6403", "1", "admin8576", "2016-08-12 20:45:57", "64.237.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6404", "1", "admin8576", "2016-08-12 21:04:51", "185.63.45.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6405", "1", "admin8576", "2016-08-12 21:04:56", "24.135.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6406", "1", "admin8576", "2016-08-12 21:05:32", "83.203.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6407", "1", "admin8576", "2016-08-12 21:14:39", "185.113.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6408", "1", "admin8576", "2016-08-12 21:14:42", "125.18.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6409", "1", "admin8576", "2016-08-12 21:15:19", "46.99.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6410", "1", "admin8576", "2016-08-12 21:15:24", "191.183.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6411", "1", "admin8576", "2016-08-12 21:17:30", "180.9.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6412", "1", "admin8576", "2016-08-12 21:17:46", "121.122.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6413", "1", "admin8576", "2016-08-12 21:18:01", "94.193.1.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6414", "1", "admin8576", "2016-08-12 21:18:55", "139.255.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6415", "1", "admin8576", "2016-08-12 21:19:43", "95.102.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6416", "1", "admin8576", "2016-08-12 21:25:24", "193.179.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6417", "1", "admin8576", "2016-08-12 21:30:29", "1.186.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6418", "1", "admin8576", "2016-08-12 21:33:15", "45.123.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6419", "1", "admin8576", "2016-08-12 21:39:35", "88.247.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6420", "1", "admin8576", "2016-08-12 21:44:17", "85.197.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6421", "1", "admin8576", "2016-08-12 21:45:27", "93.142.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6422", "1", "admin8576", "2016-08-12 21:46:05", "198.8.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6423", "1", "admin8576", "2016-08-12 21:46:40", "43.230.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6424", "1", "admin8576", "2016-08-12 21:47:56", "91.234.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6425", "1", "admin8576", "2016-08-12 21:54:16", "31.223.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6426", "1", "admin8576", "2016-08-12 21:58:26", "2.31.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6427", "1", "admin8576", "2016-08-12 21:59:46", "50.202.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6428", "1", "admin8576", "2016-08-12 22:00:16", "37.228.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6429", "1", "admin8576", "2016-08-12 22:03:44", "197.0.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6430", "1", "admin8576", "2016-08-12 22:06:19", "41.226.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6431", "1", "admin8576", "2016-08-12 22:06:20", "169.1.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6432", "1", "admin8576", "2016-08-12 22:08:12", "24.77.200.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6433", "1", "admin8576", "2016-08-12 22:08:38", "84.10.222.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6434", "1", "admin8576", "2016-08-12 22:08:42", "86.164.21.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6435", "1", "admin8576", "2016-08-12 22:15:45", "80.60.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6436", "1", "admin8576", "2016-08-12 22:16:11", "71.89.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6437", "1", "admin8576", "2016-08-12 22:16:23", "2.30.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6438", "1", "admin8576", "2016-08-12 22:16:32", "212.127.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6439", "1", "admin8576", "2016-08-12 22:18:13", "154.127.34.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6440", "1", "admin8576", "2016-08-12 22:19:49", "89.138.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6441", "1", "admin8576", "2016-08-12 22:19:50", "176.43.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6442", "1", "admin8576", "2016-08-12 22:29:04", "46.10.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6443", "1", "admin8576", "2016-08-12 22:30:10", "80.87.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6444", "1", "admin8576", "2016-08-12 22:31:22", "89.248.248.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6445", "1", "admin8576", "2016-08-12 22:36:06", "62.194.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6446", "1", "admin8576", "2016-08-12 22:36:12", "174.1.58.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6447", "1", "admin8576", "2016-08-12 22:39:42", "31.27.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6448", "1", "admin8576", "2016-08-12 22:39:49", "79.33.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6449", "1", "admin8576", "2016-08-12 22:41:06", "46.152.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6450", "1", "admin8576", "2016-08-12 22:43:25", "79.179.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6451", "1", "admin8576", "2016-08-12 22:43:35", "50.170.57.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6452", "1", "admin8576", "2016-08-12 22:43:48", "92.108.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6453", "1", "admin8576", "2016-08-12 22:44:45", "173.166.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6454", "1", "admin8576", "2016-08-12 22:44:46", "198.84.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6455", "1", "admin8576", "2016-08-12 22:46:29", "24.147.202.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6456", "1", "admin8576", "2016-08-12 22:46:33", "10.5.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6457", "1", "admin8576", "2016-08-12 22:47:29", "173.76.127.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6458", "1", "admin8576", "2016-08-12 22:47:35", "98.202.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6459", "1", "admin8576", "2016-08-12 22:49:19", "82.221.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6460", "1", "admin8576", "2016-08-12 22:49:35", "186.69.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6461", "1", "admin8576", "2016-08-12 22:51:54", "71.47.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6462", "1", "admin8576", "2016-08-12 22:52:43", "90.224.215.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6463", "1", "admin8576", "2016-08-12 22:52:52", "77.250.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6464", "1", "admin8576", "2016-08-12 22:53:05", "89.176.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6465", "1", "admin8576", "2016-08-12 22:53:36", "62.90.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6466", "1", "admin8576", "2016-08-12 22:54:24", "200.89.68.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6467", "1", "admin8576", "2016-08-12 22:56:43", "94.174.30.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6468", "1", "admin8576", "2016-08-12 22:58:33", "201.217.247.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6469", "1", "admin8576", "2016-08-12 22:59:45", "50.198.66.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6470", "1", "admin8576", "2016-08-12 23:01:03", "58.93.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6471", "1", "admin8576", "2016-08-12 23:02:40", "168.187.137.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6472", "1", "admin8576", "2016-08-12 23:04:06", "217.79.191.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6473", "1", "admin8576", "2016-08-12 23:05:04", "151.227.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6474", "1", "admin8576", "2016-08-12 23:07:22", "73.21.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6475", "1", "admin8576", "2016-08-12 23:07:40", "92.9.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6476", "1", "admin8576", "2016-08-12 23:09:38", "197.53.12.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6477", "1", "admin8576", "2016-08-12 23:10:08", "105.229.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6478", "1", "admin8576", "2016-08-12 23:11:32", "109.93.77.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6479", "1", "admin8576", "2016-08-12 23:11:37", "179.32.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6480", "1", "admin8576", "2016-08-12 23:11:46", "68.65.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6481", "1", "admin8576", "2016-08-12 23:12:10", "49.149.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6482", "1", "admin8576", "2016-08-12 23:12:20", "31.176.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6483", "1", "admin8576", "2016-08-12 23:13:03", "109.67.224.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6484", "1", "admin8576", "2016-08-12 23:13:22", "45.64.226.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6485", "1", "admin8576", "2016-08-12 23:14:20", "212.117.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6486", "1", "admin8576", "2016-08-12 23:15:49", "99.90.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6487", "1", "admin8576", "2016-08-12 23:17:19", "41.150.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6488", "1", "admin8576", "2016-08-12 23:17:30", "109.81.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6489", "1", "admin8576", "2016-08-12 23:18:30", "79.154.189.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6490", "1", "admin8576", "2016-08-12 23:18:31", "78.180.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6491", "1", "admin8576", "2016-08-12 23:19:49", "177.17.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6492", "1", "admin8576", "2016-08-12 23:19:56", "49.150.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6493", "1", "admin8576", "2016-08-12 23:21:08", "115.66.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6494", "1", "admin8576", "2016-08-12 23:21:28", "41.96.160.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6495", "1", "admin8576", "2016-08-12 23:22:29", "197.48.195.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6496", "1", "admin8576", "2016-08-12 23:24:37", "176.249.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6497", "1", "admin8576", "2016-08-12 23:26:06", "41.66.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6498", "1", "admin8576", "2016-08-12 23:27:53", "103.212.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6499", "1", "admin8576", "2016-08-12 23:30:42", "49.32.20.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6500", "1", "admin8576", "2016-08-12 23:32:19", "178.37.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6501", "1", "admin8576", "2016-08-12 23:33:15", "130.105.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6502", "1", "admin8576", "2016-08-12 23:33:51", "201.4.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6503", "1", "admin8576", "2016-08-12 23:35:17", "105.227.204.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6504", "1", "admin8576", "2016-08-12 23:36:15", "135.23.80.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6505", "1", "admin8576", "2016-08-12 23:40:05", "178.23.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6506", "1", "admin8576", "2016-08-12 23:41:56", "95.107.250.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6507", "1", "admin8576", "2016-08-12 23:43:12", "41.45.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6508", "1", "admin8576", "2016-08-12 23:45:19", "89.173.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6509", "1", "admin8576", "2016-08-12 23:45:47", "178.222.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6510", "1", "admin8576", "2016-08-12 23:46:11", "90.74.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6511", "1", "admin8576", "2016-08-12 23:47:48", "79.118.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6512", "1", "admin8576", "2016-08-12 23:49:02", "37.142.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6513", "1", "admin8576", "2016-08-12 23:51:36", "111.88.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6514", "1", "admin8576", "2016-08-12 23:54:13", "41.141.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6515", "1", "admin8576", "2016-08-12 23:54:50", "68.70.19.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6516", "1", "admin8576", "2016-08-12 23:55:04", "213.125.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6517", "1", "admin8576", "2016-08-12 23:55:17", "24.142.32.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6518", "1", "admin8576", "2016-08-12 23:56:31", "77.125.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6519", "1", "admin8576", "2016-08-12 23:57:41", "192.168.0.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6520", "1", "admin8576", "2016-08-13 00:00:33", "93.136.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6521", "1", "admin8576", "2016-08-13 00:01:49", "186.179.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6522", "1", "admin8576", "2016-08-13 00:01:55", "86.183.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6523", "1", "admin8576", "2016-08-13 00:03:03", "113.162.209.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6524", "1", "admin8576", "2016-08-13 00:03:42", "72.223.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6525", "1", "admin8576", "2016-08-13 00:04:33", "110.175.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6526", "1", "admin8576", "2016-08-13 00:04:41", "85.228.210.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6527", "1", "admin8576", "2016-08-13 00:05:57", "5.146.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6528", "1", "admin8576", "2016-08-13 00:06:05", "194.1.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6529", "1", "admin8576", "2016-08-13 00:06:07", "89.211.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6530", "1", "admin8576", "2016-08-13 00:06:58", "79.114.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6531", "1", "admin8576", "2016-08-13 00:07:35", "219.91.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6532", "1", "admin8576", "2016-08-13 00:08:31", "73.196.35.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6533", "1", "admin8576", "2016-08-13 00:10:47", "93.168.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6534", "1", "admin8576", "2016-08-13 00:10:52", "111.69.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6535", "1", "admin8576", "2016-08-13 00:10:57", "86.82.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6536", "1", "admin8576", "2016-08-13 00:10:59", "37.105.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6537", "1", "admin8576", "2016-08-13 00:12:14", "41.33.106.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6538", "1", "admin8576", "2016-08-13 00:12:49", "41.250.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6539", "1", "admin8576", "2016-08-13 00:13:05", "173.75.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6540", "1", "admin8576", "2016-08-13 00:13:28", "41.230.115.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6541", "1", "admin8576", "2016-08-13 00:13:33", "184.89.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6542", "1", "admin8576", "2016-08-13 00:24:28", "89.100.5.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6543", "1", "admin8576", "2016-08-13 00:28:16", "78.200.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6544", "1", "admin8576", "2016-08-13 00:28:26", "69.4.152.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6545", "1", "admin8576", "2016-08-13 00:29:24", "179.208.100.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6546", "1", "admin8576", "2016-08-13 00:29:36", "37.186.43.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6547", "1", "admin8576", "2016-08-13 00:30:09", "77.134.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6548", "1", "admin8576", "2016-08-13 00:31:12", "201.227.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6549", "1", "admin8576", "2016-08-13 00:38:58", "189.63.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6550", "1", "admin8576", "2016-08-13 00:43:14", "176.42.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6551", "1", "admin8576", "2016-08-13 00:45:49", "190.191.139.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6552", "1", "admin8576", "2016-08-13 00:49:12", "37.228.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6553", "1", "admin8576", "2016-08-13 00:50:29", "138.94.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6554", "1", "admin8576", "2016-08-13 00:52:04", "189.236.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6555", "1", "admin8576", "2016-08-13 01:01:33", "209.126.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6556", "1", "admin8576", "2016-08-13 01:01:47", "93.99.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6557", "1", "admin8576", "2016-08-13 01:03:59", "186.77.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6558", "1", "admin8576", "2016-08-13 01:05:27", "50.202.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6559", "1", "admin8576", "2016-08-13 01:06:10", "14.201.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6560", "1", "admin8576", "2016-08-13 01:09:08", "105.189.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6561", "1", "admin8576", "2016-08-13 01:10:02", "103.21.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6562", "1", "admin8576", "2016-08-13 01:11:07", "81.100.205.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6563", "1", "admin8576", "2016-08-13 01:12:17", "77.148.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6564", "1", "admin8576", "2016-08-13 01:15:05", "51.36.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6565", "1", "admin8576", "2016-08-13 01:16:59", "51.179.98.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6566", "1", "admin8576", "2016-08-13 01:22:33", "197.251.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6567", "1", "admin8576", "2016-08-13 01:25:43", "88.231.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6568", "1", "admin8576", "2016-08-13 01:26:14", "93.137.253.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6569", "1", "admin8576", "2016-08-13 01:27:26", "213.162.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6570", "1", "admin8576", "2016-08-13 01:28:21", "190.255.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6571", "1", "admin8576", "2016-08-13 01:28:46", "74.131.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6572", "1", "admin8576", "2016-08-13 01:29:02", "173.32.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6573", "1", "admin8576", "2016-08-13 01:35:25", "186.212.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6574", "1", "admin8576", "2016-08-13 01:40:14", "178.17.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6575", "1", "admin8576", "2016-08-13 01:40:20", "138.255.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6576", "1", "admin8576", "2016-08-13 01:41:41", "70.112.131.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6577", "1", "admin8576", "2016-08-13 01:43:57", "46.152.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6578", "1", "admin8576", "2016-08-13 01:50:38", "203.217.75.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6579", "1", "admin8576", "2016-08-13 01:51:05", "86.19.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6580", "1", "admin8576", "2016-08-13 01:53:12", "222.113.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6581", "1", "admin8576", "2016-08-13 01:57:02", "109.64.129.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6582", "1", "admin8576", "2016-08-13 01:57:09", "79.179.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6583", "1", "admin8576", "2016-08-13 02:02:08", "187.161.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6584", "1", "admin8576", "2016-08-13 02:03:01", "112.206.121.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6585", "1", "admin8576", "2016-08-13 02:03:54", "103.12.133.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6586", "1", "admin8576", "2016-08-13 02:05:21", "60.246.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6587", "1", "admin8576", "2016-08-13 02:11:32", "213.136.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6588", "1", "admin8576", "2016-08-13 02:11:36", "89.205.84.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6589", "1", "admin8576", "2016-08-13 02:15:44", "50.121.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6590", "1", "admin8576", "2016-08-13 02:16:25", "61.2.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6591", "1", "admin8576", "2016-08-13 02:17:37", "49.32.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6592", "1", "admin8576", "2016-08-13 02:18:21", "151.16.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6593", "1", "admin8576", "2016-08-13 02:18:43", "122.59.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6594", "1", "admin8576", "2016-08-13 02:19:03", "24.122.83.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6595", "1", "admin8576", "2016-08-13 02:24:14", "99.90.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6596", "1", "admin8576", "2016-08-13 02:25:13", "177.228.233.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6597", "1", "admin8576", "2016-08-13 02:25:26", "45.243.102.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6598", "1", "admin8576", "2016-08-13 02:26:34", "82.31.3.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6599", "1", "admin8576", "2016-08-13 02:27:09", "180.178.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6600", "1", "admin8576", "2016-08-13 02:28:46", "37.216.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6601", "1", "admin8576", "2016-08-13 02:29:54", "190.20.113.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6602", "1", "admin8576", "2016-08-13 02:31:21", "103.252.24.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6603", "1", "admin8576", "2016-08-13 02:34:34", "24.235.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6604", "1", "admin8576", "2016-08-13 02:37:16", "77.100.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6605", "1", "admin8576", "2016-08-13 02:39:00", "120.56.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6606", "1", "admin8576", "2016-08-13 02:39:28", "95.235.116.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6607", "1", "admin8576", "2016-08-13 02:39:57", "100.1.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6608", "1", "admin8576", "2016-08-13 02:42:39", "126.87.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6609", "1", "admin8576", "2016-08-13 02:43:23", "174.103.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6610", "1", "admin8576", "2016-08-13 02:43:48", "118.97.235.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6611", "1", "admin8576", "2016-08-13 02:51:21", "80.251.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6612", "1", "admin8576", "2016-08-13 02:51:42", "188.117.239.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6613", "1", "admin8576", "2016-08-13 02:52:38", "101.186.140.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6614", "1", "admin8576", "2016-08-13 02:53:16", "121.184.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6615", "1", "admin8576", "2016-08-13 02:53:57", "119.93.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6616", "1", "admin8576", "2016-08-13 02:54:27", "49.175.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6617", "1", "admin8576", "2016-08-13 02:55:03", "178.41.147.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6618", "1", "admin8576", "2016-08-13 02:55:19", "78.244.180.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6619", "1", "admin8576", "2016-08-13 02:59:51", "94.176.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6620", "1", "admin8576", "2016-08-13 03:03:44", "174.0.240.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6621", "1", "admin8576", "2016-08-13 03:07:21", "90.180.173.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6622", "1", "admin8576", "2016-08-13 03:08:34", "46.10.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6623", "1", "admin8576", "2016-08-13 03:09:05", "119.95.61.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6624", "1", "admin8576", "2016-08-13 03:09:13", "189.149.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6625", "1", "admin8576", "2016-08-13 03:10:26", "169.255.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6626", "1", "admin8576", "2016-08-13 03:14:03", "41.230.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6627", "1", "admin8576", "2016-08-13 03:16:22", "188.135.23.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6628", "1", "admin8576", "2016-08-13 03:19:01", "67.247.163.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6629", "1", "admin8576", "2016-08-13 03:19:06", "189.169.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6630", "1", "admin8576", "2016-08-13 03:19:44", "49.144.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6631", "1", "admin8576", "2016-08-13 03:20:36", "187.62.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6632", "1", "admin8576", "2016-08-13 03:20:50", "80.61.118.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6633", "1", "admin8576", "2016-08-13 03:21:48", "188.50.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6634", "1", "admin8576", "2016-08-13 03:22:16", "210.84.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6635", "1", "admin8576", "2016-08-13 03:23:25", "46.116.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6636", "1", "admin8576", "2016-08-13 03:26:28", "154.73.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6637", "1", "admin8576", "2016-08-13 03:27:21", "38.124.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6638", "1", "admin8576", "2016-08-13 03:28:10", "49.145.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6639", "1", "admin8576", "2016-08-13 03:28:18", "95.68.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6640", "1", "admin8576", "2016-08-13 03:28:51", "89.99.104.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6641", "1", "admin8576", "2016-08-13 03:29:51", "150.129.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6642", "1", "admin8576", "2016-08-13 03:37:00", "178.164.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6643", "1", "admin8576", "2016-08-13 03:37:42", "101.183.251.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6644", "1", "admin8576", "2016-08-13 03:39:18", "190.220.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6645", "1", "admin8576", "2016-08-13 03:40:56", "41.97.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6646", "1", "admin8576", "2016-08-13 03:41:04", "186.87.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6647", "1", "admin8576", "2016-08-13 03:43:45", "216.239.85.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6648", "1", "admin8576", "2016-08-13 03:44:19", "122.54.165.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6649", "1", "admin8576", "2016-08-13 03:46:56", "85.254.79.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6650", "1", "admin8576", "2016-08-13 03:47:20", "58.10.64.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6651", "1", "admin8576", "2016-08-13 03:49:56", "94.204.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6652", "1", "admin8576", "2016-08-13 03:50:14", "94.101.4.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6653", "1", "admin8576", "2016-08-13 03:51:30", "89.181.82.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6654", "1", "admin8576", "2016-08-13 03:54:40", "99.247.56.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6655", "1", "admin8576", "2016-08-13 03:56:17", "41.66.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6656", "1", "admin8576", "2016-08-13 03:57:05", "1.220.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6657", "1", "admin8576", "2016-08-13 03:58:01", "101.100.132.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6658", "1", "admin8576", "2016-08-13 03:59:16", "88.105.55.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6659", "1", "admin8576", "2016-08-13 04:05:07", "121.45.54.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6660", "1", "admin8576", "2016-08-13 04:06:24", "187.151.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6661", "1", "admin8576", "2016-08-13 04:08:53", "183.88.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6662", "1", "admin8576", "2016-08-13 04:10:16", "178.17.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6663", "1", "admin8576", "2016-08-13 04:10:28", "70.31.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6664", "1", "admin8576", "2016-08-13 04:10:48", "189.21.214.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6665", "1", "admin8576", "2016-08-13 04:10:58", "62.44.225.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6666", "1", "admin8576", "2016-08-13 04:11:48", "49.146.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6667", "1", "admin8576", "2016-08-13 04:14:39", "211.198.188.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6668", "1", "admin8576", "2016-08-13 04:15:38", "124.159.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6669", "1", "admin8576", "2016-08-13 04:15:58", "112.198.103.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6670", "1", "admin8576", "2016-08-13 04:16:59", "49.149.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6671", "1", "admin8576", "2016-08-13 04:18:21", "190.57.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6672", "1", "admin8576", "2016-08-13 04:21:10", "99.251.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6673", "1", "admin8576", "2016-08-13 04:21:52", "109.64.134.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6674", "1", "admin8576", "2016-08-13 04:22:10", "103.1.70.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6675", "1", "admin8576", "2016-08-13 04:26:35", "212.158.158.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6676", "1", "admin8576", "2016-08-13 04:27:30", "186.247.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6677", "1", "admin8576", "2016-08-13 04:29:47", "27.123.149.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6678", "1", "admin8576", "2016-08-13 04:30:24", "82.173.120.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6679", "1", "admin8576", "2016-08-13 04:31:58", "69.157.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6680", "1", "admin8576", "2016-08-13 04:32:22", "120.61.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6681", "1", "admin8576", "2016-08-13 04:37:29", "154.242.184.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6682", "1", "admin8576", "2016-08-13 04:39:09", "63.140.26.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6683", "1", "admin8576", "2016-08-13 04:42:13", "49.145.60.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6684", "1", "admin8576", "2016-08-13 04:43:18", "81.173.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6685", "1", "admin8576", "2016-08-13 04:44:45", "122.54.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6686", "1", "admin8576", "2016-08-13 04:47:20", "219.88.237.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6687", "1", "admin8576", "2016-08-13 04:48:30", "42.115.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6688", "1", "admin8576", "2016-08-13 04:54:13", "120.28.192.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6689", "1", "admin8576", "2016-08-13 04:54:57", "49.144.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6690", "1", "admin8576", "2016-08-13 04:56:10", "75.131.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6691", "1", "admin8576", "2016-08-13 04:58:31", "91.140.130.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6692", "1", "admin8576", "2016-08-13 04:59:36", "213.172.128.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6693", "1", "admin8576", "2016-08-13 05:00:41", "172.111.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6694", "1", "admin8576", "2016-08-13 05:01:05", "122.53.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6695", "1", "admin8576", "2016-08-13 05:03:38", "180.9.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6696", "1", "admin8576", "2016-08-13 05:04:20", "198.71.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6697", "1", "admin8576", "2016-08-13 05:04:46", "179.53.53.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6698", "1", "admin8576", "2016-08-13 05:06:18", "82.147.78.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6699", "1", "admin8576", "2016-08-13 05:10:47", "60.52.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6700", "1", "admin8576", "2016-08-13 05:11:23", "116.88.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6701", "1", "admin8576", "2016-08-13 05:15:12", "150.107.8.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6702", "1", "admin8576", "2016-08-13 05:15:53", "122.3.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6703", "1", "admin8576", "2016-08-13 05:16:24", "79.179.27.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6704", "1", "admin8576", "2016-08-13 05:17:41", "39.53.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6705", "1", "admin8576", "2016-08-13 05:18:48", "108.59.65.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6706", "1", "admin8576", "2016-08-13 05:24:55", "98.207.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6707", "1", "admin8576", "2016-08-13 05:26:18", "210.14.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6708", "1", "admin8576", "2016-08-13 05:26:37", "49.205.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6709", "1", "admin8576", "2016-08-13 05:27:51", "78.234.159.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6710", "1", "admin8576", "2016-08-13 05:28:14", "189.217.49.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6711", "1", "admin8576", "2016-08-13 05:30:26", "173.44.73.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6712", "1", "admin8576", "2016-08-13 05:31:22", "115.161.117.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6713", "1", "admin8576", "2016-08-13 05:35:14", "112.204.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6714", "1", "admin8576", "2016-08-13 05:37:14", "81.44.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6715", "1", "admin8576", "2016-08-13 05:39:36", "46.23.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6716", "1", "admin8576", "2016-08-13 05:46:04", "41.147.11.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6717", "1", "admin8576", "2016-08-13 05:48:25", "103.54.18.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6718", "1", "admin8576", "2016-08-13 05:48:26", "179.4.38.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6719", "1", "admin8576", "2016-08-13 05:50:33", "144.139.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6720", "1", "admin8576", "2016-08-13 05:52:01", "67.221.213.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6721", "1", "admin8576", "2016-08-13 05:53:47", "78.240.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6722", "1", "admin8576", "2016-08-13 05:58:25", "98.109.123.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6723", "1", "admin8576", "2016-08-13 05:59:38", "27.34.39.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6724", "1", "admin8576", "2016-08-13 06:00:31", "108.184.219.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6725", "1", "admin8576", "2016-08-13 06:06:40", "72.51.108.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6726", "1", "admin8576", "2016-08-13 06:08:06", "139.195.171.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6727", "1", "admin8576", "2016-08-13 06:09:14", "109.97.146.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6728", "1", "admin8576", "2016-08-13 06:09:50", "91.51.234.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6729", "1", "admin8576", "2016-08-13 06:11:01", "61.72.63.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6730", "1", "admin8576", "2016-08-13 06:12:58", "74.134.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6731", "1", "admin8576", "2016-08-13 06:14:52", "24.157.101.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6732", "1", "admin8576", "2016-08-13 06:18:14", "49.32.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6733", "1", "admin8576", "2016-08-13 06:21:21", "93.139.178.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6734", "1", "admin8576", "2016-08-13 06:23:14", "189.27.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6735", "1", "admin8576", "2016-08-13 06:25:09", "78.250.126.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6736", "1", "admin8576", "2016-08-13 06:27:03", "162.226.81.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6737", "1", "admin8576", "2016-08-13 06:28:43", "219.91.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6738", "1", "admin8576", "2016-08-13 06:32:17", "112.209.50.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6739", "1", "admin8576", "2016-08-13 06:34:23", "119.237.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6740", "1", "admin8576", "2016-08-13 06:34:52", "119.93.51.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6741", "1", "admin8576", "2016-08-13 06:36:40", "49.32.48.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6742", "1", "admin8576", "2016-08-13 06:36:49", "211.43.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6743", "1", "admin8576", "2016-08-13 06:37:14", "217.197.136.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6744", "1", "admin8576", "2016-08-13 06:50:03", "49.144.212.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6745", "1", "admin8576", "2016-08-13 06:50:42", "189.217.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6746", "1", "admin8576", "2016-08-13 06:53:00", "177.67.99.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6747", "1", "admin8576", "2016-08-13 06:54:59", "112.204.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6748", "1", "admin8576", "2016-08-13 06:57:20", "49.149.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6749", "1", "admin8576", "2016-08-13 06:59:18", "197.36.249.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6750", "1", "admin8576", "2016-08-13 07:00:00", "103.246.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6751", "1", "admin8576", "2016-08-13 07:05:47", "77.28.93.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6752", "1", "admin8576", "2016-08-13 07:07:53", "165.255.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6753", "1", "admin8576", "2016-08-13 07:08:59", "201.73.243.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6754", "1", "admin8576", "2016-08-13 07:09:23", "222.167.142.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6755", "1", "admin8576", "2016-08-13 07:10:32", "89.216.90.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6756", "1", "admin8576", "2016-08-13 07:11:16", "27.106.13.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6757", "1", "admin8576", "2016-08-13 07:11:52", "124.104.47.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6758", "1", "admin8576", "2016-08-13 07:12:31", "24.112.164.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6759", "1", "admin8576", "2016-08-13 07:15:12", "189.13.211.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6760", "1", "admin8576", "2016-08-13 07:15:13", "118.70.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6761", "1", "admin8576", "2016-08-13 07:16:10", "183.83.186.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6762", "1", "admin8576", "2016-08-13 07:16:12", "109.101.110.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6763", "1", "admin8576", "2016-08-13 07:18:19", "186.213.124.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6764", "1", "admin8576", "2016-08-13 07:20:09", "1.186.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6765", "1", "admin8576", "2016-08-13 07:21:56", "112.134.199.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6766", "1", "admin8576", "2016-08-13 07:22:23", "49.142.87.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6767", "1", "admin8576", "2016-08-13 07:24:20", "145.132.220.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6768", "1", "admin8576", "2016-08-13 07:27:48", "202.166.207.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6769", "1", "admin8576", "2016-08-13 07:29:06", "92.97.88.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6770", "1", "admin8576", "2016-08-13 07:29:39", "139.192.153.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6771", "1", "admin8576", "2016-08-13 07:29:47", "39.32.41.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6772", "1", "admin8576", "2016-08-13 07:30:27", "154.126.97.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6773", "1", "admin8576", "2016-08-13 07:30:43", "65.29.122.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6774", "1", "admin8576", "2016-08-13 07:31:08", "42.60.206.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6775", "1", "admin8576", "2016-08-13 07:34:42", "197.225.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6776", "1", "admin8576", "2016-08-13 07:36:57", "85.53.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6777", "1", "admin8576", "2016-08-13 07:37:21", "181.135.44.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6778", "1", "admin8576", "2016-08-13 07:37:44", "107.194.145.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6779", "1", "admin8576", "2016-08-13 07:39:19", "108.90.157.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6780", "1", "admin8576", "2016-08-13 07:41:30", "101.179.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6781", "1", "admin8576", "2016-08-13 07:42:01", "36.84.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6782", "1", "admin8576", "2016-08-13 07:42:09", "103.230.37.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6783", "1", "admin8576", "2016-08-13 07:44:01", "36.72.95.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6784", "1", "admin8576", "2016-08-13 07:44:04", "172.196.69.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6785", "1", "admin8576", "2016-08-13 07:46:06", "185.120.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6786", "1", "admin8576", "2016-08-13 07:46:38", "186.251.46.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6787", "1", "admin8576", "2016-08-13 07:47:38", "1.2.229.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6788", "1", "admin8576", "2016-08-13 07:49:51", "71.219.218.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6789", "1", "admin8576", "2016-08-13 07:52:05", "103.48.198.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6790", "1", "admin8576", "2016-08-13 07:52:53", "46.40.228.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6791", "1", "admin8576", "2016-08-13 07:54:12", "105.224.245.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6792", "1", "admin8576", "2016-08-13 07:59:21", "36.73.107.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6793", "1", "admin8576", "2016-08-13 08:02:22", "103.198.28.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6794", "1", "admin8576", "2016-08-13 08:02:57", "152.226.7.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6795", "1", "admin8576", "2016-08-13 08:04:42", "59.89.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6796", "1", "admin8576", "2016-08-13 08:05:59", "101.190.238.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6797", "1", "admin8576", "2016-08-13 08:06:56", "122.171.109.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6798", "1", "admin8576", "2016-08-13 08:07:07", "123.200.6.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6799", "1", "admin8576", "2016-08-13 08:07:36", "85.108.221.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6800", "1", "admin8576", "2016-08-13 08:07:46", "185.113.96.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6801", "1", "admin8576", "2016-08-13 08:08:27", "31.215.31.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6802", "1", "admin8576", "2016-08-13 08:10:40", "2.233.125.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6803", "1", "admin8576", "2016-08-13 08:13:05", "117.201.201.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6804", "1", "admin8576", "2016-08-13 08:16:31", "126.219.175.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6805", "1", "admin8576", "2016-08-13 08:20:57", "176.222.40.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6806", "1", "admin8576", "2016-08-13 08:21:59", "118.179.236.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6807", "1", "admin8576", "2016-08-13 08:25:13", "197.40.36.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6808", "1", "admin8576", "2016-08-13 08:33:09", "150.129.166.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6809", "1", "admin8576", "2016-08-13 08:37:13", "43.225.193.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6810", "1", "admin8576", "2016-08-13 08:38:47", "72.35.169.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6811", "1", "admin8576", "2016-08-13 08:39:57", "113.193.172.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6812", "1", "admin8576", "2016-08-13 08:46:07", "27.114.179.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6813", "1", "admin8576", "2016-08-13 08:55:31", "103.236.177.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6814", "1", "admin8576", "2016-08-13 09:14:42", "117.195.170.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6815", "1", "admin8576", "2016-08-13 09:15:02", "213.233.203.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6816", "1", "admin8576", "2016-08-13 09:45:58", "27.4.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6817", "1", "admin8576", "2016-08-13 10:10:10", "58.97.155.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6818", "1", "admin8576", "2016-08-13 10:16:47", "82.159.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6819", "1", "admin8576", "2016-08-13 10:17:59", "41.207.162.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6820", "1", "admin8576", "2016-08-13 10:18:02", "117.203.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6821", "1", "admin8576", "2016-08-13 11:34:24", "79.180.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6822", "1", "admin8576", "2016-08-13 11:50:47", "109.64.135.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6823", "1", "admin8576", "2016-08-13 12:14:13", "92.8.105.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6824", "1", "admin8576", "2016-08-13 12:47:33", "37.142.67.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6825", "1", "admin8576", "2016-08-13 13:13:45", "101.183.71.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6826", "1", "admin8576", "2016-08-13 13:58:33", "27.32.9.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6827", "1", "admin8576", "2016-08-13 14:06:16", "168.167.94.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6828", "1", "admin8576", "2016-08-13 14:26:27", "39.55.14.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6829", "1", "admin8576", "2016-08-13 15:19:49", "41.141.42.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6830", "1", "admin8576", "2016-08-13 15:25:14", "98.235.76.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6831", "1", "admin8576", "2016-08-13 15:43:45", "178.61.176.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6832", "1", "admin8576", "2016-08-13 16:19:13", "182.185.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6833", "1", "admin8576", "2016-08-13 18:36:17", "62.15.52.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6834", "1", "admin8576", "2016-08-13 21:30:30", "31.10.144.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6835", "1", "admin8576", "2016-08-13 22:40:11", "95.103.208.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6836", "1", "admin8576", "2016-08-13 22:42:26", "184.57.242.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6837", "1", "admin8576", "2016-08-14 16:40:10", "82.42.181.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6838", "1", "admin8576", "2016-08-14 21:16:52", "190.213.174.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6839", "1", "admin8576", "2016-08-15 09:36:56", "123.201.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6840", "1", "admin8576", "2016-08-15 11:58:59", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6841", "1", "admin8576", "2016-08-15 11:59:00", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6842", "2", "admin5748", "2016-08-15 11:59:01", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6843", "1", "admin8576", "2016-08-16 00:28:44", "24.87.148.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6844", "1", "admin8576", "2016-08-16 07:02:54", "175.144.156.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6845", "1", "admin8576", "2016-08-17 05:46:51", "37.229.168.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6846", "1", "admin8576", "2016-08-17 12:47:09", "80.182.114.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6847", "1", "admin8576", "2016-08-17 20:39:54", "106.51.138.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6848", "1", "admin8576", "2016-08-20 06:35:31", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6849", "1", "admin8576", "2016-08-20 06:35:32", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6850", "2", "admin5748", "2016-08-20 06:35:32", "195.154.183.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6851", "0", "Admin", "2016-08-21 16:19:57", "195.154.241.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6852", "1", "admin8576", "2016-08-22 23:21:40", "69.30.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6853", "1", "admin8576", "2016-08-22 23:21:41", "69.30.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6854", "1", "admin8576", "2016-08-22 23:21:42", "69.30.223.*");
INSERT INTO `eadsk_aiowps_failed_logins` VALUES("6855", "0", "Admin", "2016-08-29 13:51:42", "195.154.237.*");

/* INSERT TABLE DATA: eadsk_aiowps_login_activity */
INSERT INTO `eadsk_aiowps_login_activity` VALUES("1", "1", "aDmin8576", "2015-08-03 06:03:55", "0000-00-00 00:00:00", "196.210.61.204", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("2", "1", "aDmin8576", "2015-08-03 08:57:47", "0000-00-00 00:00:00", "196.210.61.204", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("3", "1", "aDmin8576", "2015-08-11 14:57:06", "2015-08-11 15:04:15", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("4", "1", "aDmin8576", "2015-08-11 14:59:57", "2015-08-11 15:04:15", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("5", "1", "aDmin8576", "2015-08-11 15:16:59", "0000-00-00 00:00:00", "196.215.124.132", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("6", "1", "aDmin8576", "2015-08-21 15:08:21", "2015-08-21 16:43:54", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("7", "1", "aDmin8576", "2015-08-21 16:42:19", "2015-08-21 16:43:54", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("8", "1", "aDmin8576", "2015-08-21 16:57:24", "0000-00-00 00:00:00", "196.215.100.36", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("9", "1", "aDmin8576", "2015-08-25 15:33:53", "2015-08-26 10:13:38", "196.210.16.42", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("10", "1", "aDmin8576", "2015-08-26 10:11:05", "2015-08-26 10:13:38", "196.210.16.42", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("11", "1", "aDmin8576", "2015-08-28 13:25:13", "0000-00-00 00:00:00", "196.210.16.42", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("12", "1", "aDmin8576", "2015-09-17 11:14:22", "0000-00-00 00:00:00", "196.210.61.194", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("13", "1", "aDmin8576", "2015-09-19 11:17:27", "0000-00-00 00:00:00", "41.13.12.197", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("14", "1", "aDmin8576", "2015-10-01 21:40:37", "0000-00-00 00:00:00", "196.210.61.159", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("15", "1", "aDmin8576", "2015-10-16 11:38:17", "0000-00-00 00:00:00", "196.210.45.106", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("16", "1", "aDmin8576", "2015-10-21 11:40:56", "0000-00-00 00:00:00", "196.210.45.245", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("17", "1", "aDmin8576", "2015-10-27 16:49:52", "0000-00-00 00:00:00", "196.215.84.33", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("18", "1", "aDmin8576", "2015-11-03 13:49:38", "2015-11-03 14:37:19", "196.215.0.112", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("19", "1", "aDmin8576", "2015-11-09 17:15:30", "2015-11-12 13:10:00", "196.215.0.112", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("20", "1", "aDmin8576", "2015-11-12 12:57:18", "2015-11-12 13:10:00", "196.215.0.112", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("21", "2", "aDmin5748", "2015-11-12 13:10:24", "2015-11-12 15:18:55", "196.215.0.112", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("22", "2", "aDmin5748", "2015-11-13 14:17:03", "2015-11-13 15:36:13", "196.210.173.234", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("23", "2", "aDmin5748", "2015-12-15 20:26:51", "0000-00-00 00:00:00", "41.13.220.23", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("24", "2", "aDmin5748", "2015-12-15 21:46:06", "2015-12-15 21:47:14", "41.13.224.178", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("25", "2", "aDmin5748", "2015-12-17 14:58:05", "0000-00-00 00:00:00", "41.13.192.171", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("26", "2", "aDmin5748", "2016-02-01 11:17:03", "0000-00-00 00:00:00", "196.210.45.124", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("27", "2", "aDmin5748", "2016-02-12 22:10:14", "0000-00-00 00:00:00", "196.215.84.55", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("28", "2", "aDmin5748", "2016-02-16 11:37:01", "0000-00-00 00:00:00", "196.215.84.106", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("29", "2", "aDmin5748", "2016-02-24 08:19:46", "0000-00-00 00:00:00", "196.210.62.32", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("30", "2", "aDmin5748", "2016-03-04 10:54:28", "0000-00-00 00:00:00", "196.210.61.137", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("31", "2", "aDmin5748", "2016-03-21 07:22:23", "0000-00-00 00:00:00", "197.228.248.59", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("32", "2", "aDmin5748", "2016-04-21 04:01:37", "0000-00-00 00:00:00", "196.215.34.63", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("33", "2", "aDmin5748", "2016-04-21 17:23:32", "0000-00-00 00:00:00", "196.215.34.63", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("34", "2", "aDmin5748", "2016-05-12 08:20:51", "0000-00-00 00:00:00", "196.210.229.220", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("35", "2", "aDmin5748", "2016-06-02 11:13:23", "0000-00-00 00:00:00", "196.215.98.97", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("36", "2", "aDmin5748", "2016-06-14 11:11:39", "0000-00-00 00:00:00", "196.215.98.117", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("37", "2", "aDmin5748", "2016-06-29 15:12:43", "0000-00-00 00:00:00", "196.215.84.21", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("38", "2", "aDmin5748", "2016-06-30 13:23:06", "0000-00-00 00:00:00", "196.215.84.21", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("39", "2", "aDmin5748", "2016-07-05 00:18:26", "0000-00-00 00:00:00", "196.210.173.248", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("40", "2", "aDmin5748", "2016-07-19 15:40:53", "0000-00-00 00:00:00", "196.215.53.7", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("41", "2", "aDmin5748", "2016-08-30 15:24:39", "0000-00-00 00:00:00", "196.210.61.171", "", "");
INSERT INTO `eadsk_aiowps_login_activity` VALUES("42", "2", "aDmin5748", "2016-09-01 09:14:57", "0000-00-00 00:00:00", "196.210.45.38", "", "");

/* INSERT TABLE DATA: eadsk_aiowps_login_lockdown */
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1", "0", "magma", "2015-08-21 17:19:16", "2015-08-21 18:19:16", "201.22.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2", "0", "magma", "2015-08-21 17:55:24", "2015-08-21 18:55:24", "2.51.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("3", "0", "magma", "2015-08-21 18:52:25", "2015-08-21 19:52:25", "39.44.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("4", "0", "magma", "2015-08-21 19:16:14", "2015-08-21 20:16:14", "94.121.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("5", "0", "magma", "2015-08-21 19:38:04", "2015-08-21 20:38:04", "201.248.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("6", "0", "magma", "2015-08-22 00:05:46", "2015-08-22 01:05:46", "85.74.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("7", "0", "magma", "2015-08-22 01:28:54", "2015-08-22 02:28:54", "37.0.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("8", "0", "magma", "2015-08-22 01:47:23", "2015-08-22 02:47:23", "175.113.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("9", "0", "magma", "2015-08-22 03:13:05", "2015-08-22 04:13:05", "112.203.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("10", "0", "magma", "2015-08-22 06:04:07", "2015-08-22 07:04:07", "86.125.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("11", "0", "magma", "2015-08-22 07:55:37", "2015-08-22 08:55:37", "37.114.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("12", "0", "magma", "2015-08-22 09:02:46", "2015-08-22 10:02:46", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("13", "0", "magma", "2015-08-22 09:43:11", "2015-08-22 10:43:11", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("14", "0", "magma", "2015-08-22 10:28:36", "2015-08-22 11:28:36", "109.224.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("15", "0", "magma", "2015-08-22 10:50:39", "2015-08-22 11:50:39", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("16", "0", "magma", "2015-08-22 12:08:23", "2015-08-22 13:08:23", "82.78.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("17", "0", "magma", "2015-08-22 13:31:13", "2015-08-22 14:31:13", "39.42.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("18", "0", "magma", "2015-08-22 13:35:00", "2015-08-22 14:35:00", "39.44.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("19", "0", "magma", "2015-08-22 14:23:21", "2015-08-22 15:23:21", "139.195.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("20", "0", "magma", "2015-08-22 15:20:07", "2015-08-22 16:20:07", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("21", "0", "magma", "2015-08-22 16:37:14", "2015-08-22 17:37:14", "103.249.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("22", "0", "magma", "2015-08-22 17:24:11", "2015-08-22 18:24:11", "41.133.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("23", "0", "magma", "2015-08-22 18:41:19", "2015-08-22 19:41:19", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("24", "0", "magma", "2015-08-22 19:28:01", "2015-08-22 20:28:01", "109.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("25", "0", "magma", "2015-08-22 19:33:33", "2015-08-22 20:33:33", "79.180.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("26", "0", "magma", "2015-08-22 19:46:16", "2015-08-22 20:46:16", "190.167.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("27", "0", "magma", "2015-08-22 22:12:01", "2015-08-22 23:12:01", "95.187.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("28", "0", "magma", "2015-08-23 00:17:03", "2015-08-23 01:17:03", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("29", "0", "magma", "2015-08-23 02:41:05", "2015-08-23 03:41:05", "109.245.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("30", "0", "magma", "2015-08-23 03:46:03", "2015-08-23 04:46:03", "183.91.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("31", "0", "magma", "2015-08-23 03:51:16", "2015-08-23 04:51:16", "87.16.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("32", "0", "magma", "2015-08-23 04:16:52", "2015-08-23 05:16:52", "178.221.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("33", "0", "magma", "2015-08-23 05:12:02", "2015-08-23 06:12:02", "109.245.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("34", "0", "magma", "2015-08-23 05:21:10", "2015-08-23 06:21:10", "1.1.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("35", "0", "magma", "2015-08-23 05:36:32", "2015-08-23 06:36:32", "179.105.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("36", "0", "magma", "2015-08-23 07:12:14", "2015-08-23 08:12:14", "188.26.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("37", "0", "magma", "2015-08-23 16:53:44", "2015-08-23 17:53:44", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("38", "0", "magma", "2015-08-23 17:00:17", "2015-08-23 18:00:17", "110.139.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("39", "0", "magma", "2015-08-23 17:20:42", "2015-08-23 18:20:42", "103.224.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("40", "0", "magma", "2015-08-23 17:44:56", "2015-08-23 18:44:56", "186.123.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("41", "0", "magma", "2015-08-23 18:17:09", "2015-08-23 19:17:09", "178.221.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("42", "0", "magma", "2015-08-23 19:59:00", "2015-08-23 20:59:00", "88.245.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("43", "0", "magma", "2015-08-23 21:44:23", "2015-08-23 22:44:23", "93.87.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("44", "0", "magma", "2015-08-24 00:07:13", "2015-08-24 01:07:13", "177.229.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("45", "0", "magma", "2015-08-24 01:27:09", "2015-08-24 02:27:09", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("46", "0", "magma", "2015-08-24 03:51:51", "2015-08-24 04:51:51", "5.12.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("47", "0", "magma", "2015-08-24 03:52:20", "2015-08-24 04:52:20", "95.245.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("48", "0", "magma", "2015-08-24 07:12:50", "2015-08-24 08:12:50", "14.141.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("49", "0", "magma", "2015-08-24 07:38:53", "2015-08-24 08:38:53", "113.20.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("50", "0", "magma", "2015-08-24 08:20:58", "2015-08-24 09:20:58", "87.68.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("51", "0", "magma", "2015-08-24 11:58:51", "2015-08-24 12:58:51", "87.10.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("52", "0", "magma", "2015-08-24 12:04:21", "2015-08-24 13:04:21", "151.247.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("53", "0", "magma", "2015-08-24 16:01:18", "2015-08-24 17:01:18", "182.185.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("54", "0", "magma", "2015-08-24 17:52:17", "2015-08-24 18:52:17", "64.237.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("55", "0", "magma", "2015-08-24 19:10:01", "2015-08-24 20:10:01", "210.195.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("56", "0", "magma", "2015-08-24 20:02:27", "2015-08-24 21:02:27", "79.101.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("57", "0", "magma", "2015-08-24 21:58:32", "2015-08-24 22:58:32", "130.204.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("58", "0", "magma", "2015-08-24 23:28:40", "2015-08-25 00:28:40", "46.40.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("59", "0", "magma", "2015-08-25 04:06:02", "2015-08-25 05:06:02", "179.24.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("60", "0", "magma", "2015-08-25 04:43:49", "2015-08-25 05:43:49", "69.47.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("61", "0", "magma", "2015-08-25 08:49:17", "2015-08-25 09:49:17", "86.125.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("62", "0", "magma", "2015-08-25 10:41:07", "2015-08-25 11:41:07", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("63", "0", "magma", "2015-08-25 12:45:40", "2015-08-25 13:45:40", "115.66.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("64", "0", "magma", "2015-08-25 17:36:32", "2015-08-25 18:36:32", "39.50.206.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("65", "0", "magma", "2015-08-25 19:00:08", "2015-08-25 20:00:08", "92.97.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("66", "0", "magma", "2015-08-25 19:35:45", "2015-08-25 20:35:45", "41.133.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("67", "0", "magma", "2015-08-25 20:58:01", "2015-08-25 21:58:01", "182.178.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("68", "0", "magma", "2015-08-25 23:12:53", "2015-08-26 00:12:53", "93.86.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("69", "0", "magma", "2015-08-26 02:23:39", "2015-08-26 03:23:39", "181.120.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("70", "0", "magma", "2015-08-26 03:45:34", "2015-08-26 04:45:34", "189.26.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("71", "0", "magma", "2015-08-26 05:19:48", "2015-08-26 06:19:48", "200.158.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("72", "0", "magma", "2015-08-26 05:46:01", "2015-08-26 06:46:01", "37.27.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("73", "0", "magma", "2015-08-26 11:46:49", "2015-08-26 12:46:49", "92.80.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("74", "0", "magma", "2015-08-26 13:25:13", "2015-08-26 14:25:13", "82.166.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("75", "0", "magma", "2015-08-26 13:59:35", "2015-08-26 14:59:35", "39.42.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("76", "0", "magma", "2015-08-26 14:00:36", "2015-08-26 15:00:36", "39.42.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("77", "0", "magma", "2015-08-26 15:32:42", "2015-08-26 16:32:42", "81.10.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("78", "0", "magma", "2015-08-26 15:38:31", "2015-08-26 16:38:31", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("79", "0", "magma", "2015-08-26 15:53:52", "2015-08-26 16:53:52", "60.51.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("80", "0", "magma", "2015-08-26 17:25:30", "2015-08-26 18:25:30", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("81", "0", "magma", "2015-08-26 18:39:57", "2015-08-26 19:39:57", "201.220.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("82", "0", "magma", "2015-08-26 18:56:34", "2015-08-26 19:56:34", "202.159.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("83", "0", "magma", "2015-08-26 19:02:58", "2015-08-26 20:02:58", "81.10.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("84", "0", "magma", "2015-08-26 20:37:29", "2015-08-26 21:37:29", "202.81.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("85", "0", "magma", "2015-08-26 20:50:16", "2015-08-26 21:50:16", "78.168.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("86", "0", "magma", "2015-08-26 21:17:12", "2015-08-26 22:17:12", "2.50.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("87", "0", "magma", "2015-08-26 21:35:06", "2015-08-26 22:35:06", "69.47.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("88", "0", "magma", "2015-08-27 00:30:09", "2015-08-27 01:30:09", "78.130.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("89", "0", "magma", "2015-08-27 04:11:07", "2015-08-27 05:11:07", "81.183.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("90", "0", "magma", "2015-08-27 04:21:24", "2015-08-27 05:21:24", "95.180.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("91", "1", "admin8576", "2015-08-27 04:58:18", "2015-08-27 05:58:18", "62.14.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("92", "0", "magma", "2015-08-27 07:57:21", "2015-08-27 08:57:21", "101.50.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("93", "0", "magma", "2015-08-27 10:25:29", "2015-08-27 11:25:29", "109.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("94", "0", "magma", "2015-08-27 10:39:49", "2015-08-27 11:39:49", "182.185.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("95", "0", "magma", "2015-08-27 12:08:53", "2015-08-27 13:08:53", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("96", "0", "magma", "2015-08-27 12:33:37", "2015-08-27 13:33:37", "115.133.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("97", "0", "magma", "2015-08-27 14:28:02", "2015-08-27 15:28:02", "42.113.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("98", "0", "magma", "2015-08-27 15:53:57", "2015-08-27 16:53:57", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("99", "0", "magma", "2015-08-27 17:06:34", "2015-08-27 18:06:34", "42.61.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("100", "0", "magma", "2015-08-27 20:24:15", "2015-08-27 21:24:15", "94.126.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("101", "0", "magma", "2015-08-27 21:54:14", "2015-08-27 22:54:14", "78.56.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("102", "0", "magma", "2015-08-28 00:06:22", "2015-08-28 01:06:22", "190.198.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("103", "0", "magma", "2015-08-28 00:11:34", "2015-08-28 01:11:34", "78.168.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("104", "0", "magma", "2015-08-28 01:11:50", "2015-08-28 02:11:50", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("105", "0", "magma", "2015-08-28 06:48:19", "2015-08-28 07:48:19", "79.134.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("106", "0", "magma", "2015-08-28 07:23:45", "2015-08-28 08:23:45", "190.198.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("107", "0", "magma", "2015-08-28 07:41:34", "2015-08-28 08:41:34", "94.189.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("108", "0", "magma", "2015-08-28 08:24:10", "2015-08-28 09:24:10", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("109", "0", "magma", "2015-08-28 10:06:02", "2015-08-28 11:06:02", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("110", "0", "magma", "2015-08-28 10:37:14", "2015-08-28 11:37:14", "178.126.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("111", "0", "magma", "2015-08-28 13:11:50", "2015-08-28 14:11:50", "89.41.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("112", "0", "magma", "2015-08-28 14:16:06", "2015-08-28 15:16:06", "197.88.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("113", "0", "magma", "2015-08-28 14:39:06", "2015-08-28 15:39:06", "139.193.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("114", "0", "magma", "2015-08-28 19:01:21", "2015-08-28 20:01:21", "84.228.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("115", "0", "magma", "2015-08-28 20:29:41", "2015-08-28 21:29:41", "86.126.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("116", "0", "magma", "2015-08-28 20:38:29", "2015-08-28 21:38:29", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("117", "0", "magma", "2015-08-29 09:36:50", "2015-08-29 10:36:50", "1.1.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("118", "0", "magma", "2015-08-29 10:57:00", "2015-08-29 11:57:00", "39.42.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("119", "0", "magma", "2015-08-29 11:11:58", "2015-08-29 12:11:58", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("120", "0", "magma", "2015-08-29 14:23:17", "2015-08-29 15:23:17", "217.119.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("121", "0", "magma", "2015-08-29 15:30:15", "2015-08-29 16:30:15", "87.120.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("122", "0", "magma", "2015-08-29 16:05:32", "2015-08-29 17:05:32", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("123", "0", "magma", "2015-08-29 16:34:53", "2015-08-29 17:34:53", "39.32.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("124", "0", "magma", "2015-08-29 20:52:51", "2015-08-29 21:52:51", "86.38.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("125", "0", "magma", "2015-08-30 02:52:50", "2015-08-30 03:52:50", "180.234.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("126", "0", "magma", "2015-08-30 04:32:09", "2015-08-30 05:32:09", "109.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("127", "0", "magma", "2015-08-30 05:38:59", "2015-08-30 06:38:59", "180.234.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("128", "0", "magma", "2015-08-30 05:52:23", "2015-08-30 06:52:23", "79.115.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("129", "0", "magma", "2015-08-30 06:44:05", "2015-08-30 07:44:05", "121.98.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("130", "0", "magma", "2015-08-30 11:57:13", "2015-08-30 12:57:13", "202.81.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("131", "0", "magma", "2015-08-30 17:37:04", "2015-08-30 18:37:04", "79.182.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("132", "0", "magma", "2015-08-30 17:57:09", "2015-08-30 18:57:09", "84.228.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("133", "0", "magma", "2015-08-30 18:41:14", "2015-08-30 19:41:14", "95.180.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("134", "0", "magma", "2015-08-30 20:04:46", "2015-08-30 21:04:46", "45.118.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("135", "0", "magma", "2015-08-30 20:14:40", "2015-08-30 21:14:40", "37.252.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("136", "0", "magma", "2015-08-30 20:16:11", "2015-08-30 21:16:11", "41.133.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("137", "0", "magma", "2015-08-30 20:43:59", "2015-08-30 21:43:59", "109.57.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("138", "0", "magma", "2015-08-30 20:49:30", "2015-08-30 21:49:30", "89.41.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("139", "0", "magma", "2015-08-30 20:51:51", "2015-08-30 21:51:51", "105.158.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("140", "0", "magma", "2015-08-30 22:05:17", "2015-08-30 23:05:17", "103.19.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("141", "0", "magma", "2015-08-31 02:29:25", "2015-08-31 03:29:25", "122.3.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("142", "0", "magma", "2015-08-31 08:32:10", "2015-08-31 09:32:10", "103.249.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("143", "0", "magma", "2015-08-31 10:40:05", "2015-08-31 11:40:05", "112.198.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("144", "0", "magma", "2015-08-31 11:15:23", "2015-08-31 12:15:23", "182.185.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("145", "0", "magma", "2015-08-31 11:26:07", "2015-08-31 12:26:07", "217.119.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("146", "0", "magma", "2015-08-31 11:32:39", "2015-08-31 12:32:39", "39.44.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("147", "0", "magma", "2015-08-31 12:15:35", "2015-08-31 13:15:35", "1.1.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("148", "0", "magma", "2015-08-31 17:58:56", "2015-08-31 18:58:56", "64.237.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("149", "0", "magma", "2015-08-31 22:14:41", "2015-08-31 23:14:41", "41.41.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("150", "0", "magma", "2015-08-31 23:35:13", "2015-09-01 00:35:13", "109.76.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("151", "0", "magma", "2015-09-01 01:52:21", "2015-09-01 02:52:21", "5.45.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("152", "0", "magma", "2015-09-01 02:00:29", "2015-09-01 03:00:29", "41.99.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("153", "0", "magma", "2015-09-01 02:38:09", "2015-09-01 03:38:09", "37.27.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("154", "0", "magma", "2015-09-01 04:54:09", "2015-09-01 05:54:09", "190.167.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("155", "0", "magma", "2015-09-01 05:26:30", "2015-09-01 06:26:30", "37.27.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("156", "0", "magma", "2015-09-01 08:04:03", "2015-09-01 09:04:03", "115.134.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("157", "0", "magma", "2015-09-01 08:26:01", "2015-09-01 09:26:01", "10.0.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("158", "0", "magma", "2015-09-01 09:24:03", "2015-09-01 10:24:03", "81.182.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("159", "0", "magma", "2015-09-01 09:47:12", "2015-09-01 10:47:12", "14.141.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("160", "0", "admin", "2015-09-01 13:02:49", "2015-09-01 14:02:49", "109.161.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("161", "0", "magma", "2015-09-01 13:47:45", "2015-09-01 14:47:45", "182.178.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("162", "0", "magma", "2015-09-01 15:47:30", "2015-09-01 16:47:30", "112.207.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("163", "0", "magma", "2015-09-01 18:19:59", "2015-09-01 19:19:59", "49.229.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("164", "0", "admin", "2015-09-01 20:02:14", "2015-09-01 21:02:14", "134.255.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("165", "0", "magma", "2015-09-01 23:28:17", "2015-09-02 00:28:17", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("166", "0", "magma", "2015-09-02 03:06:49", "2015-09-02 04:06:49", "188.159.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("167", "0", "magma", "2015-09-02 03:46:39", "2015-09-02 04:46:39", "81.183.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("168", "0", "magma", "2015-09-02 09:23:27", "2015-09-02 10:23:27", "200.90.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("169", "0", "magma", "2015-09-02 09:40:47", "2015-09-02 10:40:47", "175.136.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("170", "1", "admin8576", "2015-09-02 13:28:05", "2015-09-02 14:28:05", "52.27.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("171", "0", "magma", "2015-09-02 16:24:33", "2015-09-02 17:24:33", "180.191.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("172", "0", "magma", "2015-09-02 18:07:52", "2015-09-02 19:07:52", "5.0.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("173", "0", "magma", "2015-09-02 18:43:24", "2015-09-02 19:43:24", "78.130.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("174", "0", "magma", "2015-09-02 18:57:50", "2015-09-02 19:57:50", "2.50.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("175", "0", "magma", "2015-09-02 21:41:09", "2015-09-02 22:41:09", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("176", "0", "magma", "2015-09-03 00:34:59", "2015-09-03 01:34:59", "45.118.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("177", "0", "magma", "2015-09-03 05:40:18", "2015-09-03 06:40:18", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("178", "0", "admin", "2015-09-03 08:14:12", "2015-09-03 09:14:12", "185.24.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("179", "0", "admin", "2015-09-03 08:14:13", "2015-09-03 09:14:13", "207.201.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("180", "0", "admin", "2015-09-03 08:18:34", "2015-09-03 09:18:34", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("181", "0", "admin", "2015-09-03 09:26:10", "2015-09-03 10:26:10", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("182", "0", "magma", "2015-09-03 12:33:28", "2015-09-03 13:33:28", "188.79.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("183", "0", "admin", "2015-09-03 13:26:41", "2015-09-03 14:26:41", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("184", "0", "admin", "2015-09-03 13:26:41", "2015-09-03 14:26:41", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("185", "0", "admin", "2015-09-03 13:26:41", "2015-09-03 14:26:41", "5.189.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("186", "0", "admin", "2015-09-03 13:26:45", "2015-09-03 14:26:45", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("187", "0", "admin", "2015-09-03 13:26:47", "2015-09-03 14:26:47", "185.77.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("188", "0", "magma", "2015-09-03 15:16:43", "2015-09-03 16:16:43", "182.185.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("189", "0", "magma", "2015-09-03 17:59:44", "2015-09-03 18:59:44", "84.109.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("190", "0", "magma", "2015-09-03 19:26:46", "2015-09-03 20:26:46", "182.185.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("191", "0", "magma", "2015-09-03 20:37:53", "2015-09-03 21:37:53", "182.185.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("192", "1", "admin8576", "2015-09-03 20:46:35", "2015-09-03 21:46:35", "52.27.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("193", "0", "magma", "2015-09-03 23:11:25", "2015-09-04 00:11:25", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("194", "0", "admin", "2015-09-03 23:37:09", "2015-09-04 00:37:09", "128.68.255.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("195", "0", "admin", "2015-09-03 23:37:09", "2015-09-04 00:37:09", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("196", "0", "admin", "2015-09-03 23:37:11", "2015-09-04 00:37:11", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("197", "0", "admin", "2015-09-03 23:37:11", "2015-09-04 00:37:11", "195.228.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("198", "0", "admin", "2015-09-03 23:37:22", "2015-09-04 00:37:22", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("199", "0", "magma", "2015-09-04 01:28:00", "2015-09-04 02:28:00", "79.114.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("200", "0", "magma", "2015-09-04 02:33:38", "2015-09-04 03:33:38", "79.114.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("201", "0", "admin", "2015-09-04 08:25:25", "2015-09-04 09:25:25", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("202", "0", "admin", "2015-09-04 08:25:25", "2015-09-04 09:25:25", "5.135.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("203", "0", "admin", "2015-09-04 08:25:25", "2015-09-04 09:25:25", "96.44.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("204", "0", "admin", "2015-09-04 08:25:26", "2015-09-04 09:25:26", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("205", "0", "admin", "2015-09-04 08:25:26", "2015-09-04 09:25:26", "185.62.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("206", "0", "magma", "2015-09-04 12:09:03", "2015-09-04 13:09:03", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("207", "0", "magma", "2015-09-04 13:06:39", "2015-09-04 14:06:39", "31.46.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("208", "0", "magma", "2015-09-04 14:45:52", "2015-09-04 15:45:52", "31.46.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("209", "0", "magma", "2015-09-04 17:21:20", "2015-09-04 18:21:20", "178.164.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("210", "0", "magma", "2015-09-04 17:25:29", "2015-09-04 18:25:29", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("211", "0", "magma", "2015-09-04 17:37:13", "2015-09-04 18:37:13", "94.203.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("212", "0", "admin", "2015-09-04 17:54:48", "2015-09-04 18:54:48", "78.108.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("213", "0", "admin", "2015-09-04 17:54:49", "2015-09-04 18:54:49", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("214", "0", "admin", "2015-09-04 17:54:50", "2015-09-04 18:54:50", "178.16.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("215", "0", "admin", "2015-09-04 17:54:51", "2015-09-04 18:54:51", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("216", "0", "admin", "2015-09-04 17:54:52", "2015-09-04 18:54:52", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("217", "0", "admin", "2015-09-05 03:24:17", "2015-09-05 04:24:17", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("218", "0", "admin", "2015-09-05 03:24:18", "2015-09-05 04:24:18", "173.254.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("219", "0", "admin", "2015-09-05 03:24:18", "2015-09-05 04:24:18", "5.135.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("220", "0", "magma", "2015-09-05 04:07:15", "2015-09-05 05:07:15", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("221", "0", "magma", "2015-09-05 04:10:57", "2015-09-05 05:10:57", "190.46.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("222", "0", "magma", "2015-09-05 04:39:31", "2015-09-05 05:39:31", "151.25.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("223", "0", "magma", "2015-09-05 06:33:43", "2015-09-05 07:33:43", "103.58.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("224", "0", "magma", "2015-09-05 09:31:49", "2015-09-05 10:31:49", "103.19.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("225", "0", "magma", "2015-09-05 13:02:54", "2015-09-05 14:02:54", "5.154.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("226", "0", "magma", "2015-09-05 14:14:35", "2015-09-05 15:14:35", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("227", "0", "magma", "2015-09-05 15:09:11", "2015-09-05 16:09:11", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("228", "0", "magma", "2015-09-05 15:37:39", "2015-09-05 16:37:39", "37.27.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("229", "0", "magma", "2015-09-05 15:57:13", "2015-09-05 16:57:13", "115.76.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("230", "0", "magma", "2015-09-05 16:23:11", "2015-09-05 17:23:11", "116.88.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("231", "0", "magma", "2015-09-05 19:27:03", "2015-09-05 20:27:03", "94.177.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("232", "0", "magma", "2015-09-05 20:29:37", "2015-09-05 21:29:37", "103.224.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("233", "0", "magma", "2015-09-06 04:48:54", "2015-09-06 05:48:54", "178.238.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("234", "0", "magma", "2015-09-06 06:28:00", "2015-09-06 07:28:00", "2.50.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("235", "0", "magma", "2015-09-06 12:05:39", "2015-09-06 13:05:39", "112.209.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("236", "0", "magma", "2015-09-06 12:33:20", "2015-09-06 13:33:20", "94.227.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("237", "0", "magma", "2015-09-06 13:12:30", "2015-09-06 14:12:30", "182.185.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("238", "0", "magma", "2015-09-06 14:43:01", "2015-09-06 15:43:01", "89.39.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("239", "0", "magma", "2015-09-06 14:53:41", "2015-09-06 15:53:41", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("240", "0", "magma", "2015-09-06 16:39:03", "2015-09-06 17:39:03", "210.195.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("241", "0", "magma", "2015-09-06 18:20:33", "2015-09-06 19:20:33", "79.185.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("242", "0", "magma", "2015-09-06 19:23:07", "2015-09-06 20:23:07", "185.76.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("243", "0", "magma", "2015-09-06 22:34:39", "2015-09-06 23:34:39", "190.204.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("244", "0", "magma", "2015-09-07 03:26:49", "2015-09-07 04:26:49", "187.194.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("245", "0", "magma", "2015-09-07 04:50:46", "2015-09-07 05:50:46", "78.92.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("246", "0", "magma", "2015-09-07 12:39:33", "2015-09-07 13:39:33", "1.1.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("247", "0", "magma", "2015-09-07 14:46:44", "2015-09-07 15:46:44", "212.90.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("248", "0", "magma", "2015-09-07 14:50:41", "2015-09-07 15:50:41", "208.168.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("249", "0", "magma", "2015-09-07 14:53:53", "2015-09-07 15:53:53", "180.191.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("250", "0", "magma", "2015-09-07 14:58:43", "2015-09-07 15:58:43", "41.69.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("251", "0", "magma", "2015-09-07 15:09:02", "2015-09-07 16:09:02", "217.75.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("252", "0", "magma", "2015-09-07 15:18:37", "2015-09-07 16:18:37", "109.229.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("253", "0", "magma", "2015-09-07 15:38:06", "2015-09-07 16:38:06", "79.47.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("254", "0", "magma", "2015-09-07 15:38:59", "2015-09-07 16:38:59", "59.93.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("255", "0", "magma", "2015-09-07 15:43:01", "2015-09-07 16:43:01", "86.14.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("256", "0", "magma", "2015-09-07 15:43:13", "2015-09-07 16:43:13", "81.217.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("257", "0", "magma", "2015-09-07 15:47:22", "2015-09-07 16:47:22", "203.210.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("258", "0", "magma", "2015-09-07 15:49:06", "2015-09-07 16:49:06", "200.120.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("259", "0", "magma", "2015-09-07 15:55:07", "2015-09-07 16:55:07", "194.143.147.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("260", "0", "magma", "2015-09-07 16:05:49", "2015-09-07 17:05:49", "145.132.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("261", "0", "magma", "2015-09-07 16:07:18", "2015-09-07 17:07:18", "212.109.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("262", "0", "magma", "2015-09-07 16:07:49", "2015-09-07 17:07:49", "220.240.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("263", "0", "magma", "2015-09-07 16:12:25", "2015-09-07 17:12:25", "112.208.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("264", "0", "magma", "2015-09-07 16:31:00", "2015-09-07 17:31:00", "41.76.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("265", "0", "magma", "2015-09-07 16:31:49", "2015-09-07 17:31:49", "5.102.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("266", "0", "magma", "2015-09-07 16:32:21", "2015-09-07 17:32:21", "42.119.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("267", "0", "magma", "2015-09-07 16:41:11", "2015-09-07 17:41:11", "78.186.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("268", "0", "magma", "2015-09-07 16:43:34", "2015-09-07 17:43:34", "31.154.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("269", "0", "magma", "2015-09-07 16:45:05", "2015-09-07 17:45:05", "81.89.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("270", "0", "magma", "2015-09-07 16:50:14", "2015-09-07 17:50:14", "86.14.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("271", "0", "magma", "2015-09-07 16:52:35", "2015-09-07 17:52:35", "85.138.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("272", "0", "magma", "2015-09-07 16:53:32", "2015-09-07 17:53:32", "81.149.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("273", "0", "magma", "2015-09-07 17:01:06", "2015-09-07 18:01:06", "89.153.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("274", "0", "magma", "2015-09-07 17:10:12", "2015-09-07 18:10:12", "81.82.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("275", "0", "magma", "2015-09-07 17:14:13", "2015-09-07 18:14:13", "83.58.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("276", "0", "magma", "2015-09-07 17:17:06", "2015-09-07 18:17:06", "163.152.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("277", "0", "magma", "2015-09-07 17:28:21", "2015-09-07 18:28:21", "76.76.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("278", "0", "magma", "2015-09-07 17:37:34", "2015-09-07 18:37:34", "118.136.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("279", "0", "magma", "2015-09-07 17:38:17", "2015-09-07 18:38:17", "160.80.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("280", "0", "magma", "2015-09-07 17:42:43", "2015-09-07 18:42:43", "62.195.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("281", "0", "magma", "2015-09-07 17:45:01", "2015-09-07 18:45:01", "2.39.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("282", "0", "magma", "2015-09-07 17:48:53", "2015-09-07 18:48:53", "1.32.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("283", "0", "magma", "2015-09-07 17:50:24", "2015-09-07 18:50:24", "5.44.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("284", "0", "magma", "2015-09-07 17:54:13", "2015-09-07 18:54:13", "210.223.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("285", "0", "magma", "2015-09-07 17:57:27", "2015-09-07 18:57:27", "79.170.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("286", "0", "magma", "2015-09-07 18:00:24", "2015-09-07 19:00:24", "180.191.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("287", "0", "magma", "2015-09-07 18:05:59", "2015-09-07 19:05:59", "122.167.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("288", "0", "magma", "2015-09-07 18:14:36", "2015-09-07 19:14:36", "90.190.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("289", "0", "magma", "2015-09-07 18:18:13", "2015-09-07 19:18:13", "2.51.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("290", "0", "magma", "2015-09-07 18:18:18", "2015-09-07 19:18:18", "175.156.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("291", "0", "magma", "2015-09-07 18:22:37", "2015-09-07 19:22:37", "93.86.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("292", "0", "magma", "2015-09-07 18:27:26", "2015-09-07 19:27:26", "83.172.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("293", "0", "magma", "2015-09-07 18:28:33", "2015-09-07 19:28:33", "83.240.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("294", "0", "magma", "2015-09-07 18:28:53", "2015-09-07 19:28:53", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("295", "0", "magma", "2015-09-07 18:30:55", "2015-09-07 19:30:55", "88.192.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("296", "0", "magma", "2015-09-07 18:37:43", "2015-09-07 19:37:43", "94.228.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("297", "0", "magma", "2015-09-07 18:40:56", "2015-09-07 19:40:56", "122.57.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("298", "0", "magma", "2015-09-07 18:41:14", "2015-09-07 19:41:14", "41.215.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("299", "0", "magma", "2015-09-07 19:02:31", "2015-09-07 20:02:31", "122.177.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("300", "0", "magma", "2015-09-07 19:06:19", "2015-09-07 20:06:19", "211.223.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("301", "0", "magma", "2015-09-07 19:11:41", "2015-09-07 20:11:41", "46.121.245.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("302", "0", "magma", "2015-09-07 19:13:58", "2015-09-07 20:13:58", "183.87.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("303", "0", "magma", "2015-09-07 19:14:13", "2015-09-07 20:14:13", "109.229.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("304", "0", "magma", "2015-09-07 19:15:28", "2015-09-07 20:15:28", "109.197.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("305", "0", "magma", "2015-09-07 19:16:58", "2015-09-07 20:16:58", "181.171.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("306", "0", "magma", "2015-09-07 19:21:28", "2015-09-07 20:21:28", "109.219.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("307", "0", "magma", "2015-09-07 19:28:10", "2015-09-07 20:28:10", "47.17.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("308", "0", "magma", "2015-09-07 19:29:50", "2015-09-07 20:29:50", "79.16.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("309", "0", "magma", "2015-09-07 19:32:44", "2015-09-07 20:32:44", "220.253.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("310", "0", "magma", "2015-09-07 19:32:53", "2015-09-07 20:32:53", "37.229.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("311", "0", "magma", "2015-09-07 19:32:55", "2015-09-07 20:32:55", "121.54.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("312", "0", "magma", "2015-09-07 19:35:41", "2015-09-07 20:35:41", "24.209.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("313", "0", "magma", "2015-09-07 19:37:15", "2015-09-07 20:37:15", "61.6.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("314", "0", "magma", "2015-09-07 19:38:54", "2015-09-07 20:38:54", "151.29.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("315", "0", "magma", "2015-09-07 19:41:20", "2015-09-07 20:41:20", "109.66.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("316", "0", "magma", "2015-09-07 19:49:03", "2015-09-07 20:49:03", "79.116.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("317", "0", "magma", "2015-09-07 19:49:24", "2015-09-07 20:49:24", "98.165.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("318", "0", "magma", "2015-09-07 19:51:48", "2015-09-07 20:51:48", "89.152.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("319", "0", "magma", "2015-09-07 19:55:54", "2015-09-07 20:55:54", "188.141.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("320", "0", "magma", "2015-09-07 20:01:29", "2015-09-07 21:01:29", "37.105.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("321", "0", "magma", "2015-09-07 20:04:25", "2015-09-07 21:04:25", "177.154.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("322", "0", "magma", "2015-09-07 20:05:24", "2015-09-07 21:05:24", "203.186.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("323", "0", "magma", "2015-09-07 20:05:55", "2015-09-07 21:05:55", "68.107.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("324", "0", "magma", "2015-09-07 20:09:24", "2015-09-07 21:09:24", "39.53.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("325", "0", "magma", "2015-09-07 20:10:09", "2015-09-07 21:10:09", "124.30.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("326", "0", "magma", "2015-09-07 20:12:18", "2015-09-07 21:12:18", "14.192.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("327", "0", "magma", "2015-09-07 20:12:24", "2015-09-07 21:12:24", "81.89.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("328", "0", "magma", "2015-09-07 20:19:35", "2015-09-07 21:19:35", "109.101.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("329", "0", "magma", "2015-09-07 20:24:48", "2015-09-07 21:24:48", "77.173.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("330", "0", "magma", "2015-09-07 20:29:32", "2015-09-07 21:29:32", "200.1.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("331", "0", "magma", "2015-09-07 20:30:54", "2015-09-07 21:30:54", "67.176.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("332", "0", "magma", "2015-09-07 20:32:24", "2015-09-07 21:32:24", "210.195.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("333", "0", "magma", "2015-09-07 20:34:30", "2015-09-07 21:34:30", "24.139.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("334", "0", "magma", "2015-09-07 20:44:47", "2015-09-07 21:44:47", "93.47.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("335", "0", "magma", "2015-09-07 20:51:54", "2015-09-07 21:51:54", "94.175.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("336", "0", "magma", "2015-09-07 20:52:39", "2015-09-07 21:52:39", "186.193.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("337", "0", "magma", "2015-09-07 20:54:34", "2015-09-07 21:54:34", "176.45.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("338", "0", "magma", "2015-09-07 20:55:51", "2015-09-07 21:55:51", "222.155.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("339", "0", "magma", "2015-09-07 21:03:46", "2015-09-07 22:03:46", "103.51.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("340", "0", "magma", "2015-09-07 21:04:33", "2015-09-07 22:04:33", "41.224.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("341", "0", "magma", "2015-09-07 21:05:40", "2015-09-07 22:05:40", "217.136.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("342", "0", "magma", "2015-09-07 21:11:24", "2015-09-07 22:11:24", "95.14.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("343", "0", "magma", "2015-09-07 21:12:27", "2015-09-07 22:12:27", "176.41.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("344", "0", "magma", "2015-09-07 21:18:22", "2015-09-07 22:18:22", "85.70.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("345", "0", "magma", "2015-09-07 21:19:04", "2015-09-07 22:19:04", "76.240.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("346", "0", "magma", "2015-09-07 21:19:45", "2015-09-07 22:19:45", "85.202.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("347", "0", "magma", "2015-09-07 21:31:22", "2015-09-07 22:31:22", "78.0.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("348", "0", "magma", "2015-09-07 21:31:37", "2015-09-07 22:31:37", "46.99.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("349", "0", "magma", "2015-09-07 21:47:26", "2015-09-07 22:47:26", "158.181.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("350", "0", "magma", "2015-09-07 21:47:51", "2015-09-07 22:47:51", "189.32.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("351", "0", "magma", "2015-09-07 21:48:51", "2015-09-07 22:48:51", "80.56.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("352", "0", "magma", "2015-09-07 21:51:50", "2015-09-07 22:51:50", "197.89.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("353", "0", "magma", "2015-09-07 21:53:04", "2015-09-07 22:53:04", "84.236.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("354", "0", "magma", "2015-09-07 21:53:15", "2015-09-07 22:53:15", "2.4.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("355", "0", "magma", "2015-09-07 21:55:11", "2015-09-07 22:55:11", "200.73.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("356", "0", "magma", "2015-09-07 21:57:26", "2015-09-07 22:57:26", "188.82.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("357", "0", "magma", "2015-09-07 21:58:22", "2015-09-07 22:58:22", "95.76.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("358", "0", "magma", "2015-09-07 21:59:41", "2015-09-07 22:59:41", "87.14.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("359", "0", "magma", "2015-09-07 22:06:51", "2015-09-07 23:06:51", "31.15.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("360", "0", "magma", "2015-09-07 22:12:13", "2015-09-07 23:12:13", "31.41.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("361", "0", "magma", "2015-09-07 22:16:08", "2015-09-07 23:16:08", "190.31.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("362", "0", "magma", "2015-09-07 22:16:38", "2015-09-07 23:16:38", "149.88.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("363", "0", "magma", "2015-09-07 22:17:04", "2015-09-07 23:17:04", "176.179.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("364", "0", "magma", "2015-09-07 22:18:17", "2015-09-07 23:18:17", "94.236.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("365", "0", "magma", "2015-09-07 22:21:59", "2015-09-07 23:21:59", "217.39.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("366", "0", "magma", "2015-09-07 22:34:02", "2015-09-07 23:34:02", "79.112.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("367", "0", "magma", "2015-09-07 22:37:02", "2015-09-07 23:37:02", "37.159.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("368", "0", "magma", "2015-09-07 22:37:25", "2015-09-07 23:37:25", "5.189.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("369", "0", "magma", "2015-09-07 22:38:19", "2015-09-07 23:38:19", "5.197.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("370", "0", "magma", "2015-09-07 22:38:38", "2015-09-07 23:38:38", "149.88.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("371", "0", "magma", "2015-09-07 22:40:20", "2015-09-07 23:40:20", "181.48.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("372", "0", "magma", "2015-09-07 22:41:26", "2015-09-07 23:41:26", "79.31.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("373", "0", "admin", "2015-09-07 22:42:59", "2015-09-07 23:42:59", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("374", "0", "admin", "2015-09-07 22:42:59", "2015-09-07 23:42:59", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("375", "0", "admin", "2015-09-07 22:43:00", "2015-09-07 23:43:00", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("376", "0", "admin", "2015-09-07 22:43:00", "2015-09-07 23:43:00", "64.113.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("377", "0", "admin", "2015-09-07 22:43:00", "2015-09-07 23:43:00", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("378", "0", "magma", "2015-09-07 22:47:00", "2015-09-07 23:47:00", "77.78.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("379", "0", "magma", "2015-09-07 22:48:45", "2015-09-07 23:48:45", "94.19.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("380", "0", "magma", "2015-09-07 22:51:10", "2015-09-07 23:51:10", "186.78.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("381", "0", "magma", "2015-09-07 22:53:11", "2015-09-07 23:53:11", "24.209.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("382", "0", "magma", "2015-09-07 22:53:37", "2015-09-07 23:53:37", "89.70.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("383", "0", "magma", "2015-09-07 22:58:39", "2015-09-07 23:58:39", "71.71.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("384", "0", "magma", "2015-09-07 22:59:28", "2015-09-07 23:59:28", "202.128.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("385", "0", "magma", "2015-09-07 23:03:15", "2015-09-08 00:03:15", "79.130.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("386", "0", "magma", "2015-09-07 23:03:29", "2015-09-08 00:03:29", "66.188.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("387", "0", "magma", "2015-09-07 23:09:40", "2015-09-08 00:09:40", "5.12.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("388", "0", "magma", "2015-09-07 23:13:55", "2015-09-08 00:13:55", "188.37.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("389", "0", "magma", "2015-09-07 23:17:25", "2015-09-08 00:17:25", "59.115.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("390", "0", "magma", "2015-09-07 23:26:59", "2015-09-08 00:26:59", "79.117.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("391", "0", "magma", "2015-09-07 23:31:05", "2015-09-08 00:31:05", "112.186.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("392", "0", "magma", "2015-09-07 23:34:18", "2015-09-08 00:34:18", "83.61.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("393", "0", "magma", "2015-09-07 23:43:08", "2015-09-08 00:43:08", "197.89.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("394", "0", "magma", "2015-09-07 23:58:05", "2015-09-08 00:58:05", "109.101.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("395", "0", "magma", "2015-09-07 23:58:10", "2015-09-08 00:58:10", "68.107.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("396", "0", "magma", "2015-09-08 00:01:25", "2015-09-08 01:01:25", "78.60.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("397", "0", "magma", "2015-09-08 00:03:22", "2015-09-08 01:03:22", "177.137.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("398", "0", "magma", "2015-09-08 00:04:21", "2015-09-08 01:04:21", "178.79.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("399", "0", "magma", "2015-09-08 00:30:25", "2015-09-08 01:30:25", "181.188.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("400", "0", "magma", "2015-09-08 00:41:44", "2015-09-08 01:41:44", "128.6.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("401", "0", "magma", "2015-09-08 00:45:52", "2015-09-08 01:45:52", "89.116.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("402", "0", "magma", "2015-09-08 01:14:58", "2015-09-08 02:14:58", "76.28.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("403", "0", "magma", "2015-09-08 01:44:36", "2015-09-08 02:44:36", "178.220.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("404", "0", "magma", "2015-09-08 01:48:31", "2015-09-08 02:48:31", "109.76.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("405", "0", "magma", "2015-09-08 01:51:50", "2015-09-08 02:51:50", "87.255.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("406", "0", "magma", "2015-09-08 01:56:13", "2015-09-08 02:56:13", "86.88.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("407", "0", "magma", "2015-09-08 02:03:06", "2015-09-08 03:03:06", "88.188.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("408", "0", "magma", "2015-09-08 02:04:06", "2015-09-08 03:04:06", "192.168.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("409", "0", "magma", "2015-09-08 02:06:23", "2015-09-08 03:06:23", "31.192.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("410", "0", "magma", "2015-09-08 02:12:01", "2015-09-08 03:12:01", "189.87.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("411", "0", "magma", "2015-09-08 02:26:23", "2015-09-08 03:26:23", "95.180.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("412", "0", "magma", "2015-09-08 02:26:37", "2015-09-08 03:26:37", "89.115.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("413", "0", "magma", "2015-09-08 02:42:53", "2015-09-08 03:42:53", "89.154.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("414", "0", "magma", "2015-09-08 02:46:44", "2015-09-08 03:46:44", "174.61.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("415", "0", "magma", "2015-09-08 02:56:23", "2015-09-08 03:56:23", "79.118.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("416", "0", "magma", "2015-09-08 03:36:01", "2015-09-08 04:36:01", "107.146.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("417", "0", "magma", "2015-09-08 03:36:37", "2015-09-08 04:36:37", "46.13.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("418", "0", "magma", "2015-09-08 04:01:58", "2015-09-08 05:01:58", "77.235.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("419", "0", "magma", "2015-09-08 04:02:33", "2015-09-08 05:02:33", "105.228.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("420", "0", "magma", "2015-09-08 04:02:40", "2015-09-08 05:02:40", "85.113.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("421", "0", "magma", "2015-09-08 04:08:43", "2015-09-08 05:08:43", "85.254.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("422", "0", "magma", "2015-09-08 04:14:32", "2015-09-08 05:14:32", "210.7.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("423", "0", "magma", "2015-09-08 04:47:09", "2015-09-08 05:47:09", "124.107.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("424", "0", "magma", "2015-09-08 04:54:01", "2015-09-08 05:54:01", "113.161.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("425", "0", "magma", "2015-09-08 06:06:11", "2015-09-08 07:06:11", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("426", "0", "magma", "2015-09-08 06:08:43", "2015-09-08 07:08:43", "82.3.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("427", "0", "magma", "2015-09-08 06:24:21", "2015-09-08 07:24:21", "46.186.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("428", "0", "magma", "2015-09-08 06:28:33", "2015-09-08 07:28:33", "175.141.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("429", "0", "magma", "2015-09-08 06:45:07", "2015-09-08 07:45:07", "211.33.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("430", "0", "magma", "2015-09-08 07:00:19", "2015-09-08 08:00:19", "80.220.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("431", "0", "magma", "2015-09-08 07:10:06", "2015-09-08 08:10:06", "50.27.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("432", "0", "magma", "2015-09-08 07:10:20", "2015-09-08 08:10:20", "121.107.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("433", "0", "magma", "2015-09-08 07:13:44", "2015-09-08 08:13:44", "85.250.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("434", "0", "magma", "2015-09-08 07:34:17", "2015-09-08 08:34:17", "203.76.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("435", "0", "magma", "2015-09-08 07:38:01", "2015-09-08 08:38:01", "182.71.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("436", "0", "magma", "2015-09-08 07:42:16", "2015-09-08 08:42:16", "88.196.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("437", "0", "magma", "2015-09-08 07:57:31", "2015-09-08 08:57:31", "92.242.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("438", "0", "admin", "2015-09-08 08:05:43", "2015-09-08 09:05:43", "81.7.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("439", "0", "admin", "2015-09-08 08:05:43", "2015-09-08 09:05:43", "89.105.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("440", "0", "admin", "2015-09-08 08:05:43", "2015-09-08 09:05:43", "176.9.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("441", "0", "admin", "2015-09-08 08:05:44", "2015-09-08 09:05:44", "199.127.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("442", "0", "admin", "2015-09-08 08:05:53", "2015-09-08 09:05:53", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("443", "0", "magma", "2015-09-08 08:06:43", "2015-09-08 09:06:43", "85.254.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("444", "0", "magma", "2015-09-08 08:17:23", "2015-09-08 09:17:23", "112.211.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("445", "0", "magma", "2015-09-08 08:22:30", "2015-09-08 09:22:30", "80.77.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("446", "0", "magma", "2015-09-08 08:36:04", "2015-09-08 09:36:04", "120.63.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("447", "0", "magma", "2015-09-08 08:42:03", "2015-09-08 09:42:03", "79.42.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("448", "0", "magma", "2015-09-08 08:49:14", "2015-09-08 09:49:14", "124.107.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("449", "0", "magma", "2015-09-08 08:59:38", "2015-09-08 09:59:38", "191.185.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("450", "0", "magma", "2015-09-08 09:04:19", "2015-09-08 10:04:19", "89.41.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("451", "0", "magma", "2015-09-08 09:10:56", "2015-09-08 10:10:56", "85.113.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("452", "0", "magma", "2015-09-08 09:23:00", "2015-09-08 10:23:00", "103.10.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("453", "0", "magma", "2015-09-08 09:27:02", "2015-09-08 10:27:02", "111.240.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("454", "0", "magma", "2015-09-08 09:34:27", "2015-09-08 10:34:27", "177.134.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("455", "0", "magma", "2015-09-08 09:34:40", "2015-09-08 10:34:40", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("456", "0", "magma", "2015-09-08 09:36:24", "2015-09-08 10:36:24", "5.15.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("457", "0", "magma", "2015-09-08 09:38:51", "2015-09-08 10:38:51", "123.201.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("458", "0", "magma", "2015-09-08 09:43:59", "2015-09-08 10:43:59", "120.63.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("459", "0", "magma", "2015-09-08 09:45:17", "2015-09-08 10:45:17", "89.39.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("460", "0", "magma", "2015-09-08 09:52:57", "2015-09-08 10:52:57", "195.68.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("461", "0", "magma", "2015-09-08 09:56:35", "2015-09-08 10:56:35", "92.70.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("462", "0", "magma", "2015-09-08 09:58:01", "2015-09-08 10:58:01", "220.244.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("463", "0", "magma", "2015-09-08 10:23:09", "2015-09-08 11:23:09", "46.121.245.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("464", "0", "magma", "2015-09-08 10:36:11", "2015-09-08 11:36:11", "178.161.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("465", "0", "magma", "2015-09-08 10:38:22", "2015-09-08 11:38:22", "125.60.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("466", "0", "magma", "2015-09-08 10:47:01", "2015-09-08 11:47:01", "5.44.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("467", "0", "magma", "2015-09-08 11:09:28", "2015-09-08 12:09:28", "83.51.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("468", "0", "magma", "2015-09-08 11:15:11", "2015-09-08 12:15:11", "160.80.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("469", "0", "magma", "2015-09-08 11:15:21", "2015-09-08 12:15:21", "92.242.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("470", "0", "magma", "2015-09-08 11:24:16", "2015-09-08 12:24:16", "83.35.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("471", "0", "magma", "2015-09-08 11:30:26", "2015-09-08 12:30:26", "180.183.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("472", "0", "magma", "2015-09-08 11:36:45", "2015-09-08 12:36:45", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("473", "0", "magma", "2015-09-08 11:57:04", "2015-09-08 12:57:04", "89.155.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("474", "0", "magma", "2015-09-08 11:57:47", "2015-09-08 12:57:47", "83.132.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("475", "0", "magma", "2015-09-08 12:07:04", "2015-09-08 13:07:04", "95.180.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("476", "0", "magma", "2015-09-08 12:09:20", "2015-09-08 13:09:20", "175.136.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("477", "0", "magma", "2015-09-08 12:09:42", "2015-09-08 13:09:42", "182.237.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("478", "0", "magma", "2015-09-08 12:10:03", "2015-09-08 13:10:03", "94.178.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("479", "0", "magma", "2015-09-08 12:10:42", "2015-09-08 13:10:42", "1.126.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("480", "0", "magma", "2015-09-08 12:11:28", "2015-09-08 13:11:28", "217.75.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("481", "0", "magma", "2015-09-08 12:20:03", "2015-09-08 13:20:03", "79.114.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("482", "0", "magma", "2015-09-08 12:22:16", "2015-09-08 13:22:16", "60.241.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("483", "0", "magma", "2015-09-08 12:23:06", "2015-09-08 13:23:06", "31.154.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("484", "0", "magma", "2015-09-08 12:38:23", "2015-09-08 13:38:23", "89.66.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("485", "0", "magma", "2015-09-08 12:39:16", "2015-09-08 13:39:16", "85.204.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("486", "0", "magma", "2015-09-08 12:40:19", "2015-09-08 13:40:19", "14.201.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("487", "0", "magma", "2015-09-08 12:54:29", "2015-09-08 13:54:29", "31.154.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("488", "0", "magma", "2015-09-08 13:01:54", "2015-09-08 14:01:54", "105.186.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("489", "0", "magma", "2015-09-08 13:02:53", "2015-09-08 14:02:53", "212.107.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("490", "0", "magma", "2015-09-08 13:26:00", "2015-09-08 14:26:00", "173.172.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("491", "0", "magma", "2015-09-08 13:27:46", "2015-09-08 14:27:46", "175.141.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("492", "0", "magma", "2015-09-08 13:37:47", "2015-09-08 14:37:47", "188.225.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("493", "0", "magma", "2015-09-08 13:53:17", "2015-09-08 14:53:17", "86.35.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("494", "0", "magma", "2015-09-08 13:57:59", "2015-09-08 14:57:59", "62.197.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("495", "0", "magma", "2015-09-08 14:02:19", "2015-09-08 15:02:19", "197.210.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("496", "0", "magma", "2015-09-08 14:10:53", "2015-09-08 15:10:53", "95.86.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("497", "0", "magma", "2015-09-08 14:14:01", "2015-09-08 15:14:01", "85.99.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("498", "0", "magma", "2015-09-08 14:29:17", "2015-09-08 15:29:17", "202.128.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("499", "0", "magma", "2015-09-08 14:31:09", "2015-09-08 15:31:09", "73.18.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("500", "0", "magma", "2015-09-08 14:42:24", "2015-09-08 15:42:24", "88.243.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("501", "0", "magma", "2015-09-08 14:47:02", "2015-09-08 15:47:02", "37.210.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("502", "0", "magma", "2015-09-08 14:50:19", "2015-09-08 15:50:19", "212.79.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("503", "0", "magma", "2015-09-08 14:56:15", "2015-09-08 15:56:15", "194.1.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("504", "0", "magma", "2015-09-08 15:00:34", "2015-09-08 16:00:34", "24.184.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("505", "0", "magma", "2015-09-08 15:07:26", "2015-09-08 16:07:26", "125.179.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("506", "0", "magma", "2015-09-08 15:08:58", "2015-09-08 16:08:58", "83.9.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("507", "0", "magma", "2015-09-08 15:09:19", "2015-09-08 16:09:19", "78.157.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("508", "0", "magma", "2015-09-08 15:12:46", "2015-09-08 16:12:46", "186.121.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("509", "0", "magma", "2015-09-08 15:20:20", "2015-09-08 16:20:20", "41.201.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("510", "0", "magma", "2015-09-08 15:22:16", "2015-09-08 16:22:16", "85.138.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("511", "0", "magma", "2015-09-08 15:28:32", "2015-09-08 16:28:32", "84.1.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("512", "0", "magma", "2015-09-08 16:02:43", "2015-09-08 17:02:43", "93.103.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("513", "0", "magma", "2015-09-08 16:05:19", "2015-09-08 17:05:19", "5.44.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("514", "0", "magma", "2015-09-08 16:07:22", "2015-09-08 17:07:22", "60.53.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("515", "0", "magma", "2015-09-08 16:20:20", "2015-09-08 17:20:20", "150.129.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("516", "0", "magma", "2015-09-08 16:22:36", "2015-09-08 17:22:36", "84.228.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("517", "0", "magma", "2015-09-08 16:24:15", "2015-09-08 17:24:15", "180.190.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("518", "0", "magma", "2015-09-08 16:35:11", "2015-09-08 17:35:11", "143.176.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("519", "0", "magma", "2015-09-08 16:35:33", "2015-09-08 17:35:33", "181.188.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("520", "0", "magma", "2015-09-08 16:50:34", "2015-09-08 17:50:34", "79.183.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("521", "0", "magma", "2015-09-08 16:52:55", "2015-09-08 17:52:55", "188.24.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("522", "0", "magma", "2015-09-08 16:54:37", "2015-09-08 17:54:37", "178.255.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("523", "0", "magma", "2015-09-08 16:59:52", "2015-09-08 17:59:52", "201.210.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("524", "0", "magma", "2015-09-08 17:00:44", "2015-09-08 18:00:44", "78.23.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("525", "0", "magma", "2015-09-08 17:01:50", "2015-09-08 18:01:50", "193.92.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("526", "0", "magma", "2015-09-08 17:07:34", "2015-09-08 18:07:34", "217.84.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("527", "0", "magma", "2015-09-08 17:15:19", "2015-09-08 18:15:19", "31.41.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("528", "0", "magma", "2015-09-08 17:25:09", "2015-09-08 18:25:09", "68.58.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("529", "0", "magma", "2015-09-08 17:25:52", "2015-09-08 18:25:52", "79.134.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("530", "0", "magma", "2015-09-08 17:27:19", "2015-09-08 18:27:19", "72.252.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("531", "0", "magma", "2015-09-08 17:44:04", "2015-09-08 18:44:04", "178.220.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("532", "0", "admin", "2015-09-08 18:01:55", "2015-09-08 19:01:55", "89.73.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("533", "0", "admin", "2015-09-08 18:01:56", "2015-09-08 19:01:56", "193.37.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("534", "0", "admin", "2015-09-08 18:01:56", "2015-09-08 19:01:56", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("535", "0", "admin", "2015-09-08 18:01:56", "2015-09-08 19:01:56", "62.212.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("536", "0", "admin", "2015-09-08 18:01:57", "2015-09-08 19:01:57", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("537", "0", "magma", "2015-09-08 18:17:33", "2015-09-08 19:17:33", "86.86.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("538", "0", "magma", "2015-09-08 18:27:06", "2015-09-08 19:27:06", "189.87.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("539", "0", "magma", "2015-09-08 18:28:26", "2015-09-08 19:28:26", "116.14.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("540", "0", "magma", "2015-09-08 18:38:11", "2015-09-08 19:38:11", "43.254.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("541", "0", "magma", "2015-09-08 18:40:43", "2015-09-08 19:40:43", "91.206.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("542", "0", "magma", "2015-09-08 18:54:36", "2015-09-08 19:54:36", "84.85.161.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("543", "0", "magma", "2015-09-08 19:14:42", "2015-09-08 20:14:42", "109.101.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("544", "0", "magma", "2015-09-08 19:18:16", "2015-09-08 20:18:16", "87.95.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("545", "0", "magma", "2015-09-08 19:29:55", "2015-09-08 20:29:55", "46.121.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("546", "0", "magma", "2015-09-08 19:39:04", "2015-09-08 20:39:04", "81.219.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("547", "0", "magma", "2015-09-08 20:05:33", "2015-09-08 21:05:33", "78.82.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("548", "0", "magma", "2015-09-08 20:07:37", "2015-09-08 21:07:37", "181.198.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("549", "0", "magma", "2015-09-08 20:09:31", "2015-09-08 21:09:31", "41.202.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("550", "0", "magma", "2015-09-08 20:10:19", "2015-09-08 21:10:19", "83.183.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("551", "0", "magma", "2015-09-08 20:22:13", "2015-09-08 21:22:13", "81.108.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("552", "0", "magma", "2015-09-08 20:28:12", "2015-09-08 21:28:12", "174.64.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("553", "0", "magma", "2015-09-08 20:32:14", "2015-09-08 21:32:14", "80.192.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("554", "0", "magma", "2015-09-08 20:35:52", "2015-09-08 21:35:52", "95.76.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("555", "0", "magma", "2015-09-08 20:38:08", "2015-09-08 21:38:08", "85.24.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("556", "0", "magma", "2015-09-08 20:44:07", "2015-09-08 21:44:07", "83.117.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("557", "0", "magma", "2015-09-08 20:48:02", "2015-09-08 21:48:02", "92.126.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("558", "0", "magma", "2015-09-08 21:03:20", "2015-09-08 22:03:20", "49.158.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("559", "0", "magma", "2015-09-08 21:09:44", "2015-09-08 22:09:44", "89.169.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("560", "0", "magma", "2015-09-08 21:10:05", "2015-09-08 22:10:05", "2.49.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("561", "0", "magma", "2015-09-08 21:38:25", "2015-09-08 22:38:25", "46.13.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("562", "0", "magma", "2015-09-08 21:39:52", "2015-09-08 22:39:52", "66.183.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("563", "0", "magma", "2015-09-08 21:41:17", "2015-09-08 22:41:17", "86.121.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("564", "0", "magma", "2015-09-08 21:41:36", "2015-09-08 22:41:36", "190.98.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("565", "0", "magma", "2015-09-08 21:41:50", "2015-09-08 22:41:50", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("566", "0", "magma", "2015-09-08 21:42:20", "2015-09-08 22:42:20", "42.201.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("567", "0", "magma", "2015-09-08 22:01:11", "2015-09-08 23:01:11", "177.72.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("568", "0", "magma", "2015-09-08 22:01:42", "2015-09-08 23:01:42", "111.68.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("569", "0", "magma", "2015-09-08 22:12:55", "2015-09-08 23:12:55", "86.71.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("570", "0", "magma", "2015-09-08 22:21:08", "2015-09-08 23:21:08", "94.175.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("571", "0", "magma", "2015-09-08 22:32:40", "2015-09-08 23:32:40", "178.220.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("572", "0", "magma", "2015-09-08 22:38:33", "2015-09-08 23:38:33", "151.70.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("573", "0", "magma", "2015-09-08 23:00:39", "2015-09-09 00:00:39", "95.76.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("574", "0", "magma", "2015-09-08 23:35:23", "2015-09-09 00:35:23", "173.52.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("575", "0", "magma", "2015-09-08 23:40:04", "2015-09-09 00:40:04", "197.89.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("576", "0", "magma", "2015-09-08 23:49:52", "2015-09-09 00:49:52", "188.79.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("577", "0", "magma", "2015-09-09 00:19:43", "2015-09-09 01:19:43", "112.207.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("578", "0", "magma", "2015-09-09 00:38:06", "2015-09-09 01:38:06", "79.145.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("579", "0", "magma", "2015-09-09 00:47:37", "2015-09-09 01:47:37", "219.92.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("580", "0", "magma", "2015-09-09 01:35:29", "2015-09-09 02:35:29", "175.136.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("581", "0", "magma", "2015-09-09 02:42:55", "2015-09-09 03:42:55", "208.179.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("582", "0", "magma", "2015-09-09 03:34:28", "2015-09-09 04:34:28", "190.232.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("583", "0", "admin", "2015-09-09 03:55:44", "2015-09-09 04:55:44", "37.221.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("584", "0", "admin", "2015-09-09 03:55:44", "2015-09-09 04:55:44", "87.118.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("585", "0", "admin", "2015-09-09 03:55:44", "2015-09-09 04:55:44", "54.94.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("586", "0", "admin", "2015-09-09 03:55:45", "2015-09-09 04:55:45", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("587", "0", "admin", "2015-09-09 03:55:45", "2015-09-09 04:55:45", "5.45.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("588", "0", "magma", "2015-09-09 03:57:03", "2015-09-09 04:57:03", "174.1.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("589", "0", "magma", "2015-09-09 04:55:42", "2015-09-09 05:55:42", "2.51.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("590", "0", "magma", "2015-09-09 05:02:43", "2015-09-09 06:02:43", "87.1.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("591", "0", "magma", "2015-09-09 05:10:23", "2015-09-09 06:10:23", "212.233.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("592", "0", "magma", "2015-09-09 05:17:36", "2015-09-09 06:17:36", "211.72.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("593", "0", "magma", "2015-09-09 06:14:27", "2015-09-09 07:14:27", "190.147.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("594", "0", "magma", "2015-09-09 06:17:15", "2015-09-09 07:17:15", "76.72.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("595", "0", "magma", "2015-09-09 07:33:21", "2015-09-09 08:33:21", "78.92.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("596", "0", "magma", "2015-09-09 07:35:08", "2015-09-09 08:35:08", "31.41.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("597", "0", "magma", "2015-09-09 07:53:14", "2015-09-09 08:53:14", "79.118.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("598", "0", "magma", "2015-09-09 08:38:38", "2015-09-09 09:38:38", "86.47.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("599", "0", "magma", "2015-09-09 09:02:54", "2015-09-09 10:02:54", "103.229.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("600", "0", "magma", "2015-09-09 09:07:29", "2015-09-09 10:07:29", "109.64.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("601", "0", "magma", "2015-09-09 09:12:02", "2015-09-09 10:12:02", "108.38.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("602", "0", "magma", "2015-09-09 09:26:08", "2015-09-09 10:26:08", "183.87.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("603", "0", "magma", "2015-09-09 10:39:31", "2015-09-09 11:39:31", "112.168.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("604", "0", "magma", "2015-09-09 10:39:56", "2015-09-09 11:39:56", "188.64.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("605", "0", "magma", "2015-09-09 11:12:46", "2015-09-09 12:12:46", "179.178.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("606", "0", "magma", "2015-09-09 11:14:17", "2015-09-09 12:14:17", "77.127.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("607", "0", "magma", "2015-09-09 11:52:50", "2015-09-09 12:52:50", "112.209.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("608", "0", "magma", "2015-09-09 12:02:52", "2015-09-09 13:02:52", "31.192.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("609", "1", "admin8576", "2015-09-09 12:31:46", "2015-09-09 13:31:46", "89.233.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("610", "0", "magma", "2015-09-09 12:33:29", "2015-09-09 13:33:29", "188.135.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("611", "0", "magma", "2015-09-09 12:59:27", "2015-09-09 13:59:27", "79.101.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("612", "0", "magma", "2015-09-09 13:09:24", "2015-09-09 14:09:24", "210.242.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("613", "0", "magma", "2015-09-09 13:35:28", "2015-09-09 14:35:28", "79.130.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("614", "0", "admin", "2015-09-09 13:43:51", "2015-09-09 14:43:51", "185.104.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("615", "0", "admin", "2015-09-09 13:43:51", "2015-09-09 14:43:51", "85.10.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("616", "0", "admin", "2015-09-09 13:43:52", "2015-09-09 14:43:52", "51.254.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("617", "0", "admin", "2015-09-09 13:43:52", "2015-09-09 14:43:52", "204.8.156.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("618", "0", "admin", "2015-09-09 13:43:53", "2015-09-09 14:43:53", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("619", "0", "magma", "2015-09-09 13:58:56", "2015-09-09 14:58:56", "84.236.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("620", "0", "magma", "2015-09-09 14:15:35", "2015-09-09 15:15:35", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("621", "0", "magma", "2015-09-09 14:16:44", "2015-09-09 15:16:44", "149.129.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("622", "0", "magma", "2015-09-09 14:28:46", "2015-09-09 15:28:46", "197.200.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("623", "0", "magma", "2015-09-09 14:29:21", "2015-09-09 15:29:21", "182.57.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("624", "1", "admin8576", "2015-09-09 14:30:10", "2015-09-09 15:30:10", "89.233.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("625", "0", "magma", "2015-09-09 14:30:48", "2015-09-09 15:30:48", "112.198.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("626", "0", "magma", "2015-09-09 14:47:12", "2015-09-09 15:47:12", "105.98.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("627", "0", "magma", "2015-09-09 14:50:04", "2015-09-09 15:50:04", "188.4.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("628", "0", "magma", "2015-09-09 14:59:15", "2015-09-09 15:59:15", "31.11.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("629", "0", "magma", "2015-09-09 15:02:12", "2015-09-09 16:02:12", "46.121.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("630", "0", "magma", "2015-09-09 15:12:10", "2015-09-09 16:12:10", "149.3.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("631", "0", "magma", "2015-09-09 15:16:08", "2015-09-09 16:16:08", "143.160.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("632", "0", "magma", "2015-09-09 15:33:43", "2015-09-09 16:33:43", "41.250.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("633", "0", "magma", "2015-09-09 15:37:34", "2015-09-09 16:37:34", "1.22.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("634", "0", "magma", "2015-09-09 15:53:51", "2015-09-09 16:53:51", "86.81.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("635", "0", "magma", "2015-09-09 16:00:58", "2015-09-09 17:00:58", "180.234.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("636", "0", "magma", "2015-09-09 16:05:02", "2015-09-09 17:05:02", "113.203.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("637", "0", "magma", "2015-09-09 16:17:43", "2015-09-09 17:17:43", "109.92.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("638", "0", "magma", "2015-09-09 16:28:43", "2015-09-09 17:28:43", "89.35.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("639", "0", "magma", "2015-09-09 16:29:37", "2015-09-09 17:29:37", "122.163.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("640", "0", "magma", "2015-09-09 16:34:09", "2015-09-09 17:34:09", "180.149.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("641", "0", "magma", "2015-09-09 16:36:01", "2015-09-09 17:36:01", "87.244.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("642", "0", "magma", "2015-09-09 16:41:16", "2015-09-09 17:41:16", "190.7.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("643", "0", "magma", "2015-09-09 16:43:53", "2015-09-09 17:43:53", "188.2.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("644", "0", "magma", "2015-09-09 16:47:07", "2015-09-09 17:47:07", "92.249.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("645", "0", "magma", "2015-09-09 16:50:34", "2015-09-09 17:50:34", "197.210.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("646", "0", "magma", "2015-09-09 17:10:06", "2015-09-09 18:10:06", "46.116.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("647", "0", "magma", "2015-09-09 17:10:44", "2015-09-09 18:10:44", "175.137.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("648", "0", "magma", "2015-09-09 17:31:22", "2015-09-09 18:31:22", "5.14.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("649", "0", "magma", "2015-09-09 17:46:08", "2015-09-09 18:46:08", "79.117.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("650", "0", "magma", "2015-09-09 18:32:51", "2015-09-09 19:32:51", "189.81.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("651", "0", "magma", "2015-09-09 18:34:10", "2015-09-09 19:34:10", "79.113.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("652", "0", "magma", "2015-09-09 18:39:54", "2015-09-09 19:39:54", "93.145.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("653", "0", "magma", "2015-09-09 18:42:14", "2015-09-09 19:42:14", "5.12.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("654", "0", "magma", "2015-09-09 18:46:12", "2015-09-09 19:46:12", "81.244.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("655", "0", "magma", "2015-09-09 19:09:16", "2015-09-09 20:09:16", "78.134.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("656", "0", "magma", "2015-09-09 19:09:18", "2015-09-09 20:09:18", "182.72.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("657", "0", "magma", "2015-09-09 19:11:13", "2015-09-09 20:11:13", "61.245.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("658", "0", "magma", "2015-09-09 19:25:46", "2015-09-09 20:25:46", "108.38.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("659", "0", "magma", "2015-09-09 19:30:55", "2015-09-09 20:30:55", "78.71.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("660", "0", "magma", "2015-09-09 19:54:48", "2015-09-09 20:54:48", "118.101.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("661", "0", "magma", "2015-09-09 19:55:42", "2015-09-09 20:55:42", "197.87.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("662", "0", "magma", "2015-09-09 19:55:52", "2015-09-09 20:55:52", "83.177.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("663", "0", "magma", "2015-09-09 20:34:57", "2015-09-09 21:34:57", "62.197.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("664", "0", "magma", "2015-09-09 20:54:02", "2015-09-09 21:54:02", "90.194.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("665", "0", "magma", "2015-09-09 21:15:22", "2015-09-09 22:15:22", "77.12.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("666", "0", "magma", "2015-09-09 21:21:49", "2015-09-09 22:21:49", "213.241.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("667", "0", "magma", "2015-09-09 21:41:44", "2015-09-09 22:41:44", "188.159.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("668", "0", "magma", "2015-09-09 22:04:27", "2015-09-09 23:04:27", "197.200.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("669", "0", "magma", "2015-09-09 22:44:12", "2015-09-09 23:44:12", "188.4.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("670", "0", "magma", "2015-09-09 23:16:44", "2015-09-10 00:16:44", "78.36.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("671", "0", "magma", "2015-09-09 23:30:42", "2015-09-10 00:30:42", "69.79.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("672", "0", "magma", "2015-09-09 23:55:14", "2015-09-10 00:55:14", "105.106.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("673", "0", "magma", "2015-09-10 00:14:48", "2015-09-10 01:14:48", "41.216.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("674", "0", "magma", "2015-09-10 00:18:50", "2015-09-10 01:18:50", "186.121.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("675", "0", "admin", "2015-09-10 00:33:05", "2015-09-10 01:33:05", "185.62.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("676", "0", "admin", "2015-09-10 00:33:07", "2015-09-10 01:33:07", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("677", "0", "admin", "2015-09-10 00:33:17", "2015-09-10 01:33:17", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("678", "0", "admin", "2015-09-10 00:33:23", "2015-09-10 01:33:23", "204.85.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("679", "0", "admin", "2015-09-10 00:33:26", "2015-09-10 01:33:26", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("680", "0", "admin", "2015-09-10 00:33:33", "2015-09-10 01:33:33", "185.17.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("681", "0", "magma", "2015-09-10 00:41:31", "2015-09-10 01:41:31", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("682", "0", "magma", "2015-09-10 00:59:28", "2015-09-10 01:59:28", "24.112.176.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("683", "0", "magma", "2015-09-10 02:05:29", "2015-09-10 03:05:29", "41.250.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("684", "0", "magma", "2015-09-10 02:07:32", "2015-09-10 03:07:32", "183.89.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("685", "0", "magma", "2015-09-10 02:32:29", "2015-09-10 03:32:29", "24.209.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("686", "0", "magma", "2015-09-10 03:25:16", "2015-09-10 04:25:16", "180.69.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("687", "0", "magma", "2015-09-10 03:32:31", "2015-09-10 04:32:31", "178.222.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("688", "0", "magma", "2015-09-10 03:59:21", "2015-09-10 04:59:21", "184.188.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("689", "0", "magma", "2015-09-10 04:30:49", "2015-09-10 05:30:49", "41.250.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("690", "0", "magma", "2015-09-10 05:33:12", "2015-09-10 06:33:12", "69.79.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("691", "0", "magma", "2015-09-10 05:42:13", "2015-09-10 06:42:13", "197.224.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("692", "0", "magma", "2015-09-10 06:02:10", "2015-09-10 07:02:10", "46.99.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("693", "0", "magma", "2015-09-10 06:28:38", "2015-09-10 07:28:38", "187.54.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("694", "0", "magma", "2015-09-10 06:39:25", "2015-09-10 07:39:25", "83.233.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("695", "0", "magma", "2015-09-10 06:43:05", "2015-09-10 07:43:05", "190.72.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("696", "0", "magma", "2015-09-10 07:26:35", "2015-09-10 08:26:35", "181.120.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("697", "0", "magma", "2015-09-10 07:57:24", "2015-09-10 08:57:24", "85.229.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("698", "0", "magma", "2015-09-10 08:15:40", "2015-09-10 09:15:40", "182.186.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("699", "0", "magma", "2015-09-10 08:31:44", "2015-09-10 09:31:44", "105.186.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("700", "0", "magma", "2015-09-10 08:33:08", "2015-09-10 09:33:08", "58.186.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("701", "0", "magma", "2015-09-10 08:37:36", "2015-09-10 09:37:36", "94.240.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("702", "0", "magma", "2015-09-10 08:55:10", "2015-09-10 09:55:10", "185.82.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("703", "0", "magma", "2015-09-10 08:57:12", "2015-09-10 09:57:12", "46.248.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("704", "0", "magma", "2015-09-10 09:01:47", "2015-09-10 10:01:47", "84.236.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("705", "0", "magma", "2015-09-10 09:11:10", "2015-09-10 10:11:10", "112.133.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("706", "0", "magma", "2015-09-10 09:18:39", "2015-09-10 10:18:39", "112.210.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("707", "0", "magma", "2015-09-10 09:25:39", "2015-09-10 10:25:39", "117.194.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("708", "0", "magma", "2015-09-10 09:38:52", "2015-09-10 10:38:52", "105.98.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("709", "0", "magma", "2015-09-10 10:02:48", "2015-09-10 11:02:48", "69.204.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("710", "0", "admin", "2015-09-10 10:09:16", "2015-09-10 11:09:16", "213.252.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("711", "0", "admin", "2015-09-10 10:09:17", "2015-09-10 11:09:17", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("712", "0", "admin", "2015-09-10 10:09:17", "2015-09-10 11:09:17", "217.115.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("713", "0", "admin", "2015-09-10 10:09:17", "2015-09-10 11:09:17", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("714", "0", "admin", "2015-09-10 10:09:18", "2015-09-10 11:09:18", "69.42.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("715", "0", "magma", "2015-09-10 10:15:04", "2015-09-10 11:15:04", "202.62.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("716", "0", "magma", "2015-09-10 10:37:34", "2015-09-10 11:37:34", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("717", "0", "magma", "2015-09-10 10:42:25", "2015-09-10 11:42:25", "77.240.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("718", "0", "magma", "2015-09-10 10:55:23", "2015-09-10 11:55:23", "118.36.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("719", "0", "magma", "2015-09-10 11:00:34", "2015-09-10 12:00:34", "223.223.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("720", "0", "magma", "2015-09-10 11:49:14", "2015-09-10 12:49:14", "217.75.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("721", "0", "magma", "2015-09-10 12:22:00", "2015-09-10 13:22:00", "122.167.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("722", "0", "magma", "2015-09-10 12:48:42", "2015-09-10 13:48:42", "178.220.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("723", "0", "magma", "2015-09-10 12:55:00", "2015-09-10 13:55:00", "197.224.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("724", "0", "magma", "2015-09-10 13:23:28", "2015-09-10 14:23:28", "41.74.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("725", "0", "magma", "2015-09-10 13:34:19", "2015-09-10 14:34:19", "86.121.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("726", "0", "magma", "2015-09-10 14:03:43", "2015-09-10 15:03:43", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("727", "0", "magma", "2015-09-10 14:17:32", "2015-09-10 15:17:32", "84.0.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("728", "0", "magma", "2015-09-10 15:13:54", "2015-09-10 16:13:54", "39.36.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("729", "0", "magma", "2015-09-10 15:17:32", "2015-09-10 16:17:32", "210.242.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("730", "0", "magma", "2015-09-10 15:19:06", "2015-09-10 16:19:06", "41.230.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("731", "0", "magma", "2015-09-10 15:22:15", "2015-09-10 16:22:15", "92.84.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("732", "0", "magma", "2015-09-10 15:46:16", "2015-09-10 16:46:16", "79.114.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("733", "0", "magma", "2015-09-10 16:16:07", "2015-09-10 17:16:07", "95.76.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("734", "0", "magma", "2015-09-10 16:20:12", "2015-09-10 17:20:12", "86.123.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("735", "0", "magma", "2015-09-10 16:29:46", "2015-09-10 17:29:46", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("736", "0", "magma", "2015-09-10 16:47:11", "2015-09-10 17:47:11", "49.159.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("737", "0", "magma", "2015-09-10 17:11:53", "2015-09-10 18:11:53", "212.54.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("738", "0", "magma", "2015-09-10 17:32:07", "2015-09-10 18:32:07", "94.122.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("739", "0", "magma", "2015-09-10 17:44:16", "2015-09-10 18:44:16", "217.71.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("740", "0", "magma", "2015-09-10 18:09:08", "2015-09-10 19:09:08", "88.184.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("741", "0", "magma", "2015-09-10 18:26:40", "2015-09-10 19:26:40", "178.150.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("742", "0", "magma", "2015-09-10 18:27:57", "2015-09-10 19:27:57", "1.126.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("743", "0", "magma", "2015-09-10 18:28:00", "2015-09-10 19:28:00", "92.80.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("744", "0", "magma", "2015-09-10 18:37:15", "2015-09-10 19:37:15", "182.186.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("745", "0", "magma", "2015-09-10 19:21:10", "2015-09-10 20:21:10", "200.82.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("746", "0", "magma", "2015-09-10 19:50:10", "2015-09-10 20:50:10", "78.207.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("747", "0", "magma", "2015-09-10 19:59:23", "2015-09-10 20:59:23", "5.15.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("748", "0", "magma", "2015-09-10 20:08:11", "2015-09-10 21:08:11", "78.71.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("749", "0", "magma", "2015-09-10 20:16:03", "2015-09-10 21:16:03", "37.210.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("750", "0", "magma", "2015-09-10 20:19:50", "2015-09-10 21:19:50", "178.220.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("751", "0", "magma", "2015-09-10 20:22:56", "2015-09-10 21:22:56", "99.226.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("752", "0", "magma", "2015-09-10 20:35:49", "2015-09-10 21:35:49", "82.237.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("753", "0", "magma", "2015-09-10 20:41:08", "2015-09-10 21:41:08", "60.50.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("754", "0", "admin", "2015-09-10 20:58:30", "2015-09-10 21:58:30", "176.31.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("755", "0", "admin", "2015-09-10 20:58:31", "2015-09-10 21:58:31", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("756", "0", "admin", "2015-09-10 20:58:31", "2015-09-10 21:58:31", "134.17.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("757", "0", "admin", "2015-09-10 20:58:31", "2015-09-10 21:58:31", "178.217.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("758", "0", "admin", "2015-09-10 20:58:50", "2015-09-10 21:58:50", "185.14.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("759", "0", "admin", "2015-09-10 20:58:56", "2015-09-10 21:58:56", "87.98.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("760", "0", "magma", "2015-09-10 21:04:38", "2015-09-10 22:04:38", "81.108.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("761", "0", "magma", "2015-09-10 21:35:25", "2015-09-10 22:35:25", "39.42.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("762", "0", "magma", "2015-09-10 22:18:38", "2015-09-10 23:18:38", "27.124.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("763", "0", "magma", "2015-09-10 22:31:14", "2015-09-10 23:31:14", "41.100.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("764", "0", "magma", "2015-09-10 22:44:38", "2015-09-10 23:44:38", "197.88.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("765", "0", "magma", "2015-09-10 22:55:17", "2015-09-10 23:55:17", "89.42.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("766", "0", "magma", "2015-09-10 22:57:33", "2015-09-10 23:57:33", "84.123.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("767", "0", "magma", "2015-09-10 22:59:57", "2015-09-10 23:59:57", "92.80.222.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("768", "0", "magma", "2015-09-10 23:35:28", "2015-09-11 00:35:28", "178.148.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("769", "0", "magma", "2015-09-10 23:56:49", "2015-09-11 00:56:49", "112.208.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("770", "0", "magma", "2015-09-11 00:29:59", "2015-09-11 01:29:59", "5.228.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("771", "0", "magma", "2015-09-11 01:00:32", "2015-09-11 02:00:32", "178.67.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("772", "0", "magma", "2015-09-11 01:18:38", "2015-09-11 02:18:38", "210.242.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("773", "0", "magma", "2015-09-11 02:03:11", "2015-09-11 03:03:11", "78.127.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("774", "0", "magma", "2015-09-11 03:21:15", "2015-09-11 04:21:15", "190.88.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("775", "0", "magma", "2015-09-11 04:29:07", "2015-09-11 05:29:07", "95.23.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("776", "0", "magma", "2015-09-11 04:40:47", "2015-09-11 05:40:47", "113.203.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("777", "0", "magma", "2015-09-11 04:56:53", "2015-09-11 05:56:53", "58.186.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("778", "0", "magma", "2015-09-11 06:34:55", "2015-09-11 07:34:55", "45.114.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("779", "0", "magma", "2015-09-11 06:47:31", "2015-09-11 07:47:31", "197.88.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("780", "0", "magma", "2015-09-11 07:00:17", "2015-09-11 08:00:17", "105.98.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("781", "0", "magma", "2015-09-11 07:19:54", "2015-09-11 08:19:54", "49.145.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("782", "0", "magma", "2015-09-11 07:28:28", "2015-09-11 08:28:28", "124.82.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("783", "0", "admin", "2015-09-11 07:31:09", "2015-09-11 08:31:09", "85.25.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("784", "0", "admin", "2015-09-11 07:31:10", "2015-09-11 08:31:10", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("785", "0", "admin", "2015-09-11 07:31:10", "2015-09-11 08:31:10", "193.42.156.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("786", "0", "admin", "2015-09-11 07:31:10", "2015-09-11 08:31:10", "62.141.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("787", "0", "admin", "2015-09-11 07:31:13", "2015-09-11 08:31:13", "185.62.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("788", "0", "magma", "2015-09-11 07:45:22", "2015-09-11 08:45:22", "82.76.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("789", "0", "magma", "2015-09-11 08:35:19", "2015-09-11 09:35:19", "103.230.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("790", "0", "magma", "2015-09-11 08:39:19", "2015-09-11 09:39:19", "109.93.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("791", "0", "magma", "2015-09-11 09:09:40", "2015-09-11 10:09:40", "150.129.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("792", "0", "magma", "2015-09-11 09:26:07", "2015-09-11 10:26:07", "1.186.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("793", "0", "magma", "2015-09-11 09:33:35", "2015-09-11 10:33:35", "178.220.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("794", "0", "magma", "2015-09-11 09:54:18", "2015-09-11 10:54:18", "62.209.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("795", "0", "magma", "2015-09-11 10:19:46", "2015-09-11 11:19:46", "110.93.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("796", "0", "magma", "2015-09-11 10:21:06", "2015-09-11 11:21:06", "178.137.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("797", "0", "magma", "2015-09-11 10:35:38", "2015-09-11 11:35:38", "87.250.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("798", "0", "magma", "2015-09-11 10:55:27", "2015-09-11 11:55:27", "176.73.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("799", "1", "admin8576", "2015-09-11 11:34:22", "2015-09-11 12:34:22", "89.233.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("800", "0", "magma", "2015-09-11 12:04:25", "2015-09-11 13:04:25", "46.20.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("801", "0", "magma", "2015-09-11 12:08:10", "2015-09-11 13:08:10", "86.21.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("802", "0", "magma", "2015-09-11 12:16:36", "2015-09-11 13:16:36", "176.73.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("803", "0", "magma", "2015-09-11 13:27:55", "2015-09-11 14:27:55", "89.152.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("804", "0", "magma", "2015-09-11 13:56:14", "2015-09-11 14:56:14", "115.254.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("805", "0", "magma", "2015-09-11 13:56:19", "2015-09-11 14:56:19", "212.233.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("806", "0", "magma", "2015-09-11 14:26:40", "2015-09-11 15:26:40", "46.59.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("807", "0", "magma", "2015-09-11 14:43:29", "2015-09-11 15:43:29", "95.61.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("808", "0", "magma", "2015-09-11 14:56:24", "2015-09-11 15:56:24", "41.230.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("809", "0", "magma", "2015-09-11 15:25:55", "2015-09-11 16:25:55", "81.108.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("810", "0", "magma", "2015-09-11 15:49:28", "2015-09-11 16:49:28", "178.223.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("811", "0", "magma", "2015-09-11 15:49:29", "2015-09-11 16:49:29", "185.82.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("812", "0", "magma", "2015-09-11 16:14:17", "2015-09-11 17:14:17", "188.36.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("813", "0", "magma", "2015-09-11 17:00:33", "2015-09-11 18:00:33", "84.0.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("814", "0", "magma", "2015-09-11 17:10:58", "2015-09-11 18:10:58", "93.103.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("815", "0", "magma", "2015-09-11 17:22:01", "2015-09-11 18:22:01", "49.159.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("816", "0", "magma", "2015-09-11 17:34:27", "2015-09-11 18:34:27", "112.207.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("817", "0", "admin", "2015-09-11 17:35:46", "2015-09-11 18:35:46", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("818", "0", "admin", "2015-09-11 17:35:46", "2015-09-11 18:35:46", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("819", "0", "admin", "2015-09-11 17:35:46", "2015-09-11 18:35:46", "188.138.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("820", "0", "admin", "2015-09-11 17:35:47", "2015-09-11 18:35:47", "92.222.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("821", "0", "magma", "2015-09-11 17:49:38", "2015-09-11 18:49:38", "178.93.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("822", "0", "magma", "2015-09-11 18:11:00", "2015-09-11 19:11:00", "84.1.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("823", "0", "magma", "2015-09-11 19:09:46", "2015-09-11 20:09:46", "36.80.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("824", "0", "magma", "2015-09-11 19:18:32", "2015-09-11 20:18:32", "1.186.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("825", "0", "magma", "2015-09-11 19:41:24", "2015-09-11 20:41:24", "31.41.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("826", "0", "magma", "2015-09-11 19:43:53", "2015-09-11 20:43:53", "89.35.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("827", "0", "magma", "2015-09-11 20:13:17", "2015-09-11 21:13:17", "46.20.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("828", "0", "magma", "2015-09-11 20:16:11", "2015-09-11 21:16:11", "90.224.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("829", "0", "magma", "2015-09-11 20:19:34", "2015-09-11 21:19:34", "84.221.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("830", "0", "magma", "2015-09-11 21:02:12", "2015-09-11 22:02:12", "186.153.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("831", "0", "magma", "2015-09-11 21:06:34", "2015-09-11 22:06:34", "46.164.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("832", "0", "magma", "2015-09-11 21:42:47", "2015-09-11 22:42:47", "92.56.161.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("833", "0", "magma", "2015-09-11 21:46:39", "2015-09-11 22:46:39", "109.80.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("834", "0", "magma", "2015-09-11 21:48:12", "2015-09-11 22:48:12", "120.28.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("835", "0", "magma", "2015-09-11 22:19:33", "2015-09-11 23:19:33", "85.250.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("836", "0", "magma", "2015-09-11 22:35:56", "2015-09-11 23:35:56", "93.103.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("837", "0", "magma", "2015-09-11 22:44:46", "2015-09-11 23:44:46", "27.124.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("838", "0", "magma", "2015-09-11 23:08:59", "2015-09-12 00:08:59", "176.73.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("839", "0", "magma", "2015-09-11 23:26:53", "2015-09-12 00:26:53", "85.250.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("840", "0", "magma", "2015-09-11 23:26:57", "2015-09-12 00:26:57", "176.221.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("841", "0", "magma", "2015-09-11 23:38:23", "2015-09-12 00:38:23", "196.36.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("842", "0", "magma", "2015-09-12 01:50:12", "2015-09-12 02:50:12", "79.178.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("843", "0", "magma", "2015-09-12 01:55:34", "2015-09-12 02:55:34", "174.1.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("844", "0", "magma", "2015-09-12 03:14:08", "2015-09-12 04:14:08", "46.107.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("845", "0", "magma", "2015-09-12 03:24:21", "2015-09-12 04:24:21", "84.108.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("846", "0", "magma", "2015-09-12 03:42:06", "2015-09-12 04:42:06", "114.134.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("847", "0", "magma", "2015-09-12 03:48:30", "2015-09-12 04:48:30", "78.182.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("848", "0", "admin", "2015-09-12 04:01:41", "2015-09-12 05:01:41", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("849", "0", "admin", "2015-09-12 04:01:42", "2015-09-12 05:01:42", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("850", "0", "admin", "2015-09-12 04:01:42", "2015-09-12 05:01:42", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("851", "0", "admin", "2015-09-12 04:01:46", "2015-09-12 05:01:46", "188.209.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("852", "0", "admin", "2015-09-12 04:01:51", "2015-09-12 05:01:51", "176.9.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("853", "0", "magma", "2015-09-12 04:13:10", "2015-09-12 05:13:10", "175.142.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("854", "0", "magma", "2015-09-12 04:36:06", "2015-09-12 05:36:06", "151.25.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("855", "0", "magma", "2015-09-12 05:01:27", "2015-09-12 06:01:27", "92.82.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("856", "0", "magma", "2015-09-12 05:44:03", "2015-09-12 06:44:03", "180.232.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("857", "0", "magma", "2015-09-12 05:56:24", "2015-09-12 06:56:24", "81.217.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("858", "0", "magma", "2015-09-12 06:22:46", "2015-09-12 07:22:46", "197.251.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("859", "0", "magma", "2015-09-12 08:19:13", "2015-09-12 09:19:13", "188.212.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("860", "0", "magma", "2015-09-12 08:37:01", "2015-09-12 09:37:01", "27.147.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("861", "0", "magma", "2015-09-12 09:22:18", "2015-09-12 10:22:18", "42.115.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("862", "0", "magma", "2015-09-12 09:40:25", "2015-09-12 10:40:25", "89.103.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("863", "0", "magma", "2015-09-12 10:05:26", "2015-09-12 11:05:26", "79.117.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("864", "0", "magma", "2015-09-12 10:42:26", "2015-09-12 11:42:26", "109.65.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("865", "0", "magma", "2015-09-12 10:59:21", "2015-09-12 11:59:21", "213.226.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("866", "0", "magma", "2015-09-12 11:39:53", "2015-09-12 12:39:53", "1.52.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("867", "0", "magma", "2015-09-12 12:14:59", "2015-09-12 13:14:59", "62.197.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("868", "0", "magma", "2015-09-12 12:41:53", "2015-09-12 13:41:53", "94.52.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("869", "0", "magma", "2015-09-12 13:15:43", "2015-09-12 14:15:43", "5.178.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("870", "0", "magma", "2015-09-12 13:47:01", "2015-09-12 14:47:01", "195.240.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("871", "0", "admin", "2015-09-12 13:56:18", "2015-09-12 14:56:18", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("872", "0", "admin", "2015-09-12 13:56:19", "2015-09-12 14:56:19", "185.36.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("873", "0", "admin", "2015-09-12 13:56:19", "2015-09-12 14:56:19", "5.9.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("874", "0", "admin", "2015-09-12 13:56:21", "2015-09-12 14:56:21", "185.75.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("875", "0", "admin", "2015-09-12 13:56:27", "2015-09-12 14:56:27", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("876", "0", "magma", "2015-09-12 14:05:50", "2015-09-12 15:05:50", "103.26.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("877", "0", "magma", "2015-09-12 14:09:28", "2015-09-12 15:09:28", "90.191.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("878", "0", "magma", "2015-09-12 14:34:13", "2015-09-12 15:34:13", "143.176.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("879", "0", "magma", "2015-09-12 14:36:15", "2015-09-12 15:36:15", "5.178.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("880", "0", "magma", "2015-09-12 14:46:00", "2015-09-12 15:46:00", "139.194.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("881", "0", "magma", "2015-09-12 15:55:17", "2015-09-12 16:55:17", "105.159.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("882", "0", "magma", "2015-09-12 16:01:21", "2015-09-12 17:01:21", "109.92.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("883", "0", "magma", "2015-09-12 16:10:36", "2015-09-12 17:10:36", "80.222.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("884", "0", "magma", "2015-09-12 16:17:49", "2015-09-12 17:17:49", "178.161.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("885", "0", "magma", "2015-09-12 16:21:10", "2015-09-12 17:21:10", "217.145.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("886", "0", "magma", "2015-09-12 16:47:21", "2015-09-12 17:47:21", "89.114.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("887", "0", "magma", "2015-09-12 16:58:32", "2015-09-12 17:58:32", "188.4.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("888", "0", "magma", "2015-09-12 17:25:16", "2015-09-12 18:25:16", "195.240.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("889", "0", "magma", "2015-09-12 17:25:19", "2015-09-12 18:25:19", "180.232.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("890", "0", "magma", "2015-09-12 17:27:02", "2015-09-12 18:27:02", "185.38.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("891", "0", "magma", "2015-09-12 17:39:14", "2015-09-12 18:39:14", "217.119.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("892", "0", "magma", "2015-09-12 18:05:35", "2015-09-12 19:05:35", "46.20.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("893", "0", "magma", "2015-09-12 18:16:25", "2015-09-12 19:16:25", "109.92.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("894", "0", "magma", "2015-09-12 18:19:18", "2015-09-12 19:19:18", "86.101.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("895", "0", "magma", "2015-09-12 18:28:26", "2015-09-12 19:28:26", "79.176.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("896", "0", "magma", "2015-09-12 18:32:15", "2015-09-12 19:32:15", "83.44.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("897", "0", "magma", "2015-09-12 19:29:26", "2015-09-12 20:29:26", "175.157.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("898", "0", "magma", "2015-09-12 21:36:37", "2015-09-12 22:36:37", "103.230.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("899", "0", "magma", "2015-09-12 21:48:35", "2015-09-12 22:48:35", "210.210.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("900", "0", "magma", "2015-09-12 21:53:57", "2015-09-12 22:53:57", "175.195.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("901", "0", "magma", "2015-09-12 21:58:54", "2015-09-12 22:58:54", "37.27.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("902", "0", "magma", "2015-09-12 22:03:40", "2015-09-12 23:03:40", "86.21.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("903", "0", "magma", "2015-09-12 22:32:23", "2015-09-12 23:32:23", "46.99.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("904", "1", "admin8576", "2015-09-12 22:50:47", "2015-09-12 23:50:47", "173.208.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("905", "1", "admin8576", "2015-09-12 22:50:47", "2015-09-12 23:50:47", "173.208.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("906", "0", "magma", "2015-09-13 00:01:17", "2015-09-13 01:01:17", "194.219.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("907", "0", "magma", "2015-09-13 00:08:27", "2015-09-13 01:08:27", "85.74.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("908", "0", "admin", "2015-09-13 00:32:46", "2015-09-13 01:32:46", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("909", "0", "admin", "2015-09-13 00:32:46", "2015-09-13 01:32:46", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("910", "0", "admin", "2015-09-13 00:32:47", "2015-09-13 01:32:47", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("911", "0", "admin", "2015-09-13 00:32:48", "2015-09-13 01:32:48", "94.242.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("912", "0", "magma", "2015-09-13 01:34:23", "2015-09-13 02:34:23", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("913", "0", "magma", "2015-09-13 03:06:26", "2015-09-13 04:06:26", "108.183.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("914", "0", "magma", "2015-09-13 04:06:59", "2015-09-13 05:06:59", "50.191.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("915", "0", "magma", "2015-09-13 04:23:06", "2015-09-13 05:23:06", "41.254.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("916", "0", "magma", "2015-09-13 05:00:48", "2015-09-13 06:00:48", "181.59.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("917", "0", "magma", "2015-09-13 05:08:03", "2015-09-13 06:08:03", "62.209.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("918", "0", "magma", "2015-09-13 05:50:11", "2015-09-13 06:50:11", "121.99.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("919", "0", "magma", "2015-09-13 06:23:06", "2015-09-13 07:23:06", "119.93.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("920", "0", "magma", "2015-09-13 06:56:32", "2015-09-13 07:56:32", "186.45.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("921", "0", "magma", "2015-09-13 07:53:51", "2015-09-13 08:53:51", "180.234.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("922", "0", "magma", "2015-09-13 08:12:12", "2015-09-13 09:12:12", "175.140.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("923", "0", "magma", "2015-09-13 08:41:49", "2015-09-13 09:41:49", "210.195.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("924", "0", "magma", "2015-09-13 08:45:43", "2015-09-13 09:45:43", "178.42.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("925", "0", "magma", "2015-09-13 09:13:13", "2015-09-13 10:13:13", "50.118.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("926", "0", "magma", "2015-09-13 09:54:42", "2015-09-13 10:54:42", "79.140.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("927", "0", "magma", "2015-09-13 10:13:16", "2015-09-13 11:13:16", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("928", "0", "magma", "2015-09-13 10:33:43", "2015-09-13 11:33:43", "79.101.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("929", "0", "admin", "2015-09-13 10:36:33", "2015-09-13 11:36:33", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("930", "0", "admin", "2015-09-13 10:36:33", "2015-09-13 11:36:33", "62.141.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("931", "0", "admin", "2015-09-13 10:36:33", "2015-09-13 11:36:33", "62.210.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("932", "0", "magma", "2015-09-13 11:27:40", "2015-09-13 12:27:40", "112.168.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("933", "0", "magma", "2015-09-13 11:42:16", "2015-09-13 12:42:16", "41.142.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("934", "0", "magma", "2015-09-13 12:01:44", "2015-09-13 13:01:44", "92.87.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("935", "0", "magma", "2015-09-13 12:08:28", "2015-09-13 13:08:28", "91.186.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("936", "0", "magma", "2015-09-13 12:26:07", "2015-09-13 13:26:07", "95.86.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("937", "0", "magma", "2015-09-13 12:33:14", "2015-09-13 13:33:14", "5.83.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("938", "0", "magma", "2015-09-13 12:36:49", "2015-09-13 13:36:49", "117.195.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("939", "0", "magma", "2015-09-13 13:17:06", "2015-09-13 14:17:06", "203.87.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("940", "0", "magma", "2015-09-13 13:22:22", "2015-09-13 14:22:22", "89.42.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("941", "0", "magma", "2015-09-13 13:24:40", "2015-09-13 14:24:40", "178.150.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("942", "0", "magma", "2015-09-13 13:31:27", "2015-09-13 14:31:27", "186.123.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("943", "0", "magma", "2015-09-13 13:46:37", "2015-09-13 14:46:37", "151.30.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("944", "0", "magma", "2015-09-13 14:08:56", "2015-09-13 15:08:56", "89.139.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("945", "0", "magma", "2015-09-13 14:14:34", "2015-09-13 15:14:34", "78.61.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("946", "0", "magma", "2015-09-13 14:46:01", "2015-09-13 15:46:01", "109.101.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("947", "0", "magma", "2015-09-13 15:31:23", "2015-09-13 16:31:23", "111.68.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("948", "0", "magma", "2015-09-13 15:40:43", "2015-09-13 16:40:43", "1.52.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("949", "0", "magma", "2015-09-13 16:03:30", "2015-09-13 17:03:30", "91.186.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("950", "0", "magma", "2015-09-13 16:16:06", "2015-09-13 17:16:06", "41.46.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("951", "0", "magma", "2015-09-13 16:18:01", "2015-09-13 17:18:01", "90.244.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("952", "0", "magma", "2015-09-13 16:34:52", "2015-09-13 17:34:52", "117.195.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("953", "0", "magma", "2015-09-13 16:35:42", "2015-09-13 17:35:42", "180.234.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("954", "0", "magma", "2015-09-13 16:56:36", "2015-09-13 17:56:36", "85.122.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("955", "0", "magma", "2015-09-13 17:07:59", "2015-09-13 18:07:59", "178.222.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("956", "0", "magma", "2015-09-13 17:17:18", "2015-09-13 18:17:18", "197.200.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("957", "0", "magma", "2015-09-13 18:58:07", "2015-09-13 19:58:07", "39.59.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("958", "0", "magma", "2015-09-13 19:01:56", "2015-09-13 20:01:56", "79.134.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("959", "0", "magma", "2015-09-13 19:03:29", "2015-09-13 20:03:29", "197.0.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("960", "0", "magma", "2015-09-13 19:05:32", "2015-09-13 20:05:32", "213.226.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("961", "0", "magma", "2015-09-13 19:11:32", "2015-09-13 20:11:32", "85.238.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("962", "0", "magma", "2015-09-13 19:47:45", "2015-09-13 20:47:45", "108.183.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("963", "0", "magma", "2015-09-13 20:06:23", "2015-09-13 21:06:23", "176.109.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("964", "0", "magma", "2015-09-13 20:30:19", "2015-09-13 21:30:19", "86.124.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("965", "0", "magma", "2015-09-13 21:04:35", "2015-09-13 22:04:35", "178.93.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("966", "0", "magma", "2015-09-13 21:10:07", "2015-09-13 22:10:07", "92.82.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("967", "0", "magma", "2015-09-13 21:20:03", "2015-09-13 22:20:03", "46.99.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("968", "0", "admin", "2015-09-13 21:43:19", "2015-09-13 22:43:19", "178.17.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("969", "0", "admin", "2015-09-13 21:43:20", "2015-09-13 22:43:20", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("970", "0", "admin", "2015-09-13 21:43:20", "2015-09-13 22:43:20", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("971", "0", "admin", "2015-09-13 21:43:23", "2015-09-13 22:43:23", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("972", "0", "admin", "2015-09-13 21:43:25", "2015-09-13 22:43:25", "50.7.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("973", "0", "magma", "2015-09-13 22:47:19", "2015-09-13 23:47:19", "41.249.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("974", "0", "magma", "2015-09-13 22:53:45", "2015-09-13 23:53:45", "201.1.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("975", "0", "magma", "2015-09-13 22:54:25", "2015-09-13 23:54:25", "87.9.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("976", "0", "magma", "2015-09-14 02:40:21", "2015-09-14 03:40:21", "188.36.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("977", "0", "magma", "2015-09-14 04:09:21", "2015-09-14 05:09:21", "41.182.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("978", "0", "magma", "2015-09-14 05:45:03", "2015-09-14 06:45:03", "109.102.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("979", "0", "magma", "2015-09-14 07:19:13", "2015-09-14 08:19:13", "2.49.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("980", "0", "magma", "2015-09-14 07:34:07", "2015-09-14 08:34:07", "117.216.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("981", "0", "magma", "2015-09-14 07:51:11", "2015-09-14 08:51:11", "41.182.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("982", "0", "magma", "2015-09-14 08:04:35", "2015-09-14 09:04:35", "210.242.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("983", "0", "admin", "2015-09-14 08:17:07", "2015-09-14 09:17:07", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("984", "0", "admin", "2015-09-14 08:17:07", "2015-09-14 09:17:07", "37.157.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("985", "0", "admin", "2015-09-14 08:17:08", "2015-09-14 09:17:08", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("986", "0", "admin", "2015-09-14 08:17:09", "2015-09-14 09:17:09", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("987", "0", "admin", "2015-09-14 08:17:16", "2015-09-14 09:17:16", "85.93.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("988", "0", "magma", "2015-09-14 09:27:08", "2015-09-14 10:27:08", "95.254.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("989", "0", "magma", "2015-09-14 09:30:58", "2015-09-14 10:30:58", "217.75.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("990", "0", "magma", "2015-09-14 09:36:08", "2015-09-14 10:36:08", "158.181.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("991", "0", "magma", "2015-09-14 10:27:32", "2015-09-14 11:27:32", "188.69.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("992", "0", "magma", "2015-09-14 11:25:57", "2015-09-14 12:25:57", "31.154.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("993", "0", "magma", "2015-09-14 11:28:59", "2015-09-14 12:28:59", "146.255.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("994", "0", "magma", "2015-09-14 12:40:01", "2015-09-14 13:40:01", "41.67.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("995", "0", "magma", "2015-09-14 13:03:36", "2015-09-14 14:03:36", "79.116.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("996", "0", "magma", "2015-09-14 13:25:28", "2015-09-14 14:25:28", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("997", "0", "magma", "2015-09-14 13:32:48", "2015-09-14 14:32:48", "39.32.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("998", "0", "magma", "2015-09-14 14:12:11", "2015-09-14 15:12:11", "86.120.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("999", "0", "magma", "2015-09-14 14:12:58", "2015-09-14 15:12:58", "117.197.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1000", "0", "magma", "2015-09-14 14:42:47", "2015-09-14 15:42:47", "78.88.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1001", "0", "magma", "2015-09-14 15:17:05", "2015-09-14 16:17:05", "151.250.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1002", "0", "magma", "2015-09-14 15:43:33", "2015-09-14 16:43:33", "87.252.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1003", "0", "magma", "2015-09-14 15:55:36", "2015-09-14 16:55:36", "114.108.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1004", "0", "magma", "2015-09-14 16:10:27", "2015-09-14 17:10:27", "151.30.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1005", "0", "magma", "2015-09-14 16:28:58", "2015-09-14 17:28:58", "31.217.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1006", "0", "magma", "2015-09-14 16:33:18", "2015-09-14 17:33:18", "86.121.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1007", "0", "magma", "2015-09-14 16:37:09", "2015-09-14 17:37:09", "78.88.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1008", "0", "magma", "2015-09-14 16:44:08", "2015-09-14 17:44:08", "89.165.176.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1009", "0", "magma", "2015-09-14 17:07:32", "2015-09-14 18:07:32", "124.41.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1010", "0", "admin", "2015-09-14 20:01:20", "2015-09-14 21:01:20", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1011", "0", "admin", "2015-09-14 20:01:21", "2015-09-14 21:01:21", "85.10.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1012", "0", "admin", "2015-09-14 20:01:22", "2015-09-14 21:01:22", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1013", "0", "admin", "2015-09-14 20:01:23", "2015-09-14 21:01:23", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1014", "0", "admin", "2015-09-14 20:01:23", "2015-09-14 21:01:23", "37.48.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1015", "0", "magma", "2015-09-14 20:15:13", "2015-09-14 21:15:13", "178.221.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1016", "0", "magma", "2015-09-14 20:18:00", "2015-09-14 21:18:00", "180.234.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1017", "0", "magma", "2015-09-14 20:44:23", "2015-09-14 21:44:23", "92.97.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1018", "0", "magma", "2015-09-14 20:47:13", "2015-09-14 21:47:13", "95.49.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1019", "0", "magma", "2015-09-14 20:52:11", "2015-09-14 21:52:11", "89.138.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1020", "0", "magma", "2015-09-14 21:43:16", "2015-09-14 22:43:16", "182.181.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1021", "0", "magma", "2015-09-14 21:54:47", "2015-09-14 22:54:47", "46.107.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1022", "0", "magma", "2015-09-14 22:26:03", "2015-09-14 23:26:03", "177.200.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1023", "0", "Admin", "2015-09-14 23:39:55", "2015-09-15 00:39:55", "195.154.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1024", "0", "magma", "2015-09-14 23:52:04", "2015-09-15 00:52:04", "31.223.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1025", "0", "magma", "2015-09-15 00:07:51", "2015-09-15 01:07:51", "183.87.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1026", "0", "magma", "2015-09-15 00:20:45", "2015-09-15 01:20:45", "209.174.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1027", "0", "magma", "2015-09-15 00:48:39", "2015-09-15 01:48:39", "193.226.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1028", "0", "magma", "2015-09-15 01:02:57", "2015-09-15 02:02:57", "111.93.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1029", "0", "magma", "2015-09-15 01:48:59", "2015-09-15 02:48:59", "77.235.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1030", "0", "magma", "2015-09-15 02:12:47", "2015-09-15 03:12:47", "200.82.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1031", "0", "magma", "2015-09-15 02:37:40", "2015-09-15 03:37:40", "41.216.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1032", "0", "magma", "2015-09-15 03:34:42", "2015-09-15 04:34:42", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1033", "0", "magma", "2015-09-15 03:55:18", "2015-09-15 04:55:18", "189.49.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1034", "0", "magma", "2015-09-15 04:24:41", "2015-09-15 05:24:41", "190.78.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1035", "0", "magma", "2015-09-15 06:12:04", "2015-09-15 07:12:04", "41.216.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1036", "0", "magma", "2015-09-15 07:02:25", "2015-09-15 08:02:25", "177.18.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1037", "0", "admin", "2015-09-15 07:13:11", "2015-09-15 08:13:11", "87.118.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1038", "0", "admin", "2015-09-15 07:13:12", "2015-09-15 08:13:12", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1039", "0", "admin", "2015-09-15 07:13:12", "2015-09-15 08:13:12", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1040", "0", "admin", "2015-09-15 07:13:13", "2015-09-15 08:13:13", "194.150.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1041", "0", "magma", "2015-09-15 07:50:32", "2015-09-15 08:50:32", "49.145.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1042", "0", "magma", "2015-09-15 08:06:37", "2015-09-15 09:06:37", "95.68.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1043", "0", "magma", "2015-09-15 08:09:43", "2015-09-15 09:09:43", "103.55.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1044", "0", "magma", "2015-09-15 09:07:20", "2015-09-15 10:07:20", "2.50.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1045", "0", "magma", "2015-09-15 09:44:55", "2015-09-15 10:44:55", "2.49.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1046", "0", "magma", "2015-09-15 10:30:23", "2015-09-15 11:30:23", "213.55.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1047", "0", "magma", "2015-09-15 11:57:13", "2015-09-15 12:57:13", "178.220.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1048", "0", "magma", "2015-09-15 12:29:57", "2015-09-15 13:29:57", "60.54.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1049", "0", "magma", "2015-09-15 12:50:25", "2015-09-15 13:50:25", "46.117.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1050", "0", "magma", "2015-09-15 13:14:41", "2015-09-15 14:14:41", "80.8.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1051", "0", "magma", "2015-09-15 13:59:34", "2015-09-15 14:59:34", "94.21.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1052", "0", "magma", "2015-09-15 14:04:52", "2015-09-15 15:04:52", "92.87.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1053", "0", "magma", "2015-09-15 14:07:29", "2015-09-15 15:07:29", "42.115.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1054", "0", "magma", "2015-09-15 15:12:25", "2015-09-15 16:12:25", "85.238.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1055", "0", "magma", "2015-09-15 15:17:05", "2015-09-15 16:17:05", "120.28.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1056", "0", "magma", "2015-09-15 16:00:14", "2015-09-15 17:00:14", "188.135.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1057", "0", "magma", "2015-09-15 16:12:59", "2015-09-15 17:12:59", "89.138.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1058", "0", "magma", "2015-09-15 16:45:38", "2015-09-15 17:45:38", "117.222.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1059", "0", "magma", "2015-09-15 16:48:53", "2015-09-15 17:48:53", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1060", "0", "magma", "2015-09-15 16:55:16", "2015-09-15 17:55:16", "103.48.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1061", "0", "magma", "2015-09-15 17:15:18", "2015-09-15 18:15:18", "185.22.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1062", "0", "magma", "2015-09-15 18:06:49", "2015-09-15 19:06:49", "113.203.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1063", "0", "admin", "2015-09-15 18:21:59", "2015-09-15 19:21:59", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1064", "0", "admin", "2015-09-15 18:22:00", "2015-09-15 19:22:00", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1065", "0", "admin", "2015-09-15 18:22:00", "2015-09-15 19:22:00", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1066", "0", "admin", "2015-09-15 18:22:00", "2015-09-15 19:22:00", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1067", "0", "admin", "2015-09-15 18:22:10", "2015-09-15 19:22:10", "198.50.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1068", "0", "magma", "2015-09-15 19:16:55", "2015-09-15 20:16:55", "24.92.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1069", "0", "magma", "2015-09-15 19:37:32", "2015-09-15 20:37:32", "197.200.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1070", "0", "magma", "2015-09-15 20:31:24", "2015-09-15 21:31:24", "39.44.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1071", "0", "magma", "2015-09-15 21:04:28", "2015-09-15 22:04:28", "82.166.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1072", "0", "magma", "2015-09-15 22:42:10", "2015-09-15 23:42:10", "103.224.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1073", "0", "magma", "2015-09-16 00:07:03", "2015-09-16 01:07:03", "5.71.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1074", "0", "magma", "2015-09-16 01:27:19", "2015-09-16 02:27:19", "112.198.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1075", "0", "magma", "2015-09-16 02:21:50", "2015-09-16 03:21:50", "178.222.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1076", "0", "magma", "2015-09-16 03:30:57", "2015-09-16 04:30:57", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1077", "0", "magma", "2015-09-16 04:38:03", "2015-09-16 05:38:03", "196.207.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1078", "0", "admin", "2015-09-16 04:44:48", "2015-09-16 05:44:48", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1079", "0", "admin", "2015-09-16 04:44:48", "2015-09-16 05:44:48", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1080", "0", "admin", "2015-09-16 04:44:48", "2015-09-16 05:44:48", "46.182.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1081", "0", "admin", "2015-09-16 04:44:49", "2015-09-16 05:44:49", "96.47.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1082", "0", "admin", "2015-09-16 04:45:04", "2015-09-16 05:45:04", "87.98.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1083", "0", "magma", "2015-09-16 04:50:11", "2015-09-16 05:50:11", "188.173.255.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1084", "0", "magma", "2015-09-16 05:08:01", "2015-09-16 06:08:01", "46.40.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1085", "0", "magma", "2015-09-16 06:26:39", "2015-09-16 07:26:39", "1.52.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1086", "0", "magma", "2015-09-16 08:21:27", "2015-09-16 09:21:27", "197.221.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1087", "0", "magma", "2015-09-16 08:54:28", "2015-09-16 09:54:28", "46.107.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1088", "0", "magma", "2015-09-16 10:02:11", "2015-09-16 11:02:11", "118.136.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1089", "0", "magma", "2015-09-16 11:23:58", "2015-09-16 12:23:58", "5.55.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1090", "0", "magma", "2015-09-16 12:46:37", "2015-09-16 13:46:37", "14.192.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1091", "0", "magma", "2015-09-16 13:03:12", "2015-09-16 14:03:12", "178.220.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1092", "0", "magma", "2015-09-16 13:19:14", "2015-09-16 14:19:14", "94.21.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1093", "0", "magma", "2015-09-16 13:31:17", "2015-09-16 14:31:17", "5.178.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1094", "0", "magma", "2015-09-16 13:45:52", "2015-09-16 14:45:52", "91.206.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1095", "0", "magma", "2015-09-16 14:12:52", "2015-09-16 15:12:52", "89.42.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1096", "0", "magma", "2015-09-16 15:02:09", "2015-09-16 16:02:09", "92.82.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1097", "0", "admin", "2015-09-16 15:10:26", "2015-09-16 16:10:26", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1098", "0", "admin", "2015-09-16 15:10:27", "2015-09-16 16:10:27", "209.222.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1099", "0", "admin", "2015-09-16 15:10:28", "2015-09-16 16:10:28", "69.172.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1100", "0", "admin", "2015-09-16 15:10:29", "2015-09-16 16:10:29", "142.4.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1101", "0", "admin", "2015-09-16 15:10:29", "2015-09-16 16:10:29", "46.165.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1102", "0", "magma", "2015-09-16 17:59:27", "2015-09-16 18:59:27", "195.12.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1103", "0", "magma", "2015-09-16 18:30:29", "2015-09-16 19:30:29", "190.98.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1104", "0", "magma", "2015-09-16 19:00:30", "2015-09-16 20:00:30", "77.221.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1105", "0", "magma", "2015-09-16 19:13:22", "2015-09-16 20:13:22", "197.162.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1106", "0", "magma", "2015-09-16 20:24:50", "2015-09-16 21:24:50", "78.141.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1107", "0", "magma", "2015-09-16 21:20:53", "2015-09-16 22:20:53", "41.140.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1108", "0", "magma", "2015-09-16 21:56:51", "2015-09-16 22:56:51", "178.150.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1109", "0", "magma", "2015-09-16 22:12:25", "2015-09-16 23:12:25", "39.42.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1110", "0", "admin", "2015-09-17 02:19:31", "2015-09-17 03:19:31", "199.127.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1111", "0", "admin", "2015-09-17 02:19:31", "2015-09-17 03:19:31", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1112", "0", "admin", "2015-09-17 02:19:32", "2015-09-17 03:19:32", "93.115.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1113", "0", "admin", "2015-09-17 02:19:32", "2015-09-17 03:19:32", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1114", "0", "admin", "2015-09-17 02:19:35", "2015-09-17 03:19:35", "46.165.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1115", "0", "magma", "2015-09-17 06:19:43", "2015-09-17 07:19:43", "49.204.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1116", "0", "magma", "2015-09-17 07:44:45", "2015-09-17 08:44:45", "197.88.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1117", "0", "magma", "2015-09-17 08:29:00", "2015-09-17 09:29:00", "210.4.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1118", "0", "magma", "2015-09-17 08:58:05", "2015-09-17 09:58:05", "193.188.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1119", "0", "magma", "2015-09-17 09:45:15", "2015-09-17 10:45:15", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1120", "0", "magma", "2015-09-17 10:02:43", "2015-09-17 11:02:43", "59.161.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1121", "0", "magma", "2015-09-17 10:12:06", "2015-09-17 11:12:06", "31.154.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1122", "0", "magma", "2015-09-17 10:20:10", "2015-09-17 11:20:10", "83.50.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1123", "0", "magma", "2015-09-17 11:46:14", "2015-09-17 12:46:14", "185.82.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1124", "0", "magma", "2015-09-17 12:06:46", "2015-09-17 13:06:46", "89.215.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1125", "0", "admin", "2015-09-17 12:23:39", "2015-09-17 13:23:39", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1126", "0", "magma", "2015-09-17 13:48:14", "2015-09-17 14:48:14", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1127", "0", "magma", "2015-09-17 14:12:34", "2015-09-17 15:12:34", "60.54.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1128", "0", "magma", "2015-09-17 14:47:31", "2015-09-17 15:47:31", "200.153.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1129", "0", "magma", "2015-09-17 15:20:34", "2015-09-17 16:20:34", "152.118.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1130", "0", "magma", "2015-09-17 15:24:36", "2015-09-17 16:24:36", "109.101.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1131", "0", "magma", "2015-09-17 16:04:41", "2015-09-17 17:04:41", "117.200.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1132", "0", "magma", "2015-09-17 17:03:57", "2015-09-17 18:03:57", "81.196.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1133", "0", "magma", "2015-09-17 18:07:47", "2015-09-17 19:07:47", "5.97.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1134", "0", "magma", "2015-09-17 18:35:13", "2015-09-17 19:35:13", "41.67.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1135", "0", "magma", "2015-09-17 18:39:51", "2015-09-17 19:39:51", "31.215.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1136", "0", "magma", "2015-09-17 19:22:47", "2015-09-17 20:22:47", "94.21.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1137", "0", "magma", "2015-09-17 19:33:42", "2015-09-17 20:33:42", "39.59.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1138", "0", "magma", "2015-09-17 19:58:53", "2015-09-17 20:58:53", "223.223.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1139", "0", "magma", "2015-09-17 21:36:19", "2015-09-17 22:36:19", "2.50.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1140", "0", "admin", "2015-09-17 21:36:20", "2015-09-17 22:36:20", "94.142.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1141", "0", "admin", "2015-09-17 21:36:21", "2015-09-17 22:36:21", "109.163.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1142", "0", "magma", "2015-09-17 23:16:43", "2015-09-18 00:16:43", "94.132.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1143", "0", "magma", "2015-09-18 00:28:59", "2015-09-18 01:28:59", "41.223.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1144", "0", "magma", "2015-09-18 00:50:09", "2015-09-18 01:50:09", "188.2.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1145", "0", "magma", "2015-09-18 02:22:56", "2015-09-18 03:22:56", "178.67.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1146", "0", "magma", "2015-09-18 04:38:09", "2015-09-18 05:38:09", "37.237.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1147", "0", "magma", "2015-09-18 05:12:25", "2015-09-18 06:12:25", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1148", "0", "magma", "2015-09-18 05:37:19", "2015-09-18 06:37:19", "31.215.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1149", "0", "admin", "2015-09-18 06:19:41", "2015-09-18 07:19:41", "62.212.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1150", "0", "admin", "2015-09-18 06:19:41", "2015-09-18 07:19:41", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1151", "0", "magma", "2015-09-18 08:22:53", "2015-09-18 09:22:53", "78.167.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1152", "0", "magma", "2015-09-18 10:11:59", "2015-09-18 11:11:59", "119.74.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1153", "0", "magma", "2015-09-18 12:14:20", "2015-09-18 13:14:20", "5.107.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1154", "0", "magma", "2015-09-18 12:41:39", "2015-09-18 13:41:39", "78.182.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1155", "0", "magma", "2015-09-18 13:27:04", "2015-09-18 14:27:04", "89.39.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1156", "0", "magma", "2015-09-18 14:23:49", "2015-09-18 15:23:49", "95.61.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1157", "0", "magma", "2015-09-18 15:07:31", "2015-09-18 16:07:31", "93.145.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1158", "0", "magma", "2015-09-18 15:07:54", "2015-09-18 16:07:54", "118.136.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1159", "0", "magma", "2015-09-18 16:51:27", "2015-09-18 17:51:27", "39.58.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1160", "0", "magma", "2015-09-18 17:55:25", "2015-09-18 18:55:25", "223.223.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1161", "0", "magma", "2015-09-18 18:42:45", "2015-09-18 19:42:45", "178.164.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1162", "0", "magma", "2015-09-18 18:53:44", "2015-09-18 19:53:44", "113.203.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1163", "0", "magma", "2015-09-18 19:39:08", "2015-09-18 20:39:08", "177.18.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1164", "0", "magma", "2015-09-18 19:54:37", "2015-09-18 20:54:37", "182.185.26.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1165", "0", "magma", "2015-09-18 21:22:37", "2015-09-18 22:22:37", "197.200.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1166", "0", "admin8568", "2015-09-18 21:28:13", "2015-09-18 22:28:13", "196.210.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1167", "0", "magma", "2015-09-18 21:52:14", "2015-09-18 22:52:14", "92.83.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1168", "0", "magma", "2015-09-18 22:27:36", "2015-09-18 23:27:36", "79.119.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1169", "0", "magma", "2015-09-18 22:30:04", "2015-09-18 23:30:04", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1170", "0", "magma", "2015-09-18 22:52:50", "2015-09-18 23:52:50", "95.76.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1171", "0", "magma", "2015-09-18 23:06:56", "2015-09-19 00:06:56", "27.147.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1172", "0", "magma", "2015-09-19 00:14:13", "2015-09-19 01:14:13", "31.215.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1173", "0", "magma", "2015-09-19 00:41:13", "2015-09-19 01:41:13", "181.59.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1174", "0", "magma", "2015-09-19 00:47:40", "2015-09-19 01:47:40", "188.25.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1175", "0", "magma", "2015-09-19 01:03:11", "2015-09-19 02:03:11", "189.5.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1176", "0", "magma", "2015-09-19 01:07:26", "2015-09-19 02:07:26", "188.36.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1177", "0", "magma", "2015-09-19 02:04:27", "2015-09-19 03:04:27", "5.228.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1178", "0", "magma", "2015-09-19 03:18:43", "2015-09-19 04:18:43", "178.220.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1179", "0", "magma", "2015-09-19 05:11:01", "2015-09-19 06:11:01", "195.26.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1180", "0", "magma", "2015-09-19 06:29:48", "2015-09-19 07:29:48", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1181", "0", "magma", "2015-09-19 06:55:59", "2015-09-19 07:55:59", "203.112.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1182", "0", "magma", "2015-09-19 07:52:57", "2015-09-19 08:52:57", "122.3.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1183", "0", "magma", "2015-09-19 10:11:59", "2015-09-19 11:11:59", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1184", "0", "magma", "2015-09-19 10:59:16", "2015-09-19 11:59:16", "117.248.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1185", "0", "magma", "2015-09-19 11:40:54", "2015-09-19 12:40:54", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1186", "0", "magma", "2015-09-19 11:46:19", "2015-09-19 12:46:19", "115.76.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1187", "0", "magma", "2015-09-19 12:00:39", "2015-09-19 13:00:39", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1188", "0", "magma", "2015-09-19 12:21:55", "2015-09-19 13:21:55", "31.14.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1189", "0", "magma", "2015-09-19 12:57:28", "2015-09-19 13:57:28", "114.77.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1190", "0", "magma", "2015-09-19 13:09:33", "2015-09-19 14:09:33", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1191", "0", "magma", "2015-09-19 13:18:25", "2015-09-19 14:18:25", "178.234.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1192", "0", "magma", "2015-09-19 13:22:16", "2015-09-19 14:22:16", "133.209.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1193", "0", "magma", "2015-09-19 13:41:32", "2015-09-19 14:41:32", "41.228.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1194", "0", "magma", "2015-09-19 13:57:25", "2015-09-19 14:57:25", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1195", "0", "magma", "2015-09-19 15:08:41", "2015-09-19 16:08:41", "87.68.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1196", "0", "magma", "2015-09-19 16:43:06", "2015-09-19 17:43:06", "89.42.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1197", "0", "magma", "2015-09-19 16:53:21", "2015-09-19 17:53:21", "86.99.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1198", "0", "magma", "2015-09-19 17:04:51", "2015-09-19 18:04:51", "1.1.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1199", "0", "magma", "2015-09-19 17:13:01", "2015-09-19 18:13:01", "178.67.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1200", "0", "magma", "2015-09-19 17:36:10", "2015-09-19 18:36:10", "176.73.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1201", "0", "magma", "2015-09-19 18:30:50", "2015-09-19 19:30:50", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1202", "0", "magma", "2015-09-19 18:47:14", "2015-09-19 19:47:14", "5.14.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1203", "0", "magma", "2015-09-19 20:07:22", "2015-09-19 21:07:22", "180.191.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1204", "0", "magma", "2015-09-19 22:09:59", "2015-09-19 23:09:59", "181.59.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1205", "0", "magma", "2015-09-19 22:12:06", "2015-09-19 23:12:06", "103.252.164.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1206", "0", "magma", "2015-09-19 22:29:34", "2015-09-19 23:29:34", "46.121.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1207", "0", "magma", "2015-09-19 23:11:39", "2015-09-20 00:11:39", "78.29.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1208", "0", "magma", "2015-09-19 23:15:51", "2015-09-20 00:15:51", "77.36.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1209", "0", "magma", "2015-09-19 23:35:14", "2015-09-20 00:35:14", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1210", "0", "magma", "2015-09-20 01:14:34", "2015-09-20 02:14:34", "178.220.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1211", "0", "magma", "2015-09-20 01:17:09", "2015-09-20 02:17:09", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1212", "0", "magma", "2015-09-20 01:46:07", "2015-09-20 02:46:07", "112.134.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1213", "0", "magma", "2015-09-20 06:17:26", "2015-09-20 07:17:26", "41.67.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1214", "0", "magma", "2015-09-20 10:52:45", "2015-09-20 11:52:45", "178.164.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1215", "0", "magma", "2015-09-20 10:57:09", "2015-09-20 11:57:09", "176.109.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1216", "0", "magma", "2015-09-20 13:15:09", "2015-09-20 14:15:09", "89.35.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1217", "0", "magma", "2015-09-20 14:09:14", "2015-09-20 15:09:14", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1218", "0", "magma", "2015-09-20 14:26:33", "2015-09-20 15:26:33", "89.42.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1219", "0", "magma", "2015-09-20 15:02:00", "2015-09-20 16:02:00", "31.154.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1220", "0", "magma", "2015-09-20 17:45:48", "2015-09-20 18:45:48", "176.106.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1221", "0", "magma", "2015-09-20 17:57:39", "2015-09-20 18:57:39", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1222", "0", "magma", "2015-09-20 18:03:16", "2015-09-20 19:03:16", "41.100.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1223", "0", "magma", "2015-09-20 18:33:58", "2015-09-20 19:33:58", "42.201.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1224", "0", "magma", "2015-09-20 19:36:48", "2015-09-20 20:36:48", "82.166.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1225", "0", "magma", "2015-09-20 19:59:59", "2015-09-20 20:59:59", "41.226.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1226", "0", "magma", "2015-09-20 20:08:55", "2015-09-20 21:08:55", "146.255.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1227", "0", "magma", "2015-09-20 21:11:05", "2015-09-20 22:11:05", "31.11.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1228", "0", "magma", "2015-09-20 21:20:06", "2015-09-20 22:20:06", "77.239.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1229", "0", "magma", "2015-09-20 22:05:44", "2015-09-20 23:05:44", "178.220.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1230", "0", "magma", "2015-09-20 22:08:56", "2015-09-20 23:08:56", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1231", "0", "magma", "2015-09-20 22:40:39", "2015-09-20 23:40:39", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1232", "0", "magma", "2015-09-20 22:45:22", "2015-09-20 23:45:22", "31.185.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1233", "0", "magma", "2015-09-20 23:08:01", "2015-09-21 00:08:01", "176.106.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1234", "0", "magma", "2015-09-21 00:22:46", "2015-09-21 01:22:46", "190.75.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1235", "0", "magma", "2015-09-21 03:22:36", "2015-09-21 04:22:36", "186.121.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1236", "0", "magma", "2015-09-21 05:52:20", "2015-09-21 06:52:20", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1237", "0", "magma", "2015-09-21 07:44:02", "2015-09-21 08:44:02", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1238", "0", "magma", "2015-09-21 08:40:43", "2015-09-21 09:40:43", "117.222.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1239", "0", "magma", "2015-09-21 09:10:46", "2015-09-21 10:10:46", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1240", "0", "magma", "2015-09-21 11:47:26", "2015-09-21 12:47:26", "197.157.255.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1241", "0", "magma", "2015-09-21 12:07:29", "2015-09-21 13:07:29", "39.50.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1242", "0", "magma", "2015-09-21 12:28:32", "2015-09-21 13:28:32", "190.45.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1243", "1", "admin8576", "2015-09-21 12:36:09", "2015-09-21 13:36:09", "52.24.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1244", "0", "magma", "2015-09-21 13:18:16", "2015-09-21 14:18:16", "182.185.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1245", "0", "magma", "2015-09-21 14:16:53", "2015-09-21 15:16:53", "121.99.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1246", "0", "magma", "2015-09-21 14:41:17", "2015-09-21 15:41:17", "46.197.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1247", "0", "magma", "2015-09-21 15:14:47", "2015-09-21 16:14:47", "2.49.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1248", "0", "magma", "2015-09-21 15:49:52", "2015-09-21 16:49:52", "110.227.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1249", "0", "magma", "2015-09-21 15:56:14", "2015-09-21 16:56:14", "89.121.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1250", "0", "magma", "2015-09-21 16:04:55", "2015-09-21 17:04:55", "49.145.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1251", "0", "magma", "2015-09-21 16:36:03", "2015-09-21 17:36:03", "78.182.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1252", "0", "magma", "2015-09-21 17:14:06", "2015-09-21 18:14:06", "114.134.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1253", "0", "magma", "2015-09-21 17:47:17", "2015-09-21 18:47:17", "188.36.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1254", "0", "magma", "2015-09-21 18:52:57", "2015-09-21 19:52:57", "88.247.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1255", "0", "magma", "2015-09-21 19:01:10", "2015-09-21 20:01:10", "37.27.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1256", "0", "magma", "2015-09-21 19:17:10", "2015-09-21 20:17:10", "175.142.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1257", "0", "magma", "2015-09-21 19:58:07", "2015-09-21 20:58:07", "79.126.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1258", "0", "magma", "2015-09-21 20:24:04", "2015-09-21 21:24:04", "146.255.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1259", "0", "magma", "2015-09-21 20:51:20", "2015-09-21 21:51:20", "79.112.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1260", "0", "magma", "2015-09-21 21:21:03", "2015-09-21 22:21:03", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1261", "0", "magma", "2015-09-21 21:31:01", "2015-09-21 22:31:01", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1262", "0", "magma", "2015-09-21 22:05:08", "2015-09-21 23:05:08", "114.134.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1263", "0", "magma", "2015-09-21 22:11:44", "2015-09-21 23:11:44", "81.244.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1264", "0", "magma", "2015-09-21 23:33:04", "2015-09-22 00:33:04", "1.52.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1265", "0", "magma", "2015-09-22 00:04:46", "2015-09-22 01:04:46", "176.41.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1266", "0", "magma", "2015-09-22 04:06:53", "2015-09-22 05:06:53", "2.51.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1267", "0", "magma", "2015-09-22 04:07:46", "2015-09-22 05:07:46", "31.154.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1268", "0", "magma", "2015-09-22 07:41:44", "2015-09-22 08:41:44", "178.222.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1269", "0", "magma", "2015-09-22 10:08:42", "2015-09-22 11:08:42", "188.143.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1270", "0", "magma", "2015-09-22 11:07:17", "2015-09-22 12:07:17", "95.180.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1271", "0", "magma", "2015-09-22 12:36:37", "2015-09-22 13:36:37", "109.94.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1272", "0", "admin", "2015-09-22 14:40:35", "2015-09-22 15:40:35", "178.16.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1273", "0", "magma", "2015-09-22 14:56:03", "2015-09-22 15:56:03", "139.195.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1274", "0", "magma", "2015-09-22 15:17:23", "2015-09-22 16:17:23", "188.6.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1275", "0", "magma", "2015-09-22 15:29:02", "2015-09-22 16:29:02", "1.1.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1276", "0", "magma", "2015-09-22 16:26:02", "2015-09-22 17:26:02", "79.178.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1277", "0", "magma", "2015-09-22 16:31:03", "2015-09-22 17:31:03", "195.146.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1278", "0", "magma", "2015-09-22 17:09:04", "2015-09-22 18:09:04", "190.98.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1279", "0", "magma", "2015-09-22 17:10:27", "2015-09-22 18:10:27", "39.50.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1280", "0", "magma", "2015-09-22 17:17:22", "2015-09-22 18:17:22", "79.191.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1281", "0", "admin", "2015-09-22 18:00:31", "2015-09-22 19:00:31", "5.9.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1282", "0", "admin", "2015-09-22 18:00:32", "2015-09-22 19:00:32", "96.44.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1283", "0", "magma", "2015-09-22 18:47:19", "2015-09-22 19:47:19", "94.132.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1284", "0", "magma", "2015-09-22 18:53:54", "2015-09-22 19:53:54", "88.247.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1285", "0", "magma", "2015-09-22 19:06:02", "2015-09-22 20:06:02", "5.228.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1286", "0", "magma", "2015-09-22 19:27:34", "2015-09-22 20:27:34", "79.112.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1287", "0", "magma", "2015-09-22 20:26:14", "2015-09-22 21:26:14", "78.56.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1288", "0", "magma", "2015-09-22 20:50:05", "2015-09-22 21:50:05", "46.197.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1289", "0", "magma", "2015-09-22 21:13:50", "2015-09-22 22:13:50", "89.41.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1290", "0", "admin", "2015-09-22 21:20:06", "2015-09-22 22:20:06", "185.17.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1291", "0", "admin", "2015-09-22 21:20:15", "2015-09-22 22:20:15", "37.157.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1292", "0", "magma", "2015-09-23 00:58:37", "2015-09-23 01:58:37", "177.39.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1293", "0", "magma", "2015-09-23 01:44:18", "2015-09-23 02:44:18", "197.200.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1294", "0", "admin", "2015-09-23 02:30:04", "2015-09-23 03:30:04", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1295", "0", "magma", "2015-09-23 03:21:07", "2015-09-23 04:21:07", "192.0.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1296", "0", "magma", "2015-09-23 04:05:05", "2015-09-23 05:05:05", "179.192.155.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1297", "0", "magma", "2015-09-23 04:54:35", "2015-09-23 05:54:35", "114.77.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1298", "0", "admin", "2015-09-23 05:35:01", "2015-09-23 06:35:01", "188.138.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1299", "0", "admin", "2015-09-23 05:35:01", "2015-09-23 06:35:01", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1300", "1", "admin8576", "2015-09-23 06:08:55", "2015-09-23 07:08:55", "173.254.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1301", "0", "magma", "2015-09-23 06:19:17", "2015-09-23 07:19:17", "117.214.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1302", "0", "admin", "2015-09-23 09:02:48", "2015-09-23 10:02:48", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1303", "0", "admin", "2015-09-23 09:02:48", "2015-09-23 10:02:48", "5.255.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1304", "0", "magma", "2015-09-23 09:43:17", "2015-09-23 10:43:17", "119.94.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1305", "0", "magma", "2015-09-23 10:57:39", "2015-09-23 11:57:39", "176.106.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1306", "0", "magma", "2015-09-23 11:25:10", "2015-09-23 12:25:10", "37.0.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1307", "0", "magma", "2015-09-23 11:48:45", "2015-09-23 12:48:45", "81.196.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1308", "0", "magma", "2015-09-23 12:23:40", "2015-09-23 13:23:40", "190.147.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1309", "0", "magma", "2015-09-23 13:00:27", "2015-09-23 14:00:27", "78.169.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1310", "0", "magma", "2015-09-23 13:12:05", "2015-09-23 14:12:05", "213.197.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1311", "0", "admin", "2015-09-23 15:07:13", "2015-09-23 16:07:13", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1312", "0", "magma", "2015-09-23 15:13:22", "2015-09-23 16:13:22", "117.248.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1313", "0", "magma", "2015-09-23 15:17:32", "2015-09-23 16:17:32", "109.92.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1314", "0", "magma", "2015-09-23 15:30:48", "2015-09-23 16:30:48", "83.168.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1315", "0", "magma", "2015-09-23 15:40:08", "2015-09-23 16:40:08", "49.144.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1316", "0", "magma", "2015-09-23 16:01:27", "2015-09-23 17:01:27", "37.132.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1317", "0", "magma", "2015-09-23 16:06:02", "2015-09-23 17:06:02", "88.201.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1318", "0", "magma", "2015-09-23 16:40:53", "2015-09-23 17:40:53", "188.25.250.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1319", "0", "magma", "2015-09-23 17:34:20", "2015-09-23 18:34:20", "186.16.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1320", "0", "magma", "2015-09-23 18:06:48", "2015-09-23 19:06:48", "176.40.169.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1321", "0", "admin", "2015-09-23 18:49:46", "2015-09-23 19:49:46", "79.98.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1322", "0", "admin", "2015-09-23 18:49:46", "2015-09-23 19:49:46", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1323", "0", "magma", "2015-09-23 19:16:33", "2015-09-23 20:16:33", "178.79.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1324", "0", "magma", "2015-09-23 21:04:36", "2015-09-23 22:04:36", "95.92.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1325", "0", "magma", "2015-09-23 21:27:07", "2015-09-23 22:27:07", "62.209.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1326", "0", "magma", "2015-09-23 21:30:17", "2015-09-23 22:30:17", "146.255.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1327", "0", "admin", "2015-09-23 22:31:00", "2015-09-23 23:31:00", "5.9.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1328", "0", "admin", "2015-09-23 22:31:01", "2015-09-23 23:31:01", "185.11.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1329", "0", "magma", "2015-09-23 22:50:15", "2015-09-23 23:50:15", "141.85.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1330", "0", "magma", "2015-09-23 23:22:37", "2015-09-24 00:22:37", "82.146.26.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1331", "0", "magma", "2015-09-23 23:24:15", "2015-09-24 00:24:15", "189.5.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1332", "0", "magma", "2015-09-24 00:11:48", "2015-09-24 01:11:48", "77.235.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1333", "0", "magma", "2015-09-24 01:14:43", "2015-09-24 02:14:43", "83.168.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1334", "0", "admin", "2015-09-24 04:44:40", "2015-09-24 05:44:40", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1335", "0", "admin", "2015-09-24 08:08:51", "2015-09-24 09:08:51", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1336", "0", "admin", "2015-09-24 08:08:57", "2015-09-24 09:08:57", "50.7.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1337", "0", "magma", "2015-09-24 09:24:50", "2015-09-24 10:24:50", "212.235.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1338", "0", "magma", "2015-09-24 09:38:28", "2015-09-24 10:38:28", "60.49.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1339", "0", "magma", "2015-09-24 11:42:09", "2015-09-24 12:42:09", "81.182.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1340", "0", "admin", "2015-09-24 12:07:05", "2015-09-24 13:07:05", "5.79.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1341", "0", "admin", "2015-09-24 12:07:05", "2015-09-24 13:07:05", "199.87.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1342", "0", "magma", "2015-09-24 13:44:19", "2015-09-24 14:44:19", "83.50.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1343", "0", "magma", "2015-09-24 14:56:42", "2015-09-24 15:56:42", "120.28.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1344", "0", "magma", "2015-09-24 15:36:08", "2015-09-24 16:36:08", "95.92.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1345", "0", "magma", "2015-09-24 17:11:19", "2015-09-24 18:11:19", "41.182.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1346", "0", "magma", "2015-09-24 17:54:34", "2015-09-24 18:54:34", "197.38.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1347", "0", "admin", "2015-09-24 18:59:14", "2015-09-24 19:59:14", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1348", "0", "magma", "2015-09-24 19:00:34", "2015-09-24 20:00:34", "197.200.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1349", "0", "magma", "2015-09-24 20:06:03", "2015-09-24 21:06:03", "84.0.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1350", "0", "magma", "2015-09-24 20:58:05", "2015-09-24 21:58:05", "109.98.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1351", "0", "magma", "2015-09-24 22:32:31", "2015-09-24 23:32:31", "46.11.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1352", "0", "magma", "2015-09-24 22:45:06", "2015-09-24 23:45:06", "128.243.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1353", "0", "magma", "2015-09-24 22:50:04", "2015-09-24 23:50:04", "62.219.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1354", "0", "admin", "2015-09-24 22:53:36", "2015-09-24 23:53:36", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1355", "0", "admin", "2015-09-24 22:53:36", "2015-09-24 23:53:36", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1356", "0", "magma", "2015-09-24 23:29:00", "2015-09-25 00:29:00", "85.120.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1357", "0", "magma", "2015-09-24 23:45:57", "2015-09-25 00:45:57", "49.150.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1358", "0", "magma", "2015-09-25 00:12:23", "2015-09-25 01:12:23", "5.238.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1359", "0", "magma", "2015-09-25 01:06:33", "2015-09-25 02:06:33", "46.217.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1360", "0", "magma", "2015-09-25 01:12:24", "2015-09-25 02:12:24", "121.54.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1361", "0", "magma", "2015-09-25 01:28:52", "2015-09-25 02:28:52", "187.114.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1362", "0", "magma", "2015-09-25 02:27:19", "2015-09-25 03:27:19", "217.129.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1363", "0", "magma", "2015-09-25 02:33:45", "2015-09-25 03:33:45", "179.42.176.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1364", "0", "magma", "2015-09-25 02:39:41", "2015-09-25 03:39:41", "107.133.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1365", "0", "admin", "2015-09-25 02:57:32", "2015-09-25 03:57:32", "50.7.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1366", "0", "admin", "2015-09-25 02:57:39", "2015-09-25 03:57:39", "185.24.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1367", "0", "magma", "2015-09-25 03:30:50", "2015-09-25 04:30:50", "85.250.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1368", "0", "magma", "2015-09-25 04:28:09", "2015-09-25 05:28:09", "5.55.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1369", "0", "magma", "2015-09-25 05:09:56", "2015-09-25 06:09:56", "200.82.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1370", "0", "magma", "2015-09-25 08:08:36", "2015-09-25 09:08:36", "114.165.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1371", "0", "magma", "2015-09-25 09:11:33", "2015-09-25 10:11:33", "93.86.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1372", "0", "magma", "2015-09-25 09:35:40", "2015-09-25 10:35:40", "81.196.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1373", "0", "admin", "2015-09-25 09:41:22", "2015-09-25 10:41:22", "77.109.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1374", "0", "magma", "2015-09-25 10:52:34", "2015-09-25 11:52:34", "61.0.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1375", "0", "magma", "2015-09-25 10:55:06", "2015-09-25 11:55:06", "121.98.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1376", "0", "magma", "2015-09-25 12:00:56", "2015-09-25 13:00:56", "88.201.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1377", "0", "magma", "2015-09-25 12:33:56", "2015-09-25 13:33:56", "125.212.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1378", "0", "magma", "2015-09-25 12:34:32", "2015-09-25 13:34:32", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1379", "0", "magma", "2015-09-25 12:56:20", "2015-09-25 13:56:20", "46.107.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1380", "0", "admin", "2015-09-25 13:22:03", "2015-09-25 14:22:03", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1381", "0", "admin", "2015-09-25 13:22:12", "2015-09-25 14:22:12", "5.79.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1382", "0", "magma", "2015-09-25 13:27:57", "2015-09-25 14:27:57", "178.42.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1383", "0", "magma", "2015-09-25 13:35:39", "2015-09-25 14:35:39", "109.92.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1384", "0", "magma", "2015-09-25 13:50:41", "2015-09-25 14:50:41", "125.18.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1385", "0", "magma", "2015-09-25 14:56:50", "2015-09-25 15:56:50", "84.0.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1386", "0", "magma", "2015-09-25 15:17:44", "2015-09-25 16:17:44", "82.31.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1387", "0", "magma", "2015-09-25 16:13:14", "2015-09-25 17:13:14", "178.67.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1388", "0", "magma", "2015-09-25 16:14:05", "2015-09-25 17:14:05", "178.222.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1389", "0", "magma", "2015-09-25 16:26:44", "2015-09-25 17:26:44", "77.38.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1390", "0", "magma", "2015-09-25 16:51:37", "2015-09-25 17:51:37", "92.87.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1391", "0", "magma", "2015-09-25 17:16:36", "2015-09-25 18:16:36", "178.220.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1392", "0", "magma", "2015-09-25 17:23:47", "2015-09-25 18:23:47", "49.148.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1393", "0", "magma", "2015-09-25 17:25:45", "2015-09-25 18:25:45", "176.12.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1394", "0", "admin", "2015-09-25 17:47:00", "2015-09-25 18:47:00", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1395", "0", "admin", "2015-09-25 17:47:03", "2015-09-25 18:47:03", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1396", "0", "magma", "2015-09-25 18:09:57", "2015-09-25 19:09:57", "77.36.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1397", "0", "magma", "2015-09-25 18:26:46", "2015-09-25 19:26:46", "197.89.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1398", "0", "magma", "2015-09-25 18:50:54", "2015-09-25 19:50:54", "200.82.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1399", "0", "magma", "2015-09-25 18:52:53", "2015-09-25 19:52:53", "178.222.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1400", "0", "magma", "2015-09-25 19:01:39", "2015-09-25 20:01:39", "37.78.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1401", "0", "magma", "2015-09-25 19:03:50", "2015-09-25 20:03:50", "109.102.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1402", "0", "magma", "2015-09-25 20:14:22", "2015-09-25 21:14:22", "82.79.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1403", "0", "magma", "2015-09-25 20:28:43", "2015-09-25 21:28:43", "92.81.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1404", "0", "magma", "2015-09-25 22:03:17", "2015-09-25 23:03:17", "86.7.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1405", "0", "magma", "2015-09-25 22:07:29", "2015-09-25 23:07:29", "200.90.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1406", "0", "magma", "2015-09-25 23:43:57", "2015-09-26 00:43:57", "201.68.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1407", "0", "magma", "2015-09-26 00:49:25", "2015-09-26 01:49:25", "105.103.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1408", "0", "admin", "2015-09-26 01:08:00", "2015-09-26 02:08:00", "198.96.155.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1409", "0", "magma", "2015-09-26 01:16:10", "2015-09-26 02:16:10", "41.182.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1410", "0", "magma", "2015-09-26 03:02:41", "2015-09-26 04:02:41", "76.123.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1411", "0", "magma", "2015-09-26 04:29:42", "2015-09-26 05:29:42", "190.73.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1412", "0", "admin", "2015-09-26 04:35:04", "2015-09-26 05:35:04", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1413", "0", "admin", "2015-09-26 04:35:05", "2015-09-26 05:35:05", "82.221.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1414", "0", "magma", "2015-09-26 05:13:19", "2015-09-26 06:13:19", "153.175.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1415", "0", "magma", "2015-09-26 05:16:32", "2015-09-26 06:16:32", "86.25.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1416", "0", "magma", "2015-09-26 05:21:00", "2015-09-26 06:21:00", "200.54.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1417", "0", "magma", "2015-09-26 07:11:34", "2015-09-26 08:11:34", "200.90.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1418", "0", "magma", "2015-09-26 08:46:38", "2015-09-26 09:46:38", "31.11.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1419", "0", "admin", "2015-09-26 08:59:12", "2015-09-26 09:59:12", "193.111.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1420", "0", "admin", "2015-09-26 08:59:13", "2015-09-26 09:59:13", "198.23.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1421", "0", "magma", "2015-09-26 09:20:23", "2015-09-26 10:20:23", "109.77.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1422", "0", "magma", "2015-09-26 09:22:48", "2015-09-26 10:22:48", "183.91.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1423", "0", "magma", "2015-09-26 10:23:31", "2015-09-26 11:23:31", "95.21.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1424", "0", "magma", "2015-09-26 10:24:53", "2015-09-26 11:24:53", "115.99.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1425", "0", "magma", "2015-09-26 10:39:59", "2015-09-26 11:39:59", "176.106.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1426", "0", "magma", "2015-09-26 12:25:51", "2015-09-26 13:25:51", "86.38.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1427", "0", "magma", "2015-09-26 12:36:20", "2015-09-26 13:36:20", "77.238.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1428", "0", "magma", "2015-09-26 13:44:11", "2015-09-26 14:44:11", "46.252.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1429", "0", "magma", "2015-09-26 14:03:01", "2015-09-26 15:03:01", "80.242.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1430", "0", "magma", "2015-09-26 14:09:14", "2015-09-26 15:09:14", "27.106.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1431", "0", "magma", "2015-09-26 14:10:22", "2015-09-26 15:10:22", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1432", "0", "magma", "2015-09-26 14:28:10", "2015-09-26 15:28:10", "112.211.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1433", "0", "magma", "2015-09-26 15:23:51", "2015-09-26 16:23:51", "174.97.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1434", "0", "magma", "2015-09-26 16:09:25", "2015-09-26 17:09:25", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1435", "0", "magma", "2015-09-26 16:24:22", "2015-09-26 17:24:22", "121.7.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1436", "0", "magma", "2015-09-26 16:49:27", "2015-09-26 17:49:27", "189.5.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1437", "0", "admin", "2015-09-26 17:02:47", "2015-09-26 18:02:47", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1438", "0", "magma", "2015-09-26 17:49:04", "2015-09-26 18:49:04", "109.93.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1439", "0", "magma", "2015-09-26 18:28:04", "2015-09-26 19:28:04", "89.39.126.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1440", "0", "magma", "2015-09-26 18:52:17", "2015-09-26 19:52:17", "82.166.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1441", "0", "magma", "2015-09-26 19:43:16", "2015-09-26 20:43:16", "178.220.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1442", "0", "magma", "2015-09-26 20:16:26", "2015-09-26 21:16:26", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1443", "0", "magma", "2015-09-26 20:46:06", "2015-09-26 21:46:06", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1444", "0", "magma", "2015-09-26 20:51:55", "2015-09-26 21:51:55", "122.3.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1445", "0", "magma", "2015-09-26 22:21:07", "2015-09-26 23:21:07", "62.175.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1446", "0", "magma", "2015-09-26 22:28:50", "2015-09-26 23:28:50", "88.201.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1447", "0", "admin", "2015-09-27 00:50:55", "2015-09-27 01:50:55", "195.154.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1448", "0", "admin", "2015-09-27 00:50:55", "2015-09-27 01:50:55", "77.109.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1449", "0", "magma", "2015-09-27 02:46:29", "2015-09-27 03:46:29", "85.253.144.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1450", "0", "magma", "2015-09-27 03:33:17", "2015-09-27 04:33:17", "77.29.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1451", "0", "magma", "2015-09-27 05:25:47", "2015-09-27 06:25:47", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1452", "0", "magma", "2015-09-27 06:58:29", "2015-09-27 07:58:29", "98.177.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1453", "0", "magma", "2015-09-27 08:31:55", "2015-09-27 09:31:55", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1454", "0", "magma", "2015-09-27 12:20:05", "2015-09-27 13:20:05", "46.116.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1455", "0", "magma", "2015-09-27 13:25:01", "2015-09-27 14:25:01", "124.104.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1456", "0", "magma", "2015-09-27 13:58:39", "2015-09-27 14:58:39", "176.109.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1457", "0", "magma", "2015-09-27 15:12:47", "2015-09-27 16:12:47", "46.176.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1458", "0", "magma", "2015-09-27 16:48:56", "2015-09-27 17:48:56", "112.210.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1459", "0", "magma", "2015-09-27 17:02:22", "2015-09-27 18:02:22", "46.176.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1460", "0", "magma", "2015-09-27 17:06:03", "2015-09-27 18:06:03", "109.92.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1461", "0", "magma", "2015-09-27 17:23:09", "2015-09-27 18:23:09", "77.249.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1462", "0", "magma", "2015-09-27 17:24:11", "2015-09-27 18:24:11", "109.98.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1463", "0", "magma", "2015-09-27 17:53:23", "2015-09-27 18:53:23", "118.100.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1464", "0", "magma", "2015-09-27 19:02:19", "2015-09-27 20:02:19", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1465", "0", "magma", "2015-09-27 19:11:08", "2015-09-27 20:11:08", "89.164.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1466", "0", "magma", "2015-09-27 19:37:17", "2015-09-27 20:37:17", "95.86.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1467", "0", "magma", "2015-09-27 19:41:05", "2015-09-27 20:41:05", "93.103.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1468", "0", "magma", "2015-09-27 21:08:33", "2015-09-27 22:08:33", "5.228.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1469", "0", "magma", "2015-09-27 21:14:54", "2015-09-27 22:14:54", "189.176.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1470", "0", "magma", "2015-09-27 21:54:09", "2015-09-27 22:54:09", "95.76.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1471", "0", "magma", "2015-09-27 21:58:21", "2015-09-27 22:58:21", "83.83.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1472", "0", "magma", "2015-09-27 22:21:52", "2015-09-27 23:21:52", "188.2.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1473", "0", "magma", "2015-09-28 03:35:13", "2015-09-28 04:35:13", "109.92.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1474", "0", "magma", "2015-09-28 07:55:18", "2015-09-28 08:55:18", "186.137.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1475", "0", "magma", "2015-09-28 09:38:58", "2015-09-28 10:38:58", "83.168.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1476", "0", "magma", "2015-09-28 10:54:45", "2015-09-28 11:54:45", "193.248.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1477", "0", "magma", "2015-09-28 13:04:43", "2015-09-28 14:04:43", "79.106.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1478", "0", "magma", "2015-09-28 15:01:29", "2015-09-28 16:01:29", "31.41.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1479", "0", "magma", "2015-09-28 15:22:10", "2015-09-28 16:22:10", "109.245.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1480", "0", "magma", "2015-09-28 15:50:09", "2015-09-28 16:50:09", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1481", "0", "magma", "2015-09-28 16:04:40", "2015-09-28 17:04:40", "190.147.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1482", "0", "magma", "2015-09-28 16:47:01", "2015-09-28 17:47:01", "46.70.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1483", "0", "magma", "2015-09-28 17:01:45", "2015-09-28 18:01:45", "93.168.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1484", "0", "magma", "2015-09-28 17:50:24", "2015-09-28 18:50:24", "108.181.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1485", "0", "magma", "2015-09-28 18:11:06", "2015-09-28 19:11:06", "188.2.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1486", "0", "magma", "2015-09-28 18:31:38", "2015-09-28 19:31:38", "197.89.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1487", "0", "magma", "2015-09-28 19:18:22", "2015-09-28 20:18:22", "123.231.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1488", "0", "magma", "2015-09-28 19:23:24", "2015-09-28 20:23:24", "42.60.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1489", "0", "magma", "2015-09-28 19:32:29", "2015-09-28 20:32:29", "24.92.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1490", "0", "magma", "2015-09-28 21:18:57", "2015-09-28 22:18:57", "95.170.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1491", "0", "magma", "2015-09-28 22:21:39", "2015-09-28 23:21:39", "95.76.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1492", "0", "magma", "2015-09-29 00:26:32", "2015-09-29 01:26:32", "115.135.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1493", "0", "magma", "2015-09-29 03:23:41", "2015-09-29 04:23:41", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1494", "0", "magma", "2015-09-29 03:38:37", "2015-09-29 04:38:37", "37.27.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1495", "0", "magma", "2015-09-29 03:42:56", "2015-09-29 04:42:56", "81.183.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1496", "0", "magma", "2015-09-29 04:58:41", "2015-09-29 05:58:41", "174.97.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1497", "0", "magma", "2015-09-29 06:25:30", "2015-09-29 07:25:30", "1.52.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1498", "0", "magma", "2015-09-29 06:26:29", "2015-09-29 07:26:29", "112.209.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1499", "0", "magma", "2015-09-29 07:37:20", "2015-09-29 08:37:20", "186.121.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1500", "0", "magma", "2015-09-29 10:21:09", "2015-09-29 11:21:09", "176.40.169.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1501", "0", "magma", "2015-09-29 10:50:05", "2015-09-29 11:50:05", "93.103.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1502", "0", "magma", "2015-09-29 11:01:44", "2015-09-29 12:01:44", "182.185.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1503", "0", "magma", "2015-09-29 11:37:11", "2015-09-29 12:37:11", "79.129.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1504", "0", "magma", "2015-09-29 12:10:51", "2015-09-29 13:10:51", "79.112.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1505", "0", "magma", "2015-09-29 12:55:25", "2015-09-29 13:55:25", "180.250.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1506", "0", "admin", "2015-09-29 13:03:43", "2015-09-29 14:03:43", "92.222.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1507", "0", "admin", "2015-09-29 14:48:00", "2015-09-29 15:48:00", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1508", "0", "magma", "2015-09-29 14:54:10", "2015-09-29 15:54:10", "89.121.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1509", "0", "magma", "2015-09-29 15:36:49", "2015-09-29 16:36:49", "1.32.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1510", "0", "admin", "2015-09-29 15:47:20", "2015-09-29 16:47:20", "5.9.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1511", "0", "magma", "2015-09-29 16:10:39", "2015-09-29 17:10:39", "118.101.26.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1512", "0", "magma", "2015-09-29 16:22:06", "2015-09-29 17:22:06", "82.231.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1513", "0", "magma", "2015-09-29 16:50:38", "2015-09-29 17:50:38", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1514", "0", "magma", "2015-09-29 16:52:47", "2015-09-29 17:52:47", "89.44.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1515", "0", "admin", "2015-09-29 17:00:59", "2015-09-29 18:00:59", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1516", "0", "magma", "2015-09-29 17:38:22", "2015-09-29 18:38:22", "5.197.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1517", "0", "admin", "2015-09-29 17:55:30", "2015-09-29 18:55:30", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1518", "0", "magma", "2015-09-29 18:04:34", "2015-09-29 19:04:34", "121.99.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1519", "0", "magma", "2015-09-29 18:25:29", "2015-09-29 19:25:29", "112.207.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1520", "0", "magma", "2015-09-29 18:39:22", "2015-09-29 19:39:22", "104.200.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1521", "0", "magma", "2015-09-29 20:07:14", "2015-09-29 21:07:14", "109.92.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1522", "0", "magma", "2015-09-29 22:24:55", "2015-09-29 23:24:55", "196.205.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1523", "0", "magma", "2015-09-29 23:14:13", "2015-09-30 00:14:13", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1524", "0", "magma", "2015-09-30 00:20:31", "2015-09-30 01:20:31", "178.221.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1525", "0", "magma", "2015-09-30 00:22:24", "2015-09-30 01:22:24", "109.98.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1526", "0", "magma", "2015-09-30 01:52:26", "2015-09-30 02:52:26", "115.99.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1527", "0", "admin", "2015-09-30 04:03:03", "2015-09-30 05:03:03", "178.63.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1528", "0", "magma", "2015-09-30 04:19:52", "2015-09-30 05:19:52", "176.40.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1529", "0", "magma", "2015-09-30 05:25:33", "2015-09-30 06:25:33", "92.80.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1530", "0", "magma", "2015-09-30 05:48:40", "2015-09-30 06:48:40", "1.52.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1531", "0", "admin", "2015-09-30 05:56:48", "2015-09-30 06:56:48", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1532", "0", "magma", "2015-09-30 05:59:03", "2015-09-30 06:59:03", "109.76.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1533", "0", "magma", "2015-09-30 06:03:40", "2015-09-30 07:03:40", "49.146.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1534", "0", "magma", "2015-09-30 06:48:18", "2015-09-30 07:48:18", "178.221.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1535", "0", "admin", "2015-09-30 06:57:04", "2015-09-30 07:57:04", "85.24.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1536", "0", "magma", "2015-09-30 06:59:11", "2015-09-30 07:59:11", "1.52.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1537", "0", "admin", "2015-09-30 08:15:28", "2015-09-30 09:15:28", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1538", "0", "magma", "2015-09-30 09:03:56", "2015-09-30 10:03:56", "203.124.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1539", "0", "magma", "2015-09-30 09:04:27", "2015-09-30 10:04:27", "210.7.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1540", "0", "admin", "2015-09-30 09:09:18", "2015-09-30 10:09:18", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1541", "0", "magma", "2015-09-30 10:18:32", "2015-09-30 11:18:32", "151.250.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1542", "0", "magma", "2015-09-30 15:39:39", "2015-09-30 16:39:39", "188.2.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1543", "0", "magma", "2015-09-30 15:44:36", "2015-09-30 16:44:36", "187.107.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1544", "0", "magma", "2015-09-30 17:51:32", "2015-09-30 18:51:32", "197.255.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1545", "0", "magma", "2015-09-30 19:22:30", "2015-09-30 20:22:30", "89.44.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1546", "0", "admin", "2015-09-30 19:27:14", "2015-09-30 20:27:14", "5.79.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1547", "0", "magma", "2015-09-30 19:35:43", "2015-09-30 20:35:43", "81.64.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1548", "0", "magma", "2015-09-30 19:51:24", "2015-09-30 20:51:24", "2.85.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1549", "0", "magma", "2015-09-30 19:57:39", "2015-09-30 20:57:39", "188.36.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1550", "0", "admin", "2015-09-30 21:13:09", "2015-09-30 22:13:09", "185.29.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1551", "0", "magma", "2015-09-30 21:13:15", "2015-09-30 22:13:15", "149.78.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1552", "0", "admin", "2015-09-30 22:07:13", "2015-09-30 23:07:13", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1553", "0", "magma", "2015-09-30 22:34:42", "2015-09-30 23:34:42", "95.187.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1554", "0", "magma", "2015-09-30 23:08:32", "2015-10-01 00:08:32", "189.70.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1555", "0", "admin", "2015-09-30 23:20:35", "2015-10-01 00:20:35", "212.21.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1556", "0", "magma", "2015-09-30 23:48:45", "2015-10-01 00:48:45", "31.11.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1557", "0", "admin", "2015-10-01 00:05:55", "2015-10-01 01:05:55", "64.113.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1558", "0", "magma", "2015-10-01 00:44:09", "2015-10-01 01:44:09", "186.210.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1559", "0", "magma", "2015-10-01 01:59:31", "2015-10-01 02:59:31", "46.121.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1560", "0", "magma", "2015-10-01 07:17:41", "2015-10-01 08:17:41", "49.207.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1561", "0", "magma", "2015-10-01 08:41:32", "2015-10-01 09:41:32", "107.77.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1562", "0", "magma", "2015-10-01 08:44:59", "2015-10-01 09:44:59", "183.91.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1563", "0", "magma", "2015-10-01 09:19:40", "2015-10-01 10:19:40", "37.127.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1564", "0", "admin", "2015-10-01 09:22:22", "2015-10-01 10:22:22", "92.222.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1565", "0", "magma", "2015-10-01 09:28:04", "2015-10-01 10:28:04", "197.221.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1566", "0", "admin", "2015-10-01 10:56:40", "2015-10-01 11:56:40", "204.85.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1567", "0", "admin", "2015-10-01 11:41:13", "2015-10-01 12:41:13", "5.196.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1568", "0", "magma", "2015-10-01 11:42:00", "2015-10-01 12:42:00", "41.134.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1569", "0", "magma", "2015-10-01 12:32:30", "2015-10-01 13:32:30", "41.109.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1570", "0", "admin", "2015-10-01 12:53:45", "2015-10-01 13:53:45", "162.244.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1571", "0", "admin", "2015-10-01 13:33:56", "2015-10-01 14:33:56", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1572", "0", "magma", "2015-10-01 13:43:18", "2015-10-01 14:43:18", "212.93.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1573", "0", "magma", "2015-10-01 13:51:05", "2015-10-01 14:51:05", "59.92.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1574", "0", "magma", "2015-10-01 15:17:35", "2015-10-01 16:17:35", "217.71.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1575", "0", "magma", "2015-10-01 16:01:46", "2015-10-01 17:01:46", "92.87.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1576", "0", "magma", "2015-10-01 17:54:58", "2015-10-01 18:54:58", "79.116.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1577", "0", "magma", "2015-10-01 17:56:27", "2015-10-01 18:56:27", "87.68.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1578", "0", "magma", "2015-10-01 18:17:01", "2015-10-01 19:17:01", "201.33.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1579", "0", "magma", "2015-10-01 18:17:14", "2015-10-01 19:17:14", "77.253.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1580", "0", "magma", "2015-10-01 18:20:25", "2015-10-01 19:20:25", "39.35.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1581", "0", "magma", "2015-10-01 18:32:19", "2015-10-01 19:32:19", "2.177.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1582", "0", "magma", "2015-10-01 18:49:19", "2015-10-01 19:49:19", "79.177.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1583", "0", "magma", "2015-10-01 19:48:29", "2015-10-01 20:48:29", "37.217.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1584", "0", "magma", "2015-10-01 20:38:29", "2015-10-01 21:38:29", "79.36.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1585", "0", "magma", "2015-10-01 20:39:48", "2015-10-01 21:39:48", "5.197.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1586", "0", "magma", "2015-10-01 21:11:23", "2015-10-01 22:11:23", "95.95.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1587", "0", "magma", "2015-10-01 21:15:09", "2015-10-01 22:15:09", "41.59.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1588", "0", "magma", "2015-10-01 21:23:02", "2015-10-01 22:23:02", "81.244.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1589", "0", "magma", "2015-10-01 21:27:54", "2015-10-01 22:27:54", "58.65.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1590", "0", "magma", "2015-10-01 21:42:06", "2015-10-01 22:42:06", "100.96.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1591", "0", "magma", "2015-10-01 22:40:21", "2015-10-01 23:40:21", "217.254.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1592", "0", "magma", "2015-10-01 23:04:10", "2015-10-02 00:04:10", "78.61.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1593", "0", "admin", "2015-10-01 23:39:10", "2015-10-02 00:39:10", "198.100.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1594", "0", "magma", "2015-10-01 23:51:01", "2015-10-02 00:51:01", "210.212.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1595", "0", "magma", "2015-10-02 00:56:23", "2015-10-02 01:56:23", "188.2.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1596", "0", "admin", "2015-10-02 01:14:17", "2015-10-02 02:14:17", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1597", "0", "magma", "2015-10-02 01:27:05", "2015-10-02 02:27:05", "93.41.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1598", "0", "admin", "2015-10-02 01:54:45", "2015-10-02 02:54:45", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1599", "0", "magma", "2015-10-02 02:20:24", "2015-10-02 03:20:24", "200.90.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1600", "0", "magma", "2015-10-02 02:48:21", "2015-10-02 03:48:21", "172.7.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1601", "0", "admin", "2015-10-02 03:05:28", "2015-10-02 04:05:28", "94.242.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1602", "0", "magma", "2015-10-02 03:08:44", "2015-10-02 04:08:44", "37.27.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1603", "0", "admin", "2015-10-02 03:39:52", "2015-10-02 04:39:52", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1604", "0", "magma", "2015-10-02 06:42:52", "2015-10-02 07:42:52", "121.75.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1605", "0", "magma", "2015-10-02 07:39:53", "2015-10-02 08:39:53", "61.18.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1606", "0", "magma", "2015-10-02 08:35:04", "2015-10-02 09:35:04", "109.186.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1607", "0", "magma", "2015-10-02 09:07:27", "2015-10-02 10:07:27", "37.27.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1608", "0", "magma", "2015-10-02 09:15:30", "2015-10-02 10:15:30", "94.176.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1609", "0", "magma", "2015-10-02 10:17:04", "2015-10-02 11:17:04", "79.118.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1610", "0", "magma", "2015-10-02 11:01:17", "2015-10-02 12:01:17", "84.2.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1611", "0", "magma", "2015-10-02 11:16:12", "2015-10-02 12:16:12", "91.206.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1612", "0", "magma", "2015-10-02 11:20:31", "2015-10-02 12:20:31", "125.18.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1613", "0", "magma", "2015-10-02 12:14:08", "2015-10-02 13:14:08", "117.195.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1614", "0", "magma", "2015-10-02 12:16:06", "2015-10-02 13:16:06", "84.1.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1615", "0", "magma", "2015-10-02 12:51:19", "2015-10-02 13:51:19", "41.139.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1616", "0", "magma", "2015-10-02 13:05:32", "2015-10-02 14:05:32", "194.79.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1617", "0", "admin", "2015-10-02 14:23:45", "2015-10-02 15:23:45", "94.26.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1618", "0", "magma", "2015-10-02 14:58:07", "2015-10-02 15:58:07", "160.177.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1619", "0", "admin", "2015-10-02 15:02:17", "2015-10-02 16:02:17", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1620", "0", "admin", "2015-10-02 15:02:17", "2015-10-02 16:02:17", "188.138.9.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1621", "0", "magma", "2015-10-02 15:38:05", "2015-10-02 16:38:05", "197.156.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1622", "0", "magma", "2015-10-02 16:14:40", "2015-10-02 17:14:40", "46.116.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1623", "0", "admin", "2015-10-02 16:23:30", "2015-10-02 17:23:30", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1624", "0", "admin", "2015-10-02 16:56:32", "2015-10-02 17:56:32", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1625", "0", "magma", "2015-10-02 17:00:23", "2015-10-02 18:00:23", "89.121.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1626", "0", "magma", "2015-10-02 17:02:55", "2015-10-02 18:02:55", "27.130.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1627", "0", "magma", "2015-10-02 17:14:20", "2015-10-02 18:14:20", "43.224.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1628", "0", "magma", "2015-10-02 18:10:29", "2015-10-02 19:10:29", "109.98.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1629", "0", "magma", "2015-10-02 18:34:02", "2015-10-02 19:34:02", "117.0.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1630", "0", "magma", "2015-10-02 18:49:34", "2015-10-02 19:49:34", "176.12.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1631", "0", "magma", "2015-10-02 19:43:34", "2015-10-02 20:43:34", "77.81.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1632", "0", "magma", "2015-10-02 20:56:48", "2015-10-02 21:56:48", "46.103.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1633", "0", "magma", "2015-10-02 21:25:05", "2015-10-02 22:25:05", "126.64.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1634", "0", "magma", "2015-10-02 21:48:25", "2015-10-02 22:48:25", "5.197.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1635", "0", "magma", "2015-10-02 21:52:42", "2015-10-02 22:52:42", "77.46.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1636", "0", "magma", "2015-10-02 21:56:18", "2015-10-02 22:56:18", "93.57.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1637", "0", "magma", "2015-10-02 22:11:29", "2015-10-02 23:11:29", "188.2.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1638", "0", "magma", "2015-10-02 22:47:52", "2015-10-02 23:47:52", "46.214.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1639", "0", "magma", "2015-10-02 23:09:12", "2015-10-03 00:09:12", "95.246.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1640", "0", "magma", "2015-10-02 23:39:58", "2015-10-03 00:39:58", "60.53.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1641", "0", "magma", "2015-10-03 00:16:45", "2015-10-03 01:16:45", "197.32.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1642", "0", "magma", "2015-10-03 00:21:42", "2015-10-03 01:21:42", "112.204.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1643", "0", "magma", "2015-10-03 00:29:31", "2015-10-03 01:29:31", "190.60.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1644", "0", "magma", "2015-10-03 01:13:18", "2015-10-03 02:13:18", "49.150.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1645", "0", "magma", "2015-10-03 01:25:12", "2015-10-03 02:25:12", "191.183.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1646", "0", "magma", "2015-10-03 01:42:37", "2015-10-03 02:42:37", "178.220.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1647", "0", "magma", "2015-10-03 02:23:05", "2015-10-03 03:23:05", "81.182.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1648", "0", "magma", "2015-10-03 02:44:49", "2015-10-03 03:44:49", "200.88.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1649", "0", "admin", "2015-10-03 04:17:22", "2015-10-03 05:17:22", "176.31.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1650", "0", "magma", "2015-10-03 04:33:19", "2015-10-03 05:33:19", "116.237.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1651", "0", "admin", "2015-10-03 04:44:23", "2015-10-03 05:44:23", "5.135.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1652", "0", "admin", "2015-10-03 06:04:07", "2015-10-03 07:04:07", "212.232.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1653", "0", "admin", "2015-10-03 06:28:40", "2015-10-03 07:28:40", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1654", "0", "admin", "2015-10-03 06:39:25", "2015-10-03 07:39:25", "158.69.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1655", "0", "magma", "2015-10-03 08:10:08", "2015-10-03 09:10:08", "122.57.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1656", "0", "magma", "2015-10-03 08:26:08", "2015-10-03 09:26:08", "27.109.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1657", "0", "magma", "2015-10-03 10:03:17", "2015-10-03 11:03:17", "119.92.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1658", "0", "magma", "2015-10-03 10:23:29", "2015-10-03 11:23:29", "77.29.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1659", "0", "magma", "2015-10-03 10:24:58", "2015-10-03 11:24:58", "112.204.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1660", "0", "magma", "2015-10-03 10:52:45", "2015-10-03 11:52:45", "78.61.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1661", "0", "magma", "2015-10-03 11:08:54", "2015-10-03 12:08:54", "176.41.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1662", "0", "magma", "2015-10-03 11:28:29", "2015-10-03 12:28:29", "211.18.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1663", "0", "magma", "2015-10-03 14:22:37", "2015-10-03 15:22:37", "112.207.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1664", "0", "magma", "2015-10-03 15:29:32", "2015-10-03 16:29:32", "77.36.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1665", "0", "magma", "2015-10-03 15:30:57", "2015-10-03 16:30:57", "2.133.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1666", "0", "admin", "2015-10-03 16:40:23", "2015-10-03 17:40:23", "62.210.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1667", "0", "magma", "2015-10-03 17:23:42", "2015-10-03 18:23:42", "149.78.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1668", "0", "magma", "2015-10-03 17:38:33", "2015-10-03 18:38:33", "109.92.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1669", "0", "magma", "2015-10-03 17:47:22", "2015-10-03 18:47:22", "84.94.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1670", "0", "magma", "2015-10-03 18:02:26", "2015-10-03 19:02:26", "59.178.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1671", "0", "magma", "2015-10-03 18:40:55", "2015-10-03 19:40:55", "192.0.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1672", "0", "magma", "2015-10-03 18:58:07", "2015-10-03 19:58:07", "46.167.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1673", "0", "magma", "2015-10-03 19:02:17", "2015-10-03 20:02:17", "88.159.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1674", "0", "magma", "2015-10-03 19:02:41", "2015-10-03 20:02:41", "86.19.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1675", "0", "magma", "2015-10-03 19:06:21", "2015-10-03 20:06:21", "103.51.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1676", "0", "magma", "2015-10-03 19:12:55", "2015-10-03 20:12:55", "71.198.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1677", "0", "magma", "2015-10-03 19:13:25", "2015-10-03 20:13:25", "141.237.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1678", "0", "magma", "2015-10-03 19:16:06", "2015-10-03 20:16:06", "118.70.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1679", "0", "magma", "2015-10-03 19:25:53", "2015-10-03 20:25:53", "46.219.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1680", "0", "magma", "2015-10-03 19:28:22", "2015-10-03 20:28:22", "142.51.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1681", "0", "magma", "2015-10-03 19:31:06", "2015-10-03 20:31:06", "151.33.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1682", "0", "magma", "2015-10-03 19:44:47", "2015-10-03 20:44:47", "177.188.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1683", "0", "magma", "2015-10-03 19:46:29", "2015-10-03 20:46:29", "200.35.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1684", "0", "magma", "2015-10-03 19:57:34", "2015-10-03 20:57:34", "172.16.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1685", "0", "magma", "2015-10-03 19:59:31", "2015-10-03 20:59:31", "105.154.39.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1686", "0", "magma", "2015-10-03 20:01:11", "2015-10-03 21:01:11", "93.11.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1687", "0", "magma", "2015-10-03 20:02:52", "2015-10-03 21:02:52", "182.186.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1688", "0", "magma", "2015-10-03 20:03:01", "2015-10-03 21:03:01", "49.145.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1689", "0", "magma", "2015-10-03 20:04:02", "2015-10-03 21:04:02", "103.231.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1690", "0", "magma", "2015-10-03 20:04:04", "2015-10-03 21:04:04", "78.58.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1691", "0", "magma", "2015-10-03 20:05:34", "2015-10-03 21:05:34", "109.60.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1692", "0", "magma", "2015-10-03 20:22:17", "2015-10-03 21:22:17", "75.158.158.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1693", "0", "magma", "2015-10-03 20:45:15", "2015-10-03 21:45:15", "196.2.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1694", "0", "magma", "2015-10-03 20:49:45", "2015-10-03 21:49:45", "39.33.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1695", "0", "magma", "2015-10-03 21:00:21", "2015-10-03 22:00:21", "95.103.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1696", "0", "magma", "2015-10-03 21:05:16", "2015-10-03 22:05:16", "84.29.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1697", "0", "magma", "2015-10-03 21:19:20", "2015-10-03 22:19:20", "109.205.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1698", "0", "magma", "2015-10-03 21:33:00", "2015-10-03 22:33:00", "77.222.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1699", "0", "magma", "2015-10-03 21:41:12", "2015-10-03 22:41:12", "213.49.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1700", "0", "magma", "2015-10-03 22:08:40", "2015-10-03 23:08:40", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1701", "0", "magma", "2015-10-03 22:20:48", "2015-10-03 23:20:48", "85.244.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1702", "0", "magma", "2015-10-03 22:31:03", "2015-10-03 23:31:03", "185.18.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1703", "0", "magma", "2015-10-03 22:41:34", "2015-10-03 23:41:34", "94.76.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1704", "0", "magma", "2015-10-03 22:56:38", "2015-10-03 23:56:38", "27.34.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1705", "0", "magma", "2015-10-04 00:33:19", "2015-10-04 01:33:19", "178.243.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1706", "0", "admin", "2015-10-04 00:50:33", "2015-10-04 01:50:33", "176.31.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1707", "0", "magma", "2015-10-04 00:50:39", "2015-10-04 01:50:39", "82.49.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1708", "0", "magma", "2015-10-04 01:28:38", "2015-10-04 02:28:38", "98.160.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1709", "0", "magmainc", "2015-10-04 02:24:51", "2015-10-04 03:24:51", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1710", "0", "magma", "2015-10-04 02:51:14", "2015-10-04 03:51:14", "93.86.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1711", "0", "magma", "2015-10-04 03:01:39", "2015-10-04 04:01:39", "210.195.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1712", "0", "magmainc", "2015-10-04 04:02:28", "2015-10-04 05:02:28", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1713", "0", "magma", "2015-10-04 04:12:11", "2015-10-04 05:12:11", "42.115.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1714", "0", "magma", "2015-10-04 05:10:09", "2015-10-04 06:10:09", "112.208.206.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1715", "0", "magma", "2015-10-04 05:30:09", "2015-10-04 06:30:09", "82.65.147.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1716", "0", "magmainc.co.za", "2015-10-04 05:45:03", "2015-10-04 06:45:03", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1717", "0", "magma", "2015-10-04 06:11:53", "2015-10-04 07:11:53", "218.185.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1718", "0", "magma", "2015-10-04 06:50:17", "2015-10-04 07:50:17", "94.242.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1719", "0", "magma", "2015-10-04 06:50:39", "2015-10-04 07:50:39", "108.23.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1720", "0", "magmainc.co.za", "2015-10-04 07:25:23", "2015-10-04 08:25:23", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1721", "0", "magma", "2015-10-04 07:58:08", "2015-10-04 08:58:08", "46.167.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1722", "0", "magma", "2015-10-04 08:29:16", "2015-10-04 09:29:16", "178.41.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1723", "0", "admin", "2015-10-04 08:39:58", "2015-10-04 09:39:58", "92.222.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1724", "0", "magma", "2015-10-04 08:45:45", "2015-10-04 09:45:45", "121.181.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1725", "0", "magma", "2015-10-04 08:50:38", "2015-10-04 09:50:38", "150.129.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1726", "0", "magma", "2015-10-04 09:07:27", "2015-10-04 10:07:27", "118.96.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1727", "0", "magmainc.co.za", "2015-10-04 09:08:06", "2015-10-04 10:08:06", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1728", "0", "magma", "2015-10-04 09:21:01", "2015-10-04 10:21:01", "109.102.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1729", "0", "magma", "2015-10-04 09:40:23", "2015-10-04 10:40:23", "77.85.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1730", "0", "magma", "2015-10-04 10:03:20", "2015-10-04 11:03:20", "78.248.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1731", "0", "magma", "2015-10-04 10:04:35", "2015-10-04 11:04:35", "182.178.147.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1732", "0", "magma", "2015-10-04 10:25:46", "2015-10-04 11:25:46", "41.79.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1733", "0", "magma", "2015-10-04 10:41:40", "2015-10-04 11:41:40", "203.87.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1734", "0", "magma", "2015-10-04 10:46:14", "2015-10-04 11:46:14", "112.198.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1735", "0", "magmainc.co.za", "2015-10-04 10:52:06", "2015-10-04 11:52:06", "146.185.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1736", "0", "magma", "2015-10-04 11:07:48", "2015-10-04 12:07:48", "27.34.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1737", "0", "magma", "2015-10-04 11:36:40", "2015-10-04 12:36:40", "188.241.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1738", "0", "magma", "2015-10-04 11:50:48", "2015-10-04 12:50:48", "83.6.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1739", "0", "magma", "2015-10-04 11:59:59", "2015-10-04 12:59:59", "103.255.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1740", "0", "magma", "2015-10-04 12:39:25", "2015-10-04 13:39:25", "113.203.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1741", "0", "magma", "2015-10-04 13:16:17", "2015-10-04 14:16:17", "122.54.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1742", "0", "magma", "2015-10-04 13:27:44", "2015-10-04 14:27:44", "188.205.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1743", "0", "magma", "2015-10-04 13:31:53", "2015-10-04 14:31:53", "121.54.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1744", "0", "magma", "2015-10-04 13:35:53", "2015-10-04 14:35:53", "2.100.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1745", "0", "magma", "2015-10-04 13:38:39", "2015-10-04 14:38:39", "197.202.155.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1746", "0", "magma", "2015-10-04 13:41:29", "2015-10-04 14:41:29", "62.198.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1747", "0", "magma", "2015-10-04 13:42:41", "2015-10-04 14:42:41", "81.233.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1748", "0", "magma", "2015-10-04 13:47:12", "2015-10-04 14:47:12", "188.25.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1749", "0", "magma", "2015-10-04 14:05:25", "2015-10-04 15:05:25", "185.19.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1750", "0", "magma", "2015-10-04 14:52:42", "2015-10-04 15:52:42", "117.201.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1751", "0", "magma", "2015-10-04 15:45:02", "2015-10-04 16:45:02", "114.108.222.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1752", "0", "magma", "2015-10-04 16:46:35", "2015-10-04 17:46:35", "36.84.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1753", "0", "magma", "2015-10-04 16:51:49", "2015-10-04 17:51:49", "180.190.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1754", "0", "magma", "2015-10-04 16:59:46", "2015-10-04 17:59:46", "86.126.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1755", "0", "magma", "2015-10-04 17:12:50", "2015-10-04 18:12:50", "39.53.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1756", "0", "magma", "2015-10-04 17:14:15", "2015-10-04 18:14:15", "160.242.130.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1757", "0", "magma", "2015-10-04 17:28:39", "2015-10-04 18:28:39", "93.92.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1758", "0", "magma", "2015-10-04 17:28:40", "2015-10-04 18:28:40", "39.41.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1759", "0", "magma", "2015-10-04 17:42:01", "2015-10-04 18:42:01", "78.60.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1760", "0", "magma", "2015-10-04 17:54:14", "2015-10-04 18:54:14", "68.193.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1761", "0", "magma", "2015-10-04 18:11:46", "2015-10-04 19:11:46", "58.26.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1762", "0", "magma", "2015-10-04 18:28:55", "2015-10-04 19:28:55", "1.186.37.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1763", "0", "magma", "2015-10-04 18:58:45", "2015-10-04 19:58:45", "62.169.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1764", "0", "magma", "2015-10-04 20:29:35", "2015-10-04 21:29:35", "95.180.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1765", "0", "magma", "2015-10-04 20:39:39", "2015-10-04 21:39:39", "85.99.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1766", "0", "magma", "2015-10-04 21:37:10", "2015-10-04 22:37:10", "173.217.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1767", "0", "magma", "2015-10-04 22:04:42", "2015-10-04 23:04:42", "37.6.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1768", "0", "magma", "2015-10-04 22:46:48", "2015-10-04 23:46:48", "24.205.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1769", "0", "magma", "2015-10-04 23:27:57", "2015-10-05 00:27:57", "134.176.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1770", "0", "magma", "2015-10-04 23:56:57", "2015-10-05 00:56:57", "31.2.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1771", "0", "magma", "2015-10-05 00:22:45", "2015-10-05 01:22:45", "187.38.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1772", "0", "magma", "2015-10-05 02:22:02", "2015-10-05 03:22:02", "191.240.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1773", "0", "admin", "2015-10-05 02:59:00", "2015-10-05 03:59:00", "5.196.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1774", "0", "magma", "2015-10-05 04:54:03", "2015-10-05 05:54:03", "92.158.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1775", "0", "magma", "2015-10-05 05:14:56", "2015-10-05 06:14:56", "117.197.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1776", "0", "magma", "2015-10-05 05:31:28", "2015-10-05 06:31:28", "99.248.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1777", "0", "magma", "2015-10-05 06:00:15", "2015-10-05 07:00:15", "171.96.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1778", "0", "magma", "2015-10-05 09:18:34", "2015-10-05 10:18:34", "85.127.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1779", "0", "magma", "2015-10-05 09:22:23", "2015-10-05 10:22:23", "188.37.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1780", "0", "magma", "2015-10-05 09:56:37", "2015-10-05 10:56:37", "121.99.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1781", "0", "admin", "2015-10-05 11:01:31", "2015-10-05 12:01:31", "91.109.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1782", "0", "admin", "2015-10-05 11:28:38", "2015-10-05 12:28:38", "185.101.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1783", "0", "magma", "2015-10-05 11:48:29", "2015-10-05 12:48:29", "202.67.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1784", "0", "magma", "2015-10-05 11:49:57", "2015-10-05 12:49:57", "180.191.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1785", "0", "admin", "2015-10-05 12:01:40", "2015-10-05 13:01:40", "5.9.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1786", "0", "magma", "2015-10-05 13:11:38", "2015-10-05 14:11:38", "89.68.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1787", "0", "magma", "2015-10-05 13:46:44", "2015-10-05 14:46:44", "222.118.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1788", "0", "magma", "2015-10-05 13:49:10", "2015-10-05 14:49:10", "88.201.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1789", "0", "admin", "2015-10-05 14:58:38", "2015-10-05 15:58:38", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1790", "0", "magma", "2015-10-05 14:59:43", "2015-10-05 15:59:43", "79.177.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1791", "0", "magma", "2015-10-05 15:53:38", "2015-10-05 16:53:38", "121.99.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1792", "0", "magma", "2015-10-05 16:02:13", "2015-10-05 17:02:13", "86.107.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1793", "0", "magma", "2015-10-05 16:20:19", "2015-10-05 17:20:19", "5.2.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1794", "0", "magma", "2015-10-05 17:01:30", "2015-10-05 18:01:30", "92.252.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1795", "0", "magma", "2015-10-05 17:23:49", "2015-10-05 18:23:49", "1.23.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1796", "0", "magma", "2015-10-05 17:40:45", "2015-10-05 18:40:45", "92.51.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1797", "0", "magma", "2015-10-05 17:51:25", "2015-10-05 18:51:25", "46.211.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1798", "0", "magma", "2015-10-05 19:07:00", "2015-10-05 20:07:00", "203.215.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1799", "0", "magma", "2015-10-05 20:07:57", "2015-10-05 21:07:57", "182.65.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1800", "0", "magma", "2015-10-05 20:20:20", "2015-10-05 21:20:20", "14.47.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1801", "0", "magma", "2015-10-05 20:24:58", "2015-10-05 21:24:58", "93.109.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1802", "0", "admin", "2015-10-05 21:51:57", "2015-10-05 22:51:57", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1803", "0", "magma", "2015-10-05 21:52:46", "2015-10-05 22:52:46", "78.158.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1804", "0", "admin", "2015-10-05 22:06:07", "2015-10-05 23:06:07", "212.16.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1805", "0", "magma", "2015-10-05 22:43:55", "2015-10-05 23:43:55", "77.77.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1806", "0", "admin", "2015-10-05 22:55:06", "2015-10-05 23:55:06", "185.34.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1807", "0", "magma", "2015-10-05 23:20:49", "2015-10-06 00:20:49", "5.28.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1808", "0", "magma", "2015-10-05 23:35:28", "2015-10-06 00:35:28", "80.242.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1809", "0", "magma", "2015-10-06 01:42:32", "2015-10-06 02:42:32", "73.46.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1810", "0", "admin", "2015-10-06 01:57:04", "2015-10-06 02:57:04", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1811", "0", "magma", "2015-10-06 02:31:56", "2015-10-06 03:31:56", "2.33.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1812", "0", "magma", "2015-10-06 03:22:04", "2015-10-06 04:22:04", "114.77.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1813", "0", "magma", "2015-10-06 06:44:50", "2015-10-06 07:44:50", "95.76.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1814", "0", "magma", "2015-10-06 07:05:11", "2015-10-06 08:05:11", "79.115.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1815", "0", "admin", "2015-10-06 07:23:29", "2015-10-06 08:23:29", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1816", "0", "admin", "2015-10-06 07:34:40", "2015-10-06 08:34:40", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1817", "0", "admin", "2015-10-06 08:06:03", "2015-10-06 09:06:03", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1818", "0", "magma", "2015-10-06 08:11:56", "2015-10-06 09:11:56", "114.69.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1819", "0", "magma", "2015-10-06 08:13:08", "2015-10-06 09:13:08", "203.111.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1820", "0", "magma", "2015-10-06 08:32:12", "2015-10-06 09:32:12", "197.6.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1821", "0", "magma", "2015-10-06 09:32:18", "2015-10-06 10:32:18", "42.83.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1822", "0", "magma", "2015-10-06 11:05:18", "2015-10-06 12:05:18", "180.227.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1823", "0", "magma", "2015-10-06 14:46:50", "2015-10-06 15:46:50", "197.203.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1824", "0", "magma", "2015-10-06 14:51:30", "2015-10-06 15:51:30", "46.121.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1825", "0", "magma", "2015-10-06 14:55:46", "2015-10-06 15:55:46", "62.81.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1826", "0", "magma", "2015-10-06 15:28:56", "2015-10-06 16:28:56", "119.94.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1827", "0", "magma", "2015-10-06 15:53:27", "2015-10-06 16:53:27", "94.76.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1828", "0", "magma", "2015-10-06 17:03:03", "2015-10-06 18:03:03", "175.145.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1829", "0", "admin", "2015-10-06 17:05:00", "2015-10-06 18:05:00", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1830", "0", "admin", "2015-10-06 17:23:20", "2015-10-06 18:23:20", "149.202.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1831", "0", "magma", "2015-10-06 17:41:28", "2015-10-06 18:41:28", "114.108.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1832", "0", "magma", "2015-10-06 17:50:23", "2015-10-06 18:50:23", "178.220.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1833", "0", "admin", "2015-10-06 17:50:33", "2015-10-06 18:50:33", "94.242.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1834", "0", "magma", "2015-10-06 18:25:33", "2015-10-06 19:25:33", "90.190.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1835", "0", "magma", "2015-10-06 18:36:32", "2015-10-06 19:36:32", "179.104.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1836", "0", "magma", "2015-10-06 20:29:18", "2015-10-06 21:29:18", "87.2.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1837", "0", "admin", "2015-10-06 22:01:35", "2015-10-06 23:01:35", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1838", "0", "magma", "2015-10-06 23:50:45", "2015-10-07 00:50:45", "178.220.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1839", "0", "magma", "2015-10-06 23:54:52", "2015-10-07 00:54:52", "81.245.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1840", "0", "magma", "2015-10-07 00:13:34", "2015-10-07 01:13:34", "197.89.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1841", "0", "magma", "2015-10-07 00:20:59", "2015-10-07 01:20:59", "185.36.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1842", "0", "admin", "2015-10-07 03:05:12", "2015-10-07 04:05:12", "192.42.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1843", "0", "admin", "2015-10-07 03:27:21", "2015-10-07 04:27:21", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1844", "0", "magma", "2015-10-07 07:39:28", "2015-10-07 08:39:28", "14.98.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1845", "0", "admin", "2015-10-07 07:43:53", "2015-10-07 08:43:53", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1846", "0", "magma", "2015-10-07 08:11:55", "2015-10-07 09:11:55", "197.221.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1847", "0", "magma", "2015-10-07 11:00:48", "2015-10-07 12:00:48", "79.185.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1848", "0", "magma", "2015-10-07 11:03:51", "2015-10-07 12:03:51", "178.222.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1849", "0", "magma", "2015-10-07 12:01:33", "2015-10-07 13:01:33", "178.223.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1850", "0", "admin", "2015-10-07 12:07:05", "2015-10-07 13:07:05", "96.47.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1851", "0", "admin", "2015-10-07 12:35:06", "2015-10-07 13:35:06", "212.21.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1852", "0", "admin", "2015-10-07 12:35:29", "2015-10-07 13:35:29", "77.244.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1853", "0", "magma", "2015-10-07 16:39:12", "2015-10-07 17:39:12", "106.51.47.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1854", "0", "magma", "2015-10-07 17:18:03", "2015-10-07 18:18:03", "31.215.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1855", "0", "magma", "2015-10-07 17:29:12", "2015-10-07 18:29:12", "79.116.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1856", "0", "admin", "2015-10-07 17:36:14", "2015-10-07 18:36:14", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1857", "0", "magma", "2015-10-07 18:06:20", "2015-10-07 19:06:20", "112.207.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1858", "0", "magma", "2015-10-07 18:18:26", "2015-10-07 19:18:26", "93.87.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1859", "0", "magma", "2015-10-07 18:44:22", "2015-10-07 19:44:22", "41.133.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1860", "0", "magma", "2015-10-07 21:50:16", "2015-10-07 22:50:16", "24.132.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1861", "0", "admin", "2015-10-07 22:05:19", "2015-10-07 23:05:19", "195.154.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1862", "0", "admin", "2015-10-07 22:32:02", "2015-10-07 23:32:02", "37.157.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1863", "0", "admin", "2015-10-07 22:32:10", "2015-10-07 23:32:10", "92.222.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1864", "0", "magma", "2015-10-07 22:33:40", "2015-10-07 23:33:40", "134.176.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1865", "0", "magma", "2015-10-08 01:02:09", "2015-10-08 02:02:09", "89.205.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1866", "0", "magma", "2015-10-08 01:09:22", "2015-10-08 02:09:22", "95.92.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1867", "0", "magma", "2015-10-08 01:40:04", "2015-10-08 02:40:04", "41.196.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1868", "0", "magma", "2015-10-08 01:45:28", "2015-10-08 02:45:28", "177.80.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1869", "0", "magma", "2015-10-08 02:01:18", "2015-10-08 03:01:18", "5.83.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1870", "0", "magma", "2015-10-08 02:57:30", "2015-10-08 03:57:30", "112.201.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1871", "0", "magma", "2015-10-08 03:25:31", "2015-10-08 04:25:31", "185.36.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1872", "0", "admin", "2015-10-08 03:41:36", "2015-10-08 04:41:36", "31.172.30.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1873", "0", "magma", "2015-10-08 05:17:03", "2015-10-08 06:17:03", "106.51.26.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1874", "0", "magma", "2015-10-08 05:22:55", "2015-10-08 06:22:55", "88.161.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1875", "0", "magma", "2015-10-08 05:52:09", "2015-10-08 06:52:09", "186.30.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1876", "0", "admin", "2015-10-08 06:47:48", "2015-10-08 07:47:48", "158.69.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1877", "0", "magma", "2015-10-08 07:08:55", "2015-10-08 08:08:55", "79.169.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1878", "0", "admin", "2015-10-08 07:36:45", "2015-10-08 08:36:45", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1879", "0", "magma", "2015-10-08 08:00:24", "2015-10-08 09:00:24", "5.107.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1880", "0", "magma", "2015-10-08 09:58:26", "2015-10-08 10:58:26", "149.3.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1881", "0", "magma", "2015-10-08 12:22:27", "2015-10-08 13:22:27", "176.32.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1882", "0", "admin", "2015-10-08 12:58:01", "2015-10-08 13:58:01", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1883", "0", "magma", "2015-10-08 13:16:41", "2015-10-08 14:16:41", "200.90.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1884", "0", "magma", "2015-10-08 13:48:05", "2015-10-08 14:48:05", "79.115.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1885", "0", "magma", "2015-10-08 13:57:17", "2015-10-08 14:57:17", "197.27.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1886", "0", "magma", "2015-10-08 14:04:00", "2015-10-08 15:04:00", "80.227.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1887", "0", "admin", "2015-10-08 15:29:47", "2015-10-08 16:29:47", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1888", "0", "magma", "2015-10-08 15:35:53", "2015-10-08 16:35:53", "89.121.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1889", "0", "magma", "2015-10-08 15:46:05", "2015-10-08 16:46:05", "178.220.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1890", "0", "admin", "2015-10-08 16:01:42", "2015-10-08 17:01:42", "87.118.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1891", "0", "magma", "2015-10-08 16:44:02", "2015-10-08 17:44:02", "121.54.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1892", "0", "admin", "2015-10-08 16:45:23", "2015-10-08 17:45:23", "185.11.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1893", "0", "magma", "2015-10-08 18:51:49", "2015-10-08 19:51:49", "112.203.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1894", "0", "magma", "2015-10-08 19:32:04", "2015-10-08 20:32:04", "89.35.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1895", "0", "magma", "2015-10-08 20:48:36", "2015-10-08 21:48:36", "86.100.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1896", "0", "magma", "2015-10-08 21:18:54", "2015-10-08 22:18:54", "27.109.83.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1897", "0", "admin", "2015-10-08 22:38:47", "2015-10-08 23:38:47", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1898", "0", "magma", "2015-10-09 00:33:31", "2015-10-09 01:33:31", "81.244.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1899", "0", "admin", "2015-10-09 00:38:22", "2015-10-09 01:38:22", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1900", "0", "admin", "2015-10-09 01:08:51", "2015-10-09 02:08:51", "185.11.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1901", "0", "magma", "2015-10-09 01:21:49", "2015-10-09 02:21:49", "84.2.156.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1902", "0", "admin", "2015-10-09 02:09:51", "2015-10-09 03:09:51", "195.154.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1903", "0", "magma", "2015-10-09 07:20:21", "2015-10-09 08:20:21", "171.6.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1904", "0", "admin", "2015-10-09 07:57:56", "2015-10-09 08:57:56", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1905", "0", "admin", "2015-10-09 08:51:54", "2015-10-09 09:51:54", "5.9.21.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1906", "0", "admin", "2015-10-09 09:31:08", "2015-10-09 10:31:08", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1907", "0", "magma", "2015-10-09 09:37:01", "2015-10-09 10:37:01", "210.186.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1908", "0", "magma", "2015-10-09 10:56:06", "2015-10-09 11:56:06", "151.228.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1909", "0", "admin", "2015-10-09 11:03:54", "2015-10-09 12:03:54", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1910", "0", "magma", "2015-10-09 11:04:33", "2015-10-09 12:04:33", "37.211.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1911", "0", "magma", "2015-10-09 11:35:07", "2015-10-09 12:35:07", "174.97.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1912", "0", "magma", "2015-10-09 11:53:51", "2015-10-09 12:53:51", "92.99.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1913", "0", "magma", "2015-10-09 12:37:03", "2015-10-09 13:37:03", "174.113.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1914", "0", "magma", "2015-10-09 12:54:10", "2015-10-09 13:54:10", "175.143.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1915", "0", "magma", "2015-10-09 13:12:00", "2015-10-09 14:12:00", "89.134.242.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1916", "0", "magma", "2015-10-09 13:20:50", "2015-10-09 14:20:50", "176.43.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1917", "0", "magma", "2015-10-09 13:30:47", "2015-10-09 14:30:47", "81.246.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1918", "0", "magma", "2015-10-09 13:32:54", "2015-10-09 14:32:54", "62.28.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1919", "0", "magma", "2015-10-09 13:39:00", "2015-10-09 14:39:00", "85.186.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1920", "0", "magma", "2015-10-09 13:49:15", "2015-10-09 14:49:15", "197.160.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1921", "0", "magma", "2015-10-09 13:49:43", "2015-10-09 14:49:43", "81.108.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1922", "0", "magma", "2015-10-09 13:54:43", "2015-10-09 14:54:43", "92.87.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1923", "0", "magma", "2015-10-09 13:56:33", "2015-10-09 14:56:33", "187.183.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1924", "0", "magma", "2015-10-09 14:03:06", "2015-10-09 15:03:06", "130.204.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1925", "0", "magma", "2015-10-09 14:11:05", "2015-10-09 15:11:05", "46.217.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1926", "0", "magma", "2015-10-09 14:15:47", "2015-10-09 15:15:47", "193.191.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1927", "0", "magma", "2015-10-09 14:26:14", "2015-10-09 15:26:14", "138.118.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1928", "0", "magma", "2015-10-09 14:42:42", "2015-10-09 15:42:42", "190.46.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1929", "0", "magma", "2015-10-09 14:43:55", "2015-10-09 15:43:55", "14.141.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1930", "0", "magma", "2015-10-09 14:46:07", "2015-10-09 15:46:07", "94.67.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1931", "0", "magma", "2015-10-09 14:47:21", "2015-10-09 15:47:21", "95.146.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1932", "0", "magma", "2015-10-09 14:58:00", "2015-10-09 15:58:00", "90.221.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1933", "0", "magma", "2015-10-09 15:05:42", "2015-10-09 16:05:42", "98.228.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1934", "0", "magma", "2015-10-09 15:07:53", "2015-10-09 16:07:53", "24.63.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1935", "0", "magma", "2015-10-09 15:09:05", "2015-10-09 16:09:05", "46.109.66.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1936", "0", "magma", "2015-10-09 15:23:39", "2015-10-09 16:23:39", "201.252.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1937", "0", "magma", "2015-10-09 15:29:39", "2015-10-09 16:29:39", "178.149.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1938", "0", "magma", "2015-10-09 15:32:17", "2015-10-09 16:32:17", "58.97.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1939", "0", "magma", "2015-10-09 15:33:31", "2015-10-09 16:33:31", "100.8.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1940", "0", "magma", "2015-10-09 15:36:32", "2015-10-09 16:36:32", "79.113.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1941", "0", "magma", "2015-10-09 16:09:51", "2015-10-09 17:09:51", "110.164.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1942", "0", "magma", "2015-10-09 16:12:49", "2015-10-09 17:12:49", "94.203.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1943", "0", "magma", "2015-10-09 16:34:12", "2015-10-09 17:34:12", "94.225.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1944", "0", "magma", "2015-10-09 16:51:31", "2015-10-09 17:51:31", "79.173.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1945", "0", "magma", "2015-10-09 17:02:11", "2015-10-09 18:02:11", "87.17.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1946", "0", "magma", "2015-10-09 17:06:50", "2015-10-09 18:06:50", "89.65.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1947", "0", "magma", "2015-10-09 17:07:46", "2015-10-09 18:07:46", "178.143.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1948", "0", "magma", "2015-10-09 17:16:22", "2015-10-09 18:16:22", "181.64.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1949", "0", "magma", "2015-10-09 17:20:19", "2015-10-09 18:20:19", "93.34.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1950", "0", "magma", "2015-10-09 17:23:58", "2015-10-09 18:23:58", "103.57.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1951", "0", "admin", "2015-10-09 17:25:14", "2015-10-09 18:25:14", "193.34.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1952", "0", "magma", "2015-10-09 17:27:33", "2015-10-09 18:27:33", "97.118.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1953", "0", "magma", "2015-10-09 17:34:27", "2015-10-09 18:34:27", "59.95.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1954", "0", "magma", "2015-10-09 17:40:31", "2015-10-09 18:40:31", "181.160.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1955", "0", "admin", "2015-10-09 17:41:06", "2015-10-09 18:41:06", "109.163.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1956", "0", "magma", "2015-10-09 17:42:50", "2015-10-09 18:42:50", "5.13.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1957", "0", "magma", "2015-10-09 17:44:46", "2015-10-09 18:44:46", "187.67.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1958", "0", "magma", "2015-10-09 17:55:05", "2015-10-09 18:55:05", "154.126.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1959", "0", "magma", "2015-10-09 17:58:03", "2015-10-09 18:58:03", "67.170.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1960", "0", "magma", "2015-10-09 17:59:49", "2015-10-09 18:59:49", "106.168.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1961", "0", "magma", "2015-10-09 18:01:55", "2015-10-09 19:01:55", "105.226.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1962", "0", "magma", "2015-10-09 18:01:55", "2015-10-09 19:01:55", "79.117.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1963", "0", "magma", "2015-10-09 18:08:44", "2015-10-09 19:08:44", "85.96.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1964", "0", "magma", "2015-10-09 18:18:10", "2015-10-09 19:18:10", "178.152.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1965", "0", "magma", "2015-10-09 18:40:11", "2015-10-09 19:40:11", "94.61.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1966", "0", "magma", "2015-10-09 18:43:45", "2015-10-09 19:43:45", "86.124.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1967", "0", "magma", "2015-10-09 18:45:11", "2015-10-09 19:45:11", "43.231.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1968", "0", "magma", "2015-10-09 18:47:57", "2015-10-09 19:47:57", "79.183.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1969", "0", "magma", "2015-10-09 19:34:34", "2015-10-09 20:34:34", "41.236.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1970", "0", "magma", "2015-10-09 19:42:07", "2015-10-09 20:42:07", "213.67.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1971", "0", "magma", "2015-10-09 19:47:11", "2015-10-09 20:47:11", "37.11.53.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1972", "0", "magma", "2015-10-09 19:52:28", "2015-10-09 20:52:28", "141.8.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1973", "0", "magma", "2015-10-09 19:56:10", "2015-10-09 20:56:10", "151.72.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1974", "0", "magma", "2015-10-09 20:04:21", "2015-10-09 21:04:21", "105.224.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1975", "0", "magma", "2015-10-09 20:11:19", "2015-10-09 21:11:19", "86.124.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1976", "0", "magma", "2015-10-09 20:21:53", "2015-10-09 21:21:53", "182.57.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1977", "0", "admin", "2015-10-09 20:22:27", "2015-10-09 21:22:27", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1978", "0", "magma", "2015-10-09 20:32:19", "2015-10-09 21:32:19", "201.149.97.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1979", "0", "magma", "2015-10-09 20:49:36", "2015-10-09 21:49:36", "107.179.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1980", "0", "magma", "2015-10-09 20:54:16", "2015-10-09 21:54:16", "41.101.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1981", "0", "magma", "2015-10-09 21:04:58", "2015-10-09 22:04:58", "203.111.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1982", "0", "magma", "2015-10-09 21:09:13", "2015-10-09 22:09:13", "46.99.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1983", "0", "magma", "2015-10-09 21:09:14", "2015-10-09 22:09:14", "110.5.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1984", "0", "magma", "2015-10-09 21:10:22", "2015-10-09 22:10:22", "89.164.156.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1985", "0", "magma", "2015-10-09 21:18:25", "2015-10-09 22:18:25", "219.240.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1986", "0", "magma", "2015-10-09 21:23:43", "2015-10-09 22:23:43", "202.171.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1987", "0", "magma", "2015-10-09 21:24:03", "2015-10-09 22:24:03", "84.77.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1988", "0", "magma", "2015-10-09 21:28:47", "2015-10-09 22:28:47", "89.142.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1989", "0", "magma", "2015-10-09 21:32:39", "2015-10-09 22:32:39", "89.153.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1990", "0", "magma", "2015-10-09 21:43:33", "2015-10-09 22:43:33", "181.168.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1991", "0", "magma", "2015-10-09 21:44:35", "2015-10-09 22:44:35", "154.68.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1992", "0", "magma", "2015-10-09 21:51:25", "2015-10-09 22:51:25", "217.46.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1993", "0", "magma", "2015-10-09 21:55:17", "2015-10-09 22:55:17", "83.110.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1994", "0", "magma", "2015-10-09 22:08:16", "2015-10-09 23:08:16", "178.223.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1995", "0", "magma", "2015-10-09 22:15:07", "2015-10-09 23:15:07", "46.152.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1996", "0", "magma", "2015-10-09 22:20:40", "2015-10-09 23:20:40", "95.156.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1997", "0", "magma", "2015-10-09 22:30:08", "2015-10-09 23:30:08", "31.215.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1998", "0", "magma", "2015-10-09 22:40:45", "2015-10-09 23:40:45", "185.33.33.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("1999", "0", "magma", "2015-10-09 22:43:05", "2015-10-09 23:43:05", "87.241.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2000", "0", "magma", "2015-10-09 22:55:12", "2015-10-09 23:55:12", "90.192.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2001", "0", "magma", "2015-10-09 22:57:17", "2015-10-09 23:57:17", "212.93.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2002", "0", "magma", "2015-10-09 23:28:15", "2015-10-10 00:28:15", "89.36.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2003", "0", "magma", "2015-10-09 23:28:16", "2015-10-10 00:28:16", "37.190.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2004", "0", "magma", "2015-10-09 23:28:39", "2015-10-10 00:28:39", "213.67.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2005", "0", "magma", "2015-10-10 00:57:21", "2015-10-10 01:57:21", "109.201.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2006", "0", "admin", "2015-10-10 02:40:42", "2015-10-10 03:40:42", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2007", "0", "admin", "2015-10-10 02:57:00", "2015-10-10 03:57:00", "96.44.189.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2008", "0", "magma", "2015-10-10 10:50:32", "2015-10-10 11:50:32", "213.185.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2009", "0", "admin", "2015-10-10 10:57:25", "2015-10-10 11:57:25", "95.130.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2010", "0", "admin", "2015-10-10 12:16:27", "2015-10-10 13:16:27", "46.28.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2011", "0", "magma", "2015-10-10 13:18:34", "2015-10-10 14:18:34", "94.176.40.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2012", "0", "admin", "2015-10-10 14:32:39", "2015-10-10 15:32:39", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2013", "0", "admin", "2015-10-10 19:44:42", "2015-10-10 20:44:42", "85.10.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2014", "0", "admin", "2015-10-10 20:56:28", "2015-10-10 21:56:28", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2015", "0", "admin", "2015-10-10 23:54:05", "2015-10-11 00:54:05", "185.65.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2016", "0", "admin", "2015-10-11 05:47:58", "2015-10-11 06:47:58", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2017", "0", "admin", "2015-10-11 14:22:55", "2015-10-11 15:22:55", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2018", "0", "admin", "2015-10-11 17:28:44", "2015-10-11 18:28:44", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2019", "0", "admin", "2015-10-11 22:11:33", "2015-10-11 23:11:33", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2020", "0", "admin", "2015-10-11 23:31:29", "2015-10-12 00:31:29", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2021", "0", "admin", "2015-10-12 00:52:05", "2015-10-12 01:52:05", "77.109.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2022", "0", "admin", "2015-10-12 02:36:09", "2015-10-12 03:36:09", "185.36.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2023", "0", "admin", "2015-10-12 06:45:54", "2015-10-12 07:45:54", "91.219.236.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2024", "0", "admin", "2015-10-12 08:04:27", "2015-10-12 09:04:27", "158.130.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2025", "0", "admin", "2015-10-12 09:36:44", "2015-10-12 10:36:44", "195.154.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2026", "0", "admin", "2015-10-12 11:16:44", "2015-10-12 12:16:44", "204.85.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2027", "0", "admin", "2015-10-12 15:44:58", "2015-10-12 16:44:58", "94.23.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2028", "0", "admin", "2015-10-12 17:24:22", "2015-10-12 18:24:22", "93.174.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2029", "0", "admin", "2015-10-12 19:21:30", "2015-10-12 20:21:30", "188.165.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2030", "0", "admin", "2015-10-12 21:19:03", "2015-10-12 22:19:03", "85.10.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2031", "0", "admin", "2015-10-13 01:56:35", "2015-10-13 02:56:35", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2032", "0", "admin", "2015-10-13 05:17:12", "2015-10-13 06:17:12", "185.101.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2033", "0", "admin", "2015-10-13 06:49:09", "2015-10-13 07:49:09", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2034", "0", "admin", "2015-10-13 10:50:36", "2015-10-13 11:50:36", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2035", "0", "admin", "2015-10-13 12:35:16", "2015-10-13 13:35:16", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2036", "0", "admin", "2015-10-13 14:41:06", "2015-10-13 15:41:06", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2037", "0", "admin", "2015-10-13 22:17:53", "2015-10-13 23:17:53", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2038", "0", "admin", "2015-10-14 00:41:51", "2015-10-14 01:41:51", "212.47.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2039", "0", "admin", "2015-10-14 02:03:34", "2015-10-14 03:03:34", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2040", "0", "admin", "2015-10-14 05:37:47", "2015-10-14 06:37:47", "194.150.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2041", "0", "admin", "2015-10-14 07:25:22", "2015-10-14 08:25:22", "94.26.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2042", "0", "admin", "2015-10-14 10:12:22", "2015-10-14 11:12:22", "5.9.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2043", "0", "admin", "2015-10-14 11:32:29", "2015-10-14 12:32:29", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2044", "0", "admin", "2015-10-14 15:35:52", "2015-10-14 16:35:52", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2045", "0", "admin", "2015-10-14 17:19:18", "2015-10-14 18:19:18", "69.162.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2046", "0", "admin", "2015-10-14 21:23:23", "2015-10-14 22:23:23", "85.25.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2047", "0", "admin", "2015-10-15 01:04:39", "2015-10-15 02:04:39", "194.150.168.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2048", "0", "admin", "2015-10-15 02:46:19", "2015-10-15 03:46:19", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2049", "0", "admin", "2015-10-15 06:35:22", "2015-10-15 07:35:22", "62.210.105.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2050", "0", "admin", "2015-10-15 09:40:45", "2015-10-15 10:40:45", "62.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2051", "0", "admin", "2015-10-15 11:29:43", "2015-10-15 12:29:43", "80.82.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2052", "0", "admin", "2015-10-15 14:45:33", "2015-10-15 15:45:33", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2053", "0", "admin", "2015-10-15 15:38:07", "2015-10-15 16:38:07", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2054", "0", "admin", "2015-10-15 18:40:47", "2015-10-15 19:40:47", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2055", "0", "admin", "2015-10-15 20:45:31", "2015-10-15 21:45:31", "85.10.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2056", "0", "admin", "2015-10-16 00:26:48", "2015-10-16 01:26:48", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2057", "0", "admin", "2015-10-16 01:15:07", "2015-10-16 02:15:07", "162.221.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2058", "0", "admin", "2015-10-16 04:03:47", "2015-10-16 05:03:47", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2059", "0", "admin", "2015-10-16 09:43:59", "2015-10-16 10:43:59", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2060", "0", "admin", "2015-10-16 14:47:54", "2015-10-16 15:47:54", "95.130.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2061", "0", "admin", "2015-10-16 19:00:17", "2015-10-16 20:00:17", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2062", "0", "admin", "2015-10-16 19:24:24", "2015-10-16 20:24:24", "62.102.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2063", "0", "admin", "2015-10-16 22:02:50", "2015-10-16 23:02:50", "192.151.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2064", "0", "admin", "2015-10-17 00:09:28", "2015-10-17 01:09:28", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2065", "0", "admin", "2015-10-17 04:39:51", "2015-10-17 05:39:51", "176.126.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2066", "0", "admin", "2015-10-17 09:02:30", "2015-10-17 10:02:30", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2067", "0", "admin", "2015-10-17 13:40:29", "2015-10-17 14:40:29", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2068", "0", "admin", "2015-10-17 13:40:43", "2015-10-17 14:40:43", "176.10.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2069", "0", "magma", "2015-10-17 15:44:17", "2015-10-17 16:44:17", "182.231.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2070", "0", "magma", "2015-10-17 15:47:42", "2015-10-17 16:47:42", "31.11.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2071", "0", "magma", "2015-10-17 16:06:34", "2015-10-17 17:06:34", "86.87.11.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2072", "0", "magma", "2015-10-17 16:08:40", "2015-10-17 17:08:40", "101.186.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2073", "0", "magma", "2015-10-17 16:10:17", "2015-10-17 17:10:17", "112.210.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2074", "0", "magma", "2015-10-17 16:11:19", "2015-10-17 17:11:19", "91.240.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2075", "0", "magma", "2015-10-17 16:13:00", "2015-10-17 17:13:00", "89.46.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2076", "0", "magma", "2015-10-17 16:20:46", "2015-10-17 17:20:46", "81.230.177.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2077", "0", "magma", "2015-10-17 16:21:52", "2015-10-17 17:21:52", "177.177.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2078", "0", "magma", "2015-10-17 16:35:09", "2015-10-17 17:35:09", "62.234.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2079", "0", "magma", "2015-10-17 16:47:20", "2015-10-17 17:47:20", "176.40.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2080", "0", "magma", "2015-10-17 16:52:04", "2015-10-17 17:52:04", "105.237.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2081", "0", "magma", "2015-10-17 17:05:42", "2015-10-17 18:05:42", "100.4.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2082", "0", "magma", "2015-10-17 17:06:41", "2015-10-17 18:06:41", "197.36.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2083", "0", "magma", "2015-10-17 17:23:17", "2015-10-17 18:23:17", "105.226.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2084", "0", "magma", "2015-10-17 17:28:27", "2015-10-17 18:28:27", "105.226.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2085", "0", "magma", "2015-10-17 17:37:23", "2015-10-17 18:37:23", "92.80.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2086", "0", "magma", "2015-10-17 17:38:09", "2015-10-17 18:38:09", "109.96.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2087", "0", "magma", "2015-10-17 17:39:03", "2015-10-17 18:39:03", "93.180.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2088", "0", "magma", "2015-10-17 17:39:12", "2015-10-17 18:39:12", "95.186.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2089", "0", "magma", "2015-10-17 17:52:18", "2015-10-17 18:52:18", "79.176.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2090", "0", "magma", "2015-10-17 17:53:41", "2015-10-17 18:53:41", "178.222.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2091", "0", "magma", "2015-10-17 17:59:04", "2015-10-17 18:59:04", "93.86.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2092", "0", "magma", "2015-10-17 18:00:11", "2015-10-17 19:00:11", "79.108.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2093", "0", "magma", "2015-10-17 18:01:29", "2015-10-17 19:01:29", "81.235.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2094", "0", "admin", "2015-10-17 18:04:33", "2015-10-17 19:04:33", "149.202.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2095", "0", "magma", "2015-10-17 18:08:56", "2015-10-17 19:08:56", "203.218.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2096", "0", "magma", "2015-10-17 18:11:13", "2015-10-17 19:11:13", "82.51.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2097", "0", "magma", "2015-10-17 18:14:43", "2015-10-17 19:14:43", "46.211.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2098", "0", "magma", "2015-10-17 18:16:54", "2015-10-17 19:16:54", "83.53.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2099", "0", "magma", "2015-10-17 18:20:05", "2015-10-17 19:20:05", "88.8.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2100", "0", "magma", "2015-10-17 18:23:23", "2015-10-17 19:23:23", "92.80.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2101", "0", "magma", "2015-10-17 18:37:26", "2015-10-17 19:37:26", "83.59.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2102", "0", "magma", "2015-10-17 18:55:12", "2015-10-17 19:55:12", "78.60.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2103", "0", "magma", "2015-10-17 18:55:16", "2015-10-17 19:55:16", "24.51.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2104", "0", "magma", "2015-10-17 19:05:07", "2015-10-17 20:05:07", "182.178.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2105", "0", "magma", "2015-10-17 19:13:45", "2015-10-17 20:13:45", "109.194.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2106", "0", "magma", "2015-10-17 19:14:12", "2015-10-17 20:14:12", "213.22.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2107", "0", "magma", "2015-10-17 19:17:50", "2015-10-17 20:17:50", "82.10.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2108", "0", "magma", "2015-10-17 19:21:18", "2015-10-17 20:21:18", "188.221.8.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2109", "0", "magma", "2015-10-17 19:26:34", "2015-10-17 20:26:34", "2.49.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2110", "0", "magma", "2015-10-17 19:26:54", "2015-10-17 20:26:54", "46.19.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2111", "0", "magma", "2015-10-17 19:27:10", "2015-10-17 20:27:10", "123.201.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2112", "0", "magma", "2015-10-17 19:28:09", "2015-10-17 20:28:09", "188.127.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2113", "0", "magma", "2015-10-17 19:29:02", "2015-10-17 20:29:02", "91.178.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2114", "0", "magma", "2015-10-17 19:38:37", "2015-10-17 20:38:37", "46.189.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2115", "0", "magma", "2015-10-17 19:42:57", "2015-10-17 20:42:57", "82.67.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2116", "0", "magma", "2015-10-17 19:49:17", "2015-10-17 20:49:17", "91.185.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2117", "0", "magma", "2015-10-17 19:52:02", "2015-10-17 20:52:02", "24.157.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2118", "0", "magma", "2015-10-17 19:56:27", "2015-10-17 20:56:27", "190.152.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2119", "0", "magma", "2015-10-17 19:59:28", "2015-10-17 20:59:28", "116.87.123.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2120", "0", "magma", "2015-10-17 20:15:02", "2015-10-17 21:15:02", "78.21.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2121", "0", "magma", "2015-10-17 20:30:38", "2015-10-17 21:30:38", "5.15.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2122", "0", "magma", "2015-10-17 20:31:04", "2015-10-17 21:31:04", "31.2.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2123", "0", "magma", "2015-10-17 20:37:11", "2015-10-17 21:37:11", "213.156.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2124", "0", "magma", "2015-10-17 20:37:23", "2015-10-17 21:37:23", "39.57.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2125", "0", "magma", "2015-10-17 20:39:08", "2015-10-17 21:39:08", "78.13.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2126", "0", "magma", "2015-10-17 20:39:42", "2015-10-17 21:39:42", "2.225.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2127", "0", "magma", "2015-10-17 20:49:32", "2015-10-17 21:49:32", "111.88.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2128", "0", "magma", "2015-10-17 20:51:06", "2015-10-17 21:51:06", "37.157.215.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2129", "0", "magma", "2015-10-17 20:51:31", "2015-10-17 21:51:31", "37.211.29.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2130", "0", "magma", "2015-10-17 20:57:19", "2015-10-17 21:57:19", "82.30.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2131", "0", "magma", "2015-10-17 21:00:31", "2015-10-17 22:00:31", "46.117.152.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2132", "0", "magma", "2015-10-17 21:01:18", "2015-10-17 22:01:18", "81.165.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2133", "0", "magma", "2015-10-17 21:13:32", "2015-10-17 22:13:32", "41.136.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2134", "0", "magma", "2015-10-17 21:14:36", "2015-10-17 22:14:36", "121.87.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2135", "0", "magma", "2015-10-17 21:22:51", "2015-10-17 22:22:51", "118.96.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2136", "0", "magma", "2015-10-17 21:33:06", "2015-10-17 22:33:06", "70.171.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2137", "0", "magma", "2015-10-17 21:38:00", "2015-10-17 22:38:00", "68.195.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2138", "0", "magma", "2015-10-17 21:39:11", "2015-10-17 22:39:11", "80.174.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2139", "0", "magma", "2015-10-17 21:43:10", "2015-10-17 22:43:10", "186.45.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2140", "0", "magma", "2015-10-17 21:47:37", "2015-10-17 22:47:37", "122.175.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2141", "0", "magma", "2015-10-17 21:47:56", "2015-10-17 22:47:56", "148.101.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2142", "0", "magma", "2015-10-17 21:52:59", "2015-10-17 22:52:59", "31.134.102.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2143", "0", "magma", "2015-10-17 22:03:00", "2015-10-17 23:03:00", "174.21.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2144", "0", "magma", "2015-10-17 22:10:30", "2015-10-17 23:10:30", "178.220.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2145", "0", "magma", "2015-10-17 22:12:45", "2015-10-17 23:12:45", "88.231.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2146", "0", "magma", "2015-10-17 22:13:38", "2015-10-17 23:13:38", "129.7.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2147", "0", "magma", "2015-10-17 22:21:46", "2015-10-17 23:21:46", "78.58.199.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2148", "0", "admin", "2015-10-17 22:48:08", "2015-10-17 23:48:08", "62.212.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2149", "0", "admin", "2015-10-17 22:49:16", "2015-10-17 23:49:16", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2150", "0", "magma", "2015-10-17 23:08:07", "2015-10-18 00:08:07", "210.195.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2151", "0", "magma", "2015-10-17 23:10:50", "2015-10-18 00:10:50", "86.98.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2152", "0", "magma", "2015-10-17 23:13:56", "2015-10-18 00:13:56", "137.207.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2153", "0", "magma", "2015-10-17 23:14:57", "2015-10-18 00:14:57", "82.27.218.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2154", "0", "magma", "2015-10-17 23:16:15", "2015-10-18 00:16:15", "79.118.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2155", "0", "magma", "2015-10-17 23:17:03", "2015-10-18 00:17:03", "1.243.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2156", "0", "magma", "2015-10-17 23:21:30", "2015-10-18 00:21:30", "202.142.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2157", "0", "magma", "2015-10-17 23:34:32", "2015-10-18 00:34:32", "78.98.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2158", "0", "magma", "2015-10-17 23:48:51", "2015-10-18 00:48:51", "2.30.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2159", "0", "magma", "2015-10-18 00:02:37", "2015-10-18 01:02:37", "178.213.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2160", "0", "magma", "2015-10-18 00:13:22", "2015-10-18 01:13:22", "111.237.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2161", "0", "magma", "2015-10-18 00:13:50", "2015-10-18 01:13:50", "67.189.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2162", "0", "magma", "2015-10-18 00:15:41", "2015-10-18 01:15:41", "39.55.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2163", "0", "magma", "2015-10-18 00:17:40", "2015-10-18 01:17:40", "197.86.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2164", "0", "magma", "2015-10-18 00:17:55", "2015-10-18 01:17:55", "213.238.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2165", "0", "magma", "2015-10-18 00:20:55", "2015-10-18 01:20:55", "87.69.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2166", "0", "magma", "2015-10-18 00:24:27", "2015-10-18 01:24:27", "109.67.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2167", "0", "magma", "2015-10-18 00:25:20", "2015-10-18 01:25:20", "188.141.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2168", "0", "magma", "2015-10-18 00:27:22", "2015-10-18 01:27:22", "47.18.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2169", "0", "magma", "2015-10-18 00:36:06", "2015-10-18 01:36:06", "77.222.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2170", "0", "admin", "2015-10-18 00:37:38", "2015-10-18 01:37:38", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2171", "0", "magma", "2015-10-18 00:43:13", "2015-10-18 01:43:13", "151.0.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2172", "0", "magma", "2015-10-18 00:46:20", "2015-10-18 01:46:20", "177.10.109.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2173", "0", "magma", "2015-10-18 01:12:20", "2015-10-18 02:12:20", "181.73.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2174", "0", "magma", "2015-10-18 01:28:43", "2015-10-18 02:28:43", "178.153.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2175", "0", "magma", "2015-10-18 01:35:10", "2015-10-18 02:35:10", "41.207.252.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2176", "0", "magma", "2015-10-18 01:37:38", "2015-10-18 02:37:38", "82.19.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2177", "0", "magma", "2015-10-18 01:39:43", "2015-10-18 02:39:43", "197.86.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2178", "0", "magma", "2015-10-18 01:40:52", "2015-10-18 02:40:52", "95.95.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2179", "0", "magma", "2015-10-18 01:41:57", "2015-10-18 02:41:57", "104.235.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2180", "0", "magma", "2015-10-18 01:46:20", "2015-10-18 02:46:20", "75.40.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2181", "0", "magma", "2015-10-18 01:50:57", "2015-10-18 02:50:57", "96.55.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2182", "0", "magma", "2015-10-18 02:02:44", "2015-10-18 03:02:44", "77.97.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2183", "0", "magma", "2015-10-18 02:05:20", "2015-10-18 03:05:20", "95.185.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2184", "0", "magma", "2015-10-18 02:38:23", "2015-10-18 03:38:23", "31.11.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2185", "0", "magma", "2015-10-18 02:45:21", "2015-10-18 03:45:21", "221.202.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2186", "0", "admin", "2015-10-18 02:52:43", "2015-10-18 03:52:43", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2187", "0", "magma", "2015-10-18 02:59:14", "2015-10-18 03:59:14", "147.194.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2188", "0", "magma", "2015-10-18 03:00:39", "2015-10-18 04:00:39", "200.192.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2189", "0", "magma", "2015-10-18 03:10:56", "2015-10-18 04:10:56", "46.116.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2190", "0", "magma", "2015-10-18 03:14:20", "2015-10-18 04:14:20", "35.32.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2191", "0", "magma", "2015-10-18 03:52:04", "2015-10-18 04:52:04", "182.178.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2192", "0", "magma", "2015-10-18 03:58:19", "2015-10-18 04:58:19", "89.205.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2193", "0", "magma", "2015-10-18 04:20:05", "2015-10-18 05:20:05", "92.149.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2194", "0", "magma", "2015-10-18 04:24:41", "2015-10-18 05:24:41", "191.177.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2195", "0", "magma", "2015-10-18 04:25:56", "2015-10-18 05:25:56", "79.117.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2196", "0", "magma", "2015-10-18 04:27:08", "2015-10-18 05:27:08", "92.53.59.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2197", "0", "magma", "2015-10-18 04:38:30", "2015-10-18 05:38:30", "113.210.7.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2198", "0", "magma", "2015-10-18 04:49:03", "2015-10-18 05:49:03", "112.198.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2199", "0", "magma", "2015-10-18 05:00:08", "2015-10-18 06:00:08", "104.162.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2200", "0", "magma", "2015-10-18 05:06:24", "2015-10-18 06:06:24", "58.104.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2201", "0", "magma", "2015-10-18 05:11:18", "2015-10-18 06:11:18", "173.172.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2202", "0", "magma", "2015-10-18 05:15:01", "2015-10-18 06:15:01", "181.55.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2203", "0", "magma", "2015-10-18 05:26:57", "2015-10-18 06:26:57", "46.116.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2204", "0", "magma", "2015-10-18 05:39:27", "2015-10-18 06:39:27", "135.23.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2205", "0", "magma", "2015-10-18 05:42:28", "2015-10-18 06:42:28", "68.81.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2206", "0", "magma", "2015-10-18 06:00:40", "2015-10-18 07:00:40", "70.49.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2207", "0", "magma", "2015-10-18 06:16:32", "2015-10-18 07:16:32", "220.124.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2208", "0", "magma", "2015-10-18 06:23:05", "2015-10-18 07:23:05", "109.65.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2209", "0", "magma", "2015-10-18 06:26:29", "2015-10-18 07:26:29", "118.101.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2210", "0", "magma", "2015-10-18 06:53:27", "2015-10-18 07:53:27", "105.226.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2211", "0", "magma", "2015-10-18 06:54:08", "2015-10-18 07:54:08", "103.231.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2212", "0", "magma", "2015-10-18 07:13:12", "2015-10-18 08:13:12", "117.204.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2213", "0", "magma", "2015-10-18 07:16:37", "2015-10-18 08:16:37", "78.95.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2214", "0", "magma", "2015-10-18 07:24:31", "2015-10-18 08:24:31", "72.241.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2215", "0", "magma", "2015-10-18 07:35:24", "2015-10-18 08:35:24", "74.57.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2216", "0", "magma", "2015-10-18 07:35:44", "2015-10-18 08:35:44", "108.180.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2217", "0", "admin", "2015-10-18 07:43:10", "2015-10-18 08:43:10", "171.25.193.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2218", "0", "admin", "2015-10-18 07:52:46", "2015-10-18 08:52:46", "94.156.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2219", "0", "magma", "2015-10-18 07:54:02", "2015-10-18 08:54:02", "49.248.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2220", "0", "magma", "2015-10-18 07:55:29", "2015-10-18 08:55:29", "73.206.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2221", "0", "magma", "2015-10-18 07:56:58", "2015-10-18 08:56:58", "82.84.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2222", "0", "magma", "2015-10-18 07:58:28", "2015-10-18 08:58:28", "119.93.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2223", "0", "magma", "2015-10-18 08:01:45", "2015-10-18 09:01:45", "210.186.116.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2224", "0", "magma", "2015-10-18 08:10:46", "2015-10-18 09:10:46", "124.104.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2225", "0", "magma", "2015-10-18 08:28:52", "2015-10-18 09:28:52", "93.130.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2226", "0", "magma", "2015-10-18 08:34:51", "2015-10-18 09:34:51", "59.95.176.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2227", "0", "magma", "2015-10-18 08:52:27", "2015-10-18 09:52:27", "126.7.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2228", "0", "magma", "2015-10-18 08:54:03", "2015-10-18 09:54:03", "118.97.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2229", "0", "magma", "2015-10-18 08:59:42", "2015-10-18 09:59:42", "39.49.84.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2230", "0", "magma", "2015-10-18 09:10:01", "2015-10-18 10:10:01", "1.52.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2231", "0", "magma", "2015-10-18 09:31:41", "2015-10-18 10:31:41", "120.56.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2232", "0", "magma", "2015-10-18 09:41:29", "2015-10-18 10:41:29", "79.193.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2233", "0", "magma", "2015-10-18 09:48:19", "2015-10-18 10:48:19", "61.255.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2234", "0", "magma", "2015-10-18 09:57:36", "2015-10-18 10:57:36", "105.184.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2235", "0", "magma", "2015-10-18 10:03:49", "2015-10-18 11:03:49", "95.165.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2236", "0", "magma", "2015-10-18 10:14:46", "2015-10-18 11:14:46", "178.221.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2237", "0", "magma", "2015-10-18 10:28:26", "2015-10-18 11:28:26", "211.212.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2238", "0", "magma", "2015-10-18 10:45:53", "2015-10-18 11:45:53", "109.96.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2239", "0", "magma", "2015-10-18 10:47:24", "2015-10-18 11:47:24", "82.124.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2240", "0", "magma", "2015-10-18 10:48:52", "2015-10-18 11:48:52", "212.107.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2241", "0", "magma", "2015-10-18 10:53:32", "2015-10-18 11:53:32", "79.108.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2242", "0", "magma", "2015-10-18 10:55:19", "2015-10-18 11:55:19", "109.57.141.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2243", "0", "magma", "2015-10-18 10:56:42", "2015-10-18 11:56:42", "82.56.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2244", "0", "magma", "2015-10-18 10:57:42", "2015-10-18 11:57:42", "101.57.162.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2245", "0", "magma", "2015-10-18 11:01:27", "2015-10-18 12:01:27", "202.21.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2246", "0", "magma", "2015-10-18 11:05:31", "2015-10-18 12:05:31", "5.13.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2247", "0", "magma", "2015-10-18 11:08:54", "2015-10-18 12:08:54", "58.160.147.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2248", "0", "magma", "2015-10-18 11:16:27", "2015-10-18 12:16:27", "83.250.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2249", "0", "magma", "2015-10-18 11:23:52", "2015-10-18 12:23:52", "83.56.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2250", "0", "admin", "2015-10-18 11:24:26", "2015-10-18 12:24:26", "46.28.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2251", "0", "magma", "2015-10-18 11:26:39", "2015-10-18 12:26:39", "202.160.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2252", "0", "magma", "2015-10-18 11:35:22", "2015-10-18 12:35:22", "213.143.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2253", "0", "magma", "2015-10-18 11:38:20", "2015-10-18 12:38:20", "203.210.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2254", "0", "magma", "2015-10-18 12:10:17", "2015-10-18 13:10:17", "139.192.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2255", "0", "magma", "2015-10-18 12:26:38", "2015-10-18 13:26:38", "86.86.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2256", "0", "magma", "2015-10-18 12:29:28", "2015-10-18 13:29:28", "2.85.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2257", "0", "magma", "2015-10-18 12:35:19", "2015-10-18 13:35:19", "109.96.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2258", "0", "magma", "2015-10-18 12:37:31", "2015-10-18 13:37:31", "84.109.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2259", "0", "magma", "2015-10-18 12:51:42", "2015-10-18 13:51:42", "95.135.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2260", "0", "magma", "2015-10-18 12:55:07", "2015-10-18 13:55:07", "117.201.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2261", "0", "magma", "2015-10-18 13:12:54", "2015-10-18 14:12:54", "80.242.44.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2262", "0", "magma", "2015-10-18 13:24:15", "2015-10-18 14:24:15", "178.221.61.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2263", "0", "magma", "2015-10-18 13:27:41", "2015-10-18 14:27:41", "84.109.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2264", "0", "magma", "2015-10-18 13:30:31", "2015-10-18 14:30:31", "151.33.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2265", "0", "magma", "2015-10-18 13:35:18", "2015-10-18 14:35:18", "105.102.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2266", "0", "magma", "2015-10-18 13:44:01", "2015-10-18 14:44:01", "182.178.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2267", "0", "magma", "2015-10-18 13:49:28", "2015-10-18 14:49:28", "197.255.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2268", "0", "magma", "2015-10-18 14:06:30", "2015-10-18 15:06:30", "197.160.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2269", "0", "magma", "2015-10-18 14:09:01", "2015-10-18 15:09:01", "112.204.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2270", "0", "magma", "2015-10-18 14:18:10", "2015-10-18 15:18:10", "179.105.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2271", "0", "magma", "2015-10-18 14:42:20", "2015-10-18 15:42:20", "109.173.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2272", "0", "magma", "2015-10-18 14:43:08", "2015-10-18 15:43:08", "43.230.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2273", "0", "magma", "2015-10-18 14:50:49", "2015-10-18 15:50:49", "104.237.155.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2274", "0", "magma", "2015-10-18 14:51:16", "2015-10-18 15:51:16", "85.254.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2275", "0", "magma", "2015-10-18 14:53:48", "2015-10-18 15:53:48", "178.220.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2276", "0", "magma", "2015-10-18 14:57:51", "2015-10-18 15:57:51", "116.48.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2277", "0", "magma", "2015-10-18 15:00:49", "2015-10-18 16:00:49", "146.199.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2278", "0", "magma", "2015-10-18 15:02:54", "2015-10-18 16:02:54", "149.3.34.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2279", "0", "magma", "2015-10-18 15:06:47", "2015-10-18 16:06:47", "31.11.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2280", "0", "magma", "2015-10-18 15:12:51", "2015-10-18 16:12:51", "39.48.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2281", "0", "magma", "2015-10-18 15:13:21", "2015-10-18 16:13:21", "105.99.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2282", "0", "magma", "2015-10-18 15:39:06", "2015-10-18 16:39:06", "176.92.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2283", "0", "magma", "2015-10-18 15:43:12", "2015-10-18 16:43:12", "89.47.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2284", "0", "magma", "2015-10-18 15:51:08", "2015-10-18 16:51:08", "178.221.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2285", "0", "magma", "2015-10-18 15:55:38", "2015-10-18 16:55:38", "78.62.110.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2286", "0", "magma", "2015-10-18 16:19:52", "2015-10-18 17:19:52", "126.64.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2287", "0", "admin", "2015-10-18 16:46:06", "2015-10-18 17:46:06", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2288", "0", "magma", "2015-10-18 16:51:14", "2015-10-18 17:51:14", "118.97.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2289", "0", "magma", "2015-10-18 17:07:24", "2015-10-18 18:07:24", "78.92.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2290", "0", "magma", "2015-10-18 17:19:15", "2015-10-18 18:19:15", "66.172.250.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2291", "0", "magma", "2015-10-18 17:34:00", "2015-10-18 18:34:00", "49.207.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2292", "0", "magma", "2015-10-18 17:54:02", "2015-10-18 18:54:02", "83.4.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2293", "0", "magma", "2015-10-18 17:55:02", "2015-10-18 18:55:02", "93.130.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2294", "0", "admin", "2015-10-18 17:58:15", "2015-10-18 18:58:15", "142.4.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2295", "0", "magma", "2015-10-18 17:59:09", "2015-10-18 18:59:09", "78.60.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2296", "0", "magma", "2015-10-18 18:13:29", "2015-10-18 19:13:29", "79.115.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2297", "0", "magma", "2015-10-18 18:14:00", "2015-10-18 19:14:00", "46.236.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2298", "0", "magma", "2015-10-18 18:14:31", "2015-10-18 19:14:31", "106.68.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2299", "0", "magma", "2015-10-18 18:15:02", "2015-10-18 19:15:02", "31.214.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2300", "0", "magma", "2015-10-18 18:18:53", "2015-10-18 19:18:53", "81.104.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2301", "0", "magma", "2015-10-18 18:33:18", "2015-10-18 19:33:18", "2.51.187.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2302", "0", "magma", "2015-10-18 18:57:33", "2015-10-18 19:57:33", "93.76.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2303", "0", "magma", "2015-10-18 19:00:58", "2015-10-18 20:00:58", "93.103.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2304", "0", "magma", "2015-10-18 19:02:40", "2015-10-18 20:02:40", "202.142.65.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2305", "0", "magma", "2015-10-18 19:02:48", "2015-10-18 20:02:48", "94.67.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2306", "0", "magma", "2015-10-18 19:07:19", "2015-10-18 20:07:19", "41.251.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2307", "0", "magma", "2015-10-18 19:09:59", "2015-10-18 20:09:59", "37.201.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2308", "0", "magma", "2015-10-18 19:13:51", "2015-10-18 20:13:51", "88.227.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2309", "0", "magma", "2015-10-18 19:18:42", "2015-10-18 20:18:42", "93.58.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2310", "0", "magma", "2015-10-18 19:23:30", "2015-10-18 20:23:30", "94.177.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2311", "0", "magma", "2015-10-18 19:28:20", "2015-10-18 20:28:20", "189.48.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2312", "0", "magma", "2015-10-18 19:32:37", "2015-10-18 20:32:37", "62.98.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2313", "0", "magma", "2015-10-18 19:36:43", "2015-10-18 20:36:43", "87.126.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2314", "0", "magma", "2015-10-18 19:37:16", "2015-10-18 20:37:16", "177.205.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2315", "0", "magma", "2015-10-18 19:46:30", "2015-10-18 20:46:30", "72.178.70.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2316", "0", "magma", "2015-10-18 19:48:04", "2015-10-18 20:48:04", "89.103.62.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2317", "0", "magma", "2015-10-18 19:54:39", "2015-10-18 20:54:39", "178.143.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2318", "0", "magma", "2015-10-18 20:09:24", "2015-10-18 21:09:24", "159.20.88.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2319", "0", "magma", "2015-10-18 20:10:23", "2015-10-18 21:10:23", "188.25.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2320", "0", "magma", "2015-10-18 20:12:35", "2015-10-18 21:12:35", "93.103.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2321", "0", "magma", "2015-10-18 20:20:04", "2015-10-18 21:20:04", "176.73.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2322", "0", "magma", "2015-10-18 20:23:30", "2015-10-18 21:23:30", "178.233.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2323", "0", "magma", "2015-10-18 20:23:40", "2015-10-18 21:23:40", "46.149.82.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2324", "0", "magma", "2015-10-18 20:31:03", "2015-10-18 21:31:03", "5.246.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2325", "0", "magma", "2015-10-18 20:35:34", "2015-10-18 21:35:34", "177.80.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2326", "0", "magma", "2015-10-18 20:45:33", "2015-10-18 21:45:33", "103.26.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2327", "0", "magma", "2015-10-18 20:47:29", "2015-10-18 21:47:29", "182.185.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2328", "0", "magma", "2015-10-18 20:48:49", "2015-10-18 21:48:49", "131.161.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2329", "0", "magma", "2015-10-18 21:04:39", "2015-10-18 22:04:39", "79.157.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2330", "0", "magma", "2015-10-18 21:07:02", "2015-10-18 22:07:02", "95.95.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2331", "0", "magma", "2015-10-18 21:27:50", "2015-10-18 22:27:50", "41.102.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2332", "0", "magma", "2015-10-18 21:28:40", "2015-10-18 22:28:40", "83.117.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2333", "0", "magma", "2015-10-18 21:36:38", "2015-10-18 22:36:38", "178.128.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2334", "0", "magma", "2015-10-18 21:41:04", "2015-10-18 22:41:04", "78.60.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2335", "0", "magma", "2015-10-18 21:43:10", "2015-10-18 22:43:10", "86.98.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2336", "0", "magma", "2015-10-18 21:48:03", "2015-10-18 22:48:03", "10.1.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2337", "0", "magma", "2015-10-18 21:58:39", "2015-10-18 22:58:39", "94.132.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2338", "0", "magma", "2015-10-18 22:10:22", "2015-10-18 23:10:22", "5.64.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2339", "0", "magma", "2015-10-18 22:21:02", "2015-10-18 23:21:02", "45.74.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2340", "0", "magma", "2015-10-18 22:21:59", "2015-10-18 23:21:59", "134.226.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2341", "0", "magma", "2015-10-18 22:36:35", "2015-10-18 23:36:35", "190.160.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2342", "0", "magma", "2015-10-18 22:52:11", "2015-10-18 23:52:11", "79.169.220.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2343", "0", "magma", "2015-10-18 23:08:50", "2015-10-19 00:08:50", "93.43.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2344", "0", "magma", "2015-10-18 23:45:22", "2015-10-19 00:45:22", "200.73.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2345", "0", "magma", "2015-10-18 23:58:16", "2015-10-19 00:58:16", "78.147.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2346", "0", "magma", "2015-10-19 00:09:58", "2015-10-19 01:09:58", "77.89.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2347", "0", "magma", "2015-10-19 00:13:55", "2015-10-19 01:13:55", "193.59.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2348", "0", "magma", "2015-10-19 00:19:47", "2015-10-19 01:19:47", "88.167.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2349", "0", "magma", "2015-10-19 00:42:27", "2015-10-19 01:42:27", "78.92.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2350", "0", "magma", "2015-10-19 00:42:47", "2015-10-19 01:42:47", "177.179.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2351", "0", "magma", "2015-10-19 00:56:58", "2015-10-19 01:56:58", "119.93.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2352", "0", "magma", "2015-10-19 01:20:15", "2015-10-19 02:20:15", "24.90.57.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2353", "0", "magma", "2015-10-19 01:34:05", "2015-10-19 02:34:05", "68.172.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2354", "0", "magma", "2015-10-19 02:19:05", "2015-10-19 03:19:05", "2.50.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2355", "0", "magma", "2015-10-19 02:19:16", "2015-10-19 03:19:16", "177.143.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2356", "0", "magma", "2015-10-19 02:26:36", "2015-10-19 03:26:36", "82.213.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2357", "0", "admin", "2015-10-19 02:35:11", "2015-10-19 03:35:11", "178.219.245.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2358", "0", "magma", "2015-10-19 02:43:00", "2015-10-19 03:43:00", "119.73.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2359", "0", "magma", "2015-10-19 02:48:34", "2015-10-19 03:48:34", "93.139.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2360", "0", "admin", "2015-10-19 02:52:36", "2015-10-19 03:52:36", "93.115.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2361", "0", "magma", "2015-10-19 03:34:21", "2015-10-19 04:34:21", "83.153.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2362", "0", "magma", "2015-10-19 03:53:06", "2015-10-19 04:53:06", "220.255.247.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2363", "0", "magma", "2015-10-19 04:03:24", "2015-10-19 05:03:24", "180.255.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2364", "0", "magma", "2015-10-19 04:04:11", "2015-10-19 05:04:11", "31.185.225.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2365", "0", "magma", "2015-10-19 04:23:05", "2015-10-19 05:23:05", "82.10.214.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2366", "0", "magma", "2015-10-19 04:31:10", "2015-10-19 05:31:10", "92.85.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2367", "0", "magma", "2015-10-19 05:03:52", "2015-10-19 06:03:52", "124.83.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2368", "0", "admin", "2015-10-19 06:06:03", "2015-10-19 07:06:03", "104.167.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2369", "0", "magma", "2015-10-19 06:13:23", "2015-10-19 07:13:23", "85.127.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2370", "0", "magma", "2015-10-19 06:21:07", "2015-10-19 07:21:07", "186.45.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2371", "0", "magma", "2015-10-19 07:03:51", "2015-10-19 08:03:51", "133.21.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2372", "0", "magma", "2015-10-19 07:14:55", "2015-10-19 08:14:55", "76.183.161.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2373", "0", "magma", "2015-10-19 07:41:02", "2015-10-19 08:41:02", "182.185.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2374", "0", "magma", "2015-10-19 08:26:40", "2015-10-19 09:26:40", "49.205.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2375", "0", "magma", "2015-10-19 08:49:28", "2015-10-19 09:49:28", "86.5.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2376", "0", "magma", "2015-10-19 08:57:00", "2015-10-19 09:57:00", "104.32.133.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2377", "0", "magma", "2015-10-19 09:21:46", "2015-10-19 10:21:46", "49.151.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2378", "0", "magma", "2015-10-19 09:31:52", "2015-10-19 10:31:52", "49.146.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2379", "0", "magma", "2015-10-19 09:59:30", "2015-10-19 10:59:30", "5.140.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2380", "0", "magma", "2015-10-19 10:03:31", "2015-10-19 11:03:31", "79.46.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2381", "0", "magma", "2015-10-19 10:13:40", "2015-10-19 11:13:40", "49.145.213.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2382", "0", "magma", "2015-10-19 10:15:09", "2015-10-19 11:15:09", "198.8.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2383", "0", "magma", "2015-10-19 10:19:15", "2015-10-19 11:19:15", "123.63.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2384", "0", "magma", "2015-10-19 10:23:46", "2015-10-19 11:23:46", "12.26.161.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2385", "0", "magma", "2015-10-19 10:29:23", "2015-10-19 11:29:23", "122.61.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2386", "0", "magma", "2015-10-19 10:43:40", "2015-10-19 11:43:40", "79.126.135.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2387", "0", "magma", "2015-10-19 10:59:28", "2015-10-19 11:59:28", "173.168.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2388", "0", "magma", "2015-10-19 11:42:00", "2015-10-19 12:42:00", "165.50.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2389", "0", "magma", "2015-10-19 11:44:08", "2015-10-19 12:44:08", "65.183.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2390", "0", "magma", "2015-10-19 11:54:19", "2015-10-19 12:54:19", "194.103.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2391", "0", "admin", "2015-10-19 12:21:18", "2015-10-19 13:21:18", "176.9.25.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2392", "0", "admin", "2015-10-19 12:39:46", "2015-10-19 13:39:46", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2393", "0", "magma", "2015-10-19 13:01:58", "2015-10-19 14:01:58", "81.165.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2394", "0", "magma", "2015-10-19 13:25:04", "2015-10-19 14:25:04", "123.2.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2395", "0", "magma", "2015-10-19 13:42:29", "2015-10-19 14:42:29", "109.121.78.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2396", "0", "magma", "2015-10-19 13:45:17", "2015-10-19 14:45:17", "123.254.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2397", "0", "magma", "2015-10-19 14:10:44", "2015-10-19 15:10:44", "79.53.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2398", "0", "magma", "2015-10-19 14:16:43", "2015-10-19 15:16:43", "95.180.96.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2399", "0", "magma", "2015-10-19 14:50:36", "2015-10-19 15:50:36", "188.126.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2400", "0", "magma", "2015-10-19 14:55:20", "2015-10-19 15:55:20", "87.8.2.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2401", "0", "magma", "2015-10-19 15:17:07", "2015-10-19 16:17:07", "73.213.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2402", "0", "magma", "2015-10-19 15:20:42", "2015-10-19 16:20:42", "189.29.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2403", "0", "magma", "2015-10-19 15:24:45", "2015-10-19 16:24:45", "37.221.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2404", "0", "magma", "2015-10-19 15:25:46", "2015-10-19 16:25:46", "104.193.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2405", "0", "admin", "2015-10-19 15:39:15", "2015-10-19 16:39:15", "94.242.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2406", "0", "magma", "2015-10-19 15:54:41", "2015-10-19 16:54:41", "149.78.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2407", "0", "magma", "2015-10-19 16:14:15", "2015-10-19 17:14:15", "101.100.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2408", "0", "magma", "2015-10-19 16:47:01", "2015-10-19 17:47:01", "123.237.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2409", "0", "magma", "2015-10-19 17:02:32", "2015-10-19 18:02:32", "85.154.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2410", "0", "magma", "2015-10-19 17:12:42", "2015-10-19 18:12:42", "188.123.231.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2411", "0", "magma", "2015-10-19 17:15:43", "2015-10-19 18:15:43", "89.211.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2412", "0", "magma", "2015-10-19 17:31:55", "2015-10-19 18:31:55", "93.172.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2413", "0", "magma", "2015-10-19 17:34:23", "2015-10-19 18:34:23", "41.213.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2414", "0", "magma", "2015-10-19 17:40:25", "2015-10-19 18:40:25", "86.123.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2415", "0", "magma", "2015-10-19 17:44:00", "2015-10-19 18:44:00", "95.158.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2416", "0", "magma", "2015-10-19 18:40:00", "2015-10-19 19:40:00", "31.215.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2417", "0", "magma", "2015-10-19 18:57:18", "2015-10-19 19:57:18", "177.43.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2418", "0", "magma", "2015-10-19 19:10:30", "2015-10-19 20:10:30", "202.21.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2419", "0", "magma", "2015-10-19 19:17:24", "2015-10-19 20:17:24", "5.29.222.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2420", "0", "magma", "2015-10-19 19:32:10", "2015-10-19 20:32:10", "46.218.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2421", "0", "magma", "2015-10-19 19:37:15", "2015-10-19 20:37:15", "91.90.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2422", "0", "magma", "2015-10-19 19:42:03", "2015-10-19 20:42:03", "123.237.138.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2423", "0", "magma", "2015-10-19 19:52:28", "2015-10-19 20:52:28", "87.68.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2424", "0", "magma", "2015-10-19 20:06:44", "2015-10-19 21:06:44", "85.96.1.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2425", "0", "magma", "2015-10-19 20:24:07", "2015-10-19 21:24:07", "14.201.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2426", "0", "magma", "2015-10-19 20:25:44", "2015-10-19 21:25:44", "128.234.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2427", "0", "magma", "2015-10-19 20:30:42", "2015-10-19 21:30:42", "41.236.234.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2428", "0", "magma", "2015-10-19 20:31:59", "2015-10-19 21:31:59", "5.246.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2429", "0", "magma", "2015-10-19 20:38:13", "2015-10-19 21:38:13", "41.133.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2430", "0", "magma", "2015-10-19 20:45:55", "2015-10-19 21:45:55", "37.203.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2431", "0", "magma", "2015-10-19 21:21:02", "2015-10-19 22:21:02", "173.168.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2432", "0", "magma", "2015-10-19 21:26:54", "2015-10-19 22:26:54", "86.5.24.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2433", "0", "magma", "2015-10-19 21:31:44", "2015-10-19 22:31:44", "113.161.81.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2434", "0", "magma", "2015-10-19 21:40:35", "2015-10-19 22:40:35", "149.78.20.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2435", "0", "magma", "2015-10-19 21:52:58", "2015-10-19 22:52:58", "89.216.237.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2436", "0", "magma", "2015-10-19 22:04:54", "2015-10-19 23:04:54", "24.135.196.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2437", "0", "magma", "2015-10-19 22:22:39", "2015-10-19 23:22:39", "83.99.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2438", "0", "admin", "2015-10-19 22:22:50", "2015-10-19 23:22:50", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2439", "0", "magma", "2015-10-19 22:28:12", "2015-10-19 23:28:12", "128.179.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2440", "0", "magma", "2015-10-19 22:39:05", "2015-10-19 23:39:05", "77.77.241.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2441", "0", "magma", "2015-10-19 22:41:27", "2015-10-19 23:41:27", "79.176.51.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2442", "0", "magma", "2015-10-19 22:42:49", "2015-10-19 23:42:49", "5.66.239.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2443", "0", "admin", "2015-10-19 22:43:49", "2015-10-19 23:43:49", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2444", "0", "admin", "2015-10-19 22:47:32", "2015-10-19 23:47:32", "178.17.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2445", "0", "magma", "2015-10-19 22:59:13", "2015-10-19 23:59:13", "151.26.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2446", "0", "magma", "2015-10-19 23:10:55", "2015-10-20 00:10:55", "119.26.64.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2447", "0", "magma", "2015-10-19 23:20:51", "2015-10-20 00:20:51", "73.213.180.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2448", "0", "magma", "2015-10-19 23:23:53", "2015-10-20 00:23:53", "73.141.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2449", "0", "magma", "2015-10-19 23:24:57", "2015-10-20 00:24:57", "79.116.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2450", "0", "magma", "2015-10-19 23:43:08", "2015-10-20 00:43:08", "77.125.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2451", "0", "magma", "2015-10-19 23:49:45", "2015-10-20 00:49:45", "177.83.230.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2452", "0", "magma", "2015-10-20 00:29:14", "2015-10-20 01:29:14", "82.19.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2453", "0", "magma", "2015-10-20 00:32:30", "2015-10-20 01:32:30", "218.49.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2454", "0", "magma", "2015-10-20 01:06:13", "2015-10-20 02:06:13", "167.59.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2455", "0", "magma", "2015-10-20 01:10:58", "2015-10-20 02:10:58", "190.92.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2456", "0", "magma", "2015-10-20 01:33:37", "2015-10-20 02:33:37", "112.198.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2457", "0", "magma", "2015-10-20 01:39:07", "2015-10-20 02:39:07", "86.40.86.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2458", "0", "magma", "2015-10-20 01:47:20", "2015-10-20 02:47:20", "101.186.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2459", "0", "magma", "2015-10-20 02:10:58", "2015-10-20 03:10:58", "109.252.77.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2460", "0", "magma", "2015-10-20 02:23:11", "2015-10-20 03:23:11", "45.74.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2461", "0", "magma", "2015-10-20 02:56:40", "2015-10-20 03:56:40", "95.185.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2462", "0", "magma", "2015-10-20 03:09:46", "2015-10-20 04:09:46", "167.59.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2463", "0", "magma", "2015-10-20 03:34:10", "2015-10-20 04:34:10", "71.95.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2464", "0", "magma", "2015-10-20 03:52:46", "2015-10-20 04:52:46", "82.213.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2465", "0", "magma", "2015-10-20 03:58:05", "2015-10-20 04:58:05", "191.243.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2466", "0", "magma", "2015-10-20 04:41:44", "2015-10-20 05:41:44", "177.223.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2467", "0", "magma", "2015-10-20 04:41:55", "2015-10-20 05:41:55", "31.215.223.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2468", "0", "magma", "2015-10-20 05:20:38", "2015-10-20 06:20:38", "178.124.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2469", "0", "magma", "2015-10-20 05:55:40", "2015-10-20 06:55:40", "182.185.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2470", "0", "magma", "2015-10-20 06:10:18", "2015-10-20 07:10:18", "46.62.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2471", "0", "magma", "2015-10-20 06:49:11", "2015-10-20 07:49:11", "82.213.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2472", "0", "magma", "2015-10-20 07:28:19", "2015-10-20 08:28:19", "112.198.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2473", "0", "magma", "2015-10-20 07:55:59", "2015-10-20 08:55:59", "92.99.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2474", "0", "admin", "2015-10-20 07:57:32", "2015-10-20 08:57:32", "5.135.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2475", "0", "magma", "2015-10-20 08:07:40", "2015-10-20 09:07:40", "2.50.153.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2476", "0", "magma", "2015-10-20 08:52:04", "2015-10-20 09:52:04", "178.220.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2477", "0", "magma", "2015-10-20 09:03:17", "2015-10-20 10:03:17", "194.28.89.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2478", "0", "magma", "2015-10-20 09:14:54", "2015-10-20 10:14:54", "178.59.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2479", "0", "magma", "2015-10-20 09:45:30", "2015-10-20 10:45:30", "95.56.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2480", "0", "magma", "2015-10-20 09:48:51", "2015-10-20 10:48:51", "78.0.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2481", "0", "magma", "2015-10-20 09:50:38", "2015-10-20 10:50:38", "82.172.131.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2482", "0", "magma", "2015-10-20 10:05:49", "2015-10-20 11:05:49", "94.177.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2483", "0", "magma", "2015-10-20 10:14:44", "2015-10-20 11:14:44", "217.165.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2484", "0", "admin", "2015-10-20 10:47:58", "2015-10-20 11:47:58", "77.247.181.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2485", "0", "magma", "2015-10-20 11:00:16", "2015-10-20 12:00:16", "88.119.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2486", "0", "magma", "2015-10-20 11:33:32", "2015-10-20 12:33:32", "36.231.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2487", "0", "magma", "2015-10-20 11:42:27", "2015-10-20 12:42:27", "86.98.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2488", "0", "magma", "2015-10-20 12:27:29", "2015-10-20 13:27:29", "126.64.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2489", "0", "magma", "2015-10-20 12:29:03", "2015-10-20 13:29:03", "79.127.80.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2490", "0", "magma", "2015-10-20 12:35:34", "2015-10-20 13:35:34", "111.93.148.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2491", "0", "magma", "2015-10-20 12:44:59", "2015-10-20 13:44:59", "95.103.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2492", "0", "magma", "2015-10-20 12:51:33", "2015-10-20 13:51:33", "182.178.212.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2493", "0", "magma", "2015-10-20 12:59:01", "2015-10-20 13:59:01", "62.219.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2494", "0", "magma", "2015-10-20 13:11:48", "2015-10-20 14:11:48", "154.70.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2495", "0", "magma", "2015-10-20 13:15:00", "2015-10-20 14:15:00", "94.190.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2496", "0", "magma", "2015-10-20 14:00:18", "2015-10-20 15:00:18", "176.73.145.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2497", "0", "magma", "2015-10-20 14:11:40", "2015-10-20 15:11:40", "202.142.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2498", "0", "magma", "2015-10-20 14:28:14", "2015-10-20 15:28:14", "109.78.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2499", "0", "magma", "2015-10-20 14:38:43", "2015-10-20 15:38:43", "103.225.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2500", "0", "magma", "2015-10-20 14:40:30", "2015-10-20 15:40:30", "105.226.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2501", "0", "magma", "2015-10-20 15:09:22", "2015-10-20 16:09:22", "45.74.172.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2502", "0", "magma", "2015-10-20 15:37:20", "2015-10-20 16:37:20", "85.244.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2503", "0", "magma", "2015-10-20 15:39:47", "2015-10-20 16:39:47", "77.40.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2504", "0", "magma", "2015-10-20 15:56:36", "2015-10-20 16:56:36", "60.243.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2505", "0", "magma", "2015-10-20 16:44:54", "2015-10-20 17:44:54", "61.6.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2506", "0", "admin", "2015-10-20 16:50:16", "2015-10-20 17:50:16", "158.130.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2507", "0", "magma", "2015-10-20 17:37:20", "2015-10-20 18:37:20", "5.245.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2508", "0", "magma", "2015-10-20 18:09:57", "2015-10-20 19:09:57", "78.174.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2509", "0", "magma", "2015-10-20 18:13:07", "2015-10-20 19:13:07", "188.17.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2510", "0", "magma", "2015-10-20 18:44:48", "2015-10-20 19:44:48", "39.32.111.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2511", "0", "magma", "2015-10-20 19:06:49", "2015-10-20 20:06:49", "151.52.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2512", "0", "magma", "2015-10-20 19:18:11", "2015-10-20 20:18:11", "41.213.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2513", "0", "magma", "2015-10-20 19:30:15", "2015-10-20 20:30:15", "46.193.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2514", "0", "magma", "2015-10-20 19:36:20", "2015-10-20 20:36:20", "221.149.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2515", "0", "magma", "2015-10-20 19:45:29", "2015-10-20 20:45:29", "123.254.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2516", "0", "magma", "2015-10-20 19:53:15", "2015-10-20 20:53:15", "86.98.149.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2517", "0", "magma", "2015-10-20 19:55:46", "2015-10-20 20:55:46", "2.51.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2518", "0", "admin", "2015-10-20 20:38:22", "2015-10-20 21:38:22", "178.20.55.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2519", "0", "magma", "2015-10-20 20:38:33", "2015-10-20 21:38:33", "86.134.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2520", "0", "magma", "2015-10-20 20:51:53", "2015-10-20 21:51:53", "64.185.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2521", "0", "magma", "2015-10-20 21:37:18", "2015-10-20 22:37:18", "190.150.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2522", "0", "magma", "2015-10-20 21:44:14", "2015-10-20 22:44:14", "81.61.27.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2523", "0", "magma", "2015-10-20 21:45:23", "2015-10-20 22:45:23", "79.177.175.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2524", "0", "magma", "2015-10-20 22:02:04", "2015-10-20 23:02:04", "103.232.235.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2525", "0", "magma", "2015-10-20 22:09:45", "2015-10-20 23:09:45", "195.26.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2526", "0", "magma", "2015-10-20 22:31:18", "2015-10-20 23:31:18", "86.98.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2527", "0", "magma", "2015-10-20 22:38:54", "2015-10-20 23:38:54", "71.95.3.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2528", "0", "magma", "2015-10-20 23:04:04", "2015-10-21 00:04:04", "81.237.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2529", "0", "magma", "2015-10-20 23:42:35", "2015-10-21 00:42:35", "41.143.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2530", "0", "magma", "2015-10-21 00:02:59", "2015-10-21 01:02:59", "121.6.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2531", "0", "magma", "2015-10-21 00:05:03", "2015-10-21 01:05:03", "188.26.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2532", "0", "magma", "2015-10-21 00:23:51", "2015-10-21 01:23:51", "191.7.28.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2533", "0", "magma", "2015-10-21 00:48:11", "2015-10-21 01:48:11", "93.163.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2534", "0", "magma", "2015-10-21 00:51:03", "2015-10-21 01:51:03", "86.10.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2535", "0", "magma", "2015-10-21 01:13:16", "2015-10-21 02:13:16", "177.223.13.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2536", "0", "magma", "2015-10-21 01:19:18", "2015-10-21 02:19:18", "92.53.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2537", "0", "magma", "2015-10-21 01:25:37", "2015-10-21 02:25:37", "27.38.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2538", "0", "magma", "2015-10-21 01:32:40", "2015-10-21 02:32:40", "91.206.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2539", "0", "magma", "2015-10-21 01:54:44", "2015-10-21 02:54:44", "191.7.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2540", "0", "magma", "2015-10-21 02:05:34", "2015-10-21 03:05:34", "93.173.185.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2541", "0", "magma", "2015-10-21 02:19:49", "2015-10-21 03:19:49", "197.38.188.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2542", "0", "magma", "2015-10-21 02:22:32", "2015-10-21 03:22:32", "94.197.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2543", "0", "admin", "2015-10-21 02:55:10", "2015-10-21 03:55:10", "94.242.246.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2544", "0", "magma", "2015-10-21 02:58:33", "2015-10-21 03:58:33", "149.78.238.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2545", "0", "magma", "2015-10-21 03:15:50", "2015-10-21 04:15:50", "85.130.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2546", "0", "magma", "2015-10-21 03:16:06", "2015-10-21 04:16:06", "92.53.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2547", "0", "admin", "2015-10-21 03:38:23", "2015-10-21 04:38:23", "51.254.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2548", "0", "magma", "2015-10-21 04:08:13", "2015-10-21 05:08:13", "181.55.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2549", "0", "magma", "2015-10-21 04:13:45", "2015-10-21 05:13:45", "115.134.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2550", "0", "magma", "2015-10-21 04:29:01", "2015-10-21 05:29:01", "41.59.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2551", "0", "magma", "2015-10-21 04:32:16", "2015-10-21 05:32:16", "174.52.250.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2552", "0", "magma", "2015-10-21 05:06:34", "2015-10-21 06:06:34", "189.51.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2553", "0", "magma", "2015-10-21 05:36:25", "2015-10-21 06:36:25", "103.232.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2554", "0", "magma", "2015-10-21 05:56:42", "2015-10-21 06:56:42", "117.202.112.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2555", "0", "magma", "2015-10-21 06:04:28", "2015-10-21 07:04:28", "80.174.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2556", "0", "admin", "2015-10-21 06:19:38", "2015-10-21 07:19:38", "5.196.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2557", "0", "magma", "2015-10-21 06:21:56", "2015-10-21 07:21:56", "94.60.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2558", "0", "magma", "2015-10-21 06:24:10", "2015-10-21 07:24:10", "46.162.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2559", "0", "magma", "2015-10-21 06:33:58", "2015-10-21 07:33:58", "41.207.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2560", "0", "magma", "2015-10-21 06:34:19", "2015-10-21 07:34:19", "87.237.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2561", "0", "magma", "2015-10-21 06:50:57", "2015-10-21 07:50:57", "186.11.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2562", "0", "magma", "2015-10-21 07:18:18", "2015-10-21 08:18:18", "14.97.19.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2563", "0", "magma", "2015-10-21 08:14:48", "2015-10-21 09:14:48", "175.140.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2564", "0", "magma", "2015-10-21 08:21:45", "2015-10-21 09:21:45", "212.107.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2565", "0", "magma", "2015-10-21 09:07:18", "2015-10-21 10:07:18", "112.211.179.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2566", "0", "magma", "2015-10-21 09:21:27", "2015-10-21 10:21:27", "93.184.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2567", "0", "magma", "2015-10-21 09:23:22", "2015-10-21 10:23:22", "39.42.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2568", "0", "magma", "2015-10-21 09:48:08", "2015-10-21 10:48:08", "85.254.75.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2569", "0", "magma", "2015-10-21 09:59:30", "2015-10-21 10:59:30", "78.63.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2570", "0", "magma", "2015-10-21 10:04:02", "2015-10-21 11:04:02", "85.102.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2571", "0", "magma", "2015-10-21 10:28:00", "2015-10-21 11:28:00", "154.66.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2572", "0", "magma", "2015-10-21 11:11:53", "2015-10-21 12:11:53", "125.19.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2573", "0", "magma", "2015-10-21 11:20:56", "2015-10-21 12:20:56", "95.94.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2574", "0", "magma", "2015-10-21 11:28:31", "2015-10-21 12:28:31", "78.11.170.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2575", "0", "magma", "2015-10-21 11:54:07", "2015-10-21 12:54:07", "93.103.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2576", "0", "magma", "2015-10-21 11:58:21", "2015-10-21 12:58:21", "198.200.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2577", "0", "admin", "2015-10-21 12:19:07", "2015-10-21 13:19:07", "79.120.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2578", "0", "admin", "2015-10-21 12:20:59", "2015-10-21 13:20:59", "176.10.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2579", "0", "magma", "2015-10-21 12:29:58", "2015-10-21 13:29:58", "203.147.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2580", "0", "magma", "2015-10-21 12:30:37", "2015-10-21 13:30:37", "82.61.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2581", "0", "magma", "2015-10-21 12:42:09", "2015-10-21 13:42:09", "95.235.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2582", "0", "magma", "2015-10-21 13:24:45", "2015-10-21 14:24:45", "196.217.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2583", "0", "magma", "2015-10-21 13:39:47", "2015-10-21 14:39:47", "86.1.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2584", "0", "magma", "2015-10-21 13:58:47", "2015-10-21 14:58:47", "89.169.198.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2585", "0", "magma", "2015-10-21 14:01:24", "2015-10-21 15:01:24", "176.93.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2586", "0", "magma", "2015-10-21 14:07:14", "2015-10-21 15:07:14", "111.91.229.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2587", "0", "magma", "2015-10-21 14:16:47", "2015-10-21 15:16:47", "178.221.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2588", "0", "magma", "2015-10-21 14:23:26", "2015-10-21 15:23:26", "90.157.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2589", "0", "magma", "2015-10-21 14:40:31", "2015-10-21 15:40:31", "184.3.250.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2590", "0", "magma", "2015-10-21 15:09:07", "2015-10-21 16:09:07", "162.234.208.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2591", "0", "magma", "2015-10-21 15:17:19", "2015-10-21 16:17:19", "178.143.191.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2592", "0", "magma", "2015-10-21 15:19:09", "2015-10-21 16:19:09", "58.97.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2593", "0", "magma", "2015-10-21 15:38:24", "2015-10-21 16:38:24", "178.223.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2594", "0", "magma", "2015-10-21 15:44:26", "2015-10-21 16:44:26", "213.22.171.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2595", "0", "magma", "2015-10-21 16:02:00", "2015-10-21 17:02:00", "61.255.219.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2596", "0", "magma", "2015-10-21 16:27:49", "2015-10-21 17:27:49", "82.144.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2597", "0", "magma", "2015-10-21 16:38:01", "2015-10-21 17:38:01", "82.213.48.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2598", "0", "magma", "2015-10-21 16:45:54", "2015-10-21 17:45:54", "176.92.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2599", "0", "magma", "2015-10-21 16:56:52", "2015-10-21 17:56:52", "78.96.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2600", "0", "magma", "2015-10-21 17:18:37", "2015-10-21 18:18:37", "14.37.132.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2601", "0", "magma", "2015-10-21 17:39:06", "2015-10-21 18:39:06", "95.93.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2602", "0", "magma", "2015-10-21 18:20:40", "2015-10-21 19:20:40", "86.129.114.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2603", "0", "magma", "2015-10-21 18:25:41", "2015-10-21 19:25:41", "178.221.87.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2604", "0", "magma", "2015-10-21 18:30:09", "2015-10-21 19:30:09", "85.50.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2605", "0", "magma", "2015-10-21 19:01:02", "2015-10-21 20:01:02", "87.248.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2606", "0", "magma", "2015-10-21 19:29:15", "2015-10-21 20:29:15", "77.127.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2607", "0", "magma", "2015-10-21 19:44:05", "2015-10-21 20:44:05", "202.166.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2608", "0", "magma", "2015-10-21 19:45:08", "2015-10-21 20:45:08", "109.121.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2609", "0", "magma", "2015-10-21 22:13:36", "2015-10-21 23:13:36", "77.98.85.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2610", "0", "magma", "2015-10-21 22:27:37", "2015-10-21 23:27:37", "24.235.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2611", "0", "admin", "2015-10-21 22:40:18", "2015-10-21 23:40:18", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2612", "0", "admin", "2015-10-21 22:40:59", "2015-10-21 23:40:59", "89.187.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2613", "0", "magma", "2015-10-21 22:42:21", "2015-10-21 23:42:21", "41.72.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2614", "0", "magma", "2015-10-21 22:57:38", "2015-10-21 23:57:38", "104.137.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2615", "0", "magma", "2015-10-21 23:00:19", "2015-10-22 00:00:19", "86.217.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2616", "0", "magma", "2015-10-21 23:00:44", "2015-10-22 00:00:44", "79.181.201.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2617", "0", "magma", "2015-10-21 23:01:25", "2015-10-22 00:01:25", "41.103.204.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2618", "0", "magma", "2015-10-21 23:45:14", "2015-10-22 00:45:14", "186.194.122.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2619", "0", "admin", "2015-10-21 23:48:18", "2015-10-22 00:48:18", "213.142.46.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2620", "0", "magma", "2015-10-22 00:16:18", "2015-10-22 01:16:18", "73.233.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2621", "0", "magma", "2015-10-22 00:30:12", "2015-10-22 01:30:12", "182.55.159.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2622", "0", "magma", "2015-10-22 01:17:15", "2015-10-22 02:17:15", "5.66.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2623", "0", "magma", "2015-10-22 01:17:46", "2015-10-22 02:17:46", "5.54.50.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2624", "0", "magma", "2015-10-22 01:22:10", "2015-10-22 02:22:10", "141.237.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2625", "0", "magma", "2015-10-22 01:33:21", "2015-10-22 02:33:21", "77.127.209.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2626", "0", "magma", "2015-10-22 01:40:27", "2015-10-22 02:40:27", "79.18.41.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2627", "0", "magma", "2015-10-22 01:43:44", "2015-10-22 02:43:44", "199.192.224.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2628", "0", "magma", "2015-10-22 01:58:29", "2015-10-22 02:58:29", "92.12.146.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2629", "0", "magma", "2015-10-22 02:12:13", "2015-10-22 03:12:13", "23.116.121.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2630", "0", "magma", "2015-10-22 02:14:22", "2015-10-22 03:14:22", "31.16.74.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2631", "0", "magma", "2015-10-22 02:19:39", "2015-10-22 03:19:39", "94.231.167.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2632", "0", "magma", "2015-10-22 03:04:11", "2015-10-22 04:04:11", "5.66.23.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2633", "0", "magma", "2015-10-22 03:07:40", "2015-10-22 04:07:40", "81.237.186.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2634", "0", "magma", "2015-10-22 03:16:41", "2015-10-22 04:16:41", "98.94.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2635", "0", "magma", "2015-10-22 03:22:42", "2015-10-22 04:22:42", "2.49.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2636", "0", "magma", "2015-10-22 03:25:16", "2015-10-22 04:25:16", "116.74.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2637", "0", "magma", "2015-10-22 05:26:15", "2015-10-22 06:26:15", "103.248.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2638", "0", "magma", "2015-10-22 05:26:22", "2015-10-22 06:26:22", "104.35.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2639", "0", "magma", "2015-10-22 05:47:48", "2015-10-22 06:47:48", "94.60.63.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2640", "0", "magma", "2015-10-22 07:08:54", "2015-10-22 08:08:54", "1.22.120.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2641", "0", "admin", "2015-10-22 07:28:38", "2015-10-22 08:28:38", "199.127.226.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2642", "0", "admin", "2015-10-22 07:38:53", "2015-10-22 08:38:53", "37.187.129.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2643", "0", "magma", "2015-10-22 08:00:56", "2015-10-22 09:00:56", "37.107.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2644", "0", "magma", "2015-10-22 09:15:15", "2015-10-22 10:15:15", "88.231.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2645", "0", "magma", "2015-10-22 09:33:44", "2015-10-22 10:33:44", "75.133.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2646", "0", "magma", "2015-10-22 09:52:28", "2015-10-22 10:52:28", "193.232.52.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2647", "0", "magma", "2015-10-22 10:16:01", "2015-10-22 11:16:01", "169.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2648", "0", "magma", "2015-10-22 10:17:57", "2015-10-22 11:17:57", "5.64.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2649", "0", "magma", "2015-10-22 11:06:23", "2015-10-22 12:06:23", "139.194.100.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2650", "0", "magma", "2015-10-22 11:11:50", "2015-10-22 12:11:50", "84.241.12.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2651", "0", "magma", "2015-10-22 11:33:01", "2015-10-22 12:33:01", "49.145.240.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2652", "0", "magma", "2015-10-22 11:59:34", "2015-10-22 12:59:34", "46.208.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2653", "0", "magma", "2015-10-22 12:29:42", "2015-10-22 13:29:42", "92.46.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2654", "0", "magma", "2015-10-22 12:50:19", "2015-10-22 13:50:19", "61.247.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2655", "0", "magma", "2015-10-22 12:57:35", "2015-10-22 13:57:35", "41.223.117.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2656", "0", "magma", "2015-10-22 13:23:28", "2015-10-22 14:23:28", "111.68.104.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2657", "0", "magma", "2015-10-22 14:22:27", "2015-10-22 15:22:27", "178.175.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2658", "0", "magma", "2015-10-22 14:23:37", "2015-10-22 15:23:37", "86.1.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2659", "0", "magma", "2015-10-22 14:32:47", "2015-10-22 15:32:47", "176.60.73.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2660", "0", "magma", "2015-10-22 15:16:39", "2015-10-22 16:16:39", "178.17.18.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2661", "0", "magma", "2015-10-22 15:18:02", "2015-10-22 16:18:02", "177.208.14.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2662", "0", "magma", "2015-10-22 15:27:49", "2015-10-22 16:27:49", "210.195.207.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2663", "0", "magma", "2015-10-22 15:45:48", "2015-10-22 16:45:48", "112.211.190.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2664", "0", "magma", "2015-10-22 15:52:02", "2015-10-22 16:52:02", "42.60.154.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2665", "0", "magma", "2015-10-22 15:58:09", "2015-10-22 16:58:09", "149.78.255.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2666", "0", "magma", "2015-10-22 16:04:05", "2015-10-22 17:04:05", "177.202.5.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2667", "0", "magma", "2015-10-22 16:04:17", "2015-10-22 17:04:17", "128.0.60.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2668", "0", "magma", "2015-10-22 16:08:23", "2015-10-22 17:08:23", "94.98.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2669", "0", "magma", "2015-10-22 16:13:51", "2015-10-22 17:13:51", "117.206.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2670", "0", "magma", "2015-10-22 16:27:52", "2015-10-22 17:27:52", "81.108.35.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2671", "0", "magma", "2015-10-22 16:27:56", "2015-10-22 17:27:56", "82.168.99.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2672", "0", "admin", "2015-10-22 16:31:23", "2015-10-22 17:31:23", "85.25.103.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2673", "0", "magma", "2015-10-22 16:43:42", "2015-10-22 17:43:42", "83.110.4.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2674", "0", "magma", "2015-10-22 16:48:56", "2015-10-22 17:48:56", "178.221.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2675", "0", "magma", "2015-10-22 16:54:33", "2015-10-22 17:54:33", "46.55.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2676", "0", "admin", "2015-10-22 16:55:56", "2015-10-22 17:55:56", "79.136.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2677", "0", "magma", "2015-10-22 16:58:56", "2015-10-22 17:58:56", "197.220.160.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2678", "0", "magma", "2015-10-22 17:25:23", "2015-10-22 18:25:23", "5.81.67.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2679", "0", "magma", "2015-10-22 17:44:32", "2015-10-22 18:44:32", "31.154.92.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2680", "0", "magma", "2015-10-22 17:48:56", "2015-10-22 18:48:56", "109.121.36.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2681", "0", "magma", "2015-10-22 17:52:25", "2015-10-22 18:52:25", "188.169.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2682", "0", "magma", "2015-10-22 18:14:38", "2015-10-22 19:14:38", "87.248.0.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2683", "0", "magma", "2015-10-22 18:20:19", "2015-10-22 19:20:19", "180.190.90.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2684", "0", "magma", "2015-10-22 18:27:54", "2015-10-22 19:27:54", "73.233.115.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2685", "0", "admin", "2015-10-22 18:29:14", "2015-10-22 19:29:14", "173.254.216.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2686", "0", "magma", "2015-10-22 18:34:17", "2015-10-22 19:34:17", "83.60.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2687", "0", "magma", "2015-10-22 19:04:22", "2015-10-22 20:04:22", "91.185.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2688", "0", "magma", "2015-10-22 19:18:11", "2015-10-22 20:18:11", "200.1.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2689", "0", "magma", "2015-10-22 19:31:31", "2015-10-22 20:31:31", "41.216.228.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2690", "0", "Admin", "2015-10-22 19:49:28", "2015-10-22 20:49:28", "195.154.243.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2691", "0", "magma", "2015-10-22 19:59:11", "2015-10-22 20:59:11", "154.123.6.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2692", "0", "magma", "2015-10-22 20:09:49", "2015-10-22 21:09:49", "173.168.173.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2693", "0", "magma", "2015-10-22 20:18:50", "2015-10-22 21:18:50", "86.104.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2694", "0", "magma", "2015-10-22 20:28:02", "2015-10-22 21:28:02", "119.94.32.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2695", "0", "magma", "2015-10-22 20:36:13", "2015-10-22 21:36:13", "89.137.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2696", "0", "magma", "2015-10-22 20:43:20", "2015-10-22 21:43:20", "177.16.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2697", "0", "magma", "2015-10-22 20:46:04", "2015-10-22 21:46:04", "5.55.251.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2698", "0", "magma", "2015-10-22 21:06:44", "2015-10-22 22:06:44", "78.145.91.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2699", "0", "magma", "2015-10-22 21:36:03", "2015-10-22 22:36:03", "92.0.136.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2700", "0", "magma", "2015-10-22 21:56:18", "2015-10-22 22:56:18", "93.43.254.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2701", "0", "magma", "2015-10-22 22:07:11", "2015-10-22 23:07:11", "202.69.38.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2702", "0", "magma", "2015-10-22 22:13:31", "2015-10-22 23:13:31", "119.235.49.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2703", "0", "magma", "2015-10-22 22:39:34", "2015-10-22 23:39:34", "89.69.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2704", "0", "magma", "2015-10-22 23:14:05", "2015-10-23 00:14:05", "189.51.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2705", "0", "magma", "2015-10-22 23:17:58", "2015-10-23 00:17:58", "177.125.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2706", "0", "magma", "2015-10-23 00:24:56", "2015-10-23 01:24:56", "41.68.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2707", "0", "magma", "2015-10-23 00:38:29", "2015-10-23 01:38:29", "79.177.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2708", "0", "admin", "2015-10-23 01:45:27", "2015-10-23 02:45:27", "62.141.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2709", "0", "magma", "2015-10-23 01:48:24", "2015-10-23 02:48:24", "93.163.142.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2710", "0", "magma", "2015-10-23 02:02:21", "2015-10-23 03:02:21", "93.108.45.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2711", "0", "admin", "2015-10-23 02:16:18", "2015-10-23 03:16:18", "35.0.127.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2712", "0", "magma", "2015-10-23 02:30:54", "2015-10-23 03:30:54", "209.131.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2713", "0", "magma", "2015-10-23 03:38:10", "2015-10-23 04:38:10", "110.77.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2714", "0", "admin", "2015-10-23 03:52:37", "2015-10-23 04:52:37", "162.247.72.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2715", "0", "magma", "2015-10-23 05:35:55", "2015-10-23 06:35:55", "58.104.54.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2716", "0", "magma", "2015-10-23 06:11:23", "2015-10-23 07:11:23", "89.137.137.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2717", "0", "magma", "2015-10-23 07:03:16", "2015-10-23 08:03:16", "24.96.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2718", "0", "magma", "2015-10-23 07:06:34", "2015-10-23 08:06:34", "36.37.192.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2719", "0", "magma", "2015-10-23 07:12:37", "2015-10-23 08:12:37", "93.177.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2720", "0", "magma", "2015-10-23 07:54:44", "2015-10-23 08:54:44", "103.248.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2721", "0", "magma", "2015-10-23 07:55:42", "2015-10-23 08:55:42", "222.124.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2722", "0", "magma", "2015-10-23 09:29:12", "2015-10-23 10:29:12", "86.104.194.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2723", "0", "magma", "2015-10-23 09:47:01", "2015-10-23 10:47:01", "222.238.118.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2724", "0", "magma", "2015-10-23 11:32:42", "2015-10-23 12:32:42", "79.177.150.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2725", "0", "magma", "2015-10-23 12:16:41", "2015-10-23 13:16:41", "179.211.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2726", "0", "magma", "2015-10-23 12:18:52", "2015-10-23 13:18:52", "2.126.163.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2727", "0", "magma", "2015-10-23 13:18:51", "2015-10-23 14:18:51", "178.197.232.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2728", "0", "magma", "2015-10-23 14:08:37", "2015-10-23 15:08:37", "27.77.184.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2729", "0", "magma", "2015-10-23 14:09:26", "2015-10-23 15:09:26", "110.93.217.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2730", "0", "magma", "2015-10-23 14:34:37", "2015-10-23 15:34:37", "188.77.119.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2731", "0", "magma", "2015-10-23 15:13:33", "2015-10-23 16:13:33", "62.42.178.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2732", "0", "magma", "2015-10-23 15:43:05", "2015-10-23 16:43:05", "197.156.68.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2733", "0", "magma", "2015-10-23 16:44:02", "2015-10-23 17:44:02", "79.108.10.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2734", "0", "magma", "2015-10-23 17:20:22", "2015-10-23 18:20:22", "117.200.101.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2735", "0", "magma", "2015-10-23 17:55:47", "2015-10-23 18:55:47", "39.32.95.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2736", "0", "magma", "2015-10-23 18:01:19", "2015-10-23 19:01:19", "95.42.249.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2737", "0", "admin", "2015-10-23 18:31:17", "2015-10-23 19:31:17", "149.202.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2738", "0", "magma", "2015-10-23 18:50:56", "2015-10-23 19:50:56", "115.124.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2739", "0", "magma", "2015-10-23 19:03:30", "2015-10-23 20:03:30", "188.126.143.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2740", "0", "magma", "2015-10-23 19:17:33", "2015-10-23 20:17:33", "154.67.108.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2741", "0", "magma", "2015-10-23 20:04:42", "2015-10-23 21:04:42", "180.191.134.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2742", "0", "magma", "2015-10-23 21:31:49", "2015-10-23 22:31:49", "183.90.98.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2743", "0", "magma", "2015-10-23 21:38:59", "2015-10-23 22:38:59", "68.123.205.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2744", "0", "magma", "2015-10-23 21:59:31", "2015-10-23 22:59:31", "185.34.16.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2745", "0", "magma", "2015-10-23 22:08:54", "2015-10-23 23:08:54", "87.252.244.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2746", "0", "magma", "2015-10-23 22:13:42", "2015-10-23 23:13:42", "181.55.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2747", "0", "magma", "2015-10-23 22:26:42", "2015-10-23 23:26:42", "182.187.15.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2748", "0", "magma", "2015-10-24 02:23:46", "2015-10-24 03:23:46", "93.184.93.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2749", "0", "magma", "2015-10-24 02:53:16", "2015-10-24 03:53:16", "197.88.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2750", "0", "magma", "2015-10-24 03:23:05", "2015-10-24 04:23:05", "198.72.197.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2751", "0", "magma", "2015-10-24 04:52:18", "2015-10-24 05:52:18", "118.59.233.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2752", "0", "magma", "2015-10-24 05:01:41", "2015-10-24 06:01:41", "24.179.106.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2753", "0", "magma", "2015-10-24 05:16:13", "2015-10-24 06:16:13", "197.88.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2754", "0", "magma", "2015-10-24 07:01:32", "2015-10-24 08:01:32", "190.163.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2755", "0", "magma", "2015-10-24 07:54:28", "2015-10-24 08:54:28", "188.2.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2756", "0", "magma", "2015-10-24 07:59:04", "2015-10-24 08:59:04", "109.92.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2757", "0", "magma", "2015-10-24 08:44:15", "2015-10-24 09:44:15", "210.195.17.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2758", "0", "magma", "2015-10-24 09:49:58", "2015-10-24 10:49:58", "210.103.124.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2759", "0", "admin", "2015-10-24 09:59:45", "2015-10-24 10:59:45", "93.179.69.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2760", "0", "magma", "2015-10-24 10:31:18", "2015-10-24 11:31:18", "115.136.183.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2761", "0", "admin", "2015-10-24 10:31:28", "2015-10-24 11:31:28", "89.234.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2762", "0", "magma", "2015-10-24 11:33:55", "2015-10-24 12:33:55", "121.170.94.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2763", "0", "magma", "2015-10-24 14:05:10", "2015-10-24 15:05:10", "79.101.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2764", "0", "magma", "2015-10-24 14:21:20", "2015-10-24 15:21:20", "41.69.221.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2765", "0", "magma", "2015-10-24 14:43:44", "2015-10-24 15:43:44", "176.26.140.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2766", "0", "magma", "2015-10-24 15:31:46", "2015-10-24 16:31:46", "197.88.76.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2767", "0", "magma", "2015-10-24 15:55:11", "2015-10-24 16:55:11", "5.237.245.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2768", "0", "magma", "2015-10-24 15:59:02", "2015-10-24 16:59:02", "81.206.71.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2769", "0", "magma", "2015-10-24 16:47:56", "2015-10-24 17:47:56", "85.96.31.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2770", "0", "magma", "2015-10-24 17:25:45", "2015-10-24 18:25:45", "79.127.210.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2771", "0", "magma", "2015-10-24 17:29:45", "2015-10-24 18:29:45", "49.147.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2772", "0", "admin", "2015-10-24 19:08:59", "2015-10-24 20:08:59", "79.98.107.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2773", "0", "magma", "2015-10-24 19:19:33", "2015-10-24 20:19:33", "41.213.166.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2774", "0", "magma", "2015-10-24 19:20:15", "2015-10-24 20:20:15", "86.35.253.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2775", "0", "magma", "2015-10-24 19:20:42", "2015-10-24 20:20:42", "213.46.202.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2776", "0", "magma", "2015-10-24 19:26:47", "2015-10-24 20:26:47", "111.216.79.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2777", "0", "magma", "2015-10-24 19:32:06", "2015-10-24 20:32:06", "41.101.182.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2778", "0", "magma", "2015-10-24 19:34:15", "2015-10-24 20:34:15", "86.59.248.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2779", "0", "magma", "2015-10-24 21:41:00", "2015-10-24 22:41:00", "190.150.42.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2780", "0", "magma", "2015-10-25 00:16:39", "2015-10-25 01:16:39", "86.7.200.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2781", "0", "magma", "2015-10-25 06:30:24", "2015-10-25 07:30:24", "189.202.56.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2782", "0", "magma", "2015-10-25 06:30:33", "2015-10-25 07:30:33", "78.95.195.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2783", "0", "magma", "2015-10-25 07:16:46", "2015-10-25 08:16:46", "125.19.211.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2784", "0", "magma", "2015-10-25 08:51:49", "2015-10-25 09:51:49", "219.240.165.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2785", "0", "magma", "2015-10-25 10:37:01", "2015-10-25 11:37:01", "89.69.174.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2786", "0", "magma", "2015-10-25 10:50:30", "2015-10-25 11:50:30", "188.2.203.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2787", "0", "magma", "2015-10-25 11:10:25", "2015-10-25 12:10:25", "121.54.58.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2788", "0", "admin", "2015-10-25 11:22:33", "2015-10-25 12:22:33", "37.130.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2789", "0", "magma", "2015-10-25 11:43:23", "2015-10-25 12:43:23", "95.5.113.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2790", "0", "magma", "2015-10-25 13:32:25", "2015-10-25 14:32:25", "85.207.128.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2791", "0", "magma", "2015-10-25 14:21:30", "2015-10-25 15:21:30", "2.248.157.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2792", "0", "magma", "2015-10-25 14:58:12", "2015-10-25 15:58:12", "92.80.139.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2793", "0", "magma", "2015-10-25 15:54:45", "2015-10-25 16:54:45", "124.83.22.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2794", "0", "magma", "2015-10-25 16:15:48", "2015-10-25 17:15:48", "94.253.227.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2795", "0", "magma", "2015-10-25 16:37:54", "2015-10-25 17:37:54", "93.155.151.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2796", "0", "magma", "2015-10-25 19:16:17", "2015-10-25 20:16:17", "178.221.43.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2797", "0", "magma", "2015-10-25 19:16:45", "2015-10-25 20:16:45", "37.208.125.*", "login_fail", "");
INSERT INTO `eadsk_aiowps_login_lockdown` VALUES("2798", "0", "admin", "2015-10-25 19:39:57", "2015-10-25 20:39:57", "107.181.174.*", "login_fail", "